; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-- | FileCheck %s
; RUN: llc < %s -mtriple=aarch64-- -global-isel -global-isel-abort=1 | FileCheck %s --check-prefix=CHECK-GISEL

define i8 @shl_and(i8 %x, i8 %y) nounwind {
; CHECK-LABEL: shl_and:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #5
; CHECK-NEXT:    and w0, w8, w1, lsl #2
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: shl_and:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    lsl w8, w1, #2
; CHECK-GISEL-NEXT:    and w0, w8, w0, lsl #5
; CHECK-GISEL-NEXT:    ret
  %sh0 = shl i8 %x, 3
  %r = and i8 %sh0, %y
  %sh1 = shl i8 %r, 2
  ret i8 %sh1
}

define i16 @shl_or(i16 %x, i16 %y) nounwind {
; CHECK-LABEL: shl_or:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #12
; CHECK-NEXT:    orr w0, w8, w1, lsl #7
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: shl_or:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    lsl w8, w1, #7
; CHECK-GISEL-NEXT:    orr w0, w8, w0, lsl #12
; CHECK-GISEL-NEXT:    ret
  %sh0 = shl i16 %x, 5
  %r = or i16 %y, %sh0
  %sh1 = shl i16 %r, 7
  ret i16 %sh1
}

define i32 @shl_xor(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: shl_xor:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl w8, w0, #12
; CHECK-NEXT:    eor w0, w8, w1, lsl #7
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: shl_xor:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    lsl w8, w1, #7
; CHECK-GISEL-NEXT:    eor w0, w8, w0, lsl #12
; CHECK-GISEL-NEXT:    ret
  %sh0 = shl i32 %x, 5
  %r = xor i32 %sh0, %y
  %sh1 = shl i32 %r, 7
  ret i32 %sh1
}

define i64 @lshr_and(i64 %x, i64 %y) nounwind {
; CHECK-LABEL: lshr_and:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsr x8, x0, #12
; CHECK-NEXT:    and x0, x8, x1, lsr #7
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: lshr_and:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    lsr x8, x1, #7
; CHECK-GISEL-NEXT:    and x0, x8, x0, lsr #12
; CHECK-GISEL-NEXT:    ret
  %sh0 = lshr i64 %x, 5
  %r = and i64 %y, %sh0
  %sh1 = lshr i64 %r, 7
  ret i64 %sh1
}

define <4 x i32> @lshr_or(<4 x i32> %x, <4 x i32> %y) nounwind {
; CHECK-LABEL: lshr_or:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v1.4s, v1.4s, #7
; CHECK-NEXT:    ushr v0.4s, v0.4s, #12
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: lshr_or:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    ushr v0.4s, v0.4s, #5
; CHECK-GISEL-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GISEL-NEXT:    ushr v0.4s, v0.4s, #7
; CHECK-GISEL-NEXT:    ret
  %sh0 = lshr <4 x i32> %x, <i32 5, i32 5, i32 5, i32 5>
  %r = or <4 x i32> %sh0, %y
  %sh1 = lshr <4 x i32> %r, <i32 7, i32 7, i32 7, i32 7>
  ret <4 x i32> %sh1
}

define <8 x i16> @lshr_xor(<8 x i16> %x, <8 x i16> %y) nounwind {
; CHECK-LABEL: lshr_xor:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v1.8h, v1.8h, #7
; CHECK-NEXT:    ushr v0.8h, v0.8h, #12
; CHECK-NEXT:    eor v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: lshr_xor:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    ushr v0.8h, v0.8h, #5
; CHECK-GISEL-NEXT:    eor v0.16b, v1.16b, v0.16b
; CHECK-GISEL-NEXT:    ushr v0.8h, v0.8h, #7
; CHECK-GISEL-NEXT:    ret
  %sh0 = lshr <8 x i16> %x, <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  %r = xor <8 x i16> %y, %sh0
  %sh1 = lshr <8 x i16> %r, <i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7, i16 7>
  ret <8 x i16> %sh1
}


define <16 x i8> @ashr_and(<16 x i8> %x, <16 x i8> %y) nounwind {
; CHECK-LABEL: ashr_and:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v1.16b, v1.16b, #2
; CHECK-NEXT:    sshr v0.16b, v0.16b, #5
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: ashr_and:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    sshr v0.16b, v0.16b, #3
; CHECK-GISEL-NEXT:    and v0.16b, v1.16b, v0.16b
; CHECK-GISEL-NEXT:    sshr v0.16b, v0.16b, #2
; CHECK-GISEL-NEXT:    ret
  %sh0 = ashr <16 x i8> %x, <i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3, i8 3>
  %r = and <16 x i8> %y, %sh0
  %sh1 = ashr <16 x i8> %r, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  ret <16 x i8> %sh1
}

define <2 x i64> @ashr_or(<2 x i64> %x, <2 x i64> %y) nounwind {
; CHECK-LABEL: ashr_or:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sshr v1.2d, v1.2d, #7
; CHECK-NEXT:    sshr v0.2d, v0.2d, #12
; CHECK-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: ashr_or:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    sshr v0.2d, v0.2d, #5
; CHECK-GISEL-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GISEL-NEXT:    sshr v0.2d, v0.2d, #7
; CHECK-GISEL-NEXT:    ret
  %sh0 = ashr <2 x i64> %x, <i64 5, i64 5>
  %r = or <2 x i64> %sh0, %y
  %sh1 = ashr <2 x i64> %r, <i64 7, i64 7>
  ret <2 x i64> %sh1
}

define i32 @ashr_xor(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: ashr_xor:
; CHECK:       // %bb.0:
; CHECK-NEXT:    asr w8, w0, #12
; CHECK-NEXT:    eor w0, w8, w1, asr #7
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: ashr_xor:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    asr w8, w1, #7
; CHECK-GISEL-NEXT:    eor w0, w8, w0, asr #12
; CHECK-GISEL-NEXT:    ret
  %sh0 = ashr i32 %x, 5
  %r = xor i32 %y, %sh0
  %sh1 = ashr i32 %r, 7
  ret i32 %sh1
}

define i32 @shr_mismatch_xor(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: shr_mismatch_xor:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w8, w1, w0, asr #5
; CHECK-NEXT:    lsr w0, w8, #7
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: shr_mismatch_xor:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    eor w8, w1, w0, asr #5
; CHECK-GISEL-NEXT:    lsr w0, w8, #7
; CHECK-GISEL-NEXT:    ret
  %sh0 = ashr i32 %x, 5
  %r = xor i32 %y, %sh0
  %sh1 = lshr i32 %r, 7
  ret i32 %sh1
}

define i32 @ashr_overshift_xor(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: ashr_overshift_xor:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w8, w1, w0, asr #15
; CHECK-NEXT:    asr w0, w8, #17
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: ashr_overshift_xor:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    eor w8, w1, w0, asr #15
; CHECK-GISEL-NEXT:    asr w0, w8, #17
; CHECK-GISEL-NEXT:    ret
  %sh0 = ashr i32 %x, 15
  %r = xor i32 %y, %sh0
  %sh1 = ashr i32 %r, 17
  ret i32 %sh1
}

define i32 @lshr_or_extra_use(i32 %x, i32 %y, ptr %p) nounwind {
; CHECK-LABEL: lshr_or_extra_use:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w1, w0, lsr #5
; CHECK-NEXT:    lsr w0, w8, #7
; CHECK-NEXT:    str w8, [x2]
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: lshr_or_extra_use:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    orr w8, w1, w0, lsr #5
; CHECK-GISEL-NEXT:    lsr w0, w8, #7
; CHECK-GISEL-NEXT:    str w8, [x2]
; CHECK-GISEL-NEXT:    ret
  %sh0 = lshr i32 %x, 5
  %r = or i32 %sh0, %y
  store i32 %r, ptr %p
  %sh1 = lshr i32 %r, 7
  ret i32 %sh1
}

define i64 @desirable_to_commute1(i64 %x) {
; CHECK-LABEL: desirable_to_commute1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x0, x0, #0x7fff8
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: desirable_to_commute1:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    ubfx x8, x0, #3, #16
; CHECK-GISEL-NEXT:    lsl x0, x8, #3
; CHECK-GISEL-NEXT:    ret
  %s1 = lshr i64 %x, 3
  %a = and i64 %s1, 65535
  %s2 = shl i64 %a, 3
  ret i64 %s2
}

define i64 @desirable_to_commute2(ptr %p, i64 %i) {
; CHECK-LABEL: desirable_to_commute2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and x8, x1, #0x1ff8
; CHECK-NEXT:    ldr x0, [x0, x8]
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: desirable_to_commute2:
; CHECK-GISEL:       // %bb.0:
; CHECK-GISEL-NEXT:    ubfx x8, x1, #3, #10
; CHECK-GISEL-NEXT:    ldr x0, [x0, x8, lsl #3]
; CHECK-GISEL-NEXT:    ret
  %lshr = lshr i64 %i, 3
  %and = and i64 %lshr, 1023
  %pidx = getelementptr i64, ptr %p, i64 %and
  %r = load i64, ptr %pidx
  ret i64 %r
}

; Shrink demanded op will shrink the shl to i32,
; Lshr and shl will have different shift amount type.
; Compare apint will cause crash when type is different.
define void @apint_type_mismatch(i16 %a, ptr %p) {
; CHECK-LABEL: apint_type_mismatch:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    and w8, w0, #0x7f8
; CHECK-NEXT:    str w8, [x1]
; CHECK-NEXT:    ret
;
; CHECK-GISEL-LABEL: apint_type_mismatch:
; CHECK-GISEL:       // %bb.0: // %entry
; CHECK-GISEL-NEXT:    ubfx w8, w0, #3, #13
; CHECK-GISEL-NEXT:    and w8, w8, #0xff
; CHECK-GISEL-NEXT:    lsl w8, w8, #3
; CHECK-GISEL-NEXT:    str w8, [x1]
; CHECK-GISEL-NEXT:    ret
entry:
  %lshr = lshr i16 %a, 3
  %and = and i16 %lshr, 255
  %zext = zext i16 %and to i64
  %shl = shl i64 %zext, 3
  %trunc = trunc i64 %shl to i32
  store i32 %trunc, ptr %p
  ret void
}
