// NOTE: Assertions have been autogenerated by utils/update_mc_test_checks.py UTC_ARGS: --unique --version 5
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,+real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX12 %s
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize64,+real-true16 -show-encoding %s | FileCheck --check-prefixes=GFX12 %s

v_cmpx_class_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_class_f16_e64 v1.l, v2.l         ; encoding: [0x7e,0x00,0xfd,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 v255.l, v2.l
// GFX12: v_cmpx_class_f16_e64 v255.l, v2.l       ; encoding: [0x7e,0x00,0xfd,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_class_f16_e64 s1, v2.l
// GFX12: v_cmpx_class_f16_e64 s1, v2.l           ; encoding: [0x7e,0x00,0xfd,0xd4,0x01,0x04,0x02,0x00]

v_cmpx_class_f16_e64 s105, v255.l
// GFX12: v_cmpx_class_f16_e64 s105, v255.l       ; encoding: [0x7e,0x00,0xfd,0xd4,0x69,0xfe,0x03,0x00]

v_cmpx_class_f16_e64 vcc_lo, s2
// GFX12: v_cmpx_class_f16_e64 vcc_lo, s2         ; encoding: [0x7e,0x00,0xfd,0xd4,0x6a,0x04,0x00,0x00]

v_cmpx_class_f16_e64 vcc_hi, s105
// GFX12: v_cmpx_class_f16_e64 vcc_hi, s105       ; encoding: [0x7e,0x00,0xfd,0xd4,0x6b,0xd2,0x00,0x00]

v_cmpx_class_f16_e64 ttmp15, ttmp15
// GFX12: v_cmpx_class_f16_e64 ttmp15, ttmp15     ; encoding: [0x7e,0x00,0xfd,0xd4,0x7b,0xf6,0x00,0x00]

v_cmpx_class_f16_e64 m0, src_scc
// GFX12: v_cmpx_class_f16_e64 m0, src_scc        ; encoding: [0x7e,0x00,0xfd,0xd4,0x7d,0xfa,0x01,0x00]

v_cmpx_class_f16_e64 exec_lo, -1
// GFX12: v_cmpx_class_f16_e64 exec_lo, -1        ; encoding: [0x7e,0x00,0xfd,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_class_f16_e64 exec_hi, null
// GFX12: v_cmpx_class_f16_e64 exec_hi, null      ; encoding: [0x7e,0x00,0xfd,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_class_f16_e64 null, exec_lo
// GFX12: v_cmpx_class_f16_e64 null, exec_lo      ; encoding: [0x7e,0x00,0xfd,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_class_f16_e64 -1, exec_hi
// GFX12: v_cmpx_class_f16_e64 -1, exec_hi        ; encoding: [0x7e,0x00,0xfd,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_class_f16_e64 0.5, m0
// GFX12: v_cmpx_class_f16_e64 0.5, m0            ; encoding: [0x7e,0x00,0xfd,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_class_f16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_class_f16_e64 src_scc, vcc_lo    ; encoding: [0x7e,0x00,0xfd,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_class_f16_e64 -|0xfe0b|, vcc_hi
// GFX12: v_cmpx_class_f16_e64 -|0xfe0b|, vcc_hi  ; encoding: [0x7e,0x01,0xfd,0xd4,0xff,0xd6,0x00,0x20,0x0b,0xfe,0x00,0x00]

v_cmpx_class_f16_e64 v1.h, v2.h
// GFX12: v_cmpx_class_f16_e64 v1.h, v2.h op_sel:[1,1] ; encoding: [0x7e,0x18,0xfd,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_class_f16_e64 v255.h, v2.l
// GFX12: v_cmpx_class_f16_e64 v255.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xfd,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_class_f16_e64 s105, v255.h
// GFX12: v_cmpx_class_f16_e64 s105, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xfd,0xd4,0x69,0xfe,0x03,0x00]

v_cmpx_class_f32_e64 v1, v2
// GFX12: v_cmpx_class_f32_e64 v1, v2             ; encoding: [0x7e,0x00,0xfe,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_class_f32_e64 v255, v255
// GFX12: v_cmpx_class_f32_e64 v255, v255         ; encoding: [0x7e,0x00,0xfe,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_class_f32_e64 s1, s2
// GFX12: v_cmpx_class_f32_e64 s1, s2             ; encoding: [0x7e,0x00,0xfe,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_class_f32_e64 s105, s105
// GFX12: v_cmpx_class_f32_e64 s105, s105         ; encoding: [0x7e,0x00,0xfe,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_class_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_class_f32_e64 vcc_lo, ttmp15     ; encoding: [0x7e,0x00,0xfe,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_class_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_class_f32_e64 vcc_hi, 0xaf123456 ; encoding: [0x7e,0x00,0xfe,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_class_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_class_f32_e64 ttmp15, src_scc    ; encoding: [0x7e,0x00,0xfe,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_class_f32_e64 m0, 0.5
// GFX12: v_cmpx_class_f32_e64 m0, 0.5            ; encoding: [0x7e,0x00,0xfe,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_class_f32_e64 exec_lo, -1
// GFX12: v_cmpx_class_f32_e64 exec_lo, -1        ; encoding: [0x7e,0x00,0xfe,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_class_f32_e64 exec_hi, null
// GFX12: v_cmpx_class_f32_e64 exec_hi, null      ; encoding: [0x7e,0x00,0xfe,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_class_f32_e64 null, exec_lo
// GFX12: v_cmpx_class_f32_e64 null, exec_lo      ; encoding: [0x7e,0x00,0xfe,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_class_f32_e64 -1, exec_hi
// GFX12: v_cmpx_class_f32_e64 -1, exec_hi        ; encoding: [0x7e,0x00,0xfe,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_class_f32_e64 0.5, m0
// GFX12: v_cmpx_class_f32_e64 0.5, m0            ; encoding: [0x7e,0x00,0xfe,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_class_f32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_class_f32_e64 src_scc, vcc_lo    ; encoding: [0x7e,0x00,0xfe,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_class_f32_e64 -|0xaf123456|, vcc_hi
// GFX12: v_cmpx_class_f32_e64 -|0xaf123456|, vcc_hi ; encoding: [0x7e,0x01,0xfe,0xd4,0xff,0xd6,0x00,0x20,0x56,0x34,0x12,0xaf]

v_cmpx_class_f64_e64 v[1:2], v2
// GFX12: v_cmpx_class_f64_e64 v[1:2], v2         ; encoding: [0x7e,0x00,0xff,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_class_f64_e64 v[1:2], v255
// GFX12: v_cmpx_class_f64_e64 v[1:2], v255       ; encoding: [0x7e,0x00,0xff,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_class_f64_e64 v[1:2], s2
// GFX12: v_cmpx_class_f64_e64 v[1:2], s2         ; encoding: [0x7e,0x00,0xff,0xd4,0x01,0x05,0x00,0x00]

v_cmpx_class_f64_e64 v[1:2], s105
// GFX12: v_cmpx_class_f64_e64 v[1:2], s105       ; encoding: [0x7e,0x00,0xff,0xd4,0x01,0xd3,0x00,0x00]

v_cmpx_class_f64_e64 v[254:255], ttmp15
// GFX12: v_cmpx_class_f64_e64 v[254:255], ttmp15 ; encoding: [0x7e,0x00,0xff,0xd4,0xfe,0xf7,0x00,0x00]

v_cmpx_class_f64_e64 s[2:3], vcc_hi
// GFX12: v_cmpx_class_f64_e64 s[2:3], vcc_hi     ; encoding: [0x7e,0x00,0xff,0xd4,0x02,0xd6,0x00,0x00]

v_cmpx_class_f64_e64 s[104:105], vcc_lo
// GFX12: v_cmpx_class_f64_e64 s[104:105], vcc_lo ; encoding: [0x7e,0x00,0xff,0xd4,0x68,0xd4,0x00,0x00]

v_cmpx_class_f64_e64 vcc, m0
// GFX12: v_cmpx_class_f64_e64 vcc, m0            ; encoding: [0x7e,0x00,0xff,0xd4,0x6a,0xfa,0x00,0x00]

v_cmpx_class_f64_e64 ttmp[14:15], exec_hi
// GFX12: v_cmpx_class_f64_e64 ttmp[14:15], exec_hi ; encoding: [0x7e,0x00,0xff,0xd4,0x7a,0xfe,0x00,0x00]

v_cmpx_class_f64_e64 exec, exec_lo
// GFX12: v_cmpx_class_f64_e64 exec, exec_lo      ; encoding: [0x7e,0x00,0xff,0xd4,0x7e,0xfc,0x00,0x00]

v_cmpx_class_f64_e64 null, null
// GFX12: v_cmpx_class_f64_e64 null, null         ; encoding: [0x7e,0x00,0xff,0xd4,0x7c,0xf8,0x00,0x00]

v_cmpx_class_f64_e64 -1, -1
// GFX12: v_cmpx_class_f64_e64 -1, -1             ; encoding: [0x7e,0x00,0xff,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_class_f64_e64 0.5, 0.5
// GFX12: v_cmpx_class_f64_e64 0.5, 0.5           ; encoding: [0x7e,0x00,0xff,0xd4,0xf0,0xe0,0x01,0x00]

v_cmpx_class_f64_e64 -|src_scc|, src_scc
// GFX12: v_cmpx_class_f64_e64 -|src_scc|, src_scc ; encoding: [0x7e,0x01,0xff,0xd4,0xfd,0xfa,0x01,0x20]

v_cmpx_class_f64_e64 0xaf123456, 0xaf123456
// GFX12: v_cmpx_class_f64_e64 0xaf123456, 0xaf123456 ; encoding: [0x7e,0x00,0xff,0xd4,0xff,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_eq_f16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0x82,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_eq_f16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0x82,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_eq_f16_e64 s1, s2
// GFX12: v_cmpx_eq_f16_e64 s1, s2                ; encoding: [0x7e,0x00,0x82,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_eq_f16_e64 s105, s105
// GFX12: v_cmpx_eq_f16_e64 s105, s105            ; encoding: [0x7e,0x00,0x82,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_eq_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_eq_f16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x82,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_eq_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_eq_f16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0x82,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_eq_f16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x82,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_eq_f16_e64 m0, 0.5
// GFX12: v_cmpx_eq_f16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x82,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_eq_f16_e64 exec_lo, -1
// GFX12: v_cmpx_eq_f16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x82,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_eq_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_eq_f16_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x82,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_eq_f16_e64 null, exec_lo
// GFX12: v_cmpx_eq_f16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x82,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_eq_f16_e64 -1, exec_hi
// GFX12: v_cmpx_eq_f16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x82,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_eq_f16_e64 0.5, -m0
// GFX12: v_cmpx_eq_f16_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x82,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_eq_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_eq_f16_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x82,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_eq_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_eq_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x82,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_eq_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x82,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_eq_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x82,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_eq_f32_e64 v1, v2
// GFX12: v_cmpx_eq_f32_e64 v1, v2                ; encoding: [0x7e,0x00,0x92,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_f32_e64 v255, v255
// GFX12: v_cmpx_eq_f32_e64 v255, v255            ; encoding: [0x7e,0x00,0x92,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_eq_f32_e64 s1, s2
// GFX12: v_cmpx_eq_f32_e64 s1, s2                ; encoding: [0x7e,0x00,0x92,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_eq_f32_e64 s105, s105
// GFX12: v_cmpx_eq_f32_e64 s105, s105            ; encoding: [0x7e,0x00,0x92,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_eq_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_eq_f32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x92,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_eq_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_eq_f32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0x92,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_eq_f32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x92,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_eq_f32_e64 m0, 0.5
// GFX12: v_cmpx_eq_f32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x92,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_eq_f32_e64 exec_lo, -1
// GFX12: v_cmpx_eq_f32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x92,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_eq_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_eq_f32_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x92,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_eq_f32_e64 null, exec_lo
// GFX12: v_cmpx_eq_f32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x92,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_eq_f32_e64 -1, exec_hi
// GFX12: v_cmpx_eq_f32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x92,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_eq_f32_e64 0.5, -m0
// GFX12: v_cmpx_eq_f32_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x92,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_eq_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_eq_f32_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x92,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_eq_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_eq_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x92,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_eq_f64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xa2,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_eq_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xa2,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_eq_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_eq_f64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xa2,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_eq_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_eq_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xa2,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_eq_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_eq_f64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xa2,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_eq_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_eq_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xa2,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_eq_f64_e64 -|exec|, src_scc      ; encoding: [0x7e,0x01,0xa2,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_eq_f64_e64 null, 0.5
// GFX12: v_cmpx_eq_f64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xa2,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_eq_f64_e64 -1, -1
// GFX12: v_cmpx_eq_f64_e64 -1, -1                ; encoding: [0x7e,0x00,0xa2,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_eq_f64_e64 0.5, null
// GFX12: v_cmpx_eq_f64_e64 0.5, null             ; encoding: [0x7e,0x00,0xa2,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_eq_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_eq_f64_e64 -|src_scc|, -|exec|   ; encoding: [0x7e,0x03,0xa2,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_eq_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_eq_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xa2,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i16_e64 v1.l, v2.l
// GFX12: v_cmpx_eq_i16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xb2,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 v255.l, v255.l
// GFX12: v_cmpx_eq_i16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xb2,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_eq_i16_e64 s1, s2
// GFX12: v_cmpx_eq_i16_e64 s1, s2                ; encoding: [0x7e,0x00,0xb2,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_eq_i16_e64 s105, s105
// GFX12: v_cmpx_eq_i16_e64 s105, s105            ; encoding: [0x7e,0x00,0xb2,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_eq_i16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_eq_i16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xb2,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_eq_i16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_eq_i16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xb2,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_i16_e64 ttmp15, src_scc
// GFX12: v_cmpx_eq_i16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xb2,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_eq_i16_e64 m0, 0.5
// GFX12: v_cmpx_eq_i16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xb2,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_eq_i16_e64 exec_lo, -1
// GFX12: v_cmpx_eq_i16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xb2,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_eq_i16_e64 exec_hi, null
// GFX12: v_cmpx_eq_i16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xb2,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_eq_i16_e64 null, exec_lo
// GFX12: v_cmpx_eq_i16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xb2,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_eq_i16_e64 -1, exec_hi
// GFX12: v_cmpx_eq_i16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xb2,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_eq_i16_e64 0.5, m0
// GFX12: v_cmpx_eq_i16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xb2,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_eq_i16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_eq_i16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xb2,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_eq_i16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_eq_i16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xb2,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_i16_e64 v1.h, v2.l
// GFX12: v_cmpx_eq_i16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xb2,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_i16_e64 v255.l, v255.h
// GFX12: v_cmpx_eq_i16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xb2,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_eq_i32_e64 v1, v2
// GFX12: v_cmpx_eq_i32_e64 v1, v2                ; encoding: [0x7e,0x00,0xc2,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_i32_e64 v255, v255
// GFX12: v_cmpx_eq_i32_e64 v255, v255            ; encoding: [0x7e,0x00,0xc2,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_eq_i32_e64 s1, s2
// GFX12: v_cmpx_eq_i32_e64 s1, s2                ; encoding: [0x7e,0x00,0xc2,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_eq_i32_e64 s105, s105
// GFX12: v_cmpx_eq_i32_e64 s105, s105            ; encoding: [0x7e,0x00,0xc2,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_eq_i32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_eq_i32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xc2,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_eq_i32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_eq_i32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xc2,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i32_e64 ttmp15, src_scc
// GFX12: v_cmpx_eq_i32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xc2,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_eq_i32_e64 m0, 0.5
// GFX12: v_cmpx_eq_i32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xc2,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_eq_i32_e64 exec_lo, -1
// GFX12: v_cmpx_eq_i32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xc2,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_eq_i32_e64 exec_hi, null
// GFX12: v_cmpx_eq_i32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xc2,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_eq_i32_e64 null, exec_lo
// GFX12: v_cmpx_eq_i32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xc2,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_eq_i32_e64 -1, exec_hi
// GFX12: v_cmpx_eq_i32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xc2,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_eq_i32_e64 0.5, m0
// GFX12: v_cmpx_eq_i32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xc2,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_eq_i32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_eq_i32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xc2,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_eq_i32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_eq_i32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xc2,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_eq_i64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xd2,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_i64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_eq_i64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xd2,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_eq_i64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_eq_i64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xd2,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_eq_i64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_eq_i64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xd2,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_eq_i64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_eq_i64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xd2,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_eq_i64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_eq_i64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xd2,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_i64_e64 exec, src_scc
// GFX12: v_cmpx_eq_i64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xd2,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_eq_i64_e64 null, 0.5
// GFX12: v_cmpx_eq_i64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xd2,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_eq_i64_e64 -1, -1
// GFX12: v_cmpx_eq_i64_e64 -1, -1                ; encoding: [0x7e,0x00,0xd2,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_eq_i64_e64 0.5, null
// GFX12: v_cmpx_eq_i64_e64 0.5, null             ; encoding: [0x7e,0x00,0xd2,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_eq_i64_e64 src_scc, exec
// GFX12: v_cmpx_eq_i64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xd2,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_eq_i64_e64 0xaf123456, vcc
// GFX12: v_cmpx_eq_i64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xd2,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u16_e64 v1.l, v2.l
// GFX12: v_cmpx_eq_u16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xba,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 v255.l, v255.l
// GFX12: v_cmpx_eq_u16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xba,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_eq_u16_e64 s1, s2
// GFX12: v_cmpx_eq_u16_e64 s1, s2                ; encoding: [0x7e,0x00,0xba,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_eq_u16_e64 s105, s105
// GFX12: v_cmpx_eq_u16_e64 s105, s105            ; encoding: [0x7e,0x00,0xba,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_eq_u16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_eq_u16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xba,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_eq_u16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_eq_u16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xba,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_u16_e64 ttmp15, src_scc
// GFX12: v_cmpx_eq_u16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xba,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_eq_u16_e64 m0, 0.5
// GFX12: v_cmpx_eq_u16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xba,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_eq_u16_e64 exec_lo, -1
// GFX12: v_cmpx_eq_u16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xba,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_eq_u16_e64 exec_hi, null
// GFX12: v_cmpx_eq_u16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xba,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_eq_u16_e64 null, exec_lo
// GFX12: v_cmpx_eq_u16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xba,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_eq_u16_e64 -1, exec_hi
// GFX12: v_cmpx_eq_u16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xba,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_eq_u16_e64 0.5, m0
// GFX12: v_cmpx_eq_u16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xba,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_eq_u16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_eq_u16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xba,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_eq_u16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_eq_u16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xba,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_eq_u16_e64 v1.h, v2.l
// GFX12: v_cmpx_eq_u16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xba,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_u16_e64 v255.l, v255.h
// GFX12: v_cmpx_eq_u16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xba,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_eq_u32_e64 v1, v2
// GFX12: v_cmpx_eq_u32_e64 v1, v2                ; encoding: [0x7e,0x00,0xca,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_u32_e64 v255, v255
// GFX12: v_cmpx_eq_u32_e64 v255, v255            ; encoding: [0x7e,0x00,0xca,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_eq_u32_e64 s1, s2
// GFX12: v_cmpx_eq_u32_e64 s1, s2                ; encoding: [0x7e,0x00,0xca,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_eq_u32_e64 s105, s105
// GFX12: v_cmpx_eq_u32_e64 s105, s105            ; encoding: [0x7e,0x00,0xca,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_eq_u32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_eq_u32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xca,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_eq_u32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_eq_u32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xca,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u32_e64 ttmp15, src_scc
// GFX12: v_cmpx_eq_u32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xca,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_eq_u32_e64 m0, 0.5
// GFX12: v_cmpx_eq_u32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xca,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_eq_u32_e64 exec_lo, -1
// GFX12: v_cmpx_eq_u32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xca,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_eq_u32_e64 exec_hi, null
// GFX12: v_cmpx_eq_u32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xca,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_eq_u32_e64 null, exec_lo
// GFX12: v_cmpx_eq_u32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xca,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_eq_u32_e64 -1, exec_hi
// GFX12: v_cmpx_eq_u32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xca,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_eq_u32_e64 0.5, m0
// GFX12: v_cmpx_eq_u32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xca,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_eq_u32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_eq_u32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xca,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_eq_u32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_eq_u32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xca,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_eq_u64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xda,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_eq_u64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_eq_u64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xda,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_eq_u64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_eq_u64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xda,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_eq_u64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_eq_u64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xda,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_eq_u64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_eq_u64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xda,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_eq_u64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_eq_u64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xda,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_eq_u64_e64 exec, src_scc
// GFX12: v_cmpx_eq_u64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xda,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_eq_u64_e64 null, 0.5
// GFX12: v_cmpx_eq_u64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xda,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_eq_u64_e64 -1, -1
// GFX12: v_cmpx_eq_u64_e64 -1, -1                ; encoding: [0x7e,0x00,0xda,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_eq_u64_e64 0.5, null
// GFX12: v_cmpx_eq_u64_e64 0.5, null             ; encoding: [0x7e,0x00,0xda,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_eq_u64_e64 src_scc, exec
// GFX12: v_cmpx_eq_u64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xda,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_eq_u64_e64 0xaf123456, vcc
// GFX12: v_cmpx_eq_u64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xda,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_ge_f16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0x86,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_ge_f16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0x86,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ge_f16_e64 s1, s2
// GFX12: v_cmpx_ge_f16_e64 s1, s2                ; encoding: [0x7e,0x00,0x86,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ge_f16_e64 s105, s105
// GFX12: v_cmpx_ge_f16_e64 s105, s105            ; encoding: [0x7e,0x00,0x86,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ge_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ge_f16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x86,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ge_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_ge_f16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0x86,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_ge_f16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x86,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ge_f16_e64 m0, 0.5
// GFX12: v_cmpx_ge_f16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x86,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ge_f16_e64 exec_lo, -1
// GFX12: v_cmpx_ge_f16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x86,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ge_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_ge_f16_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x86,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ge_f16_e64 null, exec_lo
// GFX12: v_cmpx_ge_f16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x86,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ge_f16_e64 -1, exec_hi
// GFX12: v_cmpx_ge_f16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x86,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ge_f16_e64 0.5, -m0
// GFX12: v_cmpx_ge_f16_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x86,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_ge_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_ge_f16_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x86,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_ge_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_ge_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x86,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_ge_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x86,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_ge_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x86,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ge_f32_e64 v1, v2
// GFX12: v_cmpx_ge_f32_e64 v1, v2                ; encoding: [0x7e,0x00,0x96,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_f32_e64 v255, v255
// GFX12: v_cmpx_ge_f32_e64 v255, v255            ; encoding: [0x7e,0x00,0x96,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ge_f32_e64 s1, s2
// GFX12: v_cmpx_ge_f32_e64 s1, s2                ; encoding: [0x7e,0x00,0x96,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ge_f32_e64 s105, s105
// GFX12: v_cmpx_ge_f32_e64 s105, s105            ; encoding: [0x7e,0x00,0x96,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ge_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ge_f32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x96,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ge_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_ge_f32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0x96,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_ge_f32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x96,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ge_f32_e64 m0, 0.5
// GFX12: v_cmpx_ge_f32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x96,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ge_f32_e64 exec_lo, -1
// GFX12: v_cmpx_ge_f32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x96,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ge_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_ge_f32_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x96,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ge_f32_e64 null, exec_lo
// GFX12: v_cmpx_ge_f32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x96,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ge_f32_e64 -1, exec_hi
// GFX12: v_cmpx_ge_f32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x96,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ge_f32_e64 0.5, -m0
// GFX12: v_cmpx_ge_f32_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x96,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_ge_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_ge_f32_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x96,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_ge_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_ge_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x96,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_ge_f64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xa6,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_ge_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xa6,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_ge_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_ge_f64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xa6,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_ge_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_ge_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xa6,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_ge_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_ge_f64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xa6,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_ge_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_ge_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xa6,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_ge_f64_e64 -|exec|, src_scc      ; encoding: [0x7e,0x01,0xa6,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_ge_f64_e64 null, 0.5
// GFX12: v_cmpx_ge_f64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xa6,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_ge_f64_e64 -1, -1
// GFX12: v_cmpx_ge_f64_e64 -1, -1                ; encoding: [0x7e,0x00,0xa6,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_ge_f64_e64 0.5, null
// GFX12: v_cmpx_ge_f64_e64 0.5, null             ; encoding: [0x7e,0x00,0xa6,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_ge_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_ge_f64_e64 -|src_scc|, -|exec|   ; encoding: [0x7e,0x03,0xa6,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_ge_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_ge_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xa6,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i16_e64 v1.l, v2.l
// GFX12: v_cmpx_ge_i16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xb6,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 v255.l, v255.l
// GFX12: v_cmpx_ge_i16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xb6,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ge_i16_e64 s1, s2
// GFX12: v_cmpx_ge_i16_e64 s1, s2                ; encoding: [0x7e,0x00,0xb6,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ge_i16_e64 s105, s105
// GFX12: v_cmpx_ge_i16_e64 s105, s105            ; encoding: [0x7e,0x00,0xb6,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ge_i16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ge_i16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xb6,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ge_i16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_ge_i16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xb6,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_i16_e64 ttmp15, src_scc
// GFX12: v_cmpx_ge_i16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xb6,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ge_i16_e64 m0, 0.5
// GFX12: v_cmpx_ge_i16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xb6,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ge_i16_e64 exec_lo, -1
// GFX12: v_cmpx_ge_i16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xb6,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ge_i16_e64 exec_hi, null
// GFX12: v_cmpx_ge_i16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xb6,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ge_i16_e64 null, exec_lo
// GFX12: v_cmpx_ge_i16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xb6,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ge_i16_e64 -1, exec_hi
// GFX12: v_cmpx_ge_i16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xb6,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ge_i16_e64 0.5, m0
// GFX12: v_cmpx_ge_i16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xb6,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_ge_i16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_ge_i16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xb6,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_ge_i16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_ge_i16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xb6,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_i16_e64 v1.h, v2.l
// GFX12: v_cmpx_ge_i16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xb6,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_i16_e64 v255.l, v255.h
// GFX12: v_cmpx_ge_i16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xb6,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ge_i32_e64 v1, v2
// GFX12: v_cmpx_ge_i32_e64 v1, v2                ; encoding: [0x7e,0x00,0xc6,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_i32_e64 v255, v255
// GFX12: v_cmpx_ge_i32_e64 v255, v255            ; encoding: [0x7e,0x00,0xc6,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ge_i32_e64 s1, s2
// GFX12: v_cmpx_ge_i32_e64 s1, s2                ; encoding: [0x7e,0x00,0xc6,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ge_i32_e64 s105, s105
// GFX12: v_cmpx_ge_i32_e64 s105, s105            ; encoding: [0x7e,0x00,0xc6,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ge_i32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ge_i32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xc6,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ge_i32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_ge_i32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xc6,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i32_e64 ttmp15, src_scc
// GFX12: v_cmpx_ge_i32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xc6,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ge_i32_e64 m0, 0.5
// GFX12: v_cmpx_ge_i32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xc6,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ge_i32_e64 exec_lo, -1
// GFX12: v_cmpx_ge_i32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xc6,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ge_i32_e64 exec_hi, null
// GFX12: v_cmpx_ge_i32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xc6,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ge_i32_e64 null, exec_lo
// GFX12: v_cmpx_ge_i32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xc6,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ge_i32_e64 -1, exec_hi
// GFX12: v_cmpx_ge_i32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xc6,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ge_i32_e64 0.5, m0
// GFX12: v_cmpx_ge_i32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xc6,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_ge_i32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_ge_i32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xc6,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_ge_i32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_ge_i32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xc6,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_ge_i64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xd6,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_i64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_ge_i64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xd6,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_ge_i64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_ge_i64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xd6,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_ge_i64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_ge_i64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xd6,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_ge_i64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_ge_i64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xd6,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_ge_i64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_ge_i64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xd6,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_i64_e64 exec, src_scc
// GFX12: v_cmpx_ge_i64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xd6,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_ge_i64_e64 null, 0.5
// GFX12: v_cmpx_ge_i64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xd6,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_ge_i64_e64 -1, -1
// GFX12: v_cmpx_ge_i64_e64 -1, -1                ; encoding: [0x7e,0x00,0xd6,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_ge_i64_e64 0.5, null
// GFX12: v_cmpx_ge_i64_e64 0.5, null             ; encoding: [0x7e,0x00,0xd6,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_ge_i64_e64 src_scc, exec
// GFX12: v_cmpx_ge_i64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xd6,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_ge_i64_e64 0xaf123456, vcc
// GFX12: v_cmpx_ge_i64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xd6,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u16_e64 v1.l, v2.l
// GFX12: v_cmpx_ge_u16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xbe,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 v255.l, v255.l
// GFX12: v_cmpx_ge_u16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xbe,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ge_u16_e64 s1, s2
// GFX12: v_cmpx_ge_u16_e64 s1, s2                ; encoding: [0x7e,0x00,0xbe,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ge_u16_e64 s105, s105
// GFX12: v_cmpx_ge_u16_e64 s105, s105            ; encoding: [0x7e,0x00,0xbe,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ge_u16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ge_u16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xbe,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ge_u16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_ge_u16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xbe,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_u16_e64 ttmp15, src_scc
// GFX12: v_cmpx_ge_u16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xbe,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ge_u16_e64 m0, 0.5
// GFX12: v_cmpx_ge_u16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xbe,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ge_u16_e64 exec_lo, -1
// GFX12: v_cmpx_ge_u16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xbe,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ge_u16_e64 exec_hi, null
// GFX12: v_cmpx_ge_u16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xbe,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ge_u16_e64 null, exec_lo
// GFX12: v_cmpx_ge_u16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xbe,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ge_u16_e64 -1, exec_hi
// GFX12: v_cmpx_ge_u16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xbe,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ge_u16_e64 0.5, m0
// GFX12: v_cmpx_ge_u16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xbe,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_ge_u16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_ge_u16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xbe,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_ge_u16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_ge_u16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xbe,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ge_u16_e64 v1.h, v2.l
// GFX12: v_cmpx_ge_u16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xbe,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_u16_e64 v255.l, v255.h
// GFX12: v_cmpx_ge_u16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xbe,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ge_u32_e64 v1, v2
// GFX12: v_cmpx_ge_u32_e64 v1, v2                ; encoding: [0x7e,0x00,0xce,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_u32_e64 v255, v255
// GFX12: v_cmpx_ge_u32_e64 v255, v255            ; encoding: [0x7e,0x00,0xce,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ge_u32_e64 s1, s2
// GFX12: v_cmpx_ge_u32_e64 s1, s2                ; encoding: [0x7e,0x00,0xce,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ge_u32_e64 s105, s105
// GFX12: v_cmpx_ge_u32_e64 s105, s105            ; encoding: [0x7e,0x00,0xce,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ge_u32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ge_u32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xce,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ge_u32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_ge_u32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xce,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u32_e64 ttmp15, src_scc
// GFX12: v_cmpx_ge_u32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xce,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ge_u32_e64 m0, 0.5
// GFX12: v_cmpx_ge_u32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xce,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ge_u32_e64 exec_lo, -1
// GFX12: v_cmpx_ge_u32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xce,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ge_u32_e64 exec_hi, null
// GFX12: v_cmpx_ge_u32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xce,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ge_u32_e64 null, exec_lo
// GFX12: v_cmpx_ge_u32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xce,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ge_u32_e64 -1, exec_hi
// GFX12: v_cmpx_ge_u32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xce,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ge_u32_e64 0.5, m0
// GFX12: v_cmpx_ge_u32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xce,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_ge_u32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_ge_u32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xce,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_ge_u32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_ge_u32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xce,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_ge_u64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xde,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ge_u64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_ge_u64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xde,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_ge_u64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_ge_u64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xde,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_ge_u64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_ge_u64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xde,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_ge_u64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_ge_u64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xde,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_ge_u64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_ge_u64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xde,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ge_u64_e64 exec, src_scc
// GFX12: v_cmpx_ge_u64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xde,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_ge_u64_e64 null, 0.5
// GFX12: v_cmpx_ge_u64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xde,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_ge_u64_e64 -1, -1
// GFX12: v_cmpx_ge_u64_e64 -1, -1                ; encoding: [0x7e,0x00,0xde,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_ge_u64_e64 0.5, null
// GFX12: v_cmpx_ge_u64_e64 0.5, null             ; encoding: [0x7e,0x00,0xde,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_ge_u64_e64 src_scc, exec
// GFX12: v_cmpx_ge_u64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xde,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_ge_u64_e64 0xaf123456, vcc
// GFX12: v_cmpx_ge_u64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xde,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_gt_f16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0x84,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_gt_f16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0x84,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_gt_f16_e64 s1, s2
// GFX12: v_cmpx_gt_f16_e64 s1, s2                ; encoding: [0x7e,0x00,0x84,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_gt_f16_e64 s105, s105
// GFX12: v_cmpx_gt_f16_e64 s105, s105            ; encoding: [0x7e,0x00,0x84,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_gt_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_gt_f16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x84,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_gt_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_gt_f16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0x84,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_gt_f16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x84,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_gt_f16_e64 m0, 0.5
// GFX12: v_cmpx_gt_f16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x84,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_gt_f16_e64 exec_lo, -1
// GFX12: v_cmpx_gt_f16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x84,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_gt_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_gt_f16_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x84,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_gt_f16_e64 null, exec_lo
// GFX12: v_cmpx_gt_f16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x84,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_gt_f16_e64 -1, exec_hi
// GFX12: v_cmpx_gt_f16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x84,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_gt_f16_e64 0.5, -m0
// GFX12: v_cmpx_gt_f16_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x84,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_gt_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_gt_f16_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x84,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_gt_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_gt_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x84,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_gt_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x84,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_gt_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x84,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_gt_f32_e64 v1, v2
// GFX12: v_cmpx_gt_f32_e64 v1, v2                ; encoding: [0x7e,0x00,0x94,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_f32_e64 v255, v255
// GFX12: v_cmpx_gt_f32_e64 v255, v255            ; encoding: [0x7e,0x00,0x94,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_gt_f32_e64 s1, s2
// GFX12: v_cmpx_gt_f32_e64 s1, s2                ; encoding: [0x7e,0x00,0x94,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_gt_f32_e64 s105, s105
// GFX12: v_cmpx_gt_f32_e64 s105, s105            ; encoding: [0x7e,0x00,0x94,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_gt_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_gt_f32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x94,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_gt_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_gt_f32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0x94,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_gt_f32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x94,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_gt_f32_e64 m0, 0.5
// GFX12: v_cmpx_gt_f32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x94,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_gt_f32_e64 exec_lo, -1
// GFX12: v_cmpx_gt_f32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x94,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_gt_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_gt_f32_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x94,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_gt_f32_e64 null, exec_lo
// GFX12: v_cmpx_gt_f32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x94,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_gt_f32_e64 -1, exec_hi
// GFX12: v_cmpx_gt_f32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x94,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_gt_f32_e64 0.5, -m0
// GFX12: v_cmpx_gt_f32_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x94,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_gt_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_gt_f32_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x94,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_gt_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_gt_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x94,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_gt_f64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xa4,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_gt_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xa4,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_gt_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_gt_f64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xa4,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_gt_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_gt_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xa4,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_gt_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_gt_f64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xa4,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_gt_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_gt_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xa4,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_gt_f64_e64 -|exec|, src_scc      ; encoding: [0x7e,0x01,0xa4,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_gt_f64_e64 null, 0.5
// GFX12: v_cmpx_gt_f64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xa4,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_gt_f64_e64 -1, -1
// GFX12: v_cmpx_gt_f64_e64 -1, -1                ; encoding: [0x7e,0x00,0xa4,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_gt_f64_e64 0.5, null
// GFX12: v_cmpx_gt_f64_e64 0.5, null             ; encoding: [0x7e,0x00,0xa4,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_gt_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_gt_f64_e64 -|src_scc|, -|exec|   ; encoding: [0x7e,0x03,0xa4,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_gt_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_gt_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xa4,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i16_e64 v1.l, v2.l
// GFX12: v_cmpx_gt_i16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xb4,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 v255.l, v255.l
// GFX12: v_cmpx_gt_i16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xb4,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_gt_i16_e64 s1, s2
// GFX12: v_cmpx_gt_i16_e64 s1, s2                ; encoding: [0x7e,0x00,0xb4,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_gt_i16_e64 s105, s105
// GFX12: v_cmpx_gt_i16_e64 s105, s105            ; encoding: [0x7e,0x00,0xb4,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_gt_i16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_gt_i16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xb4,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_gt_i16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_gt_i16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xb4,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_i16_e64 ttmp15, src_scc
// GFX12: v_cmpx_gt_i16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xb4,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_gt_i16_e64 m0, 0.5
// GFX12: v_cmpx_gt_i16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xb4,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_gt_i16_e64 exec_lo, -1
// GFX12: v_cmpx_gt_i16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xb4,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_gt_i16_e64 exec_hi, null
// GFX12: v_cmpx_gt_i16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xb4,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_gt_i16_e64 null, exec_lo
// GFX12: v_cmpx_gt_i16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xb4,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_gt_i16_e64 -1, exec_hi
// GFX12: v_cmpx_gt_i16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xb4,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_gt_i16_e64 0.5, m0
// GFX12: v_cmpx_gt_i16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xb4,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_gt_i16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_gt_i16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xb4,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_gt_i16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_gt_i16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xb4,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_i16_e64 v1.h, v2.l
// GFX12: v_cmpx_gt_i16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xb4,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_i16_e64 v255.l, v255.h
// GFX12: v_cmpx_gt_i16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xb4,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_gt_i32_e64 v1, v2
// GFX12: v_cmpx_gt_i32_e64 v1, v2                ; encoding: [0x7e,0x00,0xc4,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_i32_e64 v255, v255
// GFX12: v_cmpx_gt_i32_e64 v255, v255            ; encoding: [0x7e,0x00,0xc4,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_gt_i32_e64 s1, s2
// GFX12: v_cmpx_gt_i32_e64 s1, s2                ; encoding: [0x7e,0x00,0xc4,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_gt_i32_e64 s105, s105
// GFX12: v_cmpx_gt_i32_e64 s105, s105            ; encoding: [0x7e,0x00,0xc4,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_gt_i32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_gt_i32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xc4,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_gt_i32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_gt_i32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xc4,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i32_e64 ttmp15, src_scc
// GFX12: v_cmpx_gt_i32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xc4,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_gt_i32_e64 m0, 0.5
// GFX12: v_cmpx_gt_i32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xc4,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_gt_i32_e64 exec_lo, -1
// GFX12: v_cmpx_gt_i32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xc4,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_gt_i32_e64 exec_hi, null
// GFX12: v_cmpx_gt_i32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xc4,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_gt_i32_e64 null, exec_lo
// GFX12: v_cmpx_gt_i32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xc4,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_gt_i32_e64 -1, exec_hi
// GFX12: v_cmpx_gt_i32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xc4,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_gt_i32_e64 0.5, m0
// GFX12: v_cmpx_gt_i32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xc4,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_gt_i32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_gt_i32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xc4,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_gt_i32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_gt_i32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xc4,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_gt_i64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xd4,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_i64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_gt_i64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xd4,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_gt_i64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_gt_i64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xd4,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_gt_i64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_gt_i64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xd4,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_gt_i64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_gt_i64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xd4,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_gt_i64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_gt_i64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xd4,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_i64_e64 exec, src_scc
// GFX12: v_cmpx_gt_i64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xd4,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_gt_i64_e64 null, 0.5
// GFX12: v_cmpx_gt_i64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xd4,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_gt_i64_e64 -1, -1
// GFX12: v_cmpx_gt_i64_e64 -1, -1                ; encoding: [0x7e,0x00,0xd4,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_gt_i64_e64 0.5, null
// GFX12: v_cmpx_gt_i64_e64 0.5, null             ; encoding: [0x7e,0x00,0xd4,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_gt_i64_e64 src_scc, exec
// GFX12: v_cmpx_gt_i64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xd4,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_gt_i64_e64 0xaf123456, vcc
// GFX12: v_cmpx_gt_i64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xd4,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u16_e64 v1.l, v2.l
// GFX12: v_cmpx_gt_u16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xbc,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 v255.l, v255.l
// GFX12: v_cmpx_gt_u16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xbc,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_gt_u16_e64 s1, s2
// GFX12: v_cmpx_gt_u16_e64 s1, s2                ; encoding: [0x7e,0x00,0xbc,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_gt_u16_e64 s105, s105
// GFX12: v_cmpx_gt_u16_e64 s105, s105            ; encoding: [0x7e,0x00,0xbc,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_gt_u16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_gt_u16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xbc,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_gt_u16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_gt_u16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xbc,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_u16_e64 ttmp15, src_scc
// GFX12: v_cmpx_gt_u16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xbc,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_gt_u16_e64 m0, 0.5
// GFX12: v_cmpx_gt_u16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xbc,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_gt_u16_e64 exec_lo, -1
// GFX12: v_cmpx_gt_u16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xbc,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_gt_u16_e64 exec_hi, null
// GFX12: v_cmpx_gt_u16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xbc,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_gt_u16_e64 null, exec_lo
// GFX12: v_cmpx_gt_u16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xbc,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_gt_u16_e64 -1, exec_hi
// GFX12: v_cmpx_gt_u16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xbc,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_gt_u16_e64 0.5, m0
// GFX12: v_cmpx_gt_u16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xbc,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_gt_u16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_gt_u16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xbc,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_gt_u16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_gt_u16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xbc,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_gt_u16_e64 v1.h, v2.l
// GFX12: v_cmpx_gt_u16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xbc,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_u16_e64 v255.l, v255.h
// GFX12: v_cmpx_gt_u16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xbc,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_gt_u32_e64 v1, v2
// GFX12: v_cmpx_gt_u32_e64 v1, v2                ; encoding: [0x7e,0x00,0xcc,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_u32_e64 v255, v255
// GFX12: v_cmpx_gt_u32_e64 v255, v255            ; encoding: [0x7e,0x00,0xcc,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_gt_u32_e64 s1, s2
// GFX12: v_cmpx_gt_u32_e64 s1, s2                ; encoding: [0x7e,0x00,0xcc,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_gt_u32_e64 s105, s105
// GFX12: v_cmpx_gt_u32_e64 s105, s105            ; encoding: [0x7e,0x00,0xcc,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_gt_u32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_gt_u32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xcc,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_gt_u32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_gt_u32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xcc,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u32_e64 ttmp15, src_scc
// GFX12: v_cmpx_gt_u32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xcc,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_gt_u32_e64 m0, 0.5
// GFX12: v_cmpx_gt_u32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xcc,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_gt_u32_e64 exec_lo, -1
// GFX12: v_cmpx_gt_u32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xcc,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_gt_u32_e64 exec_hi, null
// GFX12: v_cmpx_gt_u32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xcc,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_gt_u32_e64 null, exec_lo
// GFX12: v_cmpx_gt_u32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xcc,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_gt_u32_e64 -1, exec_hi
// GFX12: v_cmpx_gt_u32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xcc,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_gt_u32_e64 0.5, m0
// GFX12: v_cmpx_gt_u32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xcc,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_gt_u32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_gt_u32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xcc,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_gt_u32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_gt_u32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xcc,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_gt_u64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xdc,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_gt_u64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_gt_u64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xdc,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_gt_u64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_gt_u64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xdc,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_gt_u64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_gt_u64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xdc,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_gt_u64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_gt_u64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xdc,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_gt_u64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_gt_u64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xdc,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_gt_u64_e64 exec, src_scc
// GFX12: v_cmpx_gt_u64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xdc,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_gt_u64_e64 null, 0.5
// GFX12: v_cmpx_gt_u64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xdc,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_gt_u64_e64 -1, -1
// GFX12: v_cmpx_gt_u64_e64 -1, -1                ; encoding: [0x7e,0x00,0xdc,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_gt_u64_e64 0.5, null
// GFX12: v_cmpx_gt_u64_e64 0.5, null             ; encoding: [0x7e,0x00,0xdc,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_gt_u64_e64 src_scc, exec
// GFX12: v_cmpx_gt_u64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xdc,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_gt_u64_e64 0xaf123456, vcc
// GFX12: v_cmpx_gt_u64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xdc,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_le_f16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0x83,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_le_f16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0x83,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_le_f16_e64 s1, s2
// GFX12: v_cmpx_le_f16_e64 s1, s2                ; encoding: [0x7e,0x00,0x83,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_le_f16_e64 s105, s105
// GFX12: v_cmpx_le_f16_e64 s105, s105            ; encoding: [0x7e,0x00,0x83,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_le_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_le_f16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x83,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_le_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_le_f16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0x83,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_le_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_le_f16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x83,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_le_f16_e64 m0, 0.5
// GFX12: v_cmpx_le_f16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x83,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_le_f16_e64 exec_lo, -1
// GFX12: v_cmpx_le_f16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x83,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_le_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_le_f16_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x83,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_le_f16_e64 null, exec_lo
// GFX12: v_cmpx_le_f16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x83,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_le_f16_e64 -1, exec_hi
// GFX12: v_cmpx_le_f16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x83,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_le_f16_e64 0.5, -m0
// GFX12: v_cmpx_le_f16_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x83,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_le_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_le_f16_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x83,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_le_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_le_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x83,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_le_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_le_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x83,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_le_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x83,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_le_f32_e64 v1, v2
// GFX12: v_cmpx_le_f32_e64 v1, v2                ; encoding: [0x7e,0x00,0x93,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_f32_e64 v255, v255
// GFX12: v_cmpx_le_f32_e64 v255, v255            ; encoding: [0x7e,0x00,0x93,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_le_f32_e64 s1, s2
// GFX12: v_cmpx_le_f32_e64 s1, s2                ; encoding: [0x7e,0x00,0x93,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_le_f32_e64 s105, s105
// GFX12: v_cmpx_le_f32_e64 s105, s105            ; encoding: [0x7e,0x00,0x93,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_le_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_le_f32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x93,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_le_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_le_f32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0x93,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_le_f32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x93,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_le_f32_e64 m0, 0.5
// GFX12: v_cmpx_le_f32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x93,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_le_f32_e64 exec_lo, -1
// GFX12: v_cmpx_le_f32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x93,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_le_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_le_f32_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x93,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_le_f32_e64 null, exec_lo
// GFX12: v_cmpx_le_f32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x93,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_le_f32_e64 -1, exec_hi
// GFX12: v_cmpx_le_f32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x93,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_le_f32_e64 0.5, -m0
// GFX12: v_cmpx_le_f32_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x93,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_le_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_le_f32_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x93,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_le_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_le_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x93,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_le_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_le_f64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xa3,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_le_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xa3,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_le_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_le_f64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xa3,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_le_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_le_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xa3,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_le_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_le_f64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xa3,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_le_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_le_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xa3,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_le_f64_e64 -|exec|, src_scc      ; encoding: [0x7e,0x01,0xa3,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_le_f64_e64 null, 0.5
// GFX12: v_cmpx_le_f64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xa3,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_le_f64_e64 -1, -1
// GFX12: v_cmpx_le_f64_e64 -1, -1                ; encoding: [0x7e,0x00,0xa3,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_le_f64_e64 0.5, null
// GFX12: v_cmpx_le_f64_e64 0.5, null             ; encoding: [0x7e,0x00,0xa3,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_le_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_le_f64_e64 -|src_scc|, -|exec|   ; encoding: [0x7e,0x03,0xa3,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_le_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_le_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xa3,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_le_i16_e64 v1.l, v2.l
// GFX12: v_cmpx_le_i16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xb3,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 v255.l, v255.l
// GFX12: v_cmpx_le_i16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xb3,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_le_i16_e64 s1, s2
// GFX12: v_cmpx_le_i16_e64 s1, s2                ; encoding: [0x7e,0x00,0xb3,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_le_i16_e64 s105, s105
// GFX12: v_cmpx_le_i16_e64 s105, s105            ; encoding: [0x7e,0x00,0xb3,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_le_i16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_le_i16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xb3,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_le_i16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_le_i16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xb3,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_le_i16_e64 ttmp15, src_scc
// GFX12: v_cmpx_le_i16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xb3,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_le_i16_e64 m0, 0.5
// GFX12: v_cmpx_le_i16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xb3,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_le_i16_e64 exec_lo, -1
// GFX12: v_cmpx_le_i16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xb3,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_le_i16_e64 exec_hi, null
// GFX12: v_cmpx_le_i16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xb3,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_le_i16_e64 null, exec_lo
// GFX12: v_cmpx_le_i16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xb3,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_le_i16_e64 -1, exec_hi
// GFX12: v_cmpx_le_i16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xb3,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_le_i16_e64 0.5, m0
// GFX12: v_cmpx_le_i16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xb3,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_le_i16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_le_i16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xb3,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_le_i16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_le_i16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xb3,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_le_i16_e64 v1.h, v2.l
// GFX12: v_cmpx_le_i16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xb3,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_i16_e64 v255.l, v255.h
// GFX12: v_cmpx_le_i16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xb3,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_le_i32_e64 v1, v2
// GFX12: v_cmpx_le_i32_e64 v1, v2                ; encoding: [0x7e,0x00,0xc3,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_i32_e64 v255, v255
// GFX12: v_cmpx_le_i32_e64 v255, v255            ; encoding: [0x7e,0x00,0xc3,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_le_i32_e64 s1, s2
// GFX12: v_cmpx_le_i32_e64 s1, s2                ; encoding: [0x7e,0x00,0xc3,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_le_i32_e64 s105, s105
// GFX12: v_cmpx_le_i32_e64 s105, s105            ; encoding: [0x7e,0x00,0xc3,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_le_i32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_le_i32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xc3,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_le_i32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_le_i32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xc3,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_i32_e64 ttmp15, src_scc
// GFX12: v_cmpx_le_i32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xc3,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_le_i32_e64 m0, 0.5
// GFX12: v_cmpx_le_i32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xc3,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_le_i32_e64 exec_lo, -1
// GFX12: v_cmpx_le_i32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xc3,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_le_i32_e64 exec_hi, null
// GFX12: v_cmpx_le_i32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xc3,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_le_i32_e64 null, exec_lo
// GFX12: v_cmpx_le_i32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xc3,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_le_i32_e64 -1, exec_hi
// GFX12: v_cmpx_le_i32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xc3,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_le_i32_e64 0.5, m0
// GFX12: v_cmpx_le_i32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xc3,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_le_i32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_le_i32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xc3,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_le_i32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_le_i32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xc3,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_i64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_le_i64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xd3,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_i64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_le_i64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xd3,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_le_i64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_le_i64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xd3,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_le_i64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_le_i64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xd3,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_le_i64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_le_i64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xd3,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_le_i64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_le_i64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xd3,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_i64_e64 exec, src_scc
// GFX12: v_cmpx_le_i64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xd3,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_le_i64_e64 null, 0.5
// GFX12: v_cmpx_le_i64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xd3,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_le_i64_e64 -1, -1
// GFX12: v_cmpx_le_i64_e64 -1, -1                ; encoding: [0x7e,0x00,0xd3,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_le_i64_e64 0.5, null
// GFX12: v_cmpx_le_i64_e64 0.5, null             ; encoding: [0x7e,0x00,0xd3,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_le_i64_e64 src_scc, exec
// GFX12: v_cmpx_le_i64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xd3,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_le_i64_e64 0xaf123456, vcc
// GFX12: v_cmpx_le_i64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xd3,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_u16_e64 v1.l, v2.l
// GFX12: v_cmpx_le_u16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xbb,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 v255.l, v255.l
// GFX12: v_cmpx_le_u16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xbb,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_le_u16_e64 s1, s2
// GFX12: v_cmpx_le_u16_e64 s1, s2                ; encoding: [0x7e,0x00,0xbb,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_le_u16_e64 s105, s105
// GFX12: v_cmpx_le_u16_e64 s105, s105            ; encoding: [0x7e,0x00,0xbb,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_le_u16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_le_u16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xbb,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_le_u16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_le_u16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xbb,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_le_u16_e64 ttmp15, src_scc
// GFX12: v_cmpx_le_u16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xbb,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_le_u16_e64 m0, 0.5
// GFX12: v_cmpx_le_u16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xbb,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_le_u16_e64 exec_lo, -1
// GFX12: v_cmpx_le_u16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xbb,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_le_u16_e64 exec_hi, null
// GFX12: v_cmpx_le_u16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xbb,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_le_u16_e64 null, exec_lo
// GFX12: v_cmpx_le_u16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xbb,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_le_u16_e64 -1, exec_hi
// GFX12: v_cmpx_le_u16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xbb,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_le_u16_e64 0.5, m0
// GFX12: v_cmpx_le_u16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xbb,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_le_u16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_le_u16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xbb,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_le_u16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_le_u16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xbb,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_le_u16_e64 v1.h, v2.l
// GFX12: v_cmpx_le_u16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xbb,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_u16_e64 v255.l, v255.h
// GFX12: v_cmpx_le_u16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xbb,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_le_u32_e64 v1, v2
// GFX12: v_cmpx_le_u32_e64 v1, v2                ; encoding: [0x7e,0x00,0xcb,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_u32_e64 v255, v255
// GFX12: v_cmpx_le_u32_e64 v255, v255            ; encoding: [0x7e,0x00,0xcb,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_le_u32_e64 s1, s2
// GFX12: v_cmpx_le_u32_e64 s1, s2                ; encoding: [0x7e,0x00,0xcb,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_le_u32_e64 s105, s105
// GFX12: v_cmpx_le_u32_e64 s105, s105            ; encoding: [0x7e,0x00,0xcb,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_le_u32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_le_u32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xcb,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_le_u32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_le_u32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xcb,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_u32_e64 ttmp15, src_scc
// GFX12: v_cmpx_le_u32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xcb,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_le_u32_e64 m0, 0.5
// GFX12: v_cmpx_le_u32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xcb,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_le_u32_e64 exec_lo, -1
// GFX12: v_cmpx_le_u32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xcb,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_le_u32_e64 exec_hi, null
// GFX12: v_cmpx_le_u32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xcb,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_le_u32_e64 null, exec_lo
// GFX12: v_cmpx_le_u32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xcb,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_le_u32_e64 -1, exec_hi
// GFX12: v_cmpx_le_u32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xcb,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_le_u32_e64 0.5, m0
// GFX12: v_cmpx_le_u32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xcb,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_le_u32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_le_u32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xcb,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_le_u32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_le_u32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xcb,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_u64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_le_u64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xdb,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_le_u64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_le_u64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xdb,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_le_u64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_le_u64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xdb,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_le_u64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_le_u64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xdb,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_le_u64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_le_u64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xdb,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_le_u64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_le_u64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xdb,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_le_u64_e64 exec, src_scc
// GFX12: v_cmpx_le_u64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xdb,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_le_u64_e64 null, 0.5
// GFX12: v_cmpx_le_u64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xdb,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_le_u64_e64 -1, -1
// GFX12: v_cmpx_le_u64_e64 -1, -1                ; encoding: [0x7e,0x00,0xdb,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_le_u64_e64 0.5, null
// GFX12: v_cmpx_le_u64_e64 0.5, null             ; encoding: [0x7e,0x00,0xdb,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_le_u64_e64 src_scc, exec
// GFX12: v_cmpx_le_u64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xdb,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_le_u64_e64 0xaf123456, vcc
// GFX12: v_cmpx_le_u64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xdb,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_lg_f16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0x85,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_lg_f16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0x85,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lg_f16_e64 s1, s2
// GFX12: v_cmpx_lg_f16_e64 s1, s2                ; encoding: [0x7e,0x00,0x85,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_lg_f16_e64 s105, s105
// GFX12: v_cmpx_lg_f16_e64 s105, s105            ; encoding: [0x7e,0x00,0x85,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_lg_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_lg_f16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x85,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_lg_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_lg_f16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0x85,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_lg_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_lg_f16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x85,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_lg_f16_e64 m0, 0.5
// GFX12: v_cmpx_lg_f16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x85,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_lg_f16_e64 exec_lo, -1
// GFX12: v_cmpx_lg_f16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x85,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_lg_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_lg_f16_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x85,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_lg_f16_e64 null, exec_lo
// GFX12: v_cmpx_lg_f16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x85,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_lg_f16_e64 -1, exec_hi
// GFX12: v_cmpx_lg_f16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x85,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_lg_f16_e64 0.5, -m0
// GFX12: v_cmpx_lg_f16_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x85,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_lg_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_lg_f16_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x85,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_lg_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_lg_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x85,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_lg_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_lg_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x85,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lg_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_lg_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x85,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lg_f32_e64 v1, v2
// GFX12: v_cmpx_lg_f32_e64 v1, v2                ; encoding: [0x7e,0x00,0x95,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lg_f32_e64 v255, v255
// GFX12: v_cmpx_lg_f32_e64 v255, v255            ; encoding: [0x7e,0x00,0x95,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lg_f32_e64 s1, s2
// GFX12: v_cmpx_lg_f32_e64 s1, s2                ; encoding: [0x7e,0x00,0x95,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_lg_f32_e64 s105, s105
// GFX12: v_cmpx_lg_f32_e64 s105, s105            ; encoding: [0x7e,0x00,0x95,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_lg_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_lg_f32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x95,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_lg_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_lg_f32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0x95,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_lg_f32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x95,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_lg_f32_e64 m0, 0.5
// GFX12: v_cmpx_lg_f32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x95,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_lg_f32_e64 exec_lo, -1
// GFX12: v_cmpx_lg_f32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x95,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_lg_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_lg_f32_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x95,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_lg_f32_e64 null, exec_lo
// GFX12: v_cmpx_lg_f32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x95,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_lg_f32_e64 -1, exec_hi
// GFX12: v_cmpx_lg_f32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x95,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_lg_f32_e64 0.5, -m0
// GFX12: v_cmpx_lg_f32_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x95,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_lg_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_lg_f32_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x95,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_lg_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_lg_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x95,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_lg_f64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xa5,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lg_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_lg_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xa5,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_lg_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_lg_f64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xa5,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_lg_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_lg_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xa5,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_lg_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_lg_f64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xa5,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_lg_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_lg_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xa5,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lg_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_lg_f64_e64 -|exec|, src_scc      ; encoding: [0x7e,0x01,0xa5,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_lg_f64_e64 null, 0.5
// GFX12: v_cmpx_lg_f64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xa5,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_lg_f64_e64 -1, -1
// GFX12: v_cmpx_lg_f64_e64 -1, -1                ; encoding: [0x7e,0x00,0xa5,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_lg_f64_e64 0.5, null
// GFX12: v_cmpx_lg_f64_e64 0.5, null             ; encoding: [0x7e,0x00,0xa5,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_lg_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_lg_f64_e64 -|src_scc|, -|exec|   ; encoding: [0x7e,0x03,0xa5,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_lg_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_lg_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xa5,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_lt_f16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0x81,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_lt_f16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0x81,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lt_f16_e64 s1, s2
// GFX12: v_cmpx_lt_f16_e64 s1, s2                ; encoding: [0x7e,0x00,0x81,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_lt_f16_e64 s105, s105
// GFX12: v_cmpx_lt_f16_e64 s105, s105            ; encoding: [0x7e,0x00,0x81,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_lt_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_lt_f16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x81,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_lt_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_lt_f16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0x81,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_lt_f16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x81,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_lt_f16_e64 m0, 0.5
// GFX12: v_cmpx_lt_f16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x81,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_lt_f16_e64 exec_lo, -1
// GFX12: v_cmpx_lt_f16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x81,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_lt_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_lt_f16_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x81,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_lt_f16_e64 null, exec_lo
// GFX12: v_cmpx_lt_f16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x81,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_lt_f16_e64 -1, exec_hi
// GFX12: v_cmpx_lt_f16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x81,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_lt_f16_e64 0.5, -m0
// GFX12: v_cmpx_lt_f16_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x81,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_lt_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_lt_f16_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x81,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_lt_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_lt_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x81,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_lt_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x81,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_lt_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x81,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lt_f32_e64 v1, v2
// GFX12: v_cmpx_lt_f32_e64 v1, v2                ; encoding: [0x7e,0x00,0x91,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_f32_e64 v255, v255
// GFX12: v_cmpx_lt_f32_e64 v255, v255            ; encoding: [0x7e,0x00,0x91,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lt_f32_e64 s1, s2
// GFX12: v_cmpx_lt_f32_e64 s1, s2                ; encoding: [0x7e,0x00,0x91,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_lt_f32_e64 s105, s105
// GFX12: v_cmpx_lt_f32_e64 s105, s105            ; encoding: [0x7e,0x00,0x91,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_lt_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_lt_f32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0x91,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_lt_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_lt_f32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0x91,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_lt_f32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0x91,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_lt_f32_e64 m0, 0.5
// GFX12: v_cmpx_lt_f32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0x91,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_lt_f32_e64 exec_lo, -1
// GFX12: v_cmpx_lt_f32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0x91,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_lt_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_lt_f32_e64 |exec_hi|, null       ; encoding: [0x7e,0x01,0x91,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_lt_f32_e64 null, exec_lo
// GFX12: v_cmpx_lt_f32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0x91,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_lt_f32_e64 -1, exec_hi
// GFX12: v_cmpx_lt_f32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0x91,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_lt_f32_e64 0.5, -m0
// GFX12: v_cmpx_lt_f32_e64 0.5, -m0              ; encoding: [0x7e,0x00,0x91,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_lt_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_lt_f32_e64 -src_scc, |vcc_lo|    ; encoding: [0x7e,0x02,0x91,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_lt_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_lt_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x91,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_lt_f64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xa1,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_lt_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xa1,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_lt_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_lt_f64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xa1,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_lt_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_lt_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xa1,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_lt_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_lt_f64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xa1,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_lt_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_lt_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xa1,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lt_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_lt_f64_e64 -|exec|, src_scc      ; encoding: [0x7e,0x01,0xa1,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_lt_f64_e64 null, 0.5
// GFX12: v_cmpx_lt_f64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xa1,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_lt_f64_e64 -1, -1
// GFX12: v_cmpx_lt_f64_e64 -1, -1                ; encoding: [0x7e,0x00,0xa1,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_lt_f64_e64 0.5, null
// GFX12: v_cmpx_lt_f64_e64 0.5, null             ; encoding: [0x7e,0x00,0xa1,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_lt_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_lt_f64_e64 -|src_scc|, -|exec|   ; encoding: [0x7e,0x03,0xa1,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_lt_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_lt_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xa1,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i16_e64 v1.l, v2.l
// GFX12: v_cmpx_lt_i16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xb1,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 v255.l, v255.l
// GFX12: v_cmpx_lt_i16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xb1,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lt_i16_e64 s1, s2
// GFX12: v_cmpx_lt_i16_e64 s1, s2                ; encoding: [0x7e,0x00,0xb1,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_lt_i16_e64 s105, s105
// GFX12: v_cmpx_lt_i16_e64 s105, s105            ; encoding: [0x7e,0x00,0xb1,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_lt_i16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_lt_i16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xb1,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_lt_i16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_lt_i16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xb1,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_i16_e64 ttmp15, src_scc
// GFX12: v_cmpx_lt_i16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xb1,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_lt_i16_e64 m0, 0.5
// GFX12: v_cmpx_lt_i16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xb1,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_lt_i16_e64 exec_lo, -1
// GFX12: v_cmpx_lt_i16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xb1,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_lt_i16_e64 exec_hi, null
// GFX12: v_cmpx_lt_i16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xb1,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_lt_i16_e64 null, exec_lo
// GFX12: v_cmpx_lt_i16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xb1,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_lt_i16_e64 -1, exec_hi
// GFX12: v_cmpx_lt_i16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xb1,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_lt_i16_e64 0.5, m0
// GFX12: v_cmpx_lt_i16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xb1,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_lt_i16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_lt_i16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xb1,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_lt_i16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_lt_i16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xb1,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_i16_e64 v1.h, v2.l
// GFX12: v_cmpx_lt_i16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xb1,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_i16_e64 v255.l, v255.h
// GFX12: v_cmpx_lt_i16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xb1,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lt_i32_e64 v1, v2
// GFX12: v_cmpx_lt_i32_e64 v1, v2                ; encoding: [0x7e,0x00,0xc1,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_i32_e64 v255, v255
// GFX12: v_cmpx_lt_i32_e64 v255, v255            ; encoding: [0x7e,0x00,0xc1,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lt_i32_e64 s1, s2
// GFX12: v_cmpx_lt_i32_e64 s1, s2                ; encoding: [0x7e,0x00,0xc1,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_lt_i32_e64 s105, s105
// GFX12: v_cmpx_lt_i32_e64 s105, s105            ; encoding: [0x7e,0x00,0xc1,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_lt_i32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_lt_i32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xc1,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_lt_i32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_lt_i32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xc1,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i32_e64 ttmp15, src_scc
// GFX12: v_cmpx_lt_i32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xc1,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_lt_i32_e64 m0, 0.5
// GFX12: v_cmpx_lt_i32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xc1,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_lt_i32_e64 exec_lo, -1
// GFX12: v_cmpx_lt_i32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xc1,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_lt_i32_e64 exec_hi, null
// GFX12: v_cmpx_lt_i32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xc1,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_lt_i32_e64 null, exec_lo
// GFX12: v_cmpx_lt_i32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xc1,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_lt_i32_e64 -1, exec_hi
// GFX12: v_cmpx_lt_i32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xc1,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_lt_i32_e64 0.5, m0
// GFX12: v_cmpx_lt_i32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xc1,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_lt_i32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_lt_i32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xc1,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_lt_i32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_lt_i32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xc1,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_lt_i64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xd1,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_i64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_lt_i64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xd1,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_lt_i64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_lt_i64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xd1,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_lt_i64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_lt_i64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xd1,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_lt_i64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_lt_i64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xd1,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_lt_i64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_lt_i64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xd1,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lt_i64_e64 exec, src_scc
// GFX12: v_cmpx_lt_i64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xd1,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_lt_i64_e64 null, 0.5
// GFX12: v_cmpx_lt_i64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xd1,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_lt_i64_e64 -1, -1
// GFX12: v_cmpx_lt_i64_e64 -1, -1                ; encoding: [0x7e,0x00,0xd1,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_lt_i64_e64 0.5, null
// GFX12: v_cmpx_lt_i64_e64 0.5, null             ; encoding: [0x7e,0x00,0xd1,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_lt_i64_e64 src_scc, exec
// GFX12: v_cmpx_lt_i64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xd1,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_lt_i64_e64 0xaf123456, vcc
// GFX12: v_cmpx_lt_i64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xd1,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u16_e64 v1.l, v2.l
// GFX12: v_cmpx_lt_u16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xb9,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 v255.l, v255.l
// GFX12: v_cmpx_lt_u16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xb9,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lt_u16_e64 s1, s2
// GFX12: v_cmpx_lt_u16_e64 s1, s2                ; encoding: [0x7e,0x00,0xb9,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_lt_u16_e64 s105, s105
// GFX12: v_cmpx_lt_u16_e64 s105, s105            ; encoding: [0x7e,0x00,0xb9,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_lt_u16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_lt_u16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xb9,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_lt_u16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_lt_u16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xb9,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_u16_e64 ttmp15, src_scc
// GFX12: v_cmpx_lt_u16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xb9,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_lt_u16_e64 m0, 0.5
// GFX12: v_cmpx_lt_u16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xb9,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_lt_u16_e64 exec_lo, -1
// GFX12: v_cmpx_lt_u16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xb9,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_lt_u16_e64 exec_hi, null
// GFX12: v_cmpx_lt_u16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xb9,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_lt_u16_e64 null, exec_lo
// GFX12: v_cmpx_lt_u16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xb9,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_lt_u16_e64 -1, exec_hi
// GFX12: v_cmpx_lt_u16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xb9,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_lt_u16_e64 0.5, m0
// GFX12: v_cmpx_lt_u16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xb9,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_lt_u16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_lt_u16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xb9,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_lt_u16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_lt_u16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xb9,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_lt_u16_e64 v1.h, v2.l
// GFX12: v_cmpx_lt_u16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xb9,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_u16_e64 v255.l, v255.h
// GFX12: v_cmpx_lt_u16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xb9,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lt_u32_e64 v1, v2
// GFX12: v_cmpx_lt_u32_e64 v1, v2                ; encoding: [0x7e,0x00,0xc9,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_u32_e64 v255, v255
// GFX12: v_cmpx_lt_u32_e64 v255, v255            ; encoding: [0x7e,0x00,0xc9,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_lt_u32_e64 s1, s2
// GFX12: v_cmpx_lt_u32_e64 s1, s2                ; encoding: [0x7e,0x00,0xc9,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_lt_u32_e64 s105, s105
// GFX12: v_cmpx_lt_u32_e64 s105, s105            ; encoding: [0x7e,0x00,0xc9,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_lt_u32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_lt_u32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xc9,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_lt_u32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_lt_u32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xc9,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u32_e64 ttmp15, src_scc
// GFX12: v_cmpx_lt_u32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xc9,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_lt_u32_e64 m0, 0.5
// GFX12: v_cmpx_lt_u32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xc9,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_lt_u32_e64 exec_lo, -1
// GFX12: v_cmpx_lt_u32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xc9,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_lt_u32_e64 exec_hi, null
// GFX12: v_cmpx_lt_u32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xc9,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_lt_u32_e64 null, exec_lo
// GFX12: v_cmpx_lt_u32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xc9,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_lt_u32_e64 -1, exec_hi
// GFX12: v_cmpx_lt_u32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xc9,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_lt_u32_e64 0.5, m0
// GFX12: v_cmpx_lt_u32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xc9,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_lt_u32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_lt_u32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xc9,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_lt_u32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_lt_u32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xc9,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_lt_u64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xd9,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_lt_u64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_lt_u64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xd9,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_lt_u64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_lt_u64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xd9,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_lt_u64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_lt_u64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xd9,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_lt_u64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_lt_u64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xd9,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_lt_u64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_lt_u64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xd9,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_lt_u64_e64 exec, src_scc
// GFX12: v_cmpx_lt_u64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xd9,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_lt_u64_e64 null, 0.5
// GFX12: v_cmpx_lt_u64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xd9,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_lt_u64_e64 -1, -1
// GFX12: v_cmpx_lt_u64_e64 -1, -1                ; encoding: [0x7e,0x00,0xd9,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_lt_u64_e64 0.5, null
// GFX12: v_cmpx_lt_u64_e64 0.5, null             ; encoding: [0x7e,0x00,0xd9,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_lt_u64_e64 src_scc, exec
// GFX12: v_cmpx_lt_u64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xd9,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_lt_u64_e64 0xaf123456, vcc
// GFX12: v_cmpx_lt_u64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xd9,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i16_e64 v1.l, v2.l
// GFX12: v_cmpx_ne_i16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xb5,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 v255.l, v255.l
// GFX12: v_cmpx_ne_i16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xb5,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ne_i16_e64 s1, s2
// GFX12: v_cmpx_ne_i16_e64 s1, s2                ; encoding: [0x7e,0x00,0xb5,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ne_i16_e64 s105, s105
// GFX12: v_cmpx_ne_i16_e64 s105, s105            ; encoding: [0x7e,0x00,0xb5,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ne_i16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ne_i16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xb5,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ne_i16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_ne_i16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xb5,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ne_i16_e64 ttmp15, src_scc
// GFX12: v_cmpx_ne_i16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xb5,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ne_i16_e64 m0, 0.5
// GFX12: v_cmpx_ne_i16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xb5,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ne_i16_e64 exec_lo, -1
// GFX12: v_cmpx_ne_i16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xb5,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ne_i16_e64 exec_hi, null
// GFX12: v_cmpx_ne_i16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xb5,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ne_i16_e64 null, exec_lo
// GFX12: v_cmpx_ne_i16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xb5,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ne_i16_e64 -1, exec_hi
// GFX12: v_cmpx_ne_i16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xb5,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ne_i16_e64 0.5, m0
// GFX12: v_cmpx_ne_i16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xb5,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_ne_i16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_ne_i16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xb5,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_ne_i16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_ne_i16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xb5,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ne_i16_e64 v1.h, v2.l
// GFX12: v_cmpx_ne_i16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xb5,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_i16_e64 v255.l, v255.h
// GFX12: v_cmpx_ne_i16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xb5,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ne_i32_e64 v1, v2
// GFX12: v_cmpx_ne_i32_e64 v1, v2                ; encoding: [0x7e,0x00,0xc5,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_i32_e64 v255, v255
// GFX12: v_cmpx_ne_i32_e64 v255, v255            ; encoding: [0x7e,0x00,0xc5,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ne_i32_e64 s1, s2
// GFX12: v_cmpx_ne_i32_e64 s1, s2                ; encoding: [0x7e,0x00,0xc5,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ne_i32_e64 s105, s105
// GFX12: v_cmpx_ne_i32_e64 s105, s105            ; encoding: [0x7e,0x00,0xc5,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ne_i32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ne_i32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xc5,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ne_i32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_ne_i32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xc5,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i32_e64 ttmp15, src_scc
// GFX12: v_cmpx_ne_i32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xc5,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ne_i32_e64 m0, 0.5
// GFX12: v_cmpx_ne_i32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xc5,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ne_i32_e64 exec_lo, -1
// GFX12: v_cmpx_ne_i32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xc5,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ne_i32_e64 exec_hi, null
// GFX12: v_cmpx_ne_i32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xc5,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ne_i32_e64 null, exec_lo
// GFX12: v_cmpx_ne_i32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xc5,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ne_i32_e64 -1, exec_hi
// GFX12: v_cmpx_ne_i32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xc5,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ne_i32_e64 0.5, m0
// GFX12: v_cmpx_ne_i32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xc5,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_ne_i32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_ne_i32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xc5,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_ne_i32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_ne_i32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xc5,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_ne_i64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xd5,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_i64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_ne_i64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xd5,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_ne_i64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_ne_i64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xd5,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_ne_i64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_ne_i64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xd5,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_ne_i64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_ne_i64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xd5,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_ne_i64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_ne_i64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xd5,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ne_i64_e64 exec, src_scc
// GFX12: v_cmpx_ne_i64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xd5,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_ne_i64_e64 null, 0.5
// GFX12: v_cmpx_ne_i64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xd5,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_ne_i64_e64 -1, -1
// GFX12: v_cmpx_ne_i64_e64 -1, -1                ; encoding: [0x7e,0x00,0xd5,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_ne_i64_e64 0.5, null
// GFX12: v_cmpx_ne_i64_e64 0.5, null             ; encoding: [0x7e,0x00,0xd5,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_ne_i64_e64 src_scc, exec
// GFX12: v_cmpx_ne_i64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xd5,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_ne_i64_e64 0xaf123456, vcc
// GFX12: v_cmpx_ne_i64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xd5,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u16_e64 v1.l, v2.l
// GFX12: v_cmpx_ne_u16_e64 v1.l, v2.l            ; encoding: [0x7e,0x00,0xbd,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 v255.l, v255.l
// GFX12: v_cmpx_ne_u16_e64 v255.l, v255.l        ; encoding: [0x7e,0x00,0xbd,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ne_u16_e64 s1, s2
// GFX12: v_cmpx_ne_u16_e64 s1, s2                ; encoding: [0x7e,0x00,0xbd,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ne_u16_e64 s105, s105
// GFX12: v_cmpx_ne_u16_e64 s105, s105            ; encoding: [0x7e,0x00,0xbd,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ne_u16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ne_u16_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xbd,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ne_u16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_ne_u16_e64 vcc_hi, 0xfe0b        ; encoding: [0x7e,0x00,0xbd,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ne_u16_e64 ttmp15, src_scc
// GFX12: v_cmpx_ne_u16_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xbd,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ne_u16_e64 m0, 0.5
// GFX12: v_cmpx_ne_u16_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xbd,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ne_u16_e64 exec_lo, -1
// GFX12: v_cmpx_ne_u16_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xbd,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ne_u16_e64 exec_hi, null
// GFX12: v_cmpx_ne_u16_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xbd,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ne_u16_e64 null, exec_lo
// GFX12: v_cmpx_ne_u16_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xbd,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ne_u16_e64 -1, exec_hi
// GFX12: v_cmpx_ne_u16_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xbd,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ne_u16_e64 0.5, m0
// GFX12: v_cmpx_ne_u16_e64 0.5, m0               ; encoding: [0x7e,0x00,0xbd,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_ne_u16_e64 src_scc, vcc_lo
// GFX12: v_cmpx_ne_u16_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xbd,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_ne_u16_e64 0xfe0b, vcc_hi
// GFX12: v_cmpx_ne_u16_e64 0xfe0b, vcc_hi        ; encoding: [0x7e,0x00,0xbd,0xd4,0xff,0xd6,0x00,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ne_u16_e64 v1.h, v2.l
// GFX12: v_cmpx_ne_u16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0xbd,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_u16_e64 v255.l, v255.h
// GFX12: v_cmpx_ne_u16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0xbd,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ne_u32_e64 v1, v2
// GFX12: v_cmpx_ne_u32_e64 v1, v2                ; encoding: [0x7e,0x00,0xcd,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_u32_e64 v255, v255
// GFX12: v_cmpx_ne_u32_e64 v255, v255            ; encoding: [0x7e,0x00,0xcd,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ne_u32_e64 s1, s2
// GFX12: v_cmpx_ne_u32_e64 s1, s2                ; encoding: [0x7e,0x00,0xcd,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ne_u32_e64 s105, s105
// GFX12: v_cmpx_ne_u32_e64 s105, s105            ; encoding: [0x7e,0x00,0xcd,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ne_u32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ne_u32_e64 vcc_lo, ttmp15        ; encoding: [0x7e,0x00,0xcd,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ne_u32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_ne_u32_e64 vcc_hi, 0xaf123456    ; encoding: [0x7e,0x00,0xcd,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u32_e64 ttmp15, src_scc
// GFX12: v_cmpx_ne_u32_e64 ttmp15, src_scc       ; encoding: [0x7e,0x00,0xcd,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ne_u32_e64 m0, 0.5
// GFX12: v_cmpx_ne_u32_e64 m0, 0.5               ; encoding: [0x7e,0x00,0xcd,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ne_u32_e64 exec_lo, -1
// GFX12: v_cmpx_ne_u32_e64 exec_lo, -1           ; encoding: [0x7e,0x00,0xcd,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ne_u32_e64 exec_hi, null
// GFX12: v_cmpx_ne_u32_e64 exec_hi, null         ; encoding: [0x7e,0x00,0xcd,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ne_u32_e64 null, exec_lo
// GFX12: v_cmpx_ne_u32_e64 null, exec_lo         ; encoding: [0x7e,0x00,0xcd,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ne_u32_e64 -1, exec_hi
// GFX12: v_cmpx_ne_u32_e64 -1, exec_hi           ; encoding: [0x7e,0x00,0xcd,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ne_u32_e64 0.5, m0
// GFX12: v_cmpx_ne_u32_e64 0.5, m0               ; encoding: [0x7e,0x00,0xcd,0xd4,0xf0,0xfa,0x00,0x00]

v_cmpx_ne_u32_e64 src_scc, vcc_lo
// GFX12: v_cmpx_ne_u32_e64 src_scc, vcc_lo       ; encoding: [0x7e,0x00,0xcd,0xd4,0xfd,0xd4,0x00,0x00]

v_cmpx_ne_u32_e64 0xaf123456, vcc_hi
// GFX12: v_cmpx_ne_u32_e64 0xaf123456, vcc_hi    ; encoding: [0x7e,0x00,0xcd,0xd4,0xff,0xd6,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_ne_u64_e64 v[1:2], v[2:3]        ; encoding: [0x7e,0x00,0xdd,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ne_u64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_ne_u64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xdd,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_ne_u64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_ne_u64_e64 s[2:3], s[4:5]        ; encoding: [0x7e,0x00,0xdd,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_ne_u64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_ne_u64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xdd,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_ne_u64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_ne_u64_e64 vcc, ttmp[14:15]      ; encoding: [0x7e,0x00,0xdd,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_ne_u64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_ne_u64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xdd,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ne_u64_e64 exec, src_scc
// GFX12: v_cmpx_ne_u64_e64 exec, src_scc         ; encoding: [0x7e,0x00,0xdd,0xd4,0x7e,0xfa,0x01,0x00]

v_cmpx_ne_u64_e64 null, 0.5
// GFX12: v_cmpx_ne_u64_e64 null, 0.5             ; encoding: [0x7e,0x00,0xdd,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_ne_u64_e64 -1, -1
// GFX12: v_cmpx_ne_u64_e64 -1, -1                ; encoding: [0x7e,0x00,0xdd,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_ne_u64_e64 0.5, null
// GFX12: v_cmpx_ne_u64_e64 0.5, null             ; encoding: [0x7e,0x00,0xdd,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_ne_u64_e64 src_scc, exec
// GFX12: v_cmpx_ne_u64_e64 src_scc, exec         ; encoding: [0x7e,0x00,0xdd,0xd4,0xfd,0xfc,0x00,0x00]

v_cmpx_ne_u64_e64 0xaf123456, vcc
// GFX12: v_cmpx_ne_u64_e64 0xaf123456, vcc       ; encoding: [0x7e,0x00,0xdd,0xd4,0xff,0xd4,0x00,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_neq_f16_e64 v1.l, v2.l           ; encoding: [0x7e,0x00,0x8d,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_neq_f16_e64 v255.l, v255.l       ; encoding: [0x7e,0x00,0x8d,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_neq_f16_e64 s1, s2
// GFX12: v_cmpx_neq_f16_e64 s1, s2               ; encoding: [0x7e,0x00,0x8d,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_neq_f16_e64 s105, s105
// GFX12: v_cmpx_neq_f16_e64 s105, s105           ; encoding: [0x7e,0x00,0x8d,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_neq_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_neq_f16_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x8d,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_neq_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_neq_f16_e64 vcc_hi, 0xfe0b       ; encoding: [0x7e,0x00,0x8d,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_neq_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_neq_f16_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x8d,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_neq_f16_e64 m0, 0.5
// GFX12: v_cmpx_neq_f16_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x8d,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_neq_f16_e64 exec_lo, -1
// GFX12: v_cmpx_neq_f16_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x8d,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_neq_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_neq_f16_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x8d,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_neq_f16_e64 null, exec_lo
// GFX12: v_cmpx_neq_f16_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x8d,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_neq_f16_e64 -1, exec_hi
// GFX12: v_cmpx_neq_f16_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x8d,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_neq_f16_e64 0.5, -m0
// GFX12: v_cmpx_neq_f16_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x8d,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_neq_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_neq_f16_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x8d,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_neq_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_neq_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x8d,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_neq_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_neq_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x8d,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_neq_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_neq_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x8d,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_neq_f32_e64 v1, v2
// GFX12: v_cmpx_neq_f32_e64 v1, v2               ; encoding: [0x7e,0x00,0x9d,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_neq_f32_e64 v255, v255
// GFX12: v_cmpx_neq_f32_e64 v255, v255           ; encoding: [0x7e,0x00,0x9d,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_neq_f32_e64 s1, s2
// GFX12: v_cmpx_neq_f32_e64 s1, s2               ; encoding: [0x7e,0x00,0x9d,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_neq_f32_e64 s105, s105
// GFX12: v_cmpx_neq_f32_e64 s105, s105           ; encoding: [0x7e,0x00,0x9d,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_neq_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_neq_f32_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x9d,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_neq_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_neq_f32_e64 vcc_hi, 0xaf123456   ; encoding: [0x7e,0x00,0x9d,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_neq_f32_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x9d,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_neq_f32_e64 m0, 0.5
// GFX12: v_cmpx_neq_f32_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x9d,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_neq_f32_e64 exec_lo, -1
// GFX12: v_cmpx_neq_f32_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x9d,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_neq_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_neq_f32_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x9d,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_neq_f32_e64 null, exec_lo
// GFX12: v_cmpx_neq_f32_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x9d,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_neq_f32_e64 -1, exec_hi
// GFX12: v_cmpx_neq_f32_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x9d,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_neq_f32_e64 0.5, -m0
// GFX12: v_cmpx_neq_f32_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x9d,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_neq_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_neq_f32_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x9d,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_neq_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_neq_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x9d,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_neq_f64_e64 v[1:2], v[2:3]       ; encoding: [0x7e,0x00,0xad,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_neq_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_neq_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xad,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_neq_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_neq_f64_e64 s[2:3], s[4:5]       ; encoding: [0x7e,0x00,0xad,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_neq_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_neq_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xad,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_neq_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_neq_f64_e64 vcc, ttmp[14:15]     ; encoding: [0x7e,0x00,0xad,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_neq_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_neq_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xad,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_neq_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_neq_f64_e64 -|exec|, src_scc     ; encoding: [0x7e,0x01,0xad,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_neq_f64_e64 null, 0.5
// GFX12: v_cmpx_neq_f64_e64 null, 0.5            ; encoding: [0x7e,0x00,0xad,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_neq_f64_e64 -1, -1
// GFX12: v_cmpx_neq_f64_e64 -1, -1               ; encoding: [0x7e,0x00,0xad,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_neq_f64_e64 0.5, null
// GFX12: v_cmpx_neq_f64_e64 0.5, null            ; encoding: [0x7e,0x00,0xad,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_neq_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_neq_f64_e64 -|src_scc|, -|exec|  ; encoding: [0x7e,0x03,0xad,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_neq_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_neq_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xad,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_nge_f16_e64 v1.l, v2.l           ; encoding: [0x7e,0x00,0x89,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_nge_f16_e64 v255.l, v255.l       ; encoding: [0x7e,0x00,0x89,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nge_f16_e64 s1, s2
// GFX12: v_cmpx_nge_f16_e64 s1, s2               ; encoding: [0x7e,0x00,0x89,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_nge_f16_e64 s105, s105
// GFX12: v_cmpx_nge_f16_e64 s105, s105           ; encoding: [0x7e,0x00,0x89,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_nge_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_nge_f16_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x89,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_nge_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_nge_f16_e64 vcc_hi, 0xfe0b       ; encoding: [0x7e,0x00,0x89,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_nge_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_nge_f16_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x89,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_nge_f16_e64 m0, 0.5
// GFX12: v_cmpx_nge_f16_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x89,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_nge_f16_e64 exec_lo, -1
// GFX12: v_cmpx_nge_f16_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x89,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_nge_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_nge_f16_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x89,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_nge_f16_e64 null, exec_lo
// GFX12: v_cmpx_nge_f16_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x89,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_nge_f16_e64 -1, exec_hi
// GFX12: v_cmpx_nge_f16_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x89,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_nge_f16_e64 0.5, -m0
// GFX12: v_cmpx_nge_f16_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x89,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_nge_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_nge_f16_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x89,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_nge_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_nge_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x89,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_nge_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_nge_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x89,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nge_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_nge_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x89,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nge_f32_e64 v1, v2
// GFX12: v_cmpx_nge_f32_e64 v1, v2               ; encoding: [0x7e,0x00,0x99,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nge_f32_e64 v255, v255
// GFX12: v_cmpx_nge_f32_e64 v255, v255           ; encoding: [0x7e,0x00,0x99,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nge_f32_e64 s1, s2
// GFX12: v_cmpx_nge_f32_e64 s1, s2               ; encoding: [0x7e,0x00,0x99,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_nge_f32_e64 s105, s105
// GFX12: v_cmpx_nge_f32_e64 s105, s105           ; encoding: [0x7e,0x00,0x99,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_nge_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_nge_f32_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x99,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_nge_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_nge_f32_e64 vcc_hi, 0xaf123456   ; encoding: [0x7e,0x00,0x99,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_nge_f32_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x99,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_nge_f32_e64 m0, 0.5
// GFX12: v_cmpx_nge_f32_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x99,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_nge_f32_e64 exec_lo, -1
// GFX12: v_cmpx_nge_f32_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x99,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_nge_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_nge_f32_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x99,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_nge_f32_e64 null, exec_lo
// GFX12: v_cmpx_nge_f32_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x99,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_nge_f32_e64 -1, exec_hi
// GFX12: v_cmpx_nge_f32_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x99,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_nge_f32_e64 0.5, -m0
// GFX12: v_cmpx_nge_f32_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x99,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_nge_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_nge_f32_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x99,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_nge_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_nge_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x99,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_nge_f64_e64 v[1:2], v[2:3]       ; encoding: [0x7e,0x00,0xa9,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nge_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_nge_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xa9,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_nge_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_nge_f64_e64 s[2:3], s[4:5]       ; encoding: [0x7e,0x00,0xa9,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_nge_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_nge_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xa9,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_nge_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_nge_f64_e64 vcc, ttmp[14:15]     ; encoding: [0x7e,0x00,0xa9,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_nge_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_nge_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xa9,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_nge_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_nge_f64_e64 -|exec|, src_scc     ; encoding: [0x7e,0x01,0xa9,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_nge_f64_e64 null, 0.5
// GFX12: v_cmpx_nge_f64_e64 null, 0.5            ; encoding: [0x7e,0x00,0xa9,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_nge_f64_e64 -1, -1
// GFX12: v_cmpx_nge_f64_e64 -1, -1               ; encoding: [0x7e,0x00,0xa9,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_nge_f64_e64 0.5, null
// GFX12: v_cmpx_nge_f64_e64 0.5, null            ; encoding: [0x7e,0x00,0xa9,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_nge_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_nge_f64_e64 -|src_scc|, -|exec|  ; encoding: [0x7e,0x03,0xa9,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_nge_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_nge_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xa9,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_ngt_f16_e64 v1.l, v2.l           ; encoding: [0x7e,0x00,0x8b,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_ngt_f16_e64 v255.l, v255.l       ; encoding: [0x7e,0x00,0x8b,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ngt_f16_e64 s1, s2
// GFX12: v_cmpx_ngt_f16_e64 s1, s2               ; encoding: [0x7e,0x00,0x8b,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ngt_f16_e64 s105, s105
// GFX12: v_cmpx_ngt_f16_e64 s105, s105           ; encoding: [0x7e,0x00,0x8b,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ngt_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ngt_f16_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x8b,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ngt_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_ngt_f16_e64 vcc_hi, 0xfe0b       ; encoding: [0x7e,0x00,0x8b,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_ngt_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_ngt_f16_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x8b,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ngt_f16_e64 m0, 0.5
// GFX12: v_cmpx_ngt_f16_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x8b,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ngt_f16_e64 exec_lo, -1
// GFX12: v_cmpx_ngt_f16_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x8b,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ngt_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_ngt_f16_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x8b,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ngt_f16_e64 null, exec_lo
// GFX12: v_cmpx_ngt_f16_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x8b,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ngt_f16_e64 -1, exec_hi
// GFX12: v_cmpx_ngt_f16_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x8b,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ngt_f16_e64 0.5, -m0
// GFX12: v_cmpx_ngt_f16_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x8b,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_ngt_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_ngt_f16_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x8b,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_ngt_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_ngt_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x8b,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_ngt_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_ngt_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x8b,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_ngt_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x8b,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ngt_f32_e64 v1, v2
// GFX12: v_cmpx_ngt_f32_e64 v1, v2               ; encoding: [0x7e,0x00,0x9b,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f32_e64 v255, v255
// GFX12: v_cmpx_ngt_f32_e64 v255, v255           ; encoding: [0x7e,0x00,0x9b,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_ngt_f32_e64 s1, s2
// GFX12: v_cmpx_ngt_f32_e64 s1, s2               ; encoding: [0x7e,0x00,0x9b,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_ngt_f32_e64 s105, s105
// GFX12: v_cmpx_ngt_f32_e64 s105, s105           ; encoding: [0x7e,0x00,0x9b,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_ngt_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_ngt_f32_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x9b,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_ngt_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_ngt_f32_e64 vcc_hi, 0xaf123456   ; encoding: [0x7e,0x00,0x9b,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_ngt_f32_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x9b,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_ngt_f32_e64 m0, 0.5
// GFX12: v_cmpx_ngt_f32_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x9b,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_ngt_f32_e64 exec_lo, -1
// GFX12: v_cmpx_ngt_f32_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x9b,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_ngt_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_ngt_f32_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x9b,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_ngt_f32_e64 null, exec_lo
// GFX12: v_cmpx_ngt_f32_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x9b,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_ngt_f32_e64 -1, exec_hi
// GFX12: v_cmpx_ngt_f32_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x9b,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_ngt_f32_e64 0.5, -m0
// GFX12: v_cmpx_ngt_f32_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x9b,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_ngt_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_ngt_f32_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x9b,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_ngt_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_ngt_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x9b,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_ngt_f64_e64 v[1:2], v[2:3]       ; encoding: [0x7e,0x00,0xab,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_ngt_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_ngt_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xab,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_ngt_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_ngt_f64_e64 s[2:3], s[4:5]       ; encoding: [0x7e,0x00,0xab,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_ngt_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_ngt_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xab,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_ngt_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_ngt_f64_e64 vcc, ttmp[14:15]     ; encoding: [0x7e,0x00,0xab,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_ngt_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_ngt_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xab,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_ngt_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_ngt_f64_e64 -|exec|, src_scc     ; encoding: [0x7e,0x01,0xab,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_ngt_f64_e64 null, 0.5
// GFX12: v_cmpx_ngt_f64_e64 null, 0.5            ; encoding: [0x7e,0x00,0xab,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_ngt_f64_e64 -1, -1
// GFX12: v_cmpx_ngt_f64_e64 -1, -1               ; encoding: [0x7e,0x00,0xab,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_ngt_f64_e64 0.5, null
// GFX12: v_cmpx_ngt_f64_e64 0.5, null            ; encoding: [0x7e,0x00,0xab,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_ngt_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_ngt_f64_e64 -|src_scc|, -|exec|  ; encoding: [0x7e,0x03,0xab,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_ngt_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_ngt_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xab,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_nle_f16_e64 v1.l, v2.l           ; encoding: [0x7e,0x00,0x8c,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_nle_f16_e64 v255.l, v255.l       ; encoding: [0x7e,0x00,0x8c,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nle_f16_e64 s1, s2
// GFX12: v_cmpx_nle_f16_e64 s1, s2               ; encoding: [0x7e,0x00,0x8c,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_nle_f16_e64 s105, s105
// GFX12: v_cmpx_nle_f16_e64 s105, s105           ; encoding: [0x7e,0x00,0x8c,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_nle_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_nle_f16_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x8c,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_nle_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_nle_f16_e64 vcc_hi, 0xfe0b       ; encoding: [0x7e,0x00,0x8c,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_nle_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_nle_f16_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x8c,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_nle_f16_e64 m0, 0.5
// GFX12: v_cmpx_nle_f16_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x8c,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_nle_f16_e64 exec_lo, -1
// GFX12: v_cmpx_nle_f16_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x8c,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_nle_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_nle_f16_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x8c,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_nle_f16_e64 null, exec_lo
// GFX12: v_cmpx_nle_f16_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x8c,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_nle_f16_e64 -1, exec_hi
// GFX12: v_cmpx_nle_f16_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x8c,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_nle_f16_e64 0.5, -m0
// GFX12: v_cmpx_nle_f16_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x8c,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_nle_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_nle_f16_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x8c,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_nle_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_nle_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x8c,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_nle_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_nle_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x8c,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nle_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_nle_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x8c,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nle_f32_e64 v1, v2
// GFX12: v_cmpx_nle_f32_e64 v1, v2               ; encoding: [0x7e,0x00,0x9c,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nle_f32_e64 v255, v255
// GFX12: v_cmpx_nle_f32_e64 v255, v255           ; encoding: [0x7e,0x00,0x9c,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nle_f32_e64 s1, s2
// GFX12: v_cmpx_nle_f32_e64 s1, s2               ; encoding: [0x7e,0x00,0x9c,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_nle_f32_e64 s105, s105
// GFX12: v_cmpx_nle_f32_e64 s105, s105           ; encoding: [0x7e,0x00,0x9c,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_nle_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_nle_f32_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x9c,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_nle_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_nle_f32_e64 vcc_hi, 0xaf123456   ; encoding: [0x7e,0x00,0x9c,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_nle_f32_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x9c,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_nle_f32_e64 m0, 0.5
// GFX12: v_cmpx_nle_f32_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x9c,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_nle_f32_e64 exec_lo, -1
// GFX12: v_cmpx_nle_f32_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x9c,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_nle_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_nle_f32_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x9c,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_nle_f32_e64 null, exec_lo
// GFX12: v_cmpx_nle_f32_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x9c,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_nle_f32_e64 -1, exec_hi
// GFX12: v_cmpx_nle_f32_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x9c,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_nle_f32_e64 0.5, -m0
// GFX12: v_cmpx_nle_f32_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x9c,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_nle_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_nle_f32_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x9c,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_nle_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_nle_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x9c,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_nle_f64_e64 v[1:2], v[2:3]       ; encoding: [0x7e,0x00,0xac,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nle_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_nle_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xac,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_nle_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_nle_f64_e64 s[2:3], s[4:5]       ; encoding: [0x7e,0x00,0xac,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_nle_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_nle_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xac,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_nle_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_nle_f64_e64 vcc, ttmp[14:15]     ; encoding: [0x7e,0x00,0xac,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_nle_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_nle_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xac,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_nle_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_nle_f64_e64 -|exec|, src_scc     ; encoding: [0x7e,0x01,0xac,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_nle_f64_e64 null, 0.5
// GFX12: v_cmpx_nle_f64_e64 null, 0.5            ; encoding: [0x7e,0x00,0xac,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_nle_f64_e64 -1, -1
// GFX12: v_cmpx_nle_f64_e64 -1, -1               ; encoding: [0x7e,0x00,0xac,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_nle_f64_e64 0.5, null
// GFX12: v_cmpx_nle_f64_e64 0.5, null            ; encoding: [0x7e,0x00,0xac,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_nle_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_nle_f64_e64 -|src_scc|, -|exec|  ; encoding: [0x7e,0x03,0xac,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_nle_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_nle_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xac,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_nlg_f16_e64 v1.l, v2.l           ; encoding: [0x7e,0x00,0x8a,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_nlg_f16_e64 v255.l, v255.l       ; encoding: [0x7e,0x00,0x8a,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nlg_f16_e64 s1, s2
// GFX12: v_cmpx_nlg_f16_e64 s1, s2               ; encoding: [0x7e,0x00,0x8a,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_nlg_f16_e64 s105, s105
// GFX12: v_cmpx_nlg_f16_e64 s105, s105           ; encoding: [0x7e,0x00,0x8a,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_nlg_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_nlg_f16_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x8a,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_nlg_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_nlg_f16_e64 vcc_hi, 0xfe0b       ; encoding: [0x7e,0x00,0x8a,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_nlg_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_nlg_f16_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x8a,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_nlg_f16_e64 m0, 0.5
// GFX12: v_cmpx_nlg_f16_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x8a,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_nlg_f16_e64 exec_lo, -1
// GFX12: v_cmpx_nlg_f16_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x8a,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_nlg_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_nlg_f16_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x8a,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_nlg_f16_e64 null, exec_lo
// GFX12: v_cmpx_nlg_f16_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x8a,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_nlg_f16_e64 -1, exec_hi
// GFX12: v_cmpx_nlg_f16_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x8a,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_nlg_f16_e64 0.5, -m0
// GFX12: v_cmpx_nlg_f16_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x8a,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_nlg_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_nlg_f16_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x8a,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_nlg_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_nlg_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x8a,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_nlg_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_nlg_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x8a,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_nlg_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x8a,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nlg_f32_e64 v1, v2
// GFX12: v_cmpx_nlg_f32_e64 v1, v2               ; encoding: [0x7e,0x00,0x9a,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f32_e64 v255, v255
// GFX12: v_cmpx_nlg_f32_e64 v255, v255           ; encoding: [0x7e,0x00,0x9a,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nlg_f32_e64 s1, s2
// GFX12: v_cmpx_nlg_f32_e64 s1, s2               ; encoding: [0x7e,0x00,0x9a,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_nlg_f32_e64 s105, s105
// GFX12: v_cmpx_nlg_f32_e64 s105, s105           ; encoding: [0x7e,0x00,0x9a,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_nlg_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_nlg_f32_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x9a,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_nlg_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_nlg_f32_e64 vcc_hi, 0xaf123456   ; encoding: [0x7e,0x00,0x9a,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_nlg_f32_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x9a,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_nlg_f32_e64 m0, 0.5
// GFX12: v_cmpx_nlg_f32_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x9a,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_nlg_f32_e64 exec_lo, -1
// GFX12: v_cmpx_nlg_f32_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x9a,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_nlg_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_nlg_f32_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x9a,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_nlg_f32_e64 null, exec_lo
// GFX12: v_cmpx_nlg_f32_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x9a,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_nlg_f32_e64 -1, exec_hi
// GFX12: v_cmpx_nlg_f32_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x9a,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_nlg_f32_e64 0.5, -m0
// GFX12: v_cmpx_nlg_f32_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x9a,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_nlg_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_nlg_f32_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x9a,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_nlg_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_nlg_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x9a,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_nlg_f64_e64 v[1:2], v[2:3]       ; encoding: [0x7e,0x00,0xaa,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlg_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_nlg_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xaa,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_nlg_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_nlg_f64_e64 s[2:3], s[4:5]       ; encoding: [0x7e,0x00,0xaa,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_nlg_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_nlg_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xaa,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_nlg_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_nlg_f64_e64 vcc, ttmp[14:15]     ; encoding: [0x7e,0x00,0xaa,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_nlg_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_nlg_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xaa,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_nlg_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_nlg_f64_e64 -|exec|, src_scc     ; encoding: [0x7e,0x01,0xaa,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_nlg_f64_e64 null, 0.5
// GFX12: v_cmpx_nlg_f64_e64 null, 0.5            ; encoding: [0x7e,0x00,0xaa,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_nlg_f64_e64 -1, -1
// GFX12: v_cmpx_nlg_f64_e64 -1, -1               ; encoding: [0x7e,0x00,0xaa,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_nlg_f64_e64 0.5, null
// GFX12: v_cmpx_nlg_f64_e64 0.5, null            ; encoding: [0x7e,0x00,0xaa,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_nlg_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_nlg_f64_e64 -|src_scc|, -|exec|  ; encoding: [0x7e,0x03,0xaa,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_nlg_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_nlg_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xaa,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_nlt_f16_e64 v1.l, v2.l           ; encoding: [0x7e,0x00,0x8e,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_nlt_f16_e64 v255.l, v255.l       ; encoding: [0x7e,0x00,0x8e,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nlt_f16_e64 s1, s2
// GFX12: v_cmpx_nlt_f16_e64 s1, s2               ; encoding: [0x7e,0x00,0x8e,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_nlt_f16_e64 s105, s105
// GFX12: v_cmpx_nlt_f16_e64 s105, s105           ; encoding: [0x7e,0x00,0x8e,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_nlt_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_nlt_f16_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x8e,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_nlt_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_nlt_f16_e64 vcc_hi, 0xfe0b       ; encoding: [0x7e,0x00,0x8e,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_nlt_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_nlt_f16_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x8e,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_nlt_f16_e64 m0, 0.5
// GFX12: v_cmpx_nlt_f16_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x8e,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_nlt_f16_e64 exec_lo, -1
// GFX12: v_cmpx_nlt_f16_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x8e,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_nlt_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_nlt_f16_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x8e,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_nlt_f16_e64 null, exec_lo
// GFX12: v_cmpx_nlt_f16_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x8e,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_nlt_f16_e64 -1, exec_hi
// GFX12: v_cmpx_nlt_f16_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x8e,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_nlt_f16_e64 0.5, -m0
// GFX12: v_cmpx_nlt_f16_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x8e,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_nlt_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_nlt_f16_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x8e,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_nlt_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_nlt_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x8e,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_nlt_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_nlt_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x8e,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_nlt_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x8e,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nlt_f32_e64 v1, v2
// GFX12: v_cmpx_nlt_f32_e64 v1, v2               ; encoding: [0x7e,0x00,0x9e,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f32_e64 v255, v255
// GFX12: v_cmpx_nlt_f32_e64 v255, v255           ; encoding: [0x7e,0x00,0x9e,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_nlt_f32_e64 s1, s2
// GFX12: v_cmpx_nlt_f32_e64 s1, s2               ; encoding: [0x7e,0x00,0x9e,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_nlt_f32_e64 s105, s105
// GFX12: v_cmpx_nlt_f32_e64 s105, s105           ; encoding: [0x7e,0x00,0x9e,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_nlt_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_nlt_f32_e64 vcc_lo, ttmp15       ; encoding: [0x7e,0x00,0x9e,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_nlt_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_nlt_f32_e64 vcc_hi, 0xaf123456   ; encoding: [0x7e,0x00,0x9e,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_nlt_f32_e64 ttmp15, src_scc      ; encoding: [0x7e,0x00,0x9e,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_nlt_f32_e64 m0, 0.5
// GFX12: v_cmpx_nlt_f32_e64 m0, 0.5              ; encoding: [0x7e,0x00,0x9e,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_nlt_f32_e64 exec_lo, -1
// GFX12: v_cmpx_nlt_f32_e64 exec_lo, -1          ; encoding: [0x7e,0x00,0x9e,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_nlt_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_nlt_f32_e64 |exec_hi|, null      ; encoding: [0x7e,0x01,0x9e,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_nlt_f32_e64 null, exec_lo
// GFX12: v_cmpx_nlt_f32_e64 null, exec_lo        ; encoding: [0x7e,0x00,0x9e,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_nlt_f32_e64 -1, exec_hi
// GFX12: v_cmpx_nlt_f32_e64 -1, exec_hi          ; encoding: [0x7e,0x00,0x9e,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_nlt_f32_e64 0.5, -m0
// GFX12: v_cmpx_nlt_f32_e64 0.5, -m0             ; encoding: [0x7e,0x00,0x9e,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_nlt_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_nlt_f32_e64 -src_scc, |vcc_lo|   ; encoding: [0x7e,0x02,0x9e,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_nlt_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_nlt_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x9e,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_nlt_f64_e64 v[1:2], v[2:3]       ; encoding: [0x7e,0x00,0xae,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_nlt_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_nlt_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xae,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_nlt_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_nlt_f64_e64 s[2:3], s[4:5]       ; encoding: [0x7e,0x00,0xae,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_nlt_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_nlt_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xae,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_nlt_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_nlt_f64_e64 vcc, ttmp[14:15]     ; encoding: [0x7e,0x00,0xae,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_nlt_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_nlt_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xae,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_nlt_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_nlt_f64_e64 -|exec|, src_scc     ; encoding: [0x7e,0x01,0xae,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_nlt_f64_e64 null, 0.5
// GFX12: v_cmpx_nlt_f64_e64 null, 0.5            ; encoding: [0x7e,0x00,0xae,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_nlt_f64_e64 -1, -1
// GFX12: v_cmpx_nlt_f64_e64 -1, -1               ; encoding: [0x7e,0x00,0xae,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_nlt_f64_e64 0.5, null
// GFX12: v_cmpx_nlt_f64_e64 0.5, null            ; encoding: [0x7e,0x00,0xae,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_nlt_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_nlt_f64_e64 -|src_scc|, -|exec|  ; encoding: [0x7e,0x03,0xae,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_nlt_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_nlt_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xae,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_o_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_o_f16_e64 v1.l, v2.l             ; encoding: [0x7e,0x00,0x87,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_o_f16_e64 v255.l, v255.l         ; encoding: [0x7e,0x00,0x87,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_o_f16_e64 s1, s2
// GFX12: v_cmpx_o_f16_e64 s1, s2                 ; encoding: [0x7e,0x00,0x87,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_o_f16_e64 s105, s105
// GFX12: v_cmpx_o_f16_e64 s105, s105             ; encoding: [0x7e,0x00,0x87,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_o_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_o_f16_e64 vcc_lo, ttmp15         ; encoding: [0x7e,0x00,0x87,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_o_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_o_f16_e64 vcc_hi, 0xfe0b         ; encoding: [0x7e,0x00,0x87,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_o_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_o_f16_e64 ttmp15, src_scc        ; encoding: [0x7e,0x00,0x87,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_o_f16_e64 m0, 0.5
// GFX12: v_cmpx_o_f16_e64 m0, 0.5                ; encoding: [0x7e,0x00,0x87,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_o_f16_e64 exec_lo, -1
// GFX12: v_cmpx_o_f16_e64 exec_lo, -1            ; encoding: [0x7e,0x00,0x87,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_o_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_o_f16_e64 |exec_hi|, null        ; encoding: [0x7e,0x01,0x87,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_o_f16_e64 null, exec_lo
// GFX12: v_cmpx_o_f16_e64 null, exec_lo          ; encoding: [0x7e,0x00,0x87,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_o_f16_e64 -1, exec_hi
// GFX12: v_cmpx_o_f16_e64 -1, exec_hi            ; encoding: [0x7e,0x00,0x87,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_o_f16_e64 0.5, -m0
// GFX12: v_cmpx_o_f16_e64 0.5, -m0               ; encoding: [0x7e,0x00,0x87,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_o_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_o_f16_e64 -src_scc, |vcc_lo|     ; encoding: [0x7e,0x02,0x87,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_o_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_o_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x87,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_o_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_o_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x87,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_o_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_o_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x87,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_o_f32_e64 v1, v2
// GFX12: v_cmpx_o_f32_e64 v1, v2                 ; encoding: [0x7e,0x00,0x97,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_o_f32_e64 v255, v255
// GFX12: v_cmpx_o_f32_e64 v255, v255             ; encoding: [0x7e,0x00,0x97,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_o_f32_e64 s1, s2
// GFX12: v_cmpx_o_f32_e64 s1, s2                 ; encoding: [0x7e,0x00,0x97,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_o_f32_e64 s105, s105
// GFX12: v_cmpx_o_f32_e64 s105, s105             ; encoding: [0x7e,0x00,0x97,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_o_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_o_f32_e64 vcc_lo, ttmp15         ; encoding: [0x7e,0x00,0x97,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_o_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_o_f32_e64 vcc_hi, 0xaf123456     ; encoding: [0x7e,0x00,0x97,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_o_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_o_f32_e64 ttmp15, src_scc        ; encoding: [0x7e,0x00,0x97,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_o_f32_e64 m0, 0.5
// GFX12: v_cmpx_o_f32_e64 m0, 0.5                ; encoding: [0x7e,0x00,0x97,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_o_f32_e64 exec_lo, -1
// GFX12: v_cmpx_o_f32_e64 exec_lo, -1            ; encoding: [0x7e,0x00,0x97,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_o_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_o_f32_e64 |exec_hi|, null        ; encoding: [0x7e,0x01,0x97,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_o_f32_e64 null, exec_lo
// GFX12: v_cmpx_o_f32_e64 null, exec_lo          ; encoding: [0x7e,0x00,0x97,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_o_f32_e64 -1, exec_hi
// GFX12: v_cmpx_o_f32_e64 -1, exec_hi            ; encoding: [0x7e,0x00,0x97,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_o_f32_e64 0.5, -m0
// GFX12: v_cmpx_o_f32_e64 0.5, -m0               ; encoding: [0x7e,0x00,0x97,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_o_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_o_f32_e64 -src_scc, |vcc_lo|     ; encoding: [0x7e,0x02,0x97,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_o_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_o_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x97,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_o_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_o_f64_e64 v[1:2], v[2:3]         ; encoding: [0x7e,0x00,0xa7,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_o_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_o_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xa7,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_o_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_o_f64_e64 s[2:3], s[4:5]         ; encoding: [0x7e,0x00,0xa7,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_o_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_o_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xa7,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_o_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_o_f64_e64 vcc, ttmp[14:15]       ; encoding: [0x7e,0x00,0xa7,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_o_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_o_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xa7,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_o_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_o_f64_e64 -|exec|, src_scc       ; encoding: [0x7e,0x01,0xa7,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_o_f64_e64 null, 0.5
// GFX12: v_cmpx_o_f64_e64 null, 0.5              ; encoding: [0x7e,0x00,0xa7,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_o_f64_e64 -1, -1
// GFX12: v_cmpx_o_f64_e64 -1, -1                 ; encoding: [0x7e,0x00,0xa7,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_o_f64_e64 0.5, null
// GFX12: v_cmpx_o_f64_e64 0.5, null              ; encoding: [0x7e,0x00,0xa7,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_o_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_o_f64_e64 -|src_scc|, -|exec|    ; encoding: [0x7e,0x03,0xa7,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_o_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_o_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xa7,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]

v_cmpx_u_f16_e64 v1.l, v2.l
// GFX12: v_cmpx_u_f16_e64 v1.l, v2.l             ; encoding: [0x7e,0x00,0x88,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 v255.l, v255.l
// GFX12: v_cmpx_u_f16_e64 v255.l, v255.l         ; encoding: [0x7e,0x00,0x88,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_u_f16_e64 s1, s2
// GFX12: v_cmpx_u_f16_e64 s1, s2                 ; encoding: [0x7e,0x00,0x88,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_u_f16_e64 s105, s105
// GFX12: v_cmpx_u_f16_e64 s105, s105             ; encoding: [0x7e,0x00,0x88,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_u_f16_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_u_f16_e64 vcc_lo, ttmp15         ; encoding: [0x7e,0x00,0x88,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_u_f16_e64 vcc_hi, 0xfe0b
// GFX12: v_cmpx_u_f16_e64 vcc_hi, 0xfe0b         ; encoding: [0x7e,0x00,0x88,0xd4,0x6b,0xfe,0x01,0x00,0x0b,0xfe,0x00,0x00]

v_cmpx_u_f16_e64 ttmp15, src_scc
// GFX12: v_cmpx_u_f16_e64 ttmp15, src_scc        ; encoding: [0x7e,0x00,0x88,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_u_f16_e64 m0, 0.5
// GFX12: v_cmpx_u_f16_e64 m0, 0.5                ; encoding: [0x7e,0x00,0x88,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_u_f16_e64 exec_lo, -1
// GFX12: v_cmpx_u_f16_e64 exec_lo, -1            ; encoding: [0x7e,0x00,0x88,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_u_f16_e64 |exec_hi|, null
// GFX12: v_cmpx_u_f16_e64 |exec_hi|, null        ; encoding: [0x7e,0x01,0x88,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_u_f16_e64 null, exec_lo
// GFX12: v_cmpx_u_f16_e64 null, exec_lo          ; encoding: [0x7e,0x00,0x88,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_u_f16_e64 -1, exec_hi
// GFX12: v_cmpx_u_f16_e64 -1, exec_hi            ; encoding: [0x7e,0x00,0x88,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_u_f16_e64 0.5, -m0
// GFX12: v_cmpx_u_f16_e64 0.5, -m0               ; encoding: [0x7e,0x00,0x88,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_u_f16_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_u_f16_e64 -src_scc, |vcc_lo|     ; encoding: [0x7e,0x02,0x88,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_u_f16_e64 -|0xfe0b|, -|vcc_hi| clamp
// GFX12: v_cmpx_u_f16_e64 -|0xfe0b|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x88,0xd4,0xff,0xd6,0x00,0x60,0x0b,0xfe,0x00,0x00]

v_cmpx_u_f16_e64 v1.h, v2.l
// GFX12: v_cmpx_u_f16_e64 v1.h, v2.l op_sel:[1,0] ; encoding: [0x7e,0x08,0x88,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_u_f16_e64 v255.l, v255.h
// GFX12: v_cmpx_u_f16_e64 v255.l, v255.h op_sel:[0,1] ; encoding: [0x7e,0x10,0x88,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_u_f32_e64 v1, v2
// GFX12: v_cmpx_u_f32_e64 v1, v2                 ; encoding: [0x7e,0x00,0x98,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_u_f32_e64 v255, v255
// GFX12: v_cmpx_u_f32_e64 v255, v255             ; encoding: [0x7e,0x00,0x98,0xd4,0xff,0xff,0x03,0x00]

v_cmpx_u_f32_e64 s1, s2
// GFX12: v_cmpx_u_f32_e64 s1, s2                 ; encoding: [0x7e,0x00,0x98,0xd4,0x01,0x04,0x00,0x00]

v_cmpx_u_f32_e64 s105, s105
// GFX12: v_cmpx_u_f32_e64 s105, s105             ; encoding: [0x7e,0x00,0x98,0xd4,0x69,0xd2,0x00,0x00]

v_cmpx_u_f32_e64 vcc_lo, ttmp15
// GFX12: v_cmpx_u_f32_e64 vcc_lo, ttmp15         ; encoding: [0x7e,0x00,0x98,0xd4,0x6a,0xf6,0x00,0x00]

v_cmpx_u_f32_e64 vcc_hi, 0xaf123456
// GFX12: v_cmpx_u_f32_e64 vcc_hi, 0xaf123456     ; encoding: [0x7e,0x00,0x98,0xd4,0x6b,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_u_f32_e64 ttmp15, src_scc
// GFX12: v_cmpx_u_f32_e64 ttmp15, src_scc        ; encoding: [0x7e,0x00,0x98,0xd4,0x7b,0xfa,0x01,0x00]

v_cmpx_u_f32_e64 m0, 0.5
// GFX12: v_cmpx_u_f32_e64 m0, 0.5                ; encoding: [0x7e,0x00,0x98,0xd4,0x7d,0xe0,0x01,0x00]

v_cmpx_u_f32_e64 exec_lo, -1
// GFX12: v_cmpx_u_f32_e64 exec_lo, -1            ; encoding: [0x7e,0x00,0x98,0xd4,0x7e,0x82,0x01,0x00]

v_cmpx_u_f32_e64 |exec_hi|, null
// GFX12: v_cmpx_u_f32_e64 |exec_hi|, null        ; encoding: [0x7e,0x01,0x98,0xd4,0x7f,0xf8,0x00,0x00]

v_cmpx_u_f32_e64 null, exec_lo
// GFX12: v_cmpx_u_f32_e64 null, exec_lo          ; encoding: [0x7e,0x00,0x98,0xd4,0x7c,0xfc,0x00,0x00]

v_cmpx_u_f32_e64 -1, exec_hi
// GFX12: v_cmpx_u_f32_e64 -1, exec_hi            ; encoding: [0x7e,0x00,0x98,0xd4,0xc1,0xfe,0x00,0x00]

v_cmpx_u_f32_e64 0.5, -m0
// GFX12: v_cmpx_u_f32_e64 0.5, -m0               ; encoding: [0x7e,0x00,0x98,0xd4,0xf0,0xfa,0x00,0x40]

v_cmpx_u_f32_e64 -src_scc, |vcc_lo|
// GFX12: v_cmpx_u_f32_e64 -src_scc, |vcc_lo|     ; encoding: [0x7e,0x02,0x98,0xd4,0xfd,0xd4,0x00,0x20]

v_cmpx_u_f32_e64 -|0xaf123456|, -|vcc_hi| clamp
// GFX12: v_cmpx_u_f32_e64 -|0xaf123456|, -|vcc_hi| clamp ; encoding: [0x7e,0x83,0x98,0xd4,0xff,0xd6,0x00,0x60,0x56,0x34,0x12,0xaf]

v_cmpx_u_f64_e64 v[1:2], v[2:3]
// GFX12: v_cmpx_u_f64_e64 v[1:2], v[2:3]         ; encoding: [0x7e,0x00,0xa8,0xd4,0x01,0x05,0x02,0x00]

v_cmpx_u_f64_e64 v[254:255], v[254:255]
// GFX12: v_cmpx_u_f64_e64 v[254:255], v[254:255] ; encoding: [0x7e,0x00,0xa8,0xd4,0xfe,0xfd,0x03,0x00]

v_cmpx_u_f64_e64 s[2:3], s[4:5]
// GFX12: v_cmpx_u_f64_e64 s[2:3], s[4:5]         ; encoding: [0x7e,0x00,0xa8,0xd4,0x02,0x08,0x00,0x00]

v_cmpx_u_f64_e64 s[104:105], s[104:105]
// GFX12: v_cmpx_u_f64_e64 s[104:105], s[104:105] ; encoding: [0x7e,0x00,0xa8,0xd4,0x68,0xd0,0x00,0x00]

v_cmpx_u_f64_e64 vcc, ttmp[14:15]
// GFX12: v_cmpx_u_f64_e64 vcc, ttmp[14:15]       ; encoding: [0x7e,0x00,0xa8,0xd4,0x6a,0xf4,0x00,0x00]

v_cmpx_u_f64_e64 ttmp[14:15], 0xaf123456
// GFX12: v_cmpx_u_f64_e64 ttmp[14:15], 0xaf123456 ; encoding: [0x7e,0x00,0xa8,0xd4,0x7a,0xfe,0x01,0x00,0x56,0x34,0x12,0xaf]

v_cmpx_u_f64_e64 -|exec|, src_scc
// GFX12: v_cmpx_u_f64_e64 -|exec|, src_scc       ; encoding: [0x7e,0x01,0xa8,0xd4,0x7e,0xfa,0x01,0x20]

v_cmpx_u_f64_e64 null, 0.5
// GFX12: v_cmpx_u_f64_e64 null, 0.5              ; encoding: [0x7e,0x00,0xa8,0xd4,0x7c,0xe0,0x01,0x00]

v_cmpx_u_f64_e64 -1, -1
// GFX12: v_cmpx_u_f64_e64 -1, -1                 ; encoding: [0x7e,0x00,0xa8,0xd4,0xc1,0x82,0x01,0x00]

v_cmpx_u_f64_e64 0.5, null
// GFX12: v_cmpx_u_f64_e64 0.5, null              ; encoding: [0x7e,0x00,0xa8,0xd4,0xf0,0xf8,0x00,0x00]

v_cmpx_u_f64_e64 -|src_scc|, -|exec|
// GFX12: v_cmpx_u_f64_e64 -|src_scc|, -|exec|    ; encoding: [0x7e,0x03,0xa8,0xd4,0xfd,0xfc,0x00,0x60]

v_cmpx_u_f64_e64 0xaf123456, -|vcc| clamp
// GFX12: v_cmpx_u_f64_e64 0xaf123456, -|vcc| clamp ; encoding: [0x7e,0x82,0xa8,0xd4,0xff,0xd4,0x00,0x40,0x56,0x34,0x12,0xaf]
