; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+zvkg \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+zvkg \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK

declare <vscale x 1 x i32> @llvm.riscv.vgmul.vv.nxv1i32(
  <vscale x 1 x i32>,
  <vscale x 1 x i32>,
  iXLen, iXLen);

define <vscale x 1 x i32> @intrinsic_vgmul_vs_nxv1i32(<vscale x 1 x i32> %0, <vscale x 1 x i32> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vgmul_vs_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    vgmul.vv v8, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i32> @llvm.riscv.vgmul.vv.nxv1i32(
    <vscale x 1 x i32> %0,
    <vscale x 1 x i32> %1,
    iXLen %2, iXLen 2)

  ret <vscale x 1 x i32> %a
}

declare <vscale x 2 x i32> @llvm.riscv.vgmul.vv.nxv2i32(
  <vscale x 2 x i32>,
  <vscale x 2 x i32>,
  iXLen, iXLen);

define <vscale x 2 x i32> @intrinsic_vgmul_vs_nxv2i32(<vscale x 2 x i32> %0, <vscale x 2 x i32> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vgmul_vs_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    vgmul.vv v8, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i32> @llvm.riscv.vgmul.vv.nxv2i32(
    <vscale x 2 x i32> %0,
    <vscale x 2 x i32> %1,
    iXLen %2, iXLen 2)

  ret <vscale x 2 x i32> %a
}

declare <vscale x 4 x i32> @llvm.riscv.vgmul.vv.nxv4i32(
  <vscale x 4 x i32>,
  <vscale x 4 x i32>,
  iXLen, iXLen);

define <vscale x 4 x i32> @intrinsic_vgmul_vs_nxv4i32(<vscale x 4 x i32> %0, <vscale x 4 x i32> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vgmul_vs_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    vgmul.vv v8, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i32> @llvm.riscv.vgmul.vv.nxv4i32(
    <vscale x 4 x i32> %0,
    <vscale x 4 x i32> %1,
    iXLen %2, iXLen 2)

  ret <vscale x 4 x i32> %a
}

declare <vscale x 8 x i32> @llvm.riscv.vgmul.vv.nxv8i32(
  <vscale x 8 x i32>,
  <vscale x 8 x i32>,
  iXLen, iXLen);

define <vscale x 8 x i32> @intrinsic_vgmul_vs_nxv8i32(<vscale x 8 x i32> %0, <vscale x 8 x i32> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vgmul_vs_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    vgmul.vv v8, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i32> @llvm.riscv.vgmul.vv.nxv8i32(
    <vscale x 8 x i32> %0,
    <vscale x 8 x i32> %1,
    iXLen %2, iXLen 2)

  ret <vscale x 8 x i32> %a
}

declare <vscale x 16 x i32> @llvm.riscv.vgmul.vv.nxv16i32(
  <vscale x 16 x i32>,
  <vscale x 16 x i32>,
  iXLen, iXLen);

define <vscale x 16 x i32> @intrinsic_vgmul_vs_nxv16i32(<vscale x 16 x i32> %0, <vscale x 16 x i32> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vgmul_vs_nxv16i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m8, tu, ma
; CHECK-NEXT:    vgmul.vv v8, v16
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i32> @llvm.riscv.vgmul.vv.nxv16i32(
    <vscale x 16 x i32> %0,
    <vscale x 16 x i32> %1,
    iXLen %2, iXLen 2)

  ret <vscale x 16 x i32> %a
}
