/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



#ifdef GLATTER_EGL
#if defined(__egl_h_)
#if defined(EGL_VERSION_1_0)
#ifndef eglChooseConfig_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglChooseConfig, (dpy, attrib_list, configs, config_size, num_config), (EGLDisplay dpy, const EGLint *attrib_list, EGLConfig *configs, EGLint config_size, EGLint *num_config))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglChooseConfig_debug(EGLDisplay dpy, const EGLint *attrib_list, EGLConfig *configs, EGLint config_size, EGLint *num_config, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglChooseConfig, "(%p, %p, %p, %s, %p)", (void*)dpy, (void*)attrib_list, (void*)configs, GET_PRS(config_size), (void*)num_config)
    EGLBoolean rval = glatter_eglChooseConfig(dpy, attrib_list, configs, config_size, num_config);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglChooseConfig_defined
#endif
#ifndef eglCopyBuffers_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglCopyBuffers, (dpy, surface, target), (EGLDisplay dpy, EGLSurface surface, EGLNativePixmapType target))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglCopyBuffers_debug(EGLDisplay dpy, EGLSurface surface, EGLNativePixmapType target, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCopyBuffers, "(%p, %p, %s)", (void*)dpy, (void*)surface, GET_PRS(target))
    EGLBoolean rval = glatter_eglCopyBuffers(dpy, surface, target);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCopyBuffers_defined
#endif
#ifndef eglCreateContext_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLContext, EGLAPIENTRY, eglCreateContext, (dpy, config, share_context, attrib_list), (EGLDisplay dpy, EGLConfig config, EGLContext share_context, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLContext glatter_eglCreateContext_debug(EGLDisplay dpy, EGLConfig config, EGLContext share_context, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateContext, "(%p, %p, %p, %p)", (void*)dpy, (void*)config, (void*)share_context, (void*)attrib_list)
    EGLContext rval = glatter_eglCreateContext(dpy, config, share_context, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateContext_defined
#endif
#ifndef eglCreatePbufferSurface_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreatePbufferSurface, (dpy, config, attrib_list), (EGLDisplay dpy, EGLConfig config, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreatePbufferSurface_debug(EGLDisplay dpy, EGLConfig config, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreatePbufferSurface, "(%p, %p, %p)", (void*)dpy, (void*)config, (void*)attrib_list)
    EGLSurface rval = glatter_eglCreatePbufferSurface(dpy, config, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreatePbufferSurface_defined
#endif
#ifndef eglCreatePixmapSurface_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreatePixmapSurface, (dpy, config, pixmap, attrib_list), (EGLDisplay dpy, EGLConfig config, EGLNativePixmapType pixmap, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreatePixmapSurface_debug(EGLDisplay dpy, EGLConfig config, EGLNativePixmapType pixmap, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreatePixmapSurface, "(%p, %p, %s, %p)", (void*)dpy, (void*)config, GET_PRS(pixmap), (void*)attrib_list)
    EGLSurface rval = glatter_eglCreatePixmapSurface(dpy, config, pixmap, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreatePixmapSurface_defined
#endif
#ifndef eglCreateWindowSurface_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreateWindowSurface, (dpy, config, win, attrib_list), (EGLDisplay dpy, EGLConfig config, EGLNativeWindowType win, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreateWindowSurface_debug(EGLDisplay dpy, EGLConfig config, EGLNativeWindowType win, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateWindowSurface, "(%p, %p, %s, %p)", (void*)dpy, (void*)config, GET_PRS(win), (void*)attrib_list)
    EGLSurface rval = glatter_eglCreateWindowSurface(dpy, config, win, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateWindowSurface_defined
#endif
#ifndef eglDestroyContext_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglDestroyContext, (dpy, ctx), (EGLDisplay dpy, EGLContext ctx))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglDestroyContext_debug(EGLDisplay dpy, EGLContext ctx, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDestroyContext, "(%p, %p)", (void*)dpy, (void*)ctx)
    EGLBoolean rval = glatter_eglDestroyContext(dpy, ctx);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDestroyContext_defined
#endif
#ifndef eglDestroySurface_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglDestroySurface, (dpy, surface), (EGLDisplay dpy, EGLSurface surface))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglDestroySurface_debug(EGLDisplay dpy, EGLSurface surface, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDestroySurface, "(%p, %p)", (void*)dpy, (void*)surface)
    EGLBoolean rval = glatter_eglDestroySurface(dpy, surface);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDestroySurface_defined
#endif
#ifndef eglGetConfigAttrib_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglGetConfigAttrib, (dpy, config, attribute, value), (EGLDisplay dpy, EGLConfig config, EGLint attribute, EGLint *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglGetConfigAttrib_debug(EGLDisplay dpy, EGLConfig config, EGLint attribute, EGLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetConfigAttrib, "(%p, %p, %s, %p)", (void*)dpy, (void*)config, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglGetConfigAttrib(dpy, config, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetConfigAttrib_defined
#endif
#ifndef eglGetConfigs_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglGetConfigs, (dpy, configs, config_size, num_config), (EGLDisplay dpy, EGLConfig *configs, EGLint config_size, EGLint *num_config))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglGetConfigs_debug(EGLDisplay dpy, EGLConfig *configs, EGLint config_size, EGLint *num_config, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetConfigs, "(%p, %p, %s, %p)", (void*)dpy, (void*)configs, GET_PRS(config_size), (void*)num_config)
    EGLBoolean rval = glatter_eglGetConfigs(dpy, configs, config_size, num_config);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetConfigs_defined
#endif
#ifndef eglGetCurrentDisplay_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLDisplay, EGLAPIENTRY, eglGetCurrentDisplay, (), (void))
GLATTER_INLINE_OR_NOT EGLDisplay glatter_eglGetCurrentDisplay_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetCurrentDisplay, "()")
    EGLDisplay rval = glatter_eglGetCurrentDisplay();
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetCurrentDisplay_defined
#endif
#ifndef eglGetCurrentSurface_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglGetCurrentSurface, (readdraw), (EGLint readdraw))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglGetCurrentSurface_debug(EGLint readdraw, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetCurrentSurface, "(%s)", GET_PRS(readdraw))
    EGLSurface rval = glatter_eglGetCurrentSurface(readdraw);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetCurrentSurface_defined
#endif
#ifndef eglGetDisplay_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLDisplay, EGLAPIENTRY, eglGetDisplay, (display_id), (EGLNativeDisplayType display_id))
GLATTER_INLINE_OR_NOT EGLDisplay glatter_eglGetDisplay_debug(EGLNativeDisplayType display_id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetDisplay, "(%s)", GET_PRS(display_id))
    EGLDisplay rval = glatter_eglGetDisplay(display_id);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetDisplay_defined
#endif
#ifndef eglGetError_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLint, EGLAPIENTRY, eglGetError, (), (void))
GLATTER_INLINE_OR_NOT EGLint glatter_eglGetError_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetError, "()")
    EGLint rval = glatter_eglGetError();
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetError_defined
#endif
#ifndef eglGetProcAddress_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, __eglMustCastToProperFunctionPointerType, EGLAPIENTRY, eglGetProcAddress, (procname), (const char *procname))
GLATTER_INLINE_OR_NOT __eglMustCastToProperFunctionPointerType glatter_eglGetProcAddress_debug(const char *procname, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetProcAddress, "(%p)", (void*)procname)
    __eglMustCastToProperFunctionPointerType rval = glatter_eglGetProcAddress(procname);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetProcAddress_defined
#endif
#ifndef eglInitialize_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglInitialize, (dpy, major, minor), (EGLDisplay dpy, EGLint *major, EGLint *minor))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglInitialize_debug(EGLDisplay dpy, EGLint *major, EGLint *minor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglInitialize, "(%p, %p, %p)", (void*)dpy, (void*)major, (void*)minor)
    EGLBoolean rval = glatter_eglInitialize(dpy, major, minor);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglInitialize_defined
#endif
#ifndef eglMakeCurrent_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglMakeCurrent, (dpy, draw, read, ctx), (EGLDisplay dpy, EGLSurface draw, EGLSurface read, EGLContext ctx))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglMakeCurrent_debug(EGLDisplay dpy, EGLSurface draw, EGLSurface read, EGLContext ctx, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglMakeCurrent, "(%p, %p, %p, %p)", (void*)dpy, (void*)draw, (void*)read, (void*)ctx)
    EGLBoolean rval = glatter_eglMakeCurrent(dpy, draw, read, ctx);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglMakeCurrent_defined
#endif
#ifndef eglQueryContext_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryContext, (dpy, ctx, attribute, value), (EGLDisplay dpy, EGLContext ctx, EGLint attribute, EGLint *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryContext_debug(EGLDisplay dpy, EGLContext ctx, EGLint attribute, EGLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryContext, "(%p, %p, %s, %p)", (void*)dpy, (void*)ctx, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryContext(dpy, ctx, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryContext_defined
#endif
#ifndef eglQueryString_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, const char *, EGLAPIENTRY, eglQueryString, (dpy, name), (EGLDisplay dpy, EGLint name))
GLATTER_INLINE_OR_NOT const char * glatter_eglQueryString_debug(EGLDisplay dpy, EGLint name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryString, "(%p, %s)", (void*)dpy, GET_PRS(name))
    const char * rval = glatter_eglQueryString(dpy, name);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryString_defined
#endif
#ifndef eglQuerySurface_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQuerySurface, (dpy, surface, attribute, value), (EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQuerySurface_debug(EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQuerySurface, "(%p, %p, %s, %p)", (void*)dpy, (void*)surface, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQuerySurface(dpy, surface, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQuerySurface_defined
#endif
#ifndef eglSwapBuffers_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSwapBuffers, (dpy, surface), (EGLDisplay dpy, EGLSurface surface))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSwapBuffers_debug(EGLDisplay dpy, EGLSurface surface, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSwapBuffers, "(%p, %p)", (void*)dpy, (void*)surface)
    EGLBoolean rval = glatter_eglSwapBuffers(dpy, surface);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSwapBuffers_defined
#endif
#ifndef eglTerminate_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglTerminate, (dpy), (EGLDisplay dpy))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglTerminate_debug(EGLDisplay dpy, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglTerminate, "(%p)", (void*)dpy)
    EGLBoolean rval = glatter_eglTerminate(dpy);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglTerminate_defined
#endif
#ifndef eglWaitGL_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglWaitGL, (), (void))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglWaitGL_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglWaitGL, "()")
    EGLBoolean rval = glatter_eglWaitGL();
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglWaitGL_defined
#endif
#ifndef eglWaitNative_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglWaitNative, (engine), (EGLint engine))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglWaitNative_debug(EGLint engine, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglWaitNative, "(%s)", GET_PRS(engine))
    EGLBoolean rval = glatter_eglWaitNative(engine);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglWaitNative_defined
#endif
#endif // defined(EGL_VERSION_1_0)
#if defined(EGL_VERSION_1_1)
#ifndef eglBindTexImage_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglBindTexImage, (dpy, surface, buffer), (EGLDisplay dpy, EGLSurface surface, EGLint buffer))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglBindTexImage_debug(EGLDisplay dpy, EGLSurface surface, EGLint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglBindTexImage, "(%p, %p, %s)", (void*)dpy, (void*)surface, GET_PRS(buffer))
    EGLBoolean rval = glatter_eglBindTexImage(dpy, surface, buffer);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglBindTexImage_defined
#endif
#ifndef eglReleaseTexImage_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglReleaseTexImage, (dpy, surface, buffer), (EGLDisplay dpy, EGLSurface surface, EGLint buffer))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglReleaseTexImage_debug(EGLDisplay dpy, EGLSurface surface, EGLint buffer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglReleaseTexImage, "(%p, %p, %s)", (void*)dpy, (void*)surface, GET_PRS(buffer))
    EGLBoolean rval = glatter_eglReleaseTexImage(dpy, surface, buffer);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglReleaseTexImage_defined
#endif
#ifndef eglSurfaceAttrib_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSurfaceAttrib, (dpy, surface, attribute, value), (EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSurfaceAttrib_debug(EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSurfaceAttrib, "(%p, %p, %s, %s)", (void*)dpy, (void*)surface, GET_PRS(attribute), GET_PRS(value))
    EGLBoolean rval = glatter_eglSurfaceAttrib(dpy, surface, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSurfaceAttrib_defined
#endif
#ifndef eglSwapInterval_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSwapInterval, (dpy, interval), (EGLDisplay dpy, EGLint interval))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSwapInterval_debug(EGLDisplay dpy, EGLint interval, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSwapInterval, "(%p, %s)", (void*)dpy, GET_PRS(interval))
    EGLBoolean rval = glatter_eglSwapInterval(dpy, interval);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSwapInterval_defined
#endif
#endif // defined(EGL_VERSION_1_1)
#if defined(EGL_VERSION_1_2)
#ifndef eglBindAPI_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglBindAPI, (api), (EGLenum api))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglBindAPI_debug(EGLenum api, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglBindAPI, "(%s)", enum_to_string_EGL(api))
    EGLBoolean rval = glatter_eglBindAPI(api);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglBindAPI_defined
#endif
#ifndef eglCreatePbufferFromClientBuffer_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreatePbufferFromClientBuffer, (dpy, buftype, buffer, config, attrib_list), (EGLDisplay dpy, EGLenum buftype, EGLClientBuffer buffer, EGLConfig config, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreatePbufferFromClientBuffer_debug(EGLDisplay dpy, EGLenum buftype, EGLClientBuffer buffer, EGLConfig config, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreatePbufferFromClientBuffer, "(%p, %s, %p, %p, %p)", (void*)dpy, enum_to_string_EGL(buftype), (void*)buffer, (void*)config, (void*)attrib_list)
    EGLSurface rval = glatter_eglCreatePbufferFromClientBuffer(dpy, buftype, buffer, config, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreatePbufferFromClientBuffer_defined
#endif
#ifndef eglQueryAPI_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLenum, EGLAPIENTRY, eglQueryAPI, (), (void))
GLATTER_INLINE_OR_NOT EGLenum glatter_eglQueryAPI_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryAPI, "()")
    EGLenum rval = glatter_eglQueryAPI();
    GLATTER_RBLOCK("%s\n", enum_to_string_EGL(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryAPI_defined
#endif
#ifndef eglReleaseThread_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglReleaseThread, (), (void))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglReleaseThread_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglReleaseThread, "()")
    EGLBoolean rval = glatter_eglReleaseThread();
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglReleaseThread_defined
#endif
#ifndef eglWaitClient_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglWaitClient, (), (void))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglWaitClient_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglWaitClient, "()")
    EGLBoolean rval = glatter_eglWaitClient();
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglWaitClient_defined
#endif
#endif // defined(EGL_VERSION_1_2)
#if defined(EGL_VERSION_1_4)
#ifndef eglGetCurrentContext_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLContext, EGLAPIENTRY, eglGetCurrentContext, (), (void))
GLATTER_INLINE_OR_NOT EGLContext glatter_eglGetCurrentContext_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetCurrentContext, "()")
    EGLContext rval = glatter_eglGetCurrentContext();
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetCurrentContext_defined
#endif
#endif // defined(EGL_VERSION_1_4)
#if defined(EGL_VERSION_1_5)
#ifndef eglClientWaitSync_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLint, EGLAPIENTRY, eglClientWaitSync, (dpy, sync, flags, timeout), (EGLDisplay dpy, EGLSync sync, EGLint flags, EGLTime timeout))
GLATTER_INLINE_OR_NOT EGLint glatter_eglClientWaitSync_debug(EGLDisplay dpy, EGLSync sync, EGLint flags, EGLTime timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglClientWaitSync, "(%p, %p, %s, %s)", (void*)dpy, (void*)sync, GET_PRS(flags), GET_PRS(timeout))
    EGLint rval = glatter_eglClientWaitSync(dpy, sync, flags, timeout);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglClientWaitSync_defined
#endif
#ifndef eglCreateImage_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLImage, EGLAPIENTRY, eglCreateImage, (dpy, ctx, target, buffer, attrib_list), (EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLImage glatter_eglCreateImage_debug(EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateImage, "(%p, %p, %s, %p, %p)", (void*)dpy, (void*)ctx, enum_to_string_EGL(target), (void*)buffer, (void*)attrib_list)
    EGLImage rval = glatter_eglCreateImage(dpy, ctx, target, buffer, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateImage_defined
#endif
#ifndef eglCreatePlatformPixmapSurface_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreatePlatformPixmapSurface, (dpy, config, native_pixmap, attrib_list), (EGLDisplay dpy, EGLConfig config, void *native_pixmap, const EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreatePlatformPixmapSurface_debug(EGLDisplay dpy, EGLConfig config, void *native_pixmap, const EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreatePlatformPixmapSurface, "(%p, %p, %p, %p)", (void*)dpy, (void*)config, (void*)native_pixmap, (void*)attrib_list)
    EGLSurface rval = glatter_eglCreatePlatformPixmapSurface(dpy, config, native_pixmap, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreatePlatformPixmapSurface_defined
#endif
#ifndef eglCreatePlatformWindowSurface_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreatePlatformWindowSurface, (dpy, config, native_window, attrib_list), (EGLDisplay dpy, EGLConfig config, void *native_window, const EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreatePlatformWindowSurface_debug(EGLDisplay dpy, EGLConfig config, void *native_window, const EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreatePlatformWindowSurface, "(%p, %p, %p, %p)", (void*)dpy, (void*)config, (void*)native_window, (void*)attrib_list)
    EGLSurface rval = glatter_eglCreatePlatformWindowSurface(dpy, config, native_window, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreatePlatformWindowSurface_defined
#endif
#ifndef eglCreateSync_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSync, EGLAPIENTRY, eglCreateSync, (dpy, type, attrib_list), (EGLDisplay dpy, EGLenum type, const EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLSync glatter_eglCreateSync_debug(EGLDisplay dpy, EGLenum type, const EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateSync, "(%p, %s, %p)", (void*)dpy, enum_to_string_EGL(type), (void*)attrib_list)
    EGLSync rval = glatter_eglCreateSync(dpy, type, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateSync_defined
#endif
#ifndef eglDestroyImage_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglDestroyImage, (dpy, image), (EGLDisplay dpy, EGLImage image))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglDestroyImage_debug(EGLDisplay dpy, EGLImage image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDestroyImage, "(%p, %p)", (void*)dpy, (void*)image)
    EGLBoolean rval = glatter_eglDestroyImage(dpy, image);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDestroyImage_defined
#endif
#ifndef eglDestroySync_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglDestroySync, (dpy, sync), (EGLDisplay dpy, EGLSync sync))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglDestroySync_debug(EGLDisplay dpy, EGLSync sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDestroySync, "(%p, %p)", (void*)dpy, (void*)sync)
    EGLBoolean rval = glatter_eglDestroySync(dpy, sync);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDestroySync_defined
#endif
#ifndef eglGetPlatformDisplay_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLDisplay, EGLAPIENTRY, eglGetPlatformDisplay, (platform, native_display, attrib_list), (EGLenum platform, void *native_display, const EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLDisplay glatter_eglGetPlatformDisplay_debug(EGLenum platform, void *native_display, const EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetPlatformDisplay, "(%s, %p, %p)", enum_to_string_EGL(platform), (void*)native_display, (void*)attrib_list)
    EGLDisplay rval = glatter_eglGetPlatformDisplay(platform, native_display, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetPlatformDisplay_defined
#endif
#ifndef eglGetSyncAttrib_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglGetSyncAttrib, (dpy, sync, attribute, value), (EGLDisplay dpy, EGLSync sync, EGLint attribute, EGLAttrib *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglGetSyncAttrib_debug(EGLDisplay dpy, EGLSync sync, EGLint attribute, EGLAttrib *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetSyncAttrib, "(%p, %p, %s, %p)", (void*)dpy, (void*)sync, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglGetSyncAttrib(dpy, sync, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetSyncAttrib_defined
#endif
#ifndef eglWaitSync_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglWaitSync, (dpy, sync, flags), (EGLDisplay dpy, EGLSync sync, EGLint flags))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglWaitSync_debug(EGLDisplay dpy, EGLSync sync, EGLint flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglWaitSync, "(%p, %p, %s)", (void*)dpy, (void*)sync, GET_PRS(flags))
    EGLBoolean rval = glatter_eglWaitSync(dpy, sync, flags);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglWaitSync_defined
#endif
#endif // defined(EGL_VERSION_1_5)
#endif // defined(__egl_h_)
#if defined(__eglext_h_)
#if defined(EGL_ANDROID_blob_cache)
#ifndef eglSetBlobCacheFuncsANDROID_defined
GLATTER_FBLOCK(, EGL, EGLAPI, void, EGLAPIENTRY, eglSetBlobCacheFuncsANDROID, (dpy, set, get), (EGLDisplay dpy, EGLSetBlobFuncANDROID set, EGLGetBlobFuncANDROID get))
GLATTER_INLINE_OR_NOT void glatter_eglSetBlobCacheFuncsANDROID_debug(EGLDisplay dpy, EGLSetBlobFuncANDROID set, EGLGetBlobFuncANDROID get, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSetBlobCacheFuncsANDROID, "(%p, %s, %s)", (void*)dpy, GET_PRS(set), GET_PRS(get))
    glatter_eglSetBlobCacheFuncsANDROID(dpy, set, get);
    GLATTER_CHECK_ERROR(EGL, file, line)
}
#define eglSetBlobCacheFuncsANDROID_defined
#endif
#endif // defined(EGL_ANDROID_blob_cache)
#if defined(EGL_ANDROID_create_native_client_buffer)
#ifndef eglCreateNativeClientBufferANDROID_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLClientBuffer, EGLAPIENTRY, eglCreateNativeClientBufferANDROID, (attrib_list), (const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLClientBuffer glatter_eglCreateNativeClientBufferANDROID_debug(const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateNativeClientBufferANDROID, "(%p)", (void*)attrib_list)
    EGLClientBuffer rval = glatter_eglCreateNativeClientBufferANDROID(attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateNativeClientBufferANDROID_defined
#endif
#endif // defined(EGL_ANDROID_create_native_client_buffer)
#if defined(EGL_ANDROID_native_fence_sync)
#ifndef eglDupNativeFenceFDANDROID_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLint, EGLAPIENTRY, eglDupNativeFenceFDANDROID, (dpy, sync), (EGLDisplay dpy, EGLSyncKHR sync))
GLATTER_INLINE_OR_NOT EGLint glatter_eglDupNativeFenceFDANDROID_debug(EGLDisplay dpy, EGLSyncKHR sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDupNativeFenceFDANDROID, "(%p, %p)", (void*)dpy, (void*)sync)
    EGLint rval = glatter_eglDupNativeFenceFDANDROID(dpy, sync);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDupNativeFenceFDANDROID_defined
#endif
#endif // defined(EGL_ANDROID_native_fence_sync)
#if defined(EGL_ANDROID_presentation_time)
#ifndef eglPresentationTimeANDROID_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglPresentationTimeANDROID, (dpy, surface, time), (EGLDisplay dpy, EGLSurface surface, EGLnsecsANDROID time))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglPresentationTimeANDROID_debug(EGLDisplay dpy, EGLSurface surface, EGLnsecsANDROID time, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglPresentationTimeANDROID, "(%p, %p, %s)", (void*)dpy, (void*)surface, GET_PRS(time))
    EGLBoolean rval = glatter_eglPresentationTimeANDROID(dpy, surface, time);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglPresentationTimeANDROID_defined
#endif
#endif // defined(EGL_ANDROID_presentation_time)
#if defined(EGL_ANGLE_query_surface_pointer)
#ifndef eglQuerySurfacePointerANGLE_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQuerySurfacePointerANGLE, (dpy, surface, attribute, value), (EGLDisplay dpy, EGLSurface surface, EGLint attribute, void **value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQuerySurfacePointerANGLE_debug(EGLDisplay dpy, EGLSurface surface, EGLint attribute, void **value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQuerySurfacePointerANGLE, "(%p, %p, %s, %p)", (void*)dpy, (void*)surface, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQuerySurfacePointerANGLE(dpy, surface, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQuerySurfacePointerANGLE_defined
#endif
#endif // defined(EGL_ANGLE_query_surface_pointer)
#if defined(EGL_EXT_compositor)
#ifndef eglCompositorBindTexWindowEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglCompositorBindTexWindowEXT, (external_win_id), (EGLint external_win_id))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglCompositorBindTexWindowEXT_debug(EGLint external_win_id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCompositorBindTexWindowEXT, "(%s)", GET_PRS(external_win_id))
    EGLBoolean rval = glatter_eglCompositorBindTexWindowEXT(external_win_id);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCompositorBindTexWindowEXT_defined
#endif
#ifndef eglCompositorSetContextAttributesEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglCompositorSetContextAttributesEXT, (external_ref_id, context_attributes, num_entries), (EGLint external_ref_id, const EGLint *context_attributes, EGLint num_entries))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglCompositorSetContextAttributesEXT_debug(EGLint external_ref_id, const EGLint *context_attributes, EGLint num_entries, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCompositorSetContextAttributesEXT, "(%s, %p, %s)", GET_PRS(external_ref_id), (void*)context_attributes, GET_PRS(num_entries))
    EGLBoolean rval = glatter_eglCompositorSetContextAttributesEXT(external_ref_id, context_attributes, num_entries);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCompositorSetContextAttributesEXT_defined
#endif
#ifndef eglCompositorSetContextListEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglCompositorSetContextListEXT, (external_ref_ids, num_entries), (const EGLint *external_ref_ids, EGLint num_entries))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglCompositorSetContextListEXT_debug(const EGLint *external_ref_ids, EGLint num_entries, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCompositorSetContextListEXT, "(%p, %s)", (void*)external_ref_ids, GET_PRS(num_entries))
    EGLBoolean rval = glatter_eglCompositorSetContextListEXT(external_ref_ids, num_entries);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCompositorSetContextListEXT_defined
#endif
#ifndef eglCompositorSetSizeEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglCompositorSetSizeEXT, (external_win_id, width, height), (EGLint external_win_id, EGLint width, EGLint height))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglCompositorSetSizeEXT_debug(EGLint external_win_id, EGLint width, EGLint height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCompositorSetSizeEXT, "(%s, %s, %s)", GET_PRS(external_win_id), GET_PRS(width), GET_PRS(height))
    EGLBoolean rval = glatter_eglCompositorSetSizeEXT(external_win_id, width, height);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCompositorSetSizeEXT_defined
#endif
#ifndef eglCompositorSetWindowAttributesEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglCompositorSetWindowAttributesEXT, (external_win_id, window_attributes, num_entries), (EGLint external_win_id, const EGLint *window_attributes, EGLint num_entries))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglCompositorSetWindowAttributesEXT_debug(EGLint external_win_id, const EGLint *window_attributes, EGLint num_entries, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCompositorSetWindowAttributesEXT, "(%s, %p, %s)", GET_PRS(external_win_id), (void*)window_attributes, GET_PRS(num_entries))
    EGLBoolean rval = glatter_eglCompositorSetWindowAttributesEXT(external_win_id, window_attributes, num_entries);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCompositorSetWindowAttributesEXT_defined
#endif
#ifndef eglCompositorSetWindowListEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglCompositorSetWindowListEXT, (external_ref_id, external_win_ids, num_entries), (EGLint external_ref_id, const EGLint *external_win_ids, EGLint num_entries))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglCompositorSetWindowListEXT_debug(EGLint external_ref_id, const EGLint *external_win_ids, EGLint num_entries, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCompositorSetWindowListEXT, "(%s, %p, %s)", GET_PRS(external_ref_id), (void*)external_win_ids, GET_PRS(num_entries))
    EGLBoolean rval = glatter_eglCompositorSetWindowListEXT(external_ref_id, external_win_ids, num_entries);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCompositorSetWindowListEXT_defined
#endif
#ifndef eglCompositorSwapPolicyEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglCompositorSwapPolicyEXT, (external_win_id, policy), (EGLint external_win_id, EGLint policy))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglCompositorSwapPolicyEXT_debug(EGLint external_win_id, EGLint policy, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCompositorSwapPolicyEXT, "(%s, %s)", GET_PRS(external_win_id), GET_PRS(policy))
    EGLBoolean rval = glatter_eglCompositorSwapPolicyEXT(external_win_id, policy);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCompositorSwapPolicyEXT_defined
#endif
#endif // defined(EGL_EXT_compositor)
#if defined(EGL_EXT_device_base)
#ifndef eglQueryDeviceAttribEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryDeviceAttribEXT, (device, attribute, value), (EGLDeviceEXT device, EGLint attribute, EGLAttrib *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryDeviceAttribEXT_debug(EGLDeviceEXT device, EGLint attribute, EGLAttrib *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryDeviceAttribEXT, "(%p, %s, %p)", (void*)device, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryDeviceAttribEXT(device, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryDeviceAttribEXT_defined
#endif
#ifndef eglQueryDeviceStringEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, const char *, EGLAPIENTRY, eglQueryDeviceStringEXT, (device, name), (EGLDeviceEXT device, EGLint name))
GLATTER_INLINE_OR_NOT const char * glatter_eglQueryDeviceStringEXT_debug(EGLDeviceEXT device, EGLint name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryDeviceStringEXT, "(%p, %s)", (void*)device, GET_PRS(name))
    const char * rval = glatter_eglQueryDeviceStringEXT(device, name);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryDeviceStringEXT_defined
#endif
#ifndef eglQueryDevicesEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryDevicesEXT, (max_devices, devices, num_devices), (EGLint max_devices, EGLDeviceEXT *devices, EGLint *num_devices))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryDevicesEXT_debug(EGLint max_devices, EGLDeviceEXT *devices, EGLint *num_devices, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryDevicesEXT, "(%s, %p, %p)", GET_PRS(max_devices), (void*)devices, (void*)num_devices)
    EGLBoolean rval = glatter_eglQueryDevicesEXT(max_devices, devices, num_devices);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryDevicesEXT_defined
#endif
#ifndef eglQueryDisplayAttribEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryDisplayAttribEXT, (dpy, attribute, value), (EGLDisplay dpy, EGLint attribute, EGLAttrib *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryDisplayAttribEXT_debug(EGLDisplay dpy, EGLint attribute, EGLAttrib *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryDisplayAttribEXT, "(%p, %s, %p)", (void*)dpy, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryDisplayAttribEXT(dpy, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryDisplayAttribEXT_defined
#endif
#endif // defined(EGL_EXT_device_base)
#if defined(EGL_EXT_image_dma_buf_import_modifiers)
#ifndef eglQueryDmaBufFormatsEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryDmaBufFormatsEXT, (dpy, max_formats, formats, num_formats), (EGLDisplay dpy, EGLint max_formats, EGLint *formats, EGLint *num_formats))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryDmaBufFormatsEXT_debug(EGLDisplay dpy, EGLint max_formats, EGLint *formats, EGLint *num_formats, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryDmaBufFormatsEXT, "(%p, %s, %p, %p)", (void*)dpy, GET_PRS(max_formats), (void*)formats, (void*)num_formats)
    EGLBoolean rval = glatter_eglQueryDmaBufFormatsEXT(dpy, max_formats, formats, num_formats);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryDmaBufFormatsEXT_defined
#endif
#ifndef eglQueryDmaBufModifiersEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryDmaBufModifiersEXT, (dpy, format, max_modifiers, modifiers, external_only, num_modifiers), (EGLDisplay dpy, EGLint format, EGLint max_modifiers, EGLuint64KHR *modifiers, EGLBoolean *external_only, EGLint *num_modifiers))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryDmaBufModifiersEXT_debug(EGLDisplay dpy, EGLint format, EGLint max_modifiers, EGLuint64KHR *modifiers, EGLBoolean *external_only, EGLint *num_modifiers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryDmaBufModifiersEXT, "(%p, %s, %s, %p, %p, %p)", (void*)dpy, GET_PRS(format), GET_PRS(max_modifiers), (void*)modifiers, (void*)external_only, (void*)num_modifiers)
    EGLBoolean rval = glatter_eglQueryDmaBufModifiersEXT(dpy, format, max_modifiers, modifiers, external_only, num_modifiers);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryDmaBufModifiersEXT_defined
#endif
#endif // defined(EGL_EXT_image_dma_buf_import_modifiers)
#if defined(EGL_EXT_output_base)
#ifndef eglGetOutputLayersEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglGetOutputLayersEXT, (dpy, attrib_list, layers, max_layers, num_layers), (EGLDisplay dpy, const EGLAttrib *attrib_list, EGLOutputLayerEXT *layers, EGLint max_layers, EGLint *num_layers))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglGetOutputLayersEXT_debug(EGLDisplay dpy, const EGLAttrib *attrib_list, EGLOutputLayerEXT *layers, EGLint max_layers, EGLint *num_layers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetOutputLayersEXT, "(%p, %p, %p, %s, %p)", (void*)dpy, (void*)attrib_list, (void*)layers, GET_PRS(max_layers), (void*)num_layers)
    EGLBoolean rval = glatter_eglGetOutputLayersEXT(dpy, attrib_list, layers, max_layers, num_layers);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetOutputLayersEXT_defined
#endif
#ifndef eglGetOutputPortsEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglGetOutputPortsEXT, (dpy, attrib_list, ports, max_ports, num_ports), (EGLDisplay dpy, const EGLAttrib *attrib_list, EGLOutputPortEXT *ports, EGLint max_ports, EGLint *num_ports))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglGetOutputPortsEXT_debug(EGLDisplay dpy, const EGLAttrib *attrib_list, EGLOutputPortEXT *ports, EGLint max_ports, EGLint *num_ports, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetOutputPortsEXT, "(%p, %p, %p, %s, %p)", (void*)dpy, (void*)attrib_list, (void*)ports, GET_PRS(max_ports), (void*)num_ports)
    EGLBoolean rval = glatter_eglGetOutputPortsEXT(dpy, attrib_list, ports, max_ports, num_ports);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetOutputPortsEXT_defined
#endif
#ifndef eglOutputLayerAttribEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglOutputLayerAttribEXT, (dpy, layer, attribute, value), (EGLDisplay dpy, EGLOutputLayerEXT layer, EGLint attribute, EGLAttrib value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglOutputLayerAttribEXT_debug(EGLDisplay dpy, EGLOutputLayerEXT layer, EGLint attribute, EGLAttrib value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglOutputLayerAttribEXT, "(%p, %p, %s, %" PRIxPTR ")", (void*)dpy, (void*)layer, GET_PRS(attribute), (intptr_t)value)
    EGLBoolean rval = glatter_eglOutputLayerAttribEXT(dpy, layer, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglOutputLayerAttribEXT_defined
#endif
#ifndef eglOutputPortAttribEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglOutputPortAttribEXT, (dpy, port, attribute, value), (EGLDisplay dpy, EGLOutputPortEXT port, EGLint attribute, EGLAttrib value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglOutputPortAttribEXT_debug(EGLDisplay dpy, EGLOutputPortEXT port, EGLint attribute, EGLAttrib value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglOutputPortAttribEXT, "(%p, %p, %s, %" PRIxPTR ")", (void*)dpy, (void*)port, GET_PRS(attribute), (intptr_t)value)
    EGLBoolean rval = glatter_eglOutputPortAttribEXT(dpy, port, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglOutputPortAttribEXT_defined
#endif
#ifndef eglQueryOutputLayerAttribEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryOutputLayerAttribEXT, (dpy, layer, attribute, value), (EGLDisplay dpy, EGLOutputLayerEXT layer, EGLint attribute, EGLAttrib *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryOutputLayerAttribEXT_debug(EGLDisplay dpy, EGLOutputLayerEXT layer, EGLint attribute, EGLAttrib *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryOutputLayerAttribEXT, "(%p, %p, %s, %p)", (void*)dpy, (void*)layer, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryOutputLayerAttribEXT(dpy, layer, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryOutputLayerAttribEXT_defined
#endif
#ifndef eglQueryOutputLayerStringEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, const char *, EGLAPIENTRY, eglQueryOutputLayerStringEXT, (dpy, layer, name), (EGLDisplay dpy, EGLOutputLayerEXT layer, EGLint name))
GLATTER_INLINE_OR_NOT const char * glatter_eglQueryOutputLayerStringEXT_debug(EGLDisplay dpy, EGLOutputLayerEXT layer, EGLint name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryOutputLayerStringEXT, "(%p, %p, %s)", (void*)dpy, (void*)layer, GET_PRS(name))
    const char * rval = glatter_eglQueryOutputLayerStringEXT(dpy, layer, name);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryOutputLayerStringEXT_defined
#endif
#ifndef eglQueryOutputPortAttribEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryOutputPortAttribEXT, (dpy, port, attribute, value), (EGLDisplay dpy, EGLOutputPortEXT port, EGLint attribute, EGLAttrib *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryOutputPortAttribEXT_debug(EGLDisplay dpy, EGLOutputPortEXT port, EGLint attribute, EGLAttrib *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryOutputPortAttribEXT, "(%p, %p, %s, %p)", (void*)dpy, (void*)port, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryOutputPortAttribEXT(dpy, port, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryOutputPortAttribEXT_defined
#endif
#ifndef eglQueryOutputPortStringEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, const char *, EGLAPIENTRY, eglQueryOutputPortStringEXT, (dpy, port, name), (EGLDisplay dpy, EGLOutputPortEXT port, EGLint name))
GLATTER_INLINE_OR_NOT const char * glatter_eglQueryOutputPortStringEXT_debug(EGLDisplay dpy, EGLOutputPortEXT port, EGLint name, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryOutputPortStringEXT, "(%p, %p, %s)", (void*)dpy, (void*)port, GET_PRS(name))
    const char * rval = glatter_eglQueryOutputPortStringEXT(dpy, port, name);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryOutputPortStringEXT_defined
#endif
#endif // defined(EGL_EXT_output_base)
#if defined(EGL_EXT_platform_base)
#ifndef eglCreatePlatformPixmapSurfaceEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreatePlatformPixmapSurfaceEXT, (dpy, config, native_pixmap, attrib_list), (EGLDisplay dpy, EGLConfig config, void *native_pixmap, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreatePlatformPixmapSurfaceEXT_debug(EGLDisplay dpy, EGLConfig config, void *native_pixmap, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreatePlatformPixmapSurfaceEXT, "(%p, %p, %p, %p)", (void*)dpy, (void*)config, (void*)native_pixmap, (void*)attrib_list)
    EGLSurface rval = glatter_eglCreatePlatformPixmapSurfaceEXT(dpy, config, native_pixmap, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreatePlatformPixmapSurfaceEXT_defined
#endif
#ifndef eglCreatePlatformWindowSurfaceEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreatePlatformWindowSurfaceEXT, (dpy, config, native_window, attrib_list), (EGLDisplay dpy, EGLConfig config, void *native_window, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreatePlatformWindowSurfaceEXT_debug(EGLDisplay dpy, EGLConfig config, void *native_window, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreatePlatformWindowSurfaceEXT, "(%p, %p, %p, %p)", (void*)dpy, (void*)config, (void*)native_window, (void*)attrib_list)
    EGLSurface rval = glatter_eglCreatePlatformWindowSurfaceEXT(dpy, config, native_window, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreatePlatformWindowSurfaceEXT_defined
#endif
#ifndef eglGetPlatformDisplayEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLDisplay, EGLAPIENTRY, eglGetPlatformDisplayEXT, (platform, native_display, attrib_list), (EGLenum platform, void *native_display, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLDisplay glatter_eglGetPlatformDisplayEXT_debug(EGLenum platform, void *native_display, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetPlatformDisplayEXT, "(%s, %p, %p)", enum_to_string_EGL(platform), (void*)native_display, (void*)attrib_list)
    EGLDisplay rval = glatter_eglGetPlatformDisplayEXT(platform, native_display, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetPlatformDisplayEXT_defined
#endif
#endif // defined(EGL_EXT_platform_base)
#if defined(EGL_EXT_stream_consumer_egloutput)
#ifndef eglStreamConsumerOutputEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglStreamConsumerOutputEXT, (dpy, stream, layer), (EGLDisplay dpy, EGLStreamKHR stream, EGLOutputLayerEXT layer))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglStreamConsumerOutputEXT_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLOutputLayerEXT layer, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglStreamConsumerOutputEXT, "(%p, %p, %p)", (void*)dpy, (void*)stream, (void*)layer)
    EGLBoolean rval = glatter_eglStreamConsumerOutputEXT(dpy, stream, layer);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglStreamConsumerOutputEXT_defined
#endif
#endif // defined(EGL_EXT_stream_consumer_egloutput)
#if defined(EGL_EXT_swap_buffers_with_damage)
#ifndef eglSwapBuffersWithDamageEXT_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSwapBuffersWithDamageEXT, (dpy, surface, rects, n_rects), (EGLDisplay dpy, EGLSurface surface, EGLint *rects, EGLint n_rects))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSwapBuffersWithDamageEXT_debug(EGLDisplay dpy, EGLSurface surface, EGLint *rects, EGLint n_rects, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSwapBuffersWithDamageEXT, "(%p, %p, %p, %s)", (void*)dpy, (void*)surface, (void*)rects, GET_PRS(n_rects))
    EGLBoolean rval = glatter_eglSwapBuffersWithDamageEXT(dpy, surface, rects, n_rects);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSwapBuffersWithDamageEXT_defined
#endif
#endif // defined(EGL_EXT_swap_buffers_with_damage)
#if defined(EGL_HI_clientpixmap)
#ifndef eglCreatePixmapSurfaceHI_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreatePixmapSurfaceHI, (dpy, config, pixmap), (EGLDisplay dpy, EGLConfig config, struct EGLClientPixmapHI *pixmap))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreatePixmapSurfaceHI_debug(EGLDisplay dpy, EGLConfig config, struct EGLClientPixmapHI *pixmap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreatePixmapSurfaceHI, "(%p, %p, %p)", (void*)dpy, (void*)config, (void*)pixmap)
    EGLSurface rval = glatter_eglCreatePixmapSurfaceHI(dpy, config, pixmap);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreatePixmapSurfaceHI_defined
#endif
#endif // defined(EGL_HI_clientpixmap)
#if defined(EGL_KHR_cl_event2)
#ifndef eglCreateSync64KHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSyncKHR, EGLAPIENTRY, eglCreateSync64KHR, (dpy, type, attrib_list), (EGLDisplay dpy, EGLenum type, const EGLAttribKHR *attrib_list))
GLATTER_INLINE_OR_NOT EGLSyncKHR glatter_eglCreateSync64KHR_debug(EGLDisplay dpy, EGLenum type, const EGLAttribKHR *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateSync64KHR, "(%p, %s, %p)", (void*)dpy, enum_to_string_EGL(type), (void*)attrib_list)
    EGLSyncKHR rval = glatter_eglCreateSync64KHR(dpy, type, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateSync64KHR_defined
#endif
#endif // defined(EGL_KHR_cl_event2)
#if defined(EGL_KHR_debug)
#ifndef eglDebugMessageControlKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLint, EGLAPIENTRY, eglDebugMessageControlKHR, (callback, attrib_list), (EGLDEBUGPROCKHR callback, const EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLint glatter_eglDebugMessageControlKHR_debug(EGLDEBUGPROCKHR callback, const EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDebugMessageControlKHR, "(%s, %p)", GET_PRS(callback), (void*)attrib_list)
    EGLint rval = glatter_eglDebugMessageControlKHR(callback, attrib_list);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDebugMessageControlKHR_defined
#endif
#ifndef eglLabelObjectKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLint, EGLAPIENTRY, eglLabelObjectKHR, (display, objectType, object, label), (EGLDisplay display, EGLenum objectType, EGLObjectKHR object, EGLLabelKHR label))
GLATTER_INLINE_OR_NOT EGLint glatter_eglLabelObjectKHR_debug(EGLDisplay display, EGLenum objectType, EGLObjectKHR object, EGLLabelKHR label, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglLabelObjectKHR, "(%p, %s, %p, %p)", (void*)display, enum_to_string_EGL(objectType), (void*)object, (void*)label)
    EGLint rval = glatter_eglLabelObjectKHR(display, objectType, object, label);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglLabelObjectKHR_defined
#endif
#ifndef eglQueryDebugKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryDebugKHR, (attribute, value), (EGLint attribute, EGLAttrib *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryDebugKHR_debug(EGLint attribute, EGLAttrib *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryDebugKHR, "(%s, %p)", GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryDebugKHR(attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryDebugKHR_defined
#endif
#endif // defined(EGL_KHR_debug)
#if defined(EGL_KHR_fence_sync)
#if defined(KHRONOS_SUPPORT_INT64)
#ifndef eglClientWaitSyncKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLint, EGLAPIENTRY, eglClientWaitSyncKHR, (dpy, sync, flags, timeout), (EGLDisplay dpy, EGLSyncKHR sync, EGLint flags, EGLTimeKHR timeout))
GLATTER_INLINE_OR_NOT EGLint glatter_eglClientWaitSyncKHR_debug(EGLDisplay dpy, EGLSyncKHR sync, EGLint flags, EGLTimeKHR timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglClientWaitSyncKHR, "(%p, %p, %s, %s)", (void*)dpy, (void*)sync, GET_PRS(flags), GET_PRS(timeout))
    EGLint rval = glatter_eglClientWaitSyncKHR(dpy, sync, flags, timeout);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglClientWaitSyncKHR_defined
#endif
#ifndef eglCreateSyncKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSyncKHR, EGLAPIENTRY, eglCreateSyncKHR, (dpy, type, attrib_list), (EGLDisplay dpy, EGLenum type, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSyncKHR glatter_eglCreateSyncKHR_debug(EGLDisplay dpy, EGLenum type, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateSyncKHR, "(%p, %s, %p)", (void*)dpy, enum_to_string_EGL(type), (void*)attrib_list)
    EGLSyncKHR rval = glatter_eglCreateSyncKHR(dpy, type, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateSyncKHR_defined
#endif
#ifndef eglDestroySyncKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglDestroySyncKHR, (dpy, sync), (EGLDisplay dpy, EGLSyncKHR sync))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglDestroySyncKHR_debug(EGLDisplay dpy, EGLSyncKHR sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDestroySyncKHR, "(%p, %p)", (void*)dpy, (void*)sync)
    EGLBoolean rval = glatter_eglDestroySyncKHR(dpy, sync);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDestroySyncKHR_defined
#endif
#ifndef eglGetSyncAttribKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglGetSyncAttribKHR, (dpy, sync, attribute, value), (EGLDisplay dpy, EGLSyncKHR sync, EGLint attribute, EGLint *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglGetSyncAttribKHR_debug(EGLDisplay dpy, EGLSyncKHR sync, EGLint attribute, EGLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetSyncAttribKHR, "(%p, %p, %s, %p)", (void*)dpy, (void*)sync, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglGetSyncAttribKHR(dpy, sync, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetSyncAttribKHR_defined
#endif
#endif // defined(KHRONOS_SUPPORT_INT64)
#endif // defined(EGL_KHR_fence_sync)
#if defined(EGL_KHR_image)
#ifndef eglCreateImageKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLImageKHR, EGLAPIENTRY, eglCreateImageKHR, (dpy, ctx, target, buffer, attrib_list), (EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLImageKHR glatter_eglCreateImageKHR_debug(EGLDisplay dpy, EGLContext ctx, EGLenum target, EGLClientBuffer buffer, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateImageKHR, "(%p, %p, %s, %p, %p)", (void*)dpy, (void*)ctx, enum_to_string_EGL(target), (void*)buffer, (void*)attrib_list)
    EGLImageKHR rval = glatter_eglCreateImageKHR(dpy, ctx, target, buffer, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateImageKHR_defined
#endif
#ifndef eglDestroyImageKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglDestroyImageKHR, (dpy, image), (EGLDisplay dpy, EGLImageKHR image))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglDestroyImageKHR_debug(EGLDisplay dpy, EGLImageKHR image, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDestroyImageKHR, "(%p, %p)", (void*)dpy, (void*)image)
    EGLBoolean rval = glatter_eglDestroyImageKHR(dpy, image);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDestroyImageKHR_defined
#endif
#endif // defined(EGL_KHR_image)
#if defined(EGL_KHR_lock_surface)
#ifndef eglLockSurfaceKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglLockSurfaceKHR, (dpy, surface, attrib_list), (EGLDisplay dpy, EGLSurface surface, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglLockSurfaceKHR_debug(EGLDisplay dpy, EGLSurface surface, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglLockSurfaceKHR, "(%p, %p, %p)", (void*)dpy, (void*)surface, (void*)attrib_list)
    EGLBoolean rval = glatter_eglLockSurfaceKHR(dpy, surface, attrib_list);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglLockSurfaceKHR_defined
#endif
#ifndef eglUnlockSurfaceKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglUnlockSurfaceKHR, (dpy, surface), (EGLDisplay dpy, EGLSurface surface))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglUnlockSurfaceKHR_debug(EGLDisplay dpy, EGLSurface surface, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglUnlockSurfaceKHR, "(%p, %p)", (void*)dpy, (void*)surface)
    EGLBoolean rval = glatter_eglUnlockSurfaceKHR(dpy, surface);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglUnlockSurfaceKHR_defined
#endif
#endif // defined(EGL_KHR_lock_surface)
#if defined(EGL_KHR_lock_surface3)
#ifndef eglQuerySurface64KHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQuerySurface64KHR, (dpy, surface, attribute, value), (EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLAttribKHR *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQuerySurface64KHR_debug(EGLDisplay dpy, EGLSurface surface, EGLint attribute, EGLAttribKHR *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQuerySurface64KHR, "(%p, %p, %s, %p)", (void*)dpy, (void*)surface, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQuerySurface64KHR(dpy, surface, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQuerySurface64KHR_defined
#endif
#endif // defined(EGL_KHR_lock_surface3)
#if defined(EGL_KHR_partial_update)
#ifndef eglSetDamageRegionKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSetDamageRegionKHR, (dpy, surface, rects, n_rects), (EGLDisplay dpy, EGLSurface surface, EGLint *rects, EGLint n_rects))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSetDamageRegionKHR_debug(EGLDisplay dpy, EGLSurface surface, EGLint *rects, EGLint n_rects, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSetDamageRegionKHR, "(%p, %p, %p, %s)", (void*)dpy, (void*)surface, (void*)rects, GET_PRS(n_rects))
    EGLBoolean rval = glatter_eglSetDamageRegionKHR(dpy, surface, rects, n_rects);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSetDamageRegionKHR_defined
#endif
#endif // defined(EGL_KHR_partial_update)
#if defined(EGL_KHR_reusable_sync)
#if defined(KHRONOS_SUPPORT_INT64)
#ifndef eglSignalSyncKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSignalSyncKHR, (dpy, sync, mode), (EGLDisplay dpy, EGLSyncKHR sync, EGLenum mode))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSignalSyncKHR_debug(EGLDisplay dpy, EGLSyncKHR sync, EGLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSignalSyncKHR, "(%p, %p, %s)", (void*)dpy, (void*)sync, enum_to_string_EGL(mode))
    EGLBoolean rval = glatter_eglSignalSyncKHR(dpy, sync, mode);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSignalSyncKHR_defined
#endif
#endif // defined(KHRONOS_SUPPORT_INT64)
#endif // defined(EGL_KHR_reusable_sync)
#if defined(EGL_KHR_stream)
#if defined(KHRONOS_SUPPORT_INT64)
#ifndef eglCreateStreamKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLStreamKHR, EGLAPIENTRY, eglCreateStreamKHR, (dpy, attrib_list), (EGLDisplay dpy, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLStreamKHR glatter_eglCreateStreamKHR_debug(EGLDisplay dpy, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateStreamKHR, "(%p, %p)", (void*)dpy, (void*)attrib_list)
    EGLStreamKHR rval = glatter_eglCreateStreamKHR(dpy, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateStreamKHR_defined
#endif
#ifndef eglDestroyStreamKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglDestroyStreamKHR, (dpy, stream), (EGLDisplay dpy, EGLStreamKHR stream))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglDestroyStreamKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDestroyStreamKHR, "(%p, %p)", (void*)dpy, (void*)stream)
    EGLBoolean rval = glatter_eglDestroyStreamKHR(dpy, stream);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDestroyStreamKHR_defined
#endif
#ifndef eglQueryStreamKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryStreamKHR, (dpy, stream, attribute, value), (EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLint *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryStreamKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryStreamKHR, "(%p, %p, %s, %p)", (void*)dpy, (void*)stream, enum_to_string_EGL(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryStreamKHR(dpy, stream, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryStreamKHR_defined
#endif
#ifndef eglQueryStreamu64KHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryStreamu64KHR, (dpy, stream, attribute, value), (EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLuint64KHR *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryStreamu64KHR_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLuint64KHR *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryStreamu64KHR, "(%p, %p, %s, %p)", (void*)dpy, (void*)stream, enum_to_string_EGL(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryStreamu64KHR(dpy, stream, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryStreamu64KHR_defined
#endif
#ifndef eglStreamAttribKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglStreamAttribKHR, (dpy, stream, attribute, value), (EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLint value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglStreamAttribKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLint value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglStreamAttribKHR, "(%p, %p, %s, %s)", (void*)dpy, (void*)stream, enum_to_string_EGL(attribute), GET_PRS(value))
    EGLBoolean rval = glatter_eglStreamAttribKHR(dpy, stream, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglStreamAttribKHR_defined
#endif
#endif // defined(KHRONOS_SUPPORT_INT64)
#endif // defined(EGL_KHR_stream)
#if defined(EGL_KHR_stream_attrib)
#if defined(KHRONOS_SUPPORT_INT64)
#ifndef eglCreateStreamAttribKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLStreamKHR, EGLAPIENTRY, eglCreateStreamAttribKHR, (dpy, attrib_list), (EGLDisplay dpy, const EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLStreamKHR glatter_eglCreateStreamAttribKHR_debug(EGLDisplay dpy, const EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateStreamAttribKHR, "(%p, %p)", (void*)dpy, (void*)attrib_list)
    EGLStreamKHR rval = glatter_eglCreateStreamAttribKHR(dpy, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateStreamAttribKHR_defined
#endif
#ifndef eglQueryStreamAttribKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryStreamAttribKHR, (dpy, stream, attribute, value), (EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLAttrib *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryStreamAttribKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLAttrib *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryStreamAttribKHR, "(%p, %p, %s, %p)", (void*)dpy, (void*)stream, enum_to_string_EGL(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryStreamAttribKHR(dpy, stream, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryStreamAttribKHR_defined
#endif
#ifndef eglSetStreamAttribKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSetStreamAttribKHR, (dpy, stream, attribute, value), (EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLAttrib value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSetStreamAttribKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLAttrib value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSetStreamAttribKHR, "(%p, %p, %s, %" PRIxPTR ")", (void*)dpy, (void*)stream, enum_to_string_EGL(attribute), (intptr_t)value)
    EGLBoolean rval = glatter_eglSetStreamAttribKHR(dpy, stream, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSetStreamAttribKHR_defined
#endif
#ifndef eglStreamConsumerAcquireAttribKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglStreamConsumerAcquireAttribKHR, (dpy, stream, attrib_list), (EGLDisplay dpy, EGLStreamKHR stream, const EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglStreamConsumerAcquireAttribKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, const EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglStreamConsumerAcquireAttribKHR, "(%p, %p, %p)", (void*)dpy, (void*)stream, (void*)attrib_list)
    EGLBoolean rval = glatter_eglStreamConsumerAcquireAttribKHR(dpy, stream, attrib_list);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglStreamConsumerAcquireAttribKHR_defined
#endif
#ifndef eglStreamConsumerReleaseAttribKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglStreamConsumerReleaseAttribKHR, (dpy, stream, attrib_list), (EGLDisplay dpy, EGLStreamKHR stream, const EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglStreamConsumerReleaseAttribKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, const EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglStreamConsumerReleaseAttribKHR, "(%p, %p, %p)", (void*)dpy, (void*)stream, (void*)attrib_list)
    EGLBoolean rval = glatter_eglStreamConsumerReleaseAttribKHR(dpy, stream, attrib_list);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglStreamConsumerReleaseAttribKHR_defined
#endif
#endif // defined(KHRONOS_SUPPORT_INT64)
#endif // defined(EGL_KHR_stream_attrib)
#if defined(EGL_KHR_stream_consumer_gltexture)
#if defined(EGL_KHR_stream)
#ifndef eglStreamConsumerAcquireKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglStreamConsumerAcquireKHR, (dpy, stream), (EGLDisplay dpy, EGLStreamKHR stream))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglStreamConsumerAcquireKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglStreamConsumerAcquireKHR, "(%p, %p)", (void*)dpy, (void*)stream)
    EGLBoolean rval = glatter_eglStreamConsumerAcquireKHR(dpy, stream);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglStreamConsumerAcquireKHR_defined
#endif
#ifndef eglStreamConsumerGLTextureExternalKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglStreamConsumerGLTextureExternalKHR, (dpy, stream), (EGLDisplay dpy, EGLStreamKHR stream))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglStreamConsumerGLTextureExternalKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglStreamConsumerGLTextureExternalKHR, "(%p, %p)", (void*)dpy, (void*)stream)
    EGLBoolean rval = glatter_eglStreamConsumerGLTextureExternalKHR(dpy, stream);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglStreamConsumerGLTextureExternalKHR_defined
#endif
#ifndef eglStreamConsumerReleaseKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglStreamConsumerReleaseKHR, (dpy, stream), (EGLDisplay dpy, EGLStreamKHR stream))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglStreamConsumerReleaseKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglStreamConsumerReleaseKHR, "(%p, %p)", (void*)dpy, (void*)stream)
    EGLBoolean rval = glatter_eglStreamConsumerReleaseKHR(dpy, stream);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglStreamConsumerReleaseKHR_defined
#endif
#endif // defined(EGL_KHR_stream)
#endif // defined(EGL_KHR_stream_consumer_gltexture)
#if defined(EGL_KHR_stream_cross_process_fd)
#if defined(EGL_KHR_stream)
#ifndef eglCreateStreamFromFileDescriptorKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLStreamKHR, EGLAPIENTRY, eglCreateStreamFromFileDescriptorKHR, (dpy, file_descriptor), (EGLDisplay dpy, EGLNativeFileDescriptorKHR file_descriptor))
GLATTER_INLINE_OR_NOT EGLStreamKHR glatter_eglCreateStreamFromFileDescriptorKHR_debug(EGLDisplay dpy, EGLNativeFileDescriptorKHR file_descriptor, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateStreamFromFileDescriptorKHR, "(%p, %d)", (void*)dpy, (int)file_descriptor)
    EGLStreamKHR rval = glatter_eglCreateStreamFromFileDescriptorKHR(dpy, file_descriptor);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateStreamFromFileDescriptorKHR_defined
#endif
#ifndef eglGetStreamFileDescriptorKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLNativeFileDescriptorKHR, EGLAPIENTRY, eglGetStreamFileDescriptorKHR, (dpy, stream), (EGLDisplay dpy, EGLStreamKHR stream))
GLATTER_INLINE_OR_NOT EGLNativeFileDescriptorKHR glatter_eglGetStreamFileDescriptorKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetStreamFileDescriptorKHR, "(%p, %p)", (void*)dpy, (void*)stream)
    EGLNativeFileDescriptorKHR rval = glatter_eglGetStreamFileDescriptorKHR(dpy, stream);
    GLATTER_RBLOCK("%d\n", (int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetStreamFileDescriptorKHR_defined
#endif
#endif // defined(EGL_KHR_stream)
#endif // defined(EGL_KHR_stream_cross_process_fd)
#if defined(EGL_KHR_stream_fifo)
#if defined(EGL_KHR_stream)
#ifndef eglQueryStreamTimeKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryStreamTimeKHR, (dpy, stream, attribute, value), (EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLTimeKHR *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryStreamTimeKHR_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLenum attribute, EGLTimeKHR *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryStreamTimeKHR, "(%p, %p, %s, %p)", (void*)dpy, (void*)stream, enum_to_string_EGL(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryStreamTimeKHR(dpy, stream, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryStreamTimeKHR_defined
#endif
#endif // defined(EGL_KHR_stream)
#endif // defined(EGL_KHR_stream_fifo)
#if defined(EGL_KHR_stream_producer_eglsurface)
#if defined(EGL_KHR_stream)
#ifndef eglCreateStreamProducerSurfaceKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSurface, EGLAPIENTRY, eglCreateStreamProducerSurfaceKHR, (dpy, config, stream, attrib_list), (EGLDisplay dpy, EGLConfig config, EGLStreamKHR stream, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSurface glatter_eglCreateStreamProducerSurfaceKHR_debug(EGLDisplay dpy, EGLConfig config, EGLStreamKHR stream, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateStreamProducerSurfaceKHR, "(%p, %p, %p, %p)", (void*)dpy, (void*)config, (void*)stream, (void*)attrib_list)
    EGLSurface rval = glatter_eglCreateStreamProducerSurfaceKHR(dpy, config, stream, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateStreamProducerSurfaceKHR_defined
#endif
#endif // defined(EGL_KHR_stream)
#endif // defined(EGL_KHR_stream_producer_eglsurface)
#if defined(EGL_KHR_swap_buffers_with_damage)
#ifndef eglSwapBuffersWithDamageKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSwapBuffersWithDamageKHR, (dpy, surface, rects, n_rects), (EGLDisplay dpy, EGLSurface surface, EGLint *rects, EGLint n_rects))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSwapBuffersWithDamageKHR_debug(EGLDisplay dpy, EGLSurface surface, EGLint *rects, EGLint n_rects, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSwapBuffersWithDamageKHR, "(%p, %p, %p, %s)", (void*)dpy, (void*)surface, (void*)rects, GET_PRS(n_rects))
    EGLBoolean rval = glatter_eglSwapBuffersWithDamageKHR(dpy, surface, rects, n_rects);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSwapBuffersWithDamageKHR_defined
#endif
#endif // defined(EGL_KHR_swap_buffers_with_damage)
#if defined(EGL_KHR_wait_sync)
#ifndef eglWaitSyncKHR_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLint, EGLAPIENTRY, eglWaitSyncKHR, (dpy, sync, flags), (EGLDisplay dpy, EGLSyncKHR sync, EGLint flags))
GLATTER_INLINE_OR_NOT EGLint glatter_eglWaitSyncKHR_debug(EGLDisplay dpy, EGLSyncKHR sync, EGLint flags, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglWaitSyncKHR, "(%p, %p, %s)", (void*)dpy, (void*)sync, GET_PRS(flags))
    EGLint rval = glatter_eglWaitSyncKHR(dpy, sync, flags);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglWaitSyncKHR_defined
#endif
#endif // defined(EGL_KHR_wait_sync)
#if defined(EGL_MESA_drm_image)
#ifndef eglCreateDRMImageMESA_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLImageKHR, EGLAPIENTRY, eglCreateDRMImageMESA, (dpy, attrib_list), (EGLDisplay dpy, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLImageKHR glatter_eglCreateDRMImageMESA_debug(EGLDisplay dpy, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateDRMImageMESA, "(%p, %p)", (void*)dpy, (void*)attrib_list)
    EGLImageKHR rval = glatter_eglCreateDRMImageMESA(dpy, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateDRMImageMESA_defined
#endif
#ifndef eglExportDRMImageMESA_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglExportDRMImageMESA, (dpy, image, name, handle, stride), (EGLDisplay dpy, EGLImageKHR image, EGLint *name, EGLint *handle, EGLint *stride))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglExportDRMImageMESA_debug(EGLDisplay dpy, EGLImageKHR image, EGLint *name, EGLint *handle, EGLint *stride, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglExportDRMImageMESA, "(%p, %p, %p, %p, %p)", (void*)dpy, (void*)image, (void*)name, (void*)handle, (void*)stride)
    EGLBoolean rval = glatter_eglExportDRMImageMESA(dpy, image, name, handle, stride);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglExportDRMImageMESA_defined
#endif
#endif // defined(EGL_MESA_drm_image)
#if defined(EGL_MESA_image_dma_buf_export)
#ifndef eglExportDMABUFImageMESA_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglExportDMABUFImageMESA, (dpy, image, fds, strides, offsets), (EGLDisplay dpy, EGLImageKHR image, int *fds, EGLint *strides, EGLint *offsets))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglExportDMABUFImageMESA_debug(EGLDisplay dpy, EGLImageKHR image, int *fds, EGLint *strides, EGLint *offsets, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglExportDMABUFImageMESA, "(%p, %p, %p, %p, %p)", (void*)dpy, (void*)image, (void*)fds, (void*)strides, (void*)offsets)
    EGLBoolean rval = glatter_eglExportDMABUFImageMESA(dpy, image, fds, strides, offsets);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglExportDMABUFImageMESA_defined
#endif
#ifndef eglExportDMABUFImageQueryMESA_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglExportDMABUFImageQueryMESA, (dpy, image, fourcc, num_planes, modifiers), (EGLDisplay dpy, EGLImageKHR image, int *fourcc, int *num_planes, EGLuint64KHR *modifiers))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglExportDMABUFImageQueryMESA_debug(EGLDisplay dpy, EGLImageKHR image, int *fourcc, int *num_planes, EGLuint64KHR *modifiers, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglExportDMABUFImageQueryMESA, "(%p, %p, %p, %p, %p)", (void*)dpy, (void*)image, (void*)fourcc, (void*)num_planes, (void*)modifiers)
    EGLBoolean rval = glatter_eglExportDMABUFImageQueryMESA(dpy, image, fourcc, num_planes, modifiers);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglExportDMABUFImageQueryMESA_defined
#endif
#endif // defined(EGL_MESA_image_dma_buf_export)
#if defined(EGL_NOK_swap_region)
#ifndef eglSwapBuffersRegionNOK_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSwapBuffersRegionNOK, (dpy, surface, numRects, rects), (EGLDisplay dpy, EGLSurface surface, EGLint numRects, const EGLint *rects))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSwapBuffersRegionNOK_debug(EGLDisplay dpy, EGLSurface surface, EGLint numRects, const EGLint *rects, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSwapBuffersRegionNOK, "(%p, %p, %s, %p)", (void*)dpy, (void*)surface, GET_PRS(numRects), (void*)rects)
    EGLBoolean rval = glatter_eglSwapBuffersRegionNOK(dpy, surface, numRects, rects);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSwapBuffersRegionNOK_defined
#endif
#endif // defined(EGL_NOK_swap_region)
#if defined(EGL_NOK_swap_region2)
#ifndef eglSwapBuffersRegion2NOK_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSwapBuffersRegion2NOK, (dpy, surface, numRects, rects), (EGLDisplay dpy, EGLSurface surface, EGLint numRects, const EGLint *rects))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSwapBuffersRegion2NOK_debug(EGLDisplay dpy, EGLSurface surface, EGLint numRects, const EGLint *rects, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSwapBuffersRegion2NOK, "(%p, %p, %s, %p)", (void*)dpy, (void*)surface, GET_PRS(numRects), (void*)rects)
    EGLBoolean rval = glatter_eglSwapBuffersRegion2NOK(dpy, surface, numRects, rects);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSwapBuffersRegion2NOK_defined
#endif
#endif // defined(EGL_NOK_swap_region2)
#if defined(EGL_NV_native_query)
#ifndef eglQueryNativeDisplayNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryNativeDisplayNV, (dpy, display_id), (EGLDisplay dpy, EGLNativeDisplayType *display_id))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryNativeDisplayNV_debug(EGLDisplay dpy, EGLNativeDisplayType *display_id, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryNativeDisplayNV, "(%p, %p)", (void*)dpy, (void*)display_id)
    EGLBoolean rval = glatter_eglQueryNativeDisplayNV(dpy, display_id);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryNativeDisplayNV_defined
#endif
#ifndef eglQueryNativePixmapNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryNativePixmapNV, (dpy, surf, pixmap), (EGLDisplay dpy, EGLSurface surf, EGLNativePixmapType *pixmap))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryNativePixmapNV_debug(EGLDisplay dpy, EGLSurface surf, EGLNativePixmapType *pixmap, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryNativePixmapNV, "(%p, %p, %p)", (void*)dpy, (void*)surf, (void*)pixmap)
    EGLBoolean rval = glatter_eglQueryNativePixmapNV(dpy, surf, pixmap);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryNativePixmapNV_defined
#endif
#ifndef eglQueryNativeWindowNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryNativeWindowNV, (dpy, surf, window), (EGLDisplay dpy, EGLSurface surf, EGLNativeWindowType *window))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryNativeWindowNV_debug(EGLDisplay dpy, EGLSurface surf, EGLNativeWindowType *window, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryNativeWindowNV, "(%p, %p, %p)", (void*)dpy, (void*)surf, (void*)window)
    EGLBoolean rval = glatter_eglQueryNativeWindowNV(dpy, surf, window);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryNativeWindowNV_defined
#endif
#endif // defined(EGL_NV_native_query)
#if defined(EGL_NV_post_sub_buffer)
#ifndef eglPostSubBufferNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglPostSubBufferNV, (dpy, surface, x, y, width, height), (EGLDisplay dpy, EGLSurface surface, EGLint x, EGLint y, EGLint width, EGLint height))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglPostSubBufferNV_debug(EGLDisplay dpy, EGLSurface surface, EGLint x, EGLint y, EGLint width, EGLint height, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglPostSubBufferNV, "(%p, %p, %s, %s, %s, %s)", (void*)dpy, (void*)surface, GET_PRS(x), GET_PRS(y), GET_PRS(width), GET_PRS(height))
    EGLBoolean rval = glatter_eglPostSubBufferNV(dpy, surface, x, y, width, height);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglPostSubBufferNV_defined
#endif
#endif // defined(EGL_NV_post_sub_buffer)
#if defined(EGL_NV_stream_consumer_gltexture_yuv)
#ifndef eglStreamConsumerGLTextureExternalAttribsNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglStreamConsumerGLTextureExternalAttribsNV, (dpy, stream, attrib_list), (EGLDisplay dpy, EGLStreamKHR stream, EGLAttrib *attrib_list))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglStreamConsumerGLTextureExternalAttribsNV_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLAttrib *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglStreamConsumerGLTextureExternalAttribsNV, "(%p, %p, %p)", (void*)dpy, (void*)stream, (void*)attrib_list)
    EGLBoolean rval = glatter_eglStreamConsumerGLTextureExternalAttribsNV(dpy, stream, attrib_list);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglStreamConsumerGLTextureExternalAttribsNV_defined
#endif
#endif // defined(EGL_NV_stream_consumer_gltexture_yuv)
#if defined(EGL_NV_stream_metadata)
#ifndef eglQueryDisplayAttribNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryDisplayAttribNV, (dpy, attribute, value), (EGLDisplay dpy, EGLint attribute, EGLAttrib *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryDisplayAttribNV_debug(EGLDisplay dpy, EGLint attribute, EGLAttrib *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryDisplayAttribNV, "(%p, %s, %p)", (void*)dpy, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglQueryDisplayAttribNV(dpy, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryDisplayAttribNV_defined
#endif
#ifndef eglQueryStreamMetadataNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglQueryStreamMetadataNV, (dpy, stream, name, n, offset, size, data), (EGLDisplay dpy, EGLStreamKHR stream, EGLenum name, EGLint n, EGLint offset, EGLint size, void *data))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglQueryStreamMetadataNV_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLenum name, EGLint n, EGLint offset, EGLint size, void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglQueryStreamMetadataNV, "(%p, %p, %s, %s, %s, %s, %p)", (void*)dpy, (void*)stream, enum_to_string_EGL(name), GET_PRS(n), GET_PRS(offset), GET_PRS(size), (void*)data)
    EGLBoolean rval = glatter_eglQueryStreamMetadataNV(dpy, stream, name, n, offset, size, data);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglQueryStreamMetadataNV_defined
#endif
#ifndef eglSetStreamMetadataNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSetStreamMetadataNV, (dpy, stream, n, offset, size, data), (EGLDisplay dpy, EGLStreamKHR stream, EGLint n, EGLint offset, EGLint size, const void *data))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSetStreamMetadataNV_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLint n, EGLint offset, EGLint size, const void *data, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSetStreamMetadataNV, "(%p, %p, %s, %s, %s, %p)", (void*)dpy, (void*)stream, GET_PRS(n), GET_PRS(offset), GET_PRS(size), (void*)data)
    EGLBoolean rval = glatter_eglSetStreamMetadataNV(dpy, stream, n, offset, size, data);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSetStreamMetadataNV_defined
#endif
#endif // defined(EGL_NV_stream_metadata)
#if defined(EGL_NV_stream_reset)
#ifndef eglResetStreamNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglResetStreamNV, (dpy, stream), (EGLDisplay dpy, EGLStreamKHR stream))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglResetStreamNV_debug(EGLDisplay dpy, EGLStreamKHR stream, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglResetStreamNV, "(%p, %p)", (void*)dpy, (void*)stream)
    EGLBoolean rval = glatter_eglResetStreamNV(dpy, stream);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglResetStreamNV_defined
#endif
#endif // defined(EGL_NV_stream_reset)
#if defined(EGL_NV_stream_sync)
#ifndef eglCreateStreamSyncNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSyncKHR, EGLAPIENTRY, eglCreateStreamSyncNV, (dpy, stream, type, attrib_list), (EGLDisplay dpy, EGLStreamKHR stream, EGLenum type, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSyncKHR glatter_eglCreateStreamSyncNV_debug(EGLDisplay dpy, EGLStreamKHR stream, EGLenum type, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateStreamSyncNV, "(%p, %p, %s, %p)", (void*)dpy, (void*)stream, enum_to_string_EGL(type), (void*)attrib_list)
    EGLSyncKHR rval = glatter_eglCreateStreamSyncNV(dpy, stream, type, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateStreamSyncNV_defined
#endif
#endif // defined(EGL_NV_stream_sync)
#if defined(EGL_NV_sync)
#if defined(KHRONOS_SUPPORT_INT64)
#ifndef eglClientWaitSyncNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLint, EGLAPIENTRY, eglClientWaitSyncNV, (sync, flags, timeout), (EGLSyncNV sync, EGLint flags, EGLTimeNV timeout))
GLATTER_INLINE_OR_NOT EGLint glatter_eglClientWaitSyncNV_debug(EGLSyncNV sync, EGLint flags, EGLTimeNV timeout, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglClientWaitSyncNV, "(%p, %s, %s)", (void*)sync, GET_PRS(flags), GET_PRS(timeout))
    EGLint rval = glatter_eglClientWaitSyncNV(sync, flags, timeout);
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglClientWaitSyncNV_defined
#endif
#ifndef eglCreateFenceSyncNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLSyncNV, EGLAPIENTRY, eglCreateFenceSyncNV, (dpy, condition, attrib_list), (EGLDisplay dpy, EGLenum condition, const EGLint *attrib_list))
GLATTER_INLINE_OR_NOT EGLSyncNV glatter_eglCreateFenceSyncNV_debug(EGLDisplay dpy, EGLenum condition, const EGLint *attrib_list, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglCreateFenceSyncNV, "(%p, %s, %p)", (void*)dpy, enum_to_string_EGL(condition), (void*)attrib_list)
    EGLSyncNV rval = glatter_eglCreateFenceSyncNV(dpy, condition, attrib_list);
    GLATTER_RBLOCK("%p\n", (void*)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglCreateFenceSyncNV_defined
#endif
#ifndef eglDestroySyncNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglDestroySyncNV, (sync), (EGLSyncNV sync))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglDestroySyncNV_debug(EGLSyncNV sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglDestroySyncNV, "(%p)", (void*)sync)
    EGLBoolean rval = glatter_eglDestroySyncNV(sync);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglDestroySyncNV_defined
#endif
#ifndef eglFenceNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglFenceNV, (sync), (EGLSyncNV sync))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglFenceNV_debug(EGLSyncNV sync, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglFenceNV, "(%p)", (void*)sync)
    EGLBoolean rval = glatter_eglFenceNV(sync);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglFenceNV_defined
#endif
#ifndef eglGetSyncAttribNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglGetSyncAttribNV, (sync, attribute, value), (EGLSyncNV sync, EGLint attribute, EGLint *value))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglGetSyncAttribNV_debug(EGLSyncNV sync, EGLint attribute, EGLint *value, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetSyncAttribNV, "(%p, %s, %p)", (void*)sync, GET_PRS(attribute), (void*)value)
    EGLBoolean rval = glatter_eglGetSyncAttribNV(sync, attribute, value);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetSyncAttribNV_defined
#endif
#ifndef eglSignalSyncNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLBoolean, EGLAPIENTRY, eglSignalSyncNV, (sync, mode), (EGLSyncNV sync, EGLenum mode))
GLATTER_INLINE_OR_NOT EGLBoolean glatter_eglSignalSyncNV_debug(EGLSyncNV sync, EGLenum mode, const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglSignalSyncNV, "(%p, %s)", (void*)sync, enum_to_string_EGL(mode))
    EGLBoolean rval = glatter_eglSignalSyncNV(sync, mode);
    GLATTER_RBLOCK("%u\n", (unsigned int)rval);
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglSignalSyncNV_defined
#endif
#endif // defined(KHRONOS_SUPPORT_INT64)
#endif // defined(EGL_NV_sync)
#if defined(EGL_NV_system_time)
#if defined(KHRONOS_SUPPORT_INT64)
#ifndef eglGetSystemTimeFrequencyNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLuint64NV, EGLAPIENTRY, eglGetSystemTimeFrequencyNV, (), (void))
GLATTER_INLINE_OR_NOT EGLuint64NV glatter_eglGetSystemTimeFrequencyNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetSystemTimeFrequencyNV, "()")
    EGLuint64NV rval = glatter_eglGetSystemTimeFrequencyNV();
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetSystemTimeFrequencyNV_defined
#endif
#ifndef eglGetSystemTimeNV_defined
GLATTER_FBLOCK(return, EGL, EGLAPI, EGLuint64NV, EGLAPIENTRY, eglGetSystemTimeNV, (), (void))
GLATTER_INLINE_OR_NOT EGLuint64NV glatter_eglGetSystemTimeNV_debug(const char* file, int line)
{
    GLATTER_DBLOCK(file, line, eglGetSystemTimeNV, "()")
    EGLuint64NV rval = glatter_eglGetSystemTimeNV();
    GLATTER_RBLOCK("%s\n", GET_PRS(rval));
    GLATTER_CHECK_ERROR(EGL, file, line)
    return rval;
}
#define eglGetSystemTimeNV_defined
#endif
#endif // defined(__eglext_h_)
#endif // defined(EGL_NV_system_time)
#endif // defined(KHRONOS_SUPPORT_INT64)
#endif // GLATTER_EGL

