/*
Copyright 2018 Ioannis Makris

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// This file was generated by glatter.py script.



GLATTER_INLINE_OR_NOT
const char* enum_to_string_GL(GLenum e)
{
    switch (e) {
#if defined(GL_ES_VERSION_2_0)
        case 0x0: return "GL_POINTS";
        case 0x1: return "GL_LINES";
        case 0x2: return "GL_LINE_LOOP";
        case 0x3: return "GL_LINE_STRIP";
        case 0x4: return "GL_TRIANGLES";
        case 0x5: return "GL_TRIANGLE_STRIP";
        case 0x6: return "GL_TRIANGLE_FAN";
        case 0x200: return "GL_NEVER";
        case 0x201: return "GL_LESS";
        case 0x202: return "GL_EQUAL";
        case 0x203: return "GL_LEQUAL";
        case 0x204: return "GL_GREATER";
        case 0x205: return "GL_NOTEQUAL";
        case 0x206: return "GL_GEQUAL";
        case 0x207: return "GL_ALWAYS";
        case 0x300: return "GL_SRC_COLOR";
        case 0x301: return "GL_ONE_MINUS_SRC_COLOR";
        case 0x302: return "GL_SRC_ALPHA";
        case 0x303: return "GL_ONE_MINUS_SRC_ALPHA";
        case 0x304: return "GL_DST_ALPHA";
        case 0x305: return "GL_ONE_MINUS_DST_ALPHA";
        case 0x306: return "GL_DST_COLOR";
        case 0x307: return "GL_ONE_MINUS_DST_COLOR";
#endif
        case 0x308:
#if defined(GL_ES_VERSION_2_0)
                    return "GL_SRC_ALPHA_SATURATE";
#endif
#if defined(GL_EXT_blend_func_extended)
                    return "GL_SRC_ALPHA_SATURATE_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x404: return "GL_FRONT";
        case 0x405: return "GL_BACK";
        case 0x408: return "GL_FRONT_AND_BACK";
        case 0x500: return "GL_INVALID_ENUM";
        case 0x501: return "GL_INVALID_VALUE";
        case 0x502: return "GL_INVALID_OPERATION";
#endif
#if defined(GL_KHR_debug)
        case 0x503: return "GL_STACK_OVERFLOW_KHR";
        case 0x504: return "GL_STACK_UNDERFLOW_KHR";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x505: return "GL_OUT_OF_MEMORY";
        case 0x506: return "GL_INVALID_FRAMEBUFFER_OPERATION";
#endif
#if defined(GL_KHR_robustness)
        case 0x507: return "GL_CONTEXT_LOST_KHR";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x900: return "GL_CW";
        case 0x901: return "GL_CCW";
        case 0xb21: return "GL_LINE_WIDTH";
#endif
#if defined(GL_NV_polygon_mode)
        case 0xb40: return "GL_POLYGON_MODE_NV";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0xb44: return "GL_CULL_FACE";
        case 0xb45: return "GL_CULL_FACE_MODE";
        case 0xb46: return "GL_FRONT_FACE";
        case 0xb70: return "GL_DEPTH_RANGE";
        case 0xb71: return "GL_DEPTH_TEST";
        case 0xb72: return "GL_DEPTH_WRITEMASK";
        case 0xb73: return "GL_DEPTH_CLEAR_VALUE";
        case 0xb74: return "GL_DEPTH_FUNC";
        case 0xb90: return "GL_STENCIL_TEST";
        case 0xb91: return "GL_STENCIL_CLEAR_VALUE";
        case 0xb92: return "GL_STENCIL_FUNC";
        case 0xb93: return "GL_STENCIL_VALUE_MASK";
        case 0xb94: return "GL_STENCIL_FAIL";
        case 0xb95: return "GL_STENCIL_PASS_DEPTH_FAIL";
        case 0xb96: return "GL_STENCIL_PASS_DEPTH_PASS";
        case 0xb97: return "GL_STENCIL_REF";
        case 0xb98: return "GL_STENCIL_WRITEMASK";
        case 0xba2: return "GL_VIEWPORT";
#endif
#if defined(GL_NV_path_rendering)
        case 0xba3: return "GL_PATH_MODELVIEW_STACK_DEPTH_NV";
        case 0xba4: return "GL_PATH_PROJECTION_STACK_DEPTH_NV";
        case 0xba6: return "GL_PATH_MODELVIEW_MATRIX_NV";
        case 0xba7: return "GL_PATH_PROJECTION_MATRIX_NV";
#endif
#if defined(GL_QCOM_alpha_test)
        case 0xbc0: return "GL_ALPHA_TEST_QCOM";
        case 0xbc1: return "GL_ALPHA_TEST_FUNC_QCOM";
        case 0xbc2: return "GL_ALPHA_TEST_REF_QCOM";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0xbd0: return "GL_DITHER";
        case 0xbe2: return "GL_BLEND";
#endif
#if defined(GL_EXT_multiview_draw_buffers)
        case 0xc01: return "GL_DRAW_BUFFER_EXT";
#endif
        case 0xc02:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_READ_BUFFER";
#endif
#if defined(GL_EXT_multiview_draw_buffers)
                    return "GL_READ_BUFFER_EXT";
#endif
#if defined(GL_NV_read_buffer)
                    return "GL_READ_BUFFER_NV";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0xc10: return "GL_SCISSOR_BOX";
        case 0xc11: return "GL_SCISSOR_TEST";
        case 0xc22: return "GL_COLOR_CLEAR_VALUE";
        case 0xc23: return "GL_COLOR_WRITEMASK";
#endif
        case 0xcf2:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_UNPACK_ROW_LENGTH";
#endif
#if defined(GL_EXT_unpack_subimage)
                    return "GL_UNPACK_ROW_LENGTH_EXT";
#endif
            break;
        case 0xcf3:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_UNPACK_SKIP_ROWS";
#endif
#if defined(GL_EXT_unpack_subimage)
                    return "GL_UNPACK_SKIP_ROWS_EXT";
#endif
            break;
        case 0xcf4:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_UNPACK_SKIP_PIXELS";
#endif
#if defined(GL_EXT_unpack_subimage)
                    return "GL_UNPACK_SKIP_PIXELS_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0xcf5: return "GL_UNPACK_ALIGNMENT";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0xd02: return "GL_PACK_ROW_LENGTH";
        case 0xd03: return "GL_PACK_SKIP_ROWS";
        case 0xd04: return "GL_PACK_SKIP_PIXELS";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0xd05: return "GL_PACK_ALIGNMENT";
#endif
        case 0xd32:
#if defined(GL_APPLE_clip_distance)
                    return "GL_MAX_CLIP_DISTANCES_APPLE";
#endif
#if defined(GL_EXT_clip_cull_distance)
                    return "GL_MAX_CLIP_DISTANCES_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0xd33: return "GL_MAX_TEXTURE_SIZE";
#endif
#if defined(GL_NV_path_rendering)
        case 0xd36: return "GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV";
        case 0xd38: return "GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0xd3a: return "GL_MAX_VIEWPORT_DIMS";
        case 0xde1: return "GL_TEXTURE_2D";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x1000: return "GL_TEXTURE_WIDTH";
        case 0x1001: return "GL_TEXTURE_HEIGHT";
        case 0x1003: return "GL_TEXTURE_INTERNAL_FORMAT";
#endif
        case 0x1004:
#if defined(GL_EXT_texture_border_clamp)
                    return "GL_TEXTURE_BORDER_COLOR_EXT";
#endif
#if defined(GL_NV_texture_border_clamp)
                    return "GL_TEXTURE_BORDER_COLOR_NV";
#endif
#if defined(GL_OES_texture_border_clamp)
                    return "GL_TEXTURE_BORDER_COLOR_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x1100: return "GL_DONT_CARE";
        case 0x1101: return "GL_FASTEST";
        case 0x1102: return "GL_NICEST";
        case 0x1400: return "GL_BYTE";
        case 0x1401: return "GL_UNSIGNED_BYTE";
        case 0x1402: return "GL_SHORT";
        case 0x1403: return "GL_UNSIGNED_SHORT";
        case 0x1404: return "GL_INT";
        case 0x1405: return "GL_UNSIGNED_INT";
        case 0x1406: return "GL_FLOAT";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x140b: return "GL_HALF_FLOAT";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x140c: return "GL_FIXED";
#endif
#if defined(GL_NV_gpu_shader5)
        case 0x140e: return "GL_INT64_NV";
        case 0x140f: return "GL_UNSIGNED_INT64_NV";
#endif
#if defined(GL_NV_blend_equation_advanced)
        case 0x1506: return "GL_XOR_NV";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x150a: return "GL_INVERT";
#endif
#if defined(GL_NV_path_rendering)
        case 0x1700: return "GL_PATH_MODELVIEW_NV";
        case 0x1701: return "GL_PATH_PROJECTION_NV";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x1702: return "GL_TEXTURE";
#endif
        case 0x1800:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR";
#endif
#if defined(GL_EXT_discard_framebuffer)
                    return "GL_COLOR_EXT";
#endif
            break;
        case 0x1801:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DEPTH";
#endif
#if defined(GL_EXT_discard_framebuffer)
                    return "GL_DEPTH_EXT";
#endif
            break;
        case 0x1802:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_STENCIL";
#endif
#if defined(GL_EXT_discard_framebuffer)
                    return "GL_STENCIL_EXT";
#endif
            break;
        case 0x1901:
#if defined(GL_ES_VERSION_3_1)
                    return "GL_STENCIL_INDEX";
#endif
#if defined(GL_OES_texture_stencil8)
                    return "GL_STENCIL_INDEX_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x1902: return "GL_DEPTH_COMPONENT";
#endif
        case 0x1903:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RED";
#endif
#if defined(GL_EXT_texture_rg)
                    return "GL_RED_EXT";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_RED_NV";
#endif
            break;
        case 0x1904:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_GREEN";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_GREEN_NV";
#endif
            break;
        case 0x1905:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_BLUE";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_BLUE_NV";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x1906: return "GL_ALPHA";
        case 0x1907: return "GL_RGB";
        case 0x1908: return "GL_RGBA";
        case 0x1909: return "GL_LUMINANCE";
        case 0x190a: return "GL_LUMINANCE_ALPHA";
#endif
#if defined(GL_NV_polygon_mode)
        case 0x1b00: return "GL_POINT_NV";
        case 0x1b01: return "GL_LINE_NV";
        case 0x1b02: return "GL_FILL_NV";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x1e00: return "GL_KEEP";
        case 0x1e01: return "GL_REPLACE";
        case 0x1e02: return "GL_INCR";
        case 0x1e03: return "GL_DECR";
        case 0x1f00: return "GL_VENDOR";
        case 0x1f01: return "GL_RENDERER";
        case 0x1f02: return "GL_VERSION";
        case 0x1f03: return "GL_EXTENSIONS";
        case 0x2600: return "GL_NEAREST";
        case 0x2601: return "GL_LINEAR";
        case 0x2700: return "GL_NEAREST_MIPMAP_NEAREST";
        case 0x2701: return "GL_LINEAR_MIPMAP_NEAREST";
        case 0x2702: return "GL_NEAREST_MIPMAP_LINEAR";
        case 0x2703: return "GL_LINEAR_MIPMAP_LINEAR";
        case 0x2800: return "GL_TEXTURE_MAG_FILTER";
        case 0x2801: return "GL_TEXTURE_MIN_FILTER";
        case 0x2802: return "GL_TEXTURE_WRAP_S";
        case 0x2803: return "GL_TEXTURE_WRAP_T";
        case 0x2901: return "GL_REPEAT";
        case 0x2a00: return "GL_POLYGON_OFFSET_UNITS";
#endif
#if defined(GL_NV_polygon_mode)
        case 0x2a01: return "GL_POLYGON_OFFSET_POINT_NV";
        case 0x2a02: return "GL_POLYGON_OFFSET_LINE_NV";
#endif
        case 0x3000:
#if defined(GL_APPLE_clip_distance)
                    return "GL_CLIP_DISTANCE0_APPLE";
#endif
#if defined(GL_EXT_clip_cull_distance)
                    return "GL_CLIP_DISTANCE0_EXT";
#endif
            break;
        case 0x3001:
#if defined(GL_APPLE_clip_distance)
                    return "GL_CLIP_DISTANCE1_APPLE";
#endif
#if defined(GL_EXT_clip_cull_distance)
                    return "GL_CLIP_DISTANCE1_EXT";
#endif
            break;
        case 0x3002:
#if defined(GL_APPLE_clip_distance)
                    return "GL_CLIP_DISTANCE2_APPLE";
#endif
#if defined(GL_EXT_clip_cull_distance)
                    return "GL_CLIP_DISTANCE2_EXT";
#endif
            break;
        case 0x3003:
#if defined(GL_APPLE_clip_distance)
                    return "GL_CLIP_DISTANCE3_APPLE";
#endif
#if defined(GL_EXT_clip_cull_distance)
                    return "GL_CLIP_DISTANCE3_EXT";
#endif
            break;
        case 0x3004:
#if defined(GL_APPLE_clip_distance)
                    return "GL_CLIP_DISTANCE4_APPLE";
#endif
#if defined(GL_EXT_clip_cull_distance)
                    return "GL_CLIP_DISTANCE4_EXT";
#endif
            break;
        case 0x3005:
#if defined(GL_APPLE_clip_distance)
                    return "GL_CLIP_DISTANCE5_APPLE";
#endif
#if defined(GL_EXT_clip_cull_distance)
                    return "GL_CLIP_DISTANCE5_EXT";
#endif
            break;
        case 0x3006:
#if defined(GL_APPLE_clip_distance)
                    return "GL_CLIP_DISTANCE6_APPLE";
#endif
#if defined(GL_EXT_clip_cull_distance)
                    return "GL_CLIP_DISTANCE6_EXT";
#endif
            break;
        case 0x3007:
#if defined(GL_APPLE_clip_distance)
                    return "GL_CLIP_DISTANCE7_APPLE";
#endif
#if defined(GL_EXT_clip_cull_distance)
                    return "GL_CLIP_DISTANCE7_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8001: return "GL_CONSTANT_COLOR";
        case 0x8002: return "GL_ONE_MINUS_CONSTANT_COLOR";
        case 0x8003: return "GL_CONSTANT_ALPHA";
        case 0x8004: return "GL_ONE_MINUS_CONSTANT_ALPHA";
        case 0x8005: return "GL_BLEND_COLOR";
        case 0x8006: return "GL_FUNC_ADD";
#endif
        case 0x8007:
#if defined(GL_ES_VERSION_3_0) || defined(GL_OES_draw_buffers_indexed)
                    return "GL_MIN";
#endif
#if defined(GL_EXT_blend_minmax)
                    return "GL_MIN_EXT";
#endif
            break;
        case 0x8008:
#if defined(GL_ES_VERSION_3_0) || defined(GL_OES_draw_buffers_indexed)
                    return "GL_MAX";
#endif
#if defined(GL_EXT_blend_minmax)
                    return "GL_MAX_EXT";
#endif
            break;
        case 0x8009:
#if defined(GL_ES_VERSION_2_0)
                    return "GL_BLEND_EQUATION";
#endif
#if defined(GL_ES_VERSION_2_0)
                    return "GL_BLEND_EQUATION_RGB";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x800a: return "GL_FUNC_SUBTRACT";
        case 0x800b: return "GL_FUNC_REVERSE_SUBTRACT";
        case 0x8033: return "GL_UNSIGNED_SHORT_4_4_4_4";
        case 0x8034: return "GL_UNSIGNED_SHORT_5_5_5_1";
        case 0x8037: return "GL_POLYGON_OFFSET_FILL";
        case 0x8038: return "GL_POLYGON_OFFSET_FACTOR";
#endif
        case 0x803c:
#if defined(GL_EXT_texture_storage)
                    return "GL_ALPHA8_EXT";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_ALPHA8_OES";
#endif
            break;
        case 0x8040:
#if defined(GL_EXT_texture_storage)
                    return "GL_LUMINANCE8_EXT";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_LUMINANCE8_OES";
#endif
            break;
#if defined(GL_OES_required_internalformat)
        case 0x8043: return "GL_LUMINANCE4_ALPHA4_OES";
#endif
        case 0x8045:
#if defined(GL_EXT_texture_storage)
                    return "GL_LUMINANCE8_ALPHA8_EXT";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_LUMINANCE8_ALPHA8_OES";
#endif
            break;
        case 0x8051:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RGB8";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_RGB8_OES";
#endif
            break;
#if defined(GL_OES_required_internalformat)
        case 0x8052: return "GL_RGB10_EXT";
#endif
#if defined(GL_EXT_texture_norm16)
        case 0x8054: return "GL_RGB16_EXT";
#endif
        case 0x8056:
#if defined(GL_ES_VERSION_2_0)
                    return "GL_RGBA4";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_RGBA4_OES";
#endif
            break;
        case 0x8057:
#if defined(GL_ES_VERSION_2_0)
                    return "GL_RGB5_A1";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_RGB5_A1_OES";
#endif
            break;
        case 0x8058:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RGBA8";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_RGBA8_OES";
#endif
            break;
        case 0x8059:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RGB10_A2";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_RGB10_A2_EXT";
#endif
            break;
#if defined(GL_EXT_texture_norm16)
        case 0x805b: return "GL_RGBA16_EXT";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x805c: return "GL_TEXTURE_RED_SIZE";
        case 0x805d: return "GL_TEXTURE_GREEN_SIZE";
        case 0x805e: return "GL_TEXTURE_BLUE_SIZE";
        case 0x805f: return "GL_TEXTURE_ALPHA_SIZE";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8069: return "GL_TEXTURE_BINDING_2D";
#endif
        case 0x806a:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_TEXTURE_BINDING_3D";
#endif
#if defined(GL_OES_texture_3D)
                    return "GL_TEXTURE_BINDING_3D_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x806d: return "GL_UNPACK_SKIP_IMAGES";
        case 0x806e: return "GL_UNPACK_IMAGE_HEIGHT";
#endif
        case 0x806f:
#if defined(GL_ES_VERSION_3_0) || defined(GL_EXT_sparse_texture)
                    return "GL_TEXTURE_3D";
#endif
#if defined(GL_OES_texture_3D)
                    return "GL_TEXTURE_3D_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x8071: return "GL_TEXTURE_DEPTH";
#endif
        case 0x8072:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_TEXTURE_WRAP_R";
#endif
#if defined(GL_OES_texture_3D)
                    return "GL_TEXTURE_WRAP_R_OES";
#endif
            break;
        case 0x8073:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_MAX_3D_TEXTURE_SIZE";
#endif
#if defined(GL_OES_texture_3D)
                    return "GL_MAX_3D_TEXTURE_SIZE_OES";
#endif
            break;
#if defined(GL_KHR_debug)
        case 0x8074: return "GL_VERTEX_ARRAY_KHR";
#endif
#if defined(GL_EXT_multisampled_compatibility)
        case 0x809d: return "GL_MULTISAMPLE_EXT";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x809e: return "GL_SAMPLE_ALPHA_TO_COVERAGE";
#endif
#if defined(GL_EXT_multisampled_compatibility)
        case 0x809f: return "GL_SAMPLE_ALPHA_TO_ONE_EXT";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x80a0: return "GL_SAMPLE_COVERAGE";
        case 0x80a8: return "GL_SAMPLE_BUFFERS";
        case 0x80a9: return "GL_SAMPLES";
        case 0x80aa: return "GL_SAMPLE_COVERAGE_VALUE";
        case 0x80ab: return "GL_SAMPLE_COVERAGE_INVERT";
        case 0x80c8: return "GL_BLEND_DST_RGB";
        case 0x80c9: return "GL_BLEND_SRC_RGB";
        case 0x80ca: return "GL_BLEND_DST_ALPHA";
        case 0x80cb: return "GL_BLEND_SRC_ALPHA";
#endif
        case 0x80e1:
#if defined(GL_APPLE_texture_format_BGRA8888)
                    return "GL_BGRA_EXT";
#endif
#if defined(GL_IMG_read_format)
                    return "GL_BGRA_IMG";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x80e8: return "GL_MAX_ELEMENTS_VERTICES";
        case 0x80e9: return "GL_MAX_ELEMENTS_INDICES";
#endif
        case 0x812d:
#if defined(GL_EXT_texture_border_clamp)
                    return "GL_CLAMP_TO_BORDER_EXT";
#endif
#if defined(GL_NV_texture_border_clamp)
                    return "GL_CLAMP_TO_BORDER_NV";
#endif
#if defined(GL_OES_texture_border_clamp)
                    return "GL_CLAMP_TO_BORDER_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x812f: return "GL_CLAMP_TO_EDGE";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x813a: return "GL_TEXTURE_MIN_LOD";
        case 0x813b: return "GL_TEXTURE_MAX_LOD";
        case 0x813c: return "GL_TEXTURE_BASE_LEVEL";
#endif
        case 0x813d:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_TEXTURE_MAX_LEVEL";
#endif
#if defined(GL_APPLE_texture_max_level)
                    return "GL_TEXTURE_MAX_LEVEL_APPLE";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8192: return "GL_GENERATE_MIPMAP_HINT";
#endif
        case 0x81a5:
#if defined(GL_ES_VERSION_2_0)
                    return "GL_DEPTH_COMPONENT16";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_DEPTH_COMPONENT16_OES";
#endif
            break;
        case 0x81a6:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DEPTH_COMPONENT24";
#endif
#if defined(GL_OES_depth24)
                    return "GL_DEPTH_COMPONENT24_OES";
#endif
            break;
#if defined(GL_OES_depth32)
        case 0x81a7: return "GL_DEPTH_COMPONENT32_OES";
#endif
        case 0x8210:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING";
#endif
#if defined(GL_EXT_sRGB)
                    return "GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT";
#endif
            break;
        case 0x8211:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE";
#endif
#if defined(GL_EXT_color_buffer_half_float)
                    return "GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8212: return "GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE";
        case 0x8213: return "GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE";
        case 0x8214: return "GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE";
        case 0x8215: return "GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE";
        case 0x8216: return "GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE";
        case 0x8217: return "GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE";
        case 0x8218: return "GL_FRAMEBUFFER_DEFAULT";
#endif
        case 0x8219:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FRAMEBUFFER_UNDEFINED";
#endif
#if defined(GL_OES_surfaceless_context)
                    return "GL_FRAMEBUFFER_UNDEFINED_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x821a: return "GL_DEPTH_STENCIL_ATTACHMENT";
        case 0x821b: return "GL_MAJOR_VERSION";
        case 0x821c: return "GL_MINOR_VERSION";
        case 0x821d: return "GL_NUM_EXTENSIONS";
#endif
#if defined(GL_EXT_buffer_storage)
        case 0x821f: return "GL_BUFFER_IMMUTABLE_STORAGE_EXT";
        case 0x8220: return "GL_BUFFER_STORAGE_FLAGS_EXT";
#endif
        case 0x8221:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED_OES";
#endif
            break;
        case 0x8227:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RG";
#endif
#if defined(GL_EXT_texture_rg)
                    return "GL_RG_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8228: return "GL_RG_INTEGER";
#endif
        case 0x8229:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_R8";
#endif
#if defined(GL_EXT_texture_rg)
                    return "GL_R8_EXT";
#endif
            break;
#if defined(GL_EXT_texture_norm16)
        case 0x822a: return "GL_R16_EXT";
#endif
        case 0x822b:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RG8";
#endif
#if defined(GL_EXT_texture_rg)
                    return "GL_RG8_EXT";
#endif
            break;
#if defined(GL_EXT_texture_norm16)
        case 0x822c: return "GL_RG16_EXT";
#endif
        case 0x822d:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_R16F";
#endif
#if defined(GL_EXT_color_buffer_half_float)
                    return "GL_R16F_EXT";
#endif
            break;
        case 0x822e:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_R32F";
#endif
#if defined(GL_EXT_texture_storage)
                    return "GL_R32F_EXT";
#endif
            break;
        case 0x822f:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RG16F";
#endif
#if defined(GL_EXT_color_buffer_half_float)
                    return "GL_RG16F_EXT";
#endif
            break;
        case 0x8230:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RG32F";
#endif
#if defined(GL_EXT_texture_storage)
                    return "GL_RG32F_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8231: return "GL_R8I";
        case 0x8232: return "GL_R8UI";
        case 0x8233: return "GL_R16I";
        case 0x8234: return "GL_R16UI";
        case 0x8235: return "GL_R32I";
        case 0x8236: return "GL_R32UI";
        case 0x8237: return "GL_RG8I";
        case 0x8238: return "GL_RG8UI";
        case 0x8239: return "GL_RG16I";
        case 0x823a: return "GL_RG16UI";
        case 0x823b: return "GL_RG32I";
        case 0x823c: return "GL_RG32UI";
#endif
#if defined(GL_KHR_debug)
        case 0x8242: return "GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR";
        case 0x8243: return "GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR";
        case 0x8244: return "GL_DEBUG_CALLBACK_FUNCTION_KHR";
        case 0x8245: return "GL_DEBUG_CALLBACK_USER_PARAM_KHR";
        case 0x8246: return "GL_DEBUG_SOURCE_API_KHR";
        case 0x8247: return "GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR";
        case 0x8248: return "GL_DEBUG_SOURCE_SHADER_COMPILER_KHR";
        case 0x8249: return "GL_DEBUG_SOURCE_THIRD_PARTY_KHR";
        case 0x824a: return "GL_DEBUG_SOURCE_APPLICATION_KHR";
        case 0x824b: return "GL_DEBUG_SOURCE_OTHER_KHR";
        case 0x824c: return "GL_DEBUG_TYPE_ERROR_KHR";
        case 0x824d: return "GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR";
        case 0x824e: return "GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR";
        case 0x824f: return "GL_DEBUG_TYPE_PORTABILITY_KHR";
        case 0x8250: return "GL_DEBUG_TYPE_PERFORMANCE_KHR";
        case 0x8251: return "GL_DEBUG_TYPE_OTHER_KHR";
#endif
        case 0x8252:
#if defined(GL_EXT_robustness)
                    return "GL_LOSE_CONTEXT_ON_RESET_EXT";
#endif
#if defined(GL_KHR_robustness)
                    return "GL_LOSE_CONTEXT_ON_RESET_KHR";
#endif
            break;
        case 0x8253:
#if defined(GL_EXT_robustness)
                    return "GL_GUILTY_CONTEXT_RESET_EXT";
#endif
#if defined(GL_KHR_robustness)
                    return "GL_GUILTY_CONTEXT_RESET_KHR";
#endif
            break;
        case 0x8254:
#if defined(GL_EXT_robustness)
                    return "GL_INNOCENT_CONTEXT_RESET_EXT";
#endif
#if defined(GL_KHR_robustness)
                    return "GL_INNOCENT_CONTEXT_RESET_KHR";
#endif
            break;
        case 0x8255:
#if defined(GL_EXT_robustness)
                    return "GL_UNKNOWN_CONTEXT_RESET_EXT";
#endif
#if defined(GL_KHR_robustness)
                    return "GL_UNKNOWN_CONTEXT_RESET_KHR";
#endif
            break;
        case 0x8256:
#if defined(GL_EXT_robustness)
                    return "GL_RESET_NOTIFICATION_STRATEGY_EXT";
#endif
#if defined(GL_KHR_robustness)
                    return "GL_RESET_NOTIFICATION_STRATEGY_KHR";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8257: return "GL_PROGRAM_BINARY_RETRIEVABLE_HINT";
#endif
        case 0x8258:
#if defined(GL_ES_VERSION_3_1)
                    return "GL_PROGRAM_SEPARABLE";
#endif
#if defined(GL_EXT_separate_shader_objects)
                    return "GL_PROGRAM_SEPARABLE_EXT";
#endif
            break;
        case 0x8259:
#if defined(GL_ES_VERSION_3_1)
                    return "GL_ACTIVE_PROGRAM";
#endif
#if defined(GL_EXT_separate_shader_objects)
                    return "GL_ACTIVE_PROGRAM_EXT";
#endif
            break;
        case 0x825a:
#if defined(GL_ES_VERSION_3_1)
                    return "GL_PROGRAM_PIPELINE_BINDING";
#endif
#if defined(GL_EXT_separate_shader_objects)
                    return "GL_PROGRAM_PIPELINE_BINDING_EXT";
#endif
            break;
        case 0x825b:
#if defined(GL_NV_viewport_array)
                    return "GL_MAX_VIEWPORTS_NV";
#endif
#if defined(GL_OES_viewport_array)
                    return "GL_MAX_VIEWPORTS_OES";
#endif
            break;
        case 0x825d:
#if defined(GL_NV_viewport_array)
                    return "GL_VIEWPORT_BOUNDS_RANGE_NV";
#endif
#if defined(GL_OES_viewport_array)
                    return "GL_VIEWPORT_BOUNDS_RANGE_OES";
#endif
            break;
        case 0x825e:
#if defined(GL_EXT_geometry_shader)
                    return "GL_LAYER_PROVOKING_VERTEX_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_LAYER_PROVOKING_VERTEX_OES";
#endif
            break;
        case 0x825f:
#if defined(GL_NV_viewport_array)
                    return "GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV";
#endif
#if defined(GL_OES_viewport_array)
                    return "GL_VIEWPORT_INDEX_PROVOKING_VERTEX_OES";
#endif
            break;
        case 0x8260:
#if defined(GL_EXT_geometry_shader)
                    return "GL_UNDEFINED_VERTEX_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_UNDEFINED_VERTEX_OES";
#endif
            break;
        case 0x8261:
#if defined(GL_EXT_robustness)
                    return "GL_NO_RESET_NOTIFICATION_EXT";
#endif
#if defined(GL_KHR_robustness)
                    return "GL_NO_RESET_NOTIFICATION_KHR";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x8262: return "GL_MAX_COMPUTE_SHARED_MEMORY_SIZE";
        case 0x8263: return "GL_MAX_COMPUTE_UNIFORM_COMPONENTS";
        case 0x8264: return "GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS";
        case 0x8265: return "GL_MAX_COMPUTE_ATOMIC_COUNTERS";
        case 0x8266: return "GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS";
        case 0x8267: return "GL_COMPUTE_WORK_GROUP_SIZE";
#endif
#if defined(GL_KHR_debug)
        case 0x8268: return "GL_DEBUG_TYPE_MARKER_KHR";
        case 0x8269: return "GL_DEBUG_TYPE_PUSH_GROUP_KHR";
        case 0x826a: return "GL_DEBUG_TYPE_POP_GROUP_KHR";
        case 0x826b: return "GL_DEBUG_SEVERITY_NOTIFICATION_KHR";
        case 0x826c: return "GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR";
        case 0x826d: return "GL_DEBUG_GROUP_STACK_DEPTH_KHR";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x826e: return "GL_MAX_UNIFORM_LOCATIONS";
        case 0x82d4: return "GL_VERTEX_ATTRIB_BINDING";
        case 0x82d5: return "GL_VERTEX_ATTRIB_RELATIVE_OFFSET";
        case 0x82d6: return "GL_VERTEX_BINDING_DIVISOR";
        case 0x82d7: return "GL_VERTEX_BINDING_OFFSET";
        case 0x82d8: return "GL_VERTEX_BINDING_STRIDE";
        case 0x82d9: return "GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET";
        case 0x82da: return "GL_MAX_VERTEX_ATTRIB_BINDINGS";
#endif
        case 0x82db:
#if defined(GL_EXT_texture_view)
                    return "GL_TEXTURE_VIEW_MIN_LEVEL_EXT";
#endif
#if defined(GL_OES_texture_view)
                    return "GL_TEXTURE_VIEW_MIN_LEVEL_OES";
#endif
            break;
        case 0x82dc:
#if defined(GL_EXT_texture_view)
                    return "GL_TEXTURE_VIEW_NUM_LEVELS_EXT";
#endif
#if defined(GL_OES_texture_view)
                    return "GL_TEXTURE_VIEW_NUM_LEVELS_OES";
#endif
            break;
        case 0x82dd:
#if defined(GL_EXT_texture_view)
                    return "GL_TEXTURE_VIEW_MIN_LAYER_EXT";
#endif
#if defined(GL_OES_texture_view)
                    return "GL_TEXTURE_VIEW_MIN_LAYER_OES";
#endif
            break;
        case 0x82de:
#if defined(GL_EXT_texture_view)
                    return "GL_TEXTURE_VIEW_NUM_LAYERS_EXT";
#endif
#if defined(GL_OES_texture_view)
                    return "GL_TEXTURE_VIEW_NUM_LAYERS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0) || defined(GL_OES_texture_view)
        case 0x82df: return "GL_TEXTURE_IMMUTABLE_LEVELS";
#endif
#if defined(GL_KHR_debug)
        case 0x82e0: return "GL_BUFFER_KHR";
        case 0x82e1: return "GL_SHADER_KHR";
        case 0x82e2: return "GL_PROGRAM_KHR";
        case 0x82e3: return "GL_QUERY_KHR";
        case 0x82e4: return "GL_PROGRAM_PIPELINE_KHR";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x82e5: return "GL_MAX_VERTEX_ATTRIB_STRIDE";
#endif
        case 0x82e6:
#if defined(GL_KHR_debug)
                    return "GL_SAMPLER";
#endif
#if defined(GL_KHR_debug)
                    return "GL_SAMPLER_KHR";
#endif
            break;
#if defined(GL_KHR_debug)
        case 0x82e8: return "GL_MAX_LABEL_LENGTH_KHR";
#endif
#if defined(GL_EXT_clip_cull_distance)
        case 0x82f9: return "GL_MAX_CULL_DISTANCES_EXT";
        case 0x82fa: return "GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_EXT";
#endif
#if defined(GL_KHR_context_flush_control)
        case 0x82fb: return "GL_CONTEXT_RELEASE_BEHAVIOR_KHR";
        case 0x82fc: return "GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8363: return "GL_UNSIGNED_SHORT_5_6_5";
#endif
        case 0x8365:
#if defined(GL_EXT_read_format_bgra)
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT";
#endif
#if defined(GL_IMG_read_format)
                    return "GL_UNSIGNED_SHORT_4_4_4_4_REV_IMG";
#endif
            break;
#if defined(GL_EXT_read_format_bgra)
        case 0x8366: return "GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT";
#endif
        case 0x8368:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_UNSIGNED_INT_2_10_10_10_REV";
#endif
#if defined(GL_EXT_texture_type_2_10_10_10_REV)
                    return "GL_UNSIGNED_INT_2_10_10_10_REV_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8370: return "GL_MIRRORED_REPEAT";
#endif
#if defined(GL_EXT_texture_compression_dxt1)
        case 0x83f0: return "GL_COMPRESSED_RGB_S3TC_DXT1_EXT";
        case 0x83f1: return "GL_COMPRESSED_RGBA_S3TC_DXT1_EXT";
#endif
        case 0x83f2:
#if defined(GL_ANGLE_texture_compression_dxt3)
                    return "GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE";
#endif
#if defined(GL_EXT_texture_compression_s3tc)
                    return "GL_COMPRESSED_RGBA_S3TC_DXT3_EXT";
#endif
            break;
        case 0x83f3:
#if defined(GL_ANGLE_texture_compression_dxt5)
                    return "GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE";
#endif
#if defined(GL_EXT_texture_compression_s3tc)
                    return "GL_COMPRESSED_RGBA_S3TC_DXT5_EXT";
#endif
            break;
#if defined(GL_INTEL_performance_query)
        case 0x83f9: return "GL_PERFQUERY_DONOT_FLUSH_INTEL";
        case 0x83fa: return "GL_PERFQUERY_FLUSH_INTEL";
        case 0x83fb: return "GL_PERFQUERY_WAIT_INTEL";
#endif
#if defined(GL_INTEL_blackhole_render)
        case 0x83fc: return "GL_BLACKHOLE_RENDER_INTEL";
#endif
#if defined(GL_INTEL_conservative_rasterization)
        case 0x83fe: return "GL_CONSERVATIVE_RASTERIZATION_INTEL";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x846d: return "GL_ALIASED_POINT_SIZE_RANGE";
        case 0x846e: return "GL_ALIASED_LINE_WIDTH_RANGE";
        case 0x84c0: return "GL_TEXTURE0";
        case 0x84c1: return "GL_TEXTURE1";
        case 0x84c2: return "GL_TEXTURE2";
        case 0x84c3: return "GL_TEXTURE3";
        case 0x84c4: return "GL_TEXTURE4";
        case 0x84c5: return "GL_TEXTURE5";
        case 0x84c6: return "GL_TEXTURE6";
        case 0x84c7: return "GL_TEXTURE7";
        case 0x84c8: return "GL_TEXTURE8";
        case 0x84c9: return "GL_TEXTURE9";
        case 0x84ca: return "GL_TEXTURE10";
        case 0x84cb: return "GL_TEXTURE11";
        case 0x84cc: return "GL_TEXTURE12";
        case 0x84cd: return "GL_TEXTURE13";
        case 0x84ce: return "GL_TEXTURE14";
        case 0x84cf: return "GL_TEXTURE15";
        case 0x84d0: return "GL_TEXTURE16";
        case 0x84d1: return "GL_TEXTURE17";
        case 0x84d2: return "GL_TEXTURE18";
        case 0x84d3: return "GL_TEXTURE19";
        case 0x84d4: return "GL_TEXTURE20";
        case 0x84d5: return "GL_TEXTURE21";
        case 0x84d6: return "GL_TEXTURE22";
        case 0x84d7: return "GL_TEXTURE23";
        case 0x84d8: return "GL_TEXTURE24";
        case 0x84d9: return "GL_TEXTURE25";
        case 0x84da: return "GL_TEXTURE26";
        case 0x84db: return "GL_TEXTURE27";
        case 0x84dc: return "GL_TEXTURE28";
        case 0x84dd: return "GL_TEXTURE29";
        case 0x84de: return "GL_TEXTURE30";
        case 0x84df: return "GL_TEXTURE31";
        case 0x84e0: return "GL_ACTIVE_TEXTURE";
#endif
#if defined(GL_NV_path_rendering)
        case 0x84e3: return "GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV";
        case 0x84e4: return "GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x84e8: return "GL_MAX_RENDERBUFFER_SIZE";
#endif
#if defined(GL_NV_fence)
        case 0x84f2: return "GL_ALL_COMPLETED_NV";
        case 0x84f3: return "GL_FENCE_STATUS_NV";
        case 0x84f4: return "GL_FENCE_CONDITION_NV";
#endif
        case 0x84f9:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DEPTH_STENCIL";
#endif
#if defined(GL_OES_packed_depth_stencil)
                    return "GL_DEPTH_STENCIL_OES";
#endif
            break;
        case 0x84fa:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_UNSIGNED_INT_24_8";
#endif
#if defined(GL_OES_packed_depth_stencil)
                    return "GL_UNSIGNED_INT_24_8_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x84fd: return "GL_MAX_TEXTURE_LOD_BIAS";
#endif
#if defined(GL_EXT_texture_filter_anisotropic)
        case 0x84fe: return "GL_TEXTURE_MAX_ANISOTROPY_EXT";
        case 0x84ff: return "GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8507: return "GL_INCR_WRAP";
        case 0x8508: return "GL_DECR_WRAP";
        case 0x8513: return "GL_TEXTURE_CUBE_MAP";
        case 0x8514: return "GL_TEXTURE_BINDING_CUBE_MAP";
        case 0x8515: return "GL_TEXTURE_CUBE_MAP_POSITIVE_X";
        case 0x8516: return "GL_TEXTURE_CUBE_MAP_NEGATIVE_X";
        case 0x8517: return "GL_TEXTURE_CUBE_MAP_POSITIVE_Y";
        case 0x8518: return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Y";
        case 0x8519: return "GL_TEXTURE_CUBE_MAP_POSITIVE_Z";
        case 0x851a: return "GL_TEXTURE_CUBE_MAP_NEGATIVE_Z";
        case 0x851c: return "GL_MAX_CUBE_MAP_TEXTURE_SIZE";
#endif
#if defined(GL_EXT_blend_func_extended)
        case 0x8589: return "GL_SRC1_ALPHA_EXT";
#endif
        case 0x85b5:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_VERTEX_ARRAY_BINDING";
#endif
#if defined(GL_OES_vertex_array_object)
                    return "GL_VERTEX_ARRAY_BINDING_OES";
#endif
            break;
#if defined(GL_APPLE_rgb_422)
        case 0x85ba: return "GL_UNSIGNED_SHORT_8_8_APPLE";
        case 0x85bb: return "GL_UNSIGNED_SHORT_8_8_REV_APPLE";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8622: return "GL_VERTEX_ATTRIB_ARRAY_ENABLED";
        case 0x8623: return "GL_VERTEX_ATTRIB_ARRAY_SIZE";
        case 0x8624: return "GL_VERTEX_ATTRIB_ARRAY_STRIDE";
        case 0x8625: return "GL_VERTEX_ATTRIB_ARRAY_TYPE";
        case 0x8626: return "GL_CURRENT_VERTEX_ATTRIB";
        case 0x8645: return "GL_VERTEX_ATTRIB_ARRAY_POINTER";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x86a1: return "GL_TEXTURE_COMPRESSED";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x86a2: return "GL_NUM_COMPRESSED_TEXTURE_FORMATS";
        case 0x86a3: return "GL_COMPRESSED_TEXTURE_FORMATS";
#endif
#if defined(GL_AMD_program_binary_Z400)
        case 0x8740: return "GL_Z400_BINARY_AMD";
#endif
        case 0x8741:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_PROGRAM_BINARY_LENGTH";
#endif
#if defined(GL_OES_get_program_binary)
                    return "GL_PROGRAM_BINARY_LENGTH_OES";
#endif
            break;
#if defined(GL_EXT_texture_mirror_clamp_to_edge)
        case 0x8743: return "GL_MIRROR_CLAMP_TO_EDGE_EXT";
#endif
#if defined(GL_MESA_program_binary_formats)
        case 0x875f: return "GL_PROGRAM_BINARY_FORMAT_MESA";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8764: return "GL_BUFFER_SIZE";
        case 0x8765: return "GL_BUFFER_USAGE";
#endif
#if defined(GL_AMD_compressed_ATC_texture)
        case 0x87ee: return "GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD";
#endif
#if defined(GL_AMD_compressed_3DC_texture)
        case 0x87f9: return "GL_3DC_X_AMD";
        case 0x87fa: return "GL_3DC_XY_AMD";
#endif
        case 0x87fe:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_NUM_PROGRAM_BINARY_FORMATS";
#endif
#if defined(GL_OES_get_program_binary)
                    return "GL_NUM_PROGRAM_BINARY_FORMATS_OES";
#endif
            break;
        case 0x87ff:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_PROGRAM_BINARY_FORMATS";
#endif
#if defined(GL_OES_get_program_binary)
                    return "GL_PROGRAM_BINARY_FORMATS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8800: return "GL_STENCIL_BACK_FUNC";
        case 0x8801: return "GL_STENCIL_BACK_FAIL";
        case 0x8802: return "GL_STENCIL_BACK_PASS_DEPTH_FAIL";
        case 0x8803: return "GL_STENCIL_BACK_PASS_DEPTH_PASS";
#endif
        case 0x8814:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RGBA32F";
#endif
#if defined(GL_EXT_texture_storage)
                    return "GL_RGBA32F_EXT";
#endif
            break;
        case 0x8815:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RGB32F";
#endif
#if defined(GL_EXT_texture_storage)
                    return "GL_RGB32F_EXT";
#endif
            break;
#if defined(GL_EXT_texture_storage)
        case 0x8816: return "GL_ALPHA32F_EXT";
        case 0x8818: return "GL_LUMINANCE32F_EXT";
        case 0x8819: return "GL_LUMINANCE_ALPHA32F_EXT";
#endif
        case 0x881a:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RGBA16F";
#endif
#if defined(GL_EXT_color_buffer_half_float)
                    return "GL_RGBA16F_EXT";
#endif
            break;
        case 0x881b:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RGB16F";
#endif
#if defined(GL_EXT_color_buffer_half_float)
                    return "GL_RGB16F_EXT";
#endif
            break;
#if defined(GL_EXT_texture_storage)
        case 0x881c: return "GL_ALPHA16F_EXT";
        case 0x881e: return "GL_LUMINANCE16F_EXT";
        case 0x881f: return "GL_LUMINANCE_ALPHA16F_EXT";
#endif
#if defined(GL_QCOM_writeonly_rendering)
        case 0x8823: return "GL_WRITEONLY_RENDERING_QCOM";
#endif
        case 0x8824:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_MAX_DRAW_BUFFERS";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_MAX_DRAW_BUFFERS_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_MAX_DRAW_BUFFERS_NV";
#endif
            break;
        case 0x8825:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER0";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER0_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER0_NV";
#endif
            break;
        case 0x8826:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER1";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER1_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER1_NV";
#endif
            break;
        case 0x8827:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER2";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER2_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER2_NV";
#endif
            break;
        case 0x8828:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER3";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER3_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER3_NV";
#endif
            break;
        case 0x8829:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER4";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER4_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER4_NV";
#endif
            break;
        case 0x882a:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER5";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER5_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER5_NV";
#endif
            break;
        case 0x882b:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER6";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER6_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER6_NV";
#endif
            break;
        case 0x882c:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER7";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER7_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER7_NV";
#endif
            break;
        case 0x882d:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER8";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER8_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER8_NV";
#endif
            break;
        case 0x882e:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER9";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER9_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER9_NV";
#endif
            break;
        case 0x882f:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER10";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER10_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER10_NV";
#endif
            break;
        case 0x8830:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER11";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER11_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER11_NV";
#endif
            break;
        case 0x8831:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER12";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER12_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER12_NV";
#endif
            break;
        case 0x8832:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER13";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER13_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER13_NV";
#endif
            break;
        case 0x8833:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER14";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER14_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER14_NV";
#endif
            break;
        case 0x8834:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_BUFFER15";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_DRAW_BUFFER15_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_DRAW_BUFFER15_NV";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x883d: return "GL_BLEND_EQUATION_ALPHA";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x884a: return "GL_TEXTURE_DEPTH_SIZE";
#endif
        case 0x884c:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_TEXTURE_COMPARE_MODE";
#endif
#if defined(GL_EXT_shadow_samplers)
                    return "GL_TEXTURE_COMPARE_MODE_EXT";
#endif
            break;
        case 0x884d:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_TEXTURE_COMPARE_FUNC";
#endif
#if defined(GL_EXT_shadow_samplers)
                    return "GL_TEXTURE_COMPARE_FUNC_EXT";
#endif
            break;
        case 0x884e:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COMPARE_REF_TO_TEXTURE";
#endif
#if defined(GL_EXT_shadow_samplers)
                    return "GL_COMPARE_REF_TO_TEXTURE_EXT";
#endif
            break;
        case 0x8865:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_CURRENT_QUERY";
#endif
#if defined(GL_EXT_disjoint_timer_query)
                    return "GL_CURRENT_QUERY_EXT";
#endif
            break;
        case 0x8866:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_QUERY_RESULT";
#endif
#if defined(GL_EXT_disjoint_timer_query)
                    return "GL_QUERY_RESULT_EXT";
#endif
            break;
        case 0x8867:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_QUERY_RESULT_AVAILABLE";
#endif
#if defined(GL_EXT_disjoint_timer_query)
                    return "GL_QUERY_RESULT_AVAILABLE_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8869: return "GL_MAX_VERTEX_ATTRIBS";
        case 0x886a: return "GL_VERTEX_ATTRIB_ARRAY_NORMALIZED";
#endif
        case 0x886c:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_OES";
#endif
            break;
        case 0x886d:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8872: return "GL_MAX_TEXTURE_IMAGE_UNITS";
#endif
        case 0x887f:
#if defined(GL_EXT_geometry_shader)
                    return "GL_GEOMETRY_SHADER_INVOCATIONS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_GEOMETRY_SHADER_INVOCATIONS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8892: return "GL_ARRAY_BUFFER";
        case 0x8893: return "GL_ELEMENT_ARRAY_BUFFER";
        case 0x8894: return "GL_ARRAY_BUFFER_BINDING";
        case 0x8895: return "GL_ELEMENT_ARRAY_BUFFER_BINDING";
        case 0x889f: return "GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x88b8: return "GL_READ_ONLY";
#endif
        case 0x88b9:
#if defined(GL_ES_VERSION_3_1)
                    return "GL_WRITE_ONLY";
#endif
#if defined(GL_OES_mapbuffer)
                    return "GL_WRITE_ONLY_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x88ba: return "GL_READ_WRITE";
#endif
#if defined(GL_OES_mapbuffer)
        case 0x88bb: return "GL_BUFFER_ACCESS_OES";
#endif
        case 0x88bc:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_BUFFER_MAPPED";
#endif
#if defined(GL_OES_mapbuffer)
                    return "GL_BUFFER_MAPPED_OES";
#endif
            break;
        case 0x88bd:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_BUFFER_MAP_POINTER";
#endif
#if defined(GL_OES_mapbuffer)
                    return "GL_BUFFER_MAP_POINTER_OES";
#endif
            break;
#if defined(GL_EXT_disjoint_timer_query)
        case 0x88bf: return "GL_TIME_ELAPSED_EXT";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x88e0: return "GL_STREAM_DRAW";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x88e1: return "GL_STREAM_READ";
        case 0x88e2: return "GL_STREAM_COPY";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x88e4: return "GL_STATIC_DRAW";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x88e5: return "GL_STATIC_READ";
        case 0x88e6: return "GL_STATIC_COPY";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x88e8: return "GL_DYNAMIC_DRAW";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x88e9: return "GL_DYNAMIC_READ";
        case 0x88ea: return "GL_DYNAMIC_COPY";
#endif
        case 0x88eb:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_PIXEL_PACK_BUFFER";
#endif
#if defined(GL_NV_pixel_buffer_object)
                    return "GL_PIXEL_PACK_BUFFER_NV";
#endif
            break;
        case 0x88ec:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_PIXEL_UNPACK_BUFFER";
#endif
#if defined(GL_NV_pixel_buffer_object)
                    return "GL_PIXEL_UNPACK_BUFFER_NV";
#endif
            break;
        case 0x88ed:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_PIXEL_PACK_BUFFER_BINDING";
#endif
#if defined(GL_NV_pixel_buffer_object)
                    return "GL_PIXEL_PACK_BUFFER_BINDING_NV";
#endif
            break;
#if defined(GL_NV_sRGB_formats)
        case 0x88ee: return "GL_ETC1_SRGB8_NV";
#endif
        case 0x88ef:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING";
#endif
#if defined(GL_NV_pixel_buffer_object)
                    return "GL_PIXEL_UNPACK_BUFFER_BINDING_NV";
#endif
            break;
        case 0x88f0:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DEPTH24_STENCIL8";
#endif
#if defined(GL_OES_packed_depth_stencil)
                    return "GL_DEPTH24_STENCIL8_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x88f1: return "GL_TEXTURE_STENCIL_SIZE";
#endif
#if defined(GL_EXT_blend_func_extended)
        case 0x88f9: return "GL_SRC1_COLOR_EXT";
        case 0x88fa: return "GL_ONE_MINUS_SRC1_COLOR_EXT";
        case 0x88fb: return "GL_ONE_MINUS_SRC1_ALPHA_EXT";
        case 0x88fc: return "GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x88fd: return "GL_VERTEX_ATTRIB_ARRAY_INTEGER";
#endif
        case 0x88fe:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR";
#endif
#if defined(GL_ANGLE_instanced_arrays)
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE";
#endif
#if defined(GL_EXT_instanced_arrays)
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT";
#endif
#if defined(GL_NV_instanced_arrays)
                    return "GL_VERTEX_ATTRIB_ARRAY_DIVISOR_NV";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x88ff: return "GL_MAX_ARRAY_TEXTURE_LAYERS";
        case 0x8904: return "GL_MIN_PROGRAM_TEXEL_OFFSET";
        case 0x8905: return "GL_MAX_PROGRAM_TEXEL_OFFSET";
#endif
        case 0x8916:
#if defined(GL_EXT_geometry_shader)
                    return "GL_GEOMETRY_LINKED_VERTICES_OUT_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_GEOMETRY_LINKED_VERTICES_OUT_OES";
#endif
            break;
        case 0x8917:
#if defined(GL_EXT_geometry_shader)
                    return "GL_GEOMETRY_LINKED_INPUT_TYPE_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_GEOMETRY_LINKED_INPUT_TYPE_OES";
#endif
            break;
        case 0x8918:
#if defined(GL_EXT_geometry_shader)
                    return "GL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_GEOMETRY_LINKED_OUTPUT_TYPE_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8919: return "GL_SAMPLER_BINDING";
        case 0x8a11: return "GL_UNIFORM_BUFFER";
#endif
#if defined(GL_APPLE_rgb_422)
        case 0x8a1f: return "GL_RGB_422_APPLE";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8a28: return "GL_UNIFORM_BUFFER_BINDING";
        case 0x8a29: return "GL_UNIFORM_BUFFER_START";
        case 0x8a2a: return "GL_UNIFORM_BUFFER_SIZE";
        case 0x8a2b: return "GL_MAX_VERTEX_UNIFORM_BLOCKS";
#endif
        case 0x8a2c:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_UNIFORM_BLOCKS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8a2d: return "GL_MAX_FRAGMENT_UNIFORM_BLOCKS";
        case 0x8a2e: return "GL_MAX_COMBINED_UNIFORM_BLOCKS";
        case 0x8a2f: return "GL_MAX_UNIFORM_BUFFER_BINDINGS";
        case 0x8a30: return "GL_MAX_UNIFORM_BLOCK_SIZE";
        case 0x8a31: return "GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS";
#endif
        case 0x8a32:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8a33: return "GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS";
        case 0x8a34: return "GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT";
        case 0x8a35: return "GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH";
        case 0x8a36: return "GL_ACTIVE_UNIFORM_BLOCKS";
        case 0x8a37: return "GL_UNIFORM_TYPE";
        case 0x8a38: return "GL_UNIFORM_SIZE";
        case 0x8a39: return "GL_UNIFORM_NAME_LENGTH";
        case 0x8a3a: return "GL_UNIFORM_BLOCK_INDEX";
        case 0x8a3b: return "GL_UNIFORM_OFFSET";
        case 0x8a3c: return "GL_UNIFORM_ARRAY_STRIDE";
        case 0x8a3d: return "GL_UNIFORM_MATRIX_STRIDE";
        case 0x8a3e: return "GL_UNIFORM_IS_ROW_MAJOR";
        case 0x8a3f: return "GL_UNIFORM_BLOCK_BINDING";
        case 0x8a40: return "GL_UNIFORM_BLOCK_DATA_SIZE";
        case 0x8a41: return "GL_UNIFORM_BLOCK_NAME_LENGTH";
        case 0x8a42: return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS";
        case 0x8a43: return "GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES";
        case 0x8a44: return "GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER";
        case 0x8a46: return "GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER";
#endif
#if defined(GL_EXT_texture_sRGB_decode)
        case 0x8a48: return "GL_TEXTURE_SRGB_DECODE_EXT";
        case 0x8a49: return "GL_DECODE_EXT";
        case 0x8a4a: return "GL_SKIP_DECODE_EXT";
#endif
#if defined(GL_EXT_debug_label)
        case 0x8a4f: return "GL_PROGRAM_PIPELINE_OBJECT_EXT";
#endif
#if defined(GL_APPLE_rgb_422)
        case 0x8a51: return "GL_RGB_RAW_422_APPLE";
#endif
#if defined(GL_EXT_shader_framebuffer_fetch)
        case 0x8a52: return "GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT";
#endif
#if defined(GL_APPLE_sync)
        case 0x8a53: return "GL_SYNC_OBJECT_APPLE";
#endif
#if defined(GL_EXT_pvrtc_sRGB)
        case 0x8a54: return "GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT";
        case 0x8a55: return "GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT";
        case 0x8a56: return "GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT";
        case 0x8a57: return "GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8b30: return "GL_FRAGMENT_SHADER";
        case 0x8b31: return "GL_VERTEX_SHADER";
#endif
#if defined(GL_EXT_debug_label)
        case 0x8b40: return "GL_PROGRAM_OBJECT_EXT";
        case 0x8b48: return "GL_SHADER_OBJECT_EXT";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8b49: return "GL_MAX_FRAGMENT_UNIFORM_COMPONENTS";
        case 0x8b4a: return "GL_MAX_VERTEX_UNIFORM_COMPONENTS";
        case 0x8b4b: return "GL_MAX_VARYING_COMPONENTS";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8b4c: return "GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS";
        case 0x8b4d: return "GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS";
        case 0x8b4f: return "GL_SHADER_TYPE";
        case 0x8b50: return "GL_FLOAT_VEC2";
        case 0x8b51: return "GL_FLOAT_VEC3";
        case 0x8b52: return "GL_FLOAT_VEC4";
        case 0x8b53: return "GL_INT_VEC2";
        case 0x8b54: return "GL_INT_VEC3";
        case 0x8b55: return "GL_INT_VEC4";
        case 0x8b56: return "GL_BOOL";
        case 0x8b57: return "GL_BOOL_VEC2";
        case 0x8b58: return "GL_BOOL_VEC3";
        case 0x8b59: return "GL_BOOL_VEC4";
        case 0x8b5a: return "GL_FLOAT_MAT2";
        case 0x8b5b: return "GL_FLOAT_MAT3";
        case 0x8b5c: return "GL_FLOAT_MAT4";
        case 0x8b5e: return "GL_SAMPLER_2D";
#endif
        case 0x8b5f:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SAMPLER_3D";
#endif
#if defined(GL_OES_texture_3D)
                    return "GL_SAMPLER_3D_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8b60: return "GL_SAMPLER_CUBE";
#endif
        case 0x8b62:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SAMPLER_2D_SHADOW";
#endif
#if defined(GL_EXT_shadow_samplers)
                    return "GL_SAMPLER_2D_SHADOW_EXT";
#endif
            break;
        case 0x8b65:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FLOAT_MAT2x3";
#endif
#if defined(GL_NV_non_square_matrices)
                    return "GL_FLOAT_MAT2x3_NV";
#endif
            break;
        case 0x8b66:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FLOAT_MAT2x4";
#endif
#if defined(GL_NV_non_square_matrices)
                    return "GL_FLOAT_MAT2x4_NV";
#endif
            break;
        case 0x8b67:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FLOAT_MAT3x2";
#endif
#if defined(GL_NV_non_square_matrices)
                    return "GL_FLOAT_MAT3x2_NV";
#endif
            break;
        case 0x8b68:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FLOAT_MAT3x4";
#endif
#if defined(GL_NV_non_square_matrices)
                    return "GL_FLOAT_MAT3x4_NV";
#endif
            break;
        case 0x8b69:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FLOAT_MAT4x2";
#endif
#if defined(GL_NV_non_square_matrices)
                    return "GL_FLOAT_MAT4x2_NV";
#endif
            break;
        case 0x8b6a:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FLOAT_MAT4x3";
#endif
#if defined(GL_NV_non_square_matrices)
                    return "GL_FLOAT_MAT4x3_NV";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8b80: return "GL_DELETE_STATUS";
        case 0x8b81: return "GL_COMPILE_STATUS";
        case 0x8b82: return "GL_LINK_STATUS";
        case 0x8b83: return "GL_VALIDATE_STATUS";
        case 0x8b84: return "GL_INFO_LOG_LENGTH";
        case 0x8b85: return "GL_ATTACHED_SHADERS";
        case 0x8b86: return "GL_ACTIVE_UNIFORMS";
        case 0x8b87: return "GL_ACTIVE_UNIFORM_MAX_LENGTH";
        case 0x8b88: return "GL_SHADER_SOURCE_LENGTH";
        case 0x8b89: return "GL_ACTIVE_ATTRIBUTES";
        case 0x8b8a: return "GL_ACTIVE_ATTRIBUTE_MAX_LENGTH";
#endif
        case 0x8b8b:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT";
#endif
#if defined(GL_OES_standard_derivatives)
                    return "GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8b8c: return "GL_SHADING_LANGUAGE_VERSION";
        case 0x8b8d: return "GL_CURRENT_PROGRAM";
#endif
#if defined(GL_OES_compressed_paletted_texture)
        case 0x8b90: return "GL_PALETTE4_RGB8_OES";
        case 0x8b91: return "GL_PALETTE4_RGBA8_OES";
        case 0x8b92: return "GL_PALETTE4_R5_G6_B5_OES";
        case 0x8b93: return "GL_PALETTE4_RGBA4_OES";
        case 0x8b94: return "GL_PALETTE4_RGB5_A1_OES";
        case 0x8b95: return "GL_PALETTE8_RGB8_OES";
        case 0x8b96: return "GL_PALETTE8_RGBA8_OES";
        case 0x8b97: return "GL_PALETTE8_R5_G6_B5_OES";
        case 0x8b98: return "GL_PALETTE8_RGBA4_OES";
        case 0x8b99: return "GL_PALETTE8_RGB5_A1_OES";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8b9a: return "GL_IMPLEMENTATION_COLOR_READ_TYPE";
        case 0x8b9b: return "GL_IMPLEMENTATION_COLOR_READ_FORMAT";
#endif
#if defined(GL_MESA_framebuffer_flip_y)
        case 0x8bbb: return "GL_FRAMEBUFFER_FLIP_Y_MESA";
#endif
#if defined(GL_AMD_performance_monitor)
        case 0x8bc0: return "GL_COUNTER_TYPE_AMD";
        case 0x8bc1: return "GL_COUNTER_RANGE_AMD";
        case 0x8bc2: return "GL_UNSIGNED_INT64_AMD";
        case 0x8bc3: return "GL_PERCENTAGE_AMD";
        case 0x8bc4: return "GL_PERFMON_RESULT_AVAILABLE_AMD";
        case 0x8bc5: return "GL_PERFMON_RESULT_SIZE_AMD";
        case 0x8bc6: return "GL_PERFMON_RESULT_AMD";
#endif
#if defined(GL_QCOM_extended_get)
        case 0x8bd2: return "GL_TEXTURE_WIDTH_QCOM";
        case 0x8bd3: return "GL_TEXTURE_HEIGHT_QCOM";
        case 0x8bd4: return "GL_TEXTURE_DEPTH_QCOM";
        case 0x8bd5: return "GL_TEXTURE_INTERNAL_FORMAT_QCOM";
        case 0x8bd6: return "GL_TEXTURE_FORMAT_QCOM";
        case 0x8bd7: return "GL_TEXTURE_TYPE_QCOM";
        case 0x8bd8: return "GL_TEXTURE_IMAGE_VALID_QCOM";
        case 0x8bd9: return "GL_TEXTURE_NUM_LEVELS_QCOM";
        case 0x8bda: return "GL_TEXTURE_TARGET_QCOM";
        case 0x8bdb: return "GL_TEXTURE_OBJECT_VALID_QCOM";
        case 0x8bdc: return "GL_STATE_RESTORE";
#endif
#if defined(GL_EXT_YUV_target)
        case 0x8be7: return "GL_SAMPLER_EXTERNAL_2D_Y2Y_EXT";
#endif
#if defined(GL_EXT_protected_textures)
        case 0x8bfa: return "GL_TEXTURE_PROTECTED_EXT";
#endif
#if defined(GL_QCOM_texture_foveated)
        case 0x8bfc: return "GL_TEXTURE_FOVEATED_MIN_PIXEL_DENSITY_QCOM";
        case 0x8bfd: return "GL_TEXTURE_FOVEATED_FEATURE_QUERY_QCOM";
        case 0x8bfe: return "GL_TEXTURE_FOVEATED_NUM_FOCAL_POINTS_QUERY_QCOM";
        case 0x8bff: return "GL_FRAMEBUFFER_INCOMPLETE_FOVEATION_QCOM";
#endif
#if defined(GL_IMG_texture_compression_pvrtc)
        case 0x8c00: return "GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG";
        case 0x8c01: return "GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG";
        case 0x8c02: return "GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG";
        case 0x8c03: return "GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG";
#endif
#if defined(GL_IMG_shader_binary)
        case 0x8c0a: return "GL_SGX_BINARY_IMG";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x8c10: return "GL_TEXTURE_RED_TYPE";
        case 0x8c11: return "GL_TEXTURE_GREEN_TYPE";
        case 0x8c12: return "GL_TEXTURE_BLUE_TYPE";
        case 0x8c13: return "GL_TEXTURE_ALPHA_TYPE";
        case 0x8c16: return "GL_TEXTURE_DEPTH_TYPE";
#endif
        case 0x8c17:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_UNSIGNED_NORMALIZED";
#endif
#if defined(GL_EXT_color_buffer_half_float)
                    return "GL_UNSIGNED_NORMALIZED_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_3_0) || defined(GL_EXT_sparse_texture)
        case 0x8c1a: return "GL_TEXTURE_2D_ARRAY";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8c1d: return "GL_TEXTURE_BINDING_2D_ARRAY";
#endif
        case 0x8c29:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_OES";
#endif
            break;
        case 0x8c2a:
#if defined(GL_EXT_texture_buffer)
                    return "GL_TEXTURE_BUFFER_BINDING_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_TEXTURE_BUFFER_BINDING_OES";
#endif
#if defined(GL_EXT_texture_buffer)
                    return "GL_TEXTURE_BUFFER_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_TEXTURE_BUFFER_OES";
#endif
            break;
        case 0x8c2b:
#if defined(GL_EXT_texture_buffer)
                    return "GL_MAX_TEXTURE_BUFFER_SIZE_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_MAX_TEXTURE_BUFFER_SIZE_OES";
#endif
            break;
        case 0x8c2c:
#if defined(GL_EXT_texture_buffer)
                    return "GL_TEXTURE_BINDING_BUFFER_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_TEXTURE_BINDING_BUFFER_OES";
#endif
            break;
        case 0x8c2d:
#if defined(GL_EXT_texture_buffer)
                    return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_TEXTURE_BUFFER_DATA_STORE_BINDING_OES";
#endif
            break;
        case 0x8c2f:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_ANY_SAMPLES_PASSED";
#endif
#if defined(GL_EXT_occlusion_query_boolean)
                    return "GL_ANY_SAMPLES_PASSED_EXT";
#endif
            break;
#if defined(GL_OES_sample_shading)
        case 0x8c36: return "GL_SAMPLE_SHADING_OES";
        case 0x8c37: return "GL_MIN_SAMPLE_SHADING_VALUE_OES";
#endif
        case 0x8c3a:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_R11F_G11F_B10F";
#endif
#if defined(GL_APPLE_texture_packed_float)
                    return "GL_R11F_G11F_B10F_APPLE";
#endif
            break;
        case 0x8c3b:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV";
#endif
#if defined(GL_APPLE_texture_packed_float)
                    return "GL_UNSIGNED_INT_10F_11F_11F_REV_APPLE";
#endif
            break;
        case 0x8c3d:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RGB9_E5";
#endif
#if defined(GL_APPLE_texture_packed_float)
                    return "GL_RGB9_E5_APPLE";
#endif
            break;
        case 0x8c3e:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_UNSIGNED_INT_5_9_9_9_REV";
#endif
#if defined(GL_APPLE_texture_packed_float)
                    return "GL_UNSIGNED_INT_5_9_9_9_REV_APPLE";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x8c3f: return "GL_TEXTURE_SHARED_SIZE";
#endif
        case 0x8c40:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SRGB";
#endif
#if defined(GL_EXT_sRGB)
                    return "GL_SRGB_EXT";
#endif
            break;
        case 0x8c41:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SRGB8";
#endif
#if defined(GL_NV_sRGB_formats)
                    return "GL_SRGB8_NV";
#endif
            break;
#if defined(GL_EXT_sRGB)
        case 0x8c42: return "GL_SRGB_ALPHA_EXT";
#endif
        case 0x8c43:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SRGB8_ALPHA8";
#endif
#if defined(GL_EXT_sRGB)
                    return "GL_SRGB8_ALPHA8_EXT";
#endif
            break;
#if defined(GL_NV_sRGB_formats)
        case 0x8c44: return "GL_SLUMINANCE_ALPHA_NV";
        case 0x8c45: return "GL_SLUMINANCE8_ALPHA8_NV";
        case 0x8c46: return "GL_SLUMINANCE_NV";
        case 0x8c47: return "GL_SLUMINANCE8_NV";
#endif
        case 0x8c4c:
#if defined(GL_EXT_texture_compression_s3tc_srgb)
                    return "GL_COMPRESSED_SRGB_S3TC_DXT1_EXT";
#endif
#if defined(GL_NV_sRGB_formats)
                    return "GL_COMPRESSED_SRGB_S3TC_DXT1_NV";
#endif
            break;
        case 0x8c4d:
#if defined(GL_EXT_texture_compression_s3tc_srgb)
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT";
#endif
#if defined(GL_NV_sRGB_formats)
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV";
#endif
            break;
        case 0x8c4e:
#if defined(GL_EXT_texture_compression_s3tc_srgb)
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT";
#endif
#if defined(GL_NV_sRGB_formats)
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV";
#endif
            break;
        case 0x8c4f:
#if defined(GL_EXT_texture_compression_s3tc_srgb)
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT";
#endif
#if defined(GL_NV_sRGB_formats)
                    return "GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8c76: return "GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH";
        case 0x8c7f: return "GL_TRANSFORM_FEEDBACK_BUFFER_MODE";
        case 0x8c80: return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS";
        case 0x8c83: return "GL_TRANSFORM_FEEDBACK_VARYINGS";
        case 0x8c84: return "GL_TRANSFORM_FEEDBACK_BUFFER_START";
        case 0x8c85: return "GL_TRANSFORM_FEEDBACK_BUFFER_SIZE";
#endif
        case 0x8c87:
#if defined(GL_EXT_geometry_shader)
                    return "GL_PRIMITIVES_GENERATED_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_PRIMITIVES_GENERATED_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8c88: return "GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN";
        case 0x8c89: return "GL_RASTERIZER_DISCARD";
        case 0x8c8a: return "GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS";
        case 0x8c8b: return "GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS";
        case 0x8c8c: return "GL_INTERLEAVED_ATTRIBS";
        case 0x8c8d: return "GL_SEPARATE_ATTRIBS";
        case 0x8c8e: return "GL_TRANSFORM_FEEDBACK_BUFFER";
        case 0x8c8f: return "GL_TRANSFORM_FEEDBACK_BUFFER_BINDING";
#endif
#if defined(GL_AMD_compressed_ATC_texture)
        case 0x8c92: return "GL_ATC_RGB_AMD";
        case 0x8c93: return "GL_ATC_RGBA_EXPLICIT_ALPHA_AMD";
#endif
#if defined(GL_EXT_clip_control)
        case 0x8ca1: return "GL_LOWER_LEFT_EXT";
        case 0x8ca2: return "GL_UPPER_LEFT_EXT";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8ca3: return "GL_STENCIL_BACK_REF";
        case 0x8ca4: return "GL_STENCIL_BACK_VALUE_MASK";
        case 0x8ca5: return "GL_STENCIL_BACK_WRITEMASK";
#endif
        case 0x8ca6:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_FRAMEBUFFER_BINDING";
#endif
#if defined(GL_ANGLE_framebuffer_blit)
                    return "GL_DRAW_FRAMEBUFFER_BINDING_ANGLE";
#endif
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_DRAW_FRAMEBUFFER_BINDING_APPLE";
#endif
#if defined(GL_NV_framebuffer_blit)
                    return "GL_DRAW_FRAMEBUFFER_BINDING_NV";
#endif
#if defined(GL_ES_VERSION_2_0)
                    return "GL_FRAMEBUFFER_BINDING";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8ca7: return "GL_RENDERBUFFER_BINDING";
#endif
        case 0x8ca8:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_READ_FRAMEBUFFER";
#endif
#if defined(GL_ANGLE_framebuffer_blit)
                    return "GL_READ_FRAMEBUFFER_ANGLE";
#endif
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_READ_FRAMEBUFFER_APPLE";
#endif
#if defined(GL_NV_framebuffer_blit)
                    return "GL_READ_FRAMEBUFFER_NV";
#endif
            break;
        case 0x8ca9:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_DRAW_FRAMEBUFFER";
#endif
#if defined(GL_ANGLE_framebuffer_blit)
                    return "GL_DRAW_FRAMEBUFFER_ANGLE";
#endif
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_DRAW_FRAMEBUFFER_APPLE";
#endif
#if defined(GL_NV_framebuffer_blit)
                    return "GL_DRAW_FRAMEBUFFER_NV";
#endif
            break;
        case 0x8caa:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_READ_FRAMEBUFFER_BINDING";
#endif
#if defined(GL_ANGLE_framebuffer_blit)
                    return "GL_READ_FRAMEBUFFER_BINDING_ANGLE";
#endif
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_READ_FRAMEBUFFER_BINDING_APPLE";
#endif
#if defined(GL_NV_framebuffer_blit)
                    return "GL_READ_FRAMEBUFFER_BINDING_NV";
#endif
            break;
        case 0x8cab:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_RENDERBUFFER_SAMPLES";
#endif
#if defined(GL_ANGLE_framebuffer_multisample)
                    return "GL_RENDERBUFFER_SAMPLES_ANGLE";
#endif
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_RENDERBUFFER_SAMPLES_APPLE";
#endif
#if defined(GL_EXT_multisampled_render_to_texture)
                    return "GL_RENDERBUFFER_SAMPLES_EXT";
#endif
#if defined(GL_NV_framebuffer_multisample)
                    return "GL_RENDERBUFFER_SAMPLES_NV";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8cac: return "GL_DEPTH_COMPONENT32F";
        case 0x8cad: return "GL_DEPTH32F_STENCIL8";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8cd0: return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE";
        case 0x8cd1: return "GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME";
        case 0x8cd2: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL";
        case 0x8cd3: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE";
#endif
        case 0x8cd4:
#if defined(GL_OES_texture_3D)
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES";
#endif
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8cd5: return "GL_FRAMEBUFFER_COMPLETE";
        case 0x8cd6: return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT";
        case 0x8cd7: return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";
        case 0x8cd9: return "GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS";
        case 0x8cdd: return "GL_FRAMEBUFFER_UNSUPPORTED";
#endif
        case 0x8cdf:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_MAX_COLOR_ATTACHMENTS";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_MAX_COLOR_ATTACHMENTS_EXT";
#endif
#if defined(GL_NV_fbo_color_attachments)
                    return "GL_MAX_COLOR_ATTACHMENTS_NV";
#endif
            break;
        case 0x8ce0:
#if defined(GL_ES_VERSION_2_0)
                    return "GL_COLOR_ATTACHMENT0";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT0_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT0_NV";
#endif
            break;
        case 0x8ce1:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT1";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT1_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT1_NV";
#endif
            break;
        case 0x8ce2:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT2";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT2_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT2_NV";
#endif
            break;
        case 0x8ce3:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT3";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT3_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT3_NV";
#endif
            break;
        case 0x8ce4:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT4";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT4_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT4_NV";
#endif
            break;
        case 0x8ce5:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT5";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT5_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT5_NV";
#endif
            break;
        case 0x8ce6:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT6";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT6_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT6_NV";
#endif
            break;
        case 0x8ce7:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT7";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT7_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT7_NV";
#endif
            break;
        case 0x8ce8:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT8";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT8_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT8_NV";
#endif
            break;
        case 0x8ce9:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT9";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT9_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT9_NV";
#endif
            break;
        case 0x8cea:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT10";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT10_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT10_NV";
#endif
            break;
        case 0x8ceb:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT11";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT11_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT11_NV";
#endif
            break;
        case 0x8cec:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT12";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT12_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT12_NV";
#endif
            break;
        case 0x8ced:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT13";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT13_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT13_NV";
#endif
            break;
        case 0x8cee:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT14";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT14_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT14_NV";
#endif
            break;
        case 0x8cef:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COLOR_ATTACHMENT15";
#endif
#if defined(GL_EXT_draw_buffers)
                    return "GL_COLOR_ATTACHMENT15_EXT";
#endif
#if defined(GL_NV_draw_buffers)
                    return "GL_COLOR_ATTACHMENT15_NV";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8cf0: return "GL_COLOR_ATTACHMENT16";
        case 0x8cf1: return "GL_COLOR_ATTACHMENT17";
        case 0x8cf2: return "GL_COLOR_ATTACHMENT18";
        case 0x8cf3: return "GL_COLOR_ATTACHMENT19";
        case 0x8cf4: return "GL_COLOR_ATTACHMENT20";
        case 0x8cf5: return "GL_COLOR_ATTACHMENT21";
        case 0x8cf6: return "GL_COLOR_ATTACHMENT22";
        case 0x8cf7: return "GL_COLOR_ATTACHMENT23";
        case 0x8cf8: return "GL_COLOR_ATTACHMENT24";
        case 0x8cf9: return "GL_COLOR_ATTACHMENT25";
        case 0x8cfa: return "GL_COLOR_ATTACHMENT26";
        case 0x8cfb: return "GL_COLOR_ATTACHMENT27";
        case 0x8cfc: return "GL_COLOR_ATTACHMENT28";
        case 0x8cfd: return "GL_COLOR_ATTACHMENT29";
        case 0x8cfe: return "GL_COLOR_ATTACHMENT30";
        case 0x8cff: return "GL_COLOR_ATTACHMENT31";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8d00: return "GL_DEPTH_ATTACHMENT";
        case 0x8d20: return "GL_STENCIL_ATTACHMENT";
        case 0x8d40: return "GL_FRAMEBUFFER";
        case 0x8d41: return "GL_RENDERBUFFER";
        case 0x8d42: return "GL_RENDERBUFFER_WIDTH";
        case 0x8d43: return "GL_RENDERBUFFER_HEIGHT";
        case 0x8d44: return "GL_RENDERBUFFER_INTERNAL_FORMAT";
#endif
#if defined(GL_OES_stencil1)
        case 0x8d46: return "GL_STENCIL_INDEX1_OES";
#endif
#if defined(GL_OES_stencil4)
        case 0x8d47: return "GL_STENCIL_INDEX4_OES";
#endif
        case 0x8d48:
#if defined(GL_ES_VERSION_2_0)
                    return "GL_STENCIL_INDEX8";
#endif
#if defined(GL_OES_texture_stencil8)
                    return "GL_STENCIL_INDEX8_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8d50: return "GL_RENDERBUFFER_RED_SIZE";
        case 0x8d51: return "GL_RENDERBUFFER_GREEN_SIZE";
        case 0x8d52: return "GL_RENDERBUFFER_BLUE_SIZE";
        case 0x8d53: return "GL_RENDERBUFFER_ALPHA_SIZE";
        case 0x8d54: return "GL_RENDERBUFFER_DEPTH_SIZE";
        case 0x8d55: return "GL_RENDERBUFFER_STENCIL_SIZE";
#endif
        case 0x8d56:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE";
#endif
#if defined(GL_ANGLE_framebuffer_multisample)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE";
#endif
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE";
#endif
#if defined(GL_EXT_multisampled_render_to_texture)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT";
#endif
#if defined(GL_NV_framebuffer_multisample)
                    return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV";
#endif
            break;
        case 0x8d57:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_MAX_SAMPLES";
#endif
#if defined(GL_ANGLE_framebuffer_multisample)
                    return "GL_MAX_SAMPLES_ANGLE";
#endif
#if defined(GL_APPLE_framebuffer_multisample)
                    return "GL_MAX_SAMPLES_APPLE";
#endif
#if defined(GL_EXT_multisampled_render_to_texture)
                    return "GL_MAX_SAMPLES_EXT";
#endif
#if defined(GL_NV_framebuffer_multisample)
                    return "GL_MAX_SAMPLES_NV";
#endif
            break;
#if defined(GL_OES_texture_half_float)
        case 0x8d61: return "GL_HALF_FLOAT_OES";
#endif
        case 0x8d62:
#if defined(GL_ES_VERSION_2_0)
                    return "GL_RGB565";
#endif
#if defined(GL_OES_required_internalformat)
                    return "GL_RGB565_OES";
#endif
            break;
#if defined(GL_OES_compressed_ETC1_RGB8_texture)
        case 0x8d64: return "GL_ETC1_RGB8_OES";
#endif
#if defined(GL_OES_EGL_image_external)
        case 0x8d65: return "GL_TEXTURE_EXTERNAL_OES";
        case 0x8d66: return "GL_SAMPLER_EXTERNAL_OES";
        case 0x8d67: return "GL_TEXTURE_BINDING_EXTERNAL_OES";
        case 0x8d68: return "GL_REQUIRED_TEXTURE_IMAGE_UNITS_OES";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8d69: return "GL_PRIMITIVE_RESTART_FIXED_INDEX";
#endif
        case 0x8d6a:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE";
#endif
#if defined(GL_EXT_occlusion_query_boolean)
                    return "GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8d6b: return "GL_MAX_ELEMENT_INDEX";
#endif
#if defined(GL_EXT_multisampled_render_to_texture)
        case 0x8d6c: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8d70: return "GL_RGBA32UI";
        case 0x8d71: return "GL_RGB32UI";
        case 0x8d76: return "GL_RGBA16UI";
        case 0x8d77: return "GL_RGB16UI";
        case 0x8d7c: return "GL_RGBA8UI";
        case 0x8d7d: return "GL_RGB8UI";
        case 0x8d82: return "GL_RGBA32I";
        case 0x8d83: return "GL_RGB32I";
        case 0x8d88: return "GL_RGBA16I";
        case 0x8d89: return "GL_RGB16I";
        case 0x8d8e: return "GL_RGBA8I";
        case 0x8d8f: return "GL_RGB8I";
        case 0x8d94: return "GL_RED_INTEGER";
        case 0x8d98: return "GL_RGB_INTEGER";
        case 0x8d99: return "GL_RGBA_INTEGER";
        case 0x8d9f: return "GL_INT_2_10_10_10_REV";
#endif
        case 0x8da7:
#if defined(GL_EXT_geometry_shader)
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_FRAMEBUFFER_ATTACHMENT_LAYERED_OES";
#endif
            break;
        case 0x8da8:
#if defined(GL_EXT_geometry_shader)
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8dad: return "GL_FLOAT_32_UNSIGNED_INT_24_8_REV";
#endif
#if defined(GL_EXT_sRGB_write_control)
        case 0x8db9: return "GL_FRAMEBUFFER_SRGB_EXT";
#endif
#if defined(GL_EXT_texture_compression_rgtc)
        case 0x8dbb: return "GL_COMPRESSED_RED_RGTC1_EXT";
        case 0x8dbc: return "GL_COMPRESSED_SIGNED_RED_RGTC1_EXT";
        case 0x8dbd: return "GL_COMPRESSED_RED_GREEN_RGTC2_EXT";
        case 0x8dbe: return "GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8dc1: return "GL_SAMPLER_2D_ARRAY";
#endif
        case 0x8dc2:
#if defined(GL_EXT_texture_buffer)
                    return "GL_SAMPLER_BUFFER_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_SAMPLER_BUFFER_OES";
#endif
            break;
        case 0x8dc4:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SAMPLER_2D_ARRAY_SHADOW";
#endif
#if defined(GL_NV_shadow_samplers_array)
                    return "GL_SAMPLER_2D_ARRAY_SHADOW_NV";
#endif
            break;
        case 0x8dc5:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SAMPLER_CUBE_SHADOW";
#endif
#if defined(GL_NV_shadow_samplers_cube)
                    return "GL_SAMPLER_CUBE_SHADOW_NV";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8dc6: return "GL_UNSIGNED_INT_VEC2";
        case 0x8dc7: return "GL_UNSIGNED_INT_VEC3";
        case 0x8dc8: return "GL_UNSIGNED_INT_VEC4";
        case 0x8dca: return "GL_INT_SAMPLER_2D";
        case 0x8dcb: return "GL_INT_SAMPLER_3D";
        case 0x8dcc: return "GL_INT_SAMPLER_CUBE";
        case 0x8dcf: return "GL_INT_SAMPLER_2D_ARRAY";
#endif
        case 0x8dd0:
#if defined(GL_EXT_texture_buffer)
                    return "GL_INT_SAMPLER_BUFFER_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_INT_SAMPLER_BUFFER_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x8dd2: return "GL_UNSIGNED_INT_SAMPLER_2D";
        case 0x8dd3: return "GL_UNSIGNED_INT_SAMPLER_3D";
        case 0x8dd4: return "GL_UNSIGNED_INT_SAMPLER_CUBE";
        case 0x8dd7: return "GL_UNSIGNED_INT_SAMPLER_2D_ARRAY";
#endif
        case 0x8dd8:
#if defined(GL_EXT_texture_buffer)
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_UNSIGNED_INT_SAMPLER_BUFFER_OES";
#endif
            break;
        case 0x8dd9:
#if defined(GL_EXT_geometry_shader)
                    return "GL_GEOMETRY_SHADER_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_GEOMETRY_SHADER_OES";
#endif
            break;
        case 0x8ddf:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_OES";
#endif
            break;
        case 0x8de0:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_OUTPUT_VERTICES_OES";
#endif
            break;
        case 0x8de1:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_2_0)
        case 0x8df0: return "GL_LOW_FLOAT";
        case 0x8df1: return "GL_MEDIUM_FLOAT";
        case 0x8df2: return "GL_HIGH_FLOAT";
        case 0x8df3: return "GL_LOW_INT";
        case 0x8df4: return "GL_MEDIUM_INT";
        case 0x8df5: return "GL_HIGH_INT";
#endif
#if defined(GL_OES_vertex_type_10_10_10_2)
        case 0x8df6: return "GL_UNSIGNED_INT_10_10_10_2_OES";
        case 0x8df7: return "GL_INT_10_10_10_2_OES";
#endif
#if defined(GL_ES_VERSION_2_0)
        case 0x8df8: return "GL_SHADER_BINARY_FORMATS";
        case 0x8df9: return "GL_NUM_SHADER_BINARY_FORMATS";
        case 0x8dfa: return "GL_SHADER_COMPILER";
        case 0x8dfb: return "GL_MAX_VERTEX_UNIFORM_VECTORS";
        case 0x8dfc: return "GL_MAX_VARYING_VECTORS";
        case 0x8dfd: return "GL_MAX_FRAGMENT_UNIFORM_VECTORS";
#endif
#if defined(GL_NV_conditional_render)
        case 0x8e13: return "GL_QUERY_WAIT_NV";
        case 0x8e14: return "GL_QUERY_NO_WAIT_NV";
        case 0x8e15: return "GL_QUERY_BY_REGION_WAIT_NV";
        case 0x8e16: return "GL_QUERY_BY_REGION_NO_WAIT_NV";
#endif
#if defined(GL_EXT_polygon_offset_clamp)
        case 0x8e1b: return "GL_POLYGON_OFFSET_CLAMP_EXT";
#endif
        case 0x8e1e:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_OES";
#endif
            break;
        case 0x8e1f:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_OES";
#endif
            break;
#if defined(GL_NV_framebuffer_mixed_samples)
        case 0x8e20: return "GL_COLOR_SAMPLES_NV";
#endif
#if defined(GL_ES_VERSION_3_0) || defined(GL_EXT_debug_label)
        case 0x8e22: return "GL_TRANSFORM_FEEDBACK";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8e23: return "GL_TRANSFORM_FEEDBACK_PAUSED";
        case 0x8e24: return "GL_TRANSFORM_FEEDBACK_ACTIVE";
        case 0x8e25: return "GL_TRANSFORM_FEEDBACK_BINDING";
#endif
#if defined(GL_EXT_disjoint_timer_query)
        case 0x8e28: return "GL_TIMESTAMP_EXT";
#endif
#if defined(GL_NV_depth_nonlinear)
        case 0x8e2c: return "GL_DEPTH_COMPONENT16_NONLINEAR_NV";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8e42: return "GL_TEXTURE_SWIZZLE_R";
        case 0x8e43: return "GL_TEXTURE_SWIZZLE_G";
        case 0x8e44: return "GL_TEXTURE_SWIZZLE_B";
        case 0x8e45: return "GL_TEXTURE_SWIZZLE_A";
#endif
        case 0x8e4d:
#if defined(GL_EXT_geometry_shader)
                    return "GL_FIRST_VERTEX_CONVENTION_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_FIRST_VERTEX_CONVENTION_OES";
#endif
            break;
        case 0x8e4e:
#if defined(GL_EXT_geometry_shader)
                    return "GL_LAST_VERTEX_CONVENTION_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_LAST_VERTEX_CONVENTION_OES";
#endif
            break;
        case 0x8e50:
#if defined(GL_NV_sample_locations)
                    return "GL_SAMPLE_LOCATION_NV";
#endif
#if defined(GL_ES_VERSION_3_1)
                    return "GL_SAMPLE_POSITION";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x8e51: return "GL_SAMPLE_MASK";
        case 0x8e52: return "GL_SAMPLE_MASK_VALUE";
        case 0x8e59: return "GL_MAX_SAMPLE_MASK_WORDS";
#endif
        case 0x8e5a:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_SHADER_INVOCATIONS_OES";
#endif
            break;
#if defined(GL_OES_shader_multisample_interpolation)
        case 0x8e5b: return "GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES";
        case 0x8e5c: return "GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x8e5e: return "GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET";
        case 0x8e5f: return "GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET";
#endif
        case 0x8e72:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_PATCH_VERTICES_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_PATCH_VERTICES_OES";
#endif
            break;
        case 0x8e75:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_TESS_CONTROL_OUTPUT_VERTICES_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_TESS_CONTROL_OUTPUT_VERTICES_OES";
#endif
            break;
        case 0x8e76:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_TESS_GEN_MODE_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_TESS_GEN_MODE_OES";
#endif
            break;
        case 0x8e77:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_TESS_GEN_SPACING_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_TESS_GEN_SPACING_OES";
#endif
            break;
        case 0x8e78:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_TESS_GEN_VERTEX_ORDER_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_TESS_GEN_VERTEX_ORDER_OES";
#endif
            break;
        case 0x8e79:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_TESS_GEN_POINT_MODE_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_TESS_GEN_POINT_MODE_OES";
#endif
            break;
        case 0x8e7a:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_ISOLINES_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_ISOLINES_OES";
#endif
            break;
        case 0x8e7b:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_FRACTIONAL_ODD_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_FRACTIONAL_ODD_OES";
#endif
            break;
        case 0x8e7c:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_FRACTIONAL_EVEN_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_FRACTIONAL_EVEN_OES";
#endif
            break;
        case 0x8e7d:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_PATCH_VERTICES_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_PATCH_VERTICES_OES";
#endif
            break;
        case 0x8e7e:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_GEN_LEVEL_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_GEN_LEVEL_OES";
#endif
            break;
        case 0x8e7f:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_OES";
#endif
            break;
        case 0x8e80:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_OES";
#endif
            break;
        case 0x8e81:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_OES";
#endif
            break;
        case 0x8e82:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_OES";
#endif
            break;
        case 0x8e83:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_OES";
#endif
            break;
        case 0x8e84:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_PATCH_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_PATCH_COMPONENTS_OES";
#endif
            break;
        case 0x8e85:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_OES";
#endif
            break;
        case 0x8e86:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_OES";
#endif
            break;
        case 0x8e87:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_TESS_EVALUATION_SHADER_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_TESS_EVALUATION_SHADER_OES";
#endif
            break;
        case 0x8e88:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_TESS_CONTROL_SHADER_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_TESS_CONTROL_SHADER_OES";
#endif
            break;
        case 0x8e89:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_OES";
#endif
            break;
        case 0x8e8a:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_OES";
#endif
            break;
#if defined(GL_EXT_texture_compression_bptc)
        case 0x8e8c: return "GL_COMPRESSED_RGBA_BPTC_UNORM_EXT";
        case 0x8e8d: return "GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT";
        case 0x8e8e: return "GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT";
        case 0x8e8f: return "GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT";
#endif
#if defined(GL_NV_coverage_sample)
        case 0x8ed0: return "GL_COVERAGE_COMPONENT_NV";
        case 0x8ed1: return "GL_COVERAGE_COMPONENT4_NV";
        case 0x8ed2: return "GL_COVERAGE_ATTACHMENT_NV";
        case 0x8ed3: return "GL_COVERAGE_BUFFERS_NV";
        case 0x8ed4: return "GL_COVERAGE_SAMPLES_NV";
        case 0x8ed5: return "GL_COVERAGE_ALL_FRAGMENTS_NV";
        case 0x8ed6: return "GL_COVERAGE_EDGE_FRAGMENTS_NV";
        case 0x8ed7: return "GL_COVERAGE_AUTOMATIC_NV";
#endif
#if defined(GL_EXT_window_rectangles)
        case 0x8f10: return "GL_INCLUSIVE_EXT";
        case 0x8f11: return "GL_EXCLUSIVE_EXT";
        case 0x8f12: return "GL_WINDOW_RECTANGLE_EXT";
        case 0x8f13: return "GL_WINDOW_RECTANGLE_MODE_EXT";
        case 0x8f14: return "GL_MAX_WINDOW_RECTANGLES_EXT";
        case 0x8f15: return "GL_NUM_WINDOW_RECTANGLES_EXT";
#endif
        case 0x8f36:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COPY_READ_BUFFER";
#endif
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COPY_READ_BUFFER_BINDING";
#endif
#if defined(GL_NV_copy_buffer)
                    return "GL_COPY_READ_BUFFER_NV";
#endif
            break;
        case 0x8f37:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COPY_WRITE_BUFFER";
#endif
#if defined(GL_ES_VERSION_3_0)
                    return "GL_COPY_WRITE_BUFFER_BINDING";
#endif
#if defined(GL_NV_copy_buffer)
                    return "GL_COPY_WRITE_BUFFER_NV";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x8f38: return "GL_MAX_IMAGE_UNITS";
        case 0x8f39: return "GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES";
        case 0x8f3a: return "GL_IMAGE_BINDING_NAME";
        case 0x8f3b: return "GL_IMAGE_BINDING_LEVEL";
        case 0x8f3c: return "GL_IMAGE_BINDING_LAYERED";
        case 0x8f3d: return "GL_IMAGE_BINDING_LAYER";
        case 0x8f3e: return "GL_IMAGE_BINDING_ACCESS";
        case 0x8f3f: return "GL_DRAW_INDIRECT_BUFFER";
        case 0x8f43: return "GL_DRAW_INDIRECT_BUFFER_BINDING";
        case 0x8f4f: return "GL_VERTEX_BINDING_BUFFER";
#endif
#if defined(GL_ARM_mali_shader_binary)
        case 0x8f60: return "GL_MALI_SHADER_BINARY_ARM";
#endif
#if defined(GL_ARM_mali_program_binary)
        case 0x8f61: return "GL_MALI_PROGRAM_BINARY_ARM";
#endif
#if defined(GL_EXT_shader_pixel_local_storage)
        case 0x8f63: return "GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_FAST_SIZE_EXT";
        case 0x8f64: return "GL_SHADER_PIXEL_LOCAL_STORAGE_EXT";
#endif
#if defined(GL_ARM_shader_framebuffer_fetch)
        case 0x8f65: return "GL_FETCH_PER_SAMPLE_ARM";
        case 0x8f66: return "GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM";
#endif
#if defined(GL_EXT_shader_pixel_local_storage)
        case 0x8f67: return "GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_SIZE_EXT";
#endif
#if defined(GL_EXT_texture_compression_astc_decode_mode)
        case 0x8f69: return "GL_TEXTURE_ASTC_DECODE_PRECISION_EXT";
#endif
#if defined(GL_ES_VERSION_3_0) || defined(GL_EXT_render_snorm)
        case 0x8f94: return "GL_R8_SNORM";
        case 0x8f95: return "GL_RG8_SNORM";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8f96: return "GL_RGB8_SNORM";
#endif
#if defined(GL_ES_VERSION_3_0) || defined(GL_EXT_render_snorm)
        case 0x8f97: return "GL_RGBA8_SNORM";
#endif
#if defined(GL_EXT_render_snorm)
        case 0x8f98: return "GL_R16_SNORM_EXT";
        case 0x8f99: return "GL_RG16_SNORM_EXT";
#endif
#if defined(GL_EXT_texture_norm16)
        case 0x8f9a: return "GL_RGB16_SNORM_EXT";
#endif
#if defined(GL_EXT_render_snorm)
        case 0x8f9b: return "GL_RGBA16_SNORM_EXT";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x8f9c: return "GL_SIGNED_NORMALIZED";
#endif
#if defined(GL_QCOM_perfmon_global_mode)
        case 0x8fa0: return "GL_PERFMON_GLOBAL_MODE_QCOM";
#endif
#if defined(GL_QCOM_binning_control)
        case 0x8fb0: return "GL_BINNING_CONTROL_HINT_QCOM";
        case 0x8fb1: return "GL_CPU_OPTIMIZED_QCOM";
        case 0x8fb2: return "GL_GPU_OPTIMIZED_QCOM";
        case 0x8fb3: return "GL_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM";
#endif
#if defined(GL_EXT_disjoint_timer_query)
        case 0x8fbb: return "GL_GPU_DISJOINT_EXT";
#endif
#if defined(GL_EXT_texture_sRGB_R8)
        case 0x8fbd: return "GL_SR8_EXT";
#endif
#if defined(GL_EXT_texture_sRGB_RG8)
        case 0x8fbe: return "GL_SRG8_EXT";
#endif
#if defined(GL_EXT_texture_format_sRGB_override)
        case 0x8fbf: return "GL_TEXTURE_FORMAT_SRGB_OVERRIDE_EXT";
#endif
#if defined(GL_VIV_shader_binary)
        case 0x8fc4: return "GL_SHADER_BINARY_VIV";
#endif
#if defined(GL_NV_gpu_shader5)
        case 0x8fe0: return "GL_INT8_NV";
        case 0x8fe1: return "GL_INT8_VEC2_NV";
        case 0x8fe2: return "GL_INT8_VEC3_NV";
        case 0x8fe3: return "GL_INT8_VEC4_NV";
        case 0x8fe4: return "GL_INT16_NV";
        case 0x8fe5: return "GL_INT16_VEC2_NV";
        case 0x8fe6: return "GL_INT16_VEC3_NV";
        case 0x8fe7: return "GL_INT16_VEC4_NV";
        case 0x8fe9: return "GL_INT64_VEC2_NV";
        case 0x8fea: return "GL_INT64_VEC3_NV";
        case 0x8feb: return "GL_INT64_VEC4_NV";
        case 0x8fec: return "GL_UNSIGNED_INT8_NV";
        case 0x8fed: return "GL_UNSIGNED_INT8_VEC2_NV";
        case 0x8fee: return "GL_UNSIGNED_INT8_VEC3_NV";
        case 0x8fef: return "GL_UNSIGNED_INT8_VEC4_NV";
        case 0x8ff0: return "GL_UNSIGNED_INT16_NV";
        case 0x8ff1: return "GL_UNSIGNED_INT16_VEC2_NV";
        case 0x8ff2: return "GL_UNSIGNED_INT16_VEC3_NV";
        case 0x8ff3: return "GL_UNSIGNED_INT16_VEC4_NV";
        case 0x8ff5: return "GL_UNSIGNED_INT64_VEC2_NV";
        case 0x8ff6: return "GL_UNSIGNED_INT64_VEC3_NV";
        case 0x8ff7: return "GL_UNSIGNED_INT64_VEC4_NV";
        case 0x8ff8: return "GL_FLOAT16_NV";
        case 0x8ff9: return "GL_FLOAT16_VEC2_NV";
        case 0x8ffa: return "GL_FLOAT16_VEC3_NV";
        case 0x8ffb: return "GL_FLOAT16_VEC4_NV";
#endif
        case 0x9009:
#if defined(GL_EXT_texture_cube_map_array)
                    return "GL_TEXTURE_CUBE_MAP_ARRAY_EXT";
#endif
#if defined(GL_OES_texture_cube_map_array)
                    return "GL_TEXTURE_CUBE_MAP_ARRAY_OES";
#endif
            break;
        case 0x900a:
#if defined(GL_EXT_texture_cube_map_array)
                    return "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_EXT";
#endif
#if defined(GL_OES_texture_cube_map_array)
                    return "GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_OES";
#endif
            break;
        case 0x900c:
#if defined(GL_EXT_texture_cube_map_array)
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_EXT";
#endif
#if defined(GL_OES_texture_cube_map_array)
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_OES";
#endif
            break;
        case 0x900d:
#if defined(GL_EXT_texture_cube_map_array)
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_EXT";
#endif
#if defined(GL_OES_texture_cube_map_array)
                    return "GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_OES";
#endif
            break;
        case 0x900e:
#if defined(GL_EXT_texture_cube_map_array)
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY_EXT";
#endif
#if defined(GL_OES_texture_cube_map_array)
                    return "GL_INT_SAMPLER_CUBE_MAP_ARRAY_OES";
#endif
            break;
        case 0x900f:
#if defined(GL_EXT_texture_cube_map_array)
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_EXT";
#endif
#if defined(GL_OES_texture_cube_map_array)
                    return "GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_OES";
#endif
            break;
#if defined(GL_NV_blend_minmax_factor)
        case 0x901c: return "GL_FACTOR_MIN_AMD";
        case 0x901d: return "GL_FACTOR_MAX_AMD";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x904d: return "GL_IMAGE_2D";
        case 0x904e: return "GL_IMAGE_3D";
        case 0x9050: return "GL_IMAGE_CUBE";
#endif
        case 0x9051:
#if defined(GL_EXT_texture_buffer)
                    return "GL_IMAGE_BUFFER_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_IMAGE_BUFFER_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x9053: return "GL_IMAGE_2D_ARRAY";
#endif
        case 0x9054:
#if defined(GL_EXT_texture_cube_map_array)
                    return "GL_IMAGE_CUBE_MAP_ARRAY_EXT";
#endif
#if defined(GL_OES_texture_cube_map_array)
                    return "GL_IMAGE_CUBE_MAP_ARRAY_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x9058: return "GL_INT_IMAGE_2D";
        case 0x9059: return "GL_INT_IMAGE_3D";
        case 0x905b: return "GL_INT_IMAGE_CUBE";
#endif
        case 0x905c:
#if defined(GL_EXT_texture_buffer)
                    return "GL_INT_IMAGE_BUFFER_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_INT_IMAGE_BUFFER_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x905e: return "GL_INT_IMAGE_2D_ARRAY";
#endif
        case 0x905f:
#if defined(GL_EXT_texture_cube_map_array)
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT";
#endif
#if defined(GL_OES_texture_cube_map_array)
                    return "GL_INT_IMAGE_CUBE_MAP_ARRAY_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x9063: return "GL_UNSIGNED_INT_IMAGE_2D";
        case 0x9064: return "GL_UNSIGNED_INT_IMAGE_3D";
        case 0x9066: return "GL_UNSIGNED_INT_IMAGE_CUBE";
#endif
        case 0x9067:
#if defined(GL_EXT_texture_buffer)
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_UNSIGNED_INT_IMAGE_BUFFER_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x9069: return "GL_UNSIGNED_INT_IMAGE_2D_ARRAY";
#endif
        case 0x906a:
#if defined(GL_EXT_texture_cube_map_array)
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT";
#endif
#if defined(GL_OES_texture_cube_map_array)
                    return "GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x906e: return "GL_IMAGE_BINDING_FORMAT";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x906f: return "GL_RGB10_A2UI";
#endif
#if defined(GL_NV_path_rendering)
        case 0x9070: return "GL_PATH_FORMAT_SVG_NV";
        case 0x9071: return "GL_PATH_FORMAT_PS_NV";
        case 0x9072: return "GL_STANDARD_FONT_NAME_NV";
        case 0x9073: return "GL_SYSTEM_FONT_NAME_NV";
        case 0x9074: return "GL_FILE_NAME_NV";
        case 0x9075: return "GL_PATH_STROKE_WIDTH_NV";
        case 0x9076: return "GL_PATH_END_CAPS_NV";
        case 0x9077: return "GL_PATH_INITIAL_END_CAP_NV";
        case 0x9078: return "GL_PATH_TERMINAL_END_CAP_NV";
        case 0x9079: return "GL_PATH_JOIN_STYLE_NV";
        case 0x907a: return "GL_PATH_MITER_LIMIT_NV";
        case 0x907b: return "GL_PATH_DASH_CAPS_NV";
        case 0x907c: return "GL_PATH_INITIAL_DASH_CAP_NV";
        case 0x907d: return "GL_PATH_TERMINAL_DASH_CAP_NV";
        case 0x907e: return "GL_PATH_DASH_OFFSET_NV";
        case 0x907f: return "GL_PATH_CLIENT_LENGTH_NV";
        case 0x9080: return "GL_PATH_FILL_MODE_NV";
        case 0x9081: return "GL_PATH_FILL_MASK_NV";
        case 0x9082: return "GL_PATH_FILL_COVER_MODE_NV";
        case 0x9083: return "GL_PATH_STROKE_COVER_MODE_NV";
        case 0x9084: return "GL_PATH_STROKE_MASK_NV";
        case 0x9088: return "GL_COUNT_UP_NV";
        case 0x9089: return "GL_COUNT_DOWN_NV";
        case 0x908a: return "GL_PATH_OBJECT_BOUNDING_BOX_NV";
        case 0x908b: return "GL_CONVEX_HULL_NV";
        case 0x908d: return "GL_BOUNDING_BOX_NV";
        case 0x908e: return "GL_TRANSLATE_X_NV";
        case 0x908f: return "GL_TRANSLATE_Y_NV";
        case 0x9090: return "GL_TRANSLATE_2D_NV";
        case 0x9091: return "GL_TRANSLATE_3D_NV";
        case 0x9092: return "GL_AFFINE_2D_NV";
        case 0x9094: return "GL_AFFINE_3D_NV";
        case 0x9096: return "GL_TRANSPOSE_AFFINE_2D_NV";
        case 0x9098: return "GL_TRANSPOSE_AFFINE_3D_NV";
        case 0x909a: return "GL_UTF8_NV";
        case 0x909b: return "GL_UTF16_NV";
        case 0x909c: return "GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV";
        case 0x909d: return "GL_PATH_COMMAND_COUNT_NV";
        case 0x909e: return "GL_PATH_COORD_COUNT_NV";
        case 0x909f: return "GL_PATH_DASH_ARRAY_COUNT_NV";
        case 0x90a0: return "GL_PATH_COMPUTED_LENGTH_NV";
        case 0x90a1: return "GL_PATH_FILL_BOUNDING_BOX_NV";
        case 0x90a2: return "GL_PATH_STROKE_BOUNDING_BOX_NV";
        case 0x90a3: return "GL_SQUARE_NV";
        case 0x90a4: return "GL_ROUND_NV";
        case 0x90a5: return "GL_TRIANGULAR_NV";
        case 0x90a6: return "GL_BEVEL_NV";
        case 0x90a7: return "GL_MITER_REVERT_NV";
        case 0x90a8: return "GL_MITER_TRUNCATE_NV";
        case 0x90a9: return "GL_SKIP_MISSING_GLYPH_NV";
        case 0x90aa: return "GL_USE_MISSING_GLYPH_NV";
        case 0x90ab: return "GL_PATH_ERROR_POSITION_NV";
        case 0x90ad: return "GL_ACCUM_ADJACENT_PAIRS_NV";
        case 0x90ae: return "GL_ADJACENT_PAIRS_NV";
        case 0x90af: return "GL_FIRST_TO_REST_NV";
        case 0x90b0: return "GL_PATH_GEN_MODE_NV";
        case 0x90b1: return "GL_PATH_GEN_COEFF_NV";
        case 0x90b3: return "GL_PATH_GEN_COMPONENTS_NV";
        case 0x90b4: return "GL_PATH_DASH_OFFSET_RESET_NV";
        case 0x90b5: return "GL_MOVE_TO_RESETS_NV";
        case 0x90b6: return "GL_MOVE_TO_CONTINUES_NV";
        case 0x90b7: return "GL_PATH_STENCIL_FUNC_NV";
        case 0x90b8: return "GL_PATH_STENCIL_REF_NV";
        case 0x90b9: return "GL_PATH_STENCIL_VALUE_MASK_NV";
        case 0x90bd: return "GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV";
        case 0x90be: return "GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV";
        case 0x90bf: return "GL_PATH_COVER_DEPTH_FUNC_NV";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x90c7: return "GL_IMAGE_FORMAT_COMPATIBILITY_TYPE";
        case 0x90c8: return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE";
        case 0x90c9: return "GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS";
        case 0x90ca: return "GL_MAX_VERTEX_IMAGE_UNIFORMS";
#endif
        case 0x90cb:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_OES";
#endif
            break;
        case 0x90cc:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_OES";
#endif
            break;
        case 0x90cd:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_IMAGE_UNIFORMS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x90ce: return "GL_MAX_FRAGMENT_IMAGE_UNIFORMS";
        case 0x90cf: return "GL_MAX_COMBINED_IMAGE_UNIFORMS";
        case 0x90d2: return "GL_SHADER_STORAGE_BUFFER";
        case 0x90d3: return "GL_SHADER_STORAGE_BUFFER_BINDING";
        case 0x90d4: return "GL_SHADER_STORAGE_BUFFER_START";
        case 0x90d5: return "GL_SHADER_STORAGE_BUFFER_SIZE";
        case 0x90d6: return "GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS";
#endif
        case 0x90d7:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_OES";
#endif
            break;
        case 0x90d8:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_OES";
#endif
            break;
        case 0x90d9:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x90da: return "GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS";
        case 0x90db: return "GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS";
        case 0x90dc: return "GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS";
        case 0x90dd: return "GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS";
        case 0x90de: return "GL_MAX_SHADER_STORAGE_BLOCK_SIZE";
        case 0x90df: return "GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT";
        case 0x90ea: return "GL_DEPTH_STENCIL_TEXTURE_MODE";
        case 0x90eb: return "GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS";
        case 0x90ee: return "GL_DISPATCH_INDIRECT_BUFFER";
        case 0x90ef: return "GL_DISPATCH_INDIRECT_BUFFER_BINDING";
#endif
#if defined(GL_EXT_multiview_draw_buffers)
        case 0x90f0: return "GL_COLOR_ATTACHMENT_EXT";
        case 0x90f1: return "GL_MULTIVIEW_EXT";
        case 0x90f2: return "GL_MAX_MULTIVIEW_BUFFERS_EXT";
#endif
        case 0x90f3:
#if defined(GL_EXT_robustness)
                    return "GL_CONTEXT_ROBUST_ACCESS_EXT";
#endif
#if defined(GL_KHR_robustness)
                    return "GL_CONTEXT_ROBUST_ACCESS_KHR";
#endif
            break;
#if defined(GL_ES_VERSION_3_1) || defined(GL_NV_internalformat_sample_query)
        case 0x9100: return "GL_TEXTURE_2D_MULTISAMPLE";
#endif
        case 0x9102:
#if defined(GL_NV_internalformat_sample_query)
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY";
#endif
#if defined(GL_OES_texture_storage_multisample_2d_array)
                    return "GL_TEXTURE_2D_MULTISAMPLE_ARRAY_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x9104: return "GL_TEXTURE_BINDING_2D_MULTISAMPLE";
#endif
#if defined(GL_OES_texture_storage_multisample_2d_array)
        case 0x9105: return "GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY_OES";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x9106: return "GL_TEXTURE_SAMPLES";
        case 0x9107: return "GL_TEXTURE_FIXED_SAMPLE_LOCATIONS";
        case 0x9108: return "GL_SAMPLER_2D_MULTISAMPLE";
        case 0x9109: return "GL_INT_SAMPLER_2D_MULTISAMPLE";
        case 0x910a: return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE";
#endif
#if defined(GL_OES_texture_storage_multisample_2d_array)
        case 0x910b: return "GL_SAMPLER_2D_MULTISAMPLE_ARRAY_OES";
        case 0x910c: return "GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES";
        case 0x910d: return "GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x910e: return "GL_MAX_COLOR_TEXTURE_SAMPLES";
        case 0x910f: return "GL_MAX_DEPTH_TEXTURE_SAMPLES";
        case 0x9110: return "GL_MAX_INTEGER_SAMPLES";
#endif
        case 0x9111:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_MAX_SERVER_WAIT_TIMEOUT";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_MAX_SERVER_WAIT_TIMEOUT_APPLE";
#endif
            break;
        case 0x9112:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_OBJECT_TYPE";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_OBJECT_TYPE_APPLE";
#endif
            break;
        case 0x9113:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SYNC_CONDITION";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_SYNC_CONDITION_APPLE";
#endif
            break;
        case 0x9114:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SYNC_STATUS";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_SYNC_STATUS_APPLE";
#endif
            break;
        case 0x9115:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SYNC_FLAGS";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_SYNC_FLAGS_APPLE";
#endif
            break;
        case 0x9116:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SYNC_FENCE";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_SYNC_FENCE_APPLE";
#endif
            break;
        case 0x9117:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SYNC_GPU_COMMANDS_COMPLETE";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE";
#endif
            break;
        case 0x9118:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_UNSIGNALED";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_UNSIGNALED_APPLE";
#endif
            break;
        case 0x9119:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_SIGNALED";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_SIGNALED_APPLE";
#endif
            break;
        case 0x911a:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_ALREADY_SIGNALED";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_ALREADY_SIGNALED_APPLE";
#endif
            break;
        case 0x911b:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_TIMEOUT_EXPIRED";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_TIMEOUT_EXPIRED_APPLE";
#endif
            break;
        case 0x911c:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_CONDITION_SATISFIED";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_CONDITION_SATISFIED_APPLE";
#endif
            break;
        case 0x911d:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_WAIT_FAILED";
#endif
#if defined(GL_APPLE_sync)
                    return "GL_WAIT_FAILED_APPLE";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x911f: return "GL_BUFFER_ACCESS_FLAGS";
        case 0x9120: return "GL_BUFFER_MAP_LENGTH";
        case 0x9121: return "GL_BUFFER_MAP_OFFSET";
        case 0x9122: return "GL_MAX_VERTEX_OUTPUT_COMPONENTS";
#endif
        case 0x9123:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_INPUT_COMPONENTS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_INPUT_COMPONENTS_OES";
#endif
            break;
        case 0x9124:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_0)
        case 0x9125: return "GL_MAX_FRAGMENT_INPUT_COMPONENTS";
#endif
        case 0x912f:
#if defined(GL_ES_VERSION_3_0)
                    return "GL_TEXTURE_IMMUTABLE_FORMAT";
#endif
#if defined(GL_EXT_texture_storage)
                    return "GL_TEXTURE_IMMUTABLE_FORMAT_EXT";
#endif
            break;
#if defined(GL_IMG_program_binary)
        case 0x9130: return "GL_SGX_PROGRAM_BINARY_IMG";
#endif
#if defined(GL_IMG_multisampled_render_to_texture)
        case 0x9133: return "GL_RENDERBUFFER_SAMPLES_IMG";
        case 0x9134: return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG";
        case 0x9135: return "GL_MAX_SAMPLES_IMG";
        case 0x9136: return "GL_TEXTURE_SAMPLES_IMG";
#endif
#if defined(GL_IMG_texture_compression_pvrtc2)
        case 0x9137: return "GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG";
        case 0x9138: return "GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG";
#endif
#if defined(GL_IMG_texture_filter_cubic)
        case 0x9139: return "GL_CUBIC_IMG";
        case 0x913a: return "GL_CUBIC_MIPMAP_NEAREST_IMG";
        case 0x913b: return "GL_CUBIC_MIPMAP_LINEAR_IMG";
#endif
#if defined(GL_IMG_framebuffer_downsample)
        case 0x913c: return "GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_AND_DOWNSAMPLE_IMG";
        case 0x913d: return "GL_NUM_DOWNSAMPLE_SCALES_IMG";
        case 0x913e: return "GL_DOWNSAMPLE_SCALES_IMG";
        case 0x913f: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SCALE_IMG";
#endif
#if defined(GL_KHR_debug)
        case 0x9143: return "GL_MAX_DEBUG_MESSAGE_LENGTH_KHR";
        case 0x9144: return "GL_MAX_DEBUG_LOGGED_MESSAGES_KHR";
        case 0x9145: return "GL_DEBUG_LOGGED_MESSAGES_KHR";
        case 0x9146: return "GL_DEBUG_SEVERITY_HIGH_KHR";
        case 0x9147: return "GL_DEBUG_SEVERITY_MEDIUM_KHR";
        case 0x9148: return "GL_DEBUG_SEVERITY_LOW_KHR";
#endif
#if defined(GL_EXT_debug_label)
        case 0x9151: return "GL_BUFFER_OBJECT_EXT";
        case 0x9153: return "GL_QUERY_OBJECT_EXT";
        case 0x9154: return "GL_VERTEX_ARRAY_OBJECT_EXT";
#endif
#if defined(GL_EXT_sparse_texture)
        case 0x9195: return "GL_VIRTUAL_PAGE_SIZE_X_EXT";
        case 0x9196: return "GL_VIRTUAL_PAGE_SIZE_Y_EXT";
        case 0x9197: return "GL_VIRTUAL_PAGE_SIZE_Z_EXT";
        case 0x9198: return "GL_MAX_SPARSE_TEXTURE_SIZE_EXT";
        case 0x9199: return "GL_MAX_SPARSE_3D_TEXTURE_SIZE_EXT";
        case 0x919a: return "GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_EXT";
#endif
        case 0x919d:
#if defined(GL_EXT_texture_buffer)
                    return "GL_TEXTURE_BUFFER_OFFSET_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_TEXTURE_BUFFER_OFFSET_OES";
#endif
            break;
        case 0x919e:
#if defined(GL_EXT_texture_buffer)
                    return "GL_TEXTURE_BUFFER_SIZE_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_TEXTURE_BUFFER_SIZE_OES";
#endif
            break;
        case 0x919f:
#if defined(GL_EXT_texture_buffer)
                    return "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_EXT";
#endif
#if defined(GL_OES_texture_buffer)
                    return "GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_OES";
#endif
            break;
#if defined(GL_EXT_sparse_texture)
        case 0x91a6: return "GL_TEXTURE_SPARSE_EXT";
        case 0x91a7: return "GL_VIRTUAL_PAGE_SIZE_INDEX_EXT";
        case 0x91a8: return "GL_NUM_VIRTUAL_PAGE_SIZES_EXT";
        case 0x91a9: return "GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_EXT";
        case 0x91aa: return "GL_NUM_SPARSE_LEVELS_EXT";
#endif
#if defined(GL_KHR_parallel_shader_compile)
        case 0x91b0: return "GL_MAX_SHADER_COMPILER_THREADS_KHR";
        case 0x91b1: return "GL_COMPLETION_STATUS_KHR";
#endif
#if defined(GL_AMD_framebuffer_multisample_advanced)
        case 0x91b2: return "GL_RENDERBUFFER_STORAGE_SAMPLES_AMD";
        case 0x91b3: return "GL_MAX_COLOR_FRAMEBUFFER_SAMPLES_AMD";
        case 0x91b4: return "GL_MAX_COLOR_FRAMEBUFFER_STORAGE_SAMPLES_AMD";
        case 0x91b5: return "GL_MAX_DEPTH_STENCIL_FRAMEBUFFER_SAMPLES_AMD";
        case 0x91b6: return "GL_NUM_SUPPORTED_MULTISAMPLE_MODES_AMD";
        case 0x91b7: return "GL_SUPPORTED_MULTISAMPLE_MODES_AMD";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x91b9: return "GL_COMPUTE_SHADER";
        case 0x91bb: return "GL_MAX_COMPUTE_UNIFORM_BLOCKS";
        case 0x91bc: return "GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS";
        case 0x91bd: return "GL_MAX_COMPUTE_IMAGE_UNIFORMS";
        case 0x91be: return "GL_MAX_COMPUTE_WORK_GROUP_COUNT";
        case 0x91bf: return "GL_MAX_COMPUTE_WORK_GROUP_SIZE";
#endif
#if defined(GL_DMP_shader_binary)
        case 0x9250: return "GL_SHADER_BINARY_DMP";
#endif
#if defined(GL_DMP_program_binary)
        case 0x9251: return "GL_SMAPHS30_PROGRAM_BINARY_DMP";
        case 0x9252: return "GL_SMAPHS_PROGRAM_BINARY_DMP";
        case 0x9253: return "GL_DMP_PROGRAM_BINARY_DMP";
#endif
#if defined(GL_FJ_shader_binary_GCCSO)
        case 0x9260: return "GL_GCCSO_SHADER_BINARY_FJ";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x9270: return "GL_COMPRESSED_R11_EAC";
        case 0x9271: return "GL_COMPRESSED_SIGNED_R11_EAC";
        case 0x9272: return "GL_COMPRESSED_RG11_EAC";
        case 0x9273: return "GL_COMPRESSED_SIGNED_RG11_EAC";
        case 0x9274: return "GL_COMPRESSED_RGB8_ETC2";
        case 0x9275: return "GL_COMPRESSED_SRGB8_ETC2";
        case 0x9276: return "GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2";
        case 0x9277: return "GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2";
        case 0x9278: return "GL_COMPRESSED_RGBA8_ETC2_EAC";
        case 0x9279: return "GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC";
#endif
#if defined(GL_NV_blend_equation_advanced)
        case 0x9280: return "GL_BLEND_PREMULTIPLIED_SRC_NV";
        case 0x9281: return "GL_BLEND_OVERLAP_NV";
        case 0x9282: return "GL_UNCORRELATED_NV";
        case 0x9283: return "GL_DISJOINT_NV";
        case 0x9284: return "GL_CONJOINT_NV";
#endif
        case 0x9285:
#if defined(GL_KHR_blend_equation_advanced_coherent)
                    return "GL_BLEND_ADVANCED_COHERENT_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced_coherent)
                    return "GL_BLEND_ADVANCED_COHERENT_NV";
#endif
            break;
#if defined(GL_NV_blend_equation_advanced)
        case 0x9286: return "GL_SRC_NV";
        case 0x9287: return "GL_DST_NV";
        case 0x9288: return "GL_SRC_OVER_NV";
        case 0x9289: return "GL_DST_OVER_NV";
        case 0x928a: return "GL_SRC_IN_NV";
        case 0x928b: return "GL_DST_IN_NV";
        case 0x928c: return "GL_SRC_OUT_NV";
        case 0x928d: return "GL_DST_OUT_NV";
        case 0x928e: return "GL_SRC_ATOP_NV";
        case 0x928f: return "GL_DST_ATOP_NV";
        case 0x9291: return "GL_PLUS_NV";
        case 0x9292: return "GL_PLUS_DARKER_NV";
#endif
        case 0x9294:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_MULTIPLY_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_MULTIPLY_NV";
#endif
            break;
        case 0x9295:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_SCREEN_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_SCREEN_NV";
#endif
            break;
        case 0x9296:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_OVERLAY_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_OVERLAY_NV";
#endif
            break;
        case 0x9297:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_DARKEN_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_DARKEN_NV";
#endif
            break;
        case 0x9298:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_LIGHTEN_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_LIGHTEN_NV";
#endif
            break;
        case 0x9299:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_COLORDODGE_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_COLORDODGE_NV";
#endif
            break;
        case 0x929a:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_COLORBURN_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_COLORBURN_NV";
#endif
            break;
        case 0x929b:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HARDLIGHT_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HARDLIGHT_NV";
#endif
            break;
        case 0x929c:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_SOFTLIGHT_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_SOFTLIGHT_NV";
#endif
            break;
        case 0x929e:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_DIFFERENCE_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_DIFFERENCE_NV";
#endif
            break;
#if defined(GL_NV_blend_equation_advanced)
        case 0x929f: return "GL_MINUS_NV";
#endif
        case 0x92a0:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_EXCLUSION_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_EXCLUSION_NV";
#endif
            break;
#if defined(GL_NV_blend_equation_advanced)
        case 0x92a1: return "GL_CONTRAST_NV";
        case 0x92a3: return "GL_INVERT_RGB_NV";
        case 0x92a4: return "GL_LINEARDODGE_NV";
        case 0x92a5: return "GL_LINEARBURN_NV";
        case 0x92a6: return "GL_VIVIDLIGHT_NV";
        case 0x92a7: return "GL_LINEARLIGHT_NV";
        case 0x92a8: return "GL_PINLIGHT_NV";
        case 0x92a9: return "GL_HARDMIX_NV";
#endif
        case 0x92ad:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HSL_HUE_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HSL_HUE_NV";
#endif
            break;
        case 0x92ae:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HSL_SATURATION_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HSL_SATURATION_NV";
#endif
            break;
        case 0x92af:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HSL_COLOR_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HSL_COLOR_NV";
#endif
            break;
        case 0x92b0:
#if defined(GL_KHR_blend_equation_advanced)
                    return "GL_HSL_LUMINOSITY_KHR";
#endif
#if defined(GL_NV_blend_equation_advanced)
                    return "GL_HSL_LUMINOSITY_NV";
#endif
            break;
#if defined(GL_NV_blend_equation_advanced)
        case 0x92b1: return "GL_PLUS_CLAMPED_NV";
        case 0x92b2: return "GL_PLUS_CLAMPED_ALPHA_NV";
        case 0x92b3: return "GL_MINUS_CLAMPED_NV";
        case 0x92b4: return "GL_INVERT_OVG_NV";
#endif
        case 0x92be:
#if defined(GL_EXT_primitive_bounding_box)
                    return "GL_PRIMITIVE_BOUNDING_BOX_EXT";
#endif
#if defined(GL_OES_primitive_bounding_box)
                    return "GL_PRIMITIVE_BOUNDING_BOX_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x92c0: return "GL_ATOMIC_COUNTER_BUFFER";
        case 0x92c1: return "GL_ATOMIC_COUNTER_BUFFER_BINDING";
        case 0x92c2: return "GL_ATOMIC_COUNTER_BUFFER_START";
        case 0x92c3: return "GL_ATOMIC_COUNTER_BUFFER_SIZE";
        case 0x92cc: return "GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS";
#endif
        case 0x92cd:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_OES";
#endif
            break;
        case 0x92ce:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_OES";
#endif
            break;
        case 0x92cf:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x92d0: return "GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS";
        case 0x92d1: return "GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS";
        case 0x92d2: return "GL_MAX_VERTEX_ATOMIC_COUNTERS";
#endif
        case 0x92d3:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_OES";
#endif
            break;
        case 0x92d4:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_OES";
#endif
            break;
        case 0x92d5:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_GEOMETRY_ATOMIC_COUNTERS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x92d6: return "GL_MAX_FRAGMENT_ATOMIC_COUNTERS";
        case 0x92d7: return "GL_MAX_COMBINED_ATOMIC_COUNTERS";
        case 0x92d8: return "GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE";
        case 0x92d9: return "GL_ACTIVE_ATOMIC_COUNTER_BUFFERS";
        case 0x92db: return "GL_UNSIGNED_INT_ATOMIC_COUNTER";
        case 0x92dc: return "GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS";
#endif
#if defined(GL_NV_fragment_coverage_to_color)
        case 0x92dd: return "GL_FRAGMENT_COVERAGE_TO_COLOR_NV";
        case 0x92de: return "GL_FRAGMENT_COVERAGE_COLOR_NV";
#endif
#if defined(GL_KHR_debug)
        case 0x92e0: return "GL_DEBUG_OUTPUT_KHR";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x92e1: return "GL_UNIFORM";
        case 0x92e2: return "GL_UNIFORM_BLOCK";
        case 0x92e3: return "GL_PROGRAM_INPUT";
        case 0x92e4: return "GL_PROGRAM_OUTPUT";
        case 0x92e5: return "GL_BUFFER_VARIABLE";
        case 0x92e6: return "GL_SHADER_STORAGE_BLOCK";
#endif
        case 0x92e7:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_IS_PER_PATCH_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_IS_PER_PATCH_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x92f4: return "GL_TRANSFORM_FEEDBACK_VARYING";
        case 0x92f5: return "GL_ACTIVE_RESOURCES";
        case 0x92f6: return "GL_MAX_NAME_LENGTH";
        case 0x92f7: return "GL_MAX_NUM_ACTIVE_VARIABLES";
        case 0x92f9: return "GL_NAME_LENGTH";
        case 0x92fa: return "GL_TYPE";
        case 0x92fb: return "GL_ARRAY_SIZE";
        case 0x92fc: return "GL_OFFSET";
        case 0x92fd: return "GL_BLOCK_INDEX";
        case 0x92fe: return "GL_ARRAY_STRIDE";
        case 0x92ff: return "GL_MATRIX_STRIDE";
        case 0x9300: return "GL_IS_ROW_MAJOR";
        case 0x9301: return "GL_ATOMIC_COUNTER_BUFFER_INDEX";
        case 0x9302: return "GL_BUFFER_BINDING";
        case 0x9303: return "GL_BUFFER_DATA_SIZE";
        case 0x9304: return "GL_NUM_ACTIVE_VARIABLES";
        case 0x9305: return "GL_ACTIVE_VARIABLES";
        case 0x9306: return "GL_REFERENCED_BY_VERTEX_SHADER";
#endif
        case 0x9307:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_REFERENCED_BY_TESS_CONTROL_SHADER_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_REFERENCED_BY_TESS_CONTROL_SHADER_OES";
#endif
            break;
        case 0x9308:
#if defined(GL_EXT_tessellation_shader)
                    return "GL_REFERENCED_BY_TESS_EVALUATION_SHADER_EXT";
#endif
#if defined(GL_OES_tessellation_shader)
                    return "GL_REFERENCED_BY_TESS_EVALUATION_SHADER_OES";
#endif
            break;
        case 0x9309:
#if defined(GL_EXT_geometry_shader)
                    return "GL_REFERENCED_BY_GEOMETRY_SHADER_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_REFERENCED_BY_GEOMETRY_SHADER_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x930a: return "GL_REFERENCED_BY_FRAGMENT_SHADER";
        case 0x930b: return "GL_REFERENCED_BY_COMPUTE_SHADER";
        case 0x930c: return "GL_TOP_LEVEL_ARRAY_SIZE";
        case 0x930d: return "GL_TOP_LEVEL_ARRAY_STRIDE";
        case 0x930e: return "GL_LOCATION";
#endif
#if defined(GL_EXT_blend_func_extended)
        case 0x930f: return "GL_LOCATION_INDEX_EXT";
#endif
#if defined(GL_ES_VERSION_3_1)
        case 0x9310: return "GL_FRAMEBUFFER_DEFAULT_WIDTH";
        case 0x9311: return "GL_FRAMEBUFFER_DEFAULT_HEIGHT";
#endif
        case 0x9312:
#if defined(GL_EXT_geometry_shader)
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_FRAMEBUFFER_DEFAULT_LAYERS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x9313: return "GL_FRAMEBUFFER_DEFAULT_SAMPLES";
        case 0x9314: return "GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS";
        case 0x9315: return "GL_MAX_FRAMEBUFFER_WIDTH";
        case 0x9316: return "GL_MAX_FRAMEBUFFER_HEIGHT";
#endif
        case 0x9317:
#if defined(GL_EXT_geometry_shader)
                    return "GL_MAX_FRAMEBUFFER_LAYERS_EXT";
#endif
#if defined(GL_OES_geometry_shader)
                    return "GL_MAX_FRAMEBUFFER_LAYERS_OES";
#endif
            break;
#if defined(GL_ES_VERSION_3_1)
        case 0x9318: return "GL_MAX_FRAMEBUFFER_SAMPLES";
#endif
#if defined(GL_EXT_raster_multisample)
        case 0x9327: return "GL_RASTER_MULTISAMPLE_EXT";
        case 0x9328: return "GL_RASTER_SAMPLES_EXT";
        case 0x9329: return "GL_MAX_RASTER_SAMPLES_EXT";
        case 0x932a: return "GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT";
        case 0x932b: return "GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT";
        case 0x932c: return "GL_EFFECTIVE_RASTER_SAMPLES_EXT";
#endif
#if defined(GL_NV_framebuffer_mixed_samples)
        case 0x932d: return "GL_DEPTH_SAMPLES_NV";
        case 0x932e: return "GL_STENCIL_SAMPLES_NV";
        case 0x932f: return "GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV";
        case 0x9330: return "GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV";
        case 0x9331: return "GL_COVERAGE_MODULATION_TABLE_NV";
        case 0x9332: return "GL_COVERAGE_MODULATION_NV";
        case 0x9333: return "GL_COVERAGE_MODULATION_TABLE_SIZE_NV";
#endif
#if defined(GL_NV_fill_rectangle)
        case 0x933c: return "GL_FILL_RECTANGLE_NV";
#endif
#if defined(GL_NV_sample_locations)
        case 0x933e: return "GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV";
        case 0x933f: return "GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV";
        case 0x9340: return "GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV";
        case 0x9341: return "GL_PROGRAMMABLE_SAMPLE_LOCATION_NV";
        case 0x9342: return "GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV";
        case 0x9343: return "GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV";
#endif
#if defined(GL_NV_conservative_raster)
        case 0x9346: return "GL_CONSERVATIVE_RASTERIZATION_NV";
#endif
#if defined(GL_NV_viewport_swizzle)
        case 0x9350: return "GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV";
        case 0x9351: return "GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV";
        case 0x9352: return "GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV";
        case 0x9353: return "GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV";
        case 0x9354: return "GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV";
        case 0x9355: return "GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV";
        case 0x9356: return "GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV";
        case 0x9357: return "GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV";
        case 0x9358: return "GL_VIEWPORT_SWIZZLE_X_NV";
        case 0x9359: return "GL_VIEWPORT_SWIZZLE_Y_NV";
        case 0x935a: return "GL_VIEWPORT_SWIZZLE_Z_NV";
        case 0x935b: return "GL_VIEWPORT_SWIZZLE_W_NV";
#endif
#if defined(GL_EXT_clip_control)
        case 0x935c: return "GL_CLIP_ORIGIN_EXT";
        case 0x935d: return "GL_CLIP_DEPTH_MODE_EXT";
        case 0x935e: return "GL_NEGATIVE_ONE_TO_ONE_EXT";
        case 0x935f: return "GL_ZERO_TO_ONE_EXT";
#endif
#if defined(GL_EXT_texture_filter_minmax)
        case 0x9366: return "GL_TEXTURE_REDUCTION_MODE_EXT";
        case 0x9367: return "GL_WEIGHTED_AVERAGE_EXT";
#endif
#if defined(GL_NV_path_rendering)
        case 0x9368: return "GL_FONT_GLYPHS_AVAILABLE_NV";
        case 0x9369: return "GL_FONT_TARGET_UNAVAILABLE_NV";
        case 0x936a: return "GL_FONT_UNAVAILABLE_NV";
        case 0x936b: return "GL_FONT_UNINTELLIGIBLE_NV";
        case 0x936c: return "GL_STANDARD_FONT_FORMAT_NV";
        case 0x936d: return "GL_FRAGMENT_INPUT_NV";
#endif
#if defined(GL_NV_internalformat_sample_query)
        case 0x9371: return "GL_MULTISAMPLES_NV";
        case 0x9372: return "GL_SUPERSAMPLE_SCALE_X_NV";
        case 0x9373: return "GL_SUPERSAMPLE_SCALE_Y_NV";
        case 0x9374: return "GL_CONFORMANT_NV";
#endif
#if defined(GL_NV_clip_space_w_scaling)
        case 0x937c: return "GL_VIEWPORT_POSITION_W_SCALE_NV";
        case 0x937d: return "GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV";
        case 0x937e: return "GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV";
#endif
#if defined(GL_ES_VERSION_3_0)
        case 0x9380: return "GL_NUM_SAMPLE_COUNTS";
#endif
#if defined(GL_ANGLE_translated_shader_source)
        case 0x93a0: return "GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE";
#endif
#if defined(GL_APPLE_texture_format_BGRA8888)
        case 0x93a1: return "GL_BGRA8_EXT";
#endif
#if defined(GL_ANGLE_texture_usage)
        case 0x93a2: return "GL_TEXTURE_USAGE_ANGLE";
        case 0x93a3: return "GL_FRAMEBUFFER_ATTACHMENT_ANGLE";
#endif
#if defined(GL_ANGLE_pack_reverse_row_order)
        case 0x93a4: return "GL_PACK_REVERSE_ROW_ORDER_ANGLE";
#endif
#if defined(GL_ANGLE_program_binary)
        case 0x93a6: return "GL_PROGRAM_BINARY_ANGLE";
#endif
#if defined(GL_KHR_texture_compression_astc_hdr)
        case 0x93b0: return "GL_COMPRESSED_RGBA_ASTC_4x4_KHR";
        case 0x93b1: return "GL_COMPRESSED_RGBA_ASTC_5x4_KHR";
        case 0x93b2: return "GL_COMPRESSED_RGBA_ASTC_5x5_KHR";
        case 0x93b3: return "GL_COMPRESSED_RGBA_ASTC_6x5_KHR";
        case 0x93b4: return "GL_COMPRESSED_RGBA_ASTC_6x6_KHR";
        case 0x93b5: return "GL_COMPRESSED_RGBA_ASTC_8x5_KHR";
        case 0x93b6: return "GL_COMPRESSED_RGBA_ASTC_8x6_KHR";
        case 0x93b7: return "GL_COMPRESSED_RGBA_ASTC_8x8_KHR";
        case 0x93b8: return "GL_COMPRESSED_RGBA_ASTC_10x5_KHR";
        case 0x93b9: return "GL_COMPRESSED_RGBA_ASTC_10x6_KHR";
        case 0x93ba: return "GL_COMPRESSED_RGBA_ASTC_10x8_KHR";
        case 0x93bb: return "GL_COMPRESSED_RGBA_ASTC_10x10_KHR";
        case 0x93bc: return "GL_COMPRESSED_RGBA_ASTC_12x10_KHR";
        case 0x93bd: return "GL_COMPRESSED_RGBA_ASTC_12x12_KHR";
#endif
#if defined(GL_OES_texture_compression_astc)
        case 0x93c0: return "GL_COMPRESSED_RGBA_ASTC_3x3x3_OES";
        case 0x93c1: return "GL_COMPRESSED_RGBA_ASTC_4x3x3_OES";
        case 0x93c2: return "GL_COMPRESSED_RGBA_ASTC_4x4x3_OES";
        case 0x93c3: return "GL_COMPRESSED_RGBA_ASTC_4x4x4_OES";
        case 0x93c4: return "GL_COMPRESSED_RGBA_ASTC_5x4x4_OES";
        case 0x93c5: return "GL_COMPRESSED_RGBA_ASTC_5x5x4_OES";
        case 0x93c6: return "GL_COMPRESSED_RGBA_ASTC_5x5x5_OES";
        case 0x93c7: return "GL_COMPRESSED_RGBA_ASTC_6x5x5_OES";
        case 0x93c8: return "GL_COMPRESSED_RGBA_ASTC_6x6x5_OES";
        case 0x93c9: return "GL_COMPRESSED_RGBA_ASTC_6x6x6_OES";
#endif
#if defined(GL_KHR_texture_compression_astc_hdr)
        case 0x93d0: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR";
        case 0x93d1: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR";
        case 0x93d2: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR";
        case 0x93d3: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR";
        case 0x93d4: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR";
        case 0x93d5: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR";
        case 0x93d6: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR";
        case 0x93d7: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR";
        case 0x93d8: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR";
        case 0x93d9: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR";
        case 0x93da: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR";
        case 0x93db: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR";
        case 0x93dc: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR";
        case 0x93dd: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR";
#endif
#if defined(GL_OES_texture_compression_astc)
        case 0x93e0: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES";
        case 0x93e1: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES";
        case 0x93e2: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES";
        case 0x93e3: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES";
        case 0x93e4: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES";
        case 0x93e5: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES";
        case 0x93e6: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES";
        case 0x93e7: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES";
        case 0x93e8: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES";
        case 0x93e9: return "GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES";
#endif
#if defined(GL_EXT_pvrtc_sRGB)
        case 0x93f0: return "GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG";
        case 0x93f1: return "GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG";
#endif
#if defined(GL_INTEL_performance_query)
        case 0x94f0: return "GL_PERFQUERY_COUNTER_EVENT_INTEL";
        case 0x94f1: return "GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL";
        case 0x94f2: return "GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL";
        case 0x94f3: return "GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL";
        case 0x94f4: return "GL_PERFQUERY_COUNTER_RAW_INTEL";
        case 0x94f5: return "GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL";
        case 0x94f8: return "GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL";
        case 0x94f9: return "GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL";
        case 0x94fa: return "GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL";
        case 0x94fb: return "GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL";
        case 0x94fc: return "GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL";
        case 0x94fd: return "GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL";
        case 0x94fe: return "GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL";
        case 0x94ff: return "GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL";
        case 0x9500: return "GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL";
#endif
#if defined(GL_EXT_semaphore)
        case 0x9530: return "GL_LAYOUT_DEPTH_READ_ONLY_STENCIL_ATTACHMENT_EXT";
        case 0x9531: return "GL_LAYOUT_DEPTH_ATTACHMENT_STENCIL_READ_ONLY_EXT";
#endif
#if defined(GL_NV_conservative_raster_pre_snap_triangles)
        case 0x954d: return "GL_CONSERVATIVE_RASTER_MODE_NV";
        case 0x954e: return "GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV";
        case 0x954f: return "GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV";
#endif
#if defined(GL_NV_conservative_raster_pre_snap)
        case 0x9550: return "GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_NV";
#endif
#if defined(GL_EXT_memory_object)
        case 0x9580: return "GL_TEXTURE_TILING_EXT";
        case 0x9581: return "GL_DEDICATED_MEMORY_OBJECT_EXT";
        case 0x9582: return "GL_NUM_TILING_TYPES_EXT";
        case 0x9583: return "GL_TILING_TYPES_EXT";
        case 0x9584: return "GL_OPTIMAL_TILING_EXT";
        case 0x9585: return "GL_LINEAR_TILING_EXT";
#endif
#if defined(GL_EXT_memory_object_fd)
        case 0x9586: return "GL_HANDLE_TYPE_OPAQUE_FD_EXT";
#endif
#if defined(GL_EXT_memory_object_win32)
        case 0x9587: return "GL_HANDLE_TYPE_OPAQUE_WIN32_EXT";
        case 0x9588: return "GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT";
        case 0x9589: return "GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT";
        case 0x958a: return "GL_HANDLE_TYPE_D3D12_RESOURCE_EXT";
        case 0x958b: return "GL_HANDLE_TYPE_D3D11_IMAGE_EXT";
        case 0x958c: return "GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT";
#endif
#if defined(GL_EXT_semaphore)
        case 0x958d: return "GL_LAYOUT_GENERAL_EXT";
        case 0x958e: return "GL_LAYOUT_COLOR_ATTACHMENT_EXT";
        case 0x958f: return "GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT";
        case 0x9590: return "GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT";
        case 0x9591: return "GL_LAYOUT_SHADER_READ_ONLY_EXT";
        case 0x9592: return "GL_LAYOUT_TRANSFER_SRC_EXT";
        case 0x9593: return "GL_LAYOUT_TRANSFER_DST_EXT";
#endif
#if defined(GL_EXT_semaphore_win32)
        case 0x9594: return "GL_HANDLE_TYPE_D3D12_FENCE_EXT";
        case 0x9595: return "GL_D3D12_FENCE_VALUE_EXT";
#endif
#if defined(GL_EXT_memory_object)
        case 0x9596: return "GL_NUM_DEVICE_UUIDS_EXT";
        case 0x9597: return "GL_DEVICE_UUID_EXT";
        case 0x9598: return "GL_DRIVER_UUID_EXT";
#endif
#if defined(GL_EXT_memory_object_win32)
        case 0x9599: return "GL_DEVICE_LUID_EXT";
        case 0x959a: return "GL_DEVICE_NODE_MASK_EXT";
#endif
#if defined(GL_EXT_memory_object)
        case 0x959b: return "GL_PROTECTED_MEMORY_OBJECT_EXT";
#endif
#if defined(GL_OVR_multiview)
        case 0x9630: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR";
        case 0x9631: return "GL_MAX_VIEWS_OVR";
        case 0x9632: return "GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR";
        case 0x9633: return "GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR";
#endif
#if defined(GL_EXT_shader_pixel_local_storage2)
        case 0x9650: return "GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_FAST_SIZE_EXT";
        case 0x9651: return "GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_SIZE_EXT";
        case 0x9652: return "GL_FRAMEBUFFER_INCOMPLETE_INSUFFICIENT_SHADER_COMBINED_LOCAL_STORAGE_EXT";
#endif
#if defined(GL_QCOM_shader_framebuffer_fetch_noncoherent)
        case 0x96a2: return "GL_FRAMEBUFFER_FETCH_NONCOHERENT_QCOM";
#endif
    }
    return "<UNKNOWN ENUM>";
}


