/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/Reds.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 103, 0, 13, 255, 165, 15, 21, 255, 203, 24, 29, 255, 239, 59, 44, 255, 251, 106, 74, 255, 252, 146, 114, 255, 252, 187, 161, 255, 254, 224, 210, 255, 255, 245, 240, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Reds_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 102, 0, 12, 0, 103, 0, 13, 7, 103, 0, 13, 14, 104, 0, 13, 22, 104, 0, 13, 29, 105, 0, 13, 37, 105, 0, 13, 44, 106, 0, 13, 52, 106, 0, 13, 59, 107, 0, 14, 67, 107, 0, 14, 74, 108, 0, 14, 82, 108, 0, 14, 89, 109, 0, 14, 97, 109, 0, 14, 104, 110, 0, 14, 112, 110, 0, 14, 119, 111, 0, 14, 127, 111, 0, 14, 134, 111, 0, 15, 141, 112, 1, 15, 149, 112, 1, 15, 156, 113, 1, 15, 164, 113, 1, 15, 171, 114, 1, 15, 179, 114, 1, 15, 186, 115, 1, 15, 194, 115, 1, 15, 201, 116, 1, 15, 209, 116, 1, 15, 216, 117, 1, 15, 224, 117, 1, 16, 231, 118, 1, 16, 239, 118, 1, 16, 246, 119, 1, 16, 254, 119, 2, 16, 255, 120, 2, 16, 255, 120, 2, 16, 255, 121, 2, 16, 255, 121, 2, 16, 255, 121, 2, 16, 255, 122, 2, 16, 255, 122, 2, 16, 255, 123, 2, 16, 255, 123, 2, 16, 255, 124, 2, 17, 255, 124, 2, 17, 255, 125, 3, 17, 255, 125, 3, 17, 255, 126, 3, 17, 255, 126, 3, 17, 255, 127, 3, 17, 255, 127, 3, 17, 255, 128, 3, 17, 255, 128, 3, 17, 255, 129, 3, 17, 255, 129, 3, 17, 255, 130, 4, 17, 255, 130, 4, 17, 255, 131, 4, 17, 255, 131, 4, 17, 255, 132, 4, 18, 255, 132, 4, 18, 255, 133, 4, 18, 255, 133, 4, 18, 255, 134, 4, 18, 255, 134, 4, 18, 255, 135, 5, 18, 255, 135, 5, 18, 255, 135, 5, 18, 255, 136, 5, 18, 255, 136, 5, 18, 255, 137, 5, 18, 255, 137, 5, 18, 255, 138, 5, 18, 255, 138, 6, 18, 255, 139, 6, 18, 255, 139, 6, 18, 255, 140, 6, 18, 255, 140, 6, 18, 255, 141, 6, 19, 255, 141, 6, 19, 255, 142, 7, 19, 255, 142, 7, 19, 255, 143, 7, 19, 255, 143, 7, 19, 255, 144, 7, 19, 255, 144, 7, 19, 255, 145, 7, 19, 255, 145, 8, 19, 255, 146, 8, 19, 255, 146, 8, 19, 255, 147, 8, 19, 255, 147, 8, 19, 255, 148, 8, 19, 255, 148, 9, 19, 255, 149, 9, 19, 255, 149, 9, 19, 255, 150, 9, 19, 255, 150, 9, 19, 255, 151, 9, 19, 255, 151, 10, 19, 255, 152, 10, 20, 255, 152, 10, 20, 255, 153, 10, 20, 255, 153, 10, 20, 255, 154, 11, 20, 255, 154, 11, 20, 255, 155, 11, 20, 255, 155, 11, 20, 255, 156, 11, 20, 255, 156, 11, 20, 255, 157, 12, 20, 255, 157, 12, 20, 255, 158, 12, 20, 255, 158, 12, 20, 255, 159, 12, 20, 255, 159, 13, 20, 255, 160, 13, 20, 255, 160, 13, 20, 255, 161, 13, 20, 255, 161, 13, 20, 255, 162, 13, 20, 255, 162, 14, 20, 255, 163, 14, 20, 255, 163, 14, 20, 255, 164, 14, 20, 255, 164, 14, 20, 255, 164, 15, 20, 255, 165, 15, 21, 255, 165, 15, 21, 255, 165, 15, 21, 255, 166, 15, 21, 255, 166, 15, 21, 255, 166, 15, 21, 255, 167, 15, 21, 255, 167, 15, 21, 255, 167, 15, 21, 255, 167, 15, 21, 255, 168, 15, 21, 255, 168, 15, 21, 255, 168, 15, 21, 255, 169, 15, 21, 255, 169, 16, 21, 255, 169, 16, 21, 255, 169, 16, 22, 255, 170, 16, 22, 255, 170, 16, 22, 255, 170, 16, 22, 255, 171, 16, 22, 255, 171, 16, 22, 255, 171, 16, 22, 255, 172, 16, 22, 255, 172, 16, 22, 255, 172, 16, 22, 255, 172, 16, 22, 255, 173, 16, 22, 255, 173, 17, 22, 255, 173, 17, 22, 255, 174, 17, 22, 255, 174, 17, 22, 255, 174, 17, 23, 255, 174, 17, 23, 255, 175, 17, 23, 255, 175, 17, 23, 255, 175, 17, 23, 255, 176, 17, 23, 255, 176, 17, 23, 255, 176, 17, 23, 255, 177, 17, 23, 255, 177, 17, 23, 255, 177, 17, 23, 255, 177, 18, 23, 255, 178, 18, 23, 255, 178, 18, 23, 255, 178, 18, 23, 255, 179, 18, 23, 255, 179, 18, 24, 255, 179, 18, 24, 255, 179, 18, 24, 255, 180, 18, 24, 255, 180, 18, 24, 255, 180, 18, 24, 255, 181, 18, 24, 255, 181, 18, 24, 255, 181, 18, 24, 255, 182, 19, 24, 255, 182, 19, 24, 255, 182, 19, 24, 255, 182, 19, 24, 255, 183, 19, 24, 255, 183, 19, 24, 255, 183, 19, 24, 255, 184, 19, 25, 255, 184, 19, 25, 255, 184, 19, 25, 255, 185, 19, 25, 255, 185, 19, 25, 255, 185, 19, 25, 255, 185, 19, 25, 255, 186, 20, 25, 255, 186, 20, 25, 255, 186, 20, 25, 255, 187, 20, 25, 255, 187, 20, 25, 255, 187, 20, 25, 255, 187, 20, 25, 255, 188, 20, 25, 255, 188, 20, 25, 255, 188, 20, 26, 255, 189, 20, 26, 255, 189, 20, 26, 255, 189, 20, 26, 255, 190, 20, 26, 255, 190, 21, 26, 255, 190, 21, 26, 255, 190, 21, 26, 255, 191, 21, 26, 255, 191, 21, 26, 255, 191, 21, 26, 255, 192, 21, 26, 255, 192, 21, 26, 255, 192, 21, 26, 255, 193, 21, 26, 255, 193, 21, 26, 255, 193, 21, 27, 255, 193, 21, 27, 255, 194, 21, 27, 255, 194, 22, 27, 255, 194, 22, 27, 255, 195, 22, 27, 255, 195, 22, 27, 255, 195, 22, 27, 255, 196, 22, 27, 255, 196, 22, 27, 255, 196, 22, 27, 255, 196, 22, 27, 255, 197, 22, 27, 255, 197, 22, 27, 255, 197, 22, 27, 255, 198, 22, 27, 255, 198, 22, 28, 255, 198, 23, 28, 255, 199, 23, 28, 255, 199, 23, 28, 255, 199, 23, 28, 255, 199, 23, 28, 255, 200, 23, 28, 255, 200, 23, 28, 255, 200, 23, 28, 255, 201, 23, 28, 255, 201, 23, 28, 255, 201, 23, 28, 255, 202, 23, 28, 255, 202, 23, 28, 255, 202, 23, 28, 255, 202, 24, 28, 255, 203, 24, 29, 255, 203, 24, 29, 255, 203, 25, 29, 255, 204, 25, 29, 255, 204, 25, 29, 255, 204, 26, 29, 255, 204, 26, 29, 255, 205, 26, 29, 255, 205, 27, 30, 255, 205, 27, 30, 255, 206, 27, 30, 255, 206, 28, 30, 255, 206, 28, 30, 255, 206, 28, 30, 255, 207, 29, 30, 255, 207, 29, 30, 255, 207, 29, 30, 255, 208, 29, 31, 255, 208, 30, 31, 255, 208, 30, 31, 255, 208, 30, 31, 255, 209, 31, 31, 255, 209, 31, 31, 255, 209, 31, 31, 255, 209, 32, 31, 255, 210, 32, 32, 255, 210, 32, 32, 255, 210, 33, 32, 255, 211, 33, 32, 255, 211, 33, 32, 255, 211, 33, 32, 255, 211, 34, 32, 255, 212, 34, 32, 255, 212, 34, 32, 255, 212, 35, 33, 255, 213, 35, 33, 255, 213, 35, 33, 255, 213, 35, 33, 255, 213, 36, 33, 255, 214, 36, 33, 255, 214, 36, 33, 255, 214, 37, 33, 255, 215, 37, 33, 255, 215, 37, 34, 255, 215, 37, 34, 255, 215, 38, 34, 255, 216, 38, 34, 255, 216, 38, 34, 255, 216, 39, 34, 255, 216, 39, 34, 255, 217, 39, 34, 255, 217, 39, 35, 255, 217, 40, 35, 255, 218, 40, 35, 255, 218, 40, 35, 255, 218, 40, 35, 255, 218, 41, 35, 255, 219, 41, 35, 255, 219, 41, 35, 255, 219, 42, 35, 255, 220, 42, 36, 255, 220, 42, 36, 255, 220, 42, 36, 255, 220, 43, 36, 255, 221, 43, 36, 255, 221, 43, 36, 255, 221, 43, 36, 255, 222, 44, 36, 255, 222, 44, 37, 255, 222, 44, 37, 255, 222, 44, 37, 255, 223, 45, 37, 255, 223, 45, 37, 255, 223, 45, 37, 255, 224, 45, 37, 255, 224, 46, 37, 255, 224, 46, 37, 255, 224, 46, 38, 255, 225, 46, 38, 255, 225, 47, 38, 255, 225, 47, 38, 255, 225, 47, 38, 255, 226, 47, 38, 255, 226, 48, 38, 255, 226, 48, 38, 255, 227, 48, 39, 255, 227, 48, 39, 255, 227, 49, 39, 255, 227, 49, 39, 255, 228, 49, 39, 255, 228, 49, 39, 255, 228, 50, 39, 255, 229, 50, 39, 255, 229, 50, 39, 255, 229, 50, 40, 255, 229, 51, 40, 255, 230, 51, 40, 255, 230, 51, 40, 255, 230, 51, 40, 255, 231, 52, 40, 255, 231, 52, 40, 255, 231, 52, 40, 255, 231, 52, 41, 255, 232, 53, 41, 255, 232, 53, 41, 255, 232, 53, 41, 255, 233, 53, 41, 255, 233, 54, 41, 255, 233, 54, 41, 255, 233, 54, 41, 255, 234, 54, 41, 255, 234, 55, 42, 255, 234, 55, 42, 255, 235, 55, 42, 255, 235, 55, 42, 255, 235, 56, 42, 255, 235, 56, 42, 255, 236, 56, 42, 255, 236, 56, 42, 255, 236, 57, 43, 255, 237, 57, 43, 255, 237, 57, 43, 255, 237, 57, 43, 255, 237, 58, 43, 255, 238, 58, 43, 255, 238, 58, 43, 255, 238, 58, 43, 255, 238, 59, 43, 255, 239, 59, 44, 255, 239, 59, 44, 255, 239, 60, 44, 255, 239, 60, 44, 255, 239, 61, 45, 255, 239, 61, 45, 255, 239, 62, 45, 255, 239, 62, 45, 255, 239, 63, 45, 255, 239, 63, 46, 255, 240, 63, 46, 255, 240, 64, 46, 255, 240, 64, 46, 255, 240, 65, 47, 255, 240, 65, 47, 255, 240, 66, 47, 255, 240, 66, 47, 255, 240, 66, 48, 255, 240, 67, 48, 255, 240, 67, 48, 255, 241, 68, 48, 255, 241, 68, 48, 255, 241, 68, 49, 255, 241, 69, 49, 255, 241, 69, 49, 255, 241, 70, 49, 255, 241, 70, 50, 255, 241, 70, 50, 255, 241, 71, 50, 255, 241, 71, 50, 255, 242, 72, 50, 255, 242, 72, 51, 255, 242, 72, 51, 255, 242, 73, 51, 255, 242, 73, 51, 255, 242, 74, 52, 255, 242, 74, 52, 255, 242, 74, 52, 255, 242, 75, 52, 255, 242, 75, 52, 255, 243, 76, 53, 255, 243, 76, 53, 255, 243, 76, 53, 255, 243, 77, 53, 255, 243, 77, 54, 255, 243, 77, 54, 255, 243, 78, 54, 255, 243, 78, 54, 255, 243, 79, 55, 255, 243, 79, 55, 255, 243, 79, 55, 255, 244, 80, 55, 255, 244, 80, 55, 255, 244, 80, 56, 255, 244, 81, 56, 255, 244, 81, 56, 255, 244, 82, 56, 255, 244, 82, 57, 255, 244, 82, 57, 255, 244, 83, 57, 255, 244, 83, 57, 255, 245, 83, 58, 255, 245, 84, 58, 255, 245, 84, 58, 255, 245, 84, 58, 255, 245, 85, 59, 255, 245, 85, 59, 255, 245, 86, 59, 255, 245, 86, 59, 255, 245, 86, 59, 255, 245, 87, 60, 255, 245, 87, 60, 255, 246, 87, 60, 255, 246, 88, 60, 255, 246, 88, 61, 255, 246, 88, 61, 255, 246, 89, 61, 255, 246, 89, 61, 255, 246, 89, 62, 255, 246, 90, 62, 255, 246, 90, 62, 255, 246, 90, 62, 255, 246, 91, 63, 255, 247, 91, 63, 255, 247, 91, 63, 255, 247, 92, 63, 255, 247, 92, 64, 255, 247, 92, 64, 255, 247, 93, 64, 255, 247, 93, 64, 255, 247, 93, 64, 255, 247, 94, 65, 255, 247, 94, 65, 255, 247, 94, 65, 255, 248, 95, 65, 255, 248, 95, 66, 255, 248, 95, 66, 255, 248, 96, 66, 255, 248, 96, 66, 255, 248, 96, 67, 255, 248, 97, 67, 255, 248, 97, 67, 255, 248, 97, 67, 255, 248, 98, 68, 255, 248, 98, 68, 255, 249, 98, 68, 255, 249, 99, 68, 255, 249, 99, 69, 255, 249, 99, 69, 255, 249, 100, 69, 255, 249, 100, 69, 255, 249, 100, 70, 255, 249, 101, 70, 255, 249, 101, 70, 255, 249, 101, 70, 255, 249, 102, 71, 255, 250, 102, 71, 255, 250, 102, 71, 255, 250, 103, 71, 255, 250, 103, 72, 255, 250, 103, 72, 255, 250, 104, 72, 255, 250, 104, 72, 255, 250, 104, 73, 255, 250, 105, 73, 255, 250, 105, 73, 255, 250, 105, 73, 255, 250, 106, 73, 255, 251, 106, 74, 255, 251, 106, 74, 255, 251, 107, 74, 255, 251, 107, 75, 255, 251, 107, 75, 255, 251, 108, 75, 255, 251, 108, 76, 255, 251, 108, 76, 255, 251, 109, 76, 255, 251, 109, 76, 255, 251, 109, 77, 255, 251, 110, 77, 255, 251, 110, 77, 255, 251, 110, 78, 255, 251, 111, 78, 255, 251, 111, 78, 255, 251, 111, 79, 255, 251, 112, 79, 255, 251, 112, 79, 255, 251, 112, 80, 255, 251, 113, 80, 255, 251, 113, 80, 255, 251, 113, 80, 255, 251, 114, 81, 255, 251, 114, 81, 255, 251, 114, 81, 255, 251, 115, 82, 255, 251, 115, 82, 255, 251, 115, 82, 255, 251, 116, 83, 255, 251, 116, 83, 255, 251, 116, 83, 255, 251, 116, 83, 255, 251, 117, 84, 255, 251, 117, 84, 255, 251, 117, 84, 255, 251, 118, 85, 255, 251, 118, 85, 255, 251, 118, 85, 255, 251, 119, 86, 255, 251, 119, 86, 255, 251, 119, 86, 255, 251, 120, 87, 255, 251, 120, 87, 255, 251, 120, 87, 255, 251, 121, 87, 255, 251, 121, 88, 255, 251, 121, 88, 255, 251, 122, 88, 255, 251, 122, 89, 255, 251, 122, 89, 255, 251, 123, 89, 255, 251, 123, 90, 255, 251, 123, 90, 255, 251, 123, 90, 255, 251, 124, 91, 255, 251, 124, 91, 255, 251, 124, 91, 255, 251, 125, 91, 255, 251, 125, 92, 255, 251, 125, 92, 255, 251, 126, 92, 255, 251, 126, 93, 255, 251, 126, 93, 255, 251, 127, 93, 255, 251, 127, 94, 255, 251, 127, 94, 255, 251, 128, 94, 255, 251, 128, 95, 255, 251, 128, 95, 255, 251, 128, 95, 255, 251, 129, 96, 255, 251, 129, 96, 255, 251, 129, 96, 255, 251, 130, 96, 255, 251, 130, 97, 255, 252, 130, 97, 255, 252, 131, 97, 255, 252, 131, 98, 255, 252, 131, 98, 255, 252, 132, 98, 255, 252, 132, 99, 255, 252, 132, 99, 255, 252, 132, 99, 255, 252, 133, 100, 255, 252, 133, 100, 255, 252, 133, 100, 255, 252, 134, 101, 255, 252, 134, 101, 255, 252, 134, 101, 255, 252, 135, 102, 255, 252, 135, 102, 255, 252, 135, 102, 255, 252, 135, 102, 255, 252, 136, 103, 255, 252, 136, 103, 255, 252, 136, 103, 255, 252, 137, 104, 255, 252, 137, 104, 255, 252, 137, 104, 255, 252, 138, 105, 255, 252, 138, 105, 255, 252, 138, 105, 255, 252, 138, 106, 255, 252, 139, 106, 255, 252, 139, 106, 255, 252, 139, 107, 255, 252, 140, 107, 255, 252, 140, 107, 255, 252, 140, 108, 255, 252, 141, 108, 255, 252, 141, 108, 255, 252, 141, 109, 255, 252, 141, 109, 255, 252, 142, 109, 255, 252, 142, 110, 255, 252, 142, 110, 255, 252, 143, 110, 255, 252, 143, 111, 255, 252, 143, 111, 255, 252, 143, 111, 255, 252, 144, 112, 255, 252, 144, 112, 255, 252, 144, 112, 255, 252, 145, 113, 255, 252, 145, 113, 255, 252, 145, 113, 255, 251, 146, 113, 255, 252, 146, 114, 255, 252, 146, 114, 255, 252, 147, 115, 255, 252, 147, 115, 255, 252, 147, 115, 255, 252, 148, 116, 255, 252, 148, 116, 255, 252, 148, 116, 255, 252, 149, 117, 255, 252, 149, 117, 255, 252, 149, 117, 255, 252, 150, 118, 255, 252, 150, 118, 255, 252, 150, 118, 255, 252, 151, 119, 255, 252, 151, 119, 255, 252, 151, 119, 255, 252, 152, 120, 255, 252, 152, 120, 255, 252, 152, 120, 255, 252, 152, 121, 255, 252, 153, 121, 255, 252, 153, 121, 255, 252, 153, 122, 255, 252, 154, 122, 255, 252, 154, 122, 255, 252, 154, 123, 255, 252, 155, 123, 255, 252, 155, 124, 255, 252, 155, 124, 255, 252, 156, 124, 255, 252, 156, 125, 255, 252, 156, 125, 255, 252, 157, 125, 255, 252, 157, 126, 255, 252, 157, 126, 255, 252, 158, 126, 255, 252, 158, 127, 255, 252, 158, 127, 255, 252, 159, 127, 255, 252, 159, 128, 255, 252, 159, 128, 255, 252, 160, 128, 255, 252, 160, 129, 255, 252, 160, 129, 255, 252, 161, 130, 255, 252, 161, 130, 255, 252, 161, 130, 255, 252, 162, 131, 255, 252, 162, 131, 255, 252, 162, 131, 255, 252, 163, 132, 255, 252, 163, 132, 255, 252, 163, 132, 255, 252, 164, 133, 255, 252, 164, 133, 255, 252, 164, 134, 255, 252, 165, 134, 255, 252, 165, 134, 255, 252, 165, 135, 255, 252, 165, 135, 255, 252, 166, 135, 255, 252, 166, 136, 255, 252, 166, 136, 255, 252, 167, 136, 255, 252, 167, 137, 255, 252, 167, 137, 255, 252, 168, 138, 255, 252, 168, 138, 255, 252, 168, 138, 255, 252, 169, 139, 255, 252, 169, 139, 255, 252, 169, 139, 255, 252, 170, 140, 255, 252, 170, 140, 255, 252, 170, 141, 255, 252, 171, 141, 255, 252, 171, 141, 255, 252, 171, 142, 255, 252, 172, 142, 255, 252, 172, 142, 255, 252, 172, 143, 255, 252, 172, 143, 255, 252, 173, 144, 255, 252, 173, 144, 255, 252, 173, 144, 255, 252, 174, 145, 255, 252, 174, 145, 255, 252, 174, 145, 255, 252, 175, 146, 255, 252, 175, 146, 255, 252, 175, 147, 255, 252, 176, 147, 255, 252, 176, 147, 255, 252, 176, 148, 255, 252, 177, 148, 255, 252, 177, 148, 255, 252, 177, 149, 255, 252, 177, 149, 255, 252, 178, 150, 255, 252, 178, 150, 255, 252, 178, 150, 255, 252, 179, 151, 255, 252, 179, 151, 255, 252, 179, 152, 255, 252, 180, 152, 255, 252, 180, 152, 255, 252, 180, 153, 255, 252, 181, 153, 255, 252, 181, 153, 255, 252, 181, 154, 255, 252, 182, 154, 255, 252, 182, 155, 255, 252, 182, 155, 255, 252, 182, 155, 255, 252, 183, 156, 255, 252, 183, 156, 255, 252, 183, 157, 255, 252, 184, 157, 255, 252, 184, 157, 255, 252, 184, 158, 255, 252, 185, 158, 255, 252, 185, 159, 255, 252, 185, 159, 255, 252, 186, 159, 255, 252, 186, 160, 255, 252, 186, 160, 255, 251, 187, 160, 255, 252, 187, 161, 255, 252, 187, 161, 255, 252, 187, 162, 255, 252, 188, 162, 255, 252, 188, 162, 255, 252, 188, 163, 255, 252, 189, 163, 255, 252, 189, 163, 255, 252, 189, 164, 255, 252, 189, 164, 255, 252, 190, 165, 255, 252, 190, 165, 255, 252, 190, 165, 255, 252, 191, 166, 255, 252, 191, 166, 255, 252, 191, 166, 255, 252, 191, 167, 255, 252, 192, 167, 255, 252, 192, 167, 255, 252, 192, 168, 255, 252, 193, 168, 255, 252, 193, 169, 255, 252, 193, 169, 255, 252, 194, 169, 255, 252, 194, 170, 255, 252, 194, 170, 255, 252, 194, 170, 255, 252, 195, 171, 255, 252, 195, 171, 255, 252, 195, 172, 255, 252, 196, 172, 255, 252, 196, 172, 255, 252, 196, 173, 255, 252, 196, 173, 255, 252, 197, 173, 255, 252, 197, 174, 255, 252, 197, 174, 255, 252, 198, 174, 255, 252, 198, 175, 255, 252, 198, 175, 255, 253, 198, 176, 255, 253, 199, 176, 255, 253, 199, 176, 255, 253, 199, 177, 255, 253, 200, 177, 255, 253, 200, 177, 255, 253, 200, 178, 255, 253, 201, 178, 255, 253, 201, 179, 255, 253, 201, 179, 255, 253, 201, 179, 255, 253, 202, 180, 255, 253, 202, 180, 255, 253, 202, 181, 255, 253, 203, 181, 255, 253, 203, 181, 255, 253, 203, 182, 255, 253, 203, 182, 255, 253, 204, 182, 255, 253, 204, 183, 255, 253, 204, 183, 255, 253, 205, 184, 255, 253, 205, 184, 255, 253, 205, 184, 255, 253, 205, 185, 255, 253, 206, 185, 255, 253, 206, 185, 255, 253, 206, 186, 255, 253, 207, 186, 255, 253, 207, 187, 255, 253, 207, 187, 255, 253, 207, 187, 255, 253, 208, 188, 255, 253, 208, 188, 255, 253, 208, 189, 255, 253, 209, 189, 255, 253, 209, 189, 255, 253, 209, 190, 255, 253, 209, 190, 255, 253, 210, 191, 255, 253, 210, 191, 255, 253, 210, 191, 255, 253, 211, 192, 255, 253, 211, 192, 255, 253, 211, 192, 255, 253, 211, 193, 255, 253, 212, 193, 255, 253, 212, 194, 255, 253, 212, 194, 255, 253, 213, 194, 255, 253, 213, 195, 255, 253, 213, 195, 255, 253, 213, 196, 255, 253, 214, 196, 255, 253, 214, 196, 255, 253, 214, 197, 255, 253, 215, 197, 255, 253, 215, 198, 255, 253, 215, 198, 255, 253, 215, 198, 255, 253, 216, 199, 255, 253, 216, 199, 255, 253, 216, 200, 255, 253, 217, 200, 255, 253, 217, 200, 255, 253, 217, 201, 255, 253, 218, 201, 255, 253, 218, 201, 255, 253, 218, 202, 255, 253, 218, 202, 255, 253, 219, 203, 255, 253, 219, 203, 255, 253, 219, 203, 255, 253, 220, 204, 255, 253, 220, 204, 255, 253, 220, 205, 255, 253, 220, 205, 255, 253, 221, 205, 255, 253, 221, 206, 255, 253, 221, 206, 255, 253, 222, 207, 255, 253, 222, 207, 255, 253, 222, 207, 255, 253, 222, 208, 255, 253, 223, 208, 255, 253, 223, 209, 255, 253, 223, 209, 255, 253, 224, 209, 255, 254, 224, 210, 255, 254, 224, 210, 255, 254, 224, 210, 255, 254, 224, 210, 255, 254, 224, 211, 255, 254, 224, 211, 255, 254, 225, 211, 255, 254, 225, 211, 255, 254, 225, 212, 255, 254, 225, 212, 255, 254, 225, 212, 255, 254, 225, 212, 255, 254, 226, 212, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 214, 255, 254, 227, 214, 255, 254, 227, 214, 255, 254, 227, 214, 255, 254, 227, 215, 255, 254, 227, 215, 255, 254, 227, 215, 255, 254, 228, 215, 255, 254, 228, 215, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 218, 255, 254, 229, 218, 255, 254, 230, 218, 255, 254, 230, 218, 255, 254, 230, 218, 255, 254, 230, 219, 255, 254, 230, 219, 255, 254, 230, 219, 255, 254, 231, 219, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 221, 255, 254, 232, 221, 255, 254, 232, 221, 255, 254, 232, 221, 255, 254, 232, 221, 255, 254, 232, 222, 255, 254, 232, 222, 255, 254, 233, 222, 255, 254, 233, 222, 255, 254, 233, 223, 255, 254, 233, 223, 255, 254, 233, 223, 255, 254, 233, 223, 255, 254, 234, 224, 255, 254, 234, 224, 255, 254, 234, 224, 255, 254, 234, 224, 255, 254, 234, 225, 255, 254, 234, 225, 255, 254, 235, 225, 255, 254, 235, 225, 255, 254, 235, 225, 255, 254, 235, 226, 255, 254, 235, 226, 255, 254, 235, 226, 255, 254, 236, 226, 255, 254, 236, 227, 255, 254, 236, 227, 255, 254, 236, 227, 255, 254, 236, 227, 255, 254, 236, 228, 255, 254, 236, 228, 255, 254, 237, 228, 255, 254, 237, 228, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 238, 229, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 232, 255, 254, 239, 232, 255, 254, 239, 232, 255, 254, 240, 232, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 242, 235, 255, 254, 242, 235, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Reds_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 102, 0, 12, 0, 103, 0, 13, 7, 103, 0, 13, 14, 104, 0, 13, 22, 104, 0, 13, 29, 104, 0, 13, 37, 105, 0, 13, 44, 105, 0, 13, 52, 106, 0, 13, 59, 106, 0, 13, 67, 106, 0, 13, 74, 107, 0, 13, 82, 107, 0, 14, 89, 107, 0, 14, 97, 108, 0, 14, 104, 108, 0, 14, 112, 109, 0, 14, 119, 109, 0, 14, 127, 109, 0, 14, 134, 110, 0, 14, 141, 110, 0, 14, 149, 110, 0, 14, 156, 111, 0, 14, 164, 111, 0, 14, 171, 112, 1, 14, 179, 112, 1, 15, 186, 112, 1, 15, 194, 113, 1, 15, 201, 113, 1, 15, 209, 113, 1, 15, 216, 114, 1, 15, 224, 114, 1, 15, 231, 115, 1, 15, 239, 115, 1, 15, 246, 115, 1, 15, 254, 116, 1, 15, 255, 116, 1, 15, 255, 117, 1, 15, 255, 117, 1, 15, 255, 117, 1, 15, 255, 118, 1, 15, 255, 118, 2, 16, 255, 118, 2, 16, 255, 119, 2, 16, 255, 119, 2, 16, 255, 120, 2, 16, 255, 120, 2, 16, 255, 120, 2, 16, 255, 121, 2, 16, 255, 121, 2, 16, 255, 122, 2, 16, 255, 122, 2, 16, 255, 122, 2, 16, 255, 123, 2, 16, 255, 123, 2, 16, 255, 123, 3, 16, 255, 124, 3, 16, 255, 124, 3, 16, 255, 125, 3, 16, 255, 125, 3, 16, 255, 125, 3, 16, 255, 126, 3, 17, 255, 126, 3, 17, 255, 127, 3, 17, 255, 139, 6, 18, 255, 140, 6, 18, 255, 140, 6, 18, 255, 141, 7, 18, 255, 141, 7, 18, 255, 141, 7, 18, 255, 142, 7, 19, 255, 142, 7, 19, 255, 142, 7, 19, 255, 143, 7, 19, 255, 143, 7, 19, 255, 144, 7, 19, 255, 144, 7, 19, 255, 144, 8, 19, 255, 145, 8, 19, 255, 145, 8, 19, 255, 146, 8, 19, 255, 146, 8, 19, 255, 146, 8, 19, 255, 147, 8, 19, 255, 147, 8, 19, 255, 148, 9, 19, 255, 148, 9, 19, 255, 148, 9, 19, 255, 149, 9, 19, 255, 149, 9, 19, 255, 149, 9, 19, 255, 150, 9, 19, 255, 150, 9, 19, 255, 151, 10, 19, 255, 151, 10, 19, 255, 151, 10, 19, 255, 152, 10, 20, 255, 152, 10, 20, 255, 153, 10, 20, 255, 153, 10, 20, 255, 153, 10, 20, 255, 154, 11, 20, 255, 154, 11, 20, 255, 155, 11, 20, 255, 155, 11, 20, 255, 155, 11, 20, 255, 156, 11, 20, 255, 156, 11, 20, 255, 157, 12, 20, 255, 157, 12, 20, 255, 157, 12, 20, 255, 158, 12, 20, 255, 158, 12, 20, 255, 159, 12, 20, 255, 159, 12, 20, 255, 159, 13, 20, 255, 160, 13, 20, 255, 160, 13, 20, 255, 161, 13, 20, 255, 161, 13, 20, 255, 161, 13, 20, 255, 162, 13, 20, 255, 162, 14, 20, 255, 163, 14, 20, 255, 163, 14, 20, 255, 163, 14, 20, 255, 164, 14, 20, 255, 164, 14, 20, 255, 164, 15, 20, 255, 165, 15, 21, 255, 165, 15, 21, 255, 165, 15, 21, 255, 165, 15, 21, 255, 166, 15, 21, 255, 166, 15, 21, 255, 166, 15, 21, 255, 166, 15, 21, 255, 167, 15, 21, 255, 167, 15, 21, 255, 167, 15, 21, 255, 167, 15, 21, 255, 168, 15, 21, 255, 168, 15, 21, 255, 168, 15, 21, 255, 168, 15, 21, 255, 168, 15, 21, 255, 169, 15, 21, 255, 169, 16, 21, 255, 169, 16, 21, 255, 169, 16, 22, 255, 170, 16, 22, 255, 170, 16, 22, 255, 170, 16, 22, 255, 170, 16, 22, 255, 171, 16, 22, 255, 171, 16, 22, 255, 171, 16, 22, 255, 171, 16, 22, 255, 172, 16, 22, 255, 172, 16, 22, 255, 172, 16, 22, 255, 172, 16, 22, 255, 172, 16, 22, 255, 173, 16, 22, 255, 173, 17, 22, 255, 173, 17, 22, 255, 173, 17, 22, 255, 174, 17, 22, 255, 174, 17, 22, 255, 174, 17, 23, 255, 174, 17, 23, 255, 175, 17, 23, 255, 175, 17, 23, 255, 175, 17, 23, 255, 175, 17, 23, 255, 176, 17, 23, 255, 176, 17, 23, 255, 176, 17, 23, 255, 176, 17, 23, 255, 176, 17, 23, 255, 177, 17, 23, 255, 177, 17, 23, 255, 177, 18, 23, 255, 177, 18, 23, 255, 178, 18, 23, 255, 178, 18, 23, 255, 178, 18, 23, 255, 178, 18, 23, 255, 179, 18, 23, 255, 179, 18, 24, 255, 179, 18, 24, 255, 179, 18, 24, 255, 187, 20, 25, 255, 187, 20, 25, 255, 188, 20, 25, 255, 188, 20, 25, 255, 188, 20, 25, 255, 188, 20, 26, 255, 189, 20, 26, 255, 189, 20, 26, 255, 189, 20, 26, 255, 189, 20, 26, 255, 190, 20, 26, 255, 190, 20, 26, 255, 190, 21, 26, 255, 190, 21, 26, 255, 190, 21, 26, 255, 191, 21, 26, 255, 191, 21, 26, 255, 191, 21, 26, 255, 191, 21, 26, 255, 192, 21, 26, 255, 192, 21, 26, 255, 192, 21, 26, 255, 192, 21, 26, 255, 193, 21, 26, 255, 193, 21, 26, 255, 193, 21, 27, 255, 193, 21, 27, 255, 194, 21, 27, 255, 194, 21, 27, 255, 194, 22, 27, 255, 194, 22, 27, 255, 195, 22, 27, 255, 195, 22, 27, 255, 195, 22, 27, 255, 195, 22, 27, 255, 196, 22, 27, 255, 196, 22, 27, 255, 196, 22, 27, 255, 196, 22, 27, 255, 196, 22, 27, 255, 197, 22, 27, 255, 197, 22, 27, 255, 197, 22, 27, 255, 197, 22, 27, 255, 198, 22, 27, 255, 198, 22, 28, 255, 198, 22, 28, 255, 198, 23, 28, 255, 199, 23, 28, 255, 199, 23, 28, 255, 199, 23, 28, 255, 199, 23, 28, 255, 200, 23, 28, 255, 200, 23, 28, 255, 200, 23, 28, 255, 200, 23, 28, 255, 201, 23, 28, 255, 201, 23, 28, 255, 201, 23, 28, 255, 201, 23, 28, 255, 202, 23, 28, 255, 202, 23, 28, 255, 202, 23, 28, 255, 202, 23, 28, 255, 202, 24, 28, 255, 203, 24, 29, 255, 203, 24, 29, 255, 203, 24, 29, 255, 203, 25, 29, 255, 204, 25, 29, 255, 204, 25, 29, 255, 204, 25, 29, 255, 204, 26, 29, 255, 205, 26, 29, 255, 205, 26, 29, 255, 205, 26, 30, 255, 205, 27, 30, 255, 205, 27, 30, 255, 206, 27, 30, 255, 206, 28, 30, 255, 206, 28, 30, 255, 206, 28, 30, 255, 207, 28, 30, 255, 207, 29, 30, 255, 207, 29, 30, 255, 207, 29, 30, 255, 207, 29, 31, 255, 208, 30, 31, 255, 208, 30, 31, 255, 208, 30, 31, 255, 208, 30, 31, 255, 209, 30, 31, 255, 209, 31, 31, 255, 209, 31, 31, 255, 209, 31, 31, 255, 209, 31, 31, 255, 210, 32, 31, 255, 210, 32, 32, 255, 210, 32, 32, 255, 210, 32, 32, 255, 211, 33, 32, 255, 211, 33, 32, 255, 211, 33, 32, 255, 211, 33, 32, 255, 211, 34, 32, 255, 212, 34, 32, 255, 212, 34, 32, 255, 212, 34, 32, 255, 212, 34, 33, 255, 213, 35, 33, 255, 213, 35, 33, 255, 213, 35, 33, 255, 213, 35, 33, 255, 213, 36, 33, 255, 214, 36, 33, 255, 214, 36, 33, 255, 214, 36, 33, 255, 214, 36, 33, 255, 215, 37, 34, 255, 215, 37, 34, 255, 215, 37, 34, 255, 215, 37, 34, 255, 215, 37, 34, 255, 216, 38, 34, 255, 216, 38, 34, 255, 216, 38, 34, 255, 216, 38, 34, 255, 217, 39, 34, 255, 224, 46, 37, 255, 224, 46, 38, 255, 224, 46, 38, 255, 225, 46, 38, 255, 225, 47, 38, 255, 225, 47, 38, 255, 225, 47, 38, 255, 226, 47, 38, 255, 226, 47, 38, 255, 226, 48, 38, 255, 226, 48, 38, 255, 227, 48, 38, 255, 227, 48, 39, 255, 227, 48, 39, 255, 227, 49, 39, 255, 227, 49, 39, 255, 228, 49, 39, 255, 228, 49, 39, 255, 228, 49, 39, 255, 228, 50, 39, 255, 229, 50, 39, 255, 229, 50, 39, 255, 229, 50, 40, 255, 229, 50, 40, 255, 229, 51, 40, 255, 230, 51, 40, 255, 230, 51, 40, 255, 230, 51, 40, 255, 230, 51, 40, 255, 231, 52, 40, 255, 231, 52, 40, 255, 231, 52, 40, 255, 231, 52, 40, 255, 231, 52, 41, 255, 232, 53, 41, 255, 232, 53, 41, 255, 232, 53, 41, 255, 232, 53, 41, 255, 233, 53, 41, 255, 233, 54, 41, 255, 233, 54, 41, 255, 233, 54, 41, 255, 234, 54, 41, 255, 234, 54, 42, 255, 234, 55, 42, 255, 234, 55, 42, 255, 234, 55, 42, 255, 235, 55, 42, 255, 235, 55, 42, 255, 235, 56, 42, 255, 235, 56, 42, 255, 236, 56, 42, 255, 236, 56, 42, 255, 236, 56, 42, 255, 236, 57, 43, 255, 236, 57, 43, 255, 237, 57, 43, 255, 237, 57, 43, 255, 237, 57, 43, 255, 237, 58, 43, 255, 238, 58, 43, 255, 238, 58, 43, 255, 238, 58, 43, 255, 238, 58, 43, 255, 238, 59, 43, 255, 239, 59, 44, 255, 239, 59, 44, 255, 239, 60, 44, 255, 239, 60, 44, 255, 239, 60, 44, 255, 239, 61, 45, 255, 239, 61, 45, 255, 239, 61, 45, 255, 239, 62, 45, 255, 239, 62, 45, 255, 239, 62, 45, 255, 239, 63, 46, 255, 240, 63, 46, 255, 240, 63, 46, 255, 240, 64, 46, 255, 240, 64, 46, 255, 240, 64, 47, 255, 240, 65, 47, 255, 240, 65, 47, 255, 240, 65, 47, 255, 240, 66, 47, 255, 240, 66, 47, 255, 240, 66, 48, 255, 240, 67, 48, 255, 240, 67, 48, 255, 241, 67, 48, 255, 241, 68, 48, 255, 241, 68, 49, 255, 241, 68, 49, 255, 241, 69, 49, 255, 241, 69, 49, 255, 241, 69, 49, 255, 241, 70, 49, 255, 241, 70, 50, 255, 241, 70, 50, 255, 241, 71, 50, 255, 241, 71, 50, 255, 241, 71, 50, 255, 242, 72, 51, 255, 242, 72, 51, 255, 242, 72, 51, 255, 242, 72, 51, 255, 242, 73, 51, 255, 242, 73, 51, 255, 242, 73, 52, 255, 242, 74, 52, 255, 242, 74, 52, 255, 242, 74, 52, 255, 242, 75, 52, 255, 242, 75, 53, 255, 242, 75, 53, 255, 243, 75, 53, 255, 243, 76, 53, 255, 243, 76, 53, 255, 243, 76, 53, 255, 243, 77, 54, 255, 243, 77, 54, 255, 243, 77, 54, 255, 243, 78, 54, 255, 243, 78, 54, 255, 243, 78, 55, 255, 243, 78, 55, 255, 243, 79, 55, 255, 246, 88, 61, 255, 246, 89, 61, 255, 246, 89, 62, 255, 246, 89, 62, 255, 246, 90, 62, 255, 246, 90, 62, 255, 246, 90, 62, 255, 246, 90, 62, 255, 246, 91, 63, 255, 247, 91, 63, 255, 247, 91, 63, 255, 247, 91, 63, 255, 247, 92, 63, 255, 247, 92, 64, 255, 247, 92, 64, 255, 247, 93, 64, 255, 247, 93, 64, 255, 247, 93, 64, 255, 247, 93, 65, 255, 247, 94, 65, 255, 247, 94, 65, 255, 247, 94, 65, 255, 247, 95, 65, 255, 248, 95, 66, 255, 248, 95, 66, 255, 248, 95, 66, 255, 248, 96, 66, 255, 248, 96, 66, 255, 248, 96, 66, 255, 248, 96, 67, 255, 248, 97, 67, 255, 248, 97, 67, 255, 248, 97, 67, 255, 248, 97, 67, 255, 248, 98, 68, 255, 248, 98, 68, 255, 249, 98, 68, 255, 249, 99, 68, 255, 249, 99, 68, 255, 249, 99, 69, 255, 249, 99, 69, 255, 249, 100, 69, 255, 249, 100, 69, 255, 249, 100, 69, 255, 249, 100, 70, 255, 249, 101, 70, 255, 249, 101, 70, 255, 249, 101, 70, 255, 249, 101, 70, 255, 249, 102, 71, 255, 250, 102, 71, 255, 250, 102, 71, 255, 250, 102, 71, 255, 250, 103, 71, 255, 250, 103, 72, 255, 250, 103, 72, 255, 250, 103, 72, 255, 250, 104, 72, 255, 250, 104, 72, 255, 250, 104, 73, 255, 250, 104, 73, 255, 250, 105, 73, 255, 250, 105, 73, 255, 250, 105, 73, 255, 250, 106, 73, 255, 251, 106, 74, 255, 251, 106, 74, 255, 251, 106, 74, 255, 251, 107, 74, 255, 251, 107, 75, 255, 251, 107, 75, 255, 251, 107, 75, 255, 251, 108, 75, 255, 251, 108, 76, 255, 251, 108, 76, 255, 251, 108, 76, 255, 251, 109, 76, 255, 251, 109, 77, 255, 251, 109, 77, 255, 251, 110, 77, 255, 251, 110, 77, 255, 251, 110, 78, 255, 251, 110, 78, 255, 251, 111, 78, 255, 251, 111, 78, 255, 251, 111, 79, 255, 251, 111, 79, 255, 251, 112, 79, 255, 251, 112, 79, 255, 251, 112, 80, 255, 251, 112, 80, 255, 251, 113, 80, 255, 251, 113, 80, 255, 251, 113, 80, 255, 251, 114, 81, 255, 251, 114, 81, 255, 251, 114, 81, 255, 251, 114, 81, 255, 251, 115, 82, 255, 251, 115, 82, 255, 251, 115, 82, 255, 251, 115, 82, 255, 251, 116, 83, 255, 251, 116, 83, 255, 251, 116, 83, 255, 251, 116, 83, 255, 251, 117, 84, 255, 251, 117, 84, 255, 251, 117, 84, 255, 251, 117, 84, 255, 251, 118, 85, 255, 251, 118, 85, 255, 251, 118, 85, 255, 251, 118, 85, 255, 251, 119, 86, 255, 251, 119, 86, 255, 251, 119, 86, 255, 251, 119, 86, 255, 251, 120, 87, 255, 251, 120, 87, 255, 251, 120, 87, 255, 251, 120, 87, 255, 251, 121, 88, 255, 251, 121, 88, 255, 251, 121, 88, 255, 251, 121, 88, 255, 251, 122, 89, 255, 251, 122, 89, 255, 251, 130, 97, 255, 251, 130, 97, 255, 251, 131, 98, 255, 251, 131, 98, 255, 251, 131, 98, 255, 251, 131, 98, 255, 251, 132, 99, 255, 251, 132, 99, 255, 251, 132, 99, 255, 251, 132, 99, 255, 251, 133, 100, 255, 251, 133, 100, 255, 251, 133, 100, 255, 252, 133, 100, 255, 252, 134, 101, 255, 252, 134, 101, 255, 252, 134, 101, 255, 252, 134, 101, 255, 252, 135, 102, 255, 252, 135, 102, 255, 252, 135, 102, 255, 252, 135, 102, 255, 252, 136, 103, 255, 252, 136, 103, 255, 252, 136, 103, 255, 252, 136, 103, 255, 252, 137, 104, 255, 252, 137, 104, 255, 252, 137, 104, 255, 252, 137, 104, 255, 252, 137, 105, 255, 252, 138, 105, 255, 252, 138, 105, 255, 252, 138, 105, 255, 252, 138, 106, 255, 252, 139, 106, 255, 252, 139, 106, 255, 252, 139, 106, 255, 252, 139, 107, 255, 252, 140, 107, 255, 252, 140, 107, 255, 252, 140, 108, 255, 252, 140, 108, 255, 252, 141, 108, 255, 252, 141, 108, 255, 252, 141, 109, 255, 252, 141, 109, 255, 252, 142, 109, 255, 252, 142, 109, 255, 252, 142, 110, 255, 252, 142, 110, 255, 252, 142, 110, 255, 252, 143, 110, 255, 252, 143, 111, 255, 252, 143, 111, 255, 252, 143, 111, 255, 252, 144, 111, 255, 252, 144, 112, 255, 252, 144, 112, 255, 252, 144, 112, 255, 252, 145, 112, 255, 252, 145, 113, 255, 252, 145, 113, 255, 252, 145, 113, 255, 251, 146, 113, 255, 252, 146, 114, 255, 252, 146, 114, 255, 252, 146, 114, 255, 252, 147, 115, 255, 252, 147, 115, 255, 252, 147, 115, 255, 252, 147, 115, 255, 252, 148, 116, 255, 252, 148, 116, 255, 252, 148, 116, 255, 252, 148, 117, 255, 252, 149, 117, 255, 252, 149, 117, 255, 252, 149, 117, 255, 252, 150, 118, 255, 252, 150, 118, 255, 252, 150, 118, 255, 252, 150, 118, 255, 252, 151, 119, 255, 252, 151, 119, 255, 252, 151, 119, 255, 252, 151, 120, 255, 252, 152, 120, 255, 252, 152, 120, 255, 252, 152, 120, 255, 252, 152, 121, 255, 252, 153, 121, 255, 252, 153, 121, 255, 252, 153, 122, 255, 252, 153, 122, 255, 252, 154, 122, 255, 252, 154, 122, 255, 252, 154, 123, 255, 252, 155, 123, 255, 252, 155, 123, 255, 252, 155, 123, 255, 252, 155, 124, 255, 252, 156, 124, 255, 252, 156, 124, 255, 252, 156, 125, 255, 252, 156, 125, 255, 252, 157, 125, 255, 252, 157, 125, 255, 252, 157, 126, 255, 252, 157, 126, 255, 252, 158, 126, 255, 252, 158, 127, 255, 252, 158, 127, 255, 252, 158, 127, 255, 252, 159, 128, 255, 252, 159, 128, 255, 252, 159, 128, 255, 252, 159, 128, 255, 252, 160, 129, 255, 252, 160, 129, 255, 252, 160, 129, 255, 252, 160, 130, 255, 252, 161, 130, 255, 252, 161, 130, 255, 252, 161, 130, 255, 252, 161, 131, 255, 252, 162, 131, 255, 252, 162, 131, 255, 252, 170, 141, 255, 252, 171, 141, 255, 252, 171, 142, 255, 252, 171, 142, 255, 252, 171, 142, 255, 252, 172, 142, 255, 252, 172, 143, 255, 252, 172, 143, 255, 252, 172, 143, 255, 252, 173, 144, 255, 252, 173, 144, 255, 252, 173, 144, 255, 252, 174, 145, 255, 252, 174, 145, 255, 252, 174, 145, 255, 252, 174, 145, 255, 252, 175, 146, 255, 252, 175, 146, 255, 252, 175, 146, 255, 252, 175, 147, 255, 252, 176, 147, 255, 252, 176, 147, 255, 252, 176, 148, 255, 252, 176, 148, 255, 252, 177, 148, 255, 252, 177, 148, 255, 252, 177, 149, 255, 252, 177, 149, 255, 252, 178, 149, 255, 252, 178, 150, 255, 252, 178, 150, 255, 252, 178, 150, 255, 252, 179, 151, 255, 252, 179, 151, 255, 252, 179, 151, 255, 252, 179, 151, 255, 252, 180, 152, 255, 252, 180, 152, 255, 252, 180, 152, 255, 252, 180, 153, 255, 252, 181, 153, 255, 252, 181, 153, 255, 252, 181, 154, 255, 252, 181, 154, 255, 252, 182, 154, 255, 252, 182, 155, 255, 252, 182, 155, 255, 252, 182, 155, 255, 252, 183, 155, 255, 252, 183, 156, 255, 252, 183, 156, 255, 252, 183, 156, 255, 252, 184, 157, 255, 252, 184, 157, 255, 252, 184, 157, 255, 252, 184, 158, 255, 252, 185, 158, 255, 252, 185, 158, 255, 252, 185, 159, 255, 252, 185, 159, 255, 252, 186, 159, 255, 252, 186, 160, 255, 252, 186, 160, 255, 252, 186, 160, 255, 251, 187, 160, 255, 252, 187, 161, 255, 252, 187, 161, 255, 252, 187, 161, 255, 252, 187, 162, 255, 252, 188, 162, 255, 252, 188, 162, 255, 252, 188, 163, 255, 252, 188, 163, 255, 252, 189, 163, 255, 252, 189, 163, 255, 252, 189, 164, 255, 252, 189, 164, 255, 252, 190, 164, 255, 252, 190, 165, 255, 252, 190, 165, 255, 252, 190, 165, 255, 252, 190, 165, 255, 252, 191, 166, 255, 252, 191, 166, 255, 252, 191, 166, 255, 252, 191, 167, 255, 252, 192, 167, 255, 252, 192, 167, 255, 252, 192, 168, 255, 252, 192, 168, 255, 252, 193, 168, 255, 252, 193, 168, 255, 252, 193, 169, 255, 252, 193, 169, 255, 252, 194, 169, 255, 252, 194, 170, 255, 252, 194, 170, 255, 252, 194, 170, 255, 252, 194, 170, 255, 252, 195, 171, 255, 252, 195, 171, 255, 252, 195, 171, 255, 252, 195, 172, 255, 252, 196, 172, 255, 252, 196, 172, 255, 252, 196, 173, 255, 252, 196, 173, 255, 252, 197, 173, 255, 252, 197, 173, 255, 252, 197, 174, 255, 252, 197, 174, 255, 252, 197, 174, 255, 252, 198, 175, 255, 252, 198, 175, 255, 252, 198, 175, 255, 252, 198, 176, 255, 252, 199, 176, 255, 252, 199, 176, 255, 252, 199, 177, 255, 253, 199, 177, 255, 253, 200, 177, 255, 253, 200, 177, 255, 253, 200, 178, 255, 253, 200, 178, 255, 253, 200, 178, 255, 253, 201, 179, 255, 253, 201, 179, 255, 253, 201, 179, 255, 253, 209, 189, 255, 253, 209, 190, 255, 253, 209, 190, 255, 253, 210, 190, 255, 253, 210, 191, 255, 253, 210, 191, 255, 253, 210, 191, 255, 253, 210, 192, 255, 253, 211, 192, 255, 253, 211, 192, 255, 253, 211, 192, 255, 253, 211, 193, 255, 253, 212, 193, 255, 253, 212, 193, 255, 253, 212, 194, 255, 253, 212, 194, 255, 253, 213, 194, 255, 253, 213, 195, 255, 253, 213, 195, 255, 253, 213, 195, 255, 253, 213, 196, 255, 253, 214, 196, 255, 253, 214, 196, 255, 253, 214, 196, 255, 253, 214, 197, 255, 253, 215, 197, 255, 253, 215, 197, 255, 253, 215, 198, 255, 253, 215, 198, 255, 253, 215, 198, 255, 253, 216, 199, 255, 253, 216, 199, 255, 253, 216, 199, 255, 253, 216, 200, 255, 253, 217, 200, 255, 253, 217, 200, 255, 253, 217, 201, 255, 253, 217, 201, 255, 253, 218, 201, 255, 253, 218, 202, 255, 253, 218, 202, 255, 253, 218, 202, 255, 253, 218, 202, 255, 253, 219, 203, 255, 253, 219, 203, 255, 253, 219, 203, 255, 253, 219, 204, 255, 253, 220, 204, 255, 253, 220, 204, 255, 253, 220, 205, 255, 253, 220, 205, 255, 253, 221, 205, 255, 253, 221, 206, 255, 253, 221, 206, 255, 253, 221, 206, 255, 253, 221, 207, 255, 253, 222, 207, 255, 253, 222, 207, 255, 253, 222, 208, 255, 253, 222, 208, 255, 253, 223, 208, 255, 253, 223, 209, 255, 253, 223, 209, 255, 253, 223, 209, 255, 253, 224, 209, 255, 254, 224, 210, 255, 254, 224, 210, 255, 254, 224, 210, 255, 254, 224, 210, 255, 254, 224, 210, 255, 254, 224, 211, 255, 254, 224, 211, 255, 254, 225, 211, 255, 254, 225, 211, 255, 254, 225, 211, 255, 254, 225, 212, 255, 254, 225, 212, 255, 254, 225, 212, 255, 254, 225, 212, 255, 254, 225, 212, 255, 254, 226, 212, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 214, 255, 254, 227, 214, 255, 254, 227, 214, 255, 254, 227, 214, 255, 254, 227, 214, 255, 254, 227, 214, 255, 254, 227, 215, 255, 254, 227, 215, 255, 254, 227, 215, 255, 254, 228, 215, 255, 254, 228, 215, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 229, 216, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 218, 255, 254, 229, 218, 255, 254, 230, 218, 255, 254, 230, 218, 255, 254, 230, 218, 255, 254, 230, 219, 255, 254, 230, 219, 255, 254, 230, 219, 255, 254, 230, 219, 255, 254, 230, 219, 255, 254, 231, 219, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 221, 255, 254, 232, 221, 255, 254, 232, 221, 255, 254, 232, 221, 255, 254, 236, 227, 255, 254, 236, 228, 255, 254, 236, 228, 255, 254, 237, 228, 255, 254, 237, 228, 255, 254, 237, 228, 255, 254, 237, 228, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 238, 229, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 231, 255, 254, 238, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 232, 255, 254, 239, 232, 255, 254, 239, 232, 255, 254, 240, 232, 255, 254, 240, 232, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 242, 235, 255, 254, 242, 235, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Reds_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 102, 0, 12, 0, 106, 0, 13, 24, 110, 0, 14, 49, 114, 1, 15, 74, 117, 1, 15, 99, 121, 2, 16, 124, 125, 3, 16, 149, 141, 7, 18, 174, 145, 8, 19, 199, 148, 9, 19, 224, 152, 10, 20, 249, 155, 11, 20, 255, 159, 12, 20, 255, 162, 14, 20, 255, 165, 15, 21, 255, 167, 15, 21, 255, 169, 16, 22, 255, 171, 16, 22, 255, 174, 17, 22, 255, 176, 17, 23, 255, 177, 18, 23, 255, 179, 18, 24, 255, 189, 20, 26, 255, 191, 21, 26, 255, 193, 21, 26, 255, 195, 22, 27, 255, 197, 22, 27, 255, 199, 23, 28, 255, 201, 23, 28, 255, 202, 23, 28, 255, 204, 26, 29, 255, 206, 28, 30, 255, 208, 29, 31, 255, 209, 31, 31, 255, 211, 33, 32, 255, 213, 35, 33, 255, 214, 36, 33, 255, 216, 38, 34, 255, 225, 46, 38, 255, 226, 48, 38, 255, 228, 49, 39, 255, 229, 51, 40, 255, 231, 52, 40, 255, 232, 53, 41, 255, 234, 55, 42, 255, 235, 56, 42, 255, 237, 57, 43, 255, 238, 58, 43, 255, 239, 61, 45, 255, 240, 63, 46, 255, 240, 65, 47, 255, 241, 67, 48, 255, 241, 69, 49, 255, 241, 71, 50, 255, 242, 73, 51, 255, 242, 75, 53, 255, 243, 77, 54, 255, 243, 79, 55, 255, 246, 90, 62, 255, 247, 91, 63, 255, 247, 93, 64, 255, 247, 94, 65, 255, 248, 96, 66, 255, 248, 98, 67, 255, 249, 99, 69, 255, 249, 100, 70, 255, 250, 102, 71, 255, 250, 103, 72, 255, 250, 105, 73, 255, 251, 106, 74, 255, 251, 108, 75, 255, 251, 109, 77, 255, 251, 110, 78, 255, 251, 112, 79, 255, 251, 113, 80, 255, 251, 114, 82, 255, 251, 116, 83, 255, 251, 117, 84, 255, 251, 118, 85, 255, 251, 119, 86, 255, 251, 121, 88, 255, 251, 122, 89, 255, 251, 131, 98, 255, 251, 132, 99, 255, 252, 133, 100, 255, 252, 134, 102, 255, 252, 136, 103, 255, 252, 137, 104, 255, 252, 138, 105, 255, 252, 139, 106, 255, 252, 140, 107, 255, 252, 141, 108, 255, 252, 142, 109, 255, 252, 143, 111, 255, 252, 144, 112, 255, 252, 145, 113, 255, 252, 146, 114, 255, 252, 147, 115, 255, 252, 148, 116, 255, 252, 149, 117, 255, 252, 150, 118, 255, 252, 151, 119, 255, 252, 152, 121, 255, 252, 153, 122, 255, 252, 154, 123, 255, 252, 155, 124, 255, 252, 156, 125, 255, 252, 157, 126, 255, 252, 158, 127, 255, 252, 159, 128, 255, 252, 160, 129, 255, 252, 161, 130, 255, 252, 162, 131, 255, 252, 171, 142, 255, 252, 172, 143, 255, 252, 173, 144, 255, 252, 174, 145, 255, 252, 174, 146, 255, 252, 175, 147, 255, 252, 176, 148, 255, 252, 177, 149, 255, 252, 178, 150, 255, 252, 179, 151, 255, 252, 179, 152, 255, 252, 180, 153, 255, 252, 181, 153, 255, 252, 182, 154, 255, 252, 182, 155, 255, 252, 183, 156, 255, 252, 184, 157, 255, 252, 185, 158, 255, 252, 185, 159, 255, 252, 186, 160, 255, 252, 187, 161, 255, 252, 187, 162, 255, 252, 188, 163, 255, 252, 189, 163, 255, 252, 189, 164, 255, 252, 190, 165, 255, 252, 191, 166, 255, 252, 191, 167, 255, 252, 192, 167, 255, 252, 193, 168, 255, 252, 193, 169, 255, 252, 194, 170, 255, 252, 194, 170, 255, 252, 195, 171, 255, 252, 196, 172, 255, 252, 196, 173, 255, 252, 197, 173, 255, 252, 197, 174, 255, 252, 198, 175, 255, 252, 198, 176, 255, 252, 199, 176, 255, 253, 199, 177, 255, 253, 200, 178, 255, 253, 200, 178, 255, 253, 201, 179, 255, 253, 209, 189, 255, 253, 209, 190, 255, 253, 210, 191, 255, 253, 210, 191, 255, 253, 211, 192, 255, 253, 211, 193, 255, 253, 212, 193, 255, 253, 212, 194, 255, 253, 213, 195, 255, 253, 213, 195, 255, 253, 214, 196, 255, 253, 214, 197, 255, 253, 215, 197, 255, 253, 215, 198, 255, 253, 216, 198, 255, 253, 216, 199, 255, 253, 216, 200, 255, 253, 217, 200, 255, 253, 217, 201, 255, 253, 218, 201, 255, 253, 218, 202, 255, 253, 218, 202, 255, 253, 219, 203, 255, 253, 219, 204, 255, 253, 220, 204, 255, 253, 220, 205, 255, 253, 220, 205, 255, 253, 221, 206, 255, 253, 221, 206, 255, 253, 222, 207, 255, 253, 222, 207, 255, 253, 222, 208, 255, 253, 223, 208, 255, 253, 223, 209, 255, 253, 223, 209, 255, 254, 224, 210, 255, 254, 224, 210, 255, 254, 224, 210, 255, 254, 224, 211, 255, 254, 224, 211, 255, 254, 225, 211, 255, 254, 225, 211, 255, 254, 225, 212, 255, 254, 225, 212, 255, 254, 225, 212, 255, 254, 226, 212, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 213, 255, 254, 226, 214, 255, 254, 227, 214, 255, 254, 227, 214, 255, 254, 227, 214, 255, 254, 227, 215, 255, 254, 227, 215, 255, 254, 227, 215, 255, 254, 228, 215, 255, 254, 228, 215, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 228, 216, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 217, 255, 254, 229, 218, 255, 254, 229, 218, 255, 254, 230, 218, 255, 254, 230, 218, 255, 254, 230, 218, 255, 254, 230, 219, 255, 254, 230, 219, 255, 254, 230, 219, 255, 254, 230, 219, 255, 254, 231, 219, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 220, 255, 254, 231, 221, 255, 254, 231, 221, 255, 254, 232, 221, 255, 254, 232, 221, 255, 254, 232, 221, 255, 254, 236, 227, 255, 254, 236, 228, 255, 254, 236, 228, 255, 254, 236, 228, 255, 254, 237, 228, 255, 254, 237, 228, 255, 254, 237, 228, 255, 254, 237, 228, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 237, 229, 255, 254, 238, 229, 255, 254, 238, 229, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 230, 255, 254, 238, 231, 255, 254, 238, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 231, 255, 254, 239, 232, 255, 254, 239, 232, 255, 254, 239, 232, 255, 254, 239, 232, 255, 254, 239, 232, 255, 254, 239, 232, 255, 254, 240, 232, 255, 254, 240, 232, 255, 254, 240, 232, 255, 254, 240, 232, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 233, 255, 254, 240, 234, 255, 254, 240, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 234, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 241, 235, 255, 254, 242, 235, 255, 254, 242, 235, 255, 254, 242, 235, 255, 254, 242, 235, 255, 254, 242, 235, 255, 254, 242, 235, 255, 254, 242, 235, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 236, 255, 254, 242, 237, 255, 254, 242, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 237, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 243, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 238, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 244, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255, 254, 245, 239, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Reds_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
