/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/PuRd.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 103, 0, 31, 255, 152, 0, 67, 255, 206, 18, 86, 255, 231, 41, 138, 255, 223, 101, 176, 255, 201, 148, 199, 255, 212, 185, 218, 255, 231, 225, 239, 255, 247, 244, 249, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuRd_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 102, 0, 30, 0, 103, 0, 31, 7, 103, 0, 31, 14, 104, 0, 31, 22, 104, 0, 31, 29, 104, 0, 32, 37, 105, 0, 32, 44, 105, 0, 32, 52, 106, 0, 32, 59, 106, 0, 33, 67, 106, 0, 33, 74, 107, 0, 33, 82, 107, 0, 33, 89, 107, 0, 34, 97, 108, 0, 34, 104, 108, 0, 34, 112, 109, 0, 34, 119, 109, 0, 35, 127, 109, 0, 35, 134, 110, 0, 35, 141, 110, 0, 35, 149, 110, 0, 36, 156, 111, 0, 36, 164, 111, 0, 36, 171, 112, 0, 36, 179, 112, 0, 37, 186, 112, 0, 37, 194, 113, 0, 37, 201, 113, 0, 37, 209, 113, 0, 38, 216, 114, 0, 38, 224, 114, 0, 38, 231, 115, 0, 38, 239, 115, 0, 39, 246, 115, 0, 39, 254, 116, 0, 39, 255, 116, 0, 40, 255, 117, 0, 40, 255, 117, 0, 40, 255, 117, 0, 40, 255, 118, 0, 41, 255, 118, 0, 41, 255, 118, 0, 41, 255, 119, 0, 41, 255, 119, 0, 42, 255, 120, 0, 42, 255, 120, 0, 42, 255, 120, 0, 42, 255, 121, 0, 43, 255, 121, 0, 43, 255, 122, 0, 43, 255, 122, 0, 44, 255, 122, 0, 44, 255, 123, 0, 44, 255, 123, 0, 44, 255, 123, 0, 45, 255, 124, 0, 45, 255, 124, 0, 45, 255, 125, 0, 45, 255, 125, 0, 46, 255, 125, 0, 46, 255, 126, 0, 46, 255, 126, 0, 47, 255, 127, 0, 47, 255, 127, 0, 47, 255, 127, 0, 47, 255, 128, 0, 48, 255, 128, 0, 48, 255, 128, 0, 48, 255, 129, 0, 49, 255, 129, 0, 49, 255, 130, 0, 49, 255, 130, 0, 49, 255, 130, 0, 50, 255, 131, 0, 50, 255, 131, 0, 50, 255, 131, 0, 51, 255, 132, 0, 51, 255, 132, 0, 51, 255, 133, 0, 51, 255, 133, 0, 52, 255, 133, 0, 52, 255, 134, 0, 52, 255, 134, 0, 53, 255, 135, 0, 53, 255, 135, 0, 53, 255, 135, 0, 53, 255, 136, 0, 54, 255, 136, 0, 54, 255, 136, 0, 54, 255, 137, 0, 55, 255, 137, 0, 55, 255, 138, 0, 55, 255, 138, 0, 56, 255, 138, 0, 56, 255, 139, 0, 56, 255, 139, 0, 56, 255, 140, 0, 57, 255, 140, 0, 57, 255, 140, 0, 57, 255, 141, 0, 58, 255, 141, 0, 58, 255, 142, 0, 58, 255, 142, 0, 59, 255, 142, 0, 59, 255, 143, 0, 59, 255, 143, 0, 60, 255, 143, 0, 60, 255, 144, 0, 60, 255, 144, 0, 60, 255, 145, 0, 61, 255, 145, 0, 61, 255, 145, 0, 61, 255, 146, 0, 62, 255, 146, 0, 62, 255, 147, 0, 62, 255, 147, 0, 63, 255, 147, 0, 63, 255, 148, 0, 63, 255, 148, 0, 64, 255, 148, 0, 64, 255, 149, 0, 64, 255, 149, 0, 65, 255, 150, 0, 65, 255, 150, 0, 65, 255, 150, 0, 66, 255, 151, 0, 66, 255, 151, 0, 66, 255, 151, 0, 66, 255, 152, 0, 67, 255, 152, 0, 67, 255, 153, 0, 67, 255, 153, 0, 67, 255, 154, 0, 67, 255, 154, 0, 67, 255, 154, 0, 68, 255, 155, 0, 68, 255, 155, 0, 68, 255, 156, 0, 68, 255, 156, 1, 68, 255, 156, 1, 68, 255, 157, 1, 69, 255, 157, 1, 69, 255, 158, 1, 69, 255, 158, 1, 69, 255, 159, 1, 69, 255, 159, 1, 69, 255, 159, 1, 69, 255, 160, 1, 70, 255, 160, 2, 70, 255, 161, 2, 70, 255, 161, 2, 70, 255, 161, 2, 70, 255, 162, 2, 70, 255, 162, 2, 71, 255, 163, 2, 71, 255, 163, 2, 71, 255, 163, 2, 71, 255, 164, 3, 71, 255, 164, 3, 71, 255, 165, 3, 71, 255, 165, 3, 72, 255, 166, 3, 72, 255, 166, 3, 72, 255, 166, 3, 72, 255, 167, 3, 72, 255, 167, 3, 72, 255, 168, 4, 73, 255, 168, 4, 73, 255, 169, 4, 73, 255, 169, 4, 73, 255, 169, 4, 73, 255, 170, 4, 73, 255, 170, 4, 73, 255, 171, 4, 74, 255, 171, 5, 74, 255, 171, 5, 74, 255, 172, 5, 74, 255, 172, 5, 74, 255, 173, 5, 74, 255, 173, 5, 75, 255, 174, 5, 75, 255, 174, 6, 75, 255, 174, 6, 75, 255, 175, 6, 75, 255, 175, 6, 75, 255, 176, 6, 75, 255, 176, 6, 76, 255, 176, 6, 76, 255, 177, 7, 76, 255, 177, 7, 76, 255, 178, 7, 76, 255, 178, 7, 76, 255, 179, 7, 76, 255, 179, 7, 77, 255, 179, 8, 77, 255, 180, 8, 77, 255, 180, 8, 77, 255, 181, 8, 77, 255, 181, 8, 77, 255, 182, 8, 77, 255, 182, 8, 78, 255, 182, 9, 78, 255, 183, 9, 78, 255, 183, 9, 78, 255, 184, 9, 78, 255, 184, 9, 78, 255, 185, 9, 79, 255, 185, 10, 79, 255, 185, 10, 79, 255, 186, 10, 79, 255, 186, 10, 79, 255, 187, 10, 79, 255, 187, 10, 79, 255, 188, 11, 80, 255, 188, 11, 80, 255, 188, 11, 80, 255, 189, 11, 80, 255, 189, 11, 80, 255, 190, 11, 80, 255, 190, 12, 80, 255, 190, 12, 81, 255, 191, 12, 81, 255, 191, 12, 81, 255, 192, 12, 81, 255, 192, 12, 81, 255, 193, 13, 81, 255, 193, 13, 81, 255, 193, 13, 82, 255, 194, 13, 82, 255, 194, 13, 82, 255, 195, 13, 82, 255, 195, 14, 82, 255, 196, 14, 82, 255, 196, 14, 82, 255, 196, 14, 83, 255, 197, 14, 83, 255, 197, 14, 83, 255, 198, 15, 83, 255, 198, 15, 83, 255, 199, 15, 83, 255, 199, 15, 83, 255, 199, 15, 84, 255, 200, 15, 84, 255, 200, 16, 84, 255, 201, 16, 84, 255, 201, 16, 84, 255, 202, 16, 84, 255, 202, 16, 84, 255, 202, 16, 85, 255, 203, 17, 85, 255, 203, 17, 85, 255, 204, 17, 85, 255, 204, 17, 85, 255, 205, 17, 85, 255, 205, 17, 85, 255, 205, 18, 85, 255, 206, 18, 86, 255, 206, 18, 86, 255, 206, 18, 87, 255, 206, 18, 87, 255, 207, 18, 87, 255, 207, 18, 88, 255, 207, 18, 88, 255, 207, 18, 89, 255, 208, 18, 89, 255, 208, 19, 89, 255, 208, 19, 90, 255, 208, 19, 90, 255, 208, 19, 90, 255, 209, 19, 91, 255, 209, 19, 91, 255, 209, 19, 92, 255, 209, 19, 92, 255, 210, 20, 92, 255, 210, 20, 93, 255, 210, 20, 93, 255, 210, 20, 93, 255, 211, 20, 94, 255, 211, 20, 94, 255, 211, 20, 95, 255, 211, 20, 95, 255, 211, 21, 95, 255, 212, 21, 96, 255, 212, 21, 96, 255, 212, 21, 97, 255, 212, 21, 97, 255, 212, 21, 97, 255, 213, 21, 98, 255, 213, 22, 98, 255, 213, 22, 99, 255, 213, 22, 99, 255, 214, 22, 99, 255, 214, 22, 100, 255, 214, 22, 100, 255, 214, 22, 101, 255, 214, 23, 101, 255, 215, 23, 101, 255, 215, 23, 102, 255, 215, 23, 102, 255, 215, 23, 102, 255, 215, 23, 103, 255, 216, 24, 103, 255, 216, 24, 104, 255, 216, 24, 104, 255, 216, 24, 104, 255, 216, 24, 105, 255, 217, 24, 105, 255, 217, 25, 106, 255, 217, 25, 106, 255, 217, 25, 106, 255, 218, 25, 107, 255, 218, 25, 107, 255, 218, 26, 108, 255, 218, 26, 108, 255, 218, 26, 109, 255, 219, 26, 109, 255, 219, 26, 109, 255, 219, 26, 110, 255, 219, 27, 110, 255, 219, 27, 111, 255, 220, 27, 111, 255, 220, 27, 111, 255, 220, 27, 112, 255, 220, 28, 112, 255, 220, 28, 113, 255, 220, 28, 113, 255, 221, 28, 113, 255, 221, 28, 114, 255, 221, 29, 114, 255, 221, 29, 115, 255, 221, 29, 115, 255, 222, 29, 115, 255, 222, 29, 116, 255, 222, 29, 116, 255, 222, 30, 117, 255, 222, 30, 117, 255, 223, 30, 118, 255, 223, 30, 118, 255, 223, 31, 118, 255, 223, 31, 119, 255, 223, 31, 119, 255, 223, 31, 120, 255, 224, 31, 120, 255, 224, 32, 120, 255, 224, 32, 121, 255, 224, 32, 121, 255, 224, 32, 122, 255, 225, 32, 122, 255, 225, 33, 123, 255, 225, 33, 123, 255, 225, 33, 123, 255, 225, 33, 124, 255, 225, 33, 124, 255, 226, 34, 125, 255, 226, 34, 125, 255, 226, 34, 125, 255, 226, 34, 126, 255, 226, 35, 126, 255, 226, 35, 127, 255, 227, 35, 127, 255, 227, 35, 128, 255, 227, 35, 128, 255, 227, 36, 128, 255, 227, 36, 129, 255, 227, 36, 129, 255, 228, 36, 130, 255, 228, 37, 130, 255, 228, 37, 131, 255, 228, 37, 131, 255, 228, 37, 131, 255, 228, 37, 132, 255, 229, 38, 132, 255, 229, 38, 133, 255, 229, 38, 133, 255, 229, 38, 134, 255, 229, 39, 134, 255, 229, 39, 134, 255, 230, 39, 135, 255, 230, 39, 135, 255, 230, 40, 136, 255, 230, 40, 136, 255, 230, 40, 137, 255, 230, 40, 137, 255, 230, 41, 137, 255, 230, 41, 138, 255, 230, 42, 138, 255, 230, 43, 139, 255, 230, 43, 139, 255, 230, 44, 139, 255, 230, 45, 140, 255, 230, 45, 140, 255, 230, 46, 140, 255, 230, 47, 141, 255, 230, 47, 141, 255, 230, 48, 141, 255, 230, 49, 142, 255, 230, 49, 142, 255, 230, 50, 142, 255, 230, 50, 143, 255, 230, 51, 143, 255, 230, 52, 143, 255, 230, 52, 143, 255, 230, 53, 144, 255, 230, 53, 144, 255, 230, 54, 144, 255, 230, 55, 145, 255, 229, 55, 145, 255, 229, 56, 145, 255, 229, 56, 146, 255, 229, 57, 146, 255, 229, 57, 146, 255, 229, 58, 147, 255, 229, 58, 147, 255, 229, 59, 147, 255, 229, 60, 148, 255, 229, 60, 148, 255, 229, 61, 148, 255, 229, 61, 149, 255, 229, 62, 149, 255, 229, 62, 149, 255, 229, 63, 150, 255, 229, 63, 150, 255, 229, 64, 150, 255, 229, 64, 151, 255, 229, 65, 151, 255, 228, 65, 151, 255, 228, 66, 151, 255, 228, 66, 152, 255, 228, 67, 152, 255, 228, 67, 152, 255, 228, 68, 153, 255, 228, 68, 153, 255, 228, 69, 153, 255, 228, 69, 154, 255, 228, 69, 154, 255, 228, 70, 154, 255, 228, 70, 155, 255, 228, 71, 155, 255, 228, 71, 155, 255, 228, 72, 155, 255, 228, 72, 156, 255, 227, 73, 156, 255, 227, 73, 156, 255, 227, 74, 157, 255, 227, 74, 157, 255, 227, 74, 157, 255, 227, 75, 158, 255, 227, 75, 158, 255, 227, 76, 158, 255, 227, 76, 158, 255, 227, 77, 159, 255, 227, 77, 159, 255, 227, 78, 159, 255, 227, 78, 160, 255, 227, 78, 160, 255, 227, 79, 160, 255, 227, 79, 161, 255, 226, 80, 161, 255, 226, 80, 161, 255, 226, 81, 161, 255, 226, 81, 162, 255, 226, 81, 162, 255, 226, 82, 162, 255, 226, 82, 163, 255, 226, 83, 163, 255, 226, 83, 163, 255, 226, 83, 163, 255, 226, 84, 164, 255, 226, 84, 164, 255, 226, 85, 164, 255, 226, 85, 165, 255, 225, 85, 165, 255, 225, 86, 165, 255, 225, 86, 165, 255, 225, 87, 166, 255, 225, 87, 166, 255, 225, 87, 166, 255, 225, 88, 166, 255, 225, 88, 167, 255, 225, 89, 167, 255, 225, 89, 167, 255, 225, 89, 168, 255, 225, 90, 168, 255, 225, 90, 168, 255, 225, 91, 168, 255, 224, 91, 169, 255, 224, 91, 169, 255, 224, 92, 169, 255, 224, 92, 169, 255, 224, 92, 170, 255, 224, 93, 170, 255, 224, 93, 170, 255, 224, 94, 171, 255, 224, 94, 171, 255, 224, 94, 171, 255, 224, 95, 171, 255, 224, 95, 172, 255, 224, 95, 172, 255, 224, 96, 172, 255, 223, 96, 172, 255, 223, 97, 173, 255, 223, 97, 173, 255, 223, 97, 173, 255, 223, 98, 173, 255, 223, 98, 174, 255, 223, 98, 174, 255, 223, 99, 174, 255, 223, 99, 174, 255, 223, 99, 175, 255, 223, 100, 175, 255, 223, 100, 175, 255, 222, 101, 175, 255, 222, 101, 176, 255, 222, 101, 176, 255, 222, 102, 176, 255, 222, 102, 177, 255, 222, 103, 177, 255, 221, 103, 177, 255, 221, 104, 177, 255, 221, 104, 178, 255, 221, 104, 178, 255, 221, 105, 178, 255, 220, 105, 178, 255, 220, 106, 179, 255, 220, 106, 179, 255, 220, 107, 179, 255, 220, 107, 179, 255, 220, 107, 180, 255, 219, 108, 180, 255, 219, 108, 180, 255, 219, 109, 180, 255, 219, 109, 181, 255, 219, 109, 181, 255, 218, 110, 181, 255, 218, 110, 181, 255, 218, 111, 182, 255, 218, 111, 182, 255, 218, 111, 182, 255, 218, 112, 182, 255, 217, 112, 183, 255, 217, 113, 183, 255, 217, 113, 183, 255, 217, 113, 183, 255, 217, 114, 183, 255, 216, 114, 184, 255, 216, 115, 184, 255, 216, 115, 184, 255, 216, 115, 184, 255, 216, 116, 185, 255, 216, 116, 185, 255, 215, 117, 185, 255, 215, 117, 185, 255, 215, 117, 185, 255, 215, 118, 186, 255, 215, 118, 186, 255, 214, 119, 186, 255, 214, 119, 186, 255, 214, 119, 187, 255, 214, 120, 187, 255, 214, 120, 187, 255, 214, 120, 187, 255, 213, 121, 187, 255, 213, 121, 188, 255, 213, 122, 188, 255, 213, 122, 188, 255, 213, 122, 188, 255, 212, 123, 188, 255, 212, 123, 189, 255, 212, 123, 189, 255, 212, 124, 189, 255, 212, 124, 189, 255, 212, 125, 189, 255, 211, 125, 189, 255, 211, 125, 190, 255, 211, 126, 190, 255, 211, 126, 190, 255, 211, 126, 190, 255, 210, 127, 190, 255, 210, 127, 191, 255, 210, 127, 191, 255, 210, 128, 191, 255, 210, 128, 191, 255, 210, 129, 191, 255, 209, 129, 191, 255, 209, 129, 192, 255, 209, 130, 192, 255, 209, 130, 192, 255, 209, 130, 192, 255, 209, 131, 192, 255, 208, 131, 192, 255, 208, 131, 193, 255, 208, 132, 193, 255, 208, 132, 193, 255, 208, 132, 193, 255, 208, 133, 193, 255, 207, 133, 193, 255, 207, 133, 193, 255, 207, 134, 194, 255, 207, 134, 194, 255, 207, 134, 194, 255, 207, 135, 194, 255, 206, 135, 194, 255, 206, 135, 194, 255, 206, 136, 194, 255, 206, 136, 195, 255, 206, 136, 195, 255, 206, 137, 195, 255, 205, 137, 195, 255, 205, 137, 195, 255, 205, 138, 195, 255, 205, 138, 195, 255, 205, 138, 196, 255, 205, 139, 196, 255, 204, 139, 196, 255, 204, 139, 196, 255, 204, 140, 196, 255, 204, 140, 196, 255, 204, 140, 196, 255, 204, 141, 196, 255, 203, 141, 196, 255, 203, 141, 197, 255, 203, 142, 197, 255, 203, 142, 197, 255, 203, 142, 197, 255, 203, 143, 197, 255, 203, 143, 197, 255, 202, 143, 197, 255, 202, 144, 197, 255, 202, 144, 197, 255, 202, 144, 198, 255, 202, 145, 198, 255, 202, 145, 198, 255, 202, 145, 198, 255, 201, 146, 198, 255, 201, 146, 198, 255, 201, 146, 198, 255, 201, 147, 198, 255, 201, 147, 198, 255, 201, 147, 198, 255, 200, 148, 198, 255, 201, 148, 199, 255, 201, 148, 199, 255, 201, 148, 199, 255, 201, 149, 199, 255, 201, 149, 199, 255, 201, 149, 200, 255, 201, 150, 200, 255, 201, 150, 200, 255, 201, 150, 200, 255, 201, 150, 200, 255, 201, 151, 200, 255, 201, 151, 200, 255, 201, 151, 201, 255, 202, 152, 201, 255, 202, 152, 201, 255, 202, 152, 201, 255, 202, 153, 201, 255, 202, 153, 201, 255, 202, 153, 202, 255, 202, 153, 202, 255, 202, 154, 202, 255, 202, 154, 202, 255, 202, 154, 202, 255, 202, 155, 202, 255, 202, 155, 203, 255, 202, 155, 203, 255, 203, 155, 203, 255, 203, 156, 203, 255, 203, 156, 203, 255, 203, 156, 203, 255, 203, 157, 204, 255, 203, 157, 204, 255, 203, 157, 204, 255, 203, 157, 204, 255, 203, 158, 204, 255, 203, 158, 204, 255, 203, 158, 205, 255, 203, 159, 205, 255, 203, 159, 205, 255, 204, 159, 205, 255, 204, 160, 205, 255, 204, 160, 205, 255, 204, 160, 205, 255, 204, 160, 206, 255, 204, 161, 206, 255, 204, 161, 206, 255, 204, 161, 206, 255, 204, 162, 206, 255, 204, 162, 206, 255, 204, 162, 207, 255, 204, 162, 207, 255, 205, 163, 207, 255, 205, 163, 207, 255, 205, 163, 207, 255, 205, 164, 207, 255, 205, 164, 207, 255, 205, 164, 208, 255, 205, 164, 208, 255, 205, 165, 208, 255, 205, 165, 208, 255, 205, 165, 208, 255, 205, 166, 208, 255, 205, 166, 208, 255, 206, 166, 209, 255, 206, 166, 209, 255, 206, 167, 209, 255, 206, 167, 209, 255, 206, 167, 209, 255, 206, 168, 209, 255, 206, 168, 210, 255, 206, 168, 210, 255, 206, 169, 210, 255, 206, 169, 210, 255, 206, 169, 210, 255, 206, 169, 210, 255, 207, 170, 210, 255, 207, 170, 211, 255, 207, 170, 211, 255, 207, 171, 211, 255, 207, 171, 211, 255, 207, 171, 211, 255, 207, 171, 211, 255, 207, 172, 211, 255, 207, 172, 212, 255, 207, 172, 212, 255, 207, 173, 212, 255, 208, 173, 212, 255, 208, 173, 212, 255, 208, 173, 212, 255, 208, 174, 212, 255, 208, 174, 213, 255, 208, 174, 213, 255, 208, 175, 213, 255, 208, 175, 213, 255, 208, 175, 213, 255, 208, 175, 213, 255, 208, 176, 213, 255, 209, 176, 213, 255, 209, 176, 214, 255, 209, 177, 214, 255, 209, 177, 214, 255, 209, 177, 214, 255, 209, 177, 214, 255, 209, 178, 214, 255, 209, 178, 214, 255, 209, 178, 215, 255, 209, 179, 215, 255, 210, 179, 215, 255, 210, 179, 215, 255, 210, 179, 215, 255, 210, 180, 215, 255, 210, 180, 215, 255, 210, 180, 216, 255, 210, 181, 216, 255, 210, 181, 216, 255, 210, 181, 216, 255, 210, 181, 216, 255, 210, 182, 216, 255, 211, 182, 216, 255, 211, 182, 216, 255, 211, 183, 217, 255, 211, 183, 217, 255, 211, 183, 217, 255, 211, 183, 217, 255, 211, 184, 217, 255, 211, 184, 217, 255, 211, 184, 217, 255, 211, 185, 217, 255, 212, 185, 218, 255, 212, 185, 218, 255, 212, 185, 218, 255, 212, 186, 218, 255, 212, 186, 218, 255, 212, 186, 219, 255, 212, 187, 219, 255, 212, 187, 219, 255, 213, 187, 219, 255, 213, 188, 219, 255, 213, 188, 220, 255, 213, 188, 220, 255, 213, 189, 220, 255, 213, 189, 220, 255, 213, 189, 220, 255, 213, 190, 221, 255, 213, 190, 221, 255, 214, 190, 221, 255, 214, 191, 221, 255, 214, 191, 221, 255, 214, 191, 222, 255, 214, 192, 222, 255, 214, 192, 222, 255, 214, 192, 222, 255, 214, 192, 222, 255, 215, 193, 222, 255, 215, 193, 223, 255, 215, 193, 223, 255, 215, 194, 223, 255, 215, 194, 223, 255, 215, 194, 223, 255, 215, 195, 224, 255, 215, 195, 224, 255, 216, 195, 224, 255, 216, 196, 224, 255, 216, 196, 224, 255, 216, 196, 224, 255, 216, 197, 225, 255, 216, 197, 225, 255, 216, 197, 225, 255, 216, 198, 225, 255, 217, 198, 225, 255, 217, 198, 225, 255, 217, 198, 226, 255, 217, 199, 226, 255, 217, 199, 226, 255, 217, 199, 226, 255, 217, 200, 226, 255, 218, 200, 227, 255, 218, 200, 227, 255, 218, 201, 227, 255, 218, 201, 227, 255, 218, 201, 227, 255, 218, 202, 227, 255, 218, 202, 228, 255, 219, 202, 228, 255, 219, 203, 228, 255, 219, 203, 228, 255, 219, 203, 228, 255, 219, 204, 228, 255, 219, 204, 229, 255, 219, 204, 229, 255, 220, 204, 229, 255, 220, 205, 229, 255, 220, 205, 229, 255, 220, 205, 229, 255, 220, 206, 230, 255, 220, 206, 230, 255, 220, 206, 230, 255, 221, 207, 230, 255, 221, 207, 230, 255, 221, 207, 230, 255, 221, 208, 230, 255, 221, 208, 231, 255, 221, 208, 231, 255, 221, 208, 231, 255, 222, 209, 231, 255, 222, 209, 231, 255, 222, 209, 231, 255, 222, 210, 232, 255, 222, 210, 232, 255, 222, 210, 232, 255, 223, 211, 232, 255, 223, 211, 232, 255, 223, 211, 232, 255, 223, 212, 232, 255, 223, 212, 233, 255, 223, 212, 233, 255, 224, 213, 233, 255, 224, 213, 233, 255, 224, 213, 233, 255, 224, 213, 233, 255, 224, 214, 234, 255, 224, 214, 234, 255, 225, 214, 234, 255, 225, 215, 234, 255, 225, 215, 234, 255, 225, 215, 234, 255, 225, 216, 234, 255, 225, 216, 235, 255, 226, 216, 235, 255, 226, 217, 235, 255, 226, 217, 235, 255, 226, 217, 235, 255, 226, 217, 235, 255, 226, 218, 235, 255, 227, 218, 236, 255, 227, 218, 236, 255, 227, 219, 236, 255, 227, 219, 236, 255, 227, 219, 236, 255, 228, 220, 236, 255, 228, 220, 236, 255, 228, 220, 237, 255, 228, 221, 237, 255, 228, 221, 237, 255, 228, 221, 237, 255, 229, 221, 237, 255, 229, 222, 237, 255, 229, 222, 237, 255, 229, 222, 238, 255, 229, 223, 238, 255, 230, 223, 238, 255, 230, 223, 238, 255, 230, 224, 238, 255, 230, 224, 238, 255, 230, 224, 238, 255, 230, 225, 238, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 227, 240, 255, 232, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 234, 228, 240, 255, 234, 228, 240, 255, 234, 228, 240, 255, 234, 228, 240, 255, 234, 228, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 235, 229, 241, 255, 235, 229, 241, 255, 235, 229, 241, 255, 235, 229, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 236, 230, 241, 255, 236, 230, 242, 255, 236, 230, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 237, 231, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 243, 255, 237, 232, 243, 255, 238, 233, 243, 255, 238, 233, 243, 255, 238, 233, 243, 255, 238, 233, 243, 255, 238, 233, 243, 255, 238, 233, 243, 255, 238, 233, 243, 255, 239, 234, 243, 255, 239, 234, 243, 255, 239, 234, 243, 255, 239, 234, 243, 255, 239, 234, 244, 255, 239, 234, 244, 255, 239, 234, 244, 255, 239, 235, 244, 255, 240, 235, 244, 255, 240, 235, 244, 255, 240, 235, 244, 255, 240, 235, 244, 255, 240, 235, 244, 255, 240, 236, 244, 255, 240, 236, 244, 255, 240, 236, 244, 255, 240, 236, 244, 255, 241, 236, 245, 255, 241, 236, 245, 255, 241, 236, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 242, 237, 245, 255, 242, 237, 245, 255, 242, 238, 245, 255, 242, 238, 245, 255, 242, 238, 245, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 240, 246, 255, 244, 240, 246, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 242, 247, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuRd_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 102, 0, 30, 0, 103, 0, 31, 7, 103, 0, 31, 14, 103, 0, 31, 22, 104, 0, 31, 29, 104, 0, 31, 37, 104, 0, 32, 44, 105, 0, 32, 52, 105, 0, 32, 59, 105, 0, 32, 67, 106, 0, 32, 74, 106, 0, 33, 82, 106, 0, 33, 89, 106, 0, 33, 97, 107, 0, 33, 104, 107, 0, 33, 112, 107, 0, 34, 119, 108, 0, 34, 127, 108, 0, 34, 134, 108, 0, 34, 141, 109, 0, 34, 149, 109, 0, 35, 156, 109, 0, 35, 164, 109, 0, 35, 171, 110, 0, 35, 179, 110, 0, 35, 186, 110, 0, 36, 194, 111, 0, 36, 201, 111, 0, 36, 209, 111, 0, 36, 216, 112, 0, 36, 224, 112, 0, 37, 231, 112, 0, 37, 239, 113, 0, 37, 246, 113, 0, 37, 254, 113, 0, 38, 255, 113, 0, 38, 255, 114, 0, 38, 255, 114, 0, 38, 255, 114, 0, 38, 255, 115, 0, 39, 255, 115, 0, 39, 255, 115, 0, 39, 255, 116, 0, 39, 255, 116, 0, 39, 255, 116, 0, 40, 255, 116, 0, 40, 255, 117, 0, 40, 255, 117, 0, 40, 255, 117, 0, 40, 255, 118, 0, 41, 255, 118, 0, 41, 255, 118, 0, 41, 255, 119, 0, 41, 255, 119, 0, 42, 255, 119, 0, 42, 255, 120, 0, 42, 255, 120, 0, 42, 255, 120, 0, 42, 255, 120, 0, 43, 255, 121, 0, 43, 255, 121, 0, 43, 255, 121, 0, 43, 255, 122, 0, 44, 255, 132, 0, 51, 255, 132, 0, 51, 255, 132, 0, 51, 255, 133, 0, 52, 255, 133, 0, 52, 255, 133, 0, 52, 255, 134, 0, 52, 255, 134, 0, 53, 255, 134, 0, 53, 255, 135, 0, 53, 255, 135, 0, 53, 255, 135, 0, 54, 255, 135, 0, 54, 255, 136, 0, 54, 255, 136, 0, 54, 255, 136, 0, 54, 255, 137, 0, 55, 255, 137, 0, 55, 255, 137, 0, 55, 255, 138, 0, 55, 255, 138, 0, 56, 255, 138, 0, 56, 255, 139, 0, 56, 255, 139, 0, 56, 255, 139, 0, 57, 255, 139, 0, 57, 255, 140, 0, 57, 255, 140, 0, 57, 255, 140, 0, 58, 255, 141, 0, 58, 255, 141, 0, 58, 255, 141, 0, 58, 255, 142, 0, 58, 255, 142, 0, 59, 255, 142, 0, 59, 255, 143, 0, 59, 255, 143, 0, 59, 255, 143, 0, 60, 255, 144, 0, 60, 255, 144, 0, 60, 255, 144, 0, 60, 255, 144, 0, 61, 255, 145, 0, 61, 255, 145, 0, 61, 255, 145, 0, 61, 255, 146, 0, 62, 255, 146, 0, 62, 255, 146, 0, 62, 255, 147, 0, 62, 255, 147, 0, 63, 255, 147, 0, 63, 255, 148, 0, 63, 255, 148, 0, 63, 255, 148, 0, 64, 255, 148, 0, 64, 255, 149, 0, 64, 255, 149, 0, 64, 255, 149, 0, 65, 255, 150, 0, 65, 255, 150, 0, 65, 255, 150, 0, 65, 255, 151, 0, 66, 255, 151, 0, 66, 255, 151, 0, 66, 255, 151, 0, 66, 255, 152, 0, 67, 255, 152, 0, 67, 255, 152, 0, 67, 255, 153, 0, 67, 255, 153, 0, 67, 255, 153, 0, 67, 255, 154, 0, 67, 255, 154, 0, 68, 255, 154, 0, 68, 255, 155, 0, 68, 255, 155, 0, 68, 255, 155, 0, 68, 255, 156, 0, 68, 255, 156, 1, 68, 255, 156, 1, 68, 255, 157, 1, 69, 255, 157, 1, 69, 255, 157, 1, 69, 255, 158, 1, 69, 255, 158, 1, 69, 255, 158, 1, 69, 255, 159, 1, 69, 255, 159, 1, 69, 255, 159, 1, 69, 255, 160, 1, 70, 255, 160, 2, 70, 255, 160, 2, 70, 255, 161, 2, 70, 255, 161, 2, 70, 255, 161, 2, 70, 255, 162, 2, 70, 255, 162, 2, 70, 255, 162, 2, 71, 255, 163, 2, 71, 255, 163, 2, 71, 255, 163, 2, 71, 255, 164, 3, 71, 255, 164, 3, 71, 255, 164, 3, 71, 255, 165, 3, 71, 255, 165, 3, 72, 255, 165, 3, 72, 255, 166, 3, 72, 255, 166, 3, 72, 255, 166, 3, 72, 255, 167, 3, 72, 255, 167, 4, 72, 255, 167, 4, 72, 255, 168, 4, 73, 255, 168, 4, 73, 255, 168, 4, 73, 255, 169, 4, 73, 255, 169, 4, 73, 255, 169, 4, 73, 255, 170, 4, 73, 255, 170, 5, 73, 255, 170, 5, 74, 255, 171, 5, 74, 255, 171, 5, 74, 255, 171, 5, 74, 255, 172, 5, 74, 255, 172, 5, 74, 255, 173, 5, 74, 255, 184, 9, 78, 255, 184, 9, 78, 255, 184, 9, 78, 255, 185, 10, 78, 255, 185, 10, 79, 255, 185, 10, 79, 255, 186, 10, 79, 255, 186, 10, 79, 255, 186, 10, 79, 255, 187, 10, 79, 255, 187, 10, 79, 255, 187, 11, 79, 255, 188, 11, 80, 255, 188, 11, 80, 255, 188, 11, 80, 255, 189, 11, 80, 255, 189, 11, 80, 255, 189, 11, 80, 255, 190, 11, 80, 255, 190, 12, 80, 255, 190, 12, 80, 255, 191, 12, 81, 255, 191, 12, 81, 255, 191, 12, 81, 255, 192, 12, 81, 255, 192, 12, 81, 255, 192, 13, 81, 255, 193, 13, 81, 255, 193, 13, 81, 255, 193, 13, 82, 255, 194, 13, 82, 255, 194, 13, 82, 255, 195, 13, 82, 255, 195, 13, 82, 255, 195, 14, 82, 255, 196, 14, 82, 255, 196, 14, 82, 255, 196, 14, 82, 255, 197, 14, 83, 255, 197, 14, 83, 255, 197, 14, 83, 255, 198, 15, 83, 255, 198, 15, 83, 255, 198, 15, 83, 255, 199, 15, 83, 255, 199, 15, 83, 255, 199, 15, 83, 255, 200, 15, 84, 255, 200, 15, 84, 255, 200, 16, 84, 255, 201, 16, 84, 255, 201, 16, 84, 255, 201, 16, 84, 255, 202, 16, 84, 255, 202, 16, 84, 255, 202, 16, 84, 255, 203, 16, 85, 255, 203, 17, 85, 255, 203, 17, 85, 255, 204, 17, 85, 255, 204, 17, 85, 255, 204, 17, 85, 255, 205, 17, 85, 255, 205, 17, 85, 255, 205, 18, 85, 255, 206, 18, 86, 255, 206, 18, 86, 255, 206, 18, 86, 255, 206, 18, 87, 255, 206, 18, 87, 255, 207, 18, 87, 255, 207, 18, 88, 255, 207, 18, 88, 255, 207, 18, 88, 255, 207, 18, 89, 255, 208, 18, 89, 255, 208, 19, 89, 255, 208, 19, 89, 255, 208, 19, 90, 255, 208, 19, 90, 255, 208, 19, 90, 255, 209, 19, 91, 255, 209, 19, 91, 255, 209, 19, 91, 255, 209, 19, 92, 255, 209, 19, 92, 255, 210, 20, 92, 255, 210, 20, 93, 255, 210, 20, 93, 255, 210, 20, 93, 255, 210, 20, 93, 255, 210, 20, 94, 255, 211, 20, 94, 255, 211, 20, 94, 255, 211, 20, 95, 255, 211, 21, 95, 255, 211, 21, 95, 255, 211, 21, 96, 255, 212, 21, 96, 255, 212, 21, 96, 255, 212, 21, 97, 255, 212, 21, 97, 255, 212, 21, 97, 255, 212, 21, 98, 255, 213, 22, 98, 255, 213, 22, 98, 255, 213, 22, 98, 255, 213, 22, 99, 255, 213, 22, 99, 255, 213, 22, 99, 255, 214, 22, 100, 255, 214, 23, 100, 255, 214, 23, 100, 255, 214, 23, 101, 255, 214, 23, 101, 255, 214, 23, 101, 255, 215, 23, 102, 255, 215, 23, 102, 255, 215, 23, 102, 255, 215, 24, 103, 255, 215, 24, 103, 255, 215, 24, 103, 255, 216, 24, 104, 255, 216, 24, 104, 255, 216, 24, 104, 255, 216, 24, 105, 255, 216, 25, 105, 255, 216, 25, 105, 255, 222, 30, 116, 255, 222, 30, 116, 255, 222, 30, 117, 255, 222, 30, 117, 255, 222, 30, 117, 255, 222, 30, 118, 255, 222, 30, 118, 255, 223, 31, 118, 255, 223, 31, 119, 255, 223, 31, 119, 255, 223, 31, 119, 255, 223, 31, 120, 255, 223, 31, 120, 255, 224, 32, 120, 255, 224, 32, 121, 255, 224, 32, 121, 255, 224, 32, 121, 255, 224, 32, 122, 255, 224, 32, 122, 255, 224, 33, 122, 255, 225, 33, 123, 255, 225, 33, 123, 255, 225, 33, 123, 255, 225, 33, 124, 255, 225, 33, 124, 255, 225, 34, 124, 255, 225, 34, 125, 255, 226, 34, 125, 255, 226, 34, 125, 255, 226, 34, 126, 255, 226, 34, 126, 255, 226, 35, 126, 255, 226, 35, 127, 255, 226, 35, 127, 255, 227, 35, 127, 255, 227, 35, 128, 255, 227, 35, 128, 255, 227, 36, 128, 255, 227, 36, 129, 255, 227, 36, 129, 255, 227, 36, 129, 255, 228, 36, 130, 255, 228, 36, 130, 255, 228, 37, 130, 255, 228, 37, 131, 255, 228, 37, 131, 255, 228, 37, 131, 255, 228, 37, 132, 255, 228, 38, 132, 255, 229, 38, 132, 255, 229, 38, 133, 255, 229, 38, 133, 255, 229, 38, 133, 255, 229, 38, 134, 255, 229, 39, 134, 255, 229, 39, 134, 255, 230, 39, 135, 255, 230, 39, 135, 255, 230, 39, 135, 255, 230, 40, 136, 255, 230, 40, 136, 255, 230, 40, 136, 255, 230, 40, 137, 255, 230, 40, 137, 255, 230, 41, 137, 255, 230, 41, 138, 255, 230, 42, 138, 255, 230, 42, 138, 255, 230, 43, 139, 255, 230, 43, 139, 255, 230, 44, 139, 255, 230, 44, 139, 255, 230, 45, 140, 255, 230, 45, 140, 255, 230, 46, 140, 255, 230, 46, 140, 255, 230, 47, 141, 255, 230, 48, 141, 255, 230, 48, 141, 255, 230, 48, 142, 255, 230, 49, 142, 255, 230, 49, 142, 255, 230, 50, 142, 255, 230, 50, 143, 255, 230, 51, 143, 255, 230, 51, 143, 255, 230, 52, 143, 255, 230, 52, 144, 255, 230, 53, 144, 255, 230, 53, 144, 255, 230, 54, 144, 255, 230, 54, 145, 255, 229, 54, 145, 255, 229, 55, 145, 255, 229, 55, 145, 255, 229, 56, 146, 255, 229, 56, 146, 255, 229, 57, 146, 255, 229, 57, 146, 255, 229, 57, 147, 255, 229, 58, 147, 255, 229, 58, 147, 255, 229, 59, 147, 255, 229, 59, 148, 255, 229, 59, 148, 255, 229, 60, 148, 255, 229, 60, 148, 255, 229, 61, 149, 255, 229, 61, 149, 255, 229, 61, 149, 255, 229, 62, 149, 255, 229, 62, 150, 255, 229, 63, 150, 255, 229, 63, 150, 255, 228, 63, 150, 255, 228, 64, 151, 255, 228, 64, 151, 255, 228, 64, 151, 255, 228, 65, 151, 255, 228, 65, 152, 255, 228, 66, 152, 255, 228, 66, 152, 255, 228, 66, 152, 255, 228, 67, 153, 255, 228, 67, 153, 255, 228, 67, 153, 255, 228, 68, 153, 255, 228, 68, 154, 255, 226, 80, 161, 255, 226, 81, 162, 255, 226, 81, 162, 255, 226, 81, 162, 255, 226, 82, 162, 255, 226, 82, 163, 255, 226, 82, 163, 255, 226, 83, 163, 255, 226, 83, 163, 255, 226, 84, 164, 255, 226, 84, 164, 255, 226, 84, 164, 255, 226, 85, 164, 255, 226, 85, 164, 255, 225, 85, 165, 255, 225, 86, 165, 255, 225, 86, 165, 255, 225, 86, 165, 255, 225, 86, 166, 255, 225, 87, 166, 255, 225, 87, 166, 255, 225, 87, 166, 255, 225, 88, 166, 255, 225, 88, 167, 255, 225, 88, 167, 255, 225, 89, 167, 255, 225, 89, 167, 255, 225, 89, 168, 255, 225, 90, 168, 255, 225, 90, 168, 255, 225, 90, 168, 255, 224, 91, 169, 255, 224, 91, 169, 255, 224, 91, 169, 255, 224, 92, 169, 255, 224, 92, 169, 255, 224, 92, 170, 255, 224, 93, 170, 255, 224, 93, 170, 255, 224, 93, 170, 255, 224, 93, 170, 255, 224, 94, 171, 255, 224, 94, 171, 255, 224, 94, 171, 255, 224, 95, 171, 255, 224, 95, 172, 255, 224, 95, 172, 255, 224, 96, 172, 255, 223, 96, 172, 255, 223, 96, 172, 255, 223, 96, 173, 255, 223, 97, 173, 255, 223, 97, 173, 255, 223, 97, 173, 255, 223, 98, 173, 255, 223, 98, 174, 255, 223, 98, 174, 255, 223, 98, 174, 255, 223, 99, 174, 255, 223, 99, 174, 255, 223, 99, 175, 255, 223, 100, 175, 255, 223, 100, 175, 255, 223, 100, 175, 255, 222, 101, 175, 255, 222, 101, 176, 255, 222, 101, 176, 255, 222, 102, 176, 255, 222, 102, 176, 255, 222, 102, 177, 255, 222, 103, 177, 255, 221, 103, 177, 255, 221, 103, 177, 255, 221, 104, 177, 255, 221, 104, 178, 255, 221, 104, 178, 255, 221, 105, 178, 255, 221, 105, 178, 255, 220, 105, 178, 255, 220, 106, 179, 255, 220, 106, 179, 255, 220, 106, 179, 255, 220, 107, 179, 255, 220, 107, 179, 255, 220, 107, 180, 255, 219, 108, 180, 255, 219, 108, 180, 255, 219, 108, 180, 255, 219, 109, 180, 255, 219, 109, 181, 255, 219, 109, 181, 255, 219, 110, 181, 255, 218, 110, 181, 255, 218, 110, 181, 255, 218, 111, 182, 255, 218, 111, 182, 255, 218, 111, 182, 255, 218, 112, 182, 255, 218, 112, 182, 255, 217, 112, 182, 255, 217, 112, 183, 255, 217, 113, 183, 255, 217, 113, 183, 255, 217, 113, 183, 255, 217, 114, 183, 255, 216, 114, 183, 255, 216, 114, 184, 255, 216, 115, 184, 255, 216, 115, 184, 255, 216, 115, 184, 255, 216, 116, 184, 255, 216, 116, 184, 255, 215, 116, 185, 255, 215, 116, 185, 255, 215, 117, 185, 255, 215, 117, 185, 255, 215, 117, 185, 255, 215, 118, 185, 255, 215, 118, 186, 255, 214, 118, 186, 255, 214, 119, 186, 255, 214, 119, 186, 255, 214, 119, 186, 255, 214, 119, 186, 255, 214, 120, 187, 255, 214, 120, 187, 255, 213, 120, 187, 255, 213, 121, 187, 255, 209, 130, 192, 255, 209, 131, 192, 255, 208, 131, 192, 255, 208, 131, 192, 255, 208, 131, 192, 255, 208, 132, 192, 255, 208, 132, 193, 255, 208, 132, 193, 255, 208, 133, 193, 255, 208, 133, 193, 255, 207, 133, 193, 255, 207, 133, 193, 255, 207, 134, 193, 255, 207, 134, 193, 255, 207, 134, 194, 255, 207, 135, 194, 255, 207, 135, 194, 255, 206, 135, 194, 255, 206, 135, 194, 255, 206, 136, 194, 255, 206, 136, 194, 255, 206, 136, 194, 255, 206, 137, 195, 255, 206, 137, 195, 255, 205, 137, 195, 255, 205, 137, 195, 255, 205, 138, 195, 255, 205, 138, 195, 255, 205, 138, 195, 255, 205, 138, 195, 255, 205, 139, 195, 255, 205, 139, 196, 255, 204, 139, 196, 255, 204, 139, 196, 255, 204, 140, 196, 255, 204, 140, 196, 255, 204, 140, 196, 255, 204, 141, 196, 255, 204, 141, 196, 255, 204, 141, 196, 255, 203, 141, 197, 255, 203, 142, 197, 255, 203, 142, 197, 255, 203, 142, 197, 255, 203, 142, 197, 255, 203, 143, 197, 255, 203, 143, 197, 255, 203, 143, 197, 255, 202, 143, 197, 255, 202, 144, 197, 255, 202, 144, 197, 255, 202, 144, 198, 255, 202, 144, 198, 255, 202, 145, 198, 255, 202, 145, 198, 255, 202, 145, 198, 255, 201, 145, 198, 255, 201, 146, 198, 255, 201, 146, 198, 255, 201, 146, 198, 255, 201, 146, 198, 255, 201, 147, 198, 255, 201, 147, 198, 255, 201, 147, 198, 255, 200, 148, 198, 255, 201, 148, 199, 255, 201, 148, 199, 255, 201, 148, 199, 255, 201, 148, 199, 255, 201, 149, 199, 255, 201, 149, 199, 255, 201, 149, 199, 255, 201, 149, 200, 255, 201, 150, 200, 255, 201, 150, 200, 255, 201, 150, 200, 255, 201, 150, 200, 255, 201, 151, 200, 255, 201, 151, 200, 255, 201, 151, 200, 255, 201, 151, 201, 255, 202, 152, 201, 255, 202, 152, 201, 255, 202, 152, 201, 255, 202, 152, 201, 255, 202, 152, 201, 255, 202, 153, 201, 255, 202, 153, 202, 255, 202, 153, 202, 255, 202, 153, 202, 255, 202, 154, 202, 255, 202, 154, 202, 255, 202, 154, 202, 255, 202, 154, 202, 255, 202, 155, 202, 255, 202, 155, 203, 255, 202, 155, 203, 255, 202, 155, 203, 255, 203, 155, 203, 255, 203, 156, 203, 255, 203, 156, 203, 255, 203, 156, 203, 255, 203, 156, 203, 255, 203, 157, 204, 255, 203, 157, 204, 255, 203, 157, 204, 255, 203, 157, 204, 255, 203, 158, 204, 255, 203, 158, 204, 255, 203, 158, 204, 255, 203, 158, 204, 255, 203, 159, 205, 255, 203, 159, 205, 255, 204, 159, 205, 255, 204, 159, 205, 255, 204, 159, 205, 255, 204, 160, 205, 255, 204, 160, 205, 255, 204, 160, 205, 255, 204, 160, 206, 255, 204, 161, 206, 255, 204, 161, 206, 255, 204, 161, 206, 255, 204, 161, 206, 255, 204, 162, 206, 255, 204, 162, 206, 255, 204, 162, 206, 255, 204, 162, 206, 255, 207, 170, 210, 255, 207, 170, 211, 255, 207, 170, 211, 255, 207, 171, 211, 255, 207, 171, 211, 255, 207, 171, 211, 255, 207, 171, 211, 255, 207, 171, 211, 255, 207, 172, 211, 255, 207, 172, 211, 255, 207, 172, 212, 255, 207, 172, 212, 255, 208, 173, 212, 255, 208, 173, 212, 255, 208, 173, 212, 255, 208, 173, 212, 255, 208, 174, 212, 255, 208, 174, 212, 255, 208, 174, 212, 255, 208, 174, 213, 255, 208, 174, 213, 255, 208, 175, 213, 255, 208, 175, 213, 255, 208, 175, 213, 255, 208, 175, 213, 255, 208, 176, 213, 255, 209, 176, 213, 255, 209, 176, 214, 255, 209, 176, 214, 255, 209, 177, 214, 255, 209, 177, 214, 255, 209, 177, 214, 255, 209, 177, 214, 255, 209, 177, 214, 255, 209, 178, 214, 255, 209, 178, 214, 255, 209, 178, 215, 255, 209, 178, 215, 255, 209, 179, 215, 255, 210, 179, 215, 255, 210, 179, 215, 255, 210, 179, 215, 255, 210, 180, 215, 255, 210, 180, 215, 255, 210, 180, 215, 255, 210, 180, 215, 255, 210, 180, 216, 255, 210, 181, 216, 255, 210, 181, 216, 255, 210, 181, 216, 255, 210, 181, 216, 255, 210, 182, 216, 255, 211, 182, 216, 255, 211, 182, 216, 255, 211, 182, 216, 255, 211, 182, 217, 255, 211, 183, 217, 255, 211, 183, 217, 255, 211, 183, 217, 255, 211, 183, 217, 255, 211, 184, 217, 255, 211, 184, 217, 255, 211, 184, 217, 255, 211, 184, 217, 255, 211, 185, 217, 255, 212, 185, 218, 255, 212, 185, 218, 255, 212, 185, 218, 255, 212, 186, 218, 255, 212, 186, 218, 255, 212, 186, 218, 255, 212, 186, 219, 255, 212, 187, 219, 255, 212, 187, 219, 255, 212, 187, 219, 255, 212, 187, 219, 255, 213, 188, 219, 255, 213, 188, 220, 255, 213, 188, 220, 255, 213, 188, 220, 255, 213, 189, 220, 255, 213, 189, 220, 255, 213, 189, 220, 255, 213, 189, 220, 255, 213, 190, 221, 255, 213, 190, 221, 255, 214, 190, 221, 255, 214, 190, 221, 255, 214, 191, 221, 255, 214, 191, 221, 255, 214, 191, 221, 255, 214, 191, 222, 255, 214, 192, 222, 255, 214, 192, 222, 255, 214, 192, 222, 255, 214, 192, 222, 255, 215, 193, 222, 255, 215, 193, 222, 255, 215, 193, 223, 255, 215, 193, 223, 255, 215, 194, 223, 255, 215, 194, 223, 255, 215, 194, 223, 255, 215, 194, 223, 255, 215, 195, 223, 255, 215, 195, 224, 255, 216, 195, 224, 255, 216, 195, 224, 255, 216, 196, 224, 255, 216, 196, 224, 255, 216, 196, 224, 255, 216, 196, 224, 255, 216, 197, 225, 255, 216, 197, 225, 255, 216, 197, 225, 255, 217, 197, 225, 255, 217, 198, 225, 255, 217, 198, 225, 255, 217, 198, 225, 255, 217, 198, 226, 255, 217, 199, 226, 255, 217, 199, 226, 255, 217, 199, 226, 255, 217, 199, 226, 255, 218, 200, 226, 255, 218, 200, 226, 255, 218, 200, 226, 255, 218, 200, 227, 255, 222, 209, 231, 255, 222, 209, 231, 255, 222, 209, 231, 255, 222, 209, 231, 255, 222, 210, 231, 255, 222, 210, 232, 255, 223, 210, 232, 255, 223, 210, 232, 255, 223, 211, 232, 255, 223, 211, 232, 255, 223, 211, 232, 255, 223, 211, 232, 255, 223, 212, 232, 255, 223, 212, 233, 255, 224, 212, 233, 255, 224, 212, 233, 255, 224, 213, 233, 255, 224, 213, 233, 255, 224, 213, 233, 255, 224, 213, 233, 255, 224, 214, 233, 255, 224, 214, 234, 255, 225, 214, 234, 255, 225, 214, 234, 255, 225, 215, 234, 255, 225, 215, 234, 255, 225, 215, 234, 255, 225, 215, 234, 255, 225, 216, 234, 255, 225, 216, 235, 255, 226, 216, 235, 255, 226, 216, 235, 255, 226, 217, 235, 255, 226, 217, 235, 255, 226, 217, 235, 255, 226, 217, 235, 255, 226, 218, 235, 255, 227, 218, 235, 255, 227, 218, 236, 255, 227, 218, 236, 255, 227, 219, 236, 255, 227, 219, 236, 255, 227, 219, 236, 255, 227, 219, 236, 255, 228, 220, 236, 255, 228, 220, 236, 255, 228, 220, 237, 255, 228, 220, 237, 255, 228, 221, 237, 255, 228, 221, 237, 255, 228, 221, 237, 255, 229, 221, 237, 255, 229, 222, 237, 255, 229, 222, 237, 255, 229, 222, 237, 255, 229, 222, 238, 255, 229, 223, 238, 255, 229, 223, 238, 255, 230, 223, 238, 255, 230, 223, 238, 255, 230, 224, 238, 255, 230, 224, 238, 255, 230, 224, 238, 255, 230, 224, 238, 255, 230, 225, 238, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 240, 255, 232, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 234, 228, 240, 255, 234, 228, 240, 255, 234, 228, 240, 255, 234, 228, 240, 255, 234, 228, 240, 255, 234, 228, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 235, 229, 241, 255, 235, 229, 241, 255, 235, 229, 241, 255, 235, 229, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 236, 230, 241, 255, 236, 230, 242, 255, 236, 230, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 237, 231, 242, 255, 237, 231, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 240, 236, 244, 255, 240, 236, 244, 255, 241, 236, 245, 255, 241, 236, 245, 255, 241, 236, 245, 255, 241, 236, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 242, 237, 245, 255, 242, 237, 245, 255, 242, 238, 245, 255, 242, 238, 245, 255, 242, 238, 245, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 240, 246, 255, 243, 240, 246, 255, 244, 240, 246, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 242, 247, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuRd_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 102, 0, 30, 0, 106, 0, 32, 24, 109, 0, 34, 49, 111, 0, 36, 74, 114, 0, 38, 99, 117, 0, 40, 124, 120, 0, 43, 149, 133, 0, 52, 174, 136, 0, 54, 199, 139, 0, 56, 224, 142, 0, 58, 249, 144, 0, 61, 255, 147, 0, 63, 255, 150, 0, 65, 255, 153, 0, 67, 255, 156, 0, 68, 255, 159, 1, 69, 255, 161, 2, 70, 255, 164, 3, 71, 255, 167, 4, 72, 255, 170, 5, 73, 255, 173, 5, 74, 255, 186, 10, 79, 255, 189, 11, 80, 255, 192, 12, 81, 255, 195, 13, 82, 255, 197, 14, 83, 255, 200, 15, 84, 255, 203, 16, 85, 255, 205, 17, 85, 255, 207, 18, 88, 255, 208, 19, 90, 255, 210, 20, 92, 255, 211, 20, 95, 255, 212, 21, 97, 255, 213, 22, 99, 255, 215, 23, 102, 255, 216, 24, 104, 255, 222, 30, 117, 255, 223, 31, 119, 255, 224, 32, 121, 255, 225, 33, 124, 255, 226, 34, 126, 255, 227, 36, 128, 255, 228, 37, 131, 255, 229, 38, 133, 255, 230, 39, 135, 255, 230, 40, 137, 255, 230, 44, 139, 255, 230, 47, 141, 255, 230, 51, 143, 255, 230, 53, 144, 255, 229, 56, 146, 255, 229, 59, 147, 255, 229, 61, 149, 255, 228, 63, 151, 255, 228, 66, 152, 255, 228, 68, 153, 255, 226, 82, 162, 255, 226, 84, 164, 255, 225, 86, 165, 255, 225, 88, 166, 255, 225, 90, 168, 255, 224, 91, 169, 255, 224, 93, 170, 255, 224, 95, 171, 255, 223, 96, 173, 255, 223, 98, 174, 255, 223, 100, 175, 255, 222, 101, 176, 255, 221, 103, 177, 255, 221, 105, 178, 255, 220, 107, 179, 255, 219, 108, 180, 255, 218, 110, 181, 255, 218, 112, 182, 255, 217, 113, 183, 255, 216, 115, 184, 255, 215, 116, 185, 255, 215, 118, 185, 255, 214, 119, 186, 255, 213, 121, 187, 255, 208, 131, 192, 255, 208, 133, 193, 255, 207, 134, 193, 255, 206, 135, 194, 255, 206, 137, 195, 255, 205, 138, 195, 255, 205, 139, 196, 255, 204, 140, 196, 255, 203, 141, 196, 255, 203, 142, 197, 255, 202, 144, 197, 255, 202, 145, 198, 255, 201, 146, 198, 255, 201, 147, 198, 255, 201, 148, 199, 255, 201, 149, 199, 255, 201, 150, 200, 255, 201, 151, 200, 255, 202, 152, 201, 255, 202, 153, 201, 255, 202, 153, 202, 255, 202, 154, 202, 255, 202, 155, 203, 255, 203, 156, 203, 255, 203, 157, 204, 255, 203, 158, 204, 255, 203, 159, 205, 255, 204, 160, 205, 255, 204, 160, 206, 255, 204, 161, 206, 255, 204, 162, 206, 255, 207, 170, 211, 255, 207, 171, 211, 255, 207, 172, 211, 255, 208, 173, 212, 255, 208, 173, 212, 255, 208, 174, 213, 255, 208, 175, 213, 255, 209, 176, 213, 255, 209, 176, 214, 255, 209, 177, 214, 255, 209, 178, 214, 255, 209, 179, 215, 255, 210, 179, 215, 255, 210, 180, 215, 255, 210, 181, 216, 255, 210, 181, 216, 255, 211, 182, 216, 255, 211, 183, 217, 255, 211, 183, 217, 255, 211, 184, 217, 255, 212, 185, 218, 255, 212, 186, 218, 255, 212, 186, 219, 255, 212, 187, 219, 255, 213, 188, 219, 255, 213, 188, 220, 255, 213, 189, 220, 255, 213, 190, 221, 255, 214, 190, 221, 255, 214, 191, 221, 255, 214, 192, 222, 255, 214, 192, 222, 255, 215, 193, 223, 255, 215, 194, 223, 255, 215, 194, 223, 255, 215, 195, 224, 255, 216, 196, 224, 255, 216, 196, 224, 255, 216, 197, 225, 255, 217, 197, 225, 255, 217, 198, 225, 255, 217, 199, 226, 255, 217, 199, 226, 255, 218, 200, 226, 255, 218, 200, 226, 255, 222, 209, 231, 255, 222, 209, 231, 255, 222, 210, 232, 255, 223, 210, 232, 255, 223, 211, 232, 255, 223, 211, 232, 255, 223, 212, 233, 255, 224, 213, 233, 255, 224, 213, 233, 255, 224, 214, 233, 255, 224, 214, 234, 255, 225, 215, 234, 255, 225, 215, 234, 255, 225, 215, 234, 255, 226, 216, 235, 255, 226, 216, 235, 255, 226, 217, 235, 255, 226, 217, 235, 255, 227, 218, 235, 255, 227, 218, 236, 255, 227, 219, 236, 255, 227, 219, 236, 255, 228, 220, 236, 255, 228, 220, 236, 255, 228, 220, 237, 255, 228, 221, 237, 255, 229, 221, 237, 255, 229, 222, 237, 255, 229, 222, 237, 255, 229, 222, 238, 255, 229, 223, 238, 255, 230, 223, 238, 255, 230, 224, 238, 255, 230, 224, 238, 255, 230, 224, 238, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 231, 225, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 239, 255, 232, 226, 240, 255, 232, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 227, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 233, 228, 240, 255, 234, 228, 240, 255, 234, 228, 240, 255, 234, 228, 240, 255, 234, 228, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 234, 229, 241, 255, 235, 229, 241, 255, 235, 229, 241, 255, 235, 229, 241, 255, 235, 229, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 235, 230, 241, 255, 236, 230, 241, 255, 236, 230, 241, 255, 236, 230, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 236, 231, 242, 255, 237, 231, 242, 255, 237, 231, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 237, 232, 242, 255, 240, 236, 244, 255, 240, 236, 244, 255, 240, 236, 244, 255, 241, 236, 245, 255, 241, 236, 245, 255, 241, 236, 245, 255, 241, 236, 245, 255, 241, 236, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 241, 237, 245, 255, 242, 237, 245, 255, 242, 237, 245, 255, 242, 237, 245, 255, 242, 237, 245, 255, 242, 238, 245, 255, 242, 238, 245, 255, 242, 238, 245, 255, 242, 238, 245, 255, 242, 238, 245, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 242, 238, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 239, 246, 255, 243, 240, 246, 255, 243, 240, 246, 255, 243, 240, 246, 255, 243, 240, 246, 255, 244, 240, 246, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 240, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 244, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 241, 247, 255, 245, 242, 247, 255, 245, 242, 247, 255, 245, 242, 247, 255, 245, 242, 247, 255, 245, 242, 247, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 245, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 242, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 243, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255, 246, 244, 248, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_PuRd_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
