#pragma once
#include <score/statemachine/StateMachineUtils.hpp>

#include <QApplication>
#include <QGraphicsItem>
#include <QGraphicsScene>
#include <QStateMachine>

template <typename Coordinates>
class GraphicsSceneTool
{
public:
  virtual ~GraphicsSceneTool() = default;
  void start()
  {
    if(!localSM().isRunning())
      localSM().start();
  }

  void stop()
  {
    if(localSM().isRunning())
    {
      on_cancel();
      localSM().stop();
    }
  }

  virtual void on_cancel()
  {
    localSM().postEvent(new score::Cancel_Event);
    QApplication::processEvents(QEventLoop::ExcludeUserInputEvents);
  }

  const QGraphicsScene& scene() const { return m_scene; }
  QStateMachine& localSM() { return m_localSM; }

protected:
  GraphicsSceneTool(const QGraphicsScene& scene)
      : m_scene{scene}
  {
  }

  QGraphicsItem* itemUnderMouse(const QPointF& point) const
  {
    return m_scene.itemAt(point, QTransform());
  }

private:
  const QGraphicsScene& m_scene;
  QStateMachine m_localSM;
};
