// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause

// Description
// This is a test for clipping of volume using the camera near plane when the
// camera is inside the volume. The test renders the ironProt dataset after
// changing it to have a very small spacing and dollies the camera inside the
// volume geometry.

#include "vtkColorTransferFunction.h"
#include "vtkGPUVolumeRayCastMapper.h"
#include "vtkImageChangeInformation.h"
#include "vtkInteractorStyleTrackballCamera.h"
#include "vtkNew.h"
#include "vtkOSPRayPass.h"
#include "vtkPiecewiseFunction.h"
#include "vtkRenderWindow.h"
#include "vtkRenderWindowInteractor.h"
#include "vtkRenderer.h"
#include "vtkSmartPointer.h"
#include "vtkStructuredPoints.h"
#include "vtkStructuredPointsReader.h"
#include "vtkTestUtilities.h"
#include "vtkTesting.h"
#include "vtkVolume.h"
#include "vtkVolumeProperty.h"

static const char* TestGPURayCastCameraInsideSmallSpacingLog =
  "# StreamVersion 1\n"
  "EnterEvent 188 3 0 0 0 0 0\n"
  "MouseMoveEvent 188 3 0 0 0 0 0\n"
  "MouseMoveEvent 165 67 0 0 0 0 0\n"
  "MouseMoveEvent 164 67 0 0 0 0 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelForwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelForwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelBackwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelBackwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelBackwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelBackwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelBackwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelBackwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelBackwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelBackwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 164 67 0 0 0 0 0\n"

  "MouseWheelBackwardEvent 164 67 0 0 0 1 0\n"
  "StartInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "EndInteractionEvent 164 67 0 0 0 1 0\n"
  "RenderEvent 164 67 0 0 0 1 0\n"
  "MouseMoveEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 1 0\n"
  "StartInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "EndInteractionEvent 163 66 0 0 0 1 0\n"
  "RenderEvent 163 66 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 163 66 0 0 0 0 0\n"
  "StartInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "EndInteractionEvent 163 66 0 0 0 0 0\n"
  "RenderEvent 163 66 0 0 0 0 0\n"
  "MouseMoveEvent 162 67 0 0 0 0 0\n"
  "MouseMoveEvent 163 67 0 0 0 0 0\n"
  "MouseMoveEvent 165 67 0 0 0 0 0\n"
  "MouseMoveEvent 166 68 0 0 0 0 0\n"
  "MouseMoveEvent 167 69 0 0 0 0 0\n"
  "MouseMoveEvent 168 70 0 0 0 0 0\n"
  "MouseMoveEvent 169 71 0 0 0 0 0\n"
  "MouseMoveEvent 170 72 0 0 0 0 0\n"
  "MouseMoveEvent 171 73 0 0 0 0 0\n"
  "MouseMoveEvent 172 74 0 0 0 0 0\n"
  "MouseMoveEvent 173 75 0 0 0 0 0\n"
  "MouseMoveEvent 174 76 0 0 0 0 0\n"
  "MouseMoveEvent 176 78 0 0 0 0 0\n"
  "MouseMoveEvent 177 79 0 0 0 0 0\n"
  "MouseMoveEvent 178 80 0 0 0 0 0\n"
  "MouseMoveEvent 178 81 0 0 0 0 0\n"
  "MouseMoveEvent 179 83 0 0 0 0 0\n"
  "LeftButtonPressEvent 179 83 0 0 0 0 0\n"
  "StartInteractionEvent 179 83 0 0 0 0 0\n"
  "MouseMoveEvent 178 82 0 0 0 0 0\n"
  "RenderEvent 178 82 0 0 0 0 0\n"
  "InteractionEvent 178 82 0 0 0 0 0\n"
  "MouseMoveEvent 177 81 0 0 0 0 0\n"
  "RenderEvent 177 81 0 0 0 0 0\n"
  "InteractionEvent 177 81 0 0 0 0 0\n"
  "MouseMoveEvent 175 80 0 0 0 0 0\n"
  "RenderEvent 175 80 0 0 0 0 0\n"
  "InteractionEvent 175 80 0 0 0 0 0\n"
  "MouseMoveEvent 173 78 0 0 0 0 0\n"
  "RenderEvent 173 78 0 0 0 0 0\n"
  "InteractionEvent 173 78 0 0 0 0 0\n"
  "MouseMoveEvent 169 74 0 0 0 0 0\n"
  "RenderEvent 169 74 0 0 0 0 0\n"
  "InteractionEvent 169 74 0 0 0 0 0\n"
  "MouseMoveEvent 165 70 0 0 0 0 0\n"
  "RenderEvent 165 70 0 0 0 0 0\n"
  "InteractionEvent 165 70 0 0 0 0 0\n"
  "MouseMoveEvent 159 66 0 0 0 0 0\n"
  "RenderEvent 159 66 0 0 0 0 0\n"
  "InteractionEvent 159 66 0 0 0 0 0\n"
  "MouseMoveEvent 155 63 0 0 0 0 0\n"
  "RenderEvent 155 63 0 0 0 0 0\n"
  "InteractionEvent 155 63 0 0 0 0 0\n"
  "MouseMoveEvent 153 61 0 0 0 0 0\n"
  "RenderEvent 153 61 0 0 0 0 0\n"
  "InteractionEvent 153 61 0 0 0 0 0\n"
  "MouseMoveEvent 152 60 0 0 0 0 0\n"
  "RenderEvent 152 60 0 0 0 0 0\n"
  "InteractionEvent 152 60 0 0 0 0 0\n"
  "MouseMoveEvent 151 59 0 0 0 0 0\n"
  "RenderEvent 151 59 0 0 0 0 0\n"
  "InteractionEvent 151 59 0 0 0 0 0\n"
  "MouseMoveEvent 150 58 0 0 0 0 0\n"
  "RenderEvent 150 58 0 0 0 0 0\n"
  "InteractionEvent 150 58 0 0 0 0 0\n"
  "MouseMoveEvent 149 58 0 0 0 0 0\n"
  "RenderEvent 149 58 0 0 0 0 0\n"
  "InteractionEvent 149 58 0 0 0 0 0\n"
  "MouseMoveEvent 147 57 0 0 0 0 0\n"
  "RenderEvent 147 57 0 0 0 0 0\n"
  "InteractionEvent 147 57 0 0 0 0 0\n"
  "MouseMoveEvent 145 57 0 0 0 0 0\n"
  "RenderEvent 145 57 0 0 0 0 0\n"
  "InteractionEvent 145 57 0 0 0 0 0\n"
  "MouseMoveEvent 141 57 0 0 0 0 0\n"
  "RenderEvent 141 57 0 0 0 0 0\n"
  "InteractionEvent 141 57 0 0 0 0 0\n"
  "MouseMoveEvent 136 57 0 0 0 0 0\n"
  "RenderEvent 136 57 0 0 0 0 0\n"
  "InteractionEvent 136 57 0 0 0 0 0\n"
  "MouseMoveEvent 133 57 0 0 0 0 0\n"
  "RenderEvent 133 57 0 0 0 0 0\n"
  "InteractionEvent 133 57 0 0 0 0 0\n"
  "MouseMoveEvent 130 57 0 0 0 0 0\n"
  "RenderEvent 130 57 0 0 0 0 0\n"
  "InteractionEvent 130 57 0 0 0 0 0\n"
  "MouseMoveEvent 125 56 0 0 0 0 0\n"
  "RenderEvent 125 56 0 0 0 0 0\n"
  "InteractionEvent 125 56 0 0 0 0 0\n"
  "MouseMoveEvent 121 56 0 0 0 0 0\n"
  "RenderEvent 121 56 0 0 0 0 0\n"
  "InteractionEvent 121 56 0 0 0 0 0\n"
  "MouseMoveEvent 119 56 0 0 0 0 0\n"
  "RenderEvent 119 56 0 0 0 0 0\n"
  "InteractionEvent 119 56 0 0 0 0 0\n"
  "MouseMoveEvent 116 55 0 0 0 0 0\n"
  "RenderEvent 116 55 0 0 0 0 0\n"
  "InteractionEvent 116 55 0 0 0 0 0\n"
  "MouseMoveEvent 114 54 0 0 0 0 0\n"
  "RenderEvent 114 54 0 0 0 0 0\n"
  "InteractionEvent 114 54 0 0 0 0 0\n"
  "MouseMoveEvent 113 54 0 0 0 0 0\n"
  "RenderEvent 113 54 0 0 0 0 0\n"
  "InteractionEvent 113 54 0 0 0 0 0\n"
  "MouseMoveEvent 112 54 0 0 0 0 0\n"
  "RenderEvent 112 54 0 0 0 0 0\n"
  "InteractionEvent 112 54 0 0 0 0 0\n"
  "MouseMoveEvent 108 53 0 0 0 0 0\n"
  "RenderEvent 108 53 0 0 0 0 0\n"
  "InteractionEvent 108 53 0 0 0 0 0\n"
  "MouseMoveEvent 103 53 0 0 0 0 0\n"
  "RenderEvent 103 53 0 0 0 0 0\n"
  "InteractionEvent 103 53 0 0 0 0 0\n"
  "MouseMoveEvent 99 52 0 0 0 0 0\n"
  "RenderEvent 99 52 0 0 0 0 0\n"
  "InteractionEvent 99 52 0 0 0 0 0\n"
  "MouseMoveEvent 96 52 0 0 0 0 0\n"
  "RenderEvent 96 52 0 0 0 0 0\n"
  "InteractionEvent 96 52 0 0 0 0 0\n"
  "MouseMoveEvent 95 52 0 0 0 0 0\n"
  "RenderEvent 95 52 0 0 0 0 0\n"
  "InteractionEvent 95 52 0 0 0 0 0\n"
  "LeftButtonReleaseEvent 95 52 0 0 0 0 0\n"
  "EndInteractionEvent 95 52 0 0 0 0 0\n"
  "RenderEvent 95 52 0 0 0 0 0\n"
  "MouseMoveEvent 94 52 0 0 0 0 0\n"
  "MouseMoveEvent 95 53 0 0 0 0 0\n"
  "MouseMoveEvent 98 55 0 0 0 0 0\n"
  "MouseMoveEvent 100 55 0 0 0 0 0\n"
  "MouseMoveEvent 102 56 0 0 0 0 0\n"
  "MouseMoveEvent 104 58 0 0 0 0 0\n"
  "MouseMoveEvent 106 60 0 0 0 0 0\n"
  "MouseMoveEvent 109 62 0 0 0 0 0\n"
  "MouseMoveEvent 111 63 0 0 0 0 0\n"
  "MouseMoveEvent 112 64 0 0 0 0 0\n"
  "MouseMoveEvent 113 65 0 0 0 0 0\n"
  "MouseMoveEvent 114 65 0 0 0 0 0\n"
  "MouseMoveEvent 116 66 0 0 0 0 0\n"
  "MouseMoveEvent 119 68 0 0 0 0 0\n"
  "MouseMoveEvent 121 68 0 0 0 0 0\n"
  "MouseMoveEvent 123 69 0 0 0 0 0\n"
  "MouseMoveEvent 125 70 0 0 0 0 0\n"
  "MouseMoveEvent 126 70 0 0 0 0 0\n"
  "MouseWheelForwardEvent 126 70 0 0 0 0 0\n"
  "StartInteractionEvent 126 70 0 0 0 0 0\n"
  "RenderEvent 126 70 0 0 0 0 0\n"
  "EndInteractionEvent 126 70 0 0 0 0 0\n"
  "RenderEvent 126 70 0 0 0 0 0\n"
  "MouseWheelForwardEvent 126 70 0 0 0 1 0\n"
  "StartInteractionEvent 126 70 0 0 0 1 0\n"
  "RenderEvent 126 70 0 0 0 1 0\n"
  "EndInteractionEvent 126 70 0 0 0 1 0\n"
  "RenderEvent 126 70 0 0 0 1 0\n"
  "MouseWheelForwardEvent 126 70 0 0 0 0 0\n"
  "StartInteractionEvent 126 70 0 0 0 0 0\n"
  "RenderEvent 126 70 0 0 0 0 0\n"
  "EndInteractionEvent 126 70 0 0 0 0 0\n"
  "RenderEvent 126 70 0 0 0 0 0\n"
  "MouseWheelForwardEvent 126 70 0 0 0 1 0\n"
  "StartInteractionEvent 126 70 0 0 0 1 0\n"
  "RenderEvent 126 70 0 0 0 1 0\n"
  "EndInteractionEvent 126 70 0 0 0 1 0\n"
  "RenderEvent 126 70 0 0 0 1 0\n"
  "MouseMoveEvent 128 70 0 0 0 0 0\n"
  "MouseMoveEvent 132 70 0 0 0 0 0\n"
  "MouseMoveEvent 137 70 0 0 0 0 0\n"
  "MouseMoveEvent 141 70 0 0 0 0 0\n"
  "MouseMoveEvent 143 71 0 0 0 0 0\n"
  "MouseMoveEvent 146 71 0 0 0 0 0\n"
  "MouseMoveEvent 152 71 0 0 0 0 0\n"
  "MouseMoveEvent 162 73 0 0 0 0 0\n"
  "MouseMoveEvent 174 74 0 0 0 0 0\n"
  "MouseMoveEvent 182 76 0 0 0 0 0\n"
  "MouseMoveEvent 187 78 0 0 0 0 0\n"
  "MouseMoveEvent 191 80 0 0 0 0 0\n"
  "MouseMoveEvent 195 83 0 0 0 0 0\n"
  "MouseMoveEvent 199 87 0 0 0 0 0\n"
  "MouseMoveEvent 201 91 0 0 0 0 0\n"
  "MouseMoveEvent 203 98 0 0 0 0 0\n"
  "MouseMoveEvent 205 105 0 0 0 0 0\n"
  "MouseMoveEvent 207 112 0 0 0 0 0\n"
  "MouseMoveEvent 207 119 0 0 0 0 0\n"
  "MouseMoveEvent 208 127 0 0 0 0 0\n"
  "MouseMoveEvent 208 131 0 0 0 0 0\n"
  "MouseMoveEvent 208 135 0 0 0 0 0\n"
  "MouseMoveEvent 208 139 0 0 0 0 0\n"
  "MouseMoveEvent 208 144 0 0 0 0 0\n"
  "MouseMoveEvent 208 150 0 0 0 0 0\n"
  "MouseMoveEvent 208 155 0 0 0 0 0\n"
  "MouseMoveEvent 208 163 0 0 0 0 0\n"
  "MouseMoveEvent 206 170 0 0 0 0 0\n"
  "MouseMoveEvent 202 177 0 0 0 0 0\n"
  "MouseMoveEvent 200 181 0 0 0 0 0\n"
  "MouseMoveEvent 199 185 0 0 0 0 0\n"
  "MouseMoveEvent 197 187 0 0 0 0 0\n"
  "MouseMoveEvent 197 188 0 0 0 0 0\n"
  "MouseMoveEvent 196 189 0 0 0 0 0\n"
  "MouseMoveEvent 195 190 0 0 0 0 0\n"
  "MouseMoveEvent 194 189 0 0 0 0 0\n"
  "MouseMoveEvent 194 188 0 0 0 0 0\n"
  "MouseMoveEvent 194 187 0 0 0 0 0\n"
  "MouseMoveEvent 194 186 0 0 0 0 0\n"
  "MouseMoveEvent 194 185 0 0 0 0 0\n"
  "MouseMoveEvent 194 184 0 0 0 0 0\n"
  "MouseMoveEvent 195 182 0 0 0 0 0\n"
  "MiddleButtonPressEvent 195 182 0 0 0 0 0\n"
  "StartInteractionEvent 195 182 0 0 0 0 0\n"
  "MouseMoveEvent 195 181 0 0 0 0 0\n"
  "RenderEvent 195 181 0 0 0 0 0\n"
  "InteractionEvent 195 181 0 0 0 0 0\n"
  "MouseMoveEvent 194 180 0 0 0 0 0\n"
  "RenderEvent 194 180 0 0 0 0 0\n"
  "InteractionEvent 194 180 0 0 0 0 0\n"
  "MouseMoveEvent 193 180 0 0 0 0 0\n"
  "RenderEvent 193 180 0 0 0 0 0\n"
  "InteractionEvent 193 180 0 0 0 0 0\n"
  "MouseMoveEvent 192 180 0 0 0 0 0\n"
  "RenderEvent 192 180 0 0 0 0 0\n"
  "InteractionEvent 192 180 0 0 0 0 0\n"
  "MouseMoveEvent 191 180 0 0 0 0 0\n"
  "RenderEvent 191 180 0 0 0 0 0\n"
  "InteractionEvent 191 180 0 0 0 0 0\n"
  "MouseMoveEvent 189 181 0 0 0 0 0\n"
  "RenderEvent 189 181 0 0 0 0 0\n"
  "InteractionEvent 189 181 0 0 0 0 0\n"
  "MouseMoveEvent 187 183 0 0 0 0 0\n"
  "RenderEvent 187 183 0 0 0 0 0\n"
  "InteractionEvent 187 183 0 0 0 0 0\n"
  "MouseMoveEvent 182 189 0 0 0 0 0\n"
  "RenderEvent 182 189 0 0 0 0 0\n"
  "InteractionEvent 182 189 0 0 0 0 0\n"
  "MouseMoveEvent 179 195 0 0 0 0 0\n"
  "RenderEvent 179 195 0 0 0 0 0\n"
  "InteractionEvent 179 195 0 0 0 0 0\n"
  "MouseMoveEvent 176 201 0 0 0 0 0\n"
  "RenderEvent 176 201 0 0 0 0 0\n"
  "InteractionEvent 176 201 0 0 0 0 0\n"
  "MouseMoveEvent 175 205 0 0 0 0 0\n"
  "RenderEvent 175 205 0 0 0 0 0\n"
  "InteractionEvent 175 205 0 0 0 0 0\n"
  "MouseMoveEvent 173 209 0 0 0 0 0\n"
  "RenderEvent 173 209 0 0 0 0 0\n"
  "InteractionEvent 173 209 0 0 0 0 0\n"
  "MouseMoveEvent 172 211 0 0 0 0 0\n"
  "RenderEvent 172 211 0 0 0 0 0\n"
  "InteractionEvent 172 211 0 0 0 0 0\n"
  "MouseMoveEvent 171 213 0 0 0 0 0\n"
  "RenderEvent 171 213 0 0 0 0 0\n"
  "InteractionEvent 171 213 0 0 0 0 0\n"
  "MouseMoveEvent 170 216 0 0 0 0 0\n"
  "RenderEvent 170 216 0 0 0 0 0\n"
  "InteractionEvent 170 216 0 0 0 0 0\n"
  "MouseMoveEvent 170 217 0 0 0 0 0\n"
  "RenderEvent 170 217 0 0 0 0 0\n"
  "InteractionEvent 170 217 0 0 0 0 0\n"
  "MouseMoveEvent 169 218 0 0 0 0 0\n"
  "RenderEvent 169 218 0 0 0 0 0\n"
  "InteractionEvent 169 218 0 0 0 0 0\n"
  "MouseMoveEvent 168 221 0 0 0 0 0\n"
  "RenderEvent 168 221 0 0 0 0 0\n"
  "InteractionEvent 168 221 0 0 0 0 0\n"
  "MouseMoveEvent 168 222 0 0 0 0 0\n"
  "RenderEvent 168 222 0 0 0 0 0\n"
  "InteractionEvent 168 222 0 0 0 0 0\n"
  "MouseMoveEvent 167 224 0 0 0 0 0\n"
  "RenderEvent 167 224 0 0 0 0 0\n"
  "InteractionEvent 167 224 0 0 0 0 0\n"
  "MouseMoveEvent 167 225 0 0 0 0 0\n"
  "RenderEvent 167 225 0 0 0 0 0\n"
  "InteractionEvent 167 225 0 0 0 0 0\n"
  "MouseMoveEvent 167 227 0 0 0 0 0\n"
  "RenderEvent 167 227 0 0 0 0 0\n"
  "InteractionEvent 167 227 0 0 0 0 0\n"
  "MouseMoveEvent 167 230 0 0 0 0 0\n"
  "RenderEvent 167 230 0 0 0 0 0\n"
  "InteractionEvent 167 230 0 0 0 0 0\n"
  "MouseMoveEvent 167 232 0 0 0 0 0\n"
  "RenderEvent 167 232 0 0 0 0 0\n"
  "InteractionEvent 167 232 0 0 0 0 0\n"
  "MouseMoveEvent 166 236 0 0 0 0 0\n"
  "RenderEvent 166 236 0 0 0 0 0\n"
  "InteractionEvent 166 236 0 0 0 0 0\n"
  "MouseMoveEvent 166 239 0 0 0 0 0\n"
  "RenderEvent 166 239 0 0 0 0 0\n"
  "InteractionEvent 166 239 0 0 0 0 0\n"
  "MouseMoveEvent 166 243 0 0 0 0 0\n"
  "RenderEvent 166 243 0 0 0 0 0\n"
  "InteractionEvent 166 243 0 0 0 0 0\n"
  "MouseMoveEvent 166 245 0 0 0 0 0\n"
  "RenderEvent 166 245 0 0 0 0 0\n"
  "InteractionEvent 166 245 0 0 0 0 0\n"
  "MouseMoveEvent 166 250 0 0 0 0 0\n"
  "RenderEvent 166 250 0 0 0 0 0\n"
  "InteractionEvent 166 250 0 0 0 0 0\n"
  "MouseMoveEvent 166 253 0 0 0 0 0\n"
  "RenderEvent 166 253 0 0 0 0 0\n"
  "InteractionEvent 166 253 0 0 0 0 0\n"
  "MouseMoveEvent 166 255 0 0 0 0 0\n"
  "RenderEvent 166 255 0 0 0 0 0\n"
  "InteractionEvent 166 255 0 0 0 0 0\n"
  "MouseMoveEvent 166 259 0 0 0 0 0\n"
  "RenderEvent 166 259 0 0 0 0 0\n"
  "InteractionEvent 166 259 0 0 0 0 0\n"
  "MouseMoveEvent 166 261 0 0 0 0 0\n"
  "RenderEvent 166 261 0 0 0 0 0\n"
  "InteractionEvent 166 261 0 0 0 0 0\n"
  "MouseMoveEvent 166 262 0 0 0 0 0\n"
  "RenderEvent 166 262 0 0 0 0 0\n"
  "InteractionEvent 166 262 0 0 0 0 0\n"
  "MouseMoveEvent 166 263 0 0 0 0 0\n"
  "RenderEvent 166 263 0 0 0 0 0\n"
  "InteractionEvent 166 263 0 0 0 0 0\n"
  "MouseMoveEvent 166 266 0 0 0 0 0\n"
  "RenderEvent 166 266 0 0 0 0 0\n"
  "InteractionEvent 166 266 0 0 0 0 0\n"
  "MouseMoveEvent 166 267 0 0 0 0 0\n"
  "RenderEvent 166 267 0 0 0 0 0\n"
  "InteractionEvent 166 267 0 0 0 0 0\n"
  "MouseMoveEvent 166 268 0 0 0 0 0\n"
  "RenderEvent 166 268 0 0 0 0 0\n"
  "InteractionEvent 166 268 0 0 0 0 0\n"
  "MouseMoveEvent 167 269 0 0 0 0 0\n"
  "RenderEvent 167 269 0 0 0 0 0\n"
  "InteractionEvent 167 269 0 0 0 0 0\n"
  "MiddleButtonReleaseEvent 167 269 0 0 0 0 0\n"
  "EndInteractionEvent 167 269 0 0 0 0 0\n"
  "RenderEvent 167 269 0 0 0 0 0\n"
  "MouseMoveEvent 167 267 0 0 0 0 0\n"
  "MouseMoveEvent 167 265 0 0 0 0 0\n"
  "MouseMoveEvent 165 261 0 0 0 0 0\n"
  "MouseMoveEvent 165 258 0 0 0 0 0\n"
  "MouseMoveEvent 165 254 0 0 0 0 0\n"
  "MouseMoveEvent 165 247 0 0 0 0 0\n"
  "MouseMoveEvent 165 238 0 0 0 0 0\n"
  "MouseMoveEvent 165 227 0 0 0 0 0\n"
  "MouseMoveEvent 165 215 0 0 0 0 0\n"
  "MouseMoveEvent 165 206 0 0 0 0 0\n"
  "MouseMoveEvent 165 196 0 0 0 0 0\n"
  "MouseMoveEvent 165 188 0 0 0 0 0\n"
  "MouseMoveEvent 168 180 0 0 0 0 0\n"
  "MouseMoveEvent 170 172 0 0 0 0 0\n"
  "MouseMoveEvent 170 164 0 0 0 0 0\n"
  "MouseMoveEvent 173 156 0 0 0 0 0\n"
  "MouseMoveEvent 175 148 0 0 0 0 0\n"
  "MouseMoveEvent 177 142 0 0 0 0 0\n"
  "MouseMoveEvent 178 136 0 0 0 0 0\n"
  "MouseMoveEvent 180 130 0 0 0 0 0\n"
  "MouseMoveEvent 180 125 0 0 0 0 0\n"
  "MouseWheelForwardEvent 180 125 0 0 0 0 0\n"
  "StartInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "EndInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "MouseWheelForwardEvent 180 125 0 0 0 1 0\n"
  "StartInteractionEvent 180 125 0 0 0 1 0\n"
  "RenderEvent 180 125 0 0 0 1 0\n"
  "EndInteractionEvent 180 125 0 0 0 1 0\n"
  "RenderEvent 180 125 0 0 0 1 0\n"
  "MouseWheelForwardEvent 180 125 0 0 0 0 0\n"
  "StartInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "EndInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "MouseWheelForwardEvent 180 125 0 0 0 1 0\n"
  "StartInteractionEvent 180 125 0 0 0 1 0\n"
  "RenderEvent 180 125 0 0 0 1 0\n"
  "EndInteractionEvent 180 125 0 0 0 1 0\n"
  "RenderEvent 180 125 0 0 0 1 0\n"
  "MouseWheelForwardEvent 180 125 0 0 0 0 0\n"
  "StartInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "EndInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "MouseWheelForwardEvent 180 125 0 0 0 0 0\n"
  "StartInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "EndInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "MouseWheelForwardEvent 180 125 0 0 0 1 0\n"
  "StartInteractionEvent 180 125 0 0 0 1 0\n"
  "RenderEvent 180 125 0 0 0 1 0\n"
  "EndInteractionEvent 180 125 0 0 0 1 0\n"
  "RenderEvent 180 125 0 0 0 1 0\n"
  "MouseWheelForwardEvent 180 125 0 0 0 0 0\n"
  "StartInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "EndInteractionEvent 180 125 0 0 0 0 0\n"
  "RenderEvent 180 125 0 0 0 0 0\n"
  "MouseMoveEvent 181 124 0 0 0 0 0\n"
  "MouseMoveEvent 185 124 0 0 0 0 0\n"
  "MouseMoveEvent 195 124 0 0 0 0 0\n"
  "MouseMoveEvent 207 124 0 0 0 0 0\n"
  "MouseMoveEvent 217 124 0 0 0 0 0\n"
  "MouseMoveEvent 228 124 0 0 0 0 0\n"
  "MouseMoveEvent 237 124 0 0 0 0 0\n"
  "MouseMoveEvent 249 124 0 0 0 0 0\n"
  "MouseMoveEvent 260 124 0 0 0 0 0\n"
  "MouseMoveEvent 270 126 0 0 0 0 0\n"
  "MouseMoveEvent 272 126 0 0 0 0 0\n"
  "MouseMoveEvent 273 126 0 0 0 0 0\n"
  "MouseMoveEvent 274 127 0 0 0 0 0\n"
  "MouseMoveEvent 275 127 0 0 0 0 0\n"
  "MouseMoveEvent 276 128 0 0 0 0 0\n"
  "MouseMoveEvent 277 129 0 0 0 0 0\n"
  "LeftButtonPressEvent 277 129 0 0 0 0 0\n"
  "StartInteractionEvent 277 129 0 0 0 0 0\n"
  "MouseMoveEvent 276 130 0 0 0 0 0\n"
  "RenderEvent 276 130 0 0 0 0 0\n"
  "InteractionEvent 276 130 0 0 0 0 0\n"
  "MouseMoveEvent 275 130 0 0 0 0 0\n"
  "RenderEvent 275 130 0 0 0 0 0\n"
  "InteractionEvent 275 130 0 0 0 0 0\n"
  "MouseMoveEvent 273 130 0 0 0 0 0\n"
  "RenderEvent 273 130 0 0 0 0 0\n"
  "InteractionEvent 273 130 0 0 0 0 0\n"
  "MouseMoveEvent 272 130 0 0 0 0 0\n"
  "RenderEvent 272 130 0 0 0 0 0\n"
  "InteractionEvent 272 130 0 0 0 0 0\n"
  "MouseMoveEvent 271 130 0 0 0 0 0\n"
  "RenderEvent 271 130 0 0 0 0 0\n"
  "InteractionEvent 271 130 0 0 0 0 0\n"
  "MouseMoveEvent 270 130 0 0 0 0 0\n"
  "RenderEvent 270 130 0 0 0 0 0\n"
  "InteractionEvent 270 130 0 0 0 0 0\n"
  "MouseMoveEvent 269 130 0 0 0 0 0\n"
  "RenderEvent 269 130 0 0 0 0 0\n"
  "InteractionEvent 269 130 0 0 0 0 0\n"
  "MouseMoveEvent 267 130 0 0 0 0 0\n"
  "RenderEvent 267 130 0 0 0 0 0\n"
  "InteractionEvent 267 130 0 0 0 0 0\n"
  "MouseMoveEvent 266 130 0 0 0 0 0\n"
  "RenderEvent 266 130 0 0 0 0 0\n"
  "InteractionEvent 266 130 0 0 0 0 0\n"
  "MouseMoveEvent 265 130 0 0 0 0 0\n"
  "RenderEvent 265 130 0 0 0 0 0\n"
  "InteractionEvent 265 130 0 0 0 0 0\n"
  "MouseMoveEvent 264 130 0 0 0 0 0\n"
  "RenderEvent 264 130 0 0 0 0 0\n"
  "InteractionEvent 264 130 0 0 0 0 0\n"
  "MouseMoveEvent 263 130 0 0 0 0 0\n"
  "RenderEvent 263 130 0 0 0 0 0\n"
  "InteractionEvent 263 130 0 0 0 0 0\n"
  "MouseMoveEvent 261 130 0 0 0 0 0\n"
  "RenderEvent 261 130 0 0 0 0 0\n"
  "InteractionEvent 261 130 0 0 0 0 0\n"
  "MouseMoveEvent 260 130 0 0 0 0 0\n"
  "RenderEvent 260 130 0 0 0 0 0\n"
  "InteractionEvent 260 130 0 0 0 0 0\n"
  "MouseMoveEvent 259 130 0 0 0 0 0\n"
  "RenderEvent 259 130 0 0 0 0 0\n"
  "InteractionEvent 259 130 0 0 0 0 0\n"
  "MouseMoveEvent 258 130 0 0 0 0 0\n"
  "RenderEvent 258 130 0 0 0 0 0\n"
  "InteractionEvent 258 130 0 0 0 0 0\n"
  "MouseMoveEvent 256 130 0 0 0 0 0\n"
  "RenderEvent 256 130 0 0 0 0 0\n"
  "InteractionEvent 256 130 0 0 0 0 0\n"
  "MouseMoveEvent 255 130 0 0 0 0 0\n"
  "RenderEvent 255 130 0 0 0 0 0\n"
  "InteractionEvent 255 130 0 0 0 0 0\n"
  "MouseMoveEvent 254 130 0 0 0 0 0\n"
  "RenderEvent 254 130 0 0 0 0 0\n"
  "InteractionEvent 254 130 0 0 0 0 0\n"
  "MouseMoveEvent 251 130 0 0 0 0 0\n"
  "RenderEvent 251 130 0 0 0 0 0\n"
  "InteractionEvent 251 130 0 0 0 0 0\n"
  "MouseMoveEvent 248 130 0 0 0 0 0\n"
  "RenderEvent 248 130 0 0 0 0 0\n"
  "InteractionEvent 248 130 0 0 0 0 0\n"
  "MouseMoveEvent 245 130 0 0 0 0 0\n"
  "RenderEvent 245 130 0 0 0 0 0\n"
  "InteractionEvent 245 130 0 0 0 0 0\n"
  "MouseMoveEvent 244 130 0 0 0 0 0\n"
  "RenderEvent 244 130 0 0 0 0 0\n"
  "InteractionEvent 244 130 0 0 0 0 0\n"
  "MouseMoveEvent 245 130 0 0 0 0 0\n"
  "RenderEvent 245 130 0 0 0 0 0\n"
  "InteractionEvent 245 130 0 0 0 0 0\n"
  "MouseMoveEvent 247 130 0 0 0 0 0\n"
  "RenderEvent 247 130 0 0 0 0 0\n"
  "InteractionEvent 247 130 0 0 0 0 0\n"
  "MouseMoveEvent 248 130 0 0 0 0 0\n"
  "RenderEvent 248 130 0 0 0 0 0\n"
  "InteractionEvent 248 130 0 0 0 0 0\n"
  "MouseMoveEvent 250 130 0 0 0 0 0\n"
  "RenderEvent 250 130 0 0 0 0 0\n"
  "InteractionEvent 250 130 0 0 0 0 0\n"
  "MouseMoveEvent 253 130 0 0 0 0 0\n"
  "RenderEvent 253 130 0 0 0 0 0\n"
  "InteractionEvent 253 130 0 0 0 0 0\n"
  "MouseMoveEvent 257 130 0 0 0 0 0\n"
  "RenderEvent 257 130 0 0 0 0 0\n"
  "InteractionEvent 257 130 0 0 0 0 0\n"
  "MouseMoveEvent 258 130 0 0 0 0 0\n"
  "RenderEvent 258 130 0 0 0 0 0\n"
  "InteractionEvent 258 130 0 0 0 0 0\n"
  "MouseMoveEvent 260 130 0 0 0 0 0\n"
  "RenderEvent 260 130 0 0 0 0 0\n"
  "InteractionEvent 260 130 0 0 0 0 0\n"
  "MouseMoveEvent 261 130 0 0 0 0 0\n"
  "RenderEvent 261 130 0 0 0 0 0\n"
  "InteractionEvent 261 130 0 0 0 0 0\n"
  "MouseMoveEvent 262 130 0 0 0 0 0\n"
  "RenderEvent 262 130 0 0 0 0 0\n"
  "InteractionEvent 262 130 0 0 0 0 0\n"
  "MouseMoveEvent 263 130 0 0 0 0 0\n"
  "RenderEvent 263 130 0 0 0 0 0\n"
  "InteractionEvent 263 130 0 0 0 0 0\n"
  "MouseMoveEvent 266 130 0 0 0 0 0\n"
  "RenderEvent 266 130 0 0 0 0 0\n"
  "InteractionEvent 266 130 0 0 0 0 0\n"
  "MouseMoveEvent 269 130 0 0 0 0 0\n"
  "RenderEvent 269 130 0 0 0 0 0\n"
  "InteractionEvent 269 130 0 0 0 0 0\n"
  "MouseMoveEvent 271 130 0 0 0 0 0\n"
  "RenderEvent 271 130 0 0 0 0 0\n"
  "InteractionEvent 271 130 0 0 0 0 0\n"
  "MouseMoveEvent 275 130 0 0 0 0 0\n"
  "RenderEvent 275 130 0 0 0 0 0\n"
  "InteractionEvent 275 130 0 0 0 0 0\n"
  "MouseMoveEvent 276 130 0 0 0 0 0\n"
  "RenderEvent 276 130 0 0 0 0 0\n"
  "InteractionEvent 276 130 0 0 0 0 0\n"
  "MouseMoveEvent 277 130 0 0 0 0 0\n"
  "RenderEvent 277 130 0 0 0 0 0\n"
  "InteractionEvent 277 130 0 0 0 0 0\n"
  "MouseMoveEvent 278 130 0 0 0 0 0\n"
  "RenderEvent 278 130 0 0 0 0 0\n"
  "InteractionEvent 278 130 0 0 0 0 0\n"
  "MouseMoveEvent 279 130 0 0 0 0 0\n"
  "RenderEvent 279 130 0 0 0 0 0\n"
  "InteractionEvent 279 130 0 0 0 0 0\n"
  "MouseMoveEvent 280 130 0 0 0 0 0\n"
  "RenderEvent 280 130 0 0 0 0 0\n"
  "InteractionEvent 280 130 0 0 0 0 0\n"
  "MouseMoveEvent 282 130 0 0 0 0 0\n"
  "RenderEvent 282 130 0 0 0 0 0\n"
  "InteractionEvent 282 130 0 0 0 0 0\n"
  "MouseMoveEvent 283 130 0 0 0 0 0\n"
  "RenderEvent 283 130 0 0 0 0 0\n"
  "InteractionEvent 283 130 0 0 0 0 0\n"
  "MouseMoveEvent 284 130 0 0 0 0 0\n"
  "RenderEvent 284 130 0 0 0 0 0\n"
  "InteractionEvent 284 130 0 0 0 0 0\n"
  "MouseMoveEvent 285 130 0 0 0 0 0\n"
  "RenderEvent 285 130 0 0 0 0 0\n"
  "InteractionEvent 285 130 0 0 0 0 0\n"
  "MouseMoveEvent 286 130 0 0 0 0 0\n"
  "RenderEvent 286 130 0 0 0 0 0\n"
  "InteractionEvent 286 130 0 0 0 0 0\n"
  "MouseMoveEvent 287 130 0 0 0 0 0\n"
  "RenderEvent 287 130 0 0 0 0 0\n"
  "InteractionEvent 287 130 0 0 0 0 0\n"
  "MouseMoveEvent 289 130 0 0 0 0 0\n"
  "RenderEvent 289 130 0 0 0 0 0\n"
  "InteractionEvent 289 130 0 0 0 0 0\n"
  "MouseMoveEvent 291 130 0 0 0 0 0\n"
  "RenderEvent 291 130 0 0 0 0 0\n"
  "InteractionEvent 291 130 0 0 0 0 0\n"
  "MouseMoveEvent 293 130 0 0 0 0 0\n"
  "RenderEvent 293 130 0 0 0 0 0\n"
  "InteractionEvent 293 130 0 0 0 0 0\n"
  "MouseMoveEvent 296 130 0 0 0 0 0\n"
  "RenderEvent 296 130 0 0 0 0 0\n"
  "InteractionEvent 296 130 0 0 0 0 0\n"
  "MouseMoveEvent 298 130 0 0 0 0 0\n"
  "RenderEvent 298 130 0 0 0 0 0\n"
  "InteractionEvent 298 130 0 0 0 0 0\n"
  "MouseMoveEvent 300 130 0 0 0 0 0\n"
  "RenderEvent 300 130 0 0 0 0 0\n"
  "InteractionEvent 300 130 0 0 0 0 0\n"
  "LeaveEvent 301 130 0 0 0 0 0\n"
  "MouseMoveEvent 301 130 0 0 0 0 0\n"
  "RenderEvent 301 130 0 0 0 0 0\n"
  "InteractionEvent 301 130 0 0 0 0 0\n"
  "MouseMoveEvent 303 130 0 0 0 0 0\n"
  "RenderEvent 303 130 0 0 0 0 0\n"
  "InteractionEvent 303 130 0 0 0 0 0\n"
  "MouseMoveEvent 304 130 0 0 0 0 0\n"
  "RenderEvent 304 130 0 0 0 0 0\n"
  "InteractionEvent 304 130 0 0 0 0 0\n"
  "LeftButtonReleaseEvent 304 130 0 0 0 0 0\n"
  "EndInteractionEvent 304 130 0 0 0 0 0\n"
  "RenderEvent 304 130 0 0 0 0 0\n"
  "LeaveEvent 304 130 0 0 0 0 0\n"
  "EnterEvent 300 124 0 0 0 0 0\n"
  "MouseMoveEvent 300 124 0 0 0 0 0\n"
  "MouseMoveEvent 297 121 0 0 0 0 0\n"
  "MouseMoveEvent 294 118 0 0 0 0 0\n"
  "MouseMoveEvent 292 116 0 0 0 0 0\n"
  "MouseMoveEvent 290 114 0 0 0 0 0\n"
  "MouseMoveEvent 287 111 0 0 0 0 0\n"
  "MouseMoveEvent 284 108 0 0 0 0 0\n"
  "MouseMoveEvent 282 106 0 0 0 0 0\n"
  "MouseMoveEvent 280 104 0 0 0 0 0\n"
  "MouseMoveEvent 279 103 0 0 0 0 0\n"
  "MouseMoveEvent 278 102 0 0 0 0 0\n"
  "MouseMoveEvent 277 101 0 0 0 0 0\n"
  "MouseMoveEvent 276 100 0 0 0 0 0\n"
  "MouseMoveEvent 275 99 0 0 0 0 0\n"
  "MouseMoveEvent 274 98 0 0 0 0 0\n"
  "MouseMoveEvent 273 97 0 0 0 0 0\n"
  "MouseMoveEvent 272 96 0 0 0 0 0\n"
  "MouseMoveEvent 271 95 0 0 0 0 0\n"
  "MouseMoveEvent 270 94 0 0 0 0 0\n"
  "MouseMoveEvent 268 93 0 0 0 0 0\n"
  "MouseMoveEvent 265 91 0 0 0 0 0\n"
  "MouseMoveEvent 263 90 0 0 0 0 0\n"
  "MouseMoveEvent 261 89 0 0 0 0 0\n"
  "MouseMoveEvent 258 88 0 0 0 0 0\n"
  "MouseMoveEvent 255 88 0 0 0 0 0\n"
  "MouseMoveEvent 252 88 0 0 0 0 0\n"
  "MouseMoveEvent 249 87 0 0 0 0 0\n"
  "MouseMoveEvent 247 87 0 0 0 0 0\n"
  "MouseMoveEvent 245 87 0 0 0 0 0\n"
  "MouseMoveEvent 244 87 0 0 0 0 0\n"
  "MouseMoveEvent 243 87 0 0 0 0 0\n"
  "MouseMoveEvent 242 87 0 0 0 0 0\n"
  "MouseMoveEvent 240 86 0 0 0 0 0\n"
  "MouseMoveEvent 237 86 0 0 0 0 0\n"
  "MouseMoveEvent 236 86 0 0 0 0 0\n"
  "MouseMoveEvent 234 86 0 0 0 0 0\n"
  "MouseMoveEvent 232 86 0 0 0 0 0\n"
  "MouseMoveEvent 229 86 0 0 0 0 0\n"
  "MouseMoveEvent 227 86 0 0 0 0 0\n"
  "MouseMoveEvent 226 86 0 0 0 0 0\n"
  "MouseMoveEvent 225 86 0 0 0 0 0\n"
  "MouseMoveEvent 224 87 0 0 0 0 0\n"
  "MouseMoveEvent 224 88 0 0 0 0 0\n"
  "MouseMoveEvent 224 89 0 0 0 0 0\n"
  "MouseMoveEvent 224 90 0 0 0 0 0\n"
  "MouseWheelForwardEvent 224 90 0 0 0 0 0\n"
  "StartInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "EndInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 224 90 0 0 0 0 0\n"
  "StartInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "EndInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 224 90 0 0 0 1 0\n"
  "StartInteractionEvent 224 90 0 0 0 1 0\n"
  "RenderEvent 224 90 0 0 0 1 0\n"
  "EndInteractionEvent 224 90 0 0 0 1 0\n"
  "RenderEvent 224 90 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 224 90 0 0 0 0 0\n"
  "StartInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "EndInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 224 90 0 0 0 0 0\n"
  "StartInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "EndInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "MouseWheelBackwardEvent 224 90 0 0 0 1 0\n"
  "StartInteractionEvent 224 90 0 0 0 1 0\n"
  "RenderEvent 224 90 0 0 0 1 0\n"
  "EndInteractionEvent 224 90 0 0 0 1 0\n"
  "RenderEvent 224 90 0 0 0 1 0\n"
  "MouseWheelBackwardEvent 224 90 0 0 0 0 0\n"
  "StartInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "EndInteractionEvent 224 90 0 0 0 0 0\n"
  "RenderEvent 224 90 0 0 0 0 0\n"
  "MouseMoveEvent 223 89 0 0 0 0 0\n"
  "MouseMoveEvent 222 89 0 0 0 0 0\n"
  "MouseMoveEvent 220 88 0 0 0 0 0\n"
  "MouseMoveEvent 219 88 0 0 0 0 0\n"
  "MouseMoveEvent 216 88 0 0 0 0 0\n"
  "MouseMoveEvent 213 88 0 0 0 0 0\n"
  "MouseMoveEvent 209 88 0 0 0 0 0\n"
  "MouseMoveEvent 202 88 0 0 0 0 0\n"
  "MouseMoveEvent 195 88 0 0 0 0 0\n"
  "MouseMoveEvent 186 88 0 0 0 0 0\n"
  "MouseMoveEvent 176 88 0 0 0 0 0\n"
  "MouseMoveEvent 169 88 0 0 0 0 0\n"
  "MouseMoveEvent 165 88 0 0 0 0 0\n"
  "MouseMoveEvent 162 88 0 0 0 0 0\n"
  "MouseMoveEvent 159 88 0 0 0 0 0\n"
  "MouseMoveEvent 158 88 0 0 0 0 0\n"
  "MouseMoveEvent 157 88 0 0 0 0 0\n"
  "MouseMoveEvent 155 88 0 0 0 0 0\n"
  "MouseMoveEvent 154 88 0 0 0 0 0\n"
  "MouseMoveEvent 153 88 0 0 0 0 0\n"
  "MouseMoveEvent 152 88 0 0 0 0 0\n"
  "MouseMoveEvent 151 88 0 0 0 0 0\n"
  "MouseMoveEvent 150 88 0 0 0 0 0\n"
  "MouseMoveEvent 148 88 0 0 0 0 0\n"
  "MouseMoveEvent 147 88 0 0 0 0 0\n"
  "MouseMoveEvent 146 88 0 0 0 0 0\n"
  "MouseMoveEvent 145 88 0 0 0 0 0\n"
  "MouseMoveEvent 144 88 0 0 0 0 0\n"
  "MouseMoveEvent 143 88 0 0 0 0 0\n"
  "MouseMoveEvent 142 88 0 0 0 0 0\n"
  "MouseMoveEvent 141 88 0 0 0 0 0\n"
  "MouseMoveEvent 140 88 0 0 0 0 0\n"
  "MouseMoveEvent 141 88 0 0 0 0 0\n"
  "MouseMoveEvent 142 88 0 0 0 0 0\n"
  "MouseMoveEvent 144 90 0 0 0 0 0\n"
  "MouseMoveEvent 144 92 0 0 0 0 0\n"
  "MouseMoveEvent 145 94 0 0 0 0 0\n"
  "MouseMoveEvent 145 96 0 0 0 0 0\n"
  "MouseMoveEvent 145 98 0 0 0 0 0\n"
  "MouseMoveEvent 145 100 0 0 0 0 0\n"
  "MouseMoveEvent 145 103 0 0 0 0 0\n"
  "MouseMoveEvent 145 105 0 0 0 0 0\n"
  "MouseMoveEvent 145 109 0 0 0 0 0\n"
  "MouseMoveEvent 145 112 0 0 0 0 0\n"
  "MouseMoveEvent 144 115 0 0 0 0 0\n"
  "MouseMoveEvent 144 118 0 0 0 0 0\n"
  "MouseMoveEvent 144 122 0 0 0 0 0\n"
  "MouseMoveEvent 145 125 0 0 0 0 0\n"
  "MouseMoveEvent 146 129 0 0 0 0 0\n"
  "MouseMoveEvent 148 133 0 0 0 0 0\n"
  "MouseMoveEvent 149 138 0 0 0 0 0\n"
  "MouseMoveEvent 152 145 0 0 0 0 0\n"
  "MouseMoveEvent 156 152 0 0 0 0 0\n"
  "MouseMoveEvent 162 159 0 0 0 0 0\n"
  "MouseMoveEvent 168 168 0 0 0 0 0\n"
  "MouseMoveEvent 172 174 0 0 0 0 0\n"
  "MouseMoveEvent 176 182 0 0 0 0 0\n"
  "MouseMoveEvent 181 190 0 0 0 0 0\n"
  "MouseMoveEvent 185 198 0 0 0 0 0\n"
  "MouseMoveEvent 189 202 0 0 0 0 0\n"
  "MouseMoveEvent 194 206 0 0 0 0 0\n"
  "MouseMoveEvent 198 211 0 0 0 0 0\n"
  "MouseMoveEvent 202 212 0 0 0 0 0\n"
  "MouseMoveEvent 203 214 0 0 0 0 0\n"
  "MouseMoveEvent 205 215 0 0 0 0 0\n"
  "MouseMoveEvent 206 215 0 0 0 0 0\n"
  "MouseMoveEvent 208 215 0 0 0 0 0\n"
  "MouseMoveEvent 210 215 0 0 0 0 0\n"
  "MouseMoveEvent 212 215 0 0 0 0 0\n"
  "MouseMoveEvent 215 215 0 0 0 0 0\n"
  "MouseMoveEvent 217 215 0 0 0 0 0\n"
  "MouseMoveEvent 220 215 0 0 0 0 0\n"
  "MouseMoveEvent 225 215 0 0 0 0 0\n"
  "MouseMoveEvent 231 215 0 0 0 0 0\n"
  "MouseMoveEvent 239 215 0 0 0 0 0\n"
  "MouseMoveEvent 250 215 0 0 0 0 0\n"
  "MouseMoveEvent 262 215 0 0 0 0 0\n"
  "MouseMoveEvent 273 212 0 0 0 0 0\n"
  "MouseMoveEvent 284 206 0 0 0 0 0\n"
  "MouseMoveEvent 296 198 0 0 0 0 0\n"
  "LeaveEvent 304 189 0 0 0 0 0\n"
  "EnterEvent 296 131 0 0 0 0 0\n"
  "MouseMoveEvent 296 131 0 0 0 0 0\n"
  "MouseMoveEvent 291 133 0 0 0 0 0\n"
  "MouseMoveEvent 286 135 0 0 0 0 0\n"
  "MouseMoveEvent 280 139 0 0 0 0 0\n"
  "MouseMoveEvent 276 143 0 0 0 0 0\n"
  "MouseMoveEvent 275 144 0 0 0 0 0\n"
  "MouseMoveEvent 274 145 0 0 0 0 0\n"
  "MouseMoveEvent 273 146 0 0 0 0 0\n"
  "MouseMoveEvent 271 147 0 0 0 0 0\n"
  "MouseMoveEvent 270 148 0 0 0 0 0\n"
  "MouseMoveEvent 269 148 0 0 0 0 0\n"
  "MouseMoveEvent 268 148 0 0 0 0 0\n"
  "MouseMoveEvent 267 148 0 0 0 0 0\n"
  "MouseMoveEvent 266 148 0 0 0 0 0\n"
  "MouseMoveEvent 265 148 0 0 0 0 0\n"
  "MouseMoveEvent 264 148 0 0 0 0 0\n"
  "MouseMoveEvent 263 148 0 0 0 0 0\n"
  "MouseMoveEvent 261 148 0 0 0 0 0\n"
  "MouseMoveEvent 260 148 0 0 0 0 0\n"
  "MouseMoveEvent 259 148 0 0 0 0 0\n"
  "MouseMoveEvent 257 148 0 0 0 0 0\n"
  "MouseMoveEvent 255 147 0 0 0 0 0\n"
  "MouseMoveEvent 254 147 0 0 0 0 0\n"
  "MouseMoveEvent 253 146 0 0 0 0 0\n"
  "MouseMoveEvent 252 146 0 0 0 0 0\n"
  "MouseMoveEvent 250 146 0 0 0 0 0\n"
  "MouseMoveEvent 248 146 0 0 0 0 0\n"
  "MouseMoveEvent 246 146 0 0 0 0 0\n"
  "MouseMoveEvent 244 146 0 0 0 0 0\n"
  "MouseMoveEvent 242 146 0 0 0 0 0\n"
  "MouseMoveEvent 240 146 0 0 0 0 0\n"
  "MouseMoveEvent 238 146 0 0 0 0 0\n"
  "MouseMoveEvent 235 146 0 0 0 0 0\n"
  "MouseMoveEvent 233 146 0 0 0 0 0\n"
  "MouseMoveEvent 229 147 0 0 0 0 0\n"
  "MouseMoveEvent 228 148 0 0 0 0 0\n"
  "MouseMoveEvent 225 149 0 0 0 0 0\n"
  "MouseMoveEvent 222 151 0 0 0 0 0\n"
  "MouseMoveEvent 219 154 0 0 0 0 0\n"
  "MouseMoveEvent 217 155 0 0 0 0 0\n"
  "MouseMoveEvent 214 158 0 0 0 0 0\n"
  "MouseMoveEvent 210 165 0 0 0 0 0\n"
  "MouseMoveEvent 205 172 0 0 0 0 0\n"
  "MouseMoveEvent 200 179 0 0 0 0 0\n"
  "MouseMoveEvent 194 186 0 0 0 0 0\n"
  "MouseMoveEvent 190 191 0 0 0 0 0\n"
  "MouseMoveEvent 189 192 0 0 0 0 0\n"
  "MouseMoveEvent 188 193 0 0 0 0 0\n"
  "MouseMoveEvent 188 194 0 0 0 0 0\n"
  "MouseMoveEvent 187 195 0 0 0 0 0\n"
  "MouseMoveEvent 186 196 0 0 0 0 0\n"
  "MouseMoveEvent 185 197 0 0 0 0 0\n"
  "MouseMoveEvent 184 198 0 0 0 0 0\n"
  "MouseMoveEvent 183 198 0 0 0 0 0\n"
  "MouseMoveEvent 182 197 0 0 0 0 0\n"
  "MouseMoveEvent 181 197 0 0 0 0 0\n"
  "MouseMoveEvent 180 197 0 0 0 0 0\n"
  "MouseMoveEvent 179 196 0 0 0 0 0\n"
  "MouseMoveEvent 178 196 0 0 0 0 0\n"
  "MouseMoveEvent 175 196 0 0 0 0 0\n"
  "MouseMoveEvent 172 196 0 0 0 0 0\n"
  "MouseMoveEvent 171 196 0 0 0 0 0\n"
  "MouseMoveEvent 168 196 0 0 0 0 0\n"
  "MouseMoveEvent 166 196 0 0 0 0 0\n"
  "MouseMoveEvent 164 196 0 0 0 0 0\n"
  "MouseMoveEvent 161 196 0 0 0 0 0\n"
  "MouseMoveEvent 159 196 0 0 0 0 0\n"
  "MouseMoveEvent 157 196 0 0 0 0 0\n"
  "MouseMoveEvent 155 196 0 0 0 0 0\n"
  "MouseMoveEvent 153 196 0 0 0 0 0\n"
  "MouseMoveEvent 152 196 0 0 0 0 0\n"
  "MouseMoveEvent 149 196 0 0 0 0 0\n"
  "MouseMoveEvent 146 198 0 0 0 0 0\n"
  "MouseMoveEvent 144 200 0 0 0 0 0\n"
  "MouseMoveEvent 142 202 0 0 0 0 0\n"
  "MouseMoveEvent 139 204 0 0 0 0 0\n"
  "MouseMoveEvent 138 210 0 0 0 0 0\n"
  "MouseMoveEvent 135 215 0 0 0 0 0\n"
  "MouseMoveEvent 131 221 0 0 0 0 0\n"
  "MouseMoveEvent 130 223 0 0 0 0 0\n"
  "MouseMoveEvent 129 224 0 0 0 0 0\n"
  "MouseMoveEvent 128 224 0 0 0 0 0\n"
  "MouseMoveEvent 127 224 0 0 0 0 0\n"
  "MouseMoveEvent 126 224 0 0 0 0 0\n"
  "LeftButtonPressEvent 126 224 0 0 0 0 0\n"
  "StartInteractionEvent 126 224 0 0 0 0 0\n"
  "MouseMoveEvent 127 223 0 0 0 0 0\n"
  "RenderEvent 127 223 0 0 0 0 0\n"
  "InteractionEvent 127 223 0 0 0 0 0\n"
  "MouseMoveEvent 128 222 0 0 0 0 0\n"
  "RenderEvent 128 222 0 0 0 0 0\n"
  "InteractionEvent 128 222 0 0 0 0 0\n"
  "MouseMoveEvent 129 221 0 0 0 0 0\n"
  "RenderEvent 129 221 0 0 0 0 0\n"
  "InteractionEvent 129 221 0 0 0 0 0\n"
  "MouseMoveEvent 130 220 0 0 0 0 0\n"
  "RenderEvent 130 220 0 0 0 0 0\n"
  "InteractionEvent 130 220 0 0 0 0 0\n"
  "MouseMoveEvent 131 218 0 0 0 0 0\n"
  "RenderEvent 131 218 0 0 0 0 0\n"
  "InteractionEvent 131 218 0 0 0 0 0\n"
  "MouseMoveEvent 133 215 0 0 0 0 0\n"
  "RenderEvent 133 215 0 0 0 0 0\n"
  "InteractionEvent 133 215 0 0 0 0 0\n"
  "MouseMoveEvent 135 212 0 0 0 0 0\n"
  "RenderEvent 135 212 0 0 0 0 0\n"
  "InteractionEvent 135 212 0 0 0 0 0\n"
  "MouseMoveEvent 138 208 0 0 0 0 0\n"
  "RenderEvent 138 208 0 0 0 0 0\n"
  "InteractionEvent 138 208 0 0 0 0 0\n"
  "MouseMoveEvent 139 206 0 0 0 0 0\n"
  "RenderEvent 139 206 0 0 0 0 0\n"
  "InteractionEvent 139 206 0 0 0 0 0\n"
  "MouseMoveEvent 140 204 0 0 0 0 0\n"
  "RenderEvent 140 204 0 0 0 0 0\n"
  "InteractionEvent 140 204 0 0 0 0 0\n"
  "MouseMoveEvent 141 202 0 0 0 0 0\n"
  "RenderEvent 141 202 0 0 0 0 0\n"
  "InteractionEvent 141 202 0 0 0 0 0\n"
  "MouseMoveEvent 141 201 0 0 0 0 0\n"
  "RenderEvent 141 201 0 0 0 0 0\n"
  "InteractionEvent 141 201 0 0 0 0 0\n"
  "MouseMoveEvent 141 200 0 0 0 0 0\n"
  "RenderEvent 141 200 0 0 0 0 0\n"
  "InteractionEvent 141 200 0 0 0 0 0\n"
  "MouseMoveEvent 141 199 0 0 0 0 0\n"
  "RenderEvent 141 199 0 0 0 0 0\n"
  "InteractionEvent 141 199 0 0 0 0 0\n"
  "MouseMoveEvent 141 196 0 0 0 0 0\n"
  "RenderEvent 141 196 0 0 0 0 0\n"
  "InteractionEvent 141 196 0 0 0 0 0\n"
  "MouseMoveEvent 142 194 0 0 0 0 0\n"
  "RenderEvent 142 194 0 0 0 0 0\n"
  "InteractionEvent 142 194 0 0 0 0 0\n"
  "MouseMoveEvent 142 193 0 0 0 0 0\n"
  "RenderEvent 142 193 0 0 0 0 0\n"
  "InteractionEvent 142 193 0 0 0 0 0\n"
  "MouseMoveEvent 142 192 0 0 0 0 0\n"
  "RenderEvent 142 192 0 0 0 0 0\n"
  "InteractionEvent 142 192 0 0 0 0 0\n"
  "MouseMoveEvent 142 191 0 0 0 0 0\n"
  "RenderEvent 142 191 0 0 0 0 0\n"
  "InteractionEvent 142 191 0 0 0 0 0\n"
  "MouseMoveEvent 142 190 0 0 0 0 0\n"
  "RenderEvent 142 190 0 0 0 0 0\n"
  "InteractionEvent 142 190 0 0 0 0 0\n"
  "MouseMoveEvent 142 189 0 0 0 0 0\n"
  "RenderEvent 142 189 0 0 0 0 0\n"
  "InteractionEvent 142 189 0 0 0 0 0\n"
  "MouseMoveEvent 142 188 0 0 0 0 0\n"
  "RenderEvent 142 188 0 0 0 0 0\n"
  "InteractionEvent 142 188 0 0 0 0 0\n"
  "MouseMoveEvent 142 187 0 0 0 0 0\n"
  "RenderEvent 142 187 0 0 0 0 0\n"
  "InteractionEvent 142 187 0 0 0 0 0\n"
  "MouseMoveEvent 143 186 0 0 0 0 0\n"
  "RenderEvent 143 186 0 0 0 0 0\n"
  "InteractionEvent 143 186 0 0 0 0 0\n"
  "MouseMoveEvent 144 185 0 0 0 0 0\n"
  "RenderEvent 144 185 0 0 0 0 0\n"
  "InteractionEvent 144 185 0 0 0 0 0\n"
  "MouseMoveEvent 143 184 0 0 0 0 0\n"
  "RenderEvent 143 184 0 0 0 0 0\n"
  "InteractionEvent 143 184 0 0 0 0 0\n"
  "LeftButtonReleaseEvent 143 184 0 0 0 0 0\n"
  "EndInteractionEvent 143 184 0 0 0 0 0\n"
  "RenderEvent 143 184 0 0 0 0 0\n"
  "MouseMoveEvent 145 182 0 0 0 0 0\n"
  "MouseMoveEvent 147 179 0 0 0 0 0\n"
  "MouseMoveEvent 152 175 0 0 0 0 0\n"
  "MouseMoveEvent 156 171 0 0 0 0 0\n"
  "MouseMoveEvent 160 167 0 0 0 0 0\n"
  "MouseMoveEvent 164 163 0 0 0 0 0\n"
  "MouseMoveEvent 165 159 0 0 0 0 0\n"
  "MouseMoveEvent 167 153 0 0 0 0 0\n"
  "MouseMoveEvent 170 150 0 0 0 0 0\n"
  "MouseMoveEvent 171 146 0 0 0 0 0\n"
  "MouseMoveEvent 173 140 0 0 0 0 0\n"
  "MouseMoveEvent 174 137 0 0 0 0 0\n"
  "MouseMoveEvent 174 133 0 0 0 0 0\n"
  "MouseMoveEvent 175 131 0 0 0 0 0\n"
  "MouseMoveEvent 175 129 0 0 0 0 0\n"
  "LeftButtonPressEvent 175 129 0 0 0 0 0\n"
  "StartInteractionEvent 175 129 0 0 0 0 0\n"
  "MouseMoveEvent 174 131 0 0 0 0 0\n"
  "RenderEvent 174 131 0 0 0 0 0\n"
  "InteractionEvent 174 131 0 0 0 0 0\n"
  "MouseMoveEvent 173 133 0 0 0 0 0\n"
  "RenderEvent 173 133 0 0 0 0 0\n"
  "InteractionEvent 173 133 0 0 0 0 0\n"
  "MouseMoveEvent 173 134 0 0 0 0 0\n"
  "RenderEvent 173 134 0 0 0 0 0\n"
  "InteractionEvent 173 134 0 0 0 0 0\n"
  "MouseMoveEvent 170 140 0 0 0 0 0\n"
  "RenderEvent 170 140 0 0 0 0 0\n"
  "InteractionEvent 170 140 0 0 0 0 0\n"
  "MouseMoveEvent 170 142 0 0 0 0 0\n"
  "RenderEvent 170 142 0 0 0 0 0\n"
  "InteractionEvent 170 142 0 0 0 0 0\n"
  "MouseMoveEvent 169 144 0 0 0 0 0\n"
  "RenderEvent 169 144 0 0 0 0 0\n"
  "InteractionEvent 169 144 0 0 0 0 0\n"
  "MouseMoveEvent 169 145 0 0 0 0 0\n"
  "RenderEvent 169 145 0 0 0 0 0\n"
  "InteractionEvent 169 145 0 0 0 0 0\n"
  "MouseMoveEvent 169 146 0 0 0 0 0\n"
  "RenderEvent 169 146 0 0 0 0 0\n"
  "InteractionEvent 169 146 0 0 0 0 0\n"
  "LeftButtonReleaseEvent 169 146 0 0 0 0 0\n"
  "EndInteractionEvent 169 146 0 0 0 0 0\n"
  "RenderEvent 169 146 0 0 0 0 0\n"
  "MouseMoveEvent 170 145 0 0 0 0 0\n"
  "MouseMoveEvent 171 144 0 0 0 0 0\n"
  "MouseMoveEvent 172 142 0 0 0 0 0\n"
  "MouseMoveEvent 173 141 0 0 0 0 0\n"
  "MouseMoveEvent 174 140 0 0 0 0 0\n"
  "MouseMoveEvent 175 138 0 0 0 0 0\n"
  "MouseMoveEvent 177 135 0 0 0 0 0\n"
  "MouseMoveEvent 180 132 0 0 0 0 0\n"
  "MouseMoveEvent 180 131 0 0 0 0 0\n"
  "MouseMoveEvent 182 129 0 0 0 0 0\n"
  "MouseMoveEvent 184 126 0 0 0 0 0\n"
  "MouseMoveEvent 185 124 0 0 0 0 0\n"
  "MouseMoveEvent 187 122 0 0 0 0 0\n"
  "MouseMoveEvent 189 119 0 0 0 0 0\n"
  "MouseMoveEvent 190 118 0 0 0 0 0\n"
  "MouseMoveEvent 191 117 0 0 0 0 0\n"
  "MouseMoveEvent 192 116 0 0 0 0 0\n"
  "MouseMoveEvent 192 115 0 0 0 0 0\n"
  "MouseMoveEvent 193 114 0 0 0 0 0\n"
  "MouseMoveEvent 193 113 0 0 0 0 0\n"
  "MouseMoveEvent 194 112 0 0 0 0 0\n"
  "MouseMoveEvent 195 111 0 0 0 0 0\n"
  "MouseMoveEvent 196 110 0 0 0 0 0\n"
  "MouseMoveEvent 197 109 0 0 0 0 0\n"
  "MouseMoveEvent 198 109 0 0 0 0 0\n"
  "MouseMoveEvent 200 109 0 0 0 0 0\n"
  "MouseMoveEvent 201 109 0 0 0 0 0\n"
  "MouseMoveEvent 203 109 0 0 0 0 0\n"
  "MouseMoveEvent 204 109 0 0 0 0 0\n"
  "MouseMoveEvent 205 109 0 0 0 0 0\n"
  "MouseMoveEvent 206 109 0 0 0 0 0\n"
  "MouseMoveEvent 207 109 0 0 0 0 0\n"
  "MouseMoveEvent 208 109 0 0 0 0 0\n"
  "MouseMoveEvent 209 110 0 0 0 0 0\n"
  "MouseMoveEvent 210 111 0 0 0 0 0\n"
  "MouseMoveEvent 211 112 0 0 0 0 0\n"
  "MouseMoveEvent 212 113 0 0 0 0 0\n"
  "MouseMoveEvent 212 114 0 0 0 0 0\n"
  "MouseMoveEvent 212 116 0 0 0 0 0\n"
  "MouseMoveEvent 212 118 0 0 0 0 0\n"
  "MouseMoveEvent 213 120 0 0 0 0 0\n"
  "MouseMoveEvent 213 121 0 0 0 0 0\n"
  "MouseMoveEvent 214 123 0 0 0 0 0\n"
  "MouseMoveEvent 215 126 0 0 0 0 0\n"
  "MouseMoveEvent 216 129 0 0 0 0 0\n"
  "MouseMoveEvent 218 132 0 0 0 0 0\n"
  "MouseMoveEvent 219 135 0 0 0 0 0\n"
  "MouseMoveEvent 221 139 0 0 0 0 0\n"
  "MouseMoveEvent 222 142 0 0 0 0 0\n"
  "MouseMoveEvent 224 146 0 0 0 0 0\n"
  "MouseMoveEvent 226 150 0 0 0 0 0\n"
  "MouseMoveEvent 229 156 0 0 0 0 0\n"
  "MouseMoveEvent 232 163 0 0 0 0 0\n"
  "MouseMoveEvent 235 170 0 0 0 0 0\n"
  "MouseMoveEvent 238 177 0 0 0 0 0\n"
  "MouseMoveEvent 242 185 0 0 0 0 0\n"
  "MouseMoveEvent 243 192 0 0 0 0 0\n"
  "MouseMoveEvent 246 200 0 0 0 0 0\n"
  "MouseMoveEvent 248 208 0 0 0 0 0\n"
  "MouseMoveEvent 250 214 0 0 0 0 0\n"
  "MouseMoveEvent 253 220 0 0 0 0 0\n"
  "MouseMoveEvent 255 226 0 0 0 0 0\n"
  "MouseMoveEvent 255 231 0 0 0 0 0\n"
  "MouseMoveEvent 257 234 0 0 0 0 0\n"
  "MouseMoveEvent 258 238 0 0 0 0 0\n"
  "MouseMoveEvent 260 239 0 0 0 0 0\n"
  "MouseMoveEvent 260 241 0 0 0 0 0\n"
  "MouseMoveEvent 260 242 0 0 0 0 0\n"
  "MouseMoveEvent 261 243 0 0 0 0 0\n"
  "MouseMoveEvent 261 245 0 0 0 0 0\n"
  "MouseMoveEvent 262 246 0 0 0 0 0\n"
  "MouseMoveEvent 262 247 0 0 0 0 0\n"
  "MouseMoveEvent 262 249 0 0 0 0 0\n"
  "MouseMoveEvent 263 251 0 0 0 0 0\n"
  "MouseMoveEvent 263 253 0 0 0 0 0\n"
  "MouseMoveEvent 264 255 0 0 0 0 0\n"
  "MouseMoveEvent 265 258 0 0 0 0 0\n"
  "MouseMoveEvent 265 262 0 0 0 0 0\n"
  "MouseMoveEvent 266 266 0 0 0 0 0\n"
  "MouseMoveEvent 266 269 0 0 0 0 0\n"
  "MouseMoveEvent 267 273 0 0 0 0 0\n"
  "MouseMoveEvent 267 276 0 0 0 0 0\n"
  "MouseMoveEvent 268 279 0 0 0 0 0\n"
  "MouseMoveEvent 268 280 0 0 0 0 0\n"
  "MouseMoveEvent 269 282 0 0 0 0 0\n"
  "MouseMoveEvent 269 283 0 0 0 0 0\n"
  "MouseMoveEvent 269 284 0 0 0 0 0\n"
  "MouseMoveEvent 270 285 0 0 0 0 0\n"
  "MouseMoveEvent 270 287 0 0 0 0 0\n"
  "MouseMoveEvent 271 288 0 0 0 0 0\n"
  "MouseMoveEvent 272 290 0 0 0 0 0\n"
  "MouseMoveEvent 273 291 0 0 0 0 0\n"
  "MouseMoveEvent 274 293 0 0 0 0 0\n"
  "MouseMoveEvent 275 297 0 0 0 0 0\n"
  "MouseMoveEvent 276 298 0 0 0 0 0\n"
  "LeaveEvent 276 300 0 0 0 0 0\n";

int TestGPURayCastCameraInsideSmallSpacing(int argc, char* argv[])
{
  cout << "CTEST_FULL_OUTPUT (Avoid ctest truncation of output)" << endl;

  bool useOSP = true;
  for (int i = 0; i < argc; i++)
  {
    if (!strcmp(argv[i], "-GL"))
    {
      cerr << "GL" << endl;
      useOSP = false;
    }
  }

  char* volumeFile = vtkTestUtilities::ExpandDataFileName(argc, argv, "Data/ironProt.vtk");
  vtkNew<vtkStructuredPointsReader> reader;
  reader->SetFileName(volumeFile);
  delete[] volumeFile;

  int dims[3];
  reader->Update();
  reader->GetOutput()->GetDimensions(dims);

  double desiredBounds = 0.0005;
  double desiredSpacing[3];
  for (int i = 0; i < 3; ++i)
  {
    desiredSpacing[i] = desiredBounds / static_cast<double>(dims[i]);
  }

  vtkNew<vtkImageChangeInformation> imageChangeInfo;
  imageChangeInfo->SetInputConnection(reader->GetOutputPort());
  imageChangeInfo->SetOutputSpacing(desiredSpacing);

  vtkNew<vtkGPUVolumeRayCastMapper> mapper;
  mapper->SetInputConnection(imageChangeInfo->GetOutputPort());
  mapper->SetAutoAdjustSampleDistances(0);
  mapper->SetSampleDistance(7e-6);

  vtkNew<vtkColorTransferFunction> color;
  color->AddRGBPoint(0.0, 0.0, 0.0, 0.0);
  color->AddRGBPoint(64.0, 1.0, 0.0, 0.0);
  color->AddRGBPoint(128.0, 0.0, 0.0, 1.0);
  color->AddRGBPoint(192.0, 0.0, 1.0, 0.0);
  color->AddRGBPoint(255.0, 0.0, 0.2, 0.0);

  vtkNew<vtkPiecewiseFunction> opacity;
  opacity->AddPoint(0.0, 0.0);
  opacity->AddPoint(255.0, 1.0);

  vtkNew<vtkVolumeProperty> property;
  property->SetColor(color);
  property->SetScalarOpacity(opacity);
  property->SetInterpolationTypeToLinear();
  property->ShadeOff();
  property->SetScalarOpacityUnitDistance(7e-6);

  vtkNew<vtkVolume> volume;
  volume->SetMapper(mapper);
  volume->SetProperty(property);

  vtkNew<vtkRenderWindow> renWin;
  renWin->SetSize(301, 300);
  renWin->SetMultiSamples(0);

  vtkNew<vtkRenderWindowInteractor> iren;
  iren->SetRenderWindow(renWin);
  vtkNew<vtkInteractorStyleTrackballCamera> style;
  iren->SetInteractorStyle(style);

  vtkNew<vtkRenderer> ren;
  renWin->AddRenderer(ren);
  //  renWin->AddRenderer(ren);

  // Attach OSPRay render pass
  vtkSmartPointer<vtkOSPRayPass> osprayPass = vtkSmartPointer<vtkOSPRayPass>::New();
  if (useOSP)
  {
    ren->SetPass(osprayPass);
  }

  ren->AddVolume(volume);
  ren->ResetCamera();

  renWin->Render();
  iren->Initialize();

  return vtkTesting::InteractorEventLoop(
    argc, argv, iren, TestGPURayCastCameraInsideSmallSpacingLog);
}
