# 帮助 FastAPI 与求助

您喜欢 **FastAPI** 吗？

想帮助 FastAPI？其它用户？还有项目作者？

或要求助怎么使用 **FastAPI**？

以下几种帮助的方式都非常简单（有些只需要点击一两下鼠标）。

求助的渠道也很多。

## 订阅新闻邮件

您可以订阅 [**FastAPI 和它的小伙伴** 新闻邮件](newsletter.md){.internal-link target=_blank}（不会经常收到）

* FastAPI 及其小伙伴的新闻 🚀
* 指南 📝
* 功能 ✨
* 破坏性更改 🚨
* 开发技巧 ✅

## 在推特上关注 FastAPI

<a href="https://twitter.com/fastapi" class="external-link" target="_blank">在 **Twitter** 上关注 @fastapi</a> 获取 **FastAPI** 的最新消息。🐦

## 在 GitHub 上为 **FastAPI** 加星

您可以在 GitHub 上 **Star** FastAPI（只要点击右上角的星星就可以了）： <a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">https://github.com/tiangolo/fastapi。</a>⭐️

**Star** 以后，其它用户就能更容易找到 FastAPI，并了解到已经有其他用户在使用它了。

## 关注 GitHub 资源库的版本发布

您还可以在 GitHub 上 **Watch** FastAPI，（点击右上角的 **Watch** 按钮）<a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">https://github.com/tiangolo/fastapi。</a>👀

您可以选择只关注发布（**Releases only**）。

这样，您就可以（在电子邮件里）接收到 **FastAPI** 新版发布的通知，及时了解 bug 修复与新功能。

## 联系作者

您可以联系项目作者，就是<a href="https://tiangolo.com" class="external-link" target="_blank">我（Sebastián Ramírez / `tiangolo`</a>）。

您可以：

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">在 **GitHub** 上关注我</a>
    * 了解其它我创建的开源项目，或许对您会有帮助
    * 关注我什么时候创建新的开源项目
* <a href="https://twitter.com/tiangolo" class="external-link" target="_blank">在 **Twitter** 上关注我</a>
    * 告诉我您使用 FastAPI（我非常乐意听到这种消息）
    * 接收我发布公告或新工具的消息
    * 您还可以关注<a href="https://twitter.com/fastapi" class="external-link" target="_blank">@fastapi on Twitter</a>，这是个独立的账号
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">在**领英**上联系我</a>
    * 接收我发布公告或新工具的消息（虽然我用 Twitter 比较多）
* 阅读我在 <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> 或 <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a> 上的文章，或关注我
    * 阅读我的其它想法、文章，了解我创建的工具
    * 关注我，这样就可以随时看到我发布的新文章

## Tweet about **FastAPI**

<a href="https://twitter.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/tiangolo/fastapi" class="external-link" target="_blank">Tweet about **FastAPI**</a> 让我和大家知道您为什么喜欢 FastAPI。🎉

知道有人使用 **FastAPI**，我会很开心，我也想知道您为什么喜欢 FastAPI，以及您在什么项目/哪些公司使用 FastAPI，等等。

## 为 FastAPI 投票

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">在 Slant 上为 **FastAPI** 投票</a>
* <a href="https://alternativeto.net/software/fastapi/" class="external-link" target="_blank">在 AlternativeTo 上为 **FastAPI** 投票</a>

## 在 GitHub 上帮助其他人解决问题

您可以查看<a href="https://github.com/tiangolo/fastapi/issues" class="external-link" target="_blank">现有 issues</a>，并尝试帮助其他人解决问题，说不定您能解决这些问题呢。🤓

如果帮助很多人解决了问题，您就有可能成为 [FastAPI 的官方专家](fastapi-people.md#experts){.internal-link target=_blank}。🎉

## 监听 GitHub 资源库

您可以在 GitHub 上「监听」FastAPI（点击右上角的 "watch" 按钮）： <a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">https://github.com/tiangolo/fastapi</a>. 👀

如果您选择 "Watching" 而不是 "Releases only"，有人创建新 Issue 时，您会接收到通知。

然后您就可以尝试并帮助他们解决问题。

## 创建 Issue

您可以在 GitHub 资源库中<a href="https://github.com/tiangolo/fastapi/issues/new/choose" class="external-link" target="_blank">创建 Issue</a>，例如：

* 提出**问题**或**意见**
* 提出新**特性**建议

**注意**：如果您创建 Issue，我会要求您也要帮助别的用户。😉

## 创建 PR

您可以创建 PR 为源代码做[贡献](contributing.md){.internal-link target=_blank}，例如：

* 修改文档错别字
* <a href="https://github.com/tiangolo/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">编辑这个文件</a>，分享 FastAPI 的文章、视频、博客，不论是您自己的，还是您看到的都成
    * 注意，添加的链接要放在对应区块的开头
* [翻译文档](contributing.md#translations){.internal-link target=_blank}
    * 审阅别人翻译的文档
* 添加新的文档内容
* 修复现有问题/Bug
* 添加新功能

## 加入聊天

快加入 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord 聊天服务器</a> 👥 和 FastAPI 社区里的小伙伴一起哈皮吧。

!!! tip "提示"

    如有问题，请在 <a href="https://github.com/tiangolo/fastapi/issues/new/choose" class="external-link" target="_blank">GitHub Issues</a> 里提问，在这里更容易得到 [FastAPI 专家](fastapi-people.md#experts){.internal-link target=_blank}的帮助。

    聊天室仅供闲聊。

### 别在聊天室里提问

注意，聊天室更倾向于“闲聊”，经常有人会提出一些笼统得让人难以回答的问题，所以在这里提问一般没人回答。

GitHub Issues 里提供了模板，指引您提出正确的问题，有利于获得优质的回答，甚至可能解决您还没有想到的问题。而且就算答疑解惑要耗费不少时间，我还是会尽量在 GitHub 里回答问题。但在聊天室里，我就没功夫这么做了。😅

聊天室里的聊天内容也不如 GitHub 里好搜索，聊天里的问答很容易就找不到了。只有在 GitHub Issues 里的问答才能帮助您成为  [FastAPI 专家](fastapi-people.md#experts){.internal-link target=_blank}，在 GitHub Issues 中为您带来更多关注。

另一方面，聊天室里有成千上万的用户，在这里，您有很大可能遇到聊得来的人。😄

## 赞助作者

您还可以通过 <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub 赞助商</a>资助本项目的作者（就是我）。

给我买杯咖啡 ☕️ 以示感谢 😄

当然您也可以成为 FastAPI 的金牌或银牌赞助商。🏅🎉

## 赞助 FastAPI 使用的工具

如您在本文档中所见，FastAPI 站在巨人的肩膀上，它们分别是 Starlette 和 Pydantic。

您还可以赞助：

* <a href="https://github.com/sponsors/samuelcolvin" class="external-link" target="_blank">Samuel Colvin （Pydantic）</a>
* <a href="https://github.com/sponsors/encode" class="external-link" target="_blank">Encode （Starlette, Uvicorn）</a>

---

谢谢！🚀
