# Расширение OpenAPI { #extending-openapi }

Иногда может понадобиться изменить сгенерированную схему OpenAPI.

В этом разделе показано, как это сделать.

## Обычный процесс { #the-normal-process }

Обычный (по умолчанию) процесс выглядит так.

Приложение `FastAPI` (экземпляр) имеет метод `.openapi()`, который должен возвращать схему OpenAPI.

В процессе создания объекта приложения регистрируется *операция пути* (обработчик пути) для `/openapi.json` (или для того, что указано в вашем `openapi_url`).

Она просто возвращает JSON-ответ с результатом вызова метода приложения `.openapi()`.

По умолчанию метод `.openapi()` проверяет свойство `.openapi_schema`: если в нём уже есть данные, возвращает их.

Если нет — генерирует схему с помощью вспомогательной функции `fastapi.openapi.utils.get_openapi`.

Функция `get_openapi()` принимает параметры:

* `title`: Заголовок OpenAPI, отображается в документации.
* `version`: Версия вашего API, например `2.5.0`.
* `openapi_version`: Версия используемой спецификации OpenAPI. По умолчанию — последняя: `3.1.0`.
* `summary`: Краткое описание API.
* `description`: Описание вашего API; может включать Markdown и будет отображается в документации.
* `routes`: Список маршрутов — это каждая зарегистрированная *операция пути*. Берутся из `app.routes`.

/// info | Информация

Параметр `summary` доступен в OpenAPI 3.1.0 и выше, поддерживается FastAPI версии 0.99.0 и выше.

///

## Переопределение значений по умолчанию { #overriding-the-defaults }

Используя информацию выше, вы можете той же вспомогательной функцией сгенерировать схему OpenAPI и переопределить любые нужные части.

Например, добавим <a href="https://github.com/Rebilly/ReDoc/blob/master/docs/redoc-vendor-extensions.md#x-logo" class="external-link" target="_blank">расширение OpenAPI ReDoc для включения собственного логотипа</a>.

### Обычный **FastAPI** { #normal-fastapi }

Сначала напишите приложение **FastAPI** как обычно:

{* ../../docs_src/extending_openapi/tutorial001.py hl[1,4,7:9] *}

### Сгенерируйте схему OpenAPI { #generate-the-openapi-schema }

Затем используйте ту же вспомогательную функцию для генерации схемы OpenAPI внутри функции `custom_openapi()`:

{* ../../docs_src/extending_openapi/tutorial001.py hl[2,15:21] *}

### Измените схему OpenAPI { #modify-the-openapi-schema }

Теперь можно добавить расширение ReDoc, добавив кастомный `x-logo` в «объект» `info` в схеме OpenAPI:

{* ../../docs_src/extending_openapi/tutorial001.py hl[22:24] *}

### Кэшируйте схему OpenAPI { #cache-the-openapi-schema }

Вы можете использовать свойство `.openapi_schema` как «кэш» для хранения сгенерированной схемы.

Так приложению не придётся генерировать схему каждый раз, когда пользователь открывает документацию API.

Она будет создана один раз, а затем тот же кэшированный вариант будет использоваться для последующих запросов.

{* ../../docs_src/extending_openapi/tutorial001.py hl[13:14,25:26] *}

### Переопределите метод { #override-the-method }

Теперь вы можете заменить метод `.openapi()` на вашу новую функцию.

{* ../../docs_src/extending_openapi/tutorial001.py hl[29] *}

### Проверьте { #check-it }

Перейдите на <a href="http://127.0.0.1:8000/redoc" class="external-link" target="_blank">http://127.0.0.1:8000/redoc</a> — вы увидите, что используется ваш кастомный логотип (в этом примере — логотип **FastAPI**):

<img src="/img/tutorial/extending-openapi/image01.png">
