from typing import List

from typing import overload
import lief # type: ignore
import lief.Android # type: ignore
import lief.OAT # type: ignore
import lief.VDEX # type: ignore

class File(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def dex2dex_json_info(self) -> str: ...
    @property
    def dex_files(self) -> lief.OAT.Binary.it_dex_files: ...
    @property
    def header(self) -> lief.VDEX.Header: ...

class Header(lief.Object):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def dex_size(self) -> int: ...
    @property
    def magic(self) -> List[int]: ...
    @property
    def nb_dex_files(self) -> int: ...
    @property
    def quickening_info_size(self) -> int: ...
    @property
    def verifier_deps_size(self) -> int: ...
    @property
    def version(self) -> int: ...

def android_version(vdex_version: int) -> lief.Android.ANDROID_VERSIONS: ...
@overload
def is_vdex(path: str) -> bool: ...
@overload
def is_vdex(raw: List[int]) -> bool: ...
@overload
def parse(filename: str) -> lief.VDEX.File: ...
@overload
def parse(raw: List[int], name: str = ...) -> lief.VDEX.File: ...
@overload
def parse(io: object, name: str = ...) -> lief.VDEX.File: ...
@overload
def version(file: str) -> int: ...
@overload
def version(raw: List[int]) -> int: ...
