#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  INIT_UNDEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  FAKE_USE,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_ABDS,
  G_ABDU,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_FMAXIMUM,
  G_ATOMICRMW_FMINIMUM,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_ATOMICRMW_USUB_COND,
  G_ATOMICRMW_USUB_SAT,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_TRUNC_SSAT_S,
  G_TRUNC_SSAT_U,
  G_TRUNC_USAT_U,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FPTOSI_SAT,
  G_FPTOUI_SAT,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_FMINIMUMNUM,
  G_FMAXIMUMNUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_GET_ROUNDING,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_STEP_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FSINCOS,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FATAN2,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ABSMacro,
  ADJCALLSTACKDOWN,
  ADJCALLSTACKUP,
  AND_V_D_PSEUDO,
  AND_V_H_PSEUDO,
  AND_V_W_PSEUDO,
  ATOMIC_CMP_SWAP_I16,
  ATOMIC_CMP_SWAP_I16_POSTRA,
  ATOMIC_CMP_SWAP_I32,
  ATOMIC_CMP_SWAP_I32_POSTRA,
  ATOMIC_CMP_SWAP_I64,
  ATOMIC_CMP_SWAP_I64_POSTRA,
  ATOMIC_CMP_SWAP_I8,
  ATOMIC_CMP_SWAP_I8_POSTRA,
  ATOMIC_LOAD_ADD_I16,
  ATOMIC_LOAD_ADD_I16_POSTRA,
  ATOMIC_LOAD_ADD_I32,
  ATOMIC_LOAD_ADD_I32_POSTRA,
  ATOMIC_LOAD_ADD_I64,
  ATOMIC_LOAD_ADD_I64_POSTRA,
  ATOMIC_LOAD_ADD_I8,
  ATOMIC_LOAD_ADD_I8_POSTRA,
  ATOMIC_LOAD_AND_I16,
  ATOMIC_LOAD_AND_I16_POSTRA,
  ATOMIC_LOAD_AND_I32,
  ATOMIC_LOAD_AND_I32_POSTRA,
  ATOMIC_LOAD_AND_I64,
  ATOMIC_LOAD_AND_I64_POSTRA,
  ATOMIC_LOAD_AND_I8,
  ATOMIC_LOAD_AND_I8_POSTRA,
  ATOMIC_LOAD_MAX_I16,
  ATOMIC_LOAD_MAX_I16_POSTRA,
  ATOMIC_LOAD_MAX_I32,
  ATOMIC_LOAD_MAX_I32_POSTRA,
  ATOMIC_LOAD_MAX_I64,
  ATOMIC_LOAD_MAX_I64_POSTRA,
  ATOMIC_LOAD_MAX_I8,
  ATOMIC_LOAD_MAX_I8_POSTRA,
  ATOMIC_LOAD_MIN_I16,
  ATOMIC_LOAD_MIN_I16_POSTRA,
  ATOMIC_LOAD_MIN_I32,
  ATOMIC_LOAD_MIN_I32_POSTRA,
  ATOMIC_LOAD_MIN_I64,
  ATOMIC_LOAD_MIN_I64_POSTRA,
  ATOMIC_LOAD_MIN_I8,
  ATOMIC_LOAD_MIN_I8_POSTRA,
  ATOMIC_LOAD_NAND_I16,
  ATOMIC_LOAD_NAND_I16_POSTRA,
  ATOMIC_LOAD_NAND_I32,
  ATOMIC_LOAD_NAND_I32_POSTRA,
  ATOMIC_LOAD_NAND_I64,
  ATOMIC_LOAD_NAND_I64_POSTRA,
  ATOMIC_LOAD_NAND_I8,
  ATOMIC_LOAD_NAND_I8_POSTRA,
  ATOMIC_LOAD_OR_I16,
  ATOMIC_LOAD_OR_I16_POSTRA,
  ATOMIC_LOAD_OR_I32,
  ATOMIC_LOAD_OR_I32_POSTRA,
  ATOMIC_LOAD_OR_I64,
  ATOMIC_LOAD_OR_I64_POSTRA,
  ATOMIC_LOAD_OR_I8,
  ATOMIC_LOAD_OR_I8_POSTRA,
  ATOMIC_LOAD_SUB_I16,
  ATOMIC_LOAD_SUB_I16_POSTRA,
  ATOMIC_LOAD_SUB_I32,
  ATOMIC_LOAD_SUB_I32_POSTRA,
  ATOMIC_LOAD_SUB_I64,
  ATOMIC_LOAD_SUB_I64_POSTRA,
  ATOMIC_LOAD_SUB_I8,
  ATOMIC_LOAD_SUB_I8_POSTRA,
  ATOMIC_LOAD_UMAX_I16,
  ATOMIC_LOAD_UMAX_I16_POSTRA,
  ATOMIC_LOAD_UMAX_I32,
  ATOMIC_LOAD_UMAX_I32_POSTRA,
  ATOMIC_LOAD_UMAX_I64,
  ATOMIC_LOAD_UMAX_I64_POSTRA,
  ATOMIC_LOAD_UMAX_I8,
  ATOMIC_LOAD_UMAX_I8_POSTRA,
  ATOMIC_LOAD_UMIN_I16,
  ATOMIC_LOAD_UMIN_I16_POSTRA,
  ATOMIC_LOAD_UMIN_I32,
  ATOMIC_LOAD_UMIN_I32_POSTRA,
  ATOMIC_LOAD_UMIN_I64,
  ATOMIC_LOAD_UMIN_I64_POSTRA,
  ATOMIC_LOAD_UMIN_I8,
  ATOMIC_LOAD_UMIN_I8_POSTRA,
  ATOMIC_LOAD_XOR_I16,
  ATOMIC_LOAD_XOR_I16_POSTRA,
  ATOMIC_LOAD_XOR_I32,
  ATOMIC_LOAD_XOR_I32_POSTRA,
  ATOMIC_LOAD_XOR_I64,
  ATOMIC_LOAD_XOR_I64_POSTRA,
  ATOMIC_LOAD_XOR_I8,
  ATOMIC_LOAD_XOR_I8_POSTRA,
  ATOMIC_SWAP_I16,
  ATOMIC_SWAP_I16_POSTRA,
  ATOMIC_SWAP_I32,
  ATOMIC_SWAP_I32_POSTRA,
  ATOMIC_SWAP_I64,
  ATOMIC_SWAP_I64_POSTRA,
  ATOMIC_SWAP_I8,
  ATOMIC_SWAP_I8_POSTRA,
  B,
  BAL_BR,
  BAL_BR_MM,
  BEQLImmMacro,
  BGE,
  BGEImmMacro,
  BGEL,
  BGELImmMacro,
  BGEU,
  BGEUImmMacro,
  BGEUL,
  BGEULImmMacro,
  BGT,
  BGTImmMacro,
  BGTL,
  BGTLImmMacro,
  BGTU,
  BGTUImmMacro,
  BGTUL,
  BGTULImmMacro,
  BLE,
  BLEImmMacro,
  BLEL,
  BLELImmMacro,
  BLEU,
  BLEUImmMacro,
  BLEUL,
  BLEULImmMacro,
  BLT,
  BLTImmMacro,
  BLTL,
  BLTLImmMacro,
  BLTU,
  BLTUImmMacro,
  BLTUL,
  BLTULImmMacro,
  BNELImmMacro,
  BPOSGE32_PSEUDO,
  BSEL_D_PSEUDO,
  BSEL_FD_PSEUDO,
  BSEL_FW_PSEUDO,
  BSEL_H_PSEUDO,
  BSEL_W_PSEUDO,
  B_MM,
  B_MMR6_Pseudo,
  B_MM_Pseudo,
  BeqImm,
  BneImm,
  BteqzT8CmpX16,
  BteqzT8CmpiX16,
  BteqzT8SltX16,
  BteqzT8SltiX16,
  BteqzT8SltiuX16,
  BteqzT8SltuX16,
  BtnezT8CmpX16,
  BtnezT8CmpiX16,
  BtnezT8SltX16,
  BtnezT8SltiX16,
  BtnezT8SltiuX16,
  BtnezT8SltuX16,
  BuildPairF64,
  BuildPairF64_64,
  CFTC1,
  CONSTPOOL_ENTRY,
  COPY_FD_PSEUDO,
  COPY_FW_PSEUDO,
  CTTC1,
  Constant32,
  DMULImmMacro,
  DMULMacro,
  DMULOMacro,
  DMULOUMacro,
  DROL,
  DROLImm,
  DROR,
  DRORImm,
  DSDivIMacro,
  DSDivMacro,
  DSRemIMacro,
  DSRemMacro,
  DUDivIMacro,
  DUDivMacro,
  DURemIMacro,
  DURemMacro,
  ERet,
  ExtractElementF64,
  ExtractElementF64_64,
  FABS_D,
  FABS_W,
  FEXP2_D_1_PSEUDO,
  FEXP2_W_1_PSEUDO,
  FILL_FD_PSEUDO,
  FILL_FW_PSEUDO,
  GotPrologue16,
  INSERT_B_VIDX64_PSEUDO,
  INSERT_B_VIDX_PSEUDO,
  INSERT_D_VIDX64_PSEUDO,
  INSERT_D_VIDX_PSEUDO,
  INSERT_FD_PSEUDO,
  INSERT_FD_VIDX64_PSEUDO,
  INSERT_FD_VIDX_PSEUDO,
  INSERT_FW_PSEUDO,
  INSERT_FW_VIDX64_PSEUDO,
  INSERT_FW_VIDX_PSEUDO,
  INSERT_H_VIDX64_PSEUDO,
  INSERT_H_VIDX_PSEUDO,
  INSERT_W_VIDX64_PSEUDO,
  INSERT_W_VIDX_PSEUDO,
  JALR64Pseudo,
  JALRHB64Pseudo,
  JALRHBPseudo,
  JALRPseudo,
  JAL_MMR6,
  JalOneReg,
  JalTwoReg,
  LDMacro,
  LDR_D,
  LDR_W,
  LD_F16,
  LOAD_ACC128,
  LOAD_ACC64,
  LOAD_ACC64DSP,
  LOAD_CCOND_DSP,
  LONG_BRANCH_ADDiu,
  LONG_BRANCH_ADDiu2Op,
  LONG_BRANCH_DADDiu,
  LONG_BRANCH_DADDiu2Op,
  LONG_BRANCH_LUi,
  LONG_BRANCH_LUi2Op,
  LONG_BRANCH_LUi2Op_64,
  LWM_MM,
  LoadAddrImm32,
  LoadAddrImm64,
  LoadAddrReg32,
  LoadAddrReg64,
  LoadImm32,
  LoadImm64,
  LoadImmDoubleFGR,
  LoadImmDoubleFGR_32,
  LoadImmDoubleGPR,
  LoadImmSingleFGR,
  LoadImmSingleGPR,
  LwConstant32,
  MFTACX,
  MFTC0,
  MFTC1,
  MFTDSP,
  MFTGPR,
  MFTHC1,
  MFTHI,
  MFTLO,
  MIPSeh_return32,
  MIPSeh_return64,
  MSA_FP_EXTEND_D_PSEUDO,
  MSA_FP_EXTEND_W_PSEUDO,
  MSA_FP_ROUND_D_PSEUDO,
  MSA_FP_ROUND_W_PSEUDO,
  MTTACX,
  MTTC0,
  MTTC1,
  MTTDSP,
  MTTGPR,
  MTTHC1,
  MTTHI,
  MTTLO,
  MULImmMacro,
  MULOMacro,
  MULOUMacro,
  MultRxRy16,
  MultRxRyRz16,
  MultuRxRy16,
  MultuRxRyRz16,
  NOP,
  NORImm,
  NORImm64,
  NOR_V_D_PSEUDO,
  NOR_V_H_PSEUDO,
  NOR_V_W_PSEUDO,
  OR_V_D_PSEUDO,
  OR_V_H_PSEUDO,
  OR_V_W_PSEUDO,
  PseudoCMPU_EQ_QB,
  PseudoCMPU_LE_QB,
  PseudoCMPU_LT_QB,
  PseudoCMP_EQ_PH,
  PseudoCMP_LE_PH,
  PseudoCMP_LT_PH,
  PseudoCVT_D32_W,
  PseudoCVT_D64_L,
  PseudoCVT_D64_W,
  PseudoCVT_S_L,
  PseudoCVT_S_W,
  PseudoDMULT,
  PseudoDMULTu,
  PseudoDSDIV,
  PseudoDUDIV,
  PseudoD_SELECT_I,
  PseudoD_SELECT_I64,
  PseudoIndirectBranch,
  PseudoIndirectBranch64,
  PseudoIndirectBranch64R6,
  PseudoIndirectBranchR6,
  PseudoIndirectBranch_MM,
  PseudoIndirectBranch_MMR6,
  PseudoIndirectHazardBranch,
  PseudoIndirectHazardBranch64,
  PseudoIndrectHazardBranch64R6,
  PseudoIndrectHazardBranchR6,
  PseudoMADD,
  PseudoMADDU,
  PseudoMADDU_MM,
  PseudoMADD_MM,
  PseudoMFHI,
  PseudoMFHI64,
  PseudoMFHI_MM,
  PseudoMFLO,
  PseudoMFLO64,
  PseudoMFLO_MM,
  PseudoMSUB,
  PseudoMSUBU,
  PseudoMSUBU_MM,
  PseudoMSUB_MM,
  PseudoMTLOHI,
  PseudoMTLOHI64,
  PseudoMTLOHI_DSP,
  PseudoMTLOHI_MM,
  PseudoMULT,
  PseudoMULT_MM,
  PseudoMULTu,
  PseudoMULTu_MM,
  PseudoPICK_PH,
  PseudoPICK_QB,
  PseudoReturn,
  PseudoReturn64,
  PseudoSDIV,
  PseudoSELECTFP_F_D32,
  PseudoSELECTFP_F_D64,
  PseudoSELECTFP_F_I,
  PseudoSELECTFP_F_I64,
  PseudoSELECTFP_F_S,
  PseudoSELECTFP_T_D32,
  PseudoSELECTFP_T_D64,
  PseudoSELECTFP_T_I,
  PseudoSELECTFP_T_I64,
  PseudoSELECTFP_T_S,
  PseudoSELECT_D32,
  PseudoSELECT_D64,
  PseudoSELECT_I,
  PseudoSELECT_I64,
  PseudoSELECT_S,
  PseudoTRUNC_W_D,
  PseudoTRUNC_W_D32,
  PseudoTRUNC_W_S,
  PseudoUDIV,
  ROL,
  ROLImm,
  ROR,
  RORImm,
  RetRA,
  RetRA16,
  SDC1_M1,
  SDIV_MM_Pseudo,
  SDMacro,
  SDivIMacro,
  SDivMacro,
  SEQIMacro,
  SEQMacro,
  SGE,
  SGEImm,
  SGEImm64,
  SGEU,
  SGEUImm,
  SGEUImm64,
  SGTImm,
  SGTImm64,
  SGTUImm,
  SGTUImm64,
  SLE,
  SLEImm,
  SLEImm64,
  SLEU,
  SLEUImm,
  SLEUImm64,
  SLTImm64,
  SLTUImm64,
  SNEIMacro,
  SNEMacro,
  SNZ_B_PSEUDO,
  SNZ_D_PSEUDO,
  SNZ_H_PSEUDO,
  SNZ_V_PSEUDO,
  SNZ_W_PSEUDO,
  SRemIMacro,
  SRemMacro,
  STORE_ACC128,
  STORE_ACC64,
  STORE_ACC64DSP,
  STORE_CCOND_DSP,
  STR_D,
  STR_W,
  ST_F16,
  SWM_MM,
  SZ_B_PSEUDO,
  SZ_D_PSEUDO,
  SZ_H_PSEUDO,
  SZ_V_PSEUDO,
  SZ_W_PSEUDO,
  SaaAddr,
  SaadAddr,
  SelBeqZ,
  SelBneZ,
  SelTBteqZCmp,
  SelTBteqZCmpi,
  SelTBteqZSlt,
  SelTBteqZSlti,
  SelTBteqZSltiu,
  SelTBteqZSltu,
  SelTBtneZCmp,
  SelTBtneZCmpi,
  SelTBtneZSlt,
  SelTBtneZSlti,
  SelTBtneZSltiu,
  SelTBtneZSltu,
  SltCCRxRy16,
  SltiCCRxImmX16,
  SltiuCCRxImmX16,
  SltuCCRxRy16,
  SltuRxRyRz16,
  TAILCALL,
  TAILCALL64R6REG,
  TAILCALLHB64R6REG,
  TAILCALLHBR6REG,
  TAILCALLR6REG,
  TAILCALLREG,
  TAILCALLREG64,
  TAILCALLREGHB,
  TAILCALLREGHB64,
  TAILCALLREG_MM,
  TAILCALLREG_MMR6,
  TAILCALL_MM,
  TAILCALL_MMR6,
  TRAP,
  TRAP_MM,
  UDIV_MM_Pseudo,
  UDivIMacro,
  UDivMacro,
  URemIMacro,
  URemMacro,
  Ulh,
  Ulhu,
  Ulw,
  Ush,
  Usw,
  XOR_V_D_PSEUDO,
  XOR_V_H_PSEUDO,
  XOR_V_W_PSEUDO,
  ABSQ_S_PH,
  ABSQ_S_PH_MM,
  ABSQ_S_QB,
  ABSQ_S_QB_MMR2,
  ABSQ_S_W,
  ABSQ_S_W_MM,
  ADD,
  ADDIUPC,
  ADDIUPC_MM,
  ADDIUPC_MMR6,
  ADDIUR1SP_MM,
  ADDIUR2_MM,
  ADDIUS5_MM,
  ADDIUSP_MM,
  ADDIU_MMR6,
  ADDQH_PH,
  ADDQH_PH_MMR2,
  ADDQH_R_PH,
  ADDQH_R_PH_MMR2,
  ADDQH_R_W,
  ADDQH_R_W_MMR2,
  ADDQH_W,
  ADDQH_W_MMR2,
  ADDQ_PH,
  ADDQ_PH_MM,
  ADDQ_S_PH,
  ADDQ_S_PH_MM,
  ADDQ_S_W,
  ADDQ_S_W_MM,
  ADDR_PS64,
  ADDSC,
  ADDSC_MM,
  ADDS_A_B,
  ADDS_A_D,
  ADDS_A_H,
  ADDS_A_W,
  ADDS_S_B,
  ADDS_S_D,
  ADDS_S_H,
  ADDS_S_W,
  ADDS_U_B,
  ADDS_U_D,
  ADDS_U_H,
  ADDS_U_W,
  ADDU16_MM,
  ADDU16_MMR6,
  ADDUH_QB,
  ADDUH_QB_MMR2,
  ADDUH_R_QB,
  ADDUH_R_QB_MMR2,
  ADDU_MMR6,
  ADDU_PH,
  ADDU_PH_MMR2,
  ADDU_QB,
  ADDU_QB_MM,
  ADDU_S_PH,
  ADDU_S_PH_MMR2,
  ADDU_S_QB,
  ADDU_S_QB_MM,
  ADDVI_B,
  ADDVI_D,
  ADDVI_H,
  ADDVI_W,
  ADDV_B,
  ADDV_D,
  ADDV_H,
  ADDV_W,
  ADDWC,
  ADDWC_MM,
  ADD_A_B,
  ADD_A_D,
  ADD_A_H,
  ADD_A_W,
  ADD_MM,
  ADD_MMR6,
  ADDi,
  ADDi_MM,
  ADDiu,
  ADDiu_MM,
  ADDu,
  ADDu_MM,
  ALIGN,
  ALIGN_MMR6,
  ALUIPC,
  ALUIPC_MMR6,
  AND,
  AND16_MM,
  AND16_MMR6,
  AND64,
  ANDI16_MM,
  ANDI16_MMR6,
  ANDI_B,
  ANDI_MMR6,
  AND_MM,
  AND_MMR6,
  AND_V,
  ANDi,
  ANDi64,
  ANDi_MM,
  APPEND,
  APPEND_MMR2,
  ASUB_S_B,
  ASUB_S_D,
  ASUB_S_H,
  ASUB_S_W,
  ASUB_U_B,
  ASUB_U_D,
  ASUB_U_H,
  ASUB_U_W,
  AUI,
  AUIPC,
  AUIPC_MMR6,
  AUI_MMR6,
  AVER_S_B,
  AVER_S_D,
  AVER_S_H,
  AVER_S_W,
  AVER_U_B,
  AVER_U_D,
  AVER_U_H,
  AVER_U_W,
  AVE_S_B,
  AVE_S_D,
  AVE_S_H,
  AVE_S_W,
  AVE_U_B,
  AVE_U_D,
  AVE_U_H,
  AVE_U_W,
  AddiuRxImmX16,
  AddiuRxPcImmX16,
  AddiuRxRxImm16,
  AddiuRxRxImmX16,
  AddiuRxRyOffMemX16,
  AddiuSpImm16,
  AddiuSpImmX16,
  AdduRxRyRz16,
  AndRxRxRy16,
  B16_MM,
  BADDu,
  BAL,
  BALC,
  BALC_MMR6,
  BALIGN,
  BALIGN_MMR2,
  BBIT0,
  BBIT032,
  BBIT1,
  BBIT132,
  BC,
  BC16_MMR6,
  BC1EQZ,
  BC1EQZC_MMR6,
  BC1F,
  BC1FL,
  BC1F_MM,
  BC1NEZ,
  BC1NEZC_MMR6,
  BC1T,
  BC1TL,
  BC1T_MM,
  BC2EQZ,
  BC2EQZC_MMR6,
  BC2NEZ,
  BC2NEZC_MMR6,
  BCLRI_B,
  BCLRI_D,
  BCLRI_H,
  BCLRI_W,
  BCLR_B,
  BCLR_D,
  BCLR_H,
  BCLR_W,
  BC_MMR6,
  BEQ,
  BEQ64,
  BEQC,
  BEQC64,
  BEQC_MMR6,
  BEQL,
  BEQZ16_MM,
  BEQZALC,
  BEQZALC_MMR6,
  BEQZC,
  BEQZC16_MMR6,
  BEQZC64,
  BEQZC_MM,
  BEQZC_MMR6,
  BEQ_MM,
  BGEC,
  BGEC64,
  BGEC_MMR6,
  BGEUC,
  BGEUC64,
  BGEUC_MMR6,
  BGEZ,
  BGEZ64,
  BGEZAL,
  BGEZALC,
  BGEZALC_MMR6,
  BGEZALL,
  BGEZALS_MM,
  BGEZAL_MM,
  BGEZC,
  BGEZC64,
  BGEZC_MMR6,
  BGEZL,
  BGEZ_MM,
  BGTZ,
  BGTZ64,
  BGTZALC,
  BGTZALC_MMR6,
  BGTZC,
  BGTZC64,
  BGTZC_MMR6,
  BGTZL,
  BGTZ_MM,
  BINSLI_B,
  BINSLI_D,
  BINSLI_H,
  BINSLI_W,
  BINSL_B,
  BINSL_D,
  BINSL_H,
  BINSL_W,
  BINSRI_B,
  BINSRI_D,
  BINSRI_H,
  BINSRI_W,
  BINSR_B,
  BINSR_D,
  BINSR_H,
  BINSR_W,
  BITREV,
  BITREV_MM,
  BITSWAP,
  BITSWAP_MMR6,
  BLEZ,
  BLEZ64,
  BLEZALC,
  BLEZALC_MMR6,
  BLEZC,
  BLEZC64,
  BLEZC_MMR6,
  BLEZL,
  BLEZ_MM,
  BLTC,
  BLTC64,
  BLTC_MMR6,
  BLTUC,
  BLTUC64,
  BLTUC_MMR6,
  BLTZ,
  BLTZ64,
  BLTZAL,
  BLTZALC,
  BLTZALC_MMR6,
  BLTZALL,
  BLTZALS_MM,
  BLTZAL_MM,
  BLTZC,
  BLTZC64,
  BLTZC_MMR6,
  BLTZL,
  BLTZ_MM,
  BMNZI_B,
  BMNZ_V,
  BMZI_B,
  BMZ_V,
  BNE,
  BNE64,
  BNEC,
  BNEC64,
  BNEC_MMR6,
  BNEGI_B,
  BNEGI_D,
  BNEGI_H,
  BNEGI_W,
  BNEG_B,
  BNEG_D,
  BNEG_H,
  BNEG_W,
  BNEL,
  BNEZ16_MM,
  BNEZALC,
  BNEZALC_MMR6,
  BNEZC,
  BNEZC16_MMR6,
  BNEZC64,
  BNEZC_MM,
  BNEZC_MMR6,
  BNE_MM,
  BNVC,
  BNVC_MMR6,
  BNZ_B,
  BNZ_D,
  BNZ_H,
  BNZ_V,
  BNZ_W,
  BOVC,
  BOVC_MMR6,
  BPOSGE32,
  BPOSGE32C_MMR3,
  BPOSGE32_MM,
  BREAK,
  BREAK16_MM,
  BREAK16_MMR6,
  BREAK_MM,
  BREAK_MMR6,
  BSELI_B,
  BSEL_V,
  BSETI_B,
  BSETI_D,
  BSETI_H,
  BSETI_W,
  BSET_B,
  BSET_D,
  BSET_H,
  BSET_W,
  BZ_B,
  BZ_D,
  BZ_H,
  BZ_V,
  BZ_W,
  BeqzRxImm16,
  BeqzRxImmX16,
  Bimm16,
  BimmX16,
  BnezRxImm16,
  BnezRxImmX16,
  Break16,
  Bteqz16,
  BteqzX16,
  Btnez16,
  BtnezX16,
  CACHE,
  CACHEE,
  CACHEE_MM,
  CACHE_MM,
  CACHE_MMR6,
  CACHE_R6,
  CEIL_L_D64,
  CEIL_L_D_MMR6,
  CEIL_L_S,
  CEIL_L_S_MMR6,
  CEIL_W_D32,
  CEIL_W_D64,
  CEIL_W_D_MMR6,
  CEIL_W_MM,
  CEIL_W_S,
  CEIL_W_S_MM,
  CEIL_W_S_MMR6,
  CEQI_B,
  CEQI_D,
  CEQI_H,
  CEQI_W,
  CEQ_B,
  CEQ_D,
  CEQ_H,
  CEQ_W,
  CFC1,
  CFC1_MM,
  CFC2_MM,
  CFCMSA,
  CINS,
  CINS32,
  CINS64_32,
  CINS_i32,
  CLASS_D,
  CLASS_D_MMR6,
  CLASS_S,
  CLASS_S_MMR6,
  CLEI_S_B,
  CLEI_S_D,
  CLEI_S_H,
  CLEI_S_W,
  CLEI_U_B,
  CLEI_U_D,
  CLEI_U_H,
  CLEI_U_W,
  CLE_S_B,
  CLE_S_D,
  CLE_S_H,
  CLE_S_W,
  CLE_U_B,
  CLE_U_D,
  CLE_U_H,
  CLE_U_W,
  CLO,
  CLO_MM,
  CLO_MMR6,
  CLO_R6,
  CLTI_S_B,
  CLTI_S_D,
  CLTI_S_H,
  CLTI_S_W,
  CLTI_U_B,
  CLTI_U_D,
  CLTI_U_H,
  CLTI_U_W,
  CLT_S_B,
  CLT_S_D,
  CLT_S_H,
  CLT_S_W,
  CLT_U_B,
  CLT_U_D,
  CLT_U_H,
  CLT_U_W,
  CLZ,
  CLZ_MM,
  CLZ_MMR6,
  CLZ_R6,
  CMPGDU_EQ_QB,
  CMPGDU_EQ_QB_MMR2,
  CMPGDU_LE_QB,
  CMPGDU_LE_QB_MMR2,
  CMPGDU_LT_QB,
  CMPGDU_LT_QB_MMR2,
  CMPGU_EQ_QB,
  CMPGU_EQ_QB_MM,
  CMPGU_LE_QB,
  CMPGU_LE_QB_MM,
  CMPGU_LT_QB,
  CMPGU_LT_QB_MM,
  CMPU_EQ_QB,
  CMPU_EQ_QB_MM,
  CMPU_LE_QB,
  CMPU_LE_QB_MM,
  CMPU_LT_QB,
  CMPU_LT_QB_MM,
  CMP_AF_D_MMR6,
  CMP_AF_S_MMR6,
  CMP_EQ_D,
  CMP_EQ_D_MMR6,
  CMP_EQ_PH,
  CMP_EQ_PH_MM,
  CMP_EQ_S,
  CMP_EQ_S_MMR6,
  CMP_F_D,
  CMP_F_S,
  CMP_LE_D,
  CMP_LE_D_MMR6,
  CMP_LE_PH,
  CMP_LE_PH_MM,
  CMP_LE_S,
  CMP_LE_S_MMR6,
  CMP_LT_D,
  CMP_LT_D_MMR6,
  CMP_LT_PH,
  CMP_LT_PH_MM,
  CMP_LT_S,
  CMP_LT_S_MMR6,
  CMP_SAF_D,
  CMP_SAF_D_MMR6,
  CMP_SAF_S,
  CMP_SAF_S_MMR6,
  CMP_SEQ_D,
  CMP_SEQ_D_MMR6,
  CMP_SEQ_S,
  CMP_SEQ_S_MMR6,
  CMP_SLE_D,
  CMP_SLE_D_MMR6,
  CMP_SLE_S,
  CMP_SLE_S_MMR6,
  CMP_SLT_D,
  CMP_SLT_D_MMR6,
  CMP_SLT_S,
  CMP_SLT_S_MMR6,
  CMP_SUEQ_D,
  CMP_SUEQ_D_MMR6,
  CMP_SUEQ_S,
  CMP_SUEQ_S_MMR6,
  CMP_SULE_D,
  CMP_SULE_D_MMR6,
  CMP_SULE_S,
  CMP_SULE_S_MMR6,
  CMP_SULT_D,
  CMP_SULT_D_MMR6,
  CMP_SULT_S,
  CMP_SULT_S_MMR6,
  CMP_SUN_D,
  CMP_SUN_D_MMR6,
  CMP_SUN_S,
  CMP_SUN_S_MMR6,
  CMP_UEQ_D,
  CMP_UEQ_D_MMR6,
  CMP_UEQ_S,
  CMP_UEQ_S_MMR6,
  CMP_ULE_D,
  CMP_ULE_D_MMR6,
  CMP_ULE_S,
  CMP_ULE_S_MMR6,
  CMP_ULT_D,
  CMP_ULT_D_MMR6,
  CMP_ULT_S,
  CMP_ULT_S_MMR6,
  CMP_UN_D,
  CMP_UN_D_MMR6,
  CMP_UN_S,
  CMP_UN_S_MMR6,
  COPY_S_B,
  COPY_S_D,
  COPY_S_H,
  COPY_S_W,
  COPY_U_B,
  COPY_U_H,
  COPY_U_W,
  CRC32B,
  CRC32CB,
  CRC32CD,
  CRC32CH,
  CRC32CW,
  CRC32D,
  CRC32H,
  CRC32W,
  CTC1,
  CTC1_MM,
  CTC2_MM,
  CTCMSA,
  CVT_D32_S,
  CVT_D32_S_MM,
  CVT_D32_W,
  CVT_D32_W_MM,
  CVT_D64_L,
  CVT_D64_S,
  CVT_D64_S_MM,
  CVT_D64_W,
  CVT_D64_W_MM,
  CVT_D_L_MMR6,
  CVT_L_D64,
  CVT_L_D64_MM,
  CVT_L_D_MMR6,
  CVT_L_S,
  CVT_L_S_MM,
  CVT_L_S_MMR6,
  CVT_PS_PW64,
  CVT_PS_S64,
  CVT_PW_PS64,
  CVT_S_D32,
  CVT_S_D32_MM,
  CVT_S_D64,
  CVT_S_D64_MM,
  CVT_S_L,
  CVT_S_L_MMR6,
  CVT_S_PL64,
  CVT_S_PU64,
  CVT_S_W,
  CVT_S_W_MM,
  CVT_S_W_MMR6,
  CVT_W_D32,
  CVT_W_D32_MM,
  CVT_W_D64,
  CVT_W_D64_MM,
  CVT_W_S,
  CVT_W_S_MM,
  CVT_W_S_MMR6,
  C_EQ_D32,
  C_EQ_D32_MM,
  C_EQ_D64,
  C_EQ_D64_MM,
  C_EQ_S,
  C_EQ_S_MM,
  C_F_D32,
  C_F_D32_MM,
  C_F_D64,
  C_F_D64_MM,
  C_F_S,
  C_F_S_MM,
  C_LE_D32,
  C_LE_D32_MM,
  C_LE_D64,
  C_LE_D64_MM,
  C_LE_S,
  C_LE_S_MM,
  C_LT_D32,
  C_LT_D32_MM,
  C_LT_D64,
  C_LT_D64_MM,
  C_LT_S,
  C_LT_S_MM,
  C_NGE_D32,
  C_NGE_D32_MM,
  C_NGE_D64,
  C_NGE_D64_MM,
  C_NGE_S,
  C_NGE_S_MM,
  C_NGLE_D32,
  C_NGLE_D32_MM,
  C_NGLE_D64,
  C_NGLE_D64_MM,
  C_NGLE_S,
  C_NGLE_S_MM,
  C_NGL_D32,
  C_NGL_D32_MM,
  C_NGL_D64,
  C_NGL_D64_MM,
  C_NGL_S,
  C_NGL_S_MM,
  C_NGT_D32,
  C_NGT_D32_MM,
  C_NGT_D64,
  C_NGT_D64_MM,
  C_NGT_S,
  C_NGT_S_MM,
  C_OLE_D32,
  C_OLE_D32_MM,
  C_OLE_D64,
  C_OLE_D64_MM,
  C_OLE_S,
  C_OLE_S_MM,
  C_OLT_D32,
  C_OLT_D32_MM,
  C_OLT_D64,
  C_OLT_D64_MM,
  C_OLT_S,
  C_OLT_S_MM,
  C_SEQ_D32,
  C_SEQ_D32_MM,
  C_SEQ_D64,
  C_SEQ_D64_MM,
  C_SEQ_S,
  C_SEQ_S_MM,
  C_SF_D32,
  C_SF_D32_MM,
  C_SF_D64,
  C_SF_D64_MM,
  C_SF_S,
  C_SF_S_MM,
  C_UEQ_D32,
  C_UEQ_D32_MM,
  C_UEQ_D64,
  C_UEQ_D64_MM,
  C_UEQ_S,
  C_UEQ_S_MM,
  C_ULE_D32,
  C_ULE_D32_MM,
  C_ULE_D64,
  C_ULE_D64_MM,
  C_ULE_S,
  C_ULE_S_MM,
  C_ULT_D32,
  C_ULT_D32_MM,
  C_ULT_D64,
  C_ULT_D64_MM,
  C_ULT_S,
  C_ULT_S_MM,
  C_UN_D32,
  C_UN_D32_MM,
  C_UN_D64,
  C_UN_D64_MM,
  C_UN_S,
  C_UN_S_MM,
  CmpRxRy16,
  CmpiRxImm16,
  CmpiRxImmX16,
  DADD,
  DADDi,
  DADDiu,
  DADDu,
  DAHI,
  DALIGN,
  DATI,
  DAUI,
  DBITSWAP,
  DCLO,
  DCLO_R6,
  DCLZ,
  DCLZ_R6,
  DDIV,
  DDIVU,
  DERET,
  DERET_MM,
  DERET_MMR6,
  DEXT,
  DEXT64_32,
  DEXTM,
  DEXTU,
  DI,
  DINS,
  DINSM,
  DINSU,
  DIV,
  DIVU,
  DIVU_MMR6,
  DIV_MMR6,
  DIV_S_B,
  DIV_S_D,
  DIV_S_H,
  DIV_S_W,
  DIV_U_B,
  DIV_U_D,
  DIV_U_H,
  DIV_U_W,
  DI_MM,
  DI_MMR6,
  DLSA,
  DLSA_R6,
  DMFC0,
  DMFC1,
  DMFC2,
  DMFC2_OCTEON,
  DMFGC0,
  DMOD,
  DMODU,
  DMT,
  DMTC0,
  DMTC1,
  DMTC2,
  DMTC2_OCTEON,
  DMTGC0,
  DMUH,
  DMUHU,
  DMUL,
  DMULT,
  DMULTu,
  DMULU,
  DMUL_R6,
  DOTP_S_D,
  DOTP_S_H,
  DOTP_S_W,
  DOTP_U_D,
  DOTP_U_H,
  DOTP_U_W,
  DPADD_S_D,
  DPADD_S_H,
  DPADD_S_W,
  DPADD_U_D,
  DPADD_U_H,
  DPADD_U_W,
  DPAQX_SA_W_PH,
  DPAQX_SA_W_PH_MMR2,
  DPAQX_S_W_PH,
  DPAQX_S_W_PH_MMR2,
  DPAQ_SA_L_W,
  DPAQ_SA_L_W_MM,
  DPAQ_S_W_PH,
  DPAQ_S_W_PH_MM,
  DPAU_H_QBL,
  DPAU_H_QBL_MM,
  DPAU_H_QBR,
  DPAU_H_QBR_MM,
  DPAX_W_PH,
  DPAX_W_PH_MMR2,
  DPA_W_PH,
  DPA_W_PH_MMR2,
  DPOP,
  DPSQX_SA_W_PH,
  DPSQX_SA_W_PH_MMR2,
  DPSQX_S_W_PH,
  DPSQX_S_W_PH_MMR2,
  DPSQ_SA_L_W,
  DPSQ_SA_L_W_MM,
  DPSQ_S_W_PH,
  DPSQ_S_W_PH_MM,
  DPSUB_S_D,
  DPSUB_S_H,
  DPSUB_S_W,
  DPSUB_U_D,
  DPSUB_U_H,
  DPSUB_U_W,
  DPSU_H_QBL,
  DPSU_H_QBL_MM,
  DPSU_H_QBR,
  DPSU_H_QBR_MM,
  DPSX_W_PH,
  DPSX_W_PH_MMR2,
  DPS_W_PH,
  DPS_W_PH_MMR2,
  DROTR,
  DROTR32,
  DROTRV,
  DSBH,
  DSDIV,
  DSHD,
  DSLL,
  DSLL32,
  DSLL64_32,
  DSLLV,
  DSRA,
  DSRA32,
  DSRAV,
  DSRL,
  DSRL32,
  DSRLV,
  DSUB,
  DSUBu,
  DUDIV,
  DVP,
  DVPE,
  DVP_MMR6,
  DivRxRy16,
  DivuRxRy16,
  EHB,
  EHB_MM,
  EHB_MMR6,
  EI,
  EI_MM,
  EI_MMR6,
  EMT,
  ERET,
  ERETNC,
  ERETNC_MMR6,
  ERET_MM,
  ERET_MMR6,
  EVP,
  EVPE,
  EVP_MMR6,
  EXT,
  EXTP,
  EXTPDP,
  EXTPDPV,
  EXTPDPV_MM,
  EXTPDP_MM,
  EXTPV,
  EXTPV_MM,
  EXTP_MM,
  EXTRV_RS_W,
  EXTRV_RS_W_MM,
  EXTRV_R_W,
  EXTRV_R_W_MM,
  EXTRV_S_H,
  EXTRV_S_H_MM,
  EXTRV_W,
  EXTRV_W_MM,
  EXTR_RS_W,
  EXTR_RS_W_MM,
  EXTR_R_W,
  EXTR_R_W_MM,
  EXTR_S_H,
  EXTR_S_H_MM,
  EXTR_W,
  EXTR_W_MM,
  EXTS,
  EXTS32,
  EXT_MM,
  EXT_MMR6,
  FABS_D32,
  FABS_D32_MM,
  FABS_D64,
  FABS_D64_MM,
  FABS_S,
  FABS_S_MM,
  FADD_D,
  FADD_D32,
  FADD_D32_MM,
  FADD_D64,
  FADD_D64_MM,
  FADD_PS64,
  FADD_S,
  FADD_S_MM,
  FADD_S_MMR6,
  FADD_W,
  FCAF_D,
  FCAF_W,
  FCEQ_D,
  FCEQ_W,
  FCLASS_D,
  FCLASS_W,
  FCLE_D,
  FCLE_W,
  FCLT_D,
  FCLT_W,
  FCMP_D32,
  FCMP_D32_MM,
  FCMP_D64,
  FCMP_S32,
  FCMP_S32_MM,
  FCNE_D,
  FCNE_W,
  FCOR_D,
  FCOR_W,
  FCUEQ_D,
  FCUEQ_W,
  FCULE_D,
  FCULE_W,
  FCULT_D,
  FCULT_W,
  FCUNE_D,
  FCUNE_W,
  FCUN_D,
  FCUN_W,
  FDIV_D,
  FDIV_D32,
  FDIV_D32_MM,
  FDIV_D64,
  FDIV_D64_MM,
  FDIV_S,
  FDIV_S_MM,
  FDIV_S_MMR6,
  FDIV_W,
  FEXDO_H,
  FEXDO_W,
  FEXP2_D,
  FEXP2_W,
  FEXUPL_D,
  FEXUPL_W,
  FEXUPR_D,
  FEXUPR_W,
  FFINT_S_D,
  FFINT_S_W,
  FFINT_U_D,
  FFINT_U_W,
  FFQL_D,
  FFQL_W,
  FFQR_D,
  FFQR_W,
  FILL_B,
  FILL_D,
  FILL_H,
  FILL_W,
  FLOG2_D,
  FLOG2_W,
  FLOOR_L_D64,
  FLOOR_L_D_MMR6,
  FLOOR_L_S,
  FLOOR_L_S_MMR6,
  FLOOR_W_D32,
  FLOOR_W_D64,
  FLOOR_W_D_MMR6,
  FLOOR_W_MM,
  FLOOR_W_S,
  FLOOR_W_S_MM,
  FLOOR_W_S_MMR6,
  FMADD_D,
  FMADD_W,
  FMAX_A_D,
  FMAX_A_W,
  FMAX_D,
  FMAX_W,
  FMIN_A_D,
  FMIN_A_W,
  FMIN_D,
  FMIN_W,
  FMOV_D32,
  FMOV_D32_MM,
  FMOV_D64,
  FMOV_D64_MM,
  FMOV_D_MMR6,
  FMOV_S,
  FMOV_S_MM,
  FMOV_S_MMR6,
  FMSUB_D,
  FMSUB_W,
  FMUL_D,
  FMUL_D32,
  FMUL_D32_MM,
  FMUL_D64,
  FMUL_D64_MM,
  FMUL_PS64,
  FMUL_S,
  FMUL_S_MM,
  FMUL_S_MMR6,
  FMUL_W,
  FNEG_D32,
  FNEG_D32_MM,
  FNEG_D64,
  FNEG_D64_MM,
  FNEG_S,
  FNEG_S_MM,
  FNEG_S_MMR6,
  FORK,
  FRCP_D,
  FRCP_W,
  FRINT_D,
  FRINT_W,
  FRSQRT_D,
  FRSQRT_W,
  FSAF_D,
  FSAF_W,
  FSEQ_D,
  FSEQ_W,
  FSLE_D,
  FSLE_W,
  FSLT_D,
  FSLT_W,
  FSNE_D,
  FSNE_W,
  FSOR_D,
  FSOR_W,
  FSQRT_D,
  FSQRT_D32,
  FSQRT_D32_MM,
  FSQRT_D64,
  FSQRT_D64_MM,
  FSQRT_S,
  FSQRT_S_MM,
  FSQRT_W,
  FSUB_D,
  FSUB_D32,
  FSUB_D32_MM,
  FSUB_D64,
  FSUB_D64_MM,
  FSUB_PS64,
  FSUB_S,
  FSUB_S_MM,
  FSUB_S_MMR6,
  FSUB_W,
  FSUEQ_D,
  FSUEQ_W,
  FSULE_D,
  FSULE_W,
  FSULT_D,
  FSULT_W,
  FSUNE_D,
  FSUNE_W,
  FSUN_D,
  FSUN_W,
  FTINT_S_D,
  FTINT_S_W,
  FTINT_U_D,
  FTINT_U_W,
  FTQ_H,
  FTQ_W,
  FTRUNC_S_D,
  FTRUNC_S_W,
  FTRUNC_U_D,
  FTRUNC_U_W,
  GINVI,
  GINVI_MMR6,
  GINVT,
  GINVT_MMR6,
  HADD_S_D,
  HADD_S_H,
  HADD_S_W,
  HADD_U_D,
  HADD_U_H,
  HADD_U_W,
  HSUB_S_D,
  HSUB_S_H,
  HSUB_S_W,
  HSUB_U_D,
  HSUB_U_H,
  HSUB_U_W,
  HYPCALL,
  HYPCALL_MM,
  ILVEV_B,
  ILVEV_D,
  ILVEV_H,
  ILVEV_W,
  ILVL_B,
  ILVL_D,
  ILVL_H,
  ILVL_W,
  ILVOD_B,
  ILVOD_D,
  ILVOD_H,
  ILVOD_W,
  ILVR_B,
  ILVR_D,
  ILVR_H,
  ILVR_W,
  INS,
  INSERT_B,
  INSERT_D,
  INSERT_H,
  INSERT_W,
  INSV,
  INSVE_B,
  INSVE_D,
  INSVE_H,
  INSVE_W,
  INSV_MM,
  INS_MM,
  INS_MMR6,
  J,
  JAL,
  JALR,
  JALR16_MM,
  JALR64,
  JALRC16_MMR6,
  JALRC_HB_MMR6,
  JALRC_MMR6,
  JALRS16_MM,
  JALRS_MM,
  JALR_HB,
  JALR_HB64,
  JALR_MM,
  JALS_MM,
  JALX,
  JALX_MM,
  JAL_MM,
  JIALC,
  JIALC64,
  JIALC_MMR6,
  JIC,
  JIC64,
  JIC_MMR6,
  JR,
  JR16_MM,
  JR64,
  JRADDIUSP,
  JRC16_MM,
  JRC16_MMR6,
  JRCADDIUSP_MMR6,
  JR_HB,
  JR_HB64,
  JR_HB64_R6,
  JR_HB_R6,
  JR_MM,
  J_MM,
  Jal16,
  JalB16,
  JrRa16,
  JrcRa16,
  JrcRx16,
  JumpLinkReg16,
  LB,
  LB64,
  LBE,
  LBE_MM,
  LBU16_MM,
  LBUX,
  LBUX_MM,
  LBU_MMR6,
  LB_MM,
  LB_MMR6,
  LBu,
  LBu64,
  LBuE,
  LBuE_MM,
  LBu_MM,
  LD,
  LDC1,
  LDC164,
  LDC1_D64_MMR6,
  LDC1_MM_D32,
  LDC1_MM_D64,
  LDC2,
  LDC2_MMR6,
  LDC2_R6,
  LDC3,
  LDI_B,
  LDI_D,
  LDI_H,
  LDI_W,
  LDL,
  LDPC,
  LDR,
  LDXC1,
  LDXC164,
  LD_B,
  LD_D,
  LD_H,
  LD_W,
  LEA_ADDiu,
  LEA_ADDiu64,
  LEA_ADDiu_MM,
  LH,
  LH64,
  LHE,
  LHE_MM,
  LHU16_MM,
  LHX,
  LHX_MM,
  LH_MM,
  LHu,
  LHu64,
  LHuE,
  LHuE_MM,
  LHu_MM,
  LI16_MM,
  LI16_MMR6,
  LL,
  LL64,
  LL64_R6,
  LLD,
  LLD_R6,
  LLE,
  LLE_MM,
  LL_MM,
  LL_MMR6,
  LL_R6,
  LSA,
  LSA_MMR6,
  LSA_R6,
  LUI_MMR6,
  LUXC1,
  LUXC164,
  LUXC1_MM,
  LUi,
  LUi64,
  LUi_MM,
  LW,
  LW16_MM,
  LW64,
  LWC1,
  LWC1_MM,
  LWC2,
  LWC2_MMR6,
  LWC2_R6,
  LWC3,
  LWDSP,
  LWDSP_MM,
  LWE,
  LWE_MM,
  LWGP_MM,
  LWL,
  LWL64,
  LWLE,
  LWLE_MM,
  LWL_MM,
  LWM16_MM,
  LWM16_MMR6,
  LWM32_MM,
  LWPC,
  LWPC_MMR6,
  LWP_MM,
  LWR,
  LWR64,
  LWRE,
  LWRE_MM,
  LWR_MM,
  LWSP_MM,
  LWUPC,
  LWU_MM,
  LWX,
  LWXC1,
  LWXC1_MM,
  LWXS_MM,
  LWX_MM,
  LW_MM,
  LW_MMR6,
  LWu,
  LbRxRyOffMemX16,
  LbuRxRyOffMemX16,
  LhRxRyOffMemX16,
  LhuRxRyOffMemX16,
  LiRxImm16,
  LiRxImmAlignX16,
  LiRxImmX16,
  LwRxPcTcp16,
  LwRxPcTcpX16,
  LwRxRyOffMemX16,
  LwRxSpImmX16,
  MADD,
  MADDF_D,
  MADDF_D_MMR6,
  MADDF_S,
  MADDF_S_MMR6,
  MADDR_Q_H,
  MADDR_Q_W,
  MADDU,
  MADDU_DSP,
  MADDU_DSP_MM,
  MADDU_MM,
  MADDV_B,
  MADDV_D,
  MADDV_H,
  MADDV_W,
  MADD_D32,
  MADD_D32_MM,
  MADD_D64,
  MADD_DSP,
  MADD_DSP_MM,
  MADD_MM,
  MADD_Q_H,
  MADD_Q_W,
  MADD_S,
  MADD_S_MM,
  MAQ_SA_W_PHL,
  MAQ_SA_W_PHL_MM,
  MAQ_SA_W_PHR,
  MAQ_SA_W_PHR_MM,
  MAQ_S_W_PHL,
  MAQ_S_W_PHL_MM,
  MAQ_S_W_PHR,
  MAQ_S_W_PHR_MM,
  MAXA_D,
  MAXA_D_MMR6,
  MAXA_S,
  MAXA_S_MMR6,
  MAXI_S_B,
  MAXI_S_D,
  MAXI_S_H,
  MAXI_S_W,
  MAXI_U_B,
  MAXI_U_D,
  MAXI_U_H,
  MAXI_U_W,
  MAX_A_B,
  MAX_A_D,
  MAX_A_H,
  MAX_A_W,
  MAX_D,
  MAX_D_MMR6,
  MAX_S,
  MAX_S_B,
  MAX_S_D,
  MAX_S_H,
  MAX_S_MMR6,
  MAX_S_W,
  MAX_U_B,
  MAX_U_D,
  MAX_U_H,
  MAX_U_W,
  MFC0,
  MFC0_MMR6,
  MFC1,
  MFC1_D64,
  MFC1_MM,
  MFC1_MMR6,
  MFC2,
  MFC2_MMR6,
  MFGC0,
  MFGC0_MM,
  MFHC0_MMR6,
  MFHC1_D32,
  MFHC1_D32_MM,
  MFHC1_D64,
  MFHC1_D64_MM,
  MFHC2_MMR6,
  MFHGC0,
  MFHGC0_MM,
  MFHI,
  MFHI16_MM,
  MFHI64,
  MFHI_DSP,
  MFHI_DSP_MM,
  MFHI_MM,
  MFLO,
  MFLO16_MM,
  MFLO64,
  MFLO_DSP,
  MFLO_DSP_MM,
  MFLO_MM,
  MFTR,
  MINA_D,
  MINA_D_MMR6,
  MINA_S,
  MINA_S_MMR6,
  MINI_S_B,
  MINI_S_D,
  MINI_S_H,
  MINI_S_W,
  MINI_U_B,
  MINI_U_D,
  MINI_U_H,
  MINI_U_W,
  MIN_A_B,
  MIN_A_D,
  MIN_A_H,
  MIN_A_W,
  MIN_D,
  MIN_D_MMR6,
  MIN_S,
  MIN_S_B,
  MIN_S_D,
  MIN_S_H,
  MIN_S_MMR6,
  MIN_S_W,
  MIN_U_B,
  MIN_U_D,
  MIN_U_H,
  MIN_U_W,
  MOD,
  MODSUB,
  MODSUB_MM,
  MODU,
  MODU_MMR6,
  MOD_MMR6,
  MOD_S_B,
  MOD_S_D,
  MOD_S_H,
  MOD_S_W,
  MOD_U_B,
  MOD_U_D,
  MOD_U_H,
  MOD_U_W,
  MOVE16_MM,
  MOVE16_MMR6,
  MOVEP_MM,
  MOVEP_MMR6,
  MOVE_V,
  MOVF_D32,
  MOVF_D32_MM,
  MOVF_D64,
  MOVF_I,
  MOVF_I64,
  MOVF_I_MM,
  MOVF_S,
  MOVF_S_MM,
  MOVN_I64_D64,
  MOVN_I64_I,
  MOVN_I64_I64,
  MOVN_I64_S,
  MOVN_I_D32,
  MOVN_I_D32_MM,
  MOVN_I_D64,
  MOVN_I_I,
  MOVN_I_I64,
  MOVN_I_MM,
  MOVN_I_S,
  MOVN_I_S_MM,
  MOVT_D32,
  MOVT_D32_MM,
  MOVT_D64,
  MOVT_I,
  MOVT_I64,
  MOVT_I_MM,
  MOVT_S,
  MOVT_S_MM,
  MOVZ_I64_D64,
  MOVZ_I64_I,
  MOVZ_I64_I64,
  MOVZ_I64_S,
  MOVZ_I_D32,
  MOVZ_I_D32_MM,
  MOVZ_I_D64,
  MOVZ_I_I,
  MOVZ_I_I64,
  MOVZ_I_MM,
  MOVZ_I_S,
  MOVZ_I_S_MM,
  MSUB,
  MSUBF_D,
  MSUBF_D_MMR6,
  MSUBF_S,
  MSUBF_S_MMR6,
  MSUBR_Q_H,
  MSUBR_Q_W,
  MSUBU,
  MSUBU_DSP,
  MSUBU_DSP_MM,
  MSUBU_MM,
  MSUBV_B,
  MSUBV_D,
  MSUBV_H,
  MSUBV_W,
  MSUB_D32,
  MSUB_D32_MM,
  MSUB_D64,
  MSUB_DSP,
  MSUB_DSP_MM,
  MSUB_MM,
  MSUB_Q_H,
  MSUB_Q_W,
  MSUB_S,
  MSUB_S_MM,
  MTC0,
  MTC0_MMR6,
  MTC1,
  MTC1_D64,
  MTC1_D64_MM,
  MTC1_MM,
  MTC1_MMR6,
  MTC2,
  MTC2_MMR6,
  MTGC0,
  MTGC0_MM,
  MTHC0_MMR6,
  MTHC1_D32,
  MTHC1_D32_MM,
  MTHC1_D64,
  MTHC1_D64_MM,
  MTHC2_MMR6,
  MTHGC0,
  MTHGC0_MM,
  MTHI,
  MTHI64,
  MTHI_DSP,
  MTHI_DSP_MM,
  MTHI_MM,
  MTHLIP,
  MTHLIP_MM,
  MTLO,
  MTLO64,
  MTLO_DSP,
  MTLO_DSP_MM,
  MTLO_MM,
  MTM0,
  MTM1,
  MTM2,
  MTP0,
  MTP1,
  MTP2,
  MTTR,
  MUH,
  MUHU,
  MUHU_MMR6,
  MUH_MMR6,
  MUL,
  MULEQ_S_W_PHL,
  MULEQ_S_W_PHL_MM,
  MULEQ_S_W_PHR,
  MULEQ_S_W_PHR_MM,
  MULEU_S_PH_QBL,
  MULEU_S_PH_QBL_MM,
  MULEU_S_PH_QBR,
  MULEU_S_PH_QBR_MM,
  MULQ_RS_PH,
  MULQ_RS_PH_MM,
  MULQ_RS_W,
  MULQ_RS_W_MMR2,
  MULQ_S_PH,
  MULQ_S_PH_MMR2,
  MULQ_S_W,
  MULQ_S_W_MMR2,
  MULR_PS64,
  MULR_Q_H,
  MULR_Q_W,
  MULSAQ_S_W_PH,
  MULSAQ_S_W_PH_MM,
  MULSA_W_PH,
  MULSA_W_PH_MMR2,
  MULT,
  MULTU_DSP,
  MULTU_DSP_MM,
  MULT_DSP,
  MULT_DSP_MM,
  MULT_MM,
  MULTu,
  MULTu_MM,
  MULU,
  MULU_MMR6,
  MULV_B,
  MULV_D,
  MULV_H,
  MULV_W,
  MUL_MM,
  MUL_MMR6,
  MUL_PH,
  MUL_PH_MMR2,
  MUL_Q_H,
  MUL_Q_W,
  MUL_R6,
  MUL_S_PH,
  MUL_S_PH_MMR2,
  Mfhi16,
  Mflo16,
  Move32R16,
  MoveR3216,
  NAL,
  NLOC_B,
  NLOC_D,
  NLOC_H,
  NLOC_W,
  NLZC_B,
  NLZC_D,
  NLZC_H,
  NLZC_W,
  NMADD_D32,
  NMADD_D32_MM,
  NMADD_D64,
  NMADD_S,
  NMADD_S_MM,
  NMSUB_D32,
  NMSUB_D32_MM,
  NMSUB_D64,
  NMSUB_S,
  NMSUB_S_MM,
  NOR,
  NOR64,
  NORI_B,
  NOR_MM,
  NOR_MMR6,
  NOR_V,
  NOT16_MM,
  NOT16_MMR6,
  NegRxRy16,
  NotRxRy16,
  OR,
  OR16_MM,
  OR16_MMR6,
  OR64,
  ORI_B,
  ORI_MMR6,
  OR_MM,
  OR_MMR6,
  OR_V,
  ORi,
  ORi64,
  ORi_MM,
  OrRxRxRy16,
  PACKRL_PH,
  PACKRL_PH_MM,
  PAUSE,
  PAUSE_MM,
  PAUSE_MMR6,
  PCKEV_B,
  PCKEV_D,
  PCKEV_H,
  PCKEV_W,
  PCKOD_B,
  PCKOD_D,
  PCKOD_H,
  PCKOD_W,
  PCNT_B,
  PCNT_D,
  PCNT_H,
  PCNT_W,
  PICK_PH,
  PICK_PH_MM,
  PICK_QB,
  PICK_QB_MM,
  PLL_PS64,
  PLU_PS64,
  POP,
  PRECEQU_PH_QBL,
  PRECEQU_PH_QBLA,
  PRECEQU_PH_QBLA_MM,
  PRECEQU_PH_QBL_MM,
  PRECEQU_PH_QBR,
  PRECEQU_PH_QBRA,
  PRECEQU_PH_QBRA_MM,
  PRECEQU_PH_QBR_MM,
  PRECEQ_W_PHL,
  PRECEQ_W_PHL_MM,
  PRECEQ_W_PHR,
  PRECEQ_W_PHR_MM,
  PRECEU_PH_QBL,
  PRECEU_PH_QBLA,
  PRECEU_PH_QBLA_MM,
  PRECEU_PH_QBL_MM,
  PRECEU_PH_QBR,
  PRECEU_PH_QBRA,
  PRECEU_PH_QBRA_MM,
  PRECEU_PH_QBR_MM,
  PRECRQU_S_QB_PH,
  PRECRQU_S_QB_PH_MM,
  PRECRQ_PH_W,
  PRECRQ_PH_W_MM,
  PRECRQ_QB_PH,
  PRECRQ_QB_PH_MM,
  PRECRQ_RS_PH_W,
  PRECRQ_RS_PH_W_MM,
  PRECR_QB_PH,
  PRECR_QB_PH_MMR2,
  PRECR_SRA_PH_W,
  PRECR_SRA_PH_W_MMR2,
  PRECR_SRA_R_PH_W,
  PRECR_SRA_R_PH_W_MMR2,
  PREF,
  PREFE,
  PREFE_MM,
  PREFX_MM,
  PREF_MM,
  PREF_MMR6,
  PREF_R6,
  PREPEND,
  PREPEND_MMR2,
  PUL_PS64,
  PUU_PS64,
  RADDU_W_QB,
  RADDU_W_QB_MM,
  RDDSP,
  RDDSP_MM,
  RDHWR,
  RDHWR64,
  RDHWR_MM,
  RDHWR_MMR6,
  RDPGPR_MMR6,
  RECIP_D32,
  RECIP_D32_MM,
  RECIP_D64,
  RECIP_D64_MM,
  RECIP_S,
  RECIP_S_MM,
  REPLV_PH,
  REPLV_PH_MM,
  REPLV_QB,
  REPLV_QB_MM,
  REPL_PH,
  REPL_PH_MM,
  REPL_QB,
  REPL_QB_MM,
  RINT_D,
  RINT_D_MMR6,
  RINT_S,
  RINT_S_MMR6,
  ROTR,
  ROTRV,
  ROTRV_MM,
  ROTR_MM,
  ROUND_L_D64,
  ROUND_L_D_MMR6,
  ROUND_L_S,
  ROUND_L_S_MMR6,
  ROUND_W_D32,
  ROUND_W_D64,
  ROUND_W_D_MMR6,
  ROUND_W_MM,
  ROUND_W_S,
  ROUND_W_S_MM,
  ROUND_W_S_MMR6,
  RSQRT_D32,
  RSQRT_D32_MM,
  RSQRT_D64,
  RSQRT_D64_MM,
  RSQRT_S,
  RSQRT_S_MM,
  Restore16,
  RestoreX16,
  SAA,
  SAAD,
  SAT_S_B,
  SAT_S_D,
  SAT_S_H,
  SAT_S_W,
  SAT_U_B,
  SAT_U_D,
  SAT_U_H,
  SAT_U_W,
  SB,
  SB16_MM,
  SB16_MMR6,
  SB64,
  SBE,
  SBE_MM,
  SB_MM,
  SB_MMR6,
  SC,
  SC64,
  SC64_R6,
  SCD,
  SCD_R6,
  SCE,
  SCE_MM,
  SC_MM,
  SC_MMR6,
  SC_R6,
  SD,
  SDBBP,
  SDBBP16_MM,
  SDBBP16_MMR6,
  SDBBP_MM,
  SDBBP_MMR6,
  SDBBP_R6,
  SDC1,
  SDC164,
  SDC1_D64_MMR6,
  SDC1_MM_D32,
  SDC1_MM_D64,
  SDC2,
  SDC2_MMR6,
  SDC2_R6,
  SDC3,
  SDIV,
  SDIV_MM,
  SDL,
  SDR,
  SDXC1,
  SDXC164,
  SEB,
  SEB64,
  SEB_MM,
  SEH,
  SEH64,
  SEH_MM,
  SELEQZ,
  SELEQZ64,
  SELEQZ_D,
  SELEQZ_D_MMR6,
  SELEQZ_MMR6,
  SELEQZ_S,
  SELEQZ_S_MMR6,
  SELNEZ,
  SELNEZ64,
  SELNEZ_D,
  SELNEZ_D_MMR6,
  SELNEZ_MMR6,
  SELNEZ_S,
  SELNEZ_S_MMR6,
  SEL_D,
  SEL_D_MMR6,
  SEL_S,
  SEL_S_MMR6,
  SEQ,
  SEQi,
  SH,
  SH16_MM,
  SH16_MMR6,
  SH64,
  SHE,
  SHE_MM,
  SHF_B,
  SHF_H,
  SHF_W,
  SHILO,
  SHILOV,
  SHILOV_MM,
  SHILO_MM,
  SHLLV_PH,
  SHLLV_PH_MM,
  SHLLV_QB,
  SHLLV_QB_MM,
  SHLLV_S_PH,
  SHLLV_S_PH_MM,
  SHLLV_S_W,
  SHLLV_S_W_MM,
  SHLL_PH,
  SHLL_PH_MM,
  SHLL_QB,
  SHLL_QB_MM,
  SHLL_S_PH,
  SHLL_S_PH_MM,
  SHLL_S_W,
  SHLL_S_W_MM,
  SHRAV_PH,
  SHRAV_PH_MM,
  SHRAV_QB,
  SHRAV_QB_MMR2,
  SHRAV_R_PH,
  SHRAV_R_PH_MM,
  SHRAV_R_QB,
  SHRAV_R_QB_MMR2,
  SHRAV_R_W,
  SHRAV_R_W_MM,
  SHRA_PH,
  SHRA_PH_MM,
  SHRA_QB,
  SHRA_QB_MMR2,
  SHRA_R_PH,
  SHRA_R_PH_MM,
  SHRA_R_QB,
  SHRA_R_QB_MMR2,
  SHRA_R_W,
  SHRA_R_W_MM,
  SHRLV_PH,
  SHRLV_PH_MMR2,
  SHRLV_QB,
  SHRLV_QB_MM,
  SHRL_PH,
  SHRL_PH_MMR2,
  SHRL_QB,
  SHRL_QB_MM,
  SH_MM,
  SH_MMR6,
  SIGRIE,
  SIGRIE_MMR6,
  SLDI_B,
  SLDI_D,
  SLDI_H,
  SLDI_W,
  SLD_B,
  SLD_D,
  SLD_H,
  SLD_W,
  SLL,
  SLL16_MM,
  SLL16_MMR6,
  SLL64_32,
  SLL64_64,
  SLLI_B,
  SLLI_D,
  SLLI_H,
  SLLI_W,
  SLLV,
  SLLV_MM,
  SLL_B,
  SLL_D,
  SLL_H,
  SLL_MM,
  SLL_MMR6,
  SLL_W,
  SLT,
  SLT64,
  SLT_MM,
  SLTi,
  SLTi64,
  SLTi_MM,
  SLTiu,
  SLTiu64,
  SLTiu_MM,
  SLTu,
  SLTu64,
  SLTu_MM,
  SNE,
  SNEi,
  SPLATI_B,
  SPLATI_D,
  SPLATI_H,
  SPLATI_W,
  SPLAT_B,
  SPLAT_D,
  SPLAT_H,
  SPLAT_W,
  SRA,
  SRAI_B,
  SRAI_D,
  SRAI_H,
  SRAI_W,
  SRARI_B,
  SRARI_D,
  SRARI_H,
  SRARI_W,
  SRAR_B,
  SRAR_D,
  SRAR_H,
  SRAR_W,
  SRAV,
  SRAV_MM,
  SRA_B,
  SRA_D,
  SRA_H,
  SRA_MM,
  SRA_W,
  SRL,
  SRL16_MM,
  SRL16_MMR6,
  SRLI_B,
  SRLI_D,
  SRLI_H,
  SRLI_W,
  SRLRI_B,
  SRLRI_D,
  SRLRI_H,
  SRLRI_W,
  SRLR_B,
  SRLR_D,
  SRLR_H,
  SRLR_W,
  SRLV,
  SRLV_MM,
  SRL_B,
  SRL_D,
  SRL_H,
  SRL_MM,
  SRL_W,
  SSNOP,
  SSNOP_MM,
  SSNOP_MMR6,
  ST_B,
  ST_D,
  ST_H,
  ST_W,
  SUB,
  SUBQH_PH,
  SUBQH_PH_MMR2,
  SUBQH_R_PH,
  SUBQH_R_PH_MMR2,
  SUBQH_R_W,
  SUBQH_R_W_MMR2,
  SUBQH_W,
  SUBQH_W_MMR2,
  SUBQ_PH,
  SUBQ_PH_MM,
  SUBQ_S_PH,
  SUBQ_S_PH_MM,
  SUBQ_S_W,
  SUBQ_S_W_MM,
  SUBSUS_U_B,
  SUBSUS_U_D,
  SUBSUS_U_H,
  SUBSUS_U_W,
  SUBSUU_S_B,
  SUBSUU_S_D,
  SUBSUU_S_H,
  SUBSUU_S_W,
  SUBS_S_B,
  SUBS_S_D,
  SUBS_S_H,
  SUBS_S_W,
  SUBS_U_B,
  SUBS_U_D,
  SUBS_U_H,
  SUBS_U_W,
  SUBU16_MM,
  SUBU16_MMR6,
  SUBUH_QB,
  SUBUH_QB_MMR2,
  SUBUH_R_QB,
  SUBUH_R_QB_MMR2,
  SUBU_MMR6,
  SUBU_PH,
  SUBU_PH_MMR2,
  SUBU_QB,
  SUBU_QB_MM,
  SUBU_S_PH,
  SUBU_S_PH_MMR2,
  SUBU_S_QB,
  SUBU_S_QB_MM,
  SUBVI_B,
  SUBVI_D,
  SUBVI_H,
  SUBVI_W,
  SUBV_B,
  SUBV_D,
  SUBV_H,
  SUBV_W,
  SUB_MM,
  SUB_MMR6,
  SUBu,
  SUBu_MM,
  SUXC1,
  SUXC164,
  SUXC1_MM,
  SW,
  SW16_MM,
  SW16_MMR6,
  SW64,
  SWC1,
  SWC1_MM,
  SWC2,
  SWC2_MMR6,
  SWC2_R6,
  SWC3,
  SWDSP,
  SWDSP_MM,
  SWE,
  SWE_MM,
  SWL,
  SWL64,
  SWLE,
  SWLE_MM,
  SWL_MM,
  SWM16_MM,
  SWM16_MMR6,
  SWM32_MM,
  SWP_MM,
  SWR,
  SWR64,
  SWRE,
  SWRE_MM,
  SWR_MM,
  SWSP_MM,
  SWSP_MMR6,
  SWXC1,
  SWXC1_MM,
  SW_MM,
  SW_MMR6,
  SYNC,
  SYNCI,
  SYNCI_MM,
  SYNCI_MMR6,
  SYNC_MM,
  SYNC_MMR6,
  SYSCALL,
  SYSCALL_MM,
  Save16,
  SaveX16,
  SbRxRyOffMemX16,
  SebRx16,
  SehRx16,
  ShRxRyOffMemX16,
  SllX16,
  SllvRxRy16,
  SltRxRy16,
  SltiRxImm16,
  SltiRxImmX16,
  SltiuRxImm16,
  SltiuRxImmX16,
  SltuRxRy16,
  SraX16,
  SravRxRy16,
  SrlX16,
  SrlvRxRy16,
  SubuRxRyRz16,
  SwRxRyOffMemX16,
  SwRxSpImmX16,
  TEQ,
  TEQI,
  TEQI_MM,
  TEQ_MM,
  TGE,
  TGEI,
  TGEIU,
  TGEIU_MM,
  TGEI_MM,
  TGEU,
  TGEU_MM,
  TGE_MM,
  TLBGINV,
  TLBGINVF,
  TLBGINVF_MM,
  TLBGINV_MM,
  TLBGP,
  TLBGP_MM,
  TLBGR,
  TLBGR_MM,
  TLBGWI,
  TLBGWI_MM,
  TLBGWR,
  TLBGWR_MM,
  TLBINV,
  TLBINVF,
  TLBINVF_MMR6,
  TLBINV_MMR6,
  TLBP,
  TLBP_MM,
  TLBR,
  TLBR_MM,
  TLBWI,
  TLBWI_MM,
  TLBWR,
  TLBWR_MM,
  TLT,
  TLTI,
  TLTIU_MM,
  TLTI_MM,
  TLTU,
  TLTU_MM,
  TLT_MM,
  TNE,
  TNEI,
  TNEI_MM,
  TNE_MM,
  TRUNC_L_D64,
  TRUNC_L_D_MMR6,
  TRUNC_L_S,
  TRUNC_L_S_MMR6,
  TRUNC_W_D32,
  TRUNC_W_D64,
  TRUNC_W_D_MMR6,
  TRUNC_W_MM,
  TRUNC_W_S,
  TRUNC_W_S_MM,
  TRUNC_W_S_MMR6,
  TTLTIU,
  UDIV,
  UDIV_MM,
  V3MULU,
  VMM0,
  VMULU,
  VSHF_B,
  VSHF_D,
  VSHF_H,
  VSHF_W,
  WAIT,
  WAIT_MM,
  WAIT_MMR6,
  WRDSP,
  WRDSP_MM,
  WRPGPR_MMR6,
  WSBH,
  WSBH_MM,
  WSBH_MMR6,
  XOR,
  XOR16_MM,
  XOR16_MMR6,
  XOR64,
  XORI_B,
  XORI_MMR6,
  XOR_MM,
  XOR_MMR6,
  XOR_V,
  XORi,
  XORi64,
  XORi_MM,
  XorRxRxRy16,
  YIELD,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::INIT_UNDEF,
          12 => Opcode::SUBREG_TO_REG,
          13 => Opcode::COPY_TO_REGCLASS,
          14 => Opcode::DBG_VALUE,
          15 => Opcode::DBG_VALUE_LIST,
          16 => Opcode::DBG_INSTR_REF,
          17 => Opcode::DBG_PHI,
          18 => Opcode::DBG_LABEL,
          19 => Opcode::REG_SEQUENCE,
          20 => Opcode::COPY,
          21 => Opcode::BUNDLE,
          22 => Opcode::LIFETIME_START,
          23 => Opcode::LIFETIME_END,
          24 => Opcode::PSEUDO_PROBE,
          25 => Opcode::ARITH_FENCE,
          26 => Opcode::STACKMAP,
          27 => Opcode::FENTRY_CALL,
          28 => Opcode::PATCHPOINT,
          29 => Opcode::LOAD_STACK_GUARD,
          30 => Opcode::PREALLOCATED_SETUP,
          31 => Opcode::PREALLOCATED_ARG,
          32 => Opcode::STATEPOINT,
          33 => Opcode::LOCAL_ESCAPE,
          34 => Opcode::FAULTING_OP,
          35 => Opcode::PATCHABLE_OP,
          36 => Opcode::PATCHABLE_FUNCTION_ENTER,
          37 => Opcode::PATCHABLE_RET,
          38 => Opcode::PATCHABLE_FUNCTION_EXIT,
          39 => Opcode::PATCHABLE_TAIL_CALL,
          40 => Opcode::PATCHABLE_EVENT_CALL,
          41 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          42 => Opcode::ICALL_BRANCH_FUNNEL,
          43 => Opcode::FAKE_USE,
          44 => Opcode::MEMBARRIER,
          45 => Opcode::JUMP_TABLE_DEBUG_INFO,
          46 => Opcode::CONVERGENCECTRL_ENTRY,
          47 => Opcode::CONVERGENCECTRL_ANCHOR,
          48 => Opcode::CONVERGENCECTRL_LOOP,
          49 => Opcode::CONVERGENCECTRL_GLUE,
          50 => Opcode::G_ASSERT_SEXT,
          51 => Opcode::G_ASSERT_ZEXT,
          52 => Opcode::G_ASSERT_ALIGN,
          53 => Opcode::G_ADD,
          54 => Opcode::G_SUB,
          55 => Opcode::G_MUL,
          56 => Opcode::G_SDIV,
          57 => Opcode::G_UDIV,
          58 => Opcode::G_SREM,
          59 => Opcode::G_UREM,
          60 => Opcode::G_SDIVREM,
          61 => Opcode::G_UDIVREM,
          62 => Opcode::G_AND,
          63 => Opcode::G_OR,
          64 => Opcode::G_XOR,
          65 => Opcode::G_ABDS,
          66 => Opcode::G_ABDU,
          67 => Opcode::G_IMPLICIT_DEF,
          68 => Opcode::G_PHI,
          69 => Opcode::G_FRAME_INDEX,
          70 => Opcode::G_GLOBAL_VALUE,
          71 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          72 => Opcode::G_CONSTANT_POOL,
          73 => Opcode::G_EXTRACT,
          74 => Opcode::G_UNMERGE_VALUES,
          75 => Opcode::G_INSERT,
          76 => Opcode::G_MERGE_VALUES,
          77 => Opcode::G_BUILD_VECTOR,
          78 => Opcode::G_BUILD_VECTOR_TRUNC,
          79 => Opcode::G_CONCAT_VECTORS,
          80 => Opcode::G_PTRTOINT,
          81 => Opcode::G_INTTOPTR,
          82 => Opcode::G_BITCAST,
          83 => Opcode::G_FREEZE,
          84 => Opcode::G_CONSTANT_FOLD_BARRIER,
          85 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          86 => Opcode::G_INTRINSIC_TRUNC,
          87 => Opcode::G_INTRINSIC_ROUND,
          88 => Opcode::G_INTRINSIC_LRINT,
          89 => Opcode::G_INTRINSIC_LLRINT,
          90 => Opcode::G_INTRINSIC_ROUNDEVEN,
          91 => Opcode::G_READCYCLECOUNTER,
          92 => Opcode::G_READSTEADYCOUNTER,
          93 => Opcode::G_LOAD,
          94 => Opcode::G_SEXTLOAD,
          95 => Opcode::G_ZEXTLOAD,
          96 => Opcode::G_INDEXED_LOAD,
          97 => Opcode::G_INDEXED_SEXTLOAD,
          98 => Opcode::G_INDEXED_ZEXTLOAD,
          99 => Opcode::G_STORE,
          100 => Opcode::G_INDEXED_STORE,
          101 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          102 => Opcode::G_ATOMIC_CMPXCHG,
          103 => Opcode::G_ATOMICRMW_XCHG,
          104 => Opcode::G_ATOMICRMW_ADD,
          105 => Opcode::G_ATOMICRMW_SUB,
          106 => Opcode::G_ATOMICRMW_AND,
          107 => Opcode::G_ATOMICRMW_NAND,
          108 => Opcode::G_ATOMICRMW_OR,
          109 => Opcode::G_ATOMICRMW_XOR,
          110 => Opcode::G_ATOMICRMW_MAX,
          111 => Opcode::G_ATOMICRMW_MIN,
          112 => Opcode::G_ATOMICRMW_UMAX,
          113 => Opcode::G_ATOMICRMW_UMIN,
          114 => Opcode::G_ATOMICRMW_FADD,
          115 => Opcode::G_ATOMICRMW_FSUB,
          116 => Opcode::G_ATOMICRMW_FMAX,
          117 => Opcode::G_ATOMICRMW_FMIN,
          118 => Opcode::G_ATOMICRMW_FMAXIMUM,
          119 => Opcode::G_ATOMICRMW_FMINIMUM,
          120 => Opcode::G_ATOMICRMW_UINC_WRAP,
          121 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          122 => Opcode::G_ATOMICRMW_USUB_COND,
          123 => Opcode::G_ATOMICRMW_USUB_SAT,
          124 => Opcode::G_FENCE,
          125 => Opcode::G_PREFETCH,
          126 => Opcode::G_BRCOND,
          127 => Opcode::G_BRINDIRECT,
          128 => Opcode::G_INVOKE_REGION_START,
          129 => Opcode::G_INTRINSIC,
          130 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          131 => Opcode::G_INTRINSIC_CONVERGENT,
          132 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          133 => Opcode::G_ANYEXT,
          134 => Opcode::G_TRUNC,
          135 => Opcode::G_TRUNC_SSAT_S,
          136 => Opcode::G_TRUNC_SSAT_U,
          137 => Opcode::G_TRUNC_USAT_U,
          138 => Opcode::G_CONSTANT,
          139 => Opcode::G_FCONSTANT,
          140 => Opcode::G_VASTART,
          141 => Opcode::G_VAARG,
          142 => Opcode::G_SEXT,
          143 => Opcode::G_SEXT_INREG,
          144 => Opcode::G_ZEXT,
          145 => Opcode::G_SHL,
          146 => Opcode::G_LSHR,
          147 => Opcode::G_ASHR,
          148 => Opcode::G_FSHL,
          149 => Opcode::G_FSHR,
          150 => Opcode::G_ROTR,
          151 => Opcode::G_ROTL,
          152 => Opcode::G_ICMP,
          153 => Opcode::G_FCMP,
          154 => Opcode::G_SCMP,
          155 => Opcode::G_UCMP,
          156 => Opcode::G_SELECT,
          157 => Opcode::G_UADDO,
          158 => Opcode::G_UADDE,
          159 => Opcode::G_USUBO,
          160 => Opcode::G_USUBE,
          161 => Opcode::G_SADDO,
          162 => Opcode::G_SADDE,
          163 => Opcode::G_SSUBO,
          164 => Opcode::G_SSUBE,
          165 => Opcode::G_UMULO,
          166 => Opcode::G_SMULO,
          167 => Opcode::G_UMULH,
          168 => Opcode::G_SMULH,
          169 => Opcode::G_UADDSAT,
          170 => Opcode::G_SADDSAT,
          171 => Opcode::G_USUBSAT,
          172 => Opcode::G_SSUBSAT,
          173 => Opcode::G_USHLSAT,
          174 => Opcode::G_SSHLSAT,
          175 => Opcode::G_SMULFIX,
          176 => Opcode::G_UMULFIX,
          177 => Opcode::G_SMULFIXSAT,
          178 => Opcode::G_UMULFIXSAT,
          179 => Opcode::G_SDIVFIX,
          180 => Opcode::G_UDIVFIX,
          181 => Opcode::G_SDIVFIXSAT,
          182 => Opcode::G_UDIVFIXSAT,
          183 => Opcode::G_FADD,
          184 => Opcode::G_FSUB,
          185 => Opcode::G_FMUL,
          186 => Opcode::G_FMA,
          187 => Opcode::G_FMAD,
          188 => Opcode::G_FDIV,
          189 => Opcode::G_FREM,
          190 => Opcode::G_FPOW,
          191 => Opcode::G_FPOWI,
          192 => Opcode::G_FEXP,
          193 => Opcode::G_FEXP2,
          194 => Opcode::G_FEXP10,
          195 => Opcode::G_FLOG,
          196 => Opcode::G_FLOG2,
          197 => Opcode::G_FLOG10,
          198 => Opcode::G_FLDEXP,
          199 => Opcode::G_FFREXP,
          200 => Opcode::G_FNEG,
          201 => Opcode::G_FPEXT,
          202 => Opcode::G_FPTRUNC,
          203 => Opcode::G_FPTOSI,
          204 => Opcode::G_FPTOUI,
          205 => Opcode::G_SITOFP,
          206 => Opcode::G_UITOFP,
          207 => Opcode::G_FPTOSI_SAT,
          208 => Opcode::G_FPTOUI_SAT,
          209 => Opcode::G_FABS,
          210 => Opcode::G_FCOPYSIGN,
          211 => Opcode::G_IS_FPCLASS,
          212 => Opcode::G_FCANONICALIZE,
          213 => Opcode::G_FMINNUM,
          214 => Opcode::G_FMAXNUM,
          215 => Opcode::G_FMINNUM_IEEE,
          216 => Opcode::G_FMAXNUM_IEEE,
          217 => Opcode::G_FMINIMUM,
          218 => Opcode::G_FMAXIMUM,
          219 => Opcode::G_FMINIMUMNUM,
          220 => Opcode::G_FMAXIMUMNUM,
          221 => Opcode::G_GET_FPENV,
          222 => Opcode::G_SET_FPENV,
          223 => Opcode::G_RESET_FPENV,
          224 => Opcode::G_GET_FPMODE,
          225 => Opcode::G_SET_FPMODE,
          226 => Opcode::G_RESET_FPMODE,
          227 => Opcode::G_GET_ROUNDING,
          228 => Opcode::G_PTR_ADD,
          229 => Opcode::G_PTRMASK,
          230 => Opcode::G_SMIN,
          231 => Opcode::G_SMAX,
          232 => Opcode::G_UMIN,
          233 => Opcode::G_UMAX,
          234 => Opcode::G_ABS,
          235 => Opcode::G_LROUND,
          236 => Opcode::G_LLROUND,
          237 => Opcode::G_BR,
          238 => Opcode::G_BRJT,
          239 => Opcode::G_VSCALE,
          240 => Opcode::G_INSERT_SUBVECTOR,
          241 => Opcode::G_EXTRACT_SUBVECTOR,
          242 => Opcode::G_INSERT_VECTOR_ELT,
          243 => Opcode::G_EXTRACT_VECTOR_ELT,
          244 => Opcode::G_SHUFFLE_VECTOR,
          245 => Opcode::G_SPLAT_VECTOR,
          246 => Opcode::G_STEP_VECTOR,
          247 => Opcode::G_VECTOR_COMPRESS,
          248 => Opcode::G_CTTZ,
          249 => Opcode::G_CTTZ_ZERO_UNDEF,
          250 => Opcode::G_CTLZ,
          251 => Opcode::G_CTLZ_ZERO_UNDEF,
          252 => Opcode::G_CTPOP,
          253 => Opcode::G_BSWAP,
          254 => Opcode::G_BITREVERSE,
          255 => Opcode::G_FCEIL,
          256 => Opcode::G_FCOS,
          257 => Opcode::G_FSIN,
          258 => Opcode::G_FSINCOS,
          259 => Opcode::G_FTAN,
          260 => Opcode::G_FACOS,
          261 => Opcode::G_FASIN,
          262 => Opcode::G_FATAN,
          263 => Opcode::G_FATAN2,
          264 => Opcode::G_FCOSH,
          265 => Opcode::G_FSINH,
          266 => Opcode::G_FTANH,
          267 => Opcode::G_FSQRT,
          268 => Opcode::G_FFLOOR,
          269 => Opcode::G_FRINT,
          270 => Opcode::G_FNEARBYINT,
          271 => Opcode::G_ADDRSPACE_CAST,
          272 => Opcode::G_BLOCK_ADDR,
          273 => Opcode::G_JUMP_TABLE,
          274 => Opcode::G_DYN_STACKALLOC,
          275 => Opcode::G_STACKSAVE,
          276 => Opcode::G_STACKRESTORE,
          277 => Opcode::G_STRICT_FADD,
          278 => Opcode::G_STRICT_FSUB,
          279 => Opcode::G_STRICT_FMUL,
          280 => Opcode::G_STRICT_FDIV,
          281 => Opcode::G_STRICT_FREM,
          282 => Opcode::G_STRICT_FMA,
          283 => Opcode::G_STRICT_FSQRT,
          284 => Opcode::G_STRICT_FLDEXP,
          285 => Opcode::G_READ_REGISTER,
          286 => Opcode::G_WRITE_REGISTER,
          287 => Opcode::G_MEMCPY,
          288 => Opcode::G_MEMCPY_INLINE,
          289 => Opcode::G_MEMMOVE,
          290 => Opcode::G_MEMSET,
          291 => Opcode::G_BZERO,
          292 => Opcode::G_TRAP,
          293 => Opcode::G_DEBUGTRAP,
          294 => Opcode::G_UBSANTRAP,
          295 => Opcode::G_VECREDUCE_SEQ_FADD,
          296 => Opcode::G_VECREDUCE_SEQ_FMUL,
          297 => Opcode::G_VECREDUCE_FADD,
          298 => Opcode::G_VECREDUCE_FMUL,
          299 => Opcode::G_VECREDUCE_FMAX,
          300 => Opcode::G_VECREDUCE_FMIN,
          301 => Opcode::G_VECREDUCE_FMAXIMUM,
          302 => Opcode::G_VECREDUCE_FMINIMUM,
          303 => Opcode::G_VECREDUCE_ADD,
          304 => Opcode::G_VECREDUCE_MUL,
          305 => Opcode::G_VECREDUCE_AND,
          306 => Opcode::G_VECREDUCE_OR,
          307 => Opcode::G_VECREDUCE_XOR,
          308 => Opcode::G_VECREDUCE_SMAX,
          309 => Opcode::G_VECREDUCE_SMIN,
          310 => Opcode::G_VECREDUCE_UMAX,
          311 => Opcode::G_VECREDUCE_UMIN,
          312 => Opcode::G_SBFX,
          313 => Opcode::G_UBFX,
          314 => Opcode::ABSMacro,
          315 => Opcode::ADJCALLSTACKDOWN,
          316 => Opcode::ADJCALLSTACKUP,
          317 => Opcode::AND_V_D_PSEUDO,
          318 => Opcode::AND_V_H_PSEUDO,
          319 => Opcode::AND_V_W_PSEUDO,
          320 => Opcode::ATOMIC_CMP_SWAP_I16,
          321 => Opcode::ATOMIC_CMP_SWAP_I16_POSTRA,
          322 => Opcode::ATOMIC_CMP_SWAP_I32,
          323 => Opcode::ATOMIC_CMP_SWAP_I32_POSTRA,
          324 => Opcode::ATOMIC_CMP_SWAP_I64,
          325 => Opcode::ATOMIC_CMP_SWAP_I64_POSTRA,
          326 => Opcode::ATOMIC_CMP_SWAP_I8,
          327 => Opcode::ATOMIC_CMP_SWAP_I8_POSTRA,
          328 => Opcode::ATOMIC_LOAD_ADD_I16,
          329 => Opcode::ATOMIC_LOAD_ADD_I16_POSTRA,
          330 => Opcode::ATOMIC_LOAD_ADD_I32,
          331 => Opcode::ATOMIC_LOAD_ADD_I32_POSTRA,
          332 => Opcode::ATOMIC_LOAD_ADD_I64,
          333 => Opcode::ATOMIC_LOAD_ADD_I64_POSTRA,
          334 => Opcode::ATOMIC_LOAD_ADD_I8,
          335 => Opcode::ATOMIC_LOAD_ADD_I8_POSTRA,
          336 => Opcode::ATOMIC_LOAD_AND_I16,
          337 => Opcode::ATOMIC_LOAD_AND_I16_POSTRA,
          338 => Opcode::ATOMIC_LOAD_AND_I32,
          339 => Opcode::ATOMIC_LOAD_AND_I32_POSTRA,
          340 => Opcode::ATOMIC_LOAD_AND_I64,
          341 => Opcode::ATOMIC_LOAD_AND_I64_POSTRA,
          342 => Opcode::ATOMIC_LOAD_AND_I8,
          343 => Opcode::ATOMIC_LOAD_AND_I8_POSTRA,
          344 => Opcode::ATOMIC_LOAD_MAX_I16,
          345 => Opcode::ATOMIC_LOAD_MAX_I16_POSTRA,
          346 => Opcode::ATOMIC_LOAD_MAX_I32,
          347 => Opcode::ATOMIC_LOAD_MAX_I32_POSTRA,
          348 => Opcode::ATOMIC_LOAD_MAX_I64,
          349 => Opcode::ATOMIC_LOAD_MAX_I64_POSTRA,
          350 => Opcode::ATOMIC_LOAD_MAX_I8,
          351 => Opcode::ATOMIC_LOAD_MAX_I8_POSTRA,
          352 => Opcode::ATOMIC_LOAD_MIN_I16,
          353 => Opcode::ATOMIC_LOAD_MIN_I16_POSTRA,
          354 => Opcode::ATOMIC_LOAD_MIN_I32,
          355 => Opcode::ATOMIC_LOAD_MIN_I32_POSTRA,
          356 => Opcode::ATOMIC_LOAD_MIN_I64,
          357 => Opcode::ATOMIC_LOAD_MIN_I64_POSTRA,
          358 => Opcode::ATOMIC_LOAD_MIN_I8,
          359 => Opcode::ATOMIC_LOAD_MIN_I8_POSTRA,
          360 => Opcode::ATOMIC_LOAD_NAND_I16,
          361 => Opcode::ATOMIC_LOAD_NAND_I16_POSTRA,
          362 => Opcode::ATOMIC_LOAD_NAND_I32,
          363 => Opcode::ATOMIC_LOAD_NAND_I32_POSTRA,
          364 => Opcode::ATOMIC_LOAD_NAND_I64,
          365 => Opcode::ATOMIC_LOAD_NAND_I64_POSTRA,
          366 => Opcode::ATOMIC_LOAD_NAND_I8,
          367 => Opcode::ATOMIC_LOAD_NAND_I8_POSTRA,
          368 => Opcode::ATOMIC_LOAD_OR_I16,
          369 => Opcode::ATOMIC_LOAD_OR_I16_POSTRA,
          370 => Opcode::ATOMIC_LOAD_OR_I32,
          371 => Opcode::ATOMIC_LOAD_OR_I32_POSTRA,
          372 => Opcode::ATOMIC_LOAD_OR_I64,
          373 => Opcode::ATOMIC_LOAD_OR_I64_POSTRA,
          374 => Opcode::ATOMIC_LOAD_OR_I8,
          375 => Opcode::ATOMIC_LOAD_OR_I8_POSTRA,
          376 => Opcode::ATOMIC_LOAD_SUB_I16,
          377 => Opcode::ATOMIC_LOAD_SUB_I16_POSTRA,
          378 => Opcode::ATOMIC_LOAD_SUB_I32,
          379 => Opcode::ATOMIC_LOAD_SUB_I32_POSTRA,
          380 => Opcode::ATOMIC_LOAD_SUB_I64,
          381 => Opcode::ATOMIC_LOAD_SUB_I64_POSTRA,
          382 => Opcode::ATOMIC_LOAD_SUB_I8,
          383 => Opcode::ATOMIC_LOAD_SUB_I8_POSTRA,
          384 => Opcode::ATOMIC_LOAD_UMAX_I16,
          385 => Opcode::ATOMIC_LOAD_UMAX_I16_POSTRA,
          386 => Opcode::ATOMIC_LOAD_UMAX_I32,
          387 => Opcode::ATOMIC_LOAD_UMAX_I32_POSTRA,
          388 => Opcode::ATOMIC_LOAD_UMAX_I64,
          389 => Opcode::ATOMIC_LOAD_UMAX_I64_POSTRA,
          390 => Opcode::ATOMIC_LOAD_UMAX_I8,
          391 => Opcode::ATOMIC_LOAD_UMAX_I8_POSTRA,
          392 => Opcode::ATOMIC_LOAD_UMIN_I16,
          393 => Opcode::ATOMIC_LOAD_UMIN_I16_POSTRA,
          394 => Opcode::ATOMIC_LOAD_UMIN_I32,
          395 => Opcode::ATOMIC_LOAD_UMIN_I32_POSTRA,
          396 => Opcode::ATOMIC_LOAD_UMIN_I64,
          397 => Opcode::ATOMIC_LOAD_UMIN_I64_POSTRA,
          398 => Opcode::ATOMIC_LOAD_UMIN_I8,
          399 => Opcode::ATOMIC_LOAD_UMIN_I8_POSTRA,
          400 => Opcode::ATOMIC_LOAD_XOR_I16,
          401 => Opcode::ATOMIC_LOAD_XOR_I16_POSTRA,
          402 => Opcode::ATOMIC_LOAD_XOR_I32,
          403 => Opcode::ATOMIC_LOAD_XOR_I32_POSTRA,
          404 => Opcode::ATOMIC_LOAD_XOR_I64,
          405 => Opcode::ATOMIC_LOAD_XOR_I64_POSTRA,
          406 => Opcode::ATOMIC_LOAD_XOR_I8,
          407 => Opcode::ATOMIC_LOAD_XOR_I8_POSTRA,
          408 => Opcode::ATOMIC_SWAP_I16,
          409 => Opcode::ATOMIC_SWAP_I16_POSTRA,
          410 => Opcode::ATOMIC_SWAP_I32,
          411 => Opcode::ATOMIC_SWAP_I32_POSTRA,
          412 => Opcode::ATOMIC_SWAP_I64,
          413 => Opcode::ATOMIC_SWAP_I64_POSTRA,
          414 => Opcode::ATOMIC_SWAP_I8,
          415 => Opcode::ATOMIC_SWAP_I8_POSTRA,
          416 => Opcode::B,
          417 => Opcode::BAL_BR,
          418 => Opcode::BAL_BR_MM,
          419 => Opcode::BEQLImmMacro,
          420 => Opcode::BGE,
          421 => Opcode::BGEImmMacro,
          422 => Opcode::BGEL,
          423 => Opcode::BGELImmMacro,
          424 => Opcode::BGEU,
          425 => Opcode::BGEUImmMacro,
          426 => Opcode::BGEUL,
          427 => Opcode::BGEULImmMacro,
          428 => Opcode::BGT,
          429 => Opcode::BGTImmMacro,
          430 => Opcode::BGTL,
          431 => Opcode::BGTLImmMacro,
          432 => Opcode::BGTU,
          433 => Opcode::BGTUImmMacro,
          434 => Opcode::BGTUL,
          435 => Opcode::BGTULImmMacro,
          436 => Opcode::BLE,
          437 => Opcode::BLEImmMacro,
          438 => Opcode::BLEL,
          439 => Opcode::BLELImmMacro,
          440 => Opcode::BLEU,
          441 => Opcode::BLEUImmMacro,
          442 => Opcode::BLEUL,
          443 => Opcode::BLEULImmMacro,
          444 => Opcode::BLT,
          445 => Opcode::BLTImmMacro,
          446 => Opcode::BLTL,
          447 => Opcode::BLTLImmMacro,
          448 => Opcode::BLTU,
          449 => Opcode::BLTUImmMacro,
          450 => Opcode::BLTUL,
          451 => Opcode::BLTULImmMacro,
          452 => Opcode::BNELImmMacro,
          453 => Opcode::BPOSGE32_PSEUDO,
          454 => Opcode::BSEL_D_PSEUDO,
          455 => Opcode::BSEL_FD_PSEUDO,
          456 => Opcode::BSEL_FW_PSEUDO,
          457 => Opcode::BSEL_H_PSEUDO,
          458 => Opcode::BSEL_W_PSEUDO,
          459 => Opcode::B_MM,
          460 => Opcode::B_MMR6_Pseudo,
          461 => Opcode::B_MM_Pseudo,
          462 => Opcode::BeqImm,
          463 => Opcode::BneImm,
          464 => Opcode::BteqzT8CmpX16,
          465 => Opcode::BteqzT8CmpiX16,
          466 => Opcode::BteqzT8SltX16,
          467 => Opcode::BteqzT8SltiX16,
          468 => Opcode::BteqzT8SltiuX16,
          469 => Opcode::BteqzT8SltuX16,
          470 => Opcode::BtnezT8CmpX16,
          471 => Opcode::BtnezT8CmpiX16,
          472 => Opcode::BtnezT8SltX16,
          473 => Opcode::BtnezT8SltiX16,
          474 => Opcode::BtnezT8SltiuX16,
          475 => Opcode::BtnezT8SltuX16,
          476 => Opcode::BuildPairF64,
          477 => Opcode::BuildPairF64_64,
          478 => Opcode::CFTC1,
          479 => Opcode::CONSTPOOL_ENTRY,
          480 => Opcode::COPY_FD_PSEUDO,
          481 => Opcode::COPY_FW_PSEUDO,
          482 => Opcode::CTTC1,
          483 => Opcode::Constant32,
          484 => Opcode::DMULImmMacro,
          485 => Opcode::DMULMacro,
          486 => Opcode::DMULOMacro,
          487 => Opcode::DMULOUMacro,
          488 => Opcode::DROL,
          489 => Opcode::DROLImm,
          490 => Opcode::DROR,
          491 => Opcode::DRORImm,
          492 => Opcode::DSDivIMacro,
          493 => Opcode::DSDivMacro,
          494 => Opcode::DSRemIMacro,
          495 => Opcode::DSRemMacro,
          496 => Opcode::DUDivIMacro,
          497 => Opcode::DUDivMacro,
          498 => Opcode::DURemIMacro,
          499 => Opcode::DURemMacro,
          500 => Opcode::ERet,
          501 => Opcode::ExtractElementF64,
          502 => Opcode::ExtractElementF64_64,
          503 => Opcode::FABS_D,
          504 => Opcode::FABS_W,
          505 => Opcode::FEXP2_D_1_PSEUDO,
          506 => Opcode::FEXP2_W_1_PSEUDO,
          507 => Opcode::FILL_FD_PSEUDO,
          508 => Opcode::FILL_FW_PSEUDO,
          509 => Opcode::GotPrologue16,
          510 => Opcode::INSERT_B_VIDX64_PSEUDO,
          511 => Opcode::INSERT_B_VIDX_PSEUDO,
          512 => Opcode::INSERT_D_VIDX64_PSEUDO,
          513 => Opcode::INSERT_D_VIDX_PSEUDO,
          514 => Opcode::INSERT_FD_PSEUDO,
          515 => Opcode::INSERT_FD_VIDX64_PSEUDO,
          516 => Opcode::INSERT_FD_VIDX_PSEUDO,
          517 => Opcode::INSERT_FW_PSEUDO,
          518 => Opcode::INSERT_FW_VIDX64_PSEUDO,
          519 => Opcode::INSERT_FW_VIDX_PSEUDO,
          520 => Opcode::INSERT_H_VIDX64_PSEUDO,
          521 => Opcode::INSERT_H_VIDX_PSEUDO,
          522 => Opcode::INSERT_W_VIDX64_PSEUDO,
          523 => Opcode::INSERT_W_VIDX_PSEUDO,
          524 => Opcode::JALR64Pseudo,
          525 => Opcode::JALRHB64Pseudo,
          526 => Opcode::JALRHBPseudo,
          527 => Opcode::JALRPseudo,
          528 => Opcode::JAL_MMR6,
          529 => Opcode::JalOneReg,
          530 => Opcode::JalTwoReg,
          531 => Opcode::LDMacro,
          532 => Opcode::LDR_D,
          533 => Opcode::LDR_W,
          534 => Opcode::LD_F16,
          535 => Opcode::LOAD_ACC128,
          536 => Opcode::LOAD_ACC64,
          537 => Opcode::LOAD_ACC64DSP,
          538 => Opcode::LOAD_CCOND_DSP,
          539 => Opcode::LONG_BRANCH_ADDiu,
          540 => Opcode::LONG_BRANCH_ADDiu2Op,
          541 => Opcode::LONG_BRANCH_DADDiu,
          542 => Opcode::LONG_BRANCH_DADDiu2Op,
          543 => Opcode::LONG_BRANCH_LUi,
          544 => Opcode::LONG_BRANCH_LUi2Op,
          545 => Opcode::LONG_BRANCH_LUi2Op_64,
          546 => Opcode::LWM_MM,
          547 => Opcode::LoadAddrImm32,
          548 => Opcode::LoadAddrImm64,
          549 => Opcode::LoadAddrReg32,
          550 => Opcode::LoadAddrReg64,
          551 => Opcode::LoadImm32,
          552 => Opcode::LoadImm64,
          553 => Opcode::LoadImmDoubleFGR,
          554 => Opcode::LoadImmDoubleFGR_32,
          555 => Opcode::LoadImmDoubleGPR,
          556 => Opcode::LoadImmSingleFGR,
          557 => Opcode::LoadImmSingleGPR,
          558 => Opcode::LwConstant32,
          559 => Opcode::MFTACX,
          560 => Opcode::MFTC0,
          561 => Opcode::MFTC1,
          562 => Opcode::MFTDSP,
          563 => Opcode::MFTGPR,
          564 => Opcode::MFTHC1,
          565 => Opcode::MFTHI,
          566 => Opcode::MFTLO,
          567 => Opcode::MIPSeh_return32,
          568 => Opcode::MIPSeh_return64,
          569 => Opcode::MSA_FP_EXTEND_D_PSEUDO,
          570 => Opcode::MSA_FP_EXTEND_W_PSEUDO,
          571 => Opcode::MSA_FP_ROUND_D_PSEUDO,
          572 => Opcode::MSA_FP_ROUND_W_PSEUDO,
          573 => Opcode::MTTACX,
          574 => Opcode::MTTC0,
          575 => Opcode::MTTC1,
          576 => Opcode::MTTDSP,
          577 => Opcode::MTTGPR,
          578 => Opcode::MTTHC1,
          579 => Opcode::MTTHI,
          580 => Opcode::MTTLO,
          581 => Opcode::MULImmMacro,
          582 => Opcode::MULOMacro,
          583 => Opcode::MULOUMacro,
          584 => Opcode::MultRxRy16,
          585 => Opcode::MultRxRyRz16,
          586 => Opcode::MultuRxRy16,
          587 => Opcode::MultuRxRyRz16,
          588 => Opcode::NOP,
          589 => Opcode::NORImm,
          590 => Opcode::NORImm64,
          591 => Opcode::NOR_V_D_PSEUDO,
          592 => Opcode::NOR_V_H_PSEUDO,
          593 => Opcode::NOR_V_W_PSEUDO,
          594 => Opcode::OR_V_D_PSEUDO,
          595 => Opcode::OR_V_H_PSEUDO,
          596 => Opcode::OR_V_W_PSEUDO,
          597 => Opcode::PseudoCMPU_EQ_QB,
          598 => Opcode::PseudoCMPU_LE_QB,
          599 => Opcode::PseudoCMPU_LT_QB,
          600 => Opcode::PseudoCMP_EQ_PH,
          601 => Opcode::PseudoCMP_LE_PH,
          602 => Opcode::PseudoCMP_LT_PH,
          603 => Opcode::PseudoCVT_D32_W,
          604 => Opcode::PseudoCVT_D64_L,
          605 => Opcode::PseudoCVT_D64_W,
          606 => Opcode::PseudoCVT_S_L,
          607 => Opcode::PseudoCVT_S_W,
          608 => Opcode::PseudoDMULT,
          609 => Opcode::PseudoDMULTu,
          610 => Opcode::PseudoDSDIV,
          611 => Opcode::PseudoDUDIV,
          612 => Opcode::PseudoD_SELECT_I,
          613 => Opcode::PseudoD_SELECT_I64,
          614 => Opcode::PseudoIndirectBranch,
          615 => Opcode::PseudoIndirectBranch64,
          616 => Opcode::PseudoIndirectBranch64R6,
          617 => Opcode::PseudoIndirectBranchR6,
          618 => Opcode::PseudoIndirectBranch_MM,
          619 => Opcode::PseudoIndirectBranch_MMR6,
          620 => Opcode::PseudoIndirectHazardBranch,
          621 => Opcode::PseudoIndirectHazardBranch64,
          622 => Opcode::PseudoIndrectHazardBranch64R6,
          623 => Opcode::PseudoIndrectHazardBranchR6,
          624 => Opcode::PseudoMADD,
          625 => Opcode::PseudoMADDU,
          626 => Opcode::PseudoMADDU_MM,
          627 => Opcode::PseudoMADD_MM,
          628 => Opcode::PseudoMFHI,
          629 => Opcode::PseudoMFHI64,
          630 => Opcode::PseudoMFHI_MM,
          631 => Opcode::PseudoMFLO,
          632 => Opcode::PseudoMFLO64,
          633 => Opcode::PseudoMFLO_MM,
          634 => Opcode::PseudoMSUB,
          635 => Opcode::PseudoMSUBU,
          636 => Opcode::PseudoMSUBU_MM,
          637 => Opcode::PseudoMSUB_MM,
          638 => Opcode::PseudoMTLOHI,
          639 => Opcode::PseudoMTLOHI64,
          640 => Opcode::PseudoMTLOHI_DSP,
          641 => Opcode::PseudoMTLOHI_MM,
          642 => Opcode::PseudoMULT,
          643 => Opcode::PseudoMULT_MM,
          644 => Opcode::PseudoMULTu,
          645 => Opcode::PseudoMULTu_MM,
          646 => Opcode::PseudoPICK_PH,
          647 => Opcode::PseudoPICK_QB,
          648 => Opcode::PseudoReturn,
          649 => Opcode::PseudoReturn64,
          650 => Opcode::PseudoSDIV,
          651 => Opcode::PseudoSELECTFP_F_D32,
          652 => Opcode::PseudoSELECTFP_F_D64,
          653 => Opcode::PseudoSELECTFP_F_I,
          654 => Opcode::PseudoSELECTFP_F_I64,
          655 => Opcode::PseudoSELECTFP_F_S,
          656 => Opcode::PseudoSELECTFP_T_D32,
          657 => Opcode::PseudoSELECTFP_T_D64,
          658 => Opcode::PseudoSELECTFP_T_I,
          659 => Opcode::PseudoSELECTFP_T_I64,
          660 => Opcode::PseudoSELECTFP_T_S,
          661 => Opcode::PseudoSELECT_D32,
          662 => Opcode::PseudoSELECT_D64,
          663 => Opcode::PseudoSELECT_I,
          664 => Opcode::PseudoSELECT_I64,
          665 => Opcode::PseudoSELECT_S,
          666 => Opcode::PseudoTRUNC_W_D,
          667 => Opcode::PseudoTRUNC_W_D32,
          668 => Opcode::PseudoTRUNC_W_S,
          669 => Opcode::PseudoUDIV,
          670 => Opcode::ROL,
          671 => Opcode::ROLImm,
          672 => Opcode::ROR,
          673 => Opcode::RORImm,
          674 => Opcode::RetRA,
          675 => Opcode::RetRA16,
          676 => Opcode::SDC1_M1,
          677 => Opcode::SDIV_MM_Pseudo,
          678 => Opcode::SDMacro,
          679 => Opcode::SDivIMacro,
          680 => Opcode::SDivMacro,
          681 => Opcode::SEQIMacro,
          682 => Opcode::SEQMacro,
          683 => Opcode::SGE,
          684 => Opcode::SGEImm,
          685 => Opcode::SGEImm64,
          686 => Opcode::SGEU,
          687 => Opcode::SGEUImm,
          688 => Opcode::SGEUImm64,
          689 => Opcode::SGTImm,
          690 => Opcode::SGTImm64,
          691 => Opcode::SGTUImm,
          692 => Opcode::SGTUImm64,
          693 => Opcode::SLE,
          694 => Opcode::SLEImm,
          695 => Opcode::SLEImm64,
          696 => Opcode::SLEU,
          697 => Opcode::SLEUImm,
          698 => Opcode::SLEUImm64,
          699 => Opcode::SLTImm64,
          700 => Opcode::SLTUImm64,
          701 => Opcode::SNEIMacro,
          702 => Opcode::SNEMacro,
          703 => Opcode::SNZ_B_PSEUDO,
          704 => Opcode::SNZ_D_PSEUDO,
          705 => Opcode::SNZ_H_PSEUDO,
          706 => Opcode::SNZ_V_PSEUDO,
          707 => Opcode::SNZ_W_PSEUDO,
          708 => Opcode::SRemIMacro,
          709 => Opcode::SRemMacro,
          710 => Opcode::STORE_ACC128,
          711 => Opcode::STORE_ACC64,
          712 => Opcode::STORE_ACC64DSP,
          713 => Opcode::STORE_CCOND_DSP,
          714 => Opcode::STR_D,
          715 => Opcode::STR_W,
          716 => Opcode::ST_F16,
          717 => Opcode::SWM_MM,
          718 => Opcode::SZ_B_PSEUDO,
          719 => Opcode::SZ_D_PSEUDO,
          720 => Opcode::SZ_H_PSEUDO,
          721 => Opcode::SZ_V_PSEUDO,
          722 => Opcode::SZ_W_PSEUDO,
          723 => Opcode::SaaAddr,
          724 => Opcode::SaadAddr,
          725 => Opcode::SelBeqZ,
          726 => Opcode::SelBneZ,
          727 => Opcode::SelTBteqZCmp,
          728 => Opcode::SelTBteqZCmpi,
          729 => Opcode::SelTBteqZSlt,
          730 => Opcode::SelTBteqZSlti,
          731 => Opcode::SelTBteqZSltiu,
          732 => Opcode::SelTBteqZSltu,
          733 => Opcode::SelTBtneZCmp,
          734 => Opcode::SelTBtneZCmpi,
          735 => Opcode::SelTBtneZSlt,
          736 => Opcode::SelTBtneZSlti,
          737 => Opcode::SelTBtneZSltiu,
          738 => Opcode::SelTBtneZSltu,
          739 => Opcode::SltCCRxRy16,
          740 => Opcode::SltiCCRxImmX16,
          741 => Opcode::SltiuCCRxImmX16,
          742 => Opcode::SltuCCRxRy16,
          743 => Opcode::SltuRxRyRz16,
          744 => Opcode::TAILCALL,
          745 => Opcode::TAILCALL64R6REG,
          746 => Opcode::TAILCALLHB64R6REG,
          747 => Opcode::TAILCALLHBR6REG,
          748 => Opcode::TAILCALLR6REG,
          749 => Opcode::TAILCALLREG,
          750 => Opcode::TAILCALLREG64,
          751 => Opcode::TAILCALLREGHB,
          752 => Opcode::TAILCALLREGHB64,
          753 => Opcode::TAILCALLREG_MM,
          754 => Opcode::TAILCALLREG_MMR6,
          755 => Opcode::TAILCALL_MM,
          756 => Opcode::TAILCALL_MMR6,
          757 => Opcode::TRAP,
          758 => Opcode::TRAP_MM,
          759 => Opcode::UDIV_MM_Pseudo,
          760 => Opcode::UDivIMacro,
          761 => Opcode::UDivMacro,
          762 => Opcode::URemIMacro,
          763 => Opcode::URemMacro,
          764 => Opcode::Ulh,
          765 => Opcode::Ulhu,
          766 => Opcode::Ulw,
          767 => Opcode::Ush,
          768 => Opcode::Usw,
          769 => Opcode::XOR_V_D_PSEUDO,
          770 => Opcode::XOR_V_H_PSEUDO,
          771 => Opcode::XOR_V_W_PSEUDO,
          772 => Opcode::ABSQ_S_PH,
          773 => Opcode::ABSQ_S_PH_MM,
          774 => Opcode::ABSQ_S_QB,
          775 => Opcode::ABSQ_S_QB_MMR2,
          776 => Opcode::ABSQ_S_W,
          777 => Opcode::ABSQ_S_W_MM,
          778 => Opcode::ADD,
          779 => Opcode::ADDIUPC,
          780 => Opcode::ADDIUPC_MM,
          781 => Opcode::ADDIUPC_MMR6,
          782 => Opcode::ADDIUR1SP_MM,
          783 => Opcode::ADDIUR2_MM,
          784 => Opcode::ADDIUS5_MM,
          785 => Opcode::ADDIUSP_MM,
          786 => Opcode::ADDIU_MMR6,
          787 => Opcode::ADDQH_PH,
          788 => Opcode::ADDQH_PH_MMR2,
          789 => Opcode::ADDQH_R_PH,
          790 => Opcode::ADDQH_R_PH_MMR2,
          791 => Opcode::ADDQH_R_W,
          792 => Opcode::ADDQH_R_W_MMR2,
          793 => Opcode::ADDQH_W,
          794 => Opcode::ADDQH_W_MMR2,
          795 => Opcode::ADDQ_PH,
          796 => Opcode::ADDQ_PH_MM,
          797 => Opcode::ADDQ_S_PH,
          798 => Opcode::ADDQ_S_PH_MM,
          799 => Opcode::ADDQ_S_W,
          800 => Opcode::ADDQ_S_W_MM,
          801 => Opcode::ADDR_PS64,
          802 => Opcode::ADDSC,
          803 => Opcode::ADDSC_MM,
          804 => Opcode::ADDS_A_B,
          805 => Opcode::ADDS_A_D,
          806 => Opcode::ADDS_A_H,
          807 => Opcode::ADDS_A_W,
          808 => Opcode::ADDS_S_B,
          809 => Opcode::ADDS_S_D,
          810 => Opcode::ADDS_S_H,
          811 => Opcode::ADDS_S_W,
          812 => Opcode::ADDS_U_B,
          813 => Opcode::ADDS_U_D,
          814 => Opcode::ADDS_U_H,
          815 => Opcode::ADDS_U_W,
          816 => Opcode::ADDU16_MM,
          817 => Opcode::ADDU16_MMR6,
          818 => Opcode::ADDUH_QB,
          819 => Opcode::ADDUH_QB_MMR2,
          820 => Opcode::ADDUH_R_QB,
          821 => Opcode::ADDUH_R_QB_MMR2,
          822 => Opcode::ADDU_MMR6,
          823 => Opcode::ADDU_PH,
          824 => Opcode::ADDU_PH_MMR2,
          825 => Opcode::ADDU_QB,
          826 => Opcode::ADDU_QB_MM,
          827 => Opcode::ADDU_S_PH,
          828 => Opcode::ADDU_S_PH_MMR2,
          829 => Opcode::ADDU_S_QB,
          830 => Opcode::ADDU_S_QB_MM,
          831 => Opcode::ADDVI_B,
          832 => Opcode::ADDVI_D,
          833 => Opcode::ADDVI_H,
          834 => Opcode::ADDVI_W,
          835 => Opcode::ADDV_B,
          836 => Opcode::ADDV_D,
          837 => Opcode::ADDV_H,
          838 => Opcode::ADDV_W,
          839 => Opcode::ADDWC,
          840 => Opcode::ADDWC_MM,
          841 => Opcode::ADD_A_B,
          842 => Opcode::ADD_A_D,
          843 => Opcode::ADD_A_H,
          844 => Opcode::ADD_A_W,
          845 => Opcode::ADD_MM,
          846 => Opcode::ADD_MMR6,
          847 => Opcode::ADDi,
          848 => Opcode::ADDi_MM,
          849 => Opcode::ADDiu,
          850 => Opcode::ADDiu_MM,
          851 => Opcode::ADDu,
          852 => Opcode::ADDu_MM,
          853 => Opcode::ALIGN,
          854 => Opcode::ALIGN_MMR6,
          855 => Opcode::ALUIPC,
          856 => Opcode::ALUIPC_MMR6,
          857 => Opcode::AND,
          858 => Opcode::AND16_MM,
          859 => Opcode::AND16_MMR6,
          860 => Opcode::AND64,
          861 => Opcode::ANDI16_MM,
          862 => Opcode::ANDI16_MMR6,
          863 => Opcode::ANDI_B,
          864 => Opcode::ANDI_MMR6,
          865 => Opcode::AND_MM,
          866 => Opcode::AND_MMR6,
          867 => Opcode::AND_V,
          868 => Opcode::ANDi,
          869 => Opcode::ANDi64,
          870 => Opcode::ANDi_MM,
          871 => Opcode::APPEND,
          872 => Opcode::APPEND_MMR2,
          873 => Opcode::ASUB_S_B,
          874 => Opcode::ASUB_S_D,
          875 => Opcode::ASUB_S_H,
          876 => Opcode::ASUB_S_W,
          877 => Opcode::ASUB_U_B,
          878 => Opcode::ASUB_U_D,
          879 => Opcode::ASUB_U_H,
          880 => Opcode::ASUB_U_W,
          881 => Opcode::AUI,
          882 => Opcode::AUIPC,
          883 => Opcode::AUIPC_MMR6,
          884 => Opcode::AUI_MMR6,
          885 => Opcode::AVER_S_B,
          886 => Opcode::AVER_S_D,
          887 => Opcode::AVER_S_H,
          888 => Opcode::AVER_S_W,
          889 => Opcode::AVER_U_B,
          890 => Opcode::AVER_U_D,
          891 => Opcode::AVER_U_H,
          892 => Opcode::AVER_U_W,
          893 => Opcode::AVE_S_B,
          894 => Opcode::AVE_S_D,
          895 => Opcode::AVE_S_H,
          896 => Opcode::AVE_S_W,
          897 => Opcode::AVE_U_B,
          898 => Opcode::AVE_U_D,
          899 => Opcode::AVE_U_H,
          900 => Opcode::AVE_U_W,
          901 => Opcode::AddiuRxImmX16,
          902 => Opcode::AddiuRxPcImmX16,
          903 => Opcode::AddiuRxRxImm16,
          904 => Opcode::AddiuRxRxImmX16,
          905 => Opcode::AddiuRxRyOffMemX16,
          906 => Opcode::AddiuSpImm16,
          907 => Opcode::AddiuSpImmX16,
          908 => Opcode::AdduRxRyRz16,
          909 => Opcode::AndRxRxRy16,
          910 => Opcode::B16_MM,
          911 => Opcode::BADDu,
          912 => Opcode::BAL,
          913 => Opcode::BALC,
          914 => Opcode::BALC_MMR6,
          915 => Opcode::BALIGN,
          916 => Opcode::BALIGN_MMR2,
          917 => Opcode::BBIT0,
          918 => Opcode::BBIT032,
          919 => Opcode::BBIT1,
          920 => Opcode::BBIT132,
          921 => Opcode::BC,
          922 => Opcode::BC16_MMR6,
          923 => Opcode::BC1EQZ,
          924 => Opcode::BC1EQZC_MMR6,
          925 => Opcode::BC1F,
          926 => Opcode::BC1FL,
          927 => Opcode::BC1F_MM,
          928 => Opcode::BC1NEZ,
          929 => Opcode::BC1NEZC_MMR6,
          930 => Opcode::BC1T,
          931 => Opcode::BC1TL,
          932 => Opcode::BC1T_MM,
          933 => Opcode::BC2EQZ,
          934 => Opcode::BC2EQZC_MMR6,
          935 => Opcode::BC2NEZ,
          936 => Opcode::BC2NEZC_MMR6,
          937 => Opcode::BCLRI_B,
          938 => Opcode::BCLRI_D,
          939 => Opcode::BCLRI_H,
          940 => Opcode::BCLRI_W,
          941 => Opcode::BCLR_B,
          942 => Opcode::BCLR_D,
          943 => Opcode::BCLR_H,
          944 => Opcode::BCLR_W,
          945 => Opcode::BC_MMR6,
          946 => Opcode::BEQ,
          947 => Opcode::BEQ64,
          948 => Opcode::BEQC,
          949 => Opcode::BEQC64,
          950 => Opcode::BEQC_MMR6,
          951 => Opcode::BEQL,
          952 => Opcode::BEQZ16_MM,
          953 => Opcode::BEQZALC,
          954 => Opcode::BEQZALC_MMR6,
          955 => Opcode::BEQZC,
          956 => Opcode::BEQZC16_MMR6,
          957 => Opcode::BEQZC64,
          958 => Opcode::BEQZC_MM,
          959 => Opcode::BEQZC_MMR6,
          960 => Opcode::BEQ_MM,
          961 => Opcode::BGEC,
          962 => Opcode::BGEC64,
          963 => Opcode::BGEC_MMR6,
          964 => Opcode::BGEUC,
          965 => Opcode::BGEUC64,
          966 => Opcode::BGEUC_MMR6,
          967 => Opcode::BGEZ,
          968 => Opcode::BGEZ64,
          969 => Opcode::BGEZAL,
          970 => Opcode::BGEZALC,
          971 => Opcode::BGEZALC_MMR6,
          972 => Opcode::BGEZALL,
          973 => Opcode::BGEZALS_MM,
          974 => Opcode::BGEZAL_MM,
          975 => Opcode::BGEZC,
          976 => Opcode::BGEZC64,
          977 => Opcode::BGEZC_MMR6,
          978 => Opcode::BGEZL,
          979 => Opcode::BGEZ_MM,
          980 => Opcode::BGTZ,
          981 => Opcode::BGTZ64,
          982 => Opcode::BGTZALC,
          983 => Opcode::BGTZALC_MMR6,
          984 => Opcode::BGTZC,
          985 => Opcode::BGTZC64,
          986 => Opcode::BGTZC_MMR6,
          987 => Opcode::BGTZL,
          988 => Opcode::BGTZ_MM,
          989 => Opcode::BINSLI_B,
          990 => Opcode::BINSLI_D,
          991 => Opcode::BINSLI_H,
          992 => Opcode::BINSLI_W,
          993 => Opcode::BINSL_B,
          994 => Opcode::BINSL_D,
          995 => Opcode::BINSL_H,
          996 => Opcode::BINSL_W,
          997 => Opcode::BINSRI_B,
          998 => Opcode::BINSRI_D,
          999 => Opcode::BINSRI_H,
          1000 => Opcode::BINSRI_W,
          1001 => Opcode::BINSR_B,
          1002 => Opcode::BINSR_D,
          1003 => Opcode::BINSR_H,
          1004 => Opcode::BINSR_W,
          1005 => Opcode::BITREV,
          1006 => Opcode::BITREV_MM,
          1007 => Opcode::BITSWAP,
          1008 => Opcode::BITSWAP_MMR6,
          1009 => Opcode::BLEZ,
          1010 => Opcode::BLEZ64,
          1011 => Opcode::BLEZALC,
          1012 => Opcode::BLEZALC_MMR6,
          1013 => Opcode::BLEZC,
          1014 => Opcode::BLEZC64,
          1015 => Opcode::BLEZC_MMR6,
          1016 => Opcode::BLEZL,
          1017 => Opcode::BLEZ_MM,
          1018 => Opcode::BLTC,
          1019 => Opcode::BLTC64,
          1020 => Opcode::BLTC_MMR6,
          1021 => Opcode::BLTUC,
          1022 => Opcode::BLTUC64,
          1023 => Opcode::BLTUC_MMR6,
          1024 => Opcode::BLTZ,
          1025 => Opcode::BLTZ64,
          1026 => Opcode::BLTZAL,
          1027 => Opcode::BLTZALC,
          1028 => Opcode::BLTZALC_MMR6,
          1029 => Opcode::BLTZALL,
          1030 => Opcode::BLTZALS_MM,
          1031 => Opcode::BLTZAL_MM,
          1032 => Opcode::BLTZC,
          1033 => Opcode::BLTZC64,
          1034 => Opcode::BLTZC_MMR6,
          1035 => Opcode::BLTZL,
          1036 => Opcode::BLTZ_MM,
          1037 => Opcode::BMNZI_B,
          1038 => Opcode::BMNZ_V,
          1039 => Opcode::BMZI_B,
          1040 => Opcode::BMZ_V,
          1041 => Opcode::BNE,
          1042 => Opcode::BNE64,
          1043 => Opcode::BNEC,
          1044 => Opcode::BNEC64,
          1045 => Opcode::BNEC_MMR6,
          1046 => Opcode::BNEGI_B,
          1047 => Opcode::BNEGI_D,
          1048 => Opcode::BNEGI_H,
          1049 => Opcode::BNEGI_W,
          1050 => Opcode::BNEG_B,
          1051 => Opcode::BNEG_D,
          1052 => Opcode::BNEG_H,
          1053 => Opcode::BNEG_W,
          1054 => Opcode::BNEL,
          1055 => Opcode::BNEZ16_MM,
          1056 => Opcode::BNEZALC,
          1057 => Opcode::BNEZALC_MMR6,
          1058 => Opcode::BNEZC,
          1059 => Opcode::BNEZC16_MMR6,
          1060 => Opcode::BNEZC64,
          1061 => Opcode::BNEZC_MM,
          1062 => Opcode::BNEZC_MMR6,
          1063 => Opcode::BNE_MM,
          1064 => Opcode::BNVC,
          1065 => Opcode::BNVC_MMR6,
          1066 => Opcode::BNZ_B,
          1067 => Opcode::BNZ_D,
          1068 => Opcode::BNZ_H,
          1069 => Opcode::BNZ_V,
          1070 => Opcode::BNZ_W,
          1071 => Opcode::BOVC,
          1072 => Opcode::BOVC_MMR6,
          1073 => Opcode::BPOSGE32,
          1074 => Opcode::BPOSGE32C_MMR3,
          1075 => Opcode::BPOSGE32_MM,
          1076 => Opcode::BREAK,
          1077 => Opcode::BREAK16_MM,
          1078 => Opcode::BREAK16_MMR6,
          1079 => Opcode::BREAK_MM,
          1080 => Opcode::BREAK_MMR6,
          1081 => Opcode::BSELI_B,
          1082 => Opcode::BSEL_V,
          1083 => Opcode::BSETI_B,
          1084 => Opcode::BSETI_D,
          1085 => Opcode::BSETI_H,
          1086 => Opcode::BSETI_W,
          1087 => Opcode::BSET_B,
          1088 => Opcode::BSET_D,
          1089 => Opcode::BSET_H,
          1090 => Opcode::BSET_W,
          1091 => Opcode::BZ_B,
          1092 => Opcode::BZ_D,
          1093 => Opcode::BZ_H,
          1094 => Opcode::BZ_V,
          1095 => Opcode::BZ_W,
          1096 => Opcode::BeqzRxImm16,
          1097 => Opcode::BeqzRxImmX16,
          1098 => Opcode::Bimm16,
          1099 => Opcode::BimmX16,
          1100 => Opcode::BnezRxImm16,
          1101 => Opcode::BnezRxImmX16,
          1102 => Opcode::Break16,
          1103 => Opcode::Bteqz16,
          1104 => Opcode::BteqzX16,
          1105 => Opcode::Btnez16,
          1106 => Opcode::BtnezX16,
          1107 => Opcode::CACHE,
          1108 => Opcode::CACHEE,
          1109 => Opcode::CACHEE_MM,
          1110 => Opcode::CACHE_MM,
          1111 => Opcode::CACHE_MMR6,
          1112 => Opcode::CACHE_R6,
          1113 => Opcode::CEIL_L_D64,
          1114 => Opcode::CEIL_L_D_MMR6,
          1115 => Opcode::CEIL_L_S,
          1116 => Opcode::CEIL_L_S_MMR6,
          1117 => Opcode::CEIL_W_D32,
          1118 => Opcode::CEIL_W_D64,
          1119 => Opcode::CEIL_W_D_MMR6,
          1120 => Opcode::CEIL_W_MM,
          1121 => Opcode::CEIL_W_S,
          1122 => Opcode::CEIL_W_S_MM,
          1123 => Opcode::CEIL_W_S_MMR6,
          1124 => Opcode::CEQI_B,
          1125 => Opcode::CEQI_D,
          1126 => Opcode::CEQI_H,
          1127 => Opcode::CEQI_W,
          1128 => Opcode::CEQ_B,
          1129 => Opcode::CEQ_D,
          1130 => Opcode::CEQ_H,
          1131 => Opcode::CEQ_W,
          1132 => Opcode::CFC1,
          1133 => Opcode::CFC1_MM,
          1134 => Opcode::CFC2_MM,
          1135 => Opcode::CFCMSA,
          1136 => Opcode::CINS,
          1137 => Opcode::CINS32,
          1138 => Opcode::CINS64_32,
          1139 => Opcode::CINS_i32,
          1140 => Opcode::CLASS_D,
          1141 => Opcode::CLASS_D_MMR6,
          1142 => Opcode::CLASS_S,
          1143 => Opcode::CLASS_S_MMR6,
          1144 => Opcode::CLEI_S_B,
          1145 => Opcode::CLEI_S_D,
          1146 => Opcode::CLEI_S_H,
          1147 => Opcode::CLEI_S_W,
          1148 => Opcode::CLEI_U_B,
          1149 => Opcode::CLEI_U_D,
          1150 => Opcode::CLEI_U_H,
          1151 => Opcode::CLEI_U_W,
          1152 => Opcode::CLE_S_B,
          1153 => Opcode::CLE_S_D,
          1154 => Opcode::CLE_S_H,
          1155 => Opcode::CLE_S_W,
          1156 => Opcode::CLE_U_B,
          1157 => Opcode::CLE_U_D,
          1158 => Opcode::CLE_U_H,
          1159 => Opcode::CLE_U_W,
          1160 => Opcode::CLO,
          1161 => Opcode::CLO_MM,
          1162 => Opcode::CLO_MMR6,
          1163 => Opcode::CLO_R6,
          1164 => Opcode::CLTI_S_B,
          1165 => Opcode::CLTI_S_D,
          1166 => Opcode::CLTI_S_H,
          1167 => Opcode::CLTI_S_W,
          1168 => Opcode::CLTI_U_B,
          1169 => Opcode::CLTI_U_D,
          1170 => Opcode::CLTI_U_H,
          1171 => Opcode::CLTI_U_W,
          1172 => Opcode::CLT_S_B,
          1173 => Opcode::CLT_S_D,
          1174 => Opcode::CLT_S_H,
          1175 => Opcode::CLT_S_W,
          1176 => Opcode::CLT_U_B,
          1177 => Opcode::CLT_U_D,
          1178 => Opcode::CLT_U_H,
          1179 => Opcode::CLT_U_W,
          1180 => Opcode::CLZ,
          1181 => Opcode::CLZ_MM,
          1182 => Opcode::CLZ_MMR6,
          1183 => Opcode::CLZ_R6,
          1184 => Opcode::CMPGDU_EQ_QB,
          1185 => Opcode::CMPGDU_EQ_QB_MMR2,
          1186 => Opcode::CMPGDU_LE_QB,
          1187 => Opcode::CMPGDU_LE_QB_MMR2,
          1188 => Opcode::CMPGDU_LT_QB,
          1189 => Opcode::CMPGDU_LT_QB_MMR2,
          1190 => Opcode::CMPGU_EQ_QB,
          1191 => Opcode::CMPGU_EQ_QB_MM,
          1192 => Opcode::CMPGU_LE_QB,
          1193 => Opcode::CMPGU_LE_QB_MM,
          1194 => Opcode::CMPGU_LT_QB,
          1195 => Opcode::CMPGU_LT_QB_MM,
          1196 => Opcode::CMPU_EQ_QB,
          1197 => Opcode::CMPU_EQ_QB_MM,
          1198 => Opcode::CMPU_LE_QB,
          1199 => Opcode::CMPU_LE_QB_MM,
          1200 => Opcode::CMPU_LT_QB,
          1201 => Opcode::CMPU_LT_QB_MM,
          1202 => Opcode::CMP_AF_D_MMR6,
          1203 => Opcode::CMP_AF_S_MMR6,
          1204 => Opcode::CMP_EQ_D,
          1205 => Opcode::CMP_EQ_D_MMR6,
          1206 => Opcode::CMP_EQ_PH,
          1207 => Opcode::CMP_EQ_PH_MM,
          1208 => Opcode::CMP_EQ_S,
          1209 => Opcode::CMP_EQ_S_MMR6,
          1210 => Opcode::CMP_F_D,
          1211 => Opcode::CMP_F_S,
          1212 => Opcode::CMP_LE_D,
          1213 => Opcode::CMP_LE_D_MMR6,
          1214 => Opcode::CMP_LE_PH,
          1215 => Opcode::CMP_LE_PH_MM,
          1216 => Opcode::CMP_LE_S,
          1217 => Opcode::CMP_LE_S_MMR6,
          1218 => Opcode::CMP_LT_D,
          1219 => Opcode::CMP_LT_D_MMR6,
          1220 => Opcode::CMP_LT_PH,
          1221 => Opcode::CMP_LT_PH_MM,
          1222 => Opcode::CMP_LT_S,
          1223 => Opcode::CMP_LT_S_MMR6,
          1224 => Opcode::CMP_SAF_D,
          1225 => Opcode::CMP_SAF_D_MMR6,
          1226 => Opcode::CMP_SAF_S,
          1227 => Opcode::CMP_SAF_S_MMR6,
          1228 => Opcode::CMP_SEQ_D,
          1229 => Opcode::CMP_SEQ_D_MMR6,
          1230 => Opcode::CMP_SEQ_S,
          1231 => Opcode::CMP_SEQ_S_MMR6,
          1232 => Opcode::CMP_SLE_D,
          1233 => Opcode::CMP_SLE_D_MMR6,
          1234 => Opcode::CMP_SLE_S,
          1235 => Opcode::CMP_SLE_S_MMR6,
          1236 => Opcode::CMP_SLT_D,
          1237 => Opcode::CMP_SLT_D_MMR6,
          1238 => Opcode::CMP_SLT_S,
          1239 => Opcode::CMP_SLT_S_MMR6,
          1240 => Opcode::CMP_SUEQ_D,
          1241 => Opcode::CMP_SUEQ_D_MMR6,
          1242 => Opcode::CMP_SUEQ_S,
          1243 => Opcode::CMP_SUEQ_S_MMR6,
          1244 => Opcode::CMP_SULE_D,
          1245 => Opcode::CMP_SULE_D_MMR6,
          1246 => Opcode::CMP_SULE_S,
          1247 => Opcode::CMP_SULE_S_MMR6,
          1248 => Opcode::CMP_SULT_D,
          1249 => Opcode::CMP_SULT_D_MMR6,
          1250 => Opcode::CMP_SULT_S,
          1251 => Opcode::CMP_SULT_S_MMR6,
          1252 => Opcode::CMP_SUN_D,
          1253 => Opcode::CMP_SUN_D_MMR6,
          1254 => Opcode::CMP_SUN_S,
          1255 => Opcode::CMP_SUN_S_MMR6,
          1256 => Opcode::CMP_UEQ_D,
          1257 => Opcode::CMP_UEQ_D_MMR6,
          1258 => Opcode::CMP_UEQ_S,
          1259 => Opcode::CMP_UEQ_S_MMR6,
          1260 => Opcode::CMP_ULE_D,
          1261 => Opcode::CMP_ULE_D_MMR6,
          1262 => Opcode::CMP_ULE_S,
          1263 => Opcode::CMP_ULE_S_MMR6,
          1264 => Opcode::CMP_ULT_D,
          1265 => Opcode::CMP_ULT_D_MMR6,
          1266 => Opcode::CMP_ULT_S,
          1267 => Opcode::CMP_ULT_S_MMR6,
          1268 => Opcode::CMP_UN_D,
          1269 => Opcode::CMP_UN_D_MMR6,
          1270 => Opcode::CMP_UN_S,
          1271 => Opcode::CMP_UN_S_MMR6,
          1272 => Opcode::COPY_S_B,
          1273 => Opcode::COPY_S_D,
          1274 => Opcode::COPY_S_H,
          1275 => Opcode::COPY_S_W,
          1276 => Opcode::COPY_U_B,
          1277 => Opcode::COPY_U_H,
          1278 => Opcode::COPY_U_W,
          1279 => Opcode::CRC32B,
          1280 => Opcode::CRC32CB,
          1281 => Opcode::CRC32CD,
          1282 => Opcode::CRC32CH,
          1283 => Opcode::CRC32CW,
          1284 => Opcode::CRC32D,
          1285 => Opcode::CRC32H,
          1286 => Opcode::CRC32W,
          1287 => Opcode::CTC1,
          1288 => Opcode::CTC1_MM,
          1289 => Opcode::CTC2_MM,
          1290 => Opcode::CTCMSA,
          1291 => Opcode::CVT_D32_S,
          1292 => Opcode::CVT_D32_S_MM,
          1293 => Opcode::CVT_D32_W,
          1294 => Opcode::CVT_D32_W_MM,
          1295 => Opcode::CVT_D64_L,
          1296 => Opcode::CVT_D64_S,
          1297 => Opcode::CVT_D64_S_MM,
          1298 => Opcode::CVT_D64_W,
          1299 => Opcode::CVT_D64_W_MM,
          1300 => Opcode::CVT_D_L_MMR6,
          1301 => Opcode::CVT_L_D64,
          1302 => Opcode::CVT_L_D64_MM,
          1303 => Opcode::CVT_L_D_MMR6,
          1304 => Opcode::CVT_L_S,
          1305 => Opcode::CVT_L_S_MM,
          1306 => Opcode::CVT_L_S_MMR6,
          1307 => Opcode::CVT_PS_PW64,
          1308 => Opcode::CVT_PS_S64,
          1309 => Opcode::CVT_PW_PS64,
          1310 => Opcode::CVT_S_D32,
          1311 => Opcode::CVT_S_D32_MM,
          1312 => Opcode::CVT_S_D64,
          1313 => Opcode::CVT_S_D64_MM,
          1314 => Opcode::CVT_S_L,
          1315 => Opcode::CVT_S_L_MMR6,
          1316 => Opcode::CVT_S_PL64,
          1317 => Opcode::CVT_S_PU64,
          1318 => Opcode::CVT_S_W,
          1319 => Opcode::CVT_S_W_MM,
          1320 => Opcode::CVT_S_W_MMR6,
          1321 => Opcode::CVT_W_D32,
          1322 => Opcode::CVT_W_D32_MM,
          1323 => Opcode::CVT_W_D64,
          1324 => Opcode::CVT_W_D64_MM,
          1325 => Opcode::CVT_W_S,
          1326 => Opcode::CVT_W_S_MM,
          1327 => Opcode::CVT_W_S_MMR6,
          1328 => Opcode::C_EQ_D32,
          1329 => Opcode::C_EQ_D32_MM,
          1330 => Opcode::C_EQ_D64,
          1331 => Opcode::C_EQ_D64_MM,
          1332 => Opcode::C_EQ_S,
          1333 => Opcode::C_EQ_S_MM,
          1334 => Opcode::C_F_D32,
          1335 => Opcode::C_F_D32_MM,
          1336 => Opcode::C_F_D64,
          1337 => Opcode::C_F_D64_MM,
          1338 => Opcode::C_F_S,
          1339 => Opcode::C_F_S_MM,
          1340 => Opcode::C_LE_D32,
          1341 => Opcode::C_LE_D32_MM,
          1342 => Opcode::C_LE_D64,
          1343 => Opcode::C_LE_D64_MM,
          1344 => Opcode::C_LE_S,
          1345 => Opcode::C_LE_S_MM,
          1346 => Opcode::C_LT_D32,
          1347 => Opcode::C_LT_D32_MM,
          1348 => Opcode::C_LT_D64,
          1349 => Opcode::C_LT_D64_MM,
          1350 => Opcode::C_LT_S,
          1351 => Opcode::C_LT_S_MM,
          1352 => Opcode::C_NGE_D32,
          1353 => Opcode::C_NGE_D32_MM,
          1354 => Opcode::C_NGE_D64,
          1355 => Opcode::C_NGE_D64_MM,
          1356 => Opcode::C_NGE_S,
          1357 => Opcode::C_NGE_S_MM,
          1358 => Opcode::C_NGLE_D32,
          1359 => Opcode::C_NGLE_D32_MM,
          1360 => Opcode::C_NGLE_D64,
          1361 => Opcode::C_NGLE_D64_MM,
          1362 => Opcode::C_NGLE_S,
          1363 => Opcode::C_NGLE_S_MM,
          1364 => Opcode::C_NGL_D32,
          1365 => Opcode::C_NGL_D32_MM,
          1366 => Opcode::C_NGL_D64,
          1367 => Opcode::C_NGL_D64_MM,
          1368 => Opcode::C_NGL_S,
          1369 => Opcode::C_NGL_S_MM,
          1370 => Opcode::C_NGT_D32,
          1371 => Opcode::C_NGT_D32_MM,
          1372 => Opcode::C_NGT_D64,
          1373 => Opcode::C_NGT_D64_MM,
          1374 => Opcode::C_NGT_S,
          1375 => Opcode::C_NGT_S_MM,
          1376 => Opcode::C_OLE_D32,
          1377 => Opcode::C_OLE_D32_MM,
          1378 => Opcode::C_OLE_D64,
          1379 => Opcode::C_OLE_D64_MM,
          1380 => Opcode::C_OLE_S,
          1381 => Opcode::C_OLE_S_MM,
          1382 => Opcode::C_OLT_D32,
          1383 => Opcode::C_OLT_D32_MM,
          1384 => Opcode::C_OLT_D64,
          1385 => Opcode::C_OLT_D64_MM,
          1386 => Opcode::C_OLT_S,
          1387 => Opcode::C_OLT_S_MM,
          1388 => Opcode::C_SEQ_D32,
          1389 => Opcode::C_SEQ_D32_MM,
          1390 => Opcode::C_SEQ_D64,
          1391 => Opcode::C_SEQ_D64_MM,
          1392 => Opcode::C_SEQ_S,
          1393 => Opcode::C_SEQ_S_MM,
          1394 => Opcode::C_SF_D32,
          1395 => Opcode::C_SF_D32_MM,
          1396 => Opcode::C_SF_D64,
          1397 => Opcode::C_SF_D64_MM,
          1398 => Opcode::C_SF_S,
          1399 => Opcode::C_SF_S_MM,
          1400 => Opcode::C_UEQ_D32,
          1401 => Opcode::C_UEQ_D32_MM,
          1402 => Opcode::C_UEQ_D64,
          1403 => Opcode::C_UEQ_D64_MM,
          1404 => Opcode::C_UEQ_S,
          1405 => Opcode::C_UEQ_S_MM,
          1406 => Opcode::C_ULE_D32,
          1407 => Opcode::C_ULE_D32_MM,
          1408 => Opcode::C_ULE_D64,
          1409 => Opcode::C_ULE_D64_MM,
          1410 => Opcode::C_ULE_S,
          1411 => Opcode::C_ULE_S_MM,
          1412 => Opcode::C_ULT_D32,
          1413 => Opcode::C_ULT_D32_MM,
          1414 => Opcode::C_ULT_D64,
          1415 => Opcode::C_ULT_D64_MM,
          1416 => Opcode::C_ULT_S,
          1417 => Opcode::C_ULT_S_MM,
          1418 => Opcode::C_UN_D32,
          1419 => Opcode::C_UN_D32_MM,
          1420 => Opcode::C_UN_D64,
          1421 => Opcode::C_UN_D64_MM,
          1422 => Opcode::C_UN_S,
          1423 => Opcode::C_UN_S_MM,
          1424 => Opcode::CmpRxRy16,
          1425 => Opcode::CmpiRxImm16,
          1426 => Opcode::CmpiRxImmX16,
          1427 => Opcode::DADD,
          1428 => Opcode::DADDi,
          1429 => Opcode::DADDiu,
          1430 => Opcode::DADDu,
          1431 => Opcode::DAHI,
          1432 => Opcode::DALIGN,
          1433 => Opcode::DATI,
          1434 => Opcode::DAUI,
          1435 => Opcode::DBITSWAP,
          1436 => Opcode::DCLO,
          1437 => Opcode::DCLO_R6,
          1438 => Opcode::DCLZ,
          1439 => Opcode::DCLZ_R6,
          1440 => Opcode::DDIV,
          1441 => Opcode::DDIVU,
          1442 => Opcode::DERET,
          1443 => Opcode::DERET_MM,
          1444 => Opcode::DERET_MMR6,
          1445 => Opcode::DEXT,
          1446 => Opcode::DEXT64_32,
          1447 => Opcode::DEXTM,
          1448 => Opcode::DEXTU,
          1449 => Opcode::DI,
          1450 => Opcode::DINS,
          1451 => Opcode::DINSM,
          1452 => Opcode::DINSU,
          1453 => Opcode::DIV,
          1454 => Opcode::DIVU,
          1455 => Opcode::DIVU_MMR6,
          1456 => Opcode::DIV_MMR6,
          1457 => Opcode::DIV_S_B,
          1458 => Opcode::DIV_S_D,
          1459 => Opcode::DIV_S_H,
          1460 => Opcode::DIV_S_W,
          1461 => Opcode::DIV_U_B,
          1462 => Opcode::DIV_U_D,
          1463 => Opcode::DIV_U_H,
          1464 => Opcode::DIV_U_W,
          1465 => Opcode::DI_MM,
          1466 => Opcode::DI_MMR6,
          1467 => Opcode::DLSA,
          1468 => Opcode::DLSA_R6,
          1469 => Opcode::DMFC0,
          1470 => Opcode::DMFC1,
          1471 => Opcode::DMFC2,
          1472 => Opcode::DMFC2_OCTEON,
          1473 => Opcode::DMFGC0,
          1474 => Opcode::DMOD,
          1475 => Opcode::DMODU,
          1476 => Opcode::DMT,
          1477 => Opcode::DMTC0,
          1478 => Opcode::DMTC1,
          1479 => Opcode::DMTC2,
          1480 => Opcode::DMTC2_OCTEON,
          1481 => Opcode::DMTGC0,
          1482 => Opcode::DMUH,
          1483 => Opcode::DMUHU,
          1484 => Opcode::DMUL,
          1485 => Opcode::DMULT,
          1486 => Opcode::DMULTu,
          1487 => Opcode::DMULU,
          1488 => Opcode::DMUL_R6,
          1489 => Opcode::DOTP_S_D,
          1490 => Opcode::DOTP_S_H,
          1491 => Opcode::DOTP_S_W,
          1492 => Opcode::DOTP_U_D,
          1493 => Opcode::DOTP_U_H,
          1494 => Opcode::DOTP_U_W,
          1495 => Opcode::DPADD_S_D,
          1496 => Opcode::DPADD_S_H,
          1497 => Opcode::DPADD_S_W,
          1498 => Opcode::DPADD_U_D,
          1499 => Opcode::DPADD_U_H,
          1500 => Opcode::DPADD_U_W,
          1501 => Opcode::DPAQX_SA_W_PH,
          1502 => Opcode::DPAQX_SA_W_PH_MMR2,
          1503 => Opcode::DPAQX_S_W_PH,
          1504 => Opcode::DPAQX_S_W_PH_MMR2,
          1505 => Opcode::DPAQ_SA_L_W,
          1506 => Opcode::DPAQ_SA_L_W_MM,
          1507 => Opcode::DPAQ_S_W_PH,
          1508 => Opcode::DPAQ_S_W_PH_MM,
          1509 => Opcode::DPAU_H_QBL,
          1510 => Opcode::DPAU_H_QBL_MM,
          1511 => Opcode::DPAU_H_QBR,
          1512 => Opcode::DPAU_H_QBR_MM,
          1513 => Opcode::DPAX_W_PH,
          1514 => Opcode::DPAX_W_PH_MMR2,
          1515 => Opcode::DPA_W_PH,
          1516 => Opcode::DPA_W_PH_MMR2,
          1517 => Opcode::DPOP,
          1518 => Opcode::DPSQX_SA_W_PH,
          1519 => Opcode::DPSQX_SA_W_PH_MMR2,
          1520 => Opcode::DPSQX_S_W_PH,
          1521 => Opcode::DPSQX_S_W_PH_MMR2,
          1522 => Opcode::DPSQ_SA_L_W,
          1523 => Opcode::DPSQ_SA_L_W_MM,
          1524 => Opcode::DPSQ_S_W_PH,
          1525 => Opcode::DPSQ_S_W_PH_MM,
          1526 => Opcode::DPSUB_S_D,
          1527 => Opcode::DPSUB_S_H,
          1528 => Opcode::DPSUB_S_W,
          1529 => Opcode::DPSUB_U_D,
          1530 => Opcode::DPSUB_U_H,
          1531 => Opcode::DPSUB_U_W,
          1532 => Opcode::DPSU_H_QBL,
          1533 => Opcode::DPSU_H_QBL_MM,
          1534 => Opcode::DPSU_H_QBR,
          1535 => Opcode::DPSU_H_QBR_MM,
          1536 => Opcode::DPSX_W_PH,
          1537 => Opcode::DPSX_W_PH_MMR2,
          1538 => Opcode::DPS_W_PH,
          1539 => Opcode::DPS_W_PH_MMR2,
          1540 => Opcode::DROTR,
          1541 => Opcode::DROTR32,
          1542 => Opcode::DROTRV,
          1543 => Opcode::DSBH,
          1544 => Opcode::DSDIV,
          1545 => Opcode::DSHD,
          1546 => Opcode::DSLL,
          1547 => Opcode::DSLL32,
          1548 => Opcode::DSLL64_32,
          1549 => Opcode::DSLLV,
          1550 => Opcode::DSRA,
          1551 => Opcode::DSRA32,
          1552 => Opcode::DSRAV,
          1553 => Opcode::DSRL,
          1554 => Opcode::DSRL32,
          1555 => Opcode::DSRLV,
          1556 => Opcode::DSUB,
          1557 => Opcode::DSUBu,
          1558 => Opcode::DUDIV,
          1559 => Opcode::DVP,
          1560 => Opcode::DVPE,
          1561 => Opcode::DVP_MMR6,
          1562 => Opcode::DivRxRy16,
          1563 => Opcode::DivuRxRy16,
          1564 => Opcode::EHB,
          1565 => Opcode::EHB_MM,
          1566 => Opcode::EHB_MMR6,
          1567 => Opcode::EI,
          1568 => Opcode::EI_MM,
          1569 => Opcode::EI_MMR6,
          1570 => Opcode::EMT,
          1571 => Opcode::ERET,
          1572 => Opcode::ERETNC,
          1573 => Opcode::ERETNC_MMR6,
          1574 => Opcode::ERET_MM,
          1575 => Opcode::ERET_MMR6,
          1576 => Opcode::EVP,
          1577 => Opcode::EVPE,
          1578 => Opcode::EVP_MMR6,
          1579 => Opcode::EXT,
          1580 => Opcode::EXTP,
          1581 => Opcode::EXTPDP,
          1582 => Opcode::EXTPDPV,
          1583 => Opcode::EXTPDPV_MM,
          1584 => Opcode::EXTPDP_MM,
          1585 => Opcode::EXTPV,
          1586 => Opcode::EXTPV_MM,
          1587 => Opcode::EXTP_MM,
          1588 => Opcode::EXTRV_RS_W,
          1589 => Opcode::EXTRV_RS_W_MM,
          1590 => Opcode::EXTRV_R_W,
          1591 => Opcode::EXTRV_R_W_MM,
          1592 => Opcode::EXTRV_S_H,
          1593 => Opcode::EXTRV_S_H_MM,
          1594 => Opcode::EXTRV_W,
          1595 => Opcode::EXTRV_W_MM,
          1596 => Opcode::EXTR_RS_W,
          1597 => Opcode::EXTR_RS_W_MM,
          1598 => Opcode::EXTR_R_W,
          1599 => Opcode::EXTR_R_W_MM,
          1600 => Opcode::EXTR_S_H,
          1601 => Opcode::EXTR_S_H_MM,
          1602 => Opcode::EXTR_W,
          1603 => Opcode::EXTR_W_MM,
          1604 => Opcode::EXTS,
          1605 => Opcode::EXTS32,
          1606 => Opcode::EXT_MM,
          1607 => Opcode::EXT_MMR6,
          1608 => Opcode::FABS_D32,
          1609 => Opcode::FABS_D32_MM,
          1610 => Opcode::FABS_D64,
          1611 => Opcode::FABS_D64_MM,
          1612 => Opcode::FABS_S,
          1613 => Opcode::FABS_S_MM,
          1614 => Opcode::FADD_D,
          1615 => Opcode::FADD_D32,
          1616 => Opcode::FADD_D32_MM,
          1617 => Opcode::FADD_D64,
          1618 => Opcode::FADD_D64_MM,
          1619 => Opcode::FADD_PS64,
          1620 => Opcode::FADD_S,
          1621 => Opcode::FADD_S_MM,
          1622 => Opcode::FADD_S_MMR6,
          1623 => Opcode::FADD_W,
          1624 => Opcode::FCAF_D,
          1625 => Opcode::FCAF_W,
          1626 => Opcode::FCEQ_D,
          1627 => Opcode::FCEQ_W,
          1628 => Opcode::FCLASS_D,
          1629 => Opcode::FCLASS_W,
          1630 => Opcode::FCLE_D,
          1631 => Opcode::FCLE_W,
          1632 => Opcode::FCLT_D,
          1633 => Opcode::FCLT_W,
          1634 => Opcode::FCMP_D32,
          1635 => Opcode::FCMP_D32_MM,
          1636 => Opcode::FCMP_D64,
          1637 => Opcode::FCMP_S32,
          1638 => Opcode::FCMP_S32_MM,
          1639 => Opcode::FCNE_D,
          1640 => Opcode::FCNE_W,
          1641 => Opcode::FCOR_D,
          1642 => Opcode::FCOR_W,
          1643 => Opcode::FCUEQ_D,
          1644 => Opcode::FCUEQ_W,
          1645 => Opcode::FCULE_D,
          1646 => Opcode::FCULE_W,
          1647 => Opcode::FCULT_D,
          1648 => Opcode::FCULT_W,
          1649 => Opcode::FCUNE_D,
          1650 => Opcode::FCUNE_W,
          1651 => Opcode::FCUN_D,
          1652 => Opcode::FCUN_W,
          1653 => Opcode::FDIV_D,
          1654 => Opcode::FDIV_D32,
          1655 => Opcode::FDIV_D32_MM,
          1656 => Opcode::FDIV_D64,
          1657 => Opcode::FDIV_D64_MM,
          1658 => Opcode::FDIV_S,
          1659 => Opcode::FDIV_S_MM,
          1660 => Opcode::FDIV_S_MMR6,
          1661 => Opcode::FDIV_W,
          1662 => Opcode::FEXDO_H,
          1663 => Opcode::FEXDO_W,
          1664 => Opcode::FEXP2_D,
          1665 => Opcode::FEXP2_W,
          1666 => Opcode::FEXUPL_D,
          1667 => Opcode::FEXUPL_W,
          1668 => Opcode::FEXUPR_D,
          1669 => Opcode::FEXUPR_W,
          1670 => Opcode::FFINT_S_D,
          1671 => Opcode::FFINT_S_W,
          1672 => Opcode::FFINT_U_D,
          1673 => Opcode::FFINT_U_W,
          1674 => Opcode::FFQL_D,
          1675 => Opcode::FFQL_W,
          1676 => Opcode::FFQR_D,
          1677 => Opcode::FFQR_W,
          1678 => Opcode::FILL_B,
          1679 => Opcode::FILL_D,
          1680 => Opcode::FILL_H,
          1681 => Opcode::FILL_W,
          1682 => Opcode::FLOG2_D,
          1683 => Opcode::FLOG2_W,
          1684 => Opcode::FLOOR_L_D64,
          1685 => Opcode::FLOOR_L_D_MMR6,
          1686 => Opcode::FLOOR_L_S,
          1687 => Opcode::FLOOR_L_S_MMR6,
          1688 => Opcode::FLOOR_W_D32,
          1689 => Opcode::FLOOR_W_D64,
          1690 => Opcode::FLOOR_W_D_MMR6,
          1691 => Opcode::FLOOR_W_MM,
          1692 => Opcode::FLOOR_W_S,
          1693 => Opcode::FLOOR_W_S_MM,
          1694 => Opcode::FLOOR_W_S_MMR6,
          1695 => Opcode::FMADD_D,
          1696 => Opcode::FMADD_W,
          1697 => Opcode::FMAX_A_D,
          1698 => Opcode::FMAX_A_W,
          1699 => Opcode::FMAX_D,
          1700 => Opcode::FMAX_W,
          1701 => Opcode::FMIN_A_D,
          1702 => Opcode::FMIN_A_W,
          1703 => Opcode::FMIN_D,
          1704 => Opcode::FMIN_W,
          1705 => Opcode::FMOV_D32,
          1706 => Opcode::FMOV_D32_MM,
          1707 => Opcode::FMOV_D64,
          1708 => Opcode::FMOV_D64_MM,
          1709 => Opcode::FMOV_D_MMR6,
          1710 => Opcode::FMOV_S,
          1711 => Opcode::FMOV_S_MM,
          1712 => Opcode::FMOV_S_MMR6,
          1713 => Opcode::FMSUB_D,
          1714 => Opcode::FMSUB_W,
          1715 => Opcode::FMUL_D,
          1716 => Opcode::FMUL_D32,
          1717 => Opcode::FMUL_D32_MM,
          1718 => Opcode::FMUL_D64,
          1719 => Opcode::FMUL_D64_MM,
          1720 => Opcode::FMUL_PS64,
          1721 => Opcode::FMUL_S,
          1722 => Opcode::FMUL_S_MM,
          1723 => Opcode::FMUL_S_MMR6,
          1724 => Opcode::FMUL_W,
          1725 => Opcode::FNEG_D32,
          1726 => Opcode::FNEG_D32_MM,
          1727 => Opcode::FNEG_D64,
          1728 => Opcode::FNEG_D64_MM,
          1729 => Opcode::FNEG_S,
          1730 => Opcode::FNEG_S_MM,
          1731 => Opcode::FNEG_S_MMR6,
          1732 => Opcode::FORK,
          1733 => Opcode::FRCP_D,
          1734 => Opcode::FRCP_W,
          1735 => Opcode::FRINT_D,
          1736 => Opcode::FRINT_W,
          1737 => Opcode::FRSQRT_D,
          1738 => Opcode::FRSQRT_W,
          1739 => Opcode::FSAF_D,
          1740 => Opcode::FSAF_W,
          1741 => Opcode::FSEQ_D,
          1742 => Opcode::FSEQ_W,
          1743 => Opcode::FSLE_D,
          1744 => Opcode::FSLE_W,
          1745 => Opcode::FSLT_D,
          1746 => Opcode::FSLT_W,
          1747 => Opcode::FSNE_D,
          1748 => Opcode::FSNE_W,
          1749 => Opcode::FSOR_D,
          1750 => Opcode::FSOR_W,
          1751 => Opcode::FSQRT_D,
          1752 => Opcode::FSQRT_D32,
          1753 => Opcode::FSQRT_D32_MM,
          1754 => Opcode::FSQRT_D64,
          1755 => Opcode::FSQRT_D64_MM,
          1756 => Opcode::FSQRT_S,
          1757 => Opcode::FSQRT_S_MM,
          1758 => Opcode::FSQRT_W,
          1759 => Opcode::FSUB_D,
          1760 => Opcode::FSUB_D32,
          1761 => Opcode::FSUB_D32_MM,
          1762 => Opcode::FSUB_D64,
          1763 => Opcode::FSUB_D64_MM,
          1764 => Opcode::FSUB_PS64,
          1765 => Opcode::FSUB_S,
          1766 => Opcode::FSUB_S_MM,
          1767 => Opcode::FSUB_S_MMR6,
          1768 => Opcode::FSUB_W,
          1769 => Opcode::FSUEQ_D,
          1770 => Opcode::FSUEQ_W,
          1771 => Opcode::FSULE_D,
          1772 => Opcode::FSULE_W,
          1773 => Opcode::FSULT_D,
          1774 => Opcode::FSULT_W,
          1775 => Opcode::FSUNE_D,
          1776 => Opcode::FSUNE_W,
          1777 => Opcode::FSUN_D,
          1778 => Opcode::FSUN_W,
          1779 => Opcode::FTINT_S_D,
          1780 => Opcode::FTINT_S_W,
          1781 => Opcode::FTINT_U_D,
          1782 => Opcode::FTINT_U_W,
          1783 => Opcode::FTQ_H,
          1784 => Opcode::FTQ_W,
          1785 => Opcode::FTRUNC_S_D,
          1786 => Opcode::FTRUNC_S_W,
          1787 => Opcode::FTRUNC_U_D,
          1788 => Opcode::FTRUNC_U_W,
          1789 => Opcode::GINVI,
          1790 => Opcode::GINVI_MMR6,
          1791 => Opcode::GINVT,
          1792 => Opcode::GINVT_MMR6,
          1793 => Opcode::HADD_S_D,
          1794 => Opcode::HADD_S_H,
          1795 => Opcode::HADD_S_W,
          1796 => Opcode::HADD_U_D,
          1797 => Opcode::HADD_U_H,
          1798 => Opcode::HADD_U_W,
          1799 => Opcode::HSUB_S_D,
          1800 => Opcode::HSUB_S_H,
          1801 => Opcode::HSUB_S_W,
          1802 => Opcode::HSUB_U_D,
          1803 => Opcode::HSUB_U_H,
          1804 => Opcode::HSUB_U_W,
          1805 => Opcode::HYPCALL,
          1806 => Opcode::HYPCALL_MM,
          1807 => Opcode::ILVEV_B,
          1808 => Opcode::ILVEV_D,
          1809 => Opcode::ILVEV_H,
          1810 => Opcode::ILVEV_W,
          1811 => Opcode::ILVL_B,
          1812 => Opcode::ILVL_D,
          1813 => Opcode::ILVL_H,
          1814 => Opcode::ILVL_W,
          1815 => Opcode::ILVOD_B,
          1816 => Opcode::ILVOD_D,
          1817 => Opcode::ILVOD_H,
          1818 => Opcode::ILVOD_W,
          1819 => Opcode::ILVR_B,
          1820 => Opcode::ILVR_D,
          1821 => Opcode::ILVR_H,
          1822 => Opcode::ILVR_W,
          1823 => Opcode::INS,
          1824 => Opcode::INSERT_B,
          1825 => Opcode::INSERT_D,
          1826 => Opcode::INSERT_H,
          1827 => Opcode::INSERT_W,
          1828 => Opcode::INSV,
          1829 => Opcode::INSVE_B,
          1830 => Opcode::INSVE_D,
          1831 => Opcode::INSVE_H,
          1832 => Opcode::INSVE_W,
          1833 => Opcode::INSV_MM,
          1834 => Opcode::INS_MM,
          1835 => Opcode::INS_MMR6,
          1836 => Opcode::J,
          1837 => Opcode::JAL,
          1838 => Opcode::JALR,
          1839 => Opcode::JALR16_MM,
          1840 => Opcode::JALR64,
          1841 => Opcode::JALRC16_MMR6,
          1842 => Opcode::JALRC_HB_MMR6,
          1843 => Opcode::JALRC_MMR6,
          1844 => Opcode::JALRS16_MM,
          1845 => Opcode::JALRS_MM,
          1846 => Opcode::JALR_HB,
          1847 => Opcode::JALR_HB64,
          1848 => Opcode::JALR_MM,
          1849 => Opcode::JALS_MM,
          1850 => Opcode::JALX,
          1851 => Opcode::JALX_MM,
          1852 => Opcode::JAL_MM,
          1853 => Opcode::JIALC,
          1854 => Opcode::JIALC64,
          1855 => Opcode::JIALC_MMR6,
          1856 => Opcode::JIC,
          1857 => Opcode::JIC64,
          1858 => Opcode::JIC_MMR6,
          1859 => Opcode::JR,
          1860 => Opcode::JR16_MM,
          1861 => Opcode::JR64,
          1862 => Opcode::JRADDIUSP,
          1863 => Opcode::JRC16_MM,
          1864 => Opcode::JRC16_MMR6,
          1865 => Opcode::JRCADDIUSP_MMR6,
          1866 => Opcode::JR_HB,
          1867 => Opcode::JR_HB64,
          1868 => Opcode::JR_HB64_R6,
          1869 => Opcode::JR_HB_R6,
          1870 => Opcode::JR_MM,
          1871 => Opcode::J_MM,
          1872 => Opcode::Jal16,
          1873 => Opcode::JalB16,
          1874 => Opcode::JrRa16,
          1875 => Opcode::JrcRa16,
          1876 => Opcode::JrcRx16,
          1877 => Opcode::JumpLinkReg16,
          1878 => Opcode::LB,
          1879 => Opcode::LB64,
          1880 => Opcode::LBE,
          1881 => Opcode::LBE_MM,
          1882 => Opcode::LBU16_MM,
          1883 => Opcode::LBUX,
          1884 => Opcode::LBUX_MM,
          1885 => Opcode::LBU_MMR6,
          1886 => Opcode::LB_MM,
          1887 => Opcode::LB_MMR6,
          1888 => Opcode::LBu,
          1889 => Opcode::LBu64,
          1890 => Opcode::LBuE,
          1891 => Opcode::LBuE_MM,
          1892 => Opcode::LBu_MM,
          1893 => Opcode::LD,
          1894 => Opcode::LDC1,
          1895 => Opcode::LDC164,
          1896 => Opcode::LDC1_D64_MMR6,
          1897 => Opcode::LDC1_MM_D32,
          1898 => Opcode::LDC1_MM_D64,
          1899 => Opcode::LDC2,
          1900 => Opcode::LDC2_MMR6,
          1901 => Opcode::LDC2_R6,
          1902 => Opcode::LDC3,
          1903 => Opcode::LDI_B,
          1904 => Opcode::LDI_D,
          1905 => Opcode::LDI_H,
          1906 => Opcode::LDI_W,
          1907 => Opcode::LDL,
          1908 => Opcode::LDPC,
          1909 => Opcode::LDR,
          1910 => Opcode::LDXC1,
          1911 => Opcode::LDXC164,
          1912 => Opcode::LD_B,
          1913 => Opcode::LD_D,
          1914 => Opcode::LD_H,
          1915 => Opcode::LD_W,
          1916 => Opcode::LEA_ADDiu,
          1917 => Opcode::LEA_ADDiu64,
          1918 => Opcode::LEA_ADDiu_MM,
          1919 => Opcode::LH,
          1920 => Opcode::LH64,
          1921 => Opcode::LHE,
          1922 => Opcode::LHE_MM,
          1923 => Opcode::LHU16_MM,
          1924 => Opcode::LHX,
          1925 => Opcode::LHX_MM,
          1926 => Opcode::LH_MM,
          1927 => Opcode::LHu,
          1928 => Opcode::LHu64,
          1929 => Opcode::LHuE,
          1930 => Opcode::LHuE_MM,
          1931 => Opcode::LHu_MM,
          1932 => Opcode::LI16_MM,
          1933 => Opcode::LI16_MMR6,
          1934 => Opcode::LL,
          1935 => Opcode::LL64,
          1936 => Opcode::LL64_R6,
          1937 => Opcode::LLD,
          1938 => Opcode::LLD_R6,
          1939 => Opcode::LLE,
          1940 => Opcode::LLE_MM,
          1941 => Opcode::LL_MM,
          1942 => Opcode::LL_MMR6,
          1943 => Opcode::LL_R6,
          1944 => Opcode::LSA,
          1945 => Opcode::LSA_MMR6,
          1946 => Opcode::LSA_R6,
          1947 => Opcode::LUI_MMR6,
          1948 => Opcode::LUXC1,
          1949 => Opcode::LUXC164,
          1950 => Opcode::LUXC1_MM,
          1951 => Opcode::LUi,
          1952 => Opcode::LUi64,
          1953 => Opcode::LUi_MM,
          1954 => Opcode::LW,
          1955 => Opcode::LW16_MM,
          1956 => Opcode::LW64,
          1957 => Opcode::LWC1,
          1958 => Opcode::LWC1_MM,
          1959 => Opcode::LWC2,
          1960 => Opcode::LWC2_MMR6,
          1961 => Opcode::LWC2_R6,
          1962 => Opcode::LWC3,
          1963 => Opcode::LWDSP,
          1964 => Opcode::LWDSP_MM,
          1965 => Opcode::LWE,
          1966 => Opcode::LWE_MM,
          1967 => Opcode::LWGP_MM,
          1968 => Opcode::LWL,
          1969 => Opcode::LWL64,
          1970 => Opcode::LWLE,
          1971 => Opcode::LWLE_MM,
          1972 => Opcode::LWL_MM,
          1973 => Opcode::LWM16_MM,
          1974 => Opcode::LWM16_MMR6,
          1975 => Opcode::LWM32_MM,
          1976 => Opcode::LWPC,
          1977 => Opcode::LWPC_MMR6,
          1978 => Opcode::LWP_MM,
          1979 => Opcode::LWR,
          1980 => Opcode::LWR64,
          1981 => Opcode::LWRE,
          1982 => Opcode::LWRE_MM,
          1983 => Opcode::LWR_MM,
          1984 => Opcode::LWSP_MM,
          1985 => Opcode::LWUPC,
          1986 => Opcode::LWU_MM,
          1987 => Opcode::LWX,
          1988 => Opcode::LWXC1,
          1989 => Opcode::LWXC1_MM,
          1990 => Opcode::LWXS_MM,
          1991 => Opcode::LWX_MM,
          1992 => Opcode::LW_MM,
          1993 => Opcode::LW_MMR6,
          1994 => Opcode::LWu,
          1995 => Opcode::LbRxRyOffMemX16,
          1996 => Opcode::LbuRxRyOffMemX16,
          1997 => Opcode::LhRxRyOffMemX16,
          1998 => Opcode::LhuRxRyOffMemX16,
          1999 => Opcode::LiRxImm16,
          2000 => Opcode::LiRxImmAlignX16,
          2001 => Opcode::LiRxImmX16,
          2002 => Opcode::LwRxPcTcp16,
          2003 => Opcode::LwRxPcTcpX16,
          2004 => Opcode::LwRxRyOffMemX16,
          2005 => Opcode::LwRxSpImmX16,
          2006 => Opcode::MADD,
          2007 => Opcode::MADDF_D,
          2008 => Opcode::MADDF_D_MMR6,
          2009 => Opcode::MADDF_S,
          2010 => Opcode::MADDF_S_MMR6,
          2011 => Opcode::MADDR_Q_H,
          2012 => Opcode::MADDR_Q_W,
          2013 => Opcode::MADDU,
          2014 => Opcode::MADDU_DSP,
          2015 => Opcode::MADDU_DSP_MM,
          2016 => Opcode::MADDU_MM,
          2017 => Opcode::MADDV_B,
          2018 => Opcode::MADDV_D,
          2019 => Opcode::MADDV_H,
          2020 => Opcode::MADDV_W,
          2021 => Opcode::MADD_D32,
          2022 => Opcode::MADD_D32_MM,
          2023 => Opcode::MADD_D64,
          2024 => Opcode::MADD_DSP,
          2025 => Opcode::MADD_DSP_MM,
          2026 => Opcode::MADD_MM,
          2027 => Opcode::MADD_Q_H,
          2028 => Opcode::MADD_Q_W,
          2029 => Opcode::MADD_S,
          2030 => Opcode::MADD_S_MM,
          2031 => Opcode::MAQ_SA_W_PHL,
          2032 => Opcode::MAQ_SA_W_PHL_MM,
          2033 => Opcode::MAQ_SA_W_PHR,
          2034 => Opcode::MAQ_SA_W_PHR_MM,
          2035 => Opcode::MAQ_S_W_PHL,
          2036 => Opcode::MAQ_S_W_PHL_MM,
          2037 => Opcode::MAQ_S_W_PHR,
          2038 => Opcode::MAQ_S_W_PHR_MM,
          2039 => Opcode::MAXA_D,
          2040 => Opcode::MAXA_D_MMR6,
          2041 => Opcode::MAXA_S,
          2042 => Opcode::MAXA_S_MMR6,
          2043 => Opcode::MAXI_S_B,
          2044 => Opcode::MAXI_S_D,
          2045 => Opcode::MAXI_S_H,
          2046 => Opcode::MAXI_S_W,
          2047 => Opcode::MAXI_U_B,
          2048 => Opcode::MAXI_U_D,
          2049 => Opcode::MAXI_U_H,
          2050 => Opcode::MAXI_U_W,
          2051 => Opcode::MAX_A_B,
          2052 => Opcode::MAX_A_D,
          2053 => Opcode::MAX_A_H,
          2054 => Opcode::MAX_A_W,
          2055 => Opcode::MAX_D,
          2056 => Opcode::MAX_D_MMR6,
          2057 => Opcode::MAX_S,
          2058 => Opcode::MAX_S_B,
          2059 => Opcode::MAX_S_D,
          2060 => Opcode::MAX_S_H,
          2061 => Opcode::MAX_S_MMR6,
          2062 => Opcode::MAX_S_W,
          2063 => Opcode::MAX_U_B,
          2064 => Opcode::MAX_U_D,
          2065 => Opcode::MAX_U_H,
          2066 => Opcode::MAX_U_W,
          2067 => Opcode::MFC0,
          2068 => Opcode::MFC0_MMR6,
          2069 => Opcode::MFC1,
          2070 => Opcode::MFC1_D64,
          2071 => Opcode::MFC1_MM,
          2072 => Opcode::MFC1_MMR6,
          2073 => Opcode::MFC2,
          2074 => Opcode::MFC2_MMR6,
          2075 => Opcode::MFGC0,
          2076 => Opcode::MFGC0_MM,
          2077 => Opcode::MFHC0_MMR6,
          2078 => Opcode::MFHC1_D32,
          2079 => Opcode::MFHC1_D32_MM,
          2080 => Opcode::MFHC1_D64,
          2081 => Opcode::MFHC1_D64_MM,
          2082 => Opcode::MFHC2_MMR6,
          2083 => Opcode::MFHGC0,
          2084 => Opcode::MFHGC0_MM,
          2085 => Opcode::MFHI,
          2086 => Opcode::MFHI16_MM,
          2087 => Opcode::MFHI64,
          2088 => Opcode::MFHI_DSP,
          2089 => Opcode::MFHI_DSP_MM,
          2090 => Opcode::MFHI_MM,
          2091 => Opcode::MFLO,
          2092 => Opcode::MFLO16_MM,
          2093 => Opcode::MFLO64,
          2094 => Opcode::MFLO_DSP,
          2095 => Opcode::MFLO_DSP_MM,
          2096 => Opcode::MFLO_MM,
          2097 => Opcode::MFTR,
          2098 => Opcode::MINA_D,
          2099 => Opcode::MINA_D_MMR6,
          2100 => Opcode::MINA_S,
          2101 => Opcode::MINA_S_MMR6,
          2102 => Opcode::MINI_S_B,
          2103 => Opcode::MINI_S_D,
          2104 => Opcode::MINI_S_H,
          2105 => Opcode::MINI_S_W,
          2106 => Opcode::MINI_U_B,
          2107 => Opcode::MINI_U_D,
          2108 => Opcode::MINI_U_H,
          2109 => Opcode::MINI_U_W,
          2110 => Opcode::MIN_A_B,
          2111 => Opcode::MIN_A_D,
          2112 => Opcode::MIN_A_H,
          2113 => Opcode::MIN_A_W,
          2114 => Opcode::MIN_D,
          2115 => Opcode::MIN_D_MMR6,
          2116 => Opcode::MIN_S,
          2117 => Opcode::MIN_S_B,
          2118 => Opcode::MIN_S_D,
          2119 => Opcode::MIN_S_H,
          2120 => Opcode::MIN_S_MMR6,
          2121 => Opcode::MIN_S_W,
          2122 => Opcode::MIN_U_B,
          2123 => Opcode::MIN_U_D,
          2124 => Opcode::MIN_U_H,
          2125 => Opcode::MIN_U_W,
          2126 => Opcode::MOD,
          2127 => Opcode::MODSUB,
          2128 => Opcode::MODSUB_MM,
          2129 => Opcode::MODU,
          2130 => Opcode::MODU_MMR6,
          2131 => Opcode::MOD_MMR6,
          2132 => Opcode::MOD_S_B,
          2133 => Opcode::MOD_S_D,
          2134 => Opcode::MOD_S_H,
          2135 => Opcode::MOD_S_W,
          2136 => Opcode::MOD_U_B,
          2137 => Opcode::MOD_U_D,
          2138 => Opcode::MOD_U_H,
          2139 => Opcode::MOD_U_W,
          2140 => Opcode::MOVE16_MM,
          2141 => Opcode::MOVE16_MMR6,
          2142 => Opcode::MOVEP_MM,
          2143 => Opcode::MOVEP_MMR6,
          2144 => Opcode::MOVE_V,
          2145 => Opcode::MOVF_D32,
          2146 => Opcode::MOVF_D32_MM,
          2147 => Opcode::MOVF_D64,
          2148 => Opcode::MOVF_I,
          2149 => Opcode::MOVF_I64,
          2150 => Opcode::MOVF_I_MM,
          2151 => Opcode::MOVF_S,
          2152 => Opcode::MOVF_S_MM,
          2153 => Opcode::MOVN_I64_D64,
          2154 => Opcode::MOVN_I64_I,
          2155 => Opcode::MOVN_I64_I64,
          2156 => Opcode::MOVN_I64_S,
          2157 => Opcode::MOVN_I_D32,
          2158 => Opcode::MOVN_I_D32_MM,
          2159 => Opcode::MOVN_I_D64,
          2160 => Opcode::MOVN_I_I,
          2161 => Opcode::MOVN_I_I64,
          2162 => Opcode::MOVN_I_MM,
          2163 => Opcode::MOVN_I_S,
          2164 => Opcode::MOVN_I_S_MM,
          2165 => Opcode::MOVT_D32,
          2166 => Opcode::MOVT_D32_MM,
          2167 => Opcode::MOVT_D64,
          2168 => Opcode::MOVT_I,
          2169 => Opcode::MOVT_I64,
          2170 => Opcode::MOVT_I_MM,
          2171 => Opcode::MOVT_S,
          2172 => Opcode::MOVT_S_MM,
          2173 => Opcode::MOVZ_I64_D64,
          2174 => Opcode::MOVZ_I64_I,
          2175 => Opcode::MOVZ_I64_I64,
          2176 => Opcode::MOVZ_I64_S,
          2177 => Opcode::MOVZ_I_D32,
          2178 => Opcode::MOVZ_I_D32_MM,
          2179 => Opcode::MOVZ_I_D64,
          2180 => Opcode::MOVZ_I_I,
          2181 => Opcode::MOVZ_I_I64,
          2182 => Opcode::MOVZ_I_MM,
          2183 => Opcode::MOVZ_I_S,
          2184 => Opcode::MOVZ_I_S_MM,
          2185 => Opcode::MSUB,
          2186 => Opcode::MSUBF_D,
          2187 => Opcode::MSUBF_D_MMR6,
          2188 => Opcode::MSUBF_S,
          2189 => Opcode::MSUBF_S_MMR6,
          2190 => Opcode::MSUBR_Q_H,
          2191 => Opcode::MSUBR_Q_W,
          2192 => Opcode::MSUBU,
          2193 => Opcode::MSUBU_DSP,
          2194 => Opcode::MSUBU_DSP_MM,
          2195 => Opcode::MSUBU_MM,
          2196 => Opcode::MSUBV_B,
          2197 => Opcode::MSUBV_D,
          2198 => Opcode::MSUBV_H,
          2199 => Opcode::MSUBV_W,
          2200 => Opcode::MSUB_D32,
          2201 => Opcode::MSUB_D32_MM,
          2202 => Opcode::MSUB_D64,
          2203 => Opcode::MSUB_DSP,
          2204 => Opcode::MSUB_DSP_MM,
          2205 => Opcode::MSUB_MM,
          2206 => Opcode::MSUB_Q_H,
          2207 => Opcode::MSUB_Q_W,
          2208 => Opcode::MSUB_S,
          2209 => Opcode::MSUB_S_MM,
          2210 => Opcode::MTC0,
          2211 => Opcode::MTC0_MMR6,
          2212 => Opcode::MTC1,
          2213 => Opcode::MTC1_D64,
          2214 => Opcode::MTC1_D64_MM,
          2215 => Opcode::MTC1_MM,
          2216 => Opcode::MTC1_MMR6,
          2217 => Opcode::MTC2,
          2218 => Opcode::MTC2_MMR6,
          2219 => Opcode::MTGC0,
          2220 => Opcode::MTGC0_MM,
          2221 => Opcode::MTHC0_MMR6,
          2222 => Opcode::MTHC1_D32,
          2223 => Opcode::MTHC1_D32_MM,
          2224 => Opcode::MTHC1_D64,
          2225 => Opcode::MTHC1_D64_MM,
          2226 => Opcode::MTHC2_MMR6,
          2227 => Opcode::MTHGC0,
          2228 => Opcode::MTHGC0_MM,
          2229 => Opcode::MTHI,
          2230 => Opcode::MTHI64,
          2231 => Opcode::MTHI_DSP,
          2232 => Opcode::MTHI_DSP_MM,
          2233 => Opcode::MTHI_MM,
          2234 => Opcode::MTHLIP,
          2235 => Opcode::MTHLIP_MM,
          2236 => Opcode::MTLO,
          2237 => Opcode::MTLO64,
          2238 => Opcode::MTLO_DSP,
          2239 => Opcode::MTLO_DSP_MM,
          2240 => Opcode::MTLO_MM,
          2241 => Opcode::MTM0,
          2242 => Opcode::MTM1,
          2243 => Opcode::MTM2,
          2244 => Opcode::MTP0,
          2245 => Opcode::MTP1,
          2246 => Opcode::MTP2,
          2247 => Opcode::MTTR,
          2248 => Opcode::MUH,
          2249 => Opcode::MUHU,
          2250 => Opcode::MUHU_MMR6,
          2251 => Opcode::MUH_MMR6,
          2252 => Opcode::MUL,
          2253 => Opcode::MULEQ_S_W_PHL,
          2254 => Opcode::MULEQ_S_W_PHL_MM,
          2255 => Opcode::MULEQ_S_W_PHR,
          2256 => Opcode::MULEQ_S_W_PHR_MM,
          2257 => Opcode::MULEU_S_PH_QBL,
          2258 => Opcode::MULEU_S_PH_QBL_MM,
          2259 => Opcode::MULEU_S_PH_QBR,
          2260 => Opcode::MULEU_S_PH_QBR_MM,
          2261 => Opcode::MULQ_RS_PH,
          2262 => Opcode::MULQ_RS_PH_MM,
          2263 => Opcode::MULQ_RS_W,
          2264 => Opcode::MULQ_RS_W_MMR2,
          2265 => Opcode::MULQ_S_PH,
          2266 => Opcode::MULQ_S_PH_MMR2,
          2267 => Opcode::MULQ_S_W,
          2268 => Opcode::MULQ_S_W_MMR2,
          2269 => Opcode::MULR_PS64,
          2270 => Opcode::MULR_Q_H,
          2271 => Opcode::MULR_Q_W,
          2272 => Opcode::MULSAQ_S_W_PH,
          2273 => Opcode::MULSAQ_S_W_PH_MM,
          2274 => Opcode::MULSA_W_PH,
          2275 => Opcode::MULSA_W_PH_MMR2,
          2276 => Opcode::MULT,
          2277 => Opcode::MULTU_DSP,
          2278 => Opcode::MULTU_DSP_MM,
          2279 => Opcode::MULT_DSP,
          2280 => Opcode::MULT_DSP_MM,
          2281 => Opcode::MULT_MM,
          2282 => Opcode::MULTu,
          2283 => Opcode::MULTu_MM,
          2284 => Opcode::MULU,
          2285 => Opcode::MULU_MMR6,
          2286 => Opcode::MULV_B,
          2287 => Opcode::MULV_D,
          2288 => Opcode::MULV_H,
          2289 => Opcode::MULV_W,
          2290 => Opcode::MUL_MM,
          2291 => Opcode::MUL_MMR6,
          2292 => Opcode::MUL_PH,
          2293 => Opcode::MUL_PH_MMR2,
          2294 => Opcode::MUL_Q_H,
          2295 => Opcode::MUL_Q_W,
          2296 => Opcode::MUL_R6,
          2297 => Opcode::MUL_S_PH,
          2298 => Opcode::MUL_S_PH_MMR2,
          2299 => Opcode::Mfhi16,
          2300 => Opcode::Mflo16,
          2301 => Opcode::Move32R16,
          2302 => Opcode::MoveR3216,
          2303 => Opcode::NAL,
          2304 => Opcode::NLOC_B,
          2305 => Opcode::NLOC_D,
          2306 => Opcode::NLOC_H,
          2307 => Opcode::NLOC_W,
          2308 => Opcode::NLZC_B,
          2309 => Opcode::NLZC_D,
          2310 => Opcode::NLZC_H,
          2311 => Opcode::NLZC_W,
          2312 => Opcode::NMADD_D32,
          2313 => Opcode::NMADD_D32_MM,
          2314 => Opcode::NMADD_D64,
          2315 => Opcode::NMADD_S,
          2316 => Opcode::NMADD_S_MM,
          2317 => Opcode::NMSUB_D32,
          2318 => Opcode::NMSUB_D32_MM,
          2319 => Opcode::NMSUB_D64,
          2320 => Opcode::NMSUB_S,
          2321 => Opcode::NMSUB_S_MM,
          2322 => Opcode::NOR,
          2323 => Opcode::NOR64,
          2324 => Opcode::NORI_B,
          2325 => Opcode::NOR_MM,
          2326 => Opcode::NOR_MMR6,
          2327 => Opcode::NOR_V,
          2328 => Opcode::NOT16_MM,
          2329 => Opcode::NOT16_MMR6,
          2330 => Opcode::NegRxRy16,
          2331 => Opcode::NotRxRy16,
          2332 => Opcode::OR,
          2333 => Opcode::OR16_MM,
          2334 => Opcode::OR16_MMR6,
          2335 => Opcode::OR64,
          2336 => Opcode::ORI_B,
          2337 => Opcode::ORI_MMR6,
          2338 => Opcode::OR_MM,
          2339 => Opcode::OR_MMR6,
          2340 => Opcode::OR_V,
          2341 => Opcode::ORi,
          2342 => Opcode::ORi64,
          2343 => Opcode::ORi_MM,
          2344 => Opcode::OrRxRxRy16,
          2345 => Opcode::PACKRL_PH,
          2346 => Opcode::PACKRL_PH_MM,
          2347 => Opcode::PAUSE,
          2348 => Opcode::PAUSE_MM,
          2349 => Opcode::PAUSE_MMR6,
          2350 => Opcode::PCKEV_B,
          2351 => Opcode::PCKEV_D,
          2352 => Opcode::PCKEV_H,
          2353 => Opcode::PCKEV_W,
          2354 => Opcode::PCKOD_B,
          2355 => Opcode::PCKOD_D,
          2356 => Opcode::PCKOD_H,
          2357 => Opcode::PCKOD_W,
          2358 => Opcode::PCNT_B,
          2359 => Opcode::PCNT_D,
          2360 => Opcode::PCNT_H,
          2361 => Opcode::PCNT_W,
          2362 => Opcode::PICK_PH,
          2363 => Opcode::PICK_PH_MM,
          2364 => Opcode::PICK_QB,
          2365 => Opcode::PICK_QB_MM,
          2366 => Opcode::PLL_PS64,
          2367 => Opcode::PLU_PS64,
          2368 => Opcode::POP,
          2369 => Opcode::PRECEQU_PH_QBL,
          2370 => Opcode::PRECEQU_PH_QBLA,
          2371 => Opcode::PRECEQU_PH_QBLA_MM,
          2372 => Opcode::PRECEQU_PH_QBL_MM,
          2373 => Opcode::PRECEQU_PH_QBR,
          2374 => Opcode::PRECEQU_PH_QBRA,
          2375 => Opcode::PRECEQU_PH_QBRA_MM,
          2376 => Opcode::PRECEQU_PH_QBR_MM,
          2377 => Opcode::PRECEQ_W_PHL,
          2378 => Opcode::PRECEQ_W_PHL_MM,
          2379 => Opcode::PRECEQ_W_PHR,
          2380 => Opcode::PRECEQ_W_PHR_MM,
          2381 => Opcode::PRECEU_PH_QBL,
          2382 => Opcode::PRECEU_PH_QBLA,
          2383 => Opcode::PRECEU_PH_QBLA_MM,
          2384 => Opcode::PRECEU_PH_QBL_MM,
          2385 => Opcode::PRECEU_PH_QBR,
          2386 => Opcode::PRECEU_PH_QBRA,
          2387 => Opcode::PRECEU_PH_QBRA_MM,
          2388 => Opcode::PRECEU_PH_QBR_MM,
          2389 => Opcode::PRECRQU_S_QB_PH,
          2390 => Opcode::PRECRQU_S_QB_PH_MM,
          2391 => Opcode::PRECRQ_PH_W,
          2392 => Opcode::PRECRQ_PH_W_MM,
          2393 => Opcode::PRECRQ_QB_PH,
          2394 => Opcode::PRECRQ_QB_PH_MM,
          2395 => Opcode::PRECRQ_RS_PH_W,
          2396 => Opcode::PRECRQ_RS_PH_W_MM,
          2397 => Opcode::PRECR_QB_PH,
          2398 => Opcode::PRECR_QB_PH_MMR2,
          2399 => Opcode::PRECR_SRA_PH_W,
          2400 => Opcode::PRECR_SRA_PH_W_MMR2,
          2401 => Opcode::PRECR_SRA_R_PH_W,
          2402 => Opcode::PRECR_SRA_R_PH_W_MMR2,
          2403 => Opcode::PREF,
          2404 => Opcode::PREFE,
          2405 => Opcode::PREFE_MM,
          2406 => Opcode::PREFX_MM,
          2407 => Opcode::PREF_MM,
          2408 => Opcode::PREF_MMR6,
          2409 => Opcode::PREF_R6,
          2410 => Opcode::PREPEND,
          2411 => Opcode::PREPEND_MMR2,
          2412 => Opcode::PUL_PS64,
          2413 => Opcode::PUU_PS64,
          2414 => Opcode::RADDU_W_QB,
          2415 => Opcode::RADDU_W_QB_MM,
          2416 => Opcode::RDDSP,
          2417 => Opcode::RDDSP_MM,
          2418 => Opcode::RDHWR,
          2419 => Opcode::RDHWR64,
          2420 => Opcode::RDHWR_MM,
          2421 => Opcode::RDHWR_MMR6,
          2422 => Opcode::RDPGPR_MMR6,
          2423 => Opcode::RECIP_D32,
          2424 => Opcode::RECIP_D32_MM,
          2425 => Opcode::RECIP_D64,
          2426 => Opcode::RECIP_D64_MM,
          2427 => Opcode::RECIP_S,
          2428 => Opcode::RECIP_S_MM,
          2429 => Opcode::REPLV_PH,
          2430 => Opcode::REPLV_PH_MM,
          2431 => Opcode::REPLV_QB,
          2432 => Opcode::REPLV_QB_MM,
          2433 => Opcode::REPL_PH,
          2434 => Opcode::REPL_PH_MM,
          2435 => Opcode::REPL_QB,
          2436 => Opcode::REPL_QB_MM,
          2437 => Opcode::RINT_D,
          2438 => Opcode::RINT_D_MMR6,
          2439 => Opcode::RINT_S,
          2440 => Opcode::RINT_S_MMR6,
          2441 => Opcode::ROTR,
          2442 => Opcode::ROTRV,
          2443 => Opcode::ROTRV_MM,
          2444 => Opcode::ROTR_MM,
          2445 => Opcode::ROUND_L_D64,
          2446 => Opcode::ROUND_L_D_MMR6,
          2447 => Opcode::ROUND_L_S,
          2448 => Opcode::ROUND_L_S_MMR6,
          2449 => Opcode::ROUND_W_D32,
          2450 => Opcode::ROUND_W_D64,
          2451 => Opcode::ROUND_W_D_MMR6,
          2452 => Opcode::ROUND_W_MM,
          2453 => Opcode::ROUND_W_S,
          2454 => Opcode::ROUND_W_S_MM,
          2455 => Opcode::ROUND_W_S_MMR6,
          2456 => Opcode::RSQRT_D32,
          2457 => Opcode::RSQRT_D32_MM,
          2458 => Opcode::RSQRT_D64,
          2459 => Opcode::RSQRT_D64_MM,
          2460 => Opcode::RSQRT_S,
          2461 => Opcode::RSQRT_S_MM,
          2462 => Opcode::Restore16,
          2463 => Opcode::RestoreX16,
          2464 => Opcode::SAA,
          2465 => Opcode::SAAD,
          2466 => Opcode::SAT_S_B,
          2467 => Opcode::SAT_S_D,
          2468 => Opcode::SAT_S_H,
          2469 => Opcode::SAT_S_W,
          2470 => Opcode::SAT_U_B,
          2471 => Opcode::SAT_U_D,
          2472 => Opcode::SAT_U_H,
          2473 => Opcode::SAT_U_W,
          2474 => Opcode::SB,
          2475 => Opcode::SB16_MM,
          2476 => Opcode::SB16_MMR6,
          2477 => Opcode::SB64,
          2478 => Opcode::SBE,
          2479 => Opcode::SBE_MM,
          2480 => Opcode::SB_MM,
          2481 => Opcode::SB_MMR6,
          2482 => Opcode::SC,
          2483 => Opcode::SC64,
          2484 => Opcode::SC64_R6,
          2485 => Opcode::SCD,
          2486 => Opcode::SCD_R6,
          2487 => Opcode::SCE,
          2488 => Opcode::SCE_MM,
          2489 => Opcode::SC_MM,
          2490 => Opcode::SC_MMR6,
          2491 => Opcode::SC_R6,
          2492 => Opcode::SD,
          2493 => Opcode::SDBBP,
          2494 => Opcode::SDBBP16_MM,
          2495 => Opcode::SDBBP16_MMR6,
          2496 => Opcode::SDBBP_MM,
          2497 => Opcode::SDBBP_MMR6,
          2498 => Opcode::SDBBP_R6,
          2499 => Opcode::SDC1,
          2500 => Opcode::SDC164,
          2501 => Opcode::SDC1_D64_MMR6,
          2502 => Opcode::SDC1_MM_D32,
          2503 => Opcode::SDC1_MM_D64,
          2504 => Opcode::SDC2,
          2505 => Opcode::SDC2_MMR6,
          2506 => Opcode::SDC2_R6,
          2507 => Opcode::SDC3,
          2508 => Opcode::SDIV,
          2509 => Opcode::SDIV_MM,
          2510 => Opcode::SDL,
          2511 => Opcode::SDR,
          2512 => Opcode::SDXC1,
          2513 => Opcode::SDXC164,
          2514 => Opcode::SEB,
          2515 => Opcode::SEB64,
          2516 => Opcode::SEB_MM,
          2517 => Opcode::SEH,
          2518 => Opcode::SEH64,
          2519 => Opcode::SEH_MM,
          2520 => Opcode::SELEQZ,
          2521 => Opcode::SELEQZ64,
          2522 => Opcode::SELEQZ_D,
          2523 => Opcode::SELEQZ_D_MMR6,
          2524 => Opcode::SELEQZ_MMR6,
          2525 => Opcode::SELEQZ_S,
          2526 => Opcode::SELEQZ_S_MMR6,
          2527 => Opcode::SELNEZ,
          2528 => Opcode::SELNEZ64,
          2529 => Opcode::SELNEZ_D,
          2530 => Opcode::SELNEZ_D_MMR6,
          2531 => Opcode::SELNEZ_MMR6,
          2532 => Opcode::SELNEZ_S,
          2533 => Opcode::SELNEZ_S_MMR6,
          2534 => Opcode::SEL_D,
          2535 => Opcode::SEL_D_MMR6,
          2536 => Opcode::SEL_S,
          2537 => Opcode::SEL_S_MMR6,
          2538 => Opcode::SEQ,
          2539 => Opcode::SEQi,
          2540 => Opcode::SH,
          2541 => Opcode::SH16_MM,
          2542 => Opcode::SH16_MMR6,
          2543 => Opcode::SH64,
          2544 => Opcode::SHE,
          2545 => Opcode::SHE_MM,
          2546 => Opcode::SHF_B,
          2547 => Opcode::SHF_H,
          2548 => Opcode::SHF_W,
          2549 => Opcode::SHILO,
          2550 => Opcode::SHILOV,
          2551 => Opcode::SHILOV_MM,
          2552 => Opcode::SHILO_MM,
          2553 => Opcode::SHLLV_PH,
          2554 => Opcode::SHLLV_PH_MM,
          2555 => Opcode::SHLLV_QB,
          2556 => Opcode::SHLLV_QB_MM,
          2557 => Opcode::SHLLV_S_PH,
          2558 => Opcode::SHLLV_S_PH_MM,
          2559 => Opcode::SHLLV_S_W,
          2560 => Opcode::SHLLV_S_W_MM,
          2561 => Opcode::SHLL_PH,
          2562 => Opcode::SHLL_PH_MM,
          2563 => Opcode::SHLL_QB,
          2564 => Opcode::SHLL_QB_MM,
          2565 => Opcode::SHLL_S_PH,
          2566 => Opcode::SHLL_S_PH_MM,
          2567 => Opcode::SHLL_S_W,
          2568 => Opcode::SHLL_S_W_MM,
          2569 => Opcode::SHRAV_PH,
          2570 => Opcode::SHRAV_PH_MM,
          2571 => Opcode::SHRAV_QB,
          2572 => Opcode::SHRAV_QB_MMR2,
          2573 => Opcode::SHRAV_R_PH,
          2574 => Opcode::SHRAV_R_PH_MM,
          2575 => Opcode::SHRAV_R_QB,
          2576 => Opcode::SHRAV_R_QB_MMR2,
          2577 => Opcode::SHRAV_R_W,
          2578 => Opcode::SHRAV_R_W_MM,
          2579 => Opcode::SHRA_PH,
          2580 => Opcode::SHRA_PH_MM,
          2581 => Opcode::SHRA_QB,
          2582 => Opcode::SHRA_QB_MMR2,
          2583 => Opcode::SHRA_R_PH,
          2584 => Opcode::SHRA_R_PH_MM,
          2585 => Opcode::SHRA_R_QB,
          2586 => Opcode::SHRA_R_QB_MMR2,
          2587 => Opcode::SHRA_R_W,
          2588 => Opcode::SHRA_R_W_MM,
          2589 => Opcode::SHRLV_PH,
          2590 => Opcode::SHRLV_PH_MMR2,
          2591 => Opcode::SHRLV_QB,
          2592 => Opcode::SHRLV_QB_MM,
          2593 => Opcode::SHRL_PH,
          2594 => Opcode::SHRL_PH_MMR2,
          2595 => Opcode::SHRL_QB,
          2596 => Opcode::SHRL_QB_MM,
          2597 => Opcode::SH_MM,
          2598 => Opcode::SH_MMR6,
          2599 => Opcode::SIGRIE,
          2600 => Opcode::SIGRIE_MMR6,
          2601 => Opcode::SLDI_B,
          2602 => Opcode::SLDI_D,
          2603 => Opcode::SLDI_H,
          2604 => Opcode::SLDI_W,
          2605 => Opcode::SLD_B,
          2606 => Opcode::SLD_D,
          2607 => Opcode::SLD_H,
          2608 => Opcode::SLD_W,
          2609 => Opcode::SLL,
          2610 => Opcode::SLL16_MM,
          2611 => Opcode::SLL16_MMR6,
          2612 => Opcode::SLL64_32,
          2613 => Opcode::SLL64_64,
          2614 => Opcode::SLLI_B,
          2615 => Opcode::SLLI_D,
          2616 => Opcode::SLLI_H,
          2617 => Opcode::SLLI_W,
          2618 => Opcode::SLLV,
          2619 => Opcode::SLLV_MM,
          2620 => Opcode::SLL_B,
          2621 => Opcode::SLL_D,
          2622 => Opcode::SLL_H,
          2623 => Opcode::SLL_MM,
          2624 => Opcode::SLL_MMR6,
          2625 => Opcode::SLL_W,
          2626 => Opcode::SLT,
          2627 => Opcode::SLT64,
          2628 => Opcode::SLT_MM,
          2629 => Opcode::SLTi,
          2630 => Opcode::SLTi64,
          2631 => Opcode::SLTi_MM,
          2632 => Opcode::SLTiu,
          2633 => Opcode::SLTiu64,
          2634 => Opcode::SLTiu_MM,
          2635 => Opcode::SLTu,
          2636 => Opcode::SLTu64,
          2637 => Opcode::SLTu_MM,
          2638 => Opcode::SNE,
          2639 => Opcode::SNEi,
          2640 => Opcode::SPLATI_B,
          2641 => Opcode::SPLATI_D,
          2642 => Opcode::SPLATI_H,
          2643 => Opcode::SPLATI_W,
          2644 => Opcode::SPLAT_B,
          2645 => Opcode::SPLAT_D,
          2646 => Opcode::SPLAT_H,
          2647 => Opcode::SPLAT_W,
          2648 => Opcode::SRA,
          2649 => Opcode::SRAI_B,
          2650 => Opcode::SRAI_D,
          2651 => Opcode::SRAI_H,
          2652 => Opcode::SRAI_W,
          2653 => Opcode::SRARI_B,
          2654 => Opcode::SRARI_D,
          2655 => Opcode::SRARI_H,
          2656 => Opcode::SRARI_W,
          2657 => Opcode::SRAR_B,
          2658 => Opcode::SRAR_D,
          2659 => Opcode::SRAR_H,
          2660 => Opcode::SRAR_W,
          2661 => Opcode::SRAV,
          2662 => Opcode::SRAV_MM,
          2663 => Opcode::SRA_B,
          2664 => Opcode::SRA_D,
          2665 => Opcode::SRA_H,
          2666 => Opcode::SRA_MM,
          2667 => Opcode::SRA_W,
          2668 => Opcode::SRL,
          2669 => Opcode::SRL16_MM,
          2670 => Opcode::SRL16_MMR6,
          2671 => Opcode::SRLI_B,
          2672 => Opcode::SRLI_D,
          2673 => Opcode::SRLI_H,
          2674 => Opcode::SRLI_W,
          2675 => Opcode::SRLRI_B,
          2676 => Opcode::SRLRI_D,
          2677 => Opcode::SRLRI_H,
          2678 => Opcode::SRLRI_W,
          2679 => Opcode::SRLR_B,
          2680 => Opcode::SRLR_D,
          2681 => Opcode::SRLR_H,
          2682 => Opcode::SRLR_W,
          2683 => Opcode::SRLV,
          2684 => Opcode::SRLV_MM,
          2685 => Opcode::SRL_B,
          2686 => Opcode::SRL_D,
          2687 => Opcode::SRL_H,
          2688 => Opcode::SRL_MM,
          2689 => Opcode::SRL_W,
          2690 => Opcode::SSNOP,
          2691 => Opcode::SSNOP_MM,
          2692 => Opcode::SSNOP_MMR6,
          2693 => Opcode::ST_B,
          2694 => Opcode::ST_D,
          2695 => Opcode::ST_H,
          2696 => Opcode::ST_W,
          2697 => Opcode::SUB,
          2698 => Opcode::SUBQH_PH,
          2699 => Opcode::SUBQH_PH_MMR2,
          2700 => Opcode::SUBQH_R_PH,
          2701 => Opcode::SUBQH_R_PH_MMR2,
          2702 => Opcode::SUBQH_R_W,
          2703 => Opcode::SUBQH_R_W_MMR2,
          2704 => Opcode::SUBQH_W,
          2705 => Opcode::SUBQH_W_MMR2,
          2706 => Opcode::SUBQ_PH,
          2707 => Opcode::SUBQ_PH_MM,
          2708 => Opcode::SUBQ_S_PH,
          2709 => Opcode::SUBQ_S_PH_MM,
          2710 => Opcode::SUBQ_S_W,
          2711 => Opcode::SUBQ_S_W_MM,
          2712 => Opcode::SUBSUS_U_B,
          2713 => Opcode::SUBSUS_U_D,
          2714 => Opcode::SUBSUS_U_H,
          2715 => Opcode::SUBSUS_U_W,
          2716 => Opcode::SUBSUU_S_B,
          2717 => Opcode::SUBSUU_S_D,
          2718 => Opcode::SUBSUU_S_H,
          2719 => Opcode::SUBSUU_S_W,
          2720 => Opcode::SUBS_S_B,
          2721 => Opcode::SUBS_S_D,
          2722 => Opcode::SUBS_S_H,
          2723 => Opcode::SUBS_S_W,
          2724 => Opcode::SUBS_U_B,
          2725 => Opcode::SUBS_U_D,
          2726 => Opcode::SUBS_U_H,
          2727 => Opcode::SUBS_U_W,
          2728 => Opcode::SUBU16_MM,
          2729 => Opcode::SUBU16_MMR6,
          2730 => Opcode::SUBUH_QB,
          2731 => Opcode::SUBUH_QB_MMR2,
          2732 => Opcode::SUBUH_R_QB,
          2733 => Opcode::SUBUH_R_QB_MMR2,
          2734 => Opcode::SUBU_MMR6,
          2735 => Opcode::SUBU_PH,
          2736 => Opcode::SUBU_PH_MMR2,
          2737 => Opcode::SUBU_QB,
          2738 => Opcode::SUBU_QB_MM,
          2739 => Opcode::SUBU_S_PH,
          2740 => Opcode::SUBU_S_PH_MMR2,
          2741 => Opcode::SUBU_S_QB,
          2742 => Opcode::SUBU_S_QB_MM,
          2743 => Opcode::SUBVI_B,
          2744 => Opcode::SUBVI_D,
          2745 => Opcode::SUBVI_H,
          2746 => Opcode::SUBVI_W,
          2747 => Opcode::SUBV_B,
          2748 => Opcode::SUBV_D,
          2749 => Opcode::SUBV_H,
          2750 => Opcode::SUBV_W,
          2751 => Opcode::SUB_MM,
          2752 => Opcode::SUB_MMR6,
          2753 => Opcode::SUBu,
          2754 => Opcode::SUBu_MM,
          2755 => Opcode::SUXC1,
          2756 => Opcode::SUXC164,
          2757 => Opcode::SUXC1_MM,
          2758 => Opcode::SW,
          2759 => Opcode::SW16_MM,
          2760 => Opcode::SW16_MMR6,
          2761 => Opcode::SW64,
          2762 => Opcode::SWC1,
          2763 => Opcode::SWC1_MM,
          2764 => Opcode::SWC2,
          2765 => Opcode::SWC2_MMR6,
          2766 => Opcode::SWC2_R6,
          2767 => Opcode::SWC3,
          2768 => Opcode::SWDSP,
          2769 => Opcode::SWDSP_MM,
          2770 => Opcode::SWE,
          2771 => Opcode::SWE_MM,
          2772 => Opcode::SWL,
          2773 => Opcode::SWL64,
          2774 => Opcode::SWLE,
          2775 => Opcode::SWLE_MM,
          2776 => Opcode::SWL_MM,
          2777 => Opcode::SWM16_MM,
          2778 => Opcode::SWM16_MMR6,
          2779 => Opcode::SWM32_MM,
          2780 => Opcode::SWP_MM,
          2781 => Opcode::SWR,
          2782 => Opcode::SWR64,
          2783 => Opcode::SWRE,
          2784 => Opcode::SWRE_MM,
          2785 => Opcode::SWR_MM,
          2786 => Opcode::SWSP_MM,
          2787 => Opcode::SWSP_MMR6,
          2788 => Opcode::SWXC1,
          2789 => Opcode::SWXC1_MM,
          2790 => Opcode::SW_MM,
          2791 => Opcode::SW_MMR6,
          2792 => Opcode::SYNC,
          2793 => Opcode::SYNCI,
          2794 => Opcode::SYNCI_MM,
          2795 => Opcode::SYNCI_MMR6,
          2796 => Opcode::SYNC_MM,
          2797 => Opcode::SYNC_MMR6,
          2798 => Opcode::SYSCALL,
          2799 => Opcode::SYSCALL_MM,
          2800 => Opcode::Save16,
          2801 => Opcode::SaveX16,
          2802 => Opcode::SbRxRyOffMemX16,
          2803 => Opcode::SebRx16,
          2804 => Opcode::SehRx16,
          2805 => Opcode::ShRxRyOffMemX16,
          2806 => Opcode::SllX16,
          2807 => Opcode::SllvRxRy16,
          2808 => Opcode::SltRxRy16,
          2809 => Opcode::SltiRxImm16,
          2810 => Opcode::SltiRxImmX16,
          2811 => Opcode::SltiuRxImm16,
          2812 => Opcode::SltiuRxImmX16,
          2813 => Opcode::SltuRxRy16,
          2814 => Opcode::SraX16,
          2815 => Opcode::SravRxRy16,
          2816 => Opcode::SrlX16,
          2817 => Opcode::SrlvRxRy16,
          2818 => Opcode::SubuRxRyRz16,
          2819 => Opcode::SwRxRyOffMemX16,
          2820 => Opcode::SwRxSpImmX16,
          2821 => Opcode::TEQ,
          2822 => Opcode::TEQI,
          2823 => Opcode::TEQI_MM,
          2824 => Opcode::TEQ_MM,
          2825 => Opcode::TGE,
          2826 => Opcode::TGEI,
          2827 => Opcode::TGEIU,
          2828 => Opcode::TGEIU_MM,
          2829 => Opcode::TGEI_MM,
          2830 => Opcode::TGEU,
          2831 => Opcode::TGEU_MM,
          2832 => Opcode::TGE_MM,
          2833 => Opcode::TLBGINV,
          2834 => Opcode::TLBGINVF,
          2835 => Opcode::TLBGINVF_MM,
          2836 => Opcode::TLBGINV_MM,
          2837 => Opcode::TLBGP,
          2838 => Opcode::TLBGP_MM,
          2839 => Opcode::TLBGR,
          2840 => Opcode::TLBGR_MM,
          2841 => Opcode::TLBGWI,
          2842 => Opcode::TLBGWI_MM,
          2843 => Opcode::TLBGWR,
          2844 => Opcode::TLBGWR_MM,
          2845 => Opcode::TLBINV,
          2846 => Opcode::TLBINVF,
          2847 => Opcode::TLBINVF_MMR6,
          2848 => Opcode::TLBINV_MMR6,
          2849 => Opcode::TLBP,
          2850 => Opcode::TLBP_MM,
          2851 => Opcode::TLBR,
          2852 => Opcode::TLBR_MM,
          2853 => Opcode::TLBWI,
          2854 => Opcode::TLBWI_MM,
          2855 => Opcode::TLBWR,
          2856 => Opcode::TLBWR_MM,
          2857 => Opcode::TLT,
          2858 => Opcode::TLTI,
          2859 => Opcode::TLTIU_MM,
          2860 => Opcode::TLTI_MM,
          2861 => Opcode::TLTU,
          2862 => Opcode::TLTU_MM,
          2863 => Opcode::TLT_MM,
          2864 => Opcode::TNE,
          2865 => Opcode::TNEI,
          2866 => Opcode::TNEI_MM,
          2867 => Opcode::TNE_MM,
          2868 => Opcode::TRUNC_L_D64,
          2869 => Opcode::TRUNC_L_D_MMR6,
          2870 => Opcode::TRUNC_L_S,
          2871 => Opcode::TRUNC_L_S_MMR6,
          2872 => Opcode::TRUNC_W_D32,
          2873 => Opcode::TRUNC_W_D64,
          2874 => Opcode::TRUNC_W_D_MMR6,
          2875 => Opcode::TRUNC_W_MM,
          2876 => Opcode::TRUNC_W_S,
          2877 => Opcode::TRUNC_W_S_MM,
          2878 => Opcode::TRUNC_W_S_MMR6,
          2879 => Opcode::TTLTIU,
          2880 => Opcode::UDIV,
          2881 => Opcode::UDIV_MM,
          2882 => Opcode::V3MULU,
          2883 => Opcode::VMM0,
          2884 => Opcode::VMULU,
          2885 => Opcode::VSHF_B,
          2886 => Opcode::VSHF_D,
          2887 => Opcode::VSHF_H,
          2888 => Opcode::VSHF_W,
          2889 => Opcode::WAIT,
          2890 => Opcode::WAIT_MM,
          2891 => Opcode::WAIT_MMR6,
          2892 => Opcode::WRDSP,
          2893 => Opcode::WRDSP_MM,
          2894 => Opcode::WRPGPR_MMR6,
          2895 => Opcode::WSBH,
          2896 => Opcode::WSBH_MM,
          2897 => Opcode::WSBH_MMR6,
          2898 => Opcode::XOR,
          2899 => Opcode::XOR16_MM,
          2900 => Opcode::XOR16_MMR6,
          2901 => Opcode::XOR64,
          2902 => Opcode::XORI_B,
          2903 => Opcode::XORI_MMR6,
          2904 => Opcode::XOR_MM,
          2905 => Opcode::XOR_MMR6,
          2906 => Opcode::XOR_V,
          2907 => Opcode::XORi,
          2908 => Opcode::XORi64,
          2909 => Opcode::XORi_MM,
          2910 => Opcode::XorRxRxRy16,
          2911 => Opcode::YIELD,
          2912 => Opcode::INSTRUCTION_LIST_END,
          _ => Opcode::UNKNOWN(value),
        }
    }
}
