// This file implements the IFolderView Interface for Python.
// Generated by makegw.py

#include "shell_pch.h"
#include "PyIFolderView.h"

// Helper functions

static PyObject *PyObject_FromPOINT(const POINT &p) { return Py_BuildValue("ll", p.x, p.y); }

static BOOL toPIDL(PyObject *pObjId, LPITEMIDLIST *ppidl, IFolderView *self)
{
    if (PyLong_Check(pObjId)) {
        int idx = (int)PyLong_AsLong(pObjId);
        HRESULT hr = self->Item(idx, ppidl);
        if (FAILED(hr)) {
            PyCom_BuildPyException(hr, self, IID_IFolderView);
            return FALSE;
        }
    }
    else if (PyBytes_Check(pObjId)) {
        // Gainarie: Create an "artificial" list ot be passed to PyObject_AsPIDL
        PyObject *list = PyList_New(1);
        if (list == NULL)
            return FALSE;
        Py_INCREF(pObjId);
        PyList_SET_ITEM(list, 0, pObjId);
        BOOL res = PyObject_AsPIDL(list, ppidl);
        Py_DECREF(list);
        if (!res)
            return FALSE;
    }
    else {
        PyErr_Format(PyExc_TypeError, "Integer (index) or bytes (PIDL) required");
        return FALSE;
    }
    return TRUE;
}

// @doc - This file contains autoduck documentation
// ---------------------------------------------------
//
// Interface Implementation

PyIFolderView::PyIFolderView(IUnknown *pdisp) : PyIUnknown(pdisp) { ob_type = &type; }

PyIFolderView::~PyIFolderView() {}

/* static */ IFolderView *PyIFolderView::GetI(PyObject *self) { return (IFolderView *)PyIUnknown::GetI(self); }

// @pymethod |PyIFolderView|GetCurrentViewMode|Description of GetCurrentViewMode.
PyObject *PyIFolderView::GetCurrentViewMode(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    UINT viewMode;
    if (!PyArg_ParseTuple(args, ":GetCurrentViewMode"))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->GetCurrentViewMode(&viewMode);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    return Py_BuildValue("I", viewMode);
}

// @pymethod |PyIFolderView|SetCurrentViewMode|Description of SetCurrentViewMode.
PyObject *PyIFolderView::SetCurrentViewMode(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    // @pyparm int|ViewMode||Description for ViewMode
    UINT viewMode;
    if (!PyArg_ParseTuple(args, "I:SetCurrentViewMode", &viewMode))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->SetCurrentViewMode(viewMode);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    Py_RETURN_NONE;
}

// @pymethod |PyIFolderView|GetFolder|Description of GetFolder.
PyObject *PyIFolderView::GetFolder(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    // @pyparm <o PyIID>|riid||Description for riid
    PyObject *obriid;
    IID riid;
    if (!PyArg_ParseTuple(args, "O:GetFolder", &obriid))
        return NULL;
    if (!PyWinObject_AsIID(obriid, &riid))
        return NULL;
    HRESULT hr;
    IShellFolder *ppshf = NULL;
    PY_INTERFACE_PRECALL;
    hr = pIFV->GetFolder(riid, (void **)&ppshf);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    return PyCom_PyObjectFromIUnknown(ppshf, IID_IShellFolder, FALSE);
}

// @pymethod |PyIFolderView|Item|Description of Item.
PyObject *PyIFolderView::Item(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    // @pyparm int|iItemIndex||Description for iItemIndex
    int iItemIndex;
    PITEMID_CHILD pidl = NULL;
    if (!PyArg_ParseTuple(args, "i:Item", &iItemIndex))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->Item(iItemIndex, &pidl);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    PyObject *obppidl;
    obppidl = PyObject_FromPIDL(pidl, TRUE);
    if ((obppidl == Py_None) || (!PyList_Check(obppidl)) || (PyList_Size(obppidl) != 1)) {
        Py_XDECREF(obppidl);
        Py_RETURN_NONE;
    }
    PyObject *pyretval = PyList_GetItem(obppidl, 0);
    Py_INCREF(pyretval);
    Py_DECREF(obppidl);
    return pyretval;
}

// @pymethod |PyIFolderView|ItemCount|Description of ItemCount.
PyObject *PyIFolderView::ItemCount(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    // @pyparm int|uFlags||Description for uFlags
    UINT uFlags;
    int pcItems;
    if (!PyArg_ParseTuple(args, "I:ItemCount", &uFlags))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->ItemCount(uFlags, &pcItems);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    return Py_BuildValue("i", pcItems);
}

// @pymethod |PyIFolderView|Items|Description of Items.
PyObject *PyIFolderView::Items(PyObject *self, PyObject *args)
{
    return PyErr_Format(PyExc_NotImplementedError, "Not implemented.");
    /*
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    // @pyparm int|uFlags||Description for uFlags
    // @pyparm <o PyIID>|riid||Description for riid
    // *** The input argument ppv of type "__RPC__deref_out_opt void **" was not processed ***
    //     Please check the conversion function is appropriate and exists!
    void ppv;
    PyObject *obppv;
    // @pyparm <o Pyvoid>|ppv||Description for ppv
    PyObject *obriid;
    UINT uFlags;
    IID riid;
    if (!PyArg_ParseTuple(args, "iOO:Items", &uFlags, &obriid, &obppv))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (!PyWinObject_AsIID(obriid, &riid))
        bPythonIsHappy = FALSE;
    if (bPythonIsHappy && !PyObject_Asvoid(obppv, &ppv))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->Items(uFlags, riid, ppv);
    PyObject_Freevoid(ppv);

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    // *** The output argument ppv of type "__RPC__deref_out_opt void **" was not processed ***
    //     The type 'void' (ppv) is unknown.
    Py_RETURN_NONE;
    //*/
}

// @pymethod |PyIFolderView|GetSelectionMarkedItem|Description of GetSelectionMarkedItem.
PyObject *PyIFolderView::GetSelectionMarkedItem(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    int piItem;
    if (!PyArg_ParseTuple(args, ":GetSelectionMarkedItem"))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->GetSelectionMarkedItem(&piItem);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    return Py_BuildValue("i", piItem);
}

// @pymethod |PyIFolderView|GetFocusedItem|Description of GetFocusedItem.
PyObject *PyIFolderView::GetFocusedItem(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    int item;
    if (!PyArg_ParseTuple(args, ":GetFocusedItem"))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->GetFocusedItem(&item);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    return Py_BuildValue("i", item);
}

// @pymethod |PyIFolderView|GetItemPosition|Description of GetItemPosition.
PyObject *PyIFolderView::GetItemPosition(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    // @pyparm <o PyIDL>|pidl||Description for pidl
    POINT pt;
    PyObject *obpidl;
    PCUITEMID_CHILD pidl = NULL;
    if (!PyArg_ParseTuple(args, "O:GetItemPosition", &obpidl))
        return NULL;
    if (!toPIDL(obpidl, (LPITEMIDLIST *)&pidl, pIFV))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->GetItemPosition(pidl, &pt);
    PyObject_FreePIDL(pidl);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    return PyObject_FromPOINT(pt);
}

// @pymethod |PyIFolderView|GetSpacing|Description of GetSpacing.
PyObject *PyIFolderView::GetSpacing(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    // @pyparm (int, int)|pt||Coordinates of an item
    POINT pt;
    if (!PyArg_ParseTuple(args, "ll:GetSpacing", &pt.x, &pt.y))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->GetSpacing(&pt);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    return PyObject_FromPOINT(pt);
}

// @pymethod |PyIFolderView|GetDefaultSpacing|Description of GetDefaultSpacing.
PyObject *PyIFolderView::GetDefaultSpacing(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    POINT pt;
    if (!PyArg_ParseTuple(args, ":GetDefaultSpacing"))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->GetDefaultSpacing(&pt);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    return PyObject_FromPOINT(pt);
}

// @pymethod |PyIFolderView|GetAutoArrange|Description of GetAutoArrange.
PyObject *PyIFolderView::GetAutoArrange(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    if (!PyArg_ParseTuple(args, ":GetAutoArrange"))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->GetAutoArrange();
    PY_INTERFACE_POSTCALL;
    if (hr == S_OK)
        Py_RETURN_TRUE;
    Py_RETURN_FALSE;
}

// @pymethod |PyIFolderView|SelectItem|Description of SelectItem.
PyObject *PyIFolderView::SelectItem(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    // @pyparm int|iItem||Description for iItem
    // @pyparm int|dwFlags||Description for dwFlags
    int item;
    DWORD dwFlags;
    if (!PyArg_ParseTuple(args, "ik:SelectItem", &item, &dwFlags))
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->SelectItem(item, dwFlags);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    Py_RETURN_NONE;
}

// @pymethod |PyIFolderView|SelectAndPositionItems|Description of SelectAndPositionItems.
PyObject *PyIFolderView::SelectAndPositionItems(PyObject *self, PyObject *args)
{
    return PyErr_Format(PyExc_NotImplementedError, "Not implemented. Use SelectAndPositionItem instead.");
    /*
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    // @pyparm int|cidl||Description for cidl
    // @pyparm <o PyIDL>|apidl||Description for apidl
    // *** The input argument apt of type "__RPC__in_ecount_full_opt(cidl) POINT *" was not processed ***
    //     Please check the conversion function is appropriate and exists!
    POINT apt;
    PyObject *obapt;
    // @pyparm <o PyPOINT>|apt||Description for apt
    // @pyparm int|dwFlags||Description for dwFlags
    PyObject *obapidl;
    UINT cidl;
    PCUITEMID_CHILD_ARRAY apidl;
    DWORD dwFlags;
    if (!PyArg_ParseTuple(args, "iOOl:SelectAndPositionItems", &cidl, &obapidl, &obapt, &dwFlags))
        return NULL;
    BOOL bPythonIsHappy = TRUE;
    if (bPythonIsHappy && !PyObject_AsPIDL(obapidl, &*apidl))
        bPythonIsHappy = FALSE;
    if (bPythonIsHappy && !PyObject_AsPOINT(obapt, &apt))
        bPythonIsHappy = FALSE;
    if (!bPythonIsHappy)
        return NULL;
    HRESULT hr;
    PY_INTERFACE_PRECALL;
    hr = pIFV->SelectAndPositionItems(cidl, apidl, apt, dwFlags);
    PyObject_FreePIDL(apidl);
    PyObject_FreePOINT(apt);

    PY_INTERFACE_POSTCALL;

    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    Py_RETURN_NONE;
//*/
}

// @pymethod |PyIFolderView|SelectAndPositionItem|Description of SelectAndPositionItem.
PyObject *PyIFolderView::SelectAndPositionItem(PyObject *self, PyObject *args)
{
    IFolderView *pIFV = GetI(self);
    if (pIFV == NULL)
        return NULL;
    LPITEMIDLIST pidl = NULL;
    PyObject *obpidl;
    POINT pt;
    // @pyparm <o PyIDL>|apidl||Description for apidl
    // @pyparm (int, int)|pt||Coordinates where drag operation entered the window
    // @pyparm int|dwFlags||Description for dwFlags
    DWORD dwFlags;
    if (!PyArg_ParseTuple(args, "O(ll)k:SelectAndPositionItem", &obpidl, &pt.x, &pt.y, &dwFlags))
        return NULL;
    if (!toPIDL(obpidl, &pidl, pIFV))
        return NULL;
    PY_INTERFACE_PRECALL;
    HRESULT hr = pIFV->SelectAndPositionItems(1, (LPCITEMIDLIST *)&pidl, &pt, dwFlags);
    PyObject_FreePIDL(pidl);
    PY_INTERFACE_POSTCALL;
    if (FAILED(hr))
        return PyCom_BuildPyException(hr, pIFV, IID_IFolderView);
    Py_RETURN_NONE;
}

// @object PyIFolderView|Description of the interface
static struct PyMethodDef PyIFolderView_methods[] = {
    {"GetCurrentViewMode", PyIFolderView::GetCurrentViewMode,
     1},  // @pymeth GetCurrentViewMode|Description of GetCurrentViewMode
    {"SetCurrentViewMode", PyIFolderView::SetCurrentViewMode,
     1},                                         // @pymeth SetCurrentViewMode|Description of SetCurrentViewMode
    {"GetFolder", PyIFolderView::GetFolder, 1},  // @pymeth GetFolder|Description of GetFolder
    {"Item", PyIFolderView::Item, 1},            // @pymeth Item|Description of Item
    {"ItemCount", PyIFolderView::ItemCount, 1},  // @pymeth ItemCount|Description of ItemCount
    {"Items", PyIFolderView::Items, 1},          // @pymeth Items|Description of Items
    {"GetSelectionMarkedItem", PyIFolderView::GetSelectionMarkedItem,
     1},  // @pymeth GetSelectionMarkedItem|Description of GetSelectionMarkedItem
    {"GetFocusedItem", PyIFolderView::GetFocusedItem, 1},    // @pymeth GetFocusedItem|Description of GetFocusedItem
    {"GetItemPosition", PyIFolderView::GetItemPosition, 1},  // @pymeth GetItemPosition|Description of GetItemPosition
    {"GetSpacing", PyIFolderView::GetSpacing, 1},            // @pymeth GetSpacing|Description of GetSpacing
    {"GetDefaultSpacing", PyIFolderView::GetDefaultSpacing,
     1},                                                   // @pymeth GetDefaultSpacing|Description of GetDefaultSpacing
    {"GetAutoArrange", PyIFolderView::GetAutoArrange, 1},  // @pymeth GetAutoArrange|Description of GetAutoArrange
    {"SelectItem", PyIFolderView::SelectItem, 1},          // @pymeth SelectItem|Description of SelectItem
    {"SelectAndPositionItems", PyIFolderView::SelectAndPositionItems,
     1},  // @pymeth SelectAndPositionItems|Description of SelectAndPositionItems
    {"SelectAndPositionItem", PyIFolderView::SelectAndPositionItem,
     1},  // @pymeth SelectAndPositionItem|Description of SelectAndPositionItem
    {NULL}};

PyComTypeObject PyIFolderView::type("PyIFolderView", &PyIUnknown::type, sizeof(PyIFolderView), PyIFolderView_methods,
                                    GET_PYCOM_CTOR(PyIFolderView));
