# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.10

import enum
import datetime
import sys
import types
import typing

import winsdk.system
import winsdk.windows.foundation
import winsdk.windows.foundation.collections
import winsdk.windows.foundation.numerics
import winsdk.windows.graphics.directx
import winsdk.windows.graphics.directx.direct3d11
import winsdk.windows.perception
import winsdk.windows.perception.spatial
import winsdk.windows.ui.core

class HolographicDepthReprojectionMethod(enum.IntEnum):
    DEPTH_REPROJECTION = 0
    AUTO_PLANAR = 1

class HolographicFramePresentResult(enum.IntEnum):
    SUCCESS = 0
    DEVICE_REMOVED = 1

class HolographicFramePresentWaitBehavior(enum.IntEnum):
    WAIT_FOR_FRAME_TO_FINISH = 0
    DO_NOT_WAIT_FOR_FRAME_TO_FINISH = 1

class HolographicReprojectionMode(enum.IntEnum):
    POSITION_AND_ORIENTATION = 0
    ORIENTATION_ONLY = 1
    DISABLED = 2

class HolographicSpaceUserPresence(enum.IntEnum):
    ABSENT = 0
    PRESENT_PASSIVE = 1
    PRESENT_ACTIVE = 2

class HolographicViewConfigurationKind(enum.IntEnum):
    DISPLAY = 0
    PHOTO_VIDEO_CAMERA = 1

Self = typing.TypeVar('Self')

class HolographicAdapterId:
    low_part: winsdk.system.UInt32
    high_part: winsdk.system.Int32
    def __new__(cls: typing.Type[HolographicAdapterId], low_part: winsdk.system.UInt32, high_part: winsdk.system.Int32) -> HolographicAdapterId: ...

class HolographicFrameId:
    value: winsdk.system.UInt64
    def __new__(cls: typing.Type[HolographicFrameId], value: winsdk.system.UInt64) -> HolographicFrameId: ...

class HolographicStereoTransform:
    left: winsdk.windows.foundation.numerics.Matrix4x4
    right: winsdk.windows.foundation.numerics.Matrix4x4
    def __new__(cls: typing.Type[HolographicStereoTransform], left: winsdk.windows.foundation.numerics.Matrix4x4, right: winsdk.windows.foundation.numerics.Matrix4x4) -> HolographicStereoTransform: ...

class HolographicCamera(winsdk.system.Object):
    viewport_scale_factor: winsdk.system.Double
    id: winsdk.system.UInt32
    is_stereo: winsdk.system.Boolean
    render_target_size: winsdk.windows.foundation.Size
    display: typing.Optional[HolographicDisplay]
    left_viewport_parameters: typing.Optional[HolographicCameraViewportParameters]
    right_viewport_parameters: typing.Optional[HolographicCameraViewportParameters]
    is_primary_layer_enabled: winsdk.system.Boolean
    max_quad_layer_count: winsdk.system.UInt32
    quad_layers: typing.Optional[winsdk.windows.foundation.collections.IVector[HolographicQuadLayer]]
    can_override_viewport: winsdk.system.Boolean
    is_hardware_content_protection_enabled: winsdk.system.Boolean
    is_hardware_content_protection_supported: winsdk.system.Boolean
    view_configuration: typing.Optional[HolographicViewConfiguration]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicCamera: ...
    def set_far_plane_distance(self, value: winsdk.system.Double, /) -> None: ...
    def set_near_plane_distance(self, value: winsdk.system.Double, /) -> None: ...

class HolographicCameraPose(winsdk.system.Object):
    far_plane_distance: winsdk.system.Double
    holographic_camera: typing.Optional[HolographicCamera]
    near_plane_distance: winsdk.system.Double
    projection_transform: HolographicStereoTransform
    viewport: winsdk.windows.foundation.Rect
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicCameraPose: ...
    def override_projection_transform(self, projection_transform: HolographicStereoTransform, /) -> None: ...
    def override_view_transform(self, coordinate_system: typing.Optional[winsdk.windows.perception.spatial.SpatialCoordinateSystem], coordinate_system_to_view_transform: HolographicStereoTransform, /) -> None: ...
    def override_viewport(self, left_viewport: winsdk.windows.foundation.Rect, right_viewport: winsdk.windows.foundation.Rect, /) -> None: ...
    def try_get_culling_frustum(self, coordinate_system: typing.Optional[winsdk.windows.perception.spatial.SpatialCoordinateSystem], /) -> typing.Optional[typing.Optional[winsdk.windows.perception.spatial.SpatialBoundingFrustum]]: ...
    def try_get_view_transform(self, coordinate_system: typing.Optional[winsdk.windows.perception.spatial.SpatialCoordinateSystem], /) -> typing.Optional[typing.Optional[HolographicStereoTransform]]: ...
    def try_get_visible_frustum(self, coordinate_system: typing.Optional[winsdk.windows.perception.spatial.SpatialCoordinateSystem], /) -> typing.Optional[typing.Optional[winsdk.windows.perception.spatial.SpatialBoundingFrustum]]: ...

class HolographicCameraRenderingParameters(winsdk.system.Object):
    direct3_d11_back_buffer: typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DSurface]
    direct3_d11_device: typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DDevice]
    reprojection_mode: HolographicReprojectionMode
    is_content_protection_enabled: winsdk.system.Boolean
    depth_reprojection_method: HolographicDepthReprojectionMethod
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicCameraRenderingParameters: ...
    def commit_direct3_d11_depth_buffer(self, value: typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DSurface], /) -> None: ...
    @typing.overload
    def set_focus_point(self, coordinate_system: typing.Optional[winsdk.windows.perception.spatial.SpatialCoordinateSystem], position: winsdk.windows.foundation.numerics.Vector3, /) -> None: ...
    @typing.overload
    def set_focus_point(self, coordinate_system: typing.Optional[winsdk.windows.perception.spatial.SpatialCoordinateSystem], position: winsdk.windows.foundation.numerics.Vector3, normal: winsdk.windows.foundation.numerics.Vector3, /) -> None: ...
    @typing.overload
    def set_focus_point(self, coordinate_system: typing.Optional[winsdk.windows.perception.spatial.SpatialCoordinateSystem], position: winsdk.windows.foundation.numerics.Vector3, normal: winsdk.windows.foundation.numerics.Vector3, linear_velocity: winsdk.windows.foundation.numerics.Vector3, /) -> None: ...

class HolographicCameraViewportParameters(winsdk.system.Object):
    hidden_area_mesh: winsdk.windows.foundation.numerics.Vector2
    visible_area_mesh: winsdk.windows.foundation.numerics.Vector2
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicCameraViewportParameters: ...

class HolographicDisplay(winsdk.system.Object):
    adapter_id: HolographicAdapterId
    display_name: str
    is_opaque: winsdk.system.Boolean
    is_stereo: winsdk.system.Boolean
    max_viewport_size: winsdk.windows.foundation.Size
    spatial_locator: typing.Optional[winsdk.windows.perception.spatial.SpatialLocator]
    refresh_rate: winsdk.system.Double
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicDisplay: ...
    @staticmethod
    def get_default() -> typing.Optional[HolographicDisplay]: ...
    def try_get_view_configuration(self, kind: HolographicViewConfigurationKind, /) -> typing.Optional[HolographicViewConfiguration]: ...

class HolographicFrame(winsdk.system.Object):
    added_cameras: typing.Optional[winsdk.windows.foundation.collections.IVectorView[HolographicCamera]]
    current_prediction: typing.Optional[HolographicFramePrediction]
    duration: datetime.timedelta
    removed_cameras: typing.Optional[winsdk.windows.foundation.collections.IVectorView[HolographicCamera]]
    id: HolographicFrameId
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicFrame: ...
    def get_quad_layer_update_parameters(self, layer: typing.Optional[HolographicQuadLayer], /) -> typing.Optional[HolographicQuadLayerUpdateParameters]: ...
    def get_rendering_parameters(self, camera_pose: typing.Optional[HolographicCameraPose], /) -> typing.Optional[HolographicCameraRenderingParameters]: ...
    @typing.overload
    def present_using_current_prediction(self) -> HolographicFramePresentResult: ...
    @typing.overload
    def present_using_current_prediction(self, wait_behavior: HolographicFramePresentWaitBehavior, /) -> HolographicFramePresentResult: ...
    def update_current_prediction(self) -> None: ...
    def wait_for_frame_to_finish(self) -> None: ...

class HolographicFramePrediction(winsdk.system.Object):
    camera_poses: typing.Optional[winsdk.windows.foundation.collections.IVectorView[HolographicCameraPose]]
    timestamp: typing.Optional[winsdk.windows.perception.PerceptionTimestamp]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicFramePrediction: ...

class HolographicFramePresentationMonitor(winsdk.system.Object):
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicFramePresentationMonitor: ...
    def close(self) -> None: ...
    def read_reports(self) -> typing.Optional[winsdk.windows.foundation.collections.IVectorView[HolographicFramePresentationReport]]: ...

class HolographicFramePresentationReport(winsdk.system.Object):
    app_gpu_duration: datetime.timedelta
    app_gpu_overrun: datetime.timedelta
    compositor_gpu_duration: datetime.timedelta
    missed_presentation_opportunity_count: winsdk.system.UInt32
    presentation_count: winsdk.system.UInt32
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicFramePresentationReport: ...

class HolographicFrameRenderingReport(winsdk.system.Object):
    frame_id: HolographicFrameId
    missed_latch_count: winsdk.system.UInt32
    system_relative_actual_gpu_finish_time: datetime.timedelta
    system_relative_frame_ready_time: datetime.timedelta
    system_relative_target_latch_time: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicFrameRenderingReport: ...

class HolographicFrameScanoutMonitor(winsdk.system.Object):
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicFrameScanoutMonitor: ...
    def close(self) -> None: ...
    def read_reports(self) -> typing.Optional[winsdk.windows.foundation.collections.IVector[HolographicFrameScanoutReport]]: ...

class HolographicFrameScanoutReport(winsdk.system.Object):
    missed_scanout_count: winsdk.system.UInt32
    rendering_report: typing.Optional[HolographicFrameRenderingReport]
    system_relative_latch_time: datetime.timedelta
    system_relative_photon_time: datetime.timedelta
    system_relative_scanout_start_time: datetime.timedelta
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicFrameScanoutReport: ...

class HolographicQuadLayer(winsdk.system.Object):
    pixel_format: winsdk.windows.graphics.directx.DirectXPixelFormat
    size: winsdk.windows.foundation.Size
    def __enter__(self: Self) -> Self: ...
    def __exit__(self, *args) -> None: ...
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicQuadLayer: ...
    @typing.overload
    def __new__(cls: typing.Type[HolographicQuadLayer], size: winsdk.windows.foundation.Size) -> HolographicQuadLayer:...
    @typing.overload
    def __new__(cls: typing.Type[HolographicQuadLayer], size: winsdk.windows.foundation.Size, pixel_format: winsdk.windows.graphics.directx.DirectXPixelFormat) -> HolographicQuadLayer:...
    def close(self) -> None: ...

class HolographicQuadLayerUpdateParameters(winsdk.system.Object):
    can_acquire_with_hardware_protection: winsdk.system.Boolean
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicQuadLayerUpdateParameters: ...
    def acquire_buffer_to_update_content(self) -> typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DSurface]: ...
    def acquire_buffer_to_update_content_with_hardware_protection(self) -> typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DSurface]: ...
    def update_content_protection_enabled(self, value: winsdk.system.Boolean, /) -> None: ...
    def update_extents(self, value: winsdk.windows.foundation.numerics.Vector2, /) -> None: ...
    def update_location_with_display_relative_mode(self, position: winsdk.windows.foundation.numerics.Vector3, orientation: winsdk.windows.foundation.numerics.Quaternion, /) -> None: ...
    def update_location_with_stationary_mode(self, coordinate_system: typing.Optional[winsdk.windows.perception.spatial.SpatialCoordinateSystem], position: winsdk.windows.foundation.numerics.Vector3, orientation: winsdk.windows.foundation.numerics.Quaternion, /) -> None: ...
    def update_viewport(self, value: winsdk.windows.foundation.Rect, /) -> None: ...

class HolographicSpace(winsdk.system.Object):
    primary_adapter_id: HolographicAdapterId
    user_presence: HolographicSpaceUserPresence
    is_available: typing.ClassVar[winsdk.system.Boolean]
    is_supported: typing.ClassVar[winsdk.system.Boolean]
    is_configured: typing.ClassVar[winsdk.system.Boolean]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicSpace: ...
    @staticmethod
    def create_for_core_window(window: typing.Optional[winsdk.windows.ui.core.CoreWindow], /) -> typing.Optional[HolographicSpace]: ...
    def create_frame_presentation_monitor(self, max_queued_reports: winsdk.system.UInt32, /) -> typing.Optional[HolographicFramePresentationMonitor]: ...
    def create_frame_scanout_monitor(self, max_queued_reports: winsdk.system.UInt32, /) -> typing.Optional[HolographicFrameScanoutMonitor]: ...
    def create_next_frame(self) -> typing.Optional[HolographicFrame]: ...
    def set_direct3_d11_device(self, value: typing.Optional[winsdk.windows.graphics.directx.direct3d11.IDirect3DDevice], /) -> None: ...
    def wait_for_next_frame_ready(self) -> None: ...
    def wait_for_next_frame_ready_with_head_start(self, requested_head_start_duration: datetime.timedelta, /) -> None: ...
    def add_camera_added(self, handler: winsdk.windows.foundation.TypedEventHandler[HolographicSpace, HolographicSpaceCameraAddedEventArgs], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_camera_added(self, cookie: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...
    def add_camera_removed(self, handler: winsdk.windows.foundation.TypedEventHandler[HolographicSpace, HolographicSpaceCameraRemovedEventArgs], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_camera_removed(self, cookie: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...
    def add_user_presence_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[HolographicSpace, winsdk.system.Object], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_user_presence_changed(self, token: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...
    @staticmethod
    def add_is_available_changed(handler: winsdk.windows.foundation.EventHandler[winsdk.system.Object], /) -> winsdk.windows.foundation.EventRegistrationToken: ...
    @staticmethod
    def remove_is_available_changed(token: winsdk.windows.foundation.EventRegistrationToken, /) -> None: ...

class HolographicSpaceCameraAddedEventArgs(winsdk.system.Object):
    camera: typing.Optional[HolographicCamera]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicSpaceCameraAddedEventArgs: ...
    def get_deferral(self) -> typing.Optional[winsdk.windows.foundation.Deferral]: ...

class HolographicSpaceCameraRemovedEventArgs(winsdk.system.Object):
    camera: typing.Optional[HolographicCamera]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicSpaceCameraRemovedEventArgs: ...

class HolographicViewConfiguration(winsdk.system.Object):
    pixel_format: winsdk.windows.graphics.directx.DirectXPixelFormat
    is_enabled: winsdk.system.Boolean
    display: typing.Optional[HolographicDisplay]
    is_stereo: winsdk.system.Boolean
    kind: HolographicViewConfigurationKind
    native_render_target_size: winsdk.windows.foundation.Size
    refresh_rate: winsdk.system.Double
    render_target_size: winsdk.windows.foundation.Size
    supported_pixel_formats: typing.Optional[winsdk.windows.foundation.collections.IVectorView[winsdk.windows.graphics.directx.DirectXPixelFormat]]
    supported_depth_reprojection_methods: typing.Optional[winsdk.windows.foundation.collections.IVectorView[HolographicDepthReprojectionMethod]]
    @staticmethod
    def _from(obj: winsdk.system.Object, /) -> HolographicViewConfiguration: ...
    def request_render_target_size(self, size: winsdk.windows.foundation.Size, /) -> winsdk.windows.foundation.Size: ...

