// font_introspector was retired from https://github.com/dfrg/swash
// which is licensed under MIT license

#![allow(dead_code)]

pub const fn tag2(b: &[u8; 2]) -> u16 {
    (b[0] as u16) << 8 | b[1] as u16
}

pub const fn tag3(b: &[u8; 3]) -> u32 {
    (b[0] as u32) << 16 | (b[1] as u32) << 8 | b[2] as u32
}

pub const fn tag4(b: &[u8; 4]) -> u32 {
    (b[0] as u32) << 24 | (b[1] as u32) << 16 | (b[2] as u32) << 8 | b[3] as u32
}

use self::tag2 as t2;
use self::tag3 as t3;
use self::tag4 as t4;

pub const ZHT_INDEX: u16 = 711;

#[rustfmt::skip]
pub const LANG_TAGS: [u32; 715] = [
    t4(b"ABA "), t4(b"ABK "), t4(b"ACH "), t4(b"ACR "), t4(b"ADY "), t4(b"AFK "), t4(b"AFR "), t4(b"AGW "), t4(b"AIO "), t4(b"AKA "), t4(b"ALS "), t4(b"ALT "), t4(b"ALT "), t4(b"AMH "), t4(b"ANG "), t4(b"ARA "), t4(b"ARG "), t4(b"ARI "), t4(b"ARK "), t4(b"ARK "), t4(b"ASM "), t4(b"AST "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), 
    t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), 
    t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"ATH "), t4(b"AVR "), t4(b"AWA "), t4(b"AYM "), t4(b"AZB "), t4(b"AZE "), t4(b"BAD "), t4(b"BAG "), t4(b"BAL "), t4(b"BAN "), t4(b"BAR "), 
    t4(b"BAU "), t4(b"BBC "), t4(b"BCH "), t4(b"BDY "), t4(b"BEL "), t4(b"BEM "), t4(b"BEN "), t4(b"BGC "), t4(b"BGQ "), t4(b"BGR "), t4(b"BHI "), t4(b"BHI "), t4(b"BHO "), t4(b"BIK "), t4(b"BIK "), t4(b"BIK "), t4(b"BIK "), t4(b"BIK "), t4(b"BIK "), t4(b"BIK "), t4(b"BIK "), t4(b"BIK "), t4(b"BIL "), t4(b"BIS "), t4(b"BJJ "), 
    t4(b"BKF "), t4(b"BLI "), t4(b"BLK "), t4(b"BLN "), t4(b"BLN "), t4(b"BLT "), t4(b"BMB "), t4(b"BOS "), t4(b"BPY "), t4(b"BRE "), t4(b"BRH "), t4(b"BRI "), t4(b"BRM "), t4(b"BRX "), t4(b"BSH "), t4(b"BSK "), t4(b"BTI "), t4(b"BTI "), t4(b"BTI "), t4(b"BTI "), t4(b"BTI "), t4(b"BTI "), t4(b"BTS "), t4(b"BUG "), t4(b"BYV "), 
    t4(b"CAK "), t4(b"CAT "), t4(b"CBK "), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CCHN"), t4(b"CEB "), t4(b"CGG "), t4(b"CHA "), t4(b"CHE "), t4(b"CHG "), t4(b"CHH "), t4(b"CHI "), t4(b"CHK "), 
    t4(b"CHK0"), t4(b"CHO "), t4(b"CHP "), t4(b"CHR "), t4(b"CHU "), t4(b"CHY "), t4(b"CJA "), t4(b"CJM "), t4(b"CMR "), t4(b"CMR "), t4(b"CMR "), t4(b"CMR "), t4(b"COP "), t4(b"COR "), t4(b"COS "), t4(b"CRE "), t4(b"CRR "), t4(b"CRR "), t4(b"CRT "), t4(b"CSB "), t4(b"CSL "), t4(b"CSY "), t4(b"CTG "), t4(b"CUK "), t4(b"DAN "), 
    t4(b"DAR "), t4(b"DAX "), t4(b"DCR "), t4(b"DEU "), t4(b"DGO "), t4(b"DGR "), t4(b"DHG "), t4(b"DIQ "), t4(b"DIV "), t4(b"DJR "), t4(b"DJR0"), t4(b"DNG "), t4(b"DNJ "), t4(b"DNK "), t4(b"DRI "), t4(b"DUJ "), t4(b"DUJ "), t4(b"DUN "), t4(b"DZN "), t4(b"EBI "), t4(b"ECR "), t4(b"ECR "), t4(b"EDO "), t4(b"EFI "), t4(b"ELL "), 
    t4(b"EMK "), t4(b"ENG "), t4(b"ERZ "), t4(b"ESP "), t4(b"ESU "), t4(b"ETI "), t4(b"EUQ "), t4(b"EVK "), t4(b"EVN "), t4(b"EWE "), t4(b"FAN "), t4(b"FAN0"), t4(b"FAR "), t4(b"FAT "), t4(b"FIN "), t4(b"FJI "), t4(b"FLE "), t4(b"FMP "), t4(b"FNE "), t4(b"FNE "), t4(b"FON "), t4(b"FOS "), t4(b"FRA "), t4(b"FRC "), t4(b"FRI "), 
    t4(b"FRL "), t4(b"FRP "), t4(b"FTA "), t4(b"FUL "), t4(b"FUV "), t4(b"GAD "), t4(b"GAE "), t4(b"GAG "), t4(b"GAL "), t4(b"GAW "), t4(b"GEZ "), t4(b"GIH "), t4(b"GIL "), t4(b"GIL0"), t4(b"GKP "), t4(b"GLK "), t4(b"GMZ "), t4(b"GNN "), t4(b"GOG "), t4(b"GON "), t4(b"GRN "), t4(b"GRO "), t4(b"GUA "), t4(b"GUC "), t4(b"GUF "), 
    t4(b"GUJ "), t4(b"GUZ "), t4(b"HAI "), t4(b"HAL "), t4(b"HAL "), t4(b"HAR "), t4(b"HAU "), t4(b"HAW "), t4(b"HAY "), t4(b"HAZ "), t4(b"HBN "), t4(b"HER "), t4(b"HIL "), t4(b"HIN "), t4(b"HMA "), t4(b"HMN "), t4(b"HMO "), t4(b"HND "), t4(b"HND "), t4(b"HRI "), t4(b"HRV "), t4(b"HUN "), t4(b"HYE "), t4(b"HYE0"), t4(b"IBA "), 
    t4(b"IBB "), t4(b"IBO "), t4(b"IDO "), t4(b"IJO "), t4(b"ILE "), t4(b"ILO "), t4(b"INA "), t4(b"IND "), t4(b"ING "), t4(b"INU "), t4(b"IPK "), t4(b"IRI "), t4(b"IRT "), t4(b"ISL "), t4(b"ISM "), t4(b"ITA "), t4(b"IWR "), t4(b"JAM "), t4(b"JAN "), t4(b"JAV "), t4(b"JBO "), t4(b"JCT "), t4(b"JII "), t4(b"JUD "), t4(b"JUL "), 
    t4(b"KAB "), t4(b"KAB0"), t4(b"KAC "), t4(b"KAL "), t4(b"KAN "), t4(b"KAR "), t4(b"KAT "), t4(b"KAZ "), t4(b"KDE "), t4(b"KEA "), t4(b"KEB "), t4(b"KEK "), t4(b"KGE "), t4(b"KHA "), t4(b"KHK "), t4(b"KHM "), t4(b"KHS "), t4(b"KHT "), t4(b"KHV "), t4(b"KHW "), t4(b"KIK "), t4(b"KIR "), t4(b"KIS "), t4(b"KIS "), t4(b"KIU "), 
    t4(b"KJD "), t4(b"KJP "), t4(b"KJZ "), t4(b"KKN "), t4(b"KLM "), t4(b"KMB "), t4(b"KMN "), t4(b"KMO "), t4(b"KMS "), t4(b"KMZ "), t4(b"KNR "), t4(b"KOD "), t4(b"KOH "), t4(b"KOK "), t4(b"KOM "), t4(b"KON "), t4(b"KON0"), t4(b"KOP "), t4(b"KOR "), t4(b"KOS "), t4(b"KOZ "), t4(b"KPL "), t4(b"KRI "), t4(b"KRK "), t4(b"KRL "), 
    t4(b"KRM "), t4(b"KRT "), t4(b"KSH "), t4(b"KSH0"), t4(b"KSI "), t4(b"KSM "), t4(b"KSW "), t4(b"KUA "), t4(b"KUI "), t4(b"KUL "), t4(b"KUM "), t4(b"KUR "), t4(b"KUU "), t4(b"KUY "), t4(b"KYK "), t4(b"KYU "), t4(b"LAD "), t4(b"LAH "), t4(b"LAK "), t4(b"LAM "), t4(b"LAO "), t4(b"LAT "), t4(b"LAZ "), t4(b"LCR "), t4(b"LDK "), 
    t4(b"LEZ "), t4(b"LIJ "), t4(b"LIM "), t4(b"LIN "), t4(b"LIS "), t4(b"LJP "), t4(b"LKI "), t4(b"LMA "), t4(b"LMB "), t4(b"LMO "), t4(b"LMW "), t4(b"LOM "), t4(b"LRC "), t4(b"LRC "), t4(b"LRC "), t4(b"LRC "), t4(b"LSB "), t4(b"LSM "), t4(b"LTH "), t4(b"LTZ "), t4(b"LUA "), t4(b"LUB "), t4(b"LUG "), t4(b"LUH "), t4(b"LUO "), 
    t4(b"LVI "), t4(b"MAD "), t4(b"MAG "), t4(b"MAH "), t4(b"MAJ "), t4(b"MAK "), t4(b"MAL "), t4(b"MAM "), t4(b"MAN "), t4(b"MAP "), t4(b"MAR "), t4(b"MAW "), t4(b"MAW "), t4(b"MAW "), t4(b"MAW "), t4(b"MAW "), t4(b"MAW "), t4(b"MAW "), t4(b"MBN "), t4(b"MBO "), t4(b"MCH "), t4(b"MCR "), t4(b"MDE "), t4(b"MDR "), t4(b"MEN "), 
    t4(b"MER "), t4(b"MFA "), t4(b"MFE "), t4(b"MIN "), t4(b"MIZ "), t4(b"MKD "), t4(b"MKR "), t4(b"MKW "), t4(b"MLE "), t4(b"MLG "), t4(b"MLN "), t4(b"MLR "), t4(b"MLY "), t4(b"MND "), t4(b"MNG "), t4(b"MNI "), t4(b"MNK "), t4(b"MNK "), t4(b"MNK "), t4(b"MNK "), t4(b"MNK "), t4(b"MNK "), t4(b"MNK "), t4(b"MNX "), t4(b"MOH "), 
    t4(b"MOK "), t4(b"MON "), t4(b"MOS "), t4(b"MRI "), t4(b"MTH "), t4(b"MTS "), t4(b"MUN "), t4(b"MUS "), t4(b"MWL "), t4(b"MWW "), t4(b"MZN "), t4(b"NAG "), t4(b"NAN "), t4(b"NAP "), t4(b"NAS "), t4(b"NAU "), t4(b"NAV "), t4(b"NCR "), t4(b"NDB "), t4(b"NDB "), t4(b"NDC "), t4(b"NDG "), t4(b"NDS "), t4(b"NEP "), t4(b"NEW "), 
    t4(b"NGA "), t4(b"NHC "), t4(b"NIS "), t4(b"NIS "), t4(b"NIU "), t4(b"NKL "), t4(b"NKO "), t4(b"NLD "), t4(b"NOE "), t4(b"NOG "), t4(b"NOR "), t4(b"NOV "), t4(b"NSM "), t4(b"NSO "), t4(b"NTA "), t4(b"NTO "), t4(b"NYM "), t4(b"NYN "), t4(b"NZA "), t4(b"OCI "), t4(b"OCR "), t4(b"OJB "), t4(b"ORI "), t4(b"ORO "), t4(b"OSS "), 
    t4(b"PAA "), t4(b"PAG "), t4(b"PAL "), t4(b"PAM "), t4(b"PAN "), t4(b"PAP "), t4(b"PAP0"), t4(b"PAS "), t4(b"PAU "), t4(b"PCC "), t4(b"PCD "), t4(b"PDC "), t4(b"PGR "), t4(b"PHK "), t4(b"PIH "), t4(b"PIL "), t4(b"PLG "), t4(b"PLG "), t4(b"PLG "), t4(b"PLK "), t4(b"PMS "), t4(b"PNB "), t4(b"POH "), t4(b"PON "), t4(b"PRO "), 
    t4(b"PTG "), t4(b"PWO "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QIN "), t4(b"QUC "), t4(b"QUH "), t4(b"QUZ "), t4(b"QVI "), 
    t4(b"QWH "), t4(b"RAJ "), t4(b"RAR "), t4(b"RBU "), t4(b"RCR "), t4(b"REJ "), t4(b"RIA "), t4(b"RIF "), t4(b"RIT "), t4(b"RKW "), t4(b"RMS "), t4(b"RMY "), t4(b"ROM "), t4(b"ROY "), t4(b"RSY "), t4(b"RTM "), t4(b"RUA "), t4(b"RUN "), t4(b"RUP "), t4(b"RUS "), t4(b"SAD "), t4(b"SAN "), t4(b"SAS "), t4(b"SAT "), t4(b"SAY "), 
    t4(b"SCN "), t4(b"SCO "), t4(b"SCS "), t4(b"SEK "), t4(b"SEL "), t4(b"SGA "), t4(b"SGO "), t4(b"SGS "), t4(b"SHI "), t4(b"SHN "), t4(b"SIB "), t4(b"SID "), t4(b"SIG "), t4(b"SIG "), t4(b"SKS "), t4(b"SKY "), t4(b"SLA "), t4(b"SLA "), t4(b"SLV "), t4(b"SML "), t4(b"SMO "), t4(b"SNA "), t4(b"SNA0"), t4(b"SND "), t4(b"SNH "), 
    t4(b"SNK "), t4(b"SOG "), t4(b"SOP "), t4(b"SOT "), t4(b"SQI "), t4(b"SRB "), t4(b"SRD "), t4(b"SRK "), t4(b"SRR "), t4(b"SSL "), t4(b"SSM "), t4(b"STQ "), t4(b"SUK "), t4(b"SUN "), t4(b"SUR "), t4(b"SVA "), t4(b"SVE "), t4(b"SWA "), t4(b"SWK "), t4(b"SWZ "), t4(b"SXT "), t4(b"SXU "), t4(b"SYL "), t4(b"SYR "), t4(b"SYR "), 
    t4(b"SYR "), t4(b"SYR "), t4(b"SYR "), t4(b"SYR "), t4(b"SYRE"), t4(b"SYRE"), t4(b"SYRJ"), t4(b"SYRJ"), t4(b"SYRN"), t4(b"SYRN"), t4(b"SZL "), t4(b"TAB "), t4(b"TAJ "), t4(b"TAM "), t4(b"TAT "), t4(b"TCR "), t4(b"TDD "), t4(b"TEL "), t4(b"TET "), t4(b"TGL "), t4(b"TGN "), t4(b"TGR "), t4(b"TGY "), t4(b"THA "), t4(b"THT "), 
    t4(b"TIB "), t4(b"TIV "), t4(b"TKM "), t4(b"TMH "), t4(b"TMN "), t4(b"TNA "), t4(b"TNE "), t4(b"TNE "), t4(b"TNG "), t4(b"TOD "), t4(b"TOD0"), t4(b"TPI "), t4(b"TRK "), t4(b"TSG "), t4(b"TSJ "), t4(b"TUA "), t4(b"TUL "), t4(b"TUM "), t4(b"TUV "), t4(b"TVL "), t4(b"TWI "), t4(b"TYZ "), t4(b"TZM "), t4(b"TZO "), t4(b"UDM "), 
    t4(b"UKR "), t4(b"UMB "), t4(b"URD "), t4(b"USB "), t4(b"UYG "), t4(b"UZB "), t4(b"VEC "), t4(b"VEN "), t4(b"VIT "), t4(b"VOL "), t4(b"VRO "), t4(b"WAG "), t4(b"WAR "), t4(b"WCR "), t4(b"WEL "), t4(b"WLF "), t4(b"WLN "), t4(b"WTM "), t4(b"XBD "), t4(b"XHS "), t4(b"XJB "), t4(b"XKF "), t4(b"XOG "), t4(b"XPE "), t4(b"YAK "), 
    t4(b"YAO "), t4(b"YAP "), t4(b"YBA "), t4(b"YCR "), t4(b"YIM "), t4(b"ZEA "), t4(b"ZGH "), t4(b"ZHA "), t4(b"ZHH "), t4(b"ZHP "), t4(b"ZHS "), t4(b"ZHT "), t4(b"ZND "), t4(b"ZUL "), t4(b"ZZA "), 
];

#[rustfmt::skip]
pub const LANG_BY_TAG2: [(u16, u16); 186] = [
    (t2(b"aa"), 6), (t2(b"ab"), 1), (t2(b"af"), 5), (t2(b"ak"), 9), (t2(b"ak"), 670), (t2(b"am"), 13), (t2(b"an"), 16), (t2(b"ar"), 15), (t2(b"as"), 20), (t2(b"av"), 65), (t2(b"ay"), 67), (t2(b"az"), 69), (t2(b"ba"), 114), 
    (t2(b"be"), 79), (t2(b"bg"), 84), (t2(b"bi"), 98), (t2(b"bm"), 106), (t2(b"bn"), 81), (t2(b"bo"), 650), (t2(b"br"), 109), (t2(b"bs"), 107), (t2(b"ca"), 126), (t2(b"ce"), 145), (t2(b"ch"), 144), (t2(b"co"), 164), (t2(b"cr"), 703), 
    (t2(b"cr"), 165), (t2(b"cs"), 171), (t2(b"cu"), 170), (t2(b"cv"), 154), (t2(b"cy"), 689), (t2(b"da"), 174), (t2(b"de"), 178), (t2(b"dv"), 183), (t2(b"dz"), 193), (t2(b"ee"), 209), (t2(b"el"), 199), (t2(b"el"), 512), (t2(b"en"), 201), 
    (t2(b"eo"), 490), (t2(b"es"), 203), (t2(b"et"), 205), (t2(b"eu"), 206), (t2(b"fa"), 212), (t2(b"ff"), 228), (t2(b"fi"), 214), (t2(b"fj"), 215), (t2(b"fo"), 221), (t2(b"fr"), 222), (t2(b"fy"), 224), (t2(b"ga"), 287), (t2(b"ga"), 286), 
    (t2(b"gd"), 231), (t2(b"gl"), 233), (t2(b"gn"), 247), (t2(b"gu"), 250), (t2(b"gv"), 448), (t2(b"ha"), 256), (t2(b"he"), 291), (t2(b"hi"), 263), (t2(b"ho"), 266), (t2(b"hr"), 270), (t2(b"ht"), 252), (t2(b"hu"), 271), (t2(b"hy"), 273), 
    (t2(b"hy"), 272), (t2(b"hz"), 261), (t2(b"ia"), 281), (t2(b"id"), 282), (t2(b"ie"), 279), (t2(b"ig"), 276), (t2(b"ii"), 704), (t2(b"ik"), 285), (t2(b"io"), 277), (t2(b"is"), 288), (t2(b"it"), 290), (t2(b"iu"), 284), (t2(b"ja"), 293), 
    (t2(b"jv"), 294), (t2(b"ka"), 312), (t2(b"ka"), 306), (t2(b"kg"), 341), (t2(b"ki"), 320), (t2(b"kj"), 357), (t2(b"kk"), 307), (t2(b"kl"), 245), (t2(b"km"), 315), (t2(b"kn"), 304), (t2(b"ko"), 343), (t2(b"kr"), 335), (t2(b"ks"), 352), 
    (t2(b"ku"), 361), (t2(b"kv"), 339), (t2(b"kw"), 163), (t2(b"ky"), 321), (t2(b"la"), 371), (t2(b"lb"), 394), (t2(b"lg"), 397), (t2(b"li"), 377), (t2(b"ln"), 378), (t2(b"lo"), 370), (t2(b"lt"), 393), (t2(b"lu"), 396), (t2(b"lv"), 400), 
    (t2(b"mg"), 434), (t2(b"mh"), 403), (t2(b"mi"), 453), (t2(b"mk"), 430), (t2(b"ml"), 406), (t2(b"ml"), 436), (t2(b"mn"), 439), (t2(b"mr"), 410), (t2(b"ms"), 437), (t2(b"mt"), 455), (t2(b"my"), 112), (t2(b"na"), 465), (t2(b"nb"), 485), 
    (t2(b"nd"), 469), (t2(b"ne"), 473), (t2(b"ng"), 471), (t2(b"nl"), 482), (t2(b"nn"), 492), (t2(b"nr"), 468), (t2(b"nv"), 50), (t2(b"nv"), 466), (t2(b"ny"), 148), (t2(b"oc"), 494), (t2(b"oj"), 496), (t2(b"om"), 498), (t2(b"or"), 497), 
    (t2(b"os"), 499), (t2(b"pa"), 504), (t2(b"pi"), 502), (t2(b"pl"), 519), (t2(b"ps"), 507), (t2(b"pt"), 525), (t2(b"rm"), 560), (t2(b"rn"), 567), (t2(b"ro"), 562), (t2(b"ru"), 569), (t2(b"rw"), 566), (t2(b"sa"), 571), (t2(b"sc"), 606), 
    (t2(b"sd"), 598), (t2(b"se"), 487), (t2(b"sg"), 581), (t2(b"si"), 599), (t2(b"sk"), 590), (t2(b"sl"), 593), (t2(b"sm"), 595), (t2(b"sn"), 597), (t2(b"so"), 594), (t2(b"sq"), 604), (t2(b"sr"), 605), (t2(b"ss"), 619), (t2(b"st"), 603), 
    (t2(b"su"), 613), (t2(b"sv"), 616), (t2(b"sw"), 618), (t2(b"ta"), 638), (t2(b"te"), 642), (t2(b"tg"), 637), (t2(b"th"), 648), (t2(b"ti"), 647), (t2(b"tk"), 652), (t2(b"tl"), 644), (t2(b"tn"), 655), (t2(b"to"), 645), (t2(b"tr"), 662), 
    (t2(b"ts"), 663), (t2(b"tt"), 639), (t2(b"ty"), 649), (t2(b"ug"), 679), (t2(b"uk"), 675), (t2(b"ur"), 677), (t2(b"uz"), 680), (t2(b"ve"), 682), (t2(b"vi"), 683), (t2(b"vo"), 684), (t2(b"wa"), 691), (t2(b"wo"), 690), (t2(b"xh"), 694), 
    (t2(b"yi"), 297), (t2(b"yo"), 702), (t2(b"za"), 707), (t2(b"zu"), 713), 
];

#[rustfmt::skip]
pub const LANG_BY_TAG3: [(u32, u32); 711] = [
    (t3(b"aar"), 6), (t3(b"abk"), 1), (t3(b"abq"), 0), (t3(b"acf"), 210), (t3(b"ach"), 2), (t3(b"acr"), 3), (t3(b"ada"), 186), (t3(b"ady"), 4), (t3(b"afr"), 5), (t3(b"ahg"), 7), (t3(b"aht"), 33), (t3(b"aii"), 617), (t3(b"aii"), 628), 
    (t3(b"aio"), 8), (t3(b"aiw"), 17), (t3(b"aka"), 670), (t3(b"aka"), 9), (t3(b"alt"), 12), (t3(b"amf"), 260), (t3(b"amh"), 13), (t3(b"amw"), 627), (t3(b"ang"), 14), (t3(b"apj"), 46), (t3(b"apk"), 45), (t3(b"apl"), 47), (t3(b"apm"), 48), 
    (t3(b"apw"), 49), (t3(b"ara"), 15), (t3(b"arg"), 16), (t3(b"arn"), 409), (t3(b"asm"), 20), (t3(b"ast"), 21), (t3(b"atj"), 554), (t3(b"atv"), 11), (t3(b"ava"), 65), (t3(b"awa"), 66), (t3(b"aym"), 67), (t3(b"azb"), 68), (t3(b"aze"), 69), 
    (t3(b"bak"), 114), (t3(b"bal"), 101), (t3(b"bam"), 106), (t3(b"ban"), 73), (t3(b"bar"), 74), (t3(b"bbc"), 76), (t3(b"bci"), 75), (t3(b"bcl"), 94), (t3(b"bcq"), 77), (t3(b"bcr"), 53), (t3(b"bdy"), 78), (t3(b"bea"), 51), (t3(b"beb"), 116), 
    (t3(b"bel"), 79), (t3(b"bem"), 80), (t3(b"ben"), 81), (t3(b"bfq"), 70), (t3(b"bft"), 105), (t3(b"bfu"), 367), (t3(b"bfy"), 71), (t3(b"bgc"), 82), (t3(b"bgq"), 83), (t3(b"bgr"), 545), (t3(b"bhb"), 86), (t3(b"bhi"), 85), (t3(b"bho"), 87), 
    (t3(b"bik"), 92), (t3(b"bin"), 197), (t3(b"bis"), 98), (t3(b"bjj"), 99), (t3(b"bjt"), 104), (t3(b"bla"), 100), (t3(b"ble"), 103), (t3(b"blk"), 102), (t3(b"bln"), 95), (t3(b"bod"), 650), (t3(b"bos"), 107), (t3(b"bpy"), 108), (t3(b"bqi"), 388), 
    (t3(b"bra"), 111), (t3(b"bre"), 109), (t3(b"brh"), 110), (t3(b"brx"), 113), (t3(b"bsk"), 115), (t3(b"bto"), 96), (t3(b"bts"), 122), (t3(b"bug"), 123), (t3(b"bul"), 84), (t3(b"bum"), 117), (t3(b"bxp"), 118), (t3(b"bxr"), 553), (t3(b"byn"), 97), 
    (t3(b"byv"), 124), (t3(b"caf"), 54), (t3(b"caf"), 166), (t3(b"cak"), 125), (t3(b"cat"), 126), (t3(b"cbk"), 127), (t3(b"cbl"), 529), (t3(b"cco"), 140), (t3(b"ceb"), 142), (t3(b"ces"), 171), (t3(b"cfm"), 253), (t3(b"cgg"), 143), (t3(b"cha"), 144), 
    (t3(b"che"), 145), (t3(b"chj"), 139), (t3(b"chk"), 150), (t3(b"cho"), 151), (t3(b"chp"), 574), (t3(b"chp"), 152), (t3(b"chp"), 58), (t3(b"chq"), 138), (t3(b"chr"), 153), (t3(b"chu"), 170), (t3(b"chv"), 154), (t3(b"chy"), 155), (t3(b"chz"), 137), 
    (t3(b"cja"), 156), (t3(b"cjm"), 157), (t3(b"ckt"), 149), (t3(b"clc"), 55), (t3(b"cld"), 626), (t3(b"cle"), 136), (t3(b"cmr"), 534), (t3(b"cnb"), 528), (t3(b"cnh"), 544), (t3(b"cnk"), 531), (t3(b"cnl"), 135), (t3(b"cnt"), 141), (t3(b"cnw"), 543), 
    (t3(b"cop"), 162), (t3(b"coq"), 25), (t3(b"cor"), 163), (t3(b"cos"), 164), (t3(b"cpa"), 134), (t3(b"cre"), 165), (t3(b"cre"), 703), (t3(b"crh"), 168), (t3(b"crj"), 195), (t3(b"crk"), 688), (t3(b"crl"), 196), (t3(b"crm"), 421), (t3(b"crm"), 373), 
    (t3(b"crx"), 167), (t3(b"crx"), 64), (t3(b"csa"), 132), (t3(b"csb"), 169), (t3(b"csh"), 527), (t3(b"cso"), 131), (t3(b"csw"), 476), (t3(b"csw"), 467), (t3(b"csy"), 539), (t3(b"ctc"), 26), (t3(b"ctd"), 538), (t3(b"cte"), 130), (t3(b"ctg"), 172), 
    (t3(b"ctl"), 129), (t3(b"cts"), 93), (t3(b"cuc"), 128), (t3(b"cuk"), 173), (t3(b"cvn"), 133), (t3(b"cwd"), 640), (t3(b"cwd"), 177), (t3(b"cym"), 689), (t3(b"czt"), 542), (t3(b"dan"), 174), (t3(b"dao"), 533), (t3(b"dar"), 175), (t3(b"dax"), 176), 
    (t3(b"deu"), 178), (t3(b"dgo"), 179), (t3(b"dgr"), 59), (t3(b"dhd"), 416), (t3(b"dhg"), 181), (t3(b"din"), 188), (t3(b"diq"), 182), (t3(b"div"), 183), (t3(b"dje"), 184), (t3(b"djr"), 185), (t3(b"dng"), 192), (t3(b"dnj"), 187), (t3(b"doi"), 180), 
    (t3(b"dsb"), 391), (t3(b"dwu"), 190), (t3(b"dwy"), 191), (t3(b"dyu"), 299), (t3(b"dzo"), 193), (t3(b"efi"), 198), (t3(b"ell"), 199), (t3(b"ell"), 512), (t3(b"emk"), 200), (t3(b"emk"), 442), (t3(b"enf"), 218), (t3(b"eng"), 201), (t3(b"enh"), 656), 
    (t3(b"epo"), 490), (t3(b"est"), 205), (t3(b"esu"), 204), (t3(b"eto"), 119), (t3(b"eus"), 206), (t3(b"eve"), 208), (t3(b"evn"), 207), (t3(b"ewe"), 209), (t3(b"ewo"), 120), (t3(b"fan"), 211), (t3(b"fao"), 221), (t3(b"fas"), 212), (t3(b"fat"), 213), 
    (t3(b"fbl"), 91), (t3(b"fij"), 215), (t3(b"fil"), 515), (t3(b"fin"), 214), (t3(b"fmp"), 217), (t3(b"fon"), 220), (t3(b"fra"), 222), (t3(b"frc"), 223), (t3(b"frp"), 226), (t3(b"fry"), 224), (t3(b"fuf"), 227), (t3(b"ful"), 228), (t3(b"fur"), 225), 
    (t3(b"fuv"), 229), (t3(b"gaa"), 230), (t3(b"gag"), 232), (t3(b"gbm"), 234), (t3(b"gce"), 27), (t3(b"gez"), 235), (t3(b"gih"), 236), (t3(b"gil"), 238), (t3(b"gkp"), 239), (t3(b"gla"), 231), (t3(b"gld"), 462), (t3(b"gle"), 287), (t3(b"gle"), 286), 
    (t3(b"glg"), 233), (t3(b"glk"), 240), (t3(b"glv"), 448), (t3(b"gnn"), 242), (t3(b"gog"), 243), (t3(b"gon"), 244), (t3(b"grn"), 247), (t3(b"grt"), 246), (t3(b"gru"), 601), (t3(b"gsw"), 10), (t3(b"guc"), 248), (t3(b"guf"), 249), (t3(b"guj"), 250), 
    (t3(b"guk"), 241), (t3(b"guz"), 251), (t3(b"gwi"), 56), (t3(b"haa"), 57), (t3(b"har"), 269), (t3(b"hat"), 252), (t3(b"hau"), 256), (t3(b"haw"), 257), (t3(b"hay"), 258), (t3(b"haz"), 259), (t3(b"heb"), 291), (t3(b"her"), 261), (t3(b"hil"), 262), 
    (t3(b"hin"), 263), (t3(b"hlt"), 532), (t3(b"hmn"), 265), (t3(b"hmo"), 266), (t3(b"hnd"), 267), (t3(b"hne"), 147), (t3(b"hno"), 268), (t3(b"hoi"), 63), (t3(b"hoj"), 255), (t3(b"hrv"), 270), (t3(b"hsb"), 678), (t3(b"hun"), 271), (t3(b"hup"), 31), 
    (t3(b"hye"), 273), (t3(b"hye"), 272), (t3(b"iba"), 274), (t3(b"ibb"), 275), (t3(b"ibo"), 276), (t3(b"ido"), 277), (t3(b"igb"), 194), (t3(b"iii"), 704), (t3(b"ijc"), 278), (t3(b"iku"), 284), (t3(b"ile"), 279), (t3(b"ilo"), 280), (t3(b"ina"), 281), 
    (t3(b"ind"), 282), (t3(b"ing"), 44), (t3(b"inh"), 283), (t3(b"ipk"), 285), (t3(b"isl"), 288), (t3(b"ita"), 290), (t3(b"jam"), 292), (t3(b"jav"), 294), (t3(b"jbo"), 295), (t3(b"jct"), 296), (t3(b"jpn"), 293), (t3(b"kaa"), 348), (t3(b"kab"), 301), 
    (t3(b"kal"), 245), (t3(b"kam"), 330), (t3(b"kan"), 304), (t3(b"kas"), 352), (t3(b"kat"), 312), (t3(b"kat"), 306), (t3(b"kau"), 335), (t3(b"kaz"), 307), (t3(b"kbd"), 300), (t3(b"kca"), 314), (t3(b"kca"), 318), (t3(b"kca"), 316), (t3(b"kde"), 308), 
    (t3(b"kdr"), 350), (t3(b"kdt"), 363), (t3(b"kea"), 309), (t3(b"kek"), 311), (t3(b"kex"), 328), (t3(b"kfa"), 336), (t3(b"kfr"), 302), (t3(b"kfx"), 359), (t3(b"kfy"), 331), (t3(b"kha"), 354), (t3(b"khb"), 693), (t3(b"khm"), 315), (t3(b"kht"), 317), 
    (t3(b"khw"), 319), (t3(b"kik"), 320), (t3(b"kin"), 566), (t3(b"kir"), 321), (t3(b"kiu"), 324), (t3(b"kjd"), 325), (t3(b"kjh"), 313), (t3(b"kjp"), 326), (t3(b"kjz"), 327), (t3(b"kkz"), 30), (t3(b"kln"), 303), (t3(b"kmb"), 418), (t3(b"kmw"), 332), 
    (t3(b"kmz"), 334), (t3(b"koi"), 342), (t3(b"kok"), 338), (t3(b"kom"), 339), (t3(b"kon"), 341), (t3(b"kor"), 343), (t3(b"kos"), 344), (t3(b"koy"), 42), (t3(b"kpe"), 346), (t3(b"kpv"), 345), (t3(b"kpy"), 364), (t3(b"kqs"), 323), (t3(b"kqy"), 351), 
    (t3(b"krc"), 305), (t3(b"krc"), 72), (t3(b"kri"), 347), (t3(b"krl"), 349), (t3(b"kru"), 362), (t3(b"ksh"), 353), (t3(b"kss"), 322), (t3(b"ksw"), 356), (t3(b"ktb"), 310), (t3(b"ktu"), 340), (t3(b"ktw"), 43), (t3(b"kua"), 357), (t3(b"kum"), 360), 
    (t3(b"kur"), 361), (t3(b"kuu"), 38), (t3(b"kxc"), 333), (t3(b"kxu"), 358), (t3(b"kyu"), 365), (t3(b"lad"), 298), (t3(b"lao"), 370), (t3(b"lat"), 371), (t3(b"lav"), 400), (t3(b"lbe"), 368), (t3(b"lbj"), 374), (t3(b"lbl"), 90), (t3(b"lez"), 375), 
    (t3(b"lif"), 383), (t3(b"lij"), 376), (t3(b"lim"), 377), (t3(b"lin"), 378), (t3(b"lis"), 379), (t3(b"lit"), 393), (t3(b"ljp"), 380), (t3(b"lki"), 381), (t3(b"lld"), 366), (t3(b"lmn"), 369), (t3(b"lmo"), 384), (t3(b"lom"), 386), (t3(b"lrc"), 389), 
    (t3(b"ltz"), 394), (t3(b"lua"), 395), (t3(b"lub"), 396), (t3(b"lug"), 397), (t3(b"luo"), 399), (t3(b"lus"), 429), (t3(b"luy"), 398), (t3(b"luz"), 390), (t3(b"lzz"), 372), (t3(b"mad"), 401), (t3(b"mag"), 402), (t3(b"mah"), 403), (t3(b"mai"), 454), 
    (t3(b"mak"), 431), (t3(b"mal"), 436), (t3(b"mal"), 406), (t3(b"mam"), 407), (t3(b"man"), 447), (t3(b"mar"), 410), (t3(b"mbo"), 419), (t3(b"mct"), 121), (t3(b"mdf"), 450), (t3(b"mdr"), 423), (t3(b"mdy"), 433), (t3(b"men"), 422), (t3(b"mer"), 425), 
    (t3(b"mfa"), 426), (t3(b"mfe"), 427), (t3(b"mhr"), 382), (t3(b"min"), 428), (t3(b"mkd"), 430), (t3(b"mku"), 446), (t3(b"mkw"), 432), (t3(b"mlg"), 434), (t3(b"mlq"), 441), (t3(b"mlq"), 435), (t3(b"mlt"), 455), (t3(b"mnc"), 420), (t3(b"mni"), 440), 
    (t3(b"mnk"), 445), (t3(b"mnk"), 438), (t3(b"mns"), 408), (t3(b"mnw"), 451), (t3(b"moh"), 449), (t3(b"mon"), 439), (t3(b"mos"), 452), (t3(b"mpe"), 404), (t3(b"mrh"), 530), (t3(b"mri"), 453), (t3(b"mrj"), 264), (t3(b"msa"), 437), (t3(b"msc"), 443), 
    (t3(b"mtr"), 412), (t3(b"mus"), 457), (t3(b"mvb"), 23), (t3(b"mve"), 417), (t3(b"mwk"), 444), (t3(b"mwl"), 458), (t3(b"mwr"), 414), (t3(b"mww"), 459), (t3(b"mya"), 112), (t3(b"mym"), 424), (t3(b"myv"), 202), (t3(b"mzn"), 460), (t3(b"nag"), 461), 
    (t3(b"nap"), 463), (t3(b"nau"), 465), (t3(b"nav"), 466), (t3(b"nav"), 50), (t3(b"nbl"), 468), (t3(b"ndc"), 470), (t3(b"nde"), 469), (t3(b"ndo"), 471), (t3(b"nds"), 472), (t3(b"nep"), 473), (t3(b"new"), 474), (t3(b"nga"), 475), (t3(b"ngl"), 385), 
    (t3(b"ngo"), 620), (t3(b"niu"), 479), (t3(b"niv"), 237), (t3(b"njz"), 478), (t3(b"nld"), 482), (t3(b"nno"), 492), (t3(b"nob"), 485), (t3(b"nod"), 489), (t3(b"noe"), 483), (t3(b"nog"), 484), (t3(b"nov"), 486), (t3(b"nqo"), 481), (t3(b"nsk"), 464), 
    (t3(b"nso"), 488), (t3(b"nya"), 148), (t3(b"nym"), 491), (t3(b"nyn"), 480), (t3(b"nza"), 493), (t3(b"oci"), 494), (t3(b"oji"), 496), (t3(b"ojs"), 495), (t3(b"okm"), 337), (t3(b"ori"), 497), (t3(b"orm"), 498), (t3(b"oss"), 499), (t3(b"pag"), 501), 
    (t3(b"pam"), 503), (t3(b"pan"), 504), (t3(b"pap"), 506), (t3(b"pau"), 508), (t3(b"pcc"), 509), (t3(b"pcd"), 510), (t3(b"pce"), 516), (t3(b"pck"), 537), (t3(b"pdc"), 511), (t3(b"phk"), 513), (t3(b"pih"), 514), (t3(b"pli"), 502), (t3(b"pll"), 518), 
    (t3(b"plp"), 505), (t3(b"pms"), 520), (t3(b"pnb"), 521), (t3(b"poh"), 522), (t3(b"pol"), 519), (t3(b"pon"), 523), (t3(b"por"), 525), (t3(b"pro"), 524), (t3(b"prs"), 189), (t3(b"pus"), 507), (t3(b"pwo"), 526), (t3(b"quc"), 546), (t3(b"quh"), 547), 
    (t3(b"quz"), 548), (t3(b"qvi"), 549), (t3(b"qwh"), 550), (t3(b"raj"), 551), (t3(b"rar"), 552), (t3(b"rbb"), 517), (t3(b"rbl"), 89), (t3(b"rej"), 555), (t3(b"ria"), 556), (t3(b"rif"), 557), (t3(b"rit"), 558), (t3(b"rki"), 19), (t3(b"rkw"), 559), 
    (t3(b"rmy"), 561), (t3(b"rmz"), 18), (t3(b"rnl"), 254), (t3(b"roh"), 560), (t3(b"rom"), 563), (t3(b"ron"), 562), (t3(b"rtm"), 565), (t3(b"rue"), 564), (t3(b"run"), 567), (t3(b"rup"), 568), (t3(b"rus"), 569), (t3(b"rwr"), 415), (t3(b"sag"), 581), 
    (t3(b"sah"), 699), (t3(b"sam"), 500), (t3(b"san"), 571), (t3(b"sas"), 572), (t3(b"sat"), 573), (t3(b"sck"), 570), (t3(b"scn"), 575), (t3(b"sco"), 576), (t3(b"scs"), 60), (t3(b"scs"), 577), (t3(b"scs"), 591), (t3(b"seh"), 596), (t3(b"sek"), 52), 
    (t3(b"sel"), 579), (t3(b"sez"), 541), (t3(b"sga"), 580), (t3(b"sgs"), 582), (t3(b"sgw"), 146), (t3(b"shi"), 583), (t3(b"shn"), 584), (t3(b"sid"), 586), (t3(b"sin"), 599), (t3(b"sjd"), 355), (t3(b"sjo"), 585), (t3(b"skr"), 607), (t3(b"slk"), 590), 
    (t3(b"slv"), 593), (t3(b"sma"), 610), (t3(b"sme"), 487), (t3(b"smj"), 392), (t3(b"smn"), 289), (t3(b"smo"), 595), (t3(b"sms"), 589), (t3(b"sna"), 597), (t3(b"snd"), 598), (t3(b"snk"), 600), (t3(b"som"), 594), (t3(b"sop"), 602), (t3(b"sot"), 603), 
    (t3(b"spa"), 203), (t3(b"sqi"), 604), (t3(b"srd"), 606), (t3(b"srp"), 605), (t3(b"srr"), 608), (t3(b"srs"), 62), (t3(b"ssw"), 619), (t3(b"stq"), 611), (t3(b"stv"), 587), (t3(b"suk"), 612), (t3(b"sun"), 613), (t3(b"suq"), 614), (t3(b"sva"), 615), 
    (t3(b"swa"), 618), (t3(b"swb"), 158), (t3(b"swe"), 616), (t3(b"swv"), 411), (t3(b"sxu"), 621), (t3(b"syc"), 631), (t3(b"syc"), 629), (t3(b"syc"), 625), (t3(b"syc"), 633), (t3(b"syl"), 622), (t3(b"syr"), 632), (t3(b"syr"), 634), (t3(b"syr"), 624), 
    (t3(b"syr"), 630), (t3(b"szl"), 635), (t3(b"taa"), 35), (t3(b"tab"), 636), (t3(b"tah"), 649), (t3(b"tam"), 638), (t3(b"tat"), 639), (t3(b"tau"), 36), (t3(b"tcb"), 37), (t3(b"tce"), 39), (t3(b"tcp"), 540), (t3(b"tcy"), 666), (t3(b"tcz"), 536), 
    (t3(b"tdd"), 641), (t3(b"tel"), 642), (t3(b"tem"), 654), (t3(b"tet"), 643), (t3(b"tfn"), 34), (t3(b"tgj"), 477), (t3(b"tgk"), 637), (t3(b"tgl"), 644), (t3(b"tgx"), 32), (t3(b"tha"), 648), (t3(b"tht"), 41), (t3(b"tig"), 646), (t3(b"tir"), 647), 
    (t3(b"tiv"), 651), (t3(b"tmh"), 653), (t3(b"tod"), 660), (t3(b"toi"), 658), (t3(b"tol"), 28), (t3(b"ton"), 645), (t3(b"tpi"), 661), (t3(b"tru"), 623), (t3(b"tru"), 665), (t3(b"tsj"), 664), (t3(b"tsn"), 655), (t3(b"tso"), 663), (t3(b"ttm"), 40), 
    (t3(b"tuk"), 652), (t3(b"tum"), 667), (t3(b"tur"), 662), (t3(b"tuu"), 29), (t3(b"tvl"), 669), (t3(b"txc"), 22), (t3(b"tyv"), 668), (t3(b"tyz"), 671), (t3(b"tzm"), 672), (t3(b"tzo"), 673), (t3(b"ubl"), 88), (t3(b"udm"), 674), (t3(b"uig"), 679), 
    (t3(b"ukr"), 675), (t3(b"umb"), 676), (t3(b"unr"), 456), (t3(b"urd"), 677), (t3(b"uzb"), 680), (t3(b"vec"), 681), (t3(b"ven"), 682), (t3(b"vie"), 683), (t3(b"vls"), 216), (t3(b"vmw"), 405), (t3(b"vol"), 684), (t3(b"vro"), 685), (t3(b"war"), 687), 
    (t3(b"wbr"), 686), (t3(b"wlc"), 159), (t3(b"wle"), 588), (t3(b"wlk"), 24), (t3(b"wln"), 691), (t3(b"wni"), 160), (t3(b"wol"), 690), (t3(b"wry"), 413), (t3(b"wtm"), 692), (t3(b"xal"), 329), (t3(b"xal"), 659), (t3(b"xan"), 578), (t3(b"xho"), 694), 
    (t3(b"xjb"), 695), (t3(b"xkf"), 696), (t3(b"xog"), 697), (t3(b"xpe"), 698), (t3(b"xsl"), 592), (t3(b"xsl"), 609), (t3(b"xsl"), 61), (t3(b"yao"), 700), (t3(b"yap"), 701), (t3(b"yid"), 297), (t3(b"yor"), 702), (t3(b"yrk"), 657), (t3(b"yrk"), 219), 
    (t3(b"zdj"), 161), (t3(b"zea"), 705), (t3(b"zgh"), 706), (t3(b"zha"), 707), (t3(b"zne"), 712), (t3(b"zom"), 535), (t3(b"zul"), 713), (t3(b"zum"), 387), (t3(b"zza"), 714), 
];

#[rustfmt::skip]
pub const LANG_ENTRIES: [(&'static str, &'static str); 715] = [
    ("Abaza", "abq"), ("Abkhazian", "ab"), ("Acoli", "ach"), ("Achi", "acr"), ("Adyghe", "ady"), ("Afrikaans", "af"), ("Afar", "aa"), ("Qimant", "ahg"), ("Aiton", "aio"), ("Akan", "ak"), ("Swiss German", "gsw"), ("Northern Altai", "atv"), ("Southern Altai", "alt"), ("Amharic", "am"), ("Old English (ca. 450-1100)", "ang"), ("Arabic", "ar"), ("Aragonese", "an"), 
    ("Aari", "aiw"), ("Marma", "rmz"), ("Rakhine", "rki"), ("Assamese", "as"), ("Asturian", "ast"), ("Tsetsaut", "txc"), ("Mattole", "mvb"), ("Wailaki", "wlk"), ("Coquille", "coq"), ("Chetco", "ctc"), ("Galice", "gce"), ("Tolowa", "tol"), ("Tututni", "tuu"), ("Kaska", "kkz"), ("Hupa", "hup"), ("Tagish", "tgx"), ("Ahtena", "aht"), 
    ("Tanaina", "tfn"), ("Lower Tanana", "taa"), ("Upper Tanana", "tau"), ("Tanacross", "tcb"), ("Upper Kuskokwim", "kuu"), ("Southern Tutchone", "tce"), ("Northern Tutchone", "ttm"), ("Tahltan", "tht"), ("Koyukon", "koy"), ("Kato", "ktw"), ("Degexit'an", "ing"), ("Kiowa Apache", "apk"), ("Jicarilla Apache", "apj"), ("Lipan Apache", "apl"), ("Mescalero-Chiricahua Apache", "apm"), ("Western Apache", "apw"), ("Navajo", "nv"), 
    ("Beaver", "bea"), ("Sekani", "sek"), ("Babine", "bcr"), ("Southern Carrier", "caf"), ("Chilcotin", "clc"), ("Gwichʼin", "gwi"), ("Han", "haa"), ("Chipewyan", "chp"), ("Dogrib", "dgr"), ("North Slavey", "scs"), ("South Slavey", "xsl"), ("Sarsi", "srs"), ("Holikachuk", "hoi"), ("Carrier", "crx"), ("Avaric", "av"), ("Awadhi", "awa"), ("Aymara", "ay"), 
    ("South Azerbaijani", "azb"), ("Azerbaijani", "az"), ("Badaga", "bfq"), ("Bagheli", "bfy"), ("Karachay-Balkar", "krc"), ("Balinese", "ban"), ("Bavarian", "bar"), ("Baoulé", "bci"), ("Batak Toba", "bbc"), ("Bench", "bcq"), ("Bandjalang", "bdy"), ("Belarusian", "be"), ("Bemba (Zambia)", "bem"), ("Bengali", "bn"), ("Haryanvi", "bgc"), ("Bagri", "bgq"), ("Bulgarian", "bg"), 
    ("Bhilali", "bhi"), ("Bhili", "bhb"), ("Bhojpuri", "bho"), ("Buhi'non Bikol", "ubl"), ("Miraya Bikol", "rbl"), ("Libon Bikol", "lbl"), ("West Albay Bikol", "fbl"), ("Bikol", "bik"), ("Northern Catanduanes Bikol", "cts"), ("Central Bikol", "bcl"), ("Southern Catanduanes Bikol", "bln"), ("Rinconada Bikol", "bto"), ("Bilin", "byn"), ("Bislama", "bi"), ("Kanauji", "bjj"), ("Siksika", "bla"), ("Baluchi", "bal"), 
    ("Pa'o Karen", "blk"), ("Balanta-Kentohe", "ble"), ("Balanta-Ganja", "bjt"), ("Balti", "bft"), ("Bambara", "bm"), ("Bosnian", "bs"), ("Bishnupriya", "bpy"), ("Breton", "br"), ("Brahui", "brh"), ("Braj", "bra"), ("Burmese", "my"), ("Bodo (India)", "brx"), ("Bashkir", "ba"), ("Burushaski", "bsk"), ("Bebele", "beb"), ("Bulu (Cameroon)", "bum"), ("Bebil", "bxp"), 
    ("Eton (Cameroon)", "eto"), ("Ewondo", "ewo"), ("Mengisa", "mct"), ("Batak Simalungun", "bts"), ("Buginese", "bug"), ("Medumba", "byv"), ("Kaqchikel", "cak"), ("Catalan", "ca"), ("Chavacano", "cbk"), ("Usila Chinantec", "cuc"), ("Tlacoatzintepec Chinantec", "ctl"), ("Tepinapa Chinantec", "cte"), ("Sochiapam Chinantec", "cso"), ("Chiltepec Chinantec", "csa"), ("Valle Nacional Chinantec", "cvn"), ("Palantla Chinantec", "cpa"), ("Lalana Chinantec", "cnl"), 
    ("Lealao Chinantec", "cle"), ("Ozumacín Chinantec", "chz"), ("Quiotepec Chinantec", "chq"), ("Ojitlán Chinantec", "chj"), ("Comaltepec Chinantec", "cco"), ("Tepetotutla Chinantec", "cnt"), ("Cebuano", "ceb"), ("Chiga", "cgg"), ("Chamorro", "ch"), ("Chechen", "ce"), ("Sebat Bet Gurage", "sgw"), ("Chhattisgarhi", "hne"), ("Nyanja", "ny"), ("Chukot", "ckt"), ("Chuukese", "chk"), ("Choctaw", "cho"), ("Chipewyan", "chp"), 
    ("Cherokee", "chr"), ("Chuvash", "cv"), ("Cheyenne", "chy"), ("Western Cham", "cja"), ("Eastern Cham", "cjm"), ("Maore Comorian", "swb"), ("Mwali Comorian", "wlc"), ("Ndzwani Comorian", "wni"), ("Ngazidja Comorian", "zdj"), ("Coptic", "cop"), ("Cornish", "kw"), ("Corsican", "co"), ("Cree", "cr"), ("Southern Carrier", "caf"), ("Carrier", "crx"), ("Crimean Tatar", "crh"), ("Kashubian", "csb"), 
    ("Church Slavic", "cu"), ("Czech", "cs"), ("Chittagonian", "ctg"), ("San Blas Kuna", "cuk"), ("Danish", "da"), ("Dargwa", "dar"), ("Dayi", "dax"), ("Woods Cree", "cwd"), ("German", "de"), ("Dogri (individual language)", "dgo"), ("Dogri (macrolanguage)", "doi"), ("Dhangu-Djangu", "dhg"), ("Dimli (individual language)", "diq"), ("Dhivehi", "dv"), ("Zarma", "dje"), ("Djambarrpuyngu", "djr"), ("Adangme", "ada"), 
    ("Dan", "dnj"), ("Dinka", "din"), ("Dari", "prs"), ("Dhuwal", "dwu"), ("Dhuwaya", "dwy"), ("Dungan", "dng"), ("Dzongkha", "dz"), ("Ebira", "igb"), ("Southern East Cree", "crj"), ("Northern East Cree", "crl"), ("Bini", "bin"), ("Efik", "efi"), ("Modern Greek (1453-)", "el"), ("Eastern Maninkakan", "emk"), ("English", "en"), ("Erzya", "myv"), ("Spanish", "es"), 
    ("Central Yupik", "esu"), ("Estonian", "et"), ("Basque", "eu"), ("Evenki", "evn"), ("Even", "eve"), ("Ewe", "ee"), ("Saint Lucian Creole French", "acf"), ("Fang (Equatorial Guinea)", "fan"), ("Persian", "fa"), ("Fanti", "fat"), ("Finnish", "fi"), ("Fijian", "fj"), ("Vlaams", "vls"), ("Fe'fe'", "fmp"), ("Forest Enets", "enf"), ("Nenets", "yrk"), ("Fon", "fon"), 
    ("Faroese", "fo"), ("French", "fr"), ("Cajun French", "frc"), ("Western Frisian", "fy"), ("Friulian", "fur"), ("Arpitan", "frp"), ("Pular", "fuf"), ("Fulah", "ff"), ("Nigerian Fulfulde", "fuv"), ("Ga", "gaa"), ("Scottish Gaelic", "gd"), ("Gagauz", "gag"), ("Galician", "gl"), ("Garhwali", "gbm"), ("Geez", "gez"), ("Githabul", "gih"), ("Gilyak", "niv"), 
    ("Gilbertese", "gil"), ("Guinea Kpelle", "gkp"), ("Gilaki", "glk"), ("Gumuz", "guk"), ("Gumatj", "gnn"), ("Gogo", "gog"), ("Gondi", "gon"), ("Kalaallisut", "kl"), ("Garo", "grt"), ("Guarani", "gn"), ("Wayuu", "guc"), ("Gupapuyngu", "guf"), ("Gujarati", "gu"), ("Gusii", "guz"), ("Haitian", "ht"), ("Falam Chin", "cfm"), ("Ranglong", "rnl"), 
    ("Hadothi", "hoj"), ("Hausa", "ha"), ("Hawaiian", "haw"), ("Haya", "hay"), ("Hazaragi", "haz"), ("Hamer-Banna", "amf"), ("Herero", "hz"), ("Hiligaynon", "hil"), ("Hindi", "hi"), ("Western Mari", "mrj"), ("Hmong", "hmn"), ("Hiri Motu", "ho"), ("Southern Hindko", "hnd"), ("Northern Hindko", "hno"), ("Harari", "har"), ("Croatian", "hr"), ("Hungarian", "hu"), 
    ("Armenian", "hy"), ("Armenian", "hy"), ("Iban", "iba"), ("Ibibio", "ibb"), ("Igbo", "ig"), ("Ido", "io"), ("Izon", "ijc"), ("Interlingue", "ie"), ("Iloko", "ilo"), ("Interlingua (International Auxiliary Language Association)", "ia"), ("Indonesian", "id"), ("Ingush", "inh"), ("Inuktitut", "iu"), ("Inupiaq", "ik"), ("Irish", "ga"), ("Irish", "ga"), ("Icelandic", "is"), 
    ("Inari Sami", "smn"), ("Italian", "it"), ("Hebrew", "he"), ("Jamaican Creole English", "jam"), ("Japanese", "ja"), ("Javanese", "jv"), ("Lojban", "jbo"), ("Krymchak", "jct"), ("Yiddish", "yi"), ("Ladino", "lad"), ("Dyula", "dyu"), ("Kabardian", "kbd"), ("Kabyle", "kab"), ("Kachhi", "kfr"), ("Kalenjin", "kln"), ("Kannada", "kn"), ("Karachay-Balkar", "krc"), 
    ("Georgian", "ka"), ("Kazakh", "kk"), ("Makonde", "kde"), ("Kabuverdianu", "kea"), ("Kambaata", "ktb"), ("Kekchí", "kek"), ("Georgian", "ka"), ("Khakas", "kjh"), ("Khanty", "kca"), ("Central Khmer", "km"), ("Khanty", "kca"), ("Khamti", "kht"), ("Khanty", "kca"), ("Khowar", "khw"), ("Kikuyu", "ki"), ("Kirghiz", "ky"), ("Southern Kisi", "kss"), 
    ("Northern Kissi", "kqs"), ("Kirmanjki (individual language)", "kiu"), ("Southern Kiwai", "kjd"), ("Pwo Eastern Karen", "kjp"), ("Bumthangkha", "kjz"), ("Kukna", "kex"), ("Kalmyk", "xal"), ("Kamba (Kenya)", "kam"), ("Kumaoni", "kfy"), ("Komo (Democratic Republic of Congo)", "kmw"), ("Konso", "kxc"), ("Khorasani Turkish", "kmz"), ("Kanuri", "kr"), ("Kodava", "kfa"), ("Middle Korean (10th-16th cent.)", "okm"), ("Konkani (macrolanguage)", "kok"), ("Komi", "kv"), 
    ("Kituba (Democratic Republic of Congo)", "ktu"), ("Kongo", "kg"), ("Komi-Permyak", "koi"), ("Korean", "ko"), ("Kosraean", "kos"), ("Komi-Zyrian", "kpv"), ("Kpelle", "kpe"), ("Krio", "kri"), ("Kara-Kalpak", "kaa"), ("Karelian", "krl"), ("Karaim", "kdr"), ("Koorete", "kqy"), ("Kashmiri", "ks"), ("Kölsch", "ksh"), ("Khasi", "kha"), ("Kildin Sami", "sjd"), ("S'gaw Karen", "ksw"), 
    ("Kuanyama", "kj"), ("Kui (India)", "kxu"), ("Kullu Pahari", "kfx"), ("Kumyk", "kum"), ("Kurdish", "ku"), ("Kurukh", "kru"), ("Kuy", "kdt"), ("Koryak", "kpy"), ("Western Kayah", "kyu"), ("Ladin", "lld"), ("Gahri", "bfu"), ("Lak", "lbe"), ("Lambadi", "lmn"), ("Lao", "lo"), ("Latin", "la"), ("Laz", "lzz"), ("Moose Cree", "crm"), 
    ("Ladakhi", "lbj"), ("Lezghian", "lez"), ("Ligurian", "lij"), ("Limburgan", "li"), ("Lingala", "ln"), ("Lisu", "lis"), ("Lampung Api", "ljp"), ("Laki", "lki"), ("Eastern Mari", "mhr"), ("Limbu", "lif"), ("Lombard", "lmo"), ("Lomwe", "ngl"), ("Loma (Liberia)", "lom"), ("Kumzari", "zum"), ("Bakhtiari", "bqi"), ("Northern Luri", "lrc"), ("Southern Luri", "luz"), 
    ("Lower Sorbian", "dsb"), ("Lule Sami", "smj"), ("Lithuanian", "lt"), ("Luxembourgish", "lb"), ("Luba-Lulua", "lua"), ("Luba-Katanga", "lu"), ("Ganda", "lg"), ("Luyia", "luy"), ("Luo (Kenya and Tanzania)", "luo"), ("Latvian", "lv"), ("Madurese", "mad"), ("Magahi", "mag"), ("Marshallese", "mh"), ("Majang", "mpe"), ("Makhuwa", "vmw"), ("Malayalam", "ml"), ("Mam", "mam"), 
    ("Mansi", "mns"), ("Mapudungun", "arn"), ("Marathi", "mr"), ("Shekhawati", "swv"), ("Mewari", "mtr"), ("Merwari", "wry"), ("Marwari", "mwr"), ("Marwari (India)", "rwr"), ("Dhundari", "dhd"), ("Marwari (Pakistan)", "mve"), ("Kimbundu", "kmb"), ("Mbo (Cameroon)", "mbo"), ("Manchu", "mnc"), ("Moose Cree", "crm"), ("Mende (Sierra Leone)", "men"), ("Mandar", "mdr"), ("Me'en", "mym"), 
    ("Meru", "mer"), ("Pattani Malay", "mfa"), ("Morisyen", "mfe"), ("Minangkabau", "min"), ("Lushai", "lus"), ("Macedonian", "mk"), ("Makasar", "mak"), ("Kituba (Congo)", "mkw"), ("Male (Ethiopia)", "mdy"), ("Malagasy", "mg"), ("Western Maninkakan", "mlq"), ("Malayalam", "ml"), ("Malay (macrolanguage)", "ms"), ("Mandinka", "mnk"), ("Mongolian", "mn"), ("Manipuri", "mni"), ("Western Maninkakan", "mlq"), 
    ("Eastern Maninkakan", "emk"), ("Sankaran Maninka", "msc"), ("Kita Maninkakan", "mwk"), ("Mandinka", "mnk"), ("Konyanka Maninka", "mku"), ("Mandingo", "man"), ("Manx", "gv"), ("Mohawk", "moh"), ("Moksha", "mdf"), ("Mon", "mnw"), ("Mossi", "mos"), ("Maori", "mi"), ("Maithili", "mai"), ("Maltese", "mt"), ("Mundari", "unr"), ("Creek", "mus"), ("Mirandese", "mwl"), 
    ("Hmong Daw", "mww"), ("Mazanderani", "mzn"), ("Naga Pidgin", "nag"), ("Nanai", "gld"), ("Neapolitan", "nap"), ("Naskapi", "nsk"), ("Nauru", "na"), ("Navajo", "nv"), ("Swampy Cree", "csw"), ("South Ndebele", "nr"), ("North Ndebele", "nd"), ("Ndau", "ndc"), ("Ndonga", "ng"), ("Low German", "nds"), ("Nepali (macrolanguage)", "ne"), ("Newari", "new"), ("Ngbaka", "nga"), 
    ("Swampy Cree", "csw"), ("Tagin", "tgj"), ("Nyishi", "njz"), ("Niuean", "niu"), ("Nyankole", "nyn"), ("N'Ko", "nqo"), ("Dutch", "nl"), ("Nimadi", "noe"), ("Nogai", "nog"), ("Norwegian Bokmål", "nb"), ("Novial", "nov"), ("Northern Sami", "se"), ("Pedi", "nso"), ("Northern Thai", "nod"), ("Esperanto", "eo"), ("Nyamwezi", "nym"), ("Norwegian Nynorsk", "nn"), 
    ("Tigon Mbembe", "nza"), ("Occitan (post 1500)", "oc"), ("Severn Ojibwa", "ojs"), ("Ojibwa", "oj"), ("Oriya (macrolanguage)", "or"), ("Oromo", "om"), ("Ossetian", "os"), ("Samaritan Aramaic", "sam"), ("Pangasinan", "pag"), ("Pali", "pi"), ("Pampanga", "pam"), ("Panjabi", "pa"), ("Palpa", "plp"), ("Papiamento", "pap"), ("Pushto", "ps"), ("Palauan", "pau"), ("Bouyei", "pcc"), 
    ("Picard", "pcd"), ("Pennsylvania German", "pdc"), ("Modern Greek (1453-)", "el"), ("Phake", "phk"), ("Pitcairn-Norfolk", "pih"), ("Filipino", "fil"), ("Ruching Palaung", "pce"), ("Rumai Palaung", "rbb"), ("Shwe Palaung", "pll"), ("Polish", "pl"), ("Piemontese", "pms"), ("Western Panjabi", "pnb"), ("Poqomchi'", "poh"), ("Pohnpeian", "pon"), ("Old Provençal (to 1500)", "pro"), ("Portuguese", "pt"), ("Pwo Western Karen", "pwo"), 
    ("Asho Chin", "csh"), ("Chinbon Chin", "cnb"), ("Bualkhaw Chin", "cbl"), ("Mara Chin", "mrh"), ("Khumi Chin", "cnk"), ("Matu Chin", "hlt"), ("Daai Chin", "dao"), ("Mro-Khimi Chin", "cmr"), ("Zou", "zom"), ("Thado Chin", "tcz"), ("Paite Chin", "pck"), ("Tedim Chin", "ctd"), ("Siyin Chin", "csy"), ("Tawr Chin", "tcp"), ("Senthang Chin", "sez"), ("Zotung Chin", "czt"), ("Ngawn Chin", "cnw"), 
    ("Hakha Chin", "cnh"), ("Bawm Chin", "bgr"), ("K'iche'", "quc"), ("South Bolivian Quechua", "quh"), ("Cusco Quechua", "quz"), ("Imbabura Highland Quichua", "qvi"), ("Huaylas Ancash Quechua", "qwh"), ("Rajasthani", "raj"), ("Rarotongan", "rar"), ("Russia Buriat", "bxr"), ("Atikamekw", "atj"), ("Rejang", "rej"), ("Riang (India)", "ria"), ("Tarifit", "rif"), ("Ritarungo", "rit"), ("Arakwal", "rkw"), ("Romansh", "rm"), 
    ("Vlax Romani", "rmy"), ("Romanian", "ro"), ("Romany", "rom"), ("Rusyn", "rue"), ("Rotuman", "rtm"), ("Kinyarwanda", "rw"), ("Rundi", "rn"), ("Macedo-Romanian", "rup"), ("Russian", "ru"), ("Sadri", "sck"), ("Sanskrit", "sa"), ("Sasak", "sas"), ("Santali", "sat"), ("Chipewyan", "chp"), ("Sicilian", "scn"), ("Scots", "sco"), ("North Slavey", "scs"), 
    ("Xamtanga", "xan"), ("Selkup", "sel"), ("Old Irish (to 900)", "sga"), ("Sango", "sg"), ("Samogitian", "sgs"), ("Tachelhit", "shi"), ("Shan", "shn"), ("Xibe", "sjo"), ("Sidamo", "sid"), ("Silt'e", "stv"), ("Wolane", "wle"), ("Skolt Sami", "sms"), ("Slovak", "sk"), ("North Slavey", "scs"), ("South Slavey", "xsl"), ("Slovenian", "sl"), ("Somali", "so"), 
    ("Samoan", "sm"), ("Sena", "seh"), ("Shona", "sn"), ("Sindhi", "sd"), ("Sinhala", "si"), ("Soninke", "snk"), ("Kistane", "gru"), ("Songe", "sop"), ("Southern Sotho", "st"), ("Albanian", "sq"), ("Serbian", "sr"), ("Sardinian", "sc"), ("Saraiki", "skr"), ("Serer", "srr"), ("South Slavey", "xsl"), ("Southern Sami", "sma"), ("Saterfriesisch", "stq"), 
    ("Sukuma", "suk"), ("Sundanese", "su"), ("Suri", "suq"), ("Svan", "sva"), ("Swedish", "sv"), ("Assyrian Neo-Aramaic", "aii"), ("Swahili (macrolanguage)", "sw"), ("Swati", "ss"), ("Ngoni", "ngo"), ("Upper Saxon", "sxu"), ("Sylheti", "syl"), ("Turoyo", "tru"), ("Syriac", "syr"), ("Classical Syriac", "syc"), ("Chaldean Neo-Aramaic", "cld"), ("Western Neo-Aramaic", "amw"), ("Assyrian Neo-Aramaic", "aii"), 
    ("Classical Syriac", "syc"), ("Syriac", "syr"), ("Classical Syriac", "syc"), ("Syriac", "syr"), ("Classical Syriac", "syc"), ("Syriac", "syr"), ("Silesian", "szl"), ("Tabassaran", "tab"), ("Tajik", "tg"), ("Tamil", "ta"), ("Tatar", "tt"), ("Woods Cree", "cwd"), ("Tai Nüa", "tdd"), ("Telugu", "te"), ("Tetum", "tet"), ("Tagalog", "tl"), ("Tonga (Tonga Islands)", "to"), 
    ("Tigre", "tig"), ("Tigrinya", "ti"), ("Thai", "th"), ("Tahitian", "ty"), ("Tibetan", "bo"), ("Tiv", "tiv"), ("Turkmen", "tk"), ("Tamashek", "tmh"), ("Timne", "tem"), ("Tswana", "tn"), ("Tundra Enets", "enh"), ("Nenets", "yrk"), ("Tonga (Zambia)", "toi"), ("Kalmyk", "xal"), ("Toma", "tod"), ("Tok Pisin", "tpi"), ("Turkish", "tr"), 
    ("Tsonga", "ts"), ("Tshangla", "tsj"), ("Turoyo", "tru"), ("Tulu", "tcy"), ("Tumbuka", "tum"), ("Tuvinian", "tyv"), ("Tuvalu", "tvl"), ("Akan", "ak"), ("Tày", "tyz"), ("Central Atlas Tamazight", "tzm"), ("Tzotzil", "tzo"), ("Udmurt", "udm"), ("Ukrainian", "uk"), ("Umbundu", "umb"), ("Urdu", "ur"), ("Upper Sorbian", "hsb"), ("Uighur", "ug"), 
    ("Uzbek", "uz"), ("Venetian", "vec"), ("Venda", "ve"), ("Vietnamese", "vi"), ("Volapük", "vo"), ("Võro", "vro"), ("Wagdi", "wbr"), ("Waray (Philippines)", "war"), ("Plains Cree", "crk"), ("Welsh", "cy"), ("Wolof", "wo"), ("Walloon", "wa"), ("Mewati", "wtm"), ("Lü", "khb"), ("Xhosa", "xh"), ("Minjungbal", "xjb"), ("Khengkha", "xkf"), 
    ("Soga", "xog"), ("Liberia Kpelle", "xpe"), ("Yakut", "sah"), ("Yao", "yao"), ("Yapese", "yap"), ("Yoruba", "yo"), ("Cree", "cr"), ("Sichuan Yi", "ii"), ("Zeeuws", "zea"), ("Standard Moroccan Tamazight", "zgh"), ("Zhuang", "za"), ("Chinese", "zh"), ("Chinese", "zh"), ("Chinese", "zh"), ("Chinese", "zh"), ("Zande (individual language)", "zne"), ("Zulu", "zu"), 
    ("Zaza", "zza"), 
];
