# History

A brief history of SoX maintenance

## Maintainers

| From    | To       | Versions     | Maintainers |
| ----    | --       | --------     | ----------- |
| 1991-07 | 1995     | 1 to 11      | Lance Norskog on alt.sources using FTP and then the web.(1) |
| 1996-05 | 2015-02  | 11 to 14.4.2 | Chris Bagwell, Rob Sykes, Reuben Thomas, Pascal Giard, Ulrich Klauer, Eric Wong.(2) |
| 2015-02 | 2017-11  | none         | No one.(2) |
| 2017-11 | 2024-06  | none         | Mäns Rullgärd with occasional contributions from 13 other people.(2) |
| 2024-06 |          | none         | Admin on sox.sf.net: cbagwell, mansr, robs, uklauer |
| 2024-05 | 2026-05  | 14.4.3 to 14.8.0 | Martin Guy |
| 2026-05 |    ?     | 15.0.0 to  ?     | Jan Stary |

## Committers to sox.sf.net

People with 10 or more commits:

| From | To | Committer | Commits |
| ---- | -- | :-------- | ------: |
| 1999-02-02 | 2011-03-02| cbagwell (Chris Bagwell) | 876 |
| 2002-03-25 | 2005-09-01| jching (jching)          | 15 |
| 2006-11-11 | 2012-09-18| rrt (Reuben Thomas)      | 543 |
| 2006-11-18 | 2014-10-29| robs (Rob Sykes)         | 1056 |
| 2007-01-18 | 2015-02-26| evilynux (Pascal Giard)  | 156 |
| 2011-03-19 | 2012-04-03| idigdoug (Doug Cook)     | 47 |
| 2011-03-06 | 2013-11-28| ulrich (Ulrich Klauer)   | 229 |
| 2012-05-23 | 2012-06-22| normalperson (Eric Wong) | 12 |
| 2017-11-05 | 2024-05-30| mansr (Mäns Rullärd)     | 163 |

See the file `AUTHORS` for a list of authors before the git history began.

## People

### Committers

* Lance Norskog
  * Probably [on StackOverflow](https://stackoverflow.com/users/676033/lance-norskog) "last seen more than 13 years ago"
  * Probably [on Blogger](https://www.blogger.com/profile/05485293639426402989), Last post 27 Oct 2018
  * [Last post on medium.com](https://medium.com/@lance.norskog_89909/its-important-to-make-a-point-up-front-docker-is-not-a-leaky-abstraction-46b7788dba6a), 13 May 2019
  * Probably [on Github](https://github.com/LanceNorskog) [Last commit 7 Jun 2024](https://github.com/LanceNorskog/minihal/commit/6efe3b45f8aaff8f2249a1751d8bc07dc363b3df)
* Chris Bagwell
  * Rob Sykes has not heard from him "in a long time"
  * His email was chris@cnpbagwell.com but domain cnpbagwell.com, registered on 2001-08-10, is parked by godaddy.com since 2022-09-05 or before ("last updated")
  * Last commit on sox.sf.net: 26 Feb 2015
* Reuben Thomas
  * Still with us as <rrt@sc3d.org>
* Rob Sykes
  * Still with us as <aquegg@yahoo.co.uk>
* Pascal Giard <evilynux@gmail.com>
  * Probably [https://giard.info](giard.info) pascal.giard@etsmtl.ca
* Doug Cook
  * Was idigdoug at users.sourceforge.net but you now need to
    [send a private message](https://sourceforge.net/u/idigdoug/profile/send_message)
* Ulrich Klauer
  * https://github.com/chirlu Last commit on github: 17 Nov 2023
* Eric Wong
  * Still with us as <normalperson@yhbt.net>
* Mäns Rullgärd
  * Still with us as <mans@mansr.com>

### Other authors

* Chris Ausbrooks <weed@bucket.pp.ualr.edu>

## `sox_ng`

Hard forked from `sox-14.4.2` on 2024-05-18, it fixed all known CVEs
and more bugs to make `sox_ng-14.4.3` then added new features in `14.5` on,
among which:

* being able to use the external program `ffmpeg` to decode dozens more
  audio (and video!) formats
* A zillion fixes to `spectrogram` including a logarithmic frequency axis
* Making `chorus` and `echos` work
* Optional interpolation between samples in `chorus` and `phaser`
* New effects `centercut`, `dolbyb`, `saturation`, `softvol` and `speexdsp`
* --keymap to tweak effects' parameters with keystrokes while playing
* Improved and more documentation
* --help-effect has grown `extra_usage`, documenting all parameters
* More error-specific and more helpful error messages

## Sources

1. [Wikipedia](https://en.wikipedia.org/wiki/SoX)
2. [sox.sf.net git logs](https://sourceforge.net/p/sox/code/ci/master/log)
