<!-- This file is generated by scripts/link-docs.mjs. Do not edit manually. -->
# Release Instructions

Normally, you should always create release candidates to avoid failures in the release process. For example, if you are releasing version `0.12.19`, you should create a release candidate `0.12.19-rc1` first. This is because once you tag a version, you cannot delete it, otherwise the people in downstream that already pull the tag will have to force update their repository. The release candidates are canaries to test any potential poison in the release process. Two things to note:

- At most 9 release candidates can be created for a version. This is because semver compares the version number as a string, and `rc9` is greater than `rc10` in sense of string comparison.
- You must publish the release soon after a good release candidate is created, otherwise CI may fail tomorrow.

The steps to release are list as following:

- Checking before releases.
- Making a release PR.
- Tagging and pushing current revision to release

## Checking before Releases

### Checking the `Cargo.toml` and the `Cargo.lock`

A `git` with `branch` dependency is forbidden in the `Cargo.toml` file. This will cause the `Cargo.lock` file to be unstable and the build to fail. Use the `git` with `tag` dependencies instead.

### Checking publish tokens

Please check the deadline of the publish tokens stored in the GitHub secrets. If the tokens are expired, please renew them before release.

- Renew the `VSCODE_MARKETPLACE_TOKEN` according to the [Azure DevOps – Use personal access tokens.](https://learn.microsoft.com/en-us/azure/devops/organizations/accounts/use-personal-access-tokens-to-authenticate?view=azure-devops&tabs=Windows)
- Renew the `OPENVSX_ACCESS_TOKEN` at the [Open VSX Registry – Access Tokens.](https://open-vsx.org/user-settings/tokens)

## Making a Release PR

You should perform following steps to make a release PR with name in format of `build: bump version to {version}`:

### Determining the Version Number

Before release, you should determine the version number to release.

Tinymist’s versions follow the [Semantic Versioning](https://semver.org/) scheme, in format of `MAJOR.MINOR.PATCH`. Besides, tinymist follows special rules for the version number:

- If a version is suffixed with `-rcN` (<picture><source media="(prefers-color-scheme: dark)" srcset="docs/assets/images/release-instruction/frame_0.svg" /><img src="docs/assets/images/release-instruction/frame_1.svg" alt="typst-frame" /></picture>), e.g. `0.11.0-rc1` and `0.12.1-rc1`, it means this version is a release candidate. It is used to test publish script and E2E functionalities. These versions will not be published to the marketplace.
- If the `PATCH` number is odd, e.g. `0.11.1` and `0.12.3`, it means this version is a nightly release. The nightly release will use both [tinymist](https://github.com/Myriad-Dreamin/tinymist/tree/main) and [typst](https://github.com/typst/typst/tree/main) at **main branch**. They will be published as prerelease version to the marketplace. Note that in nightly releases, we change `#sys.version` to the next minor release to help develop documents with nightly features. For example, in tinymist nightly v0.12.1 or v0.12.3, the `#sys.version` is changed to `version(0, 13, 0)`.
- Otherwise, if the `PATCH` number is even, e.g. `0.11.0` and `0.12.2`, it means this version is a regular release. The regular release will always use the recent stable version of tinymist and typst.

### Updating Version String in Codebase

Update Version String in Codebase other than that of `tinymist-assets`, which will be released in the `tinymist::assets::publish` CI. You can `grep` the version number in the repository to check if all the version numbers in the `Cargo.toml` and `package.json` files are updated. Some CI script will also assert failing to help you catch the issue.

### Updating the Changelog

All released version must be documented in the changelog. The changelog is located at `editors/vscode/CHANGELOG.md`. Please ensure the correct format otherwise CI will fail.

### Publishing the tinymist-assets crate

Run the `tinymist::assets::publish` CI to release the `tinymist-assets` crate. Ensure that the `tinymist-assets` crate is published to the registry. Please see `Cargo.lock` to check the released crate is used correctly.

After publish, you should update `tinymist-assets` version in the `Cargo.toml` file.

## Tagging and Pushing Current Revision to Release

Push a tag to the repository with the version number. For example, if you are releasing version `0.12.19`, you should run the following command:

```bash
$ git tag v0.12.19
$ git push --tag
```

This step will trigger the `ci.yml` CI to build and publish the VS Code extensions to the marketplace.
