# OGDF

OGDF stands both for **O**pen **G**raph **D**rawing **F**ramework (the original name)
and **O**pen **G**raph algorithms and **D**ata structures **F**ramework.

OGDF is a self-contained C++ library for graph algorithms,
in particular for (but not restricted to) automatic graph drawing.
It offers sophisticated algorithms and data structures to use
within your own applications or scientific projects.

OGDF is developed and supported by
[Osnabrück University](http://www.inf.uni-osnabrueck.de/theoinf),
[TU Dortmund](http://ls11-www.cs.uni-dortmund.de/),
[University of Cologne](http://www.informatik.uni-koeln.de/ls_juenger/),
[University of Konstanz](https://www.cls.uni-konstanz.de/),
and [TU Ilmenau](http://www.tu-ilmenau.de/dma/).

## Shortcuts

* [How to Install](doc/build.md)
* [Release Notes](doc/relnotes.md) and [Porting Guide](doc/porting.md)
* [Compiler Defines](doc/defines.md)
* [Official Website](http://ogdf.net/)
* [Reference Documentation](http://ogdf.github.io/doc/ogdf/)

## License

This software is distributed under the terms of the GNU
General Public License v2 or v3, with special exceptions.
By installing this software you agree to these license terms.

See [LICENSE.txt](LICENSE.txt) for more information on the license and
included third-party software, like frameworks for
linear programming or unit testing.

## Copyright

All files in the OGDF distribution (except for third-party
software) are copyrighted:

Copyright (C) 1999–2020

## Note for GitHub users

OGDF is actively developed using a non-public Git repository.

The [Git repository on GitHub](https://github.com/ogdf/ogdf) is not a
mirror but contains the [official releases](http://ogdf.net/releases/)
of OGDF.
We however attempt to take care of issues and pull requests.
