# diff

> Порівняти файли та каталоги.
> Більше інформації: <https://manned.org/diff>.

- Порівняти файли (показати список змін, щоб перетворити `старий_файл` на `новий_файл`):

`diff {{старий_файл}} {{новий_файл}}`

- Порівняти файли, ігноруючи пробіли:

`diff {{[-w|--ignore-all-space]}} {{старий_файл}} {{новий_файл}}`

- Порівняти файли, показуючи відмінності поруч:

`diff {{[-y|--side-by-side]}} {{старий_файл}} {{новий_файл}}`

- Порівняти файли, показуючи відмінності в уніфікованому форматі (як використовується у `git diff`):

`diff {{[-u|--unified]}} {{старий_файл}} {{новий_файл}}`

- Рекурсивно порівняти каталоги (показує назви відрізняючихся файлів/каталогів, а також зміни, внесені до файлів):

`diff {{[-r|--recursive]}} {{старий_каталог}} {{новий_каталог}}`

- Порівняти каталоги, показуючи лише назви файлів, які відрізняються:

`diff {{[-r|--recursive]}} {{[-q|--brief]}} {{старий_каталог}} {{новий_каталог}}`

- Створити файл виправлення для Git із відмінностей двох текстових файлів, розглядаючи неіснуючі файли як порожні:

`diff {{[-a|--text]}} {{[-u|--unified]}} {{[-N|--new-file]}} {{старий_файл}} {{новий_файл}} > {{diff.patch}}`

- Порівняти файли, відображаючи результат у кольорі, і спробувати знайти менший набір змін:

`diff {{[-d|--minimal]}} --color=always {{старий_файл}} {{новий_файл}}`
