# wgsl-analyzer

This extension provides support for the [WebGPU Shading Language (WGSL)](https://www.w3.org/TR/WGSL/).

It comes bundled with a language server of the same name: [wgsl-analyzer](https://github.com/wgsl-analyzer/wgsl-analyzer).

## Features

- code completion
<!-- - [code completion][magic completions] with [imports insertion][completion with autoimport] -->
- go to definition
<!-- - go to [definition][go to definition], [implementation][go to implementation], [type definition][go to type definition] -->
<!-- - [find all references][find all references], [workspace symbol search][workspace symbol], [symbol renaming][rename] -->
<!-- - [types and documentation on hover][hover] -->
- inlay hints for types
<!-- - [inlay hints][inlay hints] for types and parameter names -->
- syntax highlighting (also in host languages' strings and Markdown fenced code blocks!)
<!-- - [semantic syntax highlighting][semantic syntax highlighting] -->
<!-- - a lot of [assists (code actions)][assists] -->
<!-- - apply suggestions from errors -->
- ... and many more, check out the [manual](https://wgsl-analyzer.github.io/book/features.html) to see them all

## Quick start

Simply install the [wgsl-analyzer extension](https://marketplace.visualstudio.com/items?itemName=rust-lang.wgsl-analyzer).

## Configuration

This extension provides configurations through VS Code's configuration settings (`settings.json`). All configurations are under `wgsl-analyzer.*`.

See [the manual](https://wgsl-analyzer.github.io/book/editor_features.html#vs-code) for more information on VS Code-specific configurations.

## Communication

For usage questions and troubleshooting requests, please visit our [Discord server](https://discord.gg/3QUGyyz984).

## Documentation

See [wgsl-analyzer.github.io](https://wgsl-analyzer.github.io/) for more information.

<!-- [magic completions]: https://wgsl-analyzer.github.io/book/features.html#magic-completions -->
<!-- [completion with autoimport]: https://wgsl-analyzer.github.io/book/features.html#completion-with-autoimport -->
<!-- [go to definition]: https://wgsl-analyzer.github.io/book/features.html#go-to-definition
[go to implementation]: https://wgsl-analyzer.github.io/book/features.html#go-to-implementation
[go to type definition]: https://wgsl-analyzer.github.io/book/features.html#go-to-type-definition -->
<!-- [find all references]: https://wgsl-analyzer.github.io/book/features.html#find-all-references -->
<!-- [workspace symbol]: https://wgsl-analyzer.github.io/book/features.html#workspace-symbol -->
<!-- [rename]: https://wgsl-analyzer.github.io/book/features.html#rename -->
<!-- [hover]: https://wgsl-analyzer.github.io/book/features.html#hover -->
<!-- [semantic syntax highlighting]: https://wgsl-analyzer.github.io/book/features.html#semantic-syntax-highlighting -->
<!-- [assists]: https://wgsl-analyzer.github.io/book/assists.html -->
