This directory contains [CMake][1] files needed to build
native build files for wxWidgets.

For building wxWidgets or using wxWidgets in your CMake project please see
the [CMake overview](../../docs/doxygen/overviews/cmake.md) in the wxWidgets
documentation.

CMake files organization
========================
All CMake files are located in $(wx)/build/cmake additionally there is a
_CMakeLists.txt_ in the root directory.

Files
-----
* $(wx)/CMakeLists.txt
    * This should only contain commands and definitions which need to be
      contained in the top level and includes _main.cmake_
* config.cmake
    * Generates config files used to find wxWidgets by other build systems
    * Creates wx-config
* files.cmake
    * List of source files generated by _update_files.py_ from _$(wx)/build/files_
    * This file should **never** be edited manually
* functions.cmake
    * contains various wxWidgets specific functions and macros used throughout
      the CMake files
    * Every function should contain a short description of it's parameters as
      a comment before the function/macro
* install.cmake
    * Handles defintions for the ´install` and `uninstall` target
* init.cmake
    * Intializes various variables used during the build process and for
      generation of setup.h and configuration files
* main.cmake
    * Includes all other cmake files
* options.cmake
    * All user selectable build options should be defined in this file via
      calls to `wx_option()`
* policies.cmake
    * [CMake policies][2] for wxWidgets should be defined in this file
* setup.cmake
    * Handles all tests required to create the _setup.h_ header based
      platform and user settings
* setup.h.in
    * Template for _setup.h_ updated automatically by _$(wx)/build/update-setup-h_
* source_groups.cmake
    * Define source groups used in supported IDEs
* toolkit.cmake
    * Define toolkit specific options and detection to this file
* uninstall.cmake.in
    * Used by _install.cmake_ when creating the `uninstall` target
* update_files.py
    * Creates _files.cmake_ from _$(wx)/build/files_

Sub directories
---------------
Each sub directory contains a _CMakeLists.txt_ and might contain various other
_.cmake_ files.

* demos
    * Defines build targets for demos via `wx_add_demo()`
* lib
    * Defines build targets for all libraries and bundle third party libraries
    * Each library is contained in a seperate directory and uses
      `wx_add_library()` to define the library target
    * Bundled third party library without upstream CMake support are defined in
      a _.cmake_ file using `wx_add_builtin_library()` to define static library
      targets
* modules
    * Includes CMake modules used to find third party packages via [find_package()][3]
    * Includes the [cotire module][4] used to for precompiled header generation
* samples
    * Defines build targets for all samples via `wx_add_sample()`
    * Defintions for trivial samples are included in _CMakeLists.txt_ more
      complex samples might have a seperate .cmake file
* tests
    * Defines build targets for all tests
* utils
    * Defines build targets for all utilities


[1]: https://cmake.org
[2]: https://cmake.org/cmake/help/latest/manual/cmake-policies.7.html
[3]: https://cmake.org/cmake/help/latest/command/find_package.html
[4]: https://github.com/sakra/cotire/
