/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>
        #include <wx/stream.h>
        #include <wx/stream.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxRichTextFileHandler : public ::wxRichTextFileHandler
{
public:
    sipwxRichTextFileHandler(const ::wxString&, const ::wxString&, int);
    sipwxRichTextFileHandler(const ::wxRichTextFileHandler&);
    virtual ~sipwxRichTextFileHandler();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    bool sipProtect_DoLoadFile(::wxRichTextBuffer*, ::wxInputStream&);
    bool sipProtect_DoSaveFile(::wxRichTextBuffer*, ::wxOutputStream&);

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    bool DoSaveFile(::wxRichTextBuffer*, ::wxOutputStream&) SIP_OVERRIDE;
    bool DoLoadFile(::wxRichTextBuffer*, ::wxInputStream&) SIP_OVERRIDE;
    void SetVisible(bool) SIP_OVERRIDE;
    bool IsVisible() const SIP_OVERRIDE;
    bool CanLoad() const SIP_OVERRIDE;
    bool CanSave() const SIP_OVERRIDE;
    bool CanHandle(const ::wxString&) const SIP_OVERRIDE;
    bool SaveFile(::wxRichTextBuffer*, const ::wxString&) SIP_OVERRIDE;
    bool LoadFile(::wxRichTextBuffer*, const ::wxString&) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxRichTextFileHandler(const sipwxRichTextFileHandler &);
    sipwxRichTextFileHandler &operator = (const sipwxRichTextFileHandler &);

    char sipPyMethods[9];
};

sipwxRichTextFileHandler::sipwxRichTextFileHandler(const ::wxString& name, const ::wxString& ext, int type): ::wxRichTextFileHandler(name, ext, type), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextFileHandler::sipwxRichTextFileHandler(const ::wxRichTextFileHandler& a0): ::wxRichTextFileHandler(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxRichTextFileHandler::~sipwxRichTextFileHandler()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

bool sipwxRichTextFileHandler::DoSaveFile(::wxRichTextBuffer*buffer, ::wxOutputStream& stream)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, sipName_RichTextFileHandler, sipName_DoSaveFile);

    if (!sipMeth)
        return 0;

    extern bool sipVH__richtext_110(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxRichTextBuffer*, ::wxOutputStream&);

    return sipVH__richtext_110(sipGILState, 0, sipPySelf, sipMeth, buffer, stream);
}

bool sipwxRichTextFileHandler::DoLoadFile(::wxRichTextBuffer*buffer, ::wxInputStream& stream)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, sipName_RichTextFileHandler, sipName_DoLoadFile);

    if (!sipMeth)
        return 0;

    extern bool sipVH__richtext_109(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxRichTextBuffer*, ::wxInputStream&);

    return sipVH__richtext_109(sipGILState, 0, sipPySelf, sipMeth, buffer, stream);
}

void sipwxRichTextFileHandler::SetVisible(bool visible)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_SetVisible);

    if (!sipMeth)
    {
        ::wxRichTextFileHandler::SetVisible(visible);
        return;
    }

    extern void sipVH__richtext_33(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, bool);

    sipVH__richtext_33(sipGILState, 0, sipPySelf, sipMeth, visible);
}

bool sipwxRichTextFileHandler::IsVisible() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[3]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_IsVisible);

    if (!sipMeth)
        return ::wxRichTextFileHandler::IsVisible();

    extern bool sipVH__richtext_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_9(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextFileHandler::CanLoad() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[4]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_CanLoad);

    if (!sipMeth)
        return ::wxRichTextFileHandler::CanLoad();

    extern bool sipVH__richtext_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_9(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextFileHandler::CanSave() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[5]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_CanSave);

    if (!sipMeth)
        return ::wxRichTextFileHandler::CanSave();

    extern bool sipVH__richtext_9(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__richtext_9(sipGILState, 0, sipPySelf, sipMeth);
}

bool sipwxRichTextFileHandler::CanHandle(const ::wxString& filename) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[6]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_CanHandle);

    if (!sipMeth)
        return ::wxRichTextFileHandler::CanHandle(filename);

    extern bool sipVH__richtext_96(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxString&);

    return sipVH__richtext_96(sipGILState, 0, sipPySelf, sipMeth, filename);
}

bool sipwxRichTextFileHandler::SaveFile(::wxRichTextBuffer*buffer, const ::wxString& filename)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_SaveFile);

    if (!sipMeth)
        return ::wxRichTextFileHandler::SaveFile(buffer, filename);

    extern bool sipVH__richtext_108(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxRichTextBuffer*, const ::wxString&);

    return sipVH__richtext_108(sipGILState, 0, sipPySelf, sipMeth, buffer, filename);
}

bool sipwxRichTextFileHandler::LoadFile(::wxRichTextBuffer*buffer, const ::wxString& filename)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[8], &sipPySelf, SIP_NULLPTR, sipName_LoadFile);

    if (!sipMeth)
        return ::wxRichTextFileHandler::LoadFile(buffer, filename);

    extern bool sipVH__richtext_108(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, ::wxRichTextBuffer*, const ::wxString&);

    return sipVH__richtext_108(sipGILState, 0, sipPySelf, sipMeth, buffer, filename);
}

bool sipwxRichTextFileHandler::sipProtect_DoLoadFile(::wxRichTextBuffer*buffer, ::wxInputStream& stream)
{
    return DoLoadFile(buffer, stream);
}

bool sipwxRichTextFileHandler::sipProtect_DoSaveFile(::wxRichTextBuffer*buffer, ::wxOutputStream& stream)
{
    return DoSaveFile(buffer, stream);
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_LoadFile, "LoadFile(buffer, stream) -> bool\n"
"LoadFile(buffer, filename) -> bool\n"
"\n"
"Loads the buffer from a stream.\n"
"");

extern "C" {static PyObject *meth_wxRichTextFileHandler_LoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_LoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxRichTextBuffer* buffer;
        ::wxInputStream* stream;
        int streamState = 0;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxInputStream, &stream, &streamState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LoadFile(buffer, *stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream, sipType_wxInputStream, streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        ::wxRichTextBuffer* buffer;
        const ::wxString* filename;
        int filenameState = 0;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxString, &filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxRichTextFileHandler::LoadFile(buffer, *filename) : sipCpp->LoadFile(buffer, *filename));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(filename), sipType_wxString, filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_LoadFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SaveFile, "SaveFile(buffer, stream) -> bool\n"
"SaveFile(buffer, filename) -> bool\n"
"\n"
"Saves the buffer to a stream.\n"
"");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SaveFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SaveFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxRichTextBuffer* buffer;
        ::wxOutputStream* stream;
        int streamState = 0;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxOutputStream, &stream, &streamState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SaveFile(buffer, *stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream, sipType_wxOutputStream, streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        ::wxRichTextBuffer* buffer;
        const ::wxString* filename;
        int filenameState = 0;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxString, &filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxRichTextFileHandler::SaveFile(buffer, *filename) : sipCpp->SaveFile(buffer, *filename));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(filename), sipType_wxString, filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SaveFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_CanHandle, "CanHandle(filename) -> bool\n"
"\n"
"Returns true if we handle this filename (if using files).");

extern "C" {static PyObject *meth_wxRichTextFileHandler_CanHandle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_CanHandle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxString* filename;
        int filenameState = 0;
        const ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_filename,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxString, &filename, &filenameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxRichTextFileHandler::CanHandle(*filename) : sipCpp->CanHandle(*filename));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(filename), sipType_wxString, filenameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_CanHandle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_CanSave, "CanSave() -> bool\n"
"\n"
"Returns true if we can save using this handler.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_CanSave(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_CanSave(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxRichTextFileHandler::CanSave() : sipCpp->CanSave());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_CanSave, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_CanLoad, "CanLoad() -> bool\n"
"\n"
"Returns true if we can load using this handler.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_CanLoad(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_CanLoad(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxRichTextFileHandler::CanLoad() : sipCpp->CanLoad());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_CanLoad, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_IsVisible, "IsVisible() -> bool\n"
"\n"
"Returns true if this handler should be visible to the user.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_IsVisible(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_IsVisible(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxRichTextFileHandler::IsVisible() : sipCpp->IsVisible());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_IsVisible, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetVisible, "SetVisible(visible)\n"
"\n"
"Sets whether the handler should be visible to the user (via the\n"
"application's load and save dialogs).");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetVisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetVisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        bool visible;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_visible,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, &visible))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxRichTextFileHandler::SetVisible(visible) : sipCpp->SetVisible(visible));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetVisible, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetName, "SetName(name)\n"
"\n"
"Sets the name of the handler.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxString, &name, &nameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetName, "GetName() -> String\n"
"\n"
"Returns the name of the handler.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetExtension, "SetExtension(ext)\n"
"\n"
"Sets the default extension to recognise.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetExtension(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetExtension(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* ext;
        int extState = 0;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_ext,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxString, &ext, &extState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetExtension(*ext);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(ext), sipType_wxString, extState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetExtension, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetExtension, "GetExtension() -> String\n"
"\n"
"Returns the default extension to recognise.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetExtension(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetExtension(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetExtension());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetExtension, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetType, "SetType(type)\n"
"\n"
"Sets the handler type.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetType(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetType(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int type;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetType(type);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetType, "GetType() -> int\n"
"\n"
"Returns the handler type.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetType(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetType(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetType();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetType, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetFlags, "SetFlags(flags)\n"
"\n"
"Sets flags that change the behaviour of loading or saving.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetFlags(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetFlags(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetFlags(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetFlags, "GetFlags() -> int\n"
"\n"
"Returns flags controlling how loading and saving is done.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetFlags(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetFlags(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFlags();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetFlags, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_SetEncoding, "SetEncoding(encoding)\n"
"\n"
"Sets the encoding to use when saving a file.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_SetEncoding(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_SetEncoding(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* encoding;
        int encodingState = 0;
        ::wxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_encoding,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxString, &encoding, &encodingState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEncoding(*encoding);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(encoding), sipType_wxString, encodingState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_SetEncoding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_GetEncoding, "GetEncoding() -> String\n"
"\n"
"Returns the encoding to use when saving a file.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_GetEncoding(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_GetEncoding(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRichTextFileHandler *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetEncoding());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_GetEncoding, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_DoLoadFile, "DoLoadFile(buffer, stream) -> bool\n"
"\n"
"Override to load content from stream into buffer.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_DoLoadFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_DoLoadFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxRichTextBuffer* buffer;
        ::wxInputStream* stream;
        int streamState = 0;
        sipwxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxInputStream, &stream, &streamState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_RichTextFileHandler, sipName_DoLoadFile);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_DoLoadFile(buffer, *stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream, sipType_wxInputStream, streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_DoLoadFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextFileHandler_DoSaveFile, "DoSaveFile(buffer, stream) -> bool\n"
"\n"
"Override to save content to stream from buffer.");

extern "C" {static PyObject *meth_wxRichTextFileHandler_DoSaveFile(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextFileHandler_DoSaveFile(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxRichTextBuffer* buffer;
        ::wxOutputStream* stream;
        int streamState = 0;
        sipwxRichTextFileHandler *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_stream,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxRichTextFileHandler, &sipCpp, sipType_wxRichTextBuffer, &buffer, sipType_wxOutputStream, &stream, &streamState))
        {
            bool sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_RichTextFileHandler, sipName_DoSaveFile);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_DoSaveFile(buffer, *stream);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream, sipType_wxOutputStream, streamState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextFileHandler, sipName_DoSaveFile, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRichTextFileHandler(void *, const sipTypeDef *);}
static void *cast_wxRichTextFileHandler(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxRichTextFileHandler *sipCpp = reinterpret_cast<::wxRichTextFileHandler *>(sipCppV);

    if (targetType == sipType_wxRichTextFileHandler)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast<::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextFileHandler(void *, int);}
static void release_wxRichTextFileHandler(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxRichTextFileHandler *>(sipCppV);
    else
        delete reinterpret_cast<::wxRichTextFileHandler *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxRichTextFileHandler(sipSimpleWrapper *);}
static void dealloc_wxRichTextFileHandler(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxRichTextFileHandler *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextFileHandler(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxRichTextFileHandler(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextFileHandler(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxRichTextFileHandler *sipCpp = SIP_NULLPTR;

    {
        const ::wxString& namedef = wxEmptyString;
        const ::wxString* name = &namedef;
        int nameState = 0;
        const ::wxString& extdef = wxEmptyString;
        const ::wxString* ext = &extdef;
        int extState = 0;
        int type = 0;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_ext,
            sipName_type,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1J1i", sipType_wxString, &name, &nameState, sipType_wxString, &ext, &extState, &type))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextFileHandler(*name, *ext, type);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast<::wxString *>(ext), sipType_wxString, extState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxRichTextFileHandler* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxRichTextFileHandler, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxRichTextFileHandler(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRichTextFileHandler[] = {{42, 0, 1}};


static PyMethodDef methods_wxRichTextFileHandler[] = {
    {sipName_CanHandle, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_CanHandle), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_CanHandle},
    {sipName_CanLoad, meth_wxRichTextFileHandler_CanLoad, METH_VARARGS, doc_wxRichTextFileHandler_CanLoad},
    {sipName_CanSave, meth_wxRichTextFileHandler_CanSave, METH_VARARGS, doc_wxRichTextFileHandler_CanSave},
    {sipName_DoLoadFile, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_DoLoadFile), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_DoLoadFile},
    {sipName_DoSaveFile, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_DoSaveFile), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_DoSaveFile},
    {sipName_GetEncoding, meth_wxRichTextFileHandler_GetEncoding, METH_VARARGS, doc_wxRichTextFileHandler_GetEncoding},
    {sipName_GetExtension, meth_wxRichTextFileHandler_GetExtension, METH_VARARGS, doc_wxRichTextFileHandler_GetExtension},
    {sipName_GetFlags, meth_wxRichTextFileHandler_GetFlags, METH_VARARGS, doc_wxRichTextFileHandler_GetFlags},
    {sipName_GetName, meth_wxRichTextFileHandler_GetName, METH_VARARGS, doc_wxRichTextFileHandler_GetName},
    {sipName_GetType, meth_wxRichTextFileHandler_GetType, METH_VARARGS, doc_wxRichTextFileHandler_GetType},
    {sipName_IsVisible, meth_wxRichTextFileHandler_IsVisible, METH_VARARGS, doc_wxRichTextFileHandler_IsVisible},
    {sipName_LoadFile, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_LoadFile), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_LoadFile},
    {sipName_SaveFile, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_SaveFile), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_SaveFile},
    {sipName_SetEncoding, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_SetEncoding), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_SetEncoding},
    {sipName_SetExtension, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_SetExtension), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_SetExtension},
    {sipName_SetFlags, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_SetFlags), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_SetFlags},
    {sipName_SetName, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_SetName), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_SetName},
    {sipName_SetType, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_SetType), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_SetType},
    {sipName_SetVisible, SIP_MLMETH_CAST(meth_wxRichTextFileHandler_SetVisible), METH_VARARGS|METH_KEYWORDS, doc_wxRichTextFileHandler_SetVisible}
};

sipVariableDef variables_wxRichTextFileHandler[] = {
    {PropertyVariable, sipName_Type, &methods_wxRichTextFileHandler[9], &methods_wxRichTextFileHandler[17], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Name, &methods_wxRichTextFileHandler[8], &methods_wxRichTextFileHandler[16], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Flags, &methods_wxRichTextFileHandler[7], &methods_wxRichTextFileHandler[15], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Extension, &methods_wxRichTextFileHandler[6], &methods_wxRichTextFileHandler[14], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Encoding, &methods_wxRichTextFileHandler[5], &methods_wxRichTextFileHandler[13], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextFileHandler, "RichTextFileHandler(name=wx.EmptyString, ext=wx.EmptyString, type=0)\n"
"\n"
"The base class for file handlers.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextFileHandler = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRichTextFileHandler,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_RichTextFileHandler,
        {0, 0, 1},
        19, methods_wxRichTextFileHandler,
        0, SIP_NULLPTR,
        5, variables_wxRichTextFileHandler,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextFileHandler,
    -1,
    -1,
    supers_wxRichTextFileHandler,
    SIP_NULLPTR,
    init_type_wxRichTextFileHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRichTextFileHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxRichTextFileHandler,
    cast_wxRichTextFileHandler,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
