/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.10.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/vscroll.h>
        #include <wx/window.h>
        #include <wx/position.h>
        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>


class sipwxVarHVScrollHelper : public ::wxVarHVScrollHelper
{
public:
    sipwxVarHVScrollHelper(::wxWindow*);
    sipwxVarHVScrollHelper(const ::wxVarHVScrollHelper&);
    virtual ~sipwxVarHVScrollHelper();

    /*
     * There is a public method for every protected method visible from
     * this class.
     */
    ::wxCoord sipProtectVirt_EstimateTotalWidth(bool) const;
    void sipProtectVirt_OnGetColumnsWidthHint(bool, size_t, size_t) const;
    ::wxCoord sipProtect_OnGetColumnWidth(size_t) const;
    void sipProtectVirt_OnGetRowsHeightHint(bool, size_t, size_t) const;
    ::wxCoord sipProtectVirt_EstimateTotalHeight(bool) const;
    ::wxCoord sipProtect_OnGetRowHeight(size_t) const;

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    void RefreshRowsColumns(const ::wxPosition&, const ::wxPosition&) SIP_OVERRIDE;
    void RefreshRowsColumns(size_t, size_t, size_t, size_t) SIP_OVERRIDE;
    void RefreshRowColumn(const ::wxPosition&) SIP_OVERRIDE;
    void RefreshRowColumn(size_t, size_t) SIP_OVERRIDE;
    void RefreshColumn(size_t) SIP_OVERRIDE;
    void RefreshColumns(size_t, size_t) SIP_OVERRIDE;
    bool ScrollColumnPages(int) SIP_OVERRIDE;
    bool ScrollColumns(int) SIP_OVERRIDE;
    ::wxCoord EstimateTotalWidth() const SIP_OVERRIDE;
    void OnGetColumnsWidthHint(size_t, size_t) const SIP_OVERRIDE;
    ::wxCoord OnGetColumnWidth(size_t) const SIP_OVERRIDE;
    void RefreshRow(size_t) SIP_OVERRIDE;
    void RefreshRows(size_t, size_t) SIP_OVERRIDE;
    bool ScrollRowPages(int) SIP_OVERRIDE;
    bool ScrollRows(int) SIP_OVERRIDE;
    void OnGetRowsHeightHint(size_t, size_t) const SIP_OVERRIDE;
    ::wxCoord EstimateTotalHeight() const SIP_OVERRIDE;
    ::wxCoord OnGetRowHeight(size_t) const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxVarHVScrollHelper(const sipwxVarHVScrollHelper &);
    sipwxVarHVScrollHelper &operator = (const sipwxVarHVScrollHelper &);

    char sipPyMethods[18];
};

sipwxVarHVScrollHelper::sipwxVarHVScrollHelper(::wxWindow*winToScroll): ::wxVarHVScrollHelper(winToScroll), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxVarHVScrollHelper::sipwxVarHVScrollHelper(const ::wxVarHVScrollHelper& a0): ::wxVarHVScrollHelper(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxVarHVScrollHelper::~sipwxVarHVScrollHelper()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

void sipwxVarHVScrollHelper::RefreshRowsColumns(const ::wxPosition& from, const ::wxPosition& to)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[0], &sipPySelf, SIP_NULLPTR, sipName_RefreshRowsColumns);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::RefreshRowsColumns(from, to);
        return;
    }

    extern void sipVH__core_150(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxPosition&, const ::wxPosition&);

    sipVH__core_150(sipGILState, 0, sipPySelf, sipMeth, from, to);
}

void sipwxVarHVScrollHelper::RefreshRowsColumns(size_t fromRow, size_t toRow, size_t fromColumn, size_t toColumn)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[1], &sipPySelf, SIP_NULLPTR, sipName_RefreshRowsColumns);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::RefreshRowsColumns(fromRow, toRow, fromColumn, toColumn);
        return;
    }

    extern void sipVH__core_149(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t, size_t, size_t);

    sipVH__core_149(sipGILState, 0, sipPySelf, sipMeth, fromRow, toRow, fromColumn, toColumn);
}

void sipwxVarHVScrollHelper::RefreshRowColumn(const ::wxPosition& pos)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[2], &sipPySelf, SIP_NULLPTR, sipName_RefreshRowColumn);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::RefreshRowColumn(pos);
        return;
    }

    extern void sipVH__core_148(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const ::wxPosition&);

    sipVH__core_148(sipGILState, 0, sipPySelf, sipMeth, pos);
}

void sipwxVarHVScrollHelper::RefreshRowColumn(size_t row, size_t column)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[3], &sipPySelf, SIP_NULLPTR, sipName_RefreshRowColumn);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::RefreshRowColumn(row, column);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, row, column);
}

void sipwxVarHVScrollHelper::RefreshColumn(size_t column)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[4], &sipPySelf, SIP_NULLPTR, sipName_RefreshColumn);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::RefreshColumn(column);
        return;
    }

    extern void sipVH__core_146(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    sipVH__core_146(sipGILState, 0, sipPySelf, sipMeth, column);
}

void sipwxVarHVScrollHelper::RefreshColumns(size_t from_, size_t to_)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[5], &sipPySelf, SIP_NULLPTR, sipName_RefreshColumns);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::RefreshColumns(from_, to_);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, from_, to_);
}

bool sipwxVarHVScrollHelper::ScrollColumnPages(int pages)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[6], &sipPySelf, SIP_NULLPTR, sipName_ScrollColumnPages);

    if (!sipMeth)
        return ::wxVarHVScrollHelper::ScrollColumnPages(pages);

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, pages);
}

bool sipwxVarHVScrollHelper::ScrollColumns(int columns)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[7], &sipPySelf, SIP_NULLPTR, sipName_ScrollColumns);

    if (!sipMeth)
        return ::wxVarHVScrollHelper::ScrollColumns(columns);

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, columns);
}

::wxCoord sipwxVarHVScrollHelper::EstimateTotalWidth() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[8]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_EstimateTotalWidth);

    if (!sipMeth)
        return ::wxVarHVScrollHelper::EstimateTotalWidth();

    extern ::wxCoord sipVH__core_112(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_112(sipGILState, 0, sipPySelf, sipMeth);
}

void sipwxVarHVScrollHelper::OnGetColumnsWidthHint(size_t columnMin, size_t columnMax) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[9]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_OnGetColumnsWidthHint);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::OnGetColumnsWidthHint(columnMin, columnMax);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, columnMin, columnMax);
}

::wxCoord sipwxVarHVScrollHelper::OnGetColumnWidth(size_t column) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[10]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_VarHVScrollHelper, sipName_OnGetColumnWidth);

    if (!sipMeth)
        return 0;

    extern ::wxCoord sipVH__core_145(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    return sipVH__core_145(sipGILState, 0, sipPySelf, sipMeth, column);
}

void sipwxVarHVScrollHelper::RefreshRow(size_t row)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[11], &sipPySelf, SIP_NULLPTR, sipName_RefreshRow);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::RefreshRow(row);
        return;
    }

    extern void sipVH__core_146(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    sipVH__core_146(sipGILState, 0, sipPySelf, sipMeth, row);
}

void sipwxVarHVScrollHelper::RefreshRows(size_t from_, size_t to_)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[12], &sipPySelf, SIP_NULLPTR, sipName_RefreshRows);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::RefreshRows(from_, to_);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, from_, to_);
}

bool sipwxVarHVScrollHelper::ScrollRowPages(int pages)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[13], &sipPySelf, SIP_NULLPTR, sipName_ScrollRowPages);

    if (!sipMeth)
        return ::wxVarHVScrollHelper::ScrollRowPages(pages);

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, pages);
}

bool sipwxVarHVScrollHelper::ScrollRows(int rows)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, &sipPyMethods[14], &sipPySelf, SIP_NULLPTR, sipName_ScrollRows);

    if (!sipMeth)
        return ::wxVarHVScrollHelper::ScrollRows(rows);

    extern bool sipVH__core_147(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, int);

    return sipVH__core_147(sipGILState, 0, sipPySelf, sipMeth, rows);
}

void sipwxVarHVScrollHelper::OnGetRowsHeightHint(size_t rowMin, size_t rowMax) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[15]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_OnGetRowsHeightHint);

    if (!sipMeth)
    {
        ::wxVarHVScrollHelper::OnGetRowsHeightHint(rowMin, rowMax);
        return;
    }

    extern void sipVH__core_144(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t, size_t);

    sipVH__core_144(sipGILState, 0, sipPySelf, sipMeth, rowMin, rowMax);
}

::wxCoord sipwxVarHVScrollHelper::EstimateTotalHeight() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[16]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_EstimateTotalHeight);

    if (!sipMeth)
        return ::wxVarHVScrollHelper::EstimateTotalHeight();

    extern ::wxCoord sipVH__core_112(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_112(sipGILState, 0, sipPySelf, sipMeth);
}

::wxCoord sipwxVarHVScrollHelper::OnGetRowHeight(size_t row) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[17]), const_cast<sipSimpleWrapper **>(&sipPySelf), sipName_VarHVScrollHelper, sipName_OnGetRowHeight);

    if (!sipMeth)
        return 0;

    extern ::wxCoord sipVH__core_145(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, size_t);

    return sipVH__core_145(sipGILState, 0, sipPySelf, sipMeth, row);
}

::wxCoord sipwxVarHVScrollHelper::sipProtectVirt_EstimateTotalWidth(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarHScrollHelper::EstimateTotalWidth() : EstimateTotalWidth());
}

void sipwxVarHVScrollHelper::sipProtectVirt_OnGetColumnsWidthHint(bool sipSelfWasArg, size_t columnMin, size_t columnMax) const
{
    (sipSelfWasArg ? ::wxVarHScrollHelper::OnGetColumnsWidthHint(columnMin, columnMax) : OnGetColumnsWidthHint(columnMin, columnMax));
}

::wxCoord sipwxVarHVScrollHelper::sipProtect_OnGetColumnWidth(size_t column) const
{
    return OnGetColumnWidth(column);
}

void sipwxVarHVScrollHelper::sipProtectVirt_OnGetRowsHeightHint(bool sipSelfWasArg, size_t rowMin, size_t rowMax) const
{
    (sipSelfWasArg ? ::wxVarVScrollHelper::OnGetRowsHeightHint(rowMin, rowMax) : OnGetRowsHeightHint(rowMin, rowMax));
}

::wxCoord sipwxVarHVScrollHelper::sipProtectVirt_EstimateTotalHeight(bool sipSelfWasArg) const
{
    return (sipSelfWasArg ? ::wxVarVScrollHelper::EstimateTotalHeight() : EstimateTotalHeight());
}

::wxCoord sipwxVarHVScrollHelper::sipProtect_OnGetRowHeight(size_t row) const
{
    return OnGetRowHeight(row);
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_EstimateTotalWidth, "EstimateTotalWidth() -> int\n"
"\n"
"This class forwards calls from EstimateTotalSize() to this function so\n"
"derived classes can override either just the height or the width\n"
"estimation, or just estimate both differently if desired in any\n"
"wxHVScrolledWindow derived class.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_EstimateTotalWidth(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_EstimateTotalWidth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarHVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_EstimateTotalWidth(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_EstimateTotalWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_OnGetColumnsWidthHint, "OnGetColumnsWidthHint(columnMin, columnMax) -> None\n"
"\n"
"This function doesn't have to be overridden but it may be useful to do\n"
"so if calculating the columns' sizes is a relatively expensive\n"
"operation as it gives your code a chance to calculate several of them\n"
"at once and cache the result if necessary.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_OnGetColumnsWidthHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_OnGetColumnsWidthHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t columnMin;
        size_t columnMax;
        const sipwxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_columnMin,
            sipName_columnMax,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &columnMin, &columnMax))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_OnGetColumnsWidthHint(sipSelfWasArg, columnMin, columnMax);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_OnGetColumnsWidthHint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_OnGetColumnWidth, "OnGetColumnWidth(column) -> int\n"
"\n"
"This function must be overridden in the derived class, and should\n"
"return the width of the given column in pixels.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_OnGetColumnWidth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_OnGetColumnWidth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        size_t column;
        const sipwxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &column))
        {
            ::wxCoord sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarHVScrollHelper, sipName_OnGetColumnWidth);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_OnGetColumnWidth(column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_OnGetColumnWidth, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_OnGetRowsHeightHint, "OnGetRowsHeightHint(rowMin, rowMax) -> None\n"
"\n"
"This function doesn't have to be overridden but it may be useful to do\n"
"so if calculating the rows' sizes is a relatively expensive operation\n"
"as it gives your code a chance to calculate several of them at once\n"
"and cache the result if necessary.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_OnGetRowsHeightHint(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_OnGetRowsHeightHint(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t rowMin;
        size_t rowMax;
        const sipwxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rowMin,
            sipName_rowMax,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &rowMin, &rowMax))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->sipProtectVirt_OnGetRowsHeightHint(sipSelfWasArg, rowMin, rowMax);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_OnGetRowsHeightHint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_EstimateTotalHeight, "EstimateTotalHeight() -> int\n"
"\n"
"This class forwards calls from EstimateTotalSize() to this function so\n"
"derived classes can override either just the height or the width\n"
"estimation, or just estimate both differently if desired in any\n"
"wxHVScrolledWindow derived class.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_EstimateTotalHeight(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_EstimateTotalHeight(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const sipwxVarHVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp))
        {
            ::wxCoord sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtectVirt_EstimateTotalHeight(sipSelfWasArg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_EstimateTotalHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_OnGetRowHeight, "OnGetRowHeight(row) -> int\n"
"\n"
"This function must be overridden in the derived class, and should\n"
"return the height of the given row in pixels.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_OnGetRowHeight(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_OnGetRowHeight(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        size_t row;
        const sipwxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B=", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &row))
        {
            ::wxCoord sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_VarHVScrollHelper, sipName_OnGetRowHeight);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->sipProtect_OnGetRowHeight(row);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_OnGetRowHeight, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_IsVisible, "IsVisible(row, column) -> bool\n"
"IsVisible(pos) -> bool\n"
"\n"
"Returns true if both the given row and column are currently visible\n"
"(even if only partially visible) or false otherwise.\n"
"");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_IsVisible(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_IsVisible(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t row;
        size_t column;
        const ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &row, &column))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsVisible(row, column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxPosition* pos;
        int posState = 0;
        const ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, sipType_wxPosition, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsVisible(*pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPosition *>(pos), sipType_wxPosition, posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_IsVisible, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_RefreshRowColumn, "RefreshRowColumn(row, column) -> None\n"
"RefreshRowColumn(pos) -> None\n"
"\n"
"Triggers a refresh for just the area shared between the given row and\n"
"column of the window if it is visible.\n"
"");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_RefreshRowColumn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_RefreshRowColumn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t row;
        size_t column;
        ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &row, &column))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxVarHVScrollHelper::RefreshRowColumn(row, column) : sipCpp->RefreshRowColumn(row, column));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPosition* pos;
        int posState = 0;
        ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, sipType_wxPosition, &pos, &posState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxVarHVScrollHelper::RefreshRowColumn(*pos) : sipCpp->RefreshRowColumn(*pos));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPosition *>(pos), sipType_wxPosition, posState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_RefreshRowColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_RefreshRowsColumns, "RefreshRowsColumns(fromRow, toRow, fromColumn, toColumn) -> None\n"
"RefreshRowsColumns(_from, to) -> None\n"
"\n"
"Triggers a refresh for the visible area shared between all given rows\n"
"and columns (inclusive) of the window.\n"
"");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_RefreshRowsColumns(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_RefreshRowsColumns(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        size_t fromRow;
        size_t toRow;
        size_t fromColumn;
        size_t toColumn;
        ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_fromRow,
            sipName_toRow,
            sipName_fromColumn,
            sipName_toColumn,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B====", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &fromRow, &toRow, &fromColumn, &toColumn))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxVarHVScrollHelper::RefreshRowsColumns(fromRow, toRow, fromColumn, toColumn) : sipCpp->RefreshRowsColumns(fromRow, toRow, fromColumn, toColumn));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPosition* from;
        int fromState = 0;
        const ::wxPosition* to;
        int toState = 0;
        ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_from,
            sipName_to,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, sipType_wxPosition, &from, &fromState, sipType_wxPosition, &to, &toState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxVarHVScrollHelper::RefreshRowsColumns(*from, *to) : sipCpp->RefreshRowsColumns(*from, *to));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPosition *>(from), sipType_wxPosition, fromState);
            sipReleaseType(const_cast<::wxPosition *>(to), sipType_wxPosition, toState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_RefreshRowsColumns, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_ScrollToRowColumn, "ScrollToRowColumn(row, column) -> bool\n"
"ScrollToRowColumn(pos) -> bool\n"
"\n"
"Scroll to the specified row and column.\n"
"");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_ScrollToRowColumn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_ScrollToRowColumn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t row;
        size_t column;
        ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_row,
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &row, &column))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ScrollToRowColumn(row, column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxPosition* pos;
        int posState = 0;
        ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, sipType_wxPosition, &pos, &posState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ScrollToRowColumn(*pos);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPosition *>(pos), sipType_wxPosition, posState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_ScrollToRowColumn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_VirtualHitTest, "VirtualHitTest(x, y) -> Position\n"
"VirtualHitTest(pos) -> Position\n"
"\n"
"Returns the virtual scroll unit under the device unit given accounting\n"
"for scroll position or wxNOT_FOUND (for the row, column, or possibly\n"
"both values) if none.\n"
"");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_VirtualHitTest(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_VirtualHitTest(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        const ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &x, &y))
        {
            ::wxPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPosition(sipCpp->VirtualHitTest(x, y));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPosition, SIP_NULLPTR);
        }
    }

    {
        const ::wxPoint* pos;
        int posState = 0;
        const ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, sipType_wxPoint, &pos, &posState))
        {
            ::wxPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPosition(sipCpp->VirtualHitTest(*pos));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPoint *>(pos), sipType_wxPoint, posState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPosition, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_VirtualHitTest, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_EnablePhysicalScrolling, "EnablePhysicalScrolling(vscrolling=True, hscrolling=True) -> None\n"
"\n"
"With physical scrolling on (when this is true), the device origin is\n"
"changed properly when a wxPaintDC is prepared, children are actually\n"
"moved and laid out properly, and the contents of the window (pixels)\n"
"are actually moved.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_EnablePhysicalScrolling(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_EnablePhysicalScrolling(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool vscrolling = 1;
        bool hscrolling = 1;
        ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_vscrolling,
            sipName_hscrolling,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|bb", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &vscrolling, &hscrolling))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EnablePhysicalScrolling(vscrolling, hscrolling);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_EnablePhysicalScrolling, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_GetRowColumnCount, "GetRowColumnCount() -> Size\n"
"\n"
"Returns the number of columns and rows the target window contains.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_GetRowColumnCount(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_GetRowColumnCount(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVarHVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp))
        {
            ::wxSize*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxSize(sipCpp->GetRowColumnCount());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxSize, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_GetRowColumnCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_GetVisibleBegin, "GetVisibleBegin() -> Position\n"
"\n"
"Returns the index of the first visible column and row based on the\n"
"current scroll position.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_GetVisibleBegin(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_GetVisibleBegin(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVarHVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp))
        {
            ::wxPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPosition(sipCpp->GetVisibleBegin());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPosition, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_GetVisibleBegin, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_GetVisibleEnd, "GetVisibleEnd() -> Position\n"
"\n"
"Returns the index of the last visible column and row based on the\n"
"scroll position.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_GetVisibleEnd(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_GetVisibleEnd(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVarHVScrollHelper *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp))
        {
            ::wxPosition*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPosition(sipCpp->GetVisibleEnd());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPosition, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_GetVisibleEnd, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVarHVScrollHelper_SetRowColumnCount, "SetRowColumnCount(rowCount, columnCount) -> None\n"
"\n"
"Set the number of rows and columns the target window will contain.");

extern "C" {static PyObject *meth_wxVarHVScrollHelper_SetRowColumnCount(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_SetRowColumnCount(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        size_t rowCount;
        size_t columnCount;
        ::wxVarHVScrollHelper *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rowCount,
            sipName_columnCount,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B==", &sipSelf, sipType_wxVarHVScrollHelper, &sipCpp, &rowCount, &columnCount))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRowColumnCount(rowCount, columnCount);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_VarHVScrollHelper, sipName_SetRowColumnCount, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxVarHVScrollHelper_OnGetUnitsSizeHint(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_OnGetUnitsSizeHint(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_VarHVScrollHelper, sipName_OnGetUnitsSizeHint, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxVarHVScrollHelper_EstimateTotalSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_EstimateTotalSize(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_VarHVScrollHelper, sipName_EstimateTotalSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxVarHVScrollHelper_GetNonOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_GetNonOrientationTargetSize(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_VarHVScrollHelper, sipName_GetNonOrientationTargetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxVarHVScrollHelper_GetOrientation(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_GetOrientation(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_VarHVScrollHelper, sipName_GetOrientation, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxVarHVScrollHelper_GetOrientationTargetSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_GetOrientationTargetSize(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_VarHVScrollHelper, sipName_GetOrientationTargetSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *meth_wxVarHVScrollHelper_OnGetUnitSize(PyObject *, PyObject *);}
static PyObject *meth_wxVarHVScrollHelper_OnGetUnitSize(PyObject *, PyObject *)
{

    sipNoMethod(SIP_NULLPTR, sipName_VarHVScrollHelper, sipName_OnGetUnitSize, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxVarHVScrollHelper(void *, const sipTypeDef *);}
static void *cast_wxVarHVScrollHelper(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxVarHVScrollHelper *sipCpp = reinterpret_cast<::wxVarHVScrollHelper *>(sipCppV);

    if (targetType == sipType_wxVarHVScrollHelper)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxVarVScrollHelper)->ctd_cast(static_cast<::wxVarVScrollHelper *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxVarHScrollHelper)->ctd_cast(static_cast<::wxVarHScrollHelper *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxVarHVScrollHelper(void *, int);}
static void release_wxVarHVScrollHelper(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxVarHVScrollHelper *>(sipCppV);
    else
        delete reinterpret_cast<::wxVarHVScrollHelper *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxVarHVScrollHelper(sipSimpleWrapper *);}
static void dealloc_wxVarHVScrollHelper(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxVarHVScrollHelper *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxVarHVScrollHelper(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxVarHVScrollHelper(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxVarHVScrollHelper(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxVarHVScrollHelper *sipCpp = SIP_NULLPTR;

    {
        ::wxWindow* winToScroll;

        static const char *sipKwdList[] = {
            sipName_winToScroll,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8", sipType_wxWindow, &winToScroll))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxVarHVScrollHelper(winToScroll);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxVarHVScrollHelper* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxVarHVScrollHelper, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxVarHVScrollHelper(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxVarHVScrollHelper[] = {{623, 255, 0}, {620, 255, 1}};


static PyMethodDef methods_wxVarHVScrollHelper[] = {
    {sipName_EnablePhysicalScrolling, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_EnablePhysicalScrolling), METH_VARARGS|METH_KEYWORDS, doc_wxVarHVScrollHelper_EnablePhysicalScrolling},
    {sipName_EstimateTotalHeight, meth_wxVarHVScrollHelper_EstimateTotalHeight, METH_VARARGS, SIP_NULLPTR},
    {sipName_EstimateTotalSize, meth_wxVarHVScrollHelper_EstimateTotalSize, METH_VARARGS, SIP_NULLPTR},
    {sipName_EstimateTotalWidth, meth_wxVarHVScrollHelper_EstimateTotalWidth, METH_VARARGS, SIP_NULLPTR},
    {sipName_GetNonOrientationTargetSize, meth_wxVarHVScrollHelper_GetNonOrientationTargetSize, METH_VARARGS, SIP_NULLPTR},
    {sipName_GetOrientation, meth_wxVarHVScrollHelper_GetOrientation, METH_VARARGS, SIP_NULLPTR},
    {sipName_GetOrientationTargetSize, meth_wxVarHVScrollHelper_GetOrientationTargetSize, METH_VARARGS, SIP_NULLPTR},
    {sipName_GetRowColumnCount, meth_wxVarHVScrollHelper_GetRowColumnCount, METH_VARARGS, doc_wxVarHVScrollHelper_GetRowColumnCount},
    {sipName_GetVisibleBegin, meth_wxVarHVScrollHelper_GetVisibleBegin, METH_VARARGS, doc_wxVarHVScrollHelper_GetVisibleBegin},
    {sipName_GetVisibleEnd, meth_wxVarHVScrollHelper_GetVisibleEnd, METH_VARARGS, doc_wxVarHVScrollHelper_GetVisibleEnd},
    {sipName_IsVisible, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_IsVisible), METH_VARARGS|METH_KEYWORDS, doc_wxVarHVScrollHelper_IsVisible},
    {sipName_OnGetColumnWidth, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_OnGetColumnWidth), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_OnGetColumnsWidthHint, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_OnGetColumnsWidthHint), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_OnGetRowHeight, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_OnGetRowHeight), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_OnGetRowsHeightHint, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_OnGetRowsHeightHint), METH_VARARGS|METH_KEYWORDS, SIP_NULLPTR},
    {sipName_OnGetUnitSize, meth_wxVarHVScrollHelper_OnGetUnitSize, METH_VARARGS, SIP_NULLPTR},
    {sipName_OnGetUnitsSizeHint, meth_wxVarHVScrollHelper_OnGetUnitsSizeHint, METH_VARARGS, SIP_NULLPTR},
    {sipName_RefreshRowColumn, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_RefreshRowColumn), METH_VARARGS|METH_KEYWORDS, doc_wxVarHVScrollHelper_RefreshRowColumn},
    {sipName_RefreshRowsColumns, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_RefreshRowsColumns), METH_VARARGS|METH_KEYWORDS, doc_wxVarHVScrollHelper_RefreshRowsColumns},
    {sipName_ScrollToRowColumn, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_ScrollToRowColumn), METH_VARARGS|METH_KEYWORDS, doc_wxVarHVScrollHelper_ScrollToRowColumn},
    {sipName_SetRowColumnCount, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_SetRowColumnCount), METH_VARARGS|METH_KEYWORDS, doc_wxVarHVScrollHelper_SetRowColumnCount},
    {sipName_VirtualHitTest, SIP_MLMETH_CAST(meth_wxVarHVScrollHelper_VirtualHitTest), METH_VARARGS|METH_KEYWORDS, doc_wxVarHVScrollHelper_VirtualHitTest}
};

sipVariableDef variables_wxVarHVScrollHelper[] = {
    {PropertyVariable, sipName_VisibleEnd, &methods_wxVarHVScrollHelper[9], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_VisibleBegin, &methods_wxVarHVScrollHelper[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_RowColumnCount, &methods_wxVarHVScrollHelper[7], &methods_wxVarHVScrollHelper[20], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxVarHVScrollHelper, "VarHVScrollHelper(winToScroll) -> None\n"
"\n"
"This class provides functions wrapping the wxVarHScrollHelper and\n"
"wxVarVScrollHelper classes, targeted for scrolling a window in both\n"
"axis.");


sipClassTypeDef sipTypeDef__core_wxVarHVScrollHelper = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxVarHVScrollHelper,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_VarHVScrollHelper,
        {0, 0, 1},
        22, methods_wxVarHVScrollHelper,
        0, SIP_NULLPTR,
        3, variables_wxVarHVScrollHelper,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxVarHVScrollHelper,
    -1,
    -1,
    supers_wxVarHVScrollHelper,
    SIP_NULLPTR,
    init_type_wxVarHVScrollHelper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxVarHVScrollHelper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxVarHVScrollHelper,
    cast_wxVarHVScrollHelper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxVarHVScrollHelper),
};
