﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/ConfigServiceRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/config/model/ResourceCountFilters.h>
#include <aws/config/model/ResourceCountGroupKey.h>
#include <utility>

namespace Aws
{
namespace ConfigService
{
namespace Model
{

  /**
   */
  class GetAggregateDiscoveredResourceCountsRequest : public ConfigServiceRequest
  {
  public:
    AWS_CONFIGSERVICE_API GetAggregateDiscoveredResourceCountsRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "GetAggregateDiscoveredResourceCounts"; }

    AWS_CONFIGSERVICE_API Aws::String SerializePayload() const override;

    AWS_CONFIGSERVICE_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    ///@{
    /**
     * <p>The name of the configuration aggregator.</p>
     */
    inline const Aws::String& GetConfigurationAggregatorName() const{ return m_configurationAggregatorName; }
    inline bool ConfigurationAggregatorNameHasBeenSet() const { return m_configurationAggregatorNameHasBeenSet; }
    inline void SetConfigurationAggregatorName(const Aws::String& value) { m_configurationAggregatorNameHasBeenSet = true; m_configurationAggregatorName = value; }
    inline void SetConfigurationAggregatorName(Aws::String&& value) { m_configurationAggregatorNameHasBeenSet = true; m_configurationAggregatorName = std::move(value); }
    inline void SetConfigurationAggregatorName(const char* value) { m_configurationAggregatorNameHasBeenSet = true; m_configurationAggregatorName.assign(value); }
    inline GetAggregateDiscoveredResourceCountsRequest& WithConfigurationAggregatorName(const Aws::String& value) { SetConfigurationAggregatorName(value); return *this;}
    inline GetAggregateDiscoveredResourceCountsRequest& WithConfigurationAggregatorName(Aws::String&& value) { SetConfigurationAggregatorName(std::move(value)); return *this;}
    inline GetAggregateDiscoveredResourceCountsRequest& WithConfigurationAggregatorName(const char* value) { SetConfigurationAggregatorName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Filters the results based on the <code>ResourceCountFilters</code>
     * object.</p>
     */
    inline const ResourceCountFilters& GetFilters() const{ return m_filters; }
    inline bool FiltersHasBeenSet() const { return m_filtersHasBeenSet; }
    inline void SetFilters(const ResourceCountFilters& value) { m_filtersHasBeenSet = true; m_filters = value; }
    inline void SetFilters(ResourceCountFilters&& value) { m_filtersHasBeenSet = true; m_filters = std::move(value); }
    inline GetAggregateDiscoveredResourceCountsRequest& WithFilters(const ResourceCountFilters& value) { SetFilters(value); return *this;}
    inline GetAggregateDiscoveredResourceCountsRequest& WithFilters(ResourceCountFilters&& value) { SetFilters(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The key to group the resource counts.</p>
     */
    inline const ResourceCountGroupKey& GetGroupByKey() const{ return m_groupByKey; }
    inline bool GroupByKeyHasBeenSet() const { return m_groupByKeyHasBeenSet; }
    inline void SetGroupByKey(const ResourceCountGroupKey& value) { m_groupByKeyHasBeenSet = true; m_groupByKey = value; }
    inline void SetGroupByKey(ResourceCountGroupKey&& value) { m_groupByKeyHasBeenSet = true; m_groupByKey = std::move(value); }
    inline GetAggregateDiscoveredResourceCountsRequest& WithGroupByKey(const ResourceCountGroupKey& value) { SetGroupByKey(value); return *this;}
    inline GetAggregateDiscoveredResourceCountsRequest& WithGroupByKey(ResourceCountGroupKey&& value) { SetGroupByKey(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The maximum number of <a>GroupedResourceCount</a> objects returned on each
     * page. The default is 1000. You cannot specify a number greater than 1000. If you
     * specify 0, Config uses the default.</p>
     */
    inline int GetLimit() const{ return m_limit; }
    inline bool LimitHasBeenSet() const { return m_limitHasBeenSet; }
    inline void SetLimit(int value) { m_limitHasBeenSet = true; m_limit = value; }
    inline GetAggregateDiscoveredResourceCountsRequest& WithLimit(int value) { SetLimit(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The <code>nextToken</code> string returned on a previous page that you use to
     * get the next page of results in a paginated response. </p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }
    inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
    inline void SetNextToken(const Aws::String& value) { m_nextTokenHasBeenSet = true; m_nextToken = value; }
    inline void SetNextToken(Aws::String&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::move(value); }
    inline void SetNextToken(const char* value) { m_nextTokenHasBeenSet = true; m_nextToken.assign(value); }
    inline GetAggregateDiscoveredResourceCountsRequest& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}
    inline GetAggregateDiscoveredResourceCountsRequest& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}
    inline GetAggregateDiscoveredResourceCountsRequest& WithNextToken(const char* value) { SetNextToken(value); return *this;}
    ///@}
  private:

    Aws::String m_configurationAggregatorName;
    bool m_configurationAggregatorNameHasBeenSet = false;

    ResourceCountFilters m_filters;
    bool m_filtersHasBeenSet = false;

    ResourceCountGroupKey m_groupByKey;
    bool m_groupByKeyHasBeenSet = false;

    int m_limit;
    bool m_limitHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;
  };

} // namespace Model
} // namespace ConfigService
} // namespace Aws
