
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was DBCSRConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

include(CMakeFindDependencyMacro)

# the following should only be needed when building statically

if (OFF)
  find_dependency(MPI)
endif ()

if (ON)
  find_dependency(OpenMP)
endif ()

if ("" MATCHES "cuda")
  enable_language(CUDA)
  find_dependency(CUDAToolkit)
endif ()

if ("" MATCHES "hip")
  enable_language(HIP)
  find_dependency(hip)
  find_dependency(hipblas)
  find_dependency(hiprtc)
endif ()


if (("libxsmm" MATCHES "libxsmm") OR ("" MATCHES "opencl"))
  find_package(PkgConfig)
  pkg_check_modules(LIBXSMM IMPORTED_TARGET GLOBAL libxsmmf)
  if (ON)
    pkg_check_modules(LIBXSMMEXT IMPORTED_TARGET GLOBAL libxsmmext)
  endif ()
endif ()

include("${CMAKE_CURRENT_LIST_DIR}/DBCSRTargets.cmake")
