/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { z } from 'zod';
/**
 * A file that is open in the IDE.
 */
export declare const FileSchema: z.ZodObject<{
    /**
     * The absolute path to the file.
     */
    path: z.ZodString;
    /**
     * The unix timestamp of when the file was last focused.
     */
    timestamp: z.ZodNumber;
    /**
     * Whether the file is the currently active file. Only one file can be active at a time.
     */
    isActive: z.ZodOptional<z.ZodBoolean>;
    /**
     * The text that is currently selected in the active file.
     */
    selectedText: z.ZodOptional<z.ZodString>;
    /**
     * The cursor position in the active file.
     */
    cursor: z.ZodOptional<z.ZodObject<{
        /**
         * The 1-based line number.
         */
        line: z.ZodNumber;
        /**
         * The 1-based character offset.
         */
        character: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        line: number;
        character: number;
    }, {
        line: number;
        character: number;
    }>>;
}, "strip", z.ZodTypeAny, {
    path: string;
    timestamp: number;
    cursor?: {
        line: number;
        character: number;
    } | undefined;
    isActive?: boolean | undefined;
    selectedText?: string | undefined;
}, {
    path: string;
    timestamp: number;
    cursor?: {
        line: number;
        character: number;
    } | undefined;
    isActive?: boolean | undefined;
    selectedText?: string | undefined;
}>;
export type File = z.infer<typeof FileSchema>;
/**
 * The context of the IDE.
 */
export declare const IdeContextSchema: z.ZodObject<{
    workspaceState: z.ZodOptional<z.ZodObject<{
        /**
         * The list of files that are currently open.
         */
        openFiles: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The absolute path to the file.
             */
            path: z.ZodString;
            /**
             * The unix timestamp of when the file was last focused.
             */
            timestamp: z.ZodNumber;
            /**
             * Whether the file is the currently active file. Only one file can be active at a time.
             */
            isActive: z.ZodOptional<z.ZodBoolean>;
            /**
             * The text that is currently selected in the active file.
             */
            selectedText: z.ZodOptional<z.ZodString>;
            /**
             * The cursor position in the active file.
             */
            cursor: z.ZodOptional<z.ZodObject<{
                /**
                 * The 1-based line number.
                 */
                line: z.ZodNumber;
                /**
                 * The 1-based character offset.
                 */
                character: z.ZodNumber;
            }, "strip", z.ZodTypeAny, {
                line: number;
                character: number;
            }, {
                line: number;
                character: number;
            }>>;
        }, "strip", z.ZodTypeAny, {
            path: string;
            timestamp: number;
            cursor?: {
                line: number;
                character: number;
            } | undefined;
            isActive?: boolean | undefined;
            selectedText?: string | undefined;
        }, {
            path: string;
            timestamp: number;
            cursor?: {
                line: number;
                character: number;
            } | undefined;
            isActive?: boolean | undefined;
            selectedText?: string | undefined;
        }>, "many">>;
        /**
         * Whether the workspace is trusted.
         */
        isTrusted: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        openFiles?: {
            path: string;
            timestamp: number;
            cursor?: {
                line: number;
                character: number;
            } | undefined;
            isActive?: boolean | undefined;
            selectedText?: string | undefined;
        }[] | undefined;
        isTrusted?: boolean | undefined;
    }, {
        openFiles?: {
            path: string;
            timestamp: number;
            cursor?: {
                line: number;
                character: number;
            } | undefined;
            isActive?: boolean | undefined;
            selectedText?: string | undefined;
        }[] | undefined;
        isTrusted?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    workspaceState?: {
        openFiles?: {
            path: string;
            timestamp: number;
            cursor?: {
                line: number;
                character: number;
            } | undefined;
            isActive?: boolean | undefined;
            selectedText?: string | undefined;
        }[] | undefined;
        isTrusted?: boolean | undefined;
    } | undefined;
}, {
    workspaceState?: {
        openFiles?: {
            path: string;
            timestamp: number;
            cursor?: {
                line: number;
                character: number;
            } | undefined;
            isActive?: boolean | undefined;
            selectedText?: string | undefined;
        }[] | undefined;
        isTrusted?: boolean | undefined;
    } | undefined;
}>;
export type IdeContext = z.infer<typeof IdeContextSchema>;
export declare const IdeContextNotificationSchema: z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    method: z.ZodLiteral<"ide/contextUpdate">;
    params: z.ZodObject<{
        workspaceState: z.ZodOptional<z.ZodObject<{
            /**
             * The list of files that are currently open.
             */
            openFiles: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * The absolute path to the file.
                 */
                path: z.ZodString;
                /**
                 * The unix timestamp of when the file was last focused.
                 */
                timestamp: z.ZodNumber;
                /**
                 * Whether the file is the currently active file. Only one file can be active at a time.
                 */
                isActive: z.ZodOptional<z.ZodBoolean>;
                /**
                 * The text that is currently selected in the active file.
                 */
                selectedText: z.ZodOptional<z.ZodString>;
                /**
                 * The cursor position in the active file.
                 */
                cursor: z.ZodOptional<z.ZodObject<{
                    /**
                     * The 1-based line number.
                     */
                    line: z.ZodNumber;
                    /**
                     * The 1-based character offset.
                     */
                    character: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    line: number;
                    character: number;
                }, {
                    line: number;
                    character: number;
                }>>;
            }, "strip", z.ZodTypeAny, {
                path: string;
                timestamp: number;
                cursor?: {
                    line: number;
                    character: number;
                } | undefined;
                isActive?: boolean | undefined;
                selectedText?: string | undefined;
            }, {
                path: string;
                timestamp: number;
                cursor?: {
                    line: number;
                    character: number;
                } | undefined;
                isActive?: boolean | undefined;
                selectedText?: string | undefined;
            }>, "many">>;
            /**
             * Whether the workspace is trusted.
             */
            isTrusted: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            openFiles?: {
                path: string;
                timestamp: number;
                cursor?: {
                    line: number;
                    character: number;
                } | undefined;
                isActive?: boolean | undefined;
                selectedText?: string | undefined;
            }[] | undefined;
            isTrusted?: boolean | undefined;
        }, {
            openFiles?: {
                path: string;
                timestamp: number;
                cursor?: {
                    line: number;
                    character: number;
                } | undefined;
                isActive?: boolean | undefined;
                selectedText?: string | undefined;
            }[] | undefined;
            isTrusted?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        workspaceState?: {
            openFiles?: {
                path: string;
                timestamp: number;
                cursor?: {
                    line: number;
                    character: number;
                } | undefined;
                isActive?: boolean | undefined;
                selectedText?: string | undefined;
            }[] | undefined;
            isTrusted?: boolean | undefined;
        } | undefined;
    }, {
        workspaceState?: {
            openFiles?: {
                path: string;
                timestamp: number;
                cursor?: {
                    line: number;
                    character: number;
                } | undefined;
                isActive?: boolean | undefined;
                selectedText?: string | undefined;
            }[] | undefined;
            isTrusted?: boolean | undefined;
        } | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    params: {
        workspaceState?: {
            openFiles?: {
                path: string;
                timestamp: number;
                cursor?: {
                    line: number;
                    character: number;
                } | undefined;
                isActive?: boolean | undefined;
                selectedText?: string | undefined;
            }[] | undefined;
            isTrusted?: boolean | undefined;
        } | undefined;
    };
    jsonrpc: "2.0";
    method: "ide/contextUpdate";
}, {
    params: {
        workspaceState?: {
            openFiles?: {
                path: string;
                timestamp: number;
                cursor?: {
                    line: number;
                    character: number;
                } | undefined;
                isActive?: boolean | undefined;
                selectedText?: string | undefined;
            }[] | undefined;
            isTrusted?: boolean | undefined;
        } | undefined;
    };
    jsonrpc: "2.0";
    method: "ide/contextUpdate";
}>;
