# The values below are for a copy of MOAB used directly
# from its build directory. These values will be overridden below
# for installed copies of MOAB.

# Feature list
MOAB_MPI_ENABLED = OFF
MOAB_FORTRAN_ENABLED = ON
MOAB_HDF5_ENABLED = OFF
MOAB_NETCDF_ENABLED = OFF
MOAB_PNETCDF_ENABLED = OFF
MOAB_IGEOM_ENABLED = OFF
MOAB_IMESH_ENABLED = OFF
MOAB_IREL_ENABLED = OFF
MOAB_FBIGEOM_ENABLED = OFF
MOAB_MESQUITE_ENABLED = 

# Library and Include paths
MOAB_LIBDIR = D:/M/B/src/build-UCRT64/src/.libs
MOAB_INCLUDES = -ID:/M/B/src/moab-5.5.1/src \
                -ID:/M/B/src/build-UCRT64/src \
                -ID:/M/B/src/moab-5.5.1/src/oldinc \
                -ID:/M/B/src/moab-5.5.1/src/verdict \
                -ID:/M/B/src/moab-5.5.1/src/parallel \
                -ID:/M/B/src/build-UCRT64/src/parallel \
                -ID:/M/B/src/moab-5.5.1/src/LocalDiscretization \
                -ID:/M/B/src/moab-5.5.1/src/RefineMesh

ifeq ($(MOAB_IGEOM_ENABLED),yes)
include 
MOAB_INCLUDES += $(IGEOM_INCLUDES)
endif

ifeq ($(MOAB_MESQUITE_ENABLED),yes)
MSQ_LIBDIR = D:/M/B/src/build-UCRT64/src/mesquite/.libs
MSQ_LIBS = -LD:/M/B/src/build-UCRT64/src/mesquite/.libs -lmbmesquite
MSQ_INCLUDES = -ID:/M/B/src/moab-5.5.1/src/mesquite/include \
	-ID:/M/B/src/build-UCRT64/src/mesquite/include \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/Mesh \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/Control \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/Wrappers \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/MappingFunction \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/MappingFunction/Lagrange \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/MappingFunction/Linear \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/Misc \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/ObjectiveFunction \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityAssessor \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityImprover \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityImprover/OptSolvers \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityImprover/Relaxation \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Debug \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Shape \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Smoothness \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/TMP \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Untangle \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/QualityMetric/Volume \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/TargetCalculator \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/Misc \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/Shape \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/ShapeOrient \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/ShapeSize \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/ShapeSizeOrient \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/Size \
	-ID:/M/B/src/moab-5.5.1/src/mesquite/TargetMetric/Untangle

MOAB_INCLUDES += ${MSQ_INCLUDES}
endif

MOAB_INCLUDES += 

MOAB_CPPFLAGS = -march=nocona -msahf -mtune=generic -O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 -pedantic -fpic -Wall -Wno-long-long -Wextra -Wno-cast-align -Wsign-compare -Wpointer-arith -Wformat -Wformat-security -Wunused-parameter -fstack-protector-all -fpermissive -Wno-ignored-attributes -Wno-variadic-macros -Wno-deprecated-declarations -Wno-unused-local-typedefs -ID:/a/msys64/ucrt64/include/eigen3 
MOAB_CXXFLAGS = -O3 -DNDEBUG 
MOAB_CFLAGS = -O3 -DNDEBUG 
MOAB_FFLAGS = -funroll-all-loops -fno-f2c
MOAB_FCFLAGS = 
MOAB_LDFLAGS =   

# missing support for DAMSEL, CCMIO
# PROBABLY FORMATTED INCORRECTLY
MOAB_EXT_LIBS =     \
                    \
                  D:/a/msys64/ucrt64/lib/libopenblas.dll.a D:/a/msys64/ucrt64/lib/libopenblas.dll.a  
MOAB_LIBS_LINK = ${MOAB_LDFLAGS} -L${MOAB_LIBDIR} -lMOAB ${MSQ_LIBS} $(MOAB_EXT_LIBS) 
DAGMC_LIBS_LINK = ${MOAB_LDFLAGS} -L${MOAB_LIBDIR}  -lMOAB ${MSQ_LIBS} $(MOAB_EXT_LIBS)

MOAB_CXX = D:/a/msys64/ucrt64/bin/g++.exe
MOAB_CC  = D:/a/msys64/ucrt64/bin/gcc.exe
MOAB_FC  = D:/a/msys64/ucrt64/bin/gfortran.exe
MOAB_F77  = D:/a/msys64/ucrt64/bin/gfortran.exe

# Override MOAB_LIBDIR and MOAB_INCLUDES from above with the correct
# values for the installed MOAB.

# NEED TO ADD SOMETHING TO MODIFY THIS FILE AT INSTALL TIME (OR FIX ISSUE #30)
