#version 120

precision mediump int;
precision mediump float;

varying vec2 uv;
uniform sampler2D inLUM;

void main()
{
  vec3 avgLum = texture2D(inLUM, vec2(0.5, 0.5)).rgb;

  //Perceptual Effects in Real-time Tone Mapping: Equ(11)
  gl_FragColor = vec4(clamp(vec3(1.0) - vec3(1.0)/(avgLum * vec3(0.1) + vec3(1.0)), vec3(0.0), vec3(1.0)) + vec3(0.1), 1.0);
}
