%feature("docstring") OT::MeixnerDistribution
"Meixner distribution.


Parameters
----------
beta : float, :math:`\\beta > 0`
    Scale parameter.
    
    Default value is 1.0.
alpha : float, :math:`\\alpha \\in [-\\pi; \\pi]`
    Skewness parameter.
    
    Default value is 0.0.
delta : float, :math:`\\delta > 0`
    Shape parameter.
    
    Default value is 1.0.
gamma : float
    Position parameter :math:`\\gamma`.
    
    Default value is 0.0.

Notes
-----
Its probability density function is defined as:

.. math::

    f_X(x) = \\frac{\\left(2 \\cos(\\alpha / 2)\\right)^{2 \\delta}}
                  {2 \\beta \\pi \\Gamma(2 \\delta)}
             \\exp\\left(\\frac{\\alpha (x - \\gamma)}{\\beta}\\right)
             \\left|\\Gamma\\left(\\delta + i \\frac{x - \\gamma}{\\beta}
                               \\right)\\right|^2,
             \\quad x \\in \\Rset

with :math:`\\beta, \\delta > 0`, :math:`\\alpha \\in [-\\pi; \\pi]`,
:math:`\\gamma \\in \\Rset` and where :math:`i^2 = -1`.

Its first moments are:

.. math::
    :nowrap:

    \\begin{eqnarray*}
        \\Expect{X} & = & \\beta \\delta \\tan(\\alpha / 2) + \\gamma \\\\
        \\Var{X} & = & \\frac{\\beta^2 \\delta}{1 + \\cos(\\alpha)}
    \\end{eqnarray*}

Examples
--------
Create a distribution:

>>> import openturns as ot
>>> distribution = ot.MeixnerDistribution(1.0, 0.0, 1.0, 0.0)

Draw a sample:

>>> sample = distribution.getSample(5)"

// ---------------------------------------------------------------------

%feature("docstring") OT::MeixnerDistribution::getBeta
"Accessor to the distribution's scale parameter :math:`\\beta`.

Returns
-------
beta : float
    Scale parameter :math:`\\beta`."

// ---------------------------------------------------------------------

%feature("docstring") OT::MeixnerDistribution::getAlpha
"Accessor to the distribution's skewness parameter :math:`\\alpha`.

Returns
-------
alpha : float
    Skewness parameter :math:`\\alpha`."

// ---------------------------------------------------------------------

%feature("docstring") OT::MeixnerDistribution::getDelta
"Accessor to the distribution's shape parameter :math:`\\delta`.

Returns
-------
delta : float
    Shape parameter :math:`\\delta`."

// ---------------------------------------------------------------------

%feature("docstring") OT::MeixnerDistribution::getGamma
"Accessor to the distribution's position parameter :math:`\\gamma`.

Returns
-------
gamma : float
    Position parameter :math:`\\gamma`."

// ---------------------------------------------------------------------

%feature("docstring") OT::MeixnerDistribution::setBeta
"Accessor to the distribution's scale parameter :math:`\\beta`.

Parameters
----------
beta : float, :math:`\\beta > 0`
    Scale parameter :math:`\\beta`."

// ---------------------------------------------------------------------

%feature("docstring") OT::MeixnerDistribution::setAlpha
"Accessor to the distribution's skewness parameter :math:`\\alpha`.

Parameters
----------
alpha : float, :math:`\\alpha \\in [-\\pi; \\pi]`
    Skewness parameter :math:`\\alpha`."

// ---------------------------------------------------------------------

%feature("docstring") OT::MeixnerDistribution::setDelta
"Accessor to the distribution's shape parameter :math:`\\delta`.

Parameters
----------
delta : float, :math:`\\delta > 0`
    Shape parameter :math:`\\delta`."

// ---------------------------------------------------------------------

%feature("docstring") OT::MeixnerDistribution::setGamma
"Accessor to the distribution's position parameter :math:`\\gamma`.

Parameters
----------
gamma : float, :math:`\\gamma \\in \\Rset`
    Position parameter :math:`\\gamma`."
