%feature("docstring") OT::NaiveEnclosingSimplex
"Naive implementation of point location.

This class implements a naive implementation of point location,
by looking into all its simplices.  It works well for convex
domains, but may be slow otherwise.

Available constructors:
    NaiveEnclosingSimplex(*vertices, simplices*)

Parameters
----------
vertices : :class:`~openturns.Sample`
    Vertices.

simplices : :class:`~openturns.IndicesCollection`
    Simplices.

Notes
-----

In order to speed-up point location, a first pass is performed
by looping over all simplices containing the nearest point.  If
query point is not found in those simplices, then all simplices
are looked for.

See also
--------
EnclosingSimplexAlgorithm

Examples
--------
>>> import openturns as ot
>>> mesher = ot.IntervalMesher([5, 10])
>>> lowerbound = [0.0, 0.0]
>>> upperBound = [2.0, 4.0]
>>> interval = ot.Interval(lowerbound, upperBound)
>>> mesh = mesher.build(interval)
>>> locator = ot.NaiveEnclosingSimplex(mesh.getVertices(), mesh.getSimplices())
>>> simplex = locator.query([0.1, 0.2])"

// ---------------------------------------------------------------------

%feature("docstring") OT::NaiveEnclosingSimplex::getNearestNeighbourAlgorithm
"Accessor to the nearest neighbour algorithm.

Returns
-------
nearestNeighbour : :class:`~openturns.NearestNeighbourAlgorithm`
    Algorithm used during first pass to locate the nearest point."

// ---------------------------------------------------------------------

%feature("docstring") OT::NaiveEnclosingSimplex::setNearestNeighbourAlgorithm
"Accessor to the nearest neighbour algorithm.

Parameters
----------
nearestNeighbour : :class:`~openturns.NearestNeighbourAlgorithm`
    Algorithm to use during first pass to locate the nearest point."

