# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Probabilistic distributions."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _dist_bundle2
else:
    import _dist_bundle2

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _dist_bundle2.delete_SwigPyIterator

    def value(self):
        return _dist_bundle2.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _dist_bundle2.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _dist_bundle2.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _dist_bundle2.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _dist_bundle2.SwigPyIterator_equal(self, x)

    def copy(self):
        return _dist_bundle2.SwigPyIterator_copy(self)

    def next(self):
        return _dist_bundle2.SwigPyIterator_next(self)

    def __next__(self):
        return _dist_bundle2.SwigPyIterator___next__(self)

    def previous(self):
        return _dist_bundle2.SwigPyIterator_previous(self)

    def advance(self, n):
        return _dist_bundle2.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _dist_bundle2.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _dist_bundle2.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _dist_bundle2.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _dist_bundle2.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _dist_bundle2.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _dist_bundle2.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _dist_bundle2:
_dist_bundle2.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
class Histogram(openturns.model_copula.ContinuousDistribution):
    r"""
    Histogram distribution.

    Available constructors:
        Histogram(*first, width, height*)

        Histogram(*ticks, frequencies*)

    Parameters
    ----------
    first : float
        Lower bound of the range.

        Default value is zero.
    width : positive sequence of float
        :math:`w_i` is the width of the class :math:`i` for :math:`1 \leq i \leq n`.

        Default value is 1.
    height : positive sequence of float
        :math:`h_i` is the density of the class :math:`i` for :math:`1 \leq i \leq n`.
        The :math:`h_i` are automatically normalized such that :math:`\sum_{i=1}^n h_iw_i=1`.

        Default value is 1.
    ticks : increasing sequence of float
        :math:`t_0` is the lower bound of the first class and :math:`t_i` is the upper bound of the class :math:`i` for :math:`1 \leq i \leq n`

        Default value is (0.0, 1.0).
    frequencies : positive sequence of float
        :math:`f_i` is the probability of the class :math:`i` for :math:`1 \leq i \leq n`.
        The :math:`f_i` are automatically normalized such that :math:`\sum_{i=1}^n f_i=1`.

        Default value is 1.0.

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        f_X(x) = \sum_{i=1}^{n}h_i\;\boldsymbol{1}_{[x_{i-1},x_i]}(x)

    where the class :math:`i` is :math:`[x_{i-1},x_i]` and :math:`w_i = x_i - x_{i-1}`.
    The values :math:`h_i` are such that :math:`\sum_{i=1}^n h_iw_i=1`.
    The relation between the two parameterizations are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            first & = & t_0 \\
            w_i & = & x_i - x_{i-1} \\
            h_i & = & f_i / w_i
        \end{eqnarray*}

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{1}{2}
                             \sum_{i=1}^n h_i\,w_i (x_{i+1} + x_i)\\
            \Var{X} & = & \frac{1}{3}
                          \sum_{i=1}^n h_i\,w_i (x_{i+1}^2 + x_i\,x_{i+1} + x_i^2)
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> l = [1.0, 0.7, 1.2, 0.9]
    >>> h = [0.5, 1.5, 3.5, 2.5]
    >>> distribution = ot.Histogram(-1.5, l, h)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Histogram_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.Histogram___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.Histogram___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.Histogram___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.Histogram_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Histogram_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Histogram_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Histogram_computeCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Histogram_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Histogram_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Histogram_computeCDFGradient(self, *args)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.Histogram_getStandardRepresentative(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.Histogram_getParameter(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.Histogram_setParameter(self, parameter)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.Histogram_getParameterDescription(self)

    def setFirst(self, first):
        r"""
        Accessor to the lower bound.

        Parameters
        ----------
        first : float
            Lower bound.
        """
        return _dist_bundle2.Histogram_setFirst(self, first)

    def getFirst(self):
        r"""
        Accessor to the distribution's lower bound.

        Returns
        -------
        first : float
            Lower bound.
        """
        return _dist_bundle2.Histogram_getFirst(self)

    def setData(self, width, weight):
        r"""
        Accessor to the widths and heights.

        Parameters
        ----------
        width : :class:`~openturns.Point`
            The collection of :math:`\ell_i`, the width of class `i`.
        height : :class:`~openturns.Point`
            The collection of :math:`h_i`, the height of class `i`.
        """
        return _dist_bundle2.Histogram_setData(self, width, weight)

    def getWidth(self):
        r"""
        Accessor to the width.

        Returns
        -------
        width : :class:`~openturns.Point`
            The collection of :math:`\ell_i`, the width of class `i`.
        """
        return _dist_bundle2.Histogram_getWidth(self)

    def getHeight(self):
        r"""
        Accessor to the height.

        Returns
        -------
        height : :class:`~openturns.Point`
            The collection of :math:`h_i`, the height of class `i`.
        """
        return _dist_bundle2.Histogram_getHeight(self)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle2.Histogram_getSingularities(self)

    def drawPDF(self, *args):
        r"""
        Draw the graph or of iso-lines of probability density function.

        Available constructors:
            drawPDF(*x_min, x_max, pointNumber, logScale*)

            drawPDF(*lowerCorner, upperCorner, pointNbrInd, logScaleX, logScaleY*)

            drawPDF(*lowerCorner, upperCorner*)

        Parameters
        ----------
        x_min : float, optional
            The min-value of the mesh of the x-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMin` from the :class:`~openturns.ResourceMap`.
        x_max : float, optional, :math:`x_{\max} > x_{\min}`
            The max-value of the mesh of the y-axis.
            Defaults uses the quantile associated to the probability level
            `Distribution-QMax` from the :class:`~openturns.ResourceMap`.
        pointNumber : int
            The number of points that is used for meshing each axis.
            Defaults uses `DistributionImplementation-DefaultPointNumber` from the
            :class:`~openturns.ResourceMap`.
        logScale : bool
            Flag to tell if the plot is done on a logarithmic scale. Default is *False*.
        lowerCorner : sequence of float, of dimension 2, optional
            The lower corner :math:`[x_{min}, y_{min}]`.
        upperCorner : sequence of float, of dimension 2, optional
            The upper corner :math:`[x_{max}, y_{max}]`.
        pointNbrInd : :class:`~openturns.Indices`, of dimension 2
            Number of points that is used for meshing each axis.
        logScaleX : bool
            Flag to tell if the plot is done on a logarithmic scale for X. Default is *False*.
        logScaleY : bool
            Flag to tell if the plot is done on a logarithmic scale for Y. Default is *False*.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            A graphical representation of the PDF or its iso_lines.

        Notes
        -----
        Only valid for univariate and bivariate distributions.

        See Also
        --------
        computePDF, viewer.View, ResourceMap

        Examples
        --------
        View the PDF of a univariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal()
        >>> graph = dist.drawPDF()
        >>> graph.setLegends(['normal pdf'])

        View the iso-lines PDF of a bivariate distribution:

        >>> import openturns as ot
        >>> dist = ot.Normal(2)
        >>> graph2 = dist.drawPDF()
        >>> graph2.setLegends(['iso- normal pdf'])
        >>> graph3 = dist.drawPDF([-10, -5],[5, 10], [511, 511])

        """
        return _dist_bundle2.Histogram_drawPDF(self, *args)

    def __init__(self, *args):
        _dist_bundle2.Histogram_swiginit(self, _dist_bundle2.new_Histogram(*args))
    __swig_destroy__ = _dist_bundle2.delete_Histogram

# Register Histogram in _dist_bundle2:
_dist_bundle2.Histogram_swigregister(Histogram)
class HistogramFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Histogram factory.

    Notes
    -----
    The range is :math:`[\min(data), \max(data)]`. 

    See the :meth:`~openturns.HistogramFactory.computeBandwidth` method for the bandwidth selection. 

    Examples
    --------
    Create an histogram:

    >>> import openturns as ot
    >>> sample = ot.Normal().getSample(50)
    >>> histogram = ot.HistogramFactory().build(sample)

    Create an histogram from a number of bins:

    >>> import openturns as ot
    >>> sample = ot.Normal().getSample(50)
    >>> binNumber = 10
    >>> histogram = ot.HistogramFactory().build(sample, binNumber)

    Create an histogram from a bandwidth:

    >>> import openturns as ot
    >>> sample = ot.Normal().getSample(50)
    >>> bandwidth = 0.5
    >>> histogram = ot.HistogramFactory().build(sample, bandwidth)

    Create an histogram from a first value and widths:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.Normal().getSample(50)
    >>> first = -4
    >>> width = ot.Point(7, 1.)
    >>> histogram = ot.HistogramFactory().build(sample, first, width)

    Compute bandwidth with default robust estimator:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.Normal().getSample(50)
    >>> factory = ot.HistogramFactory()
    >>> factory.computeBandwidth(sample)
    0.8207...

    Compute bandwidth with optimal estimator:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.Normal().getSample(50)
    >>> factory = ot.HistogramFactory()
    >>> factory.computeBandwidth(sample, False)
    0.9175...

    See also
    --------
    DistributionFactory, Histogram
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.HistogramFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.HistogramFactory_build(self, *args)

    def buildAsHistogram(self, *args):
        r"""
        Estimate the distribution as native distribution.

        If the sample is constant, the range of the histogram would be zero. 
        In this case, the range is set to be a factor of the `Distribution-DefaultCDFEpsilon` 
        key of the :class:`~openturns.ResourceMap`. 

        **Available usages**:

            buildAsHistogram()

            buildAsHistogram(*sample*)

            buildAsHistogram(*sample*, *binNumber*)

            buildAsHistogram(*sample*, *bandwidth*)

            buildAsHistogram(*sample*, *first*, *width*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        binNumber : int
            The number of classes. 
        bandwidth : float
            The width of each class. 
        first : float
            The lower bound of the first class. 
        width : 1-d sequence of float
            The widths of the classes. 

        Returns
        -------
        distribution : :class:`~openturns.Histogram`
            The estimated distribution as a Histogram.

            In the first usage, the default Histogram distribution is built.
        """
        return _dist_bundle2.HistogramFactory_buildAsHistogram(self, *args)

    def buildFromQuantiles(self, lowerBound, probabilities, quantiles):
        r"""
        Build from quantiles.

        We consider an histogram distribution with :math:`K` bins. 
        Given a set of probabilities :math:`p_1, ..., p_K \in [0, 1]` 
        and a set of quantiles :math:`q_1, ..., q_K \in \Rset`, 
        we compute the parameters of the distribution such that:

        .. math::

            \Prob{X \leq q_i} = p_i

        for :math:`i = 1, ..., K`.

        Parameters
        ----------
        lowerBound : float
            Lower bound.
        probabilities : sequence of float
            The probabilities.
        quantiles : sequence of float
            Quantiles of the desired distribution.

        Returns
        -------
        dist : :class:`~openturns.Histogram`
            Estimated distribution.

        Examples
        --------
        >>> import openturns as ot
        >>> ref_dist = ot.Normal()
        >>> lowerBound = -3.0
        >>> N = 10
        >>> probabilities = [(i+1) / N for i in range(N)]
        >>> quantiles = [ref_dist.computeQuantile(pi)[0] for pi in probabilities]
        >>> factory = ot.HistogramFactory()
        >>> dist = factory.buildFromQuantiles(lowerBound, probabilities, quantiles)

        """
        return _dist_bundle2.HistogramFactory_buildFromQuantiles(self, lowerBound, probabilities, quantiles)

    def computeBandwidth(self, sample, useQuantile=True):
        r"""
        Compute the bandwidth.

        Notes
        -----
        The bandwidth of the histogram is based on the asymptotic mean integrated squared 
        error (AMISE). 

        When `useQuantile` is `True` (the default), the bandwidth is based on the 
        quantiles of the sample.
        For any :math:`\alpha\in(0,1]`, let :math:`q_n(\alpha)` be the empirical quantile 
        at level :math:`\alpha` of the sample. 
        Let :math:`Q_1` and :math:`Q_3` be the first and last quartiles of the 
        sample: 

        .. math::

            Q_3 = q_n(0.75), \qquad Q_1 = q_n(0.25),

        and let :math:`IQR` be the inter-quartiles range:

        .. math::

            IQR = Q_3 - Q_1.

        In this case, the bandwidth is the robust estimator of the AMISE-optimal bandwidth,
        known as Freedman and Diaconis rule [freedman1981]_:

        .. math::

            h = \frac{IQR}{2\Phi^{-1}(0.75)} \left(\frac{24 \sqrt{\pi}}{n}\right)^{\frac{1}{3}}

        where :math:`\Phi^{-1}` is the quantile function of the gaussian standard 
        distribution. 
        The expression :math:`\frac{IQR}{2\Phi^{-1}(0.75)}` is the normalized inter-quartile range 
        and is equal to the standard deviation of the gaussian distribution. 
        The normalized inter-quartile range is a robust estimator of the scale of the 
        distribution (see [wand1994]_, page 60). 

        When `useQuantile` is `False`, the bandwidth is the AMISE-optimal one, 
        known as Scott's rule (see [scott2015]_ eq. 3.16 page 59): 

        .. math::

            h = \sigma_n \left(\frac{24 \sqrt{\pi}}{n}\right)^{\frac{1}{3}}

        where :math:`\sigma_n^2` is the unbiased variance of the data.
        This estimator is optimal for the gaussian distribution (see [scott1992]_). 
        In this case, the AMISE is :math:`O(n^{-2/3})`. 


        If the bandwidth is computed as zero (for example, if the sample is constant), 
        then the `Distribution-DefaultQuantileEpsilon` key 
        of the :class:`~openturns.ResourceMap` is used instead. 

        Parameters
        ----------
        sample : :class:`~openturns.Sample`
            Data

        Returns
        -------
        bandwidth : float
            The estimated bandwidth.
        useQuantile : bool, optional (default=`True`)
            If `True`, then use the robust bandwidth estimator based on Freedman and Diaconis rule. 
            Otherwise, use the optimal bandwidth estimator based on Scott's rule.
        """
        return _dist_bundle2.HistogramFactory_computeBandwidth(self, sample, useQuantile)

    def __init__(self, *args):
        _dist_bundle2.HistogramFactory_swiginit(self, _dist_bundle2.new_HistogramFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_HistogramFactory

# Register HistogramFactory in _dist_bundle2:
_dist_bundle2.HistogramFactory_swigregister(HistogramFactory)
class Hypergeometric(openturns.model_copula.DiscreteDistribution):
    r"""
    Hypergeometric distribution.

    Parameters
    ----------
    n : int, :math:`n \in \Nset`
        Population size.

        Default value is 0.
    k : int, :math:`0 \leq k \leq n`
        Number of candidates in the population.

        Default value is 1.
    m : int, :math:`0 \leq m \leq n`
        Size of the sample drawn in the population.

        Default value is 0.

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        \Prob{X = i} = \dfrac{{k \choose i}{n-m \choose m-i}}{{n \choose m}}
                       \quad \forall i \in \{\max\{0,k+m-n\}, \ldots, \min\{k,m\}\}

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & n\dfrac{k}{m} \\
            \Var{X} & = & m\dfrac{k}{n}\dfrac{n-k}{n}\dfrac{n-m}{n-1}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Hypergeometric(10, 5, 4)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Hypergeometric_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.Hypergeometric___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.Hypergeometric___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.Hypergeometric___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.Hypergeometric_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Hypergeometric_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.Hypergeometric_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Hypergeometric_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.Hypergeometric_computeComplementaryCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Hypergeometric_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Hypergeometric_computeCDFGradient(self, *args)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.Hypergeometric_getSupport(self, *args)

    def getProbabilities(self):
        r"""
        Accessor to the discrete probability levels.

        Returns
        -------
        probabilities : :class:`~openturns.Point`
            The probability levels of a discrete distribution.
        """
        return _dist_bundle2.Hypergeometric_getProbabilities(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.Hypergeometric_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.Hypergeometric_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.Hypergeometric_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.Hypergeometric_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.Hypergeometric_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.Hypergeometric_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.Hypergeometric_isElliptical(self)

    def setK(self, h):
        r"""
        Accessor to the number of candidates parameter.

        Parameters
        ----------
        k : int, :math:`0\leq k\leq n`
            The number of candidates in the population.
        """
        return _dist_bundle2.Hypergeometric_setK(self, h)

    def getK(self):
        r"""
        Accessor to the number of candidates parameter.

        Returns
        -------
        k : int, :math:`0\leq k\leq n`
            The number of candidates in the population.
        """
        return _dist_bundle2.Hypergeometric_getK(self)

    def setM(self, m):
        r"""
        Accessor to the sample size.

        Parameters
        ----------
        m : int, :math:`0\leq m\leq n`
            The sample size.
        """
        return _dist_bundle2.Hypergeometric_setM(self, m)

    def getM(self):
        r"""
        Accessor to the sample size.

        Returns
        -------
        m : int, :math:`0\leq m\leq n`
            The sample size.
        """
        return _dist_bundle2.Hypergeometric_getM(self)

    def setN(self, n):
        r"""
        Accessor to the population size.

        Parameters
        ----------
        n : int
            The population size.
        """
        return _dist_bundle2.Hypergeometric_setN(self, n)

    def getN(self):
        r"""
        Accessor to the population size.

        Returns
        -------
        n : int
            The population size.
        """
        return _dist_bundle2.Hypergeometric_getN(self)

    def __init__(self, *args):
        _dist_bundle2.Hypergeometric_swiginit(self, _dist_bundle2.new_Hypergeometric(*args))
    __swig_destroy__ = _dist_bundle2.delete_Hypergeometric

# Register Hypergeometric in _dist_bundle2:
_dist_bundle2.Hypergeometric_swigregister(Hypergeometric)
class BayesDistribution(openturns.model_copula.ContinuousDistribution):
    r"""
    Bayes distribution.

    Helper class for defining the distribution of the random vector :math:`(\vect{X},\vect{Y})` where :math:`\vect{Y}` follows the distribution :math:`\mathcal{L}_{\vect{Y}}` and :math:`\vect{X}|\vect{\Theta}` follows the distribution :math:`\mathcal{L}_{\vect{X}|\vect{\Theta}}`  where :math:`\vect{\Theta}=g(\vect{Y})` with :math:`g` a given function of input dimension the dimension of :math:`\mathcal{L}_{\vect{Y}}` and output dimension the dimension of :math:`\vect{\Theta}`.

    Available constructors:
       BayesDistribution(*conditionedDist, conditioningDist, linkFunction*)

       BayesDistribution(*conditionedDist, conditioningDist*)

       BayesDistribution()

    Parameters
    ----------

    conditionedDist : :class:`~openturns.Distribution`, the distribution of :math:`\vect{X}|\vect{\Theta}`, whose parameters will be overwritten by :math:`g(\vect{Y})`.
        In the `BayesDistribution()` constructor, `conditionedDist` is taken equal to :math:`\vect{X} | \vect{\Theta} \sim` :class:`~openturns.Uniform` :math:`(\vect{\Theta})`.

    conditioningDist : :class:`~openturns.Distribution`, the distribution of :math:`\vect{Y}`, specified with its parameters.
        In the `BayesDistribution()` constructor,  `conditioningDist` is taken equal to :math:`\vect{Y} \sim Uniform(-1,1)`.

    linkFunction : :class:`~openturns.Function`, the function :math:`g: \Rset^p \rightarrow \Rset^q`, where :math:`p` is the dimension of `conditioningDist` and :math:`q` is the dimension of :math:`\vect{\Theta}`.
        In the `BayesDistribution()` constructor, `linkFunction`  is taken equal to :math:`g: \Rset \rightarrow \Rset^2`, :math:`g(y)=(y,y+1)`.
        In the `BayesDistribution(conditionedDist, conditioningDist)` constructor, we need :math:`p=q` and `linkFunction`  is taken equal to  :math:`g(\vect{y})=\vect{y}`.


    Notes
    -----
    This distribution is limited to the continuous case, ie when both the conditioning and the conditioned distributions are continuous. Its probability density function is defined as:

    .. math::

        f_{(\vect{X}, \vect{Y})}(\vect{x}, \vect{y}) = f_{\vect{X}|\vect{\Theta}=g(\vect{y})}(\vect{x}|g(\vect{y})) f_{\vect{Y}}( \vect{y})

    with  :math:`f_{\vect{X}|\vect{\Theta}=g(\vect{y})}` the PDF of the distribution of :math:`\vect{X}|\vect{\Theta}`, where :math:`\vect{\Theta}` has been replaced by :math:`g(\vect{y})`, :math:`f_{\vect{Y}}` the PDF of :math:`\vect{Y}` and :math:`g` the linking function.

    With the default constructor, the resulting random vector :math:`(X,Y)` is uniformly distributed on the parallelogram which vertices are :math:`(-1,-1); (0,-1); (2,1); (1,1)`.


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> conditioningDist = ot.Normal(0.0, 1.0)
    >>> g = ot.SymbolicFunction(['y'], ['y', '0.1+y^2'])
    >>> conditionedDist = ot.Normal()
    >>> finalDist = ot.ConditionalDistribution(conditionedDist, conditioningDist, g)

    Draw a sample:

    >>> sample = finalDist.getSample(5)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.BayesDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.BayesDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.BayesDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.BayesDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.BayesDistribution_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.BayesDistribution_computePDF(self, *args)

    def setConditionedDistribution(self, conditionedDistribution):
        r"""
        Accessor to the distribution's conditioned distribution parameter `conditionedDistribution`.

        Parameters
        ----------
        conditionedDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\vect{X}|\vect{\Theta}`, whose parameters will be overwritten by :math:`g(\vect{Y})`.

        """
        return _dist_bundle2.BayesDistribution_setConditionedDistribution(self, conditionedDistribution)

    def getConditionedDistribution(self):
        r"""
        Accessor to the distribution's conditioned distribution parameter `conditionedDistribution`.

        Returns
        -------
        conditionedDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\vect{X}|\vect{\Theta}`, whose parameters will be overwritten by :math:`g(\vect{Y})`.

        """
        return _dist_bundle2.BayesDistribution_getConditionedDistribution(self)

    def setConditioningDistribution(self, conditioningDistribution):
        r"""
        Accessor to the distribution's conditioned distribution parameter `conditioningDistribution`.

        Parameters
        ----------
        conditioningDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\vect{Y}`, specified with its parameters.

        """
        return _dist_bundle2.BayesDistribution_setConditioningDistribution(self, conditioningDistribution)

    def getConditioningDistribution(self):
        r"""
        Accessor to the distribution's conditioned distribution parameter `conditioningDistribution`.

        Returns
        -------
        conditioningDistribution : :class:`~openturns.Distribution`, the distribution of :math:`\vect{Y}`, specified with its parameters.

        """
        return _dist_bundle2.BayesDistribution_getConditioningDistribution(self)

    def setLinkFunction(self, linkFunction):
        r"""
        Accessor to the distribution's conditioned distribution parameter `linkFunction`.

        Parameters
        ----------
        linkFunction : :class:`~openturns.Function`, the function :math:`g: \Rset^p \rightarrow \Rset^q`, where :math:`p` is the dimension of `conditioningDist` and :math:`q` is the dimension of :math:`\vect{\Theta}`.

        """
        return _dist_bundle2.BayesDistribution_setLinkFunction(self, linkFunction)

    def getLinkFunction(self):
        r"""
        Accessor to the distribution's conditioned distribution parameter `linkFunction`.

        Returns
        -------
        linkFunction : :class:`~openturns.Function`, the function :math:`g: \Rset^p \rightarrow \Rset^q`, where :math:`p` is the dimension of `conditioningDist` and :math:`q` is the dimension of :math:`\vect{\Theta}`.

        """
        return _dist_bundle2.BayesDistribution_getLinkFunction(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.BayesDistribution_getMarginal(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.BayesDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.BayesDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.BayesDistribution_getParameterDescription(self)

    def __init__(self, *args):
        _dist_bundle2.BayesDistribution_swiginit(self, _dist_bundle2.new_BayesDistribution(*args))
    __swig_destroy__ = _dist_bundle2.delete_BayesDistribution

# Register BayesDistribution in _dist_bundle2:
_dist_bundle2.BayesDistribution_swigregister(BayesDistribution)
class InverseChiSquare(openturns.model_copula.ContinuousDistribution):
    r"""
    InverseChiSquare distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        Degrees of freedom.  

        Default value is 1.0.


    Notes
    -----
    :math:`X` follows an Inverse ChiSquare distribution of parameter :math:`\nu` means that :math:`\dfrac{1}{X}` follows the :math:`\chi^2(\nu)` distribution, with :math:`\nu>0`.
    The Inverse ChiSquare distribution parameterized by :math:`\nu` is exactly the :math:`InverseGamma(2, \dfrac{\nu}{2})` distribution.

    Its probability density function is defined as:

    .. math::

        f_X(x) = \dfrac{\exp \left( -\dfrac{1}{2 x}\right)}{\Gamma \left(\dfrac{\nu}{2}\right)\lambda^{\frac{\nu}{2}}x^{\frac{\nu}{2}+1}}, \quad x \in [0; +\infty[

    with :math:`\nu > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \dfrac{1}{\nu-2}  \quad \text{if } \nu>2\\
            \Var{X} & = &\dfrac{2}{(\nu-2)^2(\nu-4)}\quad \text{if } \nu>4
        \end{eqnarray*}


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.InverseChiSquare(1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseChiSquare_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.InverseChiSquare___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.InverseChiSquare___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.InverseChiSquare___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.InverseChiSquare_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseChiSquare_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseChiSquare_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.InverseChiSquare_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseChiSquare_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.InverseChiSquare_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle2.InverseChiSquare_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.InverseChiSquare_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.InverseChiSquare_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.InverseChiSquare_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.InverseChiSquare_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.InverseChiSquare_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.InverseChiSquare_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.InverseChiSquare_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.InverseChiSquare_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.InverseChiSquare_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.InverseChiSquare_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.InverseChiSquare_getParameterDescription(self)

    def setNu(self, nu):
        r"""
        Accessor to the distribution parameter :math:`\nu`.

        Parameters
        ----------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle2.InverseChiSquare_setNu(self, nu)

    def getNu(self):
        r"""
        Accessor to the  parameter :math:`nu`.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle2.InverseChiSquare_getNu(self)

    def __init__(self, *args):
        _dist_bundle2.InverseChiSquare_swiginit(self, _dist_bundle2.new_InverseChiSquare(*args))
    __swig_destroy__ = _dist_bundle2.delete_InverseChiSquare

# Register InverseChiSquare in _dist_bundle2:
_dist_bundle2.InverseChiSquare_swigregister(InverseChiSquare)
class InverseGamma(openturns.model_copula.ContinuousDistribution):
    r"""
    InverseGamma distribution.


    Parameters
    ----------
    lambda : float, :math:`\lambda > 0`
        Rate parameter.

        Default value is 1.0.
    k : float, :math:`k > 0`
        Shape parameter.

        Default value is 1.0.

    Notes
    -----
    :math:`X` follows an Inverse Gamma distribution of parameters :math:`(\lambda, k)` means that :math:`\dfrac{1}{X}` follows the :math:`\Gamma(k, \dfrac{1}{\lambda})` distribution, with :math:`k>0` and :math:`\lambda>0`.

    Its probability density function is defined as:

    .. math::

        f_X(x) = \dfrac{\exp \left( -\dfrac{1}{\lambda x}\right)}{\Gamma(k)\lambda^kx^{k+1}}, \quad x \in [0; +\infty[

    with :math:`k >0 , \lambda > 0`.


    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \dfrac{1}{\lambda(k-1)} \quad \text{if } k>1 \\
            \Var{X} & = &\dfrac{1}{\lambda^2(k-1)^2(k-2)} \quad \text{if } k>2 
        \end{eqnarray*}


    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.InverseGamma(1.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseGamma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.InverseGamma___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.InverseGamma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.InverseGamma___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.InverseGamma_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseGamma_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseGamma_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.InverseGamma_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseGamma_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.InverseGamma_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle2.InverseGamma_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.InverseGamma_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.InverseGamma_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.InverseGamma_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.InverseGamma_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.InverseGamma_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.InverseGamma_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.InverseGamma_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.InverseGamma_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.InverseGamma_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.InverseGamma_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.InverseGamma_getParameterDescription(self)

    def setK(self, k):
        r"""
        Accessor to the distribution's shape parameter :math:`k`.

        Parameters
        ----------
        k : float, :math:`k > 0`
            Parameter :math:`k`.
        """
        return _dist_bundle2.InverseGamma_setK(self, k)

    def getK(self):
        r"""
        Accessor to the  parameter :math:`k`.

        Returns
        -------
        k : float
            Shape parameter :math:`k`.
        """
        return _dist_bundle2.InverseGamma_getK(self)

    def setLambda(self, _lambda):
        r"""
        Accessor to the distribution's scale parameter :math:`\lambda`.

        Parameters
        ----------
        lambda : float, :math:`\lambda > 0`
            Parameter :math:`\lambda`.
        """
        return _dist_bundle2.InverseGamma_setLambda(self, _lambda)

    def getLambda(self):
        r"""
        Accessor to the parameter :math:`\lambda`.

        Returns
        -------
        lambda : float
            Scale parameter :math:`\lambda`.
        """
        return _dist_bundle2.InverseGamma_getLambda(self)

    def setKLambda(self, k, _lambda):
        return _dist_bundle2.InverseGamma_setKLambda(self, k, _lambda)

    def __init__(self, *args):
        _dist_bundle2.InverseGamma_swiginit(self, _dist_bundle2.new_InverseGamma(*args))
    __swig_destroy__ = _dist_bundle2.delete_InverseGamma

# Register InverseGamma in _dist_bundle2:
_dist_bundle2.InverseGamma_swigregister(InverseGamma)
class InverseNormal(openturns.model_copula.ContinuousDistribution):
    r"""
    Inverse normal distribution.

    Parameters
    ----------
    mu : float, :math:`\mu > 0`
        Mean parameter :math:`\mu`.
    lambda : float, :math:`\lambda > 0`
        Rate parameter :math:`\lambda`.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \sqrt{\frac{\lambda}{2 \pi x^3}}
                 \exp\left(\frac{- \lambda (x - \mu)^2}{2 \mu^2 x}\right),
                 \quad x \in [0; +\infty[

    with :math:`\lambda, \mu > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \mu \\
            \Var{X} & = & \frac{\mu^3}{\lambda}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.InverseNormal(1.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseNormal_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.InverseNormal___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.InverseNormal___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.InverseNormal___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.InverseNormal_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseNormal_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.InverseNormal_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseNormal_computeCDF(self, *args)

    def computeMinimumVolumeLevelSetWithThreshold(self, prob):
        r"""
        Compute the confidence domain with minimum volume.

        Refer to :func:`computeMinimumVolumeLevelSet()`

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [0,1]`
            The confidence level.

        Returns
        -------
        levelSet : :class:`~openturns.LevelSet`
            The minimum volume domain of measure :math:`\alpha`.
        level : float
            The value :math:`p_{\alpha}` of the density function defining the frontier of the domain.

        Examples
        --------
        Create a sample from a Normal distribution:

        >>> import openturns as ot
        >>> sample = ot.Normal().getSample(10)
        >>> ot.ResourceMap.SetAsUnsignedInteger('DistributionFactory-DefaultBootstrapSize', 100)

        Fit a Normal distribution and extract the asymptotic parameters distribution:

        >>> fittedRes = ot.NormalFactory().buildEstimator(sample)
        >>> paramDist = fittedRes.getParameterDistribution()

        Determine the confidence region of minimum volume of the native parameters at level 0.9 with PDF threshold:

        >>> levelSet, threshold = paramDist.computeMinimumVolumeLevelSetWithThreshold(0.9)

        """
        return _dist_bundle2.InverseNormal_computeMinimumVolumeLevelSetWithThreshold(self, prob)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.InverseNormal_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.InverseNormal_computeLogCharacteristicFunction(self, x)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.InverseNormal_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.InverseNormal_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.InverseNormal_getKurtosis(self)

    def setMuLambda(self, mu, _lambda):
        r"""
        Accessor to the distribution's parameters.

        Parameters
        ----------
        mu : float, :math:`\mu > 0`
            Mean parameter :math:`\mu`.
        lambda : float, :math:`\lambda > 0`
            Rate parameter :math:`\lambda`.
        """
        return _dist_bundle2.InverseNormal_setMuLambda(self, mu, _lambda)

    def getLambda(self):
        r"""
        Accessor to the distribution's rate parameter.

        Returns
        -------
        lambda : float
            Rate parameter :math:`\lambda`.
        """
        return _dist_bundle2.InverseNormal_getLambda(self)

    def getMu(self):
        r"""
        Accessor to the distribution's mean parameter.

        Returns
        -------
        mu : float
            Mean parameter :math:`\mu`.
        """
        return _dist_bundle2.InverseNormal_getMu(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.InverseNormal_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.InverseNormal_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.InverseNormal_getParameterDescription(self)

    def __init__(self, *args):
        _dist_bundle2.InverseNormal_swiginit(self, _dist_bundle2.new_InverseNormal(*args))
    __swig_destroy__ = _dist_bundle2.delete_InverseNormal

# Register InverseNormal in _dist_bundle2:
_dist_bundle2.InverseNormal_swigregister(InverseNormal)
class InverseNormalFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Inverse Normal factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\mu}_n =  \bar{x}_n\\
          \displaystyle\Hat{\lambda}_n = \left(  \frac{1}{n} \sum_{i=1}^n \frac{1}{x_i} - \frac{1}{\bar{x}_n} \right)^{-1}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, InverseNormal
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseNormalFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.InverseNormalFactory_build(self, *args)

    def buildAsInverseNormal(self, *args):
        r"""
        Estimate the distribution as native distribution.


        **Available usages**:

            buildAsInverseNormal()

            buildAsInverseNormal(*sample*)

            buildAsInverseNormal(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.InverseNormal`.

        Returns
        -------
        distribution : :class:`~openturns.InverseNormal`
            The estimated distribution as a :class:`~openturns.InverseNormal`.

            In the first usage, the default :class:`openturns.InverseNormal` distribution is built.
        """
        return _dist_bundle2.InverseNormalFactory_buildAsInverseNormal(self, *args)

    def __init__(self, *args):
        _dist_bundle2.InverseNormalFactory_swiginit(self, _dist_bundle2.new_InverseNormalFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_InverseNormalFactory

# Register InverseNormalFactory in _dist_bundle2:
_dist_bundle2.InverseNormalFactory_swigregister(InverseNormalFactory)
class InverseWishart(openturns.model_copula.ContinuousDistribution):
    r"""
    Inverse-Wishart distribution.

    Parameters
    ----------
    V : 2-d sequence of float
        Scale matrix, positive definite of size :math:`p`.

        Default value is [[1.0]].
    nu : float, :math:`\nu > p - 1`
        Degrees of freedom.

        Default value is 1.0.

    See Also
    --------
    Wishart

    Notes
    -----
    The distribution is of dimension :math:`\frac{p(p+1)}{2}` (without the symmetry terms).

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> p = 3
    >>> nu = p + 1.0
    >>> distribution = ot.InverseWishart(ot.CovarianceMatrix(p), nu)

    Get a realization as covariance matrix:

    >>> matrix = distribution.getRealizationAsMatrix()
    >>> print(matrix)
    [[  0.492128 -0.260455 -0.253392 ]
     [ -0.260455  1.44373  -0.799136 ]
     [ -0.253392 -0.799136  1.07088  ]]

    Get a realization (to be interpreted as the lower triangle terms of the matrix,
    line by line as a flat vector):

    >>> flat = distribution.getRealization()
    >>> print(flat)
    [0.241637,0.0606503,0.190742,0.0930118,-0.890494,6.94252]

    Draw a sample (also in flat format):

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.InverseWishart_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.InverseWishart___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.InverseWishart___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.InverseWishart___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.InverseWishart_getRealization(self)

    def getRealizationAsMatrix(self):
        r"""
        Get one realization of the distribution as a covariance matrix.

        Returns
        -------
        V : :class:`~openturns.CovarianceMatrix`
            A realization as a matrix
        """
        return _dist_bundle2.InverseWishart_getRealizationAsMatrix(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseWishart_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.InverseWishart_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.InverseWishart_computeCDF(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.InverseWishart_getStandardDeviation(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.InverseWishart_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.InverseWishart_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.InverseWishart_getParameterDescription(self)

    def setV(self, v):
        r"""
        Accessor to the scale parameter.

        Parameters
        ----------
        V : 2-d sequence of float
            Scale matrix, positive definite of size :math:`p`.
        """
        return _dist_bundle2.InverseWishart_setV(self, v)

    def getV(self):
        r"""
        Accessor to the scale parameter.

        Returns
        -------
        V : :class:`~openturns.CovarianceMatrix`
            Scale matrix, positive definite of size :math:`p`.
        """
        return _dist_bundle2.InverseWishart_getV(self)

    def setNu(self, nu):
        r"""
        Accessor to the degrees of freedom parameter.

        Parameters
        ----------
        nu : float, :math:`\nu > 0`
            Degrees of freedom.
        """
        return _dist_bundle2.InverseWishart_setNu(self, nu)

    def getNu(self):
        r"""
        Accessor to the degrees of freedom parameter.

        Returns
        -------
        nu : float
            Degrees of freedom.
        """
        return _dist_bundle2.InverseWishart_getNu(self)

    def __init__(self, *args):
        _dist_bundle2.InverseWishart_swiginit(self, _dist_bundle2.new_InverseWishart(*args))
    __swig_destroy__ = _dist_bundle2.delete_InverseWishart

# Register InverseWishart in _dist_bundle2:
_dist_bundle2.InverseWishart_swigregister(InverseWishart)
class KPermutationsDistribution(openturns.model_copula.DiscreteDistribution):
    r"""
    KPermutations distribution.

    Parameters
    ----------
    k : int, :math:`k > 0`
    n : int, :math:`n > 0`

    Notes
    -----
    :class:`~openturns.KPermutationsDistribution` is the discrete uniform
    distribution on the set of injective functions :math:`(i_0, \hdots, i_{k_1})`
    from :math:`\{0, \hdots, k-1\}` into :math:`\{0, \hdots, n-1\}`.
    Its probability distribution function is defined as:

    .. math::

        \Prob{\vect{X} = (i_0, \hdots, i_{k-1})} = \frac{(n-k)!}{n!}

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{\vect{X}} & = & \frac{n - 1}{2}\\
            \Cov{\vect{X}} & = & \left\{
                                 \begin{array}{ll}
                                     \displaystyle \frac{n^2-1}{12} \\
                                     \displaystyle -\frac{1 + n}{12}
                                 \end{array}
                                 \right.
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.KPermutationsDistribution(6, 8)

    Draw a sample:

    >>> sample = distribution.getSample(10)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.KPermutationsDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.KPermutationsDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.KPermutationsDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.KPermutationsDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.KPermutationsDistribution_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.KPermutationsDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.KPermutationsDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.KPermutationsDistribution_computeCDF(self, *args)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`0 < p < 1`
            Quantile function input (a probability).
        tail : bool, optional (default=False)
            Whether p should be interpreted as the complementary probability.

        Returns
        -------
        X : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            Quantile at probability level :math:`p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_{\vect{X}}(p) = F_{\vect{X}}^{-1}(p),
                              \quad p \in [0; 1]
        """
        return _dist_bundle2.KPermutationsDistribution_computeQuantile(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.KPermutationsDistribution_getMarginal(self, *args)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.KPermutationsDistribution_getSupport(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.KPermutationsDistribution_getParametersCollection(self)

    def setK(self, k):
        r"""
        Accessor to the parameter :math:`k`.

        Parameters
        ----------
        k : int, :math:`k > 0`
        """
        return _dist_bundle2.KPermutationsDistribution_setK(self, k)

    def getK(self):
        r"""
        Accessor to the parameter :math:`k`.

        Returns
        -------
        k : int
        """
        return _dist_bundle2.KPermutationsDistribution_getK(self)

    def setN(self, n):
        r"""
        Accessor to the parameter :math:`n`.

        Parameters
        ----------
        n : int, :math:`n > 0`
        """
        return _dist_bundle2.KPermutationsDistribution_setN(self, n)

    def getN(self):
        r"""
        Accessor to the parameter :math:`n`.

        Returns
        -------
        n : int
        """
        return _dist_bundle2.KPermutationsDistribution_getN(self)

    def __init__(self, *args):
        _dist_bundle2.KPermutationsDistribution_swiginit(self, _dist_bundle2.new_KPermutationsDistribution(*args))
    __swig_destroy__ = _dist_bundle2.delete_KPermutationsDistribution

# Register KPermutationsDistribution in _dist_bundle2:
_dist_bundle2.KPermutationsDistribution_swigregister(KPermutationsDistribution)
class KernelMixture(openturns.model_copula.ContinuousDistribution):
    r"""
    Build a particular linear combination of probability density functions.

    Parameters
    ----------
    kernel : :class:`~openturns.Distribution`
        Univariate distribution of the kernel that will be used, :math:`K`.
    bandwidth : sequence of float
        Contains the bandwidth in each direction, :math:`(h_1, \dots, h_d)`.
    sample : 2-d sequence of float
        The data on which each kernel is centered,
        :math:`(\vect{X}_1, \dots, \vect{X}_N) \in \Rset^d`.

    Notes
    -----
    A *KernelMixture* is a particular *Mixture*: all the weights are identical and
    the all the probability density functions of the combination are of the same
    family. They are centered on :math:`N` points. The treatment is optimized.

    The pdf of a *KernelMixture* is defined by:

    .. math::

        f(\vect{x}) =  \sum_{i=1}^N \dfrac{1}{N} \Pi_{j=1}^d \dfrac{1}{h_j}K(\frac{x^j-X^j_i}{h})

    where :math:`N` is the number of points in the sample
    :math:`(\vect{X}_1, \dots, \vect{X}_N) \in \Rset^d` and :math:`K` a univariate
    distribution.

    Examples
    --------
    Create a *KernelMixture*:

    >>> import openturns as ot
    >>> kernel = ot.Uniform()
    >>> sample = ot.Normal().getSample(5)
    >>> bandwidth = [1.0]
    >>> distribution = ot.KernelMixture(kernel, bandwidth, sample)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.KernelMixture_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.KernelMixture___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.KernelMixture___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.KernelMixture___str__(self, *args)

    def setKernel(self, kernel):
        r"""
        Set the kernel used in the linear combination.

        Parameters
        ----------
        kernel : :class:`~openturns.Distribution`
            Univariate distribution used to build the kernel.
        """
        return _dist_bundle2.KernelMixture_setKernel(self, kernel)

    def getKernel(self):
        r"""
        Accessor to kernel used in the linear combination.

        Returns
        -------
        kernel : :class:`~openturns.Distribution`
            Univariate distribution used to build the kernel.
        """
        return _dist_bundle2.KernelMixture_getKernel(self)

    def setBandwidth(self, bandwidth):
        r"""
        Set the bandwidth used in the linear combination.

        Parameters
        ----------
        bandwidth : sequence of float
            Bandwidth used in each direction.
        """
        return _dist_bundle2.KernelMixture_setBandwidth(self, bandwidth)

    def getBandwidth(self):
        r"""
        Accessor to the bandwidth used in the linear combination.

        Returns
        -------
        bandwidth : :class:`~openturns.Point`
            Bandwidth used in each direction.
        """
        return _dist_bundle2.KernelMixture_getBandwidth(self)

    def setInternalSample(self, sample):
        r"""
        Set the sample used in the linear combination.

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample on which the kernels are centered.
        """
        return _dist_bundle2.KernelMixture_setInternalSample(self, sample)

    def getInternalSample(self):
        return _dist_bundle2.KernelMixture_getInternalSample(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.KernelMixture_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.KernelMixture_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.KernelMixture_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.KernelMixture_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.KernelMixture_computeComplementaryCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Survival function input(s).

        Returns
        -------
        S : float, :class:`~openturns.Point`
            Survival function value(s) at input(s) `x`.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` is defined as follows:

        .. math::


            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^d X_i > x_i}
                     \quad \forall \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function (except for
            1-dimensional distributions).

        See Also
        --------
        computeComplementaryCDF
        """
        return _dist_bundle2.KernelMixture_computeSurvivalFunction(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\vect{a}` and
        :math:`\vect{b}`:

        .. math::

            \Prob{\bigcap\limits_{i=1}^n a_i < X_i \leq b_i} =
                \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, n)}` with :math:`c_i \in [a_i, b_i]`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.KernelMixture_computeProbability(self, interval)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.KernelMixture_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.KernelMixture_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.KernelMixture_computeCDFGradient(self, *args)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle2.KernelMixture_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        X : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Conditional PDF values at input.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            pdf^{seq}_{X_1,\ldots,X_d}(x_1,\ldots,x_d) = \left(\dfrac{d}{d\,x_n}\Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}}\right)_{i=1,\ldots,d}

        ie its :math:`n`-th component is the conditional PDF of :math:`X_n` at :math:`x_n` given that :math:`X_1=x_1,\ldots,X_{n-1}=x_{n-1}`. For :math:`n=1` it reduces to :math:`\dfrac{d}{d\,x_1}\Prob{X_1 \leq x_1}`, ie the PDF of the first component at :math:`x_1`.
        """
        return _dist_bundle2.KernelMixture_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \mid X_1, \ldots, X_{n - 1}}(x_n) =
                \Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}},
                \quad x_n \in \supp{X_n}
        """
        return _dist_bundle2.KernelMixture_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        X : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at input.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            F^{seq}_{X_1,\ldots,X_d}(x_1,\ldots,x_d) = \left(\Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}}\right)_{i=1,\ldots,d}

        ie its :math:`n`-th component is the conditional CDF of :math:`X_n` at :math:`x_n` given that :math:`X_1=x_1,\ldots,X_{n-1}=x_{n-1}`. For :math:`n=1` it reduces to :math:`\Prob{X_1 \leq x_1}`, ie the CDF of the first component at :math:`x_1`.
        """
        return _dist_bundle2.KernelMixture_computeSequentialConditionalCDF(self, x)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.KernelMixture_getMarginal(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.KernelMixture_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.KernelMixture_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.KernelMixture_getKurtosis(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.KernelMixture_getParametersCollection(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.KernelMixture_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.KernelMixture_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.KernelMixture_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.KernelMixture_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.KernelMixture_isContinuous(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle2.KernelMixture_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.KernelMixture_hasIndependentCopula(self)

    def __init__(self, *args):
        _dist_bundle2.KernelMixture_swiginit(self, _dist_bundle2.new_KernelMixture(*args))
    __swig_destroy__ = _dist_bundle2.delete_KernelMixture

# Register KernelMixture in _dist_bundle2:
_dist_bundle2.KernelMixture_swigregister(KernelMixture)
class Laplace(openturns.model_copula.ContinuousDistribution):
    r"""
    Laplace distribution.

    Parameters
    ----------
    mu : float
        Mean parameter :math:`\mu`.

        Default value is 0.0.
    lambda : float, :math:`\lambda > 0`
        Rate parameter :math:`\lambda`.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{\lambda}{2}
                 \exp\left(- \lambda |x - \mu|\right),
                 \quad x \in \Rset

    with :math:`\lambda > 0` and :math:`\mu \in \Rset`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \mu \\
            \Var{X} & = & \frac{2}{\lambda^2}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Laplace(0.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Laplace_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.Laplace___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.Laplace___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.Laplace___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.Laplace_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Laplace_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Laplace_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.Laplace_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Laplace_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.Laplace_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle2.Laplace_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Laplace_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.Laplace_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Laplace_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Laplace_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.Laplace_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.Laplace_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.Laplace_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.Laplace_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.Laplace_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.Laplace_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.Laplace_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.Laplace_isElliptical(self)

    def setMu(self, mu):
        r"""
        Accessor to the distribution's mean parameter :math:`\mu`.

        Parameters
        ----------
        mu : float, :math:`\mu \in \Rset`
            Mean parameter :math:`\mu`.
        """
        return _dist_bundle2.Laplace_setMu(self, mu)

    def getMu(self):
        r"""
        Accessor to the distribution's mean parameter :math:`\mu`.

        Returns
        -------
        mu : float
            Mean parameter :math:`\mu`.
        """
        return _dist_bundle2.Laplace_getMu(self)

    def setLambda(self, _lambda):
        r"""
        Accessor to the distribution's rate parameter :math:`\lambda`.

        Parameters
        ----------
        lambda : float, :math:`\lambda > 0`
            Scale parameter :math:`\lambda`.
        """
        return _dist_bundle2.Laplace_setLambda(self, _lambda)

    def getLambda(self):
        r"""
        Accessor to the distribution's rate parameter :math:`\lambda`.

        Returns
        -------
        lambda : float
            Rate parameter :math:`\lambda`.
        """
        return _dist_bundle2.Laplace_getLambda(self)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle2.Laplace_getSingularities(self)

    def __init__(self, *args):
        _dist_bundle2.Laplace_swiginit(self, _dist_bundle2.new_Laplace(*args))
    __swig_destroy__ = _dist_bundle2.delete_Laplace

# Register Laplace in _dist_bundle2:
_dist_bundle2.Laplace_swigregister(Laplace)
class LaplaceFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Laplace factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\mu}_n = x_{1/2}\\
          \displaystyle\Hat{\lambda}_n = \frac{1}{n}\sum_{i=1}^n|x_i-\Hat{\mu}_n|
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Laplace
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LaplaceFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.LaplaceFactory_build(self, *args)

    def buildAsLaplace(self, *args):
        r"""
        Estimate the distribution as native distribution.


        **Available usages**:

            buildAsLaplace()

            buildAsLaplace(*sample*)

            buildAsLaplace(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Laplace`.

        Returns
        -------
        distribution : :class:`~openturns.Laplace`
            The estimated distribution as a Laplace.

            In the first usage, the default Laplace distribution is built.
        """
        return _dist_bundle2.LaplaceFactory_buildAsLaplace(self, *args)

    def __init__(self, *args):
        _dist_bundle2.LaplaceFactory_swiginit(self, _dist_bundle2.new_LaplaceFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_LaplaceFactory

# Register LaplaceFactory in _dist_bundle2:
_dist_bundle2.LaplaceFactory_swigregister(LaplaceFactory)
class LeastSquaresDistributionFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Least squares factory.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The distribution defining the parametric model :math:`p_{\vect{\theta}}` to be adjusted to data.

    Notes
    -----
    The method fits a scalar distribution to data of dimension 1, using a least-squares minimization method.

    Let us denote :math:`(\vect{x}_1, \dots, \vect{x}_n)` the sample, :math:`F_{\vect{\theta}}`
    the  cumulative distribution function we want to fit to the sample,
    and :math:`\vect{\theta} \in  \Theta \subset\Rset^p`  its parameter vector.

    let :math:`\hat{F}` denote the empirical cumulative distribution function built from the sample.


    The estimator :math:`\hat{\theta}` minimizes the mean square error between
    :math:`F_{\vect{\theta}}` and :math:`\hat{F}` on the empirical quantiles.It is defined as:

    .. math::

        \hat{\theta} = \argmin_{\vect{\theta} \in \Theta} \sum_{i=1}^{n} \left( F_{\vect{\theta}}(\vect{x}_i) - F_{\hat{\vect{\theta}}}(\vect{x}_i) \right) ^2

    See also
    --------
    DistributionFactory

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal(0.9, 1.7)
    >>> sample = distribution.getSample(10)
    >>> factory = ot.LeastSquaresDistributionFactory(ot.Normal())
    >>> inf_distribution = factory.build(sample)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_getClassName(self)

    def __repr__(self):
        return _dist_bundle2.LeastSquaresDistributionFactory___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.LeastSquaresDistributionFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_build(self, *args)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_getOptimizationAlgorithm(self)

    def setOptimizationBounds(self, optimizationBounds):
        r"""
        Accessor to the optimization bounds.

        Parameters
        ----------
        problem : :class:`~openturns.Interval`
            The bounds used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_setOptimizationBounds(self, optimizationBounds)

    def getOptimizationBounds(self):
        r"""
        Accessor to the optimization bounds.

        Returns
        -------
        problem : :class:`~openturns.Interval`
            The bounds used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_getOptimizationBounds(self)

    def setOptimizationInequalityConstraint(self, optimizationInequalityConstraint):
        r"""
        Accessor to the optimization inequality constraint.

        Parameters
        ----------
        inequalityConstraint : :class:`~openturns.Function`
            The inequality constraint used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_setOptimizationInequalityConstraint(self, optimizationInequalityConstraint)

    def setKnownParameter(self, values, positions):
        r"""
        Accessor to the known parameters.

        Parameters
        ----------
        values : sequence of float
            Values of fixed parameters.
        indices : sequence of int
            Indices of fixed parameters.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Beta(2.3, 4.5, -1.0, 1.0)
        >>> sample = distribution.getSample(10)
        >>> factory = ot.LeastSquaresDistributionFactory(ot.Beta())
        >>> # set (a,b) out of (r, t, a, b)
        >>> factory.setKnownParameter([-1.0, 1.0], [2, 3])
        >>> inf_distribution = factory.build(sample)
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_setKnownParameter(self, values, positions)

    def getKnownParameterValues(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        values : :class:`~openturns.Point`
            Values of fixed parameters.
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_getKnownParameterValues(self)

    def getKnownParameterIndices(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of fixed parameters.
        """
        return _dist_bundle2.LeastSquaresDistributionFactory_getKnownParameterIndices(self)

    def __init__(self, *args):
        _dist_bundle2.LeastSquaresDistributionFactory_swiginit(self, _dist_bundle2.new_LeastSquaresDistributionFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_LeastSquaresDistributionFactory

# Register LeastSquaresDistributionFactory in _dist_bundle2:
_dist_bundle2.LeastSquaresDistributionFactory_swigregister(LeastSquaresDistributionFactory)
class Logistic(openturns.model_copula.ContinuousDistribution):
    r"""
    Logistic distribution.

    Parameters
    ----------
    mu : float
        Mean parameter :math:`\mu`.

        Default value is 1.0.
    beta : float, :math:`\beta > 0`
        Scale parameter :math:`\beta`.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{\exp\left(\left(- \frac{x - \mu}{\beta}\right)\right)}
                      {\beta \left(1 + \exp\left(- \frac{x-\mu}{\beta}
                                                 \right)\right)^2},
                 \quad x \in \Rset

    with :math:`\mu \in \Rset` and :math:`\beta > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \mu \\
            \Var{X} & = & \frac{1}{3} \pi^2 \beta^2
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Logistic(0.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Logistic_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.Logistic___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.Logistic___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.Logistic___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.Logistic_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Logistic_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Logistic_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.Logistic_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Logistic_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.Logistic_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle2.Logistic_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Logistic_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.Logistic_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Logistic_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Logistic_computeCDFGradient(self, *args)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle2.Logistic_getRoughness(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.Logistic_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.Logistic_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.Logistic_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.Logistic_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.Logistic_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.Logistic_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.Logistic_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.Logistic_isElliptical(self)

    def setMu(self, mu):
        r"""
        Accessor to the distribution's mean parameter :math:`\mu`.

        Parameters
        ----------
        mu : float, :math:`\mu \in \Rset`
            Mean parameter :math:`\mu`.
        """
        return _dist_bundle2.Logistic_setMu(self, mu)

    def getMu(self):
        r"""
        Accessor to the distribution's mean parameter :math:`\mu`.

        Returns
        -------
        mu : float
            Mean parameter :math:`\mu`.
        """
        return _dist_bundle2.Logistic_getMu(self)

    def setBeta(self, beta):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`\beta > 0`
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle2.Logistic_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Returns
        -------
        beta : float
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle2.Logistic_getBeta(self)

    def __init__(self, *args):
        _dist_bundle2.Logistic_swiginit(self, _dist_bundle2.new_Logistic(*args))
    __swig_destroy__ = _dist_bundle2.delete_Logistic

# Register Logistic in _dist_bundle2:
_dist_bundle2.Logistic_swigregister(Logistic)
class LogisticFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Logistic factory.

    Notes
    -----
    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\alpha} = \bar{x}\\
          \displaystyle\Hat{\beta} = \Hat{\sigma}_x
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, Logistic
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogisticFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.LogisticFactory_build(self, *args)

    def buildEstimator(self, *args):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle2.LogisticFactory_buildEstimator(self, *args)

    def buildAsLogistic(self, *args):
        r"""
        Estimate the distribution as native distribution.


        **Available usages**:

            buildAsLogistic()

            buildAsLogistic(*sample*)

            buildAsLogistic(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Logistic`.

        Returns
        -------
        distribution : :class:`~openturns.Logistic`
            The estimated distribution as a Logistic.

            In the first usage, the default Logistic distribution is built.
        """
        return _dist_bundle2.LogisticFactory_buildAsLogistic(self, *args)

    def __init__(self, *args):
        _dist_bundle2.LogisticFactory_swiginit(self, _dist_bundle2.new_LogisticFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_LogisticFactory

# Register LogisticFactory in _dist_bundle2:
_dist_bundle2.LogisticFactory_swigregister(LogisticFactory)
class LogNormal(openturns.model_copula.ContinuousDistribution):
    r"""
    Lognormal distribution.


    Parameters
    ----------
    muLog : float
        Location parameter :math:`\mu_\ell`, the expectation of the logarithm of the log-normal random variable.

        Default value is 0.0.
    sigmaLog : float, :math:`\sigma_\ell > 0`
        Scale parameter :math:`\sigma_\ell`, the standard deviation of the logarithm of the log-normal random variable.

        Default value is 1.0.
    gamma : float, optional
        Location parameter :math:`\gamma < \mu`.

        Default value is 0.0.

    Notes
    -----
    If :math:`X` follows a LogNormal distribution parametered by :math:`(\mu_\ell, \sigma_\ell)`, then
    :math:`\log X` follows a normal distribution whose mean is :math:`\mu_\ell` and whose variance is
    :math:`\sigma_\ell^2`.

    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{1}{\sqrt{2\pi}\sigma_\ell (x - \gamma)}
                 \exp\left(- \frac{1}{2}
                           \left(\frac{\log(x - \gamma) - \mu_\ell}
                                      {\sigma_\ell}\right)^2\right),
                 \quad x \in [\gamma; +\infty[

    with :math:`\gamma, \mu_\ell \in \Rset` and :math:`\sigma_\ell > 0`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \exp\left(\mu_\ell + \sigma_\ell^2 / 2\right) + \gamma \\
            \Var{X} & = & \exp\left(2 \mu_\ell + \sigma_\ell^2\right)
                          \left(\exp(\sigma_\ell^2) - 1\right)
        \end{eqnarray*}


    It is possible to create a LogNormal distribution from the alternative parametrizations :math:`(\mu, \sigma, \gamma)`: see  :class:`~openturns.LogNormalMuSigma` or :math:`(\mu, \sigma / \mu, \gamma)`: see  :class:`~openturns.LogNormalMuSigmaOverMu`. In that case, all the results are presented in that new parametrization.

    In order to use the alternative  parametrization only to create the distribution, see the example below: all the results will be presented in the native parametrization :math:`(\mu_\ell, \sigma_\ell, \gamma)`.

    Examples
    --------
    Create a distribution from its native parameters :math:`(\mu_\ell, \sigma_\ell, \gamma)`:

    >>> import openturns as ot
    >>> myDist = ot.LogNormal(1.0, 1.0, 0.0)

    Create a it from the alternative parametrization :math:`(\mu, \sigma, \gamma)`:

    >>> myDist2 = ot.LogNormal()
    >>> myDist2.setParameter(ot.LogNormalMuSigma()([4.5, 5.8, 0.0]))

    Create a it from the alternative parametrization :math:`(\mu, \sigma/\mu, \gamma)`:

    >>> myDist3 = ot.LogNormal()
    >>> myDist3.setParameter(ot.LogNormalMuSigmaOverMu()([4.5, 1.3, 0.0]))

    Create it from :math:`(\mu, \sigma, \gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.LogNormalMuSigma(4.5, 5.8, 0.0)
    >>> myDist4 = ot.ParametrizedDistribution(myParam)

    Create it from :math:`(\mu, \sigma/\mu, \gamma)` and keep that parametrization for the remaining study: 

    >>> myParam = ot.LogNormalMuSigmaOverMu(4.5, 1.3, 0.0)
    >>> myDist5 = ot.ParametrizedDistribution(myParam)

    Draw a sample:

    >>> sample = myDist.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogNormal_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.LogNormal___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.LogNormal___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.LogNormal___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.LogNormal_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.LogNormal_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.LogNormal_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.LogNormal_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.LogNormal_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.LogNormal_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle2.LogNormal_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.LogNormal_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.LogNormal_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.LogNormal_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.LogNormal_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.LogNormal_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.LogNormal_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.LogNormal_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.LogNormal_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.LogNormal_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.LogNormal_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.LogNormal_getParameterDescription(self)

    def setMuLog(self, muLog):
        r"""
        Accessor to the distribution's location parameter :math:`\mu_\ell`.

        Parameters
        ----------
        mu_log : float, :math:`\mu_\ell \in \Rset`
            Location parameter :math:`\mu_\ell`.
        """
        return _dist_bundle2.LogNormal_setMuLog(self, muLog)

    def getMuLog(self):
        r"""
        Accessor to the distribution's location parameter :math:`\mu_\ell`.

        Returns
        -------
        mu_log : float
            Location parameter :math:`\mu_\ell`.
        """
        return _dist_bundle2.LogNormal_getMuLog(self)

    def setSigmaLog(self, sigmaLog):
        r"""
        Accessor to the distribution's scale parameter :math:`\sigma_\ell`.

        Parameters
        ----------
        sigma_log : float, :math:`\sigma_\ell > 0`
            Scale parameter :math:`\sigma_\ell`.
        """
        return _dist_bundle2.LogNormal_setSigmaLog(self, sigmaLog)

    def getSigmaLog(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\sigma_\ell`.

        Returns
        -------
        sigma_log : float
            Scale parameter :math:`\sigma_\ell`.
        """
        return _dist_bundle2.LogNormal_getSigmaLog(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Parameters
        ----------
        gamma : float, :math:`\gamma < \mu`
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle2.LogNormal_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the distribution's location parameter :math:`\gamma`.

        Returns
        -------
        gamma : float
            Location parameter :math:`\gamma`.
        """
        return _dist_bundle2.LogNormal_getGamma(self)

    def __init__(self, *args):
        _dist_bundle2.LogNormal_swiginit(self, _dist_bundle2.new_LogNormal(*args))
    __swig_destroy__ = _dist_bundle2.delete_LogNormal

# Register LogNormal in _dist_bundle2:
_dist_bundle2.LogNormal_swigregister(LogNormal)
class LogNormalFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Lognormal factory distribution.

    See also
    --------
    DistributionFactory, LogNormal

    Notes
    -----
    Several estimators to build a LogNormal distribution from a scalar sample
    are proposed. The default strategy is using the local likelihood maximum estimator.

    **Moments based estimator:**

    Lets denote:

    - :math:`\displaystyle \overline{x}_n = \frac{1}{n} \sum_{i=1}^n x_i` the empirical
      mean of the sample, 
    - :math:`\displaystyle s_n^2 = \frac{1}{n-1} \sum_{i=1}^n (x_i - \overline{x}_n)^2`
      its empirical variance,
    - :math:`\displaystyle a_{3,n} = \sqrt{n} \frac{\sum_{i=1}^n (x_i - \overline{x}_n)^3}{ \left( \sum_{i=1}^n (x_i - \overline{x}_n)^2 \right)^{3/2}}`
      its empirical skewness.

    We note :math:`\omega = e^{\sigma_l^2}`. The estimator :math:`\hat{\omega}_n` of
    :math:`\omega` is the positive root of the relation:

    .. math::
        :label: omega_moment_relation

        \omega^3 + 3 \omega^2 - (4 + a_{3,n}^2) = 0

    Then we estimate :math:`(\hat{\mu}_{ln}, \hat{\sigma}_{ln}, \hat{\gamma}_{n})`
    using:

    .. math::
        :label: moment_estimator

        \hat{\mu}_{ln} &= \log \hat{\beta}_{n} \\
        \hat{\sigma}_{ln} &= \sqrt{ \log \hat{\omega}_{n} } \\
        \hat{\gamma}_{ln} &= \overline{x}_n - \hat{\beta}_{n} \sqrt{ \hat{\omega}_{n} }

    where :math:`\displaystyle \hat{\beta}_{n} = \frac{s_n}{\hat{\omega}_{n} (\hat{\omega}_{n} - 1)}`.

    **Modified moments based estimator:**

    Using :math:`\overline{x}_n` and :math:`s_n^2` previously defined, the third
    equation is:

    .. math::
        :label: expected_modified_moment

        \Eset[ \log (X_{(1)} - \gamma)] = \log (x_{(1)} - \gamma)

    The quantity :math:`\displaystyle EZ_1 (n) = \frac{\Eset[ \log (X_{(1)} - \gamma)] - \mu_l}{\sigma_l}`
    is the mean of the first order statistics of a standard normal sample of size
    :math:`n`. We have:

    .. math::
        :label: EZ1_equation

        EZ_1(n) = \int_\Rset nz\phi(z) (1 - \Phi(z))^{n-1}\di{z}

    where :math:`\varphi` and :math:`\Phi` are the PDF and CDF of the standard
    normal distribution. The estimator :math:`\hat{\omega}_{n}` of :math:`\omega` is
    obtained as the solution of:

    .. math::
        :label: omega_modified_moment_relation

        \omega (\omega - 1) - \kappa_n \left[ \sqrt{\omega} - e^{EZ_1(n)\sqrt{\log \omega}} \right]^2 = 0

    where :math:`\displaystyle \kappa_n = \frac{s_n^2}{(\overline{x}_n - x_{(1)})^2}`.
    Then we have :math:`(\hat{\mu}_{ln}, \hat{\sigma}_{ln}, \hat{\gamma}_{n})` using
    the relations defined for the moments based estimator :eq:`moment_estimator`.

    **Local maximum likelihood estimator:**

    The following sums are defined:

    .. math::

        S_0 &= \sum_{i=1}^n \frac{1}{x_i - \gamma} \\
        S_1 &= \sum_{i=1}^n \log (x_i - \gamma) \\
        S_2 &= \sum_{i=1}^n \log^2 (x_i - \gamma) \\
        S_3 &= \sum_{i=1}^n \frac{\log (x_i - \gamma)}{x_i - \gamma}

    The Maximum Likelihood estimator of :math:`(\mu_{l}, \sigma_{l}, \gamma)` is 
    defined by:

    .. math::
        :label: ln_mll_estimator

        \hat{\mu}_{l,n} &= \frac{S_1(\hat{\gamma})}{n} \\
        \hat{\sigma}_{l,n}^2 &= \frac{S_2(\hat{\gamma})}{n} - \hat{\mu}_{l,n}^2

    Thus, :math:`\hat{\gamma}_n` satisfies the relation:

    .. math::
        :label: ln_mll_relation

        S_0 (\gamma) \left(S_2(\gamma) - S_1(\gamma) \left( 1 + \frac{S_1(\gamma)}{n} \right) \right) + n S_3(\gamma) = 0

    under the constraint :math:`\gamma \leq \min x_i`.

    **Least squares method estimator:**

    The parameter :math:`\gamma` is numerically optimized by non-linear least-squares:

    .. math::

        \min{\gamma} \norm{\Phi^{-1}(\hat{F}_n(x_i)) - (a_1 \log(x_i - \gamma) + a_0)}_2^2

    where :math:`a_0, a_1` are computed from linear least-squares at each optimization evaluation.

    When :math:`\gamma` is known and the :math:`x_i` follow a Log-Normal distribution then
    we use linear least-squares to solve the relation:

    .. math::
      :label: least_squares_estimator_lognormal

        \Phi^{-1}(\hat{F}_n(x_i)) = a_1 \log(x_i - \gamma) + a_0

    And the remaining parameters are estimated with:

    .. math::

        \hat{\sigma}_l &= \frac{1}{a_1}\\
        \hat{\mu}_l &= -a_0 \hat{\sigma}_l

    Examples
    --------

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.LogNormal(1.5, 2.5, -1.5).getSample(1000)
    >>> estimated = ot.LogNormalFactory().build(sample)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogNormalFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*sample, method*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.
        method : integer
            An integer corresponding to a specific estimator method:

            - 0 : Local likelihood maximum estimator
            - 1 : Modified moment estimator
            - 2 : Method of moment estimator
            - 3 : Least squares method.

            The default value is 0. It is stored in :class:`~openturns.ResourceMap`, key *LogNormalFactory-EstimationMethod*. 

        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The built distribution.

        Notes
        -----
        See the :meth:`buildAsLogNormal` method.

        """
        return _dist_bundle2.LogNormalFactory_build(self, *args)

    def buildAsLogNormal(self, *args):
        r"""
        Build the distribution as a LogNormal type.

        **Available usages**:

            buildAsLogNormal()

            buildAsLogNormal(*sample*)

            buildAsLogNormal(*sample, method*)

            buildAsLogNormal(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.
        method : integer
            An integer ranges from 0 to 2 corresponding to a specific estimator method:

            - 0 : Local likelihood maximum estimator
            - 1 : Modified moment estimator
            - 2 : Method of moment estimator
            - 3 : Least squares method.

            Default value is 0. It is stored in  :class:`~openturns.ResourceMap`, key `LogNormalFactory-EstimationMethod`. 
        param : Collection of :class:`~openturns.PointWithDescription`
            A vector of parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.LogNormal`
            The estimated distribution as a LogNormal.

        Notes
        -----
        In the first usage, the default :class:`~openturns.LogNormal` distribution is built.

        In the second usage, the parameters are evaluated according the following strategy:

        - It first uses the local likelihood maximum based estimator. 
        - It uses the modified moments based estimator if the resolution of
          :eq:`ln_mll_relation` is not possible.
        - It uses the moments based estimator, which are always defined, if
          the resolution of :eq:`omega_modified_moment_relation` is not possible.

        In the third usage, the parameters of the :class:`~openturns.LogNormal` are estimated using the given method.

        In the fourth usage, a :class:`~openturns.LogNormal` distribution corresponding to the given parameters is built.
        """
        return _dist_bundle2.LogNormalFactory_buildAsLogNormal(self, *args)

    def buildMethodOfMoments(self, sample):
        r"""
        Build the distribution based on the method of moments estimator.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.

        Returns
        -------
        dist : :class:`~openturns.LogNormal`
            The built distribution.
        """
        return _dist_bundle2.LogNormalFactory_buildMethodOfMoments(self, sample)

    def buildMethodOfLocalLikelihoodMaximization(self, sample):
        r"""
        Build the distribution based on the local likelihood maximum estimator.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.

        Returns
        -------
        dist : :class:`~openturns.LogNormal`
            The built distribution.
        """
        return _dist_bundle2.LogNormalFactory_buildMethodOfLocalLikelihoodMaximization(self, sample)

    def buildMethodOfModifiedMoments(self, sample):
        r"""
        Build the distribution based on the modified moments estimator.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.

        Returns
        -------
        dist : :class:`~openturns.LogNormal`
            The built distribution.
        """
        return _dist_bundle2.LogNormalFactory_buildMethodOfModifiedMoments(self, sample)

    def buildMethodOfLeastSquares(self, sample):
        r"""
        Build the distribution based on the least-squares estimator.

        Parameters
        ----------
        sample : 2-d sequence of float, of dimension 1
            The sample from which the distribution parameters are estimated.
        gamma : float, optional
            The :math:`\gamma` parameter estimate

        Returns
        -------
        dist : :class:`~openturns.LogNormal`
            The built distribution.
        """
        return _dist_bundle2.LogNormalFactory_buildMethodOfLeastSquares(self, sample)

    def __init__(self, *args):
        _dist_bundle2.LogNormalFactory_swiginit(self, _dist_bundle2.new_LogNormalFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_LogNormalFactory

# Register LogNormalFactory in _dist_bundle2:
_dist_bundle2.LogNormalFactory_swigregister(LogNormalFactory)
class LogNormalMuErrorFactor(openturns.model_copula.DistributionParametersImplementation):
    r"""
    LogNormal distribution parameters.

    Parameters
    ----------
    mu : float
        The mean of the log-normal random variable.
    EF : float
        The error factor, :math:`EF > 1`
    gamma : float, optional
        Location parameter.

    Notes
    -----
    The :math:`EF` parameter is defined as:

    .. math::

        EF = \sqrt{\frac{q_{95} - \gamma}{q_{5} - \gamma}} = \exp{\sigma_{l} q_{95}^N}

    with :math:`q_5` :math:`q_95` the quantiles of the log-normal and
    :math:`q_{95}^N` the centered and reduced gaussian quantile.


    See also
    --------
    LogNormal

    Examples
    --------
    Create the parameters of the LogNormal distribution:

    >>> import openturns as ot
    >>> parameters = ot.LogNormalMuErrorFactor(0.63, 1.5, -0.5)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [0.63,0.246505,-0.5]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogNormalMuErrorFactor_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.LogNormalMuErrorFactor___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle2.LogNormalMuErrorFactor_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle2.LogNormalMuErrorFactor_gradient(self)

    def __call__(self, inP):
        return _dist_bundle2.LogNormalMuErrorFactor___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle2.LogNormalMuErrorFactor_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuErrorFactor_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuErrorFactor_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle2.LogNormalMuErrorFactor_getDescription(self)

    def __repr__(self):
        return _dist_bundle2.LogNormalMuErrorFactor___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.LogNormalMuErrorFactor___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle2.LogNormalMuErrorFactor_swiginit(self, _dist_bundle2.new_LogNormalMuErrorFactor(*args))
    __swig_destroy__ = _dist_bundle2.delete_LogNormalMuErrorFactor

# Register LogNormalMuErrorFactor in _dist_bundle2:
_dist_bundle2.LogNormalMuErrorFactor_swigregister(LogNormalMuErrorFactor)
class LogNormalMuSigma(openturns.model_copula.DistributionParametersImplementation):
    r"""
    LogNormal distribution parameters.

    Parameters
    ----------
    mu : float
        The mean of the LogNormal random variable.

        Default value is :math:`e^{0.5}`.
    sigma : float
        The standard deviation of the LogNormal random variable, with :math:`\sigma > 0`.

        Default value is :math:`\sqrt{e^{2}-e}`.
    gamma : float, optional
        Location parameter.

        Default value is 0.0.

    Notes
    -----
    Let :math:`X` be a random variable that follows a LogNormal distribution
    such that:

    .. math::

        \Expect{X} &= \mu \\
        \Var{X} &= \sigma^2

    The native parameters of :math:`X` are :math:`\mu_\ell`
    and :math:`\sigma_\ell`, which are such that :math:`\log X` follows a normal distribution
    whose mean is :math:`\mu_\ell` and whose variance is :math:`\sigma_\ell^2`. Then we have:

    .. math::

        \sigma_\ell &= \sqrt{\log{ \left( 1+\frac{\sigma^2}{(\mu-\gamma)^2} \right) }} \\
        \mu_\ell &= \log{(\mu-\gamma)} - \frac{\sigma_\ell^2}{2}

    The default values of :math:`(\mu, \sigma, \gamma)` are defined so that the associated native parameters
    have the default values: :math:`(\mu_\ell, \sigma_\ell, \gamma_\ell) = (0.0, 1.0, 0.0)`.

    See also
    --------
    LogNormal

    Examples
    --------
    Create the parameters of the LogNormal distribution:

    >>> import openturns as ot
    >>> parameters = ot.LogNormalMuSigma(0.63, 3.3, -0.5)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [-1.00492,1.50143,-0.5]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  1.67704  -0.527552  0        ]
     [ -0.271228  0.180647  0        ]
     [ -1.67704   0.527552  1        ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogNormalMuSigma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.LogNormalMuSigma___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle2.LogNormalMuSigma_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle2.LogNormalMuSigma_gradient(self)

    def __call__(self, inP):
        return _dist_bundle2.LogNormalMuSigma___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle2.LogNormalMuSigma_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuSigma_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuSigma_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle2.LogNormalMuSigma_getDescription(self)

    def __repr__(self):
        return _dist_bundle2.LogNormalMuSigma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.LogNormalMuSigma___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle2.LogNormalMuSigma_swiginit(self, _dist_bundle2.new_LogNormalMuSigma(*args))
    __swig_destroy__ = _dist_bundle2.delete_LogNormalMuSigma

# Register LogNormalMuSigma in _dist_bundle2:
_dist_bundle2.LogNormalMuSigma_swigregister(LogNormalMuSigma)
class LogNormalMuSigmaOverMu(openturns.model_copula.DistributionParametersImplementation):
    r"""
    LogNormal distribution parameters.

    Parameters
    ----------
    mu : float
        Mean :math:`\mu > 0`.

        Default value is :math:`e^{0.5}`.
    delta : float
        Variation coefficient :math:`\delta = \frac{\sigma}{\mu}`.

        Default value is :math:`(\sqrt{e^{2}-e})e^{-0.5}`.
    gamma : float, optional
        Location parameter.

        Default value is 0.0.

    Notes
    -----

    Let :math:`X` be a random variable that follows a LogNormal distribution
    such that:

    .. math::

        \Expect{X} &= \mu \\
        \Var{X} &= \sigma^2

    The native parameters of :math:`X` are :math:`\mu_\ell`
    and :math:`\sigma_\ell`, which are such that :math:`\log X` follows a normal distribution
    whose mean is :math:`\mu_\ell` and whose variance is :math:`\sigma_\ell^2`. Then we have:

    .. math::

        \sigma_l &= \sqrt{\log{ \left(1+\frac{(\delta \mu)^2}{(\mu-\gamma)^2} \right)}}\\
        \mu_l &= \log{(\mu-\gamma)} - \frac{\sigma_l^2}{2}

    The default values of :math:`(\mu, \delta, \gamma)` are defined so that the associated native parameters
    have the default values: :math:`(\mu_\ell, \sigma_\ell, \gamma_\ell) = (0.0, 1.0, 0.0)`.

    See also
    --------
    LogNormal

    Examples
    --------
    Create the parameters of the LogNormal distribution:

    >>> import openturns as ot
    >>> parameters = ot.LogNormalMuSigmaOverMu(0.63, 5.24, -0.5)

    Convert parameters into the native parameters:

    >>> print(parameters.evaluate())
    [-1.00525,1.50164,-0.5]

    The gradient of the transformation of the native parameters into the new
    parameters:

    >>> print(parameters.gradient())
    [[  0.256272  0.418663  0        ]
     [ -0.170824  0.113758  0        ]
     [ -1.6771    0.527516  1        ]]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.LogNormalMuSigmaOverMu___eq__(self, *args)

    def getDistribution(self):
        r"""
        Build a distribution based on a set of native parameters.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            Distribution built with the native parameters.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_getDistribution(self)

    def gradient(self):
        r"""
        Get the gradient.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            The gradient of the transformation of the native parameters into the new
            parameters.

        Notes
        -----

        If we note :math:`(p_1, \dots, p_q)` the native parameters and :math:`(p'_1, \dots, p'_q)` the new ones, then the gradient matrix is :math:`\left( \dfrac{\partial p'_i}{\partial p_j} \right)_{1 \leq i,j \leq  q}`.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_gradient(self)

    def __call__(self, inP):
        return _dist_bundle2.LogNormalMuSigmaOverMu___call__(self, inP)

    def inverse(self, inP):
        r"""
        Convert to native parameters.

        Parameters
        ----------
        inP : sequence of float
            The non-native parameters.

        Returns
        -------
        outP : :class:`~openturns.Point`
            The native parameters.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_inverse(self, inP)

    def setValues(self, values):
        r"""
        Accessor to the parameters values.

        Parameters
        ----------
        values : sequence of float
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_setValues(self, values)

    def getValues(self):
        r"""
        Accessor to the parameters values.

        Returns
        -------
        values : :class:`~openturns.Point`
            List of parameters values.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_getValues(self)

    def getDescription(self):
        r"""
        Get the description of the parameters.

        Returns
        -------
        collection : :class:`~openturns.Description`
            List of parameters names.
        """
        return _dist_bundle2.LogNormalMuSigmaOverMu_getDescription(self)

    def __repr__(self):
        return _dist_bundle2.LogNormalMuSigmaOverMu___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.LogNormalMuSigmaOverMu___str__(self, *args)

    def __init__(self, *args):
        _dist_bundle2.LogNormalMuSigmaOverMu_swiginit(self, _dist_bundle2.new_LogNormalMuSigmaOverMu(*args))
    __swig_destroy__ = _dist_bundle2.delete_LogNormalMuSigmaOverMu

# Register LogNormalMuSigmaOverMu in _dist_bundle2:
_dist_bundle2.LogNormalMuSigmaOverMu_swigregister(LogNormalMuSigmaOverMu)
class LogUniform(openturns.model_copula.ContinuousDistribution):
    r"""
    LogUniform distribution.

    Parameters
    ----------
    a_log : float
        Lower bound in log-scale.

        Default value is -1.0.
    b_log : float, :math:`b_\ell > a_\ell`
        Upper bound in log-scale.

        Default value is 1.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{1}{x (b_\ell - a_\ell)},
                 \quad \log(x) \in [a_\ell; b_\ell]

    with :math:`a_\ell < b_\ell`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{b - a}{b_\ell - a_\ell} \\
            \Var{X} & = & \frac{1}{2} (b - a)
                          \frac{  b (b_\ell - a_\ell - 2)
                                + a (b_\ell - a_\ell + 2)}
                               {(b_\ell - a_\ell)^2}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.LogUniform(-1.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogUniform_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.LogUniform___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.LogUniform___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.LogUniform___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.LogUniform_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.LogUniform_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.LogUniform_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.LogUniform_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.LogUniform_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle2.LogUniform_computeEntropy(self)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.LogUniform_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.LogUniform_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.LogUniform_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.LogUniform_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.LogUniform_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.LogUniform_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.LogUniform_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.LogUniform_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.LogUniform_getParameterDescription(self)

    def setALog(self, aLog):
        r"""
        Accessor to the distribution's lower bound in log-scale :math:`a_\ell`.

        Parameters
        ----------
        a_log : float, :math:`a_\ell < b_\ell`
            Lower bound in log-scale.
        """
        return _dist_bundle2.LogUniform_setALog(self, aLog)

    def getALog(self):
        r"""
        Accessor to the distribution's lower bound in log-scale :math:`a_\ell`.

        Returns
        -------
        a_log : float
            Lower bound in log-scale.
        """
        return _dist_bundle2.LogUniform_getALog(self)

    def setBLog(self, bLog):
        r"""
        Accessor to the distribution's upper bound in log-scale :math:`b_\ell`.

        Parameters
        ----------
        b_log : float, :math:`b_\ell > a_\ell`
            Upper bound in log-scale.
        """
        return _dist_bundle2.LogUniform_setBLog(self, bLog)

    def getBLog(self):
        r"""
        Accessor to the distribution's upper bound in log-scale :math:`b_\ell`.

        Returns
        -------
        b_log : float
            Upper bound in log-scale.
        """
        return _dist_bundle2.LogUniform_getBLog(self)

    def __init__(self, *args):
        _dist_bundle2.LogUniform_swiginit(self, _dist_bundle2.new_LogUniform(*args))
    __swig_destroy__ = _dist_bundle2.delete_LogUniform

# Register LogUniform in _dist_bundle2:
_dist_bundle2.LogUniform_swigregister(LogUniform)
class LogUniformFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Log Uniform factory.

    The parameters are estimated by method of moments:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{a}_n=(1-1/(2+n))x_{(1,n)}\\
          \displaystyle\Hat{b}_n=(1+1/(2+n))x_{(n,n)}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, LogUniform
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.LogUniformFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.LogUniformFactory_build(self, *args)

    def buildAsLogUniform(self, *args):
        r"""
        Estimate the distribution as native distribution.


        **Available usages**:

            buildAsLogUniform()

            buildAsLogUniform(*sample*)

            buildAsLogUniform(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float,
            Sample from which the distribution parameters are estimated.
        param : sequence of float,
           The parameters of the :class:`~openturns.LogUniform`.

        Returns
        -------
        distribution : :class:`~openturns.LogUniform`,
            The estimated distribution as a LogUniform.

            In the first usage, the default LogUniform distribution is built.
        """
        return _dist_bundle2.LogUniformFactory_buildAsLogUniform(self, *args)

    def __init__(self, *args):
        _dist_bundle2.LogUniformFactory_swiginit(self, _dist_bundle2.new_LogUniformFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_LogUniformFactory

# Register LogUniformFactory in _dist_bundle2:
_dist_bundle2.LogUniformFactory_swigregister(LogUniformFactory)
class MarginalDistribution(openturns.model_copula.DistributionImplementation):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MarginalDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.MarginalDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.MarginalDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.MarginalDistribution___str__(self, *args)

    def setDistribution(self, distribution):
        return _dist_bundle2.MarginalDistribution_setDistribution(self, distribution)

    def getDistribution(self):
        return _dist_bundle2.MarginalDistribution_getDistribution(self)

    def setIndices(self, indices):
        return _dist_bundle2.MarginalDistribution_setIndices(self, indices)

    def getIndices(self):
        return _dist_bundle2.MarginalDistribution_getIndices(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.MarginalDistribution_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle2.MarginalDistribution_getSample(self, size)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.MarginalDistribution_computeCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Survival function input(s).

        Returns
        -------
        S : float, :class:`~openturns.Point`
            Survival function value(s) at input(s) `x`.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` is defined as follows:

        .. math::


            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^d X_i > x_i}
                     \quad \forall \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function (except for
            1-dimensional distributions).

        See Also
        --------
        computeComplementaryCDF
        """
        return _dist_bundle2.MarginalDistribution_computeSurvivalFunction(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\vect{a}` and
        :math:`\vect{b}`:

        .. math::

            \Prob{\bigcap\limits_{i=1}^n a_i < X_i \leq b_i} =
                \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, n)}` with :math:`c_i \in [a_i, b_i]`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.MarginalDistribution_computeProbability(self, interval)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.MarginalDistribution_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.MarginalDistribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.MarginalDistribution_getKurtosis(self)

    def getSpearmanCorrelation(self):
        r"""
        Accessor to the Spearman correlation matrix.

        Returns
        -------
        R : :class:`~openturns.CorrelationMatrix`
            Spearman's correlation matrix.

        Notes
        -----
        Spearman's (rank) correlation is defined as the normalized covariance matrix
        of the copula (ie that of the uniform margins):

        .. math::

            \mat{\rho_S} = \left[\frac{\Cov{F_{X_i}(X_i), F_{X_j}(X_j)}}
                                      {\sqrt{\Var{F_{X_i}(X_i)} \Var{F_{X_j}(X_j)}}},
                                 \quad i,j = 1, \ldots, n\right]

        See Also
        --------
        getKendallTau
        """
        return _dist_bundle2.MarginalDistribution_getSpearmanCorrelation(self)

    def getKendallTau(self):
        r"""
        Accessor to the Kendall coefficients matrix.

        Returns
        -------
        tau: :class:`~openturns.SquareMatrix`
            Kendall coefficients matrix.

        Notes
        -----
        The Kendall coefficients matrix is defined as:

        .. math::

            \mat{\tau} = \Big[& \Prob{X_i < x_i \cap X_j < x_j
                                      \cup
                                      X_i > x_i \cap X_j > x_j} \\
                              & - \Prob{X_i < x_i \cap X_j > x_j
                                        \cup
                                        X_i > x_i \cap X_j < x_j},
                              \quad i,j = 1, \ldots, n\Big]

        See Also
        --------
        getSpearmanCorrelation
        """
        return _dist_bundle2.MarginalDistribution_getKendallTau(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.MarginalDistribution_getMarginal(self, *args)

    def getIsoProbabilisticTransformation(self):
        r"""
        Accessor to the iso-probabilistic transformation.

        Refer to :ref:`isoprobabilistic_transformation`.

        Returns
        -------
        T : :class:`~openturns.Function`
            Iso-probabilistic transformation.

        Notes
        -----
        The iso-probabilistic transformation is defined as follows:

        .. math::

            T: \left|\begin{array}{rcl}
                    \supp{\vect{X}} & \rightarrow & \Rset^n \\
                    \vect{x} & \mapsto & \vect{u}
               \end{array}\right.

        An iso-probabilistic transformation is a *diffeomorphism* [#diff]_ from
        :math:`\supp{\vect{X}}` to :math:`\Rset^d` that maps realizations
        :math:`\vect{x}` of a random vector :math:`\vect{X}` into realizations
        :math:`\vect{y}` of another random vector :math:`\vect{Y}` while
        preserving probabilities. It is hence defined so that it satisfies:

        .. math::
            :nowrap:

            \begin{eqnarray*}
                \Prob{\bigcap_{i=1}^d X_i \leq x_i}
                    & = & \Prob{\bigcap_{i=1}^d Y_i \leq y_i} \\
                F_{\vect{X}}(\vect{x})
                    & = & F_{\vect{Y}}(\vect{y})
            \end{eqnarray*}

        **The present** implementation of the iso-probabilistic transformation maps
        realizations :math:`\vect{x}` into realizations :math:`\vect{u}` of a
        random vector :math:`\vect{U}` with *spherical distribution* [#spherical]_.
        To be more specific:

            - if the distribution is elliptical, then the transformed distribution is
              simply made spherical using the **Nataf (linear) transformation**.
            - if the distribution has an elliptical Copula, then the transformed
              distribution is made spherical using the **generalized Nataf
              transformation**.
            - otherwise, the transformed distribution is the standard multivariate
              Normal distribution and is obtained by means of the **Rosenblatt
              transformation**.

        .. [#diff] A differentiable map :math:`f` is called a *diffeomorphism* if it
            is a bijection and its inverse :math:`f^{-1}` is differentiable as well.
            Hence, the iso-probabilistic transformation implements a gradient (and
            even a Hessian).

        .. [#spherical] A distribution is said to be *spherical* if it is invariant by
            rotation. Mathematically, :math:`\vect{U}` has a spherical distribution
            if:

            .. math::

                \mat{Q}\,\vect{U} \sim \vect{U},
                \quad \forall \mat{Q} \in \cO_n(\Rset)

        See also
        --------
        getInverseIsoProbabilisticTransformation, isElliptical, hasEllipticalCopula
        """
        return _dist_bundle2.MarginalDistribution_getIsoProbabilisticTransformation(self)

    def getInverseIsoProbabilisticTransformation(self):
        r"""
        Accessor to the inverse iso-probabilistic transformation.

        Returns
        -------
        Tinv : :class:`~openturns.Function`
            Inverse iso-probabilistic transformation.

        Notes
        -----
        The inverse iso-probabilistic transformation is defined as follows:

        .. math::

            T^{-1}: \left|\begin{array}{rcl}
                        \Rset^n & \rightarrow & \supp{\vect{X}} \\
                        \vect{u} & \mapsto & \vect{x}
                    \end{array}\right.

        See also
        --------
        getIsoProbabilisticTransformation
        """
        return _dist_bundle2.MarginalDistribution_getInverseIsoProbabilisticTransformation(self)

    def getStandardDistribution(self):
        r"""
        Accessor to the standard distribution.

        Returns
        -------
        standard_distribution : :class:`~openturns.Distribution`
            Standard distribution.

        Notes
        -----
        The standard distribution is determined according to the distribution
        properties. This is the target distribution achieved by the iso-probabilistic
        transformation.

        See Also
        --------
        getIsoProbabilisticTransformation
        """
        return _dist_bundle2.MarginalDistribution_getStandardDistribution(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MarginalDistribution_hasIndependentCopula(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MarginalDistribution_getParametersCollection(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle2.MarginalDistribution_hasEllipticalCopula(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.MarginalDistribution_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MarginalDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MarginalDistribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MarginalDistribution_isIntegral(self)

    def __init__(self, *args):
        _dist_bundle2.MarginalDistribution_swiginit(self, _dist_bundle2.new_MarginalDistribution(*args))
    __swig_destroy__ = _dist_bundle2.delete_MarginalDistribution

# Register MarginalDistribution in _dist_bundle2:
_dist_bundle2.MarginalDistribution_swigregister(MarginalDistribution)
class MaximumDistribution(openturns.model_copula.DistributionImplementation):
    r"""
    Maximum distribution.

    Available constructors:
        MaximumDistribution(*distribution*)

        MaximumDistribution(*collection*)

        MaximumDistribution(*distribution, size*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The underlying distribution.
    collection : sequence of :class:`~openturns.Distribution`
        A collection of pdfs.
    size : int
        Number of instances of distribution.

    Notes
    -----
    The maximum distribution of F is the distribution of :math:`X = max(X_1, ... , X_n)`
    where :math:`(X_1, ... , X_n) \sim F`

    .. math::

        \Prob{X\leq x}=\Prob{X_1\leq x,\dots,X_n\leq x}

    This simplifies to :math:`\Prob{X\leq x}=\prod_{i=1}^n F_i(x)`
    when :math:`X_1,\dots,X_n` are independent (second constructor) and finally
    it simplifies into :math:`F^n(x)` when the random variables are iid (third
    constructor).

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> coll = [ot.Uniform(2.5, 3.5), ot.LogUniform(1.0, 1.2), ot.Triangular(2.0, 3.0, 4.0)]
    >>> distribution = ot.MaximumDistribution(coll)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MaximumDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.MaximumDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.MaximumDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.MaximumDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.MaximumDistribution_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.MaximumDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.MaximumDistribution_computeCDF(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumDistribution_setParametersCollection(self, *args)

    def setDistribution(self, distribution):
        r"""
        Accessor to the underlying distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            The underlying distribution.
        """
        return _dist_bundle2.MaximumDistribution_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Accessor to the underlying distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The underlying distribution.
        """
        return _dist_bundle2.MaximumDistribution_getDistribution(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MaximumDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MaximumDistribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MaximumDistribution_isIntegral(self)

    def __init__(self, *args):
        _dist_bundle2.MaximumDistribution_swiginit(self, _dist_bundle2.new_MaximumDistribution(*args))
    __swig_destroy__ = _dist_bundle2.delete_MaximumDistribution

# Register MaximumDistribution in _dist_bundle2:
_dist_bundle2.MaximumDistribution_swigregister(MaximumDistribution)
class MaximumEntropyOrderStatisticsDistribution(openturns.model_copula.ContinuousDistribution):
    r"""
    MaximumEntropyOrderStatistics distribution.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.Distribution`
        The marginals, with range verifying :math:`a_i \leq a_{i+1}` and :math:`b_i \leq b_{i+1}`.
    useApproximation : bool
        Indicates whether the expression :math:`\Phi_k(t)` is approximated with a polynomials (Hermitte with degree 4 on a discretization determined by a Gauss-Kronrod algorithm applied to :math:`\Phi_k(t)`).
        By default, the approximation is used.
    checkMarginals : bool
        Indicates whether the compatibility tests on the marginals is done.
        By default, the tests are done.

    Notes
    -----
    Its realizations are ordered :math:`X_1 \leq \dots \leq X_n`.

    Its probability density function is defined as:

    .. math::

        f_X(x) = f_1(x_1) \prod\limits_{k=2}^d \phi_k(x_k) \exp\left(-\int_{x_{k-1}}^{x_k} \phi_k(s)\di{s}\right) \mathbf{1}_{x_1 \leq \dots \leq x_d}

                 \text{with } \phi_k(x_k) = \frac{f_k(x_k)}{F_{k-1}(x_k)-F_k(x_k)}

    We note:

    .. math::

        \Phi_k(t) = \exp\left(-\int_{a_{k}}^{t} \phi_k(s)\di{s}\right)

    The exponential factor :math:`\Phi_k(t)` may be expensive to compute for every value
    of :math:`t`. It can be replaced by a piecewise Hermite approximation using the
    following keys in :class:`~openturns.ResourceMap`:

    * 'MaximumEntropyOrderStatisticsDistribution-UseApproximation': if set to *True*, the approximation is built. The default value is *False*;
    * 'MaximumEntropyOrderStatisticsDistribution-SupportShift': a shift to avoid the discontinuities in :math:`\Phi_k(t)`. Its default value is *1e-15*;
    * 'MaximumEntropyOrderStatisticsDistribution-ExponentialFactorDiscretization': the maximum size of the adaptive discretization used to detect discontinuities using a 7/15 points Gauss-Kronrod integration method. Default value is *100*, which should give an absolute error of order *1e-8* for the approximation with no subdivision.
    * 'MaximumEntropyOrderStatisticsDistribution-MaximumApproximationSubdivision': each interval of the adapted grid is subdivided into a regular grid of this size to improve the accuracy. Default value is *2*, giving an absolute error of order *1e-9*.

    The approximation should be used *with caution*. There is no easy quantitative criterion to guide the choice, but either it works with a high degree of precision, or it fails producing negative values for the exponential factor. It occurs when two marginal distributions have almost the same range, eg two uniform distributions with range [0,1] and [0.038, 1.038].

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> coll = [ot.Uniform(-1.0, 1.0), ot.LogUniform(1.0, 1.2), ot.Triangular(3.0, 4.0, 5.0)]
    >>> distribution = ot.MaximumEntropyOrderStatisticsDistribution(coll)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution___str__(self, *args)

    def setDistributionCollection(self, *args):
        r"""
        Accessor to the distribution's collection.

        Parameters
        ----------
        coll : sequence
            The marginals.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_setDistributionCollection(self, *args)

    def getDistributionCollection(self):
        r"""
        Accessor to the distribution's collection.

        Returns
        -------
        coll : sequence
            The marginals.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getDistributionCollection(self)

    def getCopula(self):
        r"""
        Accessor to the copula of the distribution.

        Returns
        -------
        C : :class:`~openturns.Distribution`
            Copula of the distribution.

        See Also
        --------
        ComposedDistribution
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getCopula(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeCDF(self, *args)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeConditionalPDF(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \mid X_1, \ldots, X_{n - 1}}(x_n) =
                \Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}},
                \quad x_n \in \supp{X_n}
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`0 < p < 1`
            Conditional quantile function input.
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        X1 : float
            Conditional quantile at input :math:`p`, :math:`X_{cond}`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_computeConditionalQuantile(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getMarginal(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_setParametersCollection(self, *args)

    def useApproximation(self, flag=True):
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_useApproximation(self, flag)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_hasIndependentCopula(self)

    def getApproximation(self, k=0):
        return _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_getApproximation(self, k)

    def __init__(self, *args):
        _dist_bundle2.MaximumEntropyOrderStatisticsDistribution_swiginit(self, _dist_bundle2.new_MaximumEntropyOrderStatisticsDistribution(*args))
    __swig_destroy__ = _dist_bundle2.delete_MaximumEntropyOrderStatisticsDistribution

# Register MaximumEntropyOrderStatisticsDistribution in _dist_bundle2:
_dist_bundle2.MaximumEntropyOrderStatisticsDistribution_swigregister(MaximumEntropyOrderStatisticsDistribution)
class MaximumEntropyOrderStatisticsCopula(openturns.model_copula.SklarCopula):
    r"""
    MaximumEntropyOrderStatisticsCopula copula.

    Parameters
    ----------
    coll : sequence of :class:`~openturns.Distribution`
        The margins, with range verifying :math:`a_i \leq a_{i+1}` and :math:`b_i \leq b_{i+1}`.

        Default collection is [Unif(-1.0, 0.5), Unif(-0.5, 1.0)].

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_U(u) = \prod\limits_{k=2}^d \frac{\exp\left(-\int_{\partial_{k-1}^{-1}(u_{k-1})}^{\partial_k^{-1}(u_k)} \phi_k(s)\di{s}\right)}{\partial_{k-1}(\partial_k^{-1}(u_k))-u_k} \mathbf{1}_{F_1^{-1}(u_1) \leq \dots \leq F_d^{-1}(u_d)}

        \text{with } \partial_k(t) = F_k(G^{-1}(t)) \text{ and } G(t) = \frac{1}{t} \sum\limits_{k=1}^d F_k(t)

    This class is implemented as a :class:`~openturns.SklarCopula` of the underlying :class:`~openturns.MaximumEntropyOrderStatisticsDistribution`. See the documentation of these classes for the numerical details.

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> coll = [ot.Uniform(-1.0, 1.0), ot.LogUniform(1.0, 1.2), ot.Triangular(3.0, 4.0, 5.0)]
    >>> copulaOrderStat = ot.MaximumEntropyOrderStatisticsCopula(coll)

    Draw a sample:

    >>> sample = copulaOrderStat.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula___str__(self, *args)

    def setDistributionCollection(self, coll):
        r"""
        Accessor to the distribution's collection.

        Parameters
        ----------
        coll : sequence of :class:`~openturns.Distribution`
            The margins.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_setDistributionCollection(self, coll)

    def getDistributionCollection(self):
        r"""
        Accessor to the distribution's margins collection.

        Returns
        -------
        coll : sequence of :class:`~openturns.Distribution`
            The marginals.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getDistributionCollection(self)

    def getApproximation(self, k=0):
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getApproximation(self, k)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getMarginal(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_getParametersCollection(self)

    def setParametersCollection(self, *args):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.MaximumEntropyOrderStatisticsCopula_setParametersCollection(self, *args)

    def __init__(self, *args):
        _dist_bundle2.MaximumEntropyOrderStatisticsCopula_swiginit(self, _dist_bundle2.new_MaximumEntropyOrderStatisticsCopula(*args))
    __swig_destroy__ = _dist_bundle2.delete_MaximumEntropyOrderStatisticsCopula

# Register MaximumEntropyOrderStatisticsCopula in _dist_bundle2:
_dist_bundle2.MaximumEntropyOrderStatisticsCopula_swigregister(MaximumEntropyOrderStatisticsCopula)
class MaximumLikelihoodFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Maximum likelihood factory.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The parametric distribution :math:`p_{\vect{\theta}}`.

    Notes
    -----
    This class implements the generic maximum likelihood estimation
    which is detailed in :ref:`maximum_likelihood`.

    Let us denote :math:`(\vect{x}_1, \dots, \vect{x}_n)` the sample, :math:`p_{\vect{\theta}}`
    the density of the parametric distribution we want to fit to the sample, with the
    parameter vector :math:`\vect{\theta} \in \Theta \in \Rset^p` .


    The likelihood of the sample according to :math:`p_{\vect{\theta}}` is:

    .. math::

        L(\vect{x}_1, \dots, \vect{x}_n; \vect{\theta}) = \prod_{i=1}^n p_{\vect{\theta}}(\vect{x}_i)

    The log-likelihood is defined as:

    .. math::

        \ell(\vect{x}_1, \dots, \vect{x}_n; \vect{\theta}) = \sum_{i=1}^n \log p_{\vect{\theta}}(\vect{x}_i)

    The estimator of  :math:`\vect{\theta}` maximizes the log-likelihood:

    .. math::

        \hat{\vect{\theta}} = \argmax_{\vect{\theta} \in \Theta} \log \ell (\vect{x}_1, \dots, \vect{x}_n; \vect{\theta}) 

    See also
    --------
    DistributionFactory

    Examples
    --------

    In the following example, we estimate the parameters of a `Normal` distribution 
    with maximum likelihood estimation.

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal(0.9, 1.7)
    >>> sample = distribution.getSample(10)
    >>> factory = ot.MaximumLikelihoodFactory(ot.Normal())
    >>> inf_distribution = factory.build(sample)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MaximumLikelihoodFactory_getClassName(self)

    def __repr__(self):
        return _dist_bundle2.MaximumLikelihoodFactory___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.MaximumLikelihoodFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_build(self, *args)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the optimization solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for the optimization of the log-likelihood.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the optimization solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for the optimization of the log-likelihood.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_getOptimizationAlgorithm(self)

    def setOptimizationBounds(self, optimizationBounds):
        r"""
        Accessor to the optimization bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            The bounds used for the optimization of the log-likelihood.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_setOptimizationBounds(self, optimizationBounds)

    def getOptimizationBounds(self):
        r"""
        Accessor to the optimization bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            The bounds used for the optimization of the log-likelihood.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_getOptimizationBounds(self)

    def setOptimizationInequalityConstraint(self, optimizationInequalityConstraint):
        r"""
        Accessor to the optimization inequality constraint.

        Parameters
        ----------
        inequalityConstraint : :class:`~openturns.Function`
            The inequality constraint used for the optimization of the log-likelihood.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_setOptimizationInequalityConstraint(self, optimizationInequalityConstraint)

    def setKnownParameter(self, values, positions):
        r"""
        Accessor to the known parameters.

        Parameters
        ----------
        values : sequence of float
            Values of known parameters.
        positions : sequence of int
            Indices of known parameters.

        Examples
        --------
        When a subset of the parameter vector is known, the other parameters only have to be estimated 
        from data. 

        In the following example, we consider a sample and want to fit 
        a :class:`~openturns.Beta` distribution.  
        We assume that the :math:`a` and :math:`b` parameters are known beforehand. 
        In this case, we set the third parameter (at index 2) to -1 
        and the fourth parameter (at index 3) to 1. 

        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Beta(2.3, 2.2, -1.0, 1.0)
        >>> sample = distribution.getSample(10)
        >>> factory = ot.MaximumLikelihoodFactory(ot.Beta())
        >>> # set (a,b) out of (r, t, a, b)
        >>> factory.setKnownParameter([-1.0, 1.0], [2, 3])
        >>> inf_distribution = factory.build(sample)
        """
        return _dist_bundle2.MaximumLikelihoodFactory_setKnownParameter(self, values, positions)

    def getKnownParameterValues(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        values : :class:`~openturns.Point`
            Values of known parameters.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_getKnownParameterValues(self)

    def getKnownParameterIndices(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of the known parameters.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_getKnownParameterIndices(self)

    @staticmethod
    def BuildEstimator(factory, sample, isRegular=False):
        r"""
        Estimate the parameters  and the asymptotic distribution.


        Parameters
        ----------
        factory : :class:`~openturns.DistributionFactory`
            Distribution factory to infer the data


        sample : 2-d sequence of float
            Data to infer
        is_regular : bool
            Indicates whether the parametric distribution is regular.

        Returns
        -------
        result : :class:`~openturns.DistributionFactoryResult`
            Result class providing the estimate and the asymptotic distribution.

        Notes
        -----
        If the model is regular, the asymptotic distribution of the estimator is normal and we get it from the Delta method.

        If the model is not regular, we use the Bootstrap method and the kernel smoothing method to get the asymptotic distribution of the estimator.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_BuildEstimator(factory, sample, isRegular)

    @staticmethod
    def BuildGaussianEstimator(distribution, sample):
        r"""
        Compute the asymptotic distribution of the parameters.


        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            Parametric distribution.
        sample : 2-d sequence of float
            Data to infer.

        Returns
        -------
        distribution : :class:`~openturns.Normal`
            Asymptotic normal distribution of :math:`\hat{\vect{\theta}}`.

        Notes
        -----
        We assume that the parametric model is regular: then, the asymptotic distribution of :math:`\hat{\vect{\theta}}` is normal.
        """
        return _dist_bundle2.MaximumLikelihoodFactory_BuildGaussianEstimator(distribution, sample)

    def __init__(self, *args):
        _dist_bundle2.MaximumLikelihoodFactory_swiginit(self, _dist_bundle2.new_MaximumLikelihoodFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_MaximumLikelihoodFactory

# Register MaximumLikelihoodFactory in _dist_bundle2:
_dist_bundle2.MaximumLikelihoodFactory_swigregister(MaximumLikelihoodFactory)
class MeixnerDistribution(openturns.model_copula.ContinuousDistribution):
    r"""
    Meixner distribution.


    Parameters
    ----------
    beta : float, :math:`\beta > 0`
        Scale parameter.

        Default value is 1.0.
    alpha : float, :math:`\alpha \in [-\pi; \pi]`
        Skewness parameter.

        Default value is 0.0.
    delta : float, :math:`\delta > 0`
        Shape parameter.

        Default value is 1.0.
    gamma : float
        Position parameter :math:`\gamma`.

        Default value is 0.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{\left(2 \cos(\alpha / 2)\right)^{2 \delta}}
                      {2 \beta \pi \Gamma(2 \delta)}
                 \exp\left(\frac{\alpha (x - \gamma)}{\beta}\right)
                 \left|\Gamma\left(\delta + i \frac{x - \gamma}{\beta}
                                   \right)\right|^2,
                 \quad x \in \Rset

    with :math:`\beta, \delta > 0`, :math:`\alpha \in [-\pi; \pi]`,
    :math:`\gamma \in \Rset` and where :math:`i^2 = -1`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \beta \delta \tan(\alpha / 2) + \gamma \\
            \Var{X} & = & \frac{\beta^2 \delta}{1 + \cos(\alpha)}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.MeixnerDistribution(1.0, 0.0, 1.0, 0.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MeixnerDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.MeixnerDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.MeixnerDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.MeixnerDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.MeixnerDistribution_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.MeixnerDistribution_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.MeixnerDistribution_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.MeixnerDistribution_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.MeixnerDistribution_computeComplementaryCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.MeixnerDistribution_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.MeixnerDistribution_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.MeixnerDistribution_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.MeixnerDistribution_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.MeixnerDistribution_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.MeixnerDistribution_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.MeixnerDistribution_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.MeixnerDistribution_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.MeixnerDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.MeixnerDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.MeixnerDistribution_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.MeixnerDistribution_isElliptical(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the distribution's skewness parameter :math:`\alpha`.

        Parameters
        ----------
        alpha : float, :math:`\alpha \in [-\pi; \pi]`
            Skewness parameter :math:`\alpha`.
        """
        return _dist_bundle2.MeixnerDistribution_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Accessor to the distribution's skewness parameter :math:`\alpha`.

        Returns
        -------
        alpha : float
            Skewness parameter :math:`\alpha`.
        """
        return _dist_bundle2.MeixnerDistribution_getAlpha(self)

    def setBeta(self, beta):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Parameters
        ----------
        beta : float, :math:`\beta > 0`
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle2.MeixnerDistribution_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the distribution's scale parameter :math:`\beta`.

        Returns
        -------
        beta : float
            Scale parameter :math:`\beta`.
        """
        return _dist_bundle2.MeixnerDistribution_getBeta(self)

    def setDelta(self, delta):
        r"""
        Accessor to the distribution's shape parameter :math:`\delta`.

        Parameters
        ----------
        delta : float, :math:`\delta > 0`
            Shape parameter :math:`\delta`.
        """
        return _dist_bundle2.MeixnerDistribution_setDelta(self, delta)

    def getDelta(self):
        r"""
        Accessor to the distribution's shape parameter :math:`\delta`.

        Returns
        -------
        delta : float
            Shape parameter :math:`\delta`.
        """
        return _dist_bundle2.MeixnerDistribution_getDelta(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the distribution's position parameter :math:`\gamma`.

        Parameters
        ----------
        gamma : float, :math:`\gamma \in \Rset`
            Position parameter :math:`\gamma`.
        """
        return _dist_bundle2.MeixnerDistribution_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the distribution's position parameter :math:`\gamma`.

        Returns
        -------
        gamma : float
            Position parameter :math:`\gamma`.
        """
        return _dist_bundle2.MeixnerDistribution_getGamma(self)

    def getOptimizationAlgorithm(self):
        return _dist_bundle2.MeixnerDistribution_getOptimizationAlgorithm(self)

    def setOptimizationAlgorithm(self, solver):
        return _dist_bundle2.MeixnerDistribution_setOptimizationAlgorithm(self, solver)

    def __init__(self, *args):
        _dist_bundle2.MeixnerDistribution_swiginit(self, _dist_bundle2.new_MeixnerDistribution(*args))
    __swig_destroy__ = _dist_bundle2.delete_MeixnerDistribution

# Register MeixnerDistribution in _dist_bundle2:
_dist_bundle2.MeixnerDistribution_swigregister(MeixnerDistribution)
class MeixnerDistributionFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Meixner Distribution factory.

    Notes
    -----
    The parameters are estimated using the following moments estimators:

    .. math::
        :nowrap:

        \begin{align}
          \displaystyle\Hat{\gamma_1} = \frac{\frac{1}{n}\sum_{i=1}^{n} (x_i-\Hat{x}_n)^3}{\Hat{\sigma}_n^3}\\
          \displaystyle\Hat{\gamma_2} = \frac{\frac{1}{n}\sum_{i=1}^{n} (x_i-\Hat{x}_n)^4}{\Hat{\sigma}_n^4}\\
          \displaystyle\Hat{\delta} =   \frac{1}{\Hat{\gamma_2}_n-\Hat{\gamma_1}_n^2-3}\\
          \displaystyle\Hat{\beta} =    sign(\Hat{\gamma_1}_n)arcos( 2-\Hat{\delta}_n (\Hat{\gamma_2}_n-3))\\
          \displaystyle\Hat{\alpha} =   (\Hat{\sigma}_n^2(\cos\Hat{\beta}_n+1) )^{1/3}
        \end{align}

    where :math:`\gamma_2` is defined if :math:`\Hat{\gamma_2}_n \geq 2\Hat{\gamma_1}_n +3`.

    See also
    --------
    DistributionFactory, MeixnerDistribution
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MeixnerDistributionFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.MeixnerDistributionFactory_build(self, *args)

    def buildAsMeixnerDistribution(self, *args):
        r"""
        Estimate the distribution as native distribution.


        **Available usages**:

            buildAsMeixnerDistribution()

            buildAsMeixnerDistribution(*sample*)

            buildAsMeixnerDistribution(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.MeixnerDistribution`.

        Returns
        -------
        distribution : :class:`~openturns.MeixnerDistribution`
            The estimated distribution as a MeixnerDistribution.

            In the first usage, the default MeixnerDistribution distribution is built.
        """
        return _dist_bundle2.MeixnerDistributionFactory_buildAsMeixnerDistribution(self, *args)

    def __init__(self, *args):
        _dist_bundle2.MeixnerDistributionFactory_swiginit(self, _dist_bundle2.new_MeixnerDistributionFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_MeixnerDistributionFactory

# Register MeixnerDistributionFactory in _dist_bundle2:
_dist_bundle2.MeixnerDistributionFactory_swigregister(MeixnerDistributionFactory)
class MethodOfMomentsFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Estimation by method of moments.

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The distribution defining the parametric model to be adjusted to data.
    momentsOrder : sequence of int
        The orders of moments to estimate (1 for mean, 2 for variance, etc)
    bounds : :class:`~openturns.Interval`, optional
        Parameter bounds

    Notes
    -----
    This method fits a scalar distribution to data of dimension 1, using the method of moments.

    Let :math:`(\vect{x}_1, \dots, \vect{x}_n)` denote the sample, :math:`F_{\vect{\theta}}`
    the  cumulative distribution function we want to fit to the sample,
    and :math:`\vect{\theta} \in  \Theta \subset\Rset^p`  its parameter vector.

    Let :math:`K` denote the number of parameters of the distribution and we assume that 
    the :math:`K` first moments of the distribution exist.

    Let :math:`(\mu_1, \dots, \mu_K)` denote the :math:`K` first central moments of the sample and
    and :math:`(m_1, \dots, m_K)` those of the parametric model.

    The estimator :math:`\hat{\theta}` minimizes the sum of slacks between
    :math:`(\mu_1, \dots, \mu_K)` and :math:`(m_1, \dots, m_K)`. It is defined by:

    .. math::

        \Delta = \argmin_{\vect{\theta} \in \Rset^K} \left[ \dfrac{|\mu_1-m_1|}{\sigma} \right]^2 + \sum_{i=2}^K \left[ \dfrac{|\mu_i|^{1/i}-|m_i|^{1/i}}{\sigma} \right]^2


    See also
    --------
    DistributionFactory

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> distribution = ot.Normal(0.9, 1.7)
    >>> sample = distribution.getSample(10)
    >>> orders = [1, 2]  # mean, variance
    >>> factory = ot.MethodOfMomentsFactory(ot.Normal(), orders)
    >>> inf_distribution = factory.build(sample)

    With parameter bounds:

    >>> bounds = ot.Interval([0.8, 1.6], [1.0, 1.8])
    >>> factory = ot.MethodOfMomentsFactory(ot.Normal(), orders, bounds)
    >>> inf_distribution = factory.build(sample)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MethodOfMomentsFactory_getClassName(self)

    def __repr__(self):
        return _dist_bundle2.MethodOfMomentsFactory___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.MethodOfMomentsFactory___str__(self, *args)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.MethodOfMomentsFactory_build(self, *args)

    def buildFromMoments(self, moments):
        r"""
        Build from moments.

        Parameters
        ----------
        moments : sequence of float
            Consists in the mean followed by consecutive central moments from order 2
            (variance), of total size at least the distribution parameter dimension.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            Estimated distribution.

        Notes
        -----
        Depending on the parametric model choosed, not all moments define a valid
        distribution, so it should only used with empirical moments from the same model.

        Examples
        --------
        >>> import openturns as ot
        >>> distribution = ot.Beta(2.3, 2.2, -1.0, 1.0)
        >>> factory = ot.MethodOfMomentsFactory(ot.Beta(), [1, 2, 3, 4])
        >>> cm = [distribution.getCentralMoment(i + 2)[0] for i in range(3)]
        >>> moments = [distribution.getMean()[0]] + cm
        >>> inf_distribution = factory.buildFromMoments(moments)
        """
        return _dist_bundle2.MethodOfMomentsFactory_buildFromMoments(self, moments)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Accessor to the solver.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the moments.
        """
        return _dist_bundle2.MethodOfMomentsFactory_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Accessor to the solver.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used for numerical optimization of the moments.
        """
        return _dist_bundle2.MethodOfMomentsFactory_getOptimizationAlgorithm(self)

    def setOptimizationBounds(self, optimizationBounds):
        r"""
        Accessor to the optimization bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            The bounds used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.MethodOfMomentsFactory_setOptimizationBounds(self, optimizationBounds)

    def getOptimizationBounds(self):
        r"""
        Accessor to the optimization bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            The bounds used for numerical optimization of the likelihood.
        """
        return _dist_bundle2.MethodOfMomentsFactory_getOptimizationBounds(self)

    def setKnownParameter(self, values, positions):
        r"""
        Accessor to the known parameters.

        Parameters
        ----------
        values : sequence of float
            Values of fixed parameters.
        indices : sequence of int
            Indices of fixed parameters.

        Examples
        --------
        >>> import openturns as ot
        >>> ot.RandomGenerator.SetSeed(0)
        >>> distribution = ot.Beta(2.3, 2.2, -1.0, 1.0)
        >>> sample = distribution.getSample(10)
        >>> orders = [3, 4]  # skewness, kurtosis
        >>> factory = ot.MethodOfMomentsFactory(ot.Beta(), orders)
        >>> # set (a,b) out of (r, t, a, b)
        >>> factory.setKnownParameter([-1.0, 1.0], [2, 3])
        >>> inf_distribution = factory.build(sample)
        """
        return _dist_bundle2.MethodOfMomentsFactory_setKnownParameter(self, values, positions)

    def getKnownParameterValues(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        values : :class:`~openturns.Point`
            Values of fixed parameters.
        """
        return _dist_bundle2.MethodOfMomentsFactory_getKnownParameterValues(self)

    def getKnownParameterIndices(self):
        r"""
        Accessor to the known parameters indices.

        Returns
        -------
        indices : :class:`~openturns.Indices`
            Indices of fixed parameters.
        """
        return _dist_bundle2.MethodOfMomentsFactory_getKnownParameterIndices(self)

    def setMomentOrders(self, momentsOrders):
        r"""
        Accessor to the moment orders.

        Parameters
        ----------
        momentsOrder : sequence of int
            The orders of moments to estimate (1 for mean, 2 for variance, etc)
        """
        return _dist_bundle2.MethodOfMomentsFactory_setMomentOrders(self, momentsOrders)

    def getMomentOrders(self):
        r"""
        Accessor to the moment orders.

        Returns
        -------
        momentsOrder : sequence of int
            The orders of moments to estimate (1 for mean, 2 for variance, etc)
        """
        return _dist_bundle2.MethodOfMomentsFactory_getMomentOrders(self)

    def __init__(self, *args):
        _dist_bundle2.MethodOfMomentsFactory_swiginit(self, _dist_bundle2.new_MethodOfMomentsFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_MethodOfMomentsFactory

# Register MethodOfMomentsFactory in _dist_bundle2:
_dist_bundle2.MethodOfMomentsFactory_swigregister(MethodOfMomentsFactory)
class Mixture(openturns.model_copula.DistributionImplementation):
    r"""
    Build a linear combination of probability density functions.

    Parameters
    ----------
    collDist : sequence of :class:`~openturns.Distribution`,
        The collection of distributions which compose the linear combination.
    weights : sequence of float, optional
        A sequence with each component :math:`\geq 0`, of dimension equal to the
        size of *collDist*. The collection of weights applied to the collection of
        distributions. By default, the weights fulfilled inside
        each distribution are used (if any), thanks to the method
        *collDist[i].setWeight(myWeight)*. If not set, the weights are all
        taken equal to 1. The weights are automatically normalized so that their
        sum is equal to 1.

    Notes
    -----
    The probability density function of a *Mixture* is defined by:

    .. math::

        f(x) =  \sum_{i=1}^N \alpha_i p_i(x), \quad \alpha_i \geq 0, \quad \sum_i \alpha_i = 1

    Examples
    --------
    Create a *Mixture*:

    >>> import openturns as ot
    >>> collDist = [ot.Triangular(1.0, 2.0, 4.0), ot.Normal(-1.0, 1.0), ot.Uniform(5.0, 6.0)]
    >>> weight = [0.4, 1.0, 0.2]
    >>> myMixture = ot.Mixture(collDist, weight)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Mixture_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.Mixture___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.Mixture___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.Mixture___str__(self, *args)

    def setDistributionCollection(self, coll):
        r"""
        Set the distribution collection.

        Parameters
        ----------
        collDist : :class:`~openturns.Distribution`,
            The collection of distributions which compose the linear combination.
        """
        return _dist_bundle2.Mixture_setDistributionCollection(self, coll)

    def getDistributionCollection(self):
        r"""
        Accessor to the distribution collection.

        Returns
        -------
        collDist : :class:`~openturns.Distribution`,
            The collection of distributions which compose the linear combination.
        """
        return _dist_bundle2.Mixture_getDistributionCollection(self)

    def getWeights(self):
        r"""
        Get the weights.

        Returns
        -------
        weights : :class:`~openturns.Point` with each component :math:`\geq 0`.
        """
        return _dist_bundle2.Mixture_getWeights(self)

    def setWeights(self, weights):
        r"""
        Set the weights.

        Parameters
        ----------
        weights : sequence of float with each component :math:`\geq 0`.
        """
        return _dist_bundle2.Mixture_setWeights(self, weights)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.Mixture_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Mixture_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Mixture_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Mixture_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.Mixture_computeComplementaryCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Survival function input(s).

        Returns
        -------
        S : float, :class:`~openturns.Point`
            Survival function value(s) at input(s) `x`.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` is defined as follows:

        .. math::


            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^d X_i > x_i}
                     \quad \forall \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function (except for
            1-dimensional distributions).

        See Also
        --------
        computeComplementaryCDF
        """
        return _dist_bundle2.Mixture_computeSurvivalFunction(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\vect{a}` and
        :math:`\vect{b}`:

        .. math::

            \Prob{\bigcap\limits_{i=1}^n a_i < X_i \leq b_i} =
                \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, n)}` with :math:`c_i \in [a_i, b_i]`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.Mixture_computeProbability(self, interval)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Mixture_computeCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Mixture_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Mixture_computeCDFGradient(self, *args)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle2.Mixture_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        X : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Conditional PDF values at input.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            pdf^{seq}_{X_1,\ldots,X_d}(x_1,\ldots,x_d) = \left(\dfrac{d}{d\,x_n}\Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}}\right)_{i=1,\ldots,d}

        ie its :math:`n`-th component is the conditional PDF of :math:`X_n` at :math:`x_n` given that :math:`X_1=x_1,\ldots,X_{n-1}=x_{n-1}`. For :math:`n=1` it reduces to :math:`\dfrac{d}{d\,x_1}\Prob{X_1 \leq x_1}`, ie the PDF of the first component at :math:`x_1`.
        """
        return _dist_bundle2.Mixture_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \mid X_1, \ldots, X_{n - 1}}(x_n) =
                \Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}},
                \quad x_n \in \supp{X_n}
        """
        return _dist_bundle2.Mixture_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        X : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at input.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            F^{seq}_{X_1,\ldots,X_d}(x_1,\ldots,x_d) = \left(\Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}}\right)_{i=1,\ldots,d}

        ie its :math:`n`-th component is the conditional CDF of :math:`X_n` at :math:`x_n` given that :math:`X_1=x_1,\ldots,X_{n-1}=x_{n-1}`. For :math:`n=1` it reduces to :math:`\Prob{X_1 \leq x_1}`, ie the CDF of the first component at :math:`x_1`.
        """
        return _dist_bundle2.Mixture_computeSequentialConditionalCDF(self, x)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.Mixture_getMarginal(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.Mixture_getParametersCollection(self)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.Mixture_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.Mixture_getParameterDescription(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.Mixture_setParameter(self, parameter)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.Mixture_isElliptical(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Mixture_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Mixture_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Mixture_isIntegral(self)

    def hasEllipticalCopula(self):
        r"""
        Test whether the copula of the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        See Also
        --------
        isElliptical
        """
        return _dist_bundle2.Mixture_hasEllipticalCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Mixture_hasIndependentCopula(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.Mixture_getSupport(self, *args)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle2.Mixture_getSingularities(self)

    def __init__(self, *args):
        _dist_bundle2.Mixture_swiginit(self, _dist_bundle2.new_Mixture(*args))
    __swig_destroy__ = _dist_bundle2.delete_Mixture

# Register Mixture in _dist_bundle2:
_dist_bundle2.Mixture_swigregister(Mixture)
class MixedHistogramUserDefined(openturns.model_copula.DistributionImplementation):
    r"""
    Mixed Histogram/UserDefined distribution.

    Defines a distribution with Histogram (continuous) or UserDefined (discrete) marginals,
    it is meant to be used as a specialization of the Mixture for efficient sampling.

    Each marginal is defined from a list of float that either define the intervals on which
    the marginal is uniform (equivalent to a :class:`~openturns.Histogram` distribution),
    or the set of points that define the support of the discrete marginal
    (equivalent to an :class:`~openturns.UserDefined` distribution).

    Weights are required for each combination of intervals or discrete points,
    ie for a dimension 2, with an Histogram component with 3 intervals (defined from 4 ticks) and
    a discrete component with 3 values (3 ticks), 9 probability values are required, see example below.

    Parameters
    ----------
    ticksCollection : sequence of sequence of float
        List of ticks for each component
    kind : sequence of int
        Either MixedHistogramUserDefined.DISCRETE or MixedHistogramUserDefined.CONTINUOUS
    probabilityTable : sequence of float
        List of probabilities

    See also
    --------
    Mixture, Histogram, UserDefined

    Examples
    --------
    >>> import openturns as ot
    >>> ticksCollection = [[0.0, 1.0, 3.0, 6.0], [1.0, 2.0, 3.0]]
    >>> kind = [ot.MixedHistogramUserDefined.CONTINUOUS, ot.MixedHistogramUserDefined.DISCRETE]
    >>> probabilityTable = [0.05,0.1,0.15,0.2,0.25,0.3,0.35,0.4,0.45]
    >>> distribution = ot.MixedHistogramUserDefined(ticksCollection, kind, probabilityTable)
    >>> distribution.setDescription(['A', 'B'])
    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MixedHistogramUserDefined_getClassName(self)
    DISCRETE = _dist_bundle2.MixedHistogramUserDefined_DISCRETE
    CONTINUOUS = _dist_bundle2.MixedHistogramUserDefined_CONTINUOUS

    def __eq__(self, *args):
        return _dist_bundle2.MixedHistogramUserDefined___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.MixedHistogramUserDefined___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.MixedHistogramUserDefined___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.MixedHistogramUserDefined_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle2.MixedHistogramUserDefined_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.MixedHistogramUserDefined_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.MixedHistogramUserDefined_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.MixedHistogramUserDefined_computeComplementaryCDF(self, *args)

    def computeQuantile(self, *args):
        r"""
        Compute the quantile function.

        Parameters
        ----------
        p : float (or sequence of float), :math:`0 < p < 1`
            Quantile function input (a probability).
        tail : bool, optional (default=False)
            Whether p should be interpreted as the complementary probability.

        Returns
        -------
        X : :class:`~openturns.Point` (or :class:`~openturns.Sample`)
            Quantile at probability level :math:`p`.

        Notes
        -----
        The quantile function is also known as the inverse cumulative distribution
        function:

        .. math::

            Q_{\vect{X}}(p) = F_{\vect{X}}^{-1}(p),
                              \quad p \in [0; 1]
        """
        return _dist_bundle2.MixedHistogramUserDefined_computeQuantile(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.MixedHistogramUserDefined_computeCharacteristicFunction(self, x)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.MixedHistogramUserDefined_getMarginal(self, *args)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MixedHistogramUserDefined_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MixedHistogramUserDefined_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.MixedHistogramUserDefined_isIntegral(self)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.MixedHistogramUserDefined_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.MixedHistogramUserDefined_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.MixedHistogramUserDefined_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.MixedHistogramUserDefined_getStandardRepresentative(self)

    def setTicksCollection(self, ticksCollection):
        r"""
        Ticks accessor.

        Parameters
        ----------
        ticksCollection : sequence of sequence of float
            ticksCollection
        """
        return _dist_bundle2.MixedHistogramUserDefined_setTicksCollection(self, ticksCollection)

    def getTicksCollection(self):
        r"""
        Ticks accessor.

        Returns
        -------
        ticksCollection : sequence of sequence of float
            ticksCollection
        """
        return _dist_bundle2.MixedHistogramUserDefined_getTicksCollection(self)

    def setKind(self, kind):
        r"""
        Kind accessor.

        Parameters
        ----------
        kind : sequence of int
            0=discrete, 1=continuous
        """
        return _dist_bundle2.MixedHistogramUserDefined_setKind(self, kind)

    def getKind(self):
        r"""
        Kind accessor.

        Returns
        -------
        kind : sequence of int
            0=discrete, 1=continuous
        """
        return _dist_bundle2.MixedHistogramUserDefined_getKind(self)

    def setProbabilityTable(self, probabilityTable):
        r"""
        Probability table accessor.

        Parameters
        ----------
        probabilityTable : sequence of float
            List of probabilities
        """
        return _dist_bundle2.MixedHistogramUserDefined_setProbabilityTable(self, probabilityTable)

    def getProbabilityTable(self):
        r"""
        Probability table accessor.

        Returns
        -------
        probabilityTable : sequence of float
            List of probabilities
        """
        return _dist_bundle2.MixedHistogramUserDefined_getProbabilityTable(self)

    def asMixture(self):
        r"""
        Conversion as a Mixture.

        Returns
        -------
        mixture : :class:`~openturns.Mixture`
            Mixture distribution
        """
        return _dist_bundle2.MixedHistogramUserDefined_asMixture(self)

    def setDescription(self, description):
        r"""
        Accessor to the componentwise description.

        Parameters
        ----------
        description : sequence of str
            Description of the components of the distribution.
        """
        return _dist_bundle2.MixedHistogramUserDefined_setDescription(self, description)

    def __init__(self, *args):
        _dist_bundle2.MixedHistogramUserDefined_swiginit(self, _dist_bundle2.new_MixedHistogramUserDefined(*args))
    __swig_destroy__ = _dist_bundle2.delete_MixedHistogramUserDefined

# Register MixedHistogramUserDefined in _dist_bundle2:
_dist_bundle2.MixedHistogramUserDefined_swigregister(MixedHistogramUserDefined)
class TruncatedDistribution(openturns.model_copula.DistributionImplementation):
    r"""
    Truncated distribution.

    Available constructors:
        TruncatedDistribution(*distribution, lowerBound, upperBound, threshold=0.5*)

        TruncatedDistribution(*distribution, bound, side=ot.TruncatedDistribution.LOWER, threshold=0.5*)

        TruncatedDistribution(*distribution, truncationInterval, threshold=0.5*)

    Parameters
    ----------
    distribution : :class:`~openturns.Distribution`
        The distribution to be truncated.
    lowerBound, upperBound : float
        Define a new distribution range :math:`[lowerBound, upperBound]` with
        finite bounds. The upper bound must be strictly greater than the lower
        bound.
    bound : float
        Scalar used when one of the bounds of the distribution is not finite.

        If *side = ot.TruncatedDistribution.LOWER*: the interval
        :math:`[bound, +\infty)` is used to bound the distribution.

        If *side = ot.TruncatedDistribution.UPPER*: the interval
        :math:`(-\infty, bound]` is used to bound the distribution.
    side : int, optional
        Integer used when one of the bounds of the distribution is not finite.
        (Amongst ot.TruncatedDistribution.LOWER and ot.TruncatedDistribution.UPPER).
    truncationInterval : :class:`~openturns.Interval`
        Define a new distribution range :math:`[lowerBound, upperBound]` with
        finite bounds.
    threshold : float, :math:`\tau \in [0, 1]`
        This threshold is used when generating an evaluation of the distribution.
        We note :math:`F` the CDF of the non truncated distribution:

        If :math:`F(upperBound)-F(lowerBound)<\tau`: a CDF inversion is performed.

        If :math:`F(upperBound)-F(lowerBound)>\tau`: rejection.

    Notes
    -----
    Assuming a random variable *X* is truncated with two bounds *a* and *b*,
    its probability density function is defined as:

    .. math::

          \forall y \in \Rset, p_Y(y) =
          \begin{array}{|ll}
            0 &  \mbox{for } y \geq b  \mbox{ or }  y \leq a\\
            \displaystyle \frac{1}{F_X(b) - F_X(a)}\, p_X(y) & \mbox{for } y\in[a,b]
          \end{array}

    and its cumulative distribution function is defined as:

    .. math::

        \forall y \in \Rset, F_Y(y) = \Prob{X<y\, / \, X\in[a,b]} =
        \begin{array}{|ll}
          1 & \mbox{for } y \geq b, \\
          0 & \mbox{for } y \leq a, \\
          \displaystyle \frac{F_X(y) - F_X(a)}{F_X(b) - F_X(a)} & \mbox{for } y\in[a,b]
        \end{array}

    Examples
    --------
    >>> import openturns as ot
    >>> distribution = ot.TruncatedDistribution(ot.Normal(2.0, 1.5), 1.0, 4.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.TruncatedDistribution_getClassName(self)
    LOWER = _dist_bundle2.TruncatedDistribution_LOWER
    UPPER = _dist_bundle2.TruncatedDistribution_UPPER

    def __eq__(self, *args):
        return _dist_bundle2.TruncatedDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.TruncatedDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.TruncatedDistribution___str__(self, *args)

    def getSimplifiedVersion(self):
        r"""
        Accessor to the simplified distribution.

        Drops unneeded truncation if the distribution given as argument is already
        truncated by nature (Uniform, etc).

        Returns
        -------
        simplified : :class:`~openturns.Distribution`
            The simplified distribution.
        """
        return _dist_bundle2.TruncatedDistribution_getSimplifiedVersion(self)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.TruncatedDistribution_getRealization(self)

    def computeDDF(self, *args):
        r"""
        Compute the derivative density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        d : :class:`~openturns.Point`, :class:`~openturns.Sample`
            DDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The derivative density function is the gradient of the probability density
        function with respect to :math:`\vect{x}`:

        .. math::

            \vect{\nabla}_{\vect{x}} f_{\vect{X}}(\vect{x}) =
                \Tr{\left(\frac{\partial f_{\vect{X}}(\vect{x})}{\partial x_i},
                          \quad i = 1, \ldots, n\right)},
                \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.TruncatedDistribution_computeDDF(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.TruncatedDistribution_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.TruncatedDistribution_computeCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Survival function input(s).

        Returns
        -------
        S : float, :class:`~openturns.Point`
            Survival function value(s) at input(s) `x`.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` is defined as follows:

        .. math::


            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^d X_i > x_i}
                     \quad \forall \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function (except for
            1-dimensional distributions).

        See Also
        --------
        computeComplementaryCDF
        """
        return _dist_bundle2.TruncatedDistribution_computeSurvivalFunction(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.TruncatedDistribution_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.TruncatedDistribution_computeCDFGradient(self, *args)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.TruncatedDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.TruncatedDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.TruncatedDistribution_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.TruncatedDistribution_isElliptical(self)

    def setDistribution(self, distribution):
        r"""
        Set the distribution.

        Parameters
        ----------
        distribution : :class:`~openturns.Distribution`
            The distribution to be truncated.
        """
        return _dist_bundle2.TruncatedDistribution_setDistribution(self, distribution)

    def getDistribution(self):
        r"""
        Get the distribution.

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The distribution to be truncated.
        """
        return _dist_bundle2.TruncatedDistribution_getDistribution(self)

    def setThresholdRealization(self, thresholdRealization):
        r"""
        Set the threshold used when generating an evaluation of the distribution.

        Parameters
        ----------
        threshold : float, :math:`\tau \in [0, 1]`
            This threshold is used when generating an evaluation of the distribution.
            We note :math:`F` the CDF of the non truncated distribution:

            If :math:`F(upperBound)-F(lowerBound)<\tau`: a CDF inversion is performed.

            If :math:`F(upperBound)-F(lowerBound)>\tau`: rejection.
        """
        return _dist_bundle2.TruncatedDistribution_setThresholdRealization(self, thresholdRealization)

    def getThresholdRealization(self):
        r"""
        Get the threshold used when generating an evaluation of the distribution.

        Returns
        -------
        threshold : float, :math:`\tau \in [0, 1]`
            This threshold is used when generating an evaluation of the distribution.
            We note :math:`F` the CDF of the non truncated distribution:

            If :math:`F(upperBound)-F(lowerBound)<\tau`: a CDF inversion is performed.

            If :math:`F(upperBound)-F(lowerBound)>\tau`: rejection.
        """
        return _dist_bundle2.TruncatedDistribution_getThresholdRealization(self)

    def setBounds(self, bounds):
        r"""
        Set the bounds.

        Parameters
        ----------
        bounds : :class:`~openturns.Interval`
            Truncation bounds.
        """
        return _dist_bundle2.TruncatedDistribution_setBounds(self, bounds)

    def getBounds(self):
        r"""
        Set the bounds.

        Returns
        -------
        bounds : :class:`~openturns.Interval`
            Truncation bounds.
        """
        return _dist_bundle2.TruncatedDistribution_getBounds(self)

    def isContinuous(self):
        r"""
        Test whether the distribution is continuous or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.TruncatedDistribution_isContinuous(self)

    def isDiscrete(self):
        r"""
        Test whether the distribution is discrete or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.TruncatedDistribution_isDiscrete(self)

    def isIntegral(self):
        r"""
        Test whether the distribution is integer-valued or not.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.TruncatedDistribution_isIntegral(self)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.TruncatedDistribution_getSupport(self, *args)

    def getSingularities(self):
        r"""
        Accessor to the singularities of the PDF function.

        It is defined for univariate distributions only, and gives all the singularities (ie discontinuities of any order) strictly inside of the range of the distribution.

        Returns
        -------
        singularities : :class:`~openturns.Point`
            The singularities of the PDF of an univariate distribution.
        """
        return _dist_bundle2.TruncatedDistribution_getSingularities(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.TruncatedDistribution_getMarginal(self, *args)

    def __init__(self, *args):
        _dist_bundle2.TruncatedDistribution_swiginit(self, _dist_bundle2.new_TruncatedDistribution(*args))
    __swig_destroy__ = _dist_bundle2.delete_TruncatedDistribution

# Register TruncatedDistribution in _dist_bundle2:
_dist_bundle2.TruncatedDistribution_swigregister(TruncatedDistribution)
class KernelSmoothing(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Non parametric continuous distribution estimation by kernel smoothing.

    Refer to :ref:`kernel_smoothing`.

    Parameters
    ----------
    kernel : :class:`~openturns.Distribution`, optional
        Univariate distribution of the kernel that will be used. By default, the standard Normal distribution is used. 
    binned : bool, optional
        Activates bining mechanism only in the univariate or bivariate cases. It allows one to speed up the manipulation of the density function of the resulting distribution.  By default, the mechanism is activated.
    binNumber : int, :math:`binNumber \geq 2`, optional
        Indicates the number of bins used by the bining mechanism. By default, OpenTURNS uses the values stored in the *ResourceMap*.
    boundaryCorrection : bool, optional
        Activates the boundary correction using the mirroring technique.
        By default, the correction is not provided.

    Notes
    -----
    The binning mechanism creates a regular grid of *binNumber* intervals in each
    dimension, then the unit weight of each point is linearly affected to the vertices
    of the bin containing the point (see [wand1994]_ appendix D, page 182).
    The `KernelSmoothing-BinNumber` key defines the default value of the 
    number of bins used in the _binning_ algorithm to improve the evaluation speed.

    The boundary correction is available only in one dimension, and it is done using
    the mirroring technique. See the notes of the :meth:`setBoundingOption` method for
    details.

    When applied to multivariate samples, the kernel is the kernel product of the
    univariate distribution specified in the constructor.

    Examples
    --------
    Fit a distribution on data thanks to the kernel smoothing technique:

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> sample = ot.Gamma(6.0, 1.0).getSample(100)
    >>> ks = ot.KernelSmoothing()
    >>> fittedDist = ks.build(sample)
    >>> print(fittedDist.getClassName())
    Distribution

    The :meth:`build` method produces a generic :class:`~openturns.Distribution`
    object. Other build methods (detailed below) produce more specific objects.

    Get the bandwidth:

    >>> bandwidth = ks.getBandwidth()
    >>> print(bandwidth)
    [0.862207]

    The bandwidth was evaluated by the :meth:`build` method.
    It could also have been provided by the user.

    >>> bandwidth = [0.9]
    >>> fittedDist = ks.build(sample, bandwidth)

    Compare the PDFs:

    >>> graph = fittedDist.drawPDF()
    >>> graph.add( ot.Gamma(6.0, 1.0).drawPDF())
    >>> graph.setColors(ot.Drawable.BuildDefaultPalette(2))
    >>> graph.setLegends(['KS dist', 'Gamma'])

    The default values of the parameters of the constructor usually provide good results.
    Nevertheless, the parameters can be manually set.

    >>> kernel = ot.Uniform()
    >>> ks = ot.KernelSmoothing(kernel)
    >>> binned = True # by default True
    >>> binNumber = 64
    >>> ks = ot.KernelSmoothing(kernel, binned, binNumber)
    >>> boundaryCorrection = True # by default False
    >>> ks = ot.KernelSmoothing(kernel, binned, binNumber, boundaryCorrection)

    Variants of the :meth:`build` method can be used when the distribution to build
    is expected to be of a certain type. In those cases however,
    the bandwidth must be user-specified.
    To use :meth:`buildAsTruncatedDistribution`, boundary correction must be enabled.

    >>> distribution = ks.buildAsKernelMixture(sample, bandwidth)
    >>> print(distribution.getClassName())
    KernelMixture
    >>> distribution = ks.buildAsMixture(sample, bandwidth)
    >>> print(distribution.getClassName())
    Mixture
    >>> distribution = ks.buildAsTruncatedDistribution(sample, bandwidth)
    >>> print(distribution.getClassName())
    TruncatedDistribution
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.KernelSmoothing_getClassName(self)
    NONE = _dist_bundle2.KernelSmoothing_NONE
    LOWER = _dist_bundle2.KernelSmoothing_LOWER
    UPPER = _dist_bundle2.KernelSmoothing_UPPER
    BOTH = _dist_bundle2.KernelSmoothing_BOTH

    def build(self, *args):
        r"""
        Fit a kernel smoothing distribution on data.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data on which the distribution is fitted. Any dimension.
        bandwidth : :class:`~openturns.Point`, optional
            Contains the bandwidth in each direction. If not specified, the bandwidth is calculated using the mixed rule from data.

        Returns
        -------
        fittdDist : :class:`~openturns.Distribution`
            The fitted distribution.

        Notes
        -----
        According to the dimension of the data and the specified treatments, the resulting distribution differs.

        - If the sample is constant, a :class:`~openturns.Dirac` distribution is built.
        - If dimension > 2 or if no treatment has been asked for, a :class:`~openturns.KernelMixture` is built by calling *buildAsKernelMixture*. 
        - If dimension = 1 and a boundary treatment has been asked for, a :class:`~openturns.TruncatedDistribution` is built by calling *buildAsTruncatedDistribution*
        - If dimension = 1 or 2 and no boundary treatment has been asked for, but a binning treatment has been asked for,

            - If the sample size is greater than the bin number, then a :class:`~openturns.Mixture` is built by calling `buildAsMixture`
            - Otherwise a :class:`~openturns.KernelMixture` is built by calling `buildAsKernelMixture`

        The bandwidth selection depends on the dimension.

        - If dimension = 1, then `computeMixedBandwidth` is used.
        - Otherwise, then the only multivariate rule `computeSilvermanBandwidth` is used.

        Examples
        --------
        See the effect of the boundary correction:

        >>> import openturns as ot
        >>> sample = ot.Exponential(1.0).getSample(1000)
        >>> smoother = ot.KernelSmoothing()
        >>> fittedDistNoCorr = smoother.build(sample)
        >>> smoother.setBoundaryCorrection(True)
        >>> fittedDistWithCorr = smoother.build(sample)

        Compare the PDFs:

        >>> graph = ot.Exponential(1.0).drawPDF()
        >>> graph.add(fittedDistNoCorr.drawPDF())
        >>> graph.add(fittedDistWithCorr.drawPDF())
        >>> graph.setColors(['black', 'blue', 'red'])
        >>> graph.setLegends(['Exp dist', 'No boundary corr', 'Boundary corr'])

        """
        return _dist_bundle2.KernelSmoothing_build(self, *args)

    def buildAsKernelMixture(self, sample, bandwidth):
        r"""
        Fit a kernel smoothing distribution on data.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data on which the distribution is fitted. Any dimension.
        bandwidth : :class:`~openturns.Point`
            Contains the bandwidth in each direction.

        Returns
        -------
        fittdDist : :class:`~openturns.KernelMixture`
            The fitted distribution.

        Notes
        -----
        It builds a :math:`~openturns.KernelMixture` using the given data and bandwidth regardless of the binning or boundary treatment flags.

        Examples
        --------

        >>> import openturns as ot
        >>> sample = ot.Exponential(1.0).getSample(1000)
        >>> smoother = ot.KernelSmoothing()
        >>> kernelMixture = smoother.buildAsKernelMixture(sample, [1.0])

        """
        return _dist_bundle2.KernelSmoothing_buildAsKernelMixture(self, sample, bandwidth)

    def buildAsMixture(self, sample, bandwidth):
        r"""
        Fit a kernel smoothing distribution on data.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data on which the distribution is fitted. Any dimension.
        bandwidth : :class:`~openturns.Point`
            Contains the bandwidth in each direction.

        Returns
        -------
        fittdDist : :class:`~openturns.KernelMixture`
            The fitted distribution.

        Notes
        -----
        It builds a :math:`~openturns.Mixture` using the given bandwidth and a binning of the given data regardless of the bin number, the data size, the binning flag or boundary treatment flags. This method is available only for 1D or 2D samples.

        Examples
        --------

        >>> import openturns as ot
        >>> sample = ot.Exponential(1.0).getSample(1000)
        >>> smoother = ot.KernelSmoothing(ot.Normal(), True, 100, False)
        >>> mixture = smoother.buildAsMixture(sample, [1.0])

        """
        return _dist_bundle2.KernelSmoothing_buildAsMixture(self, sample, bandwidth)

    def buildAsTruncatedDistribution(self, sample, bandwidth):
        r"""
        Estimate the distribution as :class:`~openturns.TruncatedDistribution`.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data on which the distribution is fitted. Any dimension.
        bandwidth : :class:`~openturns.Point`
            Contains the bandwidth in each direction.

        Returns
        -------
        fittdDist : :class:`~openturns.TruncatedDistribution`
            The estimated distribution as a :class:`~openturns.TruncatedDistribution`.

        Examples
        --------

        >>> import openturns as ot
        >>> sample = ot.Exponential(1.0).getSample(1000)
        >>> smoother = ot.KernelSmoothing(ot.Normal(), False, 0, True)
        >>> truncated = smoother.buildAsTruncatedDistribution(sample, [1.0])

        """
        return _dist_bundle2.KernelSmoothing_buildAsTruncatedDistribution(self, sample, bandwidth)

    def getBandwidth(self):
        r"""
        Accessor to the bandwidth used in the kernel smoothing.

        Returns
        -------
        bandwidth : :class:`~openturns.Point`
            Bandwidth used in each direction.

        """
        return _dist_bundle2.KernelSmoothing_getBandwidth(self)

    def getKernel(self):
        r"""
        Accessor to kernel used in the kernel smoothing.

        Returns
        -------
        kernel : :class:`~openturns.Distribution`
            Univariate distribution used to build the kernel.

        """
        return _dist_bundle2.KernelSmoothing_getKernel(self)

    def setBoundaryCorrection(self, boundaryCorrection):
        r"""
        Accessor to the boundary correction flag.

        Parameters
        ----------
        boundaryCorrection : bool
            Activates the boundary correction using the mirroring technique.
        """
        return _dist_bundle2.KernelSmoothing_setBoundaryCorrection(self, boundaryCorrection)

    def setBoundingOption(self, boundingOption):
        r"""
        Accessor to the boundary correction option.

        Parameters
        ----------
        boundingOption : int
            Select the boundary correction option, see notes.

        Notes
        -----
        The possible values for the bounding option are:

            - KernelSmoothing.NONE  or 0: no boundary correction
            - KernelSmoothing.LOWER or 1: apply the boundary correction to the lower bound
            - KernelSmoothing.UPPER or 2: apply the boundary correction to the upper bound
            - KernelSmoothing.BOTH  or 3: apply the boundary correction to both bounds

        It applies only to 1D samples. Each bound can be defined by the user or computed
        automatically from the sample, see *setLowerBound*, *setUpperBound*,
        *setAutomaticLowerBound*, *setAutomaticUpperBound*.
        """
        return _dist_bundle2.KernelSmoothing_setBoundingOption(self, boundingOption)

    def setLowerBound(self, lowerBound):
        r"""
        Accessor to the lower bound for boundary correction.

        Parameters
        ----------
        lowerBound : float
            A user-defined lower bound to take into account for boundary correction.

        Notes
        -----
        This method automatically sets the *automaticLowerBound* flag to *False*.
        The given value will be taken into account only if *boundingOption* is set to
        either 1 or 3. If the algorithm is applied to a sample with a minimum value
        less than the user-defined lower bound and the *automaticLowerBound* is set to
        *False*, then an exception it raised.

        """
        return _dist_bundle2.KernelSmoothing_setLowerBound(self, lowerBound)

    def setUpperBound(self, upperBound):
        r"""
        Accessor to the upper bound for boundary correction.

        Parameters
        ----------
        upperBound : float
            A user-defined lower bound to take into account for boundary correction.

        Notes
        -----
        This method automatically sets the *automaticLowerBound* flag to *False*.
        The given value will be taken into account only if *boundingOption* is set to
        either 1 or 3. If the algorithm is applied to a sample with a minimum value
        less than the user-defined lower bound and the *automaticLowerBound* is set to
        *False*, then an exception it raised.

        """
        return _dist_bundle2.KernelSmoothing_setUpperBound(self, upperBound)

    def setAutomaticLowerBound(self, automaticLowerBound):
        r"""
        Accessor to the flag for an automatic selection of lower bound.

        Parameters
        ----------
        automaticLowerBound : bool
            Flag to tell if the user-defined lower bound has to be taken into account (value *False*) or if the minimum of the given sample has to be used (value *True*).
        """
        return _dist_bundle2.KernelSmoothing_setAutomaticLowerBound(self, automaticLowerBound)

    def setAutomaticUpperBound(self, automaticUpperBound):
        r"""
        Accessor to the flag for an automatic selection of upper bound.

        Parameters
        ----------
        automaticUpperBound : bool
            Flag to tell if the user-defined upper bound has to be taken into account (value *False*) or if the maximum of the given sample has to be used (value *True*).
        """
        return _dist_bundle2.KernelSmoothing_setAutomaticUpperBound(self, automaticUpperBound)

    def computeSilvermanBandwidth(self, sample):
        r"""
        Compute the bandwidth according to the Silverman rule.

        Returns
        -------
        bandwidth : :class:`~openturns.Point`
            Bandwidth which components are evaluated according to the Silverman rule
            assuming a normal distribution.
            The bandwidth uses a robust estimate of the
            sample standard deviation, based on the interquartile range introduced
            in :ref:`kernel_smoothing` (rather than the sample standard deviation).
            This method can manage a multivariate sample and produces a
            multivariate bandwidth.

        """
        return _dist_bundle2.KernelSmoothing_computeSilvermanBandwidth(self, sample)

    def computePluginBandwidth(self, sample):
        r"""
        Compute the bandwidth according to the plugin rule.

        Returns
        -------
        bandwidth : :class:`~openturns.Point`
            Bandwidth which components are evaluated according to the plugin rule.

        Notes
        -----
        This plug-in method is based on the *solve-the-equation* rule from [sheather1991]_.
        This method can take a lot of time for large samples, as the cost is  quadratic with the sample size.

        Several keys of the :class:`~openturns.ResourceMap` are used by the [sheather1991]_ method.

        - The key `KernelSmoothing-AbsolutePrecision` is used in the Sheather-Jones algorithm
          to estimate the bandwidth.
          It defines the absolute tolerance used by the solver
          to solve the nonlinear equation.

        - The `KernelSmoothing-MaximumIteration` key defines the maximum number of iterations
          used by the solver.

        - The `KernelSmoothing-RelativePrecision` key defines the relative tolerance.

        - The `KernelSmoothing-AbsolutePrecision` key defines the absolute tolerance. 

        - The `KernelSmoothing-ResidualPrecision` key defines the absolute
          tolerance on the residual.

        - The `KernelSmoothing-CutOffPlugin` key is the cut-off value
          introduced in :ref:`kernel_smoothing`.

        More precisely, the `KernelSmoothing-CutOffPlugin` key of the :class:`~openturns.ResourceMap` controls
        the accuracy of the approximation used to estimate the rugosity of the
        second derivative of the distribution.
        The default value ensures that terms in the sum which weight are lower than
        :math:`4 \times 10^{-6}` are ignored, which can reduce the calculation in some situations.
        The properties of the standard gaussian density are so that,
        in order to make the computation exact, the value of the
        `KernelSmoothing-CutOffPlugin` must be set to 39, but this may increase the
        computation time.

        """
        return _dist_bundle2.KernelSmoothing_computePluginBandwidth(self, sample)

    def computeMixedBandwidth(self, sample):
        r"""
        Compute the bandwidth according to a mixed rule.

        Returns
        -------
        bandwidth : :class:`~openturns.Point`
            Bandwidth which components are evaluated according to a mixed rule.

        Notes
        -----
        This method uses the *mixed* rule introduced in :ref:`kernel_smoothing`.
        Its goal is to provide an accurate estimator of the bandwidth 
        when the sample size is large.

        Let :math:`n` be the sample size.
        The estimator depends on the threshold sample size :math:`n_t` defined in the
        `KernelSmoothing-SmallSize` key of the :class:`~openturns.ResourceMap`.


        - If :math:`n \leq n_t`, i.e. for a small sample, we use the plugin solve-the-equation
          method.

        - Otherwise, the *mixed* rule is used.

        """
        return _dist_bundle2.KernelSmoothing_computeMixedBandwidth(self, sample)

    def __init__(self, *args):
        _dist_bundle2.KernelSmoothing_swiginit(self, _dist_bundle2.new_KernelSmoothing(*args))
    __swig_destroy__ = _dist_bundle2.delete_KernelSmoothing

# Register KernelSmoothing in _dist_bundle2:
_dist_bundle2.KernelSmoothing_swigregister(KernelSmoothing)
class ConditionalDistribution(Mixture):
    r"""
    Conditional distribution.

    Helper class for defining the distribution of :math:`\vect{X}` such that
    :math:`\vect{X}|\vect{\Theta}` follows the distribution :math:`\mathcal{L}_{\vect{X}|\vect{\Theta}}`,
    with :math:`\vect{\Theta}=g(\vect{Y})`, :math:`\vect{Y}` follows the distribution
    :math:`\mathcal{L}_{\vect{Y}}` and :math:`g` is a given function of input
    dimension the dimension of :math:`\mathcal{L}_{\vect{Y}}` and output dimension the
    dimension of :math:`\vect{\Theta}`.

    Parameters
    ----------

    conditionedDist : :class:`~openturns.Distribution`
        the distribution of :math:`\vect{X}|\vect{\Theta}`,
        whose parameters will be overwritten by :math:`g(\vect{Y})`.
        In the default constructor, *conditionedDist* is taken equal to :math:`\vect{X} | \vect{\Theta} \sim`
        :class:`~openturns.Uniform` :math:`(\vect{\Theta})`.

    conditioningDist : :class:`~openturns.Distribution`
        the distribution of :math:`\vect{Y}`, specified with its parameters.
        In the default constructor,  *conditioningDist* is taken
        equal to :math:`\vect{Y} \sim` :class:`~openturns.Uniform`:math:`(-1,1)`.

    linkFunction : :class:`~openturns.Function`, optional
        the function :math:`g: \Rset^p \rightarrow \Rset^q`, where :math:`p` is the dimension of
        *conditioningDist* and :math:`q` is the dimension of :math:`\vect{\Theta}`.
        In the default constructor, *linkFunction* is taken equal
        to :math:`g: \Rset \rightarrow \Rset^2` with :math:`g(y)=(y,y+1)`.
        When not provided *linkFunction* is taken equal to  :math:`g(\vect{y})=\vect{y}` as we need :math:`p=q`.


    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_{\vect{X}}(\vect{x}) = \int f_{\vect{X}|\vect{\Theta}=g(\vect{y})}(\vect{x}|g(\vect{y})) f_{\vect{Y}}(\vect{y})\di{\vect{y}}

    with :math:`f_{\vect{X}|\vect{\Theta}=g(\vect{y})}` the PDF of the distribution
    of :math:`\vect{X}|\vect{\Theta}`, where :math:`\vect{\Theta}` has been replaced
    by :math:`g(\vect{y})`, :math:`f_{\vect{Y}}` the PDF of :math:`\vect{Y}` and
    :math:`g` the linking function.

    With the default constructor, the resulting random variable :math:`X` follows a
    trapezoidal distribution parameterized by :math:`(-1, 0, 1, 2)`.

    Note that a :class:`~openturns.ConditionalDistribution` can be obtained as the
    first marginal distribution of a :class:`~openturns.BayesDistribution`.

    The continuous part of the conditioning distribution is discretized using a
    :class:`~openturns.WeightedExperiment` which can be modified using
    'ConditionalDistribution-ContinuousDiscretizationMethod' in
    :class:`~openturns.ResourceMap` (can be 'GaussProduct', 'QMC' or 'MC'), in
    conjunction with 'ConditionalDistribution-MarginalIntegrationNodesNumber' and
    'ConditionalDistribution-MaximumIntegrationNodesNumber'. The default is
    'GaussProduct', well adapted if the conditioned model is *regular*, meaning that
    its range does not depend on the parameters (e.g. a :class:`~openturns.Normal`
    distribution). Otherwise, one of the other discretization methods is to be
    preferred (e.g. for a :class:`~openturns.Uniform` distribution).

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> conditioningDist = ot.Normal(0.0, 1.0)
    >>> g = ot.SymbolicFunction(['y'], ['y', '0.1+y^2'])
    >>> conditionedDist = ot.Normal()
    >>> finalDist = ot.ConditionalDistribution(conditionedDist, conditioningDist, g)

    Draw a sample:

    >>> sample = finalDist.getSample(5)

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.ConditionalDistribution_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.ConditionalDistribution___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.ConditionalDistribution___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.ConditionalDistribution___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.ConditionalDistribution_getRealization(self)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.ConditionalDistribution_getParametersCollection(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.ConditionalDistribution_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.ConditionalDistribution_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.ConditionalDistribution_getParameterDescription(self)

    def setConditionedDistribution(self, conditionedDistribution):
        r"""
        Accessor to the distribution's conditioned distribution parameter *conditionedDistribution*.

        Parameters
        ----------
        conditionedDistribution : :class:`~openturns.Distribution`
            the distribution of :math:`\vect{X}|\vect{\Theta}`,
            whose parameters will be overwritten by :math:`g(\vect{Y})`.

        """
        return _dist_bundle2.ConditionalDistribution_setConditionedDistribution(self, conditionedDistribution)

    def getConditionedDistribution(self):
        r"""
        Accessor to the distribution's conditioned distribution parameter *conditionedDistribution*.

        Returns
        -------
        conditionedDistribution : :class:`~openturns.Distribution`
            the distribution of :math:`\vect{X}|\vect{\Theta}`,
            whose parameters will be overwritten by :math:`g(\vect{Y})`.

        """
        return _dist_bundle2.ConditionalDistribution_getConditionedDistribution(self)

    def setConditioningDistribution(self, conditioningDistribution):
        r"""
        Accessor to the distribution's conditioned distribution parameter *conditioningDistribution*.

        Parameters
        ----------
        conditioningDistribution : :class:`~openturns.Distribution`
            the distribution of :math:`\vect{Y}`, specified with its parameters.

        """
        return _dist_bundle2.ConditionalDistribution_setConditioningDistribution(self, conditioningDistribution)

    def getConditioningDistribution(self):
        r"""
        Accessor to the distribution's conditioned distribution parameter *conditioningDistribution*.

        Returns
        -------
        conditioningDistribution : :class:`~openturns.Distribution`
            the distribution of :math:`\vect{Y}`, specified with its parameters.

        """
        return _dist_bundle2.ConditionalDistribution_getConditioningDistribution(self)

    def setLinkFunction(self, linkFunction):
        r"""
        Accessor to the distribution's conditioned distribution parameter *linkFunction*.

        Parameters
        ----------
        linkFunction : :class:`~openturns.Function`
            the function :math:`g: \Rset^p \rightarrow \Rset^q`, where :math:`p` is the dimension of
            *conditioningDist* and :math:`q` is the dimension of :math:`\vect{\Theta}`.

        """
        return _dist_bundle2.ConditionalDistribution_setLinkFunction(self, linkFunction)

    def getLinkFunction(self):
        r"""
        Accessor to the distribution's conditioned distribution parameter *linkFunction*.

        Returns
        -------
        linkFunction : :class:`~openturns.Function`
            the function :math:`g: \Rset^p \rightarrow \Rset^q`, where :math:`p` is the dimension of
            *conditioningDist* and :math:`q` is the dimension of :math:`\vect{\Theta}`.

        """
        return _dist_bundle2.ConditionalDistribution_getLinkFunction(self)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.ConditionalDistribution_getMarginal(self, *args)

    def __init__(self, *args):
        _dist_bundle2.ConditionalDistribution_swiginit(self, _dist_bundle2.new_ConditionalDistribution(*args))
    __swig_destroy__ = _dist_bundle2.delete_ConditionalDistribution

# Register ConditionalDistribution in _dist_bundle2:
_dist_bundle2.ConditionalDistribution_swigregister(ConditionalDistribution)
class Multinomial(openturns.model_copula.DiscreteDistribution):
    r"""
    Multinomial distribution.


    Parameters
    ----------
    N : int
        Number of trials.

        Default value is 1.
    P : sequence of float, :math:`p_i \geq 0, i = 1, \ldots, d` and :math:`\sum_{i = 1}^d p_i \leq 1`
        Component probabilities.

        Default value is [0.5].

    Notes
    -----

    This distribution differs from the classical multinomial distribution definition. The classical multinomial distribution is
    constrained by :math:`\sum_{i = 1}^d p_i=1` and is supported by
    :math:`\left\{\vect{x} \in \Nset^d\, |\, \sum_{i = 1}^d x_i = N\right\}`. The OpenTURNS distribution is
    constrained by :math:`q=\sum_{i = 1}^d p_i` with :math:`q\leq 1` and is supported in general by
    :math:`\cS=\left\{\vect{x} \in \Nset^d\, |\, \sum_{i = 1}^d x_i \leq N\right\}`.

    Its probability distribution function is defined as:

    .. math::

        \Prob{\vect{X} = \vect{x}} = \frac{N!}{x_1! \ldots x_d! (N - s)!}
                                     p_1^{x_1} \ldots p_d^{x_d} (1 - q)^{N - s}\mathbf{1}_{\vect{x} \in \cS}

    where :math:`s=\sum_{i = 1}^d x_i`.

    If :math:`q=1`, then the distribution generates realizations :math:`\vect{x}=(x_1,\dots,x_d)` such that :math:`\sum_{i = 1}^d x_i = N`. In this case, we recover the classical definition of the multinomial distribution.

    If :math:`q<1`, then the distribution generates realizations :math:`\vect{x}=(x_1,\dots,x_d)` such that :math:`\sum_{i = 1}^d x_i \leq N`. It allows one to recover the binomial distribution as a special case of multinomial distribution when :math:`d=1`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X_i} & = & N p_i, \quad i = 1, \ldots, n \\
            \Var{X_i} & = & N p_i (1 - p_i), \quad i = 1, \ldots, n \\
            \Cov{X_i, X_j} & = & - N p_i p_j, \quad i, j = 1, \ldots, n, i \neq j
        \end{eqnarray*}

    See Also
    --------
    Dirichlet

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Multinomial(1, [0.5])

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Multinomial_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.Multinomial___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.Multinomial___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.Multinomial___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.Multinomial_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle2.Multinomial_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Multinomial_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Multinomial_computeCDF(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\vect{a}` and
        :math:`\vect{b}`:

        .. math::

            \Prob{\bigcap\limits_{i=1}^n a_i < X_i \leq b_i} =
                \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, n)}` with :math:`c_i \in [a_i, b_i]`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.Multinomial_computeProbability(self, interval)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Survival function input(s).

        Returns
        -------
        S : float, :class:`~openturns.Point`
            Survival function value(s) at input(s) `x`.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` is defined as follows:

        .. math::


            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^d X_i > x_i}
                     \quad \forall \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function (except for
            1-dimensional distributions).

        See Also
        --------
        computeComplementaryCDF
        """
        return _dist_bundle2.Multinomial_computeSurvivalFunction(self, *args)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle2.Multinomial_computeConditionalPDF(self, *args)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \mid X_1, \ldots, X_{n - 1}}(x_n) =
                \Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}},
                \quad x_n \in \supp{X_n}
        """
        return _dist_bundle2.Multinomial_computeConditionalCDF(self, *args)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`0 < p < 1`
            Conditional quantile function input.
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        X1 : float
            Conditional quantile at input :math:`p`, :math:`X_{cond}`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle2.Multinomial_computeConditionalQuantile(self, *args)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.Multinomial_getMarginal(self, *args)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.Multinomial_getSupport(self, *args)

    def getParametersCollection(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameters : :class:`~openturns.PointWithDescription`
            Dictionary-like object with parameters names and values.
        """
        return _dist_bundle2.Multinomial_getParametersCollection(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.Multinomial_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.Multinomial_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.Multinomial_getParameterDescription(self)

    def isElliptical(self):
        r"""
        Test whether the distribution is elliptical or not.

        Returns
        -------
        test : bool
            Answer.

        Notes
        -----
        A multivariate distribution is said to be *elliptical* if its characteristic
        function is of the form:

        .. math::

            \phi(\vect{t}) = \exp\left(i \Tr{\vect{t}} \vect{\mu}\right)
                             \Psi\left(\Tr{\vect{t}} \mat{\Sigma} \vect{t}\right),
                             \quad \vect{t} \in \Rset^n

        for specified vector :math:`\vect{\mu}` and positive-definite matrix
        :math:`\mat{\Sigma}`. The function :math:`\Psi` is known as the
        *characteristic generator* of the elliptical distribution.
        """
        return _dist_bundle2.Multinomial_isElliptical(self)

    def setP(self, p):
        r"""
        Accessor to the component probabilities parameter :math:`\vect{p}`.

        Parameters
        ----------
        P : sequence of float, :math:`0 \leq p_i, i = 1, \ldots, n` and :math:`\sum_{i = 1}^n p_i \leq 1`
            Component probabilities (all positive with sum less than unity).
        """
        return _dist_bundle2.Multinomial_setP(self, p)

    def getP(self):
        r"""
        Accessor to the component probabilities parameter :math:`\vect{p}`.

        Returns
        -------
        P : :class:`~openturns.Point`
            Component probabilities :math:`\vect{p}`.
        """
        return _dist_bundle2.Multinomial_getP(self)

    def setN(self, n):
        r"""
        Accessor to the number of experiments parameter :math:`N`.

        Parameters
        ----------
        N : int, :math:`\sum_{i = 1}^n x_i \leq N`
            Number of experiments :math:`N`.
        """
        return _dist_bundle2.Multinomial_setN(self, n)

    def getN(self):
        r"""
        Accessor to the number of experiments parameter :math:`N`.

        Returns
        -------
        N : int
            Number of experiments :math:`N`.
        """
        return _dist_bundle2.Multinomial_getN(self)

    def setSmallA(self, smallA):
        r"""
        Accessor to the threshold in generating function computation.

        Parameters
        ----------
        smallA : float
            The threshold triggering the algorithm for the computation of the generating
            function of a truncated Poisson distribution. If the argument of the
            generating function is smaller than *smallA* the computation is done using
            the polynomial form of the generating function, otherwise it is done as a
            correction of the generating function of the untruncated Poisson distribution.
        """
        return _dist_bundle2.Multinomial_setSmallA(self, smallA)

    def getSmallA(self):
        r"""
        Accessor to the threshold in generating function computation.

        Returns
        -------
        smallA : float
            The threshold triggering the algorithm for the computation of the generating
            function of a truncated Poisson distribution. If the argument of the
            generating function is smaller than *smallA* the computation is done using
            the polynomial form of the generating function, otherwise it is done as a
            correction of the generating function of the untruncated Poisson distribution.
        """
        return _dist_bundle2.Multinomial_getSmallA(self)

    def setEta(self, eta):
        r"""
        Accessor to the maximum absolute error in CDF computation.

        Parameters
        ----------
        eta : float
            The maximum absolute error in the Poisson summation-based CDF computation.
        """
        return _dist_bundle2.Multinomial_setEta(self, eta)

    def getEta(self):
        r"""
        Accessor to the maximum absolute error in CDF computation.

        Returns
        -------
        eta : float
            The maximum absolute error in the Poisson summation-based CDF computation.
        """
        return _dist_bundle2.Multinomial_getEta(self)

    def __init__(self, *args):
        _dist_bundle2.Multinomial_swiginit(self, _dist_bundle2.new_Multinomial(*args))
    __swig_destroy__ = _dist_bundle2.delete_Multinomial

# Register Multinomial in _dist_bundle2:
_dist_bundle2.Multinomial_swigregister(Multinomial)
class MultinomialFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Multinomial factory.

    Notes
    -----
    The parameters :math:`N` and :math:`p=(p_1,\dots,p_d)` are estimated using their
    maximum likelihood estimators:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          data : (\vect{x}^1, \hdots,\vect{x}^n)\\
          N = \max_{k} \sum_{i=1}^d x_i^k\\
          p_i = \frac{1}{nN} \sum_{k=1}^{n} x_i^k
        \end{eqnarray*}

    Remember that the OpenTURNS multinomial distribution is such that
    :math:`\sum_{k=1}^d X_i\leq N`.

    See also
    --------
    DistributionFactory, Multinomial
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.MultinomialFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.MultinomialFactory_build(self, *args)

    def buildAsMultinomial(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsMultinomial()

            buildAsMultinomial(*sample*)

            buildAsMultinomial(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
           The parameters of the :class:`~openturns.Multinomial`.

        Returns
        -------
        distribution : :class:`~openturns.Multinomial`
            The estimated distribution as a Multinomial.

            In the first usage, the default Multinomial distribution is built.
        """
        return _dist_bundle2.MultinomialFactory_buildAsMultinomial(self, *args)

    def __init__(self, *args):
        _dist_bundle2.MultinomialFactory_swiginit(self, _dist_bundle2.new_MultinomialFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_MultinomialFactory

# Register MultinomialFactory in _dist_bundle2:
_dist_bundle2.MultinomialFactory_swigregister(MultinomialFactory)
class NegativeBinomial(openturns.model_copula.DiscreteDistribution):
    r"""
    NegativeBinomial distribution.


    Parameters
    ----------
    r : float, :math:`r > 0`
        Number of failures until the Bernoulli trial is stopped.

        Default value is 1.0.

    p : float, :math:`0 < p < 1`
        Success probability of the Bernoulli trial.

        Default value is 0.5.

    Notes
    -----
    Its probability distribution function is defined as:

    .. math::

        \Prob{X = k} = \frac{\Gamma(k + r)}{\Gamma(r)\Gamma(k+1)}p^k(1-p)^r,
                       \, \forall k \in \Nset

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \frac{rp}{1-p} \\
            \Var{X} & = & \frac{rp}{(1-p)^2}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.NegativeBinomial(1.0, 0.6)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NegativeBinomial_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.NegativeBinomial___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.NegativeBinomial___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.NegativeBinomial___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.NegativeBinomial_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.NegativeBinomial_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.NegativeBinomial_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.NegativeBinomial_computeComplementaryCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.NegativeBinomial_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.NegativeBinomial_computeCDFGradient(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.NegativeBinomial_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.NegativeBinomial_computeLogCharacteristicFunction(self, x)

    def computeGeneratingFunction(self, z):
        r"""
        Compute the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        g : float
            Probability-generating function value at input :math:`X`.

        Notes
        -----
        The probability-generating function is defined as follows:

        .. math::

            G_X(z) = \Expect{z^X}, \quad z \in \Cset

        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete
        """
        return _dist_bundle2.NegativeBinomial_computeGeneratingFunction(self, z)

    def computeLogGeneratingFunction(self, z):
        r"""
        Compute the logarithm of the probability-generating function.

        Parameters
        ----------
        z : float or complex
            Probability-generating function input.

        Returns
        -------
        lg : float
            Logarithm of the probability-generating function value at input :math:`X`.

        Notes
        -----
        This function only exists for discrete distributions. OpenTURNS implements
        this method for univariate distributions only.

        See Also
        --------
        isDiscrete, computeGeneratingFunction
        """
        return _dist_bundle2.NegativeBinomial_computeLogGeneratingFunction(self, z)

    def getSupport(self, *args):
        r"""
        Accessor to the support of the distribution.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval to intersect with the support of the discrete part of the distribution.

        Returns
        -------
        support : :class:`~openturns.Interval`
            The intersection of the support of the discrete part of the distribution with the given `interval`.

        Notes
        -----
        The mathematical support :math:`\supp{\vect{X}}` of the discrete part of a distribution is the collection of points with nonzero probability.

        This is yet implemented for discrete distributions only.

        See Also
        --------
        getRange
        """
        return _dist_bundle2.NegativeBinomial_getSupport(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.NegativeBinomial_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.NegativeBinomial_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.NegativeBinomial_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.NegativeBinomial_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.NegativeBinomial_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.NegativeBinomial_getParameterDescription(self)

    def setP(self, p):
        r"""
        Accessor to the success probability parameter.

        Parameters
        ----------
        p : float, :math:`0 \leq p \leq 1`
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle2.NegativeBinomial_setP(self, p)

    def getP(self):
        r"""
        Accessor to the success probability parameter.

        Returns
        -------
        p : float
            The success probability of the Bernoulli trial.
        """
        return _dist_bundle2.NegativeBinomial_getP(self)

    def setR(self, r):
        r"""
        Accessor to the number of failures parameter.

        Parameters
        ----------
        r : float, :math:`r > 0`
            Number of failures until the Bernoulli trial is stopped.
        """
        return _dist_bundle2.NegativeBinomial_setR(self, r)

    def getR(self):
        r"""
        Accessor to the number of failures parameter.

        Returns
        -------
        r : float
            Number of failures until the Bernoulli trial is stopped.
        """
        return _dist_bundle2.NegativeBinomial_getR(self)

    def __init__(self, *args):
        _dist_bundle2.NegativeBinomial_swiginit(self, _dist_bundle2.new_NegativeBinomial(*args))
    __swig_destroy__ = _dist_bundle2.delete_NegativeBinomial

# Register NegativeBinomial in _dist_bundle2:
_dist_bundle2.NegativeBinomial_swigregister(NegativeBinomial)
class NegativeBinomialFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Negative Binomial factory.

    Notes
    -----
    We use the following estimator:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          data : (\vect{x}^1, \hdots,\vect{x}^n)\\
          \displaystyle  \hat{p}_n = \frac{\bar{x}_n}{\hat{r}_n+\bar{x}_n} \\
          \displaystyle  \hat{r}_n\mbox{ solution of } n\left(\log\left(\frac{\hat{r}_n}{\hat{r}_n+\bar{x}_n}\right)-\psi(\hat{r}_n)\right)+\sum_{i=1}^n\psi(x^i+\hat{r}_n)=0\\
          \mbox{The resolution is done using Brent's method.}
        \end{eqnarray*}

    See also
    --------
    DistributionFactory, NegativeBinomial
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NegativeBinomialFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.NegativeBinomialFactory_build(self, *args)

    def buildAsNegativeBinomial(self, *args):
        r"""
        Estimate the distribution as native distribution.

        **Available usages**:

            buildAsNegativeBinomial()

            buildAsNegativeBinomial(*sample*)

            buildAsNegativeBinomial(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
           The parameters of the :class:`~openturns.NegativeBinomial`.

        Returns
        -------
        distribution : :class:`~openturns.NegativeBinomial`
            The estimated distribution as a NegativeBinomial.

            In the first usage, the default NegativeBinomial distribution is built.
        """
        return _dist_bundle2.NegativeBinomialFactory_buildAsNegativeBinomial(self, *args)

    def __init__(self, *args):
        _dist_bundle2.NegativeBinomialFactory_swiginit(self, _dist_bundle2.new_NegativeBinomialFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_NegativeBinomialFactory

# Register NegativeBinomialFactory in _dist_bundle2:
_dist_bundle2.NegativeBinomialFactory_swigregister(NegativeBinomialFactory)
class NonCentralChiSquare(openturns.model_copula.ContinuousDistribution):
    r"""
    NonCentralChiSquare distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        Generalised number degree of freedom.

        Default value is 5.0.
    lambda : float, :math:`\lambda \geq 0`
        Non-centrality parameter :math:`\lambda`.

        Default value is 0.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \sum_{j=0}^{\infty} e^{-\lambda}
                                     \frac{\lambda^j}{j!}p_{\chi^2(\nu + 2j)}(x),
                 \quad x \in [0; +\infty[

    where :math:`p_{\chi^2(q)}` is the probability density function of a
    :math:`\chi^2(q)` random variate.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \nu + \lambda \\
            \Var{X} & = & 2(\nu + 2\lambda)
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.NonCentralChiSquare(6.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NonCentralChiSquare_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.NonCentralChiSquare___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.NonCentralChiSquare___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.NonCentralChiSquare___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.NonCentralChiSquare_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.NonCentralChiSquare_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.NonCentralChiSquare_computeCDF(self, *args)

    def computeCharacteristicFunction(self, x):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.NonCentralChiSquare_computeCharacteristicFunction(self, x)

    def computeLogCharacteristicFunction(self, x):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.NonCentralChiSquare_computeLogCharacteristicFunction(self, x)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.NonCentralChiSquare_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.NonCentralChiSquare_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.NonCentralChiSquare_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.NonCentralChiSquare_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.NonCentralChiSquare_getKurtosis(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.NonCentralChiSquare_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.NonCentralChiSquare_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.NonCentralChiSquare_getParameterDescription(self)

    def setNu(self, nu):
        r"""
        Accessor to the distribution's generalised number degrees of freedom.

        Parameters
        ----------
        nu : float, :math:`\nu > 0`
            Generalised number degrees of freedom :math:`\nu`.
        """
        return _dist_bundle2.NonCentralChiSquare_setNu(self, nu)

    def setNuLambda(self, nu, _lambda):
        r"""
        Accessor to the distribution's non-centrality parameters.

        Parameters :math:`\lambda` and generalised number degrees of freedom.

        Parameters
        ----------
        nu : float, :math:`\nu > 0`
            Generalised number degrees of freedom :math:`\nu`.
        lambda : float
            Non-centrality parameter :math:`\lambda`.
        """
        return _dist_bundle2.NonCentralChiSquare_setNuLambda(self, nu, _lambda)

    def getNu(self):
        r"""
        Accessor to the distribution's generalised number degrees of freedom.

        Returns
        -------
        nu : float
            Generalised number degrees of freedom :math:`\nu`.
        """
        return _dist_bundle2.NonCentralChiSquare_getNu(self)

    def setLambda(self, _lambda):
        r"""
        Accessor to the distribution's non-centrality parameter :math:`\lambda`.

        Parameters
        ----------
        lambda : float
            Non-centrality parameter :math:`\lambda`.
        """
        return _dist_bundle2.NonCentralChiSquare_setLambda(self, _lambda)

    def getLambda(self):
        r"""
        Accessor to the distribution's non-centrality parameter :math:`\lambda`.

        Returns
        -------
        lambda : float
            Non-centrality parameter :math:`\lambda`.
        """
        return _dist_bundle2.NonCentralChiSquare_getLambda(self)

    def setMaximumIteration(self, maximumIteration):
        r"""
        Accessor to the maximum iteration number for PDF and CDF computation.

        Parameters
        ----------
        maximumIteration : int
            Maximum iteration number for :class:`~openturns.DistFunc.dNonCentralChiSquare` and
            :class:`~openturns.DistFunc.pNonCentralChiSquare`.
        """
        return _dist_bundle2.NonCentralChiSquare_setMaximumIteration(self, maximumIteration)

    def getMaximumIteration(self):
        r"""
        Accessor to the maximum iteration number for PDF and CDF computation.

        Returns
        -------
        maximumIteration : int
            Maximum iteration number for :class:`~openturns.DistFunc.dNonCentralChiSquare` and
            :class:`~openturns.DistFunc.pNonCentralChiSquare`.
        """
        return _dist_bundle2.NonCentralChiSquare_getMaximumIteration(self)

    def __init__(self, *args):
        _dist_bundle2.NonCentralChiSquare_swiginit(self, _dist_bundle2.new_NonCentralChiSquare(*args))
    __swig_destroy__ = _dist_bundle2.delete_NonCentralChiSquare

# Register NonCentralChiSquare in _dist_bundle2:
_dist_bundle2.NonCentralChiSquare_swigregister(NonCentralChiSquare)
class NonCentralStudent(openturns.model_copula.ContinuousDistribution):
    r"""
    NonCentralStudent distribution.

    Parameters
    ----------
    nu : float, :math:`\nu > 0`
        Generalised number degree of freedom.

        Default value is 5.0.
    delta : float
        Non-centrality parameter :math:`\delta`.

        Default value is 0.0.
    gamma : float
        Position parameter :math:`\gamma`.

        Default value is 0.0.

    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_X(x) = \frac{exp \left(-\delta^2 / 2 \right)}
                      {\sqrt{\nu\pi} \Gamma \left(\frac{\nu}{2} \right)}
                 \left(\frac{\nu}{\nu + (x - \gamma)^2}\right) ^ {\frac{\nu + 1}{2}}
                 \sum_{j=0}^{\infty}
                 \frac{\Gamma \left(\frac{\nu + j + 1}{2}\right)}{\Gamma(j + 1)}
                 \left(\delta(x - \gamma)
                 \sqrt{\frac{2}{\nu + (x - \gamma)^2}}\right) ^ j,
                 \quad x \in \Rset

    With :math:`\Gamma` denotes Euler's Gamma function
    :meth:`~openturns.SpecFunc.Gamma`.

    Its first moments are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{X} & = & \gamma + \delta \sqrt{\frac{\nu}{2}}
                             \frac{\Gamma\left(\frac{\nu - 1}{2}\right)}
                                  {\Gamma \left(\frac{\nu}{2}\right)}
                           \quad \text{ if }\nu > 1\\
            \Var{X} & = & \frac{\nu}{\nu - 2} (1 + \delta^2) -
                          \left(\frac{\nu}{2}\delta^2
                          \frac{\Gamma \left(\frac{\nu - 1}{2}\right)}
                               {\Gamma \left(\frac{\nu}{2}\right)}
                           - \gamma \right)^2
                        \quad \text{ if }\nu>2
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.NonCentralStudent(6.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NonCentralStudent_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.NonCentralStudent___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.NonCentralStudent___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.NonCentralStudent___str__(self, *args)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.NonCentralStudent_getRealization(self)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.NonCentralStudent_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.NonCentralStudent_computeCDF(self, *args)

    def computePDFGradient(self, *args):
        r"""
        Compute the gradient of the probability density function.

        Parameters
        ----------
        X : sequence of float
            PDF input.

        Returns
        -------
        dfdtheta : :class:`~openturns.Point`
            Partial derivatives of the PDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.NonCentralStudent_computePDFGradient(self, *args)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.NonCentralStudent_computeCDFGradient(self, *args)

    def getStandardDeviation(self):
        r"""
        Accessor to the componentwise standard deviation.

        The standard deviation is the square root of the variance.

        Returns
        -------
        sigma : :class:`~openturns.Point`
            Componentwise standard deviation.

        See Also
        --------
        getCovariance
        """
        return _dist_bundle2.NonCentralStudent_getStandardDeviation(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.NonCentralStudent_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.NonCentralStudent_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.NonCentralStudent_getStandardRepresentative(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.NonCentralStudent_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.NonCentralStudent_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.NonCentralStudent_getParameterDescription(self)

    def setNu(self, nu):
        r"""
        Accessor to the distribution's generalised number degrees of freedom.

        Parameters
        ----------
        nu : float, :math:`\nu > 0`
            Generalised number degrees of freedom :math:`\nu`.
        """
        return _dist_bundle2.NonCentralStudent_setNu(self, nu)

    def getNu(self):
        r"""
        Accessor to the distribution's generalised number degrees of freedom.

        Returns
        -------
        nu : float
            Generalised number degrees of freedom :math:`\nu`.
        """
        return _dist_bundle2.NonCentralStudent_getNu(self)

    def setDelta(self, delta):
        r"""
        Accessor to the distribution's non-centrality parameter.

        Parameters
        ----------
        delta : float
            Non-centrality parameter :math:`\delta`.
        """
        return _dist_bundle2.NonCentralStudent_setDelta(self, delta)

    def getDelta(self):
        r"""
        Accessor to the distribution's non-centrality parameter.

        Returns
        -------
        delta : float
            Non-centrality parameter :math:`\delta`.
        """
        return _dist_bundle2.NonCentralStudent_getDelta(self)

    def setGamma(self, gamma):
        r"""
        Accessor to the distribution's position from the origin.

        Parameters
        ----------
        gamma : float
            Position parameter :math:`\gamma`.
        """
        return _dist_bundle2.NonCentralStudent_setGamma(self, gamma)

    def getGamma(self):
        r"""
        Accessor to the distribution's position from the origin.

        Returns
        -------
        gamma : float
            Position parameter :math:`\gamma`.
        """
        return _dist_bundle2.NonCentralStudent_getGamma(self)

    def __init__(self, *args):
        _dist_bundle2.NonCentralStudent_swiginit(self, _dist_bundle2.new_NonCentralStudent(*args))
    __swig_destroy__ = _dist_bundle2.delete_NonCentralStudent

# Register NonCentralStudent in _dist_bundle2:
_dist_bundle2.NonCentralStudent_swigregister(NonCentralStudent)
class Normal(openturns.model_copula.EllipticalDistribution):
    r"""
    Normal distribution.

    Available constructors:
        Normal(*mu, sigma*)

        Normal(*mu, sigma, R*)

        Normal(*mu, Sigma*)

    Parameters
    ----------
    d : int, :math:`d \geq 1`
        Dimension.

        Default value is 1.

    mu : float :math:`\mu`, sequence of float, :math:`\vect{\mu} \in \Rset^d`
        Mean.

        Default value is 0.0.

    sigma : float :math:`\sigma`, sequence of float, :math:`\vect{\sigma} \in \Rset^{*d}_+`
        Scale parameter.

        Default value is 1.0.

    R : :class:`~openturns.CorrelationMatrix` :math:`\mat{R} \in  \cM_{d \times d}(\Rset)`
        Correlation matrix.

        Default value is the identity matrix.

    Sigma : :class:`~openturns.CovarianceMatrix` :math:`\mat{\Sigma} \in  \cM_{d \times d}(\Rset)`
        Covariance matrix.

    Notes
    -----
    In the first usage, a scalar centered and unit-variance normal distribution is built.

    Its probability density function is defined as:

    .. math::

        f_{\vect{X}}(\vect{x}) = \frac{1}
                 {\displaystyle (2\pi)^{\frac{n}{2}}
                                (\mathrm{det}\mat{\Sigma})^{\frac{1}{2}}}
                 \displaystyle exp \left(-\frac{1}{2}\Tr{(\vect{x} - \vect{\mu})}
                                         \mat{\Sigma}^{-1}(\vect{x} - \vect{\mu})\right)

    with :math:`\mat{\Sigma} = \diag(\vect{\sigma}) \mat{R} \diag(\vect{\sigma})`.
    Both :math:`\mat{R}` and :math:`\mat{\Sigma}` are symmetric positive definite.

    The first moments of the distribution are:

    .. math::
        :nowrap:

        \begin{eqnarray*}
            \Expect{\vect{X}} & = & \vect{\mu} \\
            \Var{\vect{X}} & = & \mat{\Sigma}
        \end{eqnarray*}

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.Normal(0.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)

    Create a multivariate normal distribution with constant :math:`\sigma` and identity correlation matrix:

    >>> dimension = 5
    >>> mu = ot.Point(dimension)
    >>> sigma = ot.Point(dimension, 0.1)
    >>> R = ot.CorrelationMatrix(dimension)
    >>> distribution = ot.Normal(mu, sigma, R)
    >>> print('distribution=', distribution)
    distribution= Normal(mu = [0,0,0,0,0], sigma = [0.1,0.1,0.1,0.1,0.1], R = 5x5
    [[ 1 0 0 0 0 ]
     [ 0 1 0 0 0 ]
     [ 0 0 1 0 0 ]
     [ 0 0 0 1 0 ]
     [ 0 0 0 0 1 ]])

    Create a multivariate normal distribution from a covariance matrix:

    >>> Sigma = ot.CovarianceMatrix(dimension)
    >>> Sigma[1, 1] = 3.0
    >>> Sigma[0, 2] = -0.5
    >>> Sigma[3, 4] = -0.2
    >>> distribution = ot.Normal(mu, Sigma)
    >>> print('distribution=', distribution)
    distribution= Normal(mu = [0,0,0,0,0], sigma = [1,1.73205,1,1,1], R = 5x5
    [[  1    0   -0.5  0    0   ]
     [  0    1    0    0    0   ]
     [ -0.5  0    1    0    0   ]
     [  0    0    0    1   -0.2 ]
     [  0    0    0   -0.2  1   ]])
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.Normal_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.Normal___eq__(self, *args)

    def __repr__(self):
        return _dist_bundle2.Normal___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.Normal___str__(self, *args)

    def computeDensityGenerator(self, betaSquare):
        r"""
        Compute the density generator.

        Parameters
        ----------
        y : float
            Input.

        Returns
        -------
        p : float
            Value :math:`\varphi(y)`.

        Notes
        -----
        The density generator is the function :math:`\varphi` such that the probability density function
        of the elliptical distribution rewrites:

        .. math::

            f_{\vect{X}}(\vect{x}) =
                \varphi\left(\Tr{\left(\vect{x} - \vect{\mu}\right)}
                              \mat{\Sigma}^{-1}
                              \left(\vect{x} - \vect{\mu}\right)
                    \right),
                \quad \vect{x} \in \supp{\vect{X}}

        The density generator only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computePDF
        """
        return _dist_bundle2.Normal_computeDensityGenerator(self, betaSquare)

    def computeLogDensityGenerator(self, betaSquare):
        r"""
        Computes the log of the density generator.

        Parameters
        ----------
        y : float
            Input.

        Returns
        -------
        p : float
            Value :math:`\log \varphi(y)`.

        Notes
        -----
        The density generator  :math:`\varphi` is defined in :eq:`generator`.

        See Also
        --------
        isElliptical, computePDF
        """
        return _dist_bundle2.Normal_computeLogDensityGenerator(self, betaSquare)

    def computeDensityGeneratorDerivative(self, betaSquare):
        r"""
        Compute the first-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Value :math:`\dfrac{d\varphi}{d\,t}(y)`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _dist_bundle2.Normal_computeDensityGeneratorDerivative(self, betaSquare)

    def computeDensityGeneratorSecondDerivative(self, betaSquare):
        r"""
        Compute the second-order derivative of the probability density function.

        PDF of the characteristic generator of the elliptical distribution.

        Parameters
        ----------
        beta2 : float
            Density generator input.

        Returns
        -------
        p : float
            Value :math:`\dfrac{d^2\varphi}{d\,t^2}(y)`.

        Notes
        -----
        This function only exists for elliptical distributions.

        See Also
        --------
        isElliptical, computeDensityGenerator
        """
        return _dist_bundle2.Normal_computeDensityGeneratorSecondDerivative(self, betaSquare)

    def getRealization(self):
        r"""
        Accessor to a pseudo-random realization from the distribution.

        Refer to :ref:`distribution_realization`.

        Returns
        -------
        point : :class:`~openturns.Point`
            A pseudo-random realization of the distribution.

        See Also
        --------
        getSample, getSampleByInversion, getSampleByQMC, RandomGenerator
        """
        return _dist_bundle2.Normal_getRealization(self)

    def getSample(self, size):
        r"""
        Accessor to a pseudo-random sample from the distribution.

        Parameters
        ----------
        size : int
            Sample size.

        Returns
        -------
        sample : :class:`~openturns.Sample`
            A pseudo-random sample of the distribution.

        See Also
        --------
        getRealization, RandomGenerator, getSampleByInversion, getSampleByQMC
        """
        return _dist_bundle2.Normal_getSample(self, size)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Normal_computePDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.Normal_computeCDF(self, *args)

    def computeComplementaryCDF(self, *args):
        r"""
        Compute the complementary cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            Complementary CDF input(s).

        Returns
        -------
        C : float, :class:`~openturns.Point`
            Complementary CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The complementary cumulative distribution function.

        .. math::

            1 - F_{\vect{X}}(\vect{x}) = 1 - \Prob{\bigcap_{i=1}^n X_i \leq x_i}, \quad \vect{x} \in \supp{\vect{X}}

        .. warning::
            This is not the survival function (except for 1-dimensional
            distributions).

        See Also
        --------
        computeSurvivalFunction
        """
        return _dist_bundle2.Normal_computeComplementaryCDF(self, *args)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle2.Normal_computeEntropy(self)

    def computeCharacteristicFunction(self, *args):
        r"""
        Compute the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Characteristic function value at input :math:`t`.

        Notes
        -----
        The characteristic function is defined as:

        .. math::
            \phi_X(t) = \mathbb{E}\left[\exp(- i t X)\right],
                        \quad t \in \Rset

        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.
        """
        return _dist_bundle2.Normal_computeCharacteristicFunction(self, *args)

    def computeLogCharacteristicFunction(self, *args):
        r"""
        Compute the logarithm of the characteristic function.

        Parameters
        ----------
        t : float
            Characteristic function input.

        Returns
        -------
        phi : complex
            Logarithm of the characteristic function value at input :math:`t`.

        Notes
        -----
        OpenTURNS features a generic implementation of the characteristic function for
        all its univariate distributions (both continuous and discrete). This default
        implementation might be time consuming, especially as the modulus of :math:`t` gets
        high. Only some univariate distributions benefit from dedicated more efficient
        implementations.

        See Also
        --------
        computeCharacteristicFunction
        """
        return _dist_bundle2.Normal_computeLogCharacteristicFunction(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\vect{a}` and
        :math:`\vect{b}`:

        .. math::

            \Prob{\bigcap\limits_{i=1}^n a_i < X_i \leq b_i} =
                \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, n)}` with :math:`c_i \in [a_i, b_i]`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.Normal_computeProbability(self, interval)

    def computeCDFGradient(self, *args):
        r"""
        Compute the gradient of the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float
            CDF input.

        Returns
        -------
        dFdtheta : :class:`~openturns.Point`
            Partial derivatives of the CDF with respect to the distribution
            parameters at input :math:`X`.
        """
        return _dist_bundle2.Normal_computeCDFGradient(self, *args)

    def computeRadialDistributionCDF(self, radius, tail=False):
        r"""
        Compute the cumulative distribution function of the squared radius.

        For the underlying standard spherical distribution (for elliptical
        distributions only).

        Parameters
        ----------
        r2 : float, :math:`0 \leq r^2`
            Squared radius.

        Returns
        -------
        F : float
            CDF value at input :math:`r^2`.

        Notes
        -----
        This is the CDF of the sum of the squared independent, standard, identically
        distributed components:

        .. math::

            R^2 = \sqrt{\sum\limits_{i=1}^n U_i^2}
        """
        return _dist_bundle2.Normal_computeRadialDistributionCDF(self, radius, tail)

    def computeConditionalPDF(self, *args):
        r"""
        Compute the conditional probability density function.

        Conditional PDF of the last component with respect to the other fixed components.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional PDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional PDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        See Also
        --------
        computePDF, computeConditionalCDF
        """
        return _dist_bundle2.Normal_computeConditionalPDF(self, *args)

    def computeSequentialConditionalPDF(self, x):
        r"""
        Compute the sequential conditional probability density function.

        Parameters
        ----------
        X : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the PDF.

        Returns
        -------
        pdf : sequence of float
            Conditional PDF values at input.

        Notes
        -----
        The sequential conditional density function is defined as follows:

        .. math::

            pdf^{seq}_{X_1,\ldots,X_d}(x_1,\ldots,x_d) = \left(\dfrac{d}{d\,x_n}\Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}}\right)_{i=1,\ldots,d}

        ie its :math:`n`-th component is the conditional PDF of :math:`X_n` at :math:`x_n` given that :math:`X_1=x_1,\ldots,X_{n-1}=x_{n-1}`. For :math:`n=1` it reduces to :math:`\dfrac{d}{d\,x_1}\Prob{X_1 \leq x_1}`, ie the PDF of the first component at :math:`x_1`.
        """
        return _dist_bundle2.Normal_computeSequentialConditionalPDF(self, x)

    def computeConditionalCDF(self, *args):
        r"""
        Compute the conditional cumulative distribution function.

        Parameters
        ----------
        Xn : float, sequence of float
            Conditional CDF input (last component).
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        F : float, sequence of float
            Conditional CDF value(s) at input :math:`X_n`, :math:`X_{cond}`.

        Notes
        -----
        The conditional cumulative distribution function of the last component with
        respect to the other fixed components is defined as follows:

        .. math::

            F_{X_n \mid X_1, \ldots, X_{n - 1}}(x_n) =
                \Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}},
                \quad x_n \in \supp{X_n}
        """
        return _dist_bundle2.Normal_computeConditionalCDF(self, *args)

    def computeSequentialConditionalCDF(self, x):
        r"""
        Compute the sequential conditional cumulative distribution functions.

        Parameters
        ----------
        X : sequence of float, with size :math:`d`
            Values to be taken sequentially as argument and conditioning part of the CDF.

        Returns
        -------
        F : sequence of float
            Conditional CDF values at input.

        Notes
        -----
        The sequential conditional cumulative distribution function is defined as follows:

        .. math::

            F^{seq}_{X_1,\ldots,X_d}(x_1,\ldots,x_d) = \left(\Prob{X_n \leq x_n \mid X_1=x_1, \ldots, X_{n-1}=x_{n-1}}\right)_{i=1,\ldots,d}

        ie its :math:`n`-th component is the conditional CDF of :math:`X_n` at :math:`x_n` given that :math:`X_1=x_1,\ldots,X_{n-1}=x_{n-1}`. For :math:`n=1` it reduces to :math:`\Prob{X_1 \leq x_1}`, ie the CDF of the first component at :math:`x_1`.
        """
        return _dist_bundle2.Normal_computeSequentialConditionalCDF(self, x)

    def computeConditionalQuantile(self, *args):
        r"""
        Compute the conditional quantile function of the last component.

        Conditional quantile with respect to the other fixed components.

        Parameters
        ----------
        p : float, sequence of float, :math:`0 < p < 1`
            Conditional quantile function input.
        Xcond : sequence of float, 2-d sequence of float with size :math:`n-1`
            Conditioning values for the other components.

        Returns
        -------
        X1 : float
            Conditional quantile at input :math:`p`, :math:`X_{cond}`.

        See Also
        --------
        computeQuantile, computeConditionalCDF
        """
        return _dist_bundle2.Normal_computeConditionalQuantile(self, *args)

    def computeSequentialConditionalQuantile(self, q):
        r"""
        Compute the conditional quantile function of the last component.

        Parameters
        ----------
        q : sequence of float in :math:`[0,1]`, with size :math:`d`
            Values to be taken sequentially as the argument of the conditional quantile.

        Returns
        -------
        Q : sequence of float
            Conditional quantiles values at input.

        Notes
        -----
        The sequential conditional quantile function is defined as follows:

        .. math::

            Q^{seq}_{X_1,\ldots,X_d}(q_1,\ldots,q_d) = \left(F^{-1}(q_n|X_1=x_1,\ldots,X_{n-1}=x_{n_1}\right)_{i=1,\ldots,d}

        where :math:`x_1,\ldots,x_{n-1}` are defined recursively as :math:`x_1=F_1^{-1}(q_1)` and given :math:`(x_i)_{i=1,
        \ldots,n-1}`, :math:`x_n=F^{-1}(q_n|X_1=x_1,\ldots,X_{n-1}=x_{n_1})`: the conditioning part is the set of already 
        computed conditional quantiles.
        """
        return _dist_bundle2.Normal_computeSequentialConditionalQuantile(self, q)

    def getMarginal(self, *args):
        r"""
        Accessor to marginal distributions.

        Parameters
        ----------
        i : int or list of ints, :math:`1 \leq i \leq n`
            Component(s) indice(s).

        Returns
        -------
        distribution : :class:`~openturns.Distribution`
            The marginal distribution of the selected component(s).
        """
        return _dist_bundle2.Normal_getMarginal(self, *args)

    def getRoughness(self):
        r"""
        Accessor to roughness of the distribution.

        Returns
        -------
        r : float
            Roughness of the distribution.

        Notes
        -----
        The roughness of the distribution is defined as the :math:`\cL^2`-norm of its
        PDF:

        .. math::

            r = \int_{\supp{\vect{X}}} f_{\vect{X}}(\vect{x})^2 \di{\vect{x}}

        See Also
        --------
        computePDF
        """
        return _dist_bundle2.Normal_getRoughness(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.Normal_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.Normal_getKurtosis(self)

    def getStandardRepresentative(self):
        r"""
        Accessor to the standard representative distribution in the parametric family.

        Returns
        -------
        std_repr_dist : :class:`~openturns.Distribution`
            Standard representative distribution.

        Notes
        -----
        The standard representative distribution is defined on a distribution by distribution basis, most of the time by scaling the distribution with bounded support to :math:`[0,1]` or by standardizing (ie zero mean, unit variance) the distributions with unbounded support. It is the member of the family for which orthonormal polynomials will be built using generic algorithms of orthonormalization.
        """
        return _dist_bundle2.Normal_getStandardRepresentative(self)

    def setCorrelation(self, R):
        return _dist_bundle2.Normal_setCorrelation(self, R)

    def getCopula(self):
        r"""
        Accessor to the copula of the distribution.

        Returns
        -------
        C : :class:`~openturns.Distribution`
            Copula of the distribution.

        See Also
        --------
        ComposedDistribution
        """
        return _dist_bundle2.Normal_getCopula(self)

    def hasIndependentCopula(self):
        r"""
        Test whether the copula of the distribution is the independent one.

        Returns
        -------
        test : bool
            Answer.
        """
        return _dist_bundle2.Normal_hasIndependentCopula(self)

    def __init__(self, *args):
        _dist_bundle2.Normal_swiginit(self, _dist_bundle2.new_Normal(*args))
    __swig_destroy__ = _dist_bundle2.delete_Normal

# Register Normal in _dist_bundle2:
_dist_bundle2.Normal_swigregister(Normal)
class NormalFactory(openturns.model_copula.DistributionFactoryImplementation):
    r"""
    Normal factory.

    Parameters
    ----------
    robust : bool, optional
        Flag to select robust estimators of the parameters.

        By default, robust is False.

    Notes
    -----    
    The parameters are estimated by likelihood maximization if *robust=False*:

    .. math::
        :nowrap:

        \begin{eqnarray*}
          \displaystyle\Hat{\vect{\mu}}_n^{\strut} = \bar{\vect{x}}_n\\
          \displaystyle\Hat{\mathrm{Cov}}_n = \frac{1}{n-1}\sum_{i=1}^n\left(\vect{X}_i-\Hat{\vect{\mu}}_n\right)\left(\vect{X}_i-\Hat{\vect{\mu}}_n\right)^t
        \end{eqnarray*}

    If *robust=True*, the estimation is done using the empirical median :math:`q_{n, 0.5}` as an estimate of :math:`\mu`, the empirical inter-quartile :math:`frac{q_{n, 0.75}-q_{n, 0.25}}{a_{0.75}-a_{0.25}}` as an estimate of the standard deviation, where :math:`a_{0.75}` and :math:`a_{0.25}` are the 75% and 25% quantiles of the standard normal distribution, and the correlation matrix :math:`R_n` is estimated as the shape matrix of the underlying :class:`~openturns.NormalCopula` using :class:`~openturns.NormalCopulaFactory`.

    See also
    --------
    DistributionFactory, Normal, NormalCopulaFactory

    Examples
    --------

    In the following example, the parameters of a :class:`~openturns.Normal` 
    are estimated from a sample. 

    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> size = 10000
    >>> distribution = ot.Normal(1.0, 2.0)
    >>> sample = distribution.getSample(size)
    >>> factory = ot.NormalFactory()
    >>> estimated = factory.build(sample)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NormalFactory_getClassName(self)

    def build(self, *args):
        r"""
        Build the distribution.

        **Available usages**:

            build()

            build(*sample*)

            build(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        param : sequence of float
            The parameters of the distribution.

        Returns
        -------
        dist : :class:`~openturns.Distribution`
            The estimated distribution.

            In the first usage, the default native distribution is built.
        """
        return _dist_bundle2.NormalFactory_build(self, *args)

    def buildAsNormal(self, *args):
        r"""
        Estimate the distribution as native distribution.


        **Available usages**:

            buildAsNormal()

            buildAsNormal(*sample*)

            buildAsNormal(*param*)

        Parameters
        ----------
        sample : 2-d sequence of float
            Sample from which the distribution parameters are estimated.
        param : sequence of float
           The parameters of the :class:`~openturns.Normal`.

        Returns
        -------
        distribution : :class:`~openturns.Normal`
            The estimated distribution as a Normal.

            In the first usage, the default Normal distribution is built.
        """
        return _dist_bundle2.NormalFactory_buildAsNormal(self, *args)

    def buildEstimator(self, sample):
        r"""
        Build the distribution and the parameter distribution.

        Parameters
        ----------
        sample : 2-d sequence of float
            Data.
        parameters : :class:`~openturns.DistributionParameters`
            Optional, the parametrization.

        Returns
        -------
        resDist : :class:`~openturns.DistributionFactoryResult`
            The results.

        Notes
        -----
        According to the way the native parameters of the distribution are estimated, the parameters distribution differs:

            - Moments method: the asymptotic parameters distribution is normal and estimated by Bootstrap on the initial data;
            - Maximum likelihood method with a regular model: the asymptotic parameters distribution is normal and its covariance matrix is the inverse Fisher information matrix;
            - Other methods: the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting (see :class:`~openturns.KernelSmoothing`).


        If another set of parameters is specified, the native parameters distribution is first estimated and the new distribution is determined from it:

            - if the native parameters distribution is normal and the transformation regular at the estimated parameters values: the asymptotic parameters distribution is normal and its covariance matrix determined from the inverse Fisher information matrix of the native parameters and the transformation;
            - in the other cases, the asymptotic parameters distribution is estimated by Bootstrap on the initial data and kernel fitting.

        """
        return _dist_bundle2.NormalFactory_buildEstimator(self, sample)

    def __init__(self, *args):
        _dist_bundle2.NormalFactory_swiginit(self, _dist_bundle2.new_NormalFactory(*args))
    __swig_destroy__ = _dist_bundle2.delete_NormalFactory

# Register NormalFactory in _dist_bundle2:
_dist_bundle2.NormalFactory_swigregister(NormalFactory)
class NormalGamma(BayesDistribution):
    r"""
    NormalGamma distribution.

    Helper class for defining the distribution of the random vector :math:`(X,Y)` where :math:`Y` follows the distribution :math:`\Gamma(\alpha, \beta)` with :math:`\alpha>0` and :math:`\beta>0`, :math:`X|Y` follows the distribution :math:`\mathcal{N}\left(\mu, \dfrac{1}{\sqrt{\kappa Y}}\right)`.

    Parameters
    ----------

    mu : float :math:`\mu`
         Mean of the conditioned Normal distribution of :math:`X|Y`.

         Default value is 0.0.

    kappa : float  :math:`\kappa >0`
         Scale parameter of the precision (ie the inverse of the variance) of the conditioned Normal distribution of :math:`X|Y`.

         Default value is 1.0.

    alpha : float  :math:`\alpha >0`
         Shape parameter of the conditioning Gamma distribution of :math:`Y`.

         Default value is 1.0.

    beta : float  :math:`\beta >0`
         Rate parameter of the conditioning Gamma distribution of :math:`Y`.

         Default value 1.0.


    Notes
    -----
    Its probability density function is defined as:

    .. math::

        f_{(X,Y)}(x,y) = \dfrac{\beta^\alpha}{\Gamma(\alpha)}\sqrt{\dfrac{\kappa}{2\pi}}y^{\alpha-1/2}\exp\left(-\dfrac{y}{2}\left[\kappa(x-\mu)^2+2\beta\right]\right)

    Examples
    --------
    Create a distribution:

    >>> import openturns as ot
    >>> distribution = ot.NormalGamma(1.0, 2.0, 1.0, 1.0)

    Draw a sample:

    >>> sample = distribution.getSample(5)
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _dist_bundle2.NormalGamma_getClassName(self)

    def __eq__(self, *args):
        return _dist_bundle2.NormalGamma___eq__(self, *args)

    def computePDF(self, *args):
        r"""
        Compute the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            PDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The probability density function is defined as follows:

        .. math::

            f_{\vect{X}}(\vect{x}) = \frac{\partial^n F_{\vect{X}}(\vect{x})}
                                          {\prod_{i=1}^n \partial x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.NormalGamma_computePDF(self, *args)

    def computeLogPDF(self, *args):
        r"""
        Compute the logarithm of the probability density function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            PDF input(s).

        Returns
        -------
        f : float, :class:`~openturns.Point`
            Logarithm of the PDF value(s) at input(s) :math:`X`.
        """
        return _dist_bundle2.NormalGamma_computeLogPDF(self, *args)

    def computeCDF(self, *args):
        r"""
        Compute the cumulative distribution function.

        Parameters
        ----------
        X : sequence of float, 2-d sequence of float
            CDF input(s).

        Returns
        -------
        F : float, :class:`~openturns.Point`
            CDF value(s) at input(s) :math:`X`.

        Notes
        -----
        The cumulative distribution function is defined as:

        .. math::

            F_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^n X_i \leq x_i},
                                     \quad \vect{x} \in \supp{\vect{X}}
        """
        return _dist_bundle2.NormalGamma_computeCDF(self, *args)

    def computeSurvivalFunction(self, *args):
        r"""
        Compute the survival function.

        Parameters
        ----------
        x : sequence of float, 2-d sequence of float
            Survival function input(s).

        Returns
        -------
        S : float, :class:`~openturns.Point`
            Survival function value(s) at input(s) `x`.

        Notes
        -----
        The survival function of the random vector :math:`\vect{X}` is defined as follows:

        .. math::


            S_{\vect{X}}(\vect{x}) = \Prob{\bigcap_{i=1}^d X_i > x_i}
                     \quad \forall \vect{x} \in \Rset^d

        .. warning::

            This is not the complementary cumulative distribution function (except for
            1-dimensional distributions).

        See Also
        --------
        computeComplementaryCDF
        """
        return _dist_bundle2.NormalGamma_computeSurvivalFunction(self, *args)

    def computeProbability(self, interval):
        r"""
        Compute the interval probability.

        Parameters
        ----------
        interval : :class:`~openturns.Interval`
            An interval, possibly multivariate.

        Returns
        -------
        P : float
            Interval probability.

        Notes
        -----
        This computes the probability that the random vector :math:`\vect{X}` lies in
        the hyper-rectangular region formed by the vectors :math:`\vect{a}` and
        :math:`\vect{b}`:

        .. math::

            \Prob{\bigcap\limits_{i=1}^n a_i < X_i \leq b_i} =
                \sum\limits_{\vect{c}} (-1)^{n(\vect{c})}
                    F_{\vect{X}}\left(\vect{c}\right)

        where the sum runs over the :math:`2^n` vectors such that
        :math:`\vect{c} = \Tr{(c_i, i = 1, \ldots, n)}` with :math:`c_i \in [a_i, b_i]`,
        and :math:`n(\vect{c})` is the number of components in
        :math:`\vect{c}` such that :math:`c_i = a_i`.
        """
        return _dist_bundle2.NormalGamma_computeProbability(self, interval)

    def computeEntropy(self):
        r"""
        Compute the entropy of the distribution.

        Returns
        -------
        e : float
            Entropy of the distribution.

        Notes
        -----
        The entropy of a distribution is defined by:

        .. math::

            \cE_X = \Expect{-\log(p_X(\vect{X}))}

        Where the random vector :math:`\vect{X}` follows the probability
        distribution of interest, and :math:`p_X` is either the *probability
        density function* of :math:`\vect{X}` if it is continuous or the
        *probability distribution function* if it is discrete.

        """
        return _dist_bundle2.NormalGamma_computeEntropy(self)

    def __repr__(self):
        return _dist_bundle2.NormalGamma___repr__(self)

    def __str__(self, *args):
        return _dist_bundle2.NormalGamma___str__(self, *args)

    def setMu(self, mu):
        r"""
        Accessor to the parameter mu.

        Parameters
        ----------
        mu : float, :math:`\mu`,
             Mean of the conditioned Normal distribution of :math:`X|Y`
        """
        return _dist_bundle2.NormalGamma_setMu(self, mu)

    def getMu(self):
        r"""
        Accessor to the parameter mu.

        Returns
        -------
        mu : float, :math:`\mu`,
             Mean of the conditioned Normal distribution of :math:`X|Y`
        """
        return _dist_bundle2.NormalGamma_getMu(self)

    def setKappa(self, kappa):
        r"""
        Accessor to the parameter kappa.

        Parameters
        ----------
        kappa : float :math:`\kappa >0`,
                Scale parameter of the precision (ie the inverse of the variance) of the conditioned Normal distribution of :math:`X|Y`
        """
        return _dist_bundle2.NormalGamma_setKappa(self, kappa)

    def getKappa(self):
        r"""
        Accessor to the parameter kappa.

        Returns
        -------
        kappa : float, :math:`\kappa`, :math:`\kappa >0`
                Scale parameter of the precision (ie the inverse of the variance) of the conditioned Normal distribution of :math:`X|Y`
        """
        return _dist_bundle2.NormalGamma_getKappa(self)

    def setAlpha(self, alpha):
        r"""
        Accessor to the parameter alpha.

        Parameters
        ----------
        alpha : float,  :math:`\alpha >0`,
                Shape parameter of the conditioning Gamma distribution of :math:`Y`
        """
        return _dist_bundle2.NormalGamma_setAlpha(self, alpha)

    def getAlpha(self):
        r"""
        Accessor to the parameter alpha.

        Returns
        -------
        alpha : float, :math:`\alpha`, :math:`\alpha >0`
                Shape parameter of the conditioning Gamma distribution of :math:`Y`
        """
        return _dist_bundle2.NormalGamma_getAlpha(self)

    def setBeta(self, beta):
        r"""
        Accessor to the parameter beta.

        Parameters
        ----------
        beta : float,  :math:`\beta >0`,
               Rate parameter of the conditioning Gamma distribution of :math:`Y`
        """
        return _dist_bundle2.NormalGamma_setBeta(self, beta)

    def getBeta(self):
        r"""
        Accessor to the parameter beta.

        Returns
        -------
        beta : float, :math:`\beta`, :math:`\beta >0`
               Rate parameter of the conditioning Gamma distribution of :math:`Y`
        """
        return _dist_bundle2.NormalGamma_getBeta(self)

    def setParameter(self, parameter):
        r"""
        Accessor to the parameter of the distribution.

        Parameters
        ----------
        parameter : sequence of float
            Parameter values.
        """
        return _dist_bundle2.NormalGamma_setParameter(self, parameter)

    def getParameter(self):
        r"""
        Accessor to the parameter of the distribution.

        Returns
        -------
        parameter : :class:`~openturns.Point`
            Parameter values.
        """
        return _dist_bundle2.NormalGamma_getParameter(self)

    def getParameterDescription(self):
        r"""
        Accessor to the parameter description of the distribution.

        Returns
        -------
        description : :class:`~openturns.Description`
            Parameter names.
        """
        return _dist_bundle2.NormalGamma_getParameterDescription(self)

    def getSkewness(self):
        r"""
        Accessor to the componentwise skewness.

        Returns
        -------
        d : :class:`~openturns.Point`
            Componentwise skewness.

        Notes
        -----
        The skewness is the third-order central moment standardized by the standard deviation:

        .. math::

            \vect{\delta} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^3},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.NormalGamma_getSkewness(self)

    def getKurtosis(self):
        r"""
        Accessor to the componentwise kurtosis.

        Returns
        -------
        k : :class:`~openturns.Point`
            Componentwise kurtosis.

        Notes
        -----
        The kurtosis is the fourth-order central moment standardized by the standard deviation:

        .. math::

            \vect{\kappa} = \Tr{\left(\Expect{\left(\frac{X_i - \mu_i}
                                                         {\sigma_i}\right)^4},
                                      \quad i = 1, \ldots, n\right)}
        """
        return _dist_bundle2.NormalGamma_getKurtosis(self)

    def __init__(self, *args):
        _dist_bundle2.NormalGamma_swiginit(self, _dist_bundle2.new_NormalGamma(*args))
    __swig_destroy__ = _dist_bundle2.delete_NormalGamma

# Register NormalGamma in _dist_bundle2:
_dist_bundle2.NormalGamma_swigregister(NormalGamma)

