%feature("docstring") OT::ExponentialFactory
"Exponential factory.

Notes
-----
The parameters are estimated by method of moments:

.. math::
    :nowrap:

    \\begin{eqnarray*}
      \\displaystyle \\Hat{\\gamma}_n = x_{(1,n)} - \\frac{|x_{(1,n)}|}{2+n}\\\\
      \\displaystyle \\Hat{\\lambda}_n= \\frac{1}{\\bar{x}_n-\\Hat{\\gamma}_n}
    \\end{eqnarray*}

See also
--------
DistributionFactory, Exponential"

// ---------------------------------------------------------------------

%feature("docstring") OT::ExponentialFactory::buildAsExponential
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsExponential()

    buildAsExponential(*sample*)

    buildAsExponential(*param*)

Parameters
----------
sample : 2-d sequence of float
    Sample from which the distribution parameters are estimated.
param : sequence of float
   The parameters of the :class:`~openturns.Exponential`.

Returns
-------
dist : :class:`~openturns.Exponential`
    The estimated distribution as a Exponential.
    
    In the first usage, the default Exponential distribution is built."

