%feature("docstring") OT::LeastSquaresDistributionFactory
"Least squares factory.

Parameters
----------
distribution : :class:`~openturns.Distribution`
    The distribution defining the parametric model :math:`p_{\\vect{\\theta}}` to be adjusted to data.

Notes
-----
The method fits a scalar distribution to data of dimension 1, using a least-squares minimization method.

Let us denote :math:`(\\vect{x}_1, \\dots, \\vect{x}_n)` the sample, :math:`F_{\\vect{\\theta}}`
the  cumulative distribution function we want to fit to the sample,
and :math:`\\vect{\\theta} \\in  \\Theta \\subset\\Rset^p`  its parameter vector.

let :math:`\\hat{F}` denote the empirical cumulative distribution function built from the sample.


The estimator :math:`\\hat{\\theta}` minimizes the mean square error between
:math:`F_{\\vect{\\theta}}` and :math:`\\hat{F}` on the empirical quantiles.It is defined as:

.. math::

    \\hat{\\theta} = \\argmin_{\\vect{\\theta} \\in \\Theta} \\sum_{i=1}^{n} \\left( F_{\\vect{\\theta}}(\\vect{x}_i) - F_{\\hat{\\vect{\\theta}}}(\\vect{x}_i) \\right) ^2

See also
--------
DistributionFactory

Examples
--------
>>> import openturns as ot
>>> ot.RandomGenerator.SetSeed(0)
>>> distribution = ot.Normal(0.9, 1.7)
>>> sample = distribution.getSample(10)
>>> factory = ot.LeastSquaresDistributionFactory(ot.Normal())
>>> inf_distribution = factory.build(sample)"

// ---------------------------------------------------------------------

%feature("docstring") OT::LeastSquaresDistributionFactory::setOptimizationAlgorithm
"Accessor to the solver.

Parameters
----------
solver : :class:`~openturns.OptimizationAlgorithm`
    The solver used for numerical optimization of the likelihood."

// ---------------------------------------------------------------------

%feature("docstring") OT::LeastSquaresDistributionFactory::getOptimizationAlgorithm
"Accessor to the solver.

Returns
-------
solver : :class:`~openturns.OptimizationAlgorithm`
    The solver used for numerical optimization of the likelihood."

// ---------------------------------------------------------------------

%feature("docstring") OT::LeastSquaresDistributionFactory::setOptimizationBounds
"Accessor to the optimization bounds.

Parameters
----------
problem : :class:`~openturns.Interval`
    The bounds used for numerical optimization of the likelihood."

// ---------------------------------------------------------------------

%feature("docstring") OT::LeastSquaresDistributionFactory::getOptimizationBounds
"Accessor to the optimization bounds.

Returns
-------
problem : :class:`~openturns.Interval`
    The bounds used for numerical optimization of the likelihood."

// ---------------------------------------------------------------------

%feature("docstring") OT::LeastSquaresDistributionFactory::setOptimizationInequalityConstraint
"Accessor to the optimization inequality constraint.

Parameters
----------
inequalityConstraint : :class:`~openturns.Function`
    The inequality constraint used for numerical optimization of the likelihood."

