%feature("docstring") OT::StudentCopulaFactory
"Student copula factory.

This class implements the method described in [peng2014]_.
It consists in inferring the correlation matrix and then estimating the
:math:`\\nu` parameter via profiled likelihood maximization.

Notes
-----
The following :class:`~openturns.ResourceMap` entries can be used to tweak
the optimization step:

- `StudentCopulaFactory-MaximumAbsoluteError`
- `StudentCopulaFactory-MaximumConstraintError`
- `StudentCopulaFactory-MaximumObjectiveError`
- `StudentCopulaFactory-MaximumRelativeError`
- `StudentCopulaFactory-NuMin`
- `StudentCopulaFactory-NuMax`
- `StudentCopulaFactory-NuStart`
- `StudentCopulaFactory-DefaultOptimizationAlgorithm`
- `StudentCopulaFactory-MaximumEvaluationNumber`

See also
--------
DistributionFactory, StudentCopula
"

// ---------------------------------------------------------------------

%feature("docstring") OT::StudentCopulaFactory::buildAsStudentCopula
"Estimate the distribution as native distribution.

**Available usages**:

    buildAsStudentCopula()

    buildAsStudentCopula(*sample*)

    buildAsStudentCopula(*param*)

Parameters
----------
sample : 2-d sequence of float
    Data.
param : sequence of float
    The parameters of the :class:`openturns.StudentCopula`.

Returns
-------
dist : :class:`~openturns.Uniform`
    The estimated distribution as a :class:`openturns.StudentCopula`.
    In the first usage, the default :class:`openturns.StudentCopula` distribution is built."

// ---------------------------------------------------------------------

%feature("docstring") OT::StudentCopulaFactory::setOptimizationAlgorithm
"Accessor to the optimization solver.

Parameters
----------
solver : :class:`~openturns.OptimizationAlgorithm`
    The solver used for the optimization of the log-likelihood.
"

// ---------------------------------------------------------------------

%feature("docstring") OT::StudentCopulaFactory::getOptimizationAlgorithm
"Accessor to the optimization solver.

Returns
-------
solver : :class:`~openturns.OptimizationAlgorithm`
    The solver used for the optimization of the log-likelihood."
