#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchinitializepackage_ PETSCBENCHINITIALIZEPACKAGE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchinitializepackage_ petscbenchinitializepackage
#endif
PETSC_EXTERN void petscbenchinitializepackage_(PetscErrorCode *ierr)
{
  *ierr = PetscBenchInitializePackage();
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchreset_ PETSCBENCHRESET
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchreset_ petscbenchreset
#endif
PETSC_EXTERN void petscbenchreset_(PetscBench *a, PetscErrorCode *ierr)
{
  *ierr = PetscBenchReset(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchdestroy_ PETSCBENCHDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchdestroy_ petscbenchdestroy
#endif
PETSC_EXTERN void petscbenchdestroy_(PetscBench *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscBenchDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchsetup_ PETSCBENCHSETUP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchsetup_ petscbenchsetup
#endif
PETSC_EXTERN void petscbenchsetup_(PetscBench *a, PetscErrorCode *ierr)
{
  *ierr = PetscBenchSetUp(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchrun_ PETSCBENCHRUN
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchrun_ petscbenchrun
#endif
PETSC_EXTERN void petscbenchrun_(PetscBench *a, PetscErrorCode *ierr)
{
  *ierr = PetscBenchRun(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchsetfromoptions_ PETSCBENCHSETFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchsetfromoptions_ petscbenchsetfromoptions
#endif
PETSC_EXTERN void petscbenchsetfromoptions_(PetscBench *a, PetscErrorCode *ierr)
{
  *ierr = PetscBenchSetFromOptions(*a);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchview_ PETSCBENCHVIEW
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchview_ petscbenchview
#endif
PETSC_EXTERN void petscbenchview_(PetscBench *a, PetscViewer *b, PetscErrorCode *ierr)
{
  PetscViewer v_b = PetscPatchDefaultViewers(b);
  *ierr = PetscBenchView(*a, v_b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchviewfromoptions_ PETSCBENCHVIEWFROMOPTIONS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchviewfromoptions_ petscbenchviewfromoptions
#endif
PETSC_EXTERN void petscbenchviewfromoptions_(PetscBench *a, PetscObject *b, char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_c;
  FIXCHAR(c, l_c, c_c);
  *ierr = PetscBenchViewFromOptions(*a, *b, c_c);
  if (*ierr) return;
  FREECHAR(c, c_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchcreate_ PETSCBENCHCREATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchcreate_ petscbenchcreate
#endif
PETSC_EXTERN void petscbenchcreate_(MPI_Fint *a, PetscBench *b, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PETSC_FORTRAN_OBJECT_CREATE(b);
  CHKFORTRANNULLOBJECT(b);
  *ierr = PetscBenchCreate(MPI_Comm_f2c(*(a)), b);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchsetoptionsprefix_ PETSCBENCHSETOPTIONSPREFIX
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchsetoptionsprefix_ petscbenchsetoptionsprefix
#endif
PETSC_EXTERN void petscbenchsetoptionsprefix_(PetscBench *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscBenchSetOptionsPrefix(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchsetsize_ PETSCBENCHSETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchsetsize_ petscbenchsetsize
#endif
PETSC_EXTERN void petscbenchsetsize_(PetscBench *a, PetscInt *b, PetscErrorCode *ierr)
{
  *ierr = PetscBenchSetSize(*a, *b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchgetsize_ PETSCBENCHGETSIZE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchgetsize_ petscbenchgetsize
#endif
PETSC_EXTERN void petscbenchgetsize_(PetscBench *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = PetscBenchGetSize(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchsettype_ PETSCBENCHSETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchsettype_ petscbenchsettype
#endif
PETSC_EXTERN void petscbenchsettype_(PetscBench *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscBenchSetType(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscbm.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscbenchgettype_ PETSCBENCHGETTYPE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscbenchgettype_ petscbenchgettype
#endif
PETSC_EXTERN void petscbenchgettype_(PetscBench *a, char * b, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscBenchGetType(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
