#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscstring.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsctokenfind_ PETSCTOKENFIND
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsctokenfind_ petsctokenfind
#endif
PETSC_EXTERN void petsctokenfind_(PetscToken *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = PetscTokenFind(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscstring.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petsctokendestroy_ PETSCTOKENDESTROY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petsctokendestroy_ petsctokendestroy
#endif
PETSC_EXTERN void petsctokendestroy_(PetscToken *a, PetscErrorCode *ierr)
{
  PETSC_FORTRAN_OBJECT_F_DESTROYED_TO_C_NULL(a);
  PetscBool null_a = !*(void**) a ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(a);
  *ierr = PetscTokenDestroy(a);
  if (*ierr) return;
  if (! null_a && !*(void**) a) *(void **) a = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscstring.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscstrcasecmp_ PETSCSTRCASECMP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscstrcasecmp_ petscstrcasecmp
#endif
PETSC_EXTERN void petscstrcasecmp_(char a[], char b[], PetscBool *c, PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_a;
  FIXCHAR(a, l_a, c_a);
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  CHKFORTRANNULLBOOL(c);
  *ierr = PetscStrcasecmp(c_a, c_b, c);
  if (*ierr) return;
  FREECHAR(a, c_a);
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscsys.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscgetpetscdir_ PETSCGETPETSCDIR
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscgetpetscdir_ petscgetpetscdir
#endif
PETSC_EXTERN void petscgetpetscdir_(char a[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a)
{
  char* c_a = PETSC_NULLPTR;
  *ierr = PetscGetPetscDir((const char **)&c_a);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)a, c_a, l_a);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscstring.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscstrreplace_ PETSCSTRREPLACE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscstrreplace_ petscstrreplace
#endif
PETSC_EXTERN void petscstrreplace_(MPI_Fint *a, char b[], char c[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b, PETSC_FORTRAN_CHARLEN_T l_c)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscStrreplace(MPI_Comm_f2c(*(a)), c_b, c, l_c);
  if (*ierr) return;
  FREECHAR(b, c_b);
  FIXRETURNCHAR(PETSC_TRUE, c, l_c);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscstring.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscstrcat_ PETSCSTRCAT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscstrcat_ petscstrcat
#endif
PETSC_EXTERN void petscstrcat_(char a[], char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscStrcat(a, c_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscsys.h>
#include <petscstring.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define petscstrcpy_ PETSCSTRCPY
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define petscstrcpy_ petscstrcpy
#endif
PETSC_EXTERN void petscstrcpy_(char a[], char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_a, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = PetscStrcpy(a, c_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, a, l_a);
  FREECHAR(b, c_b);
}
