  type, extends(tPetscObject) ::  tVec
  end type tVec
  Vec, parameter :: PETSC_NULL_VEC = tVec(0)
  Vec, target :: PETSC_NULL_VEC_ARRAY(1) = [tVec(0)]
  Vec, pointer :: PETSC_NULL_VEC_POINTER(:) => PETSC_NULL_VEC_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VEC
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VEC_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VEC_POINTER
#endif

  type tVecs
    PetscFortranAddr:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type tVecs
  Vecs, parameter :: PETSC_NULL_VECS = tVecs(0)
  Vecs, target :: PETSC_NULL_VECS_ARRAY(1) = [tVecs(0)]
  Vecs, pointer :: PETSC_NULL_VECS_POINTER(:) => PETSC_NULL_VECS_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECS
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECS_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECS_POINTER
#endif

  type, extends(tPetscObject) ::  tPetscViennaCLIndices
  end type tPetscViennaCLIndices
  PetscViennaCLIndices, parameter :: PETSC_NULL_VIENNACLINDICES = tPetscViennaCLIndices(0)
  PetscViennaCLIndices, target :: PETSC_NULL_VIENNACLINDICES_ARRAY(1) = [tPetscViennaCLIndices(0)]
  PetscViennaCLIndices, pointer :: PETSC_NULL_VIENNACLINDICES_POINTER(:) => PETSC_NULL_VIENNACLINDICES_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VIENNACLINDICES
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VIENNACLINDICES_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VIENNACLINDICES_POINTER
#endif

  type, extends(tPetscObject) ::  tVecTagger
  end type tVecTagger
  VecTagger, parameter :: PETSC_NULL_VECTAGGER = tVecTagger(0)
  VecTagger, target :: PETSC_NULL_VECTAGGER_ARRAY(1) = [tVecTagger(0)]
  VecTagger, pointer :: PETSC_NULL_VECTAGGER_POINTER(:) => PETSC_NULL_VECTAGGER_ARRAY
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECTAGGER
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECTAGGER_ARRAY
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECTAGGER_POINTER
#endif

  type eScatterMode
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eScatterMode

  ScatterMode, parameter :: PETSC_NULL_SCATTERMODE = eScatterMode(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_SCATTERMODE
#endif
    ScatterMode, parameter :: SCATTER_FORWARD = eScatterMode(0)
    ScatterMode, parameter :: SCATTER_REVERSE = eScatterMode(1)
    ScatterMode, parameter :: SCATTER_FORWARD_LOCAL = eScatterMode(2)
    ScatterMode, parameter :: SCATTER_REVERSE_LOCAL = eScatterMode(3)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::SCATTER_FORWARD 
!DEC$ ATTRIBUTES DLLEXPORT::SCATTER_REVERSE 
!DEC$ ATTRIBUTES DLLEXPORT::SCATTER_FORWARD_LOCAL 
!DEC$ ATTRIBUTES DLLEXPORT::SCATTER_REVERSE_LOCAL 
#endif

  type eNormType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eNormType

  NormType, parameter :: PETSC_NULL_NORMTYPE = eNormType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_NORMTYPE
#endif
    NormType, parameter :: NORM_1 = eNormType(0)
    NormType, parameter :: NORM_2 = eNormType(1)
    NormType, parameter :: NORM_FROBENIUS = eNormType(2)
    NormType, parameter :: NORM_INFINITY = eNormType(3)
    NormType, parameter :: NORM_1_AND_2 = eNormType(4)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::NORM_1 
!DEC$ ATTRIBUTES DLLEXPORT::NORM_2 
!DEC$ ATTRIBUTES DLLEXPORT::NORM_FROBENIUS 
!DEC$ ATTRIBUTES DLLEXPORT::NORM_INFINITY 
!DEC$ ATTRIBUTES DLLEXPORT::NORM_1_AND_2 
#endif

  type eReductionType
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eReductionType

  ReductionType, parameter :: PETSC_NULL_REDUCTIONTYPE = eReductionType(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_REDUCTIONTYPE
#endif
    ReductionType, parameter :: REDUCTION_SUM_REALPART = eReductionType(10)
    ReductionType, parameter :: REDUCTION_MEAN_REALPART = eReductionType(11)
    ReductionType, parameter :: REDUCTION_SUM_IMAGINARYPART = eReductionType(12)
    ReductionType, parameter :: REDUCTION_MEAN_IMAGINARYPART = eReductionType(13)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::REDUCTION_SUM_REALPART 
!DEC$ ATTRIBUTES DLLEXPORT::REDUCTION_MEAN_REALPART 
!DEC$ ATTRIBUTES DLLEXPORT::REDUCTION_SUM_IMAGINARYPART 
!DEC$ ATTRIBUTES DLLEXPORT::REDUCTION_MEAN_IMAGINARYPART 
#endif

  type eVecOption
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eVecOption

  VecOption, parameter :: PETSC_NULL_VECOPTION = eVecOption(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECOPTION
#endif
    VecOption, parameter :: VEC_IGNORE_OFF_PROC_ENTRIES = eVecOption(0)
    VecOption, parameter :: VEC_IGNORE_NEGATIVE_INDICES = eVecOption(1)
    VecOption, parameter :: VEC_SUBSET_OFF_PROC_ENTRIES = eVecOption(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::VEC_IGNORE_OFF_PROC_ENTRIES
!DEC$ ATTRIBUTES DLLEXPORT::VEC_IGNORE_NEGATIVE_INDICES
!DEC$ ATTRIBUTES DLLEXPORT::VEC_SUBSET_OFF_PROC_ENTRIES
#endif

  type eVecOperation
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eVecOperation

  VecOperation, parameter :: PETSC_NULL_VECOPERATION = eVecOperation(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECOPERATION
#endif
    VecOperation, parameter :: VECOP_DUPLICATE = eVecOperation(0)
    VecOperation, parameter :: VECOP_SET = eVecOperation(10)
    VecOperation, parameter :: VECOP_VIEW = eVecOperation(33)
    VecOperation, parameter :: VECOP_LOAD = eVecOperation(41)
    VecOperation, parameter :: VECOP_VIEWNATIVE = eVecOperation(69)
    VecOperation, parameter :: VECOP_LOADNATIVE = eVecOperation(70)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_DUPLICATE 
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_SET 
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_VIEW 
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_LOAD 
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_VIEWNATIVE 
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_LOADNATIVE 
#endif

  type eVecTaggerCDFMethod
    PetscEnum:: v PETSC_FORTRAN_TYPE_INITIALIZE
  end type eVecTaggerCDFMethod

  VecTaggerCDFMethod, parameter :: PETSC_NULL_VECTAGGERCDFMETHOD = eVecTaggerCDFMethod(-50)
#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECTAGGERCDFMETHOD
#endif
    VecTaggerCDFMethod, parameter :: VECTAGGER_CDF_GATHER = eVecTaggerCDFMethod(0)
    VecTaggerCDFMethod, parameter :: VECTAGGER_CDF_ITERATIVE = eVecTaggerCDFMethod(1)
    VecTaggerCDFMethod, parameter :: VECTAGGER_CDF_NUM_METHODS = eVecTaggerCDFMethod(2)

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::VECTAGGER_CDF_GATHER
!DEC$ ATTRIBUTES DLLEXPORT::VECTAGGER_CDF_ITERATIVE
!DEC$ ATTRIBUTES DLLEXPORT::VECTAGGER_CDF_NUM_METHODS
#endif

  CHARACTER(LEN=*), PARAMETER :: VECSEQ = 'seq'
  CHARACTER(LEN=*), PARAMETER :: VECMPI = 'mpi'
  CHARACTER(LEN=*), PARAMETER :: VECSTANDARD = 'standard'
  CHARACTER(LEN=*), PARAMETER :: VECSHARED = 'shared'
  CHARACTER(LEN=*), PARAMETER :: VECSEQVIENNACL = 'seqviennacl'
  CHARACTER(LEN=*), PARAMETER :: VECMPIVIENNACL = 'mpiviennacl'
  CHARACTER(LEN=*), PARAMETER :: VECVIENNACL = 'viennacl'
  CHARACTER(LEN=*), PARAMETER :: VECSEQCUDA = 'seqcuda'
  CHARACTER(LEN=*), PARAMETER :: VECMPICUDA = 'mpicuda'
  CHARACTER(LEN=*), PARAMETER :: VECCUDA = 'cuda'
  CHARACTER(LEN=*), PARAMETER :: VECSEQHIP = 'seqhip'
  CHARACTER(LEN=*), PARAMETER :: VECMPIHIP = 'mpihip'
  CHARACTER(LEN=*), PARAMETER :: VECHIP = 'hip'
  CHARACTER(LEN=*), PARAMETER :: VECNEST = 'nest'
  CHARACTER(LEN=*), PARAMETER :: VECSEQKOKKOS = 'seqkokkos'
  CHARACTER(LEN=*), PARAMETER :: VECMPIKOKKOS = 'mpikokkos'
  CHARACTER(LEN=*), PARAMETER :: VECKOKKOS = 'kokkos'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::VECSEQ
!DEC$ ATTRIBUTES DLLEXPORT::VECMPI
!DEC$ ATTRIBUTES DLLEXPORT::VECSTANDARD
!DEC$ ATTRIBUTES DLLEXPORT::VECSHARED
!DEC$ ATTRIBUTES DLLEXPORT::VECSEQVIENNACL
!DEC$ ATTRIBUTES DLLEXPORT::VECMPIVIENNACL
!DEC$ ATTRIBUTES DLLEXPORT::VECVIENNACL
!DEC$ ATTRIBUTES DLLEXPORT::VECSEQCUDA
!DEC$ ATTRIBUTES DLLEXPORT::VECMPICUDA
!DEC$ ATTRIBUTES DLLEXPORT::VECCUDA
!DEC$ ATTRIBUTES DLLEXPORT::VECSEQHIP
!DEC$ ATTRIBUTES DLLEXPORT::VECMPIHIP
!DEC$ ATTRIBUTES DLLEXPORT::VECHIP
!DEC$ ATTRIBUTES DLLEXPORT::VECNEST
!DEC$ ATTRIBUTES DLLEXPORT::VECSEQKOKKOS
!DEC$ ATTRIBUTES DLLEXPORT::VECMPIKOKKOS
!DEC$ ATTRIBUTES DLLEXPORT::VECKOKKOS
#endif

  CHARACTER(LEN=*), PARAMETER :: VECTAGGERABSOLUTE = 'absolute'
  CHARACTER(LEN=*), PARAMETER :: VECTAGGERRELATIVE = 'relative'
  CHARACTER(LEN=*), PARAMETER :: VECTAGGERCDF = 'cdf'
  CHARACTER(LEN=*), PARAMETER :: VECTAGGEROR = 'or'
  CHARACTER(LEN=*), PARAMETER :: VECTAGGERAND = 'and'

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::VECTAGGERABSOLUTE
!DEC$ ATTRIBUTES DLLEXPORT::VECTAGGERRELATIVE
!DEC$ ATTRIBUTES DLLEXPORT::VECTAGGERCDF
!DEC$ ATTRIBUTES DLLEXPORT::VECTAGGEROR
!DEC$ ATTRIBUTES DLLEXPORT::VECTAGGERAND
#endif

  type sVecTaggerBox
    PetscScalar min
    PetscScalar max
  end type sVecTaggerBox

