#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetadjacencyuseanchors_ DMPLEXSETADJACENCYUSEANCHORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetadjacencyuseanchors_ dmplexsetadjacencyuseanchors
#endif
PETSC_EXTERN void dmplexsetadjacencyuseanchors_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetAdjacencyUseAnchors(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetadjacencyuseanchors_ DMPLEXGETADJACENCYUSEANCHORS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetadjacencyuseanchors_ dmplexgetadjacencyuseanchors
#endif
PETSC_EXTERN void dmplexgetadjacencyuseanchors_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexGetAdjacencyUseAnchors(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatetwosidedprocesssf_ DMPLEXCREATETWOSIDEDPROCESSSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatetwosidedprocesssf_ dmplexcreatetwosidedprocesssf
#endif
PETSC_EXTERN void dmplexcreatetwosidedprocesssf_(DM *a, PetscSF *b, PetscSection *c, IS *d, PetscSection *e, IS *f, IS *g, PetscSF *h, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_h = !*(void**) h ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(g);
  CHKFORTRANNULLOBJECT(h);
  *ierr = DMPlexCreateTwoSidedProcessSF(*a, *b, *c, *d, *e, *f, g, h);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
  if (! null_h && !*(void**) h) *(void **) h = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexdistributeownership_ DMPLEXDISTRIBUTEOWNERSHIP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexdistributeownership_ dmplexdistributeownership
#endif
PETSC_EXTERN void dmplexdistributeownership_(DM *a, PetscSection *b, IS *c, PetscSection *d, IS *e, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_e = !*(void**) e ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(e);
  *ierr = DMPlexDistributeOwnership(*a, *b, c, *d, e);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_e && !*(void**) e) *(void **) e = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateoverlaplabel_ DMPLEXCREATEOVERLAPLABEL
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateoverlaplabel_ dmplexcreateoverlaplabel
#endif
PETSC_EXTERN void dmplexcreateoverlaplabel_(DM *a, PetscInt *b, PetscSection *c, IS *d, PetscSection *e, IS *f, DMLabel *g, PetscErrorCode *ierr)
{
  PetscBool null_g = !*(void**) g ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(g);
  *ierr = DMPlexCreateOverlapLabel(*a, *b, *c, *d, *e, *f, g);
  if (*ierr) return;
  if (! null_g && !*(void**) g) *(void **) g = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateoverlaplabelfromlabels_ DMPLEXCREATEOVERLAPLABELFROMLABELS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateoverlaplabelfromlabels_ dmplexcreateoverlaplabelfromlabels
#endif
PETSC_EXTERN void dmplexcreateoverlaplabelfromlabels_(DM *a, PetscInt *b, const DMLabel c[], const PetscInt d[], PetscInt *e, const DMLabel f[], const PetscInt g[], PetscSection *h, IS *i, PetscSection *j, IS *k, DMLabel *l, PetscErrorCode *ierr)
{
  PetscBool null_l = !*(void**) l ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLINTEGER(d);
  CHKFORTRANNULLINTEGER(g);
  CHKFORTRANNULLOBJECT(l);
  *ierr = DMPlexCreateOverlapLabelFromLabels(*a, *b, c, d, *e, f, g, *h, *i, *j, *k, l);
  if (*ierr) return;
  if (! null_l && !*(void**) l) *(void **) l = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreateoverlapmigrationsf_ DMPLEXCREATEOVERLAPMIGRATIONSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreateoverlapmigrationsf_ dmplexcreateoverlapmigrationsf
#endif
PETSC_EXTERN void dmplexcreateoverlapmigrationsf_(DM *a, PetscSF *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexCreateOverlapMigrationSF(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexstratifymigrationsf_ DMPLEXSTRATIFYMIGRATIONSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexstratifymigrationsf_ dmplexstratifymigrationsf
#endif
PETSC_EXTERN void dmplexstratifymigrationsf_(DM *a, PetscSF *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexStratifyMigrationSF(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexdistributefield_ DMPLEXDISTRIBUTEFIELD
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexdistributefield_ dmplexdistributefield
#endif
PETSC_EXTERN void dmplexdistributefield_(DM *a, PetscSF *b, PetscSection *c, Vec *d, PetscSection *e, Vec *f, PetscErrorCode *ierr)
{
  *ierr = DMPlexDistributeField(*a, *b, *c, *d, *e, *f);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexdistributefieldis_ DMPLEXDISTRIBUTEFIELDIS
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexdistributefieldis_ dmplexdistributefieldis
#endif
PETSC_EXTERN void dmplexdistributefieldis_(DM *a, PetscSF *b, PetscSection *c, IS *d, PetscSection *e, IS *f, PetscErrorCode *ierr)
{
  PetscBool null_f = !*(void**) f ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(f);
  *ierr = DMPlexDistributeFieldIS(*a, *b, *c, *d, *e, f);
  if (*ierr) return;
  if (! null_f && !*(void**) f) *(void **) f = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetpartitionbalance_ DMPLEXSETPARTITIONBALANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetpartitionbalance_ dmplexsetpartitionbalance
#endif
PETSC_EXTERN void dmplexsetpartitionbalance_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetPartitionBalance(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetpartitionbalance_ DMPLEXGETPARTITIONBALANCE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetpartitionbalance_ dmplexgetpartitionbalance
#endif
PETSC_EXTERN void dmplexgetpartitionbalance_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexGetPartitionBalance(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexcreatepointsf_ DMPLEXCREATEPOINTSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexcreatepointsf_ dmplexcreatepointsf
#endif
PETSC_EXTERN void dmplexcreatepointsf_(DM *a, PetscSF *b, PetscBool *c, PetscSF *d, PetscErrorCode *ierr)
{
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexCreatePointSF(*a, *b, *c ? PETSC_TRUE : PETSC_FALSE, d);
  if (*ierr) return;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexmigrate_ DMPLEXMIGRATE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexmigrate_ dmplexmigrate
#endif
PETSC_EXTERN void dmplexmigrate_(DM *a, PetscSF *b, DM *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexMigrate(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexremapmigrationsf_ DMPLEXREMAPMIGRATIONSF
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexremapmigrationsf_ dmplexremapmigrationsf
#endif
PETSC_EXTERN void dmplexremapmigrationsf_(PetscSF *a, PetscSF *b, PetscSF *c, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexRemapMigrationSF(*a, *b, c);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexdistribute_ DMPLEXDISTRIBUTE
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexdistribute_ dmplexdistribute
#endif
PETSC_EXTERN void dmplexdistribute_(DM *a, PetscInt *b, PetscSF *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexDistribute(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexdistributeoverlap_ DMPLEXDISTRIBUTEOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexdistributeoverlap_ dmplexdistributeoverlap
#endif
PETSC_EXTERN void dmplexdistributeoverlap_(DM *a, PetscInt *b, PetscSF *c, DM *d, PetscErrorCode *ierr)
{
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_d = !*(void**) d ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(c);
  CHKFORTRANNULLOBJECT(d);
  *ierr = DMPlexDistributeOverlap(*a, *b, c, d);
  if (*ierr) return;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
  if (! null_d && !*(void**) d) *(void **) d = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetoverlap_ DMPLEXGETOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetoverlap_ dmplexgetoverlap
#endif
PETSC_EXTERN void dmplexgetoverlap_(DM *a, PetscInt *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLINTEGER(b);
  *ierr = DMPlexGetOverlap(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexsetoverlap_ DMPLEXSETOVERLAP
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexsetoverlap_ dmplexsetoverlap
#endif
PETSC_EXTERN void dmplexsetoverlap_(DM *a, DM *b, PetscInt *c, PetscErrorCode *ierr)
{
  *ierr = DMPlexSetOverlap(*a, *b, *c);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexdistributesetdefault_ DMPLEXDISTRIBUTESETDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexdistributesetdefault_ dmplexdistributesetdefault
#endif
PETSC_EXTERN void dmplexdistributesetdefault_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  *ierr = DMPlexDistributeSetDefault(*a, *b ? PETSC_TRUE : PETSC_FALSE);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexdistributegetdefault_ DMPLEXDISTRIBUTEGETDEFAULT
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexdistributegetdefault_ dmplexdistributegetdefault
#endif
PETSC_EXTERN void dmplexdistributegetdefault_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexDistributeGetDefault(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetgatherdm_ DMPLEXGETGATHERDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetgatherdm_ dmplexgetgatherdm
#endif
PETSC_EXTERN void dmplexgetgatherdm_(DM *a, PetscSF *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexGetGatherDM(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexgetredundantdm_ DMPLEXGETREDUNDANTDM
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexgetredundantdm_ dmplexgetredundantdm
#endif
PETSC_EXTERN void dmplexgetredundantdm_(DM *a, PetscSF *b, DM *c, PetscErrorCode *ierr)
{
  PetscBool null_b = !*(void**) b ? PETSC_TRUE : PETSC_FALSE;
  PetscBool null_c = !*(void**) c ? PETSC_TRUE : PETSC_FALSE;
  CHKFORTRANNULLOBJECT(b);
  CHKFORTRANNULLOBJECT(c);
  *ierr = DMPlexGetRedundantDM(*a, b, c);
  if (*ierr) return;
  if (! null_b && !*(void**) b) *(void **) b = (void *)-2;
  if (! null_c && !*(void**) c) *(void **) c = (void *)-2;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexisdistributed_ DMPLEXISDISTRIBUTED
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexisdistributed_ dmplexisdistributed
#endif
PETSC_EXTERN void dmplexisdistributed_(DM *a, PetscBool *b, PetscErrorCode *ierr)
{
  CHKFORTRANNULLBOOL(b);
  *ierr = DMPlexIsDistributed(*a, b);
  if (*ierr) return;
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexdistributionsetname_ DMPLEXDISTRIBUTIONSETNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexdistributionsetname_ dmplexdistributionsetname
#endif
PETSC_EXTERN void dmplexdistributionsetname_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b;
  FIXCHAR(b, l_b, c_b);
  *ierr = DMPlexDistributionSetName(*a, c_b);
  if (*ierr) return;
  FREECHAR(b, c_b);
}
#include "petscsys.h"
#include "petscfix.h"
#include "petsc/private/ftnimpl.h"
#include <petscdm.h>
#include <petscdmplex.h>
#if defined(PETSC_HAVE_FORTRAN_CAPS)
  #define dmplexdistributiongetname_ DMPLEXDISTRIBUTIONGETNAME
#elif !defined(PETSC_HAVE_FORTRAN_UNDERSCORE)
  #define dmplexdistributiongetname_ dmplexdistributiongetname
#endif
PETSC_EXTERN void dmplexdistributiongetname_(DM *a, char b[], PetscErrorCode *ierr, PETSC_FORTRAN_CHARLEN_T l_b)
{
  char* c_b = PETSC_NULLPTR;
  *ierr = DMPlexDistributionGetName(*a, (const char **)&c_b);
  if (*ierr) return;
  *ierr = PetscStrncpy((char *)b, c_b, l_b);
  if (*ierr) return;
  FIXRETURNCHAR(PETSC_TRUE, b, l_b);
}
