# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide6.QtWidgets, except for defaults which are replaced by "...".
"""

# Module `PySide6.QtWidgets`

import PySide6.QtWidgets
import PySide6.QtCore
import PySide6.QtGui

import enum
from typing import Any, ClassVar, Dict, Iterable, List, Optional, Sequence, Text, Tuple, Type, Union, overload
from PySide6.QtCore import Signal, SignalInstance
from shiboken6 import Shiboken


NoneType = type(None)


class QAbstractButton(PySide6.QtWidgets.QWidget):

    clicked                  : ClassVar[Signal] = ... # clicked(); clicked(bool)
    pressed                  : ClassVar[Signal] = ... # pressed()
    released                 : ClassVar[Signal] = ... # released()
    toggled                  : ClassVar[Signal] = ... # toggled(bool)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def animateClick(self) -> None: ...
    def autoExclusive(self) -> bool: ...
    def autoRepeat(self) -> bool: ...
    def autoRepeatDelay(self) -> int: ...
    def autoRepeatInterval(self) -> int: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None: ...
    def checkStateSet(self) -> None: ...
    def click(self) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent) -> None: ...
    def group(self) -> PySide6.QtWidgets.QButtonGroup: ...
    def hitButton(self, pos: PySide6.QtCore.QPoint) -> bool: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def iconSize(self) -> PySide6.QtCore.QSize: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isDown(self) -> bool: ...
    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def nextCheckState(self) -> None: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def setAutoExclusive(self, arg__1: bool) -> None: ...
    def setAutoRepeat(self, arg__1: bool) -> None: ...
    def setAutoRepeatDelay(self, arg__1: int) -> None: ...
    def setAutoRepeatInterval(self, arg__1: int) -> None: ...
    def setCheckable(self, arg__1: bool) -> None: ...
    def setChecked(self, arg__1: bool) -> None: ...
    def setDown(self, arg__1: bool) -> None: ...
    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize) -> None: ...
    @overload
    def setShortcut(self, arg__1: PySide6.QtCore.Qt.Key) -> None: ...
    @overload
    def setShortcut(self, key: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> None: ...
    def setText(self, text: str) -> None: ...
    def shortcut(self) -> PySide6.QtGui.QKeySequence: ...
    def text(self) -> str: ...
    def timerEvent(self, e: PySide6.QtCore.QTimerEvent) -> None: ...
    def toggle(self) -> None: ...


class QAbstractGraphicsShapeItem(PySide6.QtWidgets.QGraphicsItem):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def brush(self) -> PySide6.QtGui.QBrush: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def pen(self) -> PySide6.QtGui.QPen: ...
    def setBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setPen(self, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor]) -> None: ...


class QAbstractItemDelegate(PySide6.QtCore.QObject):

    closeEditor              : ClassVar[Signal] = ... # closeEditor(QWidget*,QAbstractItemDelegate::EndEditHint); closeEditor(QWidget*)
    commitData               : ClassVar[Signal] = ... # commitData(QWidget*)
    sizeHintChanged          : ClassVar[Signal] = ... # sizeHintChanged(QModelIndex)

    class EndEditHint(enum.Enum):

        NoHint                   : QAbstractItemDelegate.EndEditHint = ... # 0x0
        EditNextItem             : QAbstractItemDelegate.EndEditHint = ... # 0x1
        EditPreviousItem         : QAbstractItemDelegate.EndEditHint = ... # 0x2
        SubmitModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x3
        RevertModelCache         : QAbstractItemDelegate.EndEditHint = ... # 0x4


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def createEditor(self, parent: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QWidget: ...
    def destroyEditor(self, editor: PySide6.QtWidgets.QWidget, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def editorEvent(self, event: PySide6.QtCore.QEvent, model: PySide6.QtCore.QAbstractItemModel, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def helpEvent(self, event: PySide6.QtGui.QHelpEvent, view: PySide6.QtWidgets.QAbstractItemView, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def paintingRoles(self) -> List[int]: ...
    def setEditorData(self, editor: PySide6.QtWidgets.QWidget, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setModelData(self, editor: PySide6.QtWidgets.QWidget, model: PySide6.QtCore.QAbstractItemModel, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def sizeHint(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QSize: ...
    def updateEditorGeometry(self, editor: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...


class QAbstractItemView(PySide6.QtWidgets.QAbstractScrollArea):

    activated                : ClassVar[Signal] = ... # activated(QModelIndex)
    clicked                  : ClassVar[Signal] = ... # clicked(QModelIndex)
    doubleClicked            : ClassVar[Signal] = ... # doubleClicked(QModelIndex)
    entered                  : ClassVar[Signal] = ... # entered(QModelIndex)
    iconSizeChanged          : ClassVar[Signal] = ... # iconSizeChanged(QSize)
    pressed                  : ClassVar[Signal] = ... # pressed(QModelIndex)
    viewportEntered          : ClassVar[Signal] = ... # viewportEntered()

    class CursorAction(enum.Enum):

        MoveUp                   : QAbstractItemView.CursorAction = ... # 0x0
        MoveDown                 : QAbstractItemView.CursorAction = ... # 0x1
        MoveLeft                 : QAbstractItemView.CursorAction = ... # 0x2
        MoveRight                : QAbstractItemView.CursorAction = ... # 0x3
        MoveHome                 : QAbstractItemView.CursorAction = ... # 0x4
        MoveEnd                  : QAbstractItemView.CursorAction = ... # 0x5
        MovePageUp               : QAbstractItemView.CursorAction = ... # 0x6
        MovePageDown             : QAbstractItemView.CursorAction = ... # 0x7
        MoveNext                 : QAbstractItemView.CursorAction = ... # 0x8
        MovePrevious             : QAbstractItemView.CursorAction = ... # 0x9

    class DragDropMode(enum.Enum):

        NoDragDrop               : QAbstractItemView.DragDropMode = ... # 0x0
        DragOnly                 : QAbstractItemView.DragDropMode = ... # 0x1
        DropOnly                 : QAbstractItemView.DragDropMode = ... # 0x2
        DragDrop                 : QAbstractItemView.DragDropMode = ... # 0x3
        InternalMove             : QAbstractItemView.DragDropMode = ... # 0x4

    class DropIndicatorPosition(enum.Enum):

        OnItem                   : QAbstractItemView.DropIndicatorPosition = ... # 0x0
        AboveItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x1
        BelowItem                : QAbstractItemView.DropIndicatorPosition = ... # 0x2
        OnViewport               : QAbstractItemView.DropIndicatorPosition = ... # 0x3

    class EditTrigger(enum.Flag):

        NoEditTriggers           : QAbstractItemView.EditTrigger = ... # 0x0
        CurrentChanged           : QAbstractItemView.EditTrigger = ... # 0x1
        DoubleClicked            : QAbstractItemView.EditTrigger = ... # 0x2
        SelectedClicked          : QAbstractItemView.EditTrigger = ... # 0x4
        EditKeyPressed           : QAbstractItemView.EditTrigger = ... # 0x8
        AnyKeyPressed            : QAbstractItemView.EditTrigger = ... # 0x10
        AllEditTriggers          : QAbstractItemView.EditTrigger = ... # 0x1f

    class ScrollHint(enum.Enum):

        EnsureVisible            : QAbstractItemView.ScrollHint = ... # 0x0
        PositionAtTop            : QAbstractItemView.ScrollHint = ... # 0x1
        PositionAtBottom         : QAbstractItemView.ScrollHint = ... # 0x2
        PositionAtCenter         : QAbstractItemView.ScrollHint = ... # 0x3

    class ScrollMode(enum.Enum):

        ScrollPerItem            : QAbstractItemView.ScrollMode = ... # 0x0
        ScrollPerPixel           : QAbstractItemView.ScrollMode = ... # 0x1

    class SelectionBehavior(enum.Enum):

        SelectItems              : QAbstractItemView.SelectionBehavior = ... # 0x0
        SelectRows               : QAbstractItemView.SelectionBehavior = ... # 0x1
        SelectColumns            : QAbstractItemView.SelectionBehavior = ... # 0x2

    class SelectionMode(enum.Enum):

        NoSelection              : QAbstractItemView.SelectionMode = ... # 0x0
        SingleSelection          : QAbstractItemView.SelectionMode = ... # 0x1
        MultiSelection           : QAbstractItemView.SelectionMode = ... # 0x2
        ExtendedSelection        : QAbstractItemView.SelectionMode = ... # 0x3
        ContiguousSelection      : QAbstractItemView.SelectionMode = ... # 0x4

    class State(enum.Enum):

        NoState                  : QAbstractItemView.State = ... # 0x0
        DraggingState            : QAbstractItemView.State = ... # 0x1
        DragSelectingState       : QAbstractItemView.State = ... # 0x2
        EditingState             : QAbstractItemView.State = ... # 0x3
        ExpandingState           : QAbstractItemView.State = ... # 0x4
        CollapsingState          : QAbstractItemView.State = ... # 0x5
        AnimatingState           : QAbstractItemView.State = ... # 0x6


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def alternatingRowColors(self) -> bool: ...
    def autoScrollMargin(self) -> int: ...
    def clearSelection(self) -> None: ...
    def closeEditor(self, editor: PySide6.QtWidgets.QWidget, hint: PySide6.QtWidgets.QAbstractItemDelegate.EndEditHint) -> None: ...
    def closePersistentEditor(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def commitData(self, editor: PySide6.QtWidgets.QWidget) -> None: ...
    def currentChanged(self, current: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], previous: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def currentIndex(self) -> PySide6.QtCore.QModelIndex: ...
    def dataChanged(self, topLeft: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], bottomRight: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], roles: Sequence[int] = ...) -> None: ...
    def defaultDropAction(self) -> PySide6.QtCore.Qt.DropAction: ...
    def dirtyRegionOffset(self) -> PySide6.QtCore.QPoint: ...
    def doAutoScroll(self) -> None: ...
    def doItemsLayout(self) -> None: ...
    def dragDropMode(self) -> PySide6.QtWidgets.QAbstractItemView.DragDropMode: ...
    def dragDropOverwriteMode(self) -> bool: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, event: PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent) -> None: ...
    def dropIndicatorPosition(self) -> PySide6.QtWidgets.QAbstractItemView.DropIndicatorPosition: ...
    @overload
    def edit(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    @overload
    def edit(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], trigger: PySide6.QtWidgets.QAbstractItemView.EditTrigger, event: PySide6.QtCore.QEvent) -> bool: ...
    def editTriggers(self) -> PySide6.QtWidgets.QAbstractItemView.EditTrigger: ...
    def editorDestroyed(self, editor: PySide6.QtCore.QObject) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> bool: ...
    def executeDelayedItemsLayout(self) -> None: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def hasAutoScroll(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollMode(self) -> PySide6.QtWidgets.QAbstractItemView.ScrollMode: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def horizontalScrollbarValueChanged(self, value: int) -> None: ...
    def iconSize(self) -> PySide6.QtCore.QSize: ...
    def indexAt(self, point: PySide6.QtCore.QPoint) -> PySide6.QtCore.QModelIndex: ...
    def indexWidget(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QWidget: ...
    def initViewItemOption(self, option: PySide6.QtWidgets.QStyleOptionViewItem) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    def isIndexHidden(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def isPersistentEditorOpen(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    @overload
    def itemDelegate(self) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    @overload
    def itemDelegate(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForColumn(self, column: int) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def itemDelegateForRow(self, row: int) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyboardSearch(self, search: str) -> None: ...
    def model(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> PySide6.QtCore.QModelIndex: ...
    def openPersistentEditor(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def reset(self) -> None: ...
    def resetHorizontalScrollMode(self) -> None: ...
    def resetVerticalScrollMode(self) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def rootIndex(self) -> PySide6.QtCore.QModelIndex: ...
    def rowsAboutToBeRemoved(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], start: int, end: int) -> None: ...
    def rowsInserted(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], start: int, end: int) -> None: ...
    def scheduleDelayedItemsLayout(self) -> None: ...
    def scrollDirtyRegion(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def scrollToBottom(self) -> None: ...
    def scrollToTop(self) -> None: ...
    def selectAll(self) -> None: ...
    def selectedIndexes(self) -> List[PySide6.QtCore.QModelIndex]: ...
    def selectionBehavior(self) -> PySide6.QtWidgets.QAbstractItemView.SelectionBehavior: ...
    def selectionChanged(self, selected: PySide6.QtCore.QItemSelection, deselected: PySide6.QtCore.QItemSelection) -> None: ...
    def selectionCommand(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], event: Optional[PySide6.QtCore.QEvent] = ...) -> PySide6.QtCore.QItemSelectionModel.SelectionFlag: ...
    def selectionMode(self) -> PySide6.QtWidgets.QAbstractItemView.SelectionMode: ...
    def selectionModel(self) -> PySide6.QtCore.QItemSelectionModel: ...
    def setAlternatingRowColors(self, enable: bool) -> None: ...
    def setAutoScroll(self, enable: bool) -> None: ...
    def setAutoScrollMargin(self, margin: int) -> None: ...
    def setCurrentIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setDefaultDropAction(self, dropAction: PySide6.QtCore.Qt.DropAction) -> None: ...
    def setDirtyRegion(self, region: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    def setDragDropMode(self, behavior: PySide6.QtWidgets.QAbstractItemView.DragDropMode) -> None: ...
    def setDragDropOverwriteMode(self, overwrite: bool) -> None: ...
    def setDragEnabled(self, enable: bool) -> None: ...
    def setDropIndicatorShown(self, enable: bool) -> None: ...
    def setEditTriggers(self, triggers: PySide6.QtWidgets.QAbstractItemView.EditTrigger) -> None: ...
    def setHorizontalScrollMode(self, mode: PySide6.QtWidgets.QAbstractItemView.ScrollMode) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setIndexWidget(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setItemDelegate(self, delegate: PySide6.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setItemDelegateForColumn(self, column: int, delegate: PySide6.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setItemDelegateForRow(self, row: int, delegate: PySide6.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setModel(self, model: Optional[PySide6.QtCore.QAbstractItemModel]) -> None: ...
    def setRootIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    def setSelectionBehavior(self, behavior: PySide6.QtWidgets.QAbstractItemView.SelectionBehavior) -> None: ...
    def setSelectionMode(self, mode: PySide6.QtWidgets.QAbstractItemView.SelectionMode) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel) -> None: ...
    def setState(self, state: PySide6.QtWidgets.QAbstractItemView.State) -> None: ...
    def setTabKeyNavigation(self, enable: bool) -> None: ...
    def setTextElideMode(self, mode: PySide6.QtCore.Qt.TextElideMode) -> None: ...
    def setVerticalScrollMode(self, mode: PySide6.QtWidgets.QAbstractItemView.ScrollMode) -> None: ...
    def showDropIndicator(self) -> bool: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QSize: ...
    def sizeHintForRow(self, row: int) -> int: ...
    def startAutoScroll(self) -> None: ...
    def startDrag(self, supportedActions: PySide6.QtCore.Qt.DropAction) -> None: ...
    def state(self) -> PySide6.QtWidgets.QAbstractItemView.State: ...
    def stopAutoScroll(self) -> None: ...
    def tabKeyNavigation(self) -> bool: ...
    def textElideMode(self) -> PySide6.QtCore.Qt.TextElideMode: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None: ...
    def update(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def updateEditorData(self) -> None: ...
    def updateEditorGeometries(self) -> None: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def verticalScrollMode(self) -> PySide6.QtWidgets.QAbstractItemView.ScrollMode: ...
    def verticalScrollbarAction(self, action: int) -> None: ...
    def verticalScrollbarValueChanged(self, value: int) -> None: ...
    def viewportEvent(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> PySide6.QtCore.QSize: ...
    def visualRect(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection) -> PySide6.QtGui.QRegion: ...


class QAbstractScrollArea(PySide6.QtWidgets.QFrame):

    class SizeAdjustPolicy(enum.Enum):

        AdjustIgnored            : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x0
        AdjustToContentsOnFirstShow: QAbstractScrollArea.SizeAdjustPolicy = ... # 0x1
        AdjustToContents         : QAbstractScrollArea.SizeAdjustPolicy = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def addScrollBarWidget(self, widget: PySide6.QtWidgets.QWidget, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def contextMenuEvent(self, arg__1: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def cornerWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def dragEnterEvent(self, arg__1: PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, arg__1: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, arg__1: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1: PySide6.QtGui.QDropEvent) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    def horizontalScrollBar(self) -> PySide6.QtWidgets.QScrollBar: ...
    def horizontalScrollBarPolicy(self) -> PySide6.QtCore.Qt.ScrollBarPolicy: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def maximumViewportSize(self) -> PySide6.QtCore.QSize: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def scrollBarWidgets(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> List[PySide6.QtWidgets.QWidget]: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setCornerWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setHorizontalScrollBar(self, scrollbar: PySide6.QtWidgets.QScrollBar) -> None: ...
    def setHorizontalScrollBarPolicy(self, arg__1: PySide6.QtCore.Qt.ScrollBarPolicy) -> None: ...
    def setSizeAdjustPolicy(self, policy: PySide6.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy) -> None: ...
    def setVerticalScrollBar(self, scrollbar: PySide6.QtWidgets.QScrollBar) -> None: ...
    def setVerticalScrollBarPolicy(self, arg__1: PySide6.QtCore.Qt.ScrollBarPolicy) -> None: ...
    def setViewport(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    @overload
    def setViewportMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setViewportMargins(self, margins: PySide6.QtCore.QMargins) -> None: ...
    def setupViewport(self, viewport: PySide6.QtWidgets.QWidget) -> None: ...
    def sizeAdjustPolicy(self) -> PySide6.QtWidgets.QAbstractScrollArea.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def verticalScrollBar(self) -> PySide6.QtWidgets.QScrollBar: ...
    def verticalScrollBarPolicy(self) -> PySide6.QtCore.Qt.ScrollBarPolicy: ...
    def viewport(self) -> PySide6.QtWidgets.QWidget: ...
    def viewportEvent(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def viewportMargins(self) -> PySide6.QtCore.QMargins: ...
    def viewportSizeHint(self) -> PySide6.QtCore.QSize: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent) -> None: ...


class QAbstractSlider(PySide6.QtWidgets.QWidget):

    actionTriggered          : ClassVar[Signal] = ... # actionTriggered(int)
    rangeChanged             : ClassVar[Signal] = ... # rangeChanged(int,int)
    sliderMoved              : ClassVar[Signal] = ... # sliderMoved(int)
    sliderPressed            : ClassVar[Signal] = ... # sliderPressed()
    sliderReleased           : ClassVar[Signal] = ... # sliderReleased()
    valueChanged             : ClassVar[Signal] = ... # valueChanged(int)

    class SliderAction(enum.Enum):

        SliderNoAction           : QAbstractSlider.SliderAction = ... # 0x0
        SliderSingleStepAdd      : QAbstractSlider.SliderAction = ... # 0x1
        SliderSingleStepSub      : QAbstractSlider.SliderAction = ... # 0x2
        SliderPageStepAdd        : QAbstractSlider.SliderAction = ... # 0x3
        SliderPageStepSub        : QAbstractSlider.SliderAction = ... # 0x4
        SliderToMinimum          : QAbstractSlider.SliderAction = ... # 0x5
        SliderToMaximum          : QAbstractSlider.SliderAction = ... # 0x6
        SliderMove               : QAbstractSlider.SliderAction = ... # 0x7

    class SliderChange(enum.Enum):

        SliderRangeChange        : QAbstractSlider.SliderChange = ... # 0x0
        SliderOrientationChange  : QAbstractSlider.SliderChange = ... # 0x1
        SliderStepsChange        : QAbstractSlider.SliderChange = ... # 0x2
        SliderValueChange        : QAbstractSlider.SliderChange = ... # 0x3


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def hasTracking(self) -> bool: ...
    def invertedAppearance(self) -> bool: ...
    def invertedControls(self) -> bool: ...
    def isSliderDown(self) -> bool: ...
    def keyPressEvent(self, ev: PySide6.QtGui.QKeyEvent) -> None: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def pageStep(self) -> int: ...
    def repeatAction(self) -> PySide6.QtWidgets.QAbstractSlider.SliderAction: ...
    def setInvertedAppearance(self, arg__1: bool) -> None: ...
    def setInvertedControls(self, arg__1: bool) -> None: ...
    def setMaximum(self, arg__1: int) -> None: ...
    def setMinimum(self, arg__1: int) -> None: ...
    def setOrientation(self, arg__1: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setPageStep(self, arg__1: int) -> None: ...
    def setRange(self, min: int, max: int) -> None: ...
    def setRepeatAction(self, action: PySide6.QtWidgets.QAbstractSlider.SliderAction, thresholdTime: int = ..., repeatTime: int = ...) -> None: ...
    def setSingleStep(self, arg__1: int) -> None: ...
    def setSliderDown(self, arg__1: bool) -> None: ...
    def setSliderPosition(self, arg__1: int) -> None: ...
    def setTracking(self, enable: bool) -> None: ...
    def setValue(self, arg__1: int) -> None: ...
    def singleStep(self) -> int: ...
    def sliderChange(self, change: PySide6.QtWidgets.QAbstractSlider.SliderChange) -> None: ...
    def sliderPosition(self) -> int: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None: ...
    def triggerAction(self, action: PySide6.QtWidgets.QAbstractSlider.SliderAction) -> None: ...
    def value(self) -> int: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent) -> None: ...


class QAbstractSpinBox(PySide6.QtWidgets.QWidget):

    editingFinished          : ClassVar[Signal] = ... # editingFinished()

    class ButtonSymbols(enum.Enum):

        UpDownArrows             : QAbstractSpinBox.ButtonSymbols = ... # 0x0
        PlusMinus                : QAbstractSpinBox.ButtonSymbols = ... # 0x1
        NoButtons                : QAbstractSpinBox.ButtonSymbols = ... # 0x2

    class CorrectionMode(enum.Enum):

        CorrectToPreviousValue   : QAbstractSpinBox.CorrectionMode = ... # 0x0
        CorrectToNearestValue    : QAbstractSpinBox.CorrectionMode = ... # 0x1

    class StepEnabledFlag(enum.Flag):

        StepNone                 : QAbstractSpinBox.StepEnabledFlag = ... # 0x0
        StepUpEnabled            : QAbstractSpinBox.StepEnabledFlag = ... # 0x1
        StepDownEnabled          : QAbstractSpinBox.StepEnabledFlag = ... # 0x2

    class StepType(enum.Enum):

        DefaultStepType          : QAbstractSpinBox.StepType = ... # 0x0
        AdaptiveDecimalStepType  : QAbstractSpinBox.StepType = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def buttonSymbols(self) -> PySide6.QtWidgets.QAbstractSpinBox.ButtonSymbols: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, event: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def correctionMode(self) -> PySide6.QtWidgets.QAbstractSpinBox.CorrectionMode: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def fixup(self, input: str) -> str: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, event: PySide6.QtGui.QHideEvent) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSpinBox) -> None: ...
    def inputMethodQuery(self, arg__1: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    def interpretText(self) -> None: ...
    def isAccelerated(self) -> bool: ...
    def isGroupSeparatorShown(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyboardTracking(self) -> bool: ...
    def lineEdit(self) -> PySide6.QtWidgets.QLineEdit: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def selectAll(self) -> None: ...
    def setAccelerated(self, on: bool) -> None: ...
    def setAlignment(self, flag: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setButtonSymbols(self, bs: PySide6.QtWidgets.QAbstractSpinBox.ButtonSymbols) -> None: ...
    def setCorrectionMode(self, cm: PySide6.QtWidgets.QAbstractSpinBox.CorrectionMode) -> None: ...
    def setFrame(self, arg__1: bool) -> None: ...
    def setGroupSeparatorShown(self, shown: bool) -> None: ...
    def setKeyboardTracking(self, kt: bool) -> None: ...
    def setLineEdit(self, edit: PySide6.QtWidgets.QLineEdit) -> None: ...
    def setReadOnly(self, r: bool) -> None: ...
    def setSpecialValueText(self, txt: str) -> None: ...
    def setWrapping(self, w: bool) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def specialValueText(self) -> str: ...
    def stepBy(self, steps: int) -> None: ...
    def stepDown(self) -> None: ...
    def stepEnabled(self) -> PySide6.QtWidgets.QAbstractSpinBox.StepEnabledFlag: ...
    def stepUp(self) -> None: ...
    def text(self) -> str: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None: ...
    def validate(self, input: str, pos: int) -> object: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...
    def wrapping(self) -> bool: ...


class QAccessibleWidget(PySide6.QtGui.QAccessibleObject, PySide6.QtGui.QAccessibleActionInterface):

    def __init__(self, o: PySide6.QtWidgets.QWidget, r: PySide6.QtGui.QAccessible.Role = ..., name: str = ...) -> None: ...

    def actionNames(self) -> List[str]: ...
    def addControllingSignal(self, signal: str) -> None: ...
    def backgroundColor(self) -> PySide6.QtGui.QColor: ...
    def child(self, index: int) -> PySide6.QtGui.QAccessibleInterface: ...
    def childCount(self) -> int: ...
    def doAction(self, actionName: str) -> None: ...
    def focusChild(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def foregroundColor(self) -> PySide6.QtGui.QColor: ...
    def indexOfChild(self, child: PySide6.QtGui.QAccessibleInterface) -> int: ...
    def interface_cast(self, t: PySide6.QtGui.QAccessible.InterfaceType) -> int: ...
    def isValid(self) -> bool: ...
    def keyBindingsForAction(self, actionName: str) -> List[str]: ...
    def parent(self) -> PySide6.QtGui.QAccessibleInterface: ...
    def parentObject(self) -> PySide6.QtCore.QObject: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def relations(self, match: PySide6.QtGui.QAccessible.RelationFlag = ...) -> List[Tuple[PySide6.QtGui.QAccessibleInterface, PySide6.QtGui.QAccessible.RelationFlag]]: ...
    def role(self) -> PySide6.QtGui.QAccessible.Role: ...
    def state(self) -> PySide6.QtGui.QAccessible.State: ...
    def text(self, t: PySide6.QtGui.QAccessible.Text) -> str: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...
    def window(self) -> PySide6.QtGui.QWindow: ...


class QApplication(PySide6.QtGui.QGuiApplication):

    focusChanged             : ClassVar[Signal] = ... # focusChanged(QWidget*,QWidget*)

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg__1: Sequence[str]) -> None: ...

    @staticmethod
    def aboutQt() -> None: ...
    @staticmethod
    def activeModalWidget() -> PySide6.QtWidgets.QWidget: ...
    @staticmethod
    def activePopupWidget() -> PySide6.QtWidgets.QWidget: ...
    @staticmethod
    def activeWindow() -> PySide6.QtWidgets.QWidget: ...
    @staticmethod
    def alert(widget: PySide6.QtWidgets.QWidget, duration: int = ...) -> None: ...
    @staticmethod
    def allWidgets() -> List[PySide6.QtWidgets.QWidget]: ...
    def autoSipEnabled(self) -> bool: ...
    @staticmethod
    def beep() -> None: ...
    @staticmethod
    def closeAllWindows() -> None: ...
    @staticmethod
    def cursorFlashTime() -> int: ...
    @staticmethod
    def doubleClickInterval() -> int: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    @staticmethod
    def exec() -> int: ...
    def exec_(self) -> int: ...
    @staticmethod
    def focusWidget() -> PySide6.QtWidgets.QWidget: ...
    @overload
    @staticmethod
    def font() -> PySide6.QtGui.QFont: ...
    @overload
    @staticmethod
    def font(arg__1: PySide6.QtWidgets.QWidget) -> PySide6.QtGui.QFont: ...
    @overload
    @staticmethod
    def font(className: Union[bytes, bytearray, memoryview]) -> PySide6.QtGui.QFont: ...
    @staticmethod
    def fontMetrics() -> PySide6.QtGui.QFontMetrics: ...
    @staticmethod
    def isEffectEnabled(arg__1: PySide6.QtCore.Qt.UIEffect) -> bool: ...
    @staticmethod
    def keyboardInputInterval() -> int: ...
    def notify(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    @overload
    @staticmethod
    def palette() -> PySide6.QtGui.QPalette: ...
    @overload
    @staticmethod
    def palette(arg__1: PySide6.QtWidgets.QWidget) -> PySide6.QtGui.QPalette: ...
    @overload
    @staticmethod
    def palette(className: Union[bytes, bytearray, memoryview]) -> PySide6.QtGui.QPalette: ...
    def resolveInterface(self, name: Union[bytes, bytearray, memoryview], revision: int) -> int: ...
    @staticmethod
    def setActiveWindow(act: PySide6.QtWidgets.QWidget) -> None: ...
    def setAutoSipEnabled(self, enabled: bool) -> None: ...
    @staticmethod
    def setCursorFlashTime(arg__1: int) -> None: ...
    @staticmethod
    def setDoubleClickInterval(arg__1: int) -> None: ...
    @staticmethod
    def setEffectEnabled(arg__1: PySide6.QtCore.Qt.UIEffect, enable: bool = ...) -> None: ...
    @staticmethod
    def setFont(arg__1: Union[PySide6.QtGui.QFont, str, Sequence[str]], className: Union[bytes, bytearray, memoryview, NoneType] = ...) -> None: ...
    @staticmethod
    def setKeyboardInputInterval(arg__1: int) -> None: ...
    @staticmethod
    def setPalette(arg__1: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], className: Union[bytes, bytearray, memoryview, NoneType] = ...) -> None: ...
    @staticmethod
    def setStartDragDistance(l: int) -> None: ...
    @staticmethod
    def setStartDragTime(ms: int) -> None: ...
    @overload
    @staticmethod
    def setStyle(arg__1: PySide6.QtWidgets.QStyle) -> None: ...
    @overload
    @staticmethod
    def setStyle(arg__1: str) -> PySide6.QtWidgets.QStyle: ...
    def setStyleSheet(self, sheet: str) -> None: ...
    @staticmethod
    def setWheelScrollLines(arg__1: int) -> None: ...
    @staticmethod
    def startDragDistance() -> int: ...
    @staticmethod
    def startDragTime() -> int: ...
    @staticmethod
    def style() -> PySide6.QtWidgets.QStyle: ...
    def styleSheet(self) -> str: ...
    @overload
    @staticmethod
    def topLevelAt(p: PySide6.QtCore.QPoint) -> PySide6.QtWidgets.QWidget: ...
    @overload
    @staticmethod
    def topLevelAt(x: int, y: int) -> PySide6.QtWidgets.QWidget: ...
    @staticmethod
    def topLevelWidgets() -> List[PySide6.QtWidgets.QWidget]: ...
    @staticmethod
    def wheelScrollLines() -> int: ...
    @overload
    @staticmethod
    def widgetAt(p: PySide6.QtCore.QPoint) -> PySide6.QtWidgets.QWidget: ...
    @overload
    @staticmethod
    def widgetAt(x: int, y: int) -> PySide6.QtWidgets.QWidget: ...


class QBoxLayout(PySide6.QtWidgets.QLayout):

    class Direction(enum.Enum):

        LeftToRight              : QBoxLayout.Direction = ... # 0x0
        RightToLeft              : QBoxLayout.Direction = ... # 0x1
        Down                     : QBoxLayout.Direction = ... # 0x2
        TopToBottom              : QBoxLayout.Direction = ... # 0x2
        BottomToTop              : QBoxLayout.Direction = ... # 0x3
        Up                       : QBoxLayout.Direction = ... # 0x3


    def __init__(self, arg__1: PySide6.QtWidgets.QBoxLayout.Direction, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def addItem(self, arg__1: PySide6.QtWidgets.QLayoutItem) -> None: ...
    def addLayout(self, layout: PySide6.QtWidgets.QLayout, stretch: int = ...) -> None: ...
    def addSpacerItem(self, spacerItem: PySide6.QtWidgets.QSpacerItem) -> None: ...
    def addSpacing(self, size: int) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def addStrut(self, arg__1: int) -> None: ...
    def addWidget(self, arg__1: PySide6.QtWidgets.QWidget, stretch: int = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    def count(self) -> int: ...
    def direction(self) -> PySide6.QtWidgets.QBoxLayout.Direction: ...
    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientation: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def insertItem(self, index: int, arg__2: PySide6.QtWidgets.QLayoutItem) -> None: ...
    def insertLayout(self, index: int, layout: PySide6.QtWidgets.QLayout, stretch: int = ...) -> None: ...
    def insertSpacerItem(self, index: int, spacerItem: PySide6.QtWidgets.QSpacerItem) -> None: ...
    def insertSpacing(self, index: int, size: int) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def insertWidget(self, index: int, widget: PySide6.QtWidgets.QWidget, stretch: int = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    def invalidate(self) -> None: ...
    def itemAt(self, arg__1: int) -> PySide6.QtWidgets.QLayoutItem: ...
    def maximumSize(self) -> PySide6.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def setDirection(self, arg__1: PySide6.QtWidgets.QBoxLayout.Direction) -> None: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    def setSpacing(self, spacing: int) -> None: ...
    def setStretch(self, index: int, stretch: int) -> None: ...
    @overload
    def setStretchFactor(self, l: PySide6.QtWidgets.QLayout, stretch: int) -> bool: ...
    @overload
    def setStretchFactor(self, w: PySide6.QtWidgets.QWidget, stretch: int) -> bool: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def stretch(self, index: int) -> int: ...
    def takeAt(self, arg__1: int) -> PySide6.QtWidgets.QLayoutItem: ...


class QButtonGroup(PySide6.QtCore.QObject):

    buttonClicked            : ClassVar[Signal] = ... # buttonClicked(QAbstractButton*)
    buttonPressed            : ClassVar[Signal] = ... # buttonPressed(QAbstractButton*)
    buttonReleased           : ClassVar[Signal] = ... # buttonReleased(QAbstractButton*)
    buttonToggled            : ClassVar[Signal] = ... # buttonToggled(QAbstractButton*,bool)
    idClicked                : ClassVar[Signal] = ... # idClicked(int)
    idPressed                : ClassVar[Signal] = ... # idPressed(int)
    idReleased               : ClassVar[Signal] = ... # idReleased(int)
    idToggled                : ClassVar[Signal] = ... # idToggled(int,bool)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def addButton(self, arg__1: PySide6.QtWidgets.QAbstractButton, id: int = ...) -> None: ...
    def button(self, id: int) -> PySide6.QtWidgets.QAbstractButton: ...
    def buttons(self) -> List[PySide6.QtWidgets.QAbstractButton]: ...
    def checkedButton(self) -> PySide6.QtWidgets.QAbstractButton: ...
    def checkedId(self) -> int: ...
    def exclusive(self) -> bool: ...
    def id(self, button: PySide6.QtWidgets.QAbstractButton) -> int: ...
    def removeButton(self, arg__1: PySide6.QtWidgets.QAbstractButton) -> None: ...
    def setExclusive(self, arg__1: bool) -> None: ...
    def setId(self, button: PySide6.QtWidgets.QAbstractButton, id: int) -> None: ...


class QCalendarWidget(PySide6.QtWidgets.QWidget):

    activated                : ClassVar[Signal] = ... # activated(QDate)
    clicked                  : ClassVar[Signal] = ... # clicked(QDate)
    currentPageChanged       : ClassVar[Signal] = ... # currentPageChanged(int,int)
    selectionChanged         : ClassVar[Signal] = ... # selectionChanged()

    class HorizontalHeaderFormat(enum.Enum):

        NoHorizontalHeader       : QCalendarWidget.HorizontalHeaderFormat = ... # 0x0
        SingleLetterDayNames     : QCalendarWidget.HorizontalHeaderFormat = ... # 0x1
        ShortDayNames            : QCalendarWidget.HorizontalHeaderFormat = ... # 0x2
        LongDayNames             : QCalendarWidget.HorizontalHeaderFormat = ... # 0x3

    class SelectionMode(enum.Enum):

        NoSelection              : QCalendarWidget.SelectionMode = ... # 0x0
        SingleSelection          : QCalendarWidget.SelectionMode = ... # 0x1

    class VerticalHeaderFormat(enum.Enum):

        NoVerticalHeader         : QCalendarWidget.VerticalHeaderFormat = ... # 0x0
        ISOWeekNumbers           : QCalendarWidget.VerticalHeaderFormat = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def calendar(self) -> PySide6.QtCore.QCalendar: ...
    def clearMaximumDate(self) -> None: ...
    def clearMinimumDate(self) -> None: ...
    def dateEditAcceptDelay(self) -> int: ...
    @overload
    def dateTextFormat(self) -> Dict[PySide6.QtCore.QDate, PySide6.QtGui.QTextCharFormat]: ...
    @overload
    def dateTextFormat(self, date: PySide6.QtCore.QDate) -> PySide6.QtGui.QTextCharFormat: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> bool: ...
    def firstDayOfWeek(self) -> PySide6.QtCore.Qt.DayOfWeek: ...
    def headerTextFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def horizontalHeaderFormat(self) -> PySide6.QtWidgets.QCalendarWidget.HorizontalHeaderFormat: ...
    def isDateEditEnabled(self) -> bool: ...
    def isGridVisible(self) -> bool: ...
    def isNavigationBarVisible(self) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def maximumDate(self) -> PySide6.QtCore.QDate: ...
    def minimumDate(self) -> PySide6.QtCore.QDate: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def monthShown(self) -> int: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintCell(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, date: PySide6.QtCore.QDate) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def selectedDate(self) -> PySide6.QtCore.QDate: ...
    def selectionMode(self) -> PySide6.QtWidgets.QCalendarWidget.SelectionMode: ...
    def setCalendar(self, calendar: PySide6.QtCore.QCalendar) -> None: ...
    def setCurrentPage(self, year: int, month: int) -> None: ...
    def setDateEditAcceptDelay(self, delay: int) -> None: ...
    def setDateEditEnabled(self, enable: bool) -> None: ...
    def setDateRange(self, min: PySide6.QtCore.QDate, max: PySide6.QtCore.QDate) -> None: ...
    def setDateTextFormat(self, date: PySide6.QtCore.QDate, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def setFirstDayOfWeek(self, dayOfWeek: PySide6.QtCore.Qt.DayOfWeek) -> None: ...
    def setGridVisible(self, show: bool) -> None: ...
    def setHeaderTextFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def setHorizontalHeaderFormat(self, format: PySide6.QtWidgets.QCalendarWidget.HorizontalHeaderFormat) -> None: ...
    def setMaximumDate(self, date: PySide6.QtCore.QDate) -> None: ...
    def setMinimumDate(self, date: PySide6.QtCore.QDate) -> None: ...
    def setNavigationBarVisible(self, visible: bool) -> None: ...
    def setSelectedDate(self, date: PySide6.QtCore.QDate) -> None: ...
    def setSelectionMode(self, mode: PySide6.QtWidgets.QCalendarWidget.SelectionMode) -> None: ...
    def setVerticalHeaderFormat(self, format: PySide6.QtWidgets.QCalendarWidget.VerticalHeaderFormat) -> None: ...
    def setWeekdayTextFormat(self, dayOfWeek: PySide6.QtCore.Qt.DayOfWeek, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def showNextMonth(self) -> None: ...
    def showNextYear(self) -> None: ...
    def showPreviousMonth(self) -> None: ...
    def showPreviousYear(self) -> None: ...
    def showSelectedDate(self) -> None: ...
    def showToday(self) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def updateCell(self, date: PySide6.QtCore.QDate) -> None: ...
    def updateCells(self) -> None: ...
    def verticalHeaderFormat(self) -> PySide6.QtWidgets.QCalendarWidget.VerticalHeaderFormat: ...
    def weekdayTextFormat(self, dayOfWeek: PySide6.QtCore.Qt.DayOfWeek) -> PySide6.QtGui.QTextCharFormat: ...
    def yearShown(self) -> int: ...


class QCheckBox(PySide6.QtWidgets.QAbstractButton):

    checkStateChanged        : ClassVar[Signal] = ... # checkStateChanged(Qt::CheckState)
    stateChanged             : ClassVar[Signal] = ... # stateChanged(int)

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def checkState(self) -> PySide6.QtCore.Qt.CheckState: ...
    def checkStateSet(self) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def hitButton(self, pos: PySide6.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionButton) -> None: ...
    def isTristate(self) -> bool: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def nextCheckState(self) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def setCheckState(self, state: PySide6.QtCore.Qt.CheckState) -> None: ...
    def setTristate(self, y: bool = ...) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...


class QColorDialog(PySide6.QtWidgets.QDialog):

    colorSelected            : ClassVar[Signal] = ... # colorSelected(QColor)
    currentColorChanged      : ClassVar[Signal] = ... # currentColorChanged(QColor)

    class ColorDialogOption(enum.Flag):

        ShowAlphaChannel         : QColorDialog.ColorDialogOption = ... # 0x1
        NoButtons                : QColorDialog.ColorDialogOption = ... # 0x2
        DontUseNativeDialog      : QColorDialog.ColorDialogOption = ... # 0x4
        NoEyeDropperButton       : QColorDialog.ColorDialogOption = ... # 0x8


    @overload
    def __init__(self, initial: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int], parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def currentColor(self) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def customColor(index: int) -> PySide6.QtGui.QColor: ...
    @staticmethod
    def customCount() -> int: ...
    def done(self, result: int) -> None: ...
    @staticmethod
    def getColor(initial: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int] = ..., parent: Optional[PySide6.QtWidgets.QWidget] = ..., title: str = ..., options: PySide6.QtWidgets.QColorDialog.ColorDialogOption = ...) -> PySide6.QtGui.QColor: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview]) -> None: ...
    def options(self) -> PySide6.QtWidgets.QColorDialog.ColorDialogOption: ...
    def selectedColor(self) -> PySide6.QtGui.QColor: ...
    def setCurrentColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    @staticmethod
    def setCustomColor(index: int, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QColorDialog.ColorDialogOption, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QColorDialog.ColorDialogOption) -> None: ...
    @staticmethod
    def setStandardColor(index: int, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    @staticmethod
    def standardColor(index: int) -> PySide6.QtGui.QColor: ...
    def testOption(self, option: PySide6.QtWidgets.QColorDialog.ColorDialogOption) -> bool: ...


class QColormap(Shiboken.Object):

    class Mode(enum.Enum):

        Direct                   : QColormap.Mode = ... # 0x0
        Indexed                  : QColormap.Mode = ... # 0x1
        Gray                     : QColormap.Mode = ... # 0x2


    def __init__(self, colormap: PySide6.QtWidgets.QColormap) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    @staticmethod
    def cleanup() -> None: ...
    def colorAt(self, pixel: int) -> PySide6.QtGui.QColor: ...
    def colormap(self) -> List[PySide6.QtGui.QColor]: ...
    def depth(self) -> int: ...
    @staticmethod
    def initialize() -> None: ...
    @staticmethod
    def instance(screen: int = ...) -> PySide6.QtWidgets.QColormap: ...
    def mode(self) -> PySide6.QtWidgets.QColormap.Mode: ...
    def pixel(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> int: ...
    def size(self) -> int: ...


class QColumnView(PySide6.QtWidgets.QAbstractItemView):

    updatePreviewWidget      : ClassVar[Signal] = ... # updatePreviewWidget(QModelIndex)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def columnWidths(self) -> List[int]: ...
    def createColumn(self, rootIndex: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QAbstractItemView: ...
    def currentChanged(self, current: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], previous: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, point: PySide6.QtCore.QPoint) -> PySide6.QtCore.QModelIndex: ...
    def initializeColumn(self, column: PySide6.QtWidgets.QAbstractItemView) -> None: ...
    def isIndexHidden(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> PySide6.QtCore.QModelIndex: ...
    def previewWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def resizeGripsVisible(self) -> bool: ...
    def rowsInserted(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectAll(self) -> None: ...
    def setColumnWidths(self, list: Sequence[int]) -> None: ...
    def setModel(self, model: Optional[PySide6.QtCore.QAbstractItemModel]) -> None: ...
    def setPreviewWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setResizeGripsVisible(self, visible: bool) -> None: ...
    def setRootIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def verticalOffset(self) -> int: ...
    def visualRect(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection) -> PySide6.QtGui.QRegion: ...


class QComboBox(PySide6.QtWidgets.QWidget):

    activated                : ClassVar[Signal] = ... # activated(int)
    currentIndexChanged      : ClassVar[Signal] = ... # currentIndexChanged(int)
    currentTextChanged       : ClassVar[Signal] = ... # currentTextChanged(QString)
    editTextChanged          : ClassVar[Signal] = ... # editTextChanged(QString)
    highlighted              : ClassVar[Signal] = ... # highlighted(int)
    textActivated            : ClassVar[Signal] = ... # textActivated(QString)
    textHighlighted          : ClassVar[Signal] = ... # textHighlighted(QString)

    class InsertPolicy(enum.Enum):

        NoInsert                 : QComboBox.InsertPolicy = ... # 0x0
        InsertAtTop              : QComboBox.InsertPolicy = ... # 0x1
        InsertAtCurrent          : QComboBox.InsertPolicy = ... # 0x2
        InsertAtBottom           : QComboBox.InsertPolicy = ... # 0x3
        InsertAfterCurrent       : QComboBox.InsertPolicy = ... # 0x4
        InsertBeforeCurrent      : QComboBox.InsertPolicy = ... # 0x5
        InsertAlphabetically     : QComboBox.InsertPolicy = ... # 0x6

    class SizeAdjustPolicy(enum.Enum):

        AdjustToContents         : QComboBox.SizeAdjustPolicy = ... # 0x0
        AdjustToContentsOnFirstShow: QComboBox.SizeAdjustPolicy = ... # 0x1
        AdjustToMinimumContentsLengthWithIcon: QComboBox.SizeAdjustPolicy = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    @overload
    def addItem(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, userData: Any = ...) -> None: ...
    @overload
    def addItem(self, text: str, userData: Any = ...) -> None: ...
    def addItems(self, texts: Sequence[str]) -> None: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def clearEditText(self) -> None: ...
    def completer(self) -> PySide6.QtWidgets.QCompleter: ...
    def contextMenuEvent(self, e: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def count(self) -> int: ...
    def currentData(self, role: int = ...) -> Any: ...
    def currentIndex(self) -> int: ...
    def currentText(self) -> str: ...
    def duplicatesEnabled(self) -> bool: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def findData(self, data: Any, role: int = ..., flags: PySide6.QtCore.Qt.MatchFlag = ...) -> int: ...
    def findText(self, text: str, flags: PySide6.QtCore.Qt.MatchFlag = ...) -> int: ...
    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent) -> None: ...
    def hasFrame(self) -> bool: ...
    def hideEvent(self, e: PySide6.QtGui.QHideEvent) -> None: ...
    def hidePopup(self) -> None: ...
    def iconSize(self) -> PySide6.QtCore.QSize: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionComboBox) -> None: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None: ...
    @overload
    def inputMethodQuery(self, arg__1: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    @overload
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, argument: Any) -> Any: ...
    @overload
    def insertItem(self, index: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, userData: Any = ...) -> None: ...
    @overload
    def insertItem(self, index: int, text: str, userData: Any = ...) -> None: ...
    def insertItems(self, index: int, texts: Sequence[str]) -> None: ...
    def insertPolicy(self) -> PySide6.QtWidgets.QComboBox.InsertPolicy: ...
    def insertSeparator(self, index: int) -> None: ...
    def isEditable(self) -> bool: ...
    def itemData(self, index: int, role: int = ...) -> Any: ...
    def itemDelegate(self) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def itemIcon(self, index: int) -> PySide6.QtGui.QIcon: ...
    def itemText(self, index: int) -> str: ...
    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent) -> None: ...
    def lineEdit(self) -> PySide6.QtWidgets.QLineEdit: ...
    def maxCount(self) -> int: ...
    def maxVisibleItems(self) -> int: ...
    def minimumContentsLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def model(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def modelColumn(self) -> int: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def placeholderText(self) -> str: ...
    def removeItem(self, index: int) -> None: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent) -> None: ...
    def rootModelIndex(self) -> PySide6.QtCore.QModelIndex: ...
    def setCompleter(self, c: PySide6.QtWidgets.QCompleter) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentText(self, text: str) -> None: ...
    def setDuplicatesEnabled(self, enable: bool) -> None: ...
    def setEditText(self, text: str) -> None: ...
    def setEditable(self, editable: bool) -> None: ...
    def setFrame(self, arg__1: bool) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setInsertPolicy(self, policy: PySide6.QtWidgets.QComboBox.InsertPolicy) -> None: ...
    def setItemData(self, index: int, value: Any, role: int = ...) -> None: ...
    def setItemDelegate(self, delegate: PySide6.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setItemIcon(self, index: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setItemText(self, index: int, text: str) -> None: ...
    def setLineEdit(self, edit: PySide6.QtWidgets.QLineEdit) -> None: ...
    def setMaxCount(self, max: int) -> None: ...
    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def setMinimumContentsLength(self, characters: int) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None: ...
    def setModelColumn(self, visibleColumn: int) -> None: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def setRootModelIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setSizeAdjustPolicy(self, policy: PySide6.QtWidgets.QComboBox.SizeAdjustPolicy) -> None: ...
    def setValidator(self, v: PySide6.QtGui.QValidator) -> None: ...
    def setView(self, itemView: PySide6.QtWidgets.QAbstractItemView) -> None: ...
    def showEvent(self, e: PySide6.QtGui.QShowEvent) -> None: ...
    def showPopup(self) -> None: ...
    def sizeAdjustPolicy(self) -> PySide6.QtWidgets.QComboBox.SizeAdjustPolicy: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def validator(self) -> PySide6.QtGui.QValidator: ...
    def view(self) -> PySide6.QtWidgets.QAbstractItemView: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent) -> None: ...


class QCommandLinkButton(PySide6.QtWidgets.QPushButton):

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, text: str, description: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def description(self) -> str: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionButton) -> None: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def setDescription(self, description: str) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...


class QCommonStyle(PySide6.QtWidgets.QStyle):

    def __init__(self) -> None: ...

    def drawComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, p: PySide6.QtGui.QPainter, w: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def drawControl(self, element: PySide6.QtWidgets.QStyle.ControlElement, opt: PySide6.QtWidgets.QStyleOption, p: PySide6.QtGui.QPainter, w: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def drawPrimitive(self, pe: PySide6.QtWidgets.QStyle.PrimitiveElement, opt: PySide6.QtWidgets.QStyleOption, p: PySide6.QtGui.QPainter, w: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def generatedIconPixmap(self, iconMode: PySide6.QtGui.QIcon.Mode, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], opt: PySide6.QtWidgets.QStyleOption) -> PySide6.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, pt: PySide6.QtCore.QPoint, w: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtWidgets.QStyle.SubControl: ...
    def layoutSpacing(self, control1: PySide6.QtWidgets.QSizePolicy.ControlType, control2: PySide6.QtWidgets.QSizePolicy.ControlType, orientation: PySide6.QtCore.Qt.Orientation, option: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> int: ...
    def pixelMetric(self, m: PySide6.QtWidgets.QStyle.PixelMetric, opt: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> int: ...
    @overload
    def polish(self, app: PySide6.QtWidgets.QApplication) -> None: ...
    @overload
    def polish(self, arg__1: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @overload
    def polish(self, palette: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @overload
    def polish(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def sizeFromContents(self, ct: PySide6.QtWidgets.QStyle.ContentsType, opt: PySide6.QtWidgets.QStyleOption, contentsSize: PySide6.QtCore.QSize, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtCore.QSize: ...
    def standardIcon(self, standardIcon: PySide6.QtWidgets.QStyle.StandardPixmap, opt: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtGui.QIcon: ...
    def standardPixmap(self, sp: PySide6.QtWidgets.QStyle.StandardPixmap, opt: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtGui.QPixmap: ...
    def styleHint(self, sh: PySide6.QtWidgets.QStyle.StyleHint, opt: Optional[PySide6.QtWidgets.QStyleOption] = ..., w: Optional[PySide6.QtWidgets.QWidget] = ..., shret: Optional[PySide6.QtWidgets.QStyleHintReturn] = ...) -> int: ...
    def subControlRect(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, sc: PySide6.QtWidgets.QStyle.SubControl, w: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtCore.QRect: ...
    def subElementRect(self, r: PySide6.QtWidgets.QStyle.SubElement, opt: PySide6.QtWidgets.QStyleOption, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtCore.QRect: ...
    @overload
    def unpolish(self, application: PySide6.QtWidgets.QApplication) -> None: ...
    @overload
    def unpolish(self, widget: PySide6.QtWidgets.QWidget) -> None: ...


class QCompleter(PySide6.QtCore.QObject):

    activated                : ClassVar[Signal] = ... # activated(QString); activated(QModelIndex)
    highlighted              : ClassVar[Signal] = ... # highlighted(QString); highlighted(QModelIndex)

    class CompletionMode(enum.Enum):

        PopupCompletion          : QCompleter.CompletionMode = ... # 0x0
        UnfilteredPopupCompletion: QCompleter.CompletionMode = ... # 0x1
        InlineCompletion         : QCompleter.CompletionMode = ... # 0x2

    class ModelSorting(enum.Enum):

        UnsortedModel            : QCompleter.ModelSorting = ... # 0x0
        CaseSensitivelySortedModel: QCompleter.ModelSorting = ... # 0x1
        CaseInsensitivelySortedModel: QCompleter.ModelSorting = ... # 0x2


    @overload
    def __init__(self, completions: Sequence[str], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, model: PySide6.QtCore.QAbstractItemModel, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def caseSensitivity(self) -> PySide6.QtCore.Qt.CaseSensitivity: ...
    def complete(self, rect: PySide6.QtCore.QRect = ...) -> None: ...
    def completionColumn(self) -> int: ...
    def completionCount(self) -> int: ...
    def completionMode(self) -> PySide6.QtWidgets.QCompleter.CompletionMode: ...
    def completionModel(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def completionPrefix(self) -> str: ...
    def completionRole(self) -> int: ...
    def currentCompletion(self) -> str: ...
    def currentIndex(self) -> PySide6.QtCore.QModelIndex: ...
    def currentRow(self) -> int: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, o: PySide6.QtCore.QObject, e: PySide6.QtCore.QEvent) -> bool: ...
    def filterMode(self) -> PySide6.QtCore.Qt.MatchFlag: ...
    def maxVisibleItems(self) -> int: ...
    def model(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def modelSorting(self) -> PySide6.QtWidgets.QCompleter.ModelSorting: ...
    def pathFromIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> str: ...
    def popup(self) -> PySide6.QtWidgets.QAbstractItemView: ...
    def setCaseSensitivity(self, caseSensitivity: PySide6.QtCore.Qt.CaseSensitivity) -> None: ...
    def setCompletionColumn(self, column: int) -> None: ...
    def setCompletionMode(self, mode: PySide6.QtWidgets.QCompleter.CompletionMode) -> None: ...
    def setCompletionPrefix(self, prefix: str) -> None: ...
    def setCompletionRole(self, role: int) -> None: ...
    def setCurrentRow(self, row: int) -> bool: ...
    def setFilterMode(self, filterMode: PySide6.QtCore.Qt.MatchFlag) -> None: ...
    def setMaxVisibleItems(self, maxItems: int) -> None: ...
    def setModel(self, c: PySide6.QtCore.QAbstractItemModel) -> None: ...
    def setModelSorting(self, sorting: PySide6.QtWidgets.QCompleter.ModelSorting) -> None: ...
    def setPopup(self, popup: PySide6.QtWidgets.QAbstractItemView) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setWrapAround(self, wrap: bool) -> None: ...
    def splitPath(self, path: str) -> List[str]: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...
    def wrapAround(self) -> bool: ...


class QDataWidgetMapper(PySide6.QtCore.QObject):

    currentIndexChanged      : ClassVar[Signal] = ... # currentIndexChanged(int)

    class SubmitPolicy(enum.Enum):

        AutoSubmit               : QDataWidgetMapper.SubmitPolicy = ... # 0x0
        ManualSubmit             : QDataWidgetMapper.SubmitPolicy = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    @overload
    def addMapping(self, widget: PySide6.QtWidgets.QWidget, section: int) -> None: ...
    @overload
    def addMapping(self, widget: PySide6.QtWidgets.QWidget, section: int, propertyName: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> None: ...
    def clearMapping(self) -> None: ...
    def currentIndex(self) -> int: ...
    def itemDelegate(self) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def mappedPropertyName(self, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtCore.QByteArray: ...
    def mappedSection(self, widget: PySide6.QtWidgets.QWidget) -> int: ...
    def mappedWidgetAt(self, section: int) -> PySide6.QtWidgets.QWidget: ...
    def model(self) -> PySide6.QtCore.QAbstractItemModel: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def removeMapping(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def revert(self) -> None: ...
    def rootIndex(self) -> PySide6.QtCore.QModelIndex: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentModelIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setItemDelegate(self, delegate: PySide6.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setModel(self, model: PySide6.QtCore.QAbstractItemModel) -> None: ...
    def setOrientation(self, aOrientation: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setRootIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setSubmitPolicy(self, policy: PySide6.QtWidgets.QDataWidgetMapper.SubmitPolicy) -> None: ...
    def submit(self) -> bool: ...
    def submitPolicy(self) -> PySide6.QtWidgets.QDataWidgetMapper.SubmitPolicy: ...
    def toFirst(self) -> None: ...
    def toLast(self) -> None: ...
    def toNext(self) -> None: ...
    def toPrevious(self) -> None: ...


class QDateEdit(PySide6.QtWidgets.QDateTimeEdit):

    userDateChanged          : ClassVar[Signal] = ... # userDateChanged(QDate)

    @overload
    def __init__(self, date: PySide6.QtCore.QDate, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...


class QDateTimeEdit(PySide6.QtWidgets.QAbstractSpinBox):

    dateChanged              : ClassVar[Signal] = ... # dateChanged(QDate)
    dateTimeChanged          : ClassVar[Signal] = ... # dateTimeChanged(QDateTime)
    timeChanged              : ClassVar[Signal] = ... # timeChanged(QTime)

    class Section(enum.Flag):

        NoSection                : QDateTimeEdit.Section = ... # 0x0
        AmPmSection              : QDateTimeEdit.Section = ... # 0x1
        MSecSection              : QDateTimeEdit.Section = ... # 0x2
        SecondSection            : QDateTimeEdit.Section = ... # 0x4
        MinuteSection            : QDateTimeEdit.Section = ... # 0x8
        HourSection              : QDateTimeEdit.Section = ... # 0x10
        TimeSections_Mask        : QDateTimeEdit.Section = ... # 0x1f
        DaySection               : QDateTimeEdit.Section = ... # 0x100
        MonthSection             : QDateTimeEdit.Section = ... # 0x200
        YearSection              : QDateTimeEdit.Section = ... # 0x400
        DateSections_Mask        : QDateTimeEdit.Section = ... # 0x700


    @overload
    def __init__(self, d: PySide6.QtCore.QDate, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, dt: PySide6.QtCore.QDateTime, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, t: PySide6.QtCore.QTime, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, val: Any, parserType: PySide6.QtCore.QMetaType.Type, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def calendar(self) -> PySide6.QtCore.QCalendar: ...
    def calendarPopup(self) -> bool: ...
    def calendarWidget(self) -> PySide6.QtWidgets.QCalendarWidget: ...
    def clear(self) -> None: ...
    def clearMaximumDate(self) -> None: ...
    def clearMaximumDateTime(self) -> None: ...
    def clearMaximumTime(self) -> None: ...
    def clearMinimumDate(self) -> None: ...
    def clearMinimumDateTime(self) -> None: ...
    def clearMinimumTime(self) -> None: ...
    def currentSection(self) -> PySide6.QtWidgets.QDateTimeEdit.Section: ...
    def currentSectionIndex(self) -> int: ...
    def date(self) -> PySide6.QtCore.QDate: ...
    def dateTime(self) -> PySide6.QtCore.QDateTime: ...
    def dateTimeFromText(self, text: str) -> PySide6.QtCore.QDateTime: ...
    def displayFormat(self) -> str: ...
    def displayedSections(self) -> PySide6.QtWidgets.QDateTimeEdit.Section: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def fixup(self, input: str) -> str: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSpinBox) -> None: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def maximumDate(self) -> PySide6.QtCore.QDate: ...
    def maximumDateTime(self) -> PySide6.QtCore.QDateTime: ...
    def maximumTime(self) -> PySide6.QtCore.QTime: ...
    def minimumDate(self) -> PySide6.QtCore.QDate: ...
    def minimumDateTime(self) -> PySide6.QtCore.QDateTime: ...
    def minimumTime(self) -> PySide6.QtCore.QTime: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    def sectionAt(self, index: int) -> PySide6.QtWidgets.QDateTimeEdit.Section: ...
    def sectionCount(self) -> int: ...
    def sectionText(self, section: PySide6.QtWidgets.QDateTimeEdit.Section) -> str: ...
    def setCalendar(self, calendar: PySide6.QtCore.QCalendar) -> None: ...
    def setCalendarPopup(self, enable: bool) -> None: ...
    def setCalendarWidget(self, calendarWidget: PySide6.QtWidgets.QCalendarWidget) -> None: ...
    def setCurrentSection(self, section: PySide6.QtWidgets.QDateTimeEdit.Section) -> None: ...
    def setCurrentSectionIndex(self, index: int) -> None: ...
    def setDate(self, date: PySide6.QtCore.QDate) -> None: ...
    def setDateRange(self, min: PySide6.QtCore.QDate, max: PySide6.QtCore.QDate) -> None: ...
    def setDateTime(self, dateTime: PySide6.QtCore.QDateTime) -> None: ...
    def setDateTimeRange(self, min: PySide6.QtCore.QDateTime, max: PySide6.QtCore.QDateTime) -> None: ...
    def setDisplayFormat(self, format: str) -> None: ...
    def setMaximumDate(self, max: PySide6.QtCore.QDate) -> None: ...
    def setMaximumDateTime(self, dt: PySide6.QtCore.QDateTime) -> None: ...
    def setMaximumTime(self, max: PySide6.QtCore.QTime) -> None: ...
    def setMinimumDate(self, min: PySide6.QtCore.QDate) -> None: ...
    def setMinimumDateTime(self, dt: PySide6.QtCore.QDateTime) -> None: ...
    def setMinimumTime(self, min: PySide6.QtCore.QTime) -> None: ...
    def setSelectedSection(self, section: PySide6.QtWidgets.QDateTimeEdit.Section) -> None: ...
    def setTime(self, time: PySide6.QtCore.QTime) -> None: ...
    def setTimeRange(self, min: PySide6.QtCore.QTime, max: PySide6.QtCore.QTime) -> None: ...
    def setTimeSpec(self, spec: PySide6.QtCore.Qt.TimeSpec) -> None: ...
    def setTimeZone(self, zone: Union[PySide6.QtCore.QTimeZone, PySide6.QtCore.QTimeZone.Initialization]) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def stepBy(self, steps: int) -> None: ...
    def stepEnabled(self) -> PySide6.QtWidgets.QAbstractSpinBox.StepEnabledFlag: ...
    def textFromDateTime(self, dt: PySide6.QtCore.QDateTime) -> str: ...
    def time(self) -> PySide6.QtCore.QTime: ...
    def timeSpec(self) -> PySide6.QtCore.Qt.TimeSpec: ...
    def timeZone(self) -> PySide6.QtCore.QTimeZone: ...
    def validate(self, input: str, pos: int) -> object: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...


class QDial(PySide6.QtWidgets.QAbstractSlider):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSlider) -> None: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, me: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, me: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, me: PySide6.QtGui.QMouseEvent) -> None: ...
    def notchSize(self) -> int: ...
    def notchTarget(self) -> float: ...
    def notchesVisible(self) -> bool: ...
    def paintEvent(self, pe: PySide6.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, re: PySide6.QtGui.QResizeEvent) -> None: ...
    def setNotchTarget(self, target: float) -> None: ...
    def setNotchesVisible(self, visible: bool) -> None: ...
    def setWrapping(self, on: bool) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def sliderChange(self, change: PySide6.QtWidgets.QAbstractSlider.SliderChange) -> None: ...
    def wrapping(self) -> bool: ...


class QDialog(PySide6.QtWidgets.QWidget):

    accepted                 : ClassVar[Signal] = ... # accepted()
    finished                 : ClassVar[Signal] = ... # finished(int)
    rejected                 : ClassVar[Signal] = ... # rejected()

    class DialogCode(enum.IntEnum):

        Rejected                 : QDialog.DialogCode = ... # 0x0
        Accepted                 : QDialog.DialogCode = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def accept(self) -> None: ...
    def adjustPosition(self, arg__1: PySide6.QtWidgets.QWidget) -> None: ...
    def closeEvent(self, arg__1: PySide6.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, arg__1: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def done(self, arg__1: int) -> None: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    def exec(self) -> int: ...
    def exec_(self) -> int: ...
    def isSizeGripEnabled(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def open(self) -> None: ...
    def reject(self) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def result(self) -> int: ...
    def setModal(self, modal: bool) -> None: ...
    def setResult(self, r: int) -> None: ...
    def setSizeGripEnabled(self, arg__1: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...


class QDialogButtonBox(PySide6.QtWidgets.QWidget):

    accepted                 : ClassVar[Signal] = ... # accepted()
    clicked                  : ClassVar[Signal] = ... # clicked(QAbstractButton*)
    helpRequested            : ClassVar[Signal] = ... # helpRequested()
    rejected                 : ClassVar[Signal] = ... # rejected()

    class ButtonLayout(enum.Enum):

        WinLayout                : QDialogButtonBox.ButtonLayout = ... # 0x0
        MacLayout                : QDialogButtonBox.ButtonLayout = ... # 0x1
        KdeLayout                : QDialogButtonBox.ButtonLayout = ... # 0x2
        GnomeLayout              : QDialogButtonBox.ButtonLayout = ... # 0x3
        AndroidLayout            : QDialogButtonBox.ButtonLayout = ... # 0x4

    class ButtonRole(enum.Enum):

        InvalidRole              : QDialogButtonBox.ButtonRole = ... # -0x1
        AcceptRole               : QDialogButtonBox.ButtonRole = ... # 0x0
        RejectRole               : QDialogButtonBox.ButtonRole = ... # 0x1
        DestructiveRole          : QDialogButtonBox.ButtonRole = ... # 0x2
        ActionRole               : QDialogButtonBox.ButtonRole = ... # 0x3
        HelpRole                 : QDialogButtonBox.ButtonRole = ... # 0x4
        YesRole                  : QDialogButtonBox.ButtonRole = ... # 0x5
        NoRole                   : QDialogButtonBox.ButtonRole = ... # 0x6
        ResetRole                : QDialogButtonBox.ButtonRole = ... # 0x7
        ApplyRole                : QDialogButtonBox.ButtonRole = ... # 0x8
        NRoles                   : QDialogButtonBox.ButtonRole = ... # 0x9

    class StandardButton(enum.Flag):

        NoButton                 : QDialogButtonBox.StandardButton = ... # 0x0
        FirstButton              : QDialogButtonBox.StandardButton = ... # 0x400
        Ok                       : QDialogButtonBox.StandardButton = ... # 0x400
        Save                     : QDialogButtonBox.StandardButton = ... # 0x800
        SaveAll                  : QDialogButtonBox.StandardButton = ... # 0x1000
        Open                     : QDialogButtonBox.StandardButton = ... # 0x2000
        Yes                      : QDialogButtonBox.StandardButton = ... # 0x4000
        YesToAll                 : QDialogButtonBox.StandardButton = ... # 0x8000
        No                       : QDialogButtonBox.StandardButton = ... # 0x10000
        NoToAll                  : QDialogButtonBox.StandardButton = ... # 0x20000
        Abort                    : QDialogButtonBox.StandardButton = ... # 0x40000
        Retry                    : QDialogButtonBox.StandardButton = ... # 0x80000
        Ignore                   : QDialogButtonBox.StandardButton = ... # 0x100000
        Close                    : QDialogButtonBox.StandardButton = ... # 0x200000
        Cancel                   : QDialogButtonBox.StandardButton = ... # 0x400000
        Discard                  : QDialogButtonBox.StandardButton = ... # 0x800000
        Help                     : QDialogButtonBox.StandardButton = ... # 0x1000000
        Apply                    : QDialogButtonBox.StandardButton = ... # 0x2000000
        Reset                    : QDialogButtonBox.StandardButton = ... # 0x4000000
        LastButton               : QDialogButtonBox.StandardButton = ... # 0x8000000
        RestoreDefaults          : QDialogButtonBox.StandardButton = ... # 0x8000000


    @overload
    def __init__(self, buttons: PySide6.QtWidgets.QDialogButtonBox.StandardButton, orientation: PySide6.QtCore.Qt.Orientation, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, buttons: PySide6.QtWidgets.QDialogButtonBox.StandardButton, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, orientation: PySide6.QtCore.Qt.Orientation, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    @overload
    def addButton(self, button: PySide6.QtWidgets.QAbstractButton, role: PySide6.QtWidgets.QDialogButtonBox.ButtonRole) -> None: ...
    @overload
    def addButton(self, button: PySide6.QtWidgets.QDialogButtonBox.StandardButton) -> PySide6.QtWidgets.QPushButton: ...
    @overload
    def addButton(self, text: str, role: PySide6.QtWidgets.QDialogButtonBox.ButtonRole) -> PySide6.QtWidgets.QPushButton: ...
    def button(self, which: PySide6.QtWidgets.QDialogButtonBox.StandardButton) -> PySide6.QtWidgets.QPushButton: ...
    def buttonRole(self, button: PySide6.QtWidgets.QAbstractButton) -> PySide6.QtWidgets.QDialogButtonBox.ButtonRole: ...
    def buttons(self) -> List[PySide6.QtWidgets.QAbstractButton]: ...
    def centerButtons(self) -> bool: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def removeButton(self, button: PySide6.QtWidgets.QAbstractButton) -> None: ...
    def setCenterButtons(self, center: bool) -> None: ...
    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setStandardButtons(self, buttons: PySide6.QtWidgets.QDialogButtonBox.StandardButton) -> None: ...
    def standardButton(self, button: PySide6.QtWidgets.QAbstractButton) -> PySide6.QtWidgets.QDialogButtonBox.StandardButton: ...
    def standardButtons(self) -> PySide6.QtWidgets.QDialogButtonBox.StandardButton: ...


class QDockWidget(PySide6.QtWidgets.QWidget):

    allowedAreasChanged      : ClassVar[Signal] = ... # allowedAreasChanged(Qt::DockWidgetAreas)
    dockLocationChanged      : ClassVar[Signal] = ... # dockLocationChanged(Qt::DockWidgetArea)
    featuresChanged          : ClassVar[Signal] = ... # featuresChanged(QDockWidget::DockWidgetFeatures)
    topLevelChanged          : ClassVar[Signal] = ... # topLevelChanged(bool)
    visibilityChanged        : ClassVar[Signal] = ... # visibilityChanged(bool)

    class DockWidgetFeature(enum.Flag):

        NoDockWidgetFeatures     : QDockWidget.DockWidgetFeature = ... # 0x0
        DockWidgetClosable       : QDockWidget.DockWidgetFeature = ... # 0x1
        DockWidgetMovable        : QDockWidget.DockWidgetFeature = ... # 0x2
        DockWidgetFloatable      : QDockWidget.DockWidgetFeature = ... # 0x4
        DockWidgetVerticalTitleBar: QDockWidget.DockWidgetFeature = ... # 0x8
        DockWidgetFeatureMask    : QDockWidget.DockWidgetFeature = ... # 0xf
        Reserved                 : QDockWidget.DockWidgetFeature = ... # 0xff


    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...
    @overload
    def __init__(self, title: str, parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def allowedAreas(self) -> PySide6.QtCore.Qt.DockWidgetArea: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def features(self) -> PySide6.QtWidgets.QDockWidget.DockWidgetFeature: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionDockWidget) -> None: ...
    def isAreaAllowed(self, area: PySide6.QtCore.Qt.DockWidgetArea) -> bool: ...
    def isFloating(self) -> bool: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    def setAllowedAreas(self, areas: PySide6.QtCore.Qt.DockWidgetArea) -> None: ...
    def setFeatures(self, features: PySide6.QtWidgets.QDockWidget.DockWidgetFeature) -> None: ...
    def setFloating(self, floating: bool) -> None: ...
    def setTitleBarWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def titleBarWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def toggleViewAction(self) -> PySide6.QtGui.QAction: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...


class QDoubleSpinBox(PySide6.QtWidgets.QAbstractSpinBox):

    textChanged              : ClassVar[Signal] = ... # textChanged(QString)
    valueChanged             : ClassVar[Signal] = ... # valueChanged(double)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def cleanText(self) -> str: ...
    def decimals(self) -> int: ...
    def fixup(self, str: str) -> str: ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def prefix(self) -> str: ...
    def setDecimals(self, prec: int) -> None: ...
    def setMaximum(self, max: float) -> None: ...
    def setMinimum(self, min: float) -> None: ...
    def setPrefix(self, prefix: str) -> None: ...
    def setRange(self, min: float, max: float) -> None: ...
    def setSingleStep(self, val: float) -> None: ...
    def setStepType(self, stepType: PySide6.QtWidgets.QAbstractSpinBox.StepType) -> None: ...
    def setSuffix(self, suffix: str) -> None: ...
    def setValue(self, val: float) -> None: ...
    def singleStep(self) -> float: ...
    def stepType(self) -> PySide6.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val: float) -> str: ...
    def validate(self, input: str, pos: int) -> object: ...
    def value(self) -> float: ...
    def valueFromText(self, text: str) -> float: ...


class QErrorMessage(PySide6.QtWidgets.QDialog):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None: ...
    def done(self, arg__1: int) -> None: ...
    @staticmethod
    def qtHandler() -> PySide6.QtWidgets.QErrorMessage: ...
    @overload
    def showMessage(self, message: str) -> None: ...
    @overload
    def showMessage(self, message: str, type: str) -> None: ...


class QFileDialog(PySide6.QtWidgets.QDialog):

    currentChanged           : ClassVar[Signal] = ... # currentChanged(QString)
    currentUrlChanged        : ClassVar[Signal] = ... # currentUrlChanged(QUrl)
    directoryEntered         : ClassVar[Signal] = ... # directoryEntered(QString)
    directoryUrlEntered      : ClassVar[Signal] = ... # directoryUrlEntered(QUrl)
    fileSelected             : ClassVar[Signal] = ... # fileSelected(QString)
    filesSelected            : ClassVar[Signal] = ... # filesSelected(QStringList)
    filterSelected           : ClassVar[Signal] = ... # filterSelected(QString)
    urlSelected              : ClassVar[Signal] = ... # urlSelected(QUrl)
    urlsSelected             : ClassVar[Signal] = ... # urlsSelected(QList<QUrl>)

    class AcceptMode(enum.Enum):

        AcceptOpen               : QFileDialog.AcceptMode = ... # 0x0
        AcceptSave               : QFileDialog.AcceptMode = ... # 0x1

    class DialogLabel(enum.Enum):

        LookIn                   : QFileDialog.DialogLabel = ... # 0x0
        FileName                 : QFileDialog.DialogLabel = ... # 0x1
        FileType                 : QFileDialog.DialogLabel = ... # 0x2
        Accept                   : QFileDialog.DialogLabel = ... # 0x3
        Reject                   : QFileDialog.DialogLabel = ... # 0x4

    class FileMode(enum.Enum):

        AnyFile                  : QFileDialog.FileMode = ... # 0x0
        ExistingFile             : QFileDialog.FileMode = ... # 0x1
        Directory                : QFileDialog.FileMode = ... # 0x2
        ExistingFiles            : QFileDialog.FileMode = ... # 0x3

    class Option(enum.Flag):

        ShowDirsOnly             : QFileDialog.Option = ... # 0x1
        DontResolveSymlinks      : QFileDialog.Option = ... # 0x2
        DontConfirmOverwrite     : QFileDialog.Option = ... # 0x4
        DontUseNativeDialog      : QFileDialog.Option = ... # 0x8
        ReadOnly                 : QFileDialog.Option = ... # 0x10
        HideNameFilterDetails    : QFileDialog.Option = ... # 0x20
        DontUseCustomDirectoryIcons: QFileDialog.Option = ... # 0x40

    class ViewMode(enum.Enum):

        Detail                   : QFileDialog.ViewMode = ... # 0x0
        List                     : QFileDialog.ViewMode = ... # 0x1


    @overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget, f: PySide6.QtCore.Qt.WindowType) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ...) -> None: ...

    def accept(self) -> None: ...
    def acceptMode(self) -> PySide6.QtWidgets.QFileDialog.AcceptMode: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None: ...
    def defaultSuffix(self) -> str: ...
    def directory(self) -> PySide6.QtCore.QDir: ...
    def directoryUrl(self) -> PySide6.QtCore.QUrl: ...
    def done(self, result: int) -> None: ...
    def fileMode(self) -> PySide6.QtWidgets.QFileDialog.FileMode: ...
    def filter(self) -> PySide6.QtCore.QDir.Filter: ...
    @staticmethod
    def getExistingDirectory(parent: Optional[PySide6.QtWidgets.QWidget] = ..., caption: str = ..., dir: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ...) -> str: ...
    @staticmethod
    def getExistingDirectoryUrl(parent: Optional[PySide6.QtWidgets.QWidget] = ..., caption: str = ..., dir: Union[PySide6.QtCore.QUrl, str] = ..., options: PySide6.QtWidgets.QFileDialog.Option = ..., supportedSchemes: Sequence[str] = ...) -> PySide6.QtCore.QUrl: ...
    @staticmethod
    def getOpenFileName(parent: Optional[PySide6.QtWidgets.QWidget] = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ...) -> Tuple[str, str]: ...
    @staticmethod
    def getOpenFileNames(parent: Optional[PySide6.QtWidgets.QWidget] = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ...) -> Tuple[List[str], str]: ...
    @staticmethod
    def getOpenFileUrl(parent: Optional[PySide6.QtWidgets.QWidget] = ..., caption: str = ..., dir: Union[PySide6.QtCore.QUrl, str] = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ..., supportedSchemes: Sequence[str] = ...) -> Tuple[PySide6.QtCore.QUrl, str]: ...
    @staticmethod
    def getOpenFileUrls(parent: Optional[PySide6.QtWidgets.QWidget] = ..., caption: str = ..., dir: Union[PySide6.QtCore.QUrl, str] = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ..., supportedSchemes: Sequence[str] = ...) -> Tuple[List[PySide6.QtCore.QUrl], str]: ...
    @staticmethod
    def getSaveFileName(parent: Optional[PySide6.QtWidgets.QWidget] = ..., caption: str = ..., dir: str = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ...) -> Tuple[str, str]: ...
    @staticmethod
    def getSaveFileUrl(parent: Optional[PySide6.QtWidgets.QWidget] = ..., caption: str = ..., dir: Union[PySide6.QtCore.QUrl, str] = ..., filter: str = ..., selectedFilter: str = ..., options: PySide6.QtWidgets.QFileDialog.Option = ..., supportedSchemes: Sequence[str] = ...) -> Tuple[PySide6.QtCore.QUrl, str]: ...
    def history(self) -> List[str]: ...
    def iconProvider(self) -> PySide6.QtGui.QAbstractFileIconProvider: ...
    def itemDelegate(self) -> PySide6.QtWidgets.QAbstractItemDelegate: ...
    def labelText(self, label: PySide6.QtWidgets.QFileDialog.DialogLabel) -> str: ...
    def mimeTypeFilters(self) -> List[str]: ...
    def nameFilters(self) -> List[str]: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview]) -> None: ...
    def options(self) -> PySide6.QtWidgets.QFileDialog.Option: ...
    def proxyModel(self) -> PySide6.QtCore.QAbstractProxyModel: ...
    def restoreState(self, state: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> bool: ...
    @staticmethod
    def saveFileContent(fileContent: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], fileNameHint: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def saveState(self) -> PySide6.QtCore.QByteArray: ...
    def selectFile(self, filename: str) -> None: ...
    def selectMimeTypeFilter(self, filter: str) -> None: ...
    def selectNameFilter(self, filter: str) -> None: ...
    def selectUrl(self, url: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def selectedFiles(self) -> List[str]: ...
    def selectedMimeTypeFilter(self) -> str: ...
    def selectedNameFilter(self) -> str: ...
    def selectedUrls(self) -> List[PySide6.QtCore.QUrl]: ...
    def setAcceptMode(self, mode: PySide6.QtWidgets.QFileDialog.AcceptMode) -> None: ...
    def setDefaultSuffix(self, suffix: str) -> None: ...
    @overload
    def setDirectory(self, directory: str) -> None: ...
    @overload
    def setDirectory(self, directory: Union[PySide6.QtCore.QDir, str]) -> None: ...
    def setDirectoryUrl(self, directory: Union[PySide6.QtCore.QUrl, str]) -> None: ...
    def setFileMode(self, mode: PySide6.QtWidgets.QFileDialog.FileMode) -> None: ...
    def setFilter(self, filters: PySide6.QtCore.QDir.Filter) -> None: ...
    def setHistory(self, paths: Sequence[str]) -> None: ...
    def setIconProvider(self, provider: PySide6.QtGui.QAbstractFileIconProvider) -> None: ...
    def setItemDelegate(self, delegate: PySide6.QtWidgets.QAbstractItemDelegate) -> None: ...
    def setLabelText(self, label: PySide6.QtWidgets.QFileDialog.DialogLabel, text: str) -> None: ...
    def setMimeTypeFilters(self, filters: Sequence[str]) -> None: ...
    def setNameFilter(self, filter: str) -> None: ...
    def setNameFilters(self, filters: Sequence[str]) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QFileDialog.Option, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QFileDialog.Option) -> None: ...
    def setProxyModel(self, model: PySide6.QtCore.QAbstractProxyModel) -> None: ...
    def setSidebarUrls(self, urls: Sequence[PySide6.QtCore.QUrl]) -> None: ...
    def setSupportedSchemes(self, schemes: Sequence[str]) -> None: ...
    def setViewMode(self, mode: PySide6.QtWidgets.QFileDialog.ViewMode) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sidebarUrls(self) -> List[PySide6.QtCore.QUrl]: ...
    def supportedSchemes(self) -> List[str]: ...
    def testOption(self, option: PySide6.QtWidgets.QFileDialog.Option) -> bool: ...
    def viewMode(self) -> PySide6.QtWidgets.QFileDialog.ViewMode: ...


class QFileIconProvider(PySide6.QtGui.QAbstractFileIconProvider):

    def __init__(self) -> None: ...

    @overload
    def icon(self, arg__1: PySide6.QtCore.QFileInfo) -> PySide6.QtGui.QIcon: ...
    @overload
    def icon(self, info: PySide6.QtCore.QFileInfo) -> PySide6.QtGui.QIcon: ...
    @overload
    def icon(self, type: PySide6.QtGui.QAbstractFileIconProvider.IconType) -> PySide6.QtGui.QIcon: ...


class QFileSystemModel(PySide6.QtCore.QAbstractItemModel):

    directoryLoaded          : ClassVar[Signal] = ... # directoryLoaded(QString)
    fileRenamed              : ClassVar[Signal] = ... # fileRenamed(QString,QString,QString)
    rootPathChanged          : ClassVar[Signal] = ... # rootPathChanged(QString)

    class Option(enum.Flag):

        DontWatchForChanges      : QFileSystemModel.Option = ... # 0x1
        DontResolveSymlinks      : QFileSystemModel.Option = ... # 0x2
        DontUseCustomDirectoryIcons: QFileSystemModel.Option = ... # 0x4

    class Roles(enum.IntEnum):

        FileIconRole             : QFileSystemModel.Roles = ... # 0x1
        FilePathRole             : QFileSystemModel.Roles = ... # 0x101
        FileNameRole             : QFileSystemModel.Roles = ... # 0x102
        FilePermissions          : QFileSystemModel.Roles = ... # 0x103


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def canFetchMore(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def columnCount(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> int: ...
    def data(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], role: int = ...) -> Any: ...
    def dropMimeData(self, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction, row: int, column: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def fetchMore(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def fileIcon(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtGui.QIcon: ...
    def fileInfo(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QFileInfo: ...
    def fileName(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> str: ...
    def filePath(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> str: ...
    def filter(self) -> PySide6.QtCore.QDir.Filter: ...
    def flags(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.Qt.ItemFlag: ...
    def hasChildren(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> bool: ...
    def headerData(self, section: int, orientation: PySide6.QtCore.Qt.Orientation, role: int = ...) -> Any: ...
    def iconProvider(self) -> PySide6.QtGui.QAbstractFileIconProvider: ...
    @overload
    def index(self, path: str, column: int = ...) -> PySide6.QtCore.QModelIndex: ...
    @overload
    def index(self, row: int, column: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> PySide6.QtCore.QModelIndex: ...
    def isDir(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def isReadOnly(self) -> bool: ...
    @overload
    def lastModified(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QDateTime: ...
    @overload
    def lastModified(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], tz: Union[PySide6.QtCore.QTimeZone, PySide6.QtCore.QTimeZone.Initialization]) -> PySide6.QtCore.QDateTime: ...
    def mimeData(self, indexes: Sequence[PySide6.QtCore.QModelIndex]) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> List[str]: ...
    def mkdir(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], name: str) -> PySide6.QtCore.QModelIndex: ...
    def myComputer(self, role: int = ...) -> Any: ...
    def nameFilterDisables(self) -> bool: ...
    def nameFilters(self) -> List[str]: ...
    def options(self) -> PySide6.QtWidgets.QFileSystemModel.Option: ...
    @overload
    def parent(self) -> PySide6.QtCore.QObject: ...
    @overload
    def parent(self, child: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QModelIndex: ...
    def permissions(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QFileDevice.Permission: ...
    def remove(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def resolveSymlinks(self) -> bool: ...
    def rmdir(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def roleNames(self) -> Dict[int, PySide6.QtCore.QByteArray]: ...
    def rootDirectory(self) -> PySide6.QtCore.QDir: ...
    def rootPath(self) -> str: ...
    def rowCount(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex] = ...) -> int: ...
    def setData(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], value: Any, role: int = ...) -> bool: ...
    def setFilter(self, filters: PySide6.QtCore.QDir.Filter) -> None: ...
    def setIconProvider(self, provider: PySide6.QtGui.QAbstractFileIconProvider) -> None: ...
    def setNameFilterDisables(self, enable: bool) -> None: ...
    def setNameFilters(self, filters: Sequence[str]) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QFileSystemModel.Option, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QFileSystemModel.Option) -> None: ...
    def setReadOnly(self, enable: bool) -> None: ...
    def setResolveSymlinks(self, enable: bool) -> None: ...
    def setRootPath(self, path: str) -> PySide6.QtCore.QModelIndex: ...
    def sibling(self, row: int, column: int, idx: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QModelIndex: ...
    def size(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> int: ...
    def sort(self, column: int, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def testOption(self, option: PySide6.QtWidgets.QFileSystemModel.Option) -> bool: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None: ...
    def type(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> str: ...


class QFocusFrame(PySide6.QtWidgets.QWidget):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOption) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...


class QFontComboBox(PySide6.QtWidgets.QComboBox):

    currentFontChanged       : ClassVar[Signal] = ... # currentFontChanged(QFont)

    class FontFilter(enum.Flag):

        AllFonts                 : QFontComboBox.FontFilter = ... # 0x0
        ScalableFonts            : QFontComboBox.FontFilter = ... # 0x1
        NonScalableFonts         : QFontComboBox.FontFilter = ... # 0x2
        MonospacedFonts          : QFontComboBox.FontFilter = ... # 0x4
        ProportionalFonts        : QFontComboBox.FontFilter = ... # 0x8


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def currentFont(self) -> PySide6.QtGui.QFont: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def fontFilters(self) -> PySide6.QtWidgets.QFontComboBox.FontFilter: ...
    def sampleTextForFont(self, fontFamily: str) -> str: ...
    def sampleTextForSystem(self, writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem) -> str: ...
    def setCurrentFont(self, f: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setDisplayFont(self, fontFamily: str, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setFontFilters(self, filters: PySide6.QtWidgets.QFontComboBox.FontFilter) -> None: ...
    def setSampleTextForFont(self, fontFamily: str, sampleText: str) -> None: ...
    def setSampleTextForSystem(self, writingSystem: PySide6.QtGui.QFontDatabase.WritingSystem, sampleText: str) -> None: ...
    def setWritingSystem(self, arg__1: PySide6.QtGui.QFontDatabase.WritingSystem) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def writingSystem(self) -> PySide6.QtGui.QFontDatabase.WritingSystem: ...


class QFontDialog(PySide6.QtWidgets.QDialog):

    currentFontChanged       : ClassVar[Signal] = ... # currentFontChanged(QFont)
    fontSelected             : ClassVar[Signal] = ... # fontSelected(QFont)

    class FontDialogOption(enum.Flag):

        NoButtons                : QFontDialog.FontDialogOption = ... # 0x1
        DontUseNativeDialog      : QFontDialog.FontDialogOption = ... # 0x2
        ScalableFonts            : QFontDialog.FontDialogOption = ... # 0x4
        NonScalableFonts         : QFontDialog.FontDialogOption = ... # 0x8
        MonospacedFonts          : QFontDialog.FontDialogOption = ... # 0x10
        ProportionalFonts        : QFontDialog.FontDialogOption = ... # 0x20


    @overload
    def __init__(self, initial: Union[PySide6.QtGui.QFont, str, Sequence[str]], parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def currentFont(self) -> PySide6.QtGui.QFont: ...
    def done(self, result: int) -> None: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> bool: ...
    @overload
    @staticmethod
    def getFont(initial: Union[PySide6.QtGui.QFont, str, Sequence[str]], parent: Optional[PySide6.QtWidgets.QWidget] = ..., title: str = ..., options: PySide6.QtWidgets.QFontDialog.FontDialogOption = ...) -> Tuple[bool, PySide6.QtGui.QFont]: ...
    @overload
    @staticmethod
    def getFont(parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> Tuple[bool, PySide6.QtGui.QFont]: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview]) -> None: ...
    def options(self) -> PySide6.QtWidgets.QFontDialog.FontDialogOption: ...
    def selectedFont(self) -> PySide6.QtGui.QFont: ...
    def setCurrentFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QFontDialog.FontDialogOption, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QFontDialog.FontDialogOption) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def testOption(self, option: PySide6.QtWidgets.QFontDialog.FontDialogOption) -> bool: ...


class QFormLayout(PySide6.QtWidgets.QLayout):

    class FieldGrowthPolicy(enum.Enum):

        FieldsStayAtSizeHint     : QFormLayout.FieldGrowthPolicy = ... # 0x0
        ExpandingFieldsGrow      : QFormLayout.FieldGrowthPolicy = ... # 0x1
        AllNonFixedFieldsGrow    : QFormLayout.FieldGrowthPolicy = ... # 0x2

    class ItemRole(enum.Enum):

        LabelRole                : QFormLayout.ItemRole = ... # 0x0
        FieldRole                : QFormLayout.ItemRole = ... # 0x1
        SpanningRole             : QFormLayout.ItemRole = ... # 0x2

    class RowWrapPolicy(enum.Enum):

        DontWrapRows             : QFormLayout.RowWrapPolicy = ... # 0x0
        WrapLongRows             : QFormLayout.RowWrapPolicy = ... # 0x1
        WrapAllRows              : QFormLayout.RowWrapPolicy = ... # 0x2

    class TakeRowResult(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, TakeRowResult: PySide6.QtWidgets.QFormLayout.TakeRowResult) -> None: ...

        @staticmethod
        def __copy__() -> None: ...


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def addItem(self, item: PySide6.QtWidgets.QLayoutItem) -> None: ...
    @overload
    def addRow(self, label: PySide6.QtWidgets.QWidget, field: PySide6.QtWidgets.QLayout) -> None: ...
    @overload
    def addRow(self, label: PySide6.QtWidgets.QWidget, field: PySide6.QtWidgets.QWidget) -> None: ...
    @overload
    def addRow(self, labelText: str, field: PySide6.QtWidgets.QLayout) -> None: ...
    @overload
    def addRow(self, labelText: str, field: PySide6.QtWidgets.QWidget) -> None: ...
    @overload
    def addRow(self, layout: PySide6.QtWidgets.QLayout) -> None: ...
    @overload
    def addRow(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientation: ...
    def fieldGrowthPolicy(self) -> PySide6.QtWidgets.QFormLayout.FieldGrowthPolicy: ...
    def formAlignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def getItemPosition(self, index: int) -> object: ...
    def getLayoutPosition(self, layout: PySide6.QtWidgets.QLayout) -> object: ...
    def getWidgetPosition(self, widget: PySide6.QtWidgets.QWidget) -> object: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    @overload
    def insertRow(self, row: int, label: PySide6.QtWidgets.QWidget, field: PySide6.QtWidgets.QLayout) -> None: ...
    @overload
    def insertRow(self, row: int, label: PySide6.QtWidgets.QWidget, field: PySide6.QtWidgets.QWidget) -> None: ...
    @overload
    def insertRow(self, row: int, labelText: str, field: PySide6.QtWidgets.QLayout) -> None: ...
    @overload
    def insertRow(self, row: int, labelText: str, field: PySide6.QtWidgets.QWidget) -> None: ...
    @overload
    def insertRow(self, row: int, layout: PySide6.QtWidgets.QLayout) -> None: ...
    @overload
    def insertRow(self, row: int, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def invalidate(self) -> None: ...
    @overload
    def isRowVisible(self, layout: PySide6.QtWidgets.QLayout) -> bool: ...
    @overload
    def isRowVisible(self, row: int) -> bool: ...
    @overload
    def isRowVisible(self, widget: PySide6.QtWidgets.QWidget) -> bool: ...
    @overload
    def itemAt(self, index: int) -> PySide6.QtWidgets.QLayoutItem: ...
    @overload
    def itemAt(self, row: int, role: PySide6.QtWidgets.QFormLayout.ItemRole) -> PySide6.QtWidgets.QLayoutItem: ...
    def labelAlignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    @overload
    def labelForField(self, field: PySide6.QtWidgets.QLayout) -> PySide6.QtWidgets.QWidget: ...
    @overload
    def labelForField(self, field: PySide6.QtWidgets.QWidget) -> PySide6.QtWidgets.QWidget: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    @overload
    def removeRow(self, layout: PySide6.QtWidgets.QLayout) -> None: ...
    @overload
    def removeRow(self, row: int) -> None: ...
    @overload
    def removeRow(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def rowCount(self) -> int: ...
    def rowWrapPolicy(self) -> PySide6.QtWidgets.QFormLayout.RowWrapPolicy: ...
    def setFieldGrowthPolicy(self, policy: PySide6.QtWidgets.QFormLayout.FieldGrowthPolicy) -> None: ...
    def setFormAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setGeometry(self, rect: PySide6.QtCore.QRect) -> None: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def setItem(self, row: int, role: PySide6.QtWidgets.QFormLayout.ItemRole, item: PySide6.QtWidgets.QLayoutItem) -> None: ...
    def setLabelAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setLayout(self, row: int, role: PySide6.QtWidgets.QFormLayout.ItemRole, layout: PySide6.QtWidgets.QLayout) -> None: ...
    @overload
    def setRowVisible(self, layout: PySide6.QtWidgets.QLayout, on: bool) -> None: ...
    @overload
    def setRowVisible(self, row: int, on: bool) -> None: ...
    @overload
    def setRowVisible(self, widget: PySide6.QtWidgets.QWidget, on: bool) -> None: ...
    def setRowWrapPolicy(self, policy: PySide6.QtWidgets.QFormLayout.RowWrapPolicy) -> None: ...
    def setSpacing(self, arg__1: int) -> None: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def setWidget(self, row: int, role: PySide6.QtWidgets.QFormLayout.ItemRole, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> PySide6.QtWidgets.QLayoutItem: ...
    @overload
    def takeRow(self, layout: PySide6.QtWidgets.QLayout) -> PySide6.QtWidgets.QFormLayout.TakeRowResult: ...
    @overload
    def takeRow(self, row: int) -> PySide6.QtWidgets.QFormLayout.TakeRowResult: ...
    @overload
    def takeRow(self, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtWidgets.QFormLayout.TakeRowResult: ...
    def verticalSpacing(self) -> int: ...


class QFrame(PySide6.QtWidgets.QWidget):

    class Shadow(enum.IntEnum):

        Plain                    : QFrame.Shadow = ... # 0x10
        Raised                   : QFrame.Shadow = ... # 0x20
        Sunken                   : QFrame.Shadow = ... # 0x30

    class Shape(enum.IntEnum):

        NoFrame                  : QFrame.Shape = ... # 0x0
        Box                      : QFrame.Shape = ... # 0x1
        Panel                    : QFrame.Shape = ... # 0x2
        WinPanel                 : QFrame.Shape = ... # 0x3
        HLine                    : QFrame.Shape = ... # 0x4
        VLine                    : QFrame.Shape = ... # 0x5
        StyledPanel              : QFrame.Shape = ... # 0x6

    class StyleMask(enum.Enum):

        Shape_Mask               : QFrame.StyleMask = ... # 0xf
        Shadow_Mask              : QFrame.StyleMask = ... # 0xf0


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def drawFrame(self, arg__1: PySide6.QtGui.QPainter) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def frameRect(self) -> PySide6.QtCore.QRect: ...
    def frameShadow(self) -> PySide6.QtWidgets.QFrame.Shadow: ...
    def frameShape(self) -> PySide6.QtWidgets.QFrame.Shape: ...
    def frameStyle(self) -> int: ...
    def frameWidth(self) -> int: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionFrame) -> None: ...
    def lineWidth(self) -> int: ...
    def midLineWidth(self) -> int: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def setFrameRect(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    def setFrameShadow(self, arg__1: PySide6.QtWidgets.QFrame.Shadow) -> None: ...
    def setFrameShape(self, arg__1: PySide6.QtWidgets.QFrame.Shape) -> None: ...
    def setFrameStyle(self, arg__1: int) -> None: ...
    def setLineWidth(self, arg__1: int) -> None: ...
    def setMidLineWidth(self, arg__1: int) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...


class QGesture(PySide6.QtCore.QObject):

    class GestureCancelPolicy(enum.Enum):

        CancelNone               : QGesture.GestureCancelPolicy = ... # 0x0
        CancelAllInContext       : QGesture.GestureCancelPolicy = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def gestureCancelPolicy(self) -> PySide6.QtWidgets.QGesture.GestureCancelPolicy: ...
    def gestureType(self) -> PySide6.QtCore.Qt.GestureType: ...
    def hasHotSpot(self) -> bool: ...
    def hotSpot(self) -> PySide6.QtCore.QPointF: ...
    def setGestureCancelPolicy(self, policy: PySide6.QtWidgets.QGesture.GestureCancelPolicy) -> None: ...
    def setHotSpot(self, value: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def state(self) -> PySide6.QtCore.Qt.GestureState: ...
    def unsetHotSpot(self) -> None: ...


class QGestureEvent(PySide6.QtCore.QEvent):

    def __init__(self, gestures: Sequence[PySide6.QtWidgets.QGesture]) -> None: ...

    @overload
    def accept(self) -> None: ...
    @overload
    def accept(self, arg__1: PySide6.QtCore.Qt.GestureType) -> None: ...
    @overload
    def accept(self, arg__1: PySide6.QtWidgets.QGesture) -> None: ...
    def activeGestures(self) -> List[PySide6.QtWidgets.QGesture]: ...
    def canceledGestures(self) -> List[PySide6.QtWidgets.QGesture]: ...
    def gesture(self, type: PySide6.QtCore.Qt.GestureType) -> PySide6.QtWidgets.QGesture: ...
    def gestures(self) -> List[PySide6.QtWidgets.QGesture]: ...
    @overload
    def ignore(self) -> None: ...
    @overload
    def ignore(self, arg__1: PySide6.QtCore.Qt.GestureType) -> None: ...
    @overload
    def ignore(self, arg__1: PySide6.QtWidgets.QGesture) -> None: ...
    @overload
    def isAccepted(self) -> bool: ...
    @overload
    def isAccepted(self, arg__1: PySide6.QtCore.Qt.GestureType) -> bool: ...
    @overload
    def isAccepted(self, arg__1: PySide6.QtWidgets.QGesture) -> bool: ...
    def mapToGraphicsScene(self, gesturePoint: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def setAccepted(self, accepted: bool) -> None: ...
    @overload
    def setAccepted(self, arg__1: PySide6.QtCore.Qt.GestureType, arg__2: bool) -> None: ...
    @overload
    def setAccepted(self, arg__1: PySide6.QtWidgets.QGesture, arg__2: bool) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...


class QGestureRecognizer(Shiboken.Object):

    class ResultFlag(enum.Flag):

        Ignore                   : QGestureRecognizer.ResultFlag = ... # 0x1
        MayBeGesture             : QGestureRecognizer.ResultFlag = ... # 0x2
        TriggerGesture           : QGestureRecognizer.ResultFlag = ... # 0x4
        FinishGesture            : QGestureRecognizer.ResultFlag = ... # 0x8
        CancelGesture            : QGestureRecognizer.ResultFlag = ... # 0x10
        ResultState_Mask         : QGestureRecognizer.ResultFlag = ... # 0xff
        ConsumeEventHint         : QGestureRecognizer.ResultFlag = ... # 0x100
        ResultHint_Mask          : QGestureRecognizer.ResultFlag = ... # 0xff00


    def __init__(self) -> None: ...

    def create(self, target: PySide6.QtCore.QObject) -> PySide6.QtWidgets.QGesture: ...
    def recognize(self, state: PySide6.QtWidgets.QGesture, watched: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> PySide6.QtWidgets.QGestureRecognizer.ResultFlag: ...
    @staticmethod
    def registerRecognizer(recognizer: PySide6.QtWidgets.QGestureRecognizer) -> PySide6.QtCore.Qt.GestureType: ...
    def reset(self, state: PySide6.QtWidgets.QGesture) -> None: ...
    @staticmethod
    def unregisterRecognizer(type: PySide6.QtCore.Qt.GestureType) -> None: ...


class QGraphicsAnchor(PySide6.QtCore.QObject):
    def setSizePolicy(self, policy: PySide6.QtWidgets.QSizePolicy.Policy) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def sizePolicy(self) -> PySide6.QtWidgets.QSizePolicy.Policy: ...
    def spacing(self) -> float: ...
    def unsetSpacing(self) -> None: ...


class QGraphicsAnchorLayout(PySide6.QtWidgets.QGraphicsLayout):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...

    def addAnchor(self, firstItem: PySide6.QtWidgets.QGraphicsLayoutItem, firstEdge: PySide6.QtCore.Qt.AnchorPoint, secondItem: PySide6.QtWidgets.QGraphicsLayoutItem, secondEdge: PySide6.QtCore.Qt.AnchorPoint) -> PySide6.QtWidgets.QGraphicsAnchor: ...
    def addAnchors(self, firstItem: PySide6.QtWidgets.QGraphicsLayoutItem, secondItem: PySide6.QtWidgets.QGraphicsLayoutItem, orientations: PySide6.QtCore.Qt.Orientation = ...) -> None: ...
    def addCornerAnchors(self, firstItem: PySide6.QtWidgets.QGraphicsLayoutItem, firstCorner: PySide6.QtCore.Qt.Corner, secondItem: PySide6.QtWidgets.QGraphicsLayoutItem, secondCorner: PySide6.QtCore.Qt.Corner) -> None: ...
    def anchor(self, firstItem: PySide6.QtWidgets.QGraphicsLayoutItem, firstEdge: PySide6.QtCore.Qt.AnchorPoint, secondItem: PySide6.QtWidgets.QGraphicsLayoutItem, secondEdge: PySide6.QtCore.Qt.AnchorPoint) -> PySide6.QtWidgets.QGraphicsAnchor: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int) -> None: ...
    def setGeometry(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...) -> PySide6.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...


class QGraphicsBlurEffect(PySide6.QtWidgets.QGraphicsEffect):

    blurHintsChanged         : ClassVar[Signal] = ... # blurHintsChanged(BlurHints)
    blurRadiusChanged        : ClassVar[Signal] = ... # blurRadiusChanged(double)

    class BlurHint(enum.Flag):

        PerformanceHint          : QGraphicsBlurEffect.BlurHint = ... # 0x0
        QualityHint              : QGraphicsBlurEffect.BlurHint = ... # 0x1
        AnimationHint            : QGraphicsBlurEffect.BlurHint = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def blurHints(self) -> PySide6.QtWidgets.QGraphicsBlurEffect.BlurHint: ...
    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def draw(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def setBlurHints(self, hints: PySide6.QtWidgets.QGraphicsBlurEffect.BlurHint) -> None: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...


class QGraphicsColorizeEffect(PySide6.QtWidgets.QGraphicsEffect):

    colorChanged             : ClassVar[Signal] = ... # colorChanged(QColor)
    strengthChanged          : ClassVar[Signal] = ... # strengthChanged(double)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def color(self) -> PySide6.QtGui.QColor: ...
    def draw(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def setColor(self, c: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setStrength(self, strength: float) -> None: ...
    def strength(self) -> float: ...


class QGraphicsDropShadowEffect(PySide6.QtWidgets.QGraphicsEffect):

    blurRadiusChanged        : ClassVar[Signal] = ... # blurRadiusChanged(double)
    colorChanged             : ClassVar[Signal] = ... # colorChanged(QColor)
    offsetChanged            : ClassVar[Signal] = ... # offsetChanged(QPointF)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def blurRadius(self) -> float: ...
    def boundingRectFor(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def color(self) -> PySide6.QtGui.QColor: ...
    def draw(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def offset(self) -> PySide6.QtCore.QPointF: ...
    def setBlurRadius(self, blurRadius: float) -> None: ...
    def setColor(self, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    @overload
    def setOffset(self, d: float) -> None: ...
    @overload
    def setOffset(self, dx: float, dy: float) -> None: ...
    @overload
    def setOffset(self, ofs: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setXOffset(self, dx: float) -> None: ...
    def setYOffset(self, dy: float) -> None: ...
    def xOffset(self) -> float: ...
    def yOffset(self) -> float: ...


class QGraphicsEffect(PySide6.QtCore.QObject):

    enabledChanged           : ClassVar[Signal] = ... # enabledChanged(bool)

    class ChangeFlag(enum.Flag):

        SourceAttached           : QGraphicsEffect.ChangeFlag = ... # 0x1
        SourceDetached           : QGraphicsEffect.ChangeFlag = ... # 0x2
        SourceBoundingRectChanged: QGraphicsEffect.ChangeFlag = ... # 0x4
        SourceInvalidated        : QGraphicsEffect.ChangeFlag = ... # 0x8

    class PixmapPadMode(enum.Enum):

        NoPad                    : QGraphicsEffect.PixmapPadMode = ... # 0x0
        PadToTransparentBorder   : QGraphicsEffect.PixmapPadMode = ... # 0x1
        PadToEffectiveBoundingRect: QGraphicsEffect.PixmapPadMode = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def boundingRectFor(self, sourceRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    def draw(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def drawSource(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enable: bool) -> None: ...
    def sourceBoundingRect(self, system: PySide6.QtCore.Qt.CoordinateSystem = ...) -> PySide6.QtCore.QRectF: ...
    def sourceChanged(self, flags: PySide6.QtWidgets.QGraphicsEffect.ChangeFlag) -> None: ...
    def sourceIsPixmap(self) -> bool: ...
    def sourcePixmap(self, system: PySide6.QtCore.Qt.CoordinateSystem = ..., offset: Optional[PySide6.QtCore.QPoint] = ..., mode: PySide6.QtWidgets.QGraphicsEffect.PixmapPadMode = ...) -> PySide6.QtGui.QPixmap: ...
    def update(self) -> None: ...
    def updateBoundingRect(self) -> None: ...


class QGraphicsEllipseItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def extension(self, variant: Any) -> Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    @overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def setSpanAngle(self, angle: int) -> None: ...
    def setStartAngle(self, angle: int) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def spanAngle(self) -> int: ...
    def startAngle(self) -> int: ...
    def type(self) -> int: ...


class QGraphicsGridLayout(PySide6.QtWidgets.QGraphicsLayout):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...

    @overload
    def addItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, row: int, column: int, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @overload
    def addItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, row: int, column: int, rowSpan: int, columnSpan: int, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    def alignment(self, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def columnAlignment(self, column: int) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def columnCount(self) -> int: ...
    def columnMaximumWidth(self, column: int) -> float: ...
    def columnMinimumWidth(self, column: int) -> float: ...
    def columnPreferredWidth(self, column: int) -> float: ...
    def columnSpacing(self, column: int) -> float: ...
    def columnStretchFactor(self, column: int) -> int: ...
    def count(self) -> int: ...
    def horizontalSpacing(self) -> float: ...
    def invalidate(self) -> None: ...
    @overload
    def itemAt(self, index: int) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    @overload
    def itemAt(self, row: int, column: int) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int) -> None: ...
    def removeItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def rowAlignment(self, row: int) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def rowCount(self) -> int: ...
    def rowMaximumHeight(self, row: int) -> float: ...
    def rowMinimumHeight(self, row: int) -> float: ...
    def rowPreferredHeight(self, row: int) -> float: ...
    def rowSpacing(self, row: int) -> float: ...
    def rowStretchFactor(self, row: int) -> int: ...
    def setAlignment(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setColumnAlignment(self, column: int, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setColumnFixedWidth(self, column: int, width: float) -> None: ...
    def setColumnMaximumWidth(self, column: int, width: float) -> None: ...
    def setColumnMinimumWidth(self, column: int, width: float) -> None: ...
    def setColumnPreferredWidth(self, column: int, width: float) -> None: ...
    def setColumnSpacing(self, column: int, spacing: float) -> None: ...
    def setColumnStretchFactor(self, column: int, stretch: int) -> None: ...
    def setGeometry(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def setHorizontalSpacing(self, spacing: float) -> None: ...
    def setRowAlignment(self, row: int, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setRowFixedHeight(self, row: int, height: float) -> None: ...
    def setRowMaximumHeight(self, row: int, height: float) -> None: ...
    def setRowMinimumHeight(self, row: int, height: float) -> None: ...
    def setRowPreferredHeight(self, row: int, height: float) -> None: ...
    def setRowSpacing(self, row: int, spacing: float) -> None: ...
    def setRowStretchFactor(self, row: int, stretch: int) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setVerticalSpacing(self, spacing: float) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...) -> PySide6.QtCore.QSizeF: ...
    def verticalSpacing(self) -> float: ...


class QGraphicsItem(Shiboken.Object):

    class CacheMode(enum.Enum):

        NoCache                  : QGraphicsItem.CacheMode = ... # 0x0
        ItemCoordinateCache      : QGraphicsItem.CacheMode = ... # 0x1
        DeviceCoordinateCache    : QGraphicsItem.CacheMode = ... # 0x2

    class Extension(enum.Enum):

        UserExtension            : QGraphicsItem.Extension = ... # 0x80000000

    class GraphicsItemChange(enum.Enum):

        ItemPositionChange       : QGraphicsItem.GraphicsItemChange = ... # 0x0
        ItemVisibleChange        : QGraphicsItem.GraphicsItemChange = ... # 0x2
        ItemEnabledChange        : QGraphicsItem.GraphicsItemChange = ... # 0x3
        ItemSelectedChange       : QGraphicsItem.GraphicsItemChange = ... # 0x4
        ItemParentChange         : QGraphicsItem.GraphicsItemChange = ... # 0x5
        ItemChildAddedChange     : QGraphicsItem.GraphicsItemChange = ... # 0x6
        ItemChildRemovedChange   : QGraphicsItem.GraphicsItemChange = ... # 0x7
        ItemTransformChange      : QGraphicsItem.GraphicsItemChange = ... # 0x8
        ItemPositionHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x9
        ItemTransformHasChanged  : QGraphicsItem.GraphicsItemChange = ... # 0xa
        ItemSceneChange          : QGraphicsItem.GraphicsItemChange = ... # 0xb
        ItemVisibleHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xc
        ItemEnabledHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0xd
        ItemSelectedHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0xe
        ItemParentHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0xf
        ItemSceneHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x10
        ItemCursorChange         : QGraphicsItem.GraphicsItemChange = ... # 0x11
        ItemCursorHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x12
        ItemToolTipChange        : QGraphicsItem.GraphicsItemChange = ... # 0x13
        ItemToolTipHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x14
        ItemFlagsChange          : QGraphicsItem.GraphicsItemChange = ... # 0x15
        ItemFlagsHaveChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x16
        ItemZValueChange         : QGraphicsItem.GraphicsItemChange = ... # 0x17
        ItemZValueHasChanged     : QGraphicsItem.GraphicsItemChange = ... # 0x18
        ItemOpacityChange        : QGraphicsItem.GraphicsItemChange = ... # 0x19
        ItemOpacityHasChanged    : QGraphicsItem.GraphicsItemChange = ... # 0x1a
        ItemScenePositionHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x1b
        ItemRotationChange       : QGraphicsItem.GraphicsItemChange = ... # 0x1c
        ItemRotationHasChanged   : QGraphicsItem.GraphicsItemChange = ... # 0x1d
        ItemScaleChange          : QGraphicsItem.GraphicsItemChange = ... # 0x1e
        ItemScaleHasChanged      : QGraphicsItem.GraphicsItemChange = ... # 0x1f
        ItemTransformOriginPointChange: QGraphicsItem.GraphicsItemChange = ... # 0x20
        ItemTransformOriginPointHasChanged: QGraphicsItem.GraphicsItemChange = ... # 0x21

    class GraphicsItemFlag(enum.Flag):

        ItemIsMovable            : QGraphicsItem.GraphicsItemFlag = ... # 0x1
        ItemIsSelectable         : QGraphicsItem.GraphicsItemFlag = ... # 0x2
        ItemIsFocusable          : QGraphicsItem.GraphicsItemFlag = ... # 0x4
        ItemClipsToShape         : QGraphicsItem.GraphicsItemFlag = ... # 0x8
        ItemClipsChildrenToShape : QGraphicsItem.GraphicsItemFlag = ... # 0x10
        ItemIgnoresTransformations: QGraphicsItem.GraphicsItemFlag = ... # 0x20
        ItemIgnoresParentOpacity : QGraphicsItem.GraphicsItemFlag = ... # 0x40
        ItemDoesntPropagateOpacityToChildren: QGraphicsItem.GraphicsItemFlag = ... # 0x80
        ItemStacksBehindParent   : QGraphicsItem.GraphicsItemFlag = ... # 0x100
        ItemUsesExtendedStyleOption: QGraphicsItem.GraphicsItemFlag = ... # 0x200
        ItemHasNoContents        : QGraphicsItem.GraphicsItemFlag = ... # 0x400
        ItemSendsGeometryChanges : QGraphicsItem.GraphicsItemFlag = ... # 0x800
        ItemAcceptsInputMethod   : QGraphicsItem.GraphicsItemFlag = ... # 0x1000
        ItemNegativeZStacksBehindParent: QGraphicsItem.GraphicsItemFlag = ... # 0x2000
        ItemIsPanel              : QGraphicsItem.GraphicsItemFlag = ... # 0x4000
        ItemIsFocusScope         : QGraphicsItem.GraphicsItemFlag = ... # 0x8000
        ItemSendsScenePositionChanges: QGraphicsItem.GraphicsItemFlag = ... # 0x10000
        ItemStopsClickFocusPropagation: QGraphicsItem.GraphicsItemFlag = ... # 0x20000
        ItemStopsFocusHandling   : QGraphicsItem.GraphicsItemFlag = ... # 0x40000
        ItemContainsChildrenInShape: QGraphicsItem.GraphicsItemFlag = ... # 0x80000

    class PanelModality(enum.Enum):

        NonModal                 : QGraphicsItem.PanelModality = ... # 0x0
        PanelModal               : QGraphicsItem.PanelModality = ... # 0x1
        SceneModal               : QGraphicsItem.PanelModality = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def acceptDrops(self) -> bool: ...
    def acceptHoverEvents(self) -> bool: ...
    def acceptTouchEvents(self) -> bool: ...
    def acceptedMouseButtons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def addToIndex(self) -> None: ...
    def advance(self, phase: int) -> None: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def boundingRegion(self, itemToDeviceTransform: PySide6.QtGui.QTransform) -> PySide6.QtGui.QRegion: ...
    def boundingRegionGranularity(self) -> float: ...
    def cacheMode(self) -> PySide6.QtWidgets.QGraphicsItem.CacheMode: ...
    def childItems(self) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    def childrenBoundingRect(self) -> PySide6.QtCore.QRectF: ...
    def clearFocus(self) -> None: ...
    def clipPath(self) -> PySide6.QtGui.QPainterPath: ...
    def collidesWithItem(self, other: PySide6.QtWidgets.QGraphicsItem, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidesWithPath(self, path: PySide6.QtGui.QPainterPath, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> bool: ...
    def collidingItems(self, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    def commonAncestorItem(self, other: PySide6.QtWidgets.QGraphicsItem) -> PySide6.QtWidgets.QGraphicsItem: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def contextMenuEvent(self, event: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...
    def cursor(self) -> PySide6.QtGui.QCursor: ...
    def data(self, key: int) -> Any: ...
    def deviceTransform(self, viewportTransform: PySide6.QtGui.QTransform) -> PySide6.QtGui.QTransform: ...
    def dragEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dropEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def effectiveOpacity(self) -> float: ...
    @overload
    def ensureVisible(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ..., xmargin: int = ..., ymargin: int = ...) -> None: ...
    @overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def extension(self, variant: Any) -> Any: ...
    def filtersChildEvents(self) -> bool: ...
    def flags(self) -> PySide6.QtWidgets.QGraphicsItem.GraphicsItemFlag: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusItem(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusProxy(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def focusScopeItem(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def grabKeyboard(self) -> None: ...
    def grabMouse(self) -> None: ...
    def graphicsEffect(self) -> PySide6.QtWidgets.QGraphicsEffect: ...
    def group(self) -> PySide6.QtWidgets.QGraphicsItemGroup: ...
    def handlesChildEvents(self) -> bool: ...
    def hasCursor(self) -> bool: ...
    def hasFocus(self) -> bool: ...
    def hide(self) -> None: ...
    def hoverEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodHints(self) -> PySide6.QtCore.Qt.InputMethodHint: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    def installSceneEventFilter(self, filterItem: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def isActive(self) -> bool: ...
    def isAncestorOf(self, child: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def isBlockedByModalPanel(self) -> Tuple[bool, PySide6.QtWidgets.QGraphicsItem]: ...
    def isClipped(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    @overload
    def isObscured(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ...) -> bool: ...
    @overload
    def isObscured(self, x: float, y: float, w: float, h: float) -> bool: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def isPanel(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def isUnderMouse(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def isVisibleTo(self, parent: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def isWidget(self) -> bool: ...
    def isWindow(self) -> bool: ...
    def itemChange(self, change: PySide6.QtWidgets.QGraphicsItem.GraphicsItemChange, value: Any) -> Any: ...
    def itemTransform(self, other: PySide6.QtWidgets.QGraphicsItem) -> Tuple[PySide6.QtGui.QTransform, bool]: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    @overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapFromParent(self, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def mapFromParent(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromParent(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapFromParent(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapFromParent(self, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromParent(self, x: float, y: float, w: float, h: float) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapFromScene(self, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def mapFromScene(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromScene(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapFromScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapFromScene(self, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromScene(self, x: float, y: float, w: float, h: float) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapRectFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectFromItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectFromParent(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectFromParent(self, x: float, y: float, w: float, h: float) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectFromScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectFromScene(self, x: float, y: float, w: float, h: float) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectToItem(self, item: PySide6.QtWidgets.QGraphicsItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectToItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectToParent(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectToParent(self, x: float, y: float, w: float, h: float) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectToScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapRectToScene(self, x: float, y: float, w: float, h: float) -> PySide6.QtCore.QRectF: ...
    @overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToItem(self, item: PySide6.QtWidgets.QGraphicsItem, x: float, y: float, w: float, h: float) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToParent(self, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def mapToParent(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToParent(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToParent(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToParent(self, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToParent(self, x: float, y: float, w: float, h: float) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def mapToScene(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToScene(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, x: float, y: float) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToScene(self, x: float, y: float, w: float, h: float) -> PySide6.QtGui.QPolygonF: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def moveBy(self, dx: float, dy: float) -> None: ...
    def opacity(self) -> float: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def panel(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def panelModality(self) -> PySide6.QtWidgets.QGraphicsItem.PanelModality: ...
    def parentItem(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def parentObject(self) -> PySide6.QtWidgets.QGraphicsObject: ...
    def parentWidget(self) -> PySide6.QtWidgets.QGraphicsWidget: ...
    def pos(self) -> PySide6.QtCore.QPointF: ...
    def prepareGeometryChange(self) -> None: ...
    def removeFromIndex(self) -> None: ...
    def removeSceneEventFilter(self, filterItem: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def resetTransform(self) -> None: ...
    def rotation(self) -> float: ...
    def scale(self) -> float: ...
    def scene(self) -> PySide6.QtWidgets.QGraphicsScene: ...
    def sceneBoundingRect(self) -> PySide6.QtCore.QRectF: ...
    def sceneEvent(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def sceneEventFilter(self, watched: PySide6.QtWidgets.QGraphicsItem, event: PySide6.QtCore.QEvent) -> bool: ...
    def scenePos(self) -> PySide6.QtCore.QPointF: ...
    def sceneTransform(self) -> PySide6.QtGui.QTransform: ...
    def scroll(self, dx: float, dy: float, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ...) -> None: ...
    def setAcceptDrops(self, on: bool) -> None: ...
    def setAcceptHoverEvents(self, enabled: bool) -> None: ...
    def setAcceptTouchEvents(self, enabled: bool) -> None: ...
    def setAcceptedMouseButtons(self, buttons: PySide6.QtCore.Qt.MouseButton) -> None: ...
    def setActive(self, active: bool) -> None: ...
    def setBoundingRegionGranularity(self, granularity: float) -> None: ...
    def setCacheMode(self, mode: PySide6.QtWidgets.QGraphicsItem.CacheMode, cacheSize: PySide6.QtCore.QSize = ...) -> None: ...
    def setCursor(self, cursor: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> None: ...
    def setData(self, key: int, value: Any) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def setFiltersChildEvents(self, enabled: bool) -> None: ...
    def setFlag(self, flag: PySide6.QtWidgets.QGraphicsItem.GraphicsItemFlag, enabled: bool = ...) -> None: ...
    def setFlags(self, flags: PySide6.QtWidgets.QGraphicsItem.GraphicsItemFlag) -> None: ...
    def setFocus(self, focusReason: PySide6.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusProxy(self, item: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def setGraphicsEffect(self, effect: PySide6.QtWidgets.QGraphicsEffect) -> None: ...
    def setGroup(self, group: PySide6.QtWidgets.QGraphicsItemGroup) -> None: ...
    def setHandlesChildEvents(self, enabled: bool) -> None: ...
    def setInputMethodHints(self, hints: PySide6.QtCore.Qt.InputMethodHint) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setPanelModality(self, panelModality: PySide6.QtWidgets.QGraphicsItem.PanelModality) -> None: ...
    def setParentItem(self, parent: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    @overload
    def setPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def setPos(self, x: float, y: float) -> None: ...
    def setRotation(self, angle: float) -> None: ...
    def setScale(self, scale: float) -> None: ...
    def setSelected(self, selected: bool) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setTransform(self, matrix: PySide6.QtGui.QTransform, combine: bool = ...) -> None: ...
    @overload
    def setTransformOriginPoint(self, ax: float, ay: float) -> None: ...
    @overload
    def setTransformOriginPoint(self, origin: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setTransformations(self, transformations: Sequence[PySide6.QtWidgets.QGraphicsTransform]) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setX(self, x: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setZValue(self, z: float) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def show(self) -> None: ...
    def stackBefore(self, sibling: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def toGraphicsObject(self) -> PySide6.QtWidgets.QGraphicsObject: ...
    def toolTip(self) -> str: ...
    def topLevelItem(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def topLevelWidget(self) -> PySide6.QtWidgets.QGraphicsWidget: ...
    def transform(self) -> PySide6.QtGui.QTransform: ...
    def transformOriginPoint(self) -> PySide6.QtCore.QPointF: ...
    def transformations(self) -> List[PySide6.QtWidgets.QGraphicsTransform]: ...
    def type(self) -> int: ...
    def ungrabKeyboard(self) -> None: ...
    def ungrabMouse(self) -> None: ...
    def unsetCursor(self) -> None: ...
    @overload
    def update(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ...) -> None: ...
    @overload
    def update(self, x: float, y: float, width: float, height: float) -> None: ...
    def updateMicroFocus(self) -> None: ...
    def wheelEvent(self, event: PySide6.QtWidgets.QGraphicsSceneWheelEvent) -> None: ...
    def window(self) -> PySide6.QtWidgets.QGraphicsWidget: ...
    def x(self) -> float: ...
    def y(self) -> float: ...
    def zValue(self) -> float: ...


class QGraphicsItemAnimation(PySide6.QtCore.QObject):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def afterAnimationStep(self, step: float) -> None: ...
    def beforeAnimationStep(self, step: float) -> None: ...
    def clear(self) -> None: ...
    def horizontalScaleAt(self, step: float) -> float: ...
    def horizontalShearAt(self, step: float) -> float: ...
    def item(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def posAt(self, step: float) -> PySide6.QtCore.QPointF: ...
    def posList(self) -> List[Tuple[float, PySide6.QtCore.QPointF]]: ...
    def rotationAt(self, step: float) -> float: ...
    def rotationList(self) -> List[Tuple[float, float]]: ...
    def scaleList(self) -> List[Tuple[float, PySide6.QtCore.QPointF]]: ...
    def setItem(self, item: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def setPosAt(self, step: float, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setRotationAt(self, step: float, angle: float) -> None: ...
    def setScaleAt(self, step: float, sx: float, sy: float) -> None: ...
    def setShearAt(self, step: float, sh: float, sv: float) -> None: ...
    def setStep(self, x: float) -> None: ...
    def setTimeLine(self, timeLine: PySide6.QtCore.QTimeLine) -> None: ...
    def setTranslationAt(self, step: float, dx: float, dy: float) -> None: ...
    def shearList(self) -> List[Tuple[float, PySide6.QtCore.QPointF]]: ...
    def timeLine(self) -> PySide6.QtCore.QTimeLine: ...
    def transformAt(self, step: float) -> PySide6.QtGui.QTransform: ...
    def translationList(self) -> List[Tuple[float, PySide6.QtCore.QPointF]]: ...
    def verticalScaleAt(self, step: float) -> float: ...
    def verticalShearAt(self, step: float) -> float: ...
    def xTranslationAt(self, step: float) -> float: ...
    def yTranslationAt(self, step: float) -> float: ...


class QGraphicsItemGroup(PySide6.QtWidgets.QGraphicsItem):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def addToGroup(self, item: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def removeFromGroup(self, item: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def type(self) -> int: ...


class QGraphicsLayout(PySide6.QtWidgets.QGraphicsLayoutItem):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...

    def activate(self) -> None: ...
    def addChildLayoutItem(self, layoutItem: PySide6.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def count(self) -> int: ...
    def getContentsMargins(self) -> object: ...
    @staticmethod
    def instantInvalidatePropagation() -> bool: ...
    def invalidate(self) -> None: ...
    def isActivated(self) -> bool: ...
    def itemAt(self, i: int) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def removeAt(self, index: int) -> None: ...
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @staticmethod
    def setInstantInvalidatePropagation(enable: bool) -> None: ...
    def updateGeometry(self) -> None: ...
    def widgetEvent(self, e: PySide6.QtCore.QEvent) -> None: ...


class QGraphicsLayoutItem(Shiboken.Object):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsLayoutItem] = ..., isLayout: bool = ...) -> None: ...

    def contentsRect(self) -> PySide6.QtCore.QRectF: ...
    def effectiveSizeHint(self, which: PySide6.QtCore.Qt.SizeHint, constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...) -> PySide6.QtCore.QSizeF: ...
    def geometry(self) -> PySide6.QtCore.QRectF: ...
    def getContentsMargins(self) -> object: ...
    def graphicsItem(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def isEmpty(self) -> bool: ...
    def isLayout(self) -> bool: ...
    def maximumHeight(self) -> float: ...
    def maximumSize(self) -> PySide6.QtCore.QSizeF: ...
    def maximumWidth(self) -> float: ...
    def minimumHeight(self) -> float: ...
    def minimumSize(self) -> PySide6.QtCore.QSizeF: ...
    def minimumWidth(self) -> float: ...
    def ownedByLayout(self) -> bool: ...
    def parentLayoutItem(self) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def preferredHeight(self) -> float: ...
    def preferredSize(self) -> PySide6.QtCore.QSizeF: ...
    def preferredWidth(self) -> float: ...
    def setGeometry(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def setGraphicsItem(self, item: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def setMaximumHeight(self, height: float) -> None: ...
    @overload
    def setMaximumSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    @overload
    def setMaximumSize(self, w: float, h: float) -> None: ...
    def setMaximumWidth(self, width: float) -> None: ...
    def setMinimumHeight(self, height: float) -> None: ...
    @overload
    def setMinimumSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    @overload
    def setMinimumSize(self, w: float, h: float) -> None: ...
    def setMinimumWidth(self, width: float) -> None: ...
    def setOwnedByLayout(self, ownedByLayout: bool) -> None: ...
    def setParentLayoutItem(self, parent: PySide6.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def setPreferredHeight(self, height: float) -> None: ...
    @overload
    def setPreferredSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    @overload
    def setPreferredSize(self, w: float, h: float) -> None: ...
    def setPreferredWidth(self, width: float) -> None: ...
    @overload
    def setSizePolicy(self, hPolicy: PySide6.QtWidgets.QSizePolicy.Policy, vPolicy: PySide6.QtWidgets.QSizePolicy.Policy, controlType: PySide6.QtWidgets.QSizePolicy.ControlType = ...) -> None: ...
    @overload
    def setSizePolicy(self, policy: PySide6.QtWidgets.QSizePolicy) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...) -> PySide6.QtCore.QSizeF: ...
    def sizePolicy(self) -> PySide6.QtWidgets.QSizePolicy: ...
    def updateGeometry(self) -> None: ...


class QGraphicsLineItem(PySide6.QtWidgets.QGraphicsItem):

    @overload
    def __init__(self, line: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine], parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def extension(self, variant: Any) -> Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def line(self) -> PySide6.QtCore.QLineF: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def pen(self) -> PySide6.QtGui.QPen: ...
    @overload
    def setLine(self, line: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine]) -> None: ...
    @overload
    def setLine(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    def setPen(self, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor]) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsLinearLayout(PySide6.QtWidgets.QGraphicsLayout):

    @overload
    def __init__(self, orientation: PySide6.QtCore.Qt.Orientation, parent: Optional[PySide6.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsLayoutItem] = ...) -> None: ...

    def addItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def addStretch(self, stretch: int = ...) -> None: ...
    def alignment(self, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def count(self) -> int: ...
    def dump(self, indent: int = ...) -> None: ...
    def insertItem(self, index: int, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def insertStretch(self, index: int, stretch: int = ...) -> None: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> PySide6.QtWidgets.QGraphicsLayoutItem: ...
    def itemSpacing(self, index: int) -> float: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def removeAt(self, index: int) -> None: ...
    def removeItem(self, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> None: ...
    def setAlignment(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setGeometry(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def setItemSpacing(self, index: int, spacing: float) -> None: ...
    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def setStretchFactor(self, item: PySide6.QtWidgets.QGraphicsLayoutItem, stretch: int) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...) -> PySide6.QtCore.QSizeF: ...
    def spacing(self) -> float: ...
    def stretchFactor(self, item: PySide6.QtWidgets.QGraphicsLayoutItem) -> int: ...


class QGraphicsObject(PySide6.QtWidgets.QGraphicsItem, PySide6.QtCore.QObject):

    childrenChanged          : ClassVar[Signal] = ... # childrenChanged()
    enabledChanged           : ClassVar[Signal] = ... # enabledChanged()
    heightChanged            : ClassVar[Signal] = ... # heightChanged()
    opacityChanged           : ClassVar[Signal] = ... # opacityChanged()
    parentChanged            : ClassVar[Signal] = ... # parentChanged()
    rotationChanged          : ClassVar[Signal] = ... # rotationChanged()
    scaleChanged             : ClassVar[Signal] = ... # scaleChanged()
    visibleChanged           : ClassVar[Signal] = ... # visibleChanged()
    widthChanged             : ClassVar[Signal] = ... # widthChanged()
    xChanged                 : ClassVar[Signal] = ... # xChanged()
    yChanged                 : ClassVar[Signal] = ... # yChanged()
    zChanged                 : ClassVar[Signal] = ... # zChanged()

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def event(self, ev: PySide6.QtCore.QEvent) -> bool: ...
    def grabGesture(self, type: PySide6.QtCore.Qt.GestureType, flags: PySide6.QtCore.Qt.GestureFlag = ...) -> None: ...
    def ungrabGesture(self, type: PySide6.QtCore.Qt.GestureType) -> None: ...
    def updateMicroFocus(self) -> None: ...


class QGraphicsOpacityEffect(PySide6.QtWidgets.QGraphicsEffect):

    opacityChanged           : ClassVar[Signal] = ... # opacityChanged(double)
    opacityMaskChanged       : ClassVar[Signal] = ... # opacityMaskChanged(QBrush)

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def draw(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def opacity(self) -> float: ...
    def opacityMask(self) -> PySide6.QtGui.QBrush: ...
    def setOpacity(self, opacity: float) -> None: ...
    def setOpacityMask(self, mask: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...


class QGraphicsPathItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, path: PySide6.QtGui.QPainterPath, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def extension(self, variant: Any) -> Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def path(self) -> PySide6.QtGui.QPainterPath: ...
    def setPath(self, path: PySide6.QtGui.QPainterPath) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsPixmapItem(PySide6.QtWidgets.QGraphicsItem):

    class ShapeMode(enum.Enum):

        MaskShape                : QGraphicsPixmapItem.ShapeMode = ... # 0x0
        BoundingRectShape        : QGraphicsPixmapItem.ShapeMode = ... # 0x1
        HeuristicMaskShape       : QGraphicsPixmapItem.ShapeMode = ... # 0x2


    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def extension(self, variant: Any) -> Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def offset(self) -> PySide6.QtCore.QPointF: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def pixmap(self) -> PySide6.QtGui.QPixmap: ...
    @overload
    def setOffset(self, offset: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def setOffset(self, x: float, y: float) -> None: ...
    def setPixmap(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def setShapeMode(self, mode: PySide6.QtWidgets.QGraphicsPixmapItem.ShapeMode) -> None: ...
    def setTransformationMode(self, mode: PySide6.QtCore.Qt.TransformationMode) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def shapeMode(self) -> PySide6.QtWidgets.QGraphicsPixmapItem.ShapeMode: ...
    def transformationMode(self) -> PySide6.QtCore.Qt.TransformationMode: ...
    def type(self) -> int: ...


class QGraphicsPolygonItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF], parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def extension(self, variant: Any) -> Any: ...
    def fillRule(self) -> PySide6.QtCore.Qt.FillRule: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def polygon(self) -> PySide6.QtGui.QPolygonF: ...
    def setFillRule(self, rule: PySide6.QtCore.Qt.FillRule) -> None: ...
    def setPolygon(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsProxyWidget(PySide6.QtWidgets.QGraphicsWidget):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ..., wFlags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def contextMenuEvent(self, event: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...
    def createProxyForChildWidget(self, child: PySide6.QtWidgets.QWidget) -> PySide6.QtWidgets.QGraphicsProxyWidget: ...
    def dragEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dropEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def grabMouseEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def hideEvent(self, event: PySide6.QtGui.QHideEvent) -> None: ...
    def hoverEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    def itemChange(self, change: PySide6.QtWidgets.QGraphicsItem.GraphicsItemChange, value: Any) -> Any: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def newProxyWidget(self, arg__1: PySide6.QtWidgets.QWidget) -> PySide6.QtWidgets.QGraphicsProxyWidget: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def resizeEvent(self, event: PySide6.QtWidgets.QGraphicsSceneResizeEvent) -> None: ...
    @overload
    def setGeometry(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setGeometry(self, x: float, y: float, w: float, h: float) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...) -> PySide6.QtCore.QSizeF: ...
    def subWidgetRect(self, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtCore.QRectF: ...
    def type(self) -> int: ...
    def ungrabMouseEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def wheelEvent(self, event: PySide6.QtWidgets.QGraphicsSceneWheelEvent) -> None: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...


class QGraphicsRectItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, x: float, y: float, w: float, h: float, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def extension(self, variant: Any) -> Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    @overload
    def setRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def type(self) -> int: ...


class QGraphicsRotation(PySide6.QtWidgets.QGraphicsTransform):

    angleChanged             : ClassVar[Signal] = ... # angleChanged()
    axisChanged              : ClassVar[Signal] = ... # axisChanged()
    originChanged            : ClassVar[Signal] = ... # originChanged()

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def angle(self) -> float: ...
    def applyTo(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...
    def axis(self) -> PySide6.QtGui.QVector3D: ...
    def origin(self) -> PySide6.QtGui.QVector3D: ...
    def setAngle(self, arg__1: float) -> None: ...
    @overload
    def setAxis(self, axis: PySide6.QtCore.Qt.Axis) -> None: ...
    @overload
    def setAxis(self, axis: PySide6.QtGui.QVector3D) -> None: ...
    def setOrigin(self, point: PySide6.QtGui.QVector3D) -> None: ...


class QGraphicsScale(PySide6.QtWidgets.QGraphicsTransform):

    originChanged            : ClassVar[Signal] = ... # originChanged()
    scaleChanged             : ClassVar[Signal] = ... # scaleChanged()
    xScaleChanged            : ClassVar[Signal] = ... # xScaleChanged()
    yScaleChanged            : ClassVar[Signal] = ... # yScaleChanged()
    zScaleChanged            : ClassVar[Signal] = ... # zScaleChanged()

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def applyTo(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...
    def origin(self) -> PySide6.QtGui.QVector3D: ...
    def setOrigin(self, point: PySide6.QtGui.QVector3D) -> None: ...
    def setXScale(self, arg__1: float) -> None: ...
    def setYScale(self, arg__1: float) -> None: ...
    def setZScale(self, arg__1: float) -> None: ...
    def xScale(self) -> float: ...
    def yScale(self) -> float: ...
    def zScale(self) -> float: ...


class QGraphicsScene(PySide6.QtCore.QObject):

    changed                  : ClassVar[Signal] = ... # changed(QList<QRectF>)
    focusItemChanged         : ClassVar[Signal] = ... # focusItemChanged(QGraphicsItem*,QGraphicsItem*,Qt::FocusReason)
    sceneRectChanged         : ClassVar[Signal] = ... # sceneRectChanged(QRectF)
    selectionChanged         : ClassVar[Signal] = ... # selectionChanged()

    class ItemIndexMethod(enum.Enum):

        NoIndex                  : QGraphicsScene.ItemIndexMethod = ... # -0x1
        BspTreeIndex             : QGraphicsScene.ItemIndexMethod = ... # 0x0

    class SceneLayer(enum.Flag):

        ItemLayer                : QGraphicsScene.SceneLayer = ... # 0x1
        BackgroundLayer          : QGraphicsScene.SceneLayer = ... # 0x2
        ForegroundLayer          : QGraphicsScene.SceneLayer = ... # 0x4
        AllLayers                : QGraphicsScene.SceneLayer = ... # 0xffff


    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, sceneRect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, x: float, y: float, width: float, height: float, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def activePanel(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def activeWindow(self) -> PySide6.QtWidgets.QGraphicsWidget: ...
    @overload
    def addEllipse(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor] = ..., brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap] = ...) -> PySide6.QtWidgets.QGraphicsEllipseItem: ...
    @overload
    def addEllipse(self, x: float, y: float, w: float, h: float, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor] = ..., brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap] = ...) -> PySide6.QtWidgets.QGraphicsEllipseItem: ...
    def addItem(self, item: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    @overload
    def addLine(self, line: Union[PySide6.QtCore.QLineF, PySide6.QtCore.QLine], pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor] = ...) -> PySide6.QtWidgets.QGraphicsLineItem: ...
    @overload
    def addLine(self, x1: float, y1: float, x2: float, y2: float, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor] = ...) -> PySide6.QtWidgets.QGraphicsLineItem: ...
    def addPath(self, path: PySide6.QtGui.QPainterPath, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor] = ..., brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap] = ...) -> PySide6.QtWidgets.QGraphicsPathItem: ...
    def addPixmap(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> PySide6.QtWidgets.QGraphicsPixmapItem: ...
    def addPolygon(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF], pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor] = ..., brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap] = ...) -> PySide6.QtWidgets.QGraphicsPolygonItem: ...
    @overload
    def addRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor] = ..., brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap] = ...) -> PySide6.QtWidgets.QGraphicsRectItem: ...
    @overload
    def addRect(self, x: float, y: float, w: float, h: float, pen: Union[PySide6.QtGui.QPen, PySide6.QtCore.Qt.PenStyle, PySide6.QtGui.QColor] = ..., brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap] = ...) -> PySide6.QtWidgets.QGraphicsRectItem: ...
    def addSimpleText(self, text: str, font: Union[PySide6.QtGui.QFont, str, Sequence[str]] = ...) -> PySide6.QtWidgets.QGraphicsSimpleTextItem: ...
    def addText(self, text: str, font: Union[PySide6.QtGui.QFont, str, Sequence[str]] = ...) -> PySide6.QtWidgets.QGraphicsTextItem: ...
    def addWidget(self, widget: PySide6.QtWidgets.QWidget, wFlags: PySide6.QtCore.Qt.WindowType = ...) -> PySide6.QtWidgets.QGraphicsProxyWidget: ...
    def advance(self) -> None: ...
    def backgroundBrush(self) -> PySide6.QtGui.QBrush: ...
    def bspTreeDepth(self) -> int: ...
    def clear(self) -> None: ...
    def clearFocus(self) -> None: ...
    def clearSelection(self) -> None: ...
    def collidingItems(self, item: PySide6.QtWidgets.QGraphicsItem, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    def contextMenuEvent(self, event: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...
    def createItemGroup(self, items: Sequence[PySide6.QtWidgets.QGraphicsItem]) -> PySide6.QtWidgets.QGraphicsItemGroup: ...
    def destroyItemGroup(self, group: PySide6.QtWidgets.QGraphicsItemGroup) -> None: ...
    def dragEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def drawBackground(self, painter: PySide6.QtGui.QPainter, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def drawForeground(self, painter: PySide6.QtGui.QPainter, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def dropEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, watched: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusItem(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOnTouch(self) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def foregroundBrush(self) -> PySide6.QtGui.QBrush: ...
    def hasFocus(self) -> bool: ...
    def height(self) -> float: ...
    def helpEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHelpEvent) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    @overload
    def invalidate(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ..., layers: PySide6.QtWidgets.QGraphicsScene.SceneLayer = ...) -> None: ...
    @overload
    def invalidate(self, x: float, y: float, w: float, h: float, layers: PySide6.QtWidgets.QGraphicsScene.SceneLayer = ...) -> None: ...
    def isActive(self) -> bool: ...
    @overload
    def itemAt(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], deviceTransform: PySide6.QtGui.QTransform) -> PySide6.QtWidgets.QGraphicsItem: ...
    @overload
    def itemAt(self, x: float, y: float, deviceTransform: PySide6.QtGui.QTransform) -> PySide6.QtWidgets.QGraphicsItem: ...
    def itemIndexMethod(self) -> PySide6.QtWidgets.QGraphicsScene.ItemIndexMethod: ...
    @overload
    def items(self, order: PySide6.QtCore.Qt.SortOrder = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, path: PySide6.QtGui.QPainterPath, mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., order: PySide6.QtCore.Qt.SortOrder = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF], mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., order: PySide6.QtCore.Qt.SortOrder = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., order: PySide6.QtCore.Qt.SortOrder = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., order: PySide6.QtCore.Qt.SortOrder = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, x: float, y: float, w: float, h: float, mode: PySide6.QtCore.Qt.ItemSelectionMode, order: PySide6.QtCore.Qt.SortOrder, deviceTransform: PySide6.QtGui.QTransform = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    def itemsBoundingRect(self) -> PySide6.QtCore.QRectF: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def minimumRenderSize(self) -> float: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseGrabberItem(self) -> PySide6.QtWidgets.QGraphicsItem: ...
    def mouseMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def palette(self) -> PySide6.QtGui.QPalette: ...
    def removeItem(self, item: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def render(self, painter: PySide6.QtGui.QPainter, target: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ..., source: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ..., aspectRatioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def sceneRect(self) -> PySide6.QtCore.QRectF: ...
    def selectedItems(self) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    def selectionArea(self) -> PySide6.QtGui.QPainterPath: ...
    def sendEvent(self, item: PySide6.QtWidgets.QGraphicsItem, event: PySide6.QtCore.QEvent) -> bool: ...
    def setActivePanel(self, item: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    def setActiveWindow(self, widget: PySide6.QtWidgets.QGraphicsWidget) -> None: ...
    def setBackgroundBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setBspTreeDepth(self, depth: int) -> None: ...
    def setFocus(self, focusReason: PySide6.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusItem(self, item: PySide6.QtWidgets.QGraphicsItem, focusReason: PySide6.QtCore.Qt.FocusReason = ...) -> None: ...
    def setFocusOnTouch(self, enabled: bool) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setForegroundBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setItemIndexMethod(self, method: PySide6.QtWidgets.QGraphicsScene.ItemIndexMethod) -> None: ...
    def setMinimumRenderSize(self, minSize: float) -> None: ...
    def setPalette(self, palette: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @overload
    def setSceneRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setSceneRect(self, x: float, y: float, w: float, h: float) -> None: ...
    @overload
    def setSelectionArea(self, path: PySide6.QtGui.QPainterPath, deviceTransform: PySide6.QtGui.QTransform) -> None: ...
    @overload
    def setSelectionArea(self, path: PySide6.QtGui.QPainterPath, selectionOperation: PySide6.QtCore.Qt.ItemSelectionOperation = ..., mode: PySide6.QtCore.Qt.ItemSelectionMode = ..., deviceTransform: PySide6.QtGui.QTransform = ...) -> None: ...
    def setStickyFocus(self, enabled: bool) -> None: ...
    def setStyle(self, style: PySide6.QtWidgets.QStyle) -> None: ...
    def stickyFocus(self) -> bool: ...
    def style(self) -> PySide6.QtWidgets.QStyle: ...
    @overload
    def update(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ...) -> None: ...
    @overload
    def update(self, x: float, y: float, w: float, h: float) -> None: ...
    def views(self) -> List[PySide6.QtWidgets.QGraphicsView]: ...
    def wheelEvent(self, event: PySide6.QtWidgets.QGraphicsSceneWheelEvent) -> None: ...
    def width(self) -> float: ...


class QGraphicsSceneContextMenuEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    class Reason(enum.Enum):

        Mouse                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x0
        Keyboard                 : QGraphicsSceneContextMenuEvent.Reason = ... # 0x1
        Other                    : QGraphicsSceneContextMenuEvent.Reason = ... # 0x2


    def __init__(self, type: Optional[PySide6.QtCore.QEvent.Type] = ...) -> None: ...

    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def pos(self) -> PySide6.QtCore.QPointF: ...
    def reason(self) -> PySide6.QtWidgets.QGraphicsSceneContextMenuEvent.Reason: ...
    def scenePos(self) -> PySide6.QtCore.QPointF: ...
    def screenPos(self) -> PySide6.QtCore.QPoint: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> None: ...
    def setPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setReason(self, reason: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent.Reason) -> None: ...
    def setScenePos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint) -> None: ...


class QGraphicsSceneDragDropEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: Optional[PySide6.QtCore.QEvent.Type] = ...) -> None: ...

    def acceptProposedAction(self) -> None: ...
    def buttons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def dropAction(self) -> PySide6.QtCore.Qt.DropAction: ...
    def mimeData(self) -> PySide6.QtCore.QMimeData: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def pos(self) -> PySide6.QtCore.QPointF: ...
    def possibleActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def proposedAction(self) -> PySide6.QtCore.Qt.DropAction: ...
    def scenePos(self) -> PySide6.QtCore.QPointF: ...
    def screenPos(self) -> PySide6.QtCore.QPoint: ...
    def setButtons(self, buttons: PySide6.QtCore.Qt.MouseButton) -> None: ...
    def setDropAction(self, action: PySide6.QtCore.Qt.DropAction) -> None: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> None: ...
    def setPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setPossibleActions(self, actions: PySide6.QtCore.Qt.DropAction) -> None: ...
    def setProposedAction(self, action: PySide6.QtCore.Qt.DropAction) -> None: ...
    def setScenePos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint) -> None: ...
    def source(self) -> PySide6.QtWidgets.QWidget: ...


class QGraphicsSceneEvent(PySide6.QtCore.QEvent):

    def __init__(self, type: PySide6.QtCore.QEvent.Type) -> None: ...

    def setTimestamp(self, ts: int) -> None: ...
    def timestamp(self) -> int: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...


class QGraphicsSceneHelpEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: Optional[PySide6.QtCore.QEvent.Type] = ...) -> None: ...

    def scenePos(self) -> PySide6.QtCore.QPointF: ...
    def screenPos(self) -> PySide6.QtCore.QPoint: ...
    def setScenePos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint) -> None: ...


class QGraphicsSceneHoverEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: Optional[PySide6.QtCore.QEvent.Type] = ...) -> None: ...

    def lastPos(self) -> PySide6.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide6.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide6.QtCore.QPoint: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def pos(self) -> PySide6.QtCore.QPointF: ...
    def scenePos(self) -> PySide6.QtCore.QPointF: ...
    def screenPos(self) -> PySide6.QtCore.QPoint: ...
    def setLastPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setLastScenePos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setLastScreenPos(self, pos: PySide6.QtCore.QPoint) -> None: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> None: ...
    def setPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setScenePos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint) -> None: ...


class QGraphicsSceneMouseEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: Optional[PySide6.QtCore.QEvent.Type] = ...) -> None: ...

    def button(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def buttonDownPos(self, button: PySide6.QtCore.Qt.MouseButton) -> PySide6.QtCore.QPointF: ...
    def buttonDownScenePos(self, button: PySide6.QtCore.Qt.MouseButton) -> PySide6.QtCore.QPointF: ...
    def buttonDownScreenPos(self, button: PySide6.QtCore.Qt.MouseButton) -> PySide6.QtCore.QPoint: ...
    def buttons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def flags(self) -> PySide6.QtCore.Qt.MouseEventFlag: ...
    def lastPos(self) -> PySide6.QtCore.QPointF: ...
    def lastScenePos(self) -> PySide6.QtCore.QPointF: ...
    def lastScreenPos(self) -> PySide6.QtCore.QPoint: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def pos(self) -> PySide6.QtCore.QPointF: ...
    def scenePos(self) -> PySide6.QtCore.QPointF: ...
    def screenPos(self) -> PySide6.QtCore.QPoint: ...
    def setButton(self, button: PySide6.QtCore.Qt.MouseButton) -> None: ...
    def setButtonDownPos(self, button: PySide6.QtCore.Qt.MouseButton, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setButtonDownScenePos(self, button: PySide6.QtCore.Qt.MouseButton, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setButtonDownScreenPos(self, button: PySide6.QtCore.Qt.MouseButton, pos: PySide6.QtCore.QPoint) -> None: ...
    def setButtons(self, buttons: PySide6.QtCore.Qt.MouseButton) -> None: ...
    def setFlags(self, arg__1: PySide6.QtCore.Qt.MouseEventFlag) -> None: ...
    def setLastPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setLastScenePos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setLastScreenPos(self, pos: PySide6.QtCore.QPoint) -> None: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> None: ...
    def setPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setScenePos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint) -> None: ...
    def setSource(self, source: PySide6.QtCore.Qt.MouseEventSource) -> None: ...
    def source(self) -> PySide6.QtCore.Qt.MouseEventSource: ...


class QGraphicsSceneMoveEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self) -> None: ...

    def newPos(self) -> PySide6.QtCore.QPointF: ...
    def oldPos(self) -> PySide6.QtCore.QPointF: ...
    def setNewPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setOldPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...


class QGraphicsSceneResizeEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self) -> None: ...

    def newSize(self) -> PySide6.QtCore.QSizeF: ...
    def oldSize(self) -> PySide6.QtCore.QSizeF: ...
    def setNewSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    def setOldSize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...


class QGraphicsSceneWheelEvent(PySide6.QtWidgets.QGraphicsSceneEvent):

    def __init__(self, type: Optional[PySide6.QtCore.QEvent.Type] = ...) -> None: ...

    def buttons(self) -> PySide6.QtCore.Qt.MouseButton: ...
    def delta(self) -> int: ...
    def isInverted(self) -> bool: ...
    def modifiers(self) -> PySide6.QtCore.Qt.KeyboardModifier: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def phase(self) -> PySide6.QtCore.Qt.ScrollPhase: ...
    def pixelDelta(self) -> PySide6.QtCore.QPoint: ...
    def pos(self) -> PySide6.QtCore.QPointF: ...
    def scenePos(self) -> PySide6.QtCore.QPointF: ...
    def screenPos(self) -> PySide6.QtCore.QPoint: ...
    def setButtons(self, buttons: PySide6.QtCore.Qt.MouseButton) -> None: ...
    def setDelta(self, delta: int) -> None: ...
    def setInverted(self, inverted: bool) -> None: ...
    def setModifiers(self, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> None: ...
    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setPhase(self, scrollPhase: PySide6.QtCore.Qt.ScrollPhase) -> None: ...
    def setPixelDelta(self, delta: PySide6.QtCore.QPoint) -> None: ...
    def setPos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setScenePos(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setScreenPos(self, pos: PySide6.QtCore.QPoint) -> None: ...


class QGraphicsSimpleTextItem(PySide6.QtWidgets.QAbstractGraphicsShapeItem):

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def extension(self, variant: Any) -> Any: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setText(self, text: str) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def text(self) -> str: ...
    def type(self) -> int: ...


class QGraphicsTextItem(PySide6.QtWidgets.QGraphicsObject):

    linkActivated            : ClassVar[Signal] = ... # linkActivated(QString)
    linkHovered              : ClassVar[Signal] = ... # linkHovered(QString)

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ...) -> None: ...

    def adjustSize(self) -> None: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def contains(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> bool: ...
    def contextMenuEvent(self, event: PySide6.QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...
    def defaultTextColor(self) -> PySide6.QtGui.QColor: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def dragEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def dropEvent(self, event: PySide6.QtWidgets.QGraphicsSceneDragDropEvent) -> None: ...
    def extension(self, variant: Any) -> Any: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def hoverEnterEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    def isObscuredBy(self, item: PySide6.QtWidgets.QGraphicsItem) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def opaqueArea(self) -> PySide6.QtGui.QPainterPath: ...
    def openExternalLinks(self) -> bool: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def sceneEvent(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def setDefaultTextColor(self, c: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setDocument(self, document: PySide6.QtGui.QTextDocument) -> None: ...
    def setExtension(self, extension: PySide6.QtWidgets.QGraphicsItem.Extension, variant: Any) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setHtml(self, html: str) -> None: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def setTextCursor(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag) -> None: ...
    def setTextWidth(self, width: float) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def supportsExtension(self, extension: PySide6.QtWidgets.QGraphicsItem.Extension) -> bool: ...
    def tabChangesFocus(self) -> bool: ...
    def textCursor(self) -> PySide6.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    def textWidth(self) -> float: ...
    def toHtml(self) -> str: ...
    def toPlainText(self) -> str: ...
    def type(self) -> int: ...


class QGraphicsTransform(PySide6.QtCore.QObject):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def applyTo(self, matrix: Union[PySide6.QtGui.QMatrix4x4, PySide6.QtGui.QTransform]) -> None: ...
    def update(self) -> None: ...


class QGraphicsView(PySide6.QtWidgets.QAbstractScrollArea):

    rubberBandChanged        : ClassVar[Signal] = ... # rubberBandChanged(QRect,QPointF,QPointF)

    class CacheModeFlag(enum.Flag):

        CacheNone                : QGraphicsView.CacheModeFlag = ... # 0x0
        CacheBackground          : QGraphicsView.CacheModeFlag = ... # 0x1

    class DragMode(enum.Enum):

        NoDrag                   : QGraphicsView.DragMode = ... # 0x0
        ScrollHandDrag           : QGraphicsView.DragMode = ... # 0x1
        RubberBandDrag           : QGraphicsView.DragMode = ... # 0x2

    class OptimizationFlag(enum.Flag):

        DontSavePainterState     : QGraphicsView.OptimizationFlag = ... # 0x1
        DontAdjustForAntialiasing: QGraphicsView.OptimizationFlag = ... # 0x2
        IndirectPainting         : QGraphicsView.OptimizationFlag = ... # 0x4

    class ViewportAnchor(enum.Enum):

        NoAnchor                 : QGraphicsView.ViewportAnchor = ... # 0x0
        AnchorViewCenter         : QGraphicsView.ViewportAnchor = ... # 0x1
        AnchorUnderMouse         : QGraphicsView.ViewportAnchor = ... # 0x2

    class ViewportUpdateMode(enum.Enum):

        FullViewportUpdate       : QGraphicsView.ViewportUpdateMode = ... # 0x0
        MinimalViewportUpdate    : QGraphicsView.ViewportUpdateMode = ... # 0x1
        SmartViewportUpdate      : QGraphicsView.ViewportUpdateMode = ... # 0x2
        NoViewportUpdate         : QGraphicsView.ViewportUpdateMode = ... # 0x3
        BoundingRectViewportUpdate: QGraphicsView.ViewportUpdateMode = ... # 0x4


    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, scene: PySide6.QtWidgets.QGraphicsScene, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def backgroundBrush(self) -> PySide6.QtGui.QBrush: ...
    def cacheMode(self) -> PySide6.QtWidgets.QGraphicsView.CacheModeFlag: ...
    @overload
    def centerOn(self, item: PySide6.QtWidgets.QGraphicsItem) -> None: ...
    @overload
    def centerOn(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def centerOn(self, x: float, y: float) -> None: ...
    def contextMenuEvent(self, event: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def dragEnterEvent(self, event: PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMode(self) -> PySide6.QtWidgets.QGraphicsView.DragMode: ...
    def dragMoveEvent(self, event: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def drawBackground(self, painter: PySide6.QtGui.QPainter, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def drawForeground(self, painter: PySide6.QtGui.QPainter, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def drawItems(self, painter: PySide6.QtGui.QPainter, items: Iterable, options: Iterable) -> None: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent) -> None: ...
    @overload
    def ensureVisible(self, item: PySide6.QtWidgets.QGraphicsItem, xmargin: int = ..., ymargin: int = ...) -> None: ...
    @overload
    def ensureVisible(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], xmargin: int = ..., ymargin: int = ...) -> None: ...
    @overload
    def ensureVisible(self, x: float, y: float, w: float, h: float, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    @overload
    def fitInView(self, item: PySide6.QtWidgets.QGraphicsItem, aspectRadioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @overload
    def fitInView(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], aspectRadioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    @overload
    def fitInView(self, x: float, y: float, w: float, h: float, aspectRadioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def foregroundBrush(self) -> PySide6.QtGui.QBrush: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    def invalidateScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ..., layers: PySide6.QtWidgets.QGraphicsScene.SceneLayer = ...) -> None: ...
    def isInteractive(self) -> bool: ...
    def isTransformed(self) -> bool: ...
    @overload
    def itemAt(self, pos: PySide6.QtCore.QPoint) -> PySide6.QtWidgets.QGraphicsItem: ...
    @overload
    def itemAt(self, x: int, y: int) -> PySide6.QtWidgets.QGraphicsItem: ...
    @overload
    def items(self) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, path: PySide6.QtGui.QPainterPath, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, polygon: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect], mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, pos: PySide6.QtCore.QPoint) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, rect: PySide6.QtCore.QRect, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, x: int, y: int) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    @overload
    def items(self, x: int, y: int, w: int, h: int, mode: PySide6.QtCore.Qt.ItemSelectionMode = ...) -> List[PySide6.QtWidgets.QGraphicsItem]: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    @overload
    def mapFromScene(self, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def mapFromScene(self, point: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapFromScene(self, polygon: Union[PySide6.QtGui.QPolygonF, Sequence[PySide6.QtCore.QPointF], PySide6.QtGui.QPolygon, PySide6.QtCore.QRectF]) -> PySide6.QtGui.QPolygon: ...
    @overload
    def mapFromScene(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygon: ...
    @overload
    def mapFromScene(self, x: float, y: float) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapFromScene(self, x: float, y: float, w: float, h: float) -> PySide6.QtGui.QPolygon: ...
    @overload
    def mapToScene(self, path: PySide6.QtGui.QPainterPath) -> PySide6.QtGui.QPainterPath: ...
    @overload
    def mapToScene(self, point: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToScene(self, polygon: Union[PySide6.QtGui.QPolygon, Sequence[PySide6.QtCore.QPoint], PySide6.QtCore.QRect]) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, rect: PySide6.QtCore.QRect) -> PySide6.QtGui.QPolygonF: ...
    @overload
    def mapToScene(self, x: int, y: int) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToScene(self, x: int, y: int, w: int, h: int) -> PySide6.QtGui.QPolygonF: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def optimizationFlags(self) -> PySide6.QtWidgets.QGraphicsView.OptimizationFlag: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    def render(self, painter: PySide6.QtGui.QPainter, target: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect] = ..., source: PySide6.QtCore.QRect = ..., aspectRatioMode: PySide6.QtCore.Qt.AspectRatioMode = ...) -> None: ...
    def renderHints(self) -> PySide6.QtGui.QPainter.RenderHint: ...
    def resetCachedContent(self) -> None: ...
    def resetTransform(self) -> None: ...
    def resizeAnchor(self) -> PySide6.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def rotate(self, angle: float) -> None: ...
    def rubberBandRect(self) -> PySide6.QtCore.QRect: ...
    def rubberBandSelectionMode(self) -> PySide6.QtCore.Qt.ItemSelectionMode: ...
    def scale(self, sx: float, sy: float) -> None: ...
    def scene(self) -> PySide6.QtWidgets.QGraphicsScene: ...
    def sceneRect(self) -> PySide6.QtCore.QRectF: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setBackgroundBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setCacheMode(self, mode: PySide6.QtWidgets.QGraphicsView.CacheModeFlag) -> None: ...
    def setDragMode(self, mode: PySide6.QtWidgets.QGraphicsView.DragMode) -> None: ...
    def setForegroundBrush(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setInteractive(self, allowed: bool) -> None: ...
    def setOptimizationFlag(self, flag: PySide6.QtWidgets.QGraphicsView.OptimizationFlag, enabled: bool = ...) -> None: ...
    def setOptimizationFlags(self, flags: PySide6.QtWidgets.QGraphicsView.OptimizationFlag) -> None: ...
    def setRenderHint(self, hint: PySide6.QtGui.QPainter.RenderHint, enabled: bool = ...) -> None: ...
    def setRenderHints(self, hints: PySide6.QtGui.QPainter.RenderHint) -> None: ...
    def setResizeAnchor(self, anchor: PySide6.QtWidgets.QGraphicsView.ViewportAnchor) -> None: ...
    def setRubberBandSelectionMode(self, mode: PySide6.QtCore.Qt.ItemSelectionMode) -> None: ...
    def setScene(self, scene: Optional[PySide6.QtWidgets.QGraphicsScene]) -> None: ...
    @overload
    def setSceneRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setSceneRect(self, x: float, y: float, w: float, h: float) -> None: ...
    def setTransform(self, matrix: PySide6.QtGui.QTransform, combine: bool = ...) -> None: ...
    def setTransformationAnchor(self, anchor: PySide6.QtWidgets.QGraphicsView.ViewportAnchor) -> None: ...
    def setViewportUpdateMode(self, mode: PySide6.QtWidgets.QGraphicsView.ViewportUpdateMode) -> None: ...
    def setupViewport(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def shear(self, sh: float, sv: float) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def transform(self) -> PySide6.QtGui.QTransform: ...
    def transformationAnchor(self) -> PySide6.QtWidgets.QGraphicsView.ViewportAnchor: ...
    def translate(self, dx: float, dy: float) -> None: ...
    def updateScene(self, rects: Sequence[PySide6.QtCore.QRectF]) -> None: ...
    def updateSceneRect(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    def viewportEvent(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def viewportTransform(self) -> PySide6.QtGui.QTransform: ...
    def viewportUpdateMode(self) -> PySide6.QtWidgets.QGraphicsView.ViewportUpdateMode: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...


class QGraphicsWidget(PySide6.QtWidgets.QGraphicsObject, PySide6.QtWidgets.QGraphicsLayoutItem):

    geometryChanged          : ClassVar[Signal] = ... # geometryChanged()
    layoutChanged            : ClassVar[Signal] = ... # layoutChanged()

    def __init__(self, parent: Optional[PySide6.QtWidgets.QGraphicsItem] = ..., wFlags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def actions(self) -> List[PySide6.QtGui.QAction]: ...
    def addAction(self, action: PySide6.QtGui.QAction) -> None: ...
    def addActions(self, actions: Sequence[PySide6.QtGui.QAction]) -> None: ...
    def adjustSize(self) -> None: ...
    def autoFillBackground(self) -> bool: ...
    def boundingRect(self) -> PySide6.QtCore.QRectF: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def close(self) -> bool: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusPolicy(self) -> PySide6.QtCore.Qt.FocusPolicy: ...
    def focusWidget(self) -> PySide6.QtWidgets.QGraphicsWidget: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def getContentsMargins(self) -> object: ...
    def getWindowFrameMargins(self) -> object: ...
    def grabKeyboardEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def grabMouseEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def grabShortcut(self, sequence: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], context: PySide6.QtCore.Qt.ShortcutContext = ...) -> int: ...
    def hideEvent(self, event: PySide6.QtGui.QHideEvent) -> None: ...
    def hoverLeaveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOption) -> None: ...
    def insertAction(self, before: PySide6.QtGui.QAction, action: PySide6.QtGui.QAction) -> None: ...
    def insertActions(self, before: PySide6.QtGui.QAction, actions: Sequence[PySide6.QtGui.QAction]) -> None: ...
    def isActiveWindow(self) -> bool: ...
    def itemChange(self, change: PySide6.QtWidgets.QGraphicsItem.GraphicsItemChange, value: Any) -> Any: ...
    def layout(self) -> PySide6.QtWidgets.QGraphicsLayout: ...
    def layoutDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def moveEvent(self, event: PySide6.QtWidgets.QGraphicsSceneMoveEvent) -> None: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def paintWindowFrame(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionGraphicsItem, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def palette(self) -> PySide6.QtGui.QPalette: ...
    def polishEvent(self) -> None: ...
    def propertyChange(self, propertyName: str, value: Any) -> Any: ...
    def rect(self) -> PySide6.QtCore.QRectF: ...
    def releaseShortcut(self, id: int) -> None: ...
    def removeAction(self, action: PySide6.QtGui.QAction) -> None: ...
    @overload
    def resize(self, size: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize]) -> None: ...
    @overload
    def resize(self, w: float, h: float) -> None: ...
    def resizeEvent(self, event: PySide6.QtWidgets.QGraphicsSceneResizeEvent) -> None: ...
    def sceneEvent(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def setAttribute(self, attribute: PySide6.QtCore.Qt.WidgetAttribute, on: bool = ...) -> None: ...
    def setAutoFillBackground(self, enabled: bool) -> None: ...
    @overload
    def setContentsMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @overload
    def setContentsMargins(self, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]) -> None: ...
    def setFocusPolicy(self, policy: PySide6.QtCore.Qt.FocusPolicy) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    @overload
    def setGeometry(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def setGeometry(self, x: float, y: float, w: float, h: float) -> None: ...
    def setLayout(self, layout: PySide6.QtWidgets.QGraphicsLayout) -> None: ...
    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    def setPalette(self, palette: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    def setShortcutAutoRepeat(self, id: int, enabled: bool = ...) -> None: ...
    def setShortcutEnabled(self, id: int, enabled: bool = ...) -> None: ...
    def setStyle(self, style: PySide6.QtWidgets.QStyle) -> None: ...
    @staticmethod
    def setTabOrder(first: PySide6.QtWidgets.QGraphicsWidget, second: PySide6.QtWidgets.QGraphicsWidget) -> None: ...
    def setWindowFlags(self, wFlags: PySide6.QtCore.Qt.WindowType) -> None: ...
    @overload
    def setWindowFrameMargins(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @overload
    def setWindowFrameMargins(self, margins: Union[PySide6.QtCore.QMarginsF, PySide6.QtCore.QMargins]) -> None: ...
    def setWindowTitle(self, title: str) -> None: ...
    def shape(self) -> PySide6.QtGui.QPainterPath: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None: ...
    def size(self) -> PySide6.QtCore.QSizeF: ...
    def sizeHint(self, which: PySide6.QtCore.Qt.SizeHint, constraint: Union[PySide6.QtCore.QSizeF, PySide6.QtCore.QSize] = ...) -> PySide6.QtCore.QSizeF: ...
    def style(self) -> PySide6.QtWidgets.QStyle: ...
    def testAttribute(self, attribute: PySide6.QtCore.Qt.WidgetAttribute) -> bool: ...
    def type(self) -> int: ...
    def ungrabKeyboardEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def ungrabMouseEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def unsetLayoutDirection(self) -> None: ...
    def unsetWindowFrameMargins(self) -> None: ...
    def updateGeometry(self) -> None: ...
    def windowFlags(self) -> PySide6.QtCore.Qt.WindowType: ...
    def windowFrameEvent(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def windowFrameGeometry(self) -> PySide6.QtCore.QRectF: ...
    def windowFrameRect(self) -> PySide6.QtCore.QRectF: ...
    def windowFrameSectionAt(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.Qt.WindowFrameSection: ...
    def windowTitle(self) -> str: ...
    def windowType(self) -> PySide6.QtCore.Qt.WindowType: ...


class QGridLayout(PySide6.QtWidgets.QLayout):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    @overload
    def addItem(self, arg__1: PySide6.QtWidgets.QLayoutItem) -> None: ...
    @overload
    def addItem(self, item: PySide6.QtWidgets.QLayoutItem, row: int, column: int, rowSpan: int = ..., columnSpan: int = ..., alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @overload
    def addLayout(self, arg__1: PySide6.QtWidgets.QLayout, row: int, column: int, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @overload
    def addLayout(self, arg__1: PySide6.QtWidgets.QLayout, row: int, column: int, rowSpan: int, columnSpan: int, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @overload
    def addWidget(self, arg__1: PySide6.QtWidgets.QWidget, row: int, column: int, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @overload
    def addWidget(self, arg__1: PySide6.QtWidgets.QWidget, row: int, column: int, rowSpan: int, columnSpan: int, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...
    @overload
    def addWidget(self, w: PySide6.QtWidgets.QWidget) -> None: ...
    def cellRect(self, row: int, column: int) -> PySide6.QtCore.QRect: ...
    def columnCount(self) -> int: ...
    def columnMinimumWidth(self, column: int) -> int: ...
    def columnStretch(self, column: int) -> int: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientation: ...
    def getItemPosition(self, idx: int) -> object: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def horizontalSpacing(self) -> int: ...
    def invalidate(self) -> None: ...
    def itemAt(self, index: int) -> PySide6.QtWidgets.QLayoutItem: ...
    def itemAtPosition(self, row: int, column: int) -> PySide6.QtWidgets.QLayoutItem: ...
    def maximumSize(self) -> PySide6.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def originCorner(self) -> PySide6.QtCore.Qt.Corner: ...
    def rowCount(self) -> int: ...
    def rowMinimumHeight(self, row: int) -> int: ...
    def rowStretch(self, row: int) -> int: ...
    def setColumnMinimumWidth(self, column: int, minSize: int) -> None: ...
    def setColumnStretch(self, column: int, stretch: int) -> None: ...
    def setDefaultPositioning(self, n: int, orient: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    def setHorizontalSpacing(self, spacing: int) -> None: ...
    def setOriginCorner(self, arg__1: PySide6.QtCore.Qt.Corner) -> None: ...
    def setRowMinimumHeight(self, row: int, minSize: int) -> None: ...
    def setRowStretch(self, row: int, stretch: int) -> None: ...
    def setSpacing(self, spacing: int) -> None: ...
    def setVerticalSpacing(self, spacing: int) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> PySide6.QtWidgets.QLayoutItem: ...
    def verticalSpacing(self) -> int: ...


class QGroupBox(PySide6.QtWidgets.QWidget):

    clicked                  : ClassVar[Signal] = ... # clicked(); clicked(bool)
    toggled                  : ClassVar[Signal] = ... # toggled(bool)

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, title: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def childEvent(self, event: PySide6.QtCore.QChildEvent) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionGroupBox) -> None: ...
    def isCheckable(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def setAlignment(self, alignment: int) -> None: ...
    def setCheckable(self, checkable: bool) -> None: ...
    def setChecked(self, checked: bool) -> None: ...
    def setFlat(self, flat: bool) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...


class QHBoxLayout(PySide6.QtWidgets.QBoxLayout):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget) -> None: ...


class QHeaderView(PySide6.QtWidgets.QAbstractItemView):

    geometriesChanged        : ClassVar[Signal] = ... # geometriesChanged()
    sectionClicked           : ClassVar[Signal] = ... # sectionClicked(int)
    sectionCountChanged      : ClassVar[Signal] = ... # sectionCountChanged(int,int)
    sectionDoubleClicked     : ClassVar[Signal] = ... # sectionDoubleClicked(int)
    sectionEntered           : ClassVar[Signal] = ... # sectionEntered(int)
    sectionHandleDoubleClicked: ClassVar[Signal] = ... # sectionHandleDoubleClicked(int)
    sectionMoved             : ClassVar[Signal] = ... # sectionMoved(int,int,int)
    sectionPressed           : ClassVar[Signal] = ... # sectionPressed(int)
    sectionResized           : ClassVar[Signal] = ... # sectionResized(int,int,int)
    sortIndicatorChanged     : ClassVar[Signal] = ... # sortIndicatorChanged(int,Qt::SortOrder)
    sortIndicatorClearableChanged: ClassVar[Signal] = ... # sortIndicatorClearableChanged(bool)

    class ResizeMode(enum.Enum):

        Interactive              : QHeaderView.ResizeMode = ... # 0x0
        Stretch                  : QHeaderView.ResizeMode = ... # 0x1
        Custom                   : QHeaderView.ResizeMode = ... # 0x2
        Fixed                    : QHeaderView.ResizeMode = ... # 0x2
        ResizeToContents         : QHeaderView.ResizeMode = ... # 0x3


    def __init__(self, orientation: PySide6.QtCore.Qt.Orientation, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def cascadingSectionResizes(self) -> bool: ...
    def count(self) -> int: ...
    def currentChanged(self, current: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], old: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def dataChanged(self, topLeft: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], bottomRight: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], roles: Sequence[int] = ...) -> None: ...
    def defaultAlignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def defaultSectionSize(self) -> int: ...
    def doItemsLayout(self) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def headerDataChanged(self, orientation: PySide6.QtCore.Qt.Orientation, logicalFirst: int, logicalLast: int) -> None: ...
    def hiddenSectionCount(self) -> int: ...
    def hideSection(self, logicalIndex: int) -> None: ...
    def highlightSections(self) -> bool: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QModelIndex: ...
    @overload
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionFrame) -> None: ...
    @overload
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionHeader) -> None: ...
    def initStyleOptionForIndex(self, option: PySide6.QtWidgets.QStyleOptionHeader, logicalIndex: int) -> None: ...
    def initialize(self) -> None: ...
    @overload
    def initializeSections(self) -> None: ...
    @overload
    def initializeSections(self, start: int, end: int) -> None: ...
    def isFirstSectionMovable(self) -> bool: ...
    def isIndexHidden(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def isSectionHidden(self, logicalIndex: int) -> bool: ...
    def isSortIndicatorClearable(self) -> bool: ...
    def isSortIndicatorShown(self) -> bool: ...
    def length(self) -> int: ...
    def logicalIndex(self, visualIndex: int) -> int: ...
    @overload
    def logicalIndexAt(self, pos: PySide6.QtCore.QPoint) -> int: ...
    @overload
    def logicalIndexAt(self, position: int) -> int: ...
    @overload
    def logicalIndexAt(self, x: int, y: int) -> int: ...
    def maximumSectionSize(self) -> int: ...
    def minimumSectionSize(self) -> int: ...
    def mouseDoubleClickEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, arg__1: PySide6.QtWidgets.QAbstractItemView.CursorAction, arg__2: PySide6.QtCore.Qt.KeyboardModifier) -> PySide6.QtCore.QModelIndex: ...
    def moveSection(self, from_: int, to: int) -> None: ...
    def offset(self) -> int: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def paintSection(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, logicalIndex: int) -> None: ...
    def reset(self) -> None: ...
    def resetDefaultSectionSize(self) -> None: ...
    def resizeContentsPrecision(self) -> int: ...
    def resizeSection(self, logicalIndex: int, size: int) -> None: ...
    @overload
    def resizeSections(self) -> None: ...
    @overload
    def resizeSections(self, mode: PySide6.QtWidgets.QHeaderView.ResizeMode) -> None: ...
    def restoreState(self, state: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> bool: ...
    def rowsInserted(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], start: int, end: int) -> None: ...
    def saveState(self) -> PySide6.QtCore.QByteArray: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint) -> None: ...
    def sectionPosition(self, logicalIndex: int) -> int: ...
    def sectionResizeMode(self, logicalIndex: int) -> PySide6.QtWidgets.QHeaderView.ResizeMode: ...
    def sectionSize(self, logicalIndex: int) -> int: ...
    def sectionSizeFromContents(self, logicalIndex: int) -> PySide6.QtCore.QSize: ...
    def sectionSizeHint(self, logicalIndex: int) -> int: ...
    def sectionViewportPosition(self, logicalIndex: int) -> int: ...
    def sectionsAboutToBeRemoved(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], logicalFirst: int, logicalLast: int) -> None: ...
    def sectionsClickable(self) -> bool: ...
    def sectionsHidden(self) -> bool: ...
    def sectionsInserted(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], logicalFirst: int, logicalLast: int) -> None: ...
    def sectionsMovable(self) -> bool: ...
    def sectionsMoved(self) -> bool: ...
    def setCascadingSectionResizes(self, enable: bool) -> None: ...
    def setDefaultAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setDefaultSectionSize(self, size: int) -> None: ...
    def setFirstSectionMovable(self, movable: bool) -> None: ...
    def setHighlightSections(self, highlight: bool) -> None: ...
    def setMaximumSectionSize(self, size: int) -> None: ...
    def setMinimumSectionSize(self, size: int) -> None: ...
    def setModel(self, model: Optional[PySide6.QtCore.QAbstractItemModel]) -> None: ...
    def setOffset(self, offset: int) -> None: ...
    def setOffsetToLastSection(self) -> None: ...
    def setOffsetToSectionPosition(self, visualIndex: int) -> None: ...
    def setResizeContentsPrecision(self, precision: int) -> None: ...
    def setSectionHidden(self, logicalIndex: int, hide: bool) -> None: ...
    @overload
    def setSectionResizeMode(self, logicalIndex: int, mode: PySide6.QtWidgets.QHeaderView.ResizeMode) -> None: ...
    @overload
    def setSectionResizeMode(self, mode: PySide6.QtWidgets.QHeaderView.ResizeMode) -> None: ...
    def setSectionsClickable(self, clickable: bool) -> None: ...
    def setSectionsMovable(self, movable: bool) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, flags: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    def setSortIndicator(self, logicalIndex: int, order: PySide6.QtCore.Qt.SortOrder) -> None: ...
    def setSortIndicatorClearable(self, clearable: bool) -> None: ...
    def setSortIndicatorShown(self, show: bool) -> None: ...
    def setStretchLastSection(self, stretch: bool) -> None: ...
    def setVisible(self, v: bool) -> None: ...
    def showSection(self, logicalIndex: int) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def sortIndicatorOrder(self) -> PySide6.QtCore.Qt.SortOrder: ...
    def sortIndicatorSection(self) -> int: ...
    def stretchLastSection(self) -> bool: ...
    def stretchSectionCount(self) -> int: ...
    def swapSections(self, first: int, second: int) -> None: ...
    def updateGeometries(self) -> None: ...
    def updateSection(self, logicalIndex: int) -> None: ...
    def verticalOffset(self) -> int: ...
    def viewportEvent(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def visualIndex(self, logicalIndex: int) -> int: ...
    def visualIndexAt(self, position: int) -> int: ...
    def visualRect(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection) -> PySide6.QtGui.QRegion: ...


class QInputDialog(PySide6.QtWidgets.QDialog):

    doubleValueChanged       : ClassVar[Signal] = ... # doubleValueChanged(double)
    doubleValueSelected      : ClassVar[Signal] = ... # doubleValueSelected(double)
    intValueChanged          : ClassVar[Signal] = ... # intValueChanged(int)
    intValueSelected         : ClassVar[Signal] = ... # intValueSelected(int)
    textValueChanged         : ClassVar[Signal] = ... # textValueChanged(QString)
    textValueSelected        : ClassVar[Signal] = ... # textValueSelected(QString)

    class InputDialogOption(enum.Enum):

        NoButtons                : QInputDialog.InputDialogOption = ... # 0x1
        UseListViewForComboBoxItems: QInputDialog.InputDialogOption = ... # 0x2
        UsePlainTextEditForTextInput: QInputDialog.InputDialogOption = ... # 0x4

    class InputMode(enum.Enum):

        TextInput                : QInputDialog.InputMode = ... # 0x0
        IntInput                 : QInputDialog.InputMode = ... # 0x1
        DoubleInput              : QInputDialog.InputMode = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def cancelButtonText(self) -> str: ...
    def comboBoxItems(self) -> List[str]: ...
    def done(self, result: int) -> None: ...
    def doubleDecimals(self) -> int: ...
    def doubleMaximum(self) -> float: ...
    def doubleMinimum(self) -> float: ...
    def doubleStep(self) -> float: ...
    def doubleValue(self) -> float: ...
    @staticmethod
    def getDouble(parent: PySide6.QtWidgets.QWidget, title: str, label: str, value: float = ..., minValue: float = ..., maxValue: float = ..., decimals: int = ..., flags: PySide6.QtCore.Qt.WindowType = ..., step: float = ...) -> Tuple[float, bool]: ...
    @staticmethod
    def getInt(parent: PySide6.QtWidgets.QWidget, title: str, label: str, value: int = ..., minValue: int = ..., maxValue: int = ..., step: int = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> Tuple[int, bool]: ...
    @staticmethod
    def getItem(parent: PySide6.QtWidgets.QWidget, title: str, label: str, items: Sequence[str], current: int = ..., editable: bool = ..., flags: PySide6.QtCore.Qt.WindowType = ..., inputMethodHints: PySide6.QtCore.Qt.InputMethodHint = ...) -> Tuple[str, bool]: ...
    @staticmethod
    def getMultiLineText(parent: PySide6.QtWidgets.QWidget, title: str, label: str, text: str = ..., flags: PySide6.QtCore.Qt.WindowType = ..., inputMethodHints: PySide6.QtCore.Qt.InputMethodHint = ...) -> Tuple[str, bool]: ...
    @staticmethod
    def getText(parent: PySide6.QtWidgets.QWidget, title: str, label: str, echo: PySide6.QtWidgets.QLineEdit.EchoMode = ..., text: str = ..., flags: PySide6.QtCore.Qt.WindowType = ..., inputMethodHints: PySide6.QtCore.Qt.InputMethodHint = ...) -> Tuple[str, bool]: ...
    def inputMode(self) -> PySide6.QtWidgets.QInputDialog.InputMode: ...
    def intMaximum(self) -> int: ...
    def intMinimum(self) -> int: ...
    def intStep(self) -> int: ...
    def intValue(self) -> int: ...
    def isComboBoxEditable(self) -> bool: ...
    def labelText(self) -> str: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def okButtonText(self) -> str: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview]) -> None: ...
    def setCancelButtonText(self, text: str) -> None: ...
    def setComboBoxEditable(self, editable: bool) -> None: ...
    def setComboBoxItems(self, items: Sequence[str]) -> None: ...
    def setDoubleDecimals(self, decimals: int) -> None: ...
    def setDoubleMaximum(self, max: float) -> None: ...
    def setDoubleMinimum(self, min: float) -> None: ...
    def setDoubleRange(self, min: float, max: float) -> None: ...
    def setDoubleStep(self, step: float) -> None: ...
    def setDoubleValue(self, value: float) -> None: ...
    def setInputMode(self, mode: PySide6.QtWidgets.QInputDialog.InputMode) -> None: ...
    def setIntMaximum(self, max: int) -> None: ...
    def setIntMinimum(self, min: int) -> None: ...
    def setIntRange(self, min: int, max: int) -> None: ...
    def setIntStep(self, step: int) -> None: ...
    def setIntValue(self, value: int) -> None: ...
    def setLabelText(self, text: str) -> None: ...
    def setOkButtonText(self, text: str) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QInputDialog.InputDialogOption, on: bool = ...) -> None: ...
    def setTextEchoMode(self, mode: PySide6.QtWidgets.QLineEdit.EchoMode) -> None: ...
    def setTextValue(self, text: str) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def testOption(self, option: PySide6.QtWidgets.QInputDialog.InputDialogOption) -> bool: ...
    def textEchoMode(self) -> PySide6.QtWidgets.QLineEdit.EchoMode: ...
    def textValue(self) -> str: ...


class QIntList(object): ...


class QItemDelegate(PySide6.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def createEditor(self, parent: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QWidget: ...
    def decoration(self, option: PySide6.QtWidgets.QStyleOptionViewItem, variant: Any) -> PySide6.QtGui.QPixmap: ...
    def doCheck(self, option: PySide6.QtWidgets.QStyleOptionViewItem, bounding: PySide6.QtCore.QRect, variant: Any) -> PySide6.QtCore.QRect: ...
    def drawBackground(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def drawCheck(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, rect: PySide6.QtCore.QRect, state: PySide6.QtCore.Qt.CheckState) -> None: ...
    def drawDecoration(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, rect: PySide6.QtCore.QRect, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def drawDisplay(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, rect: PySide6.QtCore.QRect, text: str) -> None: ...
    def drawFocus(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, rect: PySide6.QtCore.QRect) -> None: ...
    def editorEvent(self, event: PySide6.QtCore.QEvent, model: PySide6.QtCore.QAbstractItemModel, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> bool: ...
    def hasClipping(self) -> bool: ...
    def itemEditorFactory(self) -> PySide6.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def rect(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], role: int) -> PySide6.QtCore.QRect: ...
    @staticmethod
    def selectedPixmap(pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], palette: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], enabled: bool) -> PySide6.QtGui.QPixmap: ...
    def setClipping(self, clip: bool) -> None: ...
    def setEditorData(self, editor: PySide6.QtWidgets.QWidget, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setItemEditorFactory(self, factory: PySide6.QtWidgets.QItemEditorFactory) -> None: ...
    def setModelData(self, editor: PySide6.QtWidgets.QWidget, model: PySide6.QtCore.QAbstractItemModel, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setOptions(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], option: PySide6.QtWidgets.QStyleOptionViewItem) -> PySide6.QtWidgets.QStyleOptionViewItem: ...
    def sizeHint(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QSize: ...
    def textRectangle(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, font: Union[PySide6.QtGui.QFont, str, Sequence[str]], text: str) -> PySide6.QtCore.QRect: ...
    def updateEditorGeometry(self, editor: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...


class QItemEditorCreatorBase(Shiboken.Object):

    def __init__(self) -> None: ...

    def createWidget(self, parent: PySide6.QtWidgets.QWidget) -> PySide6.QtWidgets.QWidget: ...
    def valuePropertyName(self) -> PySide6.QtCore.QByteArray: ...


class QItemEditorFactory(Shiboken.Object):

    def __init__(self) -> None: ...

    def createEditor(self, userType: int, parent: PySide6.QtWidgets.QWidget) -> PySide6.QtWidgets.QWidget: ...
    @staticmethod
    def defaultFactory() -> PySide6.QtWidgets.QItemEditorFactory: ...
    def registerEditor(self, userType: int, creator: PySide6.QtWidgets.QItemEditorCreatorBase) -> None: ...
    @staticmethod
    def setDefaultFactory(factory: PySide6.QtWidgets.QItemEditorFactory) -> None: ...
    def valuePropertyName(self, userType: int) -> PySide6.QtCore.QByteArray: ...


class QKeySequenceEdit(PySide6.QtWidgets.QWidget):

    editingFinished          : ClassVar[Signal] = ... # editingFinished()
    keySequenceChanged       : ClassVar[Signal] = ... # keySequenceChanged(QKeySequence)

    @overload
    def __init__(self, keySequence: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def clear(self) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def finishingKeyCombinations(self) -> List[PySide6.QtCore.QKeyCombination]: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def isClearButtonEnabled(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def keySequence(self) -> PySide6.QtGui.QKeySequence: ...
    def maximumSequenceLength(self) -> int: ...
    def setClearButtonEnabled(self, enable: bool) -> None: ...
    def setFinishingKeyCombinations(self, finishingKeyCombinations: Sequence[PySide6.QtCore.QKeyCombination]) -> None: ...
    def setKeySequence(self, keySequence: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> None: ...
    def setMaximumSequenceLength(self, count: int) -> None: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None: ...


class QLCDNumber(PySide6.QtWidgets.QFrame):

    overflow                 : ClassVar[Signal] = ... # overflow()

    class Mode(enum.Enum):

        Hex                      : QLCDNumber.Mode = ... # 0x0
        Dec                      : QLCDNumber.Mode = ... # 0x1
        Oct                      : QLCDNumber.Mode = ... # 0x2
        Bin                      : QLCDNumber.Mode = ... # 0x3

    class SegmentStyle(enum.Enum):

        Outline                  : QLCDNumber.SegmentStyle = ... # 0x0
        Filled                   : QLCDNumber.SegmentStyle = ... # 0x1
        Flat                     : QLCDNumber.SegmentStyle = ... # 0x2


    @overload
    def __init__(self, numDigits: int, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    @overload
    def checkOverflow(self, num: float) -> bool: ...
    @overload
    def checkOverflow(self, num: int) -> bool: ...
    def digitCount(self) -> int: ...
    @overload
    def display(self, num: float) -> None: ...
    @overload
    def display(self, num: int) -> None: ...
    @overload
    def display(self, str: str) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def intValue(self) -> int: ...
    def mode(self) -> PySide6.QtWidgets.QLCDNumber.Mode: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def segmentStyle(self) -> PySide6.QtWidgets.QLCDNumber.SegmentStyle: ...
    def setBinMode(self) -> None: ...
    def setDecMode(self) -> None: ...
    def setDigitCount(self, nDigits: int) -> None: ...
    def setHexMode(self) -> None: ...
    def setMode(self, arg__1: PySide6.QtWidgets.QLCDNumber.Mode) -> None: ...
    def setOctMode(self) -> None: ...
    def setSegmentStyle(self, arg__1: PySide6.QtWidgets.QLCDNumber.SegmentStyle) -> None: ...
    def setSmallDecimalPoint(self, arg__1: bool) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def smallDecimalPoint(self) -> bool: ...
    def value(self) -> float: ...


class QLabel(PySide6.QtWidgets.QFrame):

    linkActivated            : ClassVar[Signal] = ... # linkActivated(QString)
    linkHovered              : ClassVar[Signal] = ... # linkHovered(QString)

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def buddy(self) -> PySide6.QtWidgets.QWidget: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def contextMenuEvent(self, ev: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, ev: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: PySide6.QtGui.QFocusEvent) -> None: ...
    def hasScaledContents(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def indent(self) -> int: ...
    def keyPressEvent(self, ev: PySide6.QtGui.QKeyEvent) -> None: ...
    def margin(self) -> int: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: PySide6.QtGui.QMouseEvent) -> None: ...
    def movie(self) -> PySide6.QtGui.QMovie: ...
    def openExternalLinks(self) -> bool: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def picture(self) -> PySide6.QtGui.QPicture: ...
    def pixmap(self) -> PySide6.QtGui.QPixmap: ...
    def selectedText(self) -> str: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, arg__1: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setBuddy(self, arg__1: PySide6.QtWidgets.QWidget) -> None: ...
    def setIndent(self, arg__1: int) -> None: ...
    def setMargin(self, arg__1: int) -> None: ...
    def setMovie(self, movie: PySide6.QtGui.QMovie) -> None: ...
    @overload
    def setNum(self, arg__1: float) -> None: ...
    @overload
    def setNum(self, arg__1: int) -> None: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def setPicture(self, arg__1: Union[PySide6.QtGui.QPicture, int]) -> None: ...
    def setPixmap(self, arg__1: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def setScaledContents(self, arg__1: bool) -> None: ...
    def setSelection(self, arg__1: int, arg__2: int) -> None: ...
    def setText(self, arg__1: str) -> None: ...
    def setTextFormat(self, arg__1: PySide6.QtCore.Qt.TextFormat) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide6.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    def wordWrap(self) -> bool: ...


class QLayout(PySide6.QtCore.QObject, PySide6.QtWidgets.QLayoutItem):

    class SizeConstraint(enum.Enum):

        SetDefaultConstraint     : QLayout.SizeConstraint = ... # 0x0
        SetNoConstraint          : QLayout.SizeConstraint = ... # 0x1
        SetMinimumSize           : QLayout.SizeConstraint = ... # 0x2
        SetFixedSize             : QLayout.SizeConstraint = ... # 0x3
        SetMaximumSize           : QLayout.SizeConstraint = ... # 0x4
        SetMinAndMaxSize         : QLayout.SizeConstraint = ... # 0x5


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def activate(self) -> bool: ...
    def addChildLayout(self, l: PySide6.QtWidgets.QLayout) -> None: ...
    def addChildWidget(self, w: PySide6.QtWidgets.QWidget) -> None: ...
    def addItem(self, arg__1: PySide6.QtWidgets.QLayoutItem) -> None: ...
    def addWidget(self, w: PySide6.QtWidgets.QWidget) -> None: ...
    def adoptLayout(self, layout: PySide6.QtWidgets.QLayout) -> bool: ...
    def alignmentRect(self, arg__1: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def childEvent(self, e: PySide6.QtCore.QChildEvent) -> None: ...
    @staticmethod
    def closestAcceptableSize(w: PySide6.QtWidgets.QWidget, s: PySide6.QtCore.QSize) -> PySide6.QtCore.QSize: ...
    def contentsMargins(self) -> PySide6.QtCore.QMargins: ...
    def contentsRect(self) -> PySide6.QtCore.QRect: ...
    def controlTypes(self) -> PySide6.QtWidgets.QSizePolicy.ControlType: ...
    def count(self) -> int: ...
    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientation: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def getContentsMargins(self) -> object: ...
    @overload
    def indexOf(self, arg__1: PySide6.QtWidgets.QLayoutItem) -> int: ...
    @overload
    def indexOf(self, arg__1: PySide6.QtWidgets.QWidget) -> int: ...
    def invalidate(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def itemAt(self, index: int) -> PySide6.QtWidgets.QLayoutItem: ...
    def layout(self) -> PySide6.QtWidgets.QLayout: ...
    def maximumSize(self) -> PySide6.QtCore.QSize: ...
    def menuBar(self) -> PySide6.QtWidgets.QWidget: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def parentWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def removeItem(self, arg__1: PySide6.QtWidgets.QLayoutItem) -> None: ...
    def removeWidget(self, w: PySide6.QtWidgets.QWidget) -> None: ...
    def replaceWidget(self, from_: PySide6.QtWidgets.QWidget, to: PySide6.QtWidgets.QWidget, options: PySide6.QtCore.Qt.FindChildOption = ...) -> PySide6.QtWidgets.QLayoutItem: ...
    @overload
    def setAlignment(self, arg__1: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    @overload
    def setAlignment(self, l: PySide6.QtWidgets.QLayout, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> bool: ...
    @overload
    def setAlignment(self, w: PySide6.QtWidgets.QWidget, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> bool: ...
    @overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setContentsMargins(self, margins: PySide6.QtCore.QMargins) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    def setMenuBar(self, w: PySide6.QtWidgets.QWidget) -> None: ...
    def setSizeConstraint(self, arg__1: PySide6.QtWidgets.QLayout.SizeConstraint) -> None: ...
    def setSpacing(self, arg__1: int) -> None: ...
    def sizeConstraint(self) -> PySide6.QtWidgets.QLayout.SizeConstraint: ...
    def spacing(self) -> int: ...
    def takeAt(self, index: int) -> PySide6.QtWidgets.QLayoutItem: ...
    def totalHeightForWidth(self, w: int) -> int: ...
    def totalMaximumSize(self) -> PySide6.QtCore.QSize: ...
    def totalMinimumHeightForWidth(self, w: int) -> int: ...
    def totalMinimumSize(self) -> PySide6.QtCore.QSize: ...
    def totalSizeHint(self) -> PySide6.QtCore.QSize: ...
    def unsetContentsMargins(self) -> None: ...
    def update(self) -> None: ...
    def widgetEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...


class QLayoutItem(Shiboken.Object):

    def __init__(self, alignment: PySide6.QtCore.Qt.AlignmentFlag = ...) -> None: ...

    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def controlTypes(self) -> PySide6.QtWidgets.QSizePolicy.ControlType: ...
    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientation: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def invalidate(self) -> None: ...
    def isEmpty(self) -> bool: ...
    def layout(self) -> PySide6.QtWidgets.QLayout: ...
    def maximumSize(self) -> PySide6.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def setAlignment(self, a: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def spacerItem(self) -> PySide6.QtWidgets.QSpacerItem: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...


class QLineEdit(PySide6.QtWidgets.QWidget):

    cursorPositionChanged    : ClassVar[Signal] = ... # cursorPositionChanged(int,int)
    editingFinished          : ClassVar[Signal] = ... # editingFinished()
    inputRejected            : ClassVar[Signal] = ... # inputRejected()
    returnPressed            : ClassVar[Signal] = ... # returnPressed()
    selectionChanged         : ClassVar[Signal] = ... # selectionChanged()
    textChanged              : ClassVar[Signal] = ... # textChanged(QString)
    textEdited               : ClassVar[Signal] = ... # textEdited(QString)

    class ActionPosition(enum.Enum):

        LeadingPosition          : QLineEdit.ActionPosition = ... # 0x0
        TrailingPosition         : QLineEdit.ActionPosition = ... # 0x1

    class EchoMode(enum.Enum):

        Normal                   : QLineEdit.EchoMode = ... # 0x0
        NoEcho                   : QLineEdit.EchoMode = ... # 0x1
        Password                 : QLineEdit.EchoMode = ... # 0x2
        PasswordEchoOnEdit       : QLineEdit.EchoMode = ... # 0x3


    @overload
    def __init__(self, arg__1: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    @overload
    def addAction(self, action: PySide6.QtGui.QAction) -> None: ...
    @overload
    def addAction(self, action: PySide6.QtGui.QAction, position: PySide6.QtWidgets.QLineEdit.ActionPosition) -> None: ...
    @overload
    def addAction(self, arg__1: PySide6.QtGui.QAction) -> None: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], position: PySide6.QtWidgets.QLineEdit.ActionPosition) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def backspace(self) -> None: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def completer(self) -> PySide6.QtWidgets.QCompleter: ...
    def contextMenuEvent(self, arg__1: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def copy(self) -> None: ...
    def createStandardContextMenu(self) -> PySide6.QtWidgets.QMenu: ...
    def cursorBackward(self, mark: bool, steps: int = ...) -> None: ...
    def cursorForward(self, mark: bool, steps: int = ...) -> None: ...
    def cursorMoveStyle(self) -> PySide6.QtCore.Qt.CursorMoveStyle: ...
    def cursorPosition(self) -> int: ...
    def cursorPositionAt(self, pos: PySide6.QtCore.QPoint) -> int: ...
    def cursorRect(self) -> PySide6.QtCore.QRect: ...
    def cursorWordBackward(self, mark: bool) -> None: ...
    def cursorWordForward(self, mark: bool) -> None: ...
    def cut(self) -> None: ...
    def del_(self) -> None: ...
    def deselect(self) -> None: ...
    def displayText(self) -> str: ...
    def dragEnabled(self) -> bool: ...
    def dragEnterEvent(self, arg__1: PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, arg__1: PySide6.QtGui.QDropEvent) -> None: ...
    def echoMode(self) -> PySide6.QtWidgets.QLineEdit.EchoMode: ...
    def end(self, mark: bool) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def hasAcceptableInput(self) -> bool: ...
    def hasFrame(self) -> bool: ...
    def hasSelectedText(self) -> bool: ...
    def home(self, mark: bool) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionFrame) -> None: ...
    def inputMask(self) -> str: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None: ...
    @overload
    def inputMethodQuery(self, arg__1: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    @overload
    def inputMethodQuery(self, property: PySide6.QtCore.Qt.InputMethodQuery, argument: Any) -> Any: ...
    def insert(self, arg__1: str) -> None: ...
    def isClearButtonEnabled(self) -> bool: ...
    def isModified(self) -> bool: ...
    def isReadOnly(self) -> bool: ...
    def isRedoAvailable(self) -> bool: ...
    def isUndoAvailable(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def maxLength(self) -> int: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def paste(self) -> None: ...
    def placeholderText(self) -> str: ...
    def redo(self) -> None: ...
    def selectAll(self) -> None: ...
    def selectedText(self) -> str: ...
    def selectionEnd(self) -> int: ...
    def selectionLength(self) -> int: ...
    def selectionStart(self) -> int: ...
    def setAlignment(self, flag: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setClearButtonEnabled(self, enable: bool) -> None: ...
    def setCompleter(self, completer: PySide6.QtWidgets.QCompleter) -> None: ...
    def setCursorMoveStyle(self, style: PySide6.QtCore.Qt.CursorMoveStyle) -> None: ...
    def setCursorPosition(self, arg__1: int) -> None: ...
    def setDragEnabled(self, b: bool) -> None: ...
    def setEchoMode(self, arg__1: PySide6.QtWidgets.QLineEdit.EchoMode) -> None: ...
    def setFrame(self, arg__1: bool) -> None: ...
    def setInputMask(self, inputMask: str) -> None: ...
    def setMaxLength(self, arg__1: int) -> None: ...
    def setModified(self, arg__1: bool) -> None: ...
    def setPlaceholderText(self, arg__1: str) -> None: ...
    def setReadOnly(self, arg__1: bool) -> None: ...
    def setSelection(self, arg__1: int, arg__2: int) -> None: ...
    def setText(self, arg__1: str) -> None: ...
    @overload
    def setTextMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setTextMargins(self, margins: PySide6.QtCore.QMargins) -> None: ...
    def setValidator(self, arg__1: PySide6.QtGui.QValidator) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def text(self) -> str: ...
    def textMargins(self) -> PySide6.QtCore.QMargins: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None: ...
    def undo(self) -> None: ...
    def validator(self) -> PySide6.QtGui.QValidator: ...


class QListView(PySide6.QtWidgets.QAbstractItemView):

    indexesMoved             : ClassVar[Signal] = ... # indexesMoved(QModelIndexList)

    class Flow(enum.Enum):

        LeftToRight              : QListView.Flow = ... # 0x0
        TopToBottom              : QListView.Flow = ... # 0x1

    class LayoutMode(enum.Enum):

        SinglePass               : QListView.LayoutMode = ... # 0x0
        Batched                  : QListView.LayoutMode = ... # 0x1

    class Movement(enum.Enum):

        Static                   : QListView.Movement = ... # 0x0
        Free                     : QListView.Movement = ... # 0x1
        Snap                     : QListView.Movement = ... # 0x2

    class ResizeMode(enum.Enum):

        Fixed                    : QListView.ResizeMode = ... # 0x0
        Adjust                   : QListView.ResizeMode = ... # 0x1

    class ViewMode(enum.Enum):

        ListMode                 : QListView.ViewMode = ... # 0x0
        IconMode                 : QListView.ViewMode = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def batchSize(self) -> int: ...
    def clearPropertyFlags(self) -> None: ...
    def contentsSize(self) -> PySide6.QtCore.QSize: ...
    def currentChanged(self, current: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], previous: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def dataChanged(self, topLeft: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], bottomRight: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], roles: Sequence[int] = ...) -> None: ...
    def doItemsLayout(self) -> None: ...
    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e: PySide6.QtGui.QDropEvent) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def flow(self) -> PySide6.QtWidgets.QListView.Flow: ...
    def gridSize(self) -> PySide6.QtCore.QSize: ...
    def horizontalOffset(self) -> int: ...
    def indexAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QModelIndex: ...
    def initViewItemOption(self, option: PySide6.QtWidgets.QStyleOptionViewItem) -> None: ...
    def isIndexHidden(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def isRowHidden(self, row: int) -> bool: ...
    def isSelectionRectVisible(self) -> bool: ...
    def isWrapping(self) -> bool: ...
    def itemAlignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def layoutMode(self) -> PySide6.QtWidgets.QListView.LayoutMode: ...
    def modelColumn(self) -> int: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> PySide6.QtCore.QModelIndex: ...
    def movement(self) -> PySide6.QtWidgets.QListView.Movement: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def rectForIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QRect: ...
    def reset(self) -> None: ...
    def resizeContents(self, width: int, height: int) -> None: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent) -> None: ...
    def resizeMode(self) -> PySide6.QtWidgets.QListView.ResizeMode: ...
    def rowsAboutToBeRemoved(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], start: int, end: int) -> None: ...
    def rowsInserted(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], start: int, end: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedIndexes(self) -> List[PySide6.QtCore.QModelIndex]: ...
    def selectionChanged(self, selected: PySide6.QtCore.QItemSelection, deselected: PySide6.QtCore.QItemSelection) -> None: ...
    def setBatchSize(self, batchSize: int) -> None: ...
    def setFlow(self, flow: PySide6.QtWidgets.QListView.Flow) -> None: ...
    def setGridSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setItemAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setLayoutMode(self, mode: PySide6.QtWidgets.QListView.LayoutMode) -> None: ...
    def setModelColumn(self, column: int) -> None: ...
    def setMovement(self, movement: PySide6.QtWidgets.QListView.Movement) -> None: ...
    def setPositionForIndex(self, position: PySide6.QtCore.QPoint, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setResizeMode(self, mode: PySide6.QtWidgets.QListView.ResizeMode) -> None: ...
    def setRootIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setRowHidden(self, row: int, hide: bool) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    def setSelectionRectVisible(self, show: bool) -> None: ...
    def setSpacing(self, space: int) -> None: ...
    def setUniformItemSizes(self, enable: bool) -> None: ...
    def setViewMode(self, mode: PySide6.QtWidgets.QListView.ViewMode) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def setWrapping(self, enable: bool) -> None: ...
    def spacing(self) -> int: ...
    def startDrag(self, supportedActions: PySide6.QtCore.Qt.DropAction) -> None: ...
    def timerEvent(self, e: PySide6.QtCore.QTimerEvent) -> None: ...
    def uniformItemSizes(self) -> bool: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def viewMode(self) -> PySide6.QtWidgets.QListView.ViewMode: ...
    def viewportSizeHint(self) -> PySide6.QtCore.QSize: ...
    def visualRect(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection) -> PySide6.QtGui.QRegion: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent) -> None: ...
    def wordWrap(self) -> bool: ...


class QListWidget(PySide6.QtWidgets.QListView):

    currentItemChanged       : ClassVar[Signal] = ... # currentItemChanged(QListWidgetItem*,QListWidgetItem*)
    currentRowChanged        : ClassVar[Signal] = ... # currentRowChanged(int)
    currentTextChanged       : ClassVar[Signal] = ... # currentTextChanged(QString)
    itemActivated            : ClassVar[Signal] = ... # itemActivated(QListWidgetItem*)
    itemChanged              : ClassVar[Signal] = ... # itemChanged(QListWidgetItem*)
    itemClicked              : ClassVar[Signal] = ... # itemClicked(QListWidgetItem*)
    itemDoubleClicked        : ClassVar[Signal] = ... # itemDoubleClicked(QListWidgetItem*)
    itemEntered              : ClassVar[Signal] = ... # itemEntered(QListWidgetItem*)
    itemPressed              : ClassVar[Signal] = ... # itemPressed(QListWidgetItem*)
    itemSelectionChanged     : ClassVar[Signal] = ... # itemSelectionChanged()

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    @overload
    def addItem(self, item: PySide6.QtWidgets.QListWidgetItem) -> None: ...
    @overload
    def addItem(self, label: str) -> None: ...
    def addItems(self, labels: Sequence[str]) -> None: ...
    def clear(self) -> None: ...
    def closePersistentEditor(self, item: PySide6.QtWidgets.QListWidgetItem) -> None: ...
    def count(self) -> int: ...
    def currentItem(self) -> PySide6.QtWidgets.QListWidgetItem: ...
    def currentRow(self) -> int: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent) -> None: ...
    def dropMimeData(self, index: int, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: PySide6.QtWidgets.QListWidgetItem) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def findItems(self, text: str, flags: PySide6.QtCore.Qt.MatchFlag) -> List[PySide6.QtWidgets.QListWidgetItem]: ...
    def indexFromItem(self, item: PySide6.QtWidgets.QListWidgetItem) -> PySide6.QtCore.QModelIndex: ...
    @overload
    def insertItem(self, row: int, item: PySide6.QtWidgets.QListWidgetItem) -> None: ...
    @overload
    def insertItem(self, row: int, label: str) -> None: ...
    def insertItems(self, row: int, labels: Sequence[str]) -> None: ...
    def isPersistentEditorOpen(self, item: PySide6.QtWidgets.QListWidgetItem) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def item(self, row: int) -> PySide6.QtWidgets.QListWidgetItem: ...
    @overload
    def itemAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtWidgets.QListWidgetItem: ...
    @overload
    def itemAt(self, x: int, y: int) -> PySide6.QtWidgets.QListWidgetItem: ...
    def itemFromIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QListWidgetItem: ...
    def itemWidget(self, item: PySide6.QtWidgets.QListWidgetItem) -> PySide6.QtWidgets.QWidget: ...
    def items(self, data: PySide6.QtCore.QMimeData) -> List[PySide6.QtWidgets.QListWidgetItem]: ...
    def mimeData(self, items: Sequence[PySide6.QtWidgets.QListWidgetItem]) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> List[str]: ...
    def openPersistentEditor(self, item: PySide6.QtWidgets.QListWidgetItem) -> None: ...
    def removeItemWidget(self, item: PySide6.QtWidgets.QListWidgetItem) -> None: ...
    def row(self, item: PySide6.QtWidgets.QListWidgetItem) -> int: ...
    def scrollToItem(self, item: PySide6.QtWidgets.QListWidgetItem, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self) -> List[PySide6.QtWidgets.QListWidgetItem]: ...
    @overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QListWidgetItem) -> None: ...
    @overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QListWidgetItem, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    @overload
    def setCurrentRow(self, row: int) -> None: ...
    @overload
    def setCurrentRow(self, row: int, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    def setItemWidget(self, item: PySide6.QtWidgets.QListWidgetItem, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setModel(self, model: Optional[PySide6.QtCore.QAbstractItemModel]) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel) -> None: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def sortItems(self, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def takeItem(self, row: int) -> PySide6.QtWidgets.QListWidgetItem: ...
    def visualItemRect(self, item: PySide6.QtWidgets.QListWidgetItem) -> PySide6.QtCore.QRect: ...


class QListWidgetItem(Shiboken.Object):

    class ItemType(enum.IntEnum):

        Type                     : QListWidgetItem.ItemType = ... # 0x0
        UserType                 : QListWidgetItem.ItemType = ... # 0x3e8


    @overload
    def __init__(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, listview: Optional[PySide6.QtWidgets.QListWidget] = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, listview: Optional[PySide6.QtWidgets.QListWidget] = ..., type: int = ...) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QListWidgetItem) -> None: ...
    @overload
    def __init__(self, text: str, listview: Optional[PySide6.QtWidgets.QListWidget] = ..., type: int = ...) -> None: ...

    def __lshift__(self, out: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def background(self) -> PySide6.QtGui.QBrush: ...
    def checkState(self) -> PySide6.QtCore.Qt.CheckState: ...
    def clone(self) -> PySide6.QtWidgets.QListWidgetItem: ...
    def data(self, role: int) -> Any: ...
    def flags(self) -> PySide6.QtCore.Qt.ItemFlag: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def foreground(self) -> PySide6.QtGui.QBrush: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def isHidden(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def listWidget(self) -> PySide6.QtWidgets.QListWidget: ...
    def read(self, in_: PySide6.QtCore.QDataStream) -> None: ...
    def setBackground(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setCheckState(self, state: PySide6.QtCore.Qt.CheckState) -> None: ...
    def setData(self, role: int, value: Any) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.ItemFlag) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setForeground(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setHidden(self, hide: bool) -> None: ...
    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setSelected(self, select: bool) -> None: ...
    def setSizeHint(self, size: PySide6.QtCore.QSize) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    @overload
    def setTextAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    @overload
    def setTextAlignment(self, alignment: int) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setWhatsThis(self, whatsThis: str) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def statusTip(self) -> str: ...
    def text(self) -> str: ...
    def textAlignment(self) -> int: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide6.QtCore.QDataStream) -> None: ...


class QMainWindow(PySide6.QtWidgets.QWidget):

    iconSizeChanged          : ClassVar[Signal] = ... # iconSizeChanged(QSize)
    tabifiedDockWidgetActivated: ClassVar[Signal] = ... # tabifiedDockWidgetActivated(QDockWidget*)
    toolButtonStyleChanged   : ClassVar[Signal] = ... # toolButtonStyleChanged(Qt::ToolButtonStyle)

    class DockOption(enum.Flag):

        AnimatedDocks            : QMainWindow.DockOption = ... # 0x1
        AllowNestedDocks         : QMainWindow.DockOption = ... # 0x2
        AllowTabbedDocks         : QMainWindow.DockOption = ... # 0x4
        ForceTabbedDocks         : QMainWindow.DockOption = ... # 0x8
        VerticalTabs             : QMainWindow.DockOption = ... # 0x10
        GroupedDragging          : QMainWindow.DockOption = ... # 0x20


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    @overload
    def addDockWidget(self, area: PySide6.QtCore.Qt.DockWidgetArea, dockwidget: PySide6.QtWidgets.QDockWidget) -> None: ...
    @overload
    def addDockWidget(self, area: PySide6.QtCore.Qt.DockWidgetArea, dockwidget: PySide6.QtWidgets.QDockWidget, orientation: PySide6.QtCore.Qt.Orientation) -> None: ...
    @overload
    def addToolBar(self, area: PySide6.QtCore.Qt.ToolBarArea, toolbar: PySide6.QtWidgets.QToolBar) -> None: ...
    @overload
    def addToolBar(self, title: str) -> PySide6.QtWidgets.QToolBar: ...
    @overload
    def addToolBar(self, toolbar: PySide6.QtWidgets.QToolBar) -> None: ...
    def addToolBarBreak(self, area: PySide6.QtCore.Qt.ToolBarArea = ...) -> None: ...
    def centralWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def contextMenuEvent(self, event: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def corner(self, corner: PySide6.QtCore.Qt.Corner) -> PySide6.QtCore.Qt.DockWidgetArea: ...
    def createPopupMenu(self) -> PySide6.QtWidgets.QMenu: ...
    def dockOptions(self) -> PySide6.QtWidgets.QMainWindow.DockOption: ...
    def dockWidgetArea(self, dockwidget: PySide6.QtWidgets.QDockWidget) -> PySide6.QtCore.Qt.DockWidgetArea: ...
    def documentMode(self) -> bool: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def iconSize(self) -> PySide6.QtCore.QSize: ...
    def insertToolBar(self, before: PySide6.QtWidgets.QToolBar, toolbar: PySide6.QtWidgets.QToolBar) -> None: ...
    def insertToolBarBreak(self, before: PySide6.QtWidgets.QToolBar) -> None: ...
    def isAnimated(self) -> bool: ...
    def isDockNestingEnabled(self) -> bool: ...
    def isSeparator(self, pos: PySide6.QtCore.QPoint) -> bool: ...
    def menuBar(self) -> PySide6.QtWidgets.QMenuBar: ...
    def menuWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def removeDockWidget(self, dockwidget: PySide6.QtWidgets.QDockWidget) -> None: ...
    def removeToolBar(self, toolbar: PySide6.QtWidgets.QToolBar) -> None: ...
    def removeToolBarBreak(self, before: PySide6.QtWidgets.QToolBar) -> None: ...
    def resizeDocks(self, docks: Sequence[PySide6.QtWidgets.QDockWidget], sizes: Sequence[int], orientation: PySide6.QtCore.Qt.Orientation) -> None: ...
    def restoreDockWidget(self, dockwidget: PySide6.QtWidgets.QDockWidget) -> bool: ...
    def restoreState(self, state: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], version: int = ...) -> bool: ...
    def saveState(self, version: int = ...) -> PySide6.QtCore.QByteArray: ...
    def setAnimated(self, enabled: bool) -> None: ...
    def setCentralWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setCorner(self, corner: PySide6.QtCore.Qt.Corner, area: PySide6.QtCore.Qt.DockWidgetArea) -> None: ...
    def setDockNestingEnabled(self, enabled: bool) -> None: ...
    def setDockOptions(self, options: PySide6.QtWidgets.QMainWindow.DockOption) -> None: ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def setIconSize(self, iconSize: PySide6.QtCore.QSize) -> None: ...
    def setMenuBar(self, menubar: PySide6.QtWidgets.QMenuBar) -> None: ...
    def setMenuWidget(self, menubar: PySide6.QtWidgets.QWidget) -> None: ...
    def setStatusBar(self, statusbar: PySide6.QtWidgets.QStatusBar) -> None: ...
    def setTabPosition(self, areas: PySide6.QtCore.Qt.DockWidgetArea, tabPosition: PySide6.QtWidgets.QTabWidget.TabPosition) -> None: ...
    def setTabShape(self, tabShape: PySide6.QtWidgets.QTabWidget.TabShape) -> None: ...
    def setToolButtonStyle(self, toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle) -> None: ...
    def setUnifiedTitleAndToolBarOnMac(self, set: bool) -> None: ...
    def splitDockWidget(self, after: PySide6.QtWidgets.QDockWidget, dockwidget: PySide6.QtWidgets.QDockWidget, orientation: PySide6.QtCore.Qt.Orientation) -> None: ...
    def statusBar(self) -> PySide6.QtWidgets.QStatusBar: ...
    def tabPosition(self, area: PySide6.QtCore.Qt.DockWidgetArea) -> PySide6.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self) -> PySide6.QtWidgets.QTabWidget.TabShape: ...
    def tabifiedDockWidgets(self, dockwidget: PySide6.QtWidgets.QDockWidget) -> List[PySide6.QtWidgets.QDockWidget]: ...
    def tabifyDockWidget(self, first: PySide6.QtWidgets.QDockWidget, second: PySide6.QtWidgets.QDockWidget) -> None: ...
    def takeCentralWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def toolBarArea(self, toolbar: PySide6.QtWidgets.QToolBar) -> PySide6.QtCore.Qt.ToolBarArea: ...
    def toolBarBreak(self, toolbar: PySide6.QtWidgets.QToolBar) -> bool: ...
    def toolButtonStyle(self) -> PySide6.QtCore.Qt.ToolButtonStyle: ...
    def unifiedTitleAndToolBarOnMac(self) -> bool: ...


class QMdiArea(PySide6.QtWidgets.QAbstractScrollArea):

    subWindowActivated       : ClassVar[Signal] = ... # subWindowActivated(QMdiSubWindow*)

    class AreaOption(enum.Flag):

        DontMaximizeSubWindowOnActivation: QMdiArea.AreaOption = ... # 0x1

    class ViewMode(enum.Enum):

        SubWindowView            : QMdiArea.ViewMode = ... # 0x0
        TabbedView               : QMdiArea.ViewMode = ... # 0x1

    class WindowOrder(enum.Enum):

        CreationOrder            : QMdiArea.WindowOrder = ... # 0x0
        StackingOrder            : QMdiArea.WindowOrder = ... # 0x1
        ActivationHistoryOrder   : QMdiArea.WindowOrder = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def activateNextSubWindow(self) -> None: ...
    def activatePreviousSubWindow(self) -> None: ...
    def activationOrder(self) -> PySide6.QtWidgets.QMdiArea.WindowOrder: ...
    def activeSubWindow(self) -> PySide6.QtWidgets.QMdiSubWindow: ...
    def addSubWindow(self, widget: PySide6.QtWidgets.QWidget, flags: PySide6.QtCore.Qt.WindowType = ...) -> PySide6.QtWidgets.QMdiSubWindow: ...
    def background(self) -> PySide6.QtGui.QBrush: ...
    def cascadeSubWindows(self) -> None: ...
    def childEvent(self, childEvent: PySide6.QtCore.QChildEvent) -> None: ...
    def closeActiveSubWindow(self) -> None: ...
    def closeAllSubWindows(self) -> None: ...
    def currentSubWindow(self) -> PySide6.QtWidgets.QMdiSubWindow: ...
    def documentMode(self) -> bool: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> bool: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def paintEvent(self, paintEvent: PySide6.QtGui.QPaintEvent) -> None: ...
    def removeSubWindow(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def resizeEvent(self, resizeEvent: PySide6.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setActivationOrder(self, order: PySide6.QtWidgets.QMdiArea.WindowOrder) -> None: ...
    def setActiveSubWindow(self, window: PySide6.QtWidgets.QMdiSubWindow) -> None: ...
    def setBackground(self, background: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setDocumentMode(self, enabled: bool) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QMdiArea.AreaOption, on: bool = ...) -> None: ...
    def setTabPosition(self, position: PySide6.QtWidgets.QTabWidget.TabPosition) -> None: ...
    def setTabShape(self, shape: PySide6.QtWidgets.QTabWidget.TabShape) -> None: ...
    def setTabsClosable(self, closable: bool) -> None: ...
    def setTabsMovable(self, movable: bool) -> None: ...
    def setViewMode(self, mode: PySide6.QtWidgets.QMdiArea.ViewMode) -> None: ...
    def setupViewport(self, viewport: PySide6.QtWidgets.QWidget) -> None: ...
    def showEvent(self, showEvent: PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def subWindowList(self, order: PySide6.QtWidgets.QMdiArea.WindowOrder = ...) -> List[PySide6.QtWidgets.QMdiSubWindow]: ...
    def tabPosition(self) -> PySide6.QtWidgets.QTabWidget.TabPosition: ...
    def tabShape(self) -> PySide6.QtWidgets.QTabWidget.TabShape: ...
    def tabsClosable(self) -> bool: ...
    def tabsMovable(self) -> bool: ...
    def testOption(self, opton: PySide6.QtWidgets.QMdiArea.AreaOption) -> bool: ...
    def tileSubWindows(self) -> None: ...
    def timerEvent(self, timerEvent: PySide6.QtCore.QTimerEvent) -> None: ...
    def viewMode(self) -> PySide6.QtWidgets.QMdiArea.ViewMode: ...
    def viewportEvent(self, event: PySide6.QtCore.QEvent) -> bool: ...


class QMdiSubWindow(PySide6.QtWidgets.QWidget):

    aboutToActivate          : ClassVar[Signal] = ... # aboutToActivate()
    windowStateChanged       : ClassVar[Signal] = ... # windowStateChanged(Qt::WindowStates,Qt::WindowStates)

    class SubWindowOption(enum.Flag):

        AllowOutsideAreaHorizontally: QMdiSubWindow.SubWindowOption = ... # 0x1
        AllowOutsideAreaVertically: QMdiSubWindow.SubWindowOption = ... # 0x2
        RubberBandResize         : QMdiSubWindow.SubWindowOption = ... # 0x4
        RubberBandMove           : QMdiSubWindow.SubWindowOption = ... # 0x8


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def changeEvent(self, changeEvent: PySide6.QtCore.QEvent) -> None: ...
    def childEvent(self, childEvent: PySide6.QtCore.QChildEvent) -> None: ...
    def closeEvent(self, closeEvent: PySide6.QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, contextMenuEvent: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, focusInEvent: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, focusOutEvent: PySide6.QtGui.QFocusEvent) -> None: ...
    def hideEvent(self, hideEvent: PySide6.QtGui.QHideEvent) -> None: ...
    def isShaded(self) -> bool: ...
    def keyPressEvent(self, keyEvent: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyboardPageStep(self) -> int: ...
    def keyboardSingleStep(self) -> int: ...
    def leaveEvent(self, leaveEvent: PySide6.QtCore.QEvent) -> None: ...
    def maximizedButtonsWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def maximizedSystemMenuIconWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def mdiArea(self) -> PySide6.QtWidgets.QMdiArea: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveEvent(self, moveEvent: PySide6.QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, paintEvent: PySide6.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, resizeEvent: PySide6.QtGui.QResizeEvent) -> None: ...
    def setKeyboardPageStep(self, step: int) -> None: ...
    def setKeyboardSingleStep(self, step: int) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QMdiSubWindow.SubWindowOption, on: bool = ...) -> None: ...
    def setSystemMenu(self, systemMenu: PySide6.QtWidgets.QMenu) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def showEvent(self, showEvent: PySide6.QtGui.QShowEvent) -> None: ...
    def showShaded(self) -> None: ...
    def showSystemMenu(self) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def systemMenu(self) -> PySide6.QtWidgets.QMenu: ...
    def testOption(self, arg__1: PySide6.QtWidgets.QMdiSubWindow.SubWindowOption) -> bool: ...
    def timerEvent(self, timerEvent: PySide6.QtCore.QTimerEvent) -> None: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...


class QMenu(PySide6.QtWidgets.QWidget):

    aboutToHide              : ClassVar[Signal] = ... # aboutToHide()
    aboutToShow              : ClassVar[Signal] = ... # aboutToShow()
    hovered                  : ClassVar[Signal] = ... # hovered(QAction*)
    triggered                : ClassVar[Signal] = ... # triggered(QAction*)

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, title: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def actionAt(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtGui.QAction: ...
    def actionEvent(self, arg__1: PySide6.QtGui.QActionEvent) -> None: ...
    def actionGeometry(self, arg__1: PySide6.QtGui.QAction) -> PySide6.QtCore.QRect: ...
    def activeAction(self) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, action: PySide6.QtGui.QAction) -> None: ...
    @overload
    def addAction(self, arg__1: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, arg__3: object, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int, NoneType] = ...) -> None: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, arg__2: object, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int, NoneType] = ...) -> None: ...
    @overload
    def addAction(self, text: str, callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addMenu(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], title: str) -> PySide6.QtWidgets.QMenu: ...
    @overload
    def addMenu(self, menu: PySide6.QtWidgets.QMenu) -> PySide6.QtGui.QAction: ...
    @overload
    def addMenu(self, title: str) -> PySide6.QtWidgets.QMenu: ...
    @overload
    def addSection(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> PySide6.QtGui.QAction: ...
    @overload
    def addSection(self, text: str) -> PySide6.QtGui.QAction: ...
    def addSeparator(self) -> PySide6.QtGui.QAction: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def columnCount(self) -> int: ...
    def defaultAction(self) -> PySide6.QtGui.QAction: ...
    def enterEvent(self, arg__1: PySide6.QtGui.QEnterEvent) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    @overload
    @staticmethod
    def exec(actions: Sequence[PySide6.QtGui.QAction], pos: PySide6.QtCore.QPoint, at: Optional[PySide6.QtGui.QAction] = ..., parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def exec(self) -> PySide6.QtGui.QAction: ...
    @overload
    def exec(self, pos: PySide6.QtCore.QPoint, at: Optional[PySide6.QtGui.QAction] = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def exec_(self) -> PySide6.QtGui.QAction: ...
    @overload
    def exec_(self, arg__1: PySide6.QtCore.QPoint, action: Optional[PySide6.QtGui.QAction] = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def exec_(self, arg__1: Sequence[PySide6.QtGui.QAction], arg__2: PySide6.QtCore.QPoint, at: Optional[PySide6.QtGui.QAction] = ..., parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtGui.QAction: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None: ...
    def hideTearOffMenu(self) -> None: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionMenuItem, action: PySide6.QtGui.QAction) -> None: ...
    def insertMenu(self, before: PySide6.QtGui.QAction, menu: PySide6.QtWidgets.QMenu) -> PySide6.QtGui.QAction: ...
    @overload
    def insertSection(self, before: PySide6.QtGui.QAction, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> PySide6.QtGui.QAction: ...
    @overload
    def insertSection(self, before: PySide6.QtGui.QAction, text: str) -> PySide6.QtGui.QAction: ...
    def insertSeparator(self, before: PySide6.QtGui.QAction) -> PySide6.QtGui.QAction: ...
    def isEmpty(self) -> bool: ...
    def isTearOffEnabled(self) -> bool: ...
    def isTearOffMenuVisible(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def leaveEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def menuAction(self) -> PySide6.QtGui.QAction: ...
    @staticmethod
    def menuInAction(action: PySide6.QtGui.QAction) -> PySide6.QtWidgets.QMenu: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def popup(self, pos: PySide6.QtCore.QPoint, at: Optional[PySide6.QtGui.QAction] = ...) -> None: ...
    def separatorsCollapsible(self) -> bool: ...
    def setActiveAction(self, act: PySide6.QtGui.QAction) -> None: ...
    def setDefaultAction(self, arg__1: PySide6.QtGui.QAction) -> None: ...
    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setSeparatorsCollapsible(self, collapse: bool) -> None: ...
    def setTearOffEnabled(self, arg__1: bool) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def setToolTipsVisible(self, visible: bool) -> None: ...
    @overload
    def showTearOffMenu(self) -> None: ...
    @overload
    def showTearOffMenu(self, pos: PySide6.QtCore.QPoint) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None: ...
    def title(self) -> str: ...
    def toolTipsVisible(self) -> bool: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent) -> None: ...


class QMenuBar(PySide6.QtWidgets.QWidget):

    hovered                  : ClassVar[Signal] = ... # hovered(QAction*)
    triggered                : ClassVar[Signal] = ... # triggered(QAction*)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def actionAt(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtGui.QAction: ...
    def actionEvent(self, arg__1: PySide6.QtGui.QActionEvent) -> None: ...
    def actionGeometry(self, arg__1: PySide6.QtGui.QAction) -> PySide6.QtCore.QRect: ...
    def activeAction(self) -> PySide6.QtGui.QAction: ...
    @overload
    def addMenu(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], title: str) -> PySide6.QtWidgets.QMenu: ...
    @overload
    def addMenu(self, menu: PySide6.QtWidgets.QMenu) -> PySide6.QtGui.QAction: ...
    @overload
    def addMenu(self, title: str) -> PySide6.QtWidgets.QMenu: ...
    def addSeparator(self) -> PySide6.QtGui.QAction: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def cornerWidget(self, corner: PySide6.QtCore.Qt.Corner = ...) -> PySide6.QtWidgets.QWidget: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionMenuItem, action: PySide6.QtGui.QAction) -> None: ...
    def insertMenu(self, before: PySide6.QtGui.QAction, menu: PySide6.QtWidgets.QMenu) -> PySide6.QtGui.QAction: ...
    def insertSeparator(self, before: PySide6.QtGui.QAction) -> PySide6.QtGui.QAction: ...
    def isDefaultUp(self) -> bool: ...
    def isNativeMenuBar(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def leaveEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def setActiveAction(self, action: PySide6.QtGui.QAction) -> None: ...
    def setCornerWidget(self, w: PySide6.QtWidgets.QWidget, corner: PySide6.QtCore.Qt.Corner = ...) -> None: ...
    def setDefaultUp(self, arg__1: bool) -> None: ...
    def setNativeMenuBar(self, nativeMenuBar: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None: ...


class QMessageBox(PySide6.QtWidgets.QDialog):

    buttonClicked            : ClassVar[Signal] = ... # buttonClicked(QAbstractButton*)

    class ButtonRole(enum.Enum):

        InvalidRole              : QMessageBox.ButtonRole = ... # -0x1
        AcceptRole               : QMessageBox.ButtonRole = ... # 0x0
        RejectRole               : QMessageBox.ButtonRole = ... # 0x1
        DestructiveRole          : QMessageBox.ButtonRole = ... # 0x2
        ActionRole               : QMessageBox.ButtonRole = ... # 0x3
        HelpRole                 : QMessageBox.ButtonRole = ... # 0x4
        YesRole                  : QMessageBox.ButtonRole = ... # 0x5
        NoRole                   : QMessageBox.ButtonRole = ... # 0x6
        ResetRole                : QMessageBox.ButtonRole = ... # 0x7
        ApplyRole                : QMessageBox.ButtonRole = ... # 0x8
        NRoles                   : QMessageBox.ButtonRole = ... # 0x9

    class Icon(enum.Enum):

        NoIcon                   : QMessageBox.Icon = ... # 0x0
        Information              : QMessageBox.Icon = ... # 0x1
        Warning                  : QMessageBox.Icon = ... # 0x2
        Critical                 : QMessageBox.Icon = ... # 0x3
        Question                 : QMessageBox.Icon = ... # 0x4

    class Option(enum.Flag):

        DontUseNativeDialog      : QMessageBox.Option = ... # 0x1

    class StandardButton(enum.IntFlag):

        ButtonMask               : QMessageBox.StandardButton = ... # -0x301
        NoButton                 : QMessageBox.StandardButton = ... # 0x0
        Default                  : QMessageBox.StandardButton = ... # 0x100
        Escape                   : QMessageBox.StandardButton = ... # 0x200
        FlagMask                 : QMessageBox.StandardButton = ... # 0x300
        FirstButton              : QMessageBox.StandardButton = ... # 0x400
        Ok                       : QMessageBox.StandardButton = ... # 0x400
        Save                     : QMessageBox.StandardButton = ... # 0x800
        SaveAll                  : QMessageBox.StandardButton = ... # 0x1000
        Open                     : QMessageBox.StandardButton = ... # 0x2000
        Yes                      : QMessageBox.StandardButton = ... # 0x4000
        YesAll                   : QMessageBox.StandardButton = ... # 0x8000
        YesToAll                 : QMessageBox.StandardButton = ... # 0x8000
        No                       : QMessageBox.StandardButton = ... # 0x10000
        NoAll                    : QMessageBox.StandardButton = ... # 0x20000
        NoToAll                  : QMessageBox.StandardButton = ... # 0x20000
        Abort                    : QMessageBox.StandardButton = ... # 0x40000
        Retry                    : QMessageBox.StandardButton = ... # 0x80000
        Ignore                   : QMessageBox.StandardButton = ... # 0x100000
        Close                    : QMessageBox.StandardButton = ... # 0x200000
        Cancel                   : QMessageBox.StandardButton = ... # 0x400000
        Discard                  : QMessageBox.StandardButton = ... # 0x800000
        Help                     : QMessageBox.StandardButton = ... # 0x1000000
        Apply                    : QMessageBox.StandardButton = ... # 0x2000000
        Reset                    : QMessageBox.StandardButton = ... # 0x4000000
        LastButton               : QMessageBox.StandardButton = ... # 0x8000000
        RestoreDefaults          : QMessageBox.StandardButton = ... # 0x8000000


    @overload
    def __init__(self, icon: PySide6.QtWidgets.QMessageBox.Icon, title: str, text: str, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    @staticmethod
    def about(parent: PySide6.QtWidgets.QWidget, title: str, text: str) -> None: ...
    @staticmethod
    def aboutQt(parent: PySide6.QtWidgets.QWidget, title: str = ...) -> None: ...
    @overload
    def addButton(self, button: PySide6.QtWidgets.QAbstractButton, role: PySide6.QtWidgets.QMessageBox.ButtonRole) -> None: ...
    @overload
    def addButton(self, button: PySide6.QtWidgets.QMessageBox.StandardButton) -> PySide6.QtWidgets.QPushButton: ...
    @overload
    def addButton(self, text: str, role: PySide6.QtWidgets.QMessageBox.ButtonRole) -> PySide6.QtWidgets.QPushButton: ...
    def button(self, which: PySide6.QtWidgets.QMessageBox.StandardButton) -> PySide6.QtWidgets.QAbstractButton: ...
    def buttonRole(self, button: PySide6.QtWidgets.QAbstractButton) -> PySide6.QtWidgets.QMessageBox.ButtonRole: ...
    def buttonText(self, button: int) -> str: ...
    def buttons(self) -> List[PySide6.QtWidgets.QAbstractButton]: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def checkBox(self) -> PySide6.QtWidgets.QCheckBox: ...
    def clickedButton(self) -> PySide6.QtWidgets.QAbstractButton: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent) -> None: ...
    @overload
    @staticmethod
    def critical(parent: PySide6.QtWidgets.QWidget, title: str, text: str, button0: PySide6.QtWidgets.QMessageBox.StandardButton, button1: PySide6.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @overload
    @staticmethod
    def critical(parent: PySide6.QtWidgets.QWidget, title: str, text: str, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., defaultButton: PySide6.QtWidgets.QMessageBox.StandardButton = ...) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    def defaultButton(self) -> PySide6.QtWidgets.QPushButton: ...
    def detailedText(self) -> str: ...
    def escapeButton(self) -> PySide6.QtWidgets.QAbstractButton: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def icon(self) -> PySide6.QtWidgets.QMessageBox.Icon: ...
    def iconPixmap(self) -> PySide6.QtGui.QPixmap: ...
    @overload
    @staticmethod
    def information(parent: PySide6.QtWidgets.QWidget, title: str, text: str, button0: PySide6.QtWidgets.QMessageBox.StandardButton, button1: PySide6.QtWidgets.QMessageBox.StandardButton = ...) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    @overload
    @staticmethod
    def information(parent: PySide6.QtWidgets.QWidget, title: str, text: str, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., defaultButton: PySide6.QtWidgets.QMessageBox.StandardButton = ...) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    def informativeText(self) -> str: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview]) -> None: ...
    def options(self) -> PySide6.QtWidgets.QMessageBox.Option: ...
    @overload
    @staticmethod
    def question(parent: PySide6.QtWidgets.QWidget, title: str, text: str, button0: PySide6.QtWidgets.QMessageBox.StandardButton, button1: PySide6.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @overload
    @staticmethod
    def question(parent: PySide6.QtWidgets.QWidget, title: str, text: str, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., defaultButton: PySide6.QtWidgets.QMessageBox.StandardButton = ...) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    def removeButton(self, button: PySide6.QtWidgets.QAbstractButton) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def setButtonText(self, button: int, text: str) -> None: ...
    def setCheckBox(self, cb: PySide6.QtWidgets.QCheckBox) -> None: ...
    @overload
    def setDefaultButton(self, button: PySide6.QtWidgets.QMessageBox.StandardButton) -> None: ...
    @overload
    def setDefaultButton(self, button: PySide6.QtWidgets.QPushButton) -> None: ...
    def setDetailedText(self, text: str) -> None: ...
    @overload
    def setEscapeButton(self, button: PySide6.QtWidgets.QAbstractButton) -> None: ...
    @overload
    def setEscapeButton(self, button: PySide6.QtWidgets.QMessageBox.StandardButton) -> None: ...
    def setIcon(self, arg__1: PySide6.QtWidgets.QMessageBox.Icon) -> None: ...
    def setIconPixmap(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def setInformativeText(self, text: str) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QMessageBox.Option, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QMessageBox.Option) -> None: ...
    def setStandardButtons(self, buttons: PySide6.QtWidgets.QMessageBox.StandardButton) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextFormat(self, format: PySide6.QtCore.Qt.TextFormat) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag) -> None: ...
    def setWindowModality(self, windowModality: PySide6.QtCore.Qt.WindowModality) -> None: ...
    def setWindowTitle(self, title: str) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None: ...
    def standardButton(self, button: PySide6.QtWidgets.QAbstractButton) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    def standardButtons(self) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...
    @staticmethod
    def standardIcon(icon: PySide6.QtWidgets.QMessageBox.Icon) -> PySide6.QtGui.QPixmap: ...
    def testOption(self, option: PySide6.QtWidgets.QMessageBox.Option) -> bool: ...
    def text(self) -> str: ...
    def textFormat(self) -> PySide6.QtCore.Qt.TextFormat: ...
    def textInteractionFlags(self) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    @overload
    @staticmethod
    def warning(parent: PySide6.QtWidgets.QWidget, title: str, text: str, button0: PySide6.QtWidgets.QMessageBox.StandardButton, button1: PySide6.QtWidgets.QMessageBox.StandardButton) -> int: ...
    @overload
    @staticmethod
    def warning(parent: PySide6.QtWidgets.QWidget, title: str, text: str, buttons: PySide6.QtWidgets.QMessageBox.StandardButton = ..., defaultButton: PySide6.QtWidgets.QMessageBox.StandardButton = ...) -> PySide6.QtWidgets.QMessageBox.StandardButton: ...


class QPanGesture(PySide6.QtWidgets.QGesture):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def acceleration(self) -> float: ...
    def delta(self) -> PySide6.QtCore.QPointF: ...
    def lastOffset(self) -> PySide6.QtCore.QPointF: ...
    def offset(self) -> PySide6.QtCore.QPointF: ...
    def setAcceleration(self, value: float) -> None: ...
    def setLastOffset(self, value: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setOffset(self, value: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...


class QPinchGesture(PySide6.QtWidgets.QGesture):

    class ChangeFlag(enum.Flag):

        ScaleFactorChanged       : QPinchGesture.ChangeFlag = ... # 0x1
        RotationAngleChanged     : QPinchGesture.ChangeFlag = ... # 0x2
        CenterPointChanged       : QPinchGesture.ChangeFlag = ... # 0x4


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def centerPoint(self) -> PySide6.QtCore.QPointF: ...
    def changeFlags(self) -> PySide6.QtWidgets.QPinchGesture.ChangeFlag: ...
    def lastCenterPoint(self) -> PySide6.QtCore.QPointF: ...
    def lastRotationAngle(self) -> float: ...
    def lastScaleFactor(self) -> float: ...
    def rotationAngle(self) -> float: ...
    def scaleFactor(self) -> float: ...
    def setCenterPoint(self, value: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setChangeFlags(self, value: PySide6.QtWidgets.QPinchGesture.ChangeFlag) -> None: ...
    def setLastCenterPoint(self, value: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setLastRotationAngle(self, value: float) -> None: ...
    def setLastScaleFactor(self, value: float) -> None: ...
    def setRotationAngle(self, value: float) -> None: ...
    def setScaleFactor(self, value: float) -> None: ...
    def setStartCenterPoint(self, value: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    def setTotalChangeFlags(self, value: PySide6.QtWidgets.QPinchGesture.ChangeFlag) -> None: ...
    def setTotalRotationAngle(self, value: float) -> None: ...
    def setTotalScaleFactor(self, value: float) -> None: ...
    def startCenterPoint(self) -> PySide6.QtCore.QPointF: ...
    def totalChangeFlags(self) -> PySide6.QtWidgets.QPinchGesture.ChangeFlag: ...
    def totalRotationAngle(self) -> float: ...
    def totalScaleFactor(self) -> float: ...


class QPlainTextDocumentLayout(PySide6.QtGui.QAbstractTextDocumentLayout):

    def __init__(self, document: PySide6.QtGui.QTextDocument) -> None: ...

    def blockBoundingRect(self, block: PySide6.QtGui.QTextBlock) -> PySide6.QtCore.QRectF: ...
    def cursorWidth(self) -> int: ...
    def documentChanged(self, from_: int, arg__2: int, charsAdded: int) -> None: ...
    def documentSize(self) -> PySide6.QtCore.QSizeF: ...
    def draw(self, arg__1: PySide6.QtGui.QPainter, arg__2: PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext) -> None: ...
    def ensureBlockLayout(self, block: PySide6.QtGui.QTextBlock) -> None: ...
    def frameBoundingRect(self, arg__1: PySide6.QtGui.QTextFrame) -> PySide6.QtCore.QRectF: ...
    def hitTest(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], arg__2: PySide6.QtCore.Qt.HitTestAccuracy) -> int: ...
    def pageCount(self) -> int: ...
    def requestUpdate(self) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...


class QPlainTextEdit(PySide6.QtWidgets.QAbstractScrollArea):

    blockCountChanged        : ClassVar[Signal] = ... # blockCountChanged(int)
    copyAvailable            : ClassVar[Signal] = ... # copyAvailable(bool)
    cursorPositionChanged    : ClassVar[Signal] = ... # cursorPositionChanged()
    modificationChanged      : ClassVar[Signal] = ... # modificationChanged(bool)
    redoAvailable            : ClassVar[Signal] = ... # redoAvailable(bool)
    selectionChanged         : ClassVar[Signal] = ... # selectionChanged()
    textChanged              : ClassVar[Signal] = ... # textChanged()
    undoAvailable            : ClassVar[Signal] = ... # undoAvailable(bool)
    updateRequest            : ClassVar[Signal] = ... # updateRequest(QRect,int)

    class LineWrapMode(enum.Enum):

        NoWrap                   : QPlainTextEdit.LineWrapMode = ... # 0x0
        WidgetWidth              : QPlainTextEdit.LineWrapMode = ... # 0x1


    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def anchorAt(self, pos: PySide6.QtCore.QPoint) -> str: ...
    def appendHtml(self, html: str) -> None: ...
    def appendPlainText(self, text: str) -> None: ...
    def backgroundVisible(self) -> bool: ...
    def blockBoundingGeometry(self, block: PySide6.QtGui.QTextBlock) -> PySide6.QtCore.QRectF: ...
    def blockBoundingRect(self, block: PySide6.QtGui.QTextBlock) -> PySide6.QtCore.QRectF: ...
    def blockCount(self) -> int: ...
    def canInsertFromMimeData(self, source: PySide6.QtCore.QMimeData) -> bool: ...
    def canPaste(self) -> bool: ...
    def centerCursor(self) -> None: ...
    def centerOnScroll(self) -> bool: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def contentOffset(self) -> PySide6.QtCore.QPointF: ...
    def contextMenuEvent(self, e: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def copy(self) -> None: ...
    def createMimeDataFromSelection(self) -> PySide6.QtCore.QMimeData: ...
    @overload
    def createStandardContextMenu(self) -> PySide6.QtWidgets.QMenu: ...
    @overload
    def createStandardContextMenu(self, position: PySide6.QtCore.QPoint) -> PySide6.QtWidgets.QMenu: ...
    def currentCharFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def cursorForPosition(self, pos: PySide6.QtCore.QPoint) -> PySide6.QtGui.QTextCursor: ...
    @overload
    def cursorRect(self) -> PySide6.QtCore.QRect: ...
    @overload
    def cursorRect(self, cursor: PySide6.QtGui.QTextCursor) -> PySide6.QtCore.QRect: ...
    def cursorWidth(self) -> int: ...
    def cut(self) -> None: ...
    def doSetTextCursor(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def documentTitle(self) -> str: ...
    def dragEnterEvent(self, e: PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e: PySide6.QtGui.QDropEvent) -> None: ...
    def ensureCursorVisible(self) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def extraSelections(self) -> List[PySide6.QtWidgets.QTextEdit.ExtraSelection]: ...
    @overload
    def find(self, exp: str, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> bool: ...
    @overload
    def find(self, exp: Union[PySide6.QtCore.QRegularExpression, str], options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> bool: ...
    def firstVisibleBlock(self) -> PySide6.QtGui.QTextBlock: ...
    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent) -> None: ...
    def getPaintContext(self) -> PySide6.QtGui.QAbstractTextDocumentLayout.PaintContext: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None: ...
    @overload
    def inputMethodQuery(self, property: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    @overload
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, argument: Any) -> Any: ...
    def insertFromMimeData(self, source: PySide6.QtCore.QMimeData) -> None: ...
    def insertPlainText(self, text: str) -> None: ...
    def isReadOnly(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent) -> None: ...
    def lineWrapMode(self) -> PySide6.QtWidgets.QPlainTextEdit.LineWrapMode: ...
    def loadResource(self, type: int, name: Union[PySide6.QtCore.QUrl, str]) -> Any: ...
    def maximumBlockCount(self) -> int: ...
    def mergeCurrentCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat) -> None: ...
    def mouseDoubleClickEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, operation: PySide6.QtGui.QTextCursor.MoveOperation, mode: PySide6.QtGui.QTextCursor.MoveMode = ...) -> None: ...
    def overwriteMode(self) -> bool: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def paste(self) -> None: ...
    def placeholderText(self) -> str: ...
    def print_(self, printer: PySide6.QtGui.QPagedPaintDevice) -> None: ...
    def redo(self) -> None: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def selectAll(self) -> None: ...
    def setBackgroundVisible(self, visible: bool) -> None: ...
    def setCenterOnScroll(self, enabled: bool) -> None: ...
    def setCurrentCharFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...
    def setDocument(self, document: PySide6.QtGui.QTextDocument) -> None: ...
    def setDocumentTitle(self, title: str) -> None: ...
    def setExtraSelections(self, selections: Sequence[PySide6.QtWidgets.QTextEdit.ExtraSelection]) -> None: ...
    def setLineWrapMode(self, mode: PySide6.QtWidgets.QPlainTextEdit.LineWrapMode) -> None: ...
    def setMaximumBlockCount(self, maximum: int) -> None: ...
    def setOverwriteMode(self, overwrite: bool) -> None: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setReadOnly(self, ro: bool) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def setTabStopDistance(self, distance: float) -> None: ...
    def setTextCursor(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def setWordWrapMode(self, policy: PySide6.QtGui.QTextOption.WrapMode) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def tabStopDistance(self) -> float: ...
    def textCursor(self) -> PySide6.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    def timerEvent(self, e: PySide6.QtCore.QTimerEvent) -> None: ...
    def toPlainText(self) -> str: ...
    def undo(self) -> None: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent) -> None: ...
    def wordWrapMode(self) -> PySide6.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, range: int = ...) -> None: ...
    def zoomInF(self, range: float) -> None: ...
    def zoomOut(self, range: int = ...) -> None: ...


class QPointFList(object): ...


class QPointList(object): ...


class QProgressBar(PySide6.QtWidgets.QWidget):

    valueChanged             : ClassVar[Signal] = ... # valueChanged(int)

    class Direction(enum.Enum):

        TopToBottom              : QProgressBar.Direction = ... # 0x0
        BottomToTop              : QProgressBar.Direction = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def format(self) -> str: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionProgressBar) -> None: ...
    def invertedAppearance(self) -> bool: ...
    def isTextVisible(self) -> bool: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def reset(self) -> None: ...
    def resetFormat(self) -> None: ...
    def setAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setFormat(self, format: str) -> None: ...
    def setInvertedAppearance(self, invert: bool) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def setOrientation(self, arg__1: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def setTextDirection(self, textDirection: PySide6.QtWidgets.QProgressBar.Direction) -> None: ...
    def setTextVisible(self, visible: bool) -> None: ...
    def setValue(self, value: int) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def text(self) -> str: ...
    def textDirection(self) -> PySide6.QtWidgets.QProgressBar.Direction: ...
    def value(self) -> int: ...


class QProgressDialog(PySide6.QtWidgets.QDialog):

    canceled                 : ClassVar[Signal] = ... # canceled()

    @overload
    def __init__(self, labelText: str, cancelButtonText: str, minimum: int, maximum: int, parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def autoClose(self) -> bool: ...
    def autoReset(self) -> bool: ...
    def cancel(self) -> None: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent) -> None: ...
    def forceShow(self) -> None: ...
    def labelText(self) -> str: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def minimumDuration(self) -> int: ...
    @overload
    def open(self) -> None: ...
    @overload
    def open(self, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview]) -> None: ...
    def reset(self) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def setAutoClose(self, close: bool) -> None: ...
    def setAutoReset(self, reset: bool) -> None: ...
    def setBar(self, bar: PySide6.QtWidgets.QProgressBar) -> None: ...
    def setCancelButton(self, button: PySide6.QtWidgets.QPushButton) -> None: ...
    def setCancelButtonText(self, text: str) -> None: ...
    def setLabel(self, label: PySide6.QtWidgets.QLabel) -> None: ...
    def setLabelText(self, text: str) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def setMinimumDuration(self, ms: int) -> None: ...
    def setRange(self, minimum: int, maximum: int) -> None: ...
    def setValue(self, progress: int) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def value(self) -> int: ...
    def wasCanceled(self) -> bool: ...


class QProxyStyle(PySide6.QtWidgets.QCommonStyle):

    @overload
    def __init__(self, key: str) -> None: ...
    @overload
    def __init__(self, style: Optional[PySide6.QtWidgets.QStyle] = ...) -> None: ...

    def baseStyle(self) -> PySide6.QtWidgets.QStyle: ...
    def drawComplexControl(self, control: PySide6.QtWidgets.QStyle.ComplexControl, option: PySide6.QtWidgets.QStyleOptionComplex, painter: PySide6.QtGui.QPainter, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def drawControl(self, element: PySide6.QtWidgets.QStyle.ControlElement, option: PySide6.QtWidgets.QStyleOption, painter: PySide6.QtGui.QPainter, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def drawItemPixmap(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, alignment: int, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def drawItemText(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, flags: int, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], enabled: bool, text: str, textRole: PySide6.QtGui.QPalette.ColorRole = ...) -> None: ...
    def drawPrimitive(self, element: PySide6.QtWidgets.QStyle.PrimitiveElement, option: PySide6.QtWidgets.QStyleOption, painter: PySide6.QtGui.QPainter, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def generatedIconPixmap(self, iconMode: PySide6.QtGui.QIcon.Mode, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], opt: PySide6.QtWidgets.QStyleOption) -> PySide6.QtGui.QPixmap: ...
    def hitTestComplexControl(self, control: PySide6.QtWidgets.QStyle.ComplexControl, option: PySide6.QtWidgets.QStyleOptionComplex, pos: PySide6.QtCore.QPoint, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtWidgets.QStyle.SubControl: ...
    def itemPixmapRect(self, r: PySide6.QtCore.QRect, flags: int, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> PySide6.QtCore.QRect: ...
    def itemTextRect(self, fm: PySide6.QtGui.QFontMetrics, r: PySide6.QtCore.QRect, flags: int, enabled: bool, text: str) -> PySide6.QtCore.QRect: ...
    def layoutSpacing(self, control1: PySide6.QtWidgets.QSizePolicy.ControlType, control2: PySide6.QtWidgets.QSizePolicy.ControlType, orientation: PySide6.QtCore.Qt.Orientation, option: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> int: ...
    def pixelMetric(self, metric: PySide6.QtWidgets.QStyle.PixelMetric, option: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> int: ...
    @overload
    def polish(self, app: PySide6.QtWidgets.QApplication) -> None: ...
    @overload
    def polish(self, arg__1: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @overload
    def polish(self, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @overload
    def polish(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setBaseStyle(self, style: PySide6.QtWidgets.QStyle) -> None: ...
    def sizeFromContents(self, type: PySide6.QtWidgets.QStyle.ContentsType, option: PySide6.QtWidgets.QStyleOption, size: PySide6.QtCore.QSize, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtCore.QSize: ...
    def standardIcon(self, standardIcon: PySide6.QtWidgets.QStyle.StandardPixmap, option: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtGui.QIcon: ...
    def standardPalette(self) -> PySide6.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap: PySide6.QtWidgets.QStyle.StandardPixmap, opt: PySide6.QtWidgets.QStyleOption, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtGui.QPixmap: ...
    def styleHint(self, hint: PySide6.QtWidgets.QStyle.StyleHint, option: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ..., returnData: Optional[PySide6.QtWidgets.QStyleHintReturn] = ...) -> int: ...
    def subControlRect(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, sc: PySide6.QtWidgets.QStyle.SubControl, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtCore.QRect: ...
    def subElementRect(self, element: PySide6.QtWidgets.QStyle.SubElement, option: PySide6.QtWidgets.QStyleOption, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtCore.QRect: ...
    @overload
    def unpolish(self, app: PySide6.QtWidgets.QApplication) -> None: ...
    @overload
    def unpolish(self, widget: PySide6.QtWidgets.QWidget) -> None: ...


class QPushButton(PySide6.QtWidgets.QAbstractButton):

    @overload
    def __init__(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def autoDefault(self) -> bool: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def focusInEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, arg__1: PySide6.QtGui.QFocusEvent) -> None: ...
    def hitButton(self, pos: PySide6.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionButton) -> None: ...
    def isDefault(self) -> bool: ...
    def isFlat(self) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def menu(self) -> PySide6.QtWidgets.QMenu: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def setAutoDefault(self, arg__1: bool) -> None: ...
    def setDefault(self, arg__1: bool) -> None: ...
    def setFlat(self, arg__1: bool) -> None: ...
    def setMenu(self, menu: PySide6.QtWidgets.QMenu) -> None: ...
    def showMenu(self) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...


class QRadioButton(PySide6.QtWidgets.QAbstractButton):

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def hitButton(self, arg__1: PySide6.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, button: PySide6.QtWidgets.QStyleOptionButton) -> None: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...


class QRhiWidget(PySide6.QtWidgets.QWidget):

    colorBufferFormatChanged : ClassVar[Signal] = ... # colorBufferFormatChanged(TextureFormat)
    fixedColorBufferSizeChanged: ClassVar[Signal] = ... # fixedColorBufferSizeChanged(QSize)
    frameSubmitted           : ClassVar[Signal] = ... # frameSubmitted()
    mirrorVerticallyChanged  : ClassVar[Signal] = ... # mirrorVerticallyChanged(bool)
    renderFailed             : ClassVar[Signal] = ... # renderFailed()
    sampleCountChanged       : ClassVar[Signal] = ... # sampleCountChanged(int)

    class Api(enum.Enum):

        Null                     : QRhiWidget.Api = ... # 0x0
        OpenGL                   : QRhiWidget.Api = ... # 0x1
        Metal                    : QRhiWidget.Api = ... # 0x2
        Vulkan                   : QRhiWidget.Api = ... # 0x3
        Direct3D11               : QRhiWidget.Api = ... # 0x4
        Direct3D12               : QRhiWidget.Api = ... # 0x5

    class TextureFormat(enum.Enum):

        RGBA8                    : QRhiWidget.TextureFormat = ... # 0x0
        RGBA16F                  : QRhiWidget.TextureFormat = ... # 0x1
        RGBA32F                  : QRhiWidget.TextureFormat = ... # 0x2
        RGB10A2                  : QRhiWidget.TextureFormat = ... # 0x3


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def api(self) -> PySide6.QtWidgets.QRhiWidget.Api: ...
    def colorBufferFormat(self) -> PySide6.QtWidgets.QRhiWidget.TextureFormat: ...
    def colorTexture(self) -> PySide6.QtGui.QRhiTexture: ...
    def depthStencilBuffer(self) -> PySide6.QtGui.QRhiRenderBuffer: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def fixedColorBufferSize(self) -> PySide6.QtCore.QSize: ...
    def grabFramebuffer(self) -> PySide6.QtGui.QImage: ...
    def initialize(self, cb: PySide6.QtGui.QRhiCommandBuffer) -> None: ...
    def isAutoRenderTargetEnabled(self) -> bool: ...
    def isDebugLayerEnabled(self) -> bool: ...
    def isMirrorVerticallyEnabled(self) -> bool: ...
    def msaaColorBuffer(self) -> PySide6.QtGui.QRhiRenderBuffer: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def releaseResources(self) -> None: ...
    def render(self, cb: PySide6.QtGui.QRhiCommandBuffer) -> None: ...
    def renderTarget(self) -> PySide6.QtGui.QRhiRenderTarget: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent) -> None: ...
    def resolveTexture(self) -> PySide6.QtGui.QRhiTexture: ...
    def rhi(self) -> PySide6.QtGui.QRhi: ...
    def sampleCount(self) -> int: ...
    def setApi(self, api: PySide6.QtWidgets.QRhiWidget.Api) -> None: ...
    def setAutoRenderTarget(self, enabled: bool) -> None: ...
    def setColorBufferFormat(self, format: PySide6.QtWidgets.QRhiWidget.TextureFormat) -> None: ...
    def setDebugLayerEnabled(self, enable: bool) -> None: ...
    @overload
    def setFixedColorBufferSize(self, pixelSize: PySide6.QtCore.QSize) -> None: ...
    @overload
    def setFixedColorBufferSize(self, w: int, h: int) -> None: ...
    def setMirrorVertically(self, enabled: bool) -> None: ...
    def setSampleCount(self, samples: int) -> None: ...


class QRubberBand(PySide6.QtWidgets.QWidget):

    class Shape(enum.Enum):

        Line                     : QRubberBand.Shape = ... # 0x0
        Rectangle                : QRubberBand.Shape = ... # 0x1


    def __init__(self, arg__1: PySide6.QtWidgets.QRubberBand.Shape, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionRubberBand) -> None: ...
    @overload
    def move(self, p: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def move(self, x: int, y: int) -> None: ...
    def moveEvent(self, arg__1: PySide6.QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    @overload
    def resize(self, s: PySide6.QtCore.QSize) -> None: ...
    @overload
    def resize(self, w: int, h: int) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    @overload
    def setGeometry(self, r: PySide6.QtCore.QRect) -> None: ...
    @overload
    def setGeometry(self, x: int, y: int, w: int, h: int) -> None: ...
    def shape(self) -> PySide6.QtWidgets.QRubberBand.Shape: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...


class QScrollArea(PySide6.QtWidgets.QAbstractScrollArea):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def ensureVisible(self, x: int, y: int, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def ensureWidgetVisible(self, childWidget: PySide6.QtWidgets.QWidget, xmargin: int = ..., ymargin: int = ...) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def setAlignment(self, arg__1: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setWidgetResizable(self, resizable: bool) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def takeWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def viewportSizeHint(self) -> PySide6.QtCore.QSize: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...
    def widgetResizable(self) -> bool: ...


class QScrollBar(PySide6.QtWidgets.QAbstractSlider):

    @overload
    def __init__(self, arg__1: PySide6.QtCore.Qt.Orientation, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def contextMenuEvent(self, arg__1: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSlider) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def sliderChange(self, change: PySide6.QtWidgets.QAbstractSlider.SliderChange) -> None: ...
    def wheelEvent(self, arg__1: PySide6.QtGui.QWheelEvent) -> None: ...


class QScroller(PySide6.QtCore.QObject):

    scrollerPropertiesChanged: ClassVar[Signal] = ... # scrollerPropertiesChanged(QScrollerProperties)
    stateChanged             : ClassVar[Signal] = ... # stateChanged(QScroller::State)

    class Input(enum.Enum):

        InputPress               : QScroller.Input = ... # 0x1
        InputMove                : QScroller.Input = ... # 0x2
        InputRelease             : QScroller.Input = ... # 0x3

    class ScrollerGestureType(enum.Enum):

        TouchGesture             : QScroller.ScrollerGestureType = ... # 0x0
        LeftMouseButtonGesture   : QScroller.ScrollerGestureType = ... # 0x1
        RightMouseButtonGesture  : QScroller.ScrollerGestureType = ... # 0x2
        MiddleMouseButtonGesture : QScroller.ScrollerGestureType = ... # 0x3

    class State(enum.Enum):

        Inactive                 : QScroller.State = ... # 0x0
        Pressed                  : QScroller.State = ... # 0x1
        Dragging                 : QScroller.State = ... # 0x2
        Scrolling                : QScroller.State = ... # 0x3


    @staticmethod
    def activeScrollers() -> List[PySide6.QtWidgets.QScroller]: ...
    @overload
    def ensureVisible(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], xmargin: float, ymargin: float) -> None: ...
    @overload
    def ensureVisible(self, rect: Union[PySide6.QtCore.QRectF, PySide6.QtCore.QRect], xmargin: float, ymargin: float, scrollTime: int) -> None: ...
    def finalPosition(self) -> PySide6.QtCore.QPointF: ...
    @staticmethod
    def grabGesture(target: PySide6.QtCore.QObject, gestureType: PySide6.QtWidgets.QScroller.ScrollerGestureType = ...) -> PySide6.QtCore.Qt.GestureType: ...
    @staticmethod
    def grabbedGesture(target: PySide6.QtCore.QObject) -> PySide6.QtCore.Qt.GestureType: ...
    def handleInput(self, input: PySide6.QtWidgets.QScroller.Input, position: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], timestamp: int = ...) -> bool: ...
    @staticmethod
    def hasScroller(target: PySide6.QtCore.QObject) -> bool: ...
    def pixelPerMeter(self) -> PySide6.QtCore.QPointF: ...
    def resendPrepareEvent(self) -> None: ...
    @overload
    def scrollTo(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @overload
    def scrollTo(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element], scrollTime: int) -> None: ...
    @staticmethod
    def scroller(target: PySide6.QtCore.QObject) -> PySide6.QtWidgets.QScroller: ...
    def scrollerProperties(self) -> PySide6.QtWidgets.QScrollerProperties: ...
    def setScrollerProperties(self, prop: PySide6.QtWidgets.QScrollerProperties) -> None: ...
    @overload
    def setSnapPositionsX(self, first: float, interval: float) -> None: ...
    @overload
    def setSnapPositionsX(self, positions: Sequence[float]) -> None: ...
    @overload
    def setSnapPositionsY(self, first: float, interval: float) -> None: ...
    @overload
    def setSnapPositionsY(self, positions: Sequence[float]) -> None: ...
    def state(self) -> PySide6.QtWidgets.QScroller.State: ...
    def stop(self) -> None: ...
    def target(self) -> PySide6.QtCore.QObject: ...
    @staticmethod
    def ungrabGesture(target: PySide6.QtCore.QObject) -> None: ...
    def velocity(self) -> PySide6.QtCore.QPointF: ...


class QScrollerProperties(Shiboken.Object):

    class FrameRates(enum.Enum):

        Standard                 : QScrollerProperties.FrameRates = ... # 0x0
        Fps60                    : QScrollerProperties.FrameRates = ... # 0x1
        Fps30                    : QScrollerProperties.FrameRates = ... # 0x2
        Fps20                    : QScrollerProperties.FrameRates = ... # 0x3

    class OvershootPolicy(enum.Enum):

        OvershootWhenScrollable  : QScrollerProperties.OvershootPolicy = ... # 0x0
        OvershootAlwaysOff       : QScrollerProperties.OvershootPolicy = ... # 0x1
        OvershootAlwaysOn        : QScrollerProperties.OvershootPolicy = ... # 0x2

    class ScrollMetric(enum.Enum):

        MousePressEventDelay     : QScrollerProperties.ScrollMetric = ... # 0x0
        DragStartDistance        : QScrollerProperties.ScrollMetric = ... # 0x1
        DragVelocitySmoothingFactor: QScrollerProperties.ScrollMetric = ... # 0x2
        AxisLockThreshold        : QScrollerProperties.ScrollMetric = ... # 0x3
        ScrollingCurve           : QScrollerProperties.ScrollMetric = ... # 0x4
        DecelerationFactor       : QScrollerProperties.ScrollMetric = ... # 0x5
        MinimumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x6
        MaximumVelocity          : QScrollerProperties.ScrollMetric = ... # 0x7
        MaximumClickThroughVelocity: QScrollerProperties.ScrollMetric = ... # 0x8
        AcceleratingFlickMaximumTime: QScrollerProperties.ScrollMetric = ... # 0x9
        AcceleratingFlickSpeedupFactor: QScrollerProperties.ScrollMetric = ... # 0xa
        SnapPositionRatio        : QScrollerProperties.ScrollMetric = ... # 0xb
        SnapTime                 : QScrollerProperties.ScrollMetric = ... # 0xc
        OvershootDragResistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xd
        OvershootDragDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xe
        OvershootScrollDistanceFactor: QScrollerProperties.ScrollMetric = ... # 0xf
        OvershootScrollTime      : QScrollerProperties.ScrollMetric = ... # 0x10
        HorizontalOvershootPolicy: QScrollerProperties.ScrollMetric = ... # 0x11
        VerticalOvershootPolicy  : QScrollerProperties.ScrollMetric = ... # 0x12
        FrameRate                : QScrollerProperties.ScrollMetric = ... # 0x13
        ScrollMetricCount        : QScrollerProperties.ScrollMetric = ... # 0x14


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, sp: PySide6.QtWidgets.QScrollerProperties) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def scrollMetric(self, metric: PySide6.QtWidgets.QScrollerProperties.ScrollMetric) -> Any: ...
    @staticmethod
    def setDefaultScrollerProperties(sp: PySide6.QtWidgets.QScrollerProperties) -> None: ...
    def setScrollMetric(self, metric: PySide6.QtWidgets.QScrollerProperties.ScrollMetric, value: Any) -> None: ...
    @staticmethod
    def unsetDefaultScrollerProperties() -> None: ...


class QSizeGrip(PySide6.QtWidgets.QWidget):

    def __init__(self, parent: PySide6.QtWidgets.QWidget) -> None: ...

    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    def hideEvent(self, hideEvent: PySide6.QtGui.QHideEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, mouseEvent: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveEvent(self, moveEvent: PySide6.QtGui.QMoveEvent) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def setVisible(self, arg__1: bool) -> None: ...
    def showEvent(self, showEvent: PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...


class QSizePolicy(Shiboken.Object):

    class ControlType(enum.Flag):

        DefaultType              : QSizePolicy.ControlType = ... # 0x1
        ButtonBox                : QSizePolicy.ControlType = ... # 0x2
        CheckBox                 : QSizePolicy.ControlType = ... # 0x4
        ComboBox                 : QSizePolicy.ControlType = ... # 0x8
        Frame                    : QSizePolicy.ControlType = ... # 0x10
        GroupBox                 : QSizePolicy.ControlType = ... # 0x20
        Label                    : QSizePolicy.ControlType = ... # 0x40
        Line                     : QSizePolicy.ControlType = ... # 0x80
        LineEdit                 : QSizePolicy.ControlType = ... # 0x100
        PushButton               : QSizePolicy.ControlType = ... # 0x200
        RadioButton              : QSizePolicy.ControlType = ... # 0x400
        Slider                   : QSizePolicy.ControlType = ... # 0x800
        SpinBox                  : QSizePolicy.ControlType = ... # 0x1000
        TabWidget                : QSizePolicy.ControlType = ... # 0x2000
        ToolButton               : QSizePolicy.ControlType = ... # 0x4000

    class Policy(enum.Enum):

        Fixed                    : QSizePolicy.Policy = ... # 0x0
        Minimum                  : QSizePolicy.Policy = ... # 0x1
        MinimumExpanding         : QSizePolicy.Policy = ... # 0x3
        Maximum                  : QSizePolicy.Policy = ... # 0x4
        Preferred                : QSizePolicy.Policy = ... # 0x5
        Expanding                : QSizePolicy.Policy = ... # 0x7
        Ignored                  : QSizePolicy.Policy = ... # 0xd

    class PolicyFlag(enum.IntFlag):

        GrowFlag                 : QSizePolicy.PolicyFlag = ... # 0x1
        ExpandFlag               : QSizePolicy.PolicyFlag = ... # 0x2
        ShrinkFlag               : QSizePolicy.PolicyFlag = ... # 0x4
        IgnoreFlag               : QSizePolicy.PolicyFlag = ... # 0x8


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, horizontal: PySide6.QtWidgets.QSizePolicy.Policy, vertical: PySide6.QtWidgets.QSizePolicy.Policy, type: PySide6.QtWidgets.QSizePolicy.ControlType = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __lshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, arg__1: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def controlType(self) -> PySide6.QtWidgets.QSizePolicy.ControlType: ...
    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientation: ...
    def hasHeightForWidth(self) -> bool: ...
    def hasWidthForHeight(self) -> bool: ...
    def horizontalPolicy(self) -> PySide6.QtWidgets.QSizePolicy.Policy: ...
    def horizontalStretch(self) -> int: ...
    def retainSizeWhenHidden(self) -> bool: ...
    def setControlType(self, type: PySide6.QtWidgets.QSizePolicy.ControlType) -> None: ...
    def setHeightForWidth(self, b: bool) -> None: ...
    def setHorizontalPolicy(self, d: PySide6.QtWidgets.QSizePolicy.Policy) -> None: ...
    def setHorizontalStretch(self, stretchFactor: int) -> None: ...
    def setRetainSizeWhenHidden(self, retainSize: bool) -> None: ...
    def setVerticalPolicy(self, d: PySide6.QtWidgets.QSizePolicy.Policy) -> None: ...
    def setVerticalStretch(self, stretchFactor: int) -> None: ...
    def setWidthForHeight(self, b: bool) -> None: ...
    def transpose(self) -> None: ...
    def transposed(self) -> PySide6.QtWidgets.QSizePolicy: ...
    def verticalPolicy(self) -> PySide6.QtWidgets.QSizePolicy.Policy: ...
    def verticalStretch(self) -> int: ...


class QSlider(PySide6.QtWidgets.QAbstractSlider):

    class TickPosition(enum.Enum):

        NoTicks                  : QSlider.TickPosition = ... # 0x0
        TicksAbove               : QSlider.TickPosition = ... # 0x1
        TicksLeft                : QSlider.TickPosition = ... # 0x1
        TicksBelow               : QSlider.TickPosition = ... # 0x2
        TicksRight               : QSlider.TickPosition = ... # 0x2
        TicksBothSides           : QSlider.TickPosition = ... # 0x3


    @overload
    def __init__(self, orientation: PySide6.QtCore.Qt.Orientation, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionSlider) -> None: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mouseMoveEvent(self, ev: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: PySide6.QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, ev: PySide6.QtGui.QPaintEvent) -> None: ...
    def setTickInterval(self, ti: int) -> None: ...
    def setTickPosition(self, position: PySide6.QtWidgets.QSlider.TickPosition) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def tickInterval(self) -> int: ...
    def tickPosition(self) -> PySide6.QtWidgets.QSlider.TickPosition: ...


class QSpacerItem(PySide6.QtWidgets.QLayoutItem):

    def __init__(self, w: int, h: int, hData: PySide6.QtWidgets.QSizePolicy.Policy = ..., vData: PySide6.QtWidgets.QSizePolicy.Policy = ...) -> None: ...

    def changeSize(self, w: int, h: int, hData: PySide6.QtWidgets.QSizePolicy.Policy = ..., vData: PySide6.QtWidgets.QSizePolicy.Policy = ...) -> None: ...
    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientation: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def isEmpty(self) -> bool: ...
    def maximumSize(self) -> PySide6.QtCore.QSize: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def sizePolicy(self) -> PySide6.QtWidgets.QSizePolicy: ...
    def spacerItem(self) -> PySide6.QtWidgets.QSpacerItem: ...


class QSpinBox(PySide6.QtWidgets.QAbstractSpinBox):

    textChanged              : ClassVar[Signal] = ... # textChanged(QString)
    valueChanged             : ClassVar[Signal] = ... # valueChanged(int)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def cleanText(self) -> str: ...
    def displayIntegerBase(self) -> int: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def fixup(self, str: str) -> str: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...
    def prefix(self) -> str: ...
    def setDisplayIntegerBase(self, base: int) -> None: ...
    def setMaximum(self, max: int) -> None: ...
    def setMinimum(self, min: int) -> None: ...
    def setPrefix(self, prefix: str) -> None: ...
    def setRange(self, min: int, max: int) -> None: ...
    def setSingleStep(self, val: int) -> None: ...
    def setStepType(self, stepType: PySide6.QtWidgets.QAbstractSpinBox.StepType) -> None: ...
    def setSuffix(self, suffix: str) -> None: ...
    def setValue(self, val: int) -> None: ...
    def singleStep(self) -> int: ...
    def stepType(self) -> PySide6.QtWidgets.QAbstractSpinBox.StepType: ...
    def suffix(self) -> str: ...
    def textFromValue(self, val: int) -> str: ...
    def validate(self, input: str, pos: int) -> object: ...
    def value(self) -> int: ...
    def valueFromText(self, text: str) -> int: ...


class QSplashScreen(PySide6.QtWidgets.QWidget):

    messageChanged           : ClassVar[Signal] = ... # messageChanged(QString)

    @overload
    def __init__(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...
    @overload
    def __init__(self, screen: PySide6.QtGui.QScreen, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def clearMessage(self) -> None: ...
    def drawContents(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def finish(self, w: PySide6.QtWidgets.QWidget) -> None: ...
    def message(self) -> str: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def pixmap(self) -> PySide6.QtGui.QPixmap: ...
    def setPixmap(self, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def showMessage(self, message: str, alignment: int = ..., color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int] = ...) -> None: ...


class QSplitter(PySide6.QtWidgets.QFrame):

    splitterMoved            : ClassVar[Signal] = ... # splitterMoved(int,int)

    @overload
    def __init__(self, arg__1: PySide6.QtCore.Qt.Orientation, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def addWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def childEvent(self, arg__1: PySide6.QtCore.QChildEvent) -> None: ...
    def childrenCollapsible(self) -> bool: ...
    def closestLegalPosition(self, arg__1: int, arg__2: int) -> int: ...
    def count(self) -> int: ...
    def createHandle(self) -> PySide6.QtWidgets.QSplitterHandle: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def getRange(self, index: int) -> object: ...
    def handle(self, index: int) -> PySide6.QtWidgets.QSplitterHandle: ...
    def handleWidth(self) -> int: ...
    def indexOf(self, w: PySide6.QtWidgets.QWidget) -> int: ...
    def insertWidget(self, index: int, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def isCollapsible(self, index: int) -> bool: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def moveSplitter(self, pos: int, index: int) -> None: ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def refresh(self) -> None: ...
    def replaceWidget(self, index: int, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtWidgets.QWidget: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def restoreState(self, state: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> bool: ...
    def saveState(self) -> PySide6.QtCore.QByteArray: ...
    def setChildrenCollapsible(self, arg__1: bool) -> None: ...
    def setCollapsible(self, index: int, arg__2: bool) -> None: ...
    def setHandleWidth(self, arg__1: int) -> None: ...
    def setOpaqueResize(self, opaque: bool = ...) -> None: ...
    def setOrientation(self, arg__1: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setRubberBand(self, position: int) -> None: ...
    def setSizes(self, list: Sequence[int]) -> None: ...
    def setStretchFactor(self, index: int, stretch: int) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def sizes(self) -> List[int]: ...
    def widget(self, index: int) -> PySide6.QtWidgets.QWidget: ...


class QSplitterHandle(PySide6.QtWidgets.QWidget):

    def __init__(self, o: PySide6.QtCore.Qt.Orientation, parent: PySide6.QtWidgets.QSplitter) -> None: ...

    def closestLegalPosition(self, p: int) -> int: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveSplitter(self, p: int) -> None: ...
    def opaqueResize(self) -> bool: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def setOrientation(self, o: PySide6.QtCore.Qt.Orientation) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def splitter(self) -> PySide6.QtWidgets.QSplitter: ...


class QStackedLayout(PySide6.QtWidgets.QLayout):

    currentChanged           : ClassVar[Signal] = ... # currentChanged(int)
    widgetRemoved            : ClassVar[Signal] = ... # widgetRemoved(int)

    class StackingMode(enum.Enum):

        StackOne                 : QStackedLayout.StackingMode = ... # 0x0
        StackAll                 : QStackedLayout.StackingMode = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget) -> None: ...
    @overload
    def __init__(self, parentLayout: PySide6.QtWidgets.QLayout) -> None: ...

    def addItem(self, item: PySide6.QtWidgets.QLayoutItem) -> None: ...
    def addWidget(self, w: PySide6.QtWidgets.QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def insertWidget(self, index: int, w: PySide6.QtWidgets.QWidget) -> int: ...
    def itemAt(self, arg__1: int) -> PySide6.QtWidgets.QLayoutItem: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, w: PySide6.QtWidgets.QWidget) -> None: ...
    def setGeometry(self, rect: PySide6.QtCore.QRect) -> None: ...
    def setStackingMode(self, stackingMode: PySide6.QtWidgets.QStackedLayout.StackingMode) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def stackingMode(self) -> PySide6.QtWidgets.QStackedLayout.StackingMode: ...
    def takeAt(self, arg__1: int) -> PySide6.QtWidgets.QLayoutItem: ...
    @overload
    def widget(self) -> PySide6.QtWidgets.QWidget: ...
    @overload
    def widget(self, arg__1: int) -> PySide6.QtWidgets.QWidget: ...


class QStackedWidget(PySide6.QtWidgets.QFrame):

    currentChanged           : ClassVar[Signal] = ... # currentChanged(int)
    widgetRemoved            : ClassVar[Signal] = ... # widgetRemoved(int)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def addWidget(self, w: PySide6.QtWidgets.QWidget) -> int: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def indexOf(self, arg__1: PySide6.QtWidgets.QWidget) -> int: ...
    def insertWidget(self, index: int, w: PySide6.QtWidgets.QWidget) -> int: ...
    def removeWidget(self, w: PySide6.QtWidgets.QWidget) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, w: PySide6.QtWidgets.QWidget) -> None: ...
    def widget(self, arg__1: int) -> PySide6.QtWidgets.QWidget: ...


class QStatusBar(PySide6.QtWidgets.QWidget):

    messageChanged           : ClassVar[Signal] = ... # messageChanged(QString)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def addPermanentWidget(self, widget: PySide6.QtWidgets.QWidget, stretch: int = ...) -> None: ...
    def addWidget(self, widget: PySide6.QtWidgets.QWidget, stretch: int = ...) -> None: ...
    def clearMessage(self) -> None: ...
    def currentMessage(self) -> str: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def hideOrShow(self) -> None: ...
    def insertPermanentWidget(self, index: int, widget: PySide6.QtWidgets.QWidget, stretch: int = ...) -> int: ...
    def insertWidget(self, index: int, widget: PySide6.QtWidgets.QWidget, stretch: int = ...) -> int: ...
    def isSizeGripEnabled(self) -> bool: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def reformat(self) -> None: ...
    def removeWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def setSizeGripEnabled(self, arg__1: bool) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def showMessage(self, text: str, timeout: int = ...) -> None: ...


class QStyle(PySide6.QtCore.QObject):

    class ComplexControl(enum.IntEnum):

        CC_SpinBox               : QStyle.ComplexControl = ... # 0x0
        CC_ComboBox              : QStyle.ComplexControl = ... # 0x1
        CC_ScrollBar             : QStyle.ComplexControl = ... # 0x2
        CC_Slider                : QStyle.ComplexControl = ... # 0x3
        CC_ToolButton            : QStyle.ComplexControl = ... # 0x4
        CC_TitleBar              : QStyle.ComplexControl = ... # 0x5
        CC_Dial                  : QStyle.ComplexControl = ... # 0x6
        CC_GroupBox              : QStyle.ComplexControl = ... # 0x7
        CC_MdiControls           : QStyle.ComplexControl = ... # 0x8
        CC_CustomBase            : QStyle.ComplexControl = ... # 0xf0000000

    class ContentsType(enum.IntEnum):

        CT_PushButton            : QStyle.ContentsType = ... # 0x0
        CT_CheckBox              : QStyle.ContentsType = ... # 0x1
        CT_RadioButton           : QStyle.ContentsType = ... # 0x2
        CT_ToolButton            : QStyle.ContentsType = ... # 0x3
        CT_ComboBox              : QStyle.ContentsType = ... # 0x4
        CT_Splitter              : QStyle.ContentsType = ... # 0x5
        CT_ProgressBar           : QStyle.ContentsType = ... # 0x6
        CT_MenuItem              : QStyle.ContentsType = ... # 0x7
        CT_MenuBarItem           : QStyle.ContentsType = ... # 0x8
        CT_MenuBar               : QStyle.ContentsType = ... # 0x9
        CT_Menu                  : QStyle.ContentsType = ... # 0xa
        CT_TabBarTab             : QStyle.ContentsType = ... # 0xb
        CT_Slider                : QStyle.ContentsType = ... # 0xc
        CT_ScrollBar             : QStyle.ContentsType = ... # 0xd
        CT_LineEdit              : QStyle.ContentsType = ... # 0xe
        CT_SpinBox               : QStyle.ContentsType = ... # 0xf
        CT_SizeGrip              : QStyle.ContentsType = ... # 0x10
        CT_TabWidget             : QStyle.ContentsType = ... # 0x11
        CT_DialogButtons         : QStyle.ContentsType = ... # 0x12
        CT_HeaderSection         : QStyle.ContentsType = ... # 0x13
        CT_GroupBox              : QStyle.ContentsType = ... # 0x14
        CT_MdiControls           : QStyle.ContentsType = ... # 0x15
        CT_ItemViewItem          : QStyle.ContentsType = ... # 0x16
        CT_CustomBase            : QStyle.ContentsType = ... # 0xf0000000

    class ControlElement(enum.IntEnum):

        CE_PushButton            : QStyle.ControlElement = ... # 0x0
        CE_PushButtonBevel       : QStyle.ControlElement = ... # 0x1
        CE_PushButtonLabel       : QStyle.ControlElement = ... # 0x2
        CE_CheckBox              : QStyle.ControlElement = ... # 0x3
        CE_CheckBoxLabel         : QStyle.ControlElement = ... # 0x4
        CE_RadioButton           : QStyle.ControlElement = ... # 0x5
        CE_RadioButtonLabel      : QStyle.ControlElement = ... # 0x6
        CE_TabBarTab             : QStyle.ControlElement = ... # 0x7
        CE_TabBarTabShape        : QStyle.ControlElement = ... # 0x8
        CE_TabBarTabLabel        : QStyle.ControlElement = ... # 0x9
        CE_ProgressBar           : QStyle.ControlElement = ... # 0xa
        CE_ProgressBarGroove     : QStyle.ControlElement = ... # 0xb
        CE_ProgressBarContents   : QStyle.ControlElement = ... # 0xc
        CE_ProgressBarLabel      : QStyle.ControlElement = ... # 0xd
        CE_MenuItem              : QStyle.ControlElement = ... # 0xe
        CE_MenuScroller          : QStyle.ControlElement = ... # 0xf
        CE_MenuVMargin           : QStyle.ControlElement = ... # 0x10
        CE_MenuHMargin           : QStyle.ControlElement = ... # 0x11
        CE_MenuTearoff           : QStyle.ControlElement = ... # 0x12
        CE_MenuEmptyArea         : QStyle.ControlElement = ... # 0x13
        CE_MenuBarItem           : QStyle.ControlElement = ... # 0x14
        CE_MenuBarEmptyArea      : QStyle.ControlElement = ... # 0x15
        CE_ToolButtonLabel       : QStyle.ControlElement = ... # 0x16
        CE_Header                : QStyle.ControlElement = ... # 0x17
        CE_HeaderSection         : QStyle.ControlElement = ... # 0x18
        CE_HeaderLabel           : QStyle.ControlElement = ... # 0x19
        CE_ToolBoxTab            : QStyle.ControlElement = ... # 0x1a
        CE_SizeGrip              : QStyle.ControlElement = ... # 0x1b
        CE_Splitter              : QStyle.ControlElement = ... # 0x1c
        CE_RubberBand            : QStyle.ControlElement = ... # 0x1d
        CE_DockWidgetTitle       : QStyle.ControlElement = ... # 0x1e
        CE_ScrollBarAddLine      : QStyle.ControlElement = ... # 0x1f
        CE_ScrollBarSubLine      : QStyle.ControlElement = ... # 0x20
        CE_ScrollBarAddPage      : QStyle.ControlElement = ... # 0x21
        CE_ScrollBarSubPage      : QStyle.ControlElement = ... # 0x22
        CE_ScrollBarSlider       : QStyle.ControlElement = ... # 0x23
        CE_ScrollBarFirst        : QStyle.ControlElement = ... # 0x24
        CE_ScrollBarLast         : QStyle.ControlElement = ... # 0x25
        CE_FocusFrame            : QStyle.ControlElement = ... # 0x26
        CE_ComboBoxLabel         : QStyle.ControlElement = ... # 0x27
        CE_ToolBar               : QStyle.ControlElement = ... # 0x28
        CE_ToolBoxTabShape       : QStyle.ControlElement = ... # 0x29
        CE_ToolBoxTabLabel       : QStyle.ControlElement = ... # 0x2a
        CE_HeaderEmptyArea       : QStyle.ControlElement = ... # 0x2b
        CE_ColumnViewGrip        : QStyle.ControlElement = ... # 0x2c
        CE_ItemViewItem          : QStyle.ControlElement = ... # 0x2d
        CE_ShapedFrame           : QStyle.ControlElement = ... # 0x2e
        CE_CustomBase            : QStyle.ControlElement = ... # 0xf0000000

    class PixelMetric(enum.IntEnum):

        PM_ButtonMargin          : QStyle.PixelMetric = ... # 0x0
        PM_ButtonDefaultIndicator: QStyle.PixelMetric = ... # 0x1
        PM_MenuButtonIndicator   : QStyle.PixelMetric = ... # 0x2
        PM_ButtonShiftHorizontal : QStyle.PixelMetric = ... # 0x3
        PM_ButtonShiftVertical   : QStyle.PixelMetric = ... # 0x4
        PM_DefaultFrameWidth     : QStyle.PixelMetric = ... # 0x5
        PM_SpinBoxFrameWidth     : QStyle.PixelMetric = ... # 0x6
        PM_ComboBoxFrameWidth    : QStyle.PixelMetric = ... # 0x7
        PM_MaximumDragDistance   : QStyle.PixelMetric = ... # 0x8
        PM_ScrollBarExtent       : QStyle.PixelMetric = ... # 0x9
        PM_ScrollBarSliderMin    : QStyle.PixelMetric = ... # 0xa
        PM_SliderThickness       : QStyle.PixelMetric = ... # 0xb
        PM_SliderControlThickness: QStyle.PixelMetric = ... # 0xc
        PM_SliderLength          : QStyle.PixelMetric = ... # 0xd
        PM_SliderTickmarkOffset  : QStyle.PixelMetric = ... # 0xe
        PM_SliderSpaceAvailable  : QStyle.PixelMetric = ... # 0xf
        PM_DockWidgetSeparatorExtent: QStyle.PixelMetric = ... # 0x10
        PM_DockWidgetHandleExtent: QStyle.PixelMetric = ... # 0x11
        PM_DockWidgetFrameWidth  : QStyle.PixelMetric = ... # 0x12
        PM_TabBarTabOverlap      : QStyle.PixelMetric = ... # 0x13
        PM_TabBarTabHSpace       : QStyle.PixelMetric = ... # 0x14
        PM_TabBarTabVSpace       : QStyle.PixelMetric = ... # 0x15
        PM_TabBarBaseHeight      : QStyle.PixelMetric = ... # 0x16
        PM_TabBarBaseOverlap     : QStyle.PixelMetric = ... # 0x17
        PM_ProgressBarChunkWidth : QStyle.PixelMetric = ... # 0x18
        PM_SplitterWidth         : QStyle.PixelMetric = ... # 0x19
        PM_TitleBarHeight        : QStyle.PixelMetric = ... # 0x1a
        PM_MenuScrollerHeight    : QStyle.PixelMetric = ... # 0x1b
        PM_MenuHMargin           : QStyle.PixelMetric = ... # 0x1c
        PM_MenuVMargin           : QStyle.PixelMetric = ... # 0x1d
        PM_MenuPanelWidth        : QStyle.PixelMetric = ... # 0x1e
        PM_MenuTearoffHeight     : QStyle.PixelMetric = ... # 0x1f
        PM_MenuDesktopFrameWidth : QStyle.PixelMetric = ... # 0x20
        PM_MenuBarPanelWidth     : QStyle.PixelMetric = ... # 0x21
        PM_MenuBarItemSpacing    : QStyle.PixelMetric = ... # 0x22
        PM_MenuBarVMargin        : QStyle.PixelMetric = ... # 0x23
        PM_MenuBarHMargin        : QStyle.PixelMetric = ... # 0x24
        PM_IndicatorWidth        : QStyle.PixelMetric = ... # 0x25
        PM_IndicatorHeight       : QStyle.PixelMetric = ... # 0x26
        PM_ExclusiveIndicatorWidth: QStyle.PixelMetric = ... # 0x27
        PM_ExclusiveIndicatorHeight: QStyle.PixelMetric = ... # 0x28
        PM_DialogButtonsSeparator: QStyle.PixelMetric = ... # 0x29
        PM_DialogButtonsButtonWidth: QStyle.PixelMetric = ... # 0x2a
        PM_DialogButtonsButtonHeight: QStyle.PixelMetric = ... # 0x2b
        PM_MdiSubWindowFrameWidth: QStyle.PixelMetric = ... # 0x2c
        PM_MdiSubWindowMinimizedWidth: QStyle.PixelMetric = ... # 0x2d
        PM_HeaderMargin          : QStyle.PixelMetric = ... # 0x2e
        PM_HeaderMarkSize        : QStyle.PixelMetric = ... # 0x2f
        PM_HeaderGripMargin      : QStyle.PixelMetric = ... # 0x30
        PM_TabBarTabShiftHorizontal: QStyle.PixelMetric = ... # 0x31
        PM_TabBarTabShiftVertical: QStyle.PixelMetric = ... # 0x32
        PM_TabBarScrollButtonWidth: QStyle.PixelMetric = ... # 0x33
        PM_ToolBarFrameWidth     : QStyle.PixelMetric = ... # 0x34
        PM_ToolBarHandleExtent   : QStyle.PixelMetric = ... # 0x35
        PM_ToolBarItemSpacing    : QStyle.PixelMetric = ... # 0x36
        PM_ToolBarItemMargin     : QStyle.PixelMetric = ... # 0x37
        PM_ToolBarSeparatorExtent: QStyle.PixelMetric = ... # 0x38
        PM_ToolBarExtensionExtent: QStyle.PixelMetric = ... # 0x39
        PM_SpinBoxSliderHeight   : QStyle.PixelMetric = ... # 0x3a
        PM_ToolBarIconSize       : QStyle.PixelMetric = ... # 0x3b
        PM_ListViewIconSize      : QStyle.PixelMetric = ... # 0x3c
        PM_IconViewIconSize      : QStyle.PixelMetric = ... # 0x3d
        PM_SmallIconSize         : QStyle.PixelMetric = ... # 0x3e
        PM_LargeIconSize         : QStyle.PixelMetric = ... # 0x3f
        PM_FocusFrameVMargin     : QStyle.PixelMetric = ... # 0x40
        PM_FocusFrameHMargin     : QStyle.PixelMetric = ... # 0x41
        PM_ToolTipLabelFrameWidth: QStyle.PixelMetric = ... # 0x42
        PM_CheckBoxLabelSpacing  : QStyle.PixelMetric = ... # 0x43
        PM_TabBarIconSize        : QStyle.PixelMetric = ... # 0x44
        PM_SizeGripSize          : QStyle.PixelMetric = ... # 0x45
        PM_DockWidgetTitleMargin : QStyle.PixelMetric = ... # 0x46
        PM_MessageBoxIconSize    : QStyle.PixelMetric = ... # 0x47
        PM_ButtonIconSize        : QStyle.PixelMetric = ... # 0x48
        PM_DockWidgetTitleBarButtonMargin: QStyle.PixelMetric = ... # 0x49
        PM_RadioButtonLabelSpacing: QStyle.PixelMetric = ... # 0x4a
        PM_LayoutLeftMargin      : QStyle.PixelMetric = ... # 0x4b
        PM_LayoutTopMargin       : QStyle.PixelMetric = ... # 0x4c
        PM_LayoutRightMargin     : QStyle.PixelMetric = ... # 0x4d
        PM_LayoutBottomMargin    : QStyle.PixelMetric = ... # 0x4e
        PM_LayoutHorizontalSpacing: QStyle.PixelMetric = ... # 0x4f
        PM_LayoutVerticalSpacing : QStyle.PixelMetric = ... # 0x50
        PM_TabBar_ScrollButtonOverlap: QStyle.PixelMetric = ... # 0x51
        PM_TextCursorWidth       : QStyle.PixelMetric = ... # 0x52
        PM_TabCloseIndicatorWidth: QStyle.PixelMetric = ... # 0x53
        PM_TabCloseIndicatorHeight: QStyle.PixelMetric = ... # 0x54
        PM_ScrollView_ScrollBarSpacing: QStyle.PixelMetric = ... # 0x55
        PM_ScrollView_ScrollBarOverlap: QStyle.PixelMetric = ... # 0x56
        PM_SubMenuOverlap        : QStyle.PixelMetric = ... # 0x57
        PM_TreeViewIndentation   : QStyle.PixelMetric = ... # 0x58
        PM_HeaderDefaultSectionSizeHorizontal: QStyle.PixelMetric = ... # 0x59
        PM_HeaderDefaultSectionSizeVertical: QStyle.PixelMetric = ... # 0x5a
        PM_TitleBarButtonIconSize: QStyle.PixelMetric = ... # 0x5b
        PM_TitleBarButtonSize    : QStyle.PixelMetric = ... # 0x5c
        PM_LineEditIconSize      : QStyle.PixelMetric = ... # 0x5d
        PM_LineEditIconMargin    : QStyle.PixelMetric = ... # 0x5e
        PM_CustomBase            : QStyle.PixelMetric = ... # 0xf0000000

    class PrimitiveElement(enum.IntEnum):

        PE_Frame                 : QStyle.PrimitiveElement = ... # 0x0
        PE_FrameDefaultButton    : QStyle.PrimitiveElement = ... # 0x1
        PE_FrameDockWidget       : QStyle.PrimitiveElement = ... # 0x2
        PE_FrameFocusRect        : QStyle.PrimitiveElement = ... # 0x3
        PE_FrameGroupBox         : QStyle.PrimitiveElement = ... # 0x4
        PE_FrameLineEdit         : QStyle.PrimitiveElement = ... # 0x5
        PE_FrameMenu             : QStyle.PrimitiveElement = ... # 0x6
        PE_FrameStatusBarItem    : QStyle.PrimitiveElement = ... # 0x7
        PE_FrameTabWidget        : QStyle.PrimitiveElement = ... # 0x8
        PE_FrameWindow           : QStyle.PrimitiveElement = ... # 0x9
        PE_FrameButtonBevel      : QStyle.PrimitiveElement = ... # 0xa
        PE_FrameButtonTool       : QStyle.PrimitiveElement = ... # 0xb
        PE_FrameTabBarBase       : QStyle.PrimitiveElement = ... # 0xc
        PE_PanelButtonCommand    : QStyle.PrimitiveElement = ... # 0xd
        PE_PanelButtonBevel      : QStyle.PrimitiveElement = ... # 0xe
        PE_PanelButtonTool       : QStyle.PrimitiveElement = ... # 0xf
        PE_PanelMenuBar          : QStyle.PrimitiveElement = ... # 0x10
        PE_PanelToolBar          : QStyle.PrimitiveElement = ... # 0x11
        PE_PanelLineEdit         : QStyle.PrimitiveElement = ... # 0x12
        PE_IndicatorArrowDown    : QStyle.PrimitiveElement = ... # 0x13
        PE_IndicatorArrowLeft    : QStyle.PrimitiveElement = ... # 0x14
        PE_IndicatorArrowRight   : QStyle.PrimitiveElement = ... # 0x15
        PE_IndicatorArrowUp      : QStyle.PrimitiveElement = ... # 0x16
        PE_IndicatorBranch       : QStyle.PrimitiveElement = ... # 0x17
        PE_IndicatorButtonDropDown: QStyle.PrimitiveElement = ... # 0x18
        PE_IndicatorItemViewItemCheck: QStyle.PrimitiveElement = ... # 0x19
        PE_IndicatorCheckBox     : QStyle.PrimitiveElement = ... # 0x1a
        PE_IndicatorDockWidgetResizeHandle: QStyle.PrimitiveElement = ... # 0x1b
        PE_IndicatorHeaderArrow  : QStyle.PrimitiveElement = ... # 0x1c
        PE_IndicatorMenuCheckMark: QStyle.PrimitiveElement = ... # 0x1d
        PE_IndicatorProgressChunk: QStyle.PrimitiveElement = ... # 0x1e
        PE_IndicatorRadioButton  : QStyle.PrimitiveElement = ... # 0x1f
        PE_IndicatorSpinDown     : QStyle.PrimitiveElement = ... # 0x20
        PE_IndicatorSpinMinus    : QStyle.PrimitiveElement = ... # 0x21
        PE_IndicatorSpinPlus     : QStyle.PrimitiveElement = ... # 0x22
        PE_IndicatorSpinUp       : QStyle.PrimitiveElement = ... # 0x23
        PE_IndicatorToolBarHandle: QStyle.PrimitiveElement = ... # 0x24
        PE_IndicatorToolBarSeparator: QStyle.PrimitiveElement = ... # 0x25
        PE_PanelTipLabel         : QStyle.PrimitiveElement = ... # 0x26
        PE_IndicatorTabTear      : QStyle.PrimitiveElement = ... # 0x27
        PE_IndicatorTabTearLeft  : QStyle.PrimitiveElement = ... # 0x27
        PE_PanelScrollAreaCorner : QStyle.PrimitiveElement = ... # 0x28
        PE_Widget                : QStyle.PrimitiveElement = ... # 0x29
        PE_IndicatorColumnViewArrow: QStyle.PrimitiveElement = ... # 0x2a
        PE_IndicatorItemViewItemDrop: QStyle.PrimitiveElement = ... # 0x2b
        PE_PanelItemViewItem     : QStyle.PrimitiveElement = ... # 0x2c
        PE_PanelItemViewRow      : QStyle.PrimitiveElement = ... # 0x2d
        PE_PanelStatusBar        : QStyle.PrimitiveElement = ... # 0x2e
        PE_IndicatorTabClose     : QStyle.PrimitiveElement = ... # 0x2f
        PE_PanelMenu             : QStyle.PrimitiveElement = ... # 0x30
        PE_IndicatorTabTearRight : QStyle.PrimitiveElement = ... # 0x31
        PE_CustomBase            : QStyle.PrimitiveElement = ... # 0xf000000

    class RequestSoftwareInputPanel(enum.Enum):

        RSIP_OnMouseClickAndAlreadyFocused: QStyle.RequestSoftwareInputPanel = ... # 0x0
        RSIP_OnMouseClick        : QStyle.RequestSoftwareInputPanel = ... # 0x1

    class StandardPixmap(enum.IntEnum):

        SP_TitleBarMenuButton    : QStyle.StandardPixmap = ... # 0x0
        SP_TitleBarMinButton     : QStyle.StandardPixmap = ... # 0x1
        SP_TitleBarMaxButton     : QStyle.StandardPixmap = ... # 0x2
        SP_TitleBarCloseButton   : QStyle.StandardPixmap = ... # 0x3
        SP_TitleBarNormalButton  : QStyle.StandardPixmap = ... # 0x4
        SP_TitleBarShadeButton   : QStyle.StandardPixmap = ... # 0x5
        SP_TitleBarUnshadeButton : QStyle.StandardPixmap = ... # 0x6
        SP_TitleBarContextHelpButton: QStyle.StandardPixmap = ... # 0x7
        SP_DockWidgetCloseButton : QStyle.StandardPixmap = ... # 0x8
        SP_MessageBoxInformation : QStyle.StandardPixmap = ... # 0x9
        SP_MessageBoxWarning     : QStyle.StandardPixmap = ... # 0xa
        SP_MessageBoxCritical    : QStyle.StandardPixmap = ... # 0xb
        SP_MessageBoxQuestion    : QStyle.StandardPixmap = ... # 0xc
        SP_DesktopIcon           : QStyle.StandardPixmap = ... # 0xd
        SP_TrashIcon             : QStyle.StandardPixmap = ... # 0xe
        SP_ComputerIcon          : QStyle.StandardPixmap = ... # 0xf
        SP_DriveFDIcon           : QStyle.StandardPixmap = ... # 0x10
        SP_DriveHDIcon           : QStyle.StandardPixmap = ... # 0x11
        SP_DriveCDIcon           : QStyle.StandardPixmap = ... # 0x12
        SP_DriveDVDIcon          : QStyle.StandardPixmap = ... # 0x13
        SP_DriveNetIcon          : QStyle.StandardPixmap = ... # 0x14
        SP_DirOpenIcon           : QStyle.StandardPixmap = ... # 0x15
        SP_DirClosedIcon         : QStyle.StandardPixmap = ... # 0x16
        SP_DirLinkIcon           : QStyle.StandardPixmap = ... # 0x17
        SP_DirLinkOpenIcon       : QStyle.StandardPixmap = ... # 0x18
        SP_FileIcon              : QStyle.StandardPixmap = ... # 0x19
        SP_FileLinkIcon          : QStyle.StandardPixmap = ... # 0x1a
        SP_ToolBarHorizontalExtensionButton: QStyle.StandardPixmap = ... # 0x1b
        SP_ToolBarVerticalExtensionButton: QStyle.StandardPixmap = ... # 0x1c
        SP_FileDialogStart       : QStyle.StandardPixmap = ... # 0x1d
        SP_FileDialogEnd         : QStyle.StandardPixmap = ... # 0x1e
        SP_FileDialogToParent    : QStyle.StandardPixmap = ... # 0x1f
        SP_FileDialogNewFolder   : QStyle.StandardPixmap = ... # 0x20
        SP_FileDialogDetailedView: QStyle.StandardPixmap = ... # 0x21
        SP_FileDialogInfoView    : QStyle.StandardPixmap = ... # 0x22
        SP_FileDialogContentsView: QStyle.StandardPixmap = ... # 0x23
        SP_FileDialogListView    : QStyle.StandardPixmap = ... # 0x24
        SP_FileDialogBack        : QStyle.StandardPixmap = ... # 0x25
        SP_DirIcon               : QStyle.StandardPixmap = ... # 0x26
        SP_DialogOkButton        : QStyle.StandardPixmap = ... # 0x27
        SP_DialogCancelButton    : QStyle.StandardPixmap = ... # 0x28
        SP_DialogHelpButton      : QStyle.StandardPixmap = ... # 0x29
        SP_DialogOpenButton      : QStyle.StandardPixmap = ... # 0x2a
        SP_DialogSaveButton      : QStyle.StandardPixmap = ... # 0x2b
        SP_DialogCloseButton     : QStyle.StandardPixmap = ... # 0x2c
        SP_DialogApplyButton     : QStyle.StandardPixmap = ... # 0x2d
        SP_DialogResetButton     : QStyle.StandardPixmap = ... # 0x2e
        SP_DialogDiscardButton   : QStyle.StandardPixmap = ... # 0x2f
        SP_DialogYesButton       : QStyle.StandardPixmap = ... # 0x30
        SP_DialogNoButton        : QStyle.StandardPixmap = ... # 0x31
        SP_ArrowUp               : QStyle.StandardPixmap = ... # 0x32
        SP_ArrowDown             : QStyle.StandardPixmap = ... # 0x33
        SP_ArrowLeft             : QStyle.StandardPixmap = ... # 0x34
        SP_ArrowRight            : QStyle.StandardPixmap = ... # 0x35
        SP_ArrowBack             : QStyle.StandardPixmap = ... # 0x36
        SP_ArrowForward          : QStyle.StandardPixmap = ... # 0x37
        SP_DirHomeIcon           : QStyle.StandardPixmap = ... # 0x38
        SP_CommandLink           : QStyle.StandardPixmap = ... # 0x39
        SP_VistaShield           : QStyle.StandardPixmap = ... # 0x3a
        SP_BrowserReload         : QStyle.StandardPixmap = ... # 0x3b
        SP_BrowserStop           : QStyle.StandardPixmap = ... # 0x3c
        SP_MediaPlay             : QStyle.StandardPixmap = ... # 0x3d
        SP_MediaStop             : QStyle.StandardPixmap = ... # 0x3e
        SP_MediaPause            : QStyle.StandardPixmap = ... # 0x3f
        SP_MediaSkipForward      : QStyle.StandardPixmap = ... # 0x40
        SP_MediaSkipBackward     : QStyle.StandardPixmap = ... # 0x41
        SP_MediaSeekForward      : QStyle.StandardPixmap = ... # 0x42
        SP_MediaSeekBackward     : QStyle.StandardPixmap = ... # 0x43
        SP_MediaVolume           : QStyle.StandardPixmap = ... # 0x44
        SP_MediaVolumeMuted      : QStyle.StandardPixmap = ... # 0x45
        SP_LineEditClearButton   : QStyle.StandardPixmap = ... # 0x46
        SP_DialogYesToAllButton  : QStyle.StandardPixmap = ... # 0x47
        SP_DialogNoToAllButton   : QStyle.StandardPixmap = ... # 0x48
        SP_DialogSaveAllButton   : QStyle.StandardPixmap = ... # 0x49
        SP_DialogAbortButton     : QStyle.StandardPixmap = ... # 0x4a
        SP_DialogRetryButton     : QStyle.StandardPixmap = ... # 0x4b
        SP_DialogIgnoreButton    : QStyle.StandardPixmap = ... # 0x4c
        SP_RestoreDefaultsButton : QStyle.StandardPixmap = ... # 0x4d
        SP_TabCloseButton        : QStyle.StandardPixmap = ... # 0x4e
        NStandardPixmap          : QStyle.StandardPixmap = ... # 0x4f
        SP_CustomBase            : QStyle.StandardPixmap = ... # 0xf0000000

    class StateFlag(enum.Flag):

        State_None               : QStyle.StateFlag = ... # 0x0
        State_Enabled            : QStyle.StateFlag = ... # 0x1
        State_Raised             : QStyle.StateFlag = ... # 0x2
        State_Sunken             : QStyle.StateFlag = ... # 0x4
        State_Off                : QStyle.StateFlag = ... # 0x8
        State_NoChange           : QStyle.StateFlag = ... # 0x10
        State_On                 : QStyle.StateFlag = ... # 0x20
        State_DownArrow          : QStyle.StateFlag = ... # 0x40
        State_Horizontal         : QStyle.StateFlag = ... # 0x80
        State_HasFocus           : QStyle.StateFlag = ... # 0x100
        State_Top                : QStyle.StateFlag = ... # 0x200
        State_Bottom             : QStyle.StateFlag = ... # 0x400
        State_FocusAtBorder      : QStyle.StateFlag = ... # 0x800
        State_AutoRaise          : QStyle.StateFlag = ... # 0x1000
        State_MouseOver          : QStyle.StateFlag = ... # 0x2000
        State_UpArrow            : QStyle.StateFlag = ... # 0x4000
        State_Selected           : QStyle.StateFlag = ... # 0x8000
        State_Active             : QStyle.StateFlag = ... # 0x10000
        State_Window             : QStyle.StateFlag = ... # 0x20000
        State_Open               : QStyle.StateFlag = ... # 0x40000
        State_Children           : QStyle.StateFlag = ... # 0x80000
        State_Item               : QStyle.StateFlag = ... # 0x100000
        State_Sibling            : QStyle.StateFlag = ... # 0x200000
        State_Editing            : QStyle.StateFlag = ... # 0x400000
        State_KeyboardFocusChange: QStyle.StateFlag = ... # 0x800000
        State_ReadOnly           : QStyle.StateFlag = ... # 0x2000000
        State_Small              : QStyle.StateFlag = ... # 0x4000000
        State_Mini               : QStyle.StateFlag = ... # 0x8000000

    class StyleHint(enum.IntEnum):

        SH_EtchDisabledText      : QStyle.StyleHint = ... # 0x0
        SH_DitherDisabledText    : QStyle.StyleHint = ... # 0x1
        SH_ScrollBar_MiddleClickAbsolutePosition: QStyle.StyleHint = ... # 0x2
        SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle.StyleHint = ... # 0x3
        SH_TabBar_SelectMouseType: QStyle.StyleHint = ... # 0x4
        SH_TabBar_Alignment      : QStyle.StyleHint = ... # 0x5
        SH_Header_ArrowAlignment : QStyle.StyleHint = ... # 0x6
        SH_Slider_SnapToValue    : QStyle.StyleHint = ... # 0x7
        SH_Slider_SloppyKeyEvents: QStyle.StyleHint = ... # 0x8
        SH_ProgressDialog_CenterCancelButton: QStyle.StyleHint = ... # 0x9
        SH_ProgressDialog_TextLabelAlignment: QStyle.StyleHint = ... # 0xa
        SH_PrintDialog_RightAlignButtons: QStyle.StyleHint = ... # 0xb
        SH_MainWindow_SpaceBelowMenuBar: QStyle.StyleHint = ... # 0xc
        SH_FontDialog_SelectAssociatedText: QStyle.StyleHint = ... # 0xd
        SH_Menu_AllowActiveAndDisabled: QStyle.StyleHint = ... # 0xe
        SH_Menu_SpaceActivatesItem: QStyle.StyleHint = ... # 0xf
        SH_Menu_SubMenuPopupDelay: QStyle.StyleHint = ... # 0x10
        SH_ScrollView_FrameOnlyAroundContents: QStyle.StyleHint = ... # 0x11
        SH_MenuBar_AltKeyNavigation: QStyle.StyleHint = ... # 0x12
        SH_ComboBox_ListMouseTracking: QStyle.StyleHint = ... # 0x13
        SH_Menu_MouseTracking    : QStyle.StyleHint = ... # 0x14
        SH_MenuBar_MouseTracking : QStyle.StyleHint = ... # 0x15
        SH_ItemView_ChangeHighlightOnFocus: QStyle.StyleHint = ... # 0x16
        SH_Widget_ShareActivation: QStyle.StyleHint = ... # 0x17
        SH_Workspace_FillSpaceOnMaximize: QStyle.StyleHint = ... # 0x18
        SH_ComboBox_Popup        : QStyle.StyleHint = ... # 0x19
        SH_TitleBar_NoBorder     : QStyle.StyleHint = ... # 0x1a
        SH_Slider_StopMouseOverSlider: QStyle.StyleHint = ... # 0x1b
        SH_BlinkCursorWhenTextSelected: QStyle.StyleHint = ... # 0x1c
        SH_RichText_FullWidthSelection: QStyle.StyleHint = ... # 0x1d
        SH_Menu_Scrollable       : QStyle.StyleHint = ... # 0x1e
        SH_GroupBox_TextLabelVerticalAlignment: QStyle.StyleHint = ... # 0x1f
        SH_GroupBox_TextLabelColor: QStyle.StyleHint = ... # 0x20
        SH_Menu_SloppySubMenus   : QStyle.StyleHint = ... # 0x21
        SH_Table_GridLineColor   : QStyle.StyleHint = ... # 0x22
        SH_LineEdit_PasswordCharacter: QStyle.StyleHint = ... # 0x23
        SH_DialogButtons_DefaultButton: QStyle.StyleHint = ... # 0x24
        SH_ToolBox_SelectedPageTitleBold: QStyle.StyleHint = ... # 0x25
        SH_TabBar_PreferNoArrows : QStyle.StyleHint = ... # 0x26
        SH_ScrollBar_LeftClickAbsolutePosition: QStyle.StyleHint = ... # 0x27
        SH_ListViewExpand_SelectMouseType: QStyle.StyleHint = ... # 0x28
        SH_UnderlineShortcut     : QStyle.StyleHint = ... # 0x29
        SH_SpinBox_AnimateButton : QStyle.StyleHint = ... # 0x2a
        SH_SpinBox_KeyPressAutoRepeatRate: QStyle.StyleHint = ... # 0x2b
        SH_SpinBox_ClickAutoRepeatRate: QStyle.StyleHint = ... # 0x2c
        SH_Menu_FillScreenWithScroll: QStyle.StyleHint = ... # 0x2d
        SH_ToolTipLabel_Opacity  : QStyle.StyleHint = ... # 0x2e
        SH_DrawMenuBarSeparator  : QStyle.StyleHint = ... # 0x2f
        SH_TitleBar_ModifyNotification: QStyle.StyleHint = ... # 0x30
        SH_Button_FocusPolicy    : QStyle.StyleHint = ... # 0x31
        SH_MessageBox_UseBorderForButtonSpacing: QStyle.StyleHint = ... # 0x32
        SH_TitleBar_AutoRaise    : QStyle.StyleHint = ... # 0x33
        SH_ToolButton_PopupDelay : QStyle.StyleHint = ... # 0x34
        SH_FocusFrame_Mask       : QStyle.StyleHint = ... # 0x35
        SH_RubberBand_Mask       : QStyle.StyleHint = ... # 0x36
        SH_WindowFrame_Mask      : QStyle.StyleHint = ... # 0x37
        SH_SpinControls_DisableOnBounds: QStyle.StyleHint = ... # 0x38
        SH_Dial_BackgroundRole   : QStyle.StyleHint = ... # 0x39
        SH_ComboBox_LayoutDirection: QStyle.StyleHint = ... # 0x3a
        SH_ItemView_EllipsisLocation: QStyle.StyleHint = ... # 0x3b
        SH_ItemView_ShowDecorationSelected: QStyle.StyleHint = ... # 0x3c
        SH_ItemView_ActivateItemOnSingleClick: QStyle.StyleHint = ... # 0x3d
        SH_ScrollBar_ContextMenu : QStyle.StyleHint = ... # 0x3e
        SH_ScrollBar_RollBetweenButtons: QStyle.StyleHint = ... # 0x3f
        SH_Slider_AbsoluteSetButtons: QStyle.StyleHint = ... # 0x40
        SH_Slider_PageSetButtons : QStyle.StyleHint = ... # 0x41
        SH_Menu_KeyboardSearch   : QStyle.StyleHint = ... # 0x42
        SH_TabBar_ElideMode      : QStyle.StyleHint = ... # 0x43
        SH_DialogButtonLayout    : QStyle.StyleHint = ... # 0x44
        SH_ComboBox_PopupFrameStyle: QStyle.StyleHint = ... # 0x45
        SH_MessageBox_TextInteractionFlags: QStyle.StyleHint = ... # 0x46
        SH_DialogButtonBox_ButtonsHaveIcons: QStyle.StyleHint = ... # 0x47
        SH_MessageBox_CenterButtons: QStyle.StyleHint = ... # 0x48
        SH_Menu_SelectionWrap    : QStyle.StyleHint = ... # 0x49
        SH_ItemView_MovementWithoutUpdatingSelection: QStyle.StyleHint = ... # 0x4a
        SH_ToolTip_Mask          : QStyle.StyleHint = ... # 0x4b
        SH_FocusFrame_AboveWidget: QStyle.StyleHint = ... # 0x4c
        SH_TextControl_FocusIndicatorTextCharFormat: QStyle.StyleHint = ... # 0x4d
        SH_WizardStyle           : QStyle.StyleHint = ... # 0x4e
        SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle.StyleHint = ... # 0x4f
        SH_Menu_Mask             : QStyle.StyleHint = ... # 0x50
        SH_Menu_FlashTriggeredItem: QStyle.StyleHint = ... # 0x51
        SH_Menu_FadeOutOnHide    : QStyle.StyleHint = ... # 0x52
        SH_SpinBox_ClickAutoRepeatThreshold: QStyle.StyleHint = ... # 0x53
        SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle.StyleHint = ... # 0x54
        SH_FormLayoutWrapPolicy  : QStyle.StyleHint = ... # 0x55
        SH_TabWidget_DefaultTabPosition: QStyle.StyleHint = ... # 0x56
        SH_ToolBar_Movable       : QStyle.StyleHint = ... # 0x57
        SH_FormLayoutFieldGrowthPolicy: QStyle.StyleHint = ... # 0x58
        SH_FormLayoutFormAlignment: QStyle.StyleHint = ... # 0x59
        SH_FormLayoutLabelAlignment: QStyle.StyleHint = ... # 0x5a
        SH_ItemView_DrawDelegateFrame: QStyle.StyleHint = ... # 0x5b
        SH_TabBar_CloseButtonPosition: QStyle.StyleHint = ... # 0x5c
        SH_DockWidget_ButtonsHaveFrame: QStyle.StyleHint = ... # 0x5d
        SH_ToolButtonStyle       : QStyle.StyleHint = ... # 0x5e
        SH_RequestSoftwareInputPanel: QStyle.StyleHint = ... # 0x5f
        SH_ScrollBar_Transient   : QStyle.StyleHint = ... # 0x60
        SH_Menu_SupportsSections : QStyle.StyleHint = ... # 0x61
        SH_ToolTip_WakeUpDelay   : QStyle.StyleHint = ... # 0x62
        SH_ToolTip_FallAsleepDelay: QStyle.StyleHint = ... # 0x63
        SH_Widget_Animate        : QStyle.StyleHint = ... # 0x64
        SH_Splitter_OpaqueResize : QStyle.StyleHint = ... # 0x65
        SH_ComboBox_UseNativePopup: QStyle.StyleHint = ... # 0x66
        SH_LineEdit_PasswordMaskDelay: QStyle.StyleHint = ... # 0x67
        SH_TabBar_ChangeCurrentDelay: QStyle.StyleHint = ... # 0x68
        SH_Menu_SubMenuUniDirection: QStyle.StyleHint = ... # 0x69
        SH_Menu_SubMenuUniDirectionFailCount: QStyle.StyleHint = ... # 0x6a
        SH_Menu_SubMenuSloppySelectOtherActions: QStyle.StyleHint = ... # 0x6b
        SH_Menu_SubMenuSloppyCloseTimeout: QStyle.StyleHint = ... # 0x6c
        SH_Menu_SubMenuResetWhenReenteringParent: QStyle.StyleHint = ... # 0x6d
        SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle.StyleHint = ... # 0x6e
        SH_ItemView_ScrollMode   : QStyle.StyleHint = ... # 0x6f
        SH_TitleBar_ShowToolTipsOnButtons: QStyle.StyleHint = ... # 0x70
        SH_Widget_Animation_Duration: QStyle.StyleHint = ... # 0x71
        SH_ComboBox_AllowWheelScrolling: QStyle.StyleHint = ... # 0x72
        SH_SpinBox_ButtonsInsideFrame: QStyle.StyleHint = ... # 0x73
        SH_SpinBox_StepModifier  : QStyle.StyleHint = ... # 0x74
        SH_TabBar_AllowWheelScrolling: QStyle.StyleHint = ... # 0x75
        SH_Table_AlwaysDrawLeftTopGridLines: QStyle.StyleHint = ... # 0x76
        SH_SpinBox_SelectOnStep  : QStyle.StyleHint = ... # 0x77
        SH_CustomBase            : QStyle.StyleHint = ... # 0xf0000000

    class SubControl(enum.Flag):

        SC_None                  : QStyle.SubControl = ... # 0x0
        SC_ComboBoxFrame         : QStyle.SubControl = ... # 0x1
        SC_DialGroove            : QStyle.SubControl = ... # 0x1
        SC_GroupBoxCheckBox      : QStyle.SubControl = ... # 0x1
        SC_MdiMinButton          : QStyle.SubControl = ... # 0x1
        SC_ScrollBarAddLine      : QStyle.SubControl = ... # 0x1
        SC_SliderGroove          : QStyle.SubControl = ... # 0x1
        SC_SpinBoxUp             : QStyle.SubControl = ... # 0x1
        SC_TitleBarSysMenu       : QStyle.SubControl = ... # 0x1
        SC_ToolButton            : QStyle.SubControl = ... # 0x1
        SC_ComboBoxEditField     : QStyle.SubControl = ... # 0x2
        SC_DialHandle            : QStyle.SubControl = ... # 0x2
        SC_GroupBoxLabel         : QStyle.SubControl = ... # 0x2
        SC_MdiNormalButton       : QStyle.SubControl = ... # 0x2
        SC_ScrollBarSubLine      : QStyle.SubControl = ... # 0x2
        SC_SliderHandle          : QStyle.SubControl = ... # 0x2
        SC_SpinBoxDown           : QStyle.SubControl = ... # 0x2
        SC_TitleBarMinButton     : QStyle.SubControl = ... # 0x2
        SC_ToolButtonMenu        : QStyle.SubControl = ... # 0x2
        SC_ComboBoxArrow         : QStyle.SubControl = ... # 0x4
        SC_DialTickmarks         : QStyle.SubControl = ... # 0x4
        SC_GroupBoxContents      : QStyle.SubControl = ... # 0x4
        SC_MdiCloseButton        : QStyle.SubControl = ... # 0x4
        SC_ScrollBarAddPage      : QStyle.SubControl = ... # 0x4
        SC_SliderTickmarks       : QStyle.SubControl = ... # 0x4
        SC_SpinBoxFrame          : QStyle.SubControl = ... # 0x4
        SC_TitleBarMaxButton     : QStyle.SubControl = ... # 0x4
        SC_ComboBoxListBoxPopup  : QStyle.SubControl = ... # 0x8
        SC_GroupBoxFrame         : QStyle.SubControl = ... # 0x8
        SC_ScrollBarSubPage      : QStyle.SubControl = ... # 0x8
        SC_SpinBoxEditField      : QStyle.SubControl = ... # 0x8
        SC_TitleBarCloseButton   : QStyle.SubControl = ... # 0x8
        SC_ScrollBarFirst        : QStyle.SubControl = ... # 0x10
        SC_TitleBarNormalButton  : QStyle.SubControl = ... # 0x10
        SC_ScrollBarLast         : QStyle.SubControl = ... # 0x20
        SC_TitleBarShadeButton   : QStyle.SubControl = ... # 0x20
        SC_ScrollBarSlider       : QStyle.SubControl = ... # 0x40
        SC_TitleBarUnshadeButton : QStyle.SubControl = ... # 0x40
        SC_ScrollBarGroove       : QStyle.SubControl = ... # 0x80
        SC_TitleBarContextHelpButton: QStyle.SubControl = ... # 0x80
        SC_TitleBarLabel         : QStyle.SubControl = ... # 0x100
        SC_CustomBase            : QStyle.SubControl = ... # 0xf0000000
        SC_All                   : QStyle.SubControl = ... # 0xffffffff

    class SubElement(enum.IntEnum):

        SE_PushButtonContents    : QStyle.SubElement = ... # 0x0
        SE_PushButtonFocusRect   : QStyle.SubElement = ... # 0x1
        SE_CheckBoxIndicator     : QStyle.SubElement = ... # 0x2
        SE_CheckBoxContents      : QStyle.SubElement = ... # 0x3
        SE_CheckBoxFocusRect     : QStyle.SubElement = ... # 0x4
        SE_CheckBoxClickRect     : QStyle.SubElement = ... # 0x5
        SE_RadioButtonIndicator  : QStyle.SubElement = ... # 0x6
        SE_RadioButtonContents   : QStyle.SubElement = ... # 0x7
        SE_RadioButtonFocusRect  : QStyle.SubElement = ... # 0x8
        SE_RadioButtonClickRect  : QStyle.SubElement = ... # 0x9
        SE_ComboBoxFocusRect     : QStyle.SubElement = ... # 0xa
        SE_SliderFocusRect       : QStyle.SubElement = ... # 0xb
        SE_ProgressBarGroove     : QStyle.SubElement = ... # 0xc
        SE_ProgressBarContents   : QStyle.SubElement = ... # 0xd
        SE_ProgressBarLabel      : QStyle.SubElement = ... # 0xe
        SE_ToolBoxTabContents    : QStyle.SubElement = ... # 0xf
        SE_HeaderLabel           : QStyle.SubElement = ... # 0x10
        SE_HeaderArrow           : QStyle.SubElement = ... # 0x11
        SE_TabWidgetTabBar       : QStyle.SubElement = ... # 0x12
        SE_TabWidgetTabPane      : QStyle.SubElement = ... # 0x13
        SE_TabWidgetTabContents  : QStyle.SubElement = ... # 0x14
        SE_TabWidgetLeftCorner   : QStyle.SubElement = ... # 0x15
        SE_TabWidgetRightCorner  : QStyle.SubElement = ... # 0x16
        SE_ItemViewItemCheckIndicator: QStyle.SubElement = ... # 0x17
        SE_TabBarTearIndicator   : QStyle.SubElement = ... # 0x18
        SE_TabBarTearIndicatorLeft: QStyle.SubElement = ... # 0x18
        SE_TreeViewDisclosureItem: QStyle.SubElement = ... # 0x19
        SE_LineEditContents      : QStyle.SubElement = ... # 0x1a
        SE_FrameContents         : QStyle.SubElement = ... # 0x1b
        SE_DockWidgetCloseButton : QStyle.SubElement = ... # 0x1c
        SE_DockWidgetFloatButton : QStyle.SubElement = ... # 0x1d
        SE_DockWidgetTitleBarText: QStyle.SubElement = ... # 0x1e
        SE_DockWidgetIcon        : QStyle.SubElement = ... # 0x1f
        SE_CheckBoxLayoutItem    : QStyle.SubElement = ... # 0x20
        SE_ComboBoxLayoutItem    : QStyle.SubElement = ... # 0x21
        SE_DateTimeEditLayoutItem: QStyle.SubElement = ... # 0x22
        SE_LabelLayoutItem       : QStyle.SubElement = ... # 0x23
        SE_ProgressBarLayoutItem : QStyle.SubElement = ... # 0x24
        SE_PushButtonLayoutItem  : QStyle.SubElement = ... # 0x25
        SE_RadioButtonLayoutItem : QStyle.SubElement = ... # 0x26
        SE_SliderLayoutItem      : QStyle.SubElement = ... # 0x27
        SE_SpinBoxLayoutItem     : QStyle.SubElement = ... # 0x28
        SE_ToolButtonLayoutItem  : QStyle.SubElement = ... # 0x29
        SE_FrameLayoutItem       : QStyle.SubElement = ... # 0x2a
        SE_GroupBoxLayoutItem    : QStyle.SubElement = ... # 0x2b
        SE_TabWidgetLayoutItem   : QStyle.SubElement = ... # 0x2c
        SE_ItemViewItemDecoration: QStyle.SubElement = ... # 0x2d
        SE_ItemViewItemText      : QStyle.SubElement = ... # 0x2e
        SE_ItemViewItemFocusRect : QStyle.SubElement = ... # 0x2f
        SE_TabBarTabLeftButton   : QStyle.SubElement = ... # 0x30
        SE_TabBarTabRightButton  : QStyle.SubElement = ... # 0x31
        SE_TabBarTabText         : QStyle.SubElement = ... # 0x32
        SE_ShapedFrameContents   : QStyle.SubElement = ... # 0x33
        SE_ToolBarHandle         : QStyle.SubElement = ... # 0x34
        SE_TabBarScrollLeftButton: QStyle.SubElement = ... # 0x35
        SE_TabBarScrollRightButton: QStyle.SubElement = ... # 0x36
        SE_TabBarTearIndicatorRight: QStyle.SubElement = ... # 0x37
        SE_PushButtonBevel       : QStyle.SubElement = ... # 0x38
        SE_CustomBase            : QStyle.SubElement = ... # 0xf0000000


    def __init__(self) -> None: ...

    @staticmethod
    def alignedRect(direction: PySide6.QtCore.Qt.LayoutDirection, alignment: PySide6.QtCore.Qt.AlignmentFlag, size: PySide6.QtCore.QSize, rectangle: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...
    def combinedLayoutSpacing(self, controls1: PySide6.QtWidgets.QSizePolicy.ControlType, controls2: PySide6.QtWidgets.QSizePolicy.ControlType, orientation: PySide6.QtCore.Qt.Orientation, option: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> int: ...
    def drawComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, p: PySide6.QtGui.QPainter, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def drawControl(self, element: PySide6.QtWidgets.QStyle.ControlElement, opt: PySide6.QtWidgets.QStyleOption, p: PySide6.QtGui.QPainter, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def drawItemPixmap(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, alignment: int, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def drawItemText(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, flags: int, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], enabled: bool, text: str, textRole: PySide6.QtGui.QPalette.ColorRole = ...) -> None: ...
    def drawPrimitive(self, pe: PySide6.QtWidgets.QStyle.PrimitiveElement, opt: PySide6.QtWidgets.QStyleOption, p: PySide6.QtGui.QPainter, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    def generatedIconPixmap(self, iconMode: PySide6.QtGui.QIcon.Mode, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str], opt: PySide6.QtWidgets.QStyleOption) -> PySide6.QtGui.QPixmap: ...
    def hitTestComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, pt: PySide6.QtCore.QPoint, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtWidgets.QStyle.SubControl: ...
    def itemPixmapRect(self, r: PySide6.QtCore.QRect, flags: int, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> PySide6.QtCore.QRect: ...
    def itemTextRect(self, fm: PySide6.QtGui.QFontMetrics, r: PySide6.QtCore.QRect, flags: int, enabled: bool, text: str) -> PySide6.QtCore.QRect: ...
    def layoutSpacing(self, control1: PySide6.QtWidgets.QSizePolicy.ControlType, control2: PySide6.QtWidgets.QSizePolicy.ControlType, orientation: PySide6.QtCore.Qt.Orientation, option: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> int: ...
    def name(self) -> str: ...
    def pixelMetric(self, metric: PySide6.QtWidgets.QStyle.PixelMetric, option: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> int: ...
    @overload
    def polish(self, application: PySide6.QtWidgets.QApplication) -> None: ...
    @overload
    def polish(self, palette: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @overload
    def polish(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def proxy(self) -> PySide6.QtWidgets.QStyle: ...
    def sizeFromContents(self, ct: PySide6.QtWidgets.QStyle.ContentsType, opt: PySide6.QtWidgets.QStyleOption, contentsSize: PySide6.QtCore.QSize, w: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtCore.QSize: ...
    @staticmethod
    def sliderPositionFromValue(min: int, max: int, val: int, space: int, upsideDown: bool = ...) -> int: ...
    @staticmethod
    def sliderValueFromPosition(min: int, max: int, pos: int, space: int, upsideDown: bool = ...) -> int: ...
    def standardIcon(self, standardIcon: PySide6.QtWidgets.QStyle.StandardPixmap, option: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtGui.QIcon: ...
    def standardPalette(self) -> PySide6.QtGui.QPalette: ...
    def standardPixmap(self, standardPixmap: PySide6.QtWidgets.QStyle.StandardPixmap, opt: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtGui.QPixmap: ...
    def styleHint(self, stylehint: PySide6.QtWidgets.QStyle.StyleHint, opt: Optional[PySide6.QtWidgets.QStyleOption] = ..., widget: Optional[PySide6.QtWidgets.QWidget] = ..., returnData: Optional[PySide6.QtWidgets.QStyleHintReturn] = ...) -> int: ...
    def subControlRect(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex, sc: PySide6.QtWidgets.QStyle.SubControl, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtCore.QRect: ...
    def subElementRect(self, subElement: PySide6.QtWidgets.QStyle.SubElement, option: PySide6.QtWidgets.QStyleOption, widget: Optional[PySide6.QtWidgets.QWidget] = ...) -> PySide6.QtCore.QRect: ...
    @overload
    def unpolish(self, application: PySide6.QtWidgets.QApplication) -> None: ...
    @overload
    def unpolish(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    @staticmethod
    def visualAlignment(direction: PySide6.QtCore.Qt.LayoutDirection, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    @staticmethod
    def visualPos(direction: PySide6.QtCore.Qt.LayoutDirection, boundingRect: PySide6.QtCore.QRect, logicalPos: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @staticmethod
    def visualRect(direction: PySide6.QtCore.Qt.LayoutDirection, boundingRect: PySide6.QtCore.QRect, logicalRect: PySide6.QtCore.QRect) -> PySide6.QtCore.QRect: ...


class QStyleFactory(Shiboken.Object):

    def __init__(self) -> None: ...

    @staticmethod
    def create(arg__1: str) -> PySide6.QtWidgets.QStyle: ...
    @staticmethod
    def keys() -> List[str]: ...


class QStyleHintReturn(Shiboken.Object):

    class HintReturnType(enum.Enum):

        SH_Default               : QStyleHintReturn.HintReturnType = ... # 0xf000
        SH_Mask                  : QStyleHintReturn.HintReturnType = ... # 0xf001
        SH_Variant               : QStyleHintReturn.HintReturnType = ... # 0xf002

    class StyleOptionType(enum.Enum):

        Type                     : QStyleHintReturn.StyleOptionType = ... # 0xf000

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleHintReturn.StyleOptionVersion = ... # 0x1


    def __init__(self, version: int = ..., type: int = ...) -> None: ...


class QStyleHintReturnMask(PySide6.QtWidgets.QStyleHintReturn):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleHintReturnMask.StyleOptionType = ... # 0xf001

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleHintReturnMask.StyleOptionVersion = ... # 0x1


    def __init__(self) -> None: ...


class QStyleHintReturnVariant(PySide6.QtWidgets.QStyleHintReturn):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleHintReturnVariant.StyleOptionType = ... # 0xf002

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleHintReturnVariant.StyleOptionVersion = ... # 0x1


    def __init__(self) -> None: ...


class QStyleOption(Shiboken.Object):

    class OptionType(enum.Enum):

        SO_Default               : QStyleOption.OptionType = ... # 0x0
        SO_FocusRect             : QStyleOption.OptionType = ... # 0x1
        SO_Button                : QStyleOption.OptionType = ... # 0x2
        SO_Tab                   : QStyleOption.OptionType = ... # 0x3
        SO_MenuItem              : QStyleOption.OptionType = ... # 0x4
        SO_Frame                 : QStyleOption.OptionType = ... # 0x5
        SO_ProgressBar           : QStyleOption.OptionType = ... # 0x6
        SO_ToolBox               : QStyleOption.OptionType = ... # 0x7
        SO_Header                : QStyleOption.OptionType = ... # 0x8
        SO_DockWidget            : QStyleOption.OptionType = ... # 0x9
        SO_ViewItem              : QStyleOption.OptionType = ... # 0xa
        SO_TabWidgetFrame        : QStyleOption.OptionType = ... # 0xb
        SO_TabBarBase            : QStyleOption.OptionType = ... # 0xc
        SO_RubberBand            : QStyleOption.OptionType = ... # 0xd
        SO_ToolBar               : QStyleOption.OptionType = ... # 0xe
        SO_GraphicsItem          : QStyleOption.OptionType = ... # 0xf
        SO_CustomBase            : QStyleOption.OptionType = ... # 0xf00
        SO_Complex               : QStyleOption.OptionType = ... # 0xf0000
        SO_Slider                : QStyleOption.OptionType = ... # 0xf0001
        SO_SpinBox               : QStyleOption.OptionType = ... # 0xf0002
        SO_ToolButton            : QStyleOption.OptionType = ... # 0xf0003
        SO_ComboBox              : QStyleOption.OptionType = ... # 0xf0004
        SO_TitleBar              : QStyleOption.OptionType = ... # 0xf0005
        SO_GroupBox              : QStyleOption.OptionType = ... # 0xf0006
        SO_SizeGrip              : QStyleOption.OptionType = ... # 0xf0007
        SO_ComplexCustomBase     : QStyleOption.OptionType = ... # 0xf000000

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOption.StyleOptionType = ... # 0x0

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOption.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOption) -> None: ...
    @overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...

    def initFrom(self, w: PySide6.QtWidgets.QWidget) -> None: ...


class QStyleOptionButton(PySide6.QtWidgets.QStyleOption):

    class ButtonFeature(enum.Flag):

        None_                    : QStyleOptionButton.ButtonFeature = ... # 0x0
        Flat                     : QStyleOptionButton.ButtonFeature = ... # 0x1
        HasMenu                  : QStyleOptionButton.ButtonFeature = ... # 0x2
        DefaultButton            : QStyleOptionButton.ButtonFeature = ... # 0x4
        AutoDefaultButton        : QStyleOptionButton.ButtonFeature = ... # 0x8
        CommandLinkButton        : QStyleOptionButton.ButtonFeature = ... # 0x10

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionButton.StyleOptionType = ... # 0x2

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionButton.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionButton) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionComboBox(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionComboBox.StyleOptionType = ... # 0xf0004

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionComboBox.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionComboBox) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionComplex(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionComplex.StyleOptionType = ... # 0xf0000

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionComplex.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionComplex) -> None: ...
    @overload
    def __init__(self, version: int = ..., type: int = ...) -> None: ...


class QStyleOptionDockWidget(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionDockWidget.StyleOptionType = ... # 0x9

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionDockWidget.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionDockWidget) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionFocusRect(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionFocusRect.StyleOptionType = ... # 0x1

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionFocusRect.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionFocusRect) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionFrame(PySide6.QtWidgets.QStyleOption):

    class FrameFeature(enum.Flag):

        None_                    : QStyleOptionFrame.FrameFeature = ... # 0x0
        Flat                     : QStyleOptionFrame.FrameFeature = ... # 0x1
        Rounded                  : QStyleOptionFrame.FrameFeature = ... # 0x2

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionFrame.StyleOptionType = ... # 0x5

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionFrame.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionFrame) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionGraphicsItem(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionGraphicsItem.StyleOptionType = ... # 0xf

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionGraphicsItem.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionGraphicsItem) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...

    @staticmethod
    def levelOfDetailFromTransform(worldTransform: PySide6.QtGui.QTransform) -> float: ...


class QStyleOptionGroupBox(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionGroupBox.StyleOptionType = ... # 0xf0006

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionGroupBox.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionGroupBox) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionHeader(PySide6.QtWidgets.QStyleOption):

    class SectionPosition(enum.Enum):

        Beginning                : QStyleOptionHeader.SectionPosition = ... # 0x0
        Middle                   : QStyleOptionHeader.SectionPosition = ... # 0x1
        End                      : QStyleOptionHeader.SectionPosition = ... # 0x2
        OnlyOneSection           : QStyleOptionHeader.SectionPosition = ... # 0x3

    class SelectedPosition(enum.Enum):

        NotAdjacent              : QStyleOptionHeader.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionHeader.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionHeader.SelectedPosition = ... # 0x2
        NextAndPreviousAreSelected: QStyleOptionHeader.SelectedPosition = ... # 0x3

    class SortIndicator(enum.Enum):

        None_                    : QStyleOptionHeader.SortIndicator = ... # 0x0
        SortUp                   : QStyleOptionHeader.SortIndicator = ... # 0x1
        SortDown                 : QStyleOptionHeader.SortIndicator = ... # 0x2

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionHeader.StyleOptionType = ... # 0x8

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionHeader.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionHeader) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionHeaderV2(PySide6.QtWidgets.QStyleOptionHeader):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionHeaderV2.StyleOptionType = ... # 0x8

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionHeaderV2.StyleOptionVersion = ... # 0x2


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionHeaderV2) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionMenuItem(PySide6.QtWidgets.QStyleOption):

    class CheckType(enum.Enum):

        NotCheckable             : QStyleOptionMenuItem.CheckType = ... # 0x0
        Exclusive                : QStyleOptionMenuItem.CheckType = ... # 0x1
        NonExclusive             : QStyleOptionMenuItem.CheckType = ... # 0x2

    class MenuItemType(enum.Enum):

        Normal                   : QStyleOptionMenuItem.MenuItemType = ... # 0x0
        DefaultItem              : QStyleOptionMenuItem.MenuItemType = ... # 0x1
        Separator                : QStyleOptionMenuItem.MenuItemType = ... # 0x2
        SubMenu                  : QStyleOptionMenuItem.MenuItemType = ... # 0x3
        Scroller                 : QStyleOptionMenuItem.MenuItemType = ... # 0x4
        TearOff                  : QStyleOptionMenuItem.MenuItemType = ... # 0x5
        Margin                   : QStyleOptionMenuItem.MenuItemType = ... # 0x6
        EmptyArea                : QStyleOptionMenuItem.MenuItemType = ... # 0x7

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionMenuItem.StyleOptionType = ... # 0x4

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionMenuItem.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionMenuItem) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionProgressBar(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionProgressBar.StyleOptionType = ... # 0x6

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionProgressBar.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionProgressBar) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionRubberBand(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionRubberBand.StyleOptionType = ... # 0xd

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionRubberBand.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionRubberBand) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionSizeGrip(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionSizeGrip.StyleOptionType = ... # 0xf0007

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionSizeGrip.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionSizeGrip) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionSlider(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionSlider.StyleOptionType = ... # 0xf0001

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionSlider.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionSlider) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionSpinBox(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionSpinBox.StyleOptionType = ... # 0xf0002

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionSpinBox.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionSpinBox) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTab(PySide6.QtWidgets.QStyleOption):

    class CornerWidget(enum.Flag):

        NoCornerWidgets          : QStyleOptionTab.CornerWidget = ... # 0x0
        LeftCornerWidget         : QStyleOptionTab.CornerWidget = ... # 0x1
        RightCornerWidget        : QStyleOptionTab.CornerWidget = ... # 0x2

    class SelectedPosition(enum.Enum):

        NotAdjacent              : QStyleOptionTab.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionTab.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionTab.SelectedPosition = ... # 0x2

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionTab.StyleOptionType = ... # 0x3

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionTab.StyleOptionVersion = ... # 0x1

    class TabFeature(enum.Flag):

        None_                    : QStyleOptionTab.TabFeature = ... # 0x0
        HasFrame                 : QStyleOptionTab.TabFeature = ... # 0x1

    class TabPosition(enum.Enum):

        Beginning                : QStyleOptionTab.TabPosition = ... # 0x0
        Middle                   : QStyleOptionTab.TabPosition = ... # 0x1
        End                      : QStyleOptionTab.TabPosition = ... # 0x2
        OnlyOneTab               : QStyleOptionTab.TabPosition = ... # 0x3
        Moving                   : QStyleOptionTab.TabPosition = ... # 0x4


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionTab) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTabBarBase(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionTabBarBase.StyleOptionType = ... # 0xc

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionTabBarBase.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionTabBarBase) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTabWidgetFrame(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionTabWidgetFrame.StyleOptionType = ... # 0xb

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionTabWidgetFrame.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionTabWidgetFrame) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionTitleBar(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionTitleBar.StyleOptionType = ... # 0xf0005

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionTitleBar.StyleOptionVersion = ... # 0x1


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionTitleBar) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionToolBar(PySide6.QtWidgets.QStyleOption):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionToolBar.StyleOptionType = ... # 0xe

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionToolBar.StyleOptionVersion = ... # 0x1

    class ToolBarFeature(enum.Flag):

        None_                    : QStyleOptionToolBar.ToolBarFeature = ... # 0x0
        Movable                  : QStyleOptionToolBar.ToolBarFeature = ... # 0x1

    class ToolBarPosition(enum.Enum):

        Beginning                : QStyleOptionToolBar.ToolBarPosition = ... # 0x0
        Middle                   : QStyleOptionToolBar.ToolBarPosition = ... # 0x1
        End                      : QStyleOptionToolBar.ToolBarPosition = ... # 0x2
        OnlyOne                  : QStyleOptionToolBar.ToolBarPosition = ... # 0x3


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionToolBar) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionToolBox(PySide6.QtWidgets.QStyleOption):

    class SelectedPosition(enum.Enum):

        NotAdjacent              : QStyleOptionToolBox.SelectedPosition = ... # 0x0
        NextIsSelected           : QStyleOptionToolBox.SelectedPosition = ... # 0x1
        PreviousIsSelected       : QStyleOptionToolBox.SelectedPosition = ... # 0x2

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionToolBox.StyleOptionType = ... # 0x7

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionToolBox.StyleOptionVersion = ... # 0x1

    class TabPosition(enum.Enum):

        Beginning                : QStyleOptionToolBox.TabPosition = ... # 0x0
        Middle                   : QStyleOptionToolBox.TabPosition = ... # 0x1
        End                      : QStyleOptionToolBox.TabPosition = ... # 0x2
        OnlyOneTab               : QStyleOptionToolBox.TabPosition = ... # 0x3


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionToolBox) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionToolButton(PySide6.QtWidgets.QStyleOptionComplex):

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionToolButton.StyleOptionType = ... # 0xf0003

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionToolButton.StyleOptionVersion = ... # 0x1

    class ToolButtonFeature(enum.Flag):

        None_                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x0
        Arrow                    : QStyleOptionToolButton.ToolButtonFeature = ... # 0x1
        Menu                     : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
        MenuButtonPopup          : QStyleOptionToolButton.ToolButtonFeature = ... # 0x4
        PopupDelay               : QStyleOptionToolButton.ToolButtonFeature = ... # 0x8
        HasMenu                  : QStyleOptionToolButton.ToolButtonFeature = ... # 0x10


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionToolButton) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...


class QStyleOptionViewItem(PySide6.QtWidgets.QStyleOption):

    class Position(enum.Enum):

        Left                     : QStyleOptionViewItem.Position = ... # 0x0
        Right                    : QStyleOptionViewItem.Position = ... # 0x1
        Top                      : QStyleOptionViewItem.Position = ... # 0x2
        Bottom                   : QStyleOptionViewItem.Position = ... # 0x3

    class StyleOptionType(enum.Enum):

        Type                     : QStyleOptionViewItem.StyleOptionType = ... # 0xa

    class StyleOptionVersion(enum.Enum):

        Version                  : QStyleOptionViewItem.StyleOptionVersion = ... # 0x1

    class ViewItemFeature(enum.Flag):

        None_                    : QStyleOptionViewItem.ViewItemFeature = ... # 0x0
        WrapText                 : QStyleOptionViewItem.ViewItemFeature = ... # 0x1
        Alternate                : QStyleOptionViewItem.ViewItemFeature = ... # 0x2
        HasCheckIndicator        : QStyleOptionViewItem.ViewItemFeature = ... # 0x4
        HasDisplay               : QStyleOptionViewItem.ViewItemFeature = ... # 0x8
        HasDecoration            : QStyleOptionViewItem.ViewItemFeature = ... # 0x10

    class ViewItemPosition(enum.Enum):

        Invalid                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x0
        Beginning                : QStyleOptionViewItem.ViewItemPosition = ... # 0x1
        Middle                   : QStyleOptionViewItem.ViewItemPosition = ... # 0x2
        End                      : QStyleOptionViewItem.ViewItemPosition = ... # 0x3
        OnlyOne                  : QStyleOptionViewItem.ViewItemPosition = ... # 0x4


    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QStyleOptionViewItem) -> None: ...
    @overload
    def __init__(self, version: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QStylePainter(PySide6.QtGui.QPainter):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, pd: PySide6.QtGui.QPaintDevice, w: PySide6.QtWidgets.QWidget) -> None: ...
    @overload
    def __init__(self, w: PySide6.QtWidgets.QWidget) -> None: ...

    @overload
    def begin(self, pd: PySide6.QtGui.QPaintDevice, w: PySide6.QtWidgets.QWidget) -> bool: ...
    @overload
    def begin(self, w: PySide6.QtWidgets.QWidget) -> bool: ...
    def drawComplexControl(self, cc: PySide6.QtWidgets.QStyle.ComplexControl, opt: PySide6.QtWidgets.QStyleOptionComplex) -> None: ...
    def drawControl(self, ce: PySide6.QtWidgets.QStyle.ControlElement, opt: PySide6.QtWidgets.QStyleOption) -> None: ...
    def drawItemPixmap(self, r: PySide6.QtCore.QRect, flags: int, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def drawItemText(self, r: PySide6.QtCore.QRect, flags: int, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], enabled: bool, text: str, textRole: PySide6.QtGui.QPalette.ColorRole = ...) -> None: ...
    def drawPrimitive(self, pe: PySide6.QtWidgets.QStyle.PrimitiveElement, opt: PySide6.QtWidgets.QStyleOption) -> None: ...
    def style(self) -> PySide6.QtWidgets.QStyle: ...


class QStyledItemDelegate(PySide6.QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def createEditor(self, parent: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QWidget: ...
    def displayText(self, value: Any, locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]) -> str: ...
    def editorEvent(self, event: PySide6.QtCore.QEvent, model: PySide6.QtCore.QAbstractItemModel, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def eventFilter(self, object: PySide6.QtCore.QObject, event: PySide6.QtCore.QEvent) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def itemEditorFactory(self) -> PySide6.QtWidgets.QItemEditorFactory: ...
    def paint(self, painter: PySide6.QtGui.QPainter, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setEditorData(self, editor: PySide6.QtWidgets.QWidget, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setItemEditorFactory(self, factory: PySide6.QtWidgets.QItemEditorFactory) -> None: ...
    def setModelData(self, editor: PySide6.QtWidgets.QWidget, model: PySide6.QtCore.QAbstractItemModel, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def sizeHint(self, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QSize: ...
    def updateEditorGeometry(self, editor: PySide6.QtWidgets.QWidget, option: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...


class QSwipeGesture(PySide6.QtWidgets.QGesture):

    class SwipeDirection(enum.Enum):

        NoDirection              : QSwipeGesture.SwipeDirection = ... # 0x0
        Left                     : QSwipeGesture.SwipeDirection = ... # 0x1
        Right                    : QSwipeGesture.SwipeDirection = ... # 0x2
        Up                       : QSwipeGesture.SwipeDirection = ... # 0x3
        Down                     : QSwipeGesture.SwipeDirection = ... # 0x4


    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def horizontalDirection(self) -> PySide6.QtWidgets.QSwipeGesture.SwipeDirection: ...
    def setSwipeAngle(self, value: float) -> None: ...
    def swipeAngle(self) -> float: ...
    def verticalDirection(self) -> PySide6.QtWidgets.QSwipeGesture.SwipeDirection: ...


class QSystemTrayIcon(PySide6.QtCore.QObject):

    activated                : ClassVar[Signal] = ... # activated(QSystemTrayIcon::ActivationReason)
    messageClicked           : ClassVar[Signal] = ... # messageClicked()

    class ActivationReason(enum.Enum):

        Unknown                  : QSystemTrayIcon.ActivationReason = ... # 0x0
        Context                  : QSystemTrayIcon.ActivationReason = ... # 0x1
        DoubleClick              : QSystemTrayIcon.ActivationReason = ... # 0x2
        Trigger                  : QSystemTrayIcon.ActivationReason = ... # 0x3
        MiddleClick              : QSystemTrayIcon.ActivationReason = ... # 0x4

    class MessageIcon(enum.Enum):

        NoIcon                   : QSystemTrayIcon.MessageIcon = ... # 0x0
        Information              : QSystemTrayIcon.MessageIcon = ... # 0x1
        Warning                  : QSystemTrayIcon.MessageIcon = ... # 0x2
        Critical                 : QSystemTrayIcon.MessageIcon = ... # 0x3


    @overload
    def __init__(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def contextMenu(self) -> PySide6.QtWidgets.QMenu: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def hide(self) -> None: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    @staticmethod
    def isSystemTrayAvailable() -> bool: ...
    def isVisible(self) -> bool: ...
    def setContextMenu(self, menu: PySide6.QtWidgets.QMenu) -> None: ...
    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def show(self) -> None: ...
    @overload
    def showMessage(self, title: str, msg: str, icon: PySide6.QtWidgets.QSystemTrayIcon.MessageIcon = ..., msecs: int = ...) -> None: ...
    @overload
    def showMessage(self, title: str, msg: str, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], msecs: int = ...) -> None: ...
    @staticmethod
    def supportsMessages() -> bool: ...
    def toolTip(self) -> str: ...


class QTabBar(PySide6.QtWidgets.QWidget):

    currentChanged           : ClassVar[Signal] = ... # currentChanged(int)
    tabBarClicked            : ClassVar[Signal] = ... # tabBarClicked(int)
    tabBarDoubleClicked      : ClassVar[Signal] = ... # tabBarDoubleClicked(int)
    tabCloseRequested        : ClassVar[Signal] = ... # tabCloseRequested(int)
    tabMoved                 : ClassVar[Signal] = ... # tabMoved(int,int)

    class ButtonPosition(enum.Enum):

        LeftSide                 : QTabBar.ButtonPosition = ... # 0x0
        RightSide                : QTabBar.ButtonPosition = ... # 0x1

    class SelectionBehavior(enum.Enum):

        SelectLeftTab            : QTabBar.SelectionBehavior = ... # 0x0
        SelectRightTab           : QTabBar.SelectionBehavior = ... # 0x1
        SelectPreviousTab        : QTabBar.SelectionBehavior = ... # 0x2

    class Shape(enum.Enum):

        RoundedNorth             : QTabBar.Shape = ... # 0x0
        RoundedSouth             : QTabBar.Shape = ... # 0x1
        RoundedWest              : QTabBar.Shape = ... # 0x2
        RoundedEast              : QTabBar.Shape = ... # 0x3
        TriangularNorth          : QTabBar.Shape = ... # 0x4
        TriangularSouth          : QTabBar.Shape = ... # 0x5
        TriangularWest           : QTabBar.Shape = ... # 0x6
        TriangularEast           : QTabBar.Shape = ... # 0x7


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def accessibleTabName(self, index: int) -> str: ...
    @overload
    def addTab(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> int: ...
    @overload
    def addTab(self, text: str) -> int: ...
    def autoHide(self) -> bool: ...
    def changeCurrentOnDrag(self) -> bool: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def documentMode(self) -> bool: ...
    def drawBase(self) -> bool: ...
    def elideMode(self) -> PySide6.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def expanding(self) -> bool: ...
    def hideEvent(self, arg__1: PySide6.QtGui.QHideEvent) -> None: ...
    def iconSize(self) -> PySide6.QtCore.QSize: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionTab, tabIndex: int) -> None: ...
    @overload
    def insertTab(self, index: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> int: ...
    @overload
    def insertTab(self, index: int, text: str) -> int: ...
    def isMovable(self) -> bool: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def isTabVisible(self, index: int) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def minimumTabSizeHint(self, index: int) -> PySide6.QtCore.QSize: ...
    def mouseDoubleClickEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveTab(self, from_: int, to: int) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def removeTab(self, index: int) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def selectionBehaviorOnRemove(self) -> PySide6.QtWidgets.QTabBar.SelectionBehavior: ...
    def setAccessibleTabName(self, index: int, name: str) -> None: ...
    def setAutoHide(self, hide: bool) -> None: ...
    def setChangeCurrentOnDrag(self, change: bool) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setDocumentMode(self, set: bool) -> None: ...
    def setDrawBase(self, drawTheBase: bool) -> None: ...
    def setElideMode(self, mode: PySide6.QtCore.Qt.TextElideMode) -> None: ...
    def setExpanding(self, enabled: bool) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setMovable(self, movable: bool) -> None: ...
    def setSelectionBehaviorOnRemove(self, behavior: PySide6.QtWidgets.QTabBar.SelectionBehavior) -> None: ...
    def setShape(self, shape: PySide6.QtWidgets.QTabBar.Shape) -> None: ...
    def setTabButton(self, index: int, position: PySide6.QtWidgets.QTabBar.ButtonPosition, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setTabData(self, index: int, data: Any) -> None: ...
    def setTabEnabled(self, index: int, enabled: bool) -> None: ...
    def setTabIcon(self, index: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setTabText(self, index: int, text: str) -> None: ...
    def setTabTextColor(self, index: int, color: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setTabToolTip(self, index: int, tip: str) -> None: ...
    def setTabVisible(self, index: int, visible: bool) -> None: ...
    def setTabWhatsThis(self, index: int, text: str) -> None: ...
    def setTabsClosable(self, closable: bool) -> None: ...
    def setUsesScrollButtons(self, useButtons: bool) -> None: ...
    def shape(self) -> PySide6.QtWidgets.QTabBar.Shape: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def tabAt(self, pos: PySide6.QtCore.QPoint) -> int: ...
    def tabButton(self, index: int, position: PySide6.QtWidgets.QTabBar.ButtonPosition) -> PySide6.QtWidgets.QWidget: ...
    def tabData(self, index: int) -> Any: ...
    def tabIcon(self, index: int) -> PySide6.QtGui.QIcon: ...
    def tabInserted(self, index: int) -> None: ...
    def tabLayoutChange(self) -> None: ...
    def tabRect(self, index: int) -> PySide6.QtCore.QRect: ...
    def tabRemoved(self, index: int) -> None: ...
    def tabSizeHint(self, index: int) -> PySide6.QtCore.QSize: ...
    def tabText(self, index: int) -> str: ...
    def tabTextColor(self, index: int) -> PySide6.QtGui.QColor: ...
    def tabToolTip(self, index: int) -> str: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def tabsClosable(self) -> bool: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None: ...
    def usesScrollButtons(self) -> bool: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...


class QTabWidget(PySide6.QtWidgets.QWidget):

    currentChanged           : ClassVar[Signal] = ... # currentChanged(int)
    tabBarClicked            : ClassVar[Signal] = ... # tabBarClicked(int)
    tabBarDoubleClicked      : ClassVar[Signal] = ... # tabBarDoubleClicked(int)
    tabCloseRequested        : ClassVar[Signal] = ... # tabCloseRequested(int)

    class TabPosition(enum.Enum):

        North                    : QTabWidget.TabPosition = ... # 0x0
        South                    : QTabWidget.TabPosition = ... # 0x1
        West                     : QTabWidget.TabPosition = ... # 0x2
        East                     : QTabWidget.TabPosition = ... # 0x3

    class TabShape(enum.Enum):

        Rounded                  : QTabWidget.TabShape = ... # 0x0
        Triangular               : QTabWidget.TabShape = ... # 0x1


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    @overload
    def addTab(self, widget: PySide6.QtWidgets.QWidget, arg__2: str) -> int: ...
    @overload
    def addTab(self, widget: PySide6.QtWidgets.QWidget, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], label: str) -> int: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def cornerWidget(self, corner: PySide6.QtCore.Qt.Corner = ...) -> PySide6.QtWidgets.QWidget: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def documentMode(self) -> bool: ...
    def elideMode(self) -> PySide6.QtCore.Qt.TextElideMode: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, width: int) -> int: ...
    def iconSize(self) -> PySide6.QtCore.QSize: ...
    def indexOf(self, widget: PySide6.QtWidgets.QWidget) -> int: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionTabWidgetFrame) -> None: ...
    @overload
    def insertTab(self, index: int, widget: PySide6.QtWidgets.QWidget, arg__3: str) -> int: ...
    @overload
    def insertTab(self, index: int, widget: PySide6.QtWidgets.QWidget, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], label: str) -> int: ...
    def isMovable(self) -> bool: ...
    def isTabEnabled(self, index: int) -> bool: ...
    def isTabVisible(self, index: int) -> bool: ...
    def keyPressEvent(self, arg__1: PySide6.QtGui.QKeyEvent) -> None: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def removeTab(self, index: int) -> None: ...
    def resizeEvent(self, arg__1: PySide6.QtGui.QResizeEvent) -> None: ...
    def setCornerWidget(self, w: PySide6.QtWidgets.QWidget, corner: PySide6.QtCore.Qt.Corner = ...) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setDocumentMode(self, set: bool) -> None: ...
    def setElideMode(self, mode: PySide6.QtCore.Qt.TextElideMode) -> None: ...
    def setIconSize(self, size: PySide6.QtCore.QSize) -> None: ...
    def setMovable(self, movable: bool) -> None: ...
    def setTabBar(self, arg__1: PySide6.QtWidgets.QTabBar) -> None: ...
    def setTabBarAutoHide(self, enabled: bool) -> None: ...
    def setTabEnabled(self, index: int, enabled: bool) -> None: ...
    def setTabIcon(self, index: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setTabPosition(self, position: PySide6.QtWidgets.QTabWidget.TabPosition) -> None: ...
    def setTabShape(self, s: PySide6.QtWidgets.QTabWidget.TabShape) -> None: ...
    def setTabText(self, index: int, text: str) -> None: ...
    def setTabToolTip(self, index: int, tip: str) -> None: ...
    def setTabVisible(self, index: int, visible: bool) -> None: ...
    def setTabWhatsThis(self, index: int, text: str) -> None: ...
    def setTabsClosable(self, closeable: bool) -> None: ...
    def setUsesScrollButtons(self, useButtons: bool) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def tabBar(self) -> PySide6.QtWidgets.QTabBar: ...
    def tabBarAutoHide(self) -> bool: ...
    def tabIcon(self, index: int) -> PySide6.QtGui.QIcon: ...
    def tabInserted(self, index: int) -> None: ...
    def tabPosition(self) -> PySide6.QtWidgets.QTabWidget.TabPosition: ...
    def tabRemoved(self, index: int) -> None: ...
    def tabShape(self) -> PySide6.QtWidgets.QTabWidget.TabShape: ...
    def tabText(self, index: int) -> str: ...
    def tabToolTip(self, index: int) -> str: ...
    def tabWhatsThis(self, index: int) -> str: ...
    def tabsClosable(self) -> bool: ...
    def usesScrollButtons(self) -> bool: ...
    def widget(self, index: int) -> PySide6.QtWidgets.QWidget: ...


class QTableView(PySide6.QtWidgets.QAbstractItemView):

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def clearSpans(self) -> None: ...
    def columnAt(self, x: int) -> int: ...
    def columnCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def columnMoved(self, column: int, oldIndex: int, newIndex: int) -> None: ...
    def columnResized(self, column: int, oldWidth: int, newWidth: int) -> None: ...
    def columnSpan(self, row: int, column: int) -> int: ...
    def columnViewportPosition(self, column: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def currentChanged(self, current: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], previous: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def doItemsLayout(self) -> None: ...
    def gridStyle(self) -> PySide6.QtCore.Qt.PenStyle: ...
    def hideColumn(self, column: int) -> None: ...
    def hideRow(self, row: int) -> None: ...
    def horizontalHeader(self) -> PySide6.QtWidgets.QHeaderView: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def indexAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QModelIndex: ...
    def initViewItemOption(self, option: PySide6.QtWidgets.QStyleOptionViewItem) -> None: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def isCornerButtonEnabled(self) -> bool: ...
    def isIndexHidden(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def isRowHidden(self, row: int) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> PySide6.QtCore.QModelIndex: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def resizeColumnToContents(self, column: int) -> None: ...
    def resizeColumnsToContents(self) -> None: ...
    def resizeRowToContents(self, row: int) -> None: ...
    def resizeRowsToContents(self) -> None: ...
    def rowAt(self, y: int) -> int: ...
    def rowCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def rowHeight(self, row: int) -> int: ...
    def rowMoved(self, row: int, oldIndex: int, newIndex: int) -> None: ...
    def rowResized(self, row: int, oldHeight: int, newHeight: int) -> None: ...
    def rowSpan(self, row: int, column: int) -> int: ...
    def rowViewportPosition(self, row: int) -> int: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectColumn(self, column: int) -> None: ...
    def selectRow(self, row: int) -> None: ...
    def selectedIndexes(self) -> List[PySide6.QtCore.QModelIndex]: ...
    def selectionChanged(self, selected: PySide6.QtCore.QItemSelection, deselected: PySide6.QtCore.QItemSelection) -> None: ...
    def setColumnHidden(self, column: int, hide: bool) -> None: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def setCornerButtonEnabled(self, enable: bool) -> None: ...
    def setGridStyle(self, style: PySide6.QtCore.Qt.PenStyle) -> None: ...
    def setHorizontalHeader(self, header: PySide6.QtWidgets.QHeaderView) -> None: ...
    def setModel(self, model: Optional[PySide6.QtCore.QAbstractItemModel]) -> None: ...
    def setRootIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setRowHeight(self, row: int, height: int) -> None: ...
    def setRowHidden(self, row: int, hide: bool) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel) -> None: ...
    def setShowGrid(self, show: bool) -> None: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def setSpan(self, row: int, column: int, rowSpan: int, columnSpan: int) -> None: ...
    def setVerticalHeader(self, header: PySide6.QtWidgets.QHeaderView) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def showColumn(self, column: int) -> None: ...
    def showGrid(self) -> bool: ...
    def showRow(self, row: int) -> None: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sizeHintForRow(self, row: int) -> int: ...
    def sortByColumn(self, column: int, order: PySide6.QtCore.Qt.SortOrder) -> None: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None: ...
    def updateGeometries(self) -> None: ...
    def verticalHeader(self) -> PySide6.QtWidgets.QHeaderView: ...
    def verticalOffset(self) -> int: ...
    def verticalScrollbarAction(self, action: int) -> None: ...
    def viewportSizeHint(self) -> PySide6.QtCore.QSize: ...
    def visualRect(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection) -> PySide6.QtGui.QRegion: ...
    def wordWrap(self) -> bool: ...


class QTableWidget(PySide6.QtWidgets.QTableView):

    cellActivated            : ClassVar[Signal] = ... # cellActivated(int,int)
    cellChanged              : ClassVar[Signal] = ... # cellChanged(int,int)
    cellClicked              : ClassVar[Signal] = ... # cellClicked(int,int)
    cellDoubleClicked        : ClassVar[Signal] = ... # cellDoubleClicked(int,int)
    cellEntered              : ClassVar[Signal] = ... # cellEntered(int,int)
    cellPressed              : ClassVar[Signal] = ... # cellPressed(int,int)
    currentCellChanged       : ClassVar[Signal] = ... # currentCellChanged(int,int,int,int)
    currentItemChanged       : ClassVar[Signal] = ... # currentItemChanged(QTableWidgetItem*,QTableWidgetItem*)
    itemActivated            : ClassVar[Signal] = ... # itemActivated(QTableWidgetItem*)
    itemChanged              : ClassVar[Signal] = ... # itemChanged(QTableWidgetItem*)
    itemClicked              : ClassVar[Signal] = ... # itemClicked(QTableWidgetItem*)
    itemDoubleClicked        : ClassVar[Signal] = ... # itemDoubleClicked(QTableWidgetItem*)
    itemEntered              : ClassVar[Signal] = ... # itemEntered(QTableWidgetItem*)
    itemPressed              : ClassVar[Signal] = ... # itemPressed(QTableWidgetItem*)
    itemSelectionChanged     : ClassVar[Signal] = ... # itemSelectionChanged()

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, rows: int, columns: int, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def cellWidget(self, row: int, column: int) -> PySide6.QtWidgets.QWidget: ...
    def clear(self) -> None: ...
    def clearContents(self) -> None: ...
    def closePersistentEditor(self, item: PySide6.QtWidgets.QTableWidgetItem) -> None: ...
    def column(self, item: PySide6.QtWidgets.QTableWidgetItem) -> int: ...
    def columnCount(self) -> int: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def currentRow(self) -> int: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent) -> None: ...
    def dropMimeData(self, row: int, column: int, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: PySide6.QtWidgets.QTableWidgetItem) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def findItems(self, text: str, flags: PySide6.QtCore.Qt.MatchFlag) -> List[PySide6.QtWidgets.QTableWidgetItem]: ...
    def horizontalHeaderItem(self, column: int) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def indexFromItem(self, item: PySide6.QtWidgets.QTableWidgetItem) -> PySide6.QtCore.QModelIndex: ...
    def insertColumn(self, column: int) -> None: ...
    def insertRow(self, row: int) -> None: ...
    def isPersistentEditorOpen(self, item: PySide6.QtWidgets.QTableWidgetItem) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def item(self, row: int, column: int) -> PySide6.QtWidgets.QTableWidgetItem: ...
    @overload
    def itemAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtWidgets.QTableWidgetItem: ...
    @overload
    def itemAt(self, x: int, y: int) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def itemFromIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def itemPrototype(self) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def items(self, data: PySide6.QtCore.QMimeData) -> List[PySide6.QtWidgets.QTableWidgetItem]: ...
    def mimeData(self, items: Sequence[PySide6.QtWidgets.QTableWidgetItem]) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> List[str]: ...
    def openPersistentEditor(self, item: PySide6.QtWidgets.QTableWidgetItem) -> None: ...
    def removeCellWidget(self, row: int, column: int) -> None: ...
    def removeColumn(self, column: int) -> None: ...
    def removeRow(self, row: int) -> None: ...
    def row(self, item: PySide6.QtWidgets.QTableWidgetItem) -> int: ...
    def rowCount(self) -> int: ...
    def scrollToItem(self, item: PySide6.QtWidgets.QTableWidgetItem, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self) -> List[PySide6.QtWidgets.QTableWidgetItem]: ...
    def selectedRanges(self) -> List[PySide6.QtWidgets.QTableWidgetSelectionRange]: ...
    def setCellWidget(self, row: int, column: int, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setColumnCount(self, columns: int) -> None: ...
    @overload
    def setCurrentCell(self, row: int, column: int) -> None: ...
    @overload
    def setCurrentCell(self, row: int, column: int, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    @overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTableWidgetItem) -> None: ...
    @overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTableWidgetItem, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    def setHorizontalHeaderItem(self, column: int, item: PySide6.QtWidgets.QTableWidgetItem) -> None: ...
    def setHorizontalHeaderLabels(self, labels: Sequence[str]) -> None: ...
    def setItem(self, row: int, column: int, item: PySide6.QtWidgets.QTableWidgetItem) -> None: ...
    def setItemPrototype(self, item: PySide6.QtWidgets.QTableWidgetItem) -> None: ...
    def setModel(self, model: Optional[PySide6.QtCore.QAbstractItemModel]) -> None: ...
    def setRangeSelected(self, range: PySide6.QtWidgets.QTableWidgetSelectionRange, select: bool) -> None: ...
    def setRowCount(self, rows: int) -> None: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def setVerticalHeaderItem(self, row: int, item: PySide6.QtWidgets.QTableWidgetItem) -> None: ...
    def setVerticalHeaderLabels(self, labels: Sequence[str]) -> None: ...
    def sortItems(self, column: int, order: PySide6.QtCore.Qt.SortOrder = ...) -> None: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def takeHorizontalHeaderItem(self, column: int) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def takeItem(self, row: int, column: int) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def takeVerticalHeaderItem(self, row: int) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def verticalHeaderItem(self, row: int) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def visualColumn(self, logicalColumn: int) -> int: ...
    def visualItemRect(self, item: PySide6.QtWidgets.QTableWidgetItem) -> PySide6.QtCore.QRect: ...
    def visualRow(self, logicalRow: int) -> int: ...


class QTableWidgetItem(Shiboken.Object):

    class ItemType(enum.IntEnum):

        Type                     : QTableWidgetItem.ItemType = ... # 0x0
        UserType                 : QTableWidgetItem.ItemType = ... # 0x3e8


    @overload
    def __init__(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, type: int = ...) -> None: ...
    @overload
    def __init__(self, other: PySide6.QtWidgets.QTableWidgetItem) -> None: ...
    @overload
    def __init__(self, text: str, type: int = ...) -> None: ...
    @overload
    def __init__(self, type: int = ...) -> None: ...

    def __lshift__(self, out: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def background(self) -> PySide6.QtGui.QBrush: ...
    def checkState(self) -> PySide6.QtCore.Qt.CheckState: ...
    def clone(self) -> PySide6.QtWidgets.QTableWidgetItem: ...
    def column(self) -> int: ...
    def data(self, role: int) -> Any: ...
    def flags(self) -> PySide6.QtCore.Qt.ItemFlag: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def foreground(self) -> PySide6.QtGui.QBrush: ...
    def icon(self) -> PySide6.QtGui.QIcon: ...
    def isSelected(self) -> bool: ...
    def read(self, in_: PySide6.QtCore.QDataStream) -> None: ...
    def row(self) -> int: ...
    def setBackground(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setCheckState(self, state: PySide6.QtCore.Qt.CheckState) -> None: ...
    def setData(self, role: int, value: Any) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.ItemFlag) -> None: ...
    def setFont(self, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setForeground(self, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setSelected(self, select: bool) -> None: ...
    def setSizeHint(self, size: PySide6.QtCore.QSize) -> None: ...
    def setStatusTip(self, statusTip: str) -> None: ...
    def setText(self, text: str) -> None: ...
    @overload
    def setTextAlignment(self, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    @overload
    def setTextAlignment(self, alignment: int) -> None: ...
    def setToolTip(self, toolTip: str) -> None: ...
    def setWhatsThis(self, whatsThis: str) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def statusTip(self) -> str: ...
    def tableWidget(self) -> PySide6.QtWidgets.QTableWidget: ...
    def text(self) -> str: ...
    def textAlignment(self) -> int: ...
    def toolTip(self) -> str: ...
    def type(self) -> int: ...
    def whatsThis(self) -> str: ...
    def write(self, out: PySide6.QtCore.QDataStream) -> None: ...


class QTableWidgetSelectionRange(Shiboken.Object):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, QTableWidgetSelectionRange: PySide6.QtWidgets.QTableWidgetSelectionRange) -> None: ...
    @overload
    def __init__(self, top: int, left: int, bottom: int, right: int) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def bottomRow(self) -> int: ...
    def columnCount(self) -> int: ...
    def leftColumn(self) -> int: ...
    def rightColumn(self) -> int: ...
    def rowCount(self) -> int: ...
    def topRow(self) -> int: ...


class QTapAndHoldGesture(PySide6.QtWidgets.QGesture):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def position(self) -> PySide6.QtCore.QPointF: ...
    def setPosition(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...
    @staticmethod
    def setTimeout(msecs: int) -> None: ...
    @staticmethod
    def timeout() -> int: ...


class QTapGesture(PySide6.QtWidgets.QGesture):

    def __init__(self, parent: Optional[PySide6.QtCore.QObject] = ...) -> None: ...

    def position(self) -> PySide6.QtCore.QPointF: ...
    def setPosition(self, pos: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> None: ...


class QTextBrowser(PySide6.QtWidgets.QTextEdit):

    anchorClicked            : ClassVar[Signal] = ... # anchorClicked(QUrl)
    backwardAvailable        : ClassVar[Signal] = ... # backwardAvailable(bool)
    forwardAvailable         : ClassVar[Signal] = ... # forwardAvailable(bool)
    highlighted              : ClassVar[Signal] = ... # highlighted(QUrl)
    historyChanged           : ClassVar[Signal] = ... # historyChanged()
    sourceChanged            : ClassVar[Signal] = ... # sourceChanged(QUrl)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def backward(self) -> None: ...
    def backwardHistoryCount(self) -> int: ...
    def clearHistory(self) -> None: ...
    def doSetSource(self, name: Union[PySide6.QtCore.QUrl, str], type: PySide6.QtGui.QTextDocument.ResourceType = ...) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, ev: PySide6.QtGui.QFocusEvent) -> None: ...
    def forward(self) -> None: ...
    def forwardHistoryCount(self) -> int: ...
    def historyTitle(self, arg__1: int) -> str: ...
    def historyUrl(self, arg__1: int) -> PySide6.QtCore.QUrl: ...
    def home(self) -> None: ...
    def isBackwardAvailable(self) -> bool: ...
    def isForwardAvailable(self) -> bool: ...
    def keyPressEvent(self, ev: PySide6.QtGui.QKeyEvent) -> None: ...
    def loadResource(self, type: int, name: Union[PySide6.QtCore.QUrl, str]) -> Any: ...
    def mouseMoveEvent(self, ev: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, ev: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, ev: PySide6.QtGui.QMouseEvent) -> None: ...
    def openExternalLinks(self) -> bool: ...
    def openLinks(self) -> bool: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def reload(self) -> None: ...
    def searchPaths(self) -> List[str]: ...
    def setOpenExternalLinks(self, open: bool) -> None: ...
    def setOpenLinks(self, open: bool) -> None: ...
    def setSearchPaths(self, paths: Sequence[str]) -> None: ...
    def setSource(self, name: Union[PySide6.QtCore.QUrl, str], type: PySide6.QtGui.QTextDocument.ResourceType = ...) -> None: ...
    def source(self) -> PySide6.QtCore.QUrl: ...
    def sourceType(self) -> PySide6.QtGui.QTextDocument.ResourceType: ...


class QTextEdit(PySide6.QtWidgets.QAbstractScrollArea):

    copyAvailable            : ClassVar[Signal] = ... # copyAvailable(bool)
    currentCharFormatChanged : ClassVar[Signal] = ... # currentCharFormatChanged(QTextCharFormat)
    cursorPositionChanged    : ClassVar[Signal] = ... # cursorPositionChanged()
    redoAvailable            : ClassVar[Signal] = ... # redoAvailable(bool)
    selectionChanged         : ClassVar[Signal] = ... # selectionChanged()
    textChanged              : ClassVar[Signal] = ... # textChanged()
    undoAvailable            : ClassVar[Signal] = ... # undoAvailable(bool)

    class AutoFormattingFlag(enum.Flag):

        AutoNone                 : QTextEdit.AutoFormattingFlag = ... # 0x0
        AutoBulletList           : QTextEdit.AutoFormattingFlag = ... # 0x1
        AutoAll                  : QTextEdit.AutoFormattingFlag = ... # 0xffffffff

    class ExtraSelection(Shiboken.Object):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, ExtraSelection: PySide6.QtWidgets.QTextEdit.ExtraSelection) -> None: ...

        @staticmethod
        def __copy__() -> None: ...

    class LineWrapMode(enum.Enum):

        NoWrap                   : QTextEdit.LineWrapMode = ... # 0x0
        WidgetWidth              : QTextEdit.LineWrapMode = ... # 0x1
        FixedPixelWidth          : QTextEdit.LineWrapMode = ... # 0x2
        FixedColumnWidth         : QTextEdit.LineWrapMode = ... # 0x3


    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, text: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def acceptRichText(self) -> bool: ...
    def alignment(self) -> PySide6.QtCore.Qt.AlignmentFlag: ...
    def anchorAt(self, pos: PySide6.QtCore.QPoint) -> str: ...
    def append(self, text: str) -> None: ...
    def autoFormatting(self) -> PySide6.QtWidgets.QTextEdit.AutoFormattingFlag: ...
    def canInsertFromMimeData(self, source: PySide6.QtCore.QMimeData) -> bool: ...
    def canPaste(self) -> bool: ...
    def changeEvent(self, e: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def contextMenuEvent(self, e: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def copy(self) -> None: ...
    def createMimeDataFromSelection(self) -> PySide6.QtCore.QMimeData: ...
    @overload
    def createStandardContextMenu(self) -> PySide6.QtWidgets.QMenu: ...
    @overload
    def createStandardContextMenu(self, position: PySide6.QtCore.QPoint) -> PySide6.QtWidgets.QMenu: ...
    def currentCharFormat(self) -> PySide6.QtGui.QTextCharFormat: ...
    def currentFont(self) -> PySide6.QtGui.QFont: ...
    def cursorForPosition(self, pos: PySide6.QtCore.QPoint) -> PySide6.QtGui.QTextCursor: ...
    @overload
    def cursorRect(self) -> PySide6.QtCore.QRect: ...
    @overload
    def cursorRect(self, cursor: PySide6.QtGui.QTextCursor) -> PySide6.QtCore.QRect: ...
    def cursorWidth(self) -> int: ...
    def cut(self) -> None: ...
    def doSetTextCursor(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def document(self) -> PySide6.QtGui.QTextDocument: ...
    def documentTitle(self) -> str: ...
    def dragEnterEvent(self, e: PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, e: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, e: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, e: PySide6.QtGui.QDropEvent) -> None: ...
    def ensureCursorVisible(self) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def extraSelections(self) -> List[PySide6.QtWidgets.QTextEdit.ExtraSelection]: ...
    @overload
    def find(self, exp: str, options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> bool: ...
    @overload
    def find(self, exp: Union[PySide6.QtCore.QRegularExpression, str], options: PySide6.QtGui.QTextDocument.FindFlag = ...) -> bool: ...
    def focusInEvent(self, e: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, e: PySide6.QtGui.QFocusEvent) -> None: ...
    def fontFamily(self) -> str: ...
    def fontItalic(self) -> bool: ...
    def fontPointSize(self) -> float: ...
    def fontUnderline(self) -> bool: ...
    def fontWeight(self) -> int: ...
    def inputMethodEvent(self, arg__1: PySide6.QtGui.QInputMethodEvent) -> None: ...
    @overload
    def inputMethodQuery(self, property: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    @overload
    def inputMethodQuery(self, query: PySide6.QtCore.Qt.InputMethodQuery, argument: Any) -> Any: ...
    def insertFromMimeData(self, source: PySide6.QtCore.QMimeData) -> None: ...
    def insertHtml(self, text: str) -> None: ...
    def insertPlainText(self, text: str) -> None: ...
    def isReadOnly(self) -> bool: ...
    def isUndoRedoEnabled(self) -> bool: ...
    def keyPressEvent(self, e: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, e: PySide6.QtGui.QKeyEvent) -> None: ...
    def lineWrapColumnOrWidth(self) -> int: ...
    def lineWrapMode(self) -> PySide6.QtWidgets.QTextEdit.LineWrapMode: ...
    def loadResource(self, type: int, name: Union[PySide6.QtCore.QUrl, str]) -> Any: ...
    def mergeCurrentCharFormat(self, modifier: PySide6.QtGui.QTextCharFormat) -> None: ...
    def mouseDoubleClickEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, operation: PySide6.QtGui.QTextCursor.MoveOperation, mode: PySide6.QtGui.QTextCursor.MoveMode = ...) -> None: ...
    def overwriteMode(self) -> bool: ...
    def paintEvent(self, e: PySide6.QtGui.QPaintEvent) -> None: ...
    def paste(self) -> None: ...
    def placeholderText(self) -> str: ...
    def print_(self, printer: PySide6.QtGui.QPagedPaintDevice) -> None: ...
    def redo(self) -> None: ...
    def resizeEvent(self, e: PySide6.QtGui.QResizeEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollToAnchor(self, name: str) -> None: ...
    def selectAll(self) -> None: ...
    def setAcceptRichText(self, accept: bool) -> None: ...
    def setAlignment(self, a: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    def setAutoFormatting(self, features: PySide6.QtWidgets.QTextEdit.AutoFormattingFlag) -> None: ...
    def setCurrentCharFormat(self, format: PySide6.QtGui.QTextCharFormat) -> None: ...
    def setCurrentFont(self, f: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setCursorWidth(self, width: int) -> None: ...
    def setDocument(self, document: PySide6.QtGui.QTextDocument) -> None: ...
    def setDocumentTitle(self, title: str) -> None: ...
    def setExtraSelections(self, selections: Sequence[PySide6.QtWidgets.QTextEdit.ExtraSelection]) -> None: ...
    def setFontFamily(self, fontFamily: str) -> None: ...
    def setFontItalic(self, b: bool) -> None: ...
    def setFontPointSize(self, s: float) -> None: ...
    def setFontUnderline(self, b: bool) -> None: ...
    def setFontWeight(self, w: int) -> None: ...
    def setHtml(self, text: str) -> None: ...
    def setLineWrapColumnOrWidth(self, w: int) -> None: ...
    def setLineWrapMode(self, mode: PySide6.QtWidgets.QTextEdit.LineWrapMode) -> None: ...
    def setMarkdown(self, markdown: str) -> None: ...
    def setOverwriteMode(self, overwrite: bool) -> None: ...
    def setPlaceholderText(self, placeholderText: str) -> None: ...
    def setPlainText(self, text: str) -> None: ...
    def setReadOnly(self, ro: bool) -> None: ...
    def setTabChangesFocus(self, b: bool) -> None: ...
    def setTabStopDistance(self, distance: float) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextBackgroundColor(self, c: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setTextColor(self, c: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int]) -> None: ...
    def setTextCursor(self, cursor: PySide6.QtGui.QTextCursor) -> None: ...
    def setTextInteractionFlags(self, flags: PySide6.QtCore.Qt.TextInteractionFlag) -> None: ...
    def setUndoRedoEnabled(self, enable: bool) -> None: ...
    def setWordWrapMode(self, policy: PySide6.QtGui.QTextOption.WrapMode) -> None: ...
    def showEvent(self, arg__1: PySide6.QtGui.QShowEvent) -> None: ...
    def tabChangesFocus(self) -> bool: ...
    def tabStopDistance(self) -> float: ...
    def textBackgroundColor(self) -> PySide6.QtGui.QColor: ...
    def textColor(self) -> PySide6.QtGui.QColor: ...
    def textCursor(self) -> PySide6.QtGui.QTextCursor: ...
    def textInteractionFlags(self) -> PySide6.QtCore.Qt.TextInteractionFlag: ...
    def timerEvent(self, e: PySide6.QtCore.QTimerEvent) -> None: ...
    def toHtml(self) -> str: ...
    def toMarkdown(self, features: PySide6.QtGui.QTextDocument.MarkdownFeature = ...) -> str: ...
    def toPlainText(self) -> str: ...
    def undo(self) -> None: ...
    def wheelEvent(self, e: PySide6.QtGui.QWheelEvent) -> None: ...
    def wordWrapMode(self) -> PySide6.QtGui.QTextOption.WrapMode: ...
    def zoomIn(self, range: int = ...) -> None: ...
    def zoomInF(self, range: float) -> None: ...
    def zoomOut(self, range: int = ...) -> None: ...


class QTileRules(Shiboken.Object):

    @overload
    def __init__(self, QTileRules: Union[PySide6.QtWidgets.QTileRules, PySide6.QtCore.Qt.TileRule]) -> None: ...
    @overload
    def __init__(self, horizontalRule: PySide6.QtCore.Qt.TileRule, verticalRule: PySide6.QtCore.Qt.TileRule) -> None: ...
    @overload
    def __init__(self, rule: PySide6.QtCore.Qt.TileRule = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...


class QTimeEdit(PySide6.QtWidgets.QDateTimeEdit):

    userTimeChanged          : ClassVar[Signal] = ... # userTimeChanged(QTime)

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, time: PySide6.QtCore.QTime, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...


class QToolBar(PySide6.QtWidgets.QWidget):

    actionTriggered          : ClassVar[Signal] = ... # actionTriggered(QAction*)
    allowedAreasChanged      : ClassVar[Signal] = ... # allowedAreasChanged(Qt::ToolBarAreas)
    iconSizeChanged          : ClassVar[Signal] = ... # iconSizeChanged(QSize)
    movableChanged           : ClassVar[Signal] = ... # movableChanged(bool)
    orientationChanged       : ClassVar[Signal] = ... # orientationChanged(Qt::Orientation)
    toolButtonStyleChanged   : ClassVar[Signal] = ... # toolButtonStyleChanged(Qt::ToolButtonStyle)
    topLevelChanged          : ClassVar[Signal] = ... # topLevelChanged(bool)
    visibilityChanged        : ClassVar[Signal] = ... # visibilityChanged(bool)

    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, title: str, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    @overload
    def actionAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtGui.QAction: ...
    @overload
    def actionAt(self, x: int, y: int) -> PySide6.QtGui.QAction: ...
    def actionEvent(self, event: PySide6.QtGui.QActionEvent) -> None: ...
    def actionGeometry(self, action: PySide6.QtGui.QAction) -> PySide6.QtCore.QRect: ...
    def addSeparator(self) -> PySide6.QtGui.QAction: ...
    def addWidget(self, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtGui.QAction: ...
    def allowedAreas(self) -> PySide6.QtCore.Qt.ToolBarArea: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def clear(self) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def iconSize(self) -> PySide6.QtCore.QSize: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionToolBar) -> None: ...
    def insertSeparator(self, before: PySide6.QtGui.QAction) -> PySide6.QtGui.QAction: ...
    def insertWidget(self, before: PySide6.QtGui.QAction, widget: PySide6.QtWidgets.QWidget) -> PySide6.QtGui.QAction: ...
    def isAreaAllowed(self, area: PySide6.QtCore.Qt.ToolBarArea) -> bool: ...
    def isFloatable(self) -> bool: ...
    def isFloating(self) -> bool: ...
    def isMovable(self) -> bool: ...
    def orientation(self) -> PySide6.QtCore.Qt.Orientation: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    def setAllowedAreas(self, areas: PySide6.QtCore.Qt.ToolBarArea) -> None: ...
    def setFloatable(self, floatable: bool) -> None: ...
    def setIconSize(self, iconSize: PySide6.QtCore.QSize) -> None: ...
    def setMovable(self, movable: bool) -> None: ...
    def setOrientation(self, orientation: PySide6.QtCore.Qt.Orientation) -> None: ...
    def setToolButtonStyle(self, toolButtonStyle: PySide6.QtCore.Qt.ToolButtonStyle) -> None: ...
    def toggleViewAction(self) -> PySide6.QtGui.QAction: ...
    def toolButtonStyle(self) -> PySide6.QtCore.Qt.ToolButtonStyle: ...
    def widgetForAction(self, action: PySide6.QtGui.QAction) -> PySide6.QtWidgets.QWidget: ...


class QToolBox(PySide6.QtWidgets.QFrame):

    currentChanged           : ClassVar[Signal] = ... # currentChanged(int)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    @overload
    def addItem(self, widget: PySide6.QtWidgets.QWidget, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> int: ...
    @overload
    def addItem(self, widget: PySide6.QtWidgets.QWidget, text: str) -> int: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def count(self) -> int: ...
    def currentIndex(self) -> int: ...
    def currentWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def indexOf(self, widget: PySide6.QtWidgets.QWidget) -> int: ...
    @overload
    def insertItem(self, index: int, widget: PySide6.QtWidgets.QWidget, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> int: ...
    @overload
    def insertItem(self, index: int, widget: PySide6.QtWidgets.QWidget, text: str) -> int: ...
    def isItemEnabled(self, index: int) -> bool: ...
    def itemIcon(self, index: int) -> PySide6.QtGui.QIcon: ...
    def itemInserted(self, index: int) -> None: ...
    def itemRemoved(self, index: int) -> None: ...
    def itemText(self, index: int) -> str: ...
    def itemToolTip(self, index: int) -> str: ...
    def removeItem(self, index: int) -> None: ...
    def setCurrentIndex(self, index: int) -> None: ...
    def setCurrentWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setItemEnabled(self, index: int, enabled: bool) -> None: ...
    def setItemIcon(self, index: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setItemText(self, index: int, text: str) -> None: ...
    def setItemToolTip(self, index: int, toolTip: str) -> None: ...
    def showEvent(self, e: PySide6.QtGui.QShowEvent) -> None: ...
    def widget(self, index: int) -> PySide6.QtWidgets.QWidget: ...


class QToolButton(PySide6.QtWidgets.QAbstractButton):

    triggered                : ClassVar[Signal] = ... # triggered(QAction*)

    class ToolButtonPopupMode(enum.Enum):

        DelayedPopup             : QToolButton.ToolButtonPopupMode = ... # 0x0
        MenuButtonPopup          : QToolButton.ToolButtonPopupMode = ... # 0x1
        InstantPopup             : QToolButton.ToolButtonPopupMode = ... # 0x2


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def actionEvent(self, arg__1: PySide6.QtGui.QActionEvent) -> None: ...
    def arrowType(self) -> PySide6.QtCore.Qt.ArrowType: ...
    def autoRaise(self) -> bool: ...
    def changeEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def checkStateSet(self) -> None: ...
    def defaultAction(self) -> PySide6.QtGui.QAction: ...
    def enterEvent(self, arg__1: PySide6.QtGui.QEnterEvent) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def hitButton(self, pos: PySide6.QtCore.QPoint) -> bool: ...
    def initStyleOption(self, option: PySide6.QtWidgets.QStyleOptionToolButton) -> None: ...
    def leaveEvent(self, arg__1: PySide6.QtCore.QEvent) -> None: ...
    def menu(self) -> PySide6.QtWidgets.QMenu: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def mousePressEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, arg__1: PySide6.QtGui.QMouseEvent) -> None: ...
    def nextCheckState(self) -> None: ...
    def paintEvent(self, arg__1: PySide6.QtGui.QPaintEvent) -> None: ...
    def popupMode(self) -> PySide6.QtWidgets.QToolButton.ToolButtonPopupMode: ...
    def setArrowType(self, type: PySide6.QtCore.Qt.ArrowType) -> None: ...
    def setAutoRaise(self, enable: bool) -> None: ...
    def setDefaultAction(self, arg__1: PySide6.QtGui.QAction) -> None: ...
    def setMenu(self, menu: PySide6.QtWidgets.QMenu) -> None: ...
    def setPopupMode(self, mode: PySide6.QtWidgets.QToolButton.ToolButtonPopupMode) -> None: ...
    def setToolButtonStyle(self, style: PySide6.QtCore.Qt.ToolButtonStyle) -> None: ...
    def showMenu(self) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def timerEvent(self, arg__1: PySide6.QtCore.QTimerEvent) -> None: ...
    def toolButtonStyle(self) -> PySide6.QtCore.Qt.ToolButtonStyle: ...


class QToolTip(Shiboken.Object):
    @staticmethod
    def font() -> PySide6.QtGui.QFont: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def isVisible() -> bool: ...
    @staticmethod
    def palette() -> PySide6.QtGui.QPalette: ...
    @staticmethod
    def setFont(arg__1: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    @staticmethod
    def setPalette(arg__1: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @staticmethod
    def showText(pos: PySide6.QtCore.QPoint, text: str, w: Optional[PySide6.QtWidgets.QWidget] = ..., rect: PySide6.QtCore.QRect = ..., msecShowTime: int = ...) -> None: ...
    @staticmethod
    def text() -> str: ...


class QTreeView(PySide6.QtWidgets.QAbstractItemView):

    collapsed                : ClassVar[Signal] = ... # collapsed(QModelIndex)
    expanded                 : ClassVar[Signal] = ... # expanded(QModelIndex)

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def allColumnsShowFocus(self) -> bool: ...
    def autoExpandDelay(self) -> int: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def collapse(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def collapseAll(self) -> None: ...
    def columnAt(self, x: int) -> int: ...
    def columnCountChanged(self, oldCount: int, newCount: int) -> None: ...
    def columnMoved(self) -> None: ...
    def columnResized(self, column: int, oldSize: int, newSize: int) -> None: ...
    def columnViewportPosition(self, column: int) -> int: ...
    def columnWidth(self, column: int) -> int: ...
    def currentChanged(self, current: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], previous: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def dataChanged(self, topLeft: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], bottomRight: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], roles: Sequence[int] = ...) -> None: ...
    def doItemsLayout(self) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def drawBranches(self, painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def drawRow(self, painter: PySide6.QtGui.QPainter, options: PySide6.QtWidgets.QStyleOptionViewItem, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def drawTree(self, painter: PySide6.QtGui.QPainter, region: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    def expand(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def expandAll(self) -> None: ...
    def expandRecursively(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], depth: int = ...) -> None: ...
    def expandToDepth(self, depth: int) -> None: ...
    def expandsOnDoubleClick(self) -> bool: ...
    def header(self) -> PySide6.QtWidgets.QHeaderView: ...
    def hideColumn(self, column: int) -> None: ...
    def horizontalOffset(self) -> int: ...
    def horizontalScrollbarAction(self, action: int) -> None: ...
    def indentation(self) -> int: ...
    def indexAbove(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QModelIndex: ...
    def indexAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtCore.QModelIndex: ...
    def indexBelow(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QModelIndex: ...
    def indexRowSizeHint(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> int: ...
    def isAnimated(self) -> bool: ...
    def isColumnHidden(self, column: int) -> bool: ...
    def isExpanded(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def isFirstColumnSpanned(self, row: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def isHeaderHidden(self) -> bool: ...
    def isIndexHidden(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def isRowHidden(self, row: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> bool: ...
    def isSortingEnabled(self) -> bool: ...
    def itemsExpandable(self) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyboardSearch(self, search: str) -> None: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def moveCursor(self, cursorAction: PySide6.QtWidgets.QAbstractItemView.CursorAction, modifiers: PySide6.QtCore.Qt.KeyboardModifier) -> PySide6.QtCore.QModelIndex: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    def reexpand(self) -> None: ...
    def reset(self) -> None: ...
    def resetIndentation(self) -> None: ...
    def resizeColumnToContents(self, column: int) -> None: ...
    def rootIsDecorated(self) -> bool: ...
    def rowHeight(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> int: ...
    def rowsAboutToBeRemoved(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], start: int, end: int) -> None: ...
    def rowsInserted(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], start: int, end: int) -> None: ...
    def rowsRemoved(self, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], first: int, last: int) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def scrollTo(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectAll(self) -> None: ...
    def selectedIndexes(self) -> List[PySide6.QtCore.QModelIndex]: ...
    def selectionChanged(self, selected: PySide6.QtCore.QItemSelection, deselected: PySide6.QtCore.QItemSelection) -> None: ...
    def setAllColumnsShowFocus(self, enable: bool) -> None: ...
    def setAnimated(self, enable: bool) -> None: ...
    def setAutoExpandDelay(self, delay: int) -> None: ...
    def setColumnHidden(self, column: int, hide: bool) -> None: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def setExpanded(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], expand: bool) -> None: ...
    def setExpandsOnDoubleClick(self, enable: bool) -> None: ...
    def setFirstColumnSpanned(self, row: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], span: bool) -> None: ...
    def setHeader(self, header: PySide6.QtWidgets.QHeaderView) -> None: ...
    def setHeaderHidden(self, hide: bool) -> None: ...
    def setIndentation(self, i: int) -> None: ...
    def setItemsExpandable(self, enable: bool) -> None: ...
    def setModel(self, model: Optional[PySide6.QtCore.QAbstractItemModel]) -> None: ...
    def setRootIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> None: ...
    def setRootIsDecorated(self, show: bool) -> None: ...
    def setRowHidden(self, row: int, parent: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex], hide: bool) -> None: ...
    def setSelection(self, rect: PySide6.QtCore.QRect, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel) -> None: ...
    def setSortingEnabled(self, enable: bool) -> None: ...
    def setTreePosition(self, logicalIndex: int) -> None: ...
    def setUniformRowHeights(self, uniform: bool) -> None: ...
    def setWordWrap(self, on: bool) -> None: ...
    def showColumn(self, column: int) -> None: ...
    def sizeHintForColumn(self, column: int) -> int: ...
    def sortByColumn(self, column: int, order: PySide6.QtCore.Qt.SortOrder) -> None: ...
    def timerEvent(self, event: PySide6.QtCore.QTimerEvent) -> None: ...
    def treePosition(self) -> int: ...
    def uniformRowHeights(self) -> bool: ...
    def updateGeometries(self) -> None: ...
    def verticalOffset(self) -> int: ...
    def verticalScrollbarValueChanged(self, value: int) -> None: ...
    def viewportEvent(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def viewportSizeHint(self) -> PySide6.QtCore.QSize: ...
    def visualRect(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtCore.QRect: ...
    def visualRegionForSelection(self, selection: PySide6.QtCore.QItemSelection) -> PySide6.QtGui.QRegion: ...
    def wordWrap(self) -> bool: ...


class QTreeWidget(PySide6.QtWidgets.QTreeView):

    currentItemChanged       : ClassVar[Signal] = ... # currentItemChanged(QTreeWidgetItem*,QTreeWidgetItem*)
    itemActivated            : ClassVar[Signal] = ... # itemActivated(QTreeWidgetItem*,int)
    itemChanged              : ClassVar[Signal] = ... # itemChanged(QTreeWidgetItem*,int)
    itemClicked              : ClassVar[Signal] = ... # itemClicked(QTreeWidgetItem*,int)
    itemCollapsed            : ClassVar[Signal] = ... # itemCollapsed(QTreeWidgetItem*)
    itemDoubleClicked        : ClassVar[Signal] = ... # itemDoubleClicked(QTreeWidgetItem*,int)
    itemEntered              : ClassVar[Signal] = ... # itemEntered(QTreeWidgetItem*,int)
    itemExpanded             : ClassVar[Signal] = ... # itemExpanded(QTreeWidgetItem*)
    itemPressed              : ClassVar[Signal] = ... # itemPressed(QTreeWidgetItem*,int)
    itemSelectionChanged     : ClassVar[Signal] = ... # itemSelectionChanged()

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def addTopLevelItem(self, item: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    def addTopLevelItems(self, items: Sequence[PySide6.QtWidgets.QTreeWidgetItem]) -> None: ...
    def clear(self) -> None: ...
    def closePersistentEditor(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int = ...) -> None: ...
    def collapseItem(self, item: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    def columnCount(self) -> int: ...
    def currentColumn(self) -> int: ...
    def currentItem(self) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent) -> None: ...
    def dropMimeData(self, parent: PySide6.QtWidgets.QTreeWidgetItem, index: int, data: PySide6.QtCore.QMimeData, action: PySide6.QtCore.Qt.DropAction) -> bool: ...
    def editItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int = ...) -> None: ...
    def event(self, e: PySide6.QtCore.QEvent) -> bool: ...
    def expandItem(self, item: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    def findItems(self, text: str, flags: PySide6.QtCore.Qt.MatchFlag, column: int = ...) -> List[PySide6.QtWidgets.QTreeWidgetItem]: ...
    def headerItem(self) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def indexFromItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int = ...) -> PySide6.QtCore.QModelIndex: ...
    def indexOfTopLevelItem(self, item: PySide6.QtWidgets.QTreeWidgetItem) -> int: ...
    def insertTopLevelItem(self, index: int, item: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    def insertTopLevelItems(self, index: int, items: Sequence[PySide6.QtWidgets.QTreeWidgetItem]) -> None: ...
    def invisibleRootItem(self) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def isPersistentEditorOpen(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int = ...) -> bool: ...
    def itemAbove(self, item: PySide6.QtWidgets.QTreeWidgetItem) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    @overload
    def itemAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    @overload
    def itemAt(self, x: int, y: int) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def itemBelow(self, item: PySide6.QtWidgets.QTreeWidgetItem) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def itemFromIndex(self, index: Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def itemWidget(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int) -> PySide6.QtWidgets.QWidget: ...
    def mimeData(self, items: Sequence[PySide6.QtWidgets.QTreeWidgetItem]) -> PySide6.QtCore.QMimeData: ...
    def mimeTypes(self) -> List[str]: ...
    def openPersistentEditor(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int = ...) -> None: ...
    def removeItemWidget(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int) -> None: ...
    def scrollToItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, hint: PySide6.QtWidgets.QAbstractItemView.ScrollHint = ...) -> None: ...
    def selectedItems(self) -> List[PySide6.QtWidgets.QTreeWidgetItem]: ...
    def setColumnCount(self, columns: int) -> None: ...
    @overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    @overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int) -> None: ...
    @overload
    def setCurrentItem(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int, command: PySide6.QtCore.QItemSelectionModel.SelectionFlag) -> None: ...
    def setHeaderItem(self, item: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    def setHeaderLabel(self, label: str) -> None: ...
    def setHeaderLabels(self, labels: Sequence[str]) -> None: ...
    def setItemWidget(self, item: PySide6.QtWidgets.QTreeWidgetItem, column: int, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setModel(self, model: Optional[PySide6.QtCore.QAbstractItemModel]) -> None: ...
    def setSelectionModel(self, selectionModel: PySide6.QtCore.QItemSelectionModel) -> None: ...
    def sortColumn(self) -> int: ...
    def sortItems(self, column: int, order: PySide6.QtCore.Qt.SortOrder) -> None: ...
    def supportedDropActions(self) -> PySide6.QtCore.Qt.DropAction: ...
    def takeTopLevelItem(self, index: int) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def topLevelItem(self, index: int) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def topLevelItemCount(self) -> int: ...
    def visualItemRect(self, item: PySide6.QtWidgets.QTreeWidgetItem) -> PySide6.QtCore.QRect: ...


class QTreeWidgetItem(Shiboken.Object):

    class ChildIndicatorPolicy(enum.Enum):

        ShowIndicator            : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x0
        DontShowIndicator        : QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x1
        DontShowIndicatorWhenChildless: QTreeWidgetItem.ChildIndicatorPolicy = ... # 0x2

    class ItemType(enum.IntEnum):

        Type                     : QTreeWidgetItem.ItemType = ... # 0x0
        UserType                 : QTreeWidgetItem.ItemType = ... # 0x3e8


    @overload
    def __init__(self, other: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    @overload
    def __init__(self, parent: PySide6.QtWidgets.QTreeWidgetItem, after: PySide6.QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: PySide6.QtWidgets.QTreeWidgetItem, strings: Sequence[str], type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: PySide6.QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @overload
    def __init__(self, strings: Sequence[str], type: int = ...) -> None: ...
    @overload
    def __init__(self, treeview: PySide6.QtWidgets.QTreeWidget, after: PySide6.QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @overload
    def __init__(self, treeview: PySide6.QtWidgets.QTreeWidget, strings: Sequence[str], type: int = ...) -> None: ...
    @overload
    def __init__(self, treeview: PySide6.QtWidgets.QTreeWidget, type: int = ...) -> None: ...
    @overload
    def __init__(self, type: int = ...) -> None: ...

    def __lshift__(self, out: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def __rshift__(self, in_: PySide6.QtCore.QDataStream) -> PySide6.QtCore.QDataStream: ...
    def addChild(self, child: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    def addChildren(self, children: Sequence[PySide6.QtWidgets.QTreeWidgetItem]) -> None: ...
    def background(self, column: int) -> PySide6.QtGui.QBrush: ...
    def checkState(self, column: int) -> PySide6.QtCore.Qt.CheckState: ...
    def child(self, index: int) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def childCount(self) -> int: ...
    def childIndicatorPolicy(self) -> PySide6.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy: ...
    def clone(self) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def columnCount(self) -> int: ...
    def data(self, column: int, role: int) -> Any: ...
    def emitDataChanged(self) -> None: ...
    def flags(self) -> PySide6.QtCore.Qt.ItemFlag: ...
    def font(self, column: int) -> PySide6.QtGui.QFont: ...
    def foreground(self, column: int) -> PySide6.QtGui.QBrush: ...
    def icon(self, column: int) -> PySide6.QtGui.QIcon: ...
    def indexOfChild(self, child: PySide6.QtWidgets.QTreeWidgetItem) -> int: ...
    def insertChild(self, index: int, child: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    def insertChildren(self, index: int, children: Sequence[PySide6.QtWidgets.QTreeWidgetItem]) -> None: ...
    def isDisabled(self) -> bool: ...
    def isExpanded(self) -> bool: ...
    def isFirstColumnSpanned(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isSelected(self) -> bool: ...
    def parent(self) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def read(self, in_: PySide6.QtCore.QDataStream) -> None: ...
    def removeChild(self, child: PySide6.QtWidgets.QTreeWidgetItem) -> None: ...
    def setBackground(self, column: int, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setCheckState(self, column: int, state: PySide6.QtCore.Qt.CheckState) -> None: ...
    def setChildIndicatorPolicy(self, policy: PySide6.QtWidgets.QTreeWidgetItem.ChildIndicatorPolicy) -> None: ...
    def setData(self, column: int, role: int, value: Any) -> None: ...
    def setDisabled(self, disabled: bool) -> None: ...
    def setExpanded(self, expand: bool) -> None: ...
    def setFirstColumnSpanned(self, span: bool) -> None: ...
    def setFlags(self, flags: PySide6.QtCore.Qt.ItemFlag) -> None: ...
    def setFont(self, column: int, font: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setForeground(self, column: int, brush: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap]) -> None: ...
    def setHidden(self, hide: bool) -> None: ...
    def setIcon(self, column: int, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setSelected(self, select: bool) -> None: ...
    def setSizeHint(self, column: int, size: PySide6.QtCore.QSize) -> None: ...
    def setStatusTip(self, column: int, statusTip: str) -> None: ...
    def setText(self, column: int, text: str) -> None: ...
    @overload
    def setTextAlignment(self, column: int, alignment: PySide6.QtCore.Qt.AlignmentFlag) -> None: ...
    @overload
    def setTextAlignment(self, column: int, alignment: int) -> None: ...
    def setToolTip(self, column: int, toolTip: str) -> None: ...
    def setWhatsThis(self, column: int, whatsThis: str) -> None: ...
    def sizeHint(self, column: int) -> PySide6.QtCore.QSize: ...
    def sortChildren(self, column: int, order: PySide6.QtCore.Qt.SortOrder) -> None: ...
    def statusTip(self, column: int) -> str: ...
    def takeChild(self, index: int) -> PySide6.QtWidgets.QTreeWidgetItem: ...
    def takeChildren(self) -> List[PySide6.QtWidgets.QTreeWidgetItem]: ...
    def text(self, column: int) -> str: ...
    def textAlignment(self, column: int) -> int: ...
    def toolTip(self, column: int) -> str: ...
    def treeWidget(self) -> PySide6.QtWidgets.QTreeWidget: ...
    def type(self) -> int: ...
    def whatsThis(self, column: int) -> str: ...
    def write(self, out: PySide6.QtCore.QDataStream) -> None: ...


class QTreeWidgetItemIterator(Shiboken.Object):

    class IteratorFlag(enum.Flag):

        All                      : QTreeWidgetItemIterator.IteratorFlag = ... # 0x0
        Hidden                   : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1
        NotHidden                : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2
        Selected                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4
        Unselected               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8
        Selectable               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10
        NotSelectable            : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20
        DragEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x40
        DragDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x80
        DropEnabled              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x100
        DropDisabled             : QTreeWidgetItemIterator.IteratorFlag = ... # 0x200
        HasChildren              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x400
        NoChildren               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x800
        Checked                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000
        NotChecked               : QTreeWidgetItemIterator.IteratorFlag = ... # 0x2000
        Enabled                  : QTreeWidgetItemIterator.IteratorFlag = ... # 0x4000
        Disabled                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x8000
        Editable                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x10000
        NotEditable              : QTreeWidgetItemIterator.IteratorFlag = ... # 0x20000
        UserFlag                 : QTreeWidgetItemIterator.IteratorFlag = ... # 0x1000000


    @overload
    def __init__(self, it: Union[PySide6.QtWidgets.QTreeWidgetItemIterator, PySide6.QtWidgets.QTreeWidget, PySide6.QtWidgets.QTreeWidgetItem]) -> None: ...
    @overload
    def __init__(self, item: PySide6.QtWidgets.QTreeWidgetItem, flags: PySide6.QtWidgets.QTreeWidgetItemIterator.IteratorFlag = ...) -> None: ...
    @overload
    def __init__(self, widget: PySide6.QtWidgets.QTreeWidget, flags: PySide6.QtWidgets.QTreeWidgetItemIterator.IteratorFlag = ...) -> None: ...

    @staticmethod
    def __copy__() -> None: ...
    def __iadd__(self, n: int) -> PySide6.QtWidgets.QTreeWidgetItemIterator: ...
    def __isub__(self, n: int) -> PySide6.QtWidgets.QTreeWidgetItemIterator: ...
    def __iter__(self) -> object: ...
    def __next__(self) -> object: ...
    def value(self) -> PySide6.QtWidgets.QTreeWidgetItem: ...


class QUndoView(PySide6.QtWidgets.QListView):

    @overload
    def __init__(self, group: PySide6.QtGui.QUndoGroup, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, stack: PySide6.QtGui.QUndoStack, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def cleanIcon(self) -> PySide6.QtGui.QIcon: ...
    def emptyLabel(self) -> str: ...
    def group(self) -> PySide6.QtGui.QUndoGroup: ...
    def setCleanIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setEmptyLabel(self, label: str) -> None: ...
    def setGroup(self, group: PySide6.QtGui.QUndoGroup) -> None: ...
    def setStack(self, stack: PySide6.QtGui.QUndoStack) -> None: ...
    def stack(self) -> PySide6.QtGui.QUndoStack: ...


class QVBoxLayout(PySide6.QtWidgets.QBoxLayout):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, parent: PySide6.QtWidgets.QWidget) -> None: ...


class QWhatsThis(Shiboken.Object):
    @staticmethod
    def createAction(parent: Optional[PySide6.QtCore.QObject] = ...) -> PySide6.QtGui.QAction: ...
    @staticmethod
    def enterWhatsThisMode() -> None: ...
    @staticmethod
    def hideText() -> None: ...
    @staticmethod
    def inWhatsThisMode() -> bool: ...
    @staticmethod
    def leaveWhatsThisMode() -> None: ...
    @staticmethod
    def showText(pos: PySide6.QtCore.QPoint, text: str, w: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...


class QWidget(PySide6.QtCore.QObject, PySide6.QtGui.QPaintDevice):

    customContextMenuRequested: ClassVar[Signal] = ... # customContextMenuRequested(QPoint)
    windowIconChanged        : ClassVar[Signal] = ... # windowIconChanged(QIcon)
    windowIconTextChanged    : ClassVar[Signal] = ... # windowIconTextChanged(QString)
    windowTitleChanged       : ClassVar[Signal] = ... # windowTitleChanged(QString)

    class RenderFlag(enum.Flag):

        DrawWindowBackground     : QWidget.RenderFlag = ... # 0x1
        DrawChildren             : QWidget.RenderFlag = ... # 0x2
        IgnoreMask               : QWidget.RenderFlag = ... # 0x4


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., f: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def acceptDrops(self) -> bool: ...
    def accessibleDescription(self) -> str: ...
    def accessibleName(self) -> str: ...
    def actionEvent(self, event: PySide6.QtGui.QActionEvent) -> None: ...
    def actions(self) -> List[PySide6.QtGui.QAction]: ...
    def activateWindow(self) -> None: ...
    @overload
    def addAction(self, action: PySide6.QtGui.QAction) -> None: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap], text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int]) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], callable: object) -> PySide6.QtGui.QAction: ...
    @overload
    def addAction(self, text: str, shortcut: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], receiver: PySide6.QtCore.QObject, member: Union[bytes, bytearray, memoryview], type: PySide6.QtCore.Qt.ConnectionType = ...) -> PySide6.QtGui.QAction: ...
    def addActions(self, actions: Sequence[PySide6.QtGui.QAction]) -> None: ...
    def adjustSize(self) -> None: ...
    def autoFillBackground(self) -> bool: ...
    def backgroundRole(self) -> PySide6.QtGui.QPalette.ColorRole: ...
    def backingStore(self) -> PySide6.QtGui.QBackingStore: ...
    def baseSize(self) -> PySide6.QtCore.QSize: ...
    def changeEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    @overload
    def childAt(self, p: PySide6.QtCore.QPoint) -> PySide6.QtWidgets.QWidget: ...
    @overload
    def childAt(self, x: int, y: int) -> PySide6.QtWidgets.QWidget: ...
    def childrenRect(self) -> PySide6.QtCore.QRect: ...
    def childrenRegion(self) -> PySide6.QtGui.QRegion: ...
    def clearFocus(self) -> None: ...
    def clearMask(self) -> None: ...
    def close(self) -> bool: ...
    def closeEvent(self, event: PySide6.QtGui.QCloseEvent) -> None: ...
    def contentsMargins(self) -> PySide6.QtCore.QMargins: ...
    def contentsRect(self) -> PySide6.QtCore.QRect: ...
    def contextMenuEvent(self, event: PySide6.QtGui.QContextMenuEvent) -> None: ...
    def contextMenuPolicy(self) -> PySide6.QtCore.Qt.ContextMenuPolicy: ...
    def create(self, arg__1: int = ..., initializeWindow: bool = ..., destroyOldWindow: bool = ...) -> None: ...
    def createWinId(self) -> None: ...
    @staticmethod
    def createWindowContainer(window: PySide6.QtGui.QWindow, parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> PySide6.QtWidgets.QWidget: ...
    def cursor(self) -> PySide6.QtGui.QCursor: ...
    def destroy(self, destroyWindow: bool = ..., destroySubWindows: bool = ...) -> None: ...
    def devType(self) -> int: ...
    def dragEnterEvent(self, event: PySide6.QtGui.QDragEnterEvent) -> None: ...
    def dragLeaveEvent(self, event: PySide6.QtGui.QDragLeaveEvent) -> None: ...
    def dragMoveEvent(self, event: PySide6.QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, event: PySide6.QtGui.QDropEvent) -> None: ...
    def effectiveWinId(self) -> int: ...
    def ensurePolished(self) -> None: ...
    def enterEvent(self, event: PySide6.QtGui.QEnterEvent) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    @staticmethod
    def find(arg__1: int) -> PySide6.QtWidgets.QWidget: ...
    def focusInEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusNextChild(self) -> bool: ...
    def focusNextPrevChild(self, next: bool) -> bool: ...
    def focusOutEvent(self, event: PySide6.QtGui.QFocusEvent) -> None: ...
    def focusPolicy(self) -> PySide6.QtCore.Qt.FocusPolicy: ...
    def focusPreviousChild(self) -> bool: ...
    def focusProxy(self) -> PySide6.QtWidgets.QWidget: ...
    def focusWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def font(self) -> PySide6.QtGui.QFont: ...
    def fontInfo(self) -> PySide6.QtGui.QFontInfo: ...
    def fontMetrics(self) -> PySide6.QtGui.QFontMetrics: ...
    def foregroundRole(self) -> PySide6.QtGui.QPalette.ColorRole: ...
    def frameGeometry(self) -> PySide6.QtCore.QRect: ...
    def frameSize(self) -> PySide6.QtCore.QSize: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def grab(self, rectangle: PySide6.QtCore.QRect = ...) -> PySide6.QtGui.QPixmap: ...
    def grabGesture(self, type: PySide6.QtCore.Qt.GestureType, flags: PySide6.QtCore.Qt.GestureFlag = ...) -> None: ...
    def grabKeyboard(self) -> None: ...
    @overload
    def grabMouse(self) -> None: ...
    @overload
    def grabMouse(self, arg__1: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> None: ...
    def grabShortcut(self, key: Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, str, int], context: PySide6.QtCore.Qt.ShortcutContext = ...) -> int: ...
    def graphicsEffect(self) -> PySide6.QtWidgets.QGraphicsEffect: ...
    def graphicsProxyWidget(self) -> PySide6.QtWidgets.QGraphicsProxyWidget: ...
    def hasFocus(self) -> bool: ...
    def hasHeightForWidth(self) -> bool: ...
    def hasMouseTracking(self) -> bool: ...
    def hasTabletTracking(self) -> bool: ...
    def height(self) -> int: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def hide(self) -> None: ...
    def hideEvent(self, event: PySide6.QtGui.QHideEvent) -> None: ...
    def initPainter(self, painter: PySide6.QtGui.QPainter) -> None: ...
    def inputMethodEvent(self, event: PySide6.QtGui.QInputMethodEvent) -> None: ...
    def inputMethodHints(self) -> PySide6.QtCore.Qt.InputMethodHint: ...
    def inputMethodQuery(self, arg__1: PySide6.QtCore.Qt.InputMethodQuery) -> Any: ...
    def insertAction(self, before: PySide6.QtGui.QAction, action: PySide6.QtGui.QAction) -> None: ...
    def insertActions(self, before: PySide6.QtGui.QAction, actions: Sequence[PySide6.QtGui.QAction]) -> None: ...
    def internalWinId(self) -> int: ...
    def isActiveWindow(self) -> bool: ...
    def isAncestorOf(self, child: PySide6.QtWidgets.QWidget) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isEnabledTo(self, arg__1: PySide6.QtWidgets.QWidget) -> bool: ...
    def isFullScreen(self) -> bool: ...
    def isHidden(self) -> bool: ...
    def isLeftToRight(self) -> bool: ...
    def isMaximized(self) -> bool: ...
    def isMinimized(self) -> bool: ...
    def isModal(self) -> bool: ...
    def isRightToLeft(self) -> bool: ...
    def isTopLevel(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def isVisibleTo(self, arg__1: PySide6.QtWidgets.QWidget) -> bool: ...
    def isWindow(self) -> bool: ...
    def isWindowModified(self) -> bool: ...
    def keyPressEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    def keyReleaseEvent(self, event: PySide6.QtGui.QKeyEvent) -> None: ...
    @staticmethod
    def keyboardGrabber() -> PySide6.QtWidgets.QWidget: ...
    def layout(self) -> PySide6.QtWidgets.QLayout: ...
    def layoutDirection(self) -> PySide6.QtCore.Qt.LayoutDirection: ...
    def leaveEvent(self, event: PySide6.QtCore.QEvent) -> None: ...
    def locale(self) -> PySide6.QtCore.QLocale: ...
    def lower(self) -> None: ...
    @overload
    def mapFrom(self, arg__1: PySide6.QtWidgets.QWidget, arg__2: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapFrom(self, arg__1: PySide6.QtWidgets.QWidget, arg__2: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromGlobal(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapFromGlobal(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapFromParent(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapFromParent(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapTo(self, arg__1: PySide6.QtWidgets.QWidget, arg__2: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapTo(self, arg__1: PySide6.QtWidgets.QWidget, arg__2: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToGlobal(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapToGlobal(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    @overload
    def mapToParent(self, arg__1: PySide6.QtCore.QPoint) -> PySide6.QtCore.QPoint: ...
    @overload
    def mapToParent(self, arg__1: Union[PySide6.QtCore.QPointF, PySide6.QtCore.QPoint, PySide6.QtGui.QPainterPath.Element]) -> PySide6.QtCore.QPointF: ...
    def mask(self) -> PySide6.QtGui.QRegion: ...
    def maximumHeight(self) -> int: ...
    def maximumSize(self) -> PySide6.QtCore.QSize: ...
    def maximumWidth(self) -> int: ...
    def metric(self, arg__1: PySide6.QtGui.QPaintDevice.PaintDeviceMetric) -> int: ...
    def minimumHeight(self) -> int: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def minimumSizeHint(self) -> PySide6.QtCore.QSize: ...
    def minimumWidth(self) -> int: ...
    def mouseDoubleClickEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    @staticmethod
    def mouseGrabber() -> PySide6.QtWidgets.QWidget: ...
    def mouseMoveEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: PySide6.QtGui.QMouseEvent) -> None: ...
    @overload
    def move(self, arg__1: PySide6.QtCore.QPoint) -> None: ...
    @overload
    def move(self, x: int, y: int) -> None: ...
    def moveEvent(self, event: PySide6.QtGui.QMoveEvent) -> None: ...
    def nativeEvent(self, eventType: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], message: int) -> object: ...
    def nativeParentWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def nextInFocusChain(self) -> PySide6.QtWidgets.QWidget: ...
    def normalGeometry(self) -> PySide6.QtCore.QRect: ...
    def overrideWindowFlags(self, type: PySide6.QtCore.Qt.WindowType) -> None: ...
    def overrideWindowState(self, state: PySide6.QtCore.Qt.WindowState) -> None: ...
    def paintEngine(self) -> PySide6.QtGui.QPaintEngine: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    def palette(self) -> PySide6.QtGui.QPalette: ...
    def parentWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def pos(self) -> PySide6.QtCore.QPoint: ...
    def previousInFocusChain(self) -> PySide6.QtWidgets.QWidget: ...
    def raise_(self) -> None: ...
    def rect(self) -> PySide6.QtCore.QRect: ...
    def redirected(self, offset: PySide6.QtCore.QPoint) -> PySide6.QtGui.QPaintDevice: ...
    def releaseKeyboard(self) -> None: ...
    def releaseMouse(self) -> None: ...
    def releaseShortcut(self, id: int) -> None: ...
    def removeAction(self, action: PySide6.QtGui.QAction) -> None: ...
    @overload
    def render(self, painter: PySide6.QtGui.QPainter, targetOffset: PySide6.QtCore.QPoint, sourceRegion: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect] = ..., renderFlags: PySide6.QtWidgets.QWidget.RenderFlag = ...) -> None: ...
    @overload
    def render(self, target: PySide6.QtGui.QPaintDevice, targetOffset: PySide6.QtCore.QPoint = ..., sourceRegion: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect] = ..., renderFlags: PySide6.QtWidgets.QWidget.RenderFlag = ...) -> None: ...
    @overload
    def repaint(self) -> None: ...
    @overload
    def repaint(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    @overload
    def repaint(self, arg__1: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def repaint(self, x: int, y: int, w: int, h: int) -> None: ...
    @overload
    def resize(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @overload
    def resize(self, w: int, h: int) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def restoreGeometry(self, geometry: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview]) -> bool: ...
    def saveGeometry(self) -> PySide6.QtCore.QByteArray: ...
    def screen(self) -> PySide6.QtGui.QScreen: ...
    @overload
    def scroll(self, dx: int, dy: int) -> None: ...
    @overload
    def scroll(self, dx: int, dy: int, arg__3: PySide6.QtCore.QRect) -> None: ...
    def setAcceptDrops(self, on: bool) -> None: ...
    def setAccessibleDescription(self, description: str) -> None: ...
    def setAccessibleName(self, name: str) -> None: ...
    def setAttribute(self, arg__1: PySide6.QtCore.Qt.WidgetAttribute, on: bool = ...) -> None: ...
    def setAutoFillBackground(self, enabled: bool) -> None: ...
    def setBackgroundRole(self, arg__1: PySide6.QtGui.QPalette.ColorRole) -> None: ...
    @overload
    def setBaseSize(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @overload
    def setBaseSize(self, basew: int, baseh: int) -> None: ...
    @overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None: ...
    @overload
    def setContentsMargins(self, margins: PySide6.QtCore.QMargins) -> None: ...
    def setContextMenuPolicy(self, policy: PySide6.QtCore.Qt.ContextMenuPolicy) -> None: ...
    def setCursor(self, arg__1: Union[PySide6.QtGui.QCursor, PySide6.QtCore.Qt.CursorShape, PySide6.QtGui.QPixmap]) -> None: ...
    def setDisabled(self, arg__1: bool) -> None: ...
    def setEnabled(self, arg__1: bool) -> None: ...
    def setFixedHeight(self, h: int) -> None: ...
    @overload
    def setFixedSize(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @overload
    def setFixedSize(self, w: int, h: int) -> None: ...
    def setFixedWidth(self, w: int) -> None: ...
    @overload
    def setFocus(self) -> None: ...
    @overload
    def setFocus(self, reason: PySide6.QtCore.Qt.FocusReason) -> None: ...
    def setFocusPolicy(self, policy: PySide6.QtCore.Qt.FocusPolicy) -> None: ...
    def setFocusProxy(self, arg__1: PySide6.QtWidgets.QWidget) -> None: ...
    def setFont(self, arg__1: Union[PySide6.QtGui.QFont, str, Sequence[str]]) -> None: ...
    def setForegroundRole(self, arg__1: PySide6.QtGui.QPalette.ColorRole) -> None: ...
    @overload
    def setGeometry(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    @overload
    def setGeometry(self, x: int, y: int, w: int, h: int) -> None: ...
    def setGraphicsEffect(self, effect: PySide6.QtWidgets.QGraphicsEffect) -> None: ...
    def setHidden(self, hidden: bool) -> None: ...
    def setInputMethodHints(self, hints: PySide6.QtCore.Qt.InputMethodHint) -> None: ...
    def setLayout(self, arg__1: PySide6.QtWidgets.QLayout) -> None: ...
    def setLayoutDirection(self, direction: PySide6.QtCore.Qt.LayoutDirection) -> None: ...
    def setLocale(self, locale: Union[PySide6.QtCore.QLocale, PySide6.QtCore.QLocale.Language]) -> None: ...
    @overload
    def setMask(self, arg__1: Union[PySide6.QtGui.QBitmap, str]) -> None: ...
    @overload
    def setMask(self, arg__1: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    def setMaximumHeight(self, maxh: int) -> None: ...
    @overload
    def setMaximumSize(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @overload
    def setMaximumSize(self, maxw: int, maxh: int) -> None: ...
    def setMaximumWidth(self, maxw: int) -> None: ...
    def setMinimumHeight(self, minh: int) -> None: ...
    @overload
    def setMinimumSize(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @overload
    def setMinimumSize(self, minw: int, minh: int) -> None: ...
    def setMinimumWidth(self, minw: int) -> None: ...
    def setMouseTracking(self, enable: bool) -> None: ...
    def setPalette(self, arg__1: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor]) -> None: ...
    @overload
    def setParent(self, parent: Optional[PySide6.QtWidgets.QWidget]) -> None: ...
    @overload
    def setParent(self, parent: Optional[PySide6.QtWidgets.QWidget], f: PySide6.QtCore.Qt.WindowType) -> None: ...
    def setScreen(self, arg__1: PySide6.QtGui.QScreen) -> None: ...
    def setShortcutAutoRepeat(self, id: int, enable: bool = ...) -> None: ...
    def setShortcutEnabled(self, id: int, enable: bool = ...) -> None: ...
    @overload
    def setSizeIncrement(self, arg__1: PySide6.QtCore.QSize) -> None: ...
    @overload
    def setSizeIncrement(self, w: int, h: int) -> None: ...
    @overload
    def setSizePolicy(self, arg__1: PySide6.QtWidgets.QSizePolicy) -> None: ...
    @overload
    def setSizePolicy(self, horizontal: PySide6.QtWidgets.QSizePolicy.Policy, vertical: PySide6.QtWidgets.QSizePolicy.Policy) -> None: ...
    def setStatusTip(self, arg__1: str) -> None: ...
    def setStyle(self, arg__1: PySide6.QtWidgets.QStyle) -> None: ...
    def setStyleSheet(self, styleSheet: str) -> None: ...
    @staticmethod
    def setTabOrder(arg__1: PySide6.QtWidgets.QWidget, arg__2: PySide6.QtWidgets.QWidget) -> None: ...
    def setTabletTracking(self, enable: bool) -> None: ...
    def setToolTip(self, arg__1: str) -> None: ...
    def setToolTipDuration(self, msec: int) -> None: ...
    def setUpdatesEnabled(self, enable: bool) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setWhatsThis(self, arg__1: str) -> None: ...
    def setWindowFilePath(self, filePath: str) -> None: ...
    def setWindowFlag(self, arg__1: PySide6.QtCore.Qt.WindowType, on: bool = ...) -> None: ...
    def setWindowFlags(self, type: PySide6.QtCore.Qt.WindowType) -> None: ...
    def setWindowIcon(self, icon: Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap]) -> None: ...
    def setWindowIconText(self, arg__1: str) -> None: ...
    def setWindowModality(self, windowModality: PySide6.QtCore.Qt.WindowModality) -> None: ...
    def setWindowModified(self, arg__1: bool) -> None: ...
    def setWindowOpacity(self, level: float) -> None: ...
    def setWindowRole(self, arg__1: str) -> None: ...
    def setWindowState(self, state: PySide6.QtCore.Qt.WindowState) -> None: ...
    def setWindowTitle(self, arg__1: str) -> None: ...
    def sharedPainter(self) -> PySide6.QtGui.QPainter: ...
    def show(self) -> None: ...
    def showEvent(self, event: PySide6.QtGui.QShowEvent) -> None: ...
    def showFullScreen(self) -> None: ...
    def showMaximized(self) -> None: ...
    def showMinimized(self) -> None: ...
    def showNormal(self) -> None: ...
    def size(self) -> PySide6.QtCore.QSize: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def sizeIncrement(self) -> PySide6.QtCore.QSize: ...
    def sizePolicy(self) -> PySide6.QtWidgets.QSizePolicy: ...
    def stackUnder(self, arg__1: PySide6.QtWidgets.QWidget) -> None: ...
    def statusTip(self) -> str: ...
    def style(self) -> PySide6.QtWidgets.QStyle: ...
    def styleSheet(self) -> str: ...
    def tabletEvent(self, event: PySide6.QtGui.QTabletEvent) -> None: ...
    def testAttribute(self, arg__1: PySide6.QtCore.Qt.WidgetAttribute) -> bool: ...
    def toolTip(self) -> str: ...
    def toolTipDuration(self) -> int: ...
    def topLevelWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def underMouse(self) -> bool: ...
    def ungrabGesture(self, type: PySide6.QtCore.Qt.GestureType) -> None: ...
    def unsetCursor(self) -> None: ...
    def unsetLayoutDirection(self) -> None: ...
    def unsetLocale(self) -> None: ...
    @overload
    def update(self) -> None: ...
    @overload
    def update(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    @overload
    def update(self, arg__1: Union[PySide6.QtGui.QRegion, PySide6.QtGui.QBitmap, PySide6.QtGui.QPolygon, PySide6.QtCore.QRect]) -> None: ...
    @overload
    def update(self, x: int, y: int, w: int, h: int) -> None: ...
    def updateGeometry(self) -> None: ...
    def updateMicroFocus(self, query: PySide6.QtCore.Qt.InputMethodQuery = ...) -> None: ...
    def updatesEnabled(self) -> bool: ...
    def visibleRegion(self) -> PySide6.QtGui.QRegion: ...
    def whatsThis(self) -> str: ...
    def wheelEvent(self, event: PySide6.QtGui.QWheelEvent) -> None: ...
    def width(self) -> int: ...
    def winId(self) -> int: ...
    def window(self) -> PySide6.QtWidgets.QWidget: ...
    def windowFilePath(self) -> str: ...
    def windowFlags(self) -> PySide6.QtCore.Qt.WindowType: ...
    def windowHandle(self) -> PySide6.QtGui.QWindow: ...
    def windowIcon(self) -> PySide6.QtGui.QIcon: ...
    def windowIconText(self) -> str: ...
    def windowModality(self) -> PySide6.QtCore.Qt.WindowModality: ...
    def windowOpacity(self) -> float: ...
    def windowRole(self) -> str: ...
    def windowState(self) -> PySide6.QtCore.Qt.WindowState: ...
    def windowTitle(self) -> str: ...
    def windowType(self) -> PySide6.QtCore.Qt.WindowType: ...
    def x(self) -> int: ...
    def y(self) -> int: ...


class QWidgetAction(PySide6.QtGui.QAction):

    def __init__(self, parent: PySide6.QtCore.QObject) -> None: ...

    def createWidget(self, parent: PySide6.QtWidgets.QWidget) -> PySide6.QtWidgets.QWidget: ...
    def createdWidgets(self) -> List[PySide6.QtWidgets.QWidget]: ...
    def defaultWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def deleteWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def event(self, arg__1: PySide6.QtCore.QEvent) -> bool: ...
    def eventFilter(self, arg__1: PySide6.QtCore.QObject, arg__2: PySide6.QtCore.QEvent) -> bool: ...
    def releaseWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def requestWidget(self, parent: PySide6.QtWidgets.QWidget) -> PySide6.QtWidgets.QWidget: ...
    def setDefaultWidget(self, w: PySide6.QtWidgets.QWidget) -> None: ...


class QWidgetItem(PySide6.QtWidgets.QLayoutItem):

    def __init__(self, w: PySide6.QtWidgets.QWidget) -> None: ...

    def controlTypes(self) -> PySide6.QtWidgets.QSizePolicy.ControlType: ...
    def expandingDirections(self) -> PySide6.QtCore.Qt.Orientation: ...
    def geometry(self) -> PySide6.QtCore.QRect: ...
    def hasHeightForWidth(self) -> bool: ...
    def heightForWidth(self, arg__1: int) -> int: ...
    def isEmpty(self) -> bool: ...
    def maximumSize(self) -> PySide6.QtCore.QSize: ...
    def minimumHeightForWidth(self, arg__1: int) -> int: ...
    def minimumSize(self) -> PySide6.QtCore.QSize: ...
    def setGeometry(self, arg__1: PySide6.QtCore.QRect) -> None: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def widget(self) -> PySide6.QtWidgets.QWidget: ...


class QWizard(PySide6.QtWidgets.QDialog):

    currentIdChanged         : ClassVar[Signal] = ... # currentIdChanged(int)
    customButtonClicked      : ClassVar[Signal] = ... # customButtonClicked(int)
    helpRequested            : ClassVar[Signal] = ... # helpRequested()
    pageAdded                : ClassVar[Signal] = ... # pageAdded(int)
    pageRemoved              : ClassVar[Signal] = ... # pageRemoved(int)

    class WizardButton(enum.Enum):

        NoButton                 : QWizard.WizardButton = ... # -0x1
        BackButton               : QWizard.WizardButton = ... # 0x0
        NextButton               : QWizard.WizardButton = ... # 0x1
        CommitButton             : QWizard.WizardButton = ... # 0x2
        FinishButton             : QWizard.WizardButton = ... # 0x3
        CancelButton             : QWizard.WizardButton = ... # 0x4
        HelpButton               : QWizard.WizardButton = ... # 0x5
        CustomButton1            : QWizard.WizardButton = ... # 0x6
        NStandardButtons         : QWizard.WizardButton = ... # 0x6
        CustomButton2            : QWizard.WizardButton = ... # 0x7
        CustomButton3            : QWizard.WizardButton = ... # 0x8
        NButtons                 : QWizard.WizardButton = ... # 0x9
        Stretch                  : QWizard.WizardButton = ... # 0x9

    class WizardOption(enum.Flag):

        IndependentPages         : QWizard.WizardOption = ... # 0x1
        IgnoreSubTitles          : QWizard.WizardOption = ... # 0x2
        ExtendedWatermarkPixmap  : QWizard.WizardOption = ... # 0x4
        NoDefaultButton          : QWizard.WizardOption = ... # 0x8
        NoBackButtonOnStartPage  : QWizard.WizardOption = ... # 0x10
        NoBackButtonOnLastPage   : QWizard.WizardOption = ... # 0x20
        DisabledBackButtonOnLastPage: QWizard.WizardOption = ... # 0x40
        HaveNextButtonOnLastPage : QWizard.WizardOption = ... # 0x80
        HaveFinishButtonOnEarlyPages: QWizard.WizardOption = ... # 0x100
        NoCancelButton           : QWizard.WizardOption = ... # 0x200
        CancelButtonOnLeft       : QWizard.WizardOption = ... # 0x400
        HaveHelpButton           : QWizard.WizardOption = ... # 0x800
        HelpButtonOnRight        : QWizard.WizardOption = ... # 0x1000
        HaveCustomButton1        : QWizard.WizardOption = ... # 0x2000
        HaveCustomButton2        : QWizard.WizardOption = ... # 0x4000
        HaveCustomButton3        : QWizard.WizardOption = ... # 0x8000
        NoCancelButtonOnLastPage : QWizard.WizardOption = ... # 0x10000

    class WizardPixmap(enum.Enum):

        WatermarkPixmap          : QWizard.WizardPixmap = ... # 0x0
        LogoPixmap               : QWizard.WizardPixmap = ... # 0x1
        BannerPixmap             : QWizard.WizardPixmap = ... # 0x2
        BackgroundPixmap         : QWizard.WizardPixmap = ... # 0x3
        NPixmaps                 : QWizard.WizardPixmap = ... # 0x4

    class WizardStyle(enum.Enum):

        ClassicStyle             : QWizard.WizardStyle = ... # 0x0
        ModernStyle              : QWizard.WizardStyle = ... # 0x1
        MacStyle                 : QWizard.WizardStyle = ... # 0x2
        AeroStyle                : QWizard.WizardStyle = ... # 0x3
        NStyles                  : QWizard.WizardStyle = ... # 0x4


    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ..., flags: PySide6.QtCore.Qt.WindowType = ...) -> None: ...

    def addPage(self, page: PySide6.QtWidgets.QWizardPage) -> int: ...
    def back(self) -> None: ...
    def button(self, which: PySide6.QtWidgets.QWizard.WizardButton) -> PySide6.QtWidgets.QAbstractButton: ...
    def buttonText(self, which: PySide6.QtWidgets.QWizard.WizardButton) -> str: ...
    def cleanupPage(self, id: int) -> None: ...
    def currentId(self) -> int: ...
    def currentPage(self) -> PySide6.QtWidgets.QWizardPage: ...
    def done(self, result: int) -> None: ...
    def event(self, event: PySide6.QtCore.QEvent) -> bool: ...
    def field(self, name: str) -> Any: ...
    def hasVisitedPage(self, id: int) -> bool: ...
    def initializePage(self, id: int) -> None: ...
    def nativeEvent(self, eventType: Union[PySide6.QtCore.QByteArray, bytes, bytearray, memoryview], message: int) -> object: ...
    def next(self) -> None: ...
    def nextId(self) -> int: ...
    def options(self) -> PySide6.QtWidgets.QWizard.WizardOption: ...
    def page(self, id: int) -> PySide6.QtWidgets.QWizardPage: ...
    def pageIds(self) -> List[int]: ...
    def paintEvent(self, event: PySide6.QtGui.QPaintEvent) -> None: ...
    def pixmap(self, which: PySide6.QtWidgets.QWizard.WizardPixmap) -> PySide6.QtGui.QPixmap: ...
    def removePage(self, id: int) -> None: ...
    def resizeEvent(self, event: PySide6.QtGui.QResizeEvent) -> None: ...
    def restart(self) -> None: ...
    def setButton(self, which: PySide6.QtWidgets.QWizard.WizardButton, button: PySide6.QtWidgets.QAbstractButton) -> None: ...
    def setButtonLayout(self, layout: Sequence[PySide6.QtWidgets.QWizard.WizardButton]) -> None: ...
    def setButtonText(self, which: PySide6.QtWidgets.QWizard.WizardButton, text: str) -> None: ...
    def setCurrentId(self, id: int) -> None: ...
    def setDefaultProperty(self, className: Union[bytes, bytearray, memoryview], property: Union[bytes, bytearray, memoryview], changedSignal: Union[bytes, bytearray, memoryview]) -> None: ...
    def setField(self, name: str, value: Any) -> None: ...
    def setOption(self, option: PySide6.QtWidgets.QWizard.WizardOption, on: bool = ...) -> None: ...
    def setOptions(self, options: PySide6.QtWidgets.QWizard.WizardOption) -> None: ...
    def setPage(self, id: int, page: PySide6.QtWidgets.QWizardPage) -> None: ...
    def setPixmap(self, which: PySide6.QtWidgets.QWizard.WizardPixmap, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def setSideWidget(self, widget: PySide6.QtWidgets.QWidget) -> None: ...
    def setStartId(self, id: int) -> None: ...
    def setSubTitleFormat(self, format: PySide6.QtCore.Qt.TextFormat) -> None: ...
    def setTitleFormat(self, format: PySide6.QtCore.Qt.TextFormat) -> None: ...
    def setVisible(self, visible: bool) -> None: ...
    def setWizardStyle(self, style: PySide6.QtWidgets.QWizard.WizardStyle) -> None: ...
    def sideWidget(self) -> PySide6.QtWidgets.QWidget: ...
    def sizeHint(self) -> PySide6.QtCore.QSize: ...
    def startId(self) -> int: ...
    def subTitleFormat(self) -> PySide6.QtCore.Qt.TextFormat: ...
    def testOption(self, option: PySide6.QtWidgets.QWizard.WizardOption) -> bool: ...
    def titleFormat(self) -> PySide6.QtCore.Qt.TextFormat: ...
    def validateCurrentPage(self) -> bool: ...
    def visitedIds(self) -> List[int]: ...
    def wizardStyle(self) -> PySide6.QtWidgets.QWizard.WizardStyle: ...


class QWizardPage(PySide6.QtWidgets.QWidget):

    completeChanged          : ClassVar[Signal] = ... # completeChanged()

    def __init__(self, parent: Optional[PySide6.QtWidgets.QWidget] = ...) -> None: ...

    def buttonText(self, which: PySide6.QtWidgets.QWizard.WizardButton) -> str: ...
    def cleanupPage(self) -> None: ...
    def field(self, name: str) -> Any: ...
    def initializePage(self) -> None: ...
    def isCommitPage(self) -> bool: ...
    def isComplete(self) -> bool: ...
    def isFinalPage(self) -> bool: ...
    def nextId(self) -> int: ...
    def pixmap(self, which: PySide6.QtWidgets.QWizard.WizardPixmap) -> PySide6.QtGui.QPixmap: ...
    @overload
    def registerField(self, name: str, widget: PySide6.QtWidgets.QWidget, property: str, changedSignal: PySide6.QtCore.SignalInstance) -> None: ...
    @overload
    def registerField(self, name: str, widget: PySide6.QtWidgets.QWidget, property: Optional[str] = ..., changed_signal: Optional[str] = ...) -> None: ...
    def setButtonText(self, which: PySide6.QtWidgets.QWizard.WizardButton, text: str) -> None: ...
    def setCommitPage(self, commitPage: bool) -> None: ...
    def setField(self, name: str, value: Any) -> None: ...
    def setFinalPage(self, finalPage: bool) -> None: ...
    def setPixmap(self, which: PySide6.QtWidgets.QWizard.WizardPixmap, pixmap: Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage, str]) -> None: ...
    def setSubTitle(self, subTitle: str) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def subTitle(self) -> str: ...
    def title(self) -> str: ...
    def validatePage(self) -> bool: ...
    def wizard(self) -> PySide6.QtWidgets.QWizard: ...


@overload
def qDrawPlainRect(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, arg__3: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int], lineWidth: int = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawPlainRect(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, arg__6: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int], lineWidth: int = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawPlainRoundedRect(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, rx: float, ry: float, arg__8: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int], lineWidth: int = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawPlainRoundedRect(painter: PySide6.QtGui.QPainter, rect: PySide6.QtCore.QRect, rx: float, ry: float, lineColor: Union[PySide6.QtGui.QColor, str, PySide6.QtGui.QRgba64, Any, PySide6.QtCore.Qt.GlobalColor, int], lineWidth: int = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawShadeLine(p: PySide6.QtGui.QPainter, p1: PySide6.QtCore.QPoint, p2: PySide6.QtCore.QPoint, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ...) -> None: ...
@overload
def qDrawShadeLine(p: PySide6.QtGui.QPainter, x1: int, y1: int, x2: int, y2: int, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ...) -> None: ...
@overload
def qDrawShadePanel(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., lineWidth: int = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawShadePanel(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., lineWidth: int = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawShadeRect(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawShadeRect(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., lineWidth: int = ..., midLineWidth: int = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawWinButton(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawWinButton(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawWinPanel(p: PySide6.QtGui.QPainter, r: PySide6.QtCore.QRect, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...
@overload
def qDrawWinPanel(p: PySide6.QtGui.QPainter, x: int, y: int, w: int, h: int, pal: Union[PySide6.QtGui.QPalette, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor], sunken: bool = ..., fill: Union[PySide6.QtGui.QBrush, PySide6.QtCore.Qt.BrushStyle, PySide6.QtCore.Qt.GlobalColor, PySide6.QtGui.QColor, PySide6.QtGui.QGradient, PySide6.QtGui.QImage, PySide6.QtGui.QPixmap, NoneType] = ...) -> None: ...


# eof
