# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Seacas/SEACASSuplibC clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "SEACASSuplibC requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Seacas/SEACASSuplibC build
## ---------------------------------------------------------------------------

set(SEACASSuplibC_CXX_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/g++.exe")

set(SEACASSuplibC_C_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/gcc.exe")

set(SEACASSuplibC_Fortran_COMPILER "gfortran")
# Deprecated!
set(SEACASSuplibC_FORTRAN_COMPILER "gfortran") 


## ---------------------------------------------------------------------------
## Compiler flags used by Seacas/SEACASSuplibC build
## ---------------------------------------------------------------------------

## Give the build type
set(SEACASSuplibC_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(SEACASSuplibC_CXX_FLAGS [[ ]])

set(SEACASSuplibC_C_FLAGS [[  -Wall -Wunused -pedantic -Wshadow -std=c11 ]])

set(SEACASSuplibC_Fortran_FLAGS [[ ]])
# Deprecated
set(SEACASSuplibC_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(SEACASSuplibC_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(SEACASSuplibC_SHARED_LIB_RPATH_COMMAND "${CMAKE_CURRENT_LIST_DIR}/../../../lib")
set(SEACASSuplibC_BUILD_SHARED_LIBS "ON")

set(SEACASSuplibC_LINKER ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ld.exe)
set(SEACASSuplibC_AR ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(SEACASSuplibC_INSTALL_DIR "${CMAKE_CURRENT_LIST_DIR}/../../..")

## List of package libraries
set(SEACASSuplibC_LIBRARIES SEACASSuplibC::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(SEACASSuplibC_MPI_LIBRARIES "")
set(SEACASSuplibC_MPI_LIBRARY_DIRS "")
set(SEACASSuplibC_MPI_INCLUDE_DIRS "")
set(SEACASSuplibC_MPI_EXEC "")
set(SEACASSuplibC_MPI_EXEC_MAX_NUMPROCS "")
set(SEACASSuplibC_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies

# Exported cache variables
set(SEACAS_ENABLE_DEBUG "OFF")
set(HAVE_SEACAS_DEBUG "OFF")
set(SEACASExodus_ENABLE_THREADSAFE "YES")
set(EXODUS_THREADSAFE "ON")
set(SEACASIoss_ENABLE_THREADSAFE "YES")
set(IOSS_THREADSAFE "ON")

# Include configuration of dependent packages

# Import SEACASSuplibC targets
include("${CMAKE_CURRENT_LIST_DIR}/SEACASSuplibCTargets.cmake")

# Standard TriBITS-compliant external package variables
set(SEACASSuplibC_IS_TRIBITS_COMPLIANT TRUE)
set(SEACASSuplibC_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(SEACASSuplibC_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(SEACASSuplibC_EXPORTED_PACKAGE_LIBS_NAMES "suplib_c")

foreach(libname IN LISTS SEACASSuplibC_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE SEACASSuplibC::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Seacas', then use the"
      " new namespaced target 'SEACASSuplibC::${libname}', or better yet,"
      " 'SEACASSuplibC::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'SEACASSuplibC'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Seacas', instead link against the"
      " libraries specified by the variable 'SEACASSuplibC_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
