/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.session;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.api.files.MPPPathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\r"}, d2={"Lorg/islandoftex/arara/core/session/ClassLoading;", "", "()V", "loadClass", "Lkotlin/Pair;", "Lorg/islandoftex/arara/core/session/ClassLoading$ClassLoadingStatus;", "Ljava/lang/Class;", "path", "Lorg/islandoftex/arara/api/files/MPPPath;", "name", "", "loadObject", "ClassLoadingStatus", "core"})
public final class ClassLoading {
    @NotNull
    public static final ClassLoading INSTANCE = new ClassLoading();

    private ClassLoading() {
    }

    @JvmStatic
    @NotNull
    public static final Pair<ClassLoadingStatus, Class<?>> loadClass(@NotNull MPPPath path2, @NotNull String name) {
        ClassLoadingStatus classLoadingStatus;
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(name, "name");
        File file = MPPPathKt.toJVMFile(path2);
        Class value = Object.class;
        if (!file.exists()) {
            classLoadingStatus = ClassLoadingStatus.FILE_NOT_FOUND;
        } else {
            ClassLoadingStatus classLoadingStatus2;
            try {
                URL[] uRLArray = new URL[]{file.toURI().toURL()};
                URLClassLoader classloader = new URLClassLoader(uRLArray, ClassLoading.class.getClassLoader());
                Class<?> clazz = Class.forName(name, true, classloader);
                Intrinsics.checkNotNullExpressionValue(clazz, "forName(name, true, classloader)");
                value = clazz;
                classLoadingStatus2 = ClassLoadingStatus.SUCCESS;
            }
            catch (MalformedURLException _) {
                classLoadingStatus2 = ClassLoadingStatus.MALFORMED_URL;
            }
            catch (ClassNotFoundException _) {
                classLoadingStatus2 = ClassLoadingStatus.CLASS_NOT_FOUND;
            }
            classLoadingStatus = classLoadingStatus2;
        }
        ClassLoadingStatus status2 = classLoadingStatus;
        return TuplesKt.to(status2, value);
    }

    @JvmStatic
    @NotNull
    public static final Pair<ClassLoadingStatus, Object> loadObject(@NotNull MPPPath path2, @NotNull String name) {
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(name, "name");
        Pair<ClassLoadingStatus, Class<?>> pair2 = ClassLoading.loadClass(path2, name);
        ClassLoadingStatus status2 = pair2.getFirst();
        Object value = new Object();
        if (status2 == ClassLoadingStatus.SUCCESS) {
            try {
                Object obj = pair2.getSecond().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkNotNullExpressionValue(obj, "pair.second.getDeclaredConstructor().newInstance()");
                value = obj;
            }
            catch (IllegalAccessException _) {
                status2 = ClassLoadingStatus.ILLEGAL_ACCESS;
            }
            catch (InstantiationException _) {
                status2 = ClassLoadingStatus.INSTANTIATION_EXCEPTION;
            }
            catch (InvocationTargetException _) {
                status2 = ClassLoadingStatus.INSTANTIATION_EXCEPTION;
            }
        }
        return TuplesKt.to(status2, value);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/islandoftex/arara/core/session/ClassLoading$ClassLoadingStatus;", "", "(Ljava/lang/String;I)V", "SUCCESS", "FILE_NOT_FOUND", "MALFORMED_URL", "CLASS_NOT_FOUND", "ILLEGAL_ACCESS", "INSTANTIATION_EXCEPTION", "core"})
    public static final class ClassLoadingStatus
    extends Enum<ClassLoadingStatus> {
        public static final /* enum */ ClassLoadingStatus SUCCESS = new ClassLoadingStatus();
        public static final /* enum */ ClassLoadingStatus FILE_NOT_FOUND = new ClassLoadingStatus();
        public static final /* enum */ ClassLoadingStatus MALFORMED_URL = new ClassLoadingStatus();
        public static final /* enum */ ClassLoadingStatus CLASS_NOT_FOUND = new ClassLoadingStatus();
        public static final /* enum */ ClassLoadingStatus ILLEGAL_ACCESS = new ClassLoadingStatus();
        public static final /* enum */ ClassLoadingStatus INSTANTIATION_EXCEPTION = new ClassLoadingStatus();
        private static final /* synthetic */ ClassLoadingStatus[] $VALUES;

        public static ClassLoadingStatus[] values() {
            return (ClassLoadingStatus[])$VALUES.clone();
        }

        public static ClassLoadingStatus valueOf(String value) {
            return Enum.valueOf(ClassLoadingStatus.class, value);
        }

        static {
            $VALUES = classLoadingStatusArray = new ClassLoadingStatus[]{ClassLoadingStatus.SUCCESS, ClassLoadingStatus.FILE_NOT_FOUND, ClassLoadingStatus.MALFORMED_URL, ClassLoadingStatus.CLASS_NOT_FOUND, ClassLoadingStatus.ILLEGAL_ACCESS, ClassLoadingStatus.INSTANTIATION_EXCEPTION};
        }
    }
}

