; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -global-isel=0 -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -enable-var-scope -check-prefixes=SI-SDAG %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -global-isel=1 -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -check-prefixes=SI-GISEL %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=fiji -global-isel=0 -mattr=-flat-for-global -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -enable-var-scope -check-prefixes=VI-SDAG %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=fiji -global-isel=1 -mattr=-flat-for-global -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -enable-var-scope -check-prefixes=VI-GISEL %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx900 -global-isel=0 -mattr=-flat-for-global -denormal-fp-math=preserve-sign -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -enable-var-scope -check-prefixes=GFX9-SDAG %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx900 -global-isel=1 -mattr=-flat-for-global -denormal-fp-math=preserve-sign -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -enable-var-scope -check-prefixes=GFX9-GISEL %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx950 -global-isel=0 -mattr=-flat-for-global -denormal-fp-math=preserve-sign -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -enable-var-scope -check-prefixes=GFX950-SDAG %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx950 -global-isel=1 -mattr=-flat-for-global -denormal-fp-math=preserve-sign -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -enable-var-scope -check-prefixes=GFX950-GISEL %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx1100 -global-isel=0 -mattr=-flat-for-global -denormal-fp-math=preserve-sign -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -enable-var-scope -check-prefixes=GFX11-SDAG %s
; RUN: llc -amdgpu-scalarize-global-loads=false -mtriple=amdgcn -mcpu=gfx1100 -global-isel=1 -mattr=-flat-for-global -denormal-fp-math=preserve-sign -verify-machineinstrs -enable-unsafe-fp-math < %s | FileCheck -enable-var-scope -check-prefixes=GFX11-GISEL %s

define amdgpu_kernel void @fptrunc_f32_to_f16(
; SI-SDAG-LABEL: fptrunc_f32_to_f16:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fptrunc_f32_to_f16:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dword s3, s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s3
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fptrunc_f32_to_f16:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fptrunc_f32_to_f16:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fptrunc_f32_to_f16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fptrunc_f32_to_f16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fptrunc_f32_to_f16:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX950-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fptrunc_f32_to_f16:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fptrunc_f32_to_f16:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-SDAG-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fptrunc_f32_to_f16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) {
entry:
  %a.val = load float, ptr addrspace(1) %a
  %r.val = fptrunc float %a.val to half
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fptrunc_f64_to_f16(
; SI-SDAG-LABEL: fptrunc_f64_to_f16:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; SI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fptrunc_f64_to_f16:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, s[4:5]
; SI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fptrunc_f64_to_f16:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; VI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fptrunc_f64_to_f16:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, s[2:3]
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fptrunc_f64_to_f16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fptrunc_f64_to_f16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, s[2:3]
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fptrunc_f64_to_f16:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX950-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fptrunc_f64_to_f16:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, s[2:3]
; GFX950-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fptrunc_f64_to_f16:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b64 v[0:1], off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-SDAG-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fptrunc_f64_to_f16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, s[2:3]
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-GISEL-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) {
entry:
  %a.val = load double, ptr addrspace(1) %a
  %r.val = fptrunc double %a.val to half
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fptrunc_v2f32_to_v2f16(
; SI-SDAG-LABEL: fptrunc_v2f32_to_v2f16:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SDAG-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fptrunc_v2f32_to_v2f16:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s4
; SI-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, s5
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fptrunc_v2f32_to_v2f16:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f16_f32_sdwa v1, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-SDAG-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fptrunc_v2f32_to_v2f16:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; VI-GISEL-NEXT:    v_cvt_f16_f32_sdwa v1, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fptrunc_v2f32_to_v2f16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fptrunc_v2f32_to_v2f16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dwordx2 s[2:3], s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, s3
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fptrunc_v2f32_to_v2f16:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fptrunc_v2f32_to_v2f16:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dwordx2 s[4:5], s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[4:5]
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v0, v0, v1
; GFX950-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fptrunc_v2f32_to_v2f16:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b64 v[0:1], off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-SDAG-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fptrunc_v2f32_to_v2f16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b64 s[2:3], s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, s3
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-GISEL-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) {
entry:
  %a.val = load <2 x float>, ptr addrspace(1) %a
  %r.val = fptrunc <2 x float> %a.val to <2 x half>
  store <2 x half> %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fptrunc_v2f64_to_v2f16(
; SI-SDAG-LABEL: fptrunc_v2f64_to_v2f16:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f32_f64_e32 v2, v[2:3]
; SI-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; SI-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v2
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SDAG-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fptrunc_v2f64_to_v2f16:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, s[4:5]
; SI-GISEL-NEXT:    v_cvt_f32_f64_e32 v1, s[6:7]
; SI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-GISEL-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fptrunc_v2f64_to_v2f16:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f32_f64_e32 v2, v[2:3]
; VI-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; VI-SDAG-NEXT:    v_cvt_f16_f32_sdwa v1, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-SDAG-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fptrunc_v2f64_to_v2f16:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, s[4:5]
; VI-GISEL-NEXT:    v_cvt_f32_f64_e32 v1, s[6:7]
; VI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-GISEL-NEXT:    v_cvt_f16_f32_sdwa v1, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD
; VI-GISEL-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fptrunc_v2f64_to_v2f16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f32_f64_e32 v2, v[2:3]
; GFX9-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v2
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-SDAG-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fptrunc_v2f64_to_v2f16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, s[4:5]
; GFX9-GISEL-NEXT:    v_cvt_f32_f64_e32 v1, s[6:7]
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX9-GISEL-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX9-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fptrunc_v2f64_to_v2f16:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f32_f64_e32 v2, v[2:3]
; GFX950-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX950-SDAG-NEXT:    v_cvt_pk_f16_f32 v0, v0, v2
; GFX950-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fptrunc_v2f64_to_v2f16:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[4:7], s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_mov_b64_e32 v[0:1], s[4:5]
; GFX950-GISEL-NEXT:    v_mov_b64_e32 v[2:3], s[6:7]
; GFX950-GISEL-NEXT:    v_cvt_f32_f64_e32 v2, v[2:3]
; GFX950-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX950-GISEL-NEXT:    v_cvt_pk_f16_f32 v0, v0, v2
; GFX950-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fptrunc_v2f64_to_v2f16:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b128 v[0:3], off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f32_f64_e32 v0, v[0:1]
; GFX11-SDAG-NEXT:    v_cvt_f32_f64_e32 v1, v[2:3]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-SDAG-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-SDAG-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fptrunc_v2f64_to_v2f16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f32_f64_e32 v0, s[4:5]
; GFX11-GISEL-NEXT:    v_cvt_f32_f64_e32 v1, s[6:7]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_pack_b32_f16 v0, v0, v1
; GFX11-GISEL-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) {
entry:
  %a.val = load <2 x double>, ptr addrspace(1) %a
  %r.val = fptrunc <2 x double> %a.val to <2 x half>
  store <2 x half> %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fneg_fptrunc_f32_to_f16(
; SI-SDAG-LABEL: fneg_fptrunc_f32_to_f16:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; SI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fneg_fptrunc_f32_to_f16:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dword s3, s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -s3
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fneg_fptrunc_f32_to_f16:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; VI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fneg_fptrunc_f32_to_f16:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -s2
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fneg_fptrunc_f32_to_f16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; GFX9-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fneg_fptrunc_f32_to_f16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -s2
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fneg_fptrunc_f32_to_f16:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; GFX950-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fneg_fptrunc_f32_to_f16:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -s2
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fneg_fptrunc_f32_to_f16:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -v0
; GFX11-SDAG-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fneg_fptrunc_f32_to_f16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -s2
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) {
entry:
  %a.val = load float, ptr addrspace(1) %a
  %a.fneg = fneg float %a.val
  %r.val = fptrunc float %a.fneg to half
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fabs_fptrunc_f32_to_f16(
; SI-SDAG-LABEL: fabs_fptrunc_f32_to_f16:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; SI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fabs_fptrunc_f32_to_f16:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dword s3, s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s3|
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fabs_fptrunc_f32_to_f16:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; VI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fabs_fptrunc_f32_to_f16:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s2|
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fabs_fptrunc_f32_to_f16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; GFX9-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fabs_fptrunc_f32_to_f16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s2|
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fabs_fptrunc_f32_to_f16:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; GFX950-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fabs_fptrunc_f32_to_f16:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s2|
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fabs_fptrunc_f32_to_f16:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; GFX11-SDAG-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fabs_fptrunc_f32_to_f16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s2|
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) {
entry:
  %a.val = load float, ptr addrspace(1) %a
  %a.fabs = call float @llvm.fabs.f32(float %a.val)
  %r.val = fptrunc float %a.fabs to half
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fneg_fabs_fptrunc_f32_to_f16(
; SI-SDAG-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -|v0|
; SI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dword s3, s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -|s3|
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -|v0|
; VI-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -|s2|
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -|v0|
; GFX9-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -|s2|
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -|v0|
; GFX950-SDAG-NEXT:    buffer_store_short v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -|s2|
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    buffer_store_short v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, -|v0|
; GFX11-SDAG-NEXT:    buffer_store_b16 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fneg_fabs_fptrunc_f32_to_f16:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, -|s2|
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    buffer_store_b16 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) #0 {
entry:
  %a.val = load float, ptr addrspace(1) %a
  %a.fabs = call float @llvm.fabs.f32(float %a.val)
  %a.fneg.fabs = fneg float %a.fabs
  %r.val = fptrunc float %a.fneg.fabs to half
  store half %r.val, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fptrunc_f32_to_f16_zext_i32(
; SI-SDAG-LABEL: fptrunc_f32_to_f16_zext_i32:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fptrunc_f32_to_f16_zext_i32:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dword s3, s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s3
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fptrunc_f32_to_f16_zext_i32:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fptrunc_f32_to_f16_zext_i32:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fptrunc_f32_to_f16_zext_i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fptrunc_f32_to_f16_zext_i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fptrunc_f32_to_f16_zext_i32:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX950-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fptrunc_f32_to_f16_zext_i32:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fptrunc_f32_to_f16_zext_i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-SDAG-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fptrunc_f32_to_f16_zext_i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) #0 {
entry:
  %a.val = load float, ptr addrspace(1) %a
  %r.val = fptrunc float %a.val to half
  %r.i16 = bitcast half %r.val to i16
  %zext = zext i16 %r.i16 to i32
  store i32 %zext, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fptrunc_fabs_f32_to_f16_zext_i32(
; SI-SDAG-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; SI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dword s3, s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s3|
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; VI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s2|
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s2|
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; GFX950-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s2|
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e64 v0, |v0|
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-SDAG-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fptrunc_fabs_f32_to_f16_zext_i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e64 v0, |s2|
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) #0 {
entry:
  %a.val = load float, ptr addrspace(1) %a
  %a.fabs = call float @llvm.fabs.f32(float %a.val)
  %r.val = fptrunc float %a.fabs to half
  %r.i16 = bitcast half %r.val to i16
  %zext = zext i16 %r.i16 to i32
  store i32 %zext, ptr addrspace(1) %r
  ret void
}

define amdgpu_kernel void @fptrunc_f32_to_f16_sext_i32(
; SI-SDAG-LABEL: fptrunc_f32_to_f16_sext_i32:
; SI-SDAG:       ; %bb.0: ; %entry
; SI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; SI-SDAG-NEXT:    s_mov_b32 s6, -1
; SI-SDAG-NEXT:    s_mov_b32 s10, s6
; SI-SDAG-NEXT:    s_mov_b32 s11, s7
; SI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s8, s2
; SI-SDAG-NEXT:    s_mov_b32 s9, s3
; SI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-SDAG-NEXT:    s_mov_b32 s4, s0
; SI-SDAG-NEXT:    s_mov_b32 s5, s1
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; SI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; SI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-SDAG-NEXT:    s_endpgm
;
; SI-GISEL-LABEL: fptrunc_f32_to_f16_sext_i32:
; SI-GISEL:       ; %bb.0: ; %entry
; SI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    s_load_dword s3, s[2:3], 0x0
; SI-GISEL-NEXT:    s_mov_b32 s2, -1
; SI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; SI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s3
; SI-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; SI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; SI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; SI-GISEL-NEXT:    s_endpgm
;
; VI-SDAG-LABEL: fptrunc_f32_to_f16_sext_i32:
; VI-SDAG:       ; %bb.0: ; %entry
; VI-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; VI-SDAG-NEXT:    s_mov_b32 s6, -1
; VI-SDAG-NEXT:    s_mov_b32 s10, s6
; VI-SDAG-NEXT:    s_mov_b32 s11, s7
; VI-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s8, s2
; VI-SDAG-NEXT:    s_mov_b32 s9, s3
; VI-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; VI-SDAG-NEXT:    s_mov_b32 s4, s0
; VI-SDAG-NEXT:    s_mov_b32 s5, s1
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0)
; VI-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; VI-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; VI-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; VI-SDAG-NEXT:    s_endpgm
;
; VI-GISEL-LABEL: fptrunc_f32_to_f16_sext_i32:
; VI-GISEL:       ; %bb.0: ; %entry
; VI-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; VI-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; VI-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; VI-GISEL-NEXT:    s_mov_b32 s2, -1
; VI-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; VI-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; VI-GISEL-NEXT:    s_endpgm
;
; GFX9-SDAG-LABEL: fptrunc_f32_to_f16_sext_i32:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX9-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX9-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX9-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX9-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX9-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX9-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX9-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX9-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX9-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX9-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX9-SDAG-NEXT:    s_endpgm
;
; GFX9-GISEL-LABEL: fptrunc_f32_to_f16_sext_i32:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX9-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX9-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX9-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX9-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX9-GISEL-NEXT:    s_endpgm
;
; GFX950-SDAG-LABEL: fptrunc_f32_to_f16_sext_i32:
; GFX950-SDAG:       ; %bb.0: ; %entry
; GFX950-SDAG-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-SDAG-NEXT:    s_mov_b32 s7, 0xf000
; GFX950-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX950-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX950-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX950-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX950-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX950-SDAG-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GFX950-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX950-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX950-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX950-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX950-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX950-SDAG-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GFX950-SDAG-NEXT:    s_endpgm
;
; GFX950-GISEL-LABEL: fptrunc_f32_to_f16_sext_i32:
; GFX950-GISEL:       ; %bb.0: ; %entry
; GFX950-GISEL-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX950-GISEL-NEXT:    s_mov_b32 s3, 0xf000
; GFX950-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX950-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX950-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX950-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX950-GISEL-NEXT:    buffer_store_dword v0, off, s[0:3], 0
; GFX950-GISEL-NEXT:    s_endpgm
;
; GFX11-SDAG-LABEL: fptrunc_f32_to_f16_sext_i32:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-SDAG-NEXT:    s_mov_b32 s6, -1
; GFX11-SDAG-NEXT:    s_mov_b32 s7, 0x31016000
; GFX11-SDAG-NEXT:    s_mov_b32 s10, s6
; GFX11-SDAG-NEXT:    s_mov_b32 s11, s7
; GFX11-SDAG-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_mov_b32 s8, s2
; GFX11-SDAG-NEXT:    s_mov_b32 s9, s3
; GFX11-SDAG-NEXT:    s_mov_b32 s4, s0
; GFX11-SDAG-NEXT:    buffer_load_b32 v0, off, s[8:11], 0
; GFX11-SDAG-NEXT:    s_mov_b32 s5, s1
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX11-SDAG-NEXT:    buffer_store_b32 v0, off, s[4:7], 0
; GFX11-SDAG-NEXT:    s_endpgm
;
; GFX11-GISEL-LABEL: fptrunc_f32_to_f16_sext_i32:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-GISEL-NEXT:    s_mov_b32 s3, 0x31016000
; GFX11-GISEL-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, s2
; GFX11-GISEL-NEXT:    s_mov_b32 s2, -1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_bfe_i32 v0, v0, 0, 16
; GFX11-GISEL-NEXT:    buffer_store_b32 v0, off, s[0:3], 0
; GFX11-GISEL-NEXT:    s_endpgm
    ptr addrspace(1) %r,
    ptr addrspace(1) %a) #0 {
entry:
  %a.val = load float, ptr addrspace(1) %a
  %r.val = fptrunc float %a.val to half
  %r.i16 = bitcast half %r.val to i16
  %zext = sext i16 %r.i16 to i32
  store i32 %zext, ptr addrspace(1) %r
  ret void
}

declare float @llvm.fabs.f32(float) #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
