; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV32I %s
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I %s

define <vscale x 1 x i8> @constraint_vr(<vscale x 1 x i8> %0, <vscale x 1 x i8> %1) nounwind {
; RV32I-LABEL: constraint_vr:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_vr:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
  %a = tail call <vscale x 1 x i8> asm "vadd.vv $0, $1, $2", "=^vr,^vr,^vr"(
    <vscale x 1 x i8> %0, <vscale x 1 x i8> %1)
  ret <vscale x 1 x i8> %a
}

define <vscale x 1 x i8> @constraint_vd(<vscale x 1 x i8> %0, <vscale x 1 x i8> %1) nounwind {
; RV32I-LABEL: constraint_vd:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    vadd.vv v8, v8, v9
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_vd:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    vadd.vv v8, v8, v9
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
  %a = tail call <vscale x 1 x i8> asm "vadd.vv $0, $1, $2", "=^vd,^vr,^vr"(
    <vscale x 1 x i8> %0, <vscale x 1 x i8> %1)
  ret <vscale x 1 x i8> %a
}

define <vscale x 1 x i1> @constraint_vm(<vscale x 1 x i1> %0, <vscale x 1 x i1> %1) nounwind {
; RV32I-LABEL: constraint_vm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    vsetivli zero, 1, e8, m1, ta, ma
; RV32I-NEXT:    vmv1r.v v9, v0
; RV32I-NEXT:    vmv1r.v v0, v8
; RV32I-NEXT:    #APP
; RV32I-NEXT:    vadd.vv v0, v9, v0
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_vm:
; RV64I:       # %bb.0:
; RV64I-NEXT:    vsetivli zero, 1, e8, m1, ta, ma
; RV64I-NEXT:    vmv1r.v v9, v0
; RV64I-NEXT:    vmv1r.v v0, v8
; RV64I-NEXT:    #APP
; RV64I-NEXT:    vadd.vv v0, v9, v0
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
  %a = tail call <vscale x 1 x i1> asm "vadd.vv $0, $1, $2", "=^vr,^vr,^vm"(
    <vscale x 1 x i1> %0, <vscale x 1 x i1> %1)
  ret <vscale x 1 x i1> %a
}
