; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE


target triple = "aarch64-unknown-linux-gnu"

define void @zip1_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: zip1_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    mov z2.b, z0.b[15]
; CHECK-NEXT:    mov z4.b, z0.b[14]
; CHECK-NEXT:    mov z6.b, z0.b[13]
; CHECK-NEXT:    mov z3.b, z1.b[15]
; CHECK-NEXT:    mov z5.b, z1.b[14]
; CHECK-NEXT:    mov z7.b, z1.b[13]
; CHECK-NEXT:    mov z16.b, z0.b[12]
; CHECK-NEXT:    mov z17.b, z1.b[12]
; CHECK-NEXT:    mov z18.b, z0.b[11]
; CHECK-NEXT:    mov z19.b, z1.b[11]
; CHECK-NEXT:    mov z20.b, z0.b[10]
; CHECK-NEXT:    mov z21.b, z1.b[10]
; CHECK-NEXT:    mov z22.b, z0.b[9]
; CHECK-NEXT:    mov z23.b, z1.b[9]
; CHECK-NEXT:    mov z24.b, z0.b[8]
; CHECK-NEXT:    mov z25.b, z1.b[8]
; CHECK-NEXT:    zip1 z2.b, z2.b, z3.b
; CHECK-NEXT:    zip1 z3.b, z4.b, z5.b
; CHECK-NEXT:    zip1 z4.b, z6.b, z7.b
; CHECK-NEXT:    zip1 z5.b, z16.b, z17.b
; CHECK-NEXT:    zip1 z6.b, z18.b, z19.b
; CHECK-NEXT:    zip1 z7.b, z20.b, z21.b
; CHECK-NEXT:    zip1 z16.b, z22.b, z23.b
; CHECK-NEXT:    zip1 z0.b, z0.b, z1.b
; CHECK-NEXT:    zip1 z17.b, z24.b, z25.b
; CHECK-NEXT:    zip1 z2.h, z3.h, z2.h
; CHECK-NEXT:    zip1 z3.h, z5.h, z4.h
; CHECK-NEXT:    zip1 z4.h, z7.h, z6.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    zip1 z5.h, z17.h, z16.h
; CHECK-NEXT:    zip1 z2.s, z3.s, z2.s
; CHECK-NEXT:    zip1 z3.s, z5.s, z4.s
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip1_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [x1, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [x1]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldr q1, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load volatile <32 x i8>, ptr %a
  %tmp2 = load volatile <32 x i8>, ptr %b
  %tmp3 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 0, i32 32, i32 1, i32 33, i32 2, i32 34, i32 3, i32 35, i32 4, i32 36, i32 5, i32 37, i32 6, i32 38, i32 7, i32 39, i32 8, i32 40, i32 9, i32 41, i32 10, i32 42, i32 11, i32 43, i32 12, i32 44, i32 13, i32 45, i32 14, i32 46, i32 15, i32 47>
  store volatile <32 x i8> %tmp3, ptr %a
  ret void
}

define void @zip_v32i16(ptr %a, ptr %b) {
; CHECK-LABEL: zip_v32i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp d15, d14, [sp, #-64]! // 16-byte Folded Spill
; CHECK-NEXT:    stp d13, d12, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    stp d11, d10, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NEXT:    .cfi_offset b8, -8
; CHECK-NEXT:    .cfi_offset b9, -16
; CHECK-NEXT:    .cfi_offset b10, -24
; CHECK-NEXT:    .cfi_offset b11, -32
; CHECK-NEXT:    .cfi_offset b12, -40
; CHECK-NEXT:    .cfi_offset b13, -48
; CHECK-NEXT:    .cfi_offset b14, -56
; CHECK-NEXT:    .cfi_offset b15, -64
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ldp q2, q3, [x1]
; CHECK-NEXT:    mov z5.h, z1.h[7]
; CHECK-NEXT:    mov z7.h, z1.h[6]
; CHECK-NEXT:    mov z17.h, z1.h[5]
; CHECK-NEXT:    mov z4.h, z3.h[7]
; CHECK-NEXT:    mov z6.h, z3.h[6]
; CHECK-NEXT:    mov z16.h, z3.h[5]
; CHECK-NEXT:    mov z20.h, z2.h[7]
; CHECK-NEXT:    mov z21.h, z0.h[7]
; CHECK-NEXT:    mov z18.h, z3.h[4]
; CHECK-NEXT:    mov z19.h, z1.h[4]
; CHECK-NEXT:    mov z22.h, z2.h[6]
; CHECK-NEXT:    mov z23.h, z0.h[6]
; CHECK-NEXT:    zip1 z24.h, z5.h, z4.h
; CHECK-NEXT:    zip1 z25.h, z7.h, z6.h
; CHECK-NEXT:    zip1 z17.h, z17.h, z16.h
; CHECK-NEXT:    ldp q4, q6, [x0, #32]
; CHECK-NEXT:    zip1 z16.h, z21.h, z20.h
; CHECK-NEXT:    ldp q5, q7, [x1, #32]
; CHECK-NEXT:    zip1 z18.h, z19.h, z18.h
; CHECK-NEXT:    zip1 z19.s, z25.s, z24.s
; CHECK-NEXT:    zip1 z22.h, z23.h, z22.h
; CHECK-NEXT:    mov z23.h, z2.h[5]
; CHECK-NEXT:    mov z21.h, z6.h[7]
; CHECK-NEXT:    mov z24.h, z0.h[5]
; CHECK-NEXT:    mov z25.h, z2.h[4]
; CHECK-NEXT:    mov z20.h, z7.h[7]
; CHECK-NEXT:    mov z26.h, z0.h[4]
; CHECK-NEXT:    mov z27.h, z6.h[6]
; CHECK-NEXT:    mov z28.h, z7.h[5]
; CHECK-NEXT:    mov z29.h, z6.h[5]
; CHECK-NEXT:    mov z30.h, z7.h[4]
; CHECK-NEXT:    mov z31.h, z6.h[4]
; CHECK-NEXT:    mov z8.h, z5.h[7]
; CHECK-NEXT:    mov z9.h, z4.h[7]
; CHECK-NEXT:    zip1 z20.h, z21.h, z20.h
; CHECK-NEXT:    mov z21.h, z7.h[6]
; CHECK-NEXT:    mov z10.h, z5.h[6]
; CHECK-NEXT:    mov z11.h, z4.h[6]
; CHECK-NEXT:    mov z12.h, z5.h[5]
; CHECK-NEXT:    mov z13.h, z4.h[5]
; CHECK-NEXT:    mov z14.h, z5.h[4]
; CHECK-NEXT:    mov z15.h, z4.h[4]
; CHECK-NEXT:    zip1 z23.h, z24.h, z23.h
; CHECK-NEXT:    zip1 z21.h, z27.h, z21.h
; CHECK-NEXT:    zip1 z27.h, z29.h, z28.h
; CHECK-NEXT:    zip1 z28.h, z31.h, z30.h
; CHECK-NEXT:    zip1 z24.h, z26.h, z25.h
; CHECK-NEXT:    zip1 z25.h, z9.h, z8.h
; CHECK-NEXT:    zip1 z26.h, z11.h, z10.h
; CHECK-NEXT:    ldp d9, d8, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    zip1 z29.h, z13.h, z12.h
; CHECK-NEXT:    ldp d11, d10, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    zip1 z30.h, z15.h, z14.h
; CHECK-NEXT:    ldp d13, d12, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    zip1 z17.s, z18.s, z17.s
; CHECK-NEXT:    zip1 z18.s, z21.s, z20.s
; CHECK-NEXT:    zip1 z20.s, z28.s, z27.s
; CHECK-NEXT:    zip1 z16.s, z22.s, z16.s
; CHECK-NEXT:    zip1 z21.s, z24.s, z23.s
; CHECK-NEXT:    zip1 z1.h, z1.h, z3.h
; CHECK-NEXT:    zip1 z3.s, z26.s, z25.s
; CHECK-NEXT:    zip1 z22.s, z30.s, z29.s
; CHECK-NEXT:    zip1 z6.h, z6.h, z7.h
; CHECK-NEXT:    zip1 z7.d, z17.d, z19.d
; CHECK-NEXT:    zip1 z17.d, z20.d, z18.d
; CHECK-NEXT:    zip1 z0.h, z0.h, z2.h
; CHECK-NEXT:    zip1 z2.h, z4.h, z5.h
; CHECK-NEXT:    zip1 z4.d, z21.d, z16.d
; CHECK-NEXT:    zip1 z3.d, z22.d, z3.d
; CHECK-NEXT:    add z1.h, z1.h, z6.h
; CHECK-NEXT:    add z5.h, z7.h, z17.h
; CHECK-NEXT:    add z0.h, z0.h, z2.h
; CHECK-NEXT:    add z2.h, z4.h, z3.h
; CHECK-NEXT:    stp q1, q5, [x0, #32]
; CHECK-NEXT:    stp q0, q2, [x0]
; CHECK-NEXT:    ldp d15, d14, [sp], #64 // 16-byte Folded Reload
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip_v32i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #192
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 192
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1, #32]
; NONEON-NOSVE-NEXT:    ldp q3, q2, [x0]
; NONEON-NOSVE-NEXT:    ldp q5, q4, [x1]
; NONEON-NOSVE-NEXT:    ldp q7, q6, [x0, #32]
; NONEON-NOSVE-NEXT:    stp q3, q5, [sp]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #30]
; NONEON-NOSVE-NEXT:    stp q6, q2, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q7, q0, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q4, q1, [sp, #96]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #126]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #190]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #188]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #124]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #186]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #26]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #184]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #122]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #182]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #24]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #180]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #120]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #178]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #22]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #176]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #118]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #174]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #20]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #172]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #116]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #170]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #18]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #168]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #114]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #166]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #164]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #112]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #162]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #110]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #160]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldp q3, q2, [sp, #160]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #62]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #158]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #108]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #156]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #154]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #106]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #152]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #58]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #150]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #104]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #148]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #56]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #146]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #102]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #144]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #54]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #142]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #100]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #140]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #138]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #98]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #136]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #50]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #134]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #96]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #132]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #130]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #128]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #128]
; NONEON-NOSVE-NEXT:    stp q3, q2, [x0]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #192
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <32 x i16>, ptr %a
  %tmp2 = load <32 x i16>, ptr %b
  %tmp3 = shufflevector <32 x i16> %tmp1, <32 x i16> %tmp2, <32 x i32> <i32 0, i32 32, i32 1, i32 33, i32 2, i32 34, i32 3, i32 35, i32 4, i32 36, i32 5, i32 37, i32 6, i32 38, i32 7, i32 39, i32 8, i32 40, i32 9, i32 41, i32 10, i32 42, i32 11, i32 43, i32 12, i32 44, i32 13, i32 45, i32 14, i32 46, i32 15, i32 47>
  %tmp4 = shufflevector <32 x i16> %tmp1, <32 x i16> %tmp2, <32 x i32> <i32 16, i32 48, i32 17, i32 49, i32 18, i32 50, i32 19, i32 51, i32 20, i32 52, i32 21, i32 53, i32 22, i32 54, i32 23, i32 55, i32 24, i32 56, i32 25, i32 57, i32 26, i32 58, i32 27, i32 59, i32 28, i32 60, i32 29, i32 61, i32 30, i32 62, i32 31, i32 63>
  %tmp5 = add <32 x i16> %tmp3, %tmp4
  store <32 x i16> %tmp5, ptr %a
  ret void
}

define void @zip1_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: zip1_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    mov z2.h, z0.h[7]
; CHECK-NEXT:    mov z4.h, z0.h[6]
; CHECK-NEXT:    mov z6.h, z0.h[5]
; CHECK-NEXT:    mov z3.h, z1.h[7]
; CHECK-NEXT:    mov z5.h, z1.h[6]
; CHECK-NEXT:    mov z7.h, z1.h[5]
; CHECK-NEXT:    mov z16.h, z0.h[4]
; CHECK-NEXT:    mov z17.h, z1.h[4]
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    zip1 z2.h, z2.h, z3.h
; CHECK-NEXT:    zip1 z3.h, z4.h, z5.h
; CHECK-NEXT:    zip1 z4.h, z6.h, z7.h
; CHECK-NEXT:    zip1 z5.h, z16.h, z17.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    zip1 z2.s, z3.s, z2.s
; CHECK-NEXT:    zip1 z3.s, z5.s, z4.s
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip1_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [x1, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [x1]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr q1, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load volatile <16 x i16>, ptr %a
  %tmp2 = load volatile <16 x i16>, ptr %b
  %tmp3 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 0, i32 16, i32 1, i32 17, i32 2, i32 18, i32 3, i32 19, i32 4, i32 20, i32 5, i32 21, i32 6, i32 22, i32 7, i32 23>
  store volatile <16 x i16> %tmp3, ptr %a
  ret void
}

define void @zip1_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: zip1_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    mov z2.s, z0.s[3]
; CHECK-NEXT:    mov z4.s, z0.s[2]
; CHECK-NEXT:    mov z3.s, z1.s[3]
; CHECK-NEXT:    mov z5.s, z1.s[2]
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    zip1 z2.s, z2.s, z3.s
; CHECK-NEXT:    zip1 z3.s, z4.s, z5.s
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip1_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q1, [x1, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [x1]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w8, w11, [sp, #32]
; NONEON-NOSVE-NEXT:    stp w9, w11, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w10, w8, [sp]
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldp w8, w11, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr q1, [sp]
; NONEON-NOSVE-NEXT:    stp w9, w11, [sp, #56]
; NONEON-NOSVE-NEXT:    stp w10, w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load volatile <8 x i32>, ptr %a
  %tmp2 = load volatile <8 x i32>, ptr %b
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> %tmp2, <8 x i32> <i32 0, i32 8, i32 1, i32 9, i32 2, i32 10, i32 3, i32 11>
  store volatile <8 x i32> %tmp3, ptr %a
  ret void
}

define void @zip_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: zip_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q3, q2, [x1]
; CHECK-NEXT:    zip1 z4.d, z1.d, z3.d
; CHECK-NEXT:    zip1 z5.d, z0.d, z2.d
; CHECK-NEXT:    trn2 z1.d, z1.d, z3.d
; CHECK-NEXT:    trn2 z0.d, z0.d, z2.d
; CHECK-NEXT:    movprfx z2, z4
; CHECK-NEXT:    fadd z2.d, p0/m, z2.d, z5.d
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    stp q2, q0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp]
; NONEON-NOSVE-NEXT:    stp q3, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr d1, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #56]
; NONEON-NOSVE-NEXT:    fadd d2, d1, d0
; NONEON-NOSVE-NEXT:    ldp d3, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    fadd d0, d3, d0
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #48]
; NONEON-NOSVE-NEXT:    fadd d2, d1, d0
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr d1, [sp]
; NONEON-NOSVE-NEXT:    fadd d0, d1, d0
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp q1, q0, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <4 x double>, ptr %a
  %tmp2 = load <4 x double>, ptr %b
  %tmp3 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %tmp4 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %tmp5 = fadd <4 x double> %tmp3, %tmp4
  store <4 x double> %tmp5, ptr %a
  ret void
}

define void @zip_v4i32(ptr %a, ptr %b) {
; CHECK-LABEL: zip_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x1]
; CHECK-NEXT:    ldr q1, [x0]
; CHECK-NEXT:    mov z2.s, z0.s[3]
; CHECK-NEXT:    mov z3.s, z1.s[3]
; CHECK-NEXT:    mov z4.s, z0.s[2]
; CHECK-NEXT:    mov z5.s, z1.s[2]
; CHECK-NEXT:    zip1 z0.s, z1.s, z0.s
; CHECK-NEXT:    zip1 z2.s, z3.s, z2.s
; CHECK-NEXT:    zip1 z3.s, z5.s, z4.s
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    add z0.s, z0.s, z1.s
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x1]
; NONEON-NOSVE-NEXT:    ldr q1, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #20]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #4]
; NONEON-NOSVE-NEXT:    str w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #12]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldr w9, [sp, #16]
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldr w9, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #8]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <4 x i32>, ptr %a
  %tmp2 = load <4 x i32>, ptr %b
  %tmp3 = shufflevector <4 x i32> %tmp1, <4 x i32> %tmp2, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %tmp4 = shufflevector <4 x i32> %tmp1, <4 x i32> %tmp2, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %tmp5 = add <4 x i32> %tmp3, %tmp4
  store <4 x i32> %tmp5, ptr %a
  ret void
}

define void @zip1_v8i32_undef(ptr %a) {
; CHECK-LABEL: zip1_v8i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI6_0
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI6_0]
; CHECK-NEXT:    tbl z1.s, { z0.s }, z1.s
; CHECK-NEXT:    zip1 z0.s, z0.s, z0.s
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip1_v8i32_undef:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #48
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp]
; NONEON-NOSVE-NEXT:    ldp w8, w10, [sp, #24]
; NONEON-NOSVE-NEXT:    stp w9, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr q1, [sp]
; NONEON-NOSVE-NEXT:    stp w10, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load  volatile <8 x i32>, ptr %a
  %tmp2 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 1, i32 1, i32 2, i32 2, i32 3, i32 3>
  store volatile <8 x i32> %tmp2, ptr %a
  ret void
}

define void @trn_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    trn1 z4.b, z0.b, z1.b
; CHECK-NEXT:    trn2 z0.b, z0.b, z1.b
; CHECK-NEXT:    trn1 z1.b, z2.b, z3.b
; CHECK-NEXT:    trn2 z2.b, z2.b, z3.b
; CHECK-NEXT:    add z0.b, z4.b, z0.b
; CHECK-NEXT:    add z1.b, z1.b, z2.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: trn_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #62]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #95]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #60]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #93]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #58]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #91]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #56]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #89]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #54]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #87]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #52]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #85]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #50]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #48]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #30]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #28]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #26]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #24]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #20]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #18]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #67]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <32 x i8>, ptr %a
  %tmp2 = load <32 x i8>, ptr %b
  %tmp3 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 0, i32 32, i32 2, i32 34, i32 4, i32 36, i32 6, i32 38, i32 8, i32 40, i32 10, i32 42, i32 12, i32 44, i32 14, i32 46, i32 16, i32 48, i32 18, i32 50, i32 20, i32 52, i32 22, i32 54, i32 24, i32 56, i32 26, i32 58, i32 28, i32 60, i32 30, i32 62>
  %tmp4 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 1, i32 33, i32 3, i32 35, i32 undef, i32 37, i32 7, i32 undef, i32 undef, i32 41, i32 11, i32 43, i32 13, i32 45, i32 15, i32 47, i32 17, i32 49, i32 19, i32 51, i32 21, i32 53, i32 23, i32 55, i32 25, i32 57, i32 27, i32 59, i32 29, i32 61, i32 31, i32 63>
  %tmp5 = add <32 x i8> %tmp3, %tmp4
  store <32 x i8> %tmp5, ptr %a
  ret void
}

define void @trn_v8i16(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI8_0
; CHECK-NEXT:    adrp x9, .LCPI8_1
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI8_0]
; CHECK-NEXT:    ldr q2, [x9, :lo12:.LCPI8_1]
; CHECK-NEXT:    tbl z1.h, { z0.h }, z1.h
; CHECK-NEXT:    tbl z0.h, { z0.h }, z2.h
; CHECK-NEXT:    add z0.h, z1.h, z0.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: trn_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    str q0, [sp, #-32]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w12, [sp, #4]
; NONEON-NOSVE-NEXT:    add w10, w9, w8
; NONEON-NOSVE-NEXT:    strh w10, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #8]
; NONEON-NOSVE-NEXT:    add w10, w11, w10
; NONEON-NOSVE-NEXT:    strh w10, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w10, [sp, #12]
; NONEON-NOSVE-NEXT:    add w11, w10, w11
; NONEON-NOSVE-NEXT:    add w8, w8, w10
; NONEON-NOSVE-NEXT:    strh w11, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w11, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    add w11, w12, w11
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    strh w11, [sp, #20]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #16]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <8 x i16>, ptr %a
  %tmp2 = load <8 x i16>, ptr %b
  %tmp3 = shufflevector <8 x i16> %tmp1, <8 x i16> %tmp2, <8 x i32> <i32 0, i32 7, i32 2, i32 6, i32 4, i32 5, i32 1, i32 3>
  %tmp4 = shufflevector <8 x i16> %tmp1, <8 x i16> %tmp2, <8 x i32> <i32 1, i32 6, i32 3, i32 5, i32 undef, i32 4, i32 7, i32 undef>
  %tmp5 = add <8 x i16> %tmp3, %tmp4
  store <8 x i16> %tmp5, ptr %a
  ret void
}

define void @trn_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    trn1 z4.h, z0.h, z1.h
; CHECK-NEXT:    trn2 z0.h, z0.h, z1.h
; CHECK-NEXT:    trn1 z1.h, z2.h, z3.h
; CHECK-NEXT:    trn2 z2.h, z2.h, z3.h
; CHECK-NEXT:    add z0.h, z4.h, z0.h
; CHECK-NEXT:    add z1.h, z1.h, z2.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: trn_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #56]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #24]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #20]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <16 x i16>, ptr %a
  %tmp2 = load <16 x i16>, ptr %b
  %tmp3 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 0, i32 16, i32 2, i32 18, i32 4, i32 20, i32 6, i32 22, i32 8, i32 24, i32 10, i32 26, i32 12, i32 28, i32 14, i32 30>
  %tmp4 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 1, i32 17, i32 3, i32 19, i32 5, i32 21, i32 7, i32 23, i32 9, i32 25, i32 11, i32 27, i32 13, i32 29, i32 15, i32 31>
  %tmp5 = add <16 x i16> %tmp3, %tmp4
  store <16 x i16> %tmp5, ptr %a
  ret void
}

define void @trn_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    zip1 z4.s, z0.s, z1.s
; CHECK-NEXT:    trn2 z0.s, z0.s, z1.s
; CHECK-NEXT:    trn1 z1.s, z2.s, z3.s
; CHECK-NEXT:    trn2 z2.s, z2.s, z3.s
; CHECK-NEXT:    add z0.s, z4.s, z0.s
; CHECK-NEXT:    add z1.s, z1.s, z2.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: trn_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #80
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 80
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    ldr q0, [x1, #16]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #48]
; NONEON-NOSVE-NEXT:    str q2, [sp, #16]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #32]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [sp, #64]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp]
; NONEON-NOSVE-NEXT:    ldr q0, [sp]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #80
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <8 x i32>, ptr %a
  %tmp2 = load <8 x i32>, ptr %b
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> %tmp2, <8 x i32> <i32 0, i32 8, i32 undef, i32 undef, i32 4, i32 12, i32 6, i32 14>
  %tmp4 = shufflevector <8 x i32> %tmp1, <8 x i32> %tmp2, <8 x i32> <i32 1, i32 undef, i32 3, i32 11, i32 5, i32 13, i32 undef, i32 undef>
  %tmp5 = add <8 x i32> %tmp3, %tmp4
  store <8 x i32> %tmp5, ptr %a
  ret void
}

define void @trn_v4f64(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q3, [x1]
; CHECK-NEXT:    zip1 z4.d, z0.d, z1.d
; CHECK-NEXT:    trn2 z0.d, z0.d, z1.d
; CHECK-NEXT:    zip1 z1.d, z2.d, z3.d
; CHECK-NEXT:    trn2 z2.d, z2.d, z3.d
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z4.d
; CHECK-NEXT:    fadd z1.d, p0/m, z1.d, z2.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: trn_v4f64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #48]
; NONEON-NOSVE-NEXT:    fadd d2, d1, d0
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #32]
; NONEON-NOSVE-NEXT:    fadd d0, d1, d0
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp, #16]
; NONEON-NOSVE-NEXT:    fadd d2, d1, d0
; NONEON-NOSVE-NEXT:    ldp d1, d0, [sp]
; NONEON-NOSVE-NEXT:    fadd d0, d1, d0
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <4 x double>, ptr %a
  %tmp2 = load <4 x double>, ptr %b
  %tmp3 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %tmp4 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %tmp5 = fadd <4 x double> %tmp3, %tmp4
  store <4 x double> %tmp5, ptr %a
  ret void
}

define void @trn_v4f32(ptr %a, ptr %b) {
; CHECK-LABEL: trn_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    trn1 z2.s, z0.s, z1.s
; CHECK-NEXT:    trn2 z0.s, z0.s, z1.s
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z2.s
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: trn_v4f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x1]
; NONEON-NOSVE-NEXT:    ldr q1, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #24]
; NONEON-NOSVE-NEXT:    fadd s2, s1, s0
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #8]
; NONEON-NOSVE-NEXT:    fadd s0, s1, s0
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #16]
; NONEON-NOSVE-NEXT:    fadd s2, s1, s0
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp]
; NONEON-NOSVE-NEXT:    fadd s0, s1, s0
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <4 x float>, ptr %a
  %tmp2 = load <4 x float>, ptr %b
  %tmp3 = shufflevector <4 x float> %tmp1, <4 x float> %tmp2, <4 x i32> <i32 0, i32 4, i32 2, i32 6>
  %tmp4 = shufflevector <4 x float> %tmp1, <4 x float> %tmp2, <4 x i32> <i32 1, i32 5, i32 3, i32 7>
  %tmp5 = fadd <4 x float> %tmp3, %tmp4
  store <4 x float> %tmp5, ptr %a
  ret void
}

define void @trn_v8i32_undef(ptr %a) {
; CHECK-LABEL: trn_v8i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    trn1 z2.s, z0.s, z0.s
; CHECK-NEXT:    trn2 z0.s, z0.s, z0.s
; CHECK-NEXT:    trn1 z3.s, z1.s, z1.s
; CHECK-NEXT:    trn2 z1.s, z1.s, z1.s
; CHECK-NEXT:    add z0.s, z2.s, z0.s
; CHECK-NEXT:    add z1.s, z3.s, z1.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: trn_v8i32_undef:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-64]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #24]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <8 x i32>, ptr %a
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 0, i32 0, i32 2, i32 2, i32 4, i32 4, i32 6, i32 6>
  %tmp4 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 1, i32 1, i32 3, i32 3, i32 5, i32 5, i32 7, i32 7>
  %tmp5 = add <8 x i32> %tmp3, %tmp4
  store <8 x i32> %tmp5, ptr %a
  ret void
}

define void @zip2_v32i8(ptr %a, ptr %b) #0{
; CHECK-LABEL: zip2_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    mov z2.b, z0.b[15]
; CHECK-NEXT:    mov z4.b, z0.b[14]
; CHECK-NEXT:    mov z6.b, z0.b[13]
; CHECK-NEXT:    mov z3.b, z1.b[15]
; CHECK-NEXT:    mov z5.b, z1.b[14]
; CHECK-NEXT:    mov z7.b, z1.b[13]
; CHECK-NEXT:    mov z16.b, z0.b[12]
; CHECK-NEXT:    mov z17.b, z1.b[12]
; CHECK-NEXT:    mov z18.b, z0.b[11]
; CHECK-NEXT:    mov z19.b, z1.b[11]
; CHECK-NEXT:    mov z20.b, z0.b[10]
; CHECK-NEXT:    mov z21.b, z1.b[10]
; CHECK-NEXT:    mov z22.b, z0.b[9]
; CHECK-NEXT:    mov z23.b, z1.b[9]
; CHECK-NEXT:    mov z24.b, z0.b[8]
; CHECK-NEXT:    mov z25.b, z1.b[8]
; CHECK-NEXT:    zip1 z2.b, z2.b, z3.b
; CHECK-NEXT:    zip1 z3.b, z4.b, z5.b
; CHECK-NEXT:    zip1 z4.b, z6.b, z7.b
; CHECK-NEXT:    zip1 z5.b, z16.b, z17.b
; CHECK-NEXT:    zip1 z6.b, z18.b, z19.b
; CHECK-NEXT:    zip1 z7.b, z20.b, z21.b
; CHECK-NEXT:    zip1 z16.b, z22.b, z23.b
; CHECK-NEXT:    zip1 z0.b, z0.b, z1.b
; CHECK-NEXT:    zip1 z17.b, z24.b, z25.b
; CHECK-NEXT:    zip1 z2.h, z3.h, z2.h
; CHECK-NEXT:    zip1 z3.h, z5.h, z4.h
; CHECK-NEXT:    zip1 z4.h, z7.h, z6.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    zip1 z5.h, z17.h, z16.h
; CHECK-NEXT:    zip1 z2.s, z3.s, z2.s
; CHECK-NEXT:    zip1 z3.s, z5.s, z4.s
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip2_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [x1]
; NONEON-NOSVE-NEXT:    ldr q1, [x1, #16]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #15]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #7]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldr q1, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load volatile <32 x i8>, ptr %a
  %tmp2 = load volatile <32 x i8>, ptr %b
  %tmp3 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 16, i32 48, i32 17, i32 49, i32 18, i32 50, i32 19, i32 51, i32 20, i32 52, i32 21, i32 53, i32 22, i32 54, i32 23, i32 55, i32 24, i32 56, i32 25, i32 57, i32 26, i32 58, i32 27, i32 59, i32 28, i32 60, i32 29, i32 61, i32 30, i32 62, i32 31, i32 63>
  store volatile <32 x i8> %tmp3, ptr %a
  ret void
}

define void @zip2_v16i16(ptr %a, ptr %b) #0{
; CHECK-LABEL: zip2_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    mov z2.h, z0.h[7]
; CHECK-NEXT:    mov z4.h, z0.h[6]
; CHECK-NEXT:    mov z6.h, z0.h[5]
; CHECK-NEXT:    mov z3.h, z1.h[7]
; CHECK-NEXT:    mov z5.h, z1.h[6]
; CHECK-NEXT:    mov z7.h, z1.h[5]
; CHECK-NEXT:    mov z16.h, z0.h[4]
; CHECK-NEXT:    mov z17.h, z1.h[4]
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    zip1 z2.h, z2.h, z3.h
; CHECK-NEXT:    zip1 z3.h, z4.h, z5.h
; CHECK-NEXT:    zip1 z4.h, z6.h, z7.h
; CHECK-NEXT:    zip1 z5.h, z16.h, z17.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    zip1 z2.s, z3.s, z2.s
; CHECK-NEXT:    zip1 z3.s, z5.s, z4.s
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip2_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [x1]
; NONEON-NOSVE-NEXT:    ldr q1, [x1, #16]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldr q1, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load volatile <16 x i16>, ptr %a
  %tmp2 = load volatile <16 x i16>, ptr %b
  %tmp3 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 8, i32 24, i32 9, i32 25, i32 10, i32 26, i32 11, i32 27, i32 12, i32 28, i32 13, i32 29, i32 14, i32 30, i32 15, i32 31>
  store volatile <16 x i16> %tmp3, ptr %a
  ret void
}

define void @zip2_v8i32(ptr %a, ptr %b) #0{
; CHECK-LABEL: zip2_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q1, [x1]
; CHECK-NEXT:    ldr q1, [x1, #16]
; CHECK-NEXT:    mov z2.s, z0.s[3]
; CHECK-NEXT:    mov z4.s, z0.s[2]
; CHECK-NEXT:    mov z3.s, z1.s[3]
; CHECK-NEXT:    mov z5.s, z1.s[2]
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    zip1 z2.s, z2.s, z3.s
; CHECK-NEXT:    zip1 z3.s, z4.s, z5.s
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip2_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #64
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 64
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    ldr q1, [x1]
; NONEON-NOSVE-NEXT:    ldr q1, [x1, #16]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w8, w11, [sp, #32]
; NONEON-NOSVE-NEXT:    stp w9, w11, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w10, w8, [sp]
; NONEON-NOSVE-NEXT:    ldp w10, w9, [sp, #24]
; NONEON-NOSVE-NEXT:    ldp w8, w11, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr q1, [sp]
; NONEON-NOSVE-NEXT:    stp w9, w11, [sp, #56]
; NONEON-NOSVE-NEXT:    stp w10, w8, [sp, #48]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #48]
; NONEON-NOSVE-NEXT:    str q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #64
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load volatile <8 x i32>, ptr %a
  %tmp2 = load volatile <8 x i32>, ptr %b
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> %tmp2, <8 x i32> <i32 4, i32 12, i32 5, i32 13, i32 6, i32 14, i32 7, i32 15>
  store volatile <8 x i32> %tmp3, ptr %a
  ret void
}

define void @zip2_v8i32_undef(ptr %a) #0{
; CHECK-LABEL: zip2_v8i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI17_0
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ldr q0, [x0, #16]
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI17_0]
; CHECK-NEXT:    tbl z1.s, { z0.s }, z1.s
; CHECK-NEXT:    zip1 z0.s, z0.s, z0.s
; CHECK-NEXT:    str q1, [x0, #16]
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip2_v8i32_undef:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #48
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldr q0, [x0]
; NONEON-NOSVE-NEXT:    ldr q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q0, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp w8, w9, [sp, #16]
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp]
; NONEON-NOSVE-NEXT:    ldp w8, w10, [sp, #24]
; NONEON-NOSVE-NEXT:    stp w9, w9, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr q1, [sp]
; NONEON-NOSVE-NEXT:    stp w10, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    stp w8, w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [x0, #16]
; NONEON-NOSVE-NEXT:    str q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load volatile <8 x i32>, ptr %a
  %tmp2 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 4, i32 4, i32 5, i32 5, i32 6, i32 6, i32 7, i32 7>
  store volatile <8 x i32> %tmp2, ptr %a
  ret void
}

define void @uzp_v32i8(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp d13, d12, [sp, #-48]! // 16-byte Folded Spill
; CHECK-NEXT:    stp d11, d10, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    stp d9, d8, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 48
; CHECK-NEXT:    .cfi_offset b8, -8
; CHECK-NEXT:    .cfi_offset b9, -16
; CHECK-NEXT:    .cfi_offset b10, -24
; CHECK-NEXT:    .cfi_offset b11, -32
; CHECK-NEXT:    .cfi_offset b12, -40
; CHECK-NEXT:    .cfi_offset b13, -48
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov z2.b, z1.b[14]
; CHECK-NEXT:    mov z3.b, z1.b[12]
; CHECK-NEXT:    mov z4.b, z1.b[10]
; CHECK-NEXT:    mov z5.b, z1.b[8]
; CHECK-NEXT:    mov z6.b, z1.b[6]
; CHECK-NEXT:    mov z7.b, z1.b[4]
; CHECK-NEXT:    mov z16.b, z1.b[2]
; CHECK-NEXT:    mov z18.b, z0.b[14]
; CHECK-NEXT:    mov z19.b, z0.b[12]
; CHECK-NEXT:    zip1 z3.b, z3.b, z2.b
; CHECK-NEXT:    ldp q2, q17, [x1]
; CHECK-NEXT:    mov z20.b, z0.b[10]
; CHECK-NEXT:    zip1 z4.b, z5.b, z4.b
; CHECK-NEXT:    zip1 z5.b, z7.b, z6.b
; CHECK-NEXT:    zip1 z6.b, z1.b, z16.b
; CHECK-NEXT:    mov z7.b, z0.b[8]
; CHECK-NEXT:    mov z16.b, z0.b[6]
; CHECK-NEXT:    mov z21.b, z0.b[4]
; CHECK-NEXT:    mov z22.b, z0.b[2]
; CHECK-NEXT:    mov z23.b, z17.b[14]
; CHECK-NEXT:    mov z24.b, z17.b[12]
; CHECK-NEXT:    mov z25.b, z17.b[10]
; CHECK-NEXT:    mov z26.b, z17.b[8]
; CHECK-NEXT:    mov z27.b, z17.b[6]
; CHECK-NEXT:    mov z28.b, z17.b[4]
; CHECK-NEXT:    mov z29.b, z17.b[2]
; CHECK-NEXT:    zip1 z18.b, z19.b, z18.b
; CHECK-NEXT:    zip1 z7.b, z7.b, z20.b
; CHECK-NEXT:    zip1 z16.b, z21.b, z16.b
; CHECK-NEXT:    zip1 z19.b, z0.b, z22.b
; CHECK-NEXT:    zip1 z20.b, z24.b, z23.b
; CHECK-NEXT:    zip1 z21.b, z26.b, z25.b
; CHECK-NEXT:    zip1 z22.b, z28.b, z27.b
; CHECK-NEXT:    mov z24.b, z2.b[14]
; CHECK-NEXT:    mov z25.b, z2.b[12]
; CHECK-NEXT:    mov z26.b, z2.b[10]
; CHECK-NEXT:    mov z27.b, z2.b[8]
; CHECK-NEXT:    zip1 z23.b, z17.b, z29.b
; CHECK-NEXT:    zip1 z3.h, z4.h, z3.h
; CHECK-NEXT:    zip1 z4.h, z6.h, z5.h
; CHECK-NEXT:    zip1 z5.h, z7.h, z18.h
; CHECK-NEXT:    zip1 z6.h, z19.h, z16.h
; CHECK-NEXT:    zip1 z7.h, z21.h, z20.h
; CHECK-NEXT:    zip1 z18.b, z25.b, z24.b
; CHECK-NEXT:    zip1 z19.b, z27.b, z26.b
; CHECK-NEXT:    mov z20.b, z2.b[6]
; CHECK-NEXT:    mov z21.b, z2.b[4]
; CHECK-NEXT:    mov z29.b, z17.b[3]
; CHECK-NEXT:    mov z30.b, z17.b[1]
; CHECK-NEXT:    mov z31.b, z2.b[15]
; CHECK-NEXT:    mov z8.b, z2.b[13]
; CHECK-NEXT:    zip1 z16.h, z23.h, z22.h
; CHECK-NEXT:    mov z22.b, z2.b[2]
; CHECK-NEXT:    mov z23.b, z17.b[15]
; CHECK-NEXT:    mov z24.b, z17.b[13]
; CHECK-NEXT:    mov z25.b, z17.b[11]
; CHECK-NEXT:    mov z26.b, z17.b[9]
; CHECK-NEXT:    mov z27.b, z17.b[7]
; CHECK-NEXT:    mov z28.b, z17.b[5]
; CHECK-NEXT:    zip1 z17.h, z19.h, z18.h
; CHECK-NEXT:    zip1 z21.b, z21.b, z20.b
; CHECK-NEXT:    zip1 z19.b, z30.b, z29.b
; CHECK-NEXT:    zip1 z20.b, z8.b, z31.b
; CHECK-NEXT:    mov z29.b, z1.b[15]
; CHECK-NEXT:    mov z30.b, z1.b[13]
; CHECK-NEXT:    mov z31.b, z1.b[11]
; CHECK-NEXT:    mov z8.b, z1.b[9]
; CHECK-NEXT:    zip1 z22.b, z2.b, z22.b
; CHECK-NEXT:    zip1 z23.b, z24.b, z23.b
; CHECK-NEXT:    zip1 z24.b, z26.b, z25.b
; CHECK-NEXT:    zip1 z18.b, z28.b, z27.b
; CHECK-NEXT:    mov z25.b, z2.b[11]
; CHECK-NEXT:    mov z26.b, z2.b[9]
; CHECK-NEXT:    mov z27.b, z2.b[7]
; CHECK-NEXT:    mov z28.b, z2.b[5]
; CHECK-NEXT:    mov z9.b, z1.b[7]
; CHECK-NEXT:    mov z10.b, z1.b[5]
; CHECK-NEXT:    mov z1.b, z1.b[3]
; CHECK-NEXT:    mov z11.b, z0.b[11]
; CHECK-NEXT:    mov z12.b, z0.b[9]
; CHECK-NEXT:    zip1 z29.b, z30.b, z29.b
; CHECK-NEXT:    mov z30.b, z0.b[3]
; CHECK-NEXT:    mov z13.b, z0.b[1]
; CHECK-NEXT:    zip1 z31.b, z8.b, z31.b
; CHECK-NEXT:    mov z8.b, z2.b[3]
; CHECK-NEXT:    mov z2.b, z2.b[1]
; CHECK-NEXT:    zip1 z9.b, z10.b, z9.b
; CHECK-NEXT:    zip1 z10.b, z12.b, z11.b
; CHECK-NEXT:    zip1 z1.b, z0.b, z1.b
; CHECK-NEXT:    zip1 z30.b, z13.b, z30.b
; CHECK-NEXT:    mov z11.b, z0.b[13]
; CHECK-NEXT:    mov z0.b, z0.b[5]
; CHECK-NEXT:    zip1 z25.b, z26.b, z25.b
; CHECK-NEXT:    zip1 z26.b, z28.b, z27.b
; CHECK-NEXT:    zip1 z2.b, z2.b, z8.b
; CHECK-NEXT:    zip1 z21.h, z22.h, z21.h
; CHECK-NEXT:    zip1 z22.h, z24.h, z23.h
; CHECK-NEXT:    zip1 z23.h, z31.h, z29.h
; CHECK-NEXT:    zip1 z1.h, z1.h, z9.h
; CHECK-NEXT:    ldp d9, d8, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    zip1 z24.h, z10.h, z11.h
; CHECK-NEXT:    ldp d11, d10, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    zip1 z0.h, z30.h, z0.h
; CHECK-NEXT:    zip1 z18.h, z19.h, z18.h
; CHECK-NEXT:    zip1 z19.h, z25.h, z20.h
; CHECK-NEXT:    zip1 z2.h, z2.h, z26.h
; CHECK-NEXT:    zip1 z3.s, z4.s, z3.s
; CHECK-NEXT:    zip1 z4.s, z6.s, z5.s
; CHECK-NEXT:    zip1 z5.s, z16.s, z7.s
; CHECK-NEXT:    zip1 z1.s, z1.s, z23.s
; CHECK-NEXT:    zip1 z6.s, z21.s, z17.s
; CHECK-NEXT:    zip1 z0.s, z0.s, z24.s
; CHECK-NEXT:    zip1 z7.s, z18.s, z22.s
; CHECK-NEXT:    zip1 z2.s, z2.s, z19.s
; CHECK-NEXT:    zip1 z3.d, z4.d, z3.d
; CHECK-NEXT:    zip1 z0.d, z0.d, z1.d
; CHECK-NEXT:    zip1 z1.d, z6.d, z5.d
; CHECK-NEXT:    zip1 z2.d, z2.d, z7.d
; CHECK-NEXT:    add z0.b, z3.b, z0.b
; CHECK-NEXT:    add z1.b, z1.b, z2.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ldp d13, d12, [sp], #48 // 16-byte Folded Reload
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uzp_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp]
; NONEON-NOSVE-NEXT:    stp q3, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #62]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #60]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #95]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #58]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #56]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #93]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #54]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #52]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #91]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #50]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #48]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #89]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #30]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #28]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #87]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #26]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #24]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #85]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #22]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #20]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #18]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #16]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #13]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #11]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #9]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #5]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #3]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #1]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    strb w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <32 x i8>, ptr %a
  %tmp2 = load <32 x i8>, ptr %b
  %tmp3 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62>
  %tmp4 = shufflevector <32 x i8> %tmp1, <32 x i8> %tmp2, <32 x i32> <i32 1, i32 3, i32 5, i32 undef, i32 9, i32 11, i32 13, i32 undef, i32 undef, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63>
  %tmp5 = add <32 x i8> %tmp3, %tmp4
  store <32 x i8> %tmp5, ptr %a
  ret void
}

define void @uzp_v4i16(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI19_0
; CHECK-NEXT:    adrp x9, .LCPI19_1
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI19_0]
; CHECK-NEXT:    ldr q2, [x9, :lo12:.LCPI19_1]
; CHECK-NEXT:    tbl z1.h, { z0.h }, z1.h
; CHECK-NEXT:    tbl z0.h, { z0.h }, z2.h
; CHECK-NEXT:    add z0.h, z1.h, z0.h
; CHECK-NEXT:    str d0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uzp_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr d0, [x0]
; NONEON-NOSVE-NEXT:    str d0, [sp, #-16]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #4]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    add w8, w8, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #12]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp]
; NONEON-NOSVE-NEXT:    add w9, w9, w8
; NONEON-NOSVE-NEXT:    strh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    add w8, w8, w9
; NONEON-NOSVE-NEXT:    strh w8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    str d0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <4 x i16>, ptr %a
  %tmp2 = load <4 x i16>, ptr %b
  %tmp3 = shufflevector <4 x i16> %tmp1, <4 x i16> %tmp2, <4 x i32> <i32 0, i32 3, i32 2, i32 1>
  %tmp4 = shufflevector <4 x i16> %tmp1, <4 x i16> %tmp2, <4 x i32> <i32 1, i32 0, i32 2, i32 undef>
  %tmp5 = add <4 x i16> %tmp3, %tmp4
  store <4 x i16> %tmp5, ptr %a
  ret void
}

define void @uzp_v16i16(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str d8, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset b8, -16
; CHECK-NEXT:    ldp q1, q6, [x0]
; CHECK-NEXT:    ldp q0, q2, [x1]
; CHECK-NEXT:    mov z3.h, z6.h[6]
; CHECK-NEXT:    mov z4.h, z6.h[4]
; CHECK-NEXT:    mov z5.h, z6.h[2]
; CHECK-NEXT:    mov z7.h, z1.h[6]
; CHECK-NEXT:    mov z16.h, z1.h[4]
; CHECK-NEXT:    mov z17.h, z1.h[2]
; CHECK-NEXT:    mov z18.h, z2.h[6]
; CHECK-NEXT:    mov z19.h, z2.h[4]
; CHECK-NEXT:    mov z20.h, z2.h[2]
; CHECK-NEXT:    mov z21.h, z0.h[6]
; CHECK-NEXT:    mov z22.h, z0.h[4]
; CHECK-NEXT:    zip1 z3.h, z4.h, z3.h
; CHECK-NEXT:    zip1 z4.h, z6.h, z5.h
; CHECK-NEXT:    zip1 z5.h, z16.h, z7.h
; CHECK-NEXT:    zip1 z7.h, z1.h, z17.h
; CHECK-NEXT:    zip1 z16.h, z19.h, z18.h
; CHECK-NEXT:    zip1 z18.h, z2.h, z20.h
; CHECK-NEXT:    mov z19.h, z0.h[2]
; CHECK-NEXT:    zip1 z17.h, z22.h, z21.h
; CHECK-NEXT:    mov z20.h, z6.h[7]
; CHECK-NEXT:    mov z21.h, z6.h[5]
; CHECK-NEXT:    mov z22.h, z6.h[3]
; CHECK-NEXT:    mov z6.h, z6.h[1]
; CHECK-NEXT:    mov z23.h, z1.h[7]
; CHECK-NEXT:    mov z24.h, z1.h[5]
; CHECK-NEXT:    mov z25.h, z1.h[3]
; CHECK-NEXT:    mov z1.h, z1.h[1]
; CHECK-NEXT:    mov z26.h, z2.h[7]
; CHECK-NEXT:    mov z27.h, z2.h[5]
; CHECK-NEXT:    mov z28.h, z2.h[3]
; CHECK-NEXT:    mov z2.h, z2.h[1]
; CHECK-NEXT:    mov z29.h, z0.h[7]
; CHECK-NEXT:    mov z30.h, z0.h[5]
; CHECK-NEXT:    mov z31.h, z0.h[3]
; CHECK-NEXT:    mov z8.h, z0.h[1]
; CHECK-NEXT:    zip1 z0.h, z0.h, z19.h
; CHECK-NEXT:    zip1 z19.h, z21.h, z20.h
; CHECK-NEXT:    zip1 z6.h, z6.h, z22.h
; CHECK-NEXT:    zip1 z20.h, z24.h, z23.h
; CHECK-NEXT:    zip1 z1.h, z1.h, z25.h
; CHECK-NEXT:    zip1 z21.h, z27.h, z26.h
; CHECK-NEXT:    zip1 z2.h, z2.h, z28.h
; CHECK-NEXT:    zip1 z22.h, z30.h, z29.h
; CHECK-NEXT:    zip1 z23.h, z8.h, z31.h
; CHECK-NEXT:    zip1 z3.s, z4.s, z3.s
; CHECK-NEXT:    zip1 z4.s, z7.s, z5.s
; CHECK-NEXT:    zip1 z5.s, z18.s, z16.s
; CHECK-NEXT:    zip1 z6.s, z6.s, z19.s
; CHECK-NEXT:    zip1 z1.s, z1.s, z20.s
; CHECK-NEXT:    zip1 z0.s, z0.s, z17.s
; CHECK-NEXT:    zip1 z2.s, z2.s, z21.s
; CHECK-NEXT:    zip1 z7.s, z23.s, z22.s
; CHECK-NEXT:    zip1 z3.d, z4.d, z3.d
; CHECK-NEXT:    zip1 z1.d, z1.d, z6.d
; CHECK-NEXT:    zip1 z0.d, z0.d, z5.d
; CHECK-NEXT:    zip1 z2.d, z7.d, z2.d
; CHECK-NEXT:    add z1.h, z3.h, z1.h
; CHECK-NEXT:    add z0.h, z0.h, z2.h
; CHECK-NEXT:    stp q1, q0, [x0]
; CHECK-NEXT:    ldr d8, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uzp_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp]
; NONEON-NOSVE-NEXT:    stp q3, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #60]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #56]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #52]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #48]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #24]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #20]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <16 x i16>, ptr %a
  %tmp2 = load <16 x i16>, ptr %b
  %tmp3 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %tmp4 = shufflevector <16 x i16> %tmp1, <16 x i16> %tmp2, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %tmp5 = add <16 x i16> %tmp3, %tmp4
  store <16 x i16> %tmp5, ptr %a
  ret void
}

define void @uzp_v8f32(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q6, q0, [x0]
; CHECK-NEXT:    adrp x8, .LCPI21_0
; CHECK-NEXT:    ldp q1, q2, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    mov z3.s, z0.s[2]
; CHECK-NEXT:    mov z4.s, z0.s[3]
; CHECK-NEXT:    mov z5.s, z0.s[1]
; CHECK-NEXT:    mov z7.s, z2.s[2]
; CHECK-NEXT:    mov z16.s, z1.s[2]
; CHECK-NEXT:    zip1 z0.s, z0.s, z3.s
; CHECK-NEXT:    zip1 z3.s, z5.s, z4.s
; CHECK-NEXT:    mov z4.s, z6.s[1]
; CHECK-NEXT:    zip1 z2.s, z2.s, z7.s
; CHECK-NEXT:    ldr q5, [x8, :lo12:.LCPI21_0]
; CHECK-NEXT:    zip1 z7.s, z0.s, z16.s
; CHECK-NEXT:    tbl z1.s, { z1.s }, z5.s
; CHECK-NEXT:    zip1 z0.d, z6.d, z0.d
; CHECK-NEXT:    zip1 z3.d, z4.d, z3.d
; CHECK-NEXT:    zip1 z2.d, z7.d, z2.d
; CHECK-NEXT:    fadd z0.s, p0/m, z0.s, z3.s
; CHECK-NEXT:    fadd z1.s, p0/m, z1.s, z2.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uzp_v8f32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #80
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 80
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    mov x8, #9205357640488583168 // =0x7fc000007fc00000
; NONEON-NOSVE-NEXT:    ldr q0, [x1]
; NONEON-NOSVE-NEXT:    str x8, [sp, #56]
; NONEON-NOSVE-NEXT:    mov w8, #2143289344 // =0x7fc00000
; NONEON-NOSVE-NEXT:    str w8, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #16]
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #24]
; NONEON-NOSVE-NEXT:    str q2, [sp]
; NONEON-NOSVE-NEXT:    str w8, [sp, #68]
; NONEON-NOSVE-NEXT:    fadd s0, s1, s0
; NONEON-NOSVE-NEXT:    str s0, [sp, #52]
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #40]
; NONEON-NOSVE-NEXT:    fadd s2, s1, s0
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp, #32]
; NONEON-NOSVE-NEXT:    fadd s0, s1, s0
; NONEON-NOSVE-NEXT:    stp s0, s2, [sp, #72]
; NONEON-NOSVE-NEXT:    ldp s1, s0, [sp]
; NONEON-NOSVE-NEXT:    fadd s0, s1, s0
; NONEON-NOSVE-NEXT:    str s0, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q1, q0, [sp, #48]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #80
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <8 x float>, ptr %a
  %tmp2 = load <8 x float>, ptr %b
  %tmp3 = shufflevector <8 x float> %tmp1, <8 x float> %tmp2, <8 x i32> <i32 0, i32 undef, i32 4, i32 6, i32 undef, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x float> %tmp1, <8 x float> %tmp2, <8 x i32> <i32 1, i32 undef, i32 5, i32 7, i32 9, i32 11, i32 undef, i32 undef>
  %tmp5 = fadd <8 x float> %tmp3, %tmp4
  store <8 x float> %tmp5, ptr %a
  ret void
}

define void @uzp_v4i64(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ldp q3, q2, [x1]
; CHECK-NEXT:    zip1 z4.d, z1.d, z0.d
; CHECK-NEXT:    trn2 z0.d, z1.d, z0.d
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    trn2 z2.d, z3.d, z2.d
; CHECK-NEXT:    add z0.d, z4.d, z0.d
; CHECK-NEXT:    add z1.d, z1.d, z2.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uzp_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp]
; NONEON-NOSVE-NEXT:    stp q3, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp, #48]
; NONEON-NOSVE-NEXT:    add x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp, #16]
; NONEON-NOSVE-NEXT:    add x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp, #32]
; NONEON-NOSVE-NEXT:    add x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldp x9, x8, [sp]
; NONEON-NOSVE-NEXT:    add x8, x9, x8
; NONEON-NOSVE-NEXT:    str x8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <4 x i64>, ptr %a
  %tmp2 = load <4 x i64>, ptr %b
  %tmp3 = shufflevector <4 x i64> %tmp1, <4 x i64> %tmp2, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %tmp4 = shufflevector <4 x i64> %tmp1, <4 x i64> %tmp2, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %tmp5 = add <4 x i64> %tmp3, %tmp4
  store <4 x i64> %tmp5, ptr %a
  ret void
}

define void @uzp_v8i16(ptr %a, ptr %b) #0{
; CHECK-LABEL: uzp_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x1]
; CHECK-NEXT:    ldr q1, [x0]
; CHECK-NEXT:    mov z2.h, z0.h[6]
; CHECK-NEXT:    mov z3.h, z0.h[4]
; CHECK-NEXT:    mov z4.h, z0.h[2]
; CHECK-NEXT:    mov z5.h, z1.h[6]
; CHECK-NEXT:    mov z6.h, z1.h[4]
; CHECK-NEXT:    mov z7.h, z1.h[2]
; CHECK-NEXT:    mov z16.h, z0.h[7]
; CHECK-NEXT:    mov z17.h, z0.h[5]
; CHECK-NEXT:    mov z18.h, z0.h[3]
; CHECK-NEXT:    mov z19.h, z0.h[1]
; CHECK-NEXT:    mov z20.h, z1.h[7]
; CHECK-NEXT:    mov z21.h, z1.h[5]
; CHECK-NEXT:    mov z22.h, z1.h[3]
; CHECK-NEXT:    mov z23.h, z1.h[1]
; CHECK-NEXT:    zip1 z2.h, z3.h, z2.h
; CHECK-NEXT:    zip1 z0.h, z0.h, z4.h
; CHECK-NEXT:    zip1 z3.h, z6.h, z5.h
; CHECK-NEXT:    zip1 z1.h, z1.h, z7.h
; CHECK-NEXT:    zip1 z4.h, z17.h, z16.h
; CHECK-NEXT:    zip1 z5.h, z19.h, z18.h
; CHECK-NEXT:    zip1 z6.h, z21.h, z20.h
; CHECK-NEXT:    zip1 z7.h, z23.h, z22.h
; CHECK-NEXT:    zip1 z0.s, z0.s, z2.s
; CHECK-NEXT:    zip1 z1.s, z1.s, z3.s
; CHECK-NEXT:    zip1 z2.s, z5.s, z4.s
; CHECK-NEXT:    zip1 z3.s, z7.s, z6.s
; CHECK-NEXT:    zip1 z0.d, z1.d, z0.d
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    add z0.h, z0.h, z1.h
; CHECK-NEXT:    str q0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uzp_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldr q0, [x1]
; NONEON-NOSVE-NEXT:    ldr q1, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #28]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #24]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #20]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #16]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #14]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #10]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #6]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #2]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    str q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <8 x i16>, ptr %a
  %tmp2 = load <8 x i16>, ptr %b
  %tmp3 = shufflevector <8 x i16> %tmp1, <8 x i16> %tmp2, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %tmp4 = shufflevector <8 x i16> %tmp1, <8 x i16> %tmp2, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %tmp5 = add <8 x i16> %tmp3, %tmp4
  store <8 x i16> %tmp5, ptr %a
  ret void
}

define void @uzp_v8i32_undef(ptr %a) #0{
; CHECK-LABEL: uzp_v8i32_undef:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov z2.s, z1.s[2]
; CHECK-NEXT:    mov z3.s, z0.s[2]
; CHECK-NEXT:    mov z4.s, z1.s[3]
; CHECK-NEXT:    mov z5.s, z1.s[1]
; CHECK-NEXT:    mov z6.s, z0.s[3]
; CHECK-NEXT:    mov z7.s, z0.s[1]
; CHECK-NEXT:    zip1 z1.s, z1.s, z2.s
; CHECK-NEXT:    zip1 z0.s, z0.s, z3.s
; CHECK-NEXT:    zip1 z2.s, z5.s, z4.s
; CHECK-NEXT:    zip1 z3.s, z7.s, z6.s
; CHECK-NEXT:    zip1 z0.d, z0.d, z1.d
; CHECK-NEXT:    zip1 z1.d, z3.d, z2.d
; CHECK-NEXT:    add z0.s, z0.s, z1.s
; CHECK-NEXT:    stp q0, q0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: uzp_v8i32_undef:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x0]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #24]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #16]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp, #8]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldp w9, w8, [sp]
; NONEON-NOSVE-NEXT:    add w8, w9, w8
; NONEON-NOSVE-NEXT:    str w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    stp q0, q0, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <8 x i32>, ptr %a
  %tmp3 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 0, i32 2, i32 4, i32 6>
  %tmp4 = shufflevector <8 x i32> %tmp1, <8 x i32> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 1, i32 3, i32 5, i32 7>
  %tmp5 = add <8 x i32> %tmp3, %tmp4
  store <8 x i32> %tmp5, ptr %a
  ret void
}

define void @zip_vscale2_4(ptr %a, ptr %b) {
; CHECK-LABEL: zip_vscale2_4:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q3, q2, [x1]
; CHECK-NEXT:    zip1 z4.d, z1.d, z3.d
; CHECK-NEXT:    zip1 z5.d, z0.d, z2.d
; CHECK-NEXT:    trn2 z1.d, z1.d, z3.d
; CHECK-NEXT:    trn2 z0.d, z0.d, z2.d
; CHECK-NEXT:    movprfx z2, z4
; CHECK-NEXT:    fadd z2.d, p0/m, z2.d, z5.d
; CHECK-NEXT:    fadd z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    stp q2, q0, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: zip_vscale2_4:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q1, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q3, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q1, [sp]
; NONEON-NOSVE-NEXT:    stp q3, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr d1, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #56]
; NONEON-NOSVE-NEXT:    fadd d2, d1, d0
; NONEON-NOSVE-NEXT:    ldp d3, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #40]
; NONEON-NOSVE-NEXT:    fadd d0, d3, d0
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #64]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #48]
; NONEON-NOSVE-NEXT:    fadd d2, d1, d0
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr d1, [sp]
; NONEON-NOSVE-NEXT:    fadd d0, d1, d0
; NONEON-NOSVE-NEXT:    stp d0, d2, [sp, #80]
; NONEON-NOSVE-NEXT:    ldp q1, q0, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %tmp1 = load <4 x double>, ptr %a
  %tmp2 = load <4 x double>, ptr %b
  %tmp3 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 0, i32 4, i32 1, i32 5>
  %tmp4 = shufflevector <4 x double> %tmp1, <4 x double> %tmp2, <4 x i32> <i32 2, i32 6, i32 3, i32 7>
  %tmp5 = fadd <4 x double> %tmp3, %tmp4
  store <4 x double> %tmp5, ptr %a
  ret void
}
