; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown --mattr=+avx,+no-bypass-delay-shuffle  | FileCheck %s --check-prefixes=CHECK,CHECK-AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown --mattr=+avx  | FileCheck %s --check-prefixes=CHECK,CHECK-AVX1-DELAY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown --mattr=+avx2,+no-bypass-delay-shuffle  | FileCheck %s --check-prefixes=CHECK,CHECK-AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown --mattr=+avx2  | FileCheck %s --check-prefixes=CHECK,CHECK-AVX2-DELAY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=icelake-server  | FileCheck %s --check-prefixes=CHECK,CHECK-ICX,CHECK-ICX-NO-BYPASS-DELAY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=icelake-server -mattr=-no-bypass-delay-shuffle | FileCheck %s --check-prefixes=CHECK,CHECK-ICX,CHECK-ICX-BYPASS-DELAY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=sandybridge -mattr=+no-bypass-delay-shuffle | FileCheck %s --check-prefixes=CHECK,CHECK-SNB,CHECK-SNB-NO-BYPASS-DELAY
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=sandybridge -mattr=-no-bypass-delay-shuffle | FileCheck %s --check-prefixes=CHECK,CHECK-SNB,CHECK-SNB-BYPASS-DELAY

define <4 x double> @transform_VPERMILPDYrr(<4 x double> %a) nounwind {
; CHECK-LABEL: transform_VPERMILPDYrr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshufpd {{.*#+}} ymm0 = ymm0[1,0,2,3]
; CHECK-NEXT:    retq
  %shufp = shufflevector <4 x double> %a, <4 x double> poison, <4 x i32> <i32 1, i32 0, i32 2, i32 3>
  ret <4 x double> %shufp
}

define <2 x double> @transform_VPERMILPDrr(<2 x double> %a) nounwind {
; CHECK-LABEL: transform_VPERMILPDrr:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; CHECK-NEXT:    retq
  %shufp = shufflevector <2 x double> %a, <2 x double> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x double> %shufp
}

define <4 x double> @transform_VPERMILPDYrm(ptr %ap) nounwind {
; CHECK-LABEL: transform_VPERMILPDYrm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermilpd {{.*#+}} ymm0 = mem[0,1,3,2]
; CHECK-NEXT:    retq
  %a = load <4 x double>, ptr %ap
  %shufp = shufflevector <4 x double> %a, <4 x double> poison, <4 x i32> <i32 0, i32 1, i32 3, i32 2>
  ret <4 x double> %shufp
}

define <2 x double> @transform_VPERMILPDrm(ptr %ap) nounwind {
; CHECK-LABEL: transform_VPERMILPDrm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpermilpd {{.*#+}} xmm0 = mem[1,0]
; CHECK-NEXT:    retq
  %a = load <2 x double>, ptr %ap
  %shufp = shufflevector <2 x double> %a, <2 x double> poison, <2 x i32> <i32 1, i32 0>
  ret <2 x double> %shufp
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK-AVX1: {{.*}}
; CHECK-AVX1-DELAY: {{.*}}
; CHECK-AVX2: {{.*}}
; CHECK-AVX2-DELAY: {{.*}}
; CHECK-ICX: {{.*}}
; CHECK-ICX-BYPASS-DELAY: {{.*}}
; CHECK-ICX-NO-BYPASS-DELAY: {{.*}}
; CHECK-SNB: {{.*}}
; CHECK-SNB-BYPASS-DELAY: {{.*}}
; CHECK-SNB-NO-BYPASS-DELAY: {{.*}}
