; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefixes=GISEL-GFX11,GISEL-GFX11-TRUE16 %s
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefixes=GISEL-GFX11,GISEL-GFX11-FAKE16 %s
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefixes=GISEL-GFX11,GISEL-GFX11-TRUE16 %s
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefixes=GISEL-GFX11,GISEL-GFX11-FAKE16 %s
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=GISEL-GFX10 %s
; RUN: llc -global-isel=1 -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=GISEL-GFX10 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefixes=DAGISEL-GFX11-WF32,DAGISEL-GFX11-WF32-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefixes=DAGISEL-GFX11-WF32,DAGISEL-GFX11-WF32-FAKE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefixes=DAGISEL-GFX11-WF64,DAGISEL-GFX11-WF64-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefixes=DAGISEL-GFX11-WF64,DAGISEL-GFX11-WF64-FAKE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize32 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=DAGISEL-GFX10-WF32 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1030 -mattr=+wavefrontsize64 -stop-after=finalize-isel -verify-machineinstrs < %s | FileCheck -check-prefix=DAGISEL-GFX10-WF64 %s

; We only care about which physical registers the parameters are copied from;
; the function bodies are just some arbitrary uses.

define amdgpu_cs_chain_preserve void @amdgpu_cs_chain_preserve_cc(<4 x i32> inreg %a, <4 x i32> %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_preserve_cc
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX11-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   [[V_ADD_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY8]], [[COPY4]], 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   [[V_ADD_U32_e64_1:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY9]], [[COPY5]], 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; GISEL-GFX11-NEXT:   [[V_ADD_U32_e64_2:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY10]], [[COPY6]], 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; GISEL-GFX11-NEXT:   [[V_ADD_U32_e64_3:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY11]], [[COPY7]], 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_ADD_U32_e64_]], %subreg.sub0, [[V_ADD_U32_e64_1]], %subreg.sub1, [[V_ADD_U32_e64_2]], %subreg.sub2, [[V_ADD_U32_e64_3]], %subreg.sub3
  ; GISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   FLAT_STORE_DWORDX4 [[COPY12]], [[REG_SEQUENCE]], 0, 0, implicit $exec, implicit $flat_scr :: (store (<4 x s32>) into `ptr poison`)
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_preserve_cc
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX10-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   [[V_ADD_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY8]], [[COPY4]], 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   [[V_ADD_U32_e64_1:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY9]], [[COPY5]], 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   [[V_ADD_U32_e64_2:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY10]], [[COPY6]], 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; GISEL-GFX10-NEXT:   [[V_ADD_U32_e64_3:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY11]], [[COPY7]], 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_ADD_U32_e64_]], %subreg.sub0, [[V_ADD_U32_e64_1]], %subreg.sub1, [[V_ADD_U32_e64_2]], %subreg.sub2, [[V_ADD_U32_e64_3]], %subreg.sub3
  ; GISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   FLAT_STORE_DWORDX4 [[COPY12]], [[REG_SEQUENCE]], 0, 0, implicit $exec, implicit $flat_scr :: (store (<4 x s32>) into `ptr poison`)
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc
  ; DAGISEL-GFX11-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; DAGISEL-GFX11-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY4:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_ADD_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY4]], [[COPY]], 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_ADD_U32_e64_1:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY5]], [[COPY1]], 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_ADD_U32_e64_2:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY6]], [[COPY2]], 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_ADD_U32_e64_3:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY7]], [[COPY3]], 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_ADD_U32_e64_3]], %subreg.sub0, [[V_ADD_U32_e64_2]], %subreg.sub1, [[V_ADD_U32_e64_1]], %subreg.sub2, [[V_ADD_U32_e64_]], %subreg.sub3
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF4:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY8:%[0-9]+]]:vreg_64 = COPY [[DEF4]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY9:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX11-WF32-NEXT:   FLAT_STORE_DWORDX4 killed [[COPY8]], killed [[COPY9]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison`)
  ; DAGISEL-GFX11-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc
  ; DAGISEL-GFX11-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; DAGISEL-GFX11-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY4:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_ADD_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY4]], [[COPY]], 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_ADD_U32_e64_1:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY5]], [[COPY1]], 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_ADD_U32_e64_2:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY6]], [[COPY2]], 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_ADD_U32_e64_3:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY7]], [[COPY3]], 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_ADD_U32_e64_3]], %subreg.sub0, [[V_ADD_U32_e64_2]], %subreg.sub1, [[V_ADD_U32_e64_1]], %subreg.sub2, [[V_ADD_U32_e64_]], %subreg.sub3
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF4:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY8:%[0-9]+]]:vreg_64 = COPY [[DEF4]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY9:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX11-WF64-NEXT:   FLAT_STORE_DWORDX4 killed [[COPY8]], killed [[COPY9]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison`)
  ; DAGISEL-GFX11-WF64-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc
  ; DAGISEL-GFX10-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF32-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; DAGISEL-GFX10-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY4:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_ADD_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY4]], [[COPY]], 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_ADD_U32_e64_1:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY5]], [[COPY1]], 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_ADD_U32_e64_2:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY6]], [[COPY2]], 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_ADD_U32_e64_3:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY7]], [[COPY3]], 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_ADD_U32_e64_3]], %subreg.sub0, [[V_ADD_U32_e64_2]], %subreg.sub1, [[V_ADD_U32_e64_1]], %subreg.sub2, [[V_ADD_U32_e64_]], %subreg.sub3
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF4:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY8:%[0-9]+]]:vreg_64 = COPY [[DEF4]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY9:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX10-WF32-NEXT:   FLAT_STORE_DWORDX4 killed [[COPY8]], killed [[COPY9]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison`)
  ; DAGISEL-GFX10-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc
  ; DAGISEL-GFX10-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF64-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $vgpr8, $vgpr9, $vgpr10, $vgpr11
  ; DAGISEL-GFX10-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY4:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY5:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_ADD_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY4]], [[COPY]], 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_ADD_U32_e64_1:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY5]], [[COPY1]], 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_ADD_U32_e64_2:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY6]], [[COPY2]], 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_ADD_U32_e64_3:%[0-9]+]]:vgpr_32 = V_ADD_U32_e64 [[COPY7]], [[COPY3]], 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_ADD_U32_e64_3]], %subreg.sub0, [[V_ADD_U32_e64_2]], %subreg.sub1, [[V_ADD_U32_e64_1]], %subreg.sub2, [[V_ADD_U32_e64_]], %subreg.sub3
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF4:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY8:%[0-9]+]]:vreg_64 = COPY [[DEF4]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY9:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX10-WF64-NEXT:   FLAT_STORE_DWORDX4 killed [[COPY8]], killed [[COPY9]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison`)
  ; DAGISEL-GFX10-WF64-NEXT:   S_ENDPGM 0
  %c = add <4 x i32> %a, %b
  store <4 x i32> %c, ptr poison
  ret void
}

define amdgpu_cs_chain_preserve void @amdgpu_cs_chain_preserve_cc_ptr(ptr inreg %a, ptr %b, ptr addrspace(1) inreg %a1, ptr addrspace(1) %b1, ptr addrspace(3) inreg %a3, ptr addrspace(3) %b3, ptr addrspace(5) inreg %a5, ptr addrspace(5) %b5) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_preserve_cc_ptr
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY2]], %subreg.sub0, [[COPY3]], %subreg.sub1
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[COPY4]], %subreg.sub0, [[COPY5]], %subreg.sub1
  ; GISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY6]], %subreg.sub0, [[COPY7]], %subreg.sub1
  ; GISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]]
  ; GISEL-GFX11-NEXT:   FLAT_STORE_DWORDX2 [[REG_SEQUENCE1]], [[COPY12]], 0, 0, implicit $exec, implicit $flat_scr :: (store (p0) into %ir.b)
  ; GISEL-GFX11-NEXT:   [[COPY13:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE2]]
  ; GISEL-GFX11-NEXT:   GLOBAL_STORE_DWORDX2 [[REG_SEQUENCE3]], [[COPY13]], 0, 0, implicit $exec :: (store (p1) into %ir.b1, addrspace 1)
  ; GISEL-GFX11-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GISEL-GFX11-NEXT:   DS_WRITE_B32_gfx9 [[COPY9]], [[COPY14]], 0, 0, implicit $exec :: (store (p3) into %ir.b3, addrspace 3)
  ; GISEL-GFX11-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; GISEL-GFX11-NEXT:   SCRATCH_STORE_DWORD [[COPY15]], [[COPY11]], 0, 0, implicit $exec, implicit $flat_scr :: (store (p5) into %ir.b5, addrspace 5)
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_preserve_cc_ptr
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY2]], %subreg.sub0, [[COPY3]], %subreg.sub1
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[COPY4]], %subreg.sub0, [[COPY5]], %subreg.sub1
  ; GISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY6]], %subreg.sub0, [[COPY7]], %subreg.sub1
  ; GISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]]
  ; GISEL-GFX10-NEXT:   FLAT_STORE_DWORDX2 [[REG_SEQUENCE1]], [[COPY12]], 0, 0, implicit $exec, implicit $flat_scr :: (store (p0) into %ir.b)
  ; GISEL-GFX10-NEXT:   [[COPY13:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE2]]
  ; GISEL-GFX10-NEXT:   GLOBAL_STORE_DWORDX2 [[REG_SEQUENCE3]], [[COPY13]], 0, 0, implicit $exec :: (store (p1) into %ir.b1, addrspace 1)
  ; GISEL-GFX10-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; GISEL-GFX10-NEXT:   DS_WRITE_B32_gfx9 [[COPY9]], [[COPY14]], 0, 0, implicit $exec :: (store (p3) into %ir.b3, addrspace 3)
  ; GISEL-GFX10-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; GISEL-GFX10-NEXT:   BUFFER_STORE_DWORD_OFFEN [[COPY15]], [[COPY11]], $sgpr48_sgpr49_sgpr50_sgpr51, 0, 0, 0, 0, implicit $exec :: (store (p5) into %ir.b5, addrspace 5)
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_ptr
  ; DAGISEL-GFX11-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-NEXT:   liveins: $sgpr0, $sgpr1, $vgpr8, $vgpr9, $sgpr2, $sgpr3, $vgpr10, $vgpr11, $sgpr4, $vgpr12, $sgpr5, $vgpr13
  ; DAGISEL-GFX11-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY12]], %subreg.sub0, [[COPY13]], %subreg.sub1
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY5]], %subreg.sub0, [[COPY4]], %subreg.sub1
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY14]], %subreg.sub0, [[COPY15]], %subreg.sub1
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY9]], %subreg.sub0, [[COPY8]], %subreg.sub1
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY16:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE3]]
  ; DAGISEL-GFX11-WF32-NEXT:   FLAT_STORE_DWORDX2 killed [[COPY16]], killed [[REG_SEQUENCE2]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s64) into %ir.b)
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY17:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE1]]
  ; DAGISEL-GFX11-WF32-NEXT:   GLOBAL_STORE_DWORDX2 killed [[COPY17]], killed [[REG_SEQUENCE]], 0, 0, implicit $exec :: (store (s64) into %ir.b1, addrspace 1)
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; DAGISEL-GFX11-WF32-NEXT:   DS_WRITE_B32_gfx9 [[COPY2]], [[COPY18]], 0, 0, implicit $exec :: (store (s32) into %ir.b3, addrspace 3)
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY1]]
  ; DAGISEL-GFX11-WF32-NEXT:   SCRATCH_STORE_DWORD [[COPY19]], [[COPY]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into %ir.b5, addrspace 5)
  ; DAGISEL-GFX11-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_ptr
  ; DAGISEL-GFX11-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-NEXT:   liveins: $sgpr0, $sgpr1, $vgpr8, $vgpr9, $sgpr2, $sgpr3, $vgpr10, $vgpr11, $sgpr4, $vgpr12, $sgpr5, $vgpr13
  ; DAGISEL-GFX11-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY12]], %subreg.sub0, [[COPY13]], %subreg.sub1
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY5]], %subreg.sub0, [[COPY4]], %subreg.sub1
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY14]], %subreg.sub0, [[COPY15]], %subreg.sub1
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY9]], %subreg.sub0, [[COPY8]], %subreg.sub1
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY16:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE3]]
  ; DAGISEL-GFX11-WF64-NEXT:   FLAT_STORE_DWORDX2 killed [[COPY16]], killed [[REG_SEQUENCE2]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s64) into %ir.b)
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY17:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE1]]
  ; DAGISEL-GFX11-WF64-NEXT:   GLOBAL_STORE_DWORDX2 killed [[COPY17]], killed [[REG_SEQUENCE]], 0, 0, implicit $exec :: (store (s64) into %ir.b1, addrspace 1)
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; DAGISEL-GFX11-WF64-NEXT:   DS_WRITE_B32_gfx9 [[COPY2]], [[COPY18]], 0, 0, implicit $exec :: (store (s32) into %ir.b3, addrspace 3)
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY1]]
  ; DAGISEL-GFX11-WF64-NEXT:   SCRATCH_STORE_DWORD [[COPY19]], [[COPY]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into %ir.b5, addrspace 5)
  ; DAGISEL-GFX11-WF64-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_ptr
  ; DAGISEL-GFX10-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF32-NEXT:   liveins: $sgpr0, $sgpr1, $vgpr8, $vgpr9, $sgpr2, $sgpr3, $vgpr10, $vgpr11, $sgpr4, $vgpr12, $sgpr5, $vgpr13
  ; DAGISEL-GFX10-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY12]], %subreg.sub0, [[COPY13]], %subreg.sub1
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY5]], %subreg.sub0, [[COPY4]], %subreg.sub1
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY14]], %subreg.sub0, [[COPY15]], %subreg.sub1
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY9]], %subreg.sub0, [[COPY8]], %subreg.sub1
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY16:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE3]]
  ; DAGISEL-GFX10-WF32-NEXT:   FLAT_STORE_DWORDX2 killed [[COPY16]], killed [[REG_SEQUENCE2]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s64) into %ir.b)
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY17:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE1]]
  ; DAGISEL-GFX10-WF32-NEXT:   GLOBAL_STORE_DWORDX2 killed [[COPY17]], killed [[REG_SEQUENCE]], 0, 0, implicit $exec :: (store (s64) into %ir.b1, addrspace 1)
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; DAGISEL-GFX10-WF32-NEXT:   DS_WRITE_B32_gfx9 [[COPY2]], [[COPY18]], 0, 0, implicit $exec :: (store (s32) into %ir.b3, addrspace 3)
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY1]]
  ; DAGISEL-GFX10-WF32-NEXT:   BUFFER_STORE_DWORD_OFFEN [[COPY19]], [[COPY]], $sgpr48_sgpr49_sgpr50_sgpr51, 0, 0, 0, 0, implicit $exec :: (store (s32) into %ir.b5, addrspace 5)
  ; DAGISEL-GFX10-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_ptr
  ; DAGISEL-GFX10-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF64-NEXT:   liveins: $sgpr0, $sgpr1, $vgpr8, $vgpr9, $sgpr2, $sgpr3, $vgpr10, $vgpr11, $sgpr4, $vgpr12, $sgpr5, $vgpr13
  ; DAGISEL-GFX10-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY3:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY6:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY12]], %subreg.sub0, [[COPY13]], %subreg.sub1
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY5]], %subreg.sub0, [[COPY4]], %subreg.sub1
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY14]], %subreg.sub0, [[COPY15]], %subreg.sub1
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY9]], %subreg.sub0, [[COPY8]], %subreg.sub1
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY16:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE3]]
  ; DAGISEL-GFX10-WF64-NEXT:   FLAT_STORE_DWORDX2 killed [[COPY16]], killed [[REG_SEQUENCE2]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s64) into %ir.b)
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY17:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE1]]
  ; DAGISEL-GFX10-WF64-NEXT:   GLOBAL_STORE_DWORDX2 killed [[COPY17]], killed [[REG_SEQUENCE]], 0, 0, implicit $exec :: (store (s64) into %ir.b1, addrspace 1)
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; DAGISEL-GFX10-WF64-NEXT:   DS_WRITE_B32_gfx9 [[COPY2]], [[COPY18]], 0, 0, implicit $exec :: (store (s32) into %ir.b3, addrspace 3)
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY1]]
  ; DAGISEL-GFX10-WF64-NEXT:   BUFFER_STORE_DWORD_OFFEN [[COPY19]], [[COPY]], $sgpr48_sgpr49_sgpr50_sgpr51, 0, 0, 0, 0, implicit $exec :: (store (s32) into %ir.b5, addrspace 5)
  ; DAGISEL-GFX10-WF64-NEXT:   S_ENDPGM 0
  store ptr %a, ptr %b
  store ptr addrspace(1) %a1, ptr addrspace(1) %b1
  store ptr addrspace(3) %a3, ptr addrspace(3) %b3
  store ptr addrspace(5) %a5, ptr addrspace(5) %b5
  ret void
}

define amdgpu_cs_chain_preserve void @amdgpu_cs_chain_preserve_cc_struct( {ptr, i32, <4 x i32>} inreg %a, {ptr, i32, <4 x i32>} %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_preserve_cc_struct
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY3]], %subreg.sub0, [[COPY4]], %subreg.sub1, [[COPY5]], %subreg.sub2, [[COPY6]], %subreg.sub3
  ; GISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY7]], %subreg.sub0, [[COPY8]], %subreg.sub1
  ; GISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX11-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY10]], %subreg.sub0, [[COPY11]], %subreg.sub1, [[COPY12]], %subreg.sub2, [[COPY13]], %subreg.sub3
  ; GISEL-GFX11-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX11-NEXT:   [[COPY14:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]]
  ; GISEL-GFX11-NEXT:   [[COPY15:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY15]], [[COPY14]], 0, 0, implicit $exec :: (store (p0) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX11-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; GISEL-GFX11-NEXT:   [[COPY17:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   GLOBAL_STORE_DWORD [[COPY17]], [[COPY16]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX11-NEXT:   [[COPY18:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE1]]
  ; GISEL-GFX11-NEXT:   [[COPY19:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY19]], [[COPY18]], 0, 0, implicit $exec :: (store (<4 x s32>) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX11-NEXT:   [[COPY20:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY20]], [[REG_SEQUENCE2]], 0, 0, implicit $exec :: (store (p0) into `ptr addrspace(1) poison`, align 16, addrspace 1)
  ; GISEL-GFX11-NEXT:   [[COPY21:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   GLOBAL_STORE_DWORD [[COPY21]], [[COPY9]], 8, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison` + 8, align 8, addrspace 1)
  ; GISEL-GFX11-NEXT:   [[COPY22:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY22]], [[REG_SEQUENCE3]], 16, 0, implicit $exec :: (store (<4 x s32>) into `ptr addrspace(1) poison` + 16, addrspace 1)
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_preserve_cc_struct
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:sreg_64 = REG_SEQUENCE [[COPY]], %subreg.sub0, [[COPY1]], %subreg.sub1
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:sgpr_128 = REG_SEQUENCE [[COPY3]], %subreg.sub0, [[COPY4]], %subreg.sub1, [[COPY5]], %subreg.sub2, [[COPY6]], %subreg.sub3
  ; GISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY7]], %subreg.sub0, [[COPY8]], %subreg.sub1
  ; GISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX10-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY10]], %subreg.sub0, [[COPY11]], %subreg.sub1, [[COPY12]], %subreg.sub2, [[COPY13]], %subreg.sub3
  ; GISEL-GFX10-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX10-NEXT:   [[COPY14:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]]
  ; GISEL-GFX10-NEXT:   [[COPY15:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY15]], [[COPY14]], 0, 0, implicit $exec :: (store (p0) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX10-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   [[COPY17:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   GLOBAL_STORE_DWORD [[COPY17]], [[COPY16]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX10-NEXT:   [[COPY18:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE1]]
  ; GISEL-GFX10-NEXT:   [[COPY19:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY19]], [[COPY18]], 0, 0, implicit $exec :: (store (<4 x s32>) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX10-NEXT:   [[COPY20:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY20]], [[REG_SEQUENCE2]], 0, 0, implicit $exec :: (store (p0) into `ptr addrspace(1) poison`, align 16, addrspace 1)
  ; GISEL-GFX10-NEXT:   [[COPY21:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   GLOBAL_STORE_DWORD [[COPY21]], [[COPY9]], 8, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison` + 8, align 8, addrspace 1)
  ; GISEL-GFX10-NEXT:   [[COPY22:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY22]], [[REG_SEQUENCE3]], 16, 0, implicit $exec :: (store (<4 x s32>) into `ptr addrspace(1) poison` + 16, addrspace 1)
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_struct
  ; DAGISEL-GFX11-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; DAGISEL-GFX11-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY3]], %subreg.sub0, [[COPY2]], %subreg.sub1, [[COPY1]], %subreg.sub2, [[COPY]], %subreg.sub3
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY14]], %subreg.sub0, [[COPY15]], %subreg.sub1, [[COPY16]], %subreg.sub2, [[COPY17]], %subreg.sub3
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF4:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF5:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY6]], %subreg.sub0, [[COPY5]], %subreg.sub1
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY13]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY18]], %subreg.sub0, [[COPY19]], %subreg.sub1
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF6:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY20:%[0-9]+]]:vreg_64 = COPY [[DEF6]]
  ; DAGISEL-GFX11-WF32-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY20]], killed [[REG_SEQUENCE3]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF7:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY21:%[0-9]+]]:vreg_64 = COPY [[DEF7]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; DAGISEL-GFX11-WF32-NEXT:   GLOBAL_STORE_DWORD [[COPY21]], [[COPY22]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF8:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY23:%[0-9]+]]:vreg_64 = COPY [[DEF8]]
  ; DAGISEL-GFX11-WF32-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY23]], killed [[REG_SEQUENCE1]], 0, 0, implicit $exec :: (store (s128) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF9:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY24:%[0-9]+]]:vreg_64 = COPY [[DEF9]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY25:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX11-WF32-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY24]], killed [[COPY25]], 0, 0, implicit $exec :: (store (s128) into `ptr addrspace(1) poison` + 16, addrspace 1)
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF10:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY26:%[0-9]+]]:vreg_64 = COPY [[DEF10]]
  ; DAGISEL-GFX11-WF32-NEXT:   GLOBAL_STORE_DWORD [[COPY26]], [[COPY4]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison` + 8, align 8, basealign 16, addrspace 1)
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF11:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY27:%[0-9]+]]:vreg_64 = COPY [[DEF11]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY28:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE2]]
  ; DAGISEL-GFX11-WF32-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY27]], killed [[COPY28]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, align 16, addrspace 1)
  ; DAGISEL-GFX11-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_struct
  ; DAGISEL-GFX11-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; DAGISEL-GFX11-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY3]], %subreg.sub0, [[COPY2]], %subreg.sub1, [[COPY1]], %subreg.sub2, [[COPY]], %subreg.sub3
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY14]], %subreg.sub0, [[COPY15]], %subreg.sub1, [[COPY16]], %subreg.sub2, [[COPY17]], %subreg.sub3
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF4:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF5:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY6]], %subreg.sub0, [[COPY5]], %subreg.sub1
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY13]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY18]], %subreg.sub0, [[COPY19]], %subreg.sub1
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF6:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY20:%[0-9]+]]:vreg_64 = COPY [[DEF6]]
  ; DAGISEL-GFX11-WF64-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY20]], killed [[REG_SEQUENCE3]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF7:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY21:%[0-9]+]]:vreg_64 = COPY [[DEF7]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; DAGISEL-GFX11-WF64-NEXT:   GLOBAL_STORE_DWORD [[COPY21]], [[COPY22]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF8:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY23:%[0-9]+]]:vreg_64 = COPY [[DEF8]]
  ; DAGISEL-GFX11-WF64-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY23]], killed [[REG_SEQUENCE1]], 0, 0, implicit $exec :: (store (s128) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF9:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY24:%[0-9]+]]:vreg_64 = COPY [[DEF9]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY25:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX11-WF64-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY24]], killed [[COPY25]], 0, 0, implicit $exec :: (store (s128) into `ptr addrspace(1) poison` + 16, addrspace 1)
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF10:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY26:%[0-9]+]]:vreg_64 = COPY [[DEF10]]
  ; DAGISEL-GFX11-WF64-NEXT:   GLOBAL_STORE_DWORD [[COPY26]], [[COPY4]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison` + 8, align 8, basealign 16, addrspace 1)
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF11:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY27:%[0-9]+]]:vreg_64 = COPY [[DEF11]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY28:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE2]]
  ; DAGISEL-GFX11-WF64-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY27]], killed [[COPY28]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, align 16, addrspace 1)
  ; DAGISEL-GFX11-WF64-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_struct
  ; DAGISEL-GFX10-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF32-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; DAGISEL-GFX10-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY3]], %subreg.sub0, [[COPY2]], %subreg.sub1, [[COPY1]], %subreg.sub2, [[COPY]], %subreg.sub3
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY14]], %subreg.sub0, [[COPY15]], %subreg.sub1, [[COPY16]], %subreg.sub2, [[COPY17]], %subreg.sub3
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF4:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF5:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY6]], %subreg.sub0, [[COPY5]], %subreg.sub1
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY13]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY18]], %subreg.sub0, [[COPY19]], %subreg.sub1
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF6:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY20:%[0-9]+]]:vreg_64 = COPY [[DEF6]]
  ; DAGISEL-GFX10-WF32-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY20]], killed [[REG_SEQUENCE3]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF7:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY21:%[0-9]+]]:vreg_64 = COPY [[DEF7]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; DAGISEL-GFX10-WF32-NEXT:   GLOBAL_STORE_DWORD [[COPY21]], [[COPY22]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF8:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY23:%[0-9]+]]:vreg_64 = COPY [[DEF8]]
  ; DAGISEL-GFX10-WF32-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY23]], killed [[REG_SEQUENCE1]], 0, 0, implicit $exec :: (store (s128) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF9:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY24:%[0-9]+]]:vreg_64 = COPY [[DEF9]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY25:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX10-WF32-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY24]], killed [[COPY25]], 0, 0, implicit $exec :: (store (s128) into `ptr addrspace(1) poison` + 16, addrspace 1)
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF10:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY26:%[0-9]+]]:vreg_64 = COPY [[DEF10]]
  ; DAGISEL-GFX10-WF32-NEXT:   GLOBAL_STORE_DWORD [[COPY26]], [[COPY4]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison` + 8, align 8, basealign 16, addrspace 1)
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF11:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY27:%[0-9]+]]:vreg_64 = COPY [[DEF11]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY28:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE2]]
  ; DAGISEL-GFX10-WF32-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY27]], killed [[COPY28]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, align 16, addrspace 1)
  ; DAGISEL-GFX10-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_struct
  ; DAGISEL-GFX10-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF64-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14
  ; DAGISEL-GFX10-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY7:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY3]], %subreg.sub0, [[COPY2]], %subreg.sub1, [[COPY1]], %subreg.sub2, [[COPY]], %subreg.sub3
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY [[COPY10]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY [[COPY9]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY8]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[COPY14]], %subreg.sub0, [[COPY15]], %subreg.sub1, [[COPY16]], %subreg.sub2, [[COPY17]], %subreg.sub3
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF4:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF5:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE2:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY6]], %subreg.sub0, [[COPY5]], %subreg.sub1
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY13]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY12]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE3:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY18]], %subreg.sub0, [[COPY19]], %subreg.sub1
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF6:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY20:%[0-9]+]]:vreg_64 = COPY [[DEF6]]
  ; DAGISEL-GFX10-WF64-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY20]], killed [[REG_SEQUENCE3]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF7:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY21:%[0-9]+]]:vreg_64 = COPY [[DEF7]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY [[COPY11]]
  ; DAGISEL-GFX10-WF64-NEXT:   GLOBAL_STORE_DWORD [[COPY21]], [[COPY22]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF8:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY23:%[0-9]+]]:vreg_64 = COPY [[DEF8]]
  ; DAGISEL-GFX10-WF64-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY23]], killed [[REG_SEQUENCE1]], 0, 0, implicit $exec :: (store (s128) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF9:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY24:%[0-9]+]]:vreg_64 = COPY [[DEF9]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY25:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX10-WF64-NEXT:   GLOBAL_STORE_DWORDX4 [[COPY24]], killed [[COPY25]], 0, 0, implicit $exec :: (store (s128) into `ptr addrspace(1) poison` + 16, addrspace 1)
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF10:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY26:%[0-9]+]]:vreg_64 = COPY [[DEF10]]
  ; DAGISEL-GFX10-WF64-NEXT:   GLOBAL_STORE_DWORD [[COPY26]], [[COPY4]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison` + 8, align 8, basealign 16, addrspace 1)
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF11:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY27:%[0-9]+]]:vreg_64 = COPY [[DEF11]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY28:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE2]]
  ; DAGISEL-GFX10-WF64-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY27]], killed [[COPY28]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, align 16, addrspace 1)
  ; DAGISEL-GFX10-WF64-NEXT:   S_ENDPGM 0
  %p = extractvalue {ptr, i32, <4 x i32>} %a, 0
  %i = extractvalue {ptr, i32, <4 x i32>} %a, 1
  %v = extractvalue {ptr, i32, <4 x i32>} %a, 2
  store ptr %p, ptr addrspace(1) poison
  store i32 %i, ptr addrspace(1) poison
  store <4 x i32> %v, ptr addrspace(1) poison

  store {ptr, i32, <4 x i32>} %b, ptr addrspace(1) poison
  ret void
}

define amdgpu_cs_chain_preserve void @amdgpu_cs_chain_preserve_cc_float(float inreg %a, float %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_preserve_cc_float
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, [[COPY2]], 0, [[COPY1]], 0, 0, implicit $mode, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   FLAT_STORE_DWORD [[COPY3]], [[V_ADD_F32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into `ptr poison`)
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_preserve_cc_float
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, [[COPY2]], 0, [[COPY1]], 0, 0, implicit $mode, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   FLAT_STORE_DWORD [[COPY3]], [[V_ADD_F32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into `ptr poison`)
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_float
  ; DAGISEL-GFX11-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF32-NEXT:   FLAT_STORE_DWORD killed [[COPY2]], killed [[V_ADD_F32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into `ptr poison`)
  ; DAGISEL-GFX11-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_float
  ; DAGISEL-GFX11-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF64-NEXT:   FLAT_STORE_DWORD killed [[COPY2]], killed [[V_ADD_F32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into `ptr poison`)
  ; DAGISEL-GFX11-WF64-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_float
  ; DAGISEL-GFX10-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF32-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF32-NEXT:   FLAT_STORE_DWORD killed [[COPY2]], killed [[V_ADD_F32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into `ptr poison`)
  ; DAGISEL-GFX10-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_float
  ; DAGISEL-GFX10-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF64-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF64-NEXT:   FLAT_STORE_DWORD killed [[COPY2]], killed [[V_ADD_F32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s32) into `ptr poison`)
  ; DAGISEL-GFX10-WF64-NEXT:   S_ENDPGM 0
  %c = fadd float %a, %b
  store float %c, ptr poison
  ret void
}

define amdgpu_cs_chain_preserve void @amdgpu_cs_chain_preserve_cc_half(half inreg %a, half %b) {
  ; GISEL-GFX11-TRUE16-LABEL: name: amdgpu_cs_chain_preserve_cc_half
  ; GISEL-GFX11-TRUE16: bb.1 (%ir-block.0):
  ; GISEL-GFX11-TRUE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX11-TRUE16-NEXT: {{  $}}
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY2:%[0-9]+]]:vgpr_16 = COPY [[COPY1]].lo16
  ; GISEL-GFX11-TRUE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY3:%[0-9]+]]:vgpr_16 = COPY [[COPY]]
  ; GISEL-GFX11-TRUE16-NEXT:   [[V_ADD_F16_t16_e64_:%[0-9]+]]:vgpr_16 = nofpexcept V_ADD_F16_t16_e64 0, [[COPY3]], 0, [[COPY2]], 0, 0, 0, implicit $mode, implicit $exec
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-TRUE16-NEXT:   FLAT_STORE_SHORT_t16 [[COPY4]], [[V_ADD_F16_t16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; GISEL-GFX11-TRUE16-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX11-FAKE16-LABEL: name: amdgpu_cs_chain_preserve_cc_half
  ; GISEL-GFX11-FAKE16: bb.1 (%ir-block.0):
  ; GISEL-GFX11-FAKE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX11-FAKE16-NEXT: {{  $}}
  ; GISEL-GFX11-FAKE16-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-FAKE16-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-FAKE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX11-FAKE16-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX11-FAKE16-NEXT:   [[V_ADD_F16_fake16_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F16_fake16_e64 0, [[COPY2]], 0, [[COPY1]], 0, 0, implicit $mode, implicit $exec
  ; GISEL-GFX11-FAKE16-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-FAKE16-NEXT:   FLAT_STORE_SHORT [[COPY3]], [[V_ADD_F16_fake16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; GISEL-GFX11-FAKE16-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_preserve_cc_half
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   [[V_ADD_F16_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F16_e64 0, [[COPY2]], 0, [[COPY1]], 0, 0, implicit $mode, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   FLAT_STORE_SHORT [[COPY3]], [[V_ADD_F16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-TRUE16-LABEL: name: amdgpu_cs_chain_preserve_cc_half
  ; DAGISEL-GFX11-WF32-TRUE16: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[COPY2:%[0-9]+]]:vgpr_16 = COPY [[COPY]]
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[V_ADD_F16_t16_e64_:%[0-9]+]]:vgpr_16 = nofpexcept V_ADD_F16_t16_e64 0, [[COPY1]], 0, [[COPY2]], 0, 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   FLAT_STORE_SHORT_t16 killed [[COPY3]], killed [[V_ADD_F16_t16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-FAKE16-LABEL: name: amdgpu_cs_chain_preserve_cc_half
  ; DAGISEL-GFX11-WF32-FAKE16: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[V_ADD_F16_fake16_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F16_fake16_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   FLAT_STORE_SHORT killed [[COPY2]], killed [[V_ADD_F16_fake16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-TRUE16-LABEL: name: amdgpu_cs_chain_preserve_cc_half
  ; DAGISEL-GFX11-WF64-TRUE16: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[COPY2:%[0-9]+]]:vgpr_16 = COPY [[COPY]]
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[V_ADD_F16_t16_e64_:%[0-9]+]]:vgpr_16 = nofpexcept V_ADD_F16_t16_e64 0, [[COPY1]], 0, [[COPY2]], 0, 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   FLAT_STORE_SHORT_t16 killed [[COPY3]], killed [[V_ADD_F16_t16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-FAKE16-LABEL: name: amdgpu_cs_chain_preserve_cc_half
  ; DAGISEL-GFX11-WF64-FAKE16: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[V_ADD_F16_fake16_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F16_fake16_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   FLAT_STORE_SHORT killed [[COPY2]], killed [[V_ADD_F16_fake16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_half
  ; DAGISEL-GFX10-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF32-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_ADD_F16_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F16_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF32-NEXT:   FLAT_STORE_SHORT killed [[COPY2]], killed [[V_ADD_F16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX10-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_half
  ; DAGISEL-GFX10-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF64-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_ADD_F16_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F16_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF64-NEXT:   FLAT_STORE_SHORT killed [[COPY2]], killed [[V_ADD_F16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX10-WF64-NEXT:   S_ENDPGM 0
  %c = fadd half %a, %b
  store half %c, ptr poison
  ret void
}

define amdgpu_cs_chain_preserve void @amdgpu_cs_chain_cc_bfloat(bfloat inreg %a, bfloat %b) {
  ; DAGISEL-GFX11-WF32-LABEL: name: amdgpu_cs_chain_cc_bfloat
  ; DAGISEL-GFX11-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_LSHLREV_B32_e64_:%[0-9]+]]:vgpr_32 = V_LSHLREV_B32_e64 16, [[COPY]], implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[S_LSHL_B32_:%[0-9]+]]:sreg_32 = S_LSHL_B32 [[COPY1]], 16, implicit-def dead $scc
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, killed [[S_LSHL_B32_]], 0, killed [[V_LSHLREV_B32_e64_]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_BFE_U32_e64_:%[0-9]+]]:vgpr_32 = V_BFE_U32_e64 [[V_ADD_F32_e64_]], 16, 1, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 32767
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_ADD3_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD3_U32_e64 killed [[V_BFE_U32_e64_]], [[V_ADD_F32_e64_]], killed [[S_MOV_B32_]], implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 4194304
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_OR_B32_e64_:%[0-9]+]]:vgpr_32 = V_OR_B32_e64 [[V_ADD_F32_e64_]], killed [[S_MOV_B32_1]], implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_CMP_U_F32_e64_:%[0-9]+]]:sreg_32_xm0_xexec = nofpexcept V_CMP_U_F32_e64 0, [[V_ADD_F32_e64_]], 0, [[V_ADD_F32_e64_]], 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_CNDMASK_B32_e64_:%[0-9]+]]:vgpr_32 = V_CNDMASK_B32_e64 0, killed [[V_ADD3_U32_e64_]], 0, killed [[V_OR_B32_e64_]], killed [[V_CMP_U_F32_e64_]], implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF32-NEXT:   FLAT_STORE_SHORT_D16_HI killed [[COPY2]], killed [[V_CNDMASK_B32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-LABEL: name: amdgpu_cs_chain_cc_bfloat
  ; DAGISEL-GFX11-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_LSHLREV_B32_e64_:%[0-9]+]]:vgpr_32 = V_LSHLREV_B32_e64 16, [[COPY]], implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[S_LSHL_B32_:%[0-9]+]]:sreg_32 = S_LSHL_B32 [[COPY1]], 16, implicit-def dead $scc
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, killed [[S_LSHL_B32_]], 0, killed [[V_LSHLREV_B32_e64_]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_BFE_U32_e64_:%[0-9]+]]:vgpr_32 = V_BFE_U32_e64 [[V_ADD_F32_e64_]], 16, 1, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 32767
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_ADD3_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD3_U32_e64 killed [[V_BFE_U32_e64_]], [[V_ADD_F32_e64_]], killed [[S_MOV_B32_]], implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 4194304
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_OR_B32_e64_:%[0-9]+]]:vgpr_32 = V_OR_B32_e64 [[V_ADD_F32_e64_]], killed [[S_MOV_B32_1]], implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_CMP_U_F32_e64_:%[0-9]+]]:sreg_64_xexec = nofpexcept V_CMP_U_F32_e64 0, [[V_ADD_F32_e64_]], 0, [[V_ADD_F32_e64_]], 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_CNDMASK_B32_e64_:%[0-9]+]]:vgpr_32 = V_CNDMASK_B32_e64 0, killed [[V_ADD3_U32_e64_]], 0, killed [[V_OR_B32_e64_]], killed [[V_CMP_U_F32_e64_]], implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF64-NEXT:   FLAT_STORE_SHORT_D16_HI killed [[COPY2]], killed [[V_CNDMASK_B32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF64-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF32-LABEL: name: amdgpu_cs_chain_cc_bfloat
  ; DAGISEL-GFX10-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF32-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_LSHLREV_B32_e64_:%[0-9]+]]:vgpr_32 = V_LSHLREV_B32_e64 16, [[COPY]], implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[S_LSHL_B32_:%[0-9]+]]:sreg_32 = S_LSHL_B32 [[COPY1]], 16, implicit-def dead $scc
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, killed [[S_LSHL_B32_]], 0, killed [[V_LSHLREV_B32_e64_]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_BFE_U32_e64_:%[0-9]+]]:vgpr_32 = V_BFE_U32_e64 [[V_ADD_F32_e64_]], 16, 1, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 32767
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_ADD3_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD3_U32_e64 killed [[V_BFE_U32_e64_]], [[V_ADD_F32_e64_]], killed [[S_MOV_B32_]], implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 4194304
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_OR_B32_e64_:%[0-9]+]]:vgpr_32 = V_OR_B32_e64 [[V_ADD_F32_e64_]], killed [[S_MOV_B32_1]], implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_CMP_U_F32_e64_:%[0-9]+]]:sreg_32_xm0_xexec = nofpexcept V_CMP_U_F32_e64 0, [[V_ADD_F32_e64_]], 0, [[V_ADD_F32_e64_]], 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_CNDMASK_B32_e64_:%[0-9]+]]:vgpr_32 = V_CNDMASK_B32_e64 0, killed [[V_ADD3_U32_e64_]], 0, killed [[V_OR_B32_e64_]], killed [[V_CMP_U_F32_e64_]], implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF32-NEXT:   FLAT_STORE_SHORT_D16_HI killed [[COPY2]], killed [[V_CNDMASK_B32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX10-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF64-LABEL: name: amdgpu_cs_chain_cc_bfloat
  ; DAGISEL-GFX10-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF64-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_LSHLREV_B32_e64_:%[0-9]+]]:vgpr_32 = V_LSHLREV_B32_e64 16, [[COPY]], implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[S_LSHL_B32_:%[0-9]+]]:sreg_32 = S_LSHL_B32 [[COPY1]], 16, implicit-def dead $scc
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_ADD_F32_e64_:%[0-9]+]]:vgpr_32 = nofpexcept V_ADD_F32_e64 0, killed [[S_LSHL_B32_]], 0, killed [[V_LSHLREV_B32_e64_]], 0, 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_BFE_U32_e64_:%[0-9]+]]:vgpr_32 = V_BFE_U32_e64 [[V_ADD_F32_e64_]], 16, 1, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[S_MOV_B32_:%[0-9]+]]:sreg_32 = S_MOV_B32 32767
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_ADD3_U32_e64_:%[0-9]+]]:vgpr_32 = V_ADD3_U32_e64 killed [[V_BFE_U32_e64_]], [[V_ADD_F32_e64_]], killed [[S_MOV_B32_]], implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[S_MOV_B32_1:%[0-9]+]]:sreg_32 = S_MOV_B32 4194304
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_OR_B32_e64_:%[0-9]+]]:vgpr_32 = V_OR_B32_e64 [[V_ADD_F32_e64_]], killed [[S_MOV_B32_1]], implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_CMP_U_F32_e64_:%[0-9]+]]:sreg_64_xexec = nofpexcept V_CMP_U_F32_e64 0, [[V_ADD_F32_e64_]], 0, [[V_ADD_F32_e64_]], 0, implicit $mode, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_CNDMASK_B32_e64_:%[0-9]+]]:vgpr_32 = V_CNDMASK_B32_e64 0, killed [[V_ADD3_U32_e64_]], 0, killed [[V_OR_B32_e64_]], killed [[V_CMP_U_F32_e64_]], implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF64-NEXT:   FLAT_STORE_SHORT_D16_HI killed [[COPY2]], killed [[V_CNDMASK_B32_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX10-WF64-NEXT:   S_ENDPGM 0
  %c = fadd bfloat %a, %b
  store bfloat %c, ptr poison
  ret void
}

define amdgpu_cs_chain_preserve void @amdgpu_cs_chain_preserve_cc_i16(i16 inreg %a, i16 %b) {
  ; GISEL-GFX11-TRUE16-LABEL: name: amdgpu_cs_chain_preserve_cc_i16
  ; GISEL-GFX11-TRUE16: bb.1 (%ir-block.0):
  ; GISEL-GFX11-TRUE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX11-TRUE16-NEXT: {{  $}}
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY2:%[0-9]+]]:vgpr_16 = COPY [[COPY1]].lo16
  ; GISEL-GFX11-TRUE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY3:%[0-9]+]]:vgpr_16 = COPY [[COPY]]
  ; GISEL-GFX11-TRUE16-NEXT:   [[V_ADD_NC_U16_t16_e64_:%[0-9]+]]:vgpr_16 = V_ADD_NC_U16_t16_e64 0, [[COPY3]], 0, [[COPY2]], 0, 0, implicit $exec
  ; GISEL-GFX11-TRUE16-NEXT:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-TRUE16-NEXT:   FLAT_STORE_SHORT_t16 [[COPY4]], [[V_ADD_NC_U16_t16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; GISEL-GFX11-TRUE16-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX11-FAKE16-LABEL: name: amdgpu_cs_chain_preserve_cc_i16
  ; GISEL-GFX11-FAKE16: bb.1 (%ir-block.0):
  ; GISEL-GFX11-FAKE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX11-FAKE16-NEXT: {{  $}}
  ; GISEL-GFX11-FAKE16-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-FAKE16-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-FAKE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX11-FAKE16-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX11-FAKE16-NEXT:   [[V_ADD_NC_U16_fake16_e64_:%[0-9]+]]:vgpr_32 = V_ADD_NC_U16_fake16_e64 0, [[COPY2]], 0, [[COPY1]], 0, 0, implicit $exec
  ; GISEL-GFX11-FAKE16-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-FAKE16-NEXT:   FLAT_STORE_SHORT [[COPY3]], [[V_ADD_NC_U16_fake16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; GISEL-GFX11-FAKE16-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_preserve_cc_i16
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $vgpr8
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   [[V_ADD_NC_U16_e64_:%[0-9]+]]:vgpr_32 = V_ADD_NC_U16_e64 0, [[COPY2]], 0, [[COPY1]], 0, 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   FLAT_STORE_SHORT [[COPY3]], [[V_ADD_NC_U16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-TRUE16-LABEL: name: amdgpu_cs_chain_preserve_cc_i16
  ; DAGISEL-GFX11-WF32-TRUE16: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[COPY2:%[0-9]+]]:vgpr_16 = COPY [[COPY]]
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[V_ADD_NC_U16_t16_e64_:%[0-9]+]]:vgpr_16 = V_ADD_NC_U16_t16_e64 0, [[COPY1]], 0, [[COPY2]], 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   FLAT_STORE_SHORT_t16 killed [[COPY3]], killed [[V_ADD_NC_U16_t16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF32-TRUE16-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-FAKE16-LABEL: name: amdgpu_cs_chain_preserve_cc_i16
  ; DAGISEL-GFX11-WF32-FAKE16: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[V_ADD_NC_U16_fake16_e64_:%[0-9]+]]:vgpr_32 = V_ADD_NC_U16_fake16_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   FLAT_STORE_SHORT killed [[COPY2]], killed [[V_ADD_NC_U16_fake16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF32-FAKE16-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-TRUE16-LABEL: name: amdgpu_cs_chain_preserve_cc_i16
  ; DAGISEL-GFX11-WF64-TRUE16: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[COPY2:%[0-9]+]]:vgpr_16 = COPY [[COPY]]
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[V_ADD_NC_U16_t16_e64_:%[0-9]+]]:vgpr_16 = V_ADD_NC_U16_t16_e64 0, [[COPY1]], 0, [[COPY2]], 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   FLAT_STORE_SHORT_t16 killed [[COPY3]], killed [[V_ADD_NC_U16_t16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF64-TRUE16-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-FAKE16-LABEL: name: amdgpu_cs_chain_preserve_cc_i16
  ; DAGISEL-GFX11-WF64-FAKE16: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[V_ADD_NC_U16_fake16_e64_:%[0-9]+]]:vgpr_32 = V_ADD_NC_U16_fake16_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   FLAT_STORE_SHORT killed [[COPY2]], killed [[V_ADD_NC_U16_fake16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX11-WF64-FAKE16-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_i16
  ; DAGISEL-GFX10-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF32-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_ADD_NC_U16_e64_:%[0-9]+]]:vgpr_32 = V_ADD_NC_U16_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF32-NEXT:   FLAT_STORE_SHORT killed [[COPY2]], killed [[V_ADD_NC_U16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX10-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_i16
  ; DAGISEL-GFX10-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF64-NEXT:   liveins: $sgpr0, $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY1:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_ADD_NC_U16_e64_:%[0-9]+]]:vgpr_32 = V_ADD_NC_U16_e64 0, [[COPY1]], 0, [[COPY]], 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY2:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF64-NEXT:   FLAT_STORE_SHORT killed [[COPY2]], killed [[V_ADD_NC_U16_e64_]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s16) into `ptr poison`)
  ; DAGISEL-GFX10-WF64-NEXT:   S_ENDPGM 0
  %c = add i16 %a, %b
  store i16 %c, ptr poison
  ret void
}

define amdgpu_cs_chain_preserve void @amdgpu_cs_chain_preserve_cc_v16i16(<16 x i16> inreg %a, <16 x i16> %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_preserve_cc_v16i16
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX11-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX11-NEXT:   [[COPY7:%[0-9]+]]:sreg_32 = COPY $sgpr7
  ; GISEL-GFX11-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX11-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX11-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX11-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX11-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX11-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX11-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; GISEL-GFX11-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX11-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   [[V_PK_ADD_U16_:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY16]], 8, [[COPY8]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY1]]
  ; GISEL-GFX11-NEXT:   [[V_PK_ADD_U16_1:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY17]], 8, [[COPY9]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; GISEL-GFX11-NEXT:   [[V_PK_ADD_U16_2:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY18]], 8, [[COPY10]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; GISEL-GFX11-NEXT:   [[V_PK_ADD_U16_3:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY19]], 8, [[COPY11]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[COPY4]]
  ; GISEL-GFX11-NEXT:   [[V_PK_ADD_U16_4:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY20]], 8, [[COPY12]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY21:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GISEL-GFX11-NEXT:   [[V_PK_ADD_U16_5:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY21]], 8, [[COPY13]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GISEL-GFX11-NEXT:   [[V_PK_ADD_U16_6:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY22]], 8, [[COPY14]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[COPY23:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GISEL-GFX11-NEXT:   [[V_PK_ADD_U16_7:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY23]], 8, [[COPY15]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[V_PK_ADD_U16_]], %subreg.sub0, [[V_PK_ADD_U16_1]], %subreg.sub1, [[V_PK_ADD_U16_2]], %subreg.sub2, [[V_PK_ADD_U16_3]], %subreg.sub3, [[V_PK_ADD_U16_4]], %subreg.sub4, [[V_PK_ADD_U16_5]], %subreg.sub5, [[V_PK_ADD_U16_6]], %subreg.sub6, [[V_PK_ADD_U16_7]], %subreg.sub7
  ; GISEL-GFX11-NEXT:   [[COPY24:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]].sub0_sub1_sub2_sub3
  ; GISEL-GFX11-NEXT:   [[COPY25:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]].sub4_sub5_sub6_sub7
  ; GISEL-GFX11-NEXT:   [[COPY26:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   FLAT_STORE_DWORDX4 [[COPY26]], [[COPY24]], 0, 0, implicit $exec, implicit $flat_scr :: (store (<4 x s32>) into `ptr poison`, align 32)
  ; GISEL-GFX11-NEXT:   [[COPY27:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   FLAT_STORE_DWORDX4 [[COPY27]], [[COPY25]], 16, 0, implicit $exec, implicit $flat_scr :: (store (<4 x s32>) into `ptr poison` + 16, basealign 32)
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_preserve_cc_v16i16
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr0
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:sreg_32 = COPY $sgpr1
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:sreg_32 = COPY $sgpr2
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:sreg_32 = COPY $sgpr3
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:sreg_32 = COPY $sgpr4
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:sreg_32 = COPY $sgpr5
  ; GISEL-GFX10-NEXT:   [[COPY6:%[0-9]+]]:sreg_32 = COPY $sgpr6
  ; GISEL-GFX10-NEXT:   [[COPY7:%[0-9]+]]:sreg_32 = COPY $sgpr7
  ; GISEL-GFX10-NEXT:   [[COPY8:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY9:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; GISEL-GFX10-NEXT:   [[COPY10:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; GISEL-GFX10-NEXT:   [[COPY11:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; GISEL-GFX10-NEXT:   [[COPY12:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; GISEL-GFX10-NEXT:   [[COPY13:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; GISEL-GFX10-NEXT:   [[COPY14:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; GISEL-GFX10-NEXT:   [[COPY15:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; GISEL-GFX10-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX10-NEXT:   [[COPY16:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   [[V_PK_ADD_U16_:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY16]], 8, [[COPY8]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY17:%[0-9]+]]:vgpr_32 = COPY [[COPY1]]
  ; GISEL-GFX10-NEXT:   [[V_PK_ADD_U16_1:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY17]], 8, [[COPY9]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY18:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; GISEL-GFX10-NEXT:   [[V_PK_ADD_U16_2:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY18]], 8, [[COPY10]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY19:%[0-9]+]]:vgpr_32 = COPY [[COPY3]]
  ; GISEL-GFX10-NEXT:   [[V_PK_ADD_U16_3:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY19]], 8, [[COPY11]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY20:%[0-9]+]]:vgpr_32 = COPY [[COPY4]]
  ; GISEL-GFX10-NEXT:   [[V_PK_ADD_U16_4:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY20]], 8, [[COPY12]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY21:%[0-9]+]]:vgpr_32 = COPY [[COPY5]]
  ; GISEL-GFX10-NEXT:   [[V_PK_ADD_U16_5:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY21]], 8, [[COPY13]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY22:%[0-9]+]]:vgpr_32 = COPY [[COPY6]]
  ; GISEL-GFX10-NEXT:   [[V_PK_ADD_U16_6:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY22]], 8, [[COPY14]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[COPY23:%[0-9]+]]:vgpr_32 = COPY [[COPY7]]
  ; GISEL-GFX10-NEXT:   [[V_PK_ADD_U16_7:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY23]], 8, [[COPY15]], 0, 0, 0, 0, 0, implicit $exec
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_256 = REG_SEQUENCE [[V_PK_ADD_U16_]], %subreg.sub0, [[V_PK_ADD_U16_1]], %subreg.sub1, [[V_PK_ADD_U16_2]], %subreg.sub2, [[V_PK_ADD_U16_3]], %subreg.sub3, [[V_PK_ADD_U16_4]], %subreg.sub4, [[V_PK_ADD_U16_5]], %subreg.sub5, [[V_PK_ADD_U16_6]], %subreg.sub6, [[V_PK_ADD_U16_7]], %subreg.sub7
  ; GISEL-GFX10-NEXT:   [[COPY24:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]].sub0_sub1_sub2_sub3
  ; GISEL-GFX10-NEXT:   [[COPY25:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]].sub4_sub5_sub6_sub7
  ; GISEL-GFX10-NEXT:   [[COPY26:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   FLAT_STORE_DWORDX4 [[COPY26]], [[COPY24]], 0, 0, implicit $exec, implicit $flat_scr :: (store (<4 x s32>) into `ptr poison`, align 32)
  ; GISEL-GFX10-NEXT:   [[COPY27:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   FLAT_STORE_DWORDX4 [[COPY27]], [[COPY25]], 16, 0, implicit $exec, implicit $flat_scr :: (store (<4 x s32>) into `ptr poison` + 16, basealign 32)
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_v16i16
  ; DAGISEL-GFX11-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; DAGISEL-GFX11-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr7
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY14:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY15:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_PK_ADD_U16_:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY12]], 8, [[COPY4]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_PK_ADD_U16_1:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY13]], 8, [[COPY5]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_PK_ADD_U16_2:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY14]], 8, [[COPY6]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_PK_ADD_U16_3:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY15]], 8, [[COPY7]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_PK_ADD_U16_4:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY8]], 8, [[COPY]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_PK_ADD_U16_5:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY9]], 8, [[COPY1]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_PK_ADD_U16_6:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY10]], 8, [[COPY2]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[V_PK_ADD_U16_7:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY11]], 8, [[COPY3]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_PK_ADD_U16_7]], %subreg.sub0, [[V_PK_ADD_U16_6]], %subreg.sub1, [[V_PK_ADD_U16_5]], %subreg.sub2, [[V_PK_ADD_U16_4]], %subreg.sub3
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF4:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY16:%[0-9]+]]:vreg_64 = COPY [[DEF4]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY17:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX11-WF32-NEXT:   FLAT_STORE_DWORDX4 [[COPY16]], killed [[COPY17]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison` + 16)
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF5:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF6:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF7:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF8:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_PK_ADD_U16_3]], %subreg.sub0, [[V_PK_ADD_U16_2]], %subreg.sub1, [[V_PK_ADD_U16_1]], %subreg.sub2, [[V_PK_ADD_U16_]], %subreg.sub3
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF9:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY18:%[0-9]+]]:vreg_64 = COPY [[DEF9]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY19:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE1]]
  ; DAGISEL-GFX11-WF32-NEXT:   FLAT_STORE_DWORDX4 [[COPY18]], killed [[COPY19]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison`, align 32)
  ; DAGISEL-GFX11-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_v16i16
  ; DAGISEL-GFX11-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; DAGISEL-GFX11-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr7
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY14:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY15:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_PK_ADD_U16_:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY12]], 8, [[COPY4]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_PK_ADD_U16_1:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY13]], 8, [[COPY5]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_PK_ADD_U16_2:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY14]], 8, [[COPY6]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_PK_ADD_U16_3:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY15]], 8, [[COPY7]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_PK_ADD_U16_4:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY8]], 8, [[COPY]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_PK_ADD_U16_5:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY9]], 8, [[COPY1]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_PK_ADD_U16_6:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY10]], 8, [[COPY2]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[V_PK_ADD_U16_7:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY11]], 8, [[COPY3]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_PK_ADD_U16_7]], %subreg.sub0, [[V_PK_ADD_U16_6]], %subreg.sub1, [[V_PK_ADD_U16_5]], %subreg.sub2, [[V_PK_ADD_U16_4]], %subreg.sub3
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF4:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY16:%[0-9]+]]:vreg_64 = COPY [[DEF4]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY17:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX11-WF64-NEXT:   FLAT_STORE_DWORDX4 [[COPY16]], killed [[COPY17]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison` + 16)
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF5:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF6:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF7:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF8:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_PK_ADD_U16_3]], %subreg.sub0, [[V_PK_ADD_U16_2]], %subreg.sub1, [[V_PK_ADD_U16_1]], %subreg.sub2, [[V_PK_ADD_U16_]], %subreg.sub3
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF9:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY18:%[0-9]+]]:vreg_64 = COPY [[DEF9]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY19:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE1]]
  ; DAGISEL-GFX11-WF64-NEXT:   FLAT_STORE_DWORDX4 [[COPY18]], killed [[COPY19]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison`, align 32)
  ; DAGISEL-GFX11-WF64-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF32-LABEL: name: amdgpu_cs_chain_preserve_cc_v16i16
  ; DAGISEL-GFX10-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF32-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; DAGISEL-GFX10-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr7
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY14:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY15:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_PK_ADD_U16_:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY12]], 8, [[COPY4]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_PK_ADD_U16_1:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY13]], 8, [[COPY5]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_PK_ADD_U16_2:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY14]], 8, [[COPY6]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_PK_ADD_U16_3:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY15]], 8, [[COPY7]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_PK_ADD_U16_4:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY8]], 8, [[COPY]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_PK_ADD_U16_5:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY9]], 8, [[COPY1]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_PK_ADD_U16_6:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY10]], 8, [[COPY2]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[V_PK_ADD_U16_7:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY11]], 8, [[COPY3]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_PK_ADD_U16_7]], %subreg.sub0, [[V_PK_ADD_U16_6]], %subreg.sub1, [[V_PK_ADD_U16_5]], %subreg.sub2, [[V_PK_ADD_U16_4]], %subreg.sub3
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF4:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY16:%[0-9]+]]:vreg_64 = COPY [[DEF4]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY17:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX10-WF32-NEXT:   FLAT_STORE_DWORDX4 [[COPY16]], killed [[COPY17]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison` + 16)
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF5:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF6:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF7:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF8:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_PK_ADD_U16_3]], %subreg.sub0, [[V_PK_ADD_U16_2]], %subreg.sub1, [[V_PK_ADD_U16_1]], %subreg.sub2, [[V_PK_ADD_U16_]], %subreg.sub3
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF9:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY18:%[0-9]+]]:vreg_64 = COPY [[DEF9]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY19:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE1]]
  ; DAGISEL-GFX10-WF32-NEXT:   FLAT_STORE_DWORDX4 [[COPY18]], killed [[COPY19]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison`, align 32)
  ; DAGISEL-GFX10-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF64-LABEL: name: amdgpu_cs_chain_preserve_cc_v16i16
  ; DAGISEL-GFX10-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF64-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15
  ; DAGISEL-GFX10-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr15
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr14
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr13
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY $vgpr12
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY $vgpr11
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY5:%[0-9]+]]:vgpr_32 = COPY $vgpr10
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY6:%[0-9]+]]:vgpr_32 = COPY $vgpr9
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY7:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY8:%[0-9]+]]:sgpr_32 = COPY $sgpr7
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY9:%[0-9]+]]:sgpr_32 = COPY $sgpr6
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY10:%[0-9]+]]:sgpr_32 = COPY $sgpr5
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY11:%[0-9]+]]:sgpr_32 = COPY $sgpr4
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY12:%[0-9]+]]:sgpr_32 = COPY $sgpr3
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY13:%[0-9]+]]:sgpr_32 = COPY $sgpr2
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY14:%[0-9]+]]:sgpr_32 = COPY $sgpr1
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY15:%[0-9]+]]:sgpr_32 = COPY $sgpr0
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_PK_ADD_U16_:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY12]], 8, [[COPY4]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_PK_ADD_U16_1:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY13]], 8, [[COPY5]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_PK_ADD_U16_2:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY14]], 8, [[COPY6]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_PK_ADD_U16_3:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY15]], 8, [[COPY7]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_PK_ADD_U16_4:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY8]], 8, [[COPY]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_PK_ADD_U16_5:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY9]], 8, [[COPY1]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_PK_ADD_U16_6:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY10]], 8, [[COPY2]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[V_PK_ADD_U16_7:%[0-9]+]]:vgpr_32 = V_PK_ADD_U16 8, [[COPY11]], 8, [[COPY3]], 0, 0, 0, 0, 0, implicit $exec
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF3:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_PK_ADD_U16_7]], %subreg.sub0, [[V_PK_ADD_U16_6]], %subreg.sub1, [[V_PK_ADD_U16_5]], %subreg.sub2, [[V_PK_ADD_U16_4]], %subreg.sub3
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF4:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY16:%[0-9]+]]:vreg_64 = COPY [[DEF4]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY17:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX10-WF64-NEXT:   FLAT_STORE_DWORDX4 [[COPY16]], killed [[COPY17]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison` + 16)
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF5:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF6:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF7:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF8:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE1:%[0-9]+]]:vreg_128 = REG_SEQUENCE [[V_PK_ADD_U16_3]], %subreg.sub0, [[V_PK_ADD_U16_2]], %subreg.sub1, [[V_PK_ADD_U16_1]], %subreg.sub2, [[V_PK_ADD_U16_]], %subreg.sub3
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF9:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY18:%[0-9]+]]:vreg_64 = COPY [[DEF9]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY19:%[0-9]+]]:vreg_128 = COPY [[REG_SEQUENCE1]]
  ; DAGISEL-GFX10-WF64-NEXT:   FLAT_STORE_DWORDX4 [[COPY18]], killed [[COPY19]], 0, 0, implicit $exec, implicit $flat_scr :: (store (s128) into `ptr poison`, align 32)
  ; DAGISEL-GFX10-WF64-NEXT:   S_ENDPGM 0
  %c = add <16 x i16> %a, %b
  store <16 x i16> %c, ptr poison
  ret void
}

; Test that we can pass more than 32 SGPRs (but less than 48, so it works for GFX10).
; Also an arbitrary (large) number of VGPRS.
define amdgpu_cs_chain_preserve void @amdgpu_cs_chain_preserve_many_regs(<36 x i32> inreg %a, <128 x i32> %b) {
  ; GISEL-GFX11-LABEL: name: amdgpu_cs_chain_preserve_many_regs
  ; GISEL-GFX11: bb.1 (%ir-block.0):
  ; GISEL-GFX11-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $sgpr14, $sgpr15, $sgpr16, $sgpr17, $sgpr18, $sgpr19, $sgpr20, $sgpr21, $sgpr22, $sgpr23, $sgpr24, $sgpr25, $sgpr26, $sgpr27, $sgpr28, $sgpr29, $sgpr30, $sgpr31, $sgpr32, $sgpr33, $sgpr34, $sgpr35, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $vgpr32, $vgpr33, $vgpr34, $vgpr35, $vgpr36, $vgpr37, $vgpr38, $vgpr39, $vgpr40, $vgpr41, $vgpr42, $vgpr43, $vgpr44, $vgpr45, $vgpr46, $vgpr47, $vgpr48, $vgpr49, $vgpr50, $vgpr51, $vgpr52, $vgpr53, $vgpr54, $vgpr55, $vgpr56, $vgpr57, $vgpr58, $vgpr59, $vgpr60, $vgpr61, $vgpr62, $vgpr63, $vgpr64, $vgpr65, $vgpr66, $vgpr67, $vgpr68, $vgpr69, $vgpr70, $vgpr71, $vgpr72, $vgpr73, $vgpr74, $vgpr75, $vgpr76, $vgpr77, $vgpr78, $vgpr79, $vgpr80, $vgpr81, $vgpr82, $vgpr83, $vgpr84, $vgpr85, $vgpr86, $vgpr87, $vgpr88, $vgpr89, $vgpr90, $vgpr91, $vgpr92, $vgpr93, $vgpr94, $vgpr95, $vgpr96, $vgpr97, $vgpr98, $vgpr99, $vgpr100, $vgpr101, $vgpr102, $vgpr103, $vgpr104, $vgpr105, $vgpr106, $vgpr107, $vgpr108, $vgpr109, $vgpr110, $vgpr111, $vgpr112, $vgpr113, $vgpr114, $vgpr115, $vgpr116, $vgpr117, $vgpr118, $vgpr119, $vgpr120, $vgpr121, $vgpr122, $vgpr123, $vgpr124, $vgpr125, $vgpr126, $vgpr127, $vgpr128, $vgpr129, $vgpr130, $vgpr131, $vgpr132, $vgpr133, $vgpr134, $vgpr135
  ; GISEL-GFX11-NEXT: {{  $}}
  ; GISEL-GFX11-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr35
  ; GISEL-GFX11-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX11-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; GISEL-GFX11-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX11-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX11-NEXT:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   GLOBAL_STORE_DWORD [[COPY4]], [[COPY3]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX11-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY1]], %subreg.sub0, [[COPY2]], %subreg.sub1
  ; GISEL-GFX11-NEXT:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX11-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY5]], [[REG_SEQUENCE]], 0, 0, implicit $exec :: (store (<2 x s32>) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX11-NEXT:   S_ENDPGM 0
  ;
  ; GISEL-GFX10-LABEL: name: amdgpu_cs_chain_preserve_many_regs
  ; GISEL-GFX10: bb.1 (%ir-block.0):
  ; GISEL-GFX10-NEXT:   liveins: $sgpr0, $sgpr1, $sgpr2, $sgpr3, $sgpr4, $sgpr5, $sgpr6, $sgpr7, $sgpr8, $sgpr9, $sgpr10, $sgpr11, $sgpr12, $sgpr13, $sgpr14, $sgpr15, $sgpr16, $sgpr17, $sgpr18, $sgpr19, $sgpr20, $sgpr21, $sgpr22, $sgpr23, $sgpr24, $sgpr25, $sgpr26, $sgpr27, $sgpr28, $sgpr29, $sgpr30, $sgpr31, $sgpr32, $sgpr33, $sgpr34, $sgpr35, $vgpr8, $vgpr9, $vgpr10, $vgpr11, $vgpr12, $vgpr13, $vgpr14, $vgpr15, $vgpr16, $vgpr17, $vgpr18, $vgpr19, $vgpr20, $vgpr21, $vgpr22, $vgpr23, $vgpr24, $vgpr25, $vgpr26, $vgpr27, $vgpr28, $vgpr29, $vgpr30, $vgpr31, $vgpr32, $vgpr33, $vgpr34, $vgpr35, $vgpr36, $vgpr37, $vgpr38, $vgpr39, $vgpr40, $vgpr41, $vgpr42, $vgpr43, $vgpr44, $vgpr45, $vgpr46, $vgpr47, $vgpr48, $vgpr49, $vgpr50, $vgpr51, $vgpr52, $vgpr53, $vgpr54, $vgpr55, $vgpr56, $vgpr57, $vgpr58, $vgpr59, $vgpr60, $vgpr61, $vgpr62, $vgpr63, $vgpr64, $vgpr65, $vgpr66, $vgpr67, $vgpr68, $vgpr69, $vgpr70, $vgpr71, $vgpr72, $vgpr73, $vgpr74, $vgpr75, $vgpr76, $vgpr77, $vgpr78, $vgpr79, $vgpr80, $vgpr81, $vgpr82, $vgpr83, $vgpr84, $vgpr85, $vgpr86, $vgpr87, $vgpr88, $vgpr89, $vgpr90, $vgpr91, $vgpr92, $vgpr93, $vgpr94, $vgpr95, $vgpr96, $vgpr97, $vgpr98, $vgpr99, $vgpr100, $vgpr101, $vgpr102, $vgpr103, $vgpr104, $vgpr105, $vgpr106, $vgpr107, $vgpr108, $vgpr109, $vgpr110, $vgpr111, $vgpr112, $vgpr113, $vgpr114, $vgpr115, $vgpr116, $vgpr117, $vgpr118, $vgpr119, $vgpr120, $vgpr121, $vgpr122, $vgpr123, $vgpr124, $vgpr125, $vgpr126, $vgpr127, $vgpr128, $vgpr129, $vgpr130, $vgpr131, $vgpr132, $vgpr133, $vgpr134, $vgpr135
  ; GISEL-GFX10-NEXT: {{  $}}
  ; GISEL-GFX10-NEXT:   [[COPY:%[0-9]+]]:sreg_32 = COPY $sgpr35
  ; GISEL-GFX10-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; GISEL-GFX10-NEXT:   [[COPY2:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; GISEL-GFX10-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; GISEL-GFX10-NEXT:   [[COPY3:%[0-9]+]]:vgpr_32 = COPY [[COPY]]
  ; GISEL-GFX10-NEXT:   [[COPY4:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   GLOBAL_STORE_DWORD [[COPY4]], [[COPY3]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX10-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY1]], %subreg.sub0, [[COPY2]], %subreg.sub1
  ; GISEL-GFX10-NEXT:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; GISEL-GFX10-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY5]], [[REG_SEQUENCE]], 0, 0, implicit $exec :: (store (<2 x s32>) into `ptr addrspace(1) poison`, addrspace 1)
  ; GISEL-GFX10-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF32-LABEL: name: amdgpu_cs_chain_preserve_many_regs
  ; DAGISEL-GFX11-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF32-NEXT:   liveins: $sgpr35, $vgpr8, $vgpr135
  ; DAGISEL-GFX11-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr35
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; DAGISEL-GFX11-WF32-NEXT:   GLOBAL_STORE_DWORD [[COPY3]], [[COPY4]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY1]], %subreg.sub0, [[COPY]], %subreg.sub1
  ; DAGISEL-GFX11-WF32-NEXT:   [[DEF3:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[DEF3]]
  ; DAGISEL-GFX11-WF32-NEXT:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX11-WF32-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY5]], killed [[COPY6]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX11-WF64-LABEL: name: amdgpu_cs_chain_preserve_many_regs
  ; DAGISEL-GFX11-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX11-WF64-NEXT:   liveins: $sgpr35, $vgpr8, $vgpr135
  ; DAGISEL-GFX11-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr35
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; DAGISEL-GFX11-WF64-NEXT:   GLOBAL_STORE_DWORD [[COPY3]], [[COPY4]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY1]], %subreg.sub0, [[COPY]], %subreg.sub1
  ; DAGISEL-GFX11-WF64-NEXT:   [[DEF3:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[DEF3]]
  ; DAGISEL-GFX11-WF64-NEXT:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX11-WF64-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY5]], killed [[COPY6]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX11-WF64-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF32-LABEL: name: amdgpu_cs_chain_preserve_many_regs
  ; DAGISEL-GFX10-WF32: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF32-NEXT:   liveins: $sgpr35, $vgpr8, $vgpr135
  ; DAGISEL-GFX10-WF32-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr35
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; DAGISEL-GFX10-WF32-NEXT:   GLOBAL_STORE_DWORD [[COPY3]], [[COPY4]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY1]], %subreg.sub0, [[COPY]], %subreg.sub1
  ; DAGISEL-GFX10-WF32-NEXT:   [[DEF3:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[DEF3]]
  ; DAGISEL-GFX10-WF32-NEXT:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX10-WF32-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY5]], killed [[COPY6]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF32-NEXT:   S_ENDPGM 0
  ;
  ; DAGISEL-GFX10-WF64-LABEL: name: amdgpu_cs_chain_preserve_many_regs
  ; DAGISEL-GFX10-WF64: bb.0 (%ir-block.0):
  ; DAGISEL-GFX10-WF64-NEXT:   liveins: $sgpr35, $vgpr8, $vgpr135
  ; DAGISEL-GFX10-WF64-NEXT: {{  $}}
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY:%[0-9]+]]:vgpr_32 = COPY $vgpr135
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY1:%[0-9]+]]:vgpr_32 = COPY $vgpr8
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY2:%[0-9]+]]:sgpr_32 = COPY $sgpr35
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY3:%[0-9]+]]:vreg_64 = COPY [[DEF]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY4:%[0-9]+]]:vgpr_32 = COPY [[COPY2]]
  ; DAGISEL-GFX10-WF64-NEXT:   GLOBAL_STORE_DWORD [[COPY3]], [[COPY4]], 0, 0, implicit $exec :: (store (s32) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF1:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF2:%[0-9]+]]:sgpr_32 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[REG_SEQUENCE:%[0-9]+]]:vreg_64 = REG_SEQUENCE [[COPY1]], %subreg.sub0, [[COPY]], %subreg.sub1
  ; DAGISEL-GFX10-WF64-NEXT:   [[DEF3:%[0-9]+]]:sreg_64 = IMPLICIT_DEF
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY5:%[0-9]+]]:vreg_64 = COPY [[DEF3]]
  ; DAGISEL-GFX10-WF64-NEXT:   [[COPY6:%[0-9]+]]:vreg_64 = COPY [[REG_SEQUENCE]]
  ; DAGISEL-GFX10-WF64-NEXT:   GLOBAL_STORE_DWORDX2 [[COPY5]], killed [[COPY6]], 0, 0, implicit $exec :: (store (s64) into `ptr addrspace(1) poison`, addrspace 1)
  ; DAGISEL-GFX10-WF64-NEXT:   S_ENDPGM 0
  %c = extractelement <36 x i32> %a, i32 35
  store i32 %c, ptr addrspace(1) poison

  %d = shufflevector <128 x i32> %b, <128 x i32> zeroinitializer, <2 x i32> <i32 0, i32 127>
  store <2 x i32> %d, ptr addrspace(1) poison
  ret void
}

