; RUN: llc < %s -relocation-model=pic -mtriple=powerpc-unknown-linux-gnu -ppc-asm-full-reg-names | FileCheck %s -check-prefix=PIC
; RUN: llc < %s -relocation-model=static -mtriple=powerpc-unknown-linux-gnu -ppc-asm-full-reg-names | FileCheck %s -check-prefix=STATIC
; RUN: llc < %s -relocation-model=pic -mtriple=powerpc64-unknown-linux-gnu -ppc-asm-full-reg-names | FileCheck %s -check-prefix=PPC64

@nextaddr = global ptr null                       ; <ptr> [#uses=2]
@C.0.2070 = private constant [5 x ptr] [ptr blockaddress(@foo, %L1), ptr blockaddress(@foo, %L2), ptr blockaddress(@foo, %L3), ptr blockaddress(@foo, %L4), ptr blockaddress(@foo, %L5)] ; <ptr> [#uses=1]

define internal i32 @foo(i32 %i) nounwind {
; PIC-LABEL: foo:
; STATIC-LABEL: foo:
; PPC64-LABEL: foo:
entry:
  %0 = load ptr, ptr @nextaddr, align 4               ; <ptr> [#uses=2]
  %1 = icmp eq ptr %0, null                       ; <i1> [#uses=1]
  br i1 %1, label %bb3, label %bb2

bb2:                                              ; preds = %entry, %bb3
  %gotovar.4.0 = phi ptr [ %gotovar.4.0.pre, %bb3 ], [ %0, %entry ] ; <ptr> [#uses=1]
; PIC: mtctr
; PIC-NEXT: bctr
; PIC: li
; PIC: b .LBB
; PIC: li
; PIC: b .LBB
; PIC: li
; PIC: b .LBB
; PIC: li
; PIC: b .LBB
; STATIC: mtctr
; STATIC-NEXT: bctr
; STATIC: li
; STATIC: b .LBB
; STATIC: li
; STATIC: b .LBB
; STATIC: li
; STATIC: b .LBB
; STATIC: li
; STATIC: b .LBB
; PPC64: mtctr
; PPC64-NEXT: bctr
; PPC64: li
; PPC64: b .LBB
; PPC64: li
; PPC64: b .LBB
; PPC64: li
; PPC64: b .LBB
; PPC64: li
; PPC64: b .LBB
  indirectbr ptr %gotovar.4.0, [label %L5, label %L4, label %L3, label %L2, label %L1]

bb3:                                              ; preds = %entry
  %2 = getelementptr inbounds [5 x ptr], ptr @C.0.2070, i32 0, i32 %i ; <ptr> [#uses=1]
  %gotovar.4.0.pre = load ptr, ptr %2, align 4        ; <ptr> [#uses=1]
  br label %bb2

L5:                                               ; preds = %bb2
  br label %L4

L4:                                               ; preds = %L5, %bb2
  %res.0 = phi i32 [ 385, %L5 ], [ 35, %bb2 ]     ; <i32> [#uses=1]
  br label %L3

L3:                                               ; preds = %L4, %bb2
  %res.1 = phi i32 [ %res.0, %L4 ], [ 5, %bb2 ]   ; <i32> [#uses=1]
  br label %L2

L2:                                               ; preds = %L3, %bb2
  %res.2 = phi i32 [ %res.1, %L3 ], [ 1, %bb2 ]   ; <i32> [#uses=1]
  %phitmp = mul i32 %res.2, 6                     ; <i32> [#uses=1]
  br label %L1

L1:                                               ; preds = %L2, %bb2
  %res.3 = phi i32 [ %phitmp, %L2 ], [ 2, %bb2 ]  ; <i32> [#uses=1]
; PIC: lwz r[[R0:[0-9]+]], .LC0-.LTOC(r30)
; PIC-NEXT: lwz r[[R1:[0-9]+]], .LC2-.LTOC(r30)
; PIC-NEXT: stw r[[R1]], 0(r[[R0]])
; STATIC: li r[[R0:[0-9]+]], .Ltmp0@l
; STATIC-NEXT: lis r[[R1:[0-9]+]], nextaddr@ha
; STATIC-NEXT: addis r[[R0]], r[[R0]], .Ltmp0@ha
; STATIC-NEXT: stw r[[R0]], nextaddr@l(r[[R1]]
  store ptr blockaddress(@foo, %L5), ptr @nextaddr, align 4
  ret i32 %res.3
}
