; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv64 -mattr=+xmipscmov -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=RV64I-CCMOV %s

define i32 @bare_select(i1 %a, i32 %b, i32 %c) nounwind {
; RV32I-LABEL: bare_select:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a3, a0, 1
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    bnez a3, .LBB0_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:  .LBB0_2:
; RV32I-NEXT:    ret
;
; RV64I-CCMOV-LABEL: bare_select:
; RV64I-CCMOV:       # %bb.0:
; RV64I-CCMOV-NEXT:    andi a0, a0, 1
; RV64I-CCMOV-NEXT:    mips.ccmov a0, a0, a1, a2
; RV64I-CCMOV-NEXT:    ret
  %1 = select i1 %a, i32 %b, i32 %c
  ret i32 %1
}

define float @bare_select_float(i1 %a, float %b, float %c) nounwind {
; RV32I-LABEL: bare_select_float:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a3, a0, 1
; RV32I-NEXT:    mv a0, a1
; RV32I-NEXT:    bnez a3, .LBB1_2
; RV32I-NEXT:  # %bb.1:
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:  .LBB1_2:
; RV32I-NEXT:    ret
;
; RV64I-CCMOV-LABEL: bare_select_float:
; RV64I-CCMOV:       # %bb.0:
; RV64I-CCMOV-NEXT:    andi a0, a0, 1
; RV64I-CCMOV-NEXT:    mips.ccmov a0, a0, a1, a2
; RV64I-CCMOV-NEXT:    ret
  %1 = select i1 %a, float %b, float %c
  ret float %1
}
