/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.kotlin.dsl.execution.Interpreter;
import org.gradle.kotlin.dsl.execution.ProgramKind;
import org.gradle.kotlin.dsl.execution.ProgramTarget;
import org.gradle.kotlin.dsl.support.ScriptCompilationException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u001a&\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u001a \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u001a\u001f\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00140#H\u0082\b\u001a&\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%*\u00020\u000f2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H%0#H\u0082\b\u00a2\u0006\u0002\u0010'\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006("}, d2={"interpreterLogger", "Lorg/slf4j/Logger;", "getInterpreterLogger", "()Lorg/slf4j/Logger;", "classLoaderScopeIdFor", "", "scriptPath", "stage", "locationAwareExceptionFor", "Lorg/gradle/internal/exceptions/LocationAwareException;", "original", "", "scriptClass", "Ljava/lang/Class;", "scriptSource", "Lorg/gradle/groovy/scripts/ScriptSource;", "locationAwareExceptionHandlingFor", "", "e", "logClassLoadingOf", "", "templateId", "source", "logCompilationOf", "maybeUnwrapInvocationTargetException", "kotlin.jvm.PlatformType", "templateIdFor", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "withContextClassLoader", "classLoader", "Ljava/lang/ClassLoader;", "block", "Lkotlin/Function0;", "withLocationAwareExceptionHandling", "T", "action", "(Lorg/gradle/groovy/scripts/ScriptSource;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpreter.kt\norg/gradle/kotlin/dsl/execution/InterpreterKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\norg/gradle/kotlin/dsl/support/LoggerKt\n*L\n1#1,638:1\n1#2:639\n25#3:640\n*S KotlinDebug\n*F\n+ 1 Interpreter.kt\norg/gradle/kotlin/dsl/execution/InterpreterKt\n*L\n637#1:640\n*E\n"})
public final class InterpreterKt {
    @NotNull
    private static final Logger interpreterLogger;

    @VisibleForTesting
    @NotNull
    public static final String templateIdFor(@NotNull ProgramTarget programTarget, @NotNull ProgramKind programKind, @NotNull String stage) {
        Intrinsics.checkNotNullParameter((Object)((Object)programTarget), (String)"programTarget");
        Intrinsics.checkNotNullParameter((Object)((Object)programKind), (String)"programKind");
        Intrinsics.checkNotNullParameter((Object)stage, (String)"stage");
        return programTarget.name() + '/' + programKind.name() + '/' + stage;
    }

    private static final String classLoaderScopeIdFor(String scriptPath, String stage) {
        return "kotlin-dsl:" + scriptPath + ':' + stage;
    }

    private static final Void locationAwareExceptionHandlingFor(Throwable e, Class<?> scriptClass, ScriptSource scriptSource) {
        LocationAwareException locationAware;
        Throwable targetException = InterpreterKt.maybeUnwrapInvocationTargetException(e);
        Intrinsics.checkNotNullExpressionValue((Object)targetException, (String)"targetException");
        LocationAwareException locationAwareException = locationAware = InterpreterKt.locationAwareExceptionFor(targetException, scriptClass, scriptSource);
        throw locationAwareException != null ? (Throwable)locationAwareException : targetException;
    }

    private static final LocationAwareException locationAwareExceptionFor(Throwable original, Class<?> scriptClass, ScriptSource scriptSource) {
        String scriptClassName = scriptClass.getName();
        String scriptClassNameInnerPrefix = scriptClassName + '$';
        return InterpreterKt.locationAwareExceptionFor$inferLocationFrom(scriptClassName, scriptClassNameInnerPrefix, original, scriptSource, original);
    }

    private static final <T> T withLocationAwareExceptionHandling(ScriptSource $this$withLocationAwareExceptionHandling, Function0<? extends T> action) {
        Object object;
        boolean $i$f$withLocationAwareExceptionHandling = false;
        try {
            object = action.invoke();
        }
        catch (ScriptCompilationException e) {
            throw new LocationAwareException((Throwable)e, $this$withLocationAwareExceptionHandling, e.getFirstErrorLine());
        }
        return (T)object;
    }

    private static final Throwable maybeUnwrapInvocationTargetException(Throwable e) {
        return e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void withContextClassLoader(ClassLoader classLoader, Function0<Unit> block) {
        boolean $i$f$withContextClassLoader = false;
        Thread currentThread = Thread.currentThread();
        ClassLoader previous = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(classLoader);
            block.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            currentThread.setContextClassLoader(previous);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private static final void logCompilationOf(String templateId, ScriptSource source) {
        interpreterLogger.debug("Compiling " + templateId + " from " + source.getDisplayName());
    }

    private static final void logClassLoadingOf(String templateId, ScriptSource source) {
        interpreterLogger.debug("Loading " + templateId + " from " + source.getDisplayName());
    }

    @NotNull
    public static final Logger getInterpreterLogger() {
        return interpreterLogger;
    }

    private static final boolean locationAwareExceptionFor$scriptStackTraceElement(String scriptClassName, String scriptClassNameInnerPrefix, StackTraceElement element) {
        boolean bl;
        String string = element.getClassName();
        if (string != null) {
            String $this$locationAwareExceptionFor_u24scriptStackTraceElement_u24lambda_u240 = string;
            boolean bl2 = false;
            bl = $this$locationAwareExceptionFor_u24scriptStackTraceElement_u24lambda_u240.equals(scriptClassName) || StringsKt.startsWith$default((String)$this$locationAwareExceptionFor_u24scriptStackTraceElement_u24lambda_u240, (String)scriptClassNameInnerPrefix, (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final LocationAwareException locationAwareExceptionFor$inferLocationFrom(String scriptClassName, String scriptClassNameInnerPrefix, Throwable $original, ScriptSource $scriptSource, Throwable exception) {
        while (true) {
            Throwable cause;
            Object object;
            block5: {
                if (exception instanceof LocationAwareException) {
                    return (LocationAwareException)exception;
                }
                StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"exception.stackTrace");
                for (Object object2 : (Object[])stackTraceElementArray) {
                    StackTraceElement p0 = (StackTraceElement)object2;
                    boolean bl = false;
                    if (!InterpreterKt.locationAwareExceptionFor$scriptStackTraceElement(scriptClassName, scriptClassNameInnerPrefix, p0)) continue;
                    object = object2;
                    break block5;
                }
                object = null;
            }
            StackTraceElement stackTraceElement = (StackTraceElement)object;
            if (stackTraceElement != null) {
                void it;
                StackTraceElement $this$locationAwareExceptionFor_u24inferLocationFrom_u24lambda_u242 = stackTraceElement;
                boolean bl = false;
                Integer n = $this$locationAwareExceptionFor_u24inferLocationFrom_u24lambda_u242.getLineNumber();
                int n2 = ((Number)n).intValue();
                ScriptSource scriptSource = $scriptSource;
                Throwable throwable = $original;
                boolean bl2 = false;
                boolean bl3 = it >= 0;
                Integer n3 = bl3 ? n : null;
                ScriptSource scriptSource2 = scriptSource;
                Throwable throwable2 = throwable;
                return new LocationAwareException(throwable2, scriptSource2, n3);
            }
            if (exception.getCause() == null) {
                return null;
            }
            exception = cause;
        }
    }

    public static final /* synthetic */ void access$logClassLoadingOf(String templateId, ScriptSource source) {
        InterpreterKt.logClassLoadingOf(templateId, source);
    }

    public static final /* synthetic */ String access$classLoaderScopeIdFor(String scriptPath, String stage) {
        return InterpreterKt.classLoaderScopeIdFor(scriptPath, stage);
    }

    public static final /* synthetic */ Void access$locationAwareExceptionHandlingFor(Throwable e, Class scriptClass, ScriptSource scriptSource) {
        return InterpreterKt.locationAwareExceptionHandlingFor(e, scriptClass, scriptSource);
    }

    public static final /* synthetic */ void access$logCompilationOf(String templateId, ScriptSource source) {
        InterpreterKt.logCompilationOf(templateId, source);
    }

    static {
        boolean $i$f$loggerFor = false;
        Logger logger2 = LoggerFactory.getLogger(Interpreter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(T::class.java)");
        interpreterLogger = logger2;
    }
}

